# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: guardduty
using AWS.Compat
using AWS.UUIDs

"""
    accept_administrator_invitation(administrator_id, detector_id, invitation_id)
    accept_administrator_invitation(administrator_id, detector_id, invitation_id, params::Dict{String,<:Any})

Accepts the invitation to be a member account and get monitored by a GuardDuty
administrator account that sent the invitation.

# Arguments
- `administrator_id`: The account ID of the GuardDuty administrator account whose
  invitation you're accepting.
- `detector_id`: The unique ID of the detector of the GuardDuty member account.
- `invitation_id`: The value that is used to validate the administrator account to the
  member account.

"""
function accept_administrator_invitation(
    administratorId,
    detectorId,
    invitationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/administrator",
        Dict{String,Any}(
            "administratorId" => administratorId, "invitationId" => invitationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_administrator_invitation(
    administratorId,
    detectorId,
    invitationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/administrator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "administratorId" => administratorId, "invitationId" => invitationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_invitation(detector_id, invitation_id, master_id)
    accept_invitation(detector_id, invitation_id, master_id, params::Dict{String,<:Any})

Accepts the invitation to be monitored by a GuardDuty administrator account.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.
- `invitation_id`: The value that is used to validate the administrator account to the
  member account.
- `master_id`: The account ID of the GuardDuty administrator account whose invitation
  you're accepting.

"""
function accept_invitation(
    detectorId, invitationId, masterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/master",
        Dict{String,Any}("invitationId" => invitationId, "masterId" => masterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_invitation(
    detectorId,
    invitationId,
    masterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/master",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("invitationId" => invitationId, "masterId" => masterId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    archive_findings(detector_id, finding_ids)
    archive_findings(detector_id, finding_ids, params::Dict{String,<:Any})

Archives GuardDuty findings that are specified by the list of finding IDs.  Only the
administrator account can archive findings. Member accounts don't have permission to
archive findings from their accounts.

# Arguments
- `detector_id`: The ID of the detector that specifies the GuardDuty service whose findings
  you want to archive.
- `finding_ids`: The IDs of the findings that you want to archive.

"""
function archive_findings(
    detectorId, findingIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/archive",
        Dict{String,Any}("findingIds" => findingIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function archive_findings(
    detectorId,
    findingIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/archive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("findingIds" => findingIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_detector(enable)
    create_detector(enable, params::Dict{String,<:Any})

Creates a single GuardDuty detector. A detector is a resource that represents the GuardDuty
service. To start using GuardDuty, you must create a detector in each Region where you
enable the service. You can have only one detector per account per Region. All data sources
are enabled in a new detector by default.   When you don't specify any features, with an
exception to RUNTIME_MONITORING, all the optional features are enabled by default.   When
you specify some of the features, any feature that is not specified in the API call gets
enabled by default, with an exception to RUNTIME_MONITORING.    Specifying both EKS Runtime
Monitoring (EKS_RUNTIME_MONITORING) and Runtime Monitoring (RUNTIME_MONITORING) will cause
an error. You can add only one of these two features because Runtime Monitoring already
includes the threat detection for Amazon EKS resources. For more information, see Runtime
Monitoring. There might be regional differences because some data sources might not be
available in all the Amazon Web Services Regions where GuardDuty is presently supported.
For more information, see Regions and endpoints.

# Arguments
- `enable`: A Boolean value that specifies whether the detector is to be enabled.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token for the create request.
- `"dataSources"`: Describes which data sources will be enabled for the detector. There
  might be regional differences because some data sources might not be available in all the
  Amazon Web Services Regions where GuardDuty is presently supported. For more information,
  see Regions and endpoints.
- `"features"`: A list of features that will be configured for the detector.
- `"findingPublishingFrequency"`: A value that specifies how frequently updated findings
  are exported.
- `"tags"`: The tags to be added to a new detector resource.
"""
function create_detector(enable; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/detector",
        Dict{String,Any}("enable" => enable, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_detector(
    enable, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("enable" => enable, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_filter(detector_id, finding_criteria, name)
    create_filter(detector_id, finding_criteria, name, params::Dict{String,<:Any})

Creates a filter using the specified finding criteria. The maximum number of saved filters
per Amazon Web Services account per Region is 100. For more information, see Quotas for
GuardDuty.

# Arguments
- `detector_id`: The ID of the detector belonging to the GuardDuty account that you want to
  create a filter for.
- `finding_criteria`: Represents the criteria to be used in the filter for querying
  findings. You can only use the following attributes to query findings:   accountId   id
  region   severity To filter on the basis of severity, the API and CLI use the following
  input list for the FindingCriteria condition:    Low: [\"1\", \"2\", \"3\"]     Medium:
  [\"4\", \"5\", \"6\"]     High: [\"7\", \"8\", \"9\"]    For more information, see Severity
  levels for GuardDuty findings.   type   updatedAt Type: ISO 8601 string format:
  YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains
  milliseconds.   resource.accessKeyDetails.accessKeyId
  resource.accessKeyDetails.principalId   resource.accessKeyDetails.userName
  resource.accessKeyDetails.userType   resource.instanceDetails.iamInstanceProfile.id
  resource.instanceDetails.imageId   resource.instanceDetails.instanceId
  resource.instanceDetails.tags.key   resource.instanceDetails.tags.value
  resource.instanceDetails.networkInterfaces.ipv6Addresses
  resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
  resource.instanceDetails.networkInterfaces.publicDnsName
  resource.instanceDetails.networkInterfaces.publicIp
  resource.instanceDetails.networkInterfaces.securityGroups.groupId
  resource.instanceDetails.networkInterfaces.securityGroups.groupName
  resource.instanceDetails.networkInterfaces.subnetId
  resource.instanceDetails.networkInterfaces.vpcId   resource.instanceDetails.outpostArn
  resource.resourceType   resource.s3BucketDetails.publicAccess.effectivePermissions
  resource.s3BucketDetails.name   resource.s3BucketDetails.tags.key
  resource.s3BucketDetails.tags.value   resource.s3BucketDetails.type
  service.action.actionType   service.action.awsApiCallAction.api
  service.action.awsApiCallAction.callerType   service.action.awsApiCallAction.errorCode
  service.action.awsApiCallAction.remoteIpDetails.city.cityName
  service.action.awsApiCallAction.remoteIpDetails.country.countryName
  service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
  service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
  service.action.awsApiCallAction.remoteIpDetails.organization.asn
  service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
  service.action.awsApiCallAction.serviceName   service.action.dnsRequestAction.domain
  service.action.dnsRequestAction.domainWithSuffix
  service.action.networkConnectionAction.blocked
  service.action.networkConnectionAction.connectionDirection
  service.action.networkConnectionAction.localPortDetails.port
  service.action.networkConnectionAction.protocol
  service.action.networkConnectionAction.remoteIpDetails.city.cityName
  service.action.networkConnectionAction.remoteIpDetails.country.countryName
  service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
  service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
  service.action.networkConnectionAction.remoteIpDetails.organization.asn
  service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
  service.action.networkConnectionAction.remotePortDetails.port
  service.action.awsApiCallAction.remoteAccountDetails.affiliated
  service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
  service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
  service.action.kubernetesApiCallAction.namespace
  service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
  service.action.kubernetesApiCallAction.requestUri
  service.action.kubernetesApiCallAction.statusCode
  service.action.networkConnectionAction.localIpDetails.ipAddressV4
  service.action.networkConnectionAction.localIpDetails.ipAddressV6
  service.action.networkConnectionAction.protocol
  service.action.awsApiCallAction.serviceName
  service.action.awsApiCallAction.remoteAccountDetails.accountId
  service.additionalInfo.threatListName   service.resourceRole
  resource.eksClusterDetails.name   resource.kubernetesDetails.kubernetesWorkloadDetails.name
    resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
  resource.kubernetesDetails.kubernetesUserDetails.username
  resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
  resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
  service.ebsVolumeScanDetails.scanId
  service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
  service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
  service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
    resource.ecsClusterDetails.name   resource.ecsClusterDetails.taskDetails.containers.image
    resource.ecsClusterDetails.taskDetails.definitionArn   resource.containerDetails.image
  resource.rdsDbInstanceDetails.dbInstanceIdentifier
  resource.rdsDbInstanceDetails.dbClusterIdentifier   resource.rdsDbInstanceDetails.engine
  resource.rdsDbUserDetails.user   resource.rdsDbInstanceDetails.tags.key
  resource.rdsDbInstanceDetails.tags.value   service.runtimeDetails.process.executableSha256
   service.runtimeDetails.process.name   service.runtimeDetails.process.name
  resource.lambdaDetails.functionName   resource.lambdaDetails.functionArn
  resource.lambdaDetails.tags.key   resource.lambdaDetails.tags.value
- `name`: The name of the filter. Valid characters include period (.), underscore (_), dash
  (-), and alphanumeric characters. A whitespace is considered to be an invalid character.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"action"`: Specifies the action that is to be applied to the findings that match the
  filter.
- `"clientToken"`: The idempotency token for the create request.
- `"description"`: The description of the filter. Valid characters include alphanumeric
  characters, and special characters such as hyphen, period, colon, underscore, parentheses
  ({ }, [ ], and ( )), forward slash, horizontal tab, vertical tab, newline, form feed,
  return, and whitespace.
- `"rank"`: Specifies the position of the filter in the list of current filters. Also
  specifies the order in which this filter is applied to the findings.
- `"tags"`: The tags to be added to a new filter resource.
"""
function create_filter(
    detectorId, findingCriteria, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/filter",
        Dict{String,Any}(
            "findingCriteria" => findingCriteria,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_filter(
    detectorId,
    findingCriteria,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/filter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "findingCriteria" => findingCriteria,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipset(activate, detector_id, format, location, name)
    create_ipset(activate, detector_id, format, location, name, params::Dict{String,<:Any})

Creates a new IPSet, which is called a trusted IP list in the console user interface. An
IPSet is a list of IP addresses that are trusted for secure communication with Amazon Web
Services infrastructure and applications. GuardDuty doesn't generate findings for IP
addresses that are included in IPSets. Only users from the administrator account can use
this operation.

# Arguments
- `activate`: A Boolean value that indicates whether GuardDuty is to start using the
  uploaded IPSet.
- `detector_id`: The unique ID of the detector of the GuardDuty account that you want to
  create an IPSet for.
- `format`: The format of the file that contains the IPSet.
- `location`: The URI of the file that contains the IPSet.
- `name`: The user-friendly name to identify the IPSet.  Allowed characters are
  alphanumeric, whitespace, dash (-), and underscores (_).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token for the create request.
- `"tags"`: The tags to be added to a new IP set resource.
"""
function create_ipset(
    activate,
    detectorId,
    format,
    location,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/ipset",
        Dict{String,Any}(
            "activate" => activate,
            "format" => format,
            "location" => location,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipset(
    activate,
    detectorId,
    format,
    location,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/ipset",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "activate" => activate,
                    "format" => format,
                    "location" => location,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_malware_protection_plan(protected_resource, role)
    create_malware_protection_plan(protected_resource, role, params::Dict{String,<:Any})

Creates a new Malware Protection plan for the protected resource. When you create a Malware
Protection plan, the Amazon Web Services service terms for GuardDuty Malware Protection
apply. For more information, see Amazon Web Services service terms for GuardDuty Malware
Protection.

# Arguments
- `protected_resource`: Information about the protected resource that is associated with
  the created Malware Protection plan. Presently, S3Bucket is the only supported protected
  resource.
- `role`: IAM role with permissions required to scan and add tags to the associated
  protected resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actions"`: Information about whether the tags will be added to the S3 object after
  scanning.
- `"clientToken"`: The idempotency token for the create request.
- `"tags"`: Tags added to the Malware Protection plan resource.
"""
function create_malware_protection_plan(
    protectedResource, role; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/malware-protection-plan",
        Dict{String,Any}(
            "protectedResource" => protectedResource,
            "role" => role,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_malware_protection_plan(
    protectedResource,
    role,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/malware-protection-plan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "protectedResource" => protectedResource,
                    "role" => role,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_members(account_details, detector_id)
    create_members(account_details, detector_id, params::Dict{String,<:Any})

Creates member accounts of the current Amazon Web Services account by specifying a list of
Amazon Web Services account IDs. This step is a prerequisite for managing the associated
member accounts either by invitation or through an organization. As a delegated
administrator, using CreateMembers will enable GuardDuty in the added member accounts, with
the exception of the organization delegated administrator account. A delegated
administrator must enable GuardDuty prior to being added as a member. When you use
CreateMembers as an Organizations delegated administrator, GuardDuty applies your
organization's auto-enable settings to the member accounts in this request, irrespective of
the accounts being new or existing members. For more information about the existing
auto-enable settings for your organization, see DescribeOrganizationConfiguration. If you
disassociate a member account that was added by invitation, the member account details
obtained from this API, including the associated email addresses, will be retained. This is
done so that the delegated administrator can invoke the InviteMembers API without the need
to invoke the CreateMembers API again. To remove the details associated with a member
account, the delegated administrator must invoke the DeleteMembers API.  When the member
accounts added through Organizations are later disassociated, you (administrator) can't
invite them by calling the InviteMembers API. You can create an association with these
member accounts again only by calling the CreateMembers API.

# Arguments
- `account_details`: A list of account ID and email address pairs of the accounts that you
  want to associate with the GuardDuty administrator account.
- `detector_id`: The unique ID of the detector of the GuardDuty account that you want to
  associate member accounts with.

"""
function create_members(
    accountDetails, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member",
        Dict{String,Any}("accountDetails" => accountDetails);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_members(
    accountDetails,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountDetails" => accountDetails), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_publishing_destination(destination_properties, destination_type, detector_id)
    create_publishing_destination(destination_properties, destination_type, detector_id, params::Dict{String,<:Any})

Creates a publishing destination to export findings to. The resource to export findings to
must exist before you use this operation.

# Arguments
- `destination_properties`: The properties of the publishing destination, including the
  ARNs for the destination and the KMS key used for encryption.
- `destination_type`: The type of resource for the publishing destination. Currently only
  Amazon S3 buckets are supported.
- `detector_id`: The ID of the GuardDuty detector associated with the publishing
  destination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token for the request.
"""
function create_publishing_destination(
    destinationProperties,
    destinationType,
    detectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/publishingDestination",
        Dict{String,Any}(
            "destinationProperties" => destinationProperties,
            "destinationType" => destinationType,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_publishing_destination(
    destinationProperties,
    destinationType,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/publishingDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationProperties" => destinationProperties,
                    "destinationType" => destinationType,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sample_findings(detector_id)
    create_sample_findings(detector_id, params::Dict{String,<:Any})

Generates sample findings of types specified by the list of finding types. If 'NULL' is
specified for findingTypes, the API generates sample findings of all supported finding
types.

# Arguments
- `detector_id`: The ID of the detector to create sample findings for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"findingTypes"`: The types of sample findings to generate.
"""
function create_sample_findings(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/create";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sample_findings(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/create",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_threat_intel_set(activate, detector_id, format, location, name)
    create_threat_intel_set(activate, detector_id, format, location, name, params::Dict{String,<:Any})

Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses.
GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator
account can use this operation.

# Arguments
- `activate`: A Boolean value that indicates whether GuardDuty is to start using the
  uploaded ThreatIntelSet.
- `detector_id`: The unique ID of the detector of the GuardDuty account that you want to
  create a threatIntelSet for.
- `format`: The format of the file that contains the ThreatIntelSet.
- `location`: The URI of the file that contains the ThreatIntelSet.
- `name`: A user-friendly ThreatIntelSet name displayed in all findings that are generated
  by activity that involves IP addresses included in this ThreatIntelSet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token for the create request.
- `"tags"`: The tags to be added to a new threat list resource.
"""
function create_threat_intel_set(
    activate,
    detectorId,
    format,
    location,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/threatintelset",
        Dict{String,Any}(
            "activate" => activate,
            "format" => format,
            "location" => location,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_threat_intel_set(
    activate,
    detectorId,
    format,
    location,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/threatintelset",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "activate" => activate,
                    "format" => format,
                    "location" => location,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    decline_invitations(account_ids)
    decline_invitations(account_ids, params::Dict{String,<:Any})

Declines invitations sent to the current member account by Amazon Web Services accounts
specified by their account IDs.

# Arguments
- `account_ids`: A list of account IDs of the Amazon Web Services accounts that sent
  invitations to the current member account that you want to decline invitations from.

"""
function decline_invitations(accountIds; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/invitation/decline",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function decline_invitations(
    accountIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/invitation/decline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_detector(detector_id)
    delete_detector(detector_id, params::Dict{String,<:Any})

Deletes an Amazon GuardDuty detector that is specified by the detector ID.

# Arguments
- `detector_id`: The unique ID of the detector that you want to delete.

"""
function delete_detector(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_detector(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_filter(detector_id, filter_name)
    delete_filter(detector_id, filter_name, params::Dict{String,<:Any})

Deletes the filter specified by the filter name.

# Arguments
- `detector_id`: The unique ID of the detector that the filter is associated with.
- `filter_name`: The name of the filter that you want to delete.

"""
function delete_filter(
    detectorId, filterName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/filter/$(filterName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_filter(
    detectorId,
    filterName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/filter/$(filterName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_invitations(account_ids)
    delete_invitations(account_ids, params::Dict{String,<:Any})

Deletes invitations sent to the current member account by Amazon Web Services accounts
specified by their account IDs.

# Arguments
- `account_ids`: A list of account IDs of the Amazon Web Services accounts that sent
  invitations to the current member account that you want to delete invitations from.

"""
function delete_invitations(accountIds; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/invitation/delete",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_invitations(
    accountIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/invitation/delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipset(detector_id, ip_set_id)
    delete_ipset(detector_id, ip_set_id, params::Dict{String,<:Any})

Deletes the IPSet specified by the ipSetId. IPSets are called trusted IP lists in the
console user interface.

# Arguments
- `detector_id`: The unique ID of the detector associated with the IPSet.
- `ip_set_id`: The unique ID of the IPSet to delete.

"""
function delete_ipset(
    detectorId, ipSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/ipset/$(ipSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipset(
    detectorId,
    ipSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/ipset/$(ipSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_malware_protection_plan(malware_protection_plan_id)
    delete_malware_protection_plan(malware_protection_plan_id, params::Dict{String,<:Any})

Deletes the Malware Protection plan ID associated with the Malware Protection plan
resource. Use this API only when you no longer want to protect the resource associated with
this Malware Protection plan ID.

# Arguments
- `malware_protection_plan_id`: A unique identifier associated with Malware Protection plan
  resource.

"""
function delete_malware_protection_plan(
    malwareProtectionPlanId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/malware-protection-plan/$(malwareProtectionPlanId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_malware_protection_plan(
    malwareProtectionPlanId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/malware-protection-plan/$(malwareProtectionPlanId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_members(account_ids, detector_id)
    delete_members(account_ids, detector_id, params::Dict{String,<:Any})

Deletes GuardDuty member accounts (to the current GuardDuty administrator account)
specified by the account IDs. With autoEnableOrganizationMembers configuration for your
organization set to ALL, you'll receive an error if you attempt to disable GuardDuty for a
member account in your organization.

# Arguments
- `account_ids`: A list of account IDs of the GuardDuty member accounts that you want to
  delete.
- `detector_id`: The unique ID of the detector of the GuardDuty account whose members you
  want to delete.

"""
function delete_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/delete",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_publishing_destination(destination_id, detector_id)
    delete_publishing_destination(destination_id, detector_id, params::Dict{String,<:Any})

Deletes the publishing definition with the specified destinationId.

# Arguments
- `destination_id`: The ID of the publishing destination to delete.
- `detector_id`: The unique ID of the detector associated with the publishing destination
  to delete.

"""
function delete_publishing_destination(
    destinationId, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_publishing_destination(
    destinationId,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_threat_intel_set(detector_id, threat_intel_set_id)
    delete_threat_intel_set(detector_id, threat_intel_set_id, params::Dict{String,<:Any})

Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.

# Arguments
- `detector_id`: The unique ID of the detector that the threatIntelSet is associated with.
- `threat_intel_set_id`: The unique ID of the threatIntelSet that you want to delete.

"""
function delete_threat_intel_set(
    detectorId, threatIntelSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_threat_intel_set(
    detectorId,
    threatIntelSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_malware_scans(detector_id)
    describe_malware_scans(detector_id, params::Dict{String,<:Any})

Returns a list of malware scans. Each member account can view the malware scans for their
own accounts. An administrator can view the malware scans for all the member accounts.
There might be regional differences because some data sources might not be available in all
the Amazon Web Services Regions where GuardDuty is presently supported. For more
information, see Regions and endpoints.

# Arguments
- `detector_id`: The unique ID of the detector that the request is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterCriteria"`: Represents the criteria to be used in the filter for describing scan
  entries.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
- `"sortCriteria"`: Represents the criteria used for sorting scan entries. The
  attributeName  is required and it must be scanStartTime.
"""
function describe_malware_scans(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/malware-scans";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_malware_scans(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/malware-scans",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization_configuration(detector_id)
    describe_organization_configuration(detector_id, params::Dict{String,<:Any})

Returns information about the account selected as the delegated administrator for
GuardDuty. There might be regional differences because some data sources might not be
available in all the Amazon Web Services Regions where GuardDuty is presently supported.
For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The ID of the detector to retrieve information about the delegated
  administrator from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function describe_organization_configuration(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/admin";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organization_configuration(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/admin",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_publishing_destination(destination_id, detector_id)
    describe_publishing_destination(destination_id, detector_id, params::Dict{String,<:Any})

Returns information about the publishing destination specified by the provided
destinationId.

# Arguments
- `destination_id`: The ID of the publishing destination to retrieve.
- `detector_id`: The unique ID of the detector associated with the publishing destination
  to retrieve.

"""
function describe_publishing_destination(
    destinationId, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_publishing_destination(
    destinationId,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_organization_admin_account(admin_account_id)
    disable_organization_admin_account(admin_account_id, params::Dict{String,<:Any})

Removes the existing GuardDuty delegated administrator of the organization. Only the
organization's management account can run this API operation.

# Arguments
- `admin_account_id`: The Amazon Web Services Account ID for the organizations account to
  be disabled as a GuardDuty delegated administrator.

"""
function disable_organization_admin_account(
    adminAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/admin/disable",
        Dict{String,Any}("adminAccountId" => adminAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_organization_admin_account(
    adminAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/admin/disable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("adminAccountId" => adminAccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_from_administrator_account(detector_id)
    disassociate_from_administrator_account(detector_id, params::Dict{String,<:Any})

Disassociates the current GuardDuty member account from its administrator account. When you
disassociate an invited member from a GuardDuty delegated administrator, the member account
details obtained from the CreateMembers API, including the associated email addresses, are
retained. This is done so that the delegated administrator can invoke the InviteMembers API
without the need to invoke the CreateMembers API again. To remove the details associated
with a member account, the delegated administrator must invoke the DeleteMembers API.  With
autoEnableOrganizationMembers configuration for your organization set to ALL, you'll
receive an error if you attempt to disable GuardDuty in a member account.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.

"""
function disassociate_from_administrator_account(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/administrator/disassociate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_from_administrator_account(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/administrator/disassociate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_from_master_account(detector_id)
    disassociate_from_master_account(detector_id, params::Dict{String,<:Any})

Disassociates the current GuardDuty member account from its administrator account. When you
disassociate an invited member from a GuardDuty delegated administrator, the member account
details obtained from the CreateMembers API, including the associated email addresses, are
retained. This is done so that the delegated administrator can invoke the InviteMembers API
without the need to invoke the CreateMembers API again. To remove the details associated
with a member account, the delegated administrator must invoke the DeleteMembers API.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.

"""
function disassociate_from_master_account(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/master/disassociate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_from_master_account(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/master/disassociate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_members(account_ids, detector_id)
    disassociate_members(account_ids, detector_id, params::Dict{String,<:Any})

Disassociates GuardDuty member accounts (from the current administrator account) specified
by the account IDs. When you disassociate an invited member from a GuardDuty delegated
administrator, the member account details obtained from the CreateMembers API, including
the associated email addresses, are retained. This is done so that the delegated
administrator can invoke the InviteMembers API without the need to invoke the CreateMembers
API again. To remove the details associated with a member account, the delegated
administrator must invoke the DeleteMembers API.  With autoEnableOrganizationMembers
configuration for your organization set to ALL, you'll receive an error if you attempt to
disassociate a member account before removing them from your organization. If you
disassociate a member account that was added by invitation, the member account details
obtained from this API, including the associated email addresses, will be retained. This is
done so that the delegated administrator can invoke the InviteMembers API without the need
to invoke the CreateMembers API again. To remove the details associated with a member
account, the delegated administrator must invoke the DeleteMembers API.  When the member
accounts added through Organizations are later disassociated, you (administrator) can't
invite them by calling the InviteMembers API. You can create an association with these
member accounts again only by calling the CreateMembers API.

# Arguments
- `account_ids`: A list of account IDs of the GuardDuty member accounts that you want to
  disassociate from the administrator account.
- `detector_id`: The unique ID of the detector of the GuardDuty account whose members you
  want to disassociate from the administrator account.

"""
function disassociate_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/disassociate",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/disassociate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_organization_admin_account(admin_account_id)
    enable_organization_admin_account(admin_account_id, params::Dict{String,<:Any})

Designates an Amazon Web Services account within the organization as your GuardDuty
delegated administrator. Only the organization's management account can run this API
operation.

# Arguments
- `admin_account_id`: The Amazon Web Services account ID for the organization account to be
  enabled as a GuardDuty delegated administrator.

"""
function enable_organization_admin_account(
    adminAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/admin/enable",
        Dict{String,Any}("adminAccountId" => adminAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_organization_admin_account(
    adminAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/admin/enable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("adminAccountId" => adminAccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_administrator_account(detector_id)
    get_administrator_account(detector_id, params::Dict{String,<:Any})

Provides the details of the GuardDuty administrator account associated with the current
GuardDuty member account.  If the organization's management account or a delegated
administrator runs this API, it will return success (HTTP 200) but no content.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.

"""
function get_administrator_account(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/administrator";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_administrator_account(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/administrator",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_coverage_statistics(detector_id, statistics_type)
    get_coverage_statistics(detector_id, statistics_type, params::Dict{String,<:Any})

Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you
can retrieve the statistics for all the resources associated with the active member
accounts in your organization who have enabled Runtime Monitoring and have the GuardDuty
security agent running on their resources.

# Arguments
- `detector_id`: The unique ID of the GuardDuty detector associated to the coverage
  statistics.
- `statistics_type`: Represents the statistics type used to aggregate the coverage details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterCriteria"`: Represents the criteria used to filter the coverage statistics
"""
function get_coverage_statistics(
    detectorId, statisticsType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/coverage/statistics",
        Dict{String,Any}("statisticsType" => statisticsType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_coverage_statistics(
    detectorId,
    statisticsType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/coverage/statistics",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("statisticsType" => statisticsType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_detector(detector_id)
    get_detector(detector_id, params::Dict{String,<:Any})

Retrieves an Amazon GuardDuty detector specified by the detectorId. There might be regional
differences because some data sources might not be available in all the Amazon Web Services
Regions where GuardDuty is presently supported. For more information, see Regions and
endpoints.

# Arguments
- `detector_id`: The unique ID of the detector that you want to get.

"""
function get_detector(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_detector(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_filter(detector_id, filter_name)
    get_filter(detector_id, filter_name, params::Dict{String,<:Any})

Returns the details of the filter specified by the filter name.

# Arguments
- `detector_id`: The unique ID of the detector that the filter is associated with.
- `filter_name`: The name of the filter you want to get.

"""
function get_filter(
    detectorId, filterName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/filter/$(filterName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_filter(
    detectorId,
    filterName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/filter/$(filterName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_findings(detector_id, finding_ids)
    get_findings(detector_id, finding_ids, params::Dict{String,<:Any})

Describes Amazon GuardDuty findings specified by finding IDs.

# Arguments
- `detector_id`: The ID of the detector that specifies the GuardDuty service whose findings
  you want to retrieve.
- `finding_ids`: The IDs of the findings that you want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"sortCriteria"`: Represents the criteria used for sorting findings.
"""
function get_findings(
    detectorId, findingIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/get",
        Dict{String,Any}("findingIds" => findingIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_findings(
    detectorId,
    findingIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/get",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("findingIds" => findingIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_findings_statistics(detector_id, finding_statistic_types)
    get_findings_statistics(detector_id, finding_statistic_types, params::Dict{String,<:Any})

Lists Amazon GuardDuty findings statistics for the specified detector ID. There might be
regional differences because some flags might not be available in all the Regions where
GuardDuty is currently supported. For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The ID of the detector that specifies the GuardDuty service whose
  findings' statistics you want to retrieve.
- `finding_statistic_types`: The types of finding statistics to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"findingCriteria"`: Represents the criteria that is used for querying findings.
"""
function get_findings_statistics(
    detectorId, findingStatisticTypes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/statistics",
        Dict{String,Any}("findingStatisticTypes" => findingStatisticTypes);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_findings_statistics(
    detectorId,
    findingStatisticTypes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/statistics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("findingStatisticTypes" => findingStatisticTypes),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_invitations_count()
    get_invitations_count(params::Dict{String,<:Any})

Returns the count of all GuardDuty membership invitations that were sent to the current
member account except the currently accepted invitation.

"""
function get_invitations_count(; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET", "/invitation/count"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_invitations_count(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/invitation/count",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ipset(detector_id, ip_set_id)
    get_ipset(detector_id, ip_set_id, params::Dict{String,<:Any})

Retrieves the IPSet specified by the ipSetId.

# Arguments
- `detector_id`: The unique ID of the detector that the IPSet is associated with.
- `ip_set_id`: The unique ID of the IPSet to retrieve.

"""
function get_ipset(detectorId, ipSetId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)/ipset/$(ipSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ipset(
    detectorId,
    ipSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/ipset/$(ipSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_malware_protection_plan(malware_protection_plan_id)
    get_malware_protection_plan(malware_protection_plan_id, params::Dict{String,<:Any})

Retrieves the Malware Protection plan details associated with a Malware Protection plan ID.

# Arguments
- `malware_protection_plan_id`: A unique identifier associated with Malware Protection plan
  resource.

"""
function get_malware_protection_plan(
    malwareProtectionPlanId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/malware-protection-plan/$(malwareProtectionPlanId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_malware_protection_plan(
    malwareProtectionPlanId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/malware-protection-plan/$(malwareProtectionPlanId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_malware_scan_settings(detector_id)
    get_malware_scan_settings(detector_id, params::Dict{String,<:Any})

Returns the details of the malware scan settings. There might be regional differences
because some data sources might not be available in all the Amazon Web Services Regions
where GuardDuty is presently supported. For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The unique ID of the detector that the scan setting is associated with.

"""
function get_malware_scan_settings(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/malware-scan-settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_malware_scan_settings(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/malware-scan-settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_master_account(detector_id)
    get_master_account(detector_id, params::Dict{String,<:Any})

Provides the details for the GuardDuty administrator account associated with the current
GuardDuty member account.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.

"""
function get_master_account(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)/master";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_master_account(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/master",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_member_detectors(account_ids, detector_id)
    get_member_detectors(account_ids, detector_id, params::Dict{String,<:Any})

Describes which data sources are enabled for the member account's detector. There might be
regional differences because some data sources might not be available in all the Amazon Web
Services Regions where GuardDuty is presently supported. For more information, see Regions
and endpoints.

# Arguments
- `account_ids`: The account ID of the member account.
- `detector_id`: The detector ID for the administrator account.

"""
function get_member_detectors(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/detector/get",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_member_detectors(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/detector/get",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_members(account_ids, detector_id)
    get_members(account_ids, detector_id, params::Dict{String,<:Any})

Retrieves GuardDuty member accounts (of the current GuardDuty administrator account)
specified by the account IDs.

# Arguments
- `account_ids`: A list of account IDs of the GuardDuty member accounts that you want to
  describe.
- `detector_id`: The unique ID of the detector of the GuardDuty account whose members you
  want to retrieve.

"""
function get_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/get",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/get",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_organization_statistics()
    get_organization_statistics(params::Dict{String,<:Any})

Retrieves how many active member accounts have each feature enabled within GuardDuty. Only
a delegated GuardDuty administrator of an organization can run this API. When you create a
new organization, it might take up to 24 hours to generate the statistics for the entire
organization.

"""
function get_organization_statistics(; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/organization/statistics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_organization_statistics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/organization/statistics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_remaining_free_trial_days(detector_id)
    get_remaining_free_trial_days(detector_id, params::Dict{String,<:Any})

Provides the number of days left for each data source used in the free trial period.

# Arguments
- `detector_id`: The unique ID of the detector of the GuardDuty member account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: A list of account identifiers of the GuardDuty member account.
"""
function get_remaining_free_trial_days(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/freeTrial/daysRemaining";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_remaining_free_trial_days(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/freeTrial/daysRemaining",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_threat_intel_set(detector_id, threat_intel_set_id)
    get_threat_intel_set(detector_id, threat_intel_set_id, params::Dict{String,<:Any})

Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.

# Arguments
- `detector_id`: The unique ID of the detector that the threatIntelSet is associated with.
- `threat_intel_set_id`: The unique ID of the threatIntelSet that you want to get.

"""
function get_threat_intel_set(
    detectorId, threatIntelSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_threat_intel_set(
    detectorId,
    threatIntelSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_usage_statistics(detector_id, usage_criteria, usage_statistics_type)
    get_usage_statistics(detector_id, usage_criteria, usage_statistics_type, params::Dict{String,<:Any})

Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector
ID. For newly enabled detectors or data sources, the cost returned will include only the
usage so far under 30 days. This may differ from the cost metrics in the console, which
project usage over 30 days to provide a monthly cost estimate. For more information, see
Understanding How Usage Costs are Calculated.

# Arguments
- `detector_id`: The ID of the detector that specifies the GuardDuty service whose usage
  statistics you want to retrieve.
- `usage_criteria`: Represents the criteria used for querying usage.
- `usage_statistics_type`: The type of usage statistics to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: A token to use for paginating results that are returned in the response.
  Set the value of this parameter to null for the first request to a list action. For
  subsequent calls, use the NextToken value returned from the previous request to continue
  listing results after the first page.
- `"unit"`: The currency unit you would like to view your usage statistics in. Current
  valid values are USD.
"""
function get_usage_statistics(
    detectorId,
    usageCriteria,
    usageStatisticsType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/usage/statistics",
        Dict{String,Any}(
            "usageCriteria" => usageCriteria, "usageStatisticsType" => usageStatisticsType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_usage_statistics(
    detectorId,
    usageCriteria,
    usageStatisticsType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/usage/statistics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "usageCriteria" => usageCriteria,
                    "usageStatisticsType" => usageStatisticsType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invite_members(account_ids, detector_id)
    invite_members(account_ids, detector_id, params::Dict{String,<:Any})

Invites Amazon Web Services accounts to become members of an organization administered by
the Amazon Web Services account that invokes this API. If you are using Amazon Web Services
Organizations to manage your GuardDuty environment, this step is not needed. For more
information, see Managing accounts with organizations. To invite Amazon Web Services
accounts, the first step is to ensure that GuardDuty has been enabled in the potential
member accounts. You can now invoke this API to add accounts by invitation. The invited
accounts can either accept or decline the invitation from their GuardDuty accounts. Each
invited Amazon Web Services account can choose to accept the invitation from only one
Amazon Web Services account. For more information, see Managing GuardDuty accounts by
invitation. After the invite has been accepted and you choose to disassociate a member
account (by using DisassociateMembers) from your account, the details of the member account
obtained by invoking CreateMembers, including the associated email addresses, will be
retained. This is done so that you can invoke InviteMembers without the need to invoke
CreateMembers again. To remove the details associated with a member account, you must also
invoke DeleteMembers.  If you disassociate a member account that was added by invitation,
the member account details obtained from this API, including the associated email
addresses, will be retained. This is done so that the delegated administrator can invoke
the InviteMembers API without the need to invoke the CreateMembers API again. To remove the
details associated with a member account, the delegated administrator must invoke the
DeleteMembers API.  When the member accounts added through Organizations are later
disassociated, you (administrator) can't invite them by calling the InviteMembers API. You
can create an association with these member accounts again only by calling the
CreateMembers API.

# Arguments
- `account_ids`: A list of account IDs of the accounts that you want to invite to GuardDuty
  as members.
- `detector_id`: The unique ID of the detector of the GuardDuty account that you want to
  invite members with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"disableEmailNotification"`: A Boolean value that specifies whether you want to disable
  email notification to the accounts that you are inviting to GuardDuty as members.
- `"message"`: The invitation message that you want to send to the accounts that you're
  inviting to GuardDuty as members.
"""
function invite_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/invite",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invite_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/invite",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_coverage(detector_id)
    list_coverage(detector_id, params::Dict{String,<:Any})

Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you
can retrieve all resources associated with the active member accounts in your organization.
Make sure the accounts have Runtime Monitoring enabled and GuardDuty agent running on their
resources.

# Arguments
- `detector_id`: The unique ID of the detector whose coverage details you want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filterCriteria"`: Represents the criteria used to filter the coverage details.
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: A token to use for paginating results that are returned in the response.
  Set the value of this parameter to null for the first request to a list action. For
  subsequent calls, use the NextToken value returned from the previous request to continue
  listing results after the first page.
- `"sortCriteria"`: Represents the criteria used to sort the coverage details.
"""
function list_coverage(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/detector/$(detectorId)/coverage";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_coverage(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/coverage",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_detectors()
    list_detectors(params::Dict{String,<:Any})

Lists detectorIds of all the existing Amazon GuardDuty detector resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_detectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET", "/detector"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_detectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET", "/detector", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_filters(detector_id)
    list_filters(detector_id, params::Dict{String,<:Any})

Returns a paginated list of the current filters.

# Arguments
- `detector_id`: The unique ID of the detector that the filter is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_filters(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)/filter";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_filters(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/filter",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_findings(detector_id)
    list_findings(detector_id, params::Dict{String,<:Any})

Lists GuardDuty findings for the specified detector ID. There might be regional differences
because some flags might not be available in all the Regions where GuardDuty is currently
supported. For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The ID of the detector that specifies the GuardDuty service whose findings
  you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"findingCriteria"`: Represents the criteria used for querying findings. Valid values
  include:   JSON field name   accountId   region   confidence   id
  resource.accessKeyDetails.accessKeyId   resource.accessKeyDetails.principalId
  resource.accessKeyDetails.userName   resource.accessKeyDetails.userType
  resource.instanceDetails.iamInstanceProfile.id   resource.instanceDetails.imageId
  resource.instanceDetails.instanceId
  resource.instanceDetails.networkInterfaces.ipv6Addresses
  resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
  resource.instanceDetails.networkInterfaces.publicDnsName
  resource.instanceDetails.networkInterfaces.publicIp
  resource.instanceDetails.networkInterfaces.securityGroups.groupId
  resource.instanceDetails.networkInterfaces.securityGroups.groupName
  resource.instanceDetails.networkInterfaces.subnetId
  resource.instanceDetails.networkInterfaces.vpcId   resource.instanceDetails.tags.key
  resource.instanceDetails.tags.value   resource.resourceType   service.action.actionType
  service.action.awsApiCallAction.api   service.action.awsApiCallAction.callerType
  service.action.awsApiCallAction.remoteIpDetails.city.cityName
  service.action.awsApiCallAction.remoteIpDetails.country.countryName
  service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
  service.action.awsApiCallAction.remoteIpDetails.organization.asn
  service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
  service.action.awsApiCallAction.serviceName   service.action.dnsRequestAction.domain
  service.action.dnsRequestAction.domainWithSuffix
  service.action.networkConnectionAction.blocked
  service.action.networkConnectionAction.connectionDirection
  service.action.networkConnectionAction.localPortDetails.port
  service.action.networkConnectionAction.protocol
  service.action.networkConnectionAction.remoteIpDetails.country.countryName
  service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
  service.action.networkConnectionAction.remoteIpDetails.organization.asn
  service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
  service.action.networkConnectionAction.remotePortDetails.port
  service.additionalInfo.threatListName   service.archived When this attribute is set to
  'true', only archived findings are listed. When it's set to 'false', only unarchived
  findings are listed. When this attribute is not set, all existing findings are listed.
  service.resourceRole   severity   type   updatedAt Type: Timestamp in Unix Epoch
  millisecond format: 1486685375000
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
- `"sortCriteria"`: Represents the criteria used for sorting findings.
"""
function list_findings(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_findings(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_invitations()
    list_invitations(params::Dict{String,<:Any})

Lists all GuardDuty membership invitations that were sent to the current Amazon Web
Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_invitations(; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET", "/invitation"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_invitations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET", "/invitation", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_ipsets(detector_id)
    list_ipsets(detector_id, params::Dict{String,<:Any})

Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this
operation from a member account, the IPSets returned are the IPSets from the associated
administrator account.

# Arguments
- `detector_id`: The unique ID of the detector that the IPSet is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_ipsets(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)/ipset";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_ipsets(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/ipset",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_malware_protection_plans()
    list_malware_protection_plans(params::Dict{String,<:Any})

Lists the Malware Protection plan IDs associated with the protected resources in your
Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_malware_protection_plans(; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/malware-protection-plan";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_malware_protection_plans(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/malware-protection-plan",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_members(detector_id)
    list_members(detector_id, params::Dict{String,<:Any})

Lists details about all member accounts for the current GuardDuty administrator account.

# Arguments
- `detector_id`: The unique ID of the detector the member is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the list action. For subsequent calls to the
  action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
- `"onlyAssociated"`: Specifies whether to only return associated members or to return all
  members (including members who haven't been invited yet or have been disassociated). Member
  accounts must have been previously associated with the GuardDuty administrator account
  using  Create Members .
"""
function list_members(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "GET",
        "/detector/$(detectorId)/member";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_members(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/member",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_organization_admin_accounts()
    list_organization_admin_accounts(params::Dict{String,<:Any})

Lists the accounts designated as GuardDuty delegated administrators. Only the
organization's management account can run this API operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: A token to use for paginating results that are returned in the response.
  Set the value of this parameter to null for the first request to a list action. For
  subsequent calls, use the NextToken value returned from the previous request to continue
  listing results after the first page.
"""
function list_organization_admin_accounts(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET", "/admin"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_organization_admin_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET", "/admin", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_publishing_destinations(detector_id)
    list_publishing_destinations(detector_id, params::Dict{String,<:Any})

Returns a list of publishing destinations associated with the specified detectorId.

# Arguments
- `detector_id`: The ID of the detector to retrieve publishing destinations for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: A token to use for paginating results that are returned in the response.
  Set the value of this parameter to null for the first request to a list action. For
  subsequent calls, use the NextToken value returned from the previous request to continue
  listing results after the first page.
"""
function list_publishing_destinations(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/publishingDestination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_publishing_destinations(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/publishingDestination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists tags for a resource. Tagging is currently supported for detectors, finding filters,
IP sets, threat intel sets, and publishing destination, with a limit of 50 tags per
resource. When invoked, this operation returns all assigned tags for a given resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the given GuardDuty resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_threat_intel_sets(detector_id)
    list_threat_intel_sets(detector_id, params::Dict{String,<:Any})

Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use
this operation from a member account, the ThreatIntelSets associated with the administrator
account are returned.

# Arguments
- `detector_id`: The unique ID of the detector that the threatIntelSet is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 50. The maximum value is 50.
- `"nextToken"`: You can use this parameter to paginate results in the response. Set the
  value of this parameter to null on your first call to the list action. For subsequent calls
  to the action, fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_threat_intel_sets(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/threatintelset";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_threat_intel_sets(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "GET",
        "/detector/$(detectorId)/threatintelset",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_malware_scan(resource_arn)
    start_malware_scan(resource_arn, params::Dict{String,<:Any})

Initiates the malware scan. Invoking this API will automatically create the Service-linked
role in the corresponding account. When the malware scan starts, you can use the associated
scan ID to track the status of the scan. For more information, see DescribeMalwareScans.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the resource for which you invoked the API.

"""
function start_malware_scan(resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/malware-scan/start",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_malware_scan(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/malware-scan/start",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_monitoring_members(account_ids, detector_id)
    start_monitoring_members(account_ids, detector_id, params::Dict{String,<:Any})

Turns on GuardDuty monitoring of the specified member accounts. Use this operation to
restart monitoring of accounts that you stopped monitoring with the StopMonitoringMembers
operation.

# Arguments
- `account_ids`: A list of account IDs of the GuardDuty member accounts to start monitoring.
- `detector_id`: The unique ID of the detector of the GuardDuty administrator account
  associated with the member accounts to monitor.

"""
function start_monitoring_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/start",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_monitoring_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/start",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_monitoring_members(account_ids, detector_id)
    stop_monitoring_members(account_ids, detector_id, params::Dict{String,<:Any})

Stops GuardDuty monitoring for the specified member accounts. Use the
StartMonitoringMembers operation to restart monitoring for those accounts. With
autoEnableOrganizationMembers configuration for your organization set to ALL, you'll
receive an error if you attempt to stop monitoring the member accounts in your organization.

# Arguments
- `account_ids`: A list of account IDs for the member accounts to stop monitoring.
- `detector_id`: The unique ID of the detector associated with the GuardDuty administrator
  account that is monitoring member accounts.

"""
function stop_monitoring_members(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/stop",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_monitoring_members(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/stop",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds tags to a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag
  to.
- `tags`: The tags to be added to a resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unarchive_findings(detector_id, finding_ids)
    unarchive_findings(detector_id, finding_ids, params::Dict{String,<:Any})

Unarchives GuardDuty findings specified by the findingIds.

# Arguments
- `detector_id`: The ID of the detector associated with the findings to unarchive.
- `finding_ids`: The IDs of the findings to unarchive.

"""
function unarchive_findings(
    detectorId, findingIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/unarchive",
        Dict{String,Any}("findingIds" => findingIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unarchive_findings(
    detectorId,
    findingIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/unarchive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("findingIds" => findingIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the resource to remove tags from.
- `tag_keys`: The tag keys to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_detector(detector_id)
    update_detector(detector_id, params::Dict{String,<:Any})

Updates the GuardDuty detector specified by the detector ID. Specifying both EKS Runtime
Monitoring (EKS_RUNTIME_MONITORING) and Runtime Monitoring (RUNTIME_MONITORING) will cause
an error. You can add only one of these two features because Runtime Monitoring already
includes the threat detection for Amazon EKS resources. For more information, see Runtime
Monitoring. There might be regional differences because some data sources might not be
available in all the Amazon Web Services Regions where GuardDuty is presently supported.
For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The unique ID of the detector to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSources"`: Describes which data sources will be updated. There might be regional
  differences because some data sources might not be available in all the Amazon Web Services
  Regions where GuardDuty is presently supported. For more information, see Regions and
  endpoints.
- `"enable"`: Specifies whether the detector is enabled or not enabled.
- `"features"`: Provides the features that will be updated for the detector.
- `"findingPublishingFrequency"`: An enum value that specifies how frequently findings are
  exported, such as to CloudWatch Events.
"""
function update_detector(detectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return guardduty(
        "POST",
        "/detector/$(detectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_detector(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_filter(detector_id, filter_name)
    update_filter(detector_id, filter_name, params::Dict{String,<:Any})

Updates the filter specified by the filter name.

# Arguments
- `detector_id`: The unique ID of the detector that specifies the GuardDuty service where
  you want to update a filter.
- `filter_name`: The name of the filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"action"`: Specifies the action that is to be applied to the findings that match the
  filter.
- `"description"`: The description of the filter. Valid characters include alphanumeric
  characters, and special characters such as hyphen, period, colon, underscore, parentheses
  ({ }, [ ], and ( )), forward slash, horizontal tab, vertical tab, newline, form feed,
  return, and whitespace.
- `"findingCriteria"`: Represents the criteria to be used in the filter for querying
  findings.
- `"rank"`: Specifies the position of the filter in the list of current filters. Also
  specifies the order in which this filter is applied to the findings.
"""
function update_filter(
    detectorId, filterName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/filter/$(filterName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_filter(
    detectorId,
    filterName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/filter/$(filterName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_findings_feedback(detector_id, feedback, finding_ids)
    update_findings_feedback(detector_id, feedback, finding_ids, params::Dict{String,<:Any})

Marks the specified GuardDuty findings as useful or not useful.

# Arguments
- `detector_id`: The ID of the detector associated with the findings to update feedback for.
- `feedback`: The feedback for the finding.
- `finding_ids`: The IDs of the findings that you want to mark as useful or not useful.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"comments"`: Additional feedback about the GuardDuty findings.
"""
function update_findings_feedback(
    detectorId, feedback, findingIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/feedback",
        Dict{String,Any}("feedback" => feedback, "findingIds" => findingIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_findings_feedback(
    detectorId,
    feedback,
    findingIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/findings/feedback",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("feedback" => feedback, "findingIds" => findingIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ipset(detector_id, ip_set_id)
    update_ipset(detector_id, ip_set_id, params::Dict{String,<:Any})

Updates the IPSet specified by the IPSet ID.

# Arguments
- `detector_id`: The detectorID that specifies the GuardDuty service whose IPSet you want
  to update.
- `ip_set_id`: The unique ID that specifies the IPSet that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"activate"`: The updated Boolean value that specifies whether the IPSet is active or not.
- `"location"`: The updated URI of the file that contains the IPSet.
- `"name"`: The unique ID that specifies the IPSet that you want to update.
"""
function update_ipset(
    detectorId, ipSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/ipset/$(ipSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ipset(
    detectorId,
    ipSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/ipset/$(ipSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_malware_protection_plan(malware_protection_plan_id)
    update_malware_protection_plan(malware_protection_plan_id, params::Dict{String,<:Any})

Updates an existing Malware Protection plan resource.

# Arguments
- `malware_protection_plan_id`: A unique identifier associated with the Malware Protection
  plan.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actions"`: Information about whether the tags will be added to the S3 object after
  scanning.
- `"protectedResource"`: Information about the protected resource that is associated with
  the created Malware Protection plan. Presently, S3Bucket is the only supported protected
  resource.
- `"role"`: IAM role with permissions required to scan and add tags to the associated
  protected resource.
"""
function update_malware_protection_plan(
    malwareProtectionPlanId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "PATCH",
        "/malware-protection-plan/$(malwareProtectionPlanId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_malware_protection_plan(
    malwareProtectionPlanId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "PATCH",
        "/malware-protection-plan/$(malwareProtectionPlanId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_malware_scan_settings(detector_id)
    update_malware_scan_settings(detector_id, params::Dict{String,<:Any})

Updates the malware scan settings. There might be regional differences because some data
sources might not be available in all the Amazon Web Services Regions where GuardDuty is
presently supported. For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The unique ID of the detector that specifies the GuardDuty service where
  you want to update scan settings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ebsSnapshotPreservation"`: An enum value representing possible snapshot preservation
  settings.
- `"scanResourceCriteria"`: Represents the criteria to be used in the filter for selecting
  resources to scan.
"""
function update_malware_scan_settings(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/malware-scan-settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_malware_scan_settings(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/malware-scan-settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_member_detectors(account_ids, detector_id)
    update_member_detectors(account_ids, detector_id, params::Dict{String,<:Any})

Contains information on member accounts to be updated. Specifying both EKS Runtime
Monitoring (EKS_RUNTIME_MONITORING) and Runtime Monitoring (RUNTIME_MONITORING) will cause
an error. You can add only one of these two features because Runtime Monitoring already
includes the threat detection for Amazon EKS resources. For more information, see Runtime
Monitoring. There might be regional differences because some data sources might not be
available in all the Amazon Web Services Regions where GuardDuty is presently supported.
For more information, see Regions and endpoints.

# Arguments
- `account_ids`: A list of member account IDs to be updated.
- `detector_id`: The detector ID of the administrator account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSources"`: Describes which data sources will be updated.
- `"features"`: A list of features that will be updated for the specified member accounts.
"""
function update_member_detectors(
    accountIds, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/detector/update",
        Dict{String,Any}("accountIds" => accountIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_member_detectors(
    accountIds,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/member/detector/update",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accountIds" => accountIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_organization_configuration(detector_id)
    update_organization_configuration(detector_id, params::Dict{String,<:Any})

Configures the delegated administrator account with the provided values. You must provide a
value for either autoEnableOrganizationMembers or autoEnable, but not both.  Specifying
both EKS Runtime Monitoring (EKS_RUNTIME_MONITORING) and Runtime Monitoring
(RUNTIME_MONITORING) will cause an error. You can add only one of these two features
because Runtime Monitoring already includes the threat detection for Amazon EKS resources.
For more information, see Runtime Monitoring. There might be regional differences because
some data sources might not be available in all the Amazon Web Services Regions where
GuardDuty is presently supported. For more information, see Regions and endpoints.

# Arguments
- `detector_id`: The ID of the detector that configures the delegated administrator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"autoEnable"`: Represents whether or not to automatically enable member accounts in the
  organization. Even though this is still supported, we recommend using
  AutoEnableOrganizationMembers to achieve the similar results. You must provide a value for
  either autoEnableOrganizationMembers or autoEnable.
- `"autoEnableOrganizationMembers"`: Indicates the auto-enablement configuration of
  GuardDuty for the member accounts in the organization. You must provide a value for either
  autoEnableOrganizationMembers or autoEnable.  Use one of the following configuration values
  for autoEnableOrganizationMembers:    NEW: Indicates that when a new account joins the
  organization, they will have GuardDuty enabled automatically.     ALL: Indicates that all
  accounts in the organization have GuardDuty enabled automatically. This includes NEW
  accounts that join the organization and accounts that may have been suspended or removed
  from the organization in GuardDuty. It may take up to 24 hours to update the configuration
  for all the member accounts.    NONE: Indicates that GuardDuty will not be automatically
  enabled for any account in the organization. The administrator must manage GuardDuty for
  each account in the organization individually. When you update the auto-enable setting from
  ALL or NEW to NONE, this action doesn't disable the corresponding option for your existing
  accounts. This configuration will apply to the new accounts that join the organization.
  After you update the auto-enable settings, no new account will have the corresponding
  option as enabled.
- `"dataSources"`: Describes which data sources will be updated.
- `"features"`: A list of features that will be configured for the organization.
"""
function update_organization_configuration(
    detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/admin";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_organization_configuration(
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/admin",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_publishing_destination(destination_id, detector_id)
    update_publishing_destination(destination_id, detector_id, params::Dict{String,<:Any})

Updates information about the publishing destination specified by the destinationId.

# Arguments
- `destination_id`: The ID of the publishing destination to update.
- `detector_id`: The ID of the detector associated with the publishing destinations to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"destinationProperties"`: A DestinationProperties object that includes the
  DestinationArn and KmsKeyArn of the publishing destination.
"""
function update_publishing_destination(
    destinationId, detectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_publishing_destination(
    destinationId,
    detectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/publishingDestination/$(destinationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_threat_intel_set(detector_id, threat_intel_set_id)
    update_threat_intel_set(detector_id, threat_intel_set_id, params::Dict{String,<:Any})

Updates the ThreatIntelSet specified by the ThreatIntelSet ID.

# Arguments
- `detector_id`: The detectorID that specifies the GuardDuty service whose ThreatIntelSet
  you want to update.
- `threat_intel_set_id`: The unique ID that specifies the ThreatIntelSet that you want to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"activate"`: The updated Boolean value that specifies whether the ThreateIntelSet is
  active or not.
- `"location"`: The updated URI of the file that contains the ThreateIntelSet.
- `"name"`: The unique ID that specifies the ThreatIntelSet that you want to update.
"""
function update_threat_intel_set(
    detectorId, threatIntelSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_threat_intel_set(
    detectorId,
    threatIntelSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return guardduty(
        "POST",
        "/detector/$(detectorId)/threatintelset/$(threatIntelSetId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
