# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iam
using AWS.Compat
using AWS.UUIDs

"""
    add_client_idto_open_idconnect_provider(client_id, open_idconnect_provider_arn)
    add_client_idto_open_idconnect_provider(client_id, open_idconnect_provider_arn, params::Dict{String,<:Any})

Adds a new client ID (also known as audience) to the list of client IDs already registered
for the specified IAM OpenID Connect (OIDC) provider resource. This operation is
idempotent; it does not fail or return an error if you add an existing client ID to the
provider.

# Arguments
- `client_id`: The client ID (also known as audience) to add to the IAM OpenID Connect
  provider resource.
- `open_idconnect_provider_arn`: The Amazon Resource Name (ARN) of the IAM OpenID Connect
  (OIDC) provider resource to add the client ID to. You can get a list of OIDC provider ARNs
  by using the ListOpenIDConnectProviders operation.

"""
function add_client_idto_open_idconnect_provider(
    ClientID, OpenIDConnectProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AddClientIDToOpenIDConnectProvider",
        Dict{String,Any}(
            "ClientID" => ClientID, "OpenIDConnectProviderArn" => OpenIDConnectProviderArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_client_idto_open_idconnect_provider(
    ClientID,
    OpenIDConnectProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AddClientIDToOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientID" => ClientID,
                    "OpenIDConnectProviderArn" => OpenIDConnectProviderArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_role_to_instance_profile(instance_profile_name, role_name)
    add_role_to_instance_profile(instance_profile_name, role_name, params::Dict{String,<:Any})

Adds the specified IAM role to the specified instance profile. An instance profile can
contain only one role, and this quota cannot be increased. You can remove the existing role
and then add a different role to an instance profile. You must then wait for the change to
appear across all of Amazon Web Services because of eventual consistency. To force the
change, you must disassociate the instance profile and then associate the instance profile,
or you can stop your instance and then restart it.  The caller of this operation must be
granted the PassRole permission on the IAM role by a permissions policy.   For more
information about roles, see IAM roles in the IAM User Guide. For more information about
instance profiles, see Using instance profiles in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the instance profile to update. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `role_name`: The name of the role to add. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function add_role_to_instance_profile(
    InstanceProfileName, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AddRoleToInstanceProfile",
        Dict{String,Any}(
            "InstanceProfileName" => InstanceProfileName, "RoleName" => RoleName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_role_to_instance_profile(
    InstanceProfileName,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AddRoleToInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceProfileName" => InstanceProfileName, "RoleName" => RoleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_user_to_group(group_name, user_name)
    add_user_to_group(group_name, user_name, params::Dict{String,<:Any})

Adds the specified user to the specified group.

# Arguments
- `group_name`: The name of the group to update. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
- `user_name`: The name of the user to add. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function add_user_to_group(
    GroupName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AddUserToGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_user_to_group(
    GroupName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AddUserToGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_group_policy(group_name, policy_arn)
    attach_group_policy(group_name, policy_arn, params::Dict{String,<:Any})

Attaches the specified managed policy to the specified IAM group. You use this operation to
attach a managed policy to a group. To embed an inline policy in a group, use
PutGroupPolicy . As a best practice, you can validate your IAM policies. To learn more, see
Validating IAM policies in the IAM User Guide. For more information about policies, see
Managed policies and inline policies in the IAM User Guide.

# Arguments
- `group_name`: The name (friendly name, not ARN) of the group to attach the policy to.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to attach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.

"""
function attach_group_policy(
    GroupName, PolicyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AttachGroupPolicy",
        Dict{String,Any}("GroupName" => GroupName, "PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_group_policy(
    GroupName,
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AttachGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "PolicyArn" => PolicyArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_role_policy(policy_arn, role_name)
    attach_role_policy(policy_arn, role_name, params::Dict{String,<:Any})

Attaches the specified managed policy to the specified IAM role. When you attach a managed
policy to a role, the managed policy becomes part of the role's permission (access) policy.
 You cannot use a managed policy as the role's trust policy. The role's trust policy is
created at the same time as the role, using  CreateRole . You can update a role's trust
policy using  UpdateAssumerolePolicy .  Use this operation to attach a managed policy to a
role. To embed an inline policy in a role, use  PutRolePolicy . For more information about
policies, see Managed policies and inline policies in the IAM User Guide. As a best
practice, you can validate your IAM policies. To learn more, see Validating IAM policies in
the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to attach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.
- `role_name`: The name (friendly name, not ARN) of the role to attach the policy to. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function attach_role_policy(
    PolicyArn, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AttachRolePolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_role_policy(
    PolicyArn,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AttachRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "RoleName" => RoleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_user_policy(policy_arn, user_name)
    attach_user_policy(policy_arn, user_name, params::Dict{String,<:Any})

Attaches the specified managed policy to the specified user. You use this operation to
attach a managed policy to a user. To embed an inline policy in a user, use  PutUserPolicy
. As a best practice, you can validate your IAM policies. To learn more, see Validating IAM
policies in the IAM User Guide. For more information about policies, see Managed policies
and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to attach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.
- `user_name`: The name (friendly name, not ARN) of the IAM user to attach the policy to.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

"""
function attach_user_policy(
    PolicyArn, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "AttachUserPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_user_policy(
    PolicyArn,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "AttachUserPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    change_password(new_password, old_password)
    change_password(new_password, old_password, params::Dict{String,<:Any})

Changes the password of the IAM user who is calling this operation. This operation can be
performed using the CLI, the Amazon Web Services API, or the My Security Credentials page
in the Amazon Web Services Management Console. The Amazon Web Services account root user
password is not affected by this operation. Use UpdateLoginProfile to use the CLI, the
Amazon Web Services API, or the Users page in the IAM console to change the password for
any IAM user. For more information about modifying passwords, see Managing passwords in the
IAM User Guide.

# Arguments
- `new_password`: The new password. The new password must conform to the Amazon Web
  Services account's password policy, if one exists. The regex pattern that is used to
  validate this parameter is a string of characters. That string can include almost any
  printable ASCII character from the space (u0020) through the end of the ASCII character
  range (u00FF). You can also include the tab (u0009), line feed (u000A), and carriage return
  (u000D) characters. Any of these characters are valid in a password. However, many tools,
  such as the Amazon Web Services Management Console, might restrict the ability to type
  certain characters because they have special meaning within that tool.
- `old_password`: The IAM user's current password.

"""
function change_password(
    NewPassword, OldPassword; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ChangePassword",
        Dict{String,Any}("NewPassword" => NewPassword, "OldPassword" => OldPassword);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function change_password(
    NewPassword,
    OldPassword,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ChangePassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NewPassword" => NewPassword, "OldPassword" => OldPassword
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_access_key()
    create_access_key(params::Dict{String,<:Any})

 Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services
access key ID for the specified user. The default status for new keys is Active. If you do
not specify a user name, IAM determines the user name implicitly based on the Amazon Web
Services access key ID signing the request. This operation works for access keys under the
Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web
Services account root user credentials. This is true even if the Amazon Web Services
account has no associated users.  For information about quotas on the number of keys you
can create, see IAM and STS quotas in the IAM User Guide.  To ensure the security of your
Amazon Web Services account, the secret access key is accessible only during key and user
creation. You must save the key (for example, in a text file) if you want to be able to
access it again. If a secret key is lost, you can delete the access keys for the associated
user and then create new keys.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the IAM user that the new key will belong to. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function create_access_key(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("CreateAccessKey"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function create_access_key(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateAccessKey", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    create_account_alias(account_alias)
    create_account_alias(account_alias, params::Dict{String,<:Any})

Creates an alias for your Amazon Web Services account. For information about using an
Amazon Web Services account alias, see Creating, deleting, and listing an Amazon Web
Services account alias in the Amazon Web Services Sign-In User Guide.

# Arguments
- `account_alias`: The account alias to create. This parameter allows (through its regex
  pattern) a string of characters consisting of lowercase letters, digits, and dashes. You
  cannot start or finish with a dash, nor can you have two dashes in a row.

"""
function create_account_alias(
    AccountAlias; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateAccountAlias",
        Dict{String,Any}("AccountAlias" => AccountAlias);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_account_alias(
    AccountAlias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateAccountAlias",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountAlias" => AccountAlias), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_group(group_name)
    create_group(group_name, params::Dict{String,<:Any})

Creates a new group.  For information about the number of groups you can create, see IAM
and STS quotas in the IAM User Guide.

# Arguments
- `group_name`: The name of the group to create. Do not include the path in this value. IAM
  user, group, role, and policy names must be unique within the account. Names are not
  distinguished by case. For example, you cannot create resources named both \"MyResource\"
  and \"myresource\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Path"`:  The path to the group. For more information about paths, see IAM identifiers
  in the IAM User Guide. This parameter is optional. If it is not included, it defaults to a
  slash (/). This parameter allows (through its regex pattern) a string of characters
  consisting of either a forward slash (/) by itself or a string that must begin and end with
  forward slashes. In addition, it can contain any ASCII character from the ! (u0021) through
  the DEL character (u007F), including most punctuation characters, digits, and upper and
  lowercased letters.
"""
function create_group(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "CreateGroup",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_group(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_profile(instance_profile_name)
    create_instance_profile(instance_profile_name, params::Dict{String,<:Any})

 Creates a new instance profile. For information about instance profiles, see Using roles
for applications on Amazon EC2 in the IAM User Guide, and Instance profiles in the Amazon
EC2 User Guide.  For information about the number of instance profiles you can create, see
IAM object quotas in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the instance profile to create. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Path"`:  The path to the instance profile. For more information about paths, see IAM
  Identifiers in the IAM User Guide. This parameter is optional. If it is not included, it
  defaults to a slash (/). This parameter allows (through its regex pattern) a string of
  characters consisting of either a forward slash (/) by itself or a string that must begin
  and end with forward slashes. In addition, it can contain any ASCII character from the !
  (u0021) through the DEL character (u007F), including most punctuation characters, digits,
  and upper and lowercased letters.
- `"Tags"`: A list of tags that you want to attach to the newly created IAM instance
  profile. Each tag consists of a key name and an associated value. For more information
  about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is
  invalid or if you exceed the allowed maximum number of tags, then the entire request fails
  and the resource is not created.
"""
function create_instance_profile(
    InstanceProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateInstanceProfile",
        Dict{String,Any}("InstanceProfileName" => InstanceProfileName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance_profile(
    InstanceProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceProfileName" => InstanceProfileName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_login_profile(password, user_name)
    create_login_profile(password, user_name, params::Dict{String,<:Any})

Creates a password for the specified IAM user. A password allows an IAM user to access
Amazon Web Services services through the Amazon Web Services Management Console. You can
use the CLI, the Amazon Web Services API, or the Users page in the IAM console to create a
password for any IAM user. Use ChangePassword to update your own existing password in the
My Security Credentials page in the Amazon Web Services Management Console. For more
information about managing passwords, see Managing passwords in the IAM User Guide.

# Arguments
- `password`: The new password for the user. The regex pattern that is used to validate
  this parameter is a string of characters. That string can include almost any printable
  ASCII character from the space (u0020) through the end of the ASCII character range
  (u00FF). You can also include the tab (u0009), line feed (u000A), and carriage return
  (u000D) characters. Any of these characters are valid in a password. However, many tools,
  such as the Amazon Web Services Management Console, might restrict the ability to type
  certain characters because they have special meaning within that tool.
- `user_name`: The name of the IAM user to create a password for. The user must already
  exist. This parameter allows (through its regex pattern) a string of characters consisting
  of upper and lowercase alphanumeric characters with no spaces. You can also include any of
  the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PasswordResetRequired"`: Specifies whether the user is required to set a new password
  on next sign-in.
"""
function create_login_profile(
    Password, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateLoginProfile",
        Dict{String,Any}("Password" => Password, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_login_profile(
    Password,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateLoginProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Password" => Password, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_open_idconnect_provider(url)
    create_open_idconnect_provider(url, params::Dict{String,<:Any})

Creates an IAM entity to describe an identity provider (IdP) that supports OpenID Connect
(OIDC). The OIDC provider that you create with this operation can be used as a principal in
a role's trust policy. Such a policy establishes a trust relationship between Amazon Web
Services and the OIDC provider. If you are using an OIDC identity provider from Google,
Facebook, or Amazon Cognito, you don't need to create a separate IAM identity provider.
These OIDC identity providers are already built-in to Amazon Web Services and are available
for your use. Instead, you can move directly to creating new roles using your identity
provider. To learn more, see Creating a role for web identity or OpenID connect federation
in the IAM User Guide. When you create the IAM OIDC provider, you specify the following:
The URL of the OIDC identity provider (IdP) to trust   A list of client IDs (also known as
audiences) that identify the application or applications allowed to authenticate using the
OIDC provider   A list of tags that are attached to the specified IAM OIDC provider   A
list of thumbprints of one or more server certificates that the IdP uses   You get all of
this information from the OIDC IdP you want to use to access Amazon Web Services.  Amazon
Web Services secures communication with some OIDC identity providers (IdPs) through our
library of trusted root certificate authorities (CAs) instead of using a certificate
thumbprint to verify your IdP server certificate. In these cases, your legacy thumbprint
remains in your configuration, but is no longer used for validation. These OIDC IdPs
include Auth0, GitHub, GitLab, Google, and those that use an Amazon S3 bucket to host a
JSON Web Key Set (JWKS) endpoint.   The trust for the OIDC provider is derived from the IAM
provider that this operation creates. Therefore, it is best to limit access to the
CreateOpenIDConnectProvider operation to highly privileged users.

# Arguments
- `url`: The URL of the identity provider. The URL must begin with https:// and should
  correspond to the iss claim in the provider's OpenID Connect ID tokens. Per the OIDC
  standard, path components are allowed but query parameters are not. Typically the URL
  consists of only a hostname, like https://server.example.org or https://example.com. The
  URL should not contain a port number.  You cannot register the same provider multiple times
  in a single Amazon Web Services account. If you try to submit a URL that has already been
  used for an OpenID Connect provider in the Amazon Web Services account, you will get an
  error.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientIDList"`: Provides a list of client IDs, also known as audiences. When a mobile
  or web app registers with an OpenID Connect provider, they establish a value that
  identifies the application. This is the value that's sent as the client_id parameter on
  OAuth requests. You can register multiple client IDs with the same provider. For example,
  you might have multiple applications that use the same OIDC provider. You cannot register
  more than 100 client IDs with a single IAM OIDC provider. There is no defined format for a
  client ID. The CreateOpenIDConnectProviderRequest operation accepts client IDs up to 255
  characters long.
- `"Tags"`: A list of tags that you want to attach to the new IAM OpenID Connect (OIDC)
  provider. Each tag consists of a key name and an associated value. For more information
  about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is
  invalid or if you exceed the allowed maximum number of tags, then the entire request fails
  and the resource is not created.
- `"ThumbprintList"`: A list of server certificate thumbprints for the OpenID Connect
  (OIDC) identity provider's server certificates. Typically this list includes only one
  entry. However, IAM lets you have up to five thumbprints for an OIDC provider. This lets
  you maintain multiple thumbprints if the identity provider is rotating certificates. This
  parameter is optional. If it is not included, IAM will retrieve and use the top
  intermediate certificate authority (CA) thumbprint of the OpenID Connect identity provider
  server certificate. The server certificate thumbprint is the hex-encoded SHA-1 hash value
  of the X.509 certificate used by the domain where the OpenID Connect provider makes its
  keys available. It is always a 40-character string. For example, assume that the OIDC
  provider is server.example.com and the provider stores its keys at
  https://keys.server.example.com/openid-connect. In that case, the thumbprint string would
  be the hex-encoded SHA-1 hash value of the certificate used by
  https://keys.server.example.com.  For more information about obtaining the OIDC provider
  thumbprint, see Obtaining the thumbprint for an OpenID Connect provider in the IAM user
  Guide.
"""
function create_open_idconnect_provider(
    Url; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateOpenIDConnectProvider",
        Dict{String,Any}("Url" => Url);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_open_idconnect_provider(
    Url, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateOpenIDConnectProvider",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Url" => Url), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_policy(policy_document, policy_name)
    create_policy(policy_document, policy_name, params::Dict{String,<:Any})

Creates a new managed policy for your Amazon Web Services account. This operation creates a
policy version with a version identifier of v1 and sets v1 as the policy's default version.
For more information about policy versions, see Versioning for managed policies in the IAM
User Guide. As a best practice, you can validate your IAM policies. To learn more, see
Validating IAM policies in the IAM User Guide. For more information about managed policies
in general, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_document`: The JSON policy document that you want to use as the content for the
  new policy. You must provide policies in JSON format in IAM. However, for CloudFormation
  templates formatted in YAML, you can provide the policy in JSON or YAML format.
  CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
  The maximum length of the policy document that you can pass in this operation, including
  whitespace, is listed below. To view the maximum character counts of a managed policy with
  no whitespaces, see IAM and STS character quotas. To learn more about JSON policy grammar,
  see Grammar of the IAM JSON policy language in the IAM User Guide.  The regex pattern used
  to validate this parameter is a string of characters consisting of the following:   Any
  printable ASCII character ranging from the space character (u0020) through the end of the
  ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement
  character set (through u00FF)   The special characters tab (u0009), line feed (u000A), and
  carriage return (u000D)
- `policy_name`: The friendly name of the policy. IAM user, group, role, and policy names
  must be unique within the account. Names are not distinguished by case. For example, you
  cannot create resources named both \"MyResource\" and \"myresource\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A friendly description of the policy. Typically used to store
  information about the permissions defined in the policy. For example, \"Grants access to
  production DynamoDB tables.\" The policy description is immutable. After a value is
  assigned, it cannot be changed.
- `"Path"`: The path for the policy. For more information about paths, see IAM identifiers
  in the IAM User Guide. This parameter is optional. If it is not included, it defaults to a
  slash (/). This parameter allows (through its regex pattern) a string of characters
  consisting of either a forward slash (/) by itself or a string that must begin and end with
  forward slashes. In addition, it can contain any ASCII character from the ! (u0021) through
  the DEL character (u007F), including most punctuation characters, digits, and upper and
  lowercased letters.  You cannot use an asterisk (*) in the path name.
- `"Tags"`: A list of tags that you want to attach to the new IAM customer managed policy.
  Each tag consists of a key name and an associated value. For more information about
  tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is
  invalid or if you exceed the allowed maximum number of tags, then the entire request fails
  and the resource is not created.
"""
function create_policy(
    PolicyDocument, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreatePolicy",
        Dict{String,Any}("PolicyDocument" => PolicyDocument, "PolicyName" => PolicyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_policy(
    PolicyDocument,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreatePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument, "PolicyName" => PolicyName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_policy_version(policy_arn, policy_document)
    create_policy_version(policy_arn, policy_document, params::Dict{String,<:Any})

Creates a new version of the specified managed policy. To update a managed policy, you
create a new policy version. A managed policy can have up to five versions. If the policy
has five versions, you must delete an existing version using DeletePolicyVersion before you
create a new version. Optionally, you can set the new version as the policy's default
version. The default version is the version that is in effect for the IAM users, groups,
and roles to which the policy is attached. For more information about managed policy
versions, see Versioning for managed policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy to which you want to add a
  new version. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.
- `policy_document`: The JSON policy document that you want to use as the content for this
  new version of the policy. You must provide policies in JSON format in IAM. However, for
  CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML
  format. CloudFormation always converts a YAML policy to JSON format before submitting it to
  IAM. The maximum length of the policy document that you can pass in this operation,
  including whitespace, is listed below. To view the maximum character counts of a managed
  policy with no whitespaces, see IAM and STS character quotas. The regex pattern used to
  validate this parameter is a string of characters consisting of the following:   Any
  printable ASCII character ranging from the space character (u0020) through the end of the
  ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement
  character set (through u00FF)   The special characters tab (u0009), line feed (u000A), and
  carriage return (u000D)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SetAsDefault"`: Specifies whether to set this version as the policy's default version.
  When this parameter is true, the new policy version becomes the operative version. That is,
  it becomes the version that is in effect for the IAM users, groups, and roles that the
  policy is attached to. For more information about managed policy versions, see Versioning
  for managed policies in the IAM User Guide.
"""
function create_policy_version(
    PolicyArn, PolicyDocument; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreatePolicyVersion",
        Dict{String,Any}("PolicyArn" => PolicyArn, "PolicyDocument" => PolicyDocument);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_policy_version(
    PolicyArn,
    PolicyDocument,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreatePolicyVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyArn" => PolicyArn, "PolicyDocument" => PolicyDocument
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_role(assume_role_policy_document, role_name)
    create_role(assume_role_policy_document, role_name, params::Dict{String,<:Any})

Creates a new role for your Amazon Web Services account.  For more information about roles,
see IAM roles in the IAM User Guide. For information about quotas for role names and the
number of roles you can create, see IAM and STS quotas in the IAM User Guide.

# Arguments
- `assume_role_policy_document`: The trust relationship policy document that grants an
  entity permission to assume the role. In IAM, you must provide a JSON policy that has been
  converted to a string. However, for CloudFormation templates formatted in YAML, you can
  provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to
  JSON format before submitting it to IAM. The regex pattern used to validate this parameter
  is a string of characters consisting of the following:   Any printable ASCII character
  ranging from the space character (u0020) through the end of the ASCII character range   The
  printable characters in the Basic Latin and Latin-1 Supplement character set (through
  u00FF)   The special characters tab (u0009), line feed (u000A), and carriage return (u000D)
     Upon success, the response includes the same trust policy in JSON format.
- `role_name`: The name of the role to create. IAM user, group, role, and policy names must
  be unique within the account. Names are not distinguished by case. For example, you cannot
  create resources named both \"MyResource\" and \"myresource\". This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the role.
- `"MaxSessionDuration"`: The maximum session duration (in seconds) that you want to set
  for the specified role. If you do not specify a value for this setting, the default value
  of one hour is applied. This setting can have a value from 1 hour to 12 hours. Anyone who
  assumes the role from the CLI or API can use the DurationSeconds API parameter or the
  duration-seconds CLI parameter to request a longer session. The MaxSessionDuration setting
  determines the maximum duration that can be requested using the DurationSeconds parameter.
  If users don't specify a value for the DurationSeconds parameter, their security
  credentials are valid for one hour by default. This applies when you use the AssumeRole*
  API operations or the assume-role* CLI operations but does not apply when you use those
  operations to create a console URL. For more information, see Using IAM roles in the IAM
  User Guide.
- `"Path"`:  The path to the role. For more information about paths, see IAM Identifiers in
  the IAM User Guide. This parameter is optional. If it is not included, it defaults to a
  slash (/). This parameter allows (through its regex pattern) a string of characters
  consisting of either a forward slash (/) by itself or a string that must begin and end with
  forward slashes. In addition, it can contain any ASCII character from the ! (u0021) through
  the DEL character (u007F), including most punctuation characters, digits, and upper and
  lowercased letters.
- `"PermissionsBoundary"`: The ARN of the managed policy that is used to set the
  permissions boundary for the role. A permissions boundary policy defines the maximum
  permissions that identity-based policies can grant to an entity, but does not grant
  permissions. Permissions boundaries do not define the maximum permissions that a
  resource-based policy can grant to an entity. To learn more, see Permissions boundaries for
  IAM entities in the IAM User Guide. For more information about policy types, see Policy
  types  in the IAM User Guide.
- `"Tags"`: A list of tags that you want to attach to the new role. Each tag consists of a
  key name and an associated value. For more information about tagging, see Tagging IAM
  resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the
  allowed maximum number of tags, then the entire request fails and the resource is not
  created.
"""
function create_role(
    AssumeRolePolicyDocument, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateRole",
        Dict{String,Any}(
            "AssumeRolePolicyDocument" => AssumeRolePolicyDocument, "RoleName" => RoleName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_role(
    AssumeRolePolicyDocument,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssumeRolePolicyDocument" => AssumeRolePolicyDocument,
                    "RoleName" => RoleName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_samlprovider(name, samlmetadata_document)
    create_samlprovider(name, samlmetadata_document, params::Dict{String,<:Any})

Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
The SAML provider resource that you create with this operation can be used as a principal
in an IAM role's trust policy. Such a policy can enable federated users who sign in using
the SAML IdP to assume the role. You can create an IAM role that supports Web-based single
sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access
to Amazon Web Services. When you create the SAML provider resource, you upload a SAML
metadata document that you get from your IdP. That document includes the issuer's name,
expiration information, and keys that can be used to validate the SAML authentication
response (assertions) that the IdP sends. You must generate the metadata document using the
identity management software that is used as your organization's IdP.   This operation
requires Signature Version 4.   For more information, see Enabling SAML 2.0 federated users
to access the Amazon Web Services Management Console and About SAML 2.0-based federation in
the IAM User Guide.

# Arguments
- `name`: The name of the provider to create. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
- `samlmetadata_document`: An XML document generated by an identity provider (IdP) that
  supports SAML 2.0. The document includes the issuer's name, expiration information, and
  keys that can be used to validate the SAML authentication response (assertions) that are
  received from the IdP. You must generate the metadata document using the identity
  management software that is used as your organization's IdP. For more information, see
  About SAML 2.0-based federation in the IAM User Guide

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags that you want to attach to the new IAM SAML provider. Each tag
  consists of a key name and an associated value. For more information about tagging, see
  Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you
  exceed the allowed maximum number of tags, then the entire request fails and the resource
  is not created.
"""
function create_samlprovider(
    Name, SAMLMetadataDocument; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateSAMLProvider",
        Dict{String,Any}("Name" => Name, "SAMLMetadataDocument" => SAMLMetadataDocument);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_samlprovider(
    Name,
    SAMLMetadataDocument,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "SAMLMetadataDocument" => SAMLMetadataDocument
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_linked_role(awsservice_name)
    create_service_linked_role(awsservice_name, params::Dict{String,<:Any})

Creates an IAM role that is linked to a specific Amazon Web Services service. The service
controls the attached policies and when the role can be deleted. This helps ensure that the
service is not broken by an unexpectedly changed or deleted role, which could put your
Amazon Web Services resources into an unknown state. Allowing the service to control the
role helps improve service stability and proper cleanup when a service and its role are no
longer needed. For more information, see Using service-linked roles in the IAM User Guide.
To attach a policy to this service-linked role, you must make the request using the Amazon
Web Services service that depends on this role.

# Arguments
- `awsservice_name`: The service principal for the Amazon Web Services service to which
  this role is attached. You use a string similar to a URL but without the http:// in front.
  For example: elasticbeanstalk.amazonaws.com.  Service principals are unique and
  case-sensitive. To find the exact service principal for your service-linked role, see
  Amazon Web Services services that work with IAM in the IAM User Guide. Look for the
  services that have Yes in the Service-Linked Role column. Choose the Yes link to view the
  service-linked role documentation for that service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomSuffix"`:  A string that you provide, which is combined with the service-provided
  prefix to form the complete role name. If you make multiple requests for the same service,
  then you must supply a different CustomSuffix for each request. Otherwise the request fails
  with a duplicate role name error. For example, you could add -1 or -debug to the suffix.
  Some services do not support the CustomSuffix parameter. If you provide an optional suffix
  and the operation fails, try the operation again without the suffix.
- `"Description"`: The description of the role.
"""
function create_service_linked_role(
    AWSServiceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateServiceLinkedRole",
        Dict{String,Any}("AWSServiceName" => AWSServiceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_linked_role(
    AWSServiceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateServiceLinkedRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AWSServiceName" => AWSServiceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_specific_credential(service_name, user_name)
    create_service_specific_credential(service_name, user_name, params::Dict{String,<:Any})

Generates a set of credentials consisting of a user name and password that can be used to
access the service specified in the request. These credentials are generated by IAM, and
can be used only for the specified service.  You can have a maximum of two sets of
service-specific credentials for each supported service per user. You can create
service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache Cassandra).
You can reset the password to a new service-generated value by calling
ResetServiceSpecificCredential. For more information about service-specific credentials,
see Using IAM with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access
keys in the IAM User Guide.

# Arguments
- `service_name`: The name of the Amazon Web Services service that is to be associated with
  the credentials. The service you specify here is the only service that can be accessed
  using these credentials.
- `user_name`: The name of the IAM user that is to be associated with the credentials. The
  new service-specific credentials have the same permissions as the associated user except
  that they can be used only to access the specified service. This parameter allows (through
  its regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

"""
function create_service_specific_credential(
    ServiceName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateServiceSpecificCredential",
        Dict{String,Any}("ServiceName" => ServiceName, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_specific_credential(
    ServiceName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateServiceSpecificCredential",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServiceName" => ServiceName, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(user_name)
    create_user(user_name, params::Dict{String,<:Any})

Creates a new IAM user for your Amazon Web Services account.  For information about quotas
for the number of IAM users you can create, see IAM and STS quotas in the IAM User Guide.

# Arguments
- `user_name`: The name of the user to create. IAM user, group, role, and policy names must
  be unique within the account. Names are not distinguished by case. For example, you cannot
  create resources named both \"MyResource\" and \"myresource\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Path"`:  The path for the user name. For more information about paths, see IAM
  identifiers in the IAM User Guide. This parameter is optional. If it is not included, it
  defaults to a slash (/). This parameter allows (through its regex pattern) a string of
  characters consisting of either a forward slash (/) by itself or a string that must begin
  and end with forward slashes. In addition, it can contain any ASCII character from the !
  (u0021) through the DEL character (u007F), including most punctuation characters, digits,
  and upper and lowercased letters.
- `"PermissionsBoundary"`: The ARN of the managed policy that is used to set the
  permissions boundary for the user. A permissions boundary policy defines the maximum
  permissions that identity-based policies can grant to an entity, but does not grant
  permissions. Permissions boundaries do not define the maximum permissions that a
  resource-based policy can grant to an entity. To learn more, see Permissions boundaries for
  IAM entities in the IAM User Guide. For more information about policy types, see Policy
  types  in the IAM User Guide.
- `"Tags"`: A list of tags that you want to attach to the new user. Each tag consists of a
  key name and an associated value. For more information about tagging, see Tagging IAM
  resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the
  allowed maximum number of tags, then the entire request fails and the resource is not
  created.
"""
function create_user(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "CreateUser",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_virtual_mfadevice(virtual_mfadevice_name)
    create_virtual_mfadevice(virtual_mfadevice_name, params::Dict{String,<:Any})

Creates a new virtual MFA device for the Amazon Web Services account. After creating the
virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user. For more
information about creating and working with virtual MFA devices, see Using a virtual MFA
device in the IAM User Guide. For information about the maximum number of MFA devices you
can create, see IAM and STS quotas in the IAM User Guide.  The seed information contained
in the QR code and the Base32 string should be treated like any other secret access
information. In other words, protect the seed information as you would your Amazon Web
Services access keys or your passwords. After you provision your virtual device, you should
ensure that the information is destroyed following secure procedures.

# Arguments
- `virtual_mfadevice_name`: The name of the virtual MFA device, which must be unique. Use
  with path to uniquely identify a virtual MFA device. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Path"`:  The path for the virtual MFA device. For more information about paths, see IAM
  identifiers in the IAM User Guide. This parameter is optional. If it is not included, it
  defaults to a slash (/). This parameter allows (through its regex pattern) a string of
  characters consisting of either a forward slash (/) by itself or a string that must begin
  and end with forward slashes. In addition, it can contain any ASCII character from the !
  (u0021) through the DEL character (u007F), including most punctuation characters, digits,
  and upper and lowercased letters.
- `"Tags"`: A list of tags that you want to attach to the new IAM virtual MFA device. Each
  tag consists of a key name and an associated value. For more information about tagging, see
  Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you
  exceed the allowed maximum number of tags, then the entire request fails and the resource
  is not created.
"""
function create_virtual_mfadevice(
    VirtualMFADeviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "CreateVirtualMFADevice",
        Dict{String,Any}("VirtualMFADeviceName" => VirtualMFADeviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_virtual_mfadevice(
    VirtualMFADeviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "CreateVirtualMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VirtualMFADeviceName" => VirtualMFADeviceName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_mfadevice(serial_number, user_name)
    deactivate_mfadevice(serial_number, user_name, params::Dict{String,<:Any})

Deactivates the specified MFA device and removes it from association with the user name for
which it was originally enabled. For more information about creating and working with
virtual MFA devices, see Enabling a virtual multi-factor authentication (MFA) device in the
IAM User Guide.

# Arguments
- `serial_number`: The serial number that uniquely identifies the MFA device. For virtual
  MFA devices, the serial number is the device ARN. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: =,.@:/-
- `user_name`: The name of the user whose MFA device you want to deactivate. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function deactivate_mfadevice(
    SerialNumber, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeactivateMFADevice",
        Dict{String,Any}("SerialNumber" => SerialNumber, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_mfadevice(
    SerialNumber,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeactivateMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SerialNumber" => SerialNumber, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access_key(access_key_id)
    delete_access_key(access_key_id, params::Dict{String,<:Any})

Deletes the access key pair associated with the specified IAM user. If you do not specify a
user name, IAM determines the user name implicitly based on the Amazon Web Services access
key ID signing the request. This operation works for access keys under the Amazon Web
Services account. Consequently, you can use this operation to manage Amazon Web Services
account root user credentials even if the Amazon Web Services account has no associated
users.

# Arguments
- `access_key_id`: The access key ID for the access key ID and secret access key you want
  to delete. This parameter allows (through its regex pattern) a string of characters that
  can consist of any upper or lowercased letter or digit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the user whose access key pair you want to delete. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function delete_access_key(AccessKeyId; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeleteAccessKey",
        Dict{String,Any}("AccessKeyId" => AccessKeyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access_key(
    AccessKeyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteAccessKey",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessKeyId" => AccessKeyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_alias(account_alias)
    delete_account_alias(account_alias, params::Dict{String,<:Any})

 Deletes the specified Amazon Web Services account alias. For information about using an
Amazon Web Services account alias, see Creating, deleting, and listing an Amazon Web
Services account alias in the Amazon Web Services Sign-In User Guide.

# Arguments
- `account_alias`: The name of the account alias to delete. This parameter allows (through
  its regex pattern) a string of characters consisting of lowercase letters, digits, and
  dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.

"""
function delete_account_alias(
    AccountAlias; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteAccountAlias",
        Dict{String,Any}("AccountAlias" => AccountAlias);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_alias(
    AccountAlias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteAccountAlias",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountAlias" => AccountAlias), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_password_policy()
    delete_account_password_policy(params::Dict{String,<:Any})

Deletes the password policy for the Amazon Web Services account. There are no parameters.

"""
function delete_account_password_policy(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteAccountPasswordPolicy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_password_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteAccountPasswordPolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_group(group_name)
    delete_group(group_name, params::Dict{String,<:Any})

Deletes the specified IAM group. The group must not contain any users or have any attached
policies.

# Arguments
- `group_name`: The name of the IAM group to delete. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

"""
function delete_group(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeleteGroup",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_group(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_group_policy(group_name, policy_name)
    delete_group_policy(group_name, policy_name, params::Dict{String,<:Any})

Deletes the specified inline policy that is embedded in the specified IAM group. A group
can also have managed policies attached to it. To detach a managed policy from a group, use
DetachGroupPolicy. For more information about policies, refer to Managed policies and
inline policies in the IAM User Guide.

# Arguments
- `group_name`: The name (friendly name, not ARN) identifying the group that the policy is
  embedded in. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `policy_name`: The name identifying the policy document to delete. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function delete_group_policy(
    GroupName, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteGroupPolicy",
        Dict{String,Any}("GroupName" => GroupName, "PolicyName" => PolicyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_group_policy(
    GroupName,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "PolicyName" => PolicyName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_profile(instance_profile_name)
    delete_instance_profile(instance_profile_name, params::Dict{String,<:Any})

Deletes the specified instance profile. The instance profile must not have an associated
role.  Make sure that you do not have any Amazon EC2 instances running with the instance
profile you are about to delete. Deleting a role or instance profile that is associated
with a running instance will break any applications running on the instance.  For more
information about instance profiles, see Using instance profiles in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the instance profile to delete. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function delete_instance_profile(
    InstanceProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteInstanceProfile",
        Dict{String,Any}("InstanceProfileName" => InstanceProfileName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_profile(
    InstanceProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceProfileName" => InstanceProfileName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_login_profile(user_name)
    delete_login_profile(user_name, params::Dict{String,<:Any})

Deletes the password for the specified IAM user, For more information, see Managing
passwords for IAM users. You can use the CLI, the Amazon Web Services API, or the Users
page in the IAM console to delete a password for any IAM user. You can use ChangePassword
to update, but not delete, your own password in the My Security Credentials page in the
Amazon Web Services Management Console.  Deleting a user's password does not prevent a user
from accessing Amazon Web Services through the command line interface or the API. To
prevent all user access, you must also either make any access keys inactive or delete them.
For more information about making keys inactive or deleting them, see UpdateAccessKey and
DeleteAccessKey.

# Arguments
- `user_name`: The name of the user whose password you want to delete. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function delete_login_profile(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeleteLoginProfile",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_login_profile(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteLoginProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_open_idconnect_provider(open_idconnect_provider_arn)
    delete_open_idconnect_provider(open_idconnect_provider_arn, params::Dict{String,<:Any})

Deletes an OpenID Connect identity provider (IdP) resource object in IAM. Deleting an IAM
OIDC provider resource does not update any roles that reference the provider as a principal
in their trust policies. Any attempt to assume a role that references a deleted provider
fails. This operation is idempotent; it does not fail or return an error if you call the
operation for a provider that does not exist.

# Arguments
- `open_idconnect_provider_arn`: The Amazon Resource Name (ARN) of the IAM OpenID Connect
  provider resource object to delete. You can get a list of OpenID Connect provider resource
  ARNs by using the ListOpenIDConnectProviders operation.

"""
function delete_open_idconnect_provider(
    OpenIDConnectProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteOpenIDConnectProvider",
        Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_open_idconnect_provider(
    OpenIDConnectProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy(policy_arn)
    delete_policy(policy_arn, params::Dict{String,<:Any})

Deletes the specified managed policy. Before you can delete a managed policy, you must
first detach the policy from all users, groups, and roles that it is attached to. In
addition, you must delete all the policy's versions. The following steps describe the
process for deleting a managed policy:   Detach the policy from all users, groups, and
roles that the policy is attached to, using DetachUserPolicy, DetachGroupPolicy, or
DetachRolePolicy. To list all the users, groups, and roles that a policy is attached to,
use ListEntitiesForPolicy.   Delete all versions of the policy using DeletePolicyVersion.
To list the policy's versions, use ListPolicyVersions. You cannot use DeletePolicyVersion
to delete the version that is marked as the default version. You delete the policy's
default version in the next step of the process.   Delete the policy (this automatically
deletes the policy's default version) using this operation.   For information about managed
policies, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to delete. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.

"""
function delete_policy(PolicyArn; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeletePolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy(
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeletePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyArn" => PolicyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy_version(policy_arn, version_id)
    delete_policy_version(policy_arn, version_id, params::Dict{String,<:Any})

Deletes the specified version from the specified managed policy. You cannot delete the
default version from a policy using this operation. To delete the default version from a
policy, use DeletePolicy. To find out which version of a policy is marked as the default
version, use ListPolicyVersions. For information about versions for managed policies, see
Versioning for managed policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy from which you want to
  delete a version. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.
- `version_id`: The policy version to delete. This parameter allows (through its regex
  pattern) a string of characters that consists of the lowercase letter 'v' followed by one
  or two digits, and optionally followed by a period '.' and a string of letters and digits.
  For more information about managed policy versions, see Versioning for managed policies in
  the IAM User Guide.

"""
function delete_policy_version(
    PolicyArn, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeletePolicyVersion",
        Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy_version(
    PolicyArn,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeletePolicyVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_role(role_name)
    delete_role(role_name, params::Dict{String,<:Any})

Deletes the specified role. Unlike the Amazon Web Services Management Console, when you
delete a role programmatically, you must delete the items attached to the role manually, or
the deletion fails. For more information, see Deleting an IAM role. Before attempting to
delete a role, remove the following attached items:    Inline policies (DeleteRolePolicy)
Attached managed policies (DetachRolePolicy)   Instance profile
(RemoveRoleFromInstanceProfile)   Optional – Delete instance profile after detaching from
role for resource clean up (DeleteInstanceProfile)    Make sure that you do not have any
Amazon EC2 instances running with the role you are about to delete. Deleting a role or
instance profile that is associated with a running instance will break any applications
running on the instance.

# Arguments
- `role_name`: The name of the role to delete. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function delete_role(RoleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeleteRole",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_role(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_role_permissions_boundary(role_name)
    delete_role_permissions_boundary(role_name, params::Dict{String,<:Any})

Deletes the permissions boundary for the specified IAM role.  You cannot set the boundary
for a service-linked role.  Deleting the permissions boundary for a role might increase its
permissions. For example, it might allow anyone who assumes the role to perform all the
actions granted in its permissions policies.

# Arguments
- `role_name`: The name (friendly name, not ARN) of the IAM role from which you want to
  remove the permissions boundary.

"""
function delete_role_permissions_boundary(
    RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteRolePermissionsBoundary",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_role_permissions_boundary(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteRolePermissionsBoundary",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_role_policy(policy_name, role_name)
    delete_role_policy(policy_name, role_name, params::Dict{String,<:Any})

Deletes the specified inline policy that is embedded in the specified IAM role. A role can
also have managed policies attached to it. To detach a managed policy from a role, use
DetachRolePolicy. For more information about policies, refer to Managed policies and inline
policies in the IAM User Guide.

# Arguments
- `policy_name`: The name of the inline policy to delete from the specified IAM role. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `role_name`: The name (friendly name, not ARN) identifying the role that the policy is
  embedded in. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-

"""
function delete_role_policy(
    PolicyName, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteRolePolicy",
        Dict{String,Any}("PolicyName" => PolicyName, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_role_policy(
    PolicyName,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyName" => PolicyName, "RoleName" => RoleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_samlprovider(samlprovider_arn)
    delete_samlprovider(samlprovider_arn, params::Dict{String,<:Any})

Deletes a SAML provider resource in IAM. Deleting the provider resource from IAM does not
update any roles that reference the SAML provider resource's ARN as a principal in their
trust policies. Any attempt to assume a role that references a non-existent provider
resource ARN fails.   This operation requires Signature Version 4.

# Arguments
- `samlprovider_arn`: The Amazon Resource Name (ARN) of the SAML provider to delete.

"""
function delete_samlprovider(
    SAMLProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteSAMLProvider",
        Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_samlprovider(
    SAMLProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_server_certificate(server_certificate_name)
    delete_server_certificate(server_certificate_name, params::Dict{String,<:Any})

Deletes the specified server certificate. For more information about working with server
certificates, see Working with server certificates in the IAM User Guide. This topic also
includes a list of Amazon Web Services services that can use the server certificates that
you manage with IAM.   If you are using a server certificate with Elastic Load Balancing,
deleting the certificate could have implications for your application. If Elastic Load
Balancing doesn't detect the deletion of bound certificates, it may continue to use the
certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
recommend that you remove the reference to the certificate from Elastic Load Balancing
before using this command to delete the certificate. For more information, see
DeleteLoadBalancerListeners in the Elastic Load Balancing API Reference.

# Arguments
- `server_certificate_name`: The name of the server certificate you want to delete. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function delete_server_certificate(
    ServerCertificateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteServerCertificate",
        Dict{String,Any}("ServerCertificateName" => ServerCertificateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_server_certificate(
    ServerCertificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerCertificateName" => ServerCertificateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_linked_role(role_name)
    delete_service_linked_role(role_name, params::Dict{String,<:Any})

Submits a service-linked role deletion request and returns a DeletionTaskId, which you can
use to check the status of the deletion. Before you call this operation, confirm that the
role has no active sessions and that any resources used by the role in the linked service
are deleted. If you call this operation more than once for the same service-linked role and
an earlier deletion task is not complete, then the DeletionTaskId of the earlier request is
returned. If you submit a deletion request for a service-linked role whose linked service
is still accessing a resource, then the deletion task fails. If it fails, the
GetServiceLinkedRoleDeletionStatus operation returns the reason for the failure, usually
including the resources that must be deleted. To delete the service-linked role, you must
first remove those resources from the linked service and then submit the deletion request
again. Resources are specific to the service that is linked to the role. For more
information about removing resources from a service, see the Amazon Web Services
documentation for your service. For more information about service-linked roles, see Roles
terms and concepts: Amazon Web Services service-linked role in the IAM User Guide.

# Arguments
- `role_name`: The name of the service-linked role to be deleted.

"""
function delete_service_linked_role(
    RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteServiceLinkedRole",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_linked_role(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteServiceLinkedRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_specific_credential(service_specific_credential_id)
    delete_service_specific_credential(service_specific_credential_id, params::Dict{String,<:Any})

Deletes the specified service-specific credential.

# Arguments
- `service_specific_credential_id`: The unique identifier of the service-specific
  credential. You can get this value by calling ListServiceSpecificCredentials. This
  parameter allows (through its regex pattern) a string of characters that can consist of any
  upper or lowercased letter or digit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the IAM user associated with the service-specific credential.
  If this value is not specified, then the operation assumes the user whose credentials are
  used to call the operation. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-
"""
function delete_service_specific_credential(
    ServiceSpecificCredentialId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteServiceSpecificCredential",
        Dict{String,Any}("ServiceSpecificCredentialId" => ServiceSpecificCredentialId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_specific_credential(
    ServiceSpecificCredentialId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteServiceSpecificCredential",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServiceSpecificCredentialId" => ServiceSpecificCredentialId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_signing_certificate(certificate_id)
    delete_signing_certificate(certificate_id, params::Dict{String,<:Any})

Deletes a signing certificate associated with the specified IAM user. If you do not specify
a user name, IAM determines the user name implicitly based on the Amazon Web Services
access key ID signing the request. This operation works for access keys under the Amazon
Web Services account. Consequently, you can use this operation to manage Amazon Web
Services account root user credentials even if the Amazon Web Services account has no
associated IAM users.

# Arguments
- `certificate_id`: The ID of the signing certificate to delete. The format of this
  parameter, as described by its regex pattern, is a string of characters that can be upper-
  or lower-cased letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the user the signing certificate belongs to. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function delete_signing_certificate(
    CertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteSigningCertificate",
        Dict{String,Any}("CertificateId" => CertificateId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_signing_certificate(
    CertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteSigningCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateId" => CertificateId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sshpublic_key(sshpublic_key_id, user_name)
    delete_sshpublic_key(sshpublic_key_id, user_name, params::Dict{String,<:Any})

Deletes the specified SSH public key. The SSH public key deleted by this operation is used
only for authenticating the associated IAM user to an CodeCommit repository. For more
information about using SSH keys to authenticate to an CodeCommit repository, see Set up
CodeCommit for SSH connections in the CodeCommit User Guide.

# Arguments
- `sshpublic_key_id`: The unique identifier for the SSH public key. This parameter allows
  (through its regex pattern) a string of characters that can consist of any upper or
  lowercased letter or digit.
- `user_name`: The name of the IAM user associated with the SSH public key. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function delete_sshpublic_key(
    SSHPublicKeyId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteSSHPublicKey",
        Dict{String,Any}("SSHPublicKeyId" => SSHPublicKeyId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sshpublic_key(
    SSHPublicKeyId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteSSHPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SSHPublicKeyId" => SSHPublicKeyId, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(user_name)
    delete_user(user_name, params::Dict{String,<:Any})

Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you
delete a user programmatically, you must delete the items attached to the user manually, or
the deletion fails. For more information, see Deleting an IAM user. Before attempting to
delete a user, remove the following items:   Password (DeleteLoginProfile)   Access keys
(DeleteAccessKey)   Signing certificate (DeleteSigningCertificate)   SSH public key
(DeleteSSHPublicKey)   Git credentials (DeleteServiceSpecificCredential)   Multi-factor
authentication (MFA) device (DeactivateMFADevice, DeleteVirtualMFADevice)   Inline policies
(DeleteUserPolicy)   Attached managed policies (DetachUserPolicy)   Group memberships
(RemoveUserFromGroup)

# Arguments
- `user_name`: The name of the user to delete. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function delete_user(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "DeleteUser",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_permissions_boundary(user_name)
    delete_user_permissions_boundary(user_name, params::Dict{String,<:Any})

Deletes the permissions boundary for the specified IAM user.  Deleting the permissions
boundary for a user might increase its permissions by allowing the user to perform all the
actions granted in its permissions policies.

# Arguments
- `user_name`: The name (friendly name, not ARN) of the IAM user from which you want to
  remove the permissions boundary.

"""
function delete_user_permissions_boundary(
    UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteUserPermissionsBoundary",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_permissions_boundary(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteUserPermissionsBoundary",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_policy(policy_name, user_name)
    delete_user_policy(policy_name, user_name, params::Dict{String,<:Any})

Deletes the specified inline policy that is embedded in the specified IAM user. A user can
also have managed policies attached to it. To detach a managed policy from a user, use
DetachUserPolicy. For more information about policies, refer to Managed policies and inline
policies in the IAM User Guide.

# Arguments
- `policy_name`: The name identifying the policy document to delete. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `user_name`: The name (friendly name, not ARN) identifying the user that the policy is
  embedded in. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-

"""
function delete_user_policy(
    PolicyName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteUserPolicy",
        Dict{String,Any}("PolicyName" => PolicyName, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_policy(
    PolicyName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteUserPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyName" => PolicyName, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_virtual_mfadevice(serial_number)
    delete_virtual_mfadevice(serial_number, params::Dict{String,<:Any})

Deletes a virtual MFA device.   You must deactivate a user's virtual MFA device before you
can delete it. For information about deactivating MFA devices, see DeactivateMFADevice.

# Arguments
- `serial_number`: The serial number that uniquely identifies the MFA device. For virtual
  MFA devices, the serial number is the same as the ARN. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: =,.@:/-

"""
function delete_virtual_mfadevice(
    SerialNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DeleteVirtualMFADevice",
        Dict{String,Any}("SerialNumber" => SerialNumber);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_virtual_mfadevice(
    SerialNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DeleteVirtualMFADevice",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SerialNumber" => SerialNumber), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_group_policy(group_name, policy_arn)
    detach_group_policy(group_name, policy_arn, params::Dict{String,<:Any})

Removes the specified managed policy from the specified IAM group. A group can also have
inline policies embedded with it. To delete an inline policy, use DeleteGroupPolicy. For
information about policies, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `group_name`: The name (friendly name, not ARN) of the IAM group to detach the policy
  from. This parameter allows (through its regex pattern) a string of characters consisting
  of upper and lowercase alphanumeric characters with no spaces. You can also include any of
  the following characters: _+=,.@-
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to detach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.

"""
function detach_group_policy(
    GroupName, PolicyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DetachGroupPolicy",
        Dict{String,Any}("GroupName" => GroupName, "PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_group_policy(
    GroupName,
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DetachGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "PolicyArn" => PolicyArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_role_policy(policy_arn, role_name)
    detach_role_policy(policy_arn, role_name, params::Dict{String,<:Any})

Removes the specified managed policy from the specified role. A role can also have inline
policies embedded with it. To delete an inline policy, use DeleteRolePolicy. For
information about policies, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to detach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.
- `role_name`: The name (friendly name, not ARN) of the IAM role to detach the policy from.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

"""
function detach_role_policy(
    PolicyArn, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DetachRolePolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_role_policy(
    PolicyArn,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DetachRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "RoleName" => RoleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_user_policy(policy_arn, user_name)
    detach_user_policy(policy_arn, user_name, params::Dict{String,<:Any})

Removes the specified managed policy from the specified user. A user can also have inline
policies embedded with it. To delete an inline policy, use DeleteUserPolicy. For
information about policies, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy you want to detach. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.
- `user_name`: The name (friendly name, not ARN) of the IAM user to detach the policy from.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

"""
function detach_user_policy(
    PolicyArn, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "DetachUserPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_user_policy(
    PolicyArn,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "DetachUserPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_mfadevice(authentication_code1, authentication_code2, serial_number, user_name)
    enable_mfadevice(authentication_code1, authentication_code2, serial_number, user_name, params::Dict{String,<:Any})

Enables the specified MFA device and associates it with the specified IAM user. When
enabled, the MFA device is required for every subsequent login by the IAM user associated
with the device.

# Arguments
- `authentication_code1`: An authentication code emitted by the device.  The format for
  this parameter is a string of six digits.  Submit your request immediately after generating
  the authentication codes. If you generate the codes and then wait too long to submit the
  request, the MFA device successfully associates with the user but the MFA device becomes
  out of sync. This happens because time-based one-time passwords (TOTP) expire after a short
  period of time. If this happens, you can resync the device.
- `authentication_code2`: A subsequent authentication code emitted by the device. The
  format for this parameter is a string of six digits.  Submit your request immediately after
  generating the authentication codes. If you generate the codes and then wait too long to
  submit the request, the MFA device successfully associates with the user but the MFA device
  becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after
  a short period of time. If this happens, you can resync the device.
- `serial_number`: The serial number that uniquely identifies the MFA device. For virtual
  MFA devices, the serial number is the device ARN. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: =,.@:/-
- `user_name`: The name of the IAM user for whom you want to enable the MFA device. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function enable_mfadevice(
    AuthenticationCode1,
    AuthenticationCode2,
    SerialNumber,
    UserName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "EnableMFADevice",
        Dict{String,Any}(
            "AuthenticationCode1" => AuthenticationCode1,
            "AuthenticationCode2" => AuthenticationCode2,
            "SerialNumber" => SerialNumber,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_mfadevice(
    AuthenticationCode1,
    AuthenticationCode2,
    SerialNumber,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "EnableMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationCode1" => AuthenticationCode1,
                    "AuthenticationCode2" => AuthenticationCode2,
                    "SerialNumber" => SerialNumber,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    generate_credential_report()
    generate_credential_report(params::Dict{String,<:Any})

 Generates a credential report for the Amazon Web Services account. For more information
about the credential report, see Getting credential reports in the IAM User Guide.

"""
function generate_credential_report(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GenerateCredentialReport"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function generate_credential_report(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GenerateCredentialReport",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    generate_organizations_access_report(entity_path)
    generate_organizations_access_report(entity_path, params::Dict{String,<:Any})

Generates a report for service last accessed data for Organizations. You can generate a
report for any entities (organization root, organizational unit, or account) or policies in
your organization. To call this operation, you must be signed in using your Organizations
management account credentials. You can use your long-term IAM user or root user
credentials, or temporary credentials from assuming an IAM role. SCPs must be enabled for
your organization root. You must have the required IAM and Organizations permissions. For
more information, see Refining permissions using service last accessed data in the IAM User
Guide. You can generate a service last accessed data report for entities by specifying only
the entity's path. This data includes a list of services that are allowed by any service
control policies (SCPs) that apply to the entity. You can generate a service last accessed
data report for a policy by specifying an entity's path and an optional Organizations
policy ID. This data includes a list of services that are allowed by the specified SCP. For
each service in both report types, the data includes the most recent account activity that
the policy allows to account principals in the entity or the entity's children. For
important information about the data, reporting period, permissions required,
troubleshooting, and supported Regions see Reducing permissions using service last accessed
data in the IAM User Guide.  The data includes all attempts to access Amazon Web
Services, not just the successful ones. This includes all attempts that were made using the
Amazon Web Services Management Console, the Amazon Web Services API through any of the
SDKs, or any of the command line tools. An unexpected entry in the service last accessed
data does not mean that an account has been compromised, because the request might have
been denied. Refer to your CloudTrail logs as the authoritative source for information
about all API calls and whether they were successful or denied access. For more
information, see Logging IAM events with CloudTrail in the IAM User Guide.  This operation
returns a JobId. Use this parameter in the  GetOrganizationsAccessReport  operation to
check the status of the report generation. To check the status of this request, use the
JobId parameter in the  GetOrganizationsAccessReport  operation and test the JobStatus
response parameter. When the job is complete, you can retrieve the report. To generate a
service last accessed data report for entities, specify an entity path without specifying
the optional Organizations policy ID. The type of entity that you specify determines the
data returned in the report.    Root – When you specify the organizations root as the
entity, the resulting report lists all of the services allowed by SCPs that are attached to
your root. For each service, the report includes data for all accounts in your organization
except the management account, because the management account is not limited by SCPs.    OU
– When you specify an organizational unit (OU) as the entity, the resulting report lists
all of the services allowed by SCPs that are attached to the OU and its parents. For each
service, the report includes data for all accounts in the OU or its children. This data
excludes the management account, because the management account is not limited by SCPs.
management account – When you specify the management account, the resulting report lists
all Amazon Web Services services, because the management account is not limited by SCPs.
For each service, the report includes data for only the management account.    Account –
When you specify another account as the entity, the resulting report lists all of the
services allowed by SCPs that are attached to the account and its parents. For each
service, the report includes data for only the specified account.   To generate a service
last accessed data report for policies, specify an entity path and the optional
Organizations policy ID. The type of entity that you specify determines the data returned
for each service.    Root – When you specify the root entity and a policy ID, the
resulting report lists all of the services that are allowed by the specified SCP. For each
service, the report includes data for all accounts in your organization to which the SCP
applies. This data excludes the management account, because the management account is not
limited by SCPs. If the SCP is not attached to any entities in the organization, then the
report will return a list of services with no data.    OU – When you specify an OU entity
and a policy ID, the resulting report lists all of the services that are allowed by the
specified SCP. For each service, the report includes data for all accounts in the OU or its
children to which the SCP applies. This means that other accounts outside the OU that are
affected by the SCP might not be included in the data. This data excludes the management
account, because the management account is not limited by SCPs. If the SCP is not attached
to the OU or one of its children, the report will return a list of services with no data.
 management account – When you specify the management account, the resulting report lists
all Amazon Web Services services, because the management account is not limited by SCPs. If
you specify a policy ID in the CLI or API, the policy is ignored. For each service, the
report includes data for only the management account.    Account – When you specify
another account entity and a policy ID, the resulting report lists all of the services that
are allowed by the specified SCP. For each service, the report includes data for only the
specified account. This means that other accounts in the organization that are affected by
the SCP might not be included in the data. If the SCP is not attached to the account, the
report will return a list of services with no data.    Service last accessed data does not
use other policy types when determining whether a principal could access a service. These
other policy types include identity-based policies, resource-based policies, access control
lists, IAM permissions boundaries, and STS assume role policies. It only applies SCP logic.
For more about the evaluation of policy types, see Evaluating policies in the IAM User
Guide.  For more information about service last accessed data, see Reducing policy scope by
viewing user activity in the IAM User Guide.

# Arguments
- `entity_path`: The path of the Organizations entity (root, OU, or account). You can build
  an entity path using the known structure of your organization. For example, assume that
  your account ID is 123456789012 and its parent OU ID is ou-rge0-awsabcde. The organization
  root ID is r-f6g7h8i9j0example and your organization ID is o-a1b2c3d4e5. Your entity path
  is o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OrganizationsPolicyId"`: The identifier of the Organizations service control policy
  (SCP). This parameter is optional. This ID is used to generate information about when an
  account principal that is limited by the SCP attempted to access an Amazon Web Services
  service.
"""
function generate_organizations_access_report(
    EntityPath; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GenerateOrganizationsAccessReport",
        Dict{String,Any}("EntityPath" => EntityPath);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function generate_organizations_access_report(
    EntityPath,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GenerateOrganizationsAccessReport",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EntityPath" => EntityPath), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    generate_service_last_accessed_details(arn)
    generate_service_last_accessed_details(arn, params::Dict{String,<:Any})

Generates a report that includes details about when an IAM resource (user, group, role, or
policy) was last used in an attempt to access Amazon Web Services services. Recent activity
usually appears within four hours. IAM reports activity for at least the last 400 days, or
less if your Region began supporting this feature within the last year. For more
information, see Regions where data is tracked. For more information about services and
actions for which action last accessed information is displayed, see IAM action last
accessed information services and actions.  The service last accessed data
includes all attempts to access an Amazon Web Services API, not just the successful ones.
This includes all attempts that were made using the Amazon Web Services Management Console,
the Amazon Web Services API through any of the SDKs, or any of the command line tools. An
unexpected entry in the service last accessed data does not mean that your account has been
compromised, because the request might have been denied. Refer to your CloudTrail logs as
the authoritative source for information about all API calls and whether they were
successful or denied access. For more information, see Logging IAM events with CloudTrail
in the IAM User Guide.  The GenerateServiceLastAccessedDetails operation returns a JobId.
Use this parameter in the following operations to retrieve the following details from your
report:     GetServiceLastAccessedDetails – Use this operation for users, groups, roles,
or policies to list every Amazon Web Services service that the resource could access using
permissions policies. For each service, the response includes information about the most
recent access attempt. The JobId returned by GenerateServiceLastAccessedDetail must be used
by the same role within a session, or by the same user when used to call
GetServiceLastAccessedDetail.    GetServiceLastAccessedDetailsWithEntities – Use this
operation for groups and policies to list information about the associated entities (users
or roles) that attempted to access a specific Amazon Web Services service.    To check the
status of the GenerateServiceLastAccessedDetails request, use the JobId parameter in the
same operations and test the JobStatus response parameter. For additional information about
the permissions policies that allow an identity (user, group, or role) to access specific
services, use the ListPoliciesGrantingServiceAccess operation.  Service last accessed data
does not use other policy types when determining whether a resource could access a service.
These other policy types include resource-based policies, access control lists,
Organizations policies, IAM permissions boundaries, and STS assume role policies. It only
applies permissions policy logic. For more about the evaluation of policy types, see
Evaluating policies in the IAM User Guide.  For more information about service and action
last accessed data, see Reducing permissions using service last accessed data in the IAM
User Guide.

# Arguments
- `arn`: The ARN of the IAM resource (user, group, role, or managed policy) used to
  generate information about when the resource was last used in an attempt to access an
  Amazon Web Services service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Granularity"`: The level of detail that you want to generate. You can specify whether
  you want to generate information about the last attempt to access services or actions. If
  you specify service-level granularity, this operation generates only service data. If you
  specify action-level granularity, it generates service and action data. If you don't
  include this optional parameter, the operation generates service data.
"""
function generate_service_last_accessed_details(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GenerateServiceLastAccessedDetails",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function generate_service_last_accessed_details(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GenerateServiceLastAccessedDetails",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_access_key_last_used(access_key_id)
    get_access_key_last_used(access_key_id, params::Dict{String,<:Any})

Retrieves information about when the specified access key was last used. The information
includes the date and time of last use, along with the Amazon Web Services service and
Region that were specified in the last request made with that key.

# Arguments
- `access_key_id`: The identifier of an access key. This parameter allows (through its
  regex pattern) a string of characters that can consist of any upper or lowercased letter or
  digit.

"""
function get_access_key_last_used(
    AccessKeyId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetAccessKeyLastUsed",
        Dict{String,Any}("AccessKeyId" => AccessKeyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_access_key_last_used(
    AccessKeyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetAccessKeyLastUsed",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessKeyId" => AccessKeyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_authorization_details()
    get_account_authorization_details(params::Dict{String,<:Any})

Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web
Services account, including their relationships to one another. Use this operation to
obtain a snapshot of the configuration of IAM permissions (users, groups, roles, and
policies) in your account.  Policies returned by this operation are URL-encoded compliant
with RFC 3986. You can use a URL decoding method to convert the policy back to plain JSON
text. For example, if you use Java, you can use the decode method of the
java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide similar
functionality.  You can optionally filter the results using the Filter parameter. You can
paginate the results using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: A list of entity types used to filter the results. Only the entities that
  match the types you specify are included in the output. Use the value LocalManagedPolicy to
  include customer managed policies. The format for this parameter is a comma-separated (if
  more than one) list of strings. Each string value in the list must be one of the valid
  values listed below.
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function get_account_authorization_details(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetAccountAuthorizationDetails";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_account_authorization_details(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetAccountAuthorizationDetails",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_password_policy()
    get_account_password_policy(params::Dict{String,<:Any})

Retrieves the password policy for the Amazon Web Services account. This tells you the
complexity requirements and mandatory rotation periods for the IAM user passwords in your
account. For more information about using a password policy, see Managing an IAM password
policy.

"""
function get_account_password_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetAccountPasswordPolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_password_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetAccountPasswordPolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_summary()
    get_account_summary(params::Dict{String,<:Any})

Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services
account.  For information about IAM quotas, see IAM and STS quotas in the IAM User Guide.

"""
function get_account_summary(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("GetAccountSummary"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_account_summary(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetAccountSummary", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_context_keys_for_custom_policy(policy_input_list)
    get_context_keys_for_custom_policy(policy_input_list, params::Dict{String,<:Any})

Gets a list of all of the context keys referenced in the input policies. The policies are
supplied as a list of one or more strings. To get the context keys from policies associated
with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy. Context keys are
variables maintained by Amazon Web Services and its services that provide details about the
context of an API query request. Context keys can be evaluated by testing against a value
specified in an IAM policy. Use GetContextKeysForCustomPolicy to understand what key names
and values you must supply when you call SimulateCustomPolicy. Note that all parameters are
shown in unencoded form here for clarity but must be URL encoded to be included as a part
of a real HTML request.

# Arguments
- `policy_input_list`: A list of policies for which you want the list of context keys
  referenced in those policies. Each document is specified as a string containing the
  complete, valid JSON text of an IAM policy. The regex pattern used to validate this
  parameter is a string of characters consisting of the following:   Any printable ASCII
  character ranging from the space character (u0020) through the end of the ASCII character
  range   The printable characters in the Basic Latin and Latin-1 Supplement character set
  (through u00FF)   The special characters tab (u0009), line feed (u000A), and carriage
  return (u000D)

"""
function get_context_keys_for_custom_policy(
    PolicyInputList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetContextKeysForCustomPolicy",
        Dict{String,Any}("PolicyInputList" => PolicyInputList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_context_keys_for_custom_policy(
    PolicyInputList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetContextKeysForCustomPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("PolicyInputList" => PolicyInputList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_context_keys_for_principal_policy(policy_source_arn)
    get_context_keys_for_principal_policy(policy_source_arn, params::Dict{String,<:Any})

Gets a list of all of the context keys referenced in all the IAM policies that are attached
to the specified IAM entity. The entity can be an IAM user, group, or role. If you specify
a user, then the request also includes all of the policies attached to groups that the user
is a member of. You can optionally include a list of one or more additional policies,
specified as strings. If you want to include only a list of policies by string, use
GetContextKeysForCustomPolicy instead.  Note: This operation discloses information about
the permissions granted to other users. If you do not want users to see other user's
permissions, then consider allowing them to use GetContextKeysForCustomPolicy instead.
Context keys are variables maintained by Amazon Web Services and its services that provide
details about the context of an API query request. Context keys can be evaluated by testing
against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy to understand what
key names and values you must supply when you call SimulatePrincipalPolicy.

# Arguments
- `policy_source_arn`: The ARN of a user, group, or role whose policies contain the context
  keys that you want listed. If you specify a user, the list includes context keys that are
  found in all policies that are attached to the user. The list also includes all groups that
  the user is a member of. If you pick a group or a role, then it includes only those context
  keys that are found in policies attached to that entity. Note that all parameters are shown
  in unencoded form here for clarity, but must be URL encoded to be included as a part of a
  real HTML request. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PolicyInputList"`: An optional list of additional policies for which you want the list
  of context keys that are referenced. The regex pattern used to validate this parameter is a
  string of characters consisting of the following:   Any printable ASCII character ranging
  from the space character (u0020) through the end of the ASCII character range   The
  printable characters in the Basic Latin and Latin-1 Supplement character set (through
  u00FF)   The special characters tab (u0009), line feed (u000A), and carriage return (u000D)
  
"""
function get_context_keys_for_principal_policy(
    PolicySourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetContextKeysForPrincipalPolicy",
        Dict{String,Any}("PolicySourceArn" => PolicySourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_context_keys_for_principal_policy(
    PolicySourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetContextKeysForPrincipalPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("PolicySourceArn" => PolicySourceArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_credential_report()
    get_credential_report(params::Dict{String,<:Any})

 Retrieves a credential report for the Amazon Web Services account. For more information
about the credential report, see Getting credential reports in the IAM User Guide.

"""
function get_credential_report(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetCredentialReport"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_credential_report(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetCredentialReport",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_group(group_name)
    get_group(group_name, params::Dict{String,<:Any})

 Returns a list of IAM users that are in the specified IAM group. You can paginate the
results using the MaxItems and Marker parameters.

# Arguments
- `group_name`: The name of the group. This parameter allows (through its regex pattern) a
  string of characters consisting of upper and lowercase alphanumeric characters with no
  spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function get_group(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetGroup",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_group(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_group_policy(group_name, policy_name)
    get_group_policy(group_name, policy_name, params::Dict{String,<:Any})

Retrieves the specified inline policy document that is embedded in the specified IAM group.
 Policies returned by this operation are URL-encoded compliant with RFC 3986. You can use a
URL decoding method to convert the policy back to plain JSON text. For example, if you use
Java, you can use the decode method of the java.net.URLDecoder utility class in the Java
SDK. Other languages and SDKs provide similar functionality.  An IAM group can also have
managed policies attached to it. To retrieve a managed policy document that is attached to
a group, use GetPolicy to determine the policy's default version, then use GetPolicyVersion
to retrieve the policy document. For more information about policies, see Managed policies
and inline policies in the IAM User Guide.

# Arguments
- `group_name`: The name of the group the policy is associated with. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `policy_name`: The name of the policy document to get. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

"""
function get_group_policy(
    GroupName, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetGroupPolicy",
        Dict{String,Any}("GroupName" => GroupName, "PolicyName" => PolicyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_group_policy(
    GroupName,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "PolicyName" => PolicyName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_profile(instance_profile_name)
    get_instance_profile(instance_profile_name, params::Dict{String,<:Any})

 Retrieves information about the specified instance profile, including the instance
profile's path, GUID, ARN, and role. For more information about instance profiles, see
Using instance profiles in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the instance profile to get information about. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_instance_profile(
    InstanceProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetInstanceProfile",
        Dict{String,Any}("InstanceProfileName" => InstanceProfileName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_profile(
    InstanceProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceProfileName" => InstanceProfileName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_login_profile(user_name)
    get_login_profile(user_name, params::Dict{String,<:Any})

Retrieves the user name for the specified IAM user. A login profile is created when you
create a password for the user to access the Amazon Web Services Management Console. If the
user does not exist or does not have a password, the operation returns a 404 (NoSuchEntity)
error. If you create an IAM user with access to the console, the CreateDate reflects the
date you created the initial password for the user. If you create an IAM user with
programmatic access, and then later add a password for the user to access the Amazon Web
Services Management Console, the CreateDate reflects the initial password creation date. A
user with programmatic access does not have a login profile unless you create a password
for the user to access the Amazon Web Services Management Console.

# Arguments
- `user_name`: The name of the user whose login profile you want to retrieve. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_login_profile(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetLoginProfile",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_login_profile(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetLoginProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_mfadevice(serial_number)
    get_mfadevice(serial_number, params::Dict{String,<:Any})

Retrieves information about an MFA device for a specified user.

# Arguments
- `serial_number`: Serial number that uniquely identifies the MFA device. For this API, we
  only accept FIDO security key ARNs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The friendly name identifying the user.
"""
function get_mfadevice(SerialNumber; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetMFADevice",
        Dict{String,Any}("SerialNumber" => SerialNumber);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_mfadevice(
    SerialNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetMFADevice",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SerialNumber" => SerialNumber), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_open_idconnect_provider(open_idconnect_provider_arn)
    get_open_idconnect_provider(open_idconnect_provider_arn, params::Dict{String,<:Any})

Returns information about the specified OpenID Connect (OIDC) provider resource object in
IAM.

# Arguments
- `open_idconnect_provider_arn`: The Amazon Resource Name (ARN) of the OIDC provider
  resource object in IAM to get information for. You can get a list of OIDC provider resource
  ARNs by using the ListOpenIDConnectProviders operation. For more information about ARNs,
  see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.

"""
function get_open_idconnect_provider(
    OpenIDConnectProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetOpenIDConnectProvider",
        Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_open_idconnect_provider(
    OpenIDConnectProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_organizations_access_report(job_id)
    get_organizations_access_report(job_id, params::Dict{String,<:Any})

Retrieves the service last accessed data report for Organizations that was previously
generated using the  GenerateOrganizationsAccessReport  operation. This operation retrieves
the status of your report job and the report contents. Depending on the parameters that you
passed when you generated the report, the data returned could include different
information. For details, see GenerateOrganizationsAccessReport. To call this operation,
you must be signed in to the management account in your organization. SCPs must be enabled
for your organization root. You must have permissions to perform this operation. For more
information, see Refining permissions using service last accessed data in the IAM User
Guide. For each service that principals in an account (root user, IAM users, or IAM roles)
could access using SCPs, the operation returns details about the most recent access
attempt. If there was no attempt, the service is listed without details about the most
recent attempt to access the service. If the operation fails, it returns the reason that it
failed. By default, the list is sorted by service namespace.

# Arguments
- `job_id`: The identifier of the request generated by the
  GenerateOrganizationsAccessReport operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"SortKey"`: The key that is used to sort the results. If you choose the namespace key,
  the results are returned in alphabetical order. If you choose the time key, the results are
  sorted numerically by the date and time.
"""
function get_organizations_access_report(
    JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetOrganizationsAccessReport",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_organizations_access_report(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetOrganizationsAccessReport",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy(policy_arn)
    get_policy(policy_arn, params::Dict{String,<:Any})

Retrieves information about the specified managed policy, including the policy's default
version and the total number of IAM users, groups, and roles to which the policy is
attached. To retrieve the list of the specific users, groups, and roles that the policy is
attached to, use ListEntitiesForPolicy. This operation returns metadata about the policy.
To retrieve the actual policy document for a specific version of the policy, use
GetPolicyVersion. This operation retrieves information about managed policies. To retrieve
information about an inline policy that is embedded with an IAM user, group, or role, use
GetUserPolicy, GetGroupPolicy, or GetRolePolicy. For more information about policies, see
Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the managed policy that you want
  information about. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.

"""
function get_policy(PolicyArn; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy(
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyArn" => PolicyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy_version(policy_arn, version_id)
    get_policy_version(policy_arn, version_id, params::Dict{String,<:Any})

Retrieves information about the specified version of the specified managed policy,
including the policy document.  Policies returned by this operation are URL-encoded
compliant with RFC 3986. You can use a URL decoding method to convert the policy back to
plain JSON text. For example, if you use Java, you can use the decode method of the
java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide similar
functionality.  To list the available versions for a policy, use ListPolicyVersions. This
operation retrieves information about managed policies. To retrieve information about an
inline policy that is embedded in a user, group, or role, use GetUserPolicy,
GetGroupPolicy, or GetRolePolicy. For more information about the types of policies, see
Managed policies and inline policies in the IAM User Guide. For more information about
managed policy versions, see Versioning for managed policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the managed policy that you want
  information about. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.
- `version_id`: Identifies the policy version to retrieve. This parameter allows (through
  its regex pattern) a string of characters that consists of the lowercase letter 'v'
  followed by one or two digits, and optionally followed by a period '.' and a string of
  letters and digits.

"""
function get_policy_version(
    PolicyArn, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetPolicyVersion",
        Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy_version(
    PolicyArn,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetPolicyVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_role(role_name)
    get_role(role_name, params::Dict{String,<:Any})

Retrieves information about the specified role, including the role's path, GUID, ARN, and
the role's trust policy that grants permission to assume the role. For more information
about roles, see IAM roles in the IAM User Guide.  Policies returned by this operation are
URL-encoded compliant with RFC 3986. You can use a URL decoding method to convert the
policy back to plain JSON text. For example, if you use Java, you can use the decode method
of the java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide
similar functionality.

# Arguments
- `role_name`: The name of the IAM role to get information about. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_role(RoleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "GetRole",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_role(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_role_policy(policy_name, role_name)
    get_role_policy(policy_name, role_name, params::Dict{String,<:Any})

Retrieves the specified inline policy document that is embedded with the specified IAM
role.  Policies returned by this operation are URL-encoded compliant with RFC 3986. You can
use a URL decoding method to convert the policy back to plain JSON text. For example, if
you use Java, you can use the decode method of the java.net.URLDecoder utility class in the
Java SDK. Other languages and SDKs provide similar functionality.  An IAM role can also
have managed policies attached to it. To retrieve a managed policy document that is
attached to a role, use GetPolicy to determine the policy's default version, then use
GetPolicyVersion to retrieve the policy document. For more information about policies, see
Managed policies and inline policies in the IAM User Guide.  For more information about
roles, see IAM roles in the IAM User Guide.

# Arguments
- `policy_name`: The name of the policy document to get. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-
- `role_name`: The name of the role associated with the policy. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_role_policy(
    PolicyName, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetRolePolicy",
        Dict{String,Any}("PolicyName" => PolicyName, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_role_policy(
    PolicyName,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyName" => PolicyName, "RoleName" => RoleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_samlprovider(samlprovider_arn)
    get_samlprovider(samlprovider_arn, params::Dict{String,<:Any})

Returns the SAML provider metadocument that was uploaded when the IAM SAML provider
resource object was created or updated.  This operation requires Signature Version 4.

# Arguments
- `samlprovider_arn`: The Amazon Resource Name (ARN) of the SAML provider resource object
  in IAM to get information about. For more information about ARNs, see Amazon Resource Names
  (ARNs) in the Amazon Web Services General Reference.

"""
function get_samlprovider(
    SAMLProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetSAMLProvider",
        Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_samlprovider(
    SAMLProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_server_certificate(server_certificate_name)
    get_server_certificate(server_certificate_name, params::Dict{String,<:Any})

Retrieves information about the specified server certificate stored in IAM. For more
information about working with server certificates, see Working with server certificates in
the IAM User Guide. This topic includes a list of Amazon Web Services services that can use
the server certificates that you manage with IAM.

# Arguments
- `server_certificate_name`: The name of the server certificate you want to retrieve
  information about. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-

"""
function get_server_certificate(
    ServerCertificateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetServerCertificate",
        Dict{String,Any}("ServerCertificateName" => ServerCertificateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_server_certificate(
    ServerCertificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerCertificateName" => ServerCertificateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_last_accessed_details(job_id)
    get_service_last_accessed_details(job_id, params::Dict{String,<:Any})

Retrieves a service last accessed report that was created using the
GenerateServiceLastAccessedDetails operation. You can use the JobId parameter in
GetServiceLastAccessedDetails to retrieve the status of your report job. When the report is
complete, you can retrieve the generated report. The report includes a list of Amazon Web
Services services that the resource (user, group, role, or managed policy) can access.
Service last accessed data does not use other policy types when determining whether a
resource could access a service. These other policy types include resource-based policies,
access control lists, Organizations policies, IAM permissions boundaries, and STS assume
role policies. It only applies permissions policy logic. For more about the evaluation of
policy types, see Evaluating policies in the IAM User Guide.  For each service that the
resource could access using permissions policies, the operation returns details about the
most recent access attempt. If there was no attempt, the service is listed without details
about the most recent attempt to access the service. If the operation fails, the
GetServiceLastAccessedDetails operation returns the reason that it failed. The
GetServiceLastAccessedDetails operation returns a list of services. This list includes the
number of entities that have attempted to access the service and the date and time of the
last attempt. It also returns the ARN of the following entity, depending on the resource
ARN that you used to generate the report:    User – Returns the user ARN that you used to
generate the report    Group – Returns the ARN of the group member (user) that last
attempted to access the service    Role – Returns the role ARN that you used to generate
the report    Policy – Returns the ARN of the user or role that last used the policy to
attempt to access the service   By default, the list is sorted by service namespace. If you
specified ACTION_LEVEL granularity when you generated the report, this operation returns
service and action last accessed data. This includes the most recent access attempt for
each tracked action within a service. Otherwise, this operation returns only service data.
For more information about service and action last accessed data, see Reducing permissions
using service last accessed data in the IAM User Guide.

# Arguments
- `job_id`: The ID of the request generated by the GenerateServiceLastAccessedDetails
  operation. The JobId returned by GenerateServiceLastAccessedDetail must be used by the same
  role within a session, or by the same user when used to call GetServiceLastAccessedDetail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function get_service_last_accessed_details(
    JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetServiceLastAccessedDetails",
        Dict{String,Any}("JobId" => JobId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_last_accessed_details(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetServiceLastAccessedDetails",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("JobId" => JobId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_last_accessed_details_with_entities(job_id, service_namespace)
    get_service_last_accessed_details_with_entities(job_id, service_namespace, params::Dict{String,<:Any})

After you generate a group or policy report using the GenerateServiceLastAccessedDetails
operation, you can use the JobId parameter in GetServiceLastAccessedDetailsWithEntities.
This operation retrieves the status of your report job and a list of entities that could
have used group or policy permissions to access the specified service.    Group – For a
group report, this operation returns a list of users in the group that could have used the
group’s policies in an attempt to access the service.    Policy – For a policy report,
this operation returns a list of entities (users or roles) that could have used the policy
in an attempt to access the service.   You can also use this operation for user or role
reports to retrieve details about those entities. If the operation fails, the
GetServiceLastAccessedDetailsWithEntities operation returns the reason that it failed. By
default, the list of associated entities is sorted by date, with the most recent access
listed first.

# Arguments
- `job_id`: The ID of the request generated by the GenerateServiceLastAccessedDetails
  operation.
- `service_namespace`: The service namespace for an Amazon Web Services service. Provide
  the service namespace to learn when the IAM entity last attempted to access the specified
  service. To learn the service namespace for a service, see Actions, resources, and
  condition keys for Amazon Web Services services in the IAM User Guide. Choose the name of
  the service to view details for that service. In the first paragraph, find the service
  prefix. For example, (service prefix: a4b). For more information about service namespaces,
  see Amazon Web Services service namespaces in the Amazon Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function get_service_last_accessed_details_with_entities(
    JobId, ServiceNamespace; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetServiceLastAccessedDetailsWithEntities",
        Dict{String,Any}("JobId" => JobId, "ServiceNamespace" => ServiceNamespace);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_last_accessed_details_with_entities(
    JobId,
    ServiceNamespace,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetServiceLastAccessedDetailsWithEntities",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("JobId" => JobId, "ServiceNamespace" => ServiceNamespace),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_linked_role_deletion_status(deletion_task_id)
    get_service_linked_role_deletion_status(deletion_task_id, params::Dict{String,<:Any})

Retrieves the status of your service-linked role deletion. After you use
DeleteServiceLinkedRole to submit a service-linked role for deletion, you can use the
DeletionTaskId parameter in GetServiceLinkedRoleDeletionStatus to check the status of the
deletion. If the deletion fails, this operation returns the reason that it failed, if that
information is returned by the service.

# Arguments
- `deletion_task_id`: The deletion task identifier. This identifier is returned by the
  DeleteServiceLinkedRole operation in the format
  task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;.

"""
function get_service_linked_role_deletion_status(
    DeletionTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetServiceLinkedRoleDeletionStatus",
        Dict{String,Any}("DeletionTaskId" => DeletionTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_linked_role_deletion_status(
    DeletionTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetServiceLinkedRoleDeletionStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeletionTaskId" => DeletionTaskId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sshpublic_key(encoding, sshpublic_key_id, user_name)
    get_sshpublic_key(encoding, sshpublic_key_id, user_name, params::Dict{String,<:Any})

Retrieves the specified SSH public key, including metadata about the key. The SSH public
key retrieved by this operation is used only for authenticating the associated IAM user to
an CodeCommit repository. For more information about using SSH keys to authenticate to an
CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User
Guide.

# Arguments
- `encoding`: Specifies the public key encoding format to use in the response. To retrieve
  the public key in ssh-rsa format, use SSH. To retrieve the public key in PEM format, use
  PEM.
- `sshpublic_key_id`: The unique identifier for the SSH public key. This parameter allows
  (through its regex pattern) a string of characters that can consist of any upper or
  lowercased letter or digit.
- `user_name`: The name of the IAM user associated with the SSH public key. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_sshpublic_key(
    Encoding, SSHPublicKeyId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetSSHPublicKey",
        Dict{String,Any}(
            "Encoding" => Encoding,
            "SSHPublicKeyId" => SSHPublicKeyId,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sshpublic_key(
    Encoding,
    SSHPublicKeyId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetSSHPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Encoding" => Encoding,
                    "SSHPublicKeyId" => SSHPublicKeyId,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user()
    get_user(params::Dict{String,<:Any})

Retrieves information about the specified IAM user, including the user's creation date,
path, unique ID, and ARN. If you do not specify a user name, IAM determines the user name
implicitly based on the Amazon Web Services access key ID used to sign the request to this
operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the user to get information about. This parameter is optional.
  If it is not included, it defaults to the user making the request. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function get_user(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("GetUser"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_user(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam("GetUser", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    get_user_policy(policy_name, user_name)
    get_user_policy(policy_name, user_name, params::Dict{String,<:Any})

Retrieves the specified inline policy document that is embedded in the specified IAM user.
Policies returned by this operation are URL-encoded compliant with RFC 3986. You can use a
URL decoding method to convert the policy back to plain JSON text. For example, if you use
Java, you can use the decode method of the java.net.URLDecoder utility class in the Java
SDK. Other languages and SDKs provide similar functionality.  An IAM user can also have
managed policies attached to it. To retrieve a managed policy document that is attached to
a user, use GetPolicy to determine the policy's default version. Then use GetPolicyVersion
to retrieve the policy document. For more information about policies, see Managed policies
and inline policies in the IAM User Guide.

# Arguments
- `policy_name`: The name of the policy document to get. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-
- `user_name`: The name of the user who the policy is associated with. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function get_user_policy(
    PolicyName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "GetUserPolicy",
        Dict{String,Any}("PolicyName" => PolicyName, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user_policy(
    PolicyName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "GetUserPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyName" => PolicyName, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_access_keys()
    list_access_keys(params::Dict{String,<:Any})

Returns information about the access key IDs associated with the specified IAM user. If
there is none, the operation returns an empty list. Although each user is limited to a
small number of keys, you can still paginate the results using the MaxItems and Marker
parameters. If the UserName is not specified, the user name is determined implicitly based
on the Amazon Web Services access key ID used to sign the request. If a temporary access
key is used, then UserName is required. If a long-term key is assigned to the user, then
UserName is not required. This operation works for access keys under the Amazon Web
Services account. If the Amazon Web Services account has no associated users, the root user
returns it's own access key IDs by running this command.  To ensure the security of your
Amazon Web Services account, the secret access key is accessible only during key and user
creation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"UserName"`: The name of the user. This parameter allows (through its regex pattern) a
  string of characters consisting of upper and lowercase alphanumeric characters with no
  spaces. You can also include any of the following characters: _+=,.@-
"""
function list_access_keys(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListAccessKeys"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_access_keys(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListAccessKeys", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_account_aliases()
    list_account_aliases(params::Dict{String,<:Any})

Lists the account alias associated with the Amazon Web Services account (Note: you can have
only one). For information about using an Amazon Web Services account alias, see Creating,
deleting, and listing an Amazon Web Services account alias in the Amazon Web Services
Sign-In User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_account_aliases(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListAccountAliases"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_account_aliases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListAccountAliases", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_attached_group_policies(group_name)
    list_attached_group_policies(group_name, params::Dict{String,<:Any})

Lists all managed policies that are attached to the specified IAM group. An IAM group can
also have inline policies embedded with it. To list the inline policies for a group, use
ListGroupPolicies. For information about policies, see Managed policies and inline policies
in the IAM User Guide. You can paginate the results using the MaxItems and Marker
parameters. You can use the PathPrefix parameter to limit the list of policies to only
those matching the specified path prefix. If there are no policies attached to the
specified group (or none that match the specified path prefix), the operation returns an
empty list.

# Arguments
- `group_name`: The name (friendly name, not ARN) of the group to list attached policies
  for. This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`: The path prefix for filtering the results. This parameter is optional. If
  it is not included, it defaults to a slash (/), listing all policies. This parameter allows
  (through its regex pattern) a string of characters consisting of either a forward slash (/)
  by itself or a string that must begin and end with forward slashes. In addition, it can
  contain any ASCII character from the ! (u0021) through the DEL character (u007F), including
  most punctuation characters, digits, and upper and lowercased letters.
"""
function list_attached_group_policies(
    GroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListAttachedGroupPolicies",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attached_group_policies(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListAttachedGroupPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attached_role_policies(role_name)
    list_attached_role_policies(role_name, params::Dict{String,<:Any})

Lists all managed policies that are attached to the specified IAM role. An IAM role can
also have inline policies embedded with it. To list the inline policies for a role, use
ListRolePolicies. For information about policies, see Managed policies and inline policies
in the IAM User Guide. You can paginate the results using the MaxItems and Marker
parameters. You can use the PathPrefix parameter to limit the list of policies to only
those matching the specified path prefix. If there are no policies attached to the
specified role (or none that match the specified path prefix), the operation returns an
empty list.

# Arguments
- `role_name`: The name (friendly name, not ARN) of the role to list attached policies for.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`: The path prefix for filtering the results. This parameter is optional. If
  it is not included, it defaults to a slash (/), listing all policies. This parameter allows
  (through its regex pattern) a string of characters consisting of either a forward slash (/)
  by itself or a string that must begin and end with forward slashes. In addition, it can
  contain any ASCII character from the ! (u0021) through the DEL character (u007F), including
  most punctuation characters, digits, and upper and lowercased letters.
"""
function list_attached_role_policies(
    RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListAttachedRolePolicies",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attached_role_policies(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListAttachedRolePolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attached_user_policies(user_name)
    list_attached_user_policies(user_name, params::Dict{String,<:Any})

Lists all managed policies that are attached to the specified IAM user. An IAM user can
also have inline policies embedded with it. To list the inline policies for a user, use
ListUserPolicies. For information about policies, see Managed policies and inline policies
in the IAM User Guide. You can paginate the results using the MaxItems and Marker
parameters. You can use the PathPrefix parameter to limit the list of policies to only
those matching the specified path prefix. If there are no policies attached to the
specified group (or none that match the specified path prefix), the operation returns an
empty list.

# Arguments
- `user_name`: The name (friendly name, not ARN) of the user to list attached policies for.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`: The path prefix for filtering the results. This parameter is optional. If
  it is not included, it defaults to a slash (/), listing all policies. This parameter allows
  (through its regex pattern) a string of characters consisting of either a forward slash (/)
  by itself or a string that must begin and end with forward slashes. In addition, it can
  contain any ASCII character from the ! (u0021) through the DEL character (u007F), including
  most punctuation characters, digits, and upper and lowercased letters.
"""
function list_attached_user_policies(
    UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListAttachedUserPolicies",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attached_user_policies(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListAttachedUserPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_entities_for_policy(policy_arn)
    list_entities_for_policy(policy_arn, params::Dict{String,<:Any})

Lists all IAM users, groups, and roles that the specified managed policy is attached to.
You can use the optional EntityFilter parameter to limit the results to a particular type
of entity (users, groups, or roles). For example, to list only the roles that are attached
to the specified policy, set EntityFilter to Role. You can paginate the results using the
MaxItems and Marker parameters.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy for which you want the
  versions. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon
  Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EntityFilter"`: The entity type to use for filtering the results. For example, when
  EntityFilter is Role, only the roles that are attached to the specified policy are
  returned. This parameter is optional. If it is not included, all attached entities (users,
  groups, and roles) are returned. The argument for this parameter must be one of the valid
  values listed below.
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`: The path prefix for filtering the results. This parameter is optional. If
  it is not included, it defaults to a slash (/), listing all entities. This parameter allows
  (through its regex pattern) a string of characters consisting of either a forward slash (/)
  by itself or a string that must begin and end with forward slashes. In addition, it can
  contain any ASCII character from the ! (u0021) through the DEL character (u007F), including
  most punctuation characters, digits, and upper and lowercased letters.
- `"PolicyUsageFilter"`: The policy usage method to use for filtering the results. To list
  only permissions policies, set PolicyUsageFilter to PermissionsPolicy. To list only the
  policies used to set permissions boundaries, set the value to PermissionsBoundary. This
  parameter is optional. If it is not included, all policies are returned.
"""
function list_entities_for_policy(
    PolicyArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListEntitiesForPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_entities_for_policy(
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListEntitiesForPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyArn" => PolicyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_group_policies(group_name)
    list_group_policies(group_name, params::Dict{String,<:Any})

Lists the names of the inline policies that are embedded in the specified IAM group. An IAM
group can also have managed policies attached to it. To list the managed policies that are
attached to a group, use ListAttachedGroupPolicies. For more information about policies,
see Managed policies and inline policies in the IAM User Guide. You can paginate the
results using the MaxItems and Marker parameters. If there are no inline policies embedded
with the specified group, the operation returns an empty list.

# Arguments
- `group_name`: The name of the group to list policies for. This parameter allows (through
  its regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_group_policies(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListGroupPolicies",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_group_policies(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListGroupPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_groups()
    list_groups(params::Dict{String,<:Any})

Lists the IAM groups that have the specified path prefix.  You can paginate the results
using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`:  The path prefix for filtering the results. For example, the prefix
  /division_abc/subdivision_xyz/ gets all groups whose path starts with
  /division_abc/subdivision_xyz/. This parameter is optional. If it is not included, it
  defaults to a slash (/), listing all groups. This parameter allows (through its regex
  pattern) a string of characters consisting of either a forward slash (/) by itself or a
  string that must begin and end with forward slashes. In addition, it can contain any ASCII
  character from the ! (u0021) through the DEL character (u007F), including most punctuation
  characters, digits, and upper and lowercased letters.
"""
function list_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam("ListGroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    list_groups_for_user(user_name)
    list_groups_for_user(user_name, params::Dict{String,<:Any})

Lists the IAM groups that the specified IAM user belongs to. You can paginate the results
using the MaxItems and Marker parameters.

# Arguments
- `user_name`: The name of the user to list groups for. This parameter allows (through its
  regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_groups_for_user(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListGroupsForUser",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_groups_for_user(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListGroupsForUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instance_profile_tags(instance_profile_name)
    list_instance_profile_tags(instance_profile_name, params::Dict{String,<:Any})

Lists the tags that are attached to the specified IAM instance profile. The returned list
of tags is sorted by tag key. For more information about tagging, see Tagging IAM resources
in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the IAM instance profile whose tags you want to see.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_instance_profile_tags(
    InstanceProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListInstanceProfileTags",
        Dict{String,Any}("InstanceProfileName" => InstanceProfileName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instance_profile_tags(
    InstanceProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListInstanceProfileTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceProfileName" => InstanceProfileName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instance_profiles()
    list_instance_profiles(params::Dict{String,<:Any})

Lists the instance profiles that have the specified path prefix. If there are none, the
operation returns an empty list. For more information about instance profiles, see Using
instance profiles in the IAM User Guide.  IAM resource-listing operations return a subset
of the available attributes for the resource. For example, this operation does not return
tags, even though they are an attribute of the returned object. To view all of the
information for an instance profile, see GetInstanceProfile.  You can paginate the results
using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`:  The path prefix for filtering the results. For example, the prefix
  /application_abc/component_xyz/ gets all instance profiles whose path starts with
  /application_abc/component_xyz/. This parameter is optional. If it is not included, it
  defaults to a slash (/), listing all instance profiles. This parameter allows (through its
  regex pattern) a string of characters consisting of either a forward slash (/) by itself or
  a string that must begin and end with forward slashes. In addition, it can contain any
  ASCII character from the ! (u0021) through the DEL character (u007F), including most
  punctuation characters, digits, and upper and lowercased letters.
"""
function list_instance_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListInstanceProfiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_instance_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListInstanceProfiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_instance_profiles_for_role(role_name)
    list_instance_profiles_for_role(role_name, params::Dict{String,<:Any})

Lists the instance profiles that have the specified associated IAM role. If there are none,
the operation returns an empty list. For more information about instance profiles, go to
Using instance profiles in the IAM User Guide. You can paginate the results using the
MaxItems and Marker parameters.

# Arguments
- `role_name`: The name of the role to list instance profiles for. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_instance_profiles_for_role(
    RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListInstanceProfilesForRole",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_instance_profiles_for_role(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListInstanceProfilesForRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_mfadevice_tags(serial_number)
    list_mfadevice_tags(serial_number, params::Dict{String,<:Any})

Lists the tags that are attached to the specified IAM virtual multi-factor authentication
(MFA) device. The returned list of tags is sorted by tag key. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.

# Arguments
- `serial_number`: The unique identifier for the IAM virtual MFA device whose tags you want
  to see. For virtual MFA devices, the serial number is the same as the ARN. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_mfadevice_tags(
    SerialNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListMFADeviceTags",
        Dict{String,Any}("SerialNumber" => SerialNumber);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_mfadevice_tags(
    SerialNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListMFADeviceTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SerialNumber" => SerialNumber), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_mfadevices()
    list_mfadevices(params::Dict{String,<:Any})

Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this
operation lists all the MFA devices associated with the specified user. If you do not
specify a user name, IAM determines the user name implicitly based on the Amazon Web
Services access key ID signing the request for this operation. You can paginate the results
using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"UserName"`: The name of the user whose MFA devices you want to list. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function list_mfadevices(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListMFADevices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_mfadevices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListMFADevices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_open_idconnect_provider_tags(open_idconnect_provider_arn)
    list_open_idconnect_provider_tags(open_idconnect_provider_arn, params::Dict{String,<:Any})

Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity
provider. The returned list of tags is sorted by tag key. For more information, see About
web identity federation. For more information about tagging, see Tagging IAM resources in
the IAM User Guide.

# Arguments
- `open_idconnect_provider_arn`: The ARN of the OpenID Connect (OIDC) identity provider
  whose tags you want to see. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_open_idconnect_provider_tags(
    OpenIDConnectProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListOpenIDConnectProviderTags",
        Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_open_idconnect_provider_tags(
    OpenIDConnectProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListOpenIDConnectProviderTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OpenIDConnectProviderArn" => OpenIDConnectProviderArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_open_idconnect_providers()
    list_open_idconnect_providers(params::Dict{String,<:Any})

Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in
the Amazon Web Services account.  IAM resource-listing operations return a subset of the
available attributes for the resource. For example, this operation does not return tags,
even though they are an attribute of the returned object. To view all of the information
for an OIDC provider, see GetOpenIDConnectProvider.

"""
function list_open_idconnect_providers(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListOpenIDConnectProviders"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_open_idconnect_providers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListOpenIDConnectProviders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policies()
    list_policies(params::Dict{String,<:Any})

Lists all the managed policies that are available in your Amazon Web Services account,
including your own customer-defined managed policies and all Amazon Web Services managed
policies. You can filter the list of policies that is returned using the optional
OnlyAttached, Scope, and PathPrefix parameters. For example, to list only the customer
managed policies in your Amazon Web Services account, set Scope to Local. To list only
Amazon Web Services managed policies, set Scope to AWS. You can paginate the results using
the MaxItems and Marker parameters. For more information about managed policies, see
Managed policies and inline policies in the IAM User Guide.  IAM resource-listing
operations return a subset of the available attributes for the resource. For example, this
operation does not return tags, even though they are an attribute of the returned object.
To view all of the information for a customer manged policy, see GetPolicy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"OnlyAttached"`: A flag to filter the results to only the attached policies. When
  OnlyAttached is true, the returned list contains only the policies that are attached to an
  IAM user, group, or role. When OnlyAttached is false, or when the parameter is not
  included, all policies are returned.
- `"PathPrefix"`: The path prefix for filtering the results. This parameter is optional. If
  it is not included, it defaults to a slash (/), listing all policies. This parameter allows
  (through its regex pattern) a string of characters consisting of either a forward slash (/)
  by itself or a string that must begin and end with forward slashes. In addition, it can
  contain any ASCII character from the ! (u0021) through the DEL character (u007F), including
  most punctuation characters, digits, and upper and lowercased letters.
- `"PolicyUsageFilter"`: The policy usage method to use for filtering the results. To list
  only permissions policies, set PolicyUsageFilter to PermissionsPolicy. To list only the
  policies used to set permissions boundaries, set the value to PermissionsBoundary. This
  parameter is optional. If it is not included, all policies are returned.
- `"Scope"`: The scope to use for filtering the results. To list only Amazon Web Services
  managed policies, set Scope to AWS. To list only the customer managed policies in your
  Amazon Web Services account, set Scope to Local. This parameter is optional. If it is not
  included, or if it is set to All, all policies are returned.
"""
function list_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListPolicies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListPolicies", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_policies_granting_service_access(arn, service_namespaces)
    list_policies_granting_service_access(arn, service_namespaces, params::Dict{String,<:Any})

Retrieves a list of policies that the IAM identity (user, group, or role) can use to access
each specified service.  This operation does not use other policy types when determining
whether a resource could access a service. These other policy types include resource-based
policies, access control lists, Organizations policies, IAM permissions boundaries, and STS
assume role policies. It only applies permissions policy logic. For more about the
evaluation of policy types, see Evaluating policies in the IAM User Guide.  The list of
policies returned by the operation depends on the ARN of the identity that you provide.
User – The list of policies includes the managed and inline policies that are attached to
the user directly. The list also includes any additional managed and inline policies that
are attached to the group to which the user belongs.     Group – The list of policies
includes only the managed and inline policies that are attached to the group directly.
Policies that are attached to the group’s user are not included.    Role – The list of
policies includes only the managed and inline policies that are attached to the role.   For
each managed policy, this operation returns the ARN and policy name. For each inline
policy, it returns the policy name and the entity to which it is attached. Inline policies
do not have an ARN. For more information about these policy types, see Managed policies and
inline policies in the IAM User Guide. Policies that are attached to users and roles as
permissions boundaries are not returned. To view which managed policy is currently used to
set the permissions boundary for a user or role, use the GetUser or GetRole operations.

# Arguments
- `arn`: The ARN of the IAM identity (user, group, or role) whose policies you want to list.
- `service_namespaces`: The service namespace for the Amazon Web Services services whose
  policies you want to list. To learn the service namespace for a service, see Actions,
  resources, and condition keys for Amazon Web Services services in the IAM User Guide.
  Choose the name of the service to view details for that service. In the first paragraph,
  find the service prefix. For example, (service prefix: a4b). For more information about
  service namespaces, see Amazon Web Services service namespaces in the Amazon Web Services
  General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
"""
function list_policies_granting_service_access(
    Arn, ServiceNamespaces; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListPoliciesGrantingServiceAccess",
        Dict{String,Any}("Arn" => Arn, "ServiceNamespaces" => ServiceNamespaces);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policies_granting_service_access(
    Arn,
    ServiceNamespaces,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListPoliciesGrantingServiceAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Arn" => Arn, "ServiceNamespaces" => ServiceNamespaces),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policy_tags(policy_arn)
    list_policy_tags(policy_arn, params::Dict{String,<:Any})

Lists the tags that are attached to the specified IAM customer managed policy. The returned
list of tags is sorted by tag key. For more information about tagging, see Tagging IAM
resources in the IAM User Guide.

# Arguments
- `policy_arn`: The ARN of the IAM customer managed policy whose tags you want to see. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_policy_tags(PolicyArn; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListPolicyTags",
        Dict{String,Any}("PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policy_tags(
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListPolicyTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyArn" => PolicyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policy_versions(policy_arn)
    list_policy_versions(policy_arn, params::Dict{String,<:Any})

Lists information about the versions of the specified managed policy, including the version
that is currently set as the policy's default version. For more information about managed
policies, see Managed policies and inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy for which you want the
  versions. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon
  Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_policy_versions(PolicyArn; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListPolicyVersions",
        Dict{String,Any}("PolicyArn" => PolicyArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policy_versions(
    PolicyArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListPolicyVersions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyArn" => PolicyArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_role_policies(role_name)
    list_role_policies(role_name, params::Dict{String,<:Any})

Lists the names of the inline policies that are embedded in the specified IAM role. An IAM
role can also have managed policies attached to it. To list the managed policies that are
attached to a role, use ListAttachedRolePolicies. For more information about policies, see
Managed policies and inline policies in the IAM User Guide. You can paginate the results
using the MaxItems and Marker parameters. If there are no inline policies embedded with the
specified role, the operation returns an empty list.

# Arguments
- `role_name`: The name of the role to list policies for. This parameter allows (through
  its regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_role_policies(RoleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListRolePolicies",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_role_policies(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListRolePolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_role_tags(role_name)
    list_role_tags(role_name, params::Dict{String,<:Any})

Lists the tags that are attached to the specified role. The returned list of tags is sorted
by tag key. For more information about tagging, see Tagging IAM resources in the IAM User
Guide.

# Arguments
- `role_name`: The name of the IAM role for which you want to see the list of tags. This
  parameter accepts (through its regex pattern) a string of characters that consist of upper
  and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_role_tags(RoleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListRoleTags",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_role_tags(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListRoleTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_roles()
    list_roles(params::Dict{String,<:Any})

Lists the IAM roles that have the specified path prefix. If there are none, the operation
returns an empty list. For more information about roles, see IAM roles in the IAM User
Guide.  IAM resource-listing operations return a subset of the available attributes for the
resource. This operation does not return the following attributes, even though they are an
attribute of the returned object:   PermissionsBoundary   RoleLastUsed   Tags   To view all
of the information for a role, see GetRole.  You can paginate the results using the
MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`:  The path prefix for filtering the results. For example, the prefix
  /application_abc/component_xyz/ gets all roles whose path starts with
  /application_abc/component_xyz/. This parameter is optional. If it is not included, it
  defaults to a slash (/), listing all roles. This parameter allows (through its regex
  pattern) a string of characters consisting of either a forward slash (/) by itself or a
  string that must begin and end with forward slashes. In addition, it can contain any ASCII
  character from the ! (u0021) through the DEL character (u007F), including most punctuation
  characters, digits, and upper and lowercased letters.
"""
function list_roles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListRoles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_roles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam("ListRoles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    list_samlprovider_tags(samlprovider_arn)
    list_samlprovider_tags(samlprovider_arn, params::Dict{String,<:Any})

Lists the tags that are attached to the specified Security Assertion Markup Language (SAML)
identity provider. The returned list of tags is sorted by tag key. For more information,
see About SAML 2.0-based federation. For more information about tagging, see Tagging IAM
resources in the IAM User Guide.

# Arguments
- `samlprovider_arn`: The ARN of the Security Assertion Markup Language (SAML) identity
  provider whose tags you want to see. This parameter allows (through its regex pattern) a
  string of characters consisting of upper and lowercase alphanumeric characters with no
  spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_samlprovider_tags(
    SAMLProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListSAMLProviderTags",
        Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_samlprovider_tags(
    SAMLProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListSAMLProviderTags",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_samlproviders()
    list_samlproviders(params::Dict{String,<:Any})

Lists the SAML provider resource objects defined in IAM in the account. IAM
resource-listing operations return a subset of the available attributes for the resource.
For example, this operation does not return tags, even though they are an attribute of the
returned object. To view all of the information for a SAML provider, see GetSAMLProvider.
This operation requires Signature Version 4.

"""
function list_samlproviders(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListSAMLProviders"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_samlproviders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListSAMLProviders", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_server_certificate_tags(server_certificate_name)
    list_server_certificate_tags(server_certificate_name, params::Dict{String,<:Any})

Lists the tags that are attached to the specified IAM server certificate. The returned list
of tags is sorted by tag key. For more information about tagging, see Tagging IAM resources
in the IAM User Guide.  For certificates in a Region supported by Certificate Manager
(ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to
provision, manage, and deploy your server certificates. For more information about IAM
server certificates, Working with server certificates in the IAM User Guide.

# Arguments
- `server_certificate_name`: The name of the IAM server certificate whose tags you want to
  see. This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_server_certificate_tags(
    ServerCertificateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListServerCertificateTags",
        Dict{String,Any}("ServerCertificateName" => ServerCertificateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_server_certificate_tags(
    ServerCertificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListServerCertificateTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerCertificateName" => ServerCertificateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_server_certificates()
    list_server_certificates(params::Dict{String,<:Any})

Lists the server certificates stored in IAM that have the specified path prefix. If none
exist, the operation returns an empty list.  You can paginate the results using the
MaxItems and Marker parameters. For more information about working with server
certificates, see Working with server certificates in the IAM User Guide. This topic also
includes a list of Amazon Web Services services that can use the server certificates that
you manage with IAM.  IAM resource-listing operations return a subset of the available
attributes for the resource. For example, this operation does not return tags, even though
they are an attribute of the returned object. To view all of the information for a
servercertificate, see GetServerCertificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`:  The path prefix for filtering the results. For example:
  /company/servercerts would get all server certificates for which the path starts with
  /company/servercerts. This parameter is optional. If it is not included, it defaults to a
  slash (/), listing all server certificates. This parameter allows (through its regex
  pattern) a string of characters consisting of either a forward slash (/) by itself or a
  string that must begin and end with forward slashes. In addition, it can contain any ASCII
  character from the ! (u0021) through the DEL character (u007F), including most punctuation
  characters, digits, and upper and lowercased letters.
"""
function list_server_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListServerCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_server_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListServerCertificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_specific_credentials()
    list_service_specific_credentials(params::Dict{String,<:Any})

Returns information about the service-specific credentials associated with the specified
IAM user. If none exists, the operation returns an empty list. The service-specific
credentials returned by this operation are used only for authenticating the IAM user to a
specific service. For more information about using service-specific credentials to
authenticate to an Amazon Web Services service, see Set up service-specific credentials in
the CodeCommit User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ServiceName"`: Filters the returned results to only those for the specified Amazon Web
  Services service. If not specified, then Amazon Web Services returns service-specific
  credentials for all services.
- `"UserName"`: The name of the user whose service-specific credentials you want
  information about. If this value is not specified, then the operation assumes the user
  whose credentials are used to call the operation. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
"""
function list_service_specific_credentials(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListServiceSpecificCredentials";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_service_specific_credentials(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListServiceSpecificCredentials",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_signing_certificates()
    list_signing_certificates(params::Dict{String,<:Any})

Returns information about the signing certificates associated with the specified IAM user.
If none exists, the operation returns an empty list. Although each user is limited to a
small number of signing certificates, you can still paginate the results using the MaxItems
and Marker parameters. If the UserName field is not specified, the user name is determined
implicitly based on the Amazon Web Services access key ID used to sign the request for this
operation. This operation works for access keys under the Amazon Web Services account.
Consequently, you can use this operation to manage Amazon Web Services account root user
credentials even if the Amazon Web Services account has no associated users.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"UserName"`: The name of the IAM user whose signing certificates you want to examine.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-
"""
function list_signing_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListSigningCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_signing_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListSigningCertificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sshpublic_keys()
    list_sshpublic_keys(params::Dict{String,<:Any})

Returns information about the SSH public keys associated with the specified IAM user. If
none exists, the operation returns an empty list. The SSH public keys returned by this
operation are used only for authenticating the IAM user to an CodeCommit repository. For
more information about using SSH keys to authenticate to an CodeCommit repository, see Set
up CodeCommit for SSH connections in the CodeCommit User Guide. Although each user is
limited to a small number of keys, you can still paginate the results using the MaxItems
and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"UserName"`: The name of the IAM user to list SSH public keys for. If none is specified,
  the UserName field is determined implicitly based on the Amazon Web Services access key
  used to sign the request. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-
"""
function list_sshpublic_keys(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListSSHPublicKeys"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_sshpublic_keys(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListSSHPublicKeys", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_user_policies(user_name)
    list_user_policies(user_name, params::Dict{String,<:Any})

Lists the names of the inline policies embedded in the specified IAM user. An IAM user can
also have managed policies attached to it. To list the managed policies that are attached
to a user, use ListAttachedUserPolicies. For more information about policies, see Managed
policies and inline policies in the IAM User Guide. You can paginate the results using the
MaxItems and Marker parameters. If there are no inline policies embedded with the specified
user, the operation returns an empty list.

# Arguments
- `user_name`: The name of the user to list policies for. This parameter allows (through
  its regex pattern) a string of characters consisting of upper and lowercase alphanumeric
  characters with no spaces. You can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_user_policies(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListUserPolicies",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_user_policies(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListUserPolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_user_tags(user_name)
    list_user_tags(user_name, params::Dict{String,<:Any})

Lists the tags that are attached to the specified IAM user. The returned list of tags is
sorted by tag key. For more information about tagging, see Tagging IAM resources in the IAM
User Guide.

# Arguments
- `user_name`: The name of the IAM user whose tags you want to see. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_user_tags(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListUserTags",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_user_tags(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ListUserTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users()
    list_users(params::Dict{String,<:Any})

Lists the IAM users that have the specified path prefix. If no path prefix is specified,
the operation returns all users in the Amazon Web Services account. If there are none, the
operation returns an empty list.  IAM resource-listing operations return a subset of the
available attributes for the resource. This operation does not return the following
attributes, even though they are an attribute of the returned object:   PermissionsBoundary
  Tags   To view all of the information for a user, see GetUser.  You can paginate the
results using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PathPrefix"`:  The path prefix for filtering the results. For example:
  /division_abc/subdivision_xyz/, which would get all user names whose path starts with
  /division_abc/subdivision_xyz/. This parameter is optional. If it is not included, it
  defaults to a slash (/), listing all user names. This parameter allows (through its regex
  pattern) a string of characters consisting of either a forward slash (/) by itself or a
  string that must begin and end with forward slashes. In addition, it can contain any ASCII
  character from the ! (u0021) through the DEL character (u007F), including most punctuation
  characters, digits, and upper and lowercased letters.
"""
function list_users(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam("ListUsers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_users(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam("ListUsers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    list_virtual_mfadevices()
    list_virtual_mfadevices(params::Dict{String,<:Any})

Lists the virtual MFA devices defined in the Amazon Web Services account by assignment
status. If you do not specify an assignment status, the operation returns a list of all
virtual MFA devices. Assignment status can be Assigned, Unassigned, or Any.  IAM
resource-listing operations return a subset of the available attributes for the resource.
For example, this operation does not return tags, even though they are an attribute of the
returned object. To view tag information for a virtual MFA device, see ListMFADeviceTags.
You can paginate the results using the MaxItems and Marker parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssignmentStatus"`:  The status (Unassigned or Assigned) of the devices to list. If you
  do not specify an AssignmentStatus, the operation defaults to Any, which lists both
  assigned and unassigned virtual MFA devices.,
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
"""
function list_virtual_mfadevices(; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "ListVirtualMFADevices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_virtual_mfadevices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ListVirtualMFADevices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_group_policy(group_name, policy_document, policy_name)
    put_group_policy(group_name, policy_document, policy_name, params::Dict{String,<:Any})

Adds or updates an inline policy document that is embedded in the specified IAM group. A
user can also have managed policies attached to it. To attach a managed policy to a group,
use  AttachGroupPolicy . To create a new managed policy, use  CreatePolicy . For
information about policies, see Managed policies and inline policies in the IAM User Guide.
For information about the maximum number of inline policies that you can embed in a group,
see IAM and STS quotas in the IAM User Guide.  Because policy documents can be large, you
should use POST rather than GET when calling PutGroupPolicy. For general information about
using the Query API with IAM, see Making query requests in the IAM User Guide.

# Arguments
- `group_name`: The name of the group to associate the policy with. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-.
- `policy_document`: The policy document. You must provide policies in JSON format in IAM.
  However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON
  or YAML format. CloudFormation always converts a YAML policy to JSON format before
  submitting it to IAM. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `policy_name`: The name of the policy document. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function put_group_policy(
    GroupName,
    PolicyDocument,
    PolicyName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutGroupPolicy",
        Dict{String,Any}(
            "GroupName" => GroupName,
            "PolicyDocument" => PolicyDocument,
            "PolicyName" => PolicyName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_group_policy(
    GroupName,
    PolicyDocument,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GroupName" => GroupName,
                    "PolicyDocument" => PolicyDocument,
                    "PolicyName" => PolicyName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_role_permissions_boundary(permissions_boundary, role_name)
    put_role_permissions_boundary(permissions_boundary, role_name, params::Dict{String,<:Any})

Adds or updates the policy that is specified as the IAM role's permissions boundary. You
can use an Amazon Web Services managed policy or a customer managed policy to set the
boundary for a role. Use the boundary to control the maximum permissions that the role can
have. Setting a permissions boundary is an advanced feature that can affect the permissions
for the role. You cannot set the boundary for a service-linked role.  Policies used as
permissions boundaries do not provide permissions. You must also attach a permissions
policy to the role. To learn how the effective permissions for a role are evaluated, see
IAM JSON policy evaluation logic in the IAM User Guide.

# Arguments
- `permissions_boundary`: The ARN of the managed policy that is used to set the permissions
  boundary for the role. A permissions boundary policy defines the maximum permissions that
  identity-based policies can grant to an entity, but does not grant permissions. Permissions
  boundaries do not define the maximum permissions that a resource-based policy can grant to
  an entity. To learn more, see Permissions boundaries for IAM entities in the IAM User
  Guide. For more information about policy types, see Policy types  in the IAM User Guide.
- `role_name`: The name (friendly name, not ARN) of the IAM role for which you want to set
  the permissions boundary.

"""
function put_role_permissions_boundary(
    PermissionsBoundary, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "PutRolePermissionsBoundary",
        Dict{String,Any}(
            "PermissionsBoundary" => PermissionsBoundary, "RoleName" => RoleName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_role_permissions_boundary(
    PermissionsBoundary,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutRolePermissionsBoundary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PermissionsBoundary" => PermissionsBoundary, "RoleName" => RoleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_role_policy(policy_document, policy_name, role_name)
    put_role_policy(policy_document, policy_name, role_name, params::Dict{String,<:Any})

Adds or updates an inline policy document that is embedded in the specified IAM role. When
you embed an inline policy in a role, the inline policy is used as part of the role's
access (permissions) policy. The role's trust policy is created at the same time as the
role, using  CreateRole . You can update a role's trust policy using
UpdateAssumeRolePolicy . For more information about roles, see IAM roles in the IAM User
Guide. A role can also have a managed policy attached to it. To attach a managed policy to
a role, use  AttachRolePolicy . To create a new managed policy, use  CreatePolicy . For
information about policies, see Managed policies and inline policies in the IAM User Guide.
For information about the maximum number of inline policies that you can embed with a role,
see IAM and STS quotas in the IAM User Guide.  Because policy documents can be large, you
should use POST rather than GET when calling PutRolePolicy. For general information about
using the Query API with IAM, see Making query requests in the IAM User Guide.

# Arguments
- `policy_document`: The policy document. You must provide policies in JSON format in IAM.
  However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON
  or YAML format. CloudFormation always converts a YAML policy to JSON format before
  submitting it to IAM. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `policy_name`: The name of the policy document. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
- `role_name`: The name of the role to associate the policy with. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function put_role_policy(
    PolicyDocument, PolicyName, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "PutRolePolicy",
        Dict{String,Any}(
            "PolicyDocument" => PolicyDocument,
            "PolicyName" => PolicyName,
            "RoleName" => RoleName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_role_policy(
    PolicyDocument,
    PolicyName,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument,
                    "PolicyName" => PolicyName,
                    "RoleName" => RoleName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_user_permissions_boundary(permissions_boundary, user_name)
    put_user_permissions_boundary(permissions_boundary, user_name, params::Dict{String,<:Any})

Adds or updates the policy that is specified as the IAM user's permissions boundary. You
can use an Amazon Web Services managed policy or a customer managed policy to set the
boundary for a user. Use the boundary to control the maximum permissions that the user can
have. Setting a permissions boundary is an advanced feature that can affect the permissions
for the user.  Policies that are used as permissions boundaries do not provide permissions.
You must also attach a permissions policy to the user. To learn how the effective
permissions for a user are evaluated, see IAM JSON policy evaluation logic in the IAM User
Guide.

# Arguments
- `permissions_boundary`: The ARN of the managed policy that is used to set the permissions
  boundary for the user. A permissions boundary policy defines the maximum permissions that
  identity-based policies can grant to an entity, but does not grant permissions. Permissions
  boundaries do not define the maximum permissions that a resource-based policy can grant to
  an entity. To learn more, see Permissions boundaries for IAM entities in the IAM User
  Guide. For more information about policy types, see Policy types  in the IAM User Guide.
- `user_name`: The name (friendly name, not ARN) of the IAM user for which you want to set
  the permissions boundary.

"""
function put_user_permissions_boundary(
    PermissionsBoundary, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "PutUserPermissionsBoundary",
        Dict{String,Any}(
            "PermissionsBoundary" => PermissionsBoundary, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_user_permissions_boundary(
    PermissionsBoundary,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutUserPermissionsBoundary",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PermissionsBoundary" => PermissionsBoundary, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_user_policy(policy_document, policy_name, user_name)
    put_user_policy(policy_document, policy_name, user_name, params::Dict{String,<:Any})

Adds or updates an inline policy document that is embedded in the specified IAM user. An
IAM user can also have a managed policy attached to it. To attach a managed policy to a
user, use  AttachUserPolicy . To create a new managed policy, use  CreatePolicy . For
information about policies, see Managed policies and inline policies in the IAM User Guide.
For information about the maximum number of inline policies that you can embed in a user,
see IAM and STS quotas in the IAM User Guide.  Because policy documents can be large, you
should use POST rather than GET when calling PutUserPolicy. For general information about
using the Query API with IAM, see Making query requests in the IAM User Guide.

# Arguments
- `policy_document`: The policy document. You must provide policies in JSON format in IAM.
  However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON
  or YAML format. CloudFormation always converts a YAML policy to JSON format before
  submitting it to IAM. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `policy_name`: The name of the policy document. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
- `user_name`: The name of the user to associate the policy with. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function put_user_policy(
    PolicyDocument, PolicyName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "PutUserPolicy",
        Dict{String,Any}(
            "PolicyDocument" => PolicyDocument,
            "PolicyName" => PolicyName,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_user_policy(
    PolicyDocument,
    PolicyName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "PutUserPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument,
                    "PolicyName" => PolicyName,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_client_idfrom_open_idconnect_provider(client_id, open_idconnect_provider_arn)
    remove_client_idfrom_open_idconnect_provider(client_id, open_idconnect_provider_arn, params::Dict{String,<:Any})

Removes the specified client ID (also known as audience) from the list of client IDs
registered for the specified IAM OpenID Connect (OIDC) provider resource object. This
operation is idempotent; it does not fail or return an error if you try to remove a client
ID that does not exist.

# Arguments
- `client_id`: The client ID (also known as audience) to remove from the IAM OIDC provider
  resource. For more information about client IDs, see CreateOpenIDConnectProvider.
- `open_idconnect_provider_arn`: The Amazon Resource Name (ARN) of the IAM OIDC provider
  resource to remove the client ID from. You can get a list of OIDC provider ARNs by using
  the ListOpenIDConnectProviders operation. For more information about ARNs, see Amazon
  Resource Names (ARNs) in the Amazon Web Services General Reference.

"""
function remove_client_idfrom_open_idconnect_provider(
    ClientID, OpenIDConnectProviderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "RemoveClientIDFromOpenIDConnectProvider",
        Dict{String,Any}(
            "ClientID" => ClientID, "OpenIDConnectProviderArn" => OpenIDConnectProviderArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_client_idfrom_open_idconnect_provider(
    ClientID,
    OpenIDConnectProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "RemoveClientIDFromOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientID" => ClientID,
                    "OpenIDConnectProviderArn" => OpenIDConnectProviderArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_role_from_instance_profile(instance_profile_name, role_name)
    remove_role_from_instance_profile(instance_profile_name, role_name, params::Dict{String,<:Any})

Removes the specified IAM role from the specified Amazon EC2 instance profile.  Make sure
that you do not have any Amazon EC2 instances running with the role you are about to remove
from the instance profile. Removing a role from an instance profile that is associated with
a running instance might break any applications running on the instance.   For more
information about roles, see IAM roles in the IAM User Guide. For more information about
instance profiles, see Using instance profiles in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the instance profile to update. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `role_name`: The name of the role to remove. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function remove_role_from_instance_profile(
    InstanceProfileName, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "RemoveRoleFromInstanceProfile",
        Dict{String,Any}(
            "InstanceProfileName" => InstanceProfileName, "RoleName" => RoleName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_role_from_instance_profile(
    InstanceProfileName,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "RemoveRoleFromInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceProfileName" => InstanceProfileName, "RoleName" => RoleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_user_from_group(group_name, user_name)
    remove_user_from_group(group_name, user_name, params::Dict{String,<:Any})

Removes the specified user from the specified group.

# Arguments
- `group_name`: The name of the group to update. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-
- `user_name`: The name of the user to remove. This parameter allows (through its regex
  pattern) a string of characters consisting of upper and lowercase alphanumeric characters
  with no spaces. You can also include any of the following characters: _+=,.@-

"""
function remove_user_from_group(
    GroupName, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "RemoveUserFromGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_user_from_group(
    GroupName,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "RemoveUserFromGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_service_specific_credential(service_specific_credential_id)
    reset_service_specific_credential(service_specific_credential_id, params::Dict{String,<:Any})

Resets the password for a service-specific credential. The new password is Amazon Web
Services generated and cryptographically strong. It cannot be configured by the user.
Resetting the password immediately invalidates the previous password associated with this
user.

# Arguments
- `service_specific_credential_id`: The unique identifier of the service-specific
  credential. This parameter allows (through its regex pattern) a string of characters that
  can consist of any upper or lowercased letter or digit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the IAM user associated with the service-specific credential.
  If this value is not specified, then the operation assumes the user whose credentials are
  used to call the operation. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-
"""
function reset_service_specific_credential(
    ServiceSpecificCredentialId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "ResetServiceSpecificCredential",
        Dict{String,Any}("ServiceSpecificCredentialId" => ServiceSpecificCredentialId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_service_specific_credential(
    ServiceSpecificCredentialId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ResetServiceSpecificCredential",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServiceSpecificCredentialId" => ServiceSpecificCredentialId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resync_mfadevice(authentication_code1, authentication_code2, serial_number, user_name)
    resync_mfadevice(authentication_code1, authentication_code2, serial_number, user_name, params::Dict{String,<:Any})

Synchronizes the specified MFA device with its IAM resource object on the Amazon Web
Services servers. For more information about creating and working with virtual MFA devices,
see Using a virtual MFA device in the IAM User Guide.

# Arguments
- `authentication_code1`: An authentication code emitted by the device. The format for this
  parameter is a sequence of six digits.
- `authentication_code2`: A subsequent authentication code emitted by the device. The
  format for this parameter is a sequence of six digits.
- `serial_number`: Serial number that uniquely identifies the MFA device. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `user_name`: The name of the user whose MFA device you want to resynchronize. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function resync_mfadevice(
    AuthenticationCode1,
    AuthenticationCode2,
    SerialNumber,
    UserName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ResyncMFADevice",
        Dict{String,Any}(
            "AuthenticationCode1" => AuthenticationCode1,
            "AuthenticationCode2" => AuthenticationCode2,
            "SerialNumber" => SerialNumber,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resync_mfadevice(
    AuthenticationCode1,
    AuthenticationCode2,
    SerialNumber,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "ResyncMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationCode1" => AuthenticationCode1,
                    "AuthenticationCode2" => AuthenticationCode2,
                    "SerialNumber" => SerialNumber,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_default_policy_version(policy_arn, version_id)
    set_default_policy_version(policy_arn, version_id, params::Dict{String,<:Any})

Sets the specified version of the specified policy as the policy's default (operative)
version. This operation affects all users, groups, and roles that the policy is attached
to. To list the users, groups, and roles that the policy is attached to, use
ListEntitiesForPolicy. For information about managed policies, see Managed policies and
inline policies in the IAM User Guide.

# Arguments
- `policy_arn`: The Amazon Resource Name (ARN) of the IAM policy whose default version you
  want to set. For more information about ARNs, see Amazon Resource Names (ARNs) in the
  Amazon Web Services General Reference.
- `version_id`: The version of the policy to set as the default (operative) version. For
  more information about managed policy versions, see Versioning for managed policies in the
  IAM User Guide.

"""
function set_default_policy_version(
    PolicyArn, VersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "SetDefaultPolicyVersion",
        Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_default_policy_version(
    PolicyArn,
    VersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "SetDefaultPolicyVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "VersionId" => VersionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_security_token_service_preferences(global_endpoint_token_version)
    set_security_token_service_preferences(global_endpoint_token_version, params::Dict{String,<:Any})

Sets the specified version of the global endpoint token as the token version used for the
Amazon Web Services account. By default, Security Token Service (STS) is available as a
global service, and all STS requests go to a single endpoint at https://sts.amazonaws.com.
Amazon Web Services recommends using Regional STS endpoints to reduce latency, build in
redundancy, and increase session token availability. For information about Regional
endpoints for STS, see Security Token Service endpoints and quotas in the Amazon Web
Services General Reference. If you make an STS call to the global endpoint, the resulting
session tokens might be valid in some Regions but not others. It depends on the version
that is set in this operation. Version 1 tokens are valid only in Amazon Web Services
Regions that are available by default. These tokens do not work in manually enabled
Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions.
However, version 2 tokens are longer and might affect systems where you temporarily store
tokens. For information, see Activating and deactivating STS in an Amazon Web Services
Region in the IAM User Guide. To view the current session token version, see the
GlobalEndpointTokenVersion entry in the response of the GetAccountSummary operation.

# Arguments
- `global_endpoint_token_version`: The version of the global endpoint token. Version 1
  tokens are valid only in Amazon Web Services Regions that are available by default. These
  tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2
  tokens are valid in all Regions. However, version 2 tokens are longer and might affect
  systems where you temporarily store tokens. For information, see Activating and
  deactivating STS in an Amazon Web Services Region in the IAM User Guide.

"""
function set_security_token_service_preferences(
    GlobalEndpointTokenVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "SetSecurityTokenServicePreferences",
        Dict{String,Any}("GlobalEndpointTokenVersion" => GlobalEndpointTokenVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_security_token_service_preferences(
    GlobalEndpointTokenVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "SetSecurityTokenServicePreferences",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalEndpointTokenVersion" => GlobalEndpointTokenVersion
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    simulate_custom_policy(action_names, policy_input_list)
    simulate_custom_policy(action_names, policy_input_list, params::Dict{String,<:Any})

Simulate how a set of IAM policies and optionally a resource-based policy works with a list
of API operations and Amazon Web Services resources to determine the policies' effective
permissions. The policies are provided as strings. The simulation does not perform the API
operations; it only checks the authorization to determine if the simulated policies allow
or deny the operations. You can simulate resources that don't exist in your account. If you
want to simulate existing policies that are attached to an IAM user, group, or role, use
SimulatePrincipalPolicy instead. Context keys are variables that are maintained by Amazon
Web Services and its services and which provide details about the context of an API query
request. You can use the Condition element of an IAM policy to evaluate context keys. To
get the list of context keys that the policies require for correct simulation, use
GetContextKeysForCustomPolicy. If the output is long, you can use MaxItems and Marker
parameters to paginate the results.  The IAM policy simulator evaluates statements in the
identity-based policy and the inputs that you provide during simulation. The policy
simulator results can differ from your live Amazon Web Services environment. We recommend
that you check your policies against your live Amazon Web Services environment after
testing using the policy simulator to confirm that you have the desired results. For more
information about using the policy simulator, see Testing IAM policies with the IAM policy
simulator in the IAM User Guide.

# Arguments
- `action_names`: A list of names of API operations to evaluate in the simulation. Each
  operation is evaluated against each resource. Each operation must include the service
  identifier, such as iam:CreateUser. This operation does not support using wildcards (*) in
  an action name.
- `policy_input_list`: A list of policy documents to include in the simulation. Each
  document is specified as a string containing the complete, valid JSON text of an IAM
  policy. Do not include any resource-based policies in this parameter. Any resource-based
  policy must be submitted with the ResourcePolicy parameter. The policies cannot be
  \"scope-down\" policies, such as you could include in a call to GetFederationToken or one
  of the AssumeRole API operations. In other words, do not use policies designed to restrict
  what a user can do while using the temporary credentials. The maximum length of the policy
  document that you can pass in this operation, including whitespace, is listed below. To
  view the maximum character counts of a managed policy with no whitespaces, see IAM and STS
  character quotas. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CallerArn"`: The ARN of the IAM user that you want to use as the simulated caller of
  the API operations. CallerArn is required if you include a ResourcePolicy so that the
  policy's Principal element has a value to use in evaluating the policy. You can specify
  only the ARN of an IAM user. You cannot specify the ARN of an assumed role, federated user,
  or a service principal.
- `"ContextEntries"`: A list of context keys and corresponding values for the simulation to
  use. Whenever a context key is evaluated in one of the simulated IAM permissions policies,
  the corresponding value is supplied.
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PermissionsBoundaryPolicyInputList"`: The IAM permissions boundary policy to simulate.
  The permissions boundary sets the maximum permissions that an IAM entity can have. You can
  input only one permissions boundary when you pass a policy to this operation. For more
  information about permissions boundaries, see Permissions boundaries for IAM entities in
  the IAM User Guide. The policy input is specified as a string that contains the complete,
  valid JSON text of a permissions boundary policy. The maximum length of the policy document
  that you can pass in this operation, including whitespace, is listed below. To view the
  maximum character counts of a managed policy with no whitespaces, see IAM and STS character
  quotas. The regex pattern used to validate this parameter is a string of characters
  consisting of the following:   Any printable ASCII character ranging from the space
  character (u0020) through the end of the ASCII character range   The printable characters
  in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The special
  characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `"ResourceArns"`: A list of ARNs of Amazon Web Services resources to include in the
  simulation. If this parameter is not provided, then the value defaults to * (all
  resources). Each API in the ActionNames parameter is evaluated for each resource in this
  list. The simulation determines the access result (allowed or denied) of each combination
  and reports it in the response. You can simulate resources that don't exist in your
  account. The simulation does not automatically retrieve policies for the specified
  resources. If you want to include a resource policy in the simulation, then you must
  include the policy as a string in the ResourcePolicy parameter. If you include a
  ResourcePolicy, then it must be applicable to all of the resources included in the
  simulation or you receive an invalid input error. For more information about ARNs, see
  Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.  Simulation of
  resource-based policies isn't supported for IAM roles.
- `"ResourceHandlingOption"`: Specifies the type of simulation to run. Different API
  operations that support resource-based policies require different combinations of
  resources. By specifying the type of simulation to run, you enable the policy simulator to
  enforce the presence of the required resources to ensure reliable simulation results. If
  your simulation does not match one of the following scenarios, then you can omit this
  parameter. The following list shows each of the supported scenario values and the resources
  that you must define to run the simulation. Each of the Amazon EC2 scenarios requires that
  you specify instance, image, and security group resources. If your scenario includes an EBS
  volume, then you must specify that volume as a resource. If the Amazon EC2 scenario
  includes VPC, then you must supply the network interface resource. If it includes an IP
  subnet, then you must specify the subnet resource. For more information on the Amazon EC2
  scenario options, see Supported platforms in the Amazon EC2 User Guide.
  EC2-VPC-InstanceStore  instance, image, security group, network interface
  EC2-VPC-InstanceStore-Subnet  instance, image, security group, network interface, subnet
  EC2-VPC-EBS  instance, image, security group, network interface, volume
  EC2-VPC-EBS-Subnet  instance, image, security group, network interface, subnet, volume
- `"ResourceOwner"`: An ARN representing the Amazon Web Services account ID that specifies
  the owner of any simulated resource that does not identify its owner in the resource ARN.
  Examples of resource ARNs include an S3 bucket or object. If ResourceOwner is specified, it
  is also used as the account owner of any ResourcePolicy included in the simulation. If the
  ResourceOwner parameter is not specified, then the owner of the resources and the resource
  policy defaults to the account of the identity provided in CallerArn. This parameter is
  required only if you specify a resource-based policy and account that owns the resource is
  different from the account that owns the simulated calling user CallerArn. The ARN for an
  account uses the following syntax: arn:aws:iam::AWS-account-ID:root. For example, to
  represent the account with the 112233445566 ID, use the following ARN:
  arn:aws:iam::112233445566-ID:root.
- `"ResourcePolicy"`: A resource-based policy to include in the simulation provided as a
  string. Each resource in the simulation is treated as if it had this policy attached. You
  can include only one resource-based policy in a simulation. The maximum length of the
  policy document that you can pass in this operation, including whitespace, is listed below.
  To view the maximum character counts of a managed policy with no whitespaces, see IAM and
  STS character quotas. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
  Simulation of resource-based policies isn't supported for IAM roles.
"""
function simulate_custom_policy(
    ActionNames, PolicyInputList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "SimulateCustomPolicy",
        Dict{String,Any}(
            "ActionNames" => ActionNames, "PolicyInputList" => PolicyInputList
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function simulate_custom_policy(
    ActionNames,
    PolicyInputList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "SimulateCustomPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActionNames" => ActionNames, "PolicyInputList" => PolicyInputList
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    simulate_principal_policy(action_names, policy_source_arn)
    simulate_principal_policy(action_names, policy_source_arn, params::Dict{String,<:Any})

Simulate how a set of IAM policies attached to an IAM entity works with a list of API
operations and Amazon Web Services resources to determine the policies' effective
permissions. The entity can be an IAM user, group, or role. If you specify a user, then the
simulation also includes all of the policies that are attached to groups that the user
belongs to. You can simulate resources that don't exist in your account. You can optionally
include a list of one or more additional policies specified as strings to include in the
simulation. If you want to simulate only policies specified as strings, use
SimulateCustomPolicy instead. You can also optionally include one resource-based policy to
be evaluated with each of the resources included in the simulation for IAM users only. The
simulation does not perform the API operations; it only checks the authorization to
determine if the simulated policies allow or deny the operations.  Note: This operation
discloses information about the permissions granted to other users. If you do not want
users to see other user's permissions, then consider allowing them to use
SimulateCustomPolicy instead. Context keys are variables maintained by Amazon Web Services
and its services that provide details about the context of an API query request. You can
use the Condition element of an IAM policy to evaluate context keys. To get the list of
context keys that the policies require for correct simulation, use
GetContextKeysForPrincipalPolicy. If the output is long, you can use the MaxItems and
Marker parameters to paginate the results.  The IAM policy simulator evaluates statements
in the identity-based policy and the inputs that you provide during simulation. The policy
simulator results can differ from your live Amazon Web Services environment. We recommend
that you check your policies against your live Amazon Web Services environment after
testing using the policy simulator to confirm that you have the desired results. For more
information about using the policy simulator, see Testing IAM policies with the IAM policy
simulator in the IAM User Guide.

# Arguments
- `action_names`: A list of names of API operations to evaluate in the simulation. Each
  operation is evaluated for each resource. Each operation must include the service
  identifier, such as iam:CreateUser.
- `policy_source_arn`: The Amazon Resource Name (ARN) of a user, group, or role whose
  policies you want to include in the simulation. If you specify a user, group, or role, the
  simulation includes all policies that are associated with that entity. If you specify a
  user, the simulation also includes all policies that are attached to any groups the user
  belongs to. The maximum length of the policy document that you can pass in this operation,
  including whitespace, is listed below. To view the maximum character counts of a managed
  policy with no whitespaces, see IAM and STS character quotas. For more information about
  ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CallerArn"`: The ARN of the IAM user that you want to specify as the simulated caller
  of the API operations. If you do not specify a CallerArn, it defaults to the ARN of the
  user that you specify in PolicySourceArn, if you specified a user. If you include both a
  PolicySourceArn (for example, arn:aws:iam::123456789012:user/David) and a CallerArn (for
  example, arn:aws:iam::123456789012:user/Bob), the result is that you simulate calling the
  API operations as Bob, as if Bob had David's policies. You can specify only the ARN of an
  IAM user. You cannot specify the ARN of an assumed role, federated user, or a service
  principal.  CallerArn is required if you include a ResourcePolicy and the PolicySourceArn
  is not the ARN for an IAM user. This is required so that the resource-based policy's
  Principal element has a value to use in evaluating the policy. For more information about
  ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
- `"ContextEntries"`: A list of context keys and corresponding values for the simulation to
  use. Whenever a context key is evaluated in one of the simulated IAM permissions policies,
  the corresponding value is supplied.
- `"Marker"`: Use this parameter only when paginating results and only after you receive a
  response indicating that the results are truncated. Set it to the value of the Marker
  element in the response that you received to indicate where the next call should start.
- `"MaxItems"`: Use this only when paginating results to indicate the maximum number of
  items you want in the response. If additional items exist beyond the maximum you specify,
  the IsTruncated response element is true. If you do not include this parameter, the number
  of items defaults to 100. Note that IAM might return fewer results, even when there are
  more results available. In that case, the IsTruncated response element returns true, and
  Marker contains a value to include in the subsequent call that tells the service where to
  continue from.
- `"PermissionsBoundaryPolicyInputList"`: The IAM permissions boundary policy to simulate.
  The permissions boundary sets the maximum permissions that the entity can have. You can
  input only one permissions boundary when you pass a policy to this operation. An IAM entity
  can only have one permissions boundary in effect at a time. For example, if a permissions
  boundary is attached to an entity and you pass in a different permissions boundary policy
  using this parameter, then the new permissions boundary policy is used for the simulation.
  For more information about permissions boundaries, see Permissions boundaries for IAM
  entities in the IAM User Guide. The policy input is specified as a string containing the
  complete, valid JSON text of a permissions boundary policy. The maximum length of the
  policy document that you can pass in this operation, including whitespace, is listed below.
  To view the maximum character counts of a managed policy with no whitespaces, see IAM and
  STS character quotas. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `"PolicyInputList"`: An optional list of additional policy documents to include in the
  simulation. Each document is specified as a string containing the complete, valid JSON text
  of an IAM policy. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
- `"ResourceArns"`: A list of ARNs of Amazon Web Services resources to include in the
  simulation. If this parameter is not provided, then the value defaults to * (all
  resources). Each API in the ActionNames parameter is evaluated for each resource in this
  list. The simulation determines the access result (allowed or denied) of each combination
  and reports it in the response. You can simulate resources that don't exist in your
  account. The simulation does not automatically retrieve policies for the specified
  resources. If you want to include a resource policy in the simulation, then you must
  include the policy as a string in the ResourcePolicy parameter. For more information about
  ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
  Simulation of resource-based policies isn't supported for IAM roles.
- `"ResourceHandlingOption"`: Specifies the type of simulation to run. Different API
  operations that support resource-based policies require different combinations of
  resources. By specifying the type of simulation to run, you enable the policy simulator to
  enforce the presence of the required resources to ensure reliable simulation results. If
  your simulation does not match one of the following scenarios, then you can omit this
  parameter. The following list shows each of the supported scenario values and the resources
  that you must define to run the simulation. Each of the Amazon EC2 scenarios requires that
  you specify instance, image, and security group resources. If your scenario includes an EBS
  volume, then you must specify that volume as a resource. If the Amazon EC2 scenario
  includes VPC, then you must supply the network interface resource. If it includes an IP
  subnet, then you must specify the subnet resource. For more information on the Amazon EC2
  scenario options, see Supported platforms in the Amazon EC2 User Guide.
  EC2-VPC-InstanceStore  instance, image, security group, network interface
  EC2-VPC-InstanceStore-Subnet  instance, image, security group, network interface, subnet
  EC2-VPC-EBS  instance, image, security group, network interface, volume
  EC2-VPC-EBS-Subnet  instance, image, security group, network interface, subnet, volume
- `"ResourceOwner"`: An Amazon Web Services account ID that specifies the owner of any
  simulated resource that does not identify its owner in the resource ARN. Examples of
  resource ARNs include an S3 bucket or object. If ResourceOwner is specified, it is also
  used as the account owner of any ResourcePolicy included in the simulation. If the
  ResourceOwner parameter is not specified, then the owner of the resources and the resource
  policy defaults to the account of the identity provided in CallerArn. This parameter is
  required only if you specify a resource-based policy and account that owns the resource is
  different from the account that owns the simulated calling user CallerArn.
- `"ResourcePolicy"`: A resource-based policy to include in the simulation provided as a
  string. Each resource in the simulation is treated as if it had this policy attached. You
  can include only one resource-based policy in a simulation. The maximum length of the
  policy document that you can pass in this operation, including whitespace, is listed below.
  To view the maximum character counts of a managed policy with no whitespaces, see IAM and
  STS character quotas. The regex pattern used to validate this parameter is a string of
  characters consisting of the following:   Any printable ASCII character ranging from the
  space character (u0020) through the end of the ASCII character range   The printable
  characters in the Basic Latin and Latin-1 Supplement character set (through u00FF)   The
  special characters tab (u0009), line feed (u000A), and carriage return (u000D)
  Simulation of resource-based policies isn't supported for IAM roles.
"""
function simulate_principal_policy(
    ActionNames, PolicySourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "SimulatePrincipalPolicy",
        Dict{String,Any}(
            "ActionNames" => ActionNames, "PolicySourceArn" => PolicySourceArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function simulate_principal_policy(
    ActionNames,
    PolicySourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "SimulatePrincipalPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActionNames" => ActionNames, "PolicySourceArn" => PolicySourceArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_instance_profile(instance_profile_name, tags)
    tag_instance_profile(instance_profile_name, tags, params::Dict{String,<:Any})

Adds one or more tags to an IAM instance profile. If a tag with the same key name already
exists, then that tag is overwritten with the new value. Each tag consists of a key name
and an associated value. By assigning tags to your resources, you can do the following:
Administrative grouping and discovery - Attach tags to resources to aid in organization and
search. For example, you could search for all resources with the key name Project and the
value MyImportantProject. Or search for all resources with the key name Cost Center and the
value 41200.     Access control - Include tags in IAM user-based and resource-based
policies. You can use tags to restrict access to only an IAM instance profile that has a
specified tag attached. For examples of policies that show how to use tags to control
access, see Control access using IAM tags in the IAM User Guide.      If any one of the
tags is invalid or if you exceed the allowed maximum number of tags, then the entire
request fails and the resource is not created. For more information about tagging, see
Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the
tag Value as a single string. If you need to store an array, you can store comma-separated
values in the string. However, you must interpret the value in your code.

# Arguments
- `instance_profile_name`: The name of the IAM instance profile to which you want to add
  tags. This parameter allows (through its regex pattern) a string of characters consisting
  of upper and lowercase alphanumeric characters with no spaces. You can also include any of
  the following characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the IAM instance profile. Each tag
  consists of a key name and an associated value.

"""
function tag_instance_profile(
    InstanceProfileName, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "TagInstanceProfile",
        Dict{String,Any}("InstanceProfileName" => InstanceProfileName, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_instance_profile(
    InstanceProfileName,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceProfileName" => InstanceProfileName, "Tags" => Tags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_mfadevice(serial_number, tags)
    tag_mfadevice(serial_number, tags, params::Dict{String,<:Any})

Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag
with the same key name already exists, then that tag is overwritten with the new value. A
tag consists of a key name and an associated value. By assigning tags to your resources,
you can do the following:    Administrative grouping and discovery - Attach tags to
resources to aid in organization and search. For example, you could search for all
resources with the key name Project and the value MyImportantProject. Or search for all
resources with the key name Cost Center and the value 41200.     Access control - Include
tags in IAM user-based and resource-based policies. You can use tags to restrict access to
only an IAM virtual MFA device that has a specified tag attached. For examples of policies
that show how to use tags to control access, see Control access using IAM tags in the IAM
User Guide.      If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not created. For more
information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web
Services always interprets the tag Value as a single string. If you need to store an array,
you can store comma-separated values in the string. However, you must interpret the value
in your code.

# Arguments
- `serial_number`: The unique identifier for the IAM virtual MFA device to which you want
  to add tags. For virtual MFA devices, the serial number is the same as the ARN. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the IAM virtual MFA device. Each tag
  consists of a key name and an associated value.

"""
function tag_mfadevice(
    SerialNumber, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "TagMFADevice",
        Dict{String,Any}("SerialNumber" => SerialNumber, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_mfadevice(
    SerialNumber,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SerialNumber" => SerialNumber, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_open_idconnect_provider(open_idconnect_provider_arn, tags)
    tag_open_idconnect_provider(open_idconnect_provider_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more
information about these providers, see About web identity federation. If a tag with the
same key name already exists, then that tag is overwritten with the new value. A tag
consists of a key name and an associated value. By assigning tags to your resources, you
can do the following:    Administrative grouping and discovery - Attach tags to resources
to aid in organization and search. For example, you could search for all resources with the
key name Project and the value MyImportantProject. Or search for all resources with the key
name Cost Center and the value 41200.     Access control - Include tags in IAM
identity-based and resource-based policies. You can use tags to restrict access to only an
OIDC provider that has a specified tag attached. For examples of policies that show how to
use tags to control access, see Control access using IAM tags in the IAM User Guide.
If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then
the entire request fails and the resource is not created. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always
interprets the tag Value as a single string. If you need to store an array, you can store
comma-separated values in the string. However, you must interpret the value in your code.

# Arguments
- `open_idconnect_provider_arn`: The ARN of the OIDC identity provider in IAM to which you
  want to add tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the OIDC identity provider in IAM.
  Each tag consists of a key name and an associated value.

"""
function tag_open_idconnect_provider(
    OpenIDConnectProviderArn, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "TagOpenIDConnectProvider",
        Dict{String,Any}(
            "OpenIDConnectProviderArn" => OpenIDConnectProviderArn, "Tags" => Tags
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_open_idconnect_provider(
    OpenIDConnectProviderArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OpenIDConnectProviderArn" => OpenIDConnectProviderArn, "Tags" => Tags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_policy(policy_arn, tags)
    tag_policy(policy_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to an IAM customer managed policy. If a tag with the same key name
already exists, then that tag is overwritten with the new value. A tag consists of a key
name and an associated value. By assigning tags to your resources, you can do the
following:    Administrative grouping and discovery - Attach tags to resources to aid in
organization and search. For example, you could search for all resources with the key name
Project and the value MyImportantProject. Or search for all resources with the key name
Cost Center and the value 41200.     Access control - Include tags in IAM user-based and
resource-based policies. You can use tags to restrict access to only an IAM customer
managed policy that has a specified tag attached. For examples of policies that show how to
use tags to control access, see Control access using IAM tags in the IAM User Guide.
If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then
the entire request fails and the resource is not created. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always
interprets the tag Value as a single string. If you need to store an array, you can store
comma-separated values in the string. However, you must interpret the value in your code.

# Arguments
- `policy_arn`: The ARN of the IAM customer managed policy to which you want to add tags.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the IAM customer managed policy. Each
  tag consists of a key name and an associated value.

"""
function tag_policy(PolicyArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "TagPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_policy(
    PolicyArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("PolicyArn" => PolicyArn, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_role(role_name, tags)
    tag_role(role_name, tags, params::Dict{String,<:Any})

Adds one or more tags to an IAM role. The role can be a regular role or a service-linked
role. If a tag with the same key name already exists, then that tag is overwritten with the
new value. A tag consists of a key name and an associated value. By assigning tags to your
resources, you can do the following:    Administrative grouping and discovery - Attach tags
to resources to aid in organization and search. For example, you could search for all
resources with the key name Project and the value MyImportantProject. Or search for all
resources with the key name Cost Center and the value 41200.     Access control - Include
tags in IAM user-based and resource-based policies. You can use tags to restrict access to
only an IAM role that has a specified tag attached. You can also restrict access to only
those resources that have a certain tag attached. For examples of policies that show how to
use tags to control access, see Control access using IAM tags in the IAM User Guide.
Cost allocation - Use tags to help track which individuals and teams are using which Amazon
Web Services resources.      If any one of the tags is invalid or if you exceed the allowed
maximum number of tags, then the entire request fails and the resource is not created. For
more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon
Web Services always interprets the tag Value as a single string. If you need to store an
array, you can store comma-separated values in the string. However, you must interpret the
value in your code.    For more information about tagging, see Tagging IAM identities in
the IAM User Guide.

# Arguments
- `role_name`: The name of the IAM role to which you want to add tags. This parameter
  accepts (through its regex pattern) a string of characters that consist of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the IAM role. Each tag consists of a
  key name and an associated value.

"""
function tag_role(RoleName, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "TagRole",
        Dict{String,Any}("RoleName" => RoleName, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_role(
    RoleName,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagRole",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RoleName" => RoleName, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_samlprovider(samlprovider_arn, tags)
    tag_samlprovider(samlprovider_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For
more information about these providers, see About SAML 2.0-based federation . If a tag with
the same key name already exists, then that tag is overwritten with the new value. A tag
consists of a key name and an associated value. By assigning tags to your resources, you
can do the following:    Administrative grouping and discovery - Attach tags to resources
to aid in organization and search. For example, you could search for all resources with the
key name Project and the value MyImportantProject. Or search for all resources with the key
name Cost Center and the value 41200.     Access control - Include tags in IAM user-based
and resource-based policies. You can use tags to restrict access to only a SAML identity
provider that has a specified tag attached. For examples of policies that show how to use
tags to control access, see Control access using IAM tags in the IAM User Guide.      If
any one of the tags is invalid or if you exceed the allowed maximum number of tags, then
the entire request fails and the resource is not created. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always
interprets the tag Value as a single string. If you need to store an array, you can store
comma-separated values in the string. However, you must interpret the value in your code.

# Arguments
- `samlprovider_arn`: The ARN of the SAML identity provider in IAM to which you want to add
  tags. This parameter allows (through its regex pattern) a string of characters consisting
  of upper and lowercase alphanumeric characters with no spaces. You can also include any of
  the following characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the SAML identity provider in IAM.
  Each tag consists of a key name and an associated value.

"""
function tag_samlprovider(
    SAMLProviderArn, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "TagSAMLProvider",
        Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_samlprovider(
    SAMLProviderArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_server_certificate(server_certificate_name, tags)
    tag_server_certificate(server_certificate_name, tags, params::Dict{String,<:Any})

Adds one or more tags to an IAM server certificate. If a tag with the same key name already
exists, then that tag is overwritten with the new value.  For certificates in a Region
supported by Certificate Manager (ACM), we recommend that you don't use IAM server
certificates. Instead, use ACM to provision, manage, and deploy your server certificates.
For more information about IAM server certificates, Working with server certificates in the
IAM User Guide.  A tag consists of a key name and an associated value. By assigning tags to
your resources, you can do the following:    Administrative grouping and discovery - Attach
tags to resources to aid in organization and search. For example, you could search for all
resources with the key name Project and the value MyImportantProject. Or search for all
resources with the key name Cost Center and the value 41200.     Access control - Include
tags in IAM user-based and resource-based policies. You can use tags to restrict access to
only a server certificate that has a specified tag attached. For examples of policies that
show how to use tags to control access, see Control access using IAM tags in the IAM User
Guide.    Cost allocation - Use tags to help track which individuals and teams are using
which Amazon Web Services resources.      If any one of the tags is invalid or if you
exceed the allowed maximum number of tags, then the entire request fails and the resource
is not created. For more information about tagging, see Tagging IAM resources in the IAM
User Guide.   Amazon Web Services always interprets the tag Value as a single string. If
you need to store an array, you can store comma-separated values in the string. However,
you must interpret the value in your code.

# Arguments
- `server_certificate_name`: The name of the IAM server certificate to which you want to
  add tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tags`: The list of tags that you want to attach to the IAM server certificate. Each tag
  consists of a key name and an associated value.

"""
function tag_server_certificate(
    ServerCertificateName, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "TagServerCertificate",
        Dict{String,Any}("ServerCertificateName" => ServerCertificateName, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_server_certificate(
    ServerCertificateName,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerCertificateName" => ServerCertificateName, "Tags" => Tags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_user(tags, user_name)
    tag_user(tags, user_name, params::Dict{String,<:Any})

Adds one or more tags to an IAM user. If a tag with the same key name already exists, then
that tag is overwritten with the new value. A tag consists of a key name and an associated
value. By assigning tags to your resources, you can do the following:    Administrative
grouping and discovery - Attach tags to resources to aid in organization and search. For
example, you could search for all resources with the key name Project and the value
MyImportantProject. Or search for all resources with the key name Cost Center and the value
41200.     Access control - Include tags in IAM identity-based and resource-based policies.
You can use tags to restrict access to only an IAM requesting user that has a specified tag
attached. You can also restrict access to only those resources that have a certain tag
attached. For examples of policies that show how to use tags to control access, see Control
access using IAM tags in the IAM User Guide.    Cost allocation - Use tags to help track
which individuals and teams are using which Amazon Web Services resources.      If any one
of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire
request fails and the resource is not created. For more information about tagging, see
Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the
tag Value as a single string. If you need to store an array, you can store comma-separated
values in the string. However, you must interpret the value in your code.    For more
information about tagging, see Tagging IAM identities in the IAM User Guide.

# Arguments
- `tags`: The list of tags that you want to attach to the IAM user. Each tag consists of a
  key name and an associated value.
- `user_name`: The name of the IAM user to which you want to add tags. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function tag_user(Tags, UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "TagUser",
        Dict{String,Any}("Tags" => Tags, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_user(
    Tags,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "TagUser",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Tags" => Tags, "UserName" => UserName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_instance_profile(instance_profile_name, tag_keys)
    untag_instance_profile(instance_profile_name, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the IAM instance profile. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.

# Arguments
- `instance_profile_name`: The name of the IAM instance profile from which you want to
  remove tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified instance profile.

"""
function untag_instance_profile(
    InstanceProfileName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagInstanceProfile",
        Dict{String,Any}(
            "InstanceProfileName" => InstanceProfileName, "TagKeys" => TagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_instance_profile(
    InstanceProfileName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceProfileName" => InstanceProfileName, "TagKeys" => TagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_mfadevice(serial_number, tag_keys)
    untag_mfadevice(serial_number, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device.
For more information about tagging, see Tagging IAM resources in the IAM User Guide.

# Arguments
- `serial_number`: The unique identifier for the IAM virtual MFA device from which you want
  to remove tags. For virtual MFA devices, the serial number is the same as the ARN. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified instance profile.

"""
function untag_mfadevice(
    SerialNumber, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagMFADevice",
        Dict{String,Any}("SerialNumber" => SerialNumber, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_mfadevice(
    SerialNumber,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagMFADevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SerialNumber" => SerialNumber, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_open_idconnect_provider(open_idconnect_provider_arn, tag_keys)
    untag_open_idconnect_provider(open_idconnect_provider_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity
provider in IAM. For more information about OIDC providers, see About web identity
federation. For more information about tagging, see Tagging IAM resources in the IAM User
Guide.

# Arguments
- `open_idconnect_provider_arn`: The ARN of the OIDC provider in IAM from which you want to
  remove tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified OIDC provider.

"""
function untag_open_idconnect_provider(
    OpenIDConnectProviderArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagOpenIDConnectProvider",
        Dict{String,Any}(
            "OpenIDConnectProviderArn" => OpenIDConnectProviderArn, "TagKeys" => TagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_open_idconnect_provider(
    OpenIDConnectProviderArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagOpenIDConnectProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OpenIDConnectProviderArn" => OpenIDConnectProviderArn,
                    "TagKeys" => TagKeys,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_policy(policy_arn, tag_keys)
    untag_policy(policy_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the customer managed policy. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.

# Arguments
- `policy_arn`: The ARN of the IAM customer managed policy from which you want to remove
  tags. This parameter allows (through its regex pattern) a string of characters consisting
  of upper and lowercase alphanumeric characters with no spaces. You can also include any of
  the following characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified policy.

"""
function untag_policy(
    PolicyArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagPolicy",
        Dict{String,Any}("PolicyArn" => PolicyArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_policy(
    PolicyArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyArn" => PolicyArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_role(role_name, tag_keys)
    untag_role(role_name, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the role. For more information about tagging, see Tagging
IAM resources in the IAM User Guide.

# Arguments
- `role_name`: The name of the IAM role from which you want to remove tags. This parameter
  accepts (through its regex pattern) a string of characters that consist of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified role.

"""
function untag_role(RoleName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UntagRole",
        Dict{String,Any}("RoleName" => RoleName, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_role(
    RoleName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RoleName" => RoleName, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_samlprovider(samlprovider_arn, tag_keys)
    untag_samlprovider(samlprovider_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified Security Assertion Markup Language (SAML)
identity provider in IAM. For more information about these providers, see About web
identity federation. For more information about tagging, see Tagging IAM resources in the
IAM User Guide.

# Arguments
- `samlprovider_arn`: The ARN of the SAML identity provider in IAM from which you want to
  remove tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified SAML identity provider.

"""
function untag_samlprovider(
    SAMLProviderArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagSAMLProvider",
        Dict{String,Any}("SAMLProviderArn" => SAMLProviderArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_samlprovider(
    SAMLProviderArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SAMLProviderArn" => SAMLProviderArn, "TagKeys" => TagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_server_certificate(server_certificate_name, tag_keys)
    untag_server_certificate(server_certificate_name, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the IAM server certificate. For more information about
tagging, see Tagging IAM resources in the IAM User Guide.  For certificates in a Region
supported by Certificate Manager (ACM), we recommend that you don't use IAM server
certificates. Instead, use ACM to provision, manage, and deploy your server certificates.
For more information about IAM server certificates, Working with server certificates in the
IAM User Guide.

# Arguments
- `server_certificate_name`: The name of the IAM server certificate from which you want to
  remove tags. This parameter allows (through its regex pattern) a string of characters
  consisting of upper and lowercase alphanumeric characters with no spaces. You can also
  include any of the following characters: _+=,.@-
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified IAM server certificate.

"""
function untag_server_certificate(
    ServerCertificateName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UntagServerCertificate",
        Dict{String,Any}(
            "ServerCertificateName" => ServerCertificateName, "TagKeys" => TagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_server_certificate(
    ServerCertificateName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerCertificateName" => ServerCertificateName, "TagKeys" => TagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_user(tag_keys, user_name)
    untag_user(tag_keys, user_name, params::Dict{String,<:Any})

Removes the specified tags from the user. For more information about tagging, see Tagging
IAM resources in the IAM User Guide.

# Arguments
- `tag_keys`: A list of key names as a simple array of strings. The tags with matching keys
  are removed from the specified user.
- `user_name`: The name of the IAM user from which you want to remove tags. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function untag_user(TagKeys, UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UntagUser",
        Dict{String,Any}("TagKeys" => TagKeys, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_user(
    TagKeys,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UntagUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TagKeys" => TagKeys, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_access_key(access_key_id, status)
    update_access_key(access_key_id, status, params::Dict{String,<:Any})

Changes the status of the specified access key from Active to Inactive, or vice versa. This
operation can be used to disable a user's key as part of a key rotation workflow. If the
UserName is not specified, the user name is determined implicitly based on the Amazon Web
Services access key ID used to sign the request. If a temporary access key is used, then
UserName is required. If a long-term key is assigned to the user, then UserName is not
required. This operation works for access keys under the Amazon Web Services account.
Consequently, you can use this operation to manage Amazon Web Services account root user
credentials even if the Amazon Web Services account has no associated users. For
information about rotating keys, see Managing keys and certificates in the IAM User Guide.

# Arguments
- `access_key_id`: The access key ID of the secret access key you want to update. This
  parameter allows (through its regex pattern) a string of characters that can consist of any
  upper or lowercased letter or digit.
- `status`:  The status you want to assign to the secret access key. Active means that the
  key can be used for programmatic calls to Amazon Web Services, while Inactive means that
  the key cannot be used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the user whose key you want to update. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function update_access_key(
    AccessKeyId, Status; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateAccessKey",
        Dict{String,Any}("AccessKeyId" => AccessKeyId, "Status" => Status);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_access_key(
    AccessKeyId,
    Status,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateAccessKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccessKeyId" => AccessKeyId, "Status" => Status),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_password_policy()
    update_account_password_policy(params::Dict{String,<:Any})

Updates the password policy settings for the Amazon Web Services account.  This operation
does not support partial updates. No parameters are required, but if you do not specify a
parameter, that parameter's value reverts to its default value. See the Request Parameters
section for each parameter's default value. Also note that some parameters do not allow the
default parameter to be explicitly set. Instead, to invoke the default value, do not
include that parameter when you invoke the operation.   For more information about using a
password policy, see Managing an IAM password policy in the IAM User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowUsersToChangePassword"`:  Allows all IAM users in your account to use the Amazon
  Web Services Management Console to change their own passwords. For more information, see
  Permitting IAM users to change their own passwords in the IAM User Guide. If you do not
  specify a value for this parameter, then the operation uses the default value of false. The
  result is that IAM users in the account do not automatically have permissions to change
  their own password.
- `"HardExpiry"`:  Prevents IAM users who are accessing the account via the Amazon Web
  Services Management Console from setting a new console password after their password has
  expired. The IAM user cannot access the console until an administrator resets the password.
  If you do not specify a value for this parameter, then the operation uses the default value
  of false. The result is that IAM users can change their passwords after they expire and
  continue to sign in as the user.   In the Amazon Web Services Management Console, the
  custom password policy option Allow users to change their own password gives IAM users
  permissions to iam:ChangePassword for only their user and to the
  iam:GetAccountPasswordPolicy action. This option does not attach a permissions policy to
  each user, rather the permissions are applied at the account-level for all users by IAM.
  IAM users with iam:ChangePassword permission and active access keys can reset their own
  expired console password using the CLI or API.
- `"MaxPasswordAge"`: The number of days that an IAM user password is valid. If you do not
  specify a value for this parameter, then the operation uses the default value of 0. The
  result is that IAM user passwords never expire.
- `"MinimumPasswordLength"`: The minimum number of characters allowed in an IAM user
  password. If you do not specify a value for this parameter, then the operation uses the
  default value of 6.
- `"PasswordReusePrevention"`: Specifies the number of previous passwords that IAM users
  are prevented from reusing. If you do not specify a value for this parameter, then the
  operation uses the default value of 0. The result is that IAM users are not prevented from
  reusing previous passwords.
- `"RequireLowercaseCharacters"`: Specifies whether IAM user passwords must contain at
  least one lowercase character from the ISO basic Latin alphabet (a to z). If you do not
  specify a value for this parameter, then the operation uses the default value of false. The
  result is that passwords do not require at least one lowercase character.
- `"RequireNumbers"`: Specifies whether IAM user passwords must contain at least one
  numeric character (0 to 9). If you do not specify a value for this parameter, then the
  operation uses the default value of false. The result is that passwords do not require at
  least one numeric character.
- `"RequireSymbols"`: Specifies whether IAM user passwords must contain at least one of the
  following non-alphanumeric characters: ! @ #  % ^ &amp; * ( ) _ + - = [ ] { } | ' If you do
  not specify a value for this parameter, then the operation uses the default value of false.
  The result is that passwords do not require at least one symbol character.
- `"RequireUppercaseCharacters"`: Specifies whether IAM user passwords must contain at
  least one uppercase character from the ISO basic Latin alphabet (A to Z). If you do not
  specify a value for this parameter, then the operation uses the default value of false. The
  result is that passwords do not require at least one uppercase character.
"""
function update_account_password_policy(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateAccountPasswordPolicy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account_password_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateAccountPasswordPolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_assume_role_policy(policy_document, role_name)
    update_assume_role_policy(policy_document, role_name, params::Dict{String,<:Any})

Updates the policy that grants an IAM entity permission to assume a role. This is typically
referred to as the \"role trust policy\". For more information about roles, see Using roles
to delegate permissions and federate identities.

# Arguments
- `policy_document`: The policy that grants an entity permission to assume the role. You
  must provide policies in JSON format in IAM. However, for CloudFormation templates
  formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always
  converts a YAML policy to JSON format before submitting it to IAM. The regex pattern used
  to validate this parameter is a string of characters consisting of the following:   Any
  printable ASCII character ranging from the space character (u0020) through the end of the
  ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement
  character set (through u00FF)   The special characters tab (u0009), line feed (u000A), and
  carriage return (u000D)
- `role_name`: The name of the role to update with the new policy. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function update_assume_role_policy(
    PolicyDocument, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateAssumeRolePolicy",
        Dict{String,Any}("PolicyDocument" => PolicyDocument, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_assume_role_policy(
    PolicyDocument,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateAssumeRolePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument, "RoleName" => RoleName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_group(group_name)
    update_group(group_name, params::Dict{String,<:Any})

Updates the name and/or the path of the specified IAM group.   You should understand the
implications of changing a group's path or name. For more information, see Renaming users
and groups in the IAM User Guide.   The person making the request (the principal), must
have permission to change the role group with the old name and the new name. For example,
to change the group named Managers to MGRs, the principal must have a policy that allows
them to update both groups. If the principal has permission to update the Managers group,
but not the MGRs group, then the update fails. For more information about permissions, see
Access management.

# Arguments
- `group_name`: Name of the IAM group to update. If you're changing the name of the group,
  this is the original name. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewGroupName"`: New name for the IAM group. Only include this if changing the group's
  name. IAM user, group, role, and policy names must be unique within the account. Names are
  not distinguished by case. For example, you cannot create resources named both
  \"MyResource\" and \"myresource\".
- `"NewPath"`: New path for the IAM group. Only include this if changing the group's path.
  This parameter allows (through its regex pattern) a string of characters consisting of
  either a forward slash (/) by itself or a string that must begin and end with forward
  slashes. In addition, it can contain any ASCII character from the ! (u0021) through the DEL
  character (u007F), including most punctuation characters, digits, and upper and lowercased
  letters.
"""
function update_group(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UpdateGroup",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_group(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_login_profile(user_name)
    update_login_profile(user_name, params::Dict{String,<:Any})

Changes the password for the specified IAM user. You can use the CLI, the Amazon Web
Services API, or the Users page in the IAM console to change the password for any IAM user.
Use ChangePassword to change your own password in the My Security Credentials page in the
Amazon Web Services Management Console. For more information about modifying passwords, see
Managing passwords in the IAM User Guide.

# Arguments
- `user_name`: The name of the user whose password you want to update. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Password"`: The new password for the specified IAM user. The regex pattern used to
  validate this parameter is a string of characters consisting of the following:   Any
  printable ASCII character ranging from the space character (u0020) through the end of the
  ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement
  character set (through u00FF)   The special characters tab (u0009), line feed (u000A), and
  carriage return (u000D)   However, the format can be further restricted by the account
  administrator by setting a password policy on the Amazon Web Services account. For more
  information, see UpdateAccountPasswordPolicy.
- `"PasswordResetRequired"`: Allows this new password to be used only once by requiring the
  specified IAM user to set a new password on next sign-in.
"""
function update_login_profile(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UpdateLoginProfile",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_login_profile(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateLoginProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_open_idconnect_provider_thumbprint(open_idconnect_provider_arn, thumbprint_list)
    update_open_idconnect_provider_thumbprint(open_idconnect_provider_arn, thumbprint_list, params::Dict{String,<:Any})

Replaces the existing list of server certificate thumbprints associated with an OpenID
Connect (OIDC) provider resource object with a new list of thumbprints. The list that you
pass with this operation completely replaces the existing list of thumbprints. (The lists
are not merged.) Typically, you need to update a thumbprint only when the identity provider
certificate changes, which occurs rarely. However, if the provider's certificate does
change, any attempt to assume an IAM role that specifies the OIDC provider as a principal
fails until the certificate thumbprint is updated.  Amazon Web Services secures
communication with some OIDC identity providers (IdPs) through our library of trusted root
certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP
server certificate. In these cases, your legacy thumbprint remains in your configuration,
but is no longer used for validation. These OIDC IdPs include Auth0, GitHub, GitLab,
Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint.
 Trust for the OIDC provider is derived from the provider certificate and is validated by
the thumbprint. Therefore, it is best to limit access to the
UpdateOpenIDConnectProviderThumbprint operation to highly privileged users.

# Arguments
- `open_idconnect_provider_arn`: The Amazon Resource Name (ARN) of the IAM OIDC provider
  resource object for which you want to update the thumbprint. You can get a list of OIDC
  provider ARNs by using the ListOpenIDConnectProviders operation. For more information about
  ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
- `thumbprint_list`: A list of certificate thumbprints that are associated with the
  specified IAM OpenID Connect provider. For more information, see
  CreateOpenIDConnectProvider.

"""
function update_open_idconnect_provider_thumbprint(
    OpenIDConnectProviderArn,
    ThumbprintList;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateOpenIDConnectProviderThumbprint",
        Dict{String,Any}(
            "OpenIDConnectProviderArn" => OpenIDConnectProviderArn,
            "ThumbprintList" => ThumbprintList,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_open_idconnect_provider_thumbprint(
    OpenIDConnectProviderArn,
    ThumbprintList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateOpenIDConnectProviderThumbprint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OpenIDConnectProviderArn" => OpenIDConnectProviderArn,
                    "ThumbprintList" => ThumbprintList,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_role(role_name)
    update_role(role_name, params::Dict{String,<:Any})

Updates the description or maximum session duration setting of a role.

# Arguments
- `role_name`: The name of the role that you want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The new description that you want to apply to the specified role.
- `"MaxSessionDuration"`: The maximum session duration (in seconds) that you want to set
  for the specified role. If you do not specify a value for this setting, the default value
  of one hour is applied. This setting can have a value from 1 hour to 12 hours. Anyone who
  assumes the role from the CLI or API can use the DurationSeconds API parameter or the
  duration-seconds CLI parameter to request a longer session. The MaxSessionDuration setting
  determines the maximum duration that can be requested using the DurationSeconds parameter.
  If users don't specify a value for the DurationSeconds parameter, their security
  credentials are valid for one hour by default. This applies when you use the AssumeRole*
  API operations or the assume-role* CLI operations but does not apply when you use those
  operations to create a console URL. For more information, see Using IAM roles in the IAM
  User Guide.  IAM role credentials provided by Amazon EC2 instances assigned to the role are
  not subject to the specified maximum session duration.
"""
function update_role(RoleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UpdateRole",
        Dict{String,Any}("RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_role(
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateRole",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RoleName" => RoleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_role_description(description, role_name)
    update_role_description(description, role_name, params::Dict{String,<:Any})

Use UpdateRole instead. Modifies only the description of a role. This operation performs
the same function as the Description parameter in the UpdateRole operation.

# Arguments
- `description`: The new description that you want to apply to the specified role.
- `role_name`: The name of the role that you want to modify.

"""
function update_role_description(
    Description, RoleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateRoleDescription",
        Dict{String,Any}("Description" => Description, "RoleName" => RoleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_role_description(
    Description,
    RoleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateRoleDescription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Description" => Description, "RoleName" => RoleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_samlprovider(samlmetadata_document, samlprovider_arn)
    update_samlprovider(samlmetadata_document, samlprovider_arn, params::Dict{String,<:Any})

Updates the metadata document for an existing SAML provider resource object.  This
operation requires Signature Version 4.

# Arguments
- `samlmetadata_document`: An XML document generated by an identity provider (IdP) that
  supports SAML 2.0. The document includes the issuer's name, expiration information, and
  keys that can be used to validate the SAML authentication response (assertions) that are
  received from the IdP. You must generate the metadata document using the identity
  management software that is used as your organization's IdP.
- `samlprovider_arn`: The Amazon Resource Name (ARN) of the SAML provider to update. For
  more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services
  General Reference.

"""
function update_samlprovider(
    SAMLMetadataDocument,
    SAMLProviderArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateSAMLProvider",
        Dict{String,Any}(
            "SAMLMetadataDocument" => SAMLMetadataDocument,
            "SAMLProviderArn" => SAMLProviderArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_samlprovider(
    SAMLMetadataDocument,
    SAMLProviderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateSAMLProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SAMLMetadataDocument" => SAMLMetadataDocument,
                    "SAMLProviderArn" => SAMLProviderArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_server_certificate(server_certificate_name)
    update_server_certificate(server_certificate_name, params::Dict{String,<:Any})

Updates the name and/or the path of the specified server certificate stored in IAM. For
more information about working with server certificates, see Working with server
certificates in the IAM User Guide. This topic also includes a list of Amazon Web Services
services that can use the server certificates that you manage with IAM.  You should
understand the implications of changing a server certificate's path or name. For more
information, see Renaming a server certificate in the IAM User Guide.   The person making
the request (the principal), must have permission to change the server certificate with the
old name and the new name. For example, to change the certificate named ProductionCert to
ProdCert, the principal must have a policy that allows them to update both certificates. If
the principal has permission to update the ProductionCert group, but not the ProdCert
certificate, then the update fails. For more information about permissions, see Access
management in the IAM User Guide.

# Arguments
- `server_certificate_name`: The name of the server certificate that you want to update.
  This parameter allows (through its regex pattern) a string of characters consisting of
  upper and lowercase alphanumeric characters with no spaces. You can also include any of the
  following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewPath"`: The new path for the server certificate. Include this only if you are
  updating the server certificate's path. This parameter allows (through its regex pattern) a
  string of characters consisting of either a forward slash (/) by itself or a string that
  must begin and end with forward slashes. In addition, it can contain any ASCII character
  from the ! (u0021) through the DEL character (u007F), including most punctuation
  characters, digits, and upper and lowercased letters.
- `"NewServerCertificateName"`: The new name for the server certificate. Include this only
  if you are updating the server certificate's name. The name of the certificate cannot
  contain any spaces. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-
"""
function update_server_certificate(
    ServerCertificateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateServerCertificate",
        Dict{String,Any}("ServerCertificateName" => ServerCertificateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_server_certificate(
    ServerCertificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerCertificateName" => ServerCertificateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_specific_credential(service_specific_credential_id, status)
    update_service_specific_credential(service_specific_credential_id, status, params::Dict{String,<:Any})

Sets the status of a service-specific credential to Active or Inactive. Service-specific
credentials that are inactive cannot be used for authentication to the service. This
operation can be used to disable a user's service-specific credential as part of a
credential rotation work flow.

# Arguments
- `service_specific_credential_id`: The unique identifier of the service-specific
  credential. This parameter allows (through its regex pattern) a string of characters that
  can consist of any upper or lowercased letter or digit.
- `status`: The status to be assigned to the service-specific credential.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the IAM user associated with the service-specific credential.
  If you do not specify this value, then the operation assumes the user whose credentials are
  used to call the operation. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-
"""
function update_service_specific_credential(
    ServiceSpecificCredentialId, Status; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateServiceSpecificCredential",
        Dict{String,Any}(
            "ServiceSpecificCredentialId" => ServiceSpecificCredentialId, "Status" => Status
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service_specific_credential(
    ServiceSpecificCredentialId,
    Status,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateServiceSpecificCredential",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServiceSpecificCredentialId" => ServiceSpecificCredentialId,
                    "Status" => Status,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_signing_certificate(certificate_id, status)
    update_signing_certificate(certificate_id, status, params::Dict{String,<:Any})

Changes the status of the specified user signing certificate from active to disabled, or
vice versa. This operation can be used to disable an IAM user's signing certificate as part
of a certificate rotation work flow. If the UserName field is not specified, the user name
is determined implicitly based on the Amazon Web Services access key ID used to sign the
request. This operation works for access keys under the Amazon Web Services account.
Consequently, you can use this operation to manage Amazon Web Services account root user
credentials even if the Amazon Web Services account has no associated users.

# Arguments
- `certificate_id`: The ID of the signing certificate you want to update. This parameter
  allows (through its regex pattern) a string of characters that can consist of any upper or
  lowercased letter or digit.
- `status`:  The status you want to assign to the certificate. Active means that the
  certificate can be used for programmatic calls to Amazon Web Services Inactive means that
  the certificate cannot be used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the IAM user the signing certificate belongs to. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function update_signing_certificate(
    CertificateId, Status; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateSigningCertificate",
        Dict{String,Any}("CertificateId" => CertificateId, "Status" => Status);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_signing_certificate(
    CertificateId,
    Status,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateSigningCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateId" => CertificateId, "Status" => Status),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sshpublic_key(sshpublic_key_id, status, user_name)
    update_sshpublic_key(sshpublic_key_id, status, user_name, params::Dict{String,<:Any})

Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that
are inactive cannot be used for authentication. This operation can be used to disable a
user's SSH public key as part of a key rotation work flow. The SSH public key affected by
this operation is used only for authenticating the associated IAM user to an CodeCommit
repository. For more information about using SSH keys to authenticate to an CodeCommit
repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide.

# Arguments
- `sshpublic_key_id`: The unique identifier for the SSH public key. This parameter allows
  (through its regex pattern) a string of characters that can consist of any upper or
  lowercased letter or digit.
- `status`: The status to assign to the SSH public key. Active means that the key can be
  used for authentication with an CodeCommit repository. Inactive means that the key cannot
  be used.
- `user_name`: The name of the IAM user associated with the SSH public key. This parameter
  allows (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function update_sshpublic_key(
    SSHPublicKeyId, Status, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UpdateSSHPublicKey",
        Dict{String,Any}(
            "SSHPublicKeyId" => SSHPublicKeyId, "Status" => Status, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sshpublic_key(
    SSHPublicKeyId,
    Status,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateSSHPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SSHPublicKeyId" => SSHPublicKeyId,
                    "Status" => Status,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user(user_name)
    update_user(user_name, params::Dict{String,<:Any})

Updates the name and/or the path of the specified IAM user.   You should understand the
implications of changing an IAM user's path or name. For more information, see Renaming an
IAM user and Renaming an IAM group in the IAM User Guide.    To change a user name, the
requester must have appropriate permissions on both the source object and the target
object. For example, to change Bob to Robert, the entity making the request must have
permission on Bob and Robert, or must have permission on all (*). For more information
about permissions, see Permissions and policies.

# Arguments
- `user_name`: Name of the user to update. If you're changing the name of the user, this is
  the original user name. This parameter allows (through its regex pattern) a string of
  characters consisting of upper and lowercase alphanumeric characters with no spaces. You
  can also include any of the following characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewPath"`: New path for the IAM user. Include this parameter only if you're changing
  the user's path. This parameter allows (through its regex pattern) a string of characters
  consisting of either a forward slash (/) by itself or a string that must begin and end with
  forward slashes. In addition, it can contain any ASCII character from the ! (u0021) through
  the DEL character (u007F), including most punctuation characters, digits, and upper and
  lowercased letters.
- `"NewUserName"`: New name for the user. Include this parameter only if you're changing
  the user's name. IAM user, group, role, and policy names must be unique within the account.
  Names are not distinguished by case. For example, you cannot create resources named both
  \"MyResource\" and \"myresource\".
"""
function update_user(UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return iam(
        "UpdateUser",
        Dict{String,Any}("UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user(
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UpdateUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserName" => UserName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    upload_server_certificate(certificate_body, private_key, server_certificate_name)
    upload_server_certificate(certificate_body, private_key, server_certificate_name, params::Dict{String,<:Any})

Uploads a server certificate entity for the Amazon Web Services account. The server
certificate entity includes a public key certificate, a private key, and an optional
certificate chain, which should all be PEM-encoded. We recommend that you use Certificate
Manager to provision, manage, and deploy your server certificates. With ACM you can request
a certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate
renewals for you. Certificates provided by ACM are free. For more information about using
ACM, see the Certificate Manager User Guide. For more information about working with server
certificates, see Working with server certificates in the IAM User Guide. This topic
includes a list of Amazon Web Services services that can use the server certificates that
you manage with IAM. For information about the number of server certificates you can
upload, see IAM and STS quotas in the IAM User Guide.  Because the body of the public key
certificate, private key, and the certificate chain can be large, you should use POST
rather than GET when calling UploadServerCertificate. For information about setting up
signatures and authorization through the API, see Signing Amazon Web Services API requests
in the Amazon Web Services General Reference. For general information about using the Query
API with IAM, see Calling the API by making HTTP query requests in the IAM User Guide.

# Arguments
- `certificate_body`: The contents of the public key certificate in PEM-encoded format. The
  regex pattern used to validate this parameter is a string of characters consisting of the
  following:   Any printable ASCII character ranging from the space character (u0020) through
  the end of the ASCII character range   The printable characters in the Basic Latin and
  Latin-1 Supplement character set (through u00FF)   The special characters tab (u0009), line
  feed (u000A), and carriage return (u000D)
- `private_key`: The contents of the private key in PEM-encoded format. The regex pattern
  used to validate this parameter is a string of characters consisting of the following:
  Any printable ASCII character ranging from the space character (u0020) through the end of
  the ASCII character range   The printable characters in the Basic Latin and Latin-1
  Supplement character set (through u00FF)   The special characters tab (u0009), line feed
  (u000A), and carriage return (u000D)
- `server_certificate_name`: The name for the server certificate. Do not include the path
  in this value. The name of the certificate cannot contain any spaces. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateChain"`: The contents of the certificate chain. This is typically a
  concatenation of the PEM-encoded public key certificates of the chain. The regex pattern
  used to validate this parameter is a string of characters consisting of the following:
  Any printable ASCII character ranging from the space character (u0020) through the end of
  the ASCII character range   The printable characters in the Basic Latin and Latin-1
  Supplement character set (through u00FF)   The special characters tab (u0009), line feed
  (u000A), and carriage return (u000D)
- `"Path"`: The path for the server certificate. For more information about paths, see IAM
  identifiers in the IAM User Guide. This parameter is optional. If it is not included, it
  defaults to a slash (/). This parameter allows (through its regex pattern) a string of
  characters consisting of either a forward slash (/) by itself or a string that must begin
  and end with forward slashes. In addition, it can contain any ASCII character from the !
  (u0021) through the DEL character (u007F), including most punctuation characters, digits,
  and upper and lowercased letters.   If you are uploading a server certificate specifically
  for use with Amazon CloudFront distributions, you must specify a path using the path
  parameter. The path must begin with /cloudfront and must include a trailing slash (for
  example, /cloudfront/test/).
- `"Tags"`: A list of tags that you want to attach to the new IAM server certificate
  resource. Each tag consists of a key name and an associated value. For more information
  about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is
  invalid or if you exceed the allowed maximum number of tags, then the entire request fails
  and the resource is not created.
"""
function upload_server_certificate(
    CertificateBody,
    PrivateKey,
    ServerCertificateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UploadServerCertificate",
        Dict{String,Any}(
            "CertificateBody" => CertificateBody,
            "PrivateKey" => PrivateKey,
            "ServerCertificateName" => ServerCertificateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function upload_server_certificate(
    CertificateBody,
    PrivateKey,
    ServerCertificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UploadServerCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateBody" => CertificateBody,
                    "PrivateKey" => PrivateKey,
                    "ServerCertificateName" => ServerCertificateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    upload_signing_certificate(certificate_body)
    upload_signing_certificate(certificate_body, params::Dict{String,<:Any})

Uploads an X.509 signing certificate and associates it with the specified IAM user. Some
Amazon Web Services services require you to use certificates to validate requests that are
signed with a corresponding private key. When you upload the certificate, its default
status is Active. For information about when you would use an X.509 signing certificate,
see Managing server certificates in IAM in the IAM User Guide. If the UserName is not
specified, the IAM user name is determined implicitly based on the Amazon Web Services
access key ID used to sign the request. This operation works for access keys under the
Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web
Services account root user credentials even if the Amazon Web Services account has no
associated users.  Because the body of an X.509 certificate can be large, you should use
POST rather than GET when calling UploadSigningCertificate. For information about setting
up signatures and authorization through the API, see Signing Amazon Web Services API
requests in the Amazon Web Services General Reference. For general information about using
the Query API with IAM, see Making query requests in the IAM User Guide.

# Arguments
- `certificate_body`: The contents of the signing certificate. The regex pattern used to
  validate this parameter is a string of characters consisting of the following:   Any
  printable ASCII character ranging from the space character (u0020) through the end of the
  ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement
  character set (through u00FF)   The special characters tab (u0009), line feed (u000A), and
  carriage return (u000D)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserName"`: The name of the user the signing certificate is for. This parameter allows
  (through its regex pattern) a string of characters consisting of upper and lowercase
  alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-
"""
function upload_signing_certificate(
    CertificateBody; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UploadSigningCertificate",
        Dict{String,Any}("CertificateBody" => CertificateBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function upload_signing_certificate(
    CertificateBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UploadSigningCertificate",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("CertificateBody" => CertificateBody), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    upload_sshpublic_key(sshpublic_key_body, user_name)
    upload_sshpublic_key(sshpublic_key_body, user_name, params::Dict{String,<:Any})

Uploads an SSH public key and associates it with the specified IAM user. The SSH public key
uploaded by this operation can be used only for authenticating the associated IAM user to
an CodeCommit repository. For more information about using SSH keys to authenticate to an
CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User
Guide.

# Arguments
- `sshpublic_key_body`: The SSH public key. The public key must be encoded in ssh-rsa
  format or PEM format. The minimum bit-length of the public key is 2048 bits. For example,
  you can generate a 2048-bit key, and the resulting PEM file is 1679 bytes long. The regex
  pattern used to validate this parameter is a string of characters consisting of the
  following:   Any printable ASCII character ranging from the space character (u0020) through
  the end of the ASCII character range   The printable characters in the Basic Latin and
  Latin-1 Supplement character set (through u00FF)   The special characters tab (u0009), line
  feed (u000A), and carriage return (u000D)
- `user_name`: The name of the IAM user to associate the SSH public key with. This
  parameter allows (through its regex pattern) a string of characters consisting of upper and
  lowercase alphanumeric characters with no spaces. You can also include any of the following
  characters: _+=,.@-

"""
function upload_sshpublic_key(
    SSHPublicKeyBody, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iam(
        "UploadSSHPublicKey",
        Dict{String,Any}("SSHPublicKeyBody" => SSHPublicKeyBody, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function upload_sshpublic_key(
    SSHPublicKeyBody,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iam(
        "UploadSSHPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SSHPublicKeyBody" => SSHPublicKeyBody, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
