# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iot
using AWS.Compat
using AWS.UUIDs

"""
    accept_certificate_transfer(certificate_id)
    accept_certificate_transfer(certificate_id, params::Dict{String,<:Any})

Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
To check for pending certificate transfers, call ListCertificates to enumerate your
certificates. Requires permission to access the AcceptCertificateTransfer action.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"setAsActive"`: Specifies whether the certificate is active.
"""
function accept_certificate_transfer(
    certificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/accept-certificate-transfer/$(certificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_certificate_transfer(
    certificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/accept-certificate-transfer/$(certificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_thing_to_billing_group()
    add_thing_to_billing_group(params::Dict{String,<:Any})

Adds a thing to a billing group. Requires permission to access the AddThingToBillingGroup
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"billingGroupArn"`: The ARN of the billing group.
- `"billingGroupName"`: The name of the billing group.  This call is asynchronous. It might
  take several seconds for the detachment to propagate.
- `"thingArn"`: The ARN of the thing to be added to the billing group.
- `"thingName"`: The name of the thing to be added to the billing group.
"""
function add_thing_to_billing_group(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/billing-groups/addThingToBillingGroup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_thing_to_billing_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/billing-groups/addThingToBillingGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_thing_to_thing_group()
    add_thing_to_thing_group(params::Dict{String,<:Any})

Adds a thing to a thing group. Requires permission to access the AddThingToThingGroup
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"overrideDynamicGroups"`: Override dynamic thing groups with static thing groups when
  10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those
  groups are dynamic thing groups, adding a thing to a static group removes the thing from
  the last dynamic group.
- `"thingArn"`: The ARN of the thing to add to a group.
- `"thingGroupArn"`: The ARN of the group to which you are adding a thing.
- `"thingGroupName"`: The name of the group to which you are adding a thing.
- `"thingName"`: The name of the thing to add to a group.
"""
function add_thing_to_thing_group(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/thing-groups/addThingToThingGroup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_thing_to_thing_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/thing-groups/addThingToThingGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_targets_with_job(job_id, targets)
    associate_targets_with_job(job_id, targets, params::Dict{String,<:Any})

Associates a group with a continuous job. The following criteria must be met:    The job
must have been created with the targetSelection field set to \"CONTINUOUS\".   The job
status must currently be \"IN_PROGRESS\".   The total number of targets associated with a
job must not exceed 100.   Requires permission to access the AssociateTargetsWithJob action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.
- `targets`: A list of thing group ARNs that define the targets of the job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"comment"`: An optional comment string describing why the job was associated with the
  targets.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
"""
function associate_targets_with_job(
    jobId, targets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/jobs/$(jobId)/targets",
        Dict{String,Any}("targets" => targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_targets_with_job(
    jobId,
    targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/jobs/$(jobId)/targets",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("targets" => targets), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_policy(policy_name, target)
    attach_policy(policy_name, target, params::Dict{String,<:Any})

Attaches the specified policy to the specified principal (certificate or other credential).
Requires permission to access the AttachPolicy action.

# Arguments
- `policy_name`: The name of the policy to attach.
- `target`: The identity to which the policy is attached. For example, a thing group or a
  certificate.

"""
function attach_policy(
    policyName, target; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/target-policies/$(policyName)",
        Dict{String,Any}("target" => target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_policy(
    policyName,
    target,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/target-policies/$(policyName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("target" => target), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_principal_policy(policy_name, x-amzn-iot-principal)
    attach_principal_policy(policy_name, x-amzn-iot-principal, params::Dict{String,<:Any})

Attaches the specified policy to the specified principal (certificate or other credential).
 Note: This action is deprecated and works as expected for backward compatibility, but we
won't add enhancements. Use AttachPolicy instead. Requires permission to access the
AttachPrincipalPolicy action.

# Arguments
- `policy_name`: The policy name.
- `x-amzn-iot-principal`: The principal, which can be a certificate ARN (as returned from
  the CreateCertificate operation) or an Amazon Cognito ID.

"""
function attach_principal_policy(
    policyName, x_amzn_iot_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/principal-policies/$(policyName)",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_principal_policy(
    policyName,
    x_amzn_iot_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/principal-policies/$(policyName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" =>
                        Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_security_profile(security_profile_name, security_profile_target_arn)
    attach_security_profile(security_profile_name, security_profile_target_arn, params::Dict{String,<:Any})

Associates a Device Defender security profile with a thing group or this account. Each
thing group or account can have up to five security profiles associated with it. Requires
permission to access the AttachSecurityProfile action.

# Arguments
- `security_profile_name`: The security profile that is attached.
- `security_profile_target_arn`: The ARN of the target (thing group) to which the security
  profile is attached.

"""
function attach_security_profile(
    securityProfileName,
    securityProfileTargetArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/security-profiles/$(securityProfileName)/targets",
        Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_security_profile(
    securityProfileName,
    securityProfileTargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/security-profiles/$(securityProfileName)/targets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_thing_principal(thing_name, x-amzn-principal)
    attach_thing_principal(thing_name, x-amzn-principal, params::Dict{String,<:Any})

Attaches the specified principal to the specified thing. A principal can be X.509
certificates, Amazon Cognito identities or federated identities. Requires permission to
access the AttachThingPrincipal action.

# Arguments
- `thing_name`: The name of the thing.
- `x-amzn-principal`: The principal, which can be a certificate ARN (as returned from the
  CreateCertificate operation) or an Amazon Cognito ID.

"""
function attach_thing_principal(
    thingName, x_amzn_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/things/$(thingName)/principals",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_thing_principal(
    thingName,
    x_amzn_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/things/$(thingName)/principals",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_audit_mitigation_actions_task(task_id)
    cancel_audit_mitigation_actions_task(task_id, params::Dict{String,<:Any})

Cancels a mitigation action task that is in progress. If the task is not in progress, an
InvalidRequestException occurs. Requires permission to access the
CancelAuditMitigationActionsTask action.

# Arguments
- `task_id`: The unique identifier for the task that you want to cancel.

"""
function cancel_audit_mitigation_actions_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/audit/mitigationactions/tasks/$(taskId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_audit_mitigation_actions_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/audit/mitigationactions/tasks/$(taskId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_audit_task(task_id)
    cancel_audit_task(task_id, params::Dict{String,<:Any})

Cancels an audit that is in progress. The audit can be either scheduled or on demand. If
the audit isn't in progress, an \"InvalidRequestException\" occurs. Requires permission to
access the CancelAuditTask action.

# Arguments
- `task_id`: The ID of the audit you want to cancel. You can only cancel an audit that is
  \"IN_PROGRESS\".

"""
function cancel_audit_task(taskId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/audit/tasks/$(taskId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_audit_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/audit/tasks/$(taskId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_certificate_transfer(certificate_id)
    cancel_certificate_transfer(certificate_id, params::Dict{String,<:Any})

Cancels a pending transfer for the specified certificate.  Note Only the transfer source
account can use this operation to cancel a transfer. (Transfer destinations can use
RejectCertificateTransfer instead.) After transfer, IoT returns the certificate to the
source account in the INACTIVE state. After the destination account has accepted the
transfer, the transfer cannot be cancelled. After a certificate transfer is cancelled, the
status of the certificate changes from PENDING_TRANSFER to INACTIVE. Requires permission to
access the CancelCertificateTransfer action.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)

"""
function cancel_certificate_transfer(
    certificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/cancel-certificate-transfer/$(certificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_certificate_transfer(
    certificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/cancel-certificate-transfer/$(certificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_detect_mitigation_actions_task(task_id)
    cancel_detect_mitigation_actions_task(task_id, params::Dict{String,<:Any})

 Cancels a Device Defender ML Detect mitigation action.  Requires permission to access the
CancelDetectMitigationActionsTask action.

# Arguments
- `task_id`:  The unique identifier of the task.

"""
function cancel_detect_mitigation_actions_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/detect/mitigationactions/tasks/$(taskId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_detect_mitigation_actions_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/detect/mitigationactions/tasks/$(taskId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_job(job_id)
    cancel_job(job_id, params::Dict{String,<:Any})

Cancels a job. Requires permission to access the CancelJob action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"comment"`: An optional comment string describing why the job was canceled.
- `"force"`: (Optional) If true job executions with status \"IN_PROGRESS\" and \"QUEUED\"
  are canceled, otherwise only job executions with status \"QUEUED\" are canceled. The
  default is false. Canceling a job which is \"IN_PROGRESS\", will cause a device which is
  executing the job to be unable to update the job execution status. Use caution and ensure
  that each device executing a job which is canceled is able to recover to a valid state.
- `"reasonCode"`: (Optional)A reason code string that explains why the job was canceled.
"""
function cancel_job(jobId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/jobs/$(jobId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_job(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/jobs/$(jobId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_job_execution(job_id, thing_name)
    cancel_job_execution(job_id, thing_name, params::Dict{String,<:Any})

Cancels the execution of a job for a given thing. Requires permission to access the
CancelJobExecution action.

# Arguments
- `job_id`: The ID of the job to be canceled.
- `thing_name`: The name of the thing whose execution of the job will be canceled.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: (Optional) The expected current version of the job execution. Each
  time you update the job execution, its version is incremented. If the version of the job
  execution stored in Jobs does not match, the update is rejected with a VersionMismatch
  error, and an ErrorResponse that contains the current job execution status data is
  returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in
  order to obtain the job execution status data.)
- `"force"`: (Optional) If true the job execution will be canceled if it has status
  IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status
  QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set
  force to true, then an InvalidStateTransitionException will be thrown. The default is
  false. Canceling a job execution which is \"IN_PROGRESS\", will cause the device to be
  unable to update the job execution status. Use caution and ensure that the device is able
  to recover to a valid state.
- `"statusDetails"`: A collection of name/value pairs that describe the status of the job
  execution. If not specified, the statusDetails are unchanged. You can specify at most 10
  name/value pairs.
"""
function cancel_job_execution(
    jobId, thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/things/$(thingName)/jobs/$(jobId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_job_execution(
    jobId,
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/things/$(thingName)/jobs/$(jobId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    clear_default_authorizer()
    clear_default_authorizer(params::Dict{String,<:Any})

Clears the default authorizer. Requires permission to access the ClearDefaultAuthorizer
action.

"""
function clear_default_authorizer(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/default-authorizer";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function clear_default_authorizer(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/default-authorizer",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    confirm_topic_rule_destination(confirmation_token)
    confirm_topic_rule_destination(confirmation_token, params::Dict{String,<:Any})

Confirms a topic rule destination. When you create a rule requiring a destination, IoT
sends a confirmation message to the endpoint or base address you specify. The message
includes a token which you pass back when calling ConfirmTopicRuleDestination to confirm
that you own or have access to the endpoint. Requires permission to access the
ConfirmTopicRuleDestination action.

# Arguments
- `confirmation_token`: The token used to confirm ownership or access to the topic rule
  confirmation URL.

"""
function confirm_topic_rule_destination(
    confirmationToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/confirmdestination/$(confirmationToken)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function confirm_topic_rule_destination(
    confirmationToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/confirmdestination/$(confirmationToken)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_audit_suppression(check_name, client_request_token, resource_identifier)
    create_audit_suppression(check_name, client_request_token, resource_identifier, params::Dict{String,<:Any})

 Creates a Device Defender audit suppression.  Requires permission to access the
CreateAuditSuppression action.

# Arguments
- `check_name`:
- `client_request_token`:  Each audit supression must have a unique client request token.
  If you try to create a new audit suppression with the same token as one that already
  exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will
  automatically generate a unique client request.
- `resource_identifier`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  The description of the audit suppression.
- `"expirationDate"`:  The epoch timestamp in seconds at which this suppression expires.
- `"suppressIndefinitely"`:  Indicates whether a suppression should exist indefinitely or
  not.
"""
function create_audit_suppression(
    checkName,
    clientRequestToken,
    resourceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/suppressions/create",
        Dict{String,Any}(
            "checkName" => checkName,
            "clientRequestToken" => clientRequestToken,
            "resourceIdentifier" => resourceIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_audit_suppression(
    checkName,
    clientRequestToken,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/suppressions/create",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "checkName" => checkName,
                    "clientRequestToken" => clientRequestToken,
                    "resourceIdentifier" => resourceIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_authorizer(authorizer_function_arn, authorizer_name)
    create_authorizer(authorizer_function_arn, authorizer_name, params::Dict{String,<:Any})

Creates an authorizer. Requires permission to access the CreateAuthorizer action.

# Arguments
- `authorizer_function_arn`: The ARN of the authorizer's Lambda function.
- `authorizer_name`: The authorizer name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enableCachingForHttp"`: When true, the result from the authorizer’s Lambda function
  is cached for clients that use persistent HTTP connections. The results are cached for the
  time specified by the Lambda function in refreshAfterInSeconds. This value does not affect
  authorization of clients that use MQTT connections. The default value is false.
- `"signingDisabled"`: Specifies whether IoT validates the token signature in an
  authorization request.
- `"status"`: The status of the create authorizer request.
- `"tags"`: Metadata which can be used to manage the custom authorizer.  For URI Request
  parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter
  use format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file
  use format: \"tags\": \"key1=value1&amp;key2=value2...\"
- `"tokenKeyName"`: The name of the token key used to extract the token from the HTTP
  headers.
- `"tokenSigningPublicKeys"`: The public keys used to verify the digital signature returned
  by your custom authentication service.
"""
function create_authorizer(
    authorizerFunctionArn,
    authorizerName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/authorizer/$(authorizerName)",
        Dict{String,Any}("authorizerFunctionArn" => authorizerFunctionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_authorizer(
    authorizerFunctionArn,
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/authorizer/$(authorizerName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("authorizerFunctionArn" => authorizerFunctionArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_billing_group(billing_group_name)
    create_billing_group(billing_group_name, params::Dict{String,<:Any})

Creates a billing group. Requires permission to access the CreateBillingGroup action.

# Arguments
- `billing_group_name`: The name you wish to give to the billing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"billingGroupProperties"`: The properties of the billing group.
- `"tags"`: Metadata which can be used to manage the billing group.
"""
function create_billing_group(
    billingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/billing-groups/$(billingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_billing_group(
    billingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/billing-groups/$(billingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_certificate_from_csr(certificate_signing_request)
    create_certificate_from_csr(certificate_signing_request, params::Dict{String,<:Any})

Creates an X.509 certificate using the specified certificate signing request.  Requires
permission to access the CreateCertificateFromCsr action.   The CSR must include a public
key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST
P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult  Certificate
signing algorithms supported by IoT.    Reusing the same certificate signing request (CSR)
results in a distinct certificate.  You can create multiple certificates in a batch by
creating a directory, copying multiple .csr files into that directory, and then specifying
that directory on the command line. The following commands show how to create a batch of
certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs
are located inside of the directory my-csr-directory: On Linux and OS X, the command is:
ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
--certificate-signing-request file://my-csr-directory/{}  This command lists all of the
CSRs in my-csr-directory and pipes each CSR file name to the aws iot
create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the
corresponding CSR.  You can also run the aws iot create-certificate-from-csr part of the
command in parallel to speed up the certificate creation process:   ls my-csr-directory/ |
xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request
file://my-csr-directory/{}   On Windows PowerShell, the command to create certificates for
all CSRs in my-csr-directory is:  &gt; ls -Name my-csr-directory | %{aws iot
create-certificate-from-csr --certificate-signing-request file://my-csr-directory/_}   On a
Windows command prompt, the command to create certificates for all CSRs in my-csr-directory
is:  &gt; forfiles /p my-csr-directory /c \"cmd /c aws iot create-certificate-from-csr
--certificate-signing-request file://@path\"

# Arguments
- `certificate_signing_request`: The certificate signing request (CSR).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"setAsActive"`: Specifies whether the certificate is active.
"""
function create_certificate_from_csr(
    certificateSigningRequest; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/certificates",
        Dict{String,Any}("certificateSigningRequest" => certificateSigningRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_certificate_from_csr(
    certificateSigningRequest,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/certificates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("certificateSigningRequest" => certificateSigningRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_certificate_provider(account_default_for_operations, certificate_provider_name, lambda_function_arn)
    create_certificate_provider(account_default_for_operations, certificate_provider_name, lambda_function_arn, params::Dict{String,<:Any})

Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web
Services IoT Core certificate provider to customize how to sign a certificate signing
request (CSR) in IoT fleet provisioning. For more information, see Customizing certificate
signing using Amazon Web Services IoT Core certificate provider from Amazon Web Services
IoT Core Developer Guide. Requires permission to access the CreateCertificateProvider
action.  After you create a certificate provider, the behavior of  CreateCertificateFromCsr
API for fleet provisioning will change and all API calls to CreateCertificateFromCsr will
invoke the certificate provider to create the certificates. It can take up to a few minutes
for this behavior to change after a certificate provider is created.

# Arguments
- `account_default_for_operations`: A list of the operations that the certificate provider
  will use to generate certificates. Valid value: CreateCertificateFromCsr.
- `certificate_provider_name`: The name of the certificate provider.
- `lambda_function_arn`: The ARN of the Lambda function that defines the authentication
  logic.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A string that you can optionally pass in the CreateCertificateProvider
  request to make sure the request is idempotent.
- `"tags"`: Metadata which can be used to manage the certificate provider.
"""
function create_certificate_provider(
    accountDefaultForOperations,
    certificateProviderName,
    lambdaFunctionArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/certificate-providers/$(certificateProviderName)",
        Dict{String,Any}(
            "accountDefaultForOperations" => accountDefaultForOperations,
            "lambdaFunctionArn" => lambdaFunctionArn,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_certificate_provider(
    accountDefaultForOperations,
    certificateProviderName,
    lambdaFunctionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/certificate-providers/$(certificateProviderName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "accountDefaultForOperations" => accountDefaultForOperations,
                    "lambdaFunctionArn" => lambdaFunctionArn,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_metric(client_request_token, metric_name, metric_type)
    create_custom_metric(client_request_token, metric_name, metric_type, params::Dict{String,<:Any})

 Use this API to define a Custom Metric published by your devices to Device Defender.
Requires permission to access the CreateCustomMetric action.

# Arguments
- `client_request_token`: Each custom metric must have a unique client request token. If
  you try to create a new custom metric that already exists with a different token, an
  exception occurs. If you omit this value, Amazon Web Services SDKs will automatically
  generate a unique client request.
- `metric_name`:  The name of the custom metric. This will be used in the metric report
  submitted from the device/thing. The name can't begin with aws:. You can't change the name
  after you define it.
- `metric_type`:  The type of the custom metric.   The type number only takes a single
  metric value as an input, but when you submit the metrics value in the DeviceMetrics
  report, you must pass it as an array with a single value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"displayName"`:  The friendly name in the console for the custom metric. This name
  doesn't have to be unique. Don't use this name as the metric identifier in the device
  metric report. You can update the friendly name after you define it.
- `"tags"`:  Metadata that can be used to manage the custom metric.
"""
function create_custom_metric(
    clientRequestToken,
    metricName,
    metricType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/custom-metric/$(metricName)",
        Dict{String,Any}(
            "clientRequestToken" => clientRequestToken, "metricType" => metricType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_metric(
    clientRequestToken,
    metricName,
    metricType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/custom-metric/$(metricName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientRequestToken" => clientRequestToken, "metricType" => metricType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dimension(client_request_token, name, string_values, type)
    create_dimension(client_request_token, name, string_values, type, params::Dict{String,<:Any})

Create a dimension that you can use to limit the scope of a metric used in a security
profile for IoT Device Defender. For example, using a TOPIC_FILTER dimension, you can
narrow down the scope of the metric only to MQTT topics whose name match the pattern
specified in the dimension. Requires permission to access the CreateDimension action.

# Arguments
- `client_request_token`: Each dimension must have a unique client request token. If you
  try to create a new dimension with the same token as a dimension that already exists, an
  exception occurs. If you omit this value, Amazon Web Services SDKs will automatically
  generate a unique client request.
- `name`: A unique identifier for the dimension. Choose something that describes the type
  and value to make it easy to remember what it does.
- `string_values`: Specifies the value or list of values for the dimension. For
  TOPIC_FILTER dimensions, this is a pattern used to match the MQTT topic (for example,
  \"admin/#\").
- `type`: Specifies the type of dimension. Supported types: TOPIC_FILTER.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: Metadata that can be used to manage the dimension.
"""
function create_dimension(
    clientRequestToken,
    name,
    stringValues,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/dimensions/$(name)",
        Dict{String,Any}(
            "clientRequestToken" => clientRequestToken,
            "stringValues" => stringValues,
            "type" => type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dimension(
    clientRequestToken,
    name,
    stringValues,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/dimensions/$(name)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientRequestToken" => clientRequestToken,
                    "stringValues" => stringValues,
                    "type" => type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain_configuration(domain_configuration_name)
    create_domain_configuration(domain_configuration_name, params::Dict{String,<:Any})

Creates a domain configuration. Requires permission to access the CreateDomainConfiguration
action.

# Arguments
- `domain_configuration_name`: The name of the domain configuration. This value must be
  unique to a region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorizerConfig"`: An object that specifies the authorization service for a domain.
- `"domainName"`: The name of the domain.
- `"serverCertificateArns"`: The ARNs of the certificates that IoT passes to the device
  during the TLS handshake. Currently you can specify only one certificate ARN. This value is
  not required for Amazon Web Services-managed domains.
- `"serverCertificateConfig"`: The server certificate configuration.
- `"serviceType"`: The type of service delivered by the endpoint.  Amazon Web Services IoT
  Core currently supports only the DATA service type.
- `"tags"`: Metadata which can be used to manage the domain configuration.  For URI Request
  parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter
  use format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file
  use format: \"tags\": \"key1=value1&amp;key2=value2...\"
- `"tlsConfig"`: An object that specifies the TLS configuration for a domain.
- `"validationCertificateArn"`: The certificate used to validate the server certificate and
  prove domain name ownership. This certificate must be signed by a public certificate
  authority. This value is not required for Amazon Web Services-managed domains.
"""
function create_domain_configuration(
    domainConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/domainConfigurations/$(domainConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain_configuration(
    domainConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/domainConfigurations/$(domainConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dynamic_thing_group(query_string, thing_group_name)
    create_dynamic_thing_group(query_string, thing_group_name, params::Dict{String,<:Any})

Creates a dynamic thing group. Requires permission to access the CreateDynamicThingGroup
action.

# Arguments
- `query_string`: The dynamic thing group search query string. See Query Syntax for
  information about query string syntax.
- `thing_group_name`: The dynamic thing group name to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"indexName"`: The dynamic thing group index name.  Currently one index is supported:
  AWS_Things.
- `"queryVersion"`: The dynamic thing group query version.  Currently one query version is
  supported: \"2017-09-30\". If not specified, the query version defaults to this value.
- `"tags"`: Metadata which can be used to manage the dynamic thing group.
- `"thingGroupProperties"`: The dynamic thing group properties.
"""
function create_dynamic_thing_group(
    queryString, thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/dynamic-thing-groups/$(thingGroupName)",
        Dict{String,Any}("queryString" => queryString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dynamic_thing_group(
    queryString,
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/dynamic-thing-groups/$(thingGroupName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("queryString" => queryString), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet_metric(aggregation_field, aggregation_type, metric_name, period, query_string)
    create_fleet_metric(aggregation_field, aggregation_type, metric_name, period, query_string, params::Dict{String,<:Any})

Creates a fleet metric. Requires permission to access the CreateFleetMetric action.

# Arguments
- `aggregation_field`: The field to aggregate.
- `aggregation_type`: The type of the aggregation query.
- `metric_name`: The name of the fleet metric to create.
- `period`: The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1
  day)] and must be multiple of 60.
- `query_string`: The search query string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The fleet metric description.
- `"indexName"`: The name of the index to search.
- `"queryVersion"`: The query version.
- `"tags"`: Metadata, which can be used to manage the fleet metric.
- `"unit"`: Used to support unit transformation such as milliseconds to seconds. The unit
  must be supported by CW metric. Default to null.
"""
function create_fleet_metric(
    aggregationField,
    aggregationType,
    metricName,
    period,
    queryString;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/fleet-metric/$(metricName)",
        Dict{String,Any}(
            "aggregationField" => aggregationField,
            "aggregationType" => aggregationType,
            "period" => period,
            "queryString" => queryString,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet_metric(
    aggregationField,
    aggregationType,
    metricName,
    period,
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/fleet-metric/$(metricName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "aggregationField" => aggregationField,
                    "aggregationType" => aggregationType,
                    "period" => period,
                    "queryString" => queryString,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_job(job_id, targets)
    create_job(job_id, targets, params::Dict{String,<:Any})

Creates a job. Requires permission to access the CreateJob action.

# Arguments
- `job_id`: A job identifier which must be unique for your Amazon Web Services account. We
  recommend using a UUID. Alpha-numeric characters, \"-\" and \"_\" are valid for use here.
- `targets`: A list of things and thing groups to which the job should be sent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"abortConfig"`: Allows you to create the criteria to abort a job.
- `"description"`: A short text description of the job.
- `"destinationPackageVersions"`: The package version Amazon Resource Names (ARNs) that are
  installed on the device when the job successfully completes. The package version must be in
  either the Published or Deprecated state when the job deploys. For more information, see
  Package version lifecycle.   Note:The following Length Constraints relates to a single ARN.
  Up to 25 package version ARNs are allowed.
- `"document"`: The job document. Required if you don't specify a value for documentSource.
- `"documentParameters"`: Parameters of an Amazon Web Services managed template that you
  can specify to create the job document.   documentParameters can only be used when creating
  jobs from Amazon Web Services managed templates. This parameter can't be used with custom
  job templates or to create jobs from them.
- `"documentSource"`: An S3 link, or S3 object URL, to the job document. The link is an
  Amazon S3 object URL and is required if you don't specify a value for document. For
  example, --document-source
  https://s3.region-code.amazonaws.com/example-firmware/device-firmware.1.0  For more
  information, see Methods for accessing a bucket.
- `"jobExecutionsRetryConfig"`: Allows you to create the criteria to retry a job.
- `"jobExecutionsRolloutConfig"`: Allows you to create a staged rollout of the job.
- `"jobTemplateArn"`: The ARN of the job template used to create the job.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
- `"presignedUrlConfig"`: Configuration information for pre-signed S3 URLs.
- `"schedulingConfig"`: The configuration that allows you to schedule a job for a future
  date and time in addition to specifying the end behavior for each job execution.
- `"tags"`: Metadata which can be used to manage the job.
- `"targetSelection"`: Specifies whether the job will continue to run (CONTINUOUS), or will
  be complete after all those things specified as targets have completed the job (SNAPSHOT).
  If continuous, the job may also be run on a thing when a change is detected in a target.
  For example, a job will run on a thing when the thing is added to a target group, even
  after the job was completed by all things originally in the group.  We recommend that you
  use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using
  continuous jobs, devices that join the group receive the job execution even after the job
  has been created.
- `"timeoutConfig"`: Specifies the amount of time each device has to finish its execution
  of the job. The timer is started when the job execution status is set to IN_PROGRESS. If
  the job execution status is not set to another terminal state before the time expires, it
  will be automatically set to TIMED_OUT.
"""
function create_job(jobId, targets; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/jobs/$(jobId)",
        Dict{String,Any}("targets" => targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_job(
    jobId,
    targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/jobs/$(jobId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("targets" => targets), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_job_template(description, job_template_id)
    create_job_template(description, job_template_id, params::Dict{String,<:Any})

Creates a job template. Requires permission to access the CreateJobTemplate action.

# Arguments
- `description`: A description of the job document.
- `job_template_id`: A unique identifier for the job template. We recommend using a UUID.
  Alpha-numeric characters, \"-\", and \"_\" are valid for use here.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"abortConfig"`:
- `"destinationPackageVersions"`: The package version Amazon Resource Names (ARNs) that are
  installed on the device when the job successfully completes. The package version must be in
  either the Published or Deprecated state when the job deploys. For more information, see
  Package version lifecycle.  Note:The following Length Constraints relates to a single ARN.
  Up to 25 package version ARNs are allowed.
- `"document"`: The job document. Required if you don't specify a value for documentSource.
- `"documentSource"`: An S3 link, or S3 object URL, to the job document. The link is an
  Amazon S3 object URL and is required if you don't specify a value for document. For
  example, --document-source
  https://s3.region-code.amazonaws.com/example-firmware/device-firmware.1.0  For more
  information, see Methods for accessing a bucket.
- `"jobArn"`: The ARN of the job to use as the basis for the job template.
- `"jobExecutionsRetryConfig"`: Allows you to create the criteria to retry a job.
- `"jobExecutionsRolloutConfig"`:
- `"maintenanceWindows"`: Allows you to configure an optional maintenance window for the
  rollout of a job document to all devices in the target group for a job.
- `"presignedUrlConfig"`:
- `"tags"`: Metadata that can be used to manage the job template.
- `"timeoutConfig"`:
"""
function create_job_template(
    description, jobTemplateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/job-templates/$(jobTemplateId)",
        Dict{String,Any}("description" => description);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_job_template(
    description,
    jobTemplateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/job-templates/$(jobTemplateId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("description" => description), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_keys_and_certificate()
    create_keys_and_certificate(params::Dict{String,<:Any})

Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public
key. You can also call CreateKeysAndCertificate over MQTT from a device, for more
information, see Provisioning MQTT API.  Note This is the only time IoT issues the private
key for this certificate, so it is important to keep it in a secure location. Requires
permission to access the CreateKeysAndCertificate action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"setAsActive"`: Specifies whether the certificate is active.
"""
function create_keys_and_certificate(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/keys-and-certificate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_keys_and_certificate(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/keys-and-certificate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_mitigation_action(action_name, action_params, role_arn)
    create_mitigation_action(action_name, action_params, role_arn, params::Dict{String,<:Any})

Defines an action that can be applied to audit findings by using
StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to
specific check names. For more information, see Mitigation actions. Each mitigation action
can apply only one type of change. Requires permission to access the CreateMitigationAction
action.

# Arguments
- `action_name`: A friendly name for the action. Choose a friendly name that accurately
  describes the action (for example, EnableLoggingAction).
- `action_params`: Defines the type of action and the parameters for that action.
- `role_arn`: The ARN of the IAM role that is used to apply the mitigation action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: Metadata that can be used to manage the mitigation action.
"""
function create_mitigation_action(
    actionName, actionParams, roleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/mitigationactions/actions/$(actionName)",
        Dict{String,Any}("actionParams" => actionParams, "roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_mitigation_action(
    actionName,
    actionParams,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/mitigationactions/actions/$(actionName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("actionParams" => actionParams, "roleArn" => roleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_otaupdate(files, ota_update_id, role_arn, targets)
    create_otaupdate(files, ota_update_id, role_arn, targets, params::Dict{String,<:Any})

Creates an IoT OTA update on a target group of things or groups. Requires permission to
access the CreateOTAUpdate action.

# Arguments
- `files`: The files to be streamed by the OTA update.
- `ota_update_id`: The ID of the OTA update to be created.
- `role_arn`: The IAM role that grants Amazon Web Services IoT Core access to the Amazon
  S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.
- `targets`: The devices targeted to receive OTA updates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalParameters"`: A list of additional OTA update parameters, which are
  name-value pairs. They won't be sent to devices as a part of the Job document.
- `"awsJobAbortConfig"`: The criteria that determine when and how a job abort takes place.
- `"awsJobExecutionsRolloutConfig"`: Configuration for the rollout of OTA updates.
- `"awsJobPresignedUrlConfig"`: Configuration information for pre-signed URLs.
- `"awsJobTimeoutConfig"`: Specifies the amount of time each device has to finish its
  execution of the job. A timer is started when the job execution status is set to
  IN_PROGRESS. If the job execution status is not set to another terminal state before the
  timer expires, it will be automatically set to TIMED_OUT.
- `"description"`: The description of the OTA update.
- `"protocols"`: The protocol used to transfer the OTA update image. Valid values are
  [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can
  choose the protocol.
- `"tags"`: Metadata which can be used to manage updates.
- `"targetSelection"`: Specifies whether the update will continue to run (CONTINUOUS), or
  will be complete after all the things specified as targets have completed the update
  (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected
  in a target. For example, an update will run on a thing when the thing is added to a target
  group, even after the update was completed by all things originally in the group. Valid
  values: CONTINUOUS | SNAPSHOT.
"""
function create_otaupdate(
    files, otaUpdateId, roleArn, targets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/otaUpdates/$(otaUpdateId)",
        Dict{String,Any}("files" => files, "roleArn" => roleArn, "targets" => targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_otaupdate(
    files,
    otaUpdateId,
    roleArn,
    targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/otaUpdates/$(otaUpdateId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "files" => files, "roleArn" => roleArn, "targets" => targets
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_package(package_name)
    create_package(package_name, params::Dict{String,<:Any})

Creates an IoT software package that can be deployed to your fleet. Requires permission to
access the CreatePackage and GetIndexingConfiguration actions.

# Arguments
- `package_name`: The name of the new software package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"description"`: A summary of the package being created. This can be used to outline the
  package's contents or purpose.
- `"tags"`: Metadata that can be used to manage the package.
"""
function create_package(packageName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/packages/$(packageName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_package(
    packageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/packages/$(packageName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_package_version(package_name, version_name)
    create_package_version(package_name, version_name, params::Dict{String,<:Any})

Creates a new version for an existing IoT software package. Requires permission to access
the CreatePackageVersion and GetIndexingConfiguration actions.

# Arguments
- `package_name`: The name of the associated software package.
- `version_name`: The name of the new package version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributes"`: Metadata that can be used to define a package version’s configuration.
  For example, the S3 file location, configuration options that are being sent to the device
  or fleet. The combined size of all the attributes on a package version is limited to 3KB.
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"description"`: A summary of the package version being created. This can be used to
  outline the package's contents or purpose.
- `"tags"`: Metadata that can be used to manage the package version.
"""
function create_package_version(
    packageName, versionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_package_version(
    packageName,
    versionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_policy(policy_document, policy_name)
    create_policy(policy_document, policy_name, params::Dict{String,<:Any})

Creates an IoT policy. The created policy is the default version for the policy. This
operation creates a policy version with a version identifier of 1 and sets 1 as the
policy's default version. Requires permission to access the CreatePolicy action.

# Arguments
- `policy_document`: The JSON document that describes the policy. policyDocument must have
  a minimum length of 1, with a maximum length of 2048, excluding whitespace.
- `policy_name`: The policy name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: Metadata which can be used to manage the policy.  For URI Request parameters
  use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter use
  format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file use
  format: \"tags\": \"key1=value1&amp;key2=value2...\"
"""
function create_policy(
    policyDocument, policyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/policies/$(policyName)",
        Dict{String,Any}("policyDocument" => policyDocument);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_policy(
    policyDocument,
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/policies/$(policyName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyDocument" => policyDocument), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_policy_version(policy_document, policy_name)
    create_policy_version(policy_document, policy_name, params::Dict{String,<:Any})

Creates a new version of the specified IoT policy. To update a policy, create a new policy
version. A managed policy can have up to five versions. If the policy has five versions,
you must use DeletePolicyVersion to delete an existing version before you create a new one.
Optionally, you can set the new version as the policy's default version. The default
version is the operative version (that is, the version that is in effect for the
certificates to which the policy is attached). Requires permission to access the
CreatePolicyVersion action.

# Arguments
- `policy_document`: The JSON document that describes the policy. Minimum length of 1.
  Maximum length of 2048, excluding whitespace.
- `policy_name`: The policy name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"setAsDefault"`: Specifies whether the policy version is set as the default. When this
  parameter is true, the new policy version becomes the operative version (that is, the
  version that is in effect for the certificates to which the policy is attached).
"""
function create_policy_version(
    policyDocument, policyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/policies/$(policyName)/version",
        Dict{String,Any}("policyDocument" => policyDocument);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_policy_version(
    policyDocument,
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/policies/$(policyName)/version",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyDocument" => policyDocument), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_provisioning_claim(template_name)
    create_provisioning_claim(template_name, params::Dict{String,<:Any})

Creates a provisioning claim. Requires permission to access the CreateProvisioningClaim
action.

# Arguments
- `template_name`: The name of the provisioning template to use.

"""
function create_provisioning_claim(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/provisioning-templates/$(templateName)/provisioning-claim";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_provisioning_claim(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/provisioning-templates/$(templateName)/provisioning-claim",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_provisioning_template(provisioning_role_arn, template_body, template_name)
    create_provisioning_template(provisioning_role_arn, template_body, template_name, params::Dict{String,<:Any})

Creates a provisioning template. Requires permission to access the
CreateProvisioningTemplate action.

# Arguments
- `provisioning_role_arn`: The role ARN for the role associated with the provisioning
  template. This IoT role grants permission to provision a device.
- `template_body`: The JSON formatted contents of the provisioning template.
- `template_name`: The name of the provisioning template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the provisioning template.
- `"enabled"`: True to enable the provisioning template, otherwise false.
- `"preProvisioningHook"`: Creates a pre-provisioning hook template. Only supports template
  of type FLEET_PROVISIONING. For more information about provisioning template types, see
  type.
- `"tags"`: Metadata which can be used to manage the provisioning template.  For URI
  Request parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line
  parameter use format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the
  cli-input-json file use format: \"tags\": \"key1=value1&amp;key2=value2...\"
- `"type"`: The type you define in a provisioning template. You can create a template with
  only one type. You can't change the template type after its creation. The default value is
  FLEET_PROVISIONING. For more information about provisioning template, see: Provisioning
  template.
"""
function create_provisioning_template(
    provisioningRoleArn,
    templateBody,
    templateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/provisioning-templates",
        Dict{String,Any}(
            "provisioningRoleArn" => provisioningRoleArn,
            "templateBody" => templateBody,
            "templateName" => templateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_provisioning_template(
    provisioningRoleArn,
    templateBody,
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/provisioning-templates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "provisioningRoleArn" => provisioningRoleArn,
                    "templateBody" => templateBody,
                    "templateName" => templateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_provisioning_template_version(template_body, template_name)
    create_provisioning_template_version(template_body, template_name, params::Dict{String,<:Any})

Creates a new version of a provisioning template. Requires permission to access the
CreateProvisioningTemplateVersion action.

# Arguments
- `template_body`: The JSON formatted contents of the provisioning template.
- `template_name`: The name of the provisioning template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"setAsDefault"`: Sets a fleet provision template version as the default version.
"""
function create_provisioning_template_version(
    templateBody, templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/provisioning-templates/$(templateName)/versions",
        Dict{String,Any}("templateBody" => templateBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_provisioning_template_version(
    templateBody,
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/provisioning-templates/$(templateName)/versions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("templateBody" => templateBody), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_role_alias(role_alias, role_arn)
    create_role_alias(role_alias, role_arn, params::Dict{String,<:Any})

Creates a role alias. Requires permission to access the CreateRoleAlias action.

# Arguments
- `role_alias`: The role alias that points to a role ARN. This allows you to change the
  role without having to update the device.
- `role_arn`: The role ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"credentialDurationSeconds"`: How long (in seconds) the credentials will be valid. The
  default value is 3,600 seconds. This value must be less than or equal to the maximum
  session duration of the IAM role that the role alias references.
- `"tags"`: Metadata which can be used to manage the role alias.  For URI Request
  parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter
  use format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file
  use format: \"tags\": \"key1=value1&amp;key2=value2...\"
"""
function create_role_alias(
    roleAlias, roleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/role-aliases/$(roleAlias)",
        Dict{String,Any}("roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_role_alias(
    roleAlias,
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/role-aliases/$(roleAlias)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("roleArn" => roleArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_scheduled_audit(frequency, scheduled_audit_name, target_check_names)
    create_scheduled_audit(frequency, scheduled_audit_name, target_check_names, params::Dict{String,<:Any})

Creates a scheduled audit that is run at a specified time interval. Requires permission to
access the CreateScheduledAudit action.

# Arguments
- `frequency`: How often the scheduled audit takes place, either DAILY, WEEKLY, BIWEEKLY or
  MONTHLY. The start time of each audit is determined by the system.
- `scheduled_audit_name`: The name you want to give to the scheduled audit. (Max. 128 chars)
- `target_check_names`: Which checks are performed during the scheduled audit. Checks must
  be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all
  checks, including those that are enabled or use UpdateAccountAuditConfiguration to select
  which checks are enabled.)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dayOfMonth"`: The day of the month on which the scheduled audit takes place. This can
  be \"1\" through \"31\" or \"LAST\". This field is required if the \"frequency\" parameter
  is set to MONTHLY. If days 29 to 31 are specified, and the month doesn't have that many
  days, the audit takes place on the LAST day of the month.
- `"dayOfWeek"`: The day of the week on which the scheduled audit takes place, either SUN,
  MON, TUE, WED, THU, FRI, or SAT. This field is required if the frequency parameter is set
  to WEEKLY or BIWEEKLY.
- `"tags"`: Metadata that can be used to manage the scheduled audit.
"""
function create_scheduled_audit(
    frequency,
    scheduledAuditName,
    targetCheckNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/scheduledaudits/$(scheduledAuditName)",
        Dict{String,Any}("frequency" => frequency, "targetCheckNames" => targetCheckNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_scheduled_audit(
    frequency,
    scheduledAuditName,
    targetCheckNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/scheduledaudits/$(scheduledAuditName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "frequency" => frequency, "targetCheckNames" => targetCheckNames
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_security_profile(security_profile_name)
    create_security_profile(security_profile_name, params::Dict{String,<:Any})

Creates a Device Defender security profile. Requires permission to access the
CreateSecurityProfile action.

# Arguments
- `security_profile_name`: The name you are giving to the security profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalMetricsToRetain"`:  Please use
  CreateSecurityProfileRequestadditionalMetricsToRetainV2 instead.  A list of metrics whose
  data is retained (stored). By default, data is retained for any metric used in the
  profile's behaviors, but it is also retained for any metric specified here. Can be used
  with custom metrics; cannot be used with dimensions.
- `"additionalMetricsToRetainV2"`: A list of metrics whose data is retained (stored). By
  default, data is retained for any metric used in the profile's behaviors, but it is also
  retained for any metric specified here. Can be used with custom metrics; cannot be used
  with dimensions.
- `"alertTargets"`: Specifies the destinations to which alerts are sent. (Alerts are always
  sent to the console.) Alerts are generated when a device (thing) violates a behavior.
- `"behaviors"`: Specifies the behaviors that, when violated by a device (thing), cause an
  alert.
- `"metricsExportConfig"`: Specifies the MQTT topic and role ARN required for metric export.
- `"securityProfileDescription"`: A description of the security profile.
- `"tags"`: Metadata that can be used to manage the security profile.
"""
function create_security_profile(
    securityProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/security-profiles/$(securityProfileName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_security_profile(
    securityProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/security-profiles/$(securityProfileName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_stream(files, role_arn, stream_id)
    create_stream(files, role_arn, stream_id, params::Dict{String,<:Any})

Creates a stream for delivering one or more large files in chunks over MQTT. A stream
transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3.
You can have one or more files associated with a stream. Requires permission to access the
CreateStream action.

# Arguments
- `files`: The files to stream.
- `role_arn`: An IAM role that allows the IoT service principal to access your S3 files.
- `stream_id`: The stream ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the stream.
- `"tags"`: Metadata which can be used to manage streams.
"""
function create_stream(
    files, roleArn, streamId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/streams/$(streamId)",
        Dict{String,Any}("files" => files, "roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_stream(
    files,
    roleArn,
    streamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/streams/$(streamId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("files" => files, "roleArn" => roleArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_thing(thing_name)
    create_thing(thing_name, params::Dict{String,<:Any})

Creates a thing record in the registry. If this call is made multiple times using the same
thing name and configuration, the call will succeed. If this call is made with the same
thing name but different configuration a ResourceAlreadyExistsException is thrown.  This is
a control plane operation. See Authorization for information about authorizing control
plane actions.  Requires permission to access the CreateThing action.

# Arguments
- `thing_name`: The name of the thing to create. You can't change a thing's name after you
  create it. To change a thing's name, you must create a new thing, give it the new name, and
  then delete the old thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributePayload"`: The attribute payload, which consists of up to three name/value
  pairs in a JSON document. For example:  {\"attributes\":{\"string1\":\"string2\"}}
- `"billingGroupName"`: The name of the billing group the thing will be added to.
- `"thingTypeName"`: The name of the thing type associated with the new thing.
"""
function create_thing(thingName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/things/$(thingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/things/$(thingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_thing_group(thing_group_name)
    create_thing_group(thing_group_name, params::Dict{String,<:Any})

Create a thing group.  This is a control plane operation. See Authorization for information
about authorizing control plane actions. If the ThingGroup that you create has the exact
same attributes as an existing ThingGroup, you will get a 200 success response.   Requires
permission to access the CreateThingGroup action.

# Arguments
- `thing_group_name`: The thing group name to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"parentGroupName"`: The name of the parent thing group.
- `"tags"`: Metadata which can be used to manage the thing group.
- `"thingGroupProperties"`: The thing group properties.
"""
function create_thing_group(
    thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/thing-groups/$(thingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_thing_group(
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/thing-groups/$(thingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_thing_type(thing_type_name)
    create_thing_type(thing_type_name, params::Dict{String,<:Any})

Creates a new thing type. Requires permission to access the CreateThingType action.

# Arguments
- `thing_type_name`: The name of the thing type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: Metadata which can be used to manage the thing type.
- `"thingTypeProperties"`: The ThingTypeProperties for the thing type to create. It
  contains information about the new thing type including a description, and a list of
  searchable thing attribute names.
"""
function create_thing_type(
    thingTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/thing-types/$(thingTypeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_thing_type(
    thingTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/thing-types/$(thingTypeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_topic_rule(rule_name, topic_rule_payload)
    create_topic_rule(rule_name, topic_rule_payload, params::Dict{String,<:Any})

Creates a rule. Creating rules is an administrator-level action. Any user who has
permission to create rules will be able to access data processed by the rule. Requires
permission to access the CreateTopicRule action.

# Arguments
- `rule_name`: The name of the rule.
- `topic_rule_payload`: The rule payload.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-tagging"`: Metadata which can be used to manage the topic rule.  For URI Request
  parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter
  use format: --tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file use
  format: \"tags\": \"key1=value1&amp;key2=value2...\"
"""
function create_topic_rule(
    ruleName, topicRulePayload; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/rules/$(ruleName)",
        Dict{String,Any}("topicRulePayload" => topicRulePayload);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_topic_rule(
    ruleName,
    topicRulePayload,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/rules/$(ruleName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("topicRulePayload" => topicRulePayload), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_topic_rule_destination(destination_configuration)
    create_topic_rule_destination(destination_configuration, params::Dict{String,<:Any})

Creates a topic rule destination. The destination must be confirmed prior to use. Requires
permission to access the CreateTopicRuleDestination action.

# Arguments
- `destination_configuration`: The topic rule destination configuration.

"""
function create_topic_rule_destination(
    destinationConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/destinations",
        Dict{String,Any}("destinationConfiguration" => destinationConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_topic_rule_destination(
    destinationConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/destinations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("destinationConfiguration" => destinationConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_audit_configuration()
    delete_account_audit_configuration(params::Dict{String,<:Any})

Restores the default settings for Device Defender audits for this account. Any
configuration data you entered is deleted and all audit checks are reset to disabled.
Requires permission to access the DeleteAccountAuditConfiguration action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deleteScheduledAudits"`: If true, all scheduled audits are deleted.
"""
function delete_account_audit_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/audit/configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_audit_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/audit/configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_audit_suppression(check_name, resource_identifier)
    delete_audit_suppression(check_name, resource_identifier, params::Dict{String,<:Any})

 Deletes a Device Defender audit suppression.  Requires permission to access the
DeleteAuditSuppression action.

# Arguments
- `check_name`:
- `resource_identifier`:

"""
function delete_audit_suppression(
    checkName, resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/audit/suppressions/delete",
        Dict{String,Any}(
            "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_audit_suppression(
    checkName,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/suppressions/delete",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_authorizer(authorizer_name)
    delete_authorizer(authorizer_name, params::Dict{String,<:Any})

Deletes an authorizer. Requires permission to access the DeleteAuthorizer action.

# Arguments
- `authorizer_name`: The name of the authorizer to delete.

"""
function delete_authorizer(
    authorizerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/authorizer/$(authorizerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_authorizer(
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/authorizer/$(authorizerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_billing_group(billing_group_name)
    delete_billing_group(billing_group_name, params::Dict{String,<:Any})

Deletes the billing group. Requires permission to access the DeleteBillingGroup action.

# Arguments
- `billing_group_name`: The name of the billing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the billing group. If the version of the
  billing group does not match the expected version specified in the request, the
  DeleteBillingGroup request is rejected with a VersionConflictException.
"""
function delete_billing_group(
    billingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/billing-groups/$(billingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_billing_group(
    billingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/billing-groups/$(billingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cacertificate(ca_certificate_id)
    delete_cacertificate(ca_certificate_id, params::Dict{String,<:Any})

Deletes a registered CA certificate. Requires permission to access the DeleteCACertificate
action.

# Arguments
- `ca_certificate_id`: The ID of the certificate to delete. (The last part of the
  certificate ARN contains the certificate ID.)

"""
function delete_cacertificate(
    caCertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/cacertificate/$(caCertificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cacertificate(
    caCertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/cacertificate/$(caCertificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_certificate(certificate_id)
    delete_certificate(certificate_id, params::Dict{String,<:Any})

Deletes the specified certificate. A certificate cannot be deleted if it has a policy or
IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first
use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action
to set the certificate to the INACTIVE status. Requires permission to access the
DeleteCertificate action.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceDelete"`: Forces the deletion of a certificate if it is inactive and is not
  attached to an IoT thing.
"""
function delete_certificate(
    certificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/certificates/$(certificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_certificate(
    certificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/certificates/$(certificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_certificate_provider(certificate_provider_name)
    delete_certificate_provider(certificate_provider_name, params::Dict{String,<:Any})

Deletes a certificate provider. Requires permission to access the DeleteCertificateProvider
action.  If you delete the certificate provider resource, the behavior of
CreateCertificateFromCsr will resume, and IoT will create certificates signed by IoT from a
certificate signing request (CSR).

# Arguments
- `certificate_provider_name`: The name of the certificate provider.

"""
function delete_certificate_provider(
    certificateProviderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/certificate-providers/$(certificateProviderName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_certificate_provider(
    certificateProviderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/certificate-providers/$(certificateProviderName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_metric(metric_name)
    delete_custom_metric(metric_name, params::Dict{String,<:Any})

 Deletes a Device Defender detect custom metric.  Requires permission to access the
DeleteCustomMetric action.  Before you can delete a custom metric, you must first remove
the custom metric from all security profiles it's a part of. The security profile
associated with the custom metric can be found using the ListSecurityProfiles API with
metricName set to your custom metric name.

# Arguments
- `metric_name`:  The name of the custom metric.

"""
function delete_custom_metric(
    metricName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/custom-metric/$(metricName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_metric(
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/custom-metric/$(metricName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dimension(name)
    delete_dimension(name, params::Dict{String,<:Any})

Removes the specified dimension from your Amazon Web Services accounts. Requires permission
to access the DeleteDimension action.

# Arguments
- `name`: The unique identifier for the dimension that you want to delete.

"""
function delete_dimension(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/dimensions/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dimension(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/dimensions/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain_configuration(domain_configuration_name)
    delete_domain_configuration(domain_configuration_name, params::Dict{String,<:Any})

Deletes the specified domain configuration. Requires permission to access the
DeleteDomainConfiguration action.

# Arguments
- `domain_configuration_name`: The name of the domain configuration to be deleted.

"""
function delete_domain_configuration(
    domainConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/domainConfigurations/$(domainConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain_configuration(
    domainConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/domainConfigurations/$(domainConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dynamic_thing_group(thing_group_name)
    delete_dynamic_thing_group(thing_group_name, params::Dict{String,<:Any})

Deletes a dynamic thing group. Requires permission to access the DeleteDynamicThingGroup
action.

# Arguments
- `thing_group_name`: The name of the dynamic thing group to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the dynamic thing group to delete.
"""
function delete_dynamic_thing_group(
    thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/dynamic-thing-groups/$(thingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dynamic_thing_group(
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/dynamic-thing-groups/$(thingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleet_metric(metric_name)
    delete_fleet_metric(metric_name, params::Dict{String,<:Any})

Deletes the specified fleet metric. Returns successfully with no error if the deletion is
successful or you specify a fleet metric that doesn't exist. Requires permission to access
the DeleteFleetMetric action.

# Arguments
- `metric_name`: The name of the fleet metric to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the fleet metric to delete.
"""
function delete_fleet_metric(metricName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/fleet-metric/$(metricName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleet_metric(
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/fleet-metric/$(metricName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_job(job_id)
    delete_job(job_id, params::Dict{String,<:Any})

Deletes a job and its related job executions. Deleting a job may take time, depending on
the number of job executions created for the job and various other factors. While the job
is being deleted, the status of the job will be shown as \"DELETION_IN_PROGRESS\".
Attempting to delete or cancel a job whose status is already \"DELETION_IN_PROGRESS\" will
result in an error. Only 10 jobs may have status \"DELETION_IN_PROGRESS\" at the same time,
or a LimitExceededException will occur. Requires permission to access the DeleteJob action.

# Arguments
- `job_id`: The ID of the job to be deleted. After a job deletion is completed, you may
  reuse this jobId when you create a new job. However, this is not recommended, and you must
  ensure that your devices are not using the jobId to refer to the deleted job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: (Optional) When true, you can delete a job which is \"IN_PROGRESS\".
  Otherwise, you can only delete a job which is in a terminal state (\"COMPLETED\" or
  \"CANCELED\") or an exception will occur. The default is false.  Deleting a job which is
  \"IN_PROGRESS\", will cause a device which is executing the job to be unable to access job
  information or update the job execution status. Use caution and ensure that each device
  executing a job which is deleted is able to recover to a valid state.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
"""
function delete_job(jobId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE", "/jobs/$(jobId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_job(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/jobs/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_job_execution(execution_number, job_id, thing_name)
    delete_job_execution(execution_number, job_id, thing_name, params::Dict{String,<:Any})

Deletes a job execution. Requires permission to access the DeleteJobExecution action.

# Arguments
- `execution_number`: The ID of the job execution to be deleted. The executionNumber refers
  to the execution of a particular job on a particular device. Note that once a job execution
  is deleted, the executionNumber may be reused by IoT, so be sure you get and use the
  correct value here.
- `job_id`: The ID of the job whose execution on a particular device will be deleted.
- `thing_name`: The name of the thing whose job execution will be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: (Optional) When true, you can delete a job execution which is \"IN_PROGRESS\".
  Otherwise, you can only delete a job execution which is in a terminal state (\"SUCCEEDED\",
  \"FAILED\", \"REJECTED\", \"REMOVED\" or \"CANCELED\") or an exception will occur. The
  default is false.  Deleting a job execution which is \"IN_PROGRESS\", will cause the device
  to be unable to access job information or update the job execution status. Use caution and
  ensure that the device is able to recover to a valid state.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
"""
function delete_job_execution(
    executionNumber, jobId, thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/things/$(thingName)/jobs/$(jobId)/executionNumber/$(executionNumber)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_job_execution(
    executionNumber,
    jobId,
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/things/$(thingName)/jobs/$(jobId)/executionNumber/$(executionNumber)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_job_template(job_template_id)
    delete_job_template(job_template_id, params::Dict{String,<:Any})

Deletes the specified job template.

# Arguments
- `job_template_id`: The unique identifier of the job template to delete.

"""
function delete_job_template(
    jobTemplateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/job-templates/$(jobTemplateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_job_template(
    jobTemplateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/job-templates/$(jobTemplateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_mitigation_action(action_name)
    delete_mitigation_action(action_name, params::Dict{String,<:Any})

Deletes a defined mitigation action from your Amazon Web Services accounts. Requires
permission to access the DeleteMitigationAction action.

# Arguments
- `action_name`: The name of the mitigation action that you want to delete.

"""
function delete_mitigation_action(
    actionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/mitigationactions/actions/$(actionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_mitigation_action(
    actionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/mitigationactions/actions/$(actionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_otaupdate(ota_update_id)
    delete_otaupdate(ota_update_id, params::Dict{String,<:Any})

Delete an OTA update. Requires permission to access the DeleteOTAUpdate action.

# Arguments
- `ota_update_id`: The ID of the OTA update to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deleteStream"`: When true, the stream created by the OTAUpdate process is deleted when
  the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by
  the user.
- `"forceDeleteAWSJob"`: When true, deletes the IoT job created by the OTAUpdate process
  even if it is \"IN_PROGRESS\". Otherwise, if the job is not in a terminal state
  (\"COMPLETED\" or \"CANCELED\") an exception will occur. The default is false.
"""
function delete_otaupdate(otaUpdateId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/otaUpdates/$(otaUpdateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_otaupdate(
    otaUpdateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/otaUpdates/$(otaUpdateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_package(package_name)
    delete_package(package_name, params::Dict{String,<:Any})

Deletes a specific version from a software package.  Note: All package versions must be
deleted before deleting the software package. Requires permission to access the
DeletePackageVersion action.

# Arguments
- `package_name`: The name of the target software package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
"""
function delete_package(packageName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/packages/$(packageName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_package(
    packageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/packages/$(packageName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_package_version(package_name, version_name)
    delete_package_version(package_name, version_name, params::Dict{String,<:Any})

Deletes a specific version from a software package.  Note: If a package version is
designated as default, you must remove the designation from the software package using the
UpdatePackage action.

# Arguments
- `package_name`: The name of the associated software package.
- `version_name`: The name of the target package version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
"""
function delete_package_version(
    packageName, versionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_package_version(
    packageName,
    versionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy(policy_name)
    delete_policy(policy_name, params::Dict{String,<:Any})

Deletes the specified policy. A policy cannot be deleted if it has non-default versions or
it is attached to any certificate. To delete a policy, use the DeletePolicyVersion action
to delete all non-default versions of the policy; use the DetachPolicy action to detach the
policy from any certificate; and then use the DeletePolicy action to delete the policy.
When a policy is deleted using DeletePolicy, its default version is deleted with it.
Because of the distributed nature of Amazon Web Services, it can take up to five minutes
after a policy is detached before it's ready to be deleted.  Requires permission to access
the DeletePolicy action.

# Arguments
- `policy_name`: The name of the policy to delete.

"""
function delete_policy(policyName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/policies/$(policyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy(
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/policies/$(policyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy_version(policy_name, policy_version_id)
    delete_policy_version(policy_name, policy_version_id, params::Dict{String,<:Any})

Deletes the specified version of the specified policy. You cannot delete the default
version of a policy using this action. To delete the default version of a policy, use
DeletePolicy. To find out which version of a policy is marked as the default version, use
ListPolicyVersions. Requires permission to access the DeletePolicyVersion action.

# Arguments
- `policy_name`: The name of the policy.
- `policy_version_id`: The policy version ID.

"""
function delete_policy_version(
    policyName, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/policies/$(policyName)/version/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy_version(
    policyName,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/policies/$(policyName)/version/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_provisioning_template(template_name)
    delete_provisioning_template(template_name, params::Dict{String,<:Any})

Deletes a provisioning template. Requires permission to access the
DeleteProvisioningTemplate action.

# Arguments
- `template_name`: The name of the fleet provision template to delete.

"""
function delete_provisioning_template(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/provisioning-templates/$(templateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_provisioning_template(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/provisioning-templates/$(templateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_provisioning_template_version(template_name, version_id)
    delete_provisioning_template_version(template_name, version_id, params::Dict{String,<:Any})

Deletes a provisioning template version. Requires permission to access the
DeleteProvisioningTemplateVersion action.

# Arguments
- `template_name`: The name of the provisioning template version to delete.
- `version_id`: The provisioning template version ID to delete.

"""
function delete_provisioning_template_version(
    templateName, versionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/provisioning-templates/$(templateName)/versions/$(versionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_provisioning_template_version(
    templateName,
    versionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/provisioning-templates/$(templateName)/versions/$(versionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registration_code()
    delete_registration_code(params::Dict{String,<:Any})

Deletes a CA certificate registration code. Requires permission to access the
DeleteRegistrationCode action.

"""
function delete_registration_code(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/registrationcode";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_registration_code(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/registrationcode",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_role_alias(role_alias)
    delete_role_alias(role_alias, params::Dict{String,<:Any})

Deletes a role alias Requires permission to access the DeleteRoleAlias action.

# Arguments
- `role_alias`: The role alias to delete.

"""
function delete_role_alias(roleAlias; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/role-aliases/$(roleAlias)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_role_alias(
    roleAlias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/role-aliases/$(roleAlias)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_scheduled_audit(scheduled_audit_name)
    delete_scheduled_audit(scheduled_audit_name, params::Dict{String,<:Any})

Deletes a scheduled audit. Requires permission to access the DeleteScheduledAudit action.

# Arguments
- `scheduled_audit_name`: The name of the scheduled audit you want to delete.

"""
function delete_scheduled_audit(
    scheduledAuditName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/audit/scheduledaudits/$(scheduledAuditName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_scheduled_audit(
    scheduledAuditName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/audit/scheduledaudits/$(scheduledAuditName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_security_profile(security_profile_name)
    delete_security_profile(security_profile_name, params::Dict{String,<:Any})

Deletes a Device Defender security profile. Requires permission to access the
DeleteSecurityProfile action.

# Arguments
- `security_profile_name`: The name of the security profile to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the security profile. A new version is
  generated whenever the security profile is updated. If you specify a value that is
  different from the actual version, a VersionConflictException is thrown.
"""
function delete_security_profile(
    securityProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/security-profiles/$(securityProfileName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_security_profile(
    securityProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/security-profiles/$(securityProfileName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_stream(stream_id)
    delete_stream(stream_id, params::Dict{String,<:Any})

Deletes a stream. Requires permission to access the DeleteStream action.

# Arguments
- `stream_id`: The stream ID.

"""
function delete_stream(streamId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/streams/$(streamId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_stream(
    streamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/streams/$(streamId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_thing(thing_name)
    delete_thing(thing_name, params::Dict{String,<:Any})

Deletes the specified thing. Returns successfully with no error if the deletion is
successful or you specify a thing that doesn't exist. Requires permission to access the
DeleteThing action.

# Arguments
- `thing_name`: The name of the thing to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the thing record in the registry. If the
  version of the record in the registry does not match the expected version specified in the
  request, the DeleteThing request is rejected with a VersionConflictException.
"""
function delete_thing(thingName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/things/$(thingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/things/$(thingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_thing_group(thing_group_name)
    delete_thing_group(thing_group_name, params::Dict{String,<:Any})

Deletes a thing group. Requires permission to access the DeleteThingGroup action.

# Arguments
- `thing_group_name`: The name of the thing group to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the thing group to delete.
"""
function delete_thing_group(
    thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/thing-groups/$(thingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_thing_group(
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/thing-groups/$(thingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_thing_type(thing_type_name)
    delete_thing_type(thing_type_name, params::Dict{String,<:Any})

Deletes the specified thing type. You cannot delete a thing type if it has things
associated with it. To delete a thing type, first mark it as deprecated by calling
DeprecateThingType, then remove any associated things by calling UpdateThing to change the
thing type on any associated thing, and finally use DeleteThingType to delete the thing
type. Requires permission to access the DeleteThingType action.

# Arguments
- `thing_type_name`: The name of the thing type.

"""
function delete_thing_type(
    thingTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/thing-types/$(thingTypeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_thing_type(
    thingTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/thing-types/$(thingTypeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_topic_rule(rule_name)
    delete_topic_rule(rule_name, params::Dict{String,<:Any})

Deletes the rule. Requires permission to access the DeleteTopicRule action.

# Arguments
- `rule_name`: The name of the rule.

"""
function delete_topic_rule(ruleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "DELETE",
        "/rules/$(ruleName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_topic_rule(
    ruleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/rules/$(ruleName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_topic_rule_destination(arn)
    delete_topic_rule_destination(arn, params::Dict{String,<:Any})

Deletes a topic rule destination. Requires permission to access the
DeleteTopicRuleDestination action.

# Arguments
- `arn`: The ARN of the topic rule destination to delete.

"""
function delete_topic_rule_destination(
    arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/destinations/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_topic_rule_destination(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/destinations/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_v2_logging_level(target_name, target_type)
    delete_v2_logging_level(target_name, target_type, params::Dict{String,<:Any})

Deletes a logging level. Requires permission to access the DeleteV2LoggingLevel action.

# Arguments
- `target_name`: The name of the resource for which you are configuring logging.
- `target_type`: The type of resource for which you are configuring logging. Must be
  THING_Group.

"""
function delete_v2_logging_level(
    targetName, targetType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/v2LoggingLevel",
        Dict{String,Any}("targetName" => targetName, "targetType" => targetType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_v2_logging_level(
    targetName,
    targetType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/v2LoggingLevel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("targetName" => targetName, "targetType" => targetType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprecate_thing_type(thing_type_name)
    deprecate_thing_type(thing_type_name, params::Dict{String,<:Any})

Deprecates a thing type. You can not associate new things with deprecated thing type.
Requires permission to access the DeprecateThingType action.

# Arguments
- `thing_type_name`: The name of the thing type to deprecate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"undoDeprecate"`: Whether to undeprecate a deprecated thing type. If true, the thing
  type will not be deprecated anymore and you can associate it with things.
"""
function deprecate_thing_type(
    thingTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/thing-types/$(thingTypeName)/deprecate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprecate_thing_type(
    thingTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/thing-types/$(thingTypeName)/deprecate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_audit_configuration()
    describe_account_audit_configuration(params::Dict{String,<:Any})

Gets information about the Device Defender audit settings for this account. Settings
include how audit notifications are sent and which audit checks are enabled or disabled.
Requires permission to access the DescribeAccountAuditConfiguration action.

"""
function describe_account_audit_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_account_audit_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_audit_finding(finding_id)
    describe_audit_finding(finding_id, params::Dict{String,<:Any})

Gets information about a single audit finding. Properties include the reason for
noncompliance, the severity of the issue, and the start time when the audit that returned
the finding. Requires permission to access the DescribeAuditFinding action.

# Arguments
- `finding_id`: A unique identifier for a single audit finding. You can use this identifier
  to apply mitigation actions to the finding.

"""
function describe_audit_finding(
    findingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/findings/$(findingId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_audit_finding(
    findingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/findings/$(findingId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_audit_mitigation_actions_task(task_id)
    describe_audit_mitigation_actions_task(task_id, params::Dict{String,<:Any})

Gets information about an audit mitigation task that is used to apply mitigation actions to
a set of audit findings. Properties include the actions being applied, the audit checks to
which they're being applied, the task status, and aggregated task statistics.

# Arguments
- `task_id`: The unique identifier for the audit mitigation task.

"""
function describe_audit_mitigation_actions_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/mitigationactions/tasks/$(taskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_audit_mitigation_actions_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/mitigationactions/tasks/$(taskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_audit_suppression(check_name, resource_identifier)
    describe_audit_suppression(check_name, resource_identifier, params::Dict{String,<:Any})

 Gets information about a Device Defender audit suppression.

# Arguments
- `check_name`:
- `resource_identifier`:

"""
function describe_audit_suppression(
    checkName, resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/audit/suppressions/describe",
        Dict{String,Any}(
            "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_audit_suppression(
    checkName,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/suppressions/describe",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_audit_task(task_id)
    describe_audit_task(task_id, params::Dict{String,<:Any})

Gets information about a Device Defender audit. Requires permission to access the
DescribeAuditTask action.

# Arguments
- `task_id`: The ID of the audit whose information you want to get.

"""
function describe_audit_task(taskId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/audit/tasks/$(taskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_audit_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/tasks/$(taskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_authorizer(authorizer_name)
    describe_authorizer(authorizer_name, params::Dict{String,<:Any})

Describes an authorizer. Requires permission to access the DescribeAuthorizer action.

# Arguments
- `authorizer_name`: The name of the authorizer to describe.

"""
function describe_authorizer(
    authorizerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/authorizer/$(authorizerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_authorizer(
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/authorizer/$(authorizerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_billing_group(billing_group_name)
    describe_billing_group(billing_group_name, params::Dict{String,<:Any})

Returns information about a billing group. Requires permission to access the
DescribeBillingGroup action.

# Arguments
- `billing_group_name`: The name of the billing group.

"""
function describe_billing_group(
    billingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/billing-groups/$(billingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_billing_group(
    billingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/billing-groups/$(billingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cacertificate(ca_certificate_id)
    describe_cacertificate(ca_certificate_id, params::Dict{String,<:Any})

Describes a registered CA certificate. Requires permission to access the
DescribeCACertificate action.

# Arguments
- `ca_certificate_id`: The CA certificate identifier.

"""
function describe_cacertificate(
    caCertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/cacertificate/$(caCertificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cacertificate(
    caCertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/cacertificate/$(caCertificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificate(certificate_id)
    describe_certificate(certificate_id, params::Dict{String,<:Any})

Gets information about the specified certificate. Requires permission to access the
DescribeCertificate action.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)

"""
function describe_certificate(
    certificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificates/$(certificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_certificate(
    certificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/certificates/$(certificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificate_provider(certificate_provider_name)
    describe_certificate_provider(certificate_provider_name, params::Dict{String,<:Any})

Describes a certificate provider. Requires permission to access the
DescribeCertificateProvider action.

# Arguments
- `certificate_provider_name`: The name of the certificate provider.

"""
function describe_certificate_provider(
    certificateProviderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificate-providers/$(certificateProviderName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_certificate_provider(
    certificateProviderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/certificate-providers/$(certificateProviderName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_custom_metric(metric_name)
    describe_custom_metric(metric_name, params::Dict{String,<:Any})

 Gets information about a Device Defender detect custom metric.  Requires permission to
access the DescribeCustomMetric action.

# Arguments
- `metric_name`:  The name of the custom metric.

"""
function describe_custom_metric(
    metricName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/custom-metric/$(metricName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_custom_metric(
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/custom-metric/$(metricName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_default_authorizer()
    describe_default_authorizer(params::Dict{String,<:Any})

Describes the default authorizer. Requires permission to access the
DescribeDefaultAuthorizer action.

"""
function describe_default_authorizer(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/default-authorizer"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_default_authorizer(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/default-authorizer",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_detect_mitigation_actions_task(task_id)
    describe_detect_mitigation_actions_task(task_id, params::Dict{String,<:Any})

 Gets information about a Device Defender ML Detect mitigation action.  Requires permission
to access the DescribeDetectMitigationActionsTask action.

# Arguments
- `task_id`:  The unique identifier of the task.

"""
function describe_detect_mitigation_actions_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/detect/mitigationactions/tasks/$(taskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_detect_mitigation_actions_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/detect/mitigationactions/tasks/$(taskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dimension(name)
    describe_dimension(name, params::Dict{String,<:Any})

Provides details about a dimension that is defined in your Amazon Web Services accounts.
Requires permission to access the DescribeDimension action.

# Arguments
- `name`: The unique identifier for the dimension.

"""
function describe_dimension(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/dimensions/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dimension(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/dimensions/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_configuration(domain_configuration_name)
    describe_domain_configuration(domain_configuration_name, params::Dict{String,<:Any})

Gets summary information about a domain configuration. Requires permission to access the
DescribeDomainConfiguration action.

# Arguments
- `domain_configuration_name`: The name of the domain configuration.

"""
function describe_domain_configuration(
    domainConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/domainConfigurations/$(domainConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_configuration(
    domainConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/domainConfigurations/$(domainConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_endpoint()
    describe_endpoint(params::Dict{String,<:Any})

Returns or creates a unique endpoint specific to the Amazon Web Services account making the
call.  The first time DescribeEndpoint is called, an endpoint is created. All subsequent
calls to DescribeEndpoint return the same endpoint.  Requires permission to access the
DescribeEndpoint action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endpointType"`: The endpoint type. Valid endpoint types include:    iot:Data - Returns
  a VeriSign signed data endpoint.      iot:Data-ATS - Returns an ATS signed data endpoint.
     iot:CredentialProvider - Returns an IoT credentials provider API endpoint.      iot:Jobs
  - Returns an IoT device management Jobs API endpoint.   We strongly recommend that
  customers use the newer iot:Data-ATS endpoint type to avoid issues related to the
  widespread distrust of Symantec certificate authorities. ATS Signed Certificates are more
  secure and are trusted by most popular browsers.
"""
function describe_endpoint(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/endpoint"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_endpoint(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/endpoint", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_event_configurations()
    describe_event_configurations(params::Dict{String,<:Any})

Describes event configurations. Requires permission to access the
DescribeEventConfigurations action.

"""
function describe_event_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/event-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_event_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/event-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleet_metric(metric_name)
    describe_fleet_metric(metric_name, params::Dict{String,<:Any})

Gets information about the specified fleet metric. Requires permission to access the
DescribeFleetMetric action.

# Arguments
- `metric_name`: The name of the fleet metric to describe.

"""
function describe_fleet_metric(
    metricName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/fleet-metric/$(metricName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fleet_metric(
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/fleet-metric/$(metricName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_index(index_name)
    describe_index(index_name, params::Dict{String,<:Any})

Describes a search index. Requires permission to access the DescribeIndex action.

# Arguments
- `index_name`: The index name.

"""
function describe_index(indexName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/indices/$(indexName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_index(
    indexName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/indices/$(indexName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job(job_id)
    describe_job(job_id, params::Dict{String,<:Any})

Describes a job. Requires permission to access the DescribeJob action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.

"""
function describe_job(jobId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/jobs/$(jobId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_job(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/jobs/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job_execution(job_id, thing_name)
    describe_job_execution(job_id, thing_name, params::Dict{String,<:Any})

Describes a job execution. Requires permission to access the DescribeJobExecution action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.
- `thing_name`: The name of the thing on which the job execution is running.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"executionNumber"`: A string (consisting of the digits \"0\" through \"9\" which is used
  to specify a particular job execution on a particular device.
"""
function describe_job_execution(
    jobId, thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/things/$(thingName)/jobs/$(jobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_job_execution(
    jobId,
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/things/$(thingName)/jobs/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_job_template(job_template_id)
    describe_job_template(job_template_id, params::Dict{String,<:Any})

Returns information about a job template.

# Arguments
- `job_template_id`: The unique identifier of the job template.

"""
function describe_job_template(
    jobTemplateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/job-templates/$(jobTemplateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_job_template(
    jobTemplateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/job-templates/$(jobTemplateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_managed_job_template(template_name)
    describe_managed_job_template(template_name, params::Dict{String,<:Any})

View details of a managed job template.

# Arguments
- `template_name`: The unique name of a managed job template, which is required.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"templateVersion"`: An optional parameter to specify version of a managed template. If
  not specified, the pre-defined default version is returned.
"""
function describe_managed_job_template(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/managed-job-templates/$(templateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_managed_job_template(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/managed-job-templates/$(templateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_mitigation_action(action_name)
    describe_mitigation_action(action_name, params::Dict{String,<:Any})

Gets information about a mitigation action. Requires permission to access the
DescribeMitigationAction action.

# Arguments
- `action_name`: The friendly name that uniquely identifies the mitigation action.

"""
function describe_mitigation_action(
    actionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/mitigationactions/actions/$(actionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_mitigation_action(
    actionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/mitigationactions/actions/$(actionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_provisioning_template(template_name)
    describe_provisioning_template(template_name, params::Dict{String,<:Any})

Returns information about a provisioning template. Requires permission to access the
DescribeProvisioningTemplate action.

# Arguments
- `template_name`: The name of the provisioning template.

"""
function describe_provisioning_template(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_provisioning_template(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_provisioning_template_version(template_name, version_id)
    describe_provisioning_template_version(template_name, version_id, params::Dict{String,<:Any})

Returns information about a provisioning template version. Requires permission to access
the DescribeProvisioningTemplateVersion action.

# Arguments
- `template_name`: The template name.
- `version_id`: The provisioning template version ID.

"""
function describe_provisioning_template_version(
    templateName, versionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)/versions/$(versionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_provisioning_template_version(
    templateName,
    versionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)/versions/$(versionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_role_alias(role_alias)
    describe_role_alias(role_alias, params::Dict{String,<:Any})

Describes a role alias. Requires permission to access the DescribeRoleAlias action.

# Arguments
- `role_alias`: The role alias to describe.

"""
function describe_role_alias(roleAlias; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/role-aliases/$(roleAlias)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_role_alias(
    roleAlias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/role-aliases/$(roleAlias)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scheduled_audit(scheduled_audit_name)
    describe_scheduled_audit(scheduled_audit_name, params::Dict{String,<:Any})

Gets information about a scheduled audit. Requires permission to access the
DescribeScheduledAudit action.

# Arguments
- `scheduled_audit_name`: The name of the scheduled audit whose information you want to get.

"""
function describe_scheduled_audit(
    scheduledAuditName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/scheduledaudits/$(scheduledAuditName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scheduled_audit(
    scheduledAuditName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/scheduledaudits/$(scheduledAuditName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_profile(security_profile_name)
    describe_security_profile(security_profile_name, params::Dict{String,<:Any})

Gets information about a Device Defender security profile. Requires permission to access
the DescribeSecurityProfile action.

# Arguments
- `security_profile_name`: The name of the security profile whose information you want to
  get.

"""
function describe_security_profile(
    securityProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/security-profiles/$(securityProfileName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_security_profile(
    securityProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/security-profiles/$(securityProfileName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stream(stream_id)
    describe_stream(stream_id, params::Dict{String,<:Any})

Gets information about a stream. Requires permission to access the DescribeStream action.

# Arguments
- `stream_id`: The stream ID.

"""
function describe_stream(streamId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/streams/$(streamId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stream(
    streamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/streams/$(streamId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_thing(thing_name)
    describe_thing(thing_name, params::Dict{String,<:Any})

Gets information about the specified thing. Requires permission to access the DescribeThing
action.

# Arguments
- `thing_name`: The name of the thing.

"""
function describe_thing(thingName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/things/$(thingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/things/$(thingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_thing_group(thing_group_name)
    describe_thing_group(thing_group_name, params::Dict{String,<:Any})

Describe a thing group. Requires permission to access the DescribeThingGroup action.

# Arguments
- `thing_group_name`: The name of the thing group.

"""
function describe_thing_group(
    thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-groups/$(thingGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_thing_group(
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/thing-groups/$(thingGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_thing_registration_task(task_id)
    describe_thing_registration_task(task_id, params::Dict{String,<:Any})

Describes a bulk thing provisioning task. Requires permission to access the
DescribeThingRegistrationTask action.

# Arguments
- `task_id`: The task ID.

"""
function describe_thing_registration_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-registration-tasks/$(taskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_thing_registration_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-registration-tasks/$(taskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_thing_type(thing_type_name)
    describe_thing_type(thing_type_name, params::Dict{String,<:Any})

Gets information about the specified thing type. Requires permission to access the
DescribeThingType action.

# Arguments
- `thing_type_name`: The name of the thing type.

"""
function describe_thing_type(
    thingTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-types/$(thingTypeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_thing_type(
    thingTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/thing-types/$(thingTypeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_policy(policy_name, target)
    detach_policy(policy_name, target, params::Dict{String,<:Any})

Detaches a policy from the specified target.  Because of the distributed nature of Amazon
Web Services, it can take up to five minutes after a policy is detached before it's ready
to be deleted.  Requires permission to access the DetachPolicy action.

# Arguments
- `policy_name`: The policy to detach.
- `target`: The target from which the policy will be detached.

"""
function detach_policy(
    policyName, target; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/target-policies/$(policyName)",
        Dict{String,Any}("target" => target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_policy(
    policyName,
    target,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/target-policies/$(policyName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("target" => target), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_principal_policy(policy_name, x-amzn-iot-principal)
    detach_principal_policy(policy_name, x-amzn-iot-principal, params::Dict{String,<:Any})

Removes the specified policy from the specified certificate.  Note: This action is
deprecated and works as expected for backward compatibility, but we won't add enhancements.
Use DetachPolicy instead. Requires permission to access the DetachPrincipalPolicy action.

# Arguments
- `policy_name`: The name of the policy to detach.
- `x-amzn-iot-principal`: The principal. Valid principals are CertificateArn
  (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn
  (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).

"""
function detach_principal_policy(
    policyName, x_amzn_iot_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/principal-policies/$(policyName)",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_principal_policy(
    policyName,
    x_amzn_iot_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/principal-policies/$(policyName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" =>
                        Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_security_profile(security_profile_name, security_profile_target_arn)
    detach_security_profile(security_profile_name, security_profile_target_arn, params::Dict{String,<:Any})

Disassociates a Device Defender security profile from a thing group or from this account.
Requires permission to access the DetachSecurityProfile action.

# Arguments
- `security_profile_name`: The security profile that is detached.
- `security_profile_target_arn`: The ARN of the thing group from which the security profile
  is detached.

"""
function detach_security_profile(
    securityProfileName,
    securityProfileTargetArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/security-profiles/$(securityProfileName)/targets",
        Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_security_profile(
    securityProfileName,
    securityProfileTargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/security-profiles/$(securityProfileName)/targets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_thing_principal(thing_name, x-amzn-principal)
    detach_thing_principal(thing_name, x-amzn-principal, params::Dict{String,<:Any})

Detaches the specified principal from the specified thing. A principal can be X.509
certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
identities.  This call is asynchronous. It might take several seconds for the detachment to
propagate.  Requires permission to access the DetachThingPrincipal action.

# Arguments
- `thing_name`: The name of the thing.
- `x-amzn-principal`: If the principal is a certificate, this value must be ARN of the
  certificate. If the principal is an Amazon Cognito identity, this value must be the ID of
  the Amazon Cognito identity.

"""
function detach_thing_principal(
    thingName, x_amzn_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "DELETE",
        "/things/$(thingName)/principals",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_thing_principal(
    thingName,
    x_amzn_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "DELETE",
        "/things/$(thingName)/principals",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_topic_rule(rule_name)
    disable_topic_rule(rule_name, params::Dict{String,<:Any})

Disables the rule. Requires permission to access the DisableTopicRule action.

# Arguments
- `rule_name`: The name of the rule to disable.

"""
function disable_topic_rule(ruleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/rules/$(ruleName)/disable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_topic_rule(
    ruleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/rules/$(ruleName)/disable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_topic_rule(rule_name)
    enable_topic_rule(rule_name, params::Dict{String,<:Any})

Enables the rule. Requires permission to access the EnableTopicRule action.

# Arguments
- `rule_name`: The name of the topic rule to enable.

"""
function enable_topic_rule(ruleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/rules/$(ruleName)/enable";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_topic_rule(
    ruleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/rules/$(ruleName)/enable",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_behavior_model_training_summaries()
    get_behavior_model_training_summaries(params::Dict{String,<:Any})

 Returns a Device Defender's ML Detect Security Profile training model's status.  Requires
permission to access the GetBehaviorModelTrainingSummaries action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of results to return at one time. The default is 10.
- `"nextToken"`:  The token for the next set of results.
- `"securityProfileName"`:  The name of the security profile.
"""
function get_behavior_model_training_summaries(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/behavior-model-training/summaries";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_behavior_model_training_summaries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/behavior-model-training/summaries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_buckets_aggregation(aggregation_field, buckets_aggregation_type, query_string)
    get_buckets_aggregation(aggregation_field, buckets_aggregation_type, query_string, params::Dict{String,<:Any})

Aggregates on indexed data with search queries pertaining to particular fields.  Requires
permission to access the GetBucketsAggregation action.

# Arguments
- `aggregation_field`: The aggregation field.
- `buckets_aggregation_type`: The basic control of the response shape and the bucket
  aggregation type to perform.
- `query_string`: The search query string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"indexName"`: The name of the index to search.
- `"queryVersion"`: The version of the query.
"""
function get_buckets_aggregation(
    aggregationField,
    bucketsAggregationType,
    queryString;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/buckets",
        Dict{String,Any}(
            "aggregationField" => aggregationField,
            "bucketsAggregationType" => bucketsAggregationType,
            "queryString" => queryString,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_buckets_aggregation(
    aggregationField,
    bucketsAggregationType,
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/buckets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "aggregationField" => aggregationField,
                    "bucketsAggregationType" => bucketsAggregationType,
                    "queryString" => queryString,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cardinality(query_string)
    get_cardinality(query_string, params::Dict{String,<:Any})

Returns the approximate count of unique values that match the query. Requires permission to
access the GetCardinality action.

# Arguments
- `query_string`: The search query string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"aggregationField"`: The field to aggregate.
- `"indexName"`: The name of the index to search.
- `"queryVersion"`: The query version.
"""
function get_cardinality(queryString; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/indices/cardinality",
        Dict{String,Any}("queryString" => queryString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cardinality(
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/cardinality",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("queryString" => queryString), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_effective_policies()
    get_effective_policies(params::Dict{String,<:Any})

Gets a list of the policies that have an effect on the authorization behavior of the
specified device when it connects to the IoT device gateway. Requires permission to access
the GetEffectivePolicies action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cognitoIdentityPoolId"`: The Cognito identity pool ID.
- `"principal"`: The principal. Valid principals are CertificateArn
  (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn
  (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).
- `"thingName"`: The thing name.
"""
function get_effective_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/effective-policies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_effective_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/effective-policies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_indexing_configuration()
    get_indexing_configuration(params::Dict{String,<:Any})

Gets the indexing configuration. Requires permission to access the GetIndexingConfiguration
action.

"""
function get_indexing_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/indexing/config"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_indexing_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/indexing/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_job_document(job_id)
    get_job_document(job_id, params::Dict{String,<:Any})

Gets a job document. Requires permission to access the GetJobDocument action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.

"""
function get_job_document(jobId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/jobs/$(jobId)/job-document";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_job_document(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/jobs/$(jobId)/job-document",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_logging_options()
    get_logging_options(params::Dict{String,<:Any})

Gets the logging options. NOTE: use of this command is not recommended. Use
GetV2LoggingOptions instead. Requires permission to access the GetLoggingOptions action.

"""
function get_logging_options(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/loggingOptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_logging_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/loggingOptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_otaupdate(ota_update_id)
    get_otaupdate(ota_update_id, params::Dict{String,<:Any})

Gets an OTA update. Requires permission to access the GetOTAUpdate action.

# Arguments
- `ota_update_id`: The OTA update ID.

"""
function get_otaupdate(otaUpdateId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/otaUpdates/$(otaUpdateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_otaupdate(
    otaUpdateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/otaUpdates/$(otaUpdateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_package(package_name)
    get_package(package_name, params::Dict{String,<:Any})

Gets information about the specified software package. Requires permission to access the
GetPackage action.

# Arguments
- `package_name`: The name of the target software package.

"""
function get_package(packageName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/packages/$(packageName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_package(
    packageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/packages/$(packageName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_package_configuration()
    get_package_configuration(params::Dict{String,<:Any})

Gets information about the specified software package's configuration. Requires permission
to access the GetPackageConfiguration action.

"""
function get_package_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/package-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_package_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/package-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_package_version(package_name, version_name)
    get_package_version(package_name, version_name, params::Dict{String,<:Any})

Gets information about the specified package version.  Requires permission to access the
GetPackageVersion action.

# Arguments
- `package_name`: The name of the associated package.
- `version_name`: The name of the target package version.

"""
function get_package_version(
    packageName, versionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/packages/$(packageName)/versions/$(versionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_package_version(
    packageName,
    versionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/packages/$(packageName)/versions/$(versionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_percentiles(query_string)
    get_percentiles(query_string, params::Dict{String,<:Any})

Groups the aggregated values that match the query into percentile groupings. The default
percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you
call GetPercentiles. This function returns a value for each percentile group specified (or
the default percentile groupings). The percentile group \"1\" contains the aggregated field
value that occurs in approximately one percent of the values that match the query. The
percentile group \"5\" contains the aggregated field value that occurs in approximately
five percent of the values that match the query, and so on. The result is an approximation,
the more values that match the query, the more accurate the percentile values. Requires
permission to access the GetPercentiles action.

# Arguments
- `query_string`: The search query string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"aggregationField"`: The field to aggregate.
- `"indexName"`: The name of the index to search.
- `"percents"`: The percentile groups returned.
- `"queryVersion"`: The query version.
"""
function get_percentiles(queryString; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/indices/percentiles",
        Dict{String,Any}("queryString" => queryString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_percentiles(
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/percentiles",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("queryString" => queryString), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy(policy_name)
    get_policy(policy_name, params::Dict{String,<:Any})

Gets information about the specified policy with the policy document of the default
version. Requires permission to access the GetPolicy action.

# Arguments
- `policy_name`: The name of the policy.

"""
function get_policy(policyName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/policies/$(policyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy(
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/policies/$(policyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy_version(policy_name, policy_version_id)
    get_policy_version(policy_name, policy_version_id, params::Dict{String,<:Any})

Gets information about the specified policy version. Requires permission to access the
GetPolicyVersion action.

# Arguments
- `policy_name`: The name of the policy.
- `policy_version_id`: The policy version ID.

"""
function get_policy_version(
    policyName, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/policies/$(policyName)/version/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy_version(
    policyName,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/policies/$(policyName)/version/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_registration_code()
    get_registration_code(params::Dict{String,<:Any})

Gets a registration code used to register a CA certificate with IoT. IoT will create a
registration code as part of this API call if the registration code doesn't exist or has
been deleted. If you already have a registration code, this API call will return the same
registration code. Requires permission to access the GetRegistrationCode action.

"""
function get_registration_code(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/registrationcode"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_registration_code(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/registrationcode",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_statistics(query_string)
    get_statistics(query_string, params::Dict{String,<:Any})

Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard
deviation for the specified aggregated field. If the aggregation field is of type String,
only the count statistic is returned. Requires permission to access the GetStatistics
action.

# Arguments
- `query_string`: The query used to search. You can specify \"*\" for the query string to
  get the count of all indexed things in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"aggregationField"`: The aggregation field name.
- `"indexName"`: The name of the index to search. The default value is AWS_Things.
- `"queryVersion"`: The version of the query used to search.
"""
function get_statistics(queryString; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/indices/statistics",
        Dict{String,Any}("queryString" => queryString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_statistics(
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/statistics",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("queryString" => queryString), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_topic_rule(rule_name)
    get_topic_rule(rule_name, params::Dict{String,<:Any})

Gets information about the rule. Requires permission to access the GetTopicRule action.

# Arguments
- `rule_name`: The name of the rule.

"""
function get_topic_rule(ruleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/rules/$(ruleName)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_topic_rule(
    ruleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/rules/$(ruleName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_topic_rule_destination(arn)
    get_topic_rule_destination(arn, params::Dict{String,<:Any})

Gets information about a topic rule destination. Requires permission to access the
GetTopicRuleDestination action.

# Arguments
- `arn`: The ARN of the topic rule destination.

"""
function get_topic_rule_destination(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/destinations/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_topic_rule_destination(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/destinations/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_v2_logging_options()
    get_v2_logging_options(params::Dict{String,<:Any})

Gets the fine grained logging options. Requires permission to access the
GetV2LoggingOptions action.

"""
function get_v2_logging_options(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/v2LoggingOptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_v2_logging_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/v2LoggingOptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_active_violations()
    list_active_violations(params::Dict{String,<:Any})

Lists the active violations for a given Device Defender security profile. Requires
permission to access the ListActiveViolations action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"behaviorCriteriaType"`:  The criteria for a behavior.
- `"listSuppressedAlerts"`:  A list of all suppressed alerts.
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
- `"securityProfileName"`: The name of the Device Defender security profile for which
  violations are listed.
- `"thingName"`: The name of the thing whose active violations are listed.
- `"verificationState"`: The verification state of the violation (detect alarm).
"""
function list_active_violations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/active-violations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_active_violations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/active-violations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attached_policies(target)
    list_attached_policies(target, params::Dict{String,<:Any})

Lists the policies attached to the specified thing group. Requires permission to access the
ListAttachedPolicies action.

# Arguments
- `target`: The group or principal for which the policies will be listed. Valid principals
  are CertificateArn (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn
  (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"marker"`: The token to retrieve the next set of results.
- `"pageSize"`: The maximum number of results to be returned per request.
- `"recursive"`: When true, recursively list attached policies.
"""
function list_attached_policies(target; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/attached-policies/$(target)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attached_policies(
    target, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/attached-policies/$(target)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audit_findings()
    list_audit_findings(params::Dict{String,<:Any})

Lists the findings (results) of a Device Defender audit or of the audits performed during a
specified time period. (Findings are retained for 90 days.) Requires permission to access
the ListAuditFindings action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checkName"`: A filter to limit results to the findings for the specified audit check.
- `"endTime"`: A filter to limit results to those found before the specified time. You must
  specify either the startTime and endTime or the taskId, but not both.
- `"listSuppressedFindings"`:  Boolean flag indicating whether only the suppressed findings
  or the unsuppressed findings should be listed. If this parameter isn't provided, the
  response will list both suppressed and unsuppressed findings.
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
- `"resourceIdentifier"`: Information identifying the noncompliant resource.
- `"startTime"`: A filter to limit results to those found after the specified time. You
  must specify either the startTime and endTime or the taskId, but not both.
- `"taskId"`: A filter to limit results to the audit with the specified ID. You must
  specify either the taskId or the startTime and endTime, but not both.
"""
function list_audit_findings(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST", "/audit/findings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_audit_findings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/audit/findings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audit_mitigation_actions_executions(finding_id, task_id)
    list_audit_mitigation_actions_executions(finding_id, task_id, params::Dict{String,<:Any})

Gets the status of audit mitigation action tasks that were executed. Requires permission to
access the ListAuditMitigationActionsExecutions action.

# Arguments
- `finding_id`: Specify this filter to limit results to those that were applied to a
  specific audit finding.
- `task_id`: Specify this filter to limit results to actions for a specific audit
  mitigation actions task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionStatus"`: Specify this filter to limit results to those with a specific status.
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
"""
function list_audit_mitigation_actions_executions(
    findingId, taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/mitigationactions/executions",
        Dict{String,Any}("findingId" => findingId, "taskId" => taskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audit_mitigation_actions_executions(
    findingId,
    taskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/mitigationactions/executions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("findingId" => findingId, "taskId" => taskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audit_mitigation_actions_tasks(end_time, start_time)
    list_audit_mitigation_actions_tasks(end_time, start_time, params::Dict{String,<:Any})

Gets a list of audit mitigation action tasks that match the specified filters. Requires
permission to access the ListAuditMitigationActionsTasks action.

# Arguments
- `end_time`: Specify this filter to limit results to tasks that were completed or canceled
  on or before a specific date and time.
- `start_time`: Specify this filter to limit results to tasks that began on or after a
  specific date and time.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"auditTaskId"`: Specify this filter to limit results to tasks that were applied to
  results for a specific audit.
- `"findingId"`: Specify this filter to limit results to tasks that were applied to a
  specific audit finding.
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
- `"taskStatus"`: Specify this filter to limit results to tasks that are in a specific
  state.
"""
function list_audit_mitigation_actions_tasks(
    endTime, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/mitigationactions/tasks",
        Dict{String,Any}("endTime" => endTime, "startTime" => startTime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audit_mitigation_actions_tasks(
    endTime,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/mitigationactions/tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("endTime" => endTime, "startTime" => startTime),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audit_suppressions()
    list_audit_suppressions(params::Dict{String,<:Any})

 Lists your Device Defender audit listings.  Requires permission to access the
ListAuditSuppressions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ascendingOrder"`:  Determines whether suppressions are listed in ascending order by
  expiration date or not. If parameter isn't provided, ascendingOrder=true.
- `"checkName"`:
- `"maxResults"`:  The maximum number of results to return at one time. The default is 25.
- `"nextToken"`:  The token for the next set of results.
- `"resourceIdentifier"`:
"""
function list_audit_suppressions(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/audit/suppressions/list";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audit_suppressions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/audit/suppressions/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audit_tasks(end_time, start_time)
    list_audit_tasks(end_time, start_time, params::Dict{String,<:Any})

Lists the Device Defender audits that have been performed during a given time period.
Requires permission to access the ListAuditTasks action.

# Arguments
- `end_time`: The end of the time period.
- `start_time`: The beginning of the time period. Audit information is retained for a
  limited time (90 days). Requesting a start time prior to what is retained results in an
  \"InvalidRequestException\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
- `"taskStatus"`: A filter to limit the output to audits with the specified completion
  status: can be one of \"IN_PROGRESS\", \"COMPLETED\", \"FAILED\", or \"CANCELED\".
- `"taskType"`: A filter to limit the output to the specified type of audit: can be one of
  \"ON_DEMAND_AUDIT_TASK\" or \"SCHEDULED__AUDIT_TASK\".
"""
function list_audit_tasks(
    endTime, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/tasks",
        Dict{String,Any}("endTime" => endTime, "startTime" => startTime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audit_tasks(
    endTime,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("endTime" => endTime, "startTime" => startTime),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_authorizers()
    list_authorizers(params::Dict{String,<:Any})

Lists the authorizers registered in your account. Requires permission to access the
ListAuthorizers action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Return the list of authorizers in ascending alphabetical order.
- `"marker"`: A marker used to get the next set of results.
- `"pageSize"`: The maximum number of results to return at one time.
- `"status"`: The status of the list authorizers request.
"""
function list_authorizers(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/authorizers/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_authorizers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/authorizers/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_billing_groups()
    list_billing_groups(params::Dict{String,<:Any})

Lists the billing groups you have created. Requires permission to access the
ListBillingGroups action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per request.
- `"namePrefixFilter"`: Limit the results to billing groups whose names have the given
  prefix.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_billing_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/billing-groups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_billing_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/billing-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_cacertificates()
    list_cacertificates(params::Dict{String,<:Any})

Lists the CA certificates registered for your Amazon Web Services account. The results are
paginated with a default page size of 25. You can use the returned marker to retrieve
additional results. Requires permission to access the ListCACertificates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Determines the order of the results.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
- `"templateName"`: The name of the provisioning template.
"""
function list_cacertificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/cacertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_cacertificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/cacertificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificate_providers()
    list_certificate_providers(params::Dict{String,<:Any})

Lists all your certificate providers in your Amazon Web Services account. Requires
permission to access the ListCertificateProviders action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Returns the list of certificate providers in ascending alphabetical
  order.
- `"nextToken"`: The token for the next set of results, or null if there are no more
  results.
"""
function list_certificate_providers(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/certificate-providers/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_certificate_providers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificate-providers/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificates()
    list_certificates(params::Dict{String,<:Any})

Lists the certificates registered in your Amazon Web Services account. The results are
paginated with a default page size of 25. You can use the returned marker to retrieve
additional results. Requires permission to access the ListCertificates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If True, the results are returned
  in ascending order, based on the creation date.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/certificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificates_by_ca(ca_certificate_id)
    list_certificates_by_ca(ca_certificate_id, params::Dict{String,<:Any})

List the device certificates signed by the specified CA certificate. Requires permission to
access the ListCertificatesByCA action.

# Arguments
- `ca_certificate_id`: The ID of the CA certificate. This operation will list all
  registered device certificate that were signed by this CA certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If True, the results are returned
  in ascending order, based on the creation date.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_certificates_by_ca(
    caCertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificates-by-ca/$(caCertificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_certificates_by_ca(
    caCertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/certificates-by-ca/$(caCertificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_metrics()
    list_custom_metrics(params::Dict{String,<:Any})

 Lists your Device Defender detect custom metrics.  Requires permission to access the
ListCustomMetrics action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of results to return at one time. The default is 25.
- `"nextToken"`:  The token for the next set of results.
"""
function list_custom_metrics(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/custom-metrics"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_custom_metrics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/custom-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_detect_mitigation_actions_executions()
    list_detect_mitigation_actions_executions(params::Dict{String,<:Any})

 Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
Requires permission to access the ListDetectMitigationActionsExecutions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`:  The end of the time period for which ML Detect mitigation actions
  executions are returned.
- `"maxResults"`:  The maximum number of results to return at one time. The default is 25.
- `"nextToken"`:  The token for the next set of results.
- `"startTime"`:  A filter to limit results to those found after the specified time. You
  must specify either the startTime and endTime or the taskId, but not both.
- `"taskId"`:  The unique identifier of the task.
- `"thingName"`:  The name of the thing whose mitigation actions are listed.
- `"violationId"`:  The unique identifier of the violation.
"""
function list_detect_mitigation_actions_executions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/detect/mitigationactions/executions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_detect_mitigation_actions_executions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/detect/mitigationactions/executions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_detect_mitigation_actions_tasks(end_time, start_time)
    list_detect_mitigation_actions_tasks(end_time, start_time, params::Dict{String,<:Any})

 List of Device Defender ML Detect mitigation actions tasks.  Requires permission to access
the ListDetectMitigationActionsTasks action.

# Arguments
- `end_time`:  The end of the time period for which ML Detect mitigation actions tasks are
  returned.
- `start_time`:  A filter to limit results to those found after the specified time. You
  must specify either the startTime and endTime or the taskId, but not both.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`:  The token for the next set of results.
"""
function list_detect_mitigation_actions_tasks(
    endTime, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/detect/mitigationactions/tasks",
        Dict{String,Any}("endTime" => endTime, "startTime" => startTime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_detect_mitigation_actions_tasks(
    endTime,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/detect/mitigationactions/tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("endTime" => endTime, "startTime" => startTime),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_dimensions()
    list_dimensions(params::Dict{String,<:Any})

List the set of dimensions that are defined for your Amazon Web Services accounts. Requires
permission to access the ListDimensions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to retrieve at one time.
- `"nextToken"`: The token for the next set of results.
"""
function list_dimensions(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/dimensions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_dimensions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/dimensions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_domain_configurations()
    list_domain_configurations(params::Dict{String,<:Any})

Gets a list of domain configurations for the user. This list is sorted alphabetically by
domain configuration name. Requires permission to access the ListDomainConfigurations
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
- `"serviceType"`: The type of service delivered by the endpoint.
"""
function list_domain_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/domainConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domain_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/domainConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_fleet_metrics()
    list_fleet_metrics(params::Dict{String,<:Any})

Lists all your fleet metrics.  Requires permission to access the ListFleetMetrics action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_fleet_metrics(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/fleet-metrics"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_fleet_metrics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/fleet-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_indices()
    list_indices(params::Dict{String,<:Any})

Lists the search indices. Requires permission to access the ListIndices action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token used to get the next set of results, or null if there are no
  additional results.
"""
function list_indices(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/indices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_indices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/indices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_job_executions_for_job(job_id)
    list_job_executions_for_job(job_id, params::Dict{String,<:Any})

Lists the job executions for a job. Requires permission to access the
ListJobExecutionsForJob action.

# Arguments
- `job_id`: The unique identifier you assigned to this job when it was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per request.
- `"nextToken"`: The token to retrieve the next set of results.
- `"status"`: The status of the job.
"""
function list_job_executions_for_job(
    jobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/jobs/$(jobId)/things";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_job_executions_for_job(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/jobs/$(jobId)/things",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_job_executions_for_thing(thing_name)
    list_job_executions_for_thing(thing_name, params::Dict{String,<:Any})

Lists the job executions for the specified thing. Requires permission to access the
ListJobExecutionsForThing action.

# Arguments
- `thing_name`: The thing name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"jobId"`: The unique identifier you assigned to this job when it was created.
- `"maxResults"`: The maximum number of results to be returned per request.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
- `"nextToken"`: The token to retrieve the next set of results.
- `"status"`: An optional filter that lets you search for jobs that have the specified
  status.
"""
function list_job_executions_for_thing(
    thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/things/$(thingName)/jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_job_executions_for_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/things/$(thingName)/jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_job_templates()
    list_job_templates(params::Dict{String,<:Any})

Returns a list of job templates. Requires permission to access the ListJobTemplates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the list.
- `"nextToken"`: The token to use to return the next set of results in the list.
"""
function list_job_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/job-templates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_job_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/job-templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_jobs()
    list_jobs(params::Dict{String,<:Any})

Lists jobs. Requires permission to access the ListJobs action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per request.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
- `"nextToken"`: The token to retrieve the next set of results.
- `"status"`: An optional filter that lets you search for jobs that have the specified
  status.
- `"targetSelection"`: Specifies whether the job will continue to run (CONTINUOUS), or will
  be complete after all those things specified as targets have completed the job (SNAPSHOT).
  If continuous, the job may also be run on a thing when a change is detected in a target.
  For example, a job will run on a thing when the thing is added to a target group, even
  after the job was completed by all things originally in the group.   We recommend that you
  use continuous jobs instead of snapshot jobs for dynamic thing group targets. By using
  continuous jobs, devices that join the group receive the job execution even after the job
  has been created.
- `"thingGroupId"`: A filter that limits the returned jobs to those for the specified group.
- `"thingGroupName"`: A filter that limits the returned jobs to those for the specified
  group.
"""
function list_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/jobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/jobs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_managed_job_templates()
    list_managed_job_templates(params::Dict{String,<:Any})

Returns a list of managed job templates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: Maximum number of entries that can be returned.
- `"nextToken"`: The token to retrieve the next set of results.
- `"templateName"`: An optional parameter for template name. If specified, only the
  versions of the managed job templates that have the specified template name will be
  returned.
"""
function list_managed_job_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/managed-job-templates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_managed_job_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/managed-job-templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_metric_values(end_time, metric_name, start_time, thing_name)
    list_metric_values(end_time, metric_name, start_time, thing_name, params::Dict{String,<:Any})

Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side
metric, or custom metric) by the given thing during the specified time period.

# Arguments
- `end_time`: The end of the time period for which metric values are returned.
- `metric_name`: The name of the security profile metric for which values are returned.
- `start_time`: The start of the time period for which metric values are returned.
- `thing_name`: The name of the thing for which security profile metric values are returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dimensionName"`: The dimension name.
- `"dimensionValueOperator"`: The dimension value operator.
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
"""
function list_metric_values(
    endTime,
    metricName,
    startTime,
    thingName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/metric-values",
        Dict{String,Any}(
            "endTime" => endTime,
            "metricName" => metricName,
            "startTime" => startTime,
            "thingName" => thingName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_metric_values(
    endTime,
    metricName,
    startTime,
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/metric-values",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "metricName" => metricName,
                    "startTime" => startTime,
                    "thingName" => thingName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_mitigation_actions()
    list_mitigation_actions(params::Dict{String,<:Any})

Gets a list of all mitigation actions that match the specified filter criteria. Requires
permission to access the ListMitigationActions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionType"`: Specify a value to limit the result to mitigation actions with a specific
  action type.
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
"""
function list_mitigation_actions(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/mitigationactions/actions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_mitigation_actions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/mitigationactions/actions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_otaupdates()
    list_otaupdates(params::Dict{String,<:Any})

Lists OTA updates. Requires permission to access the ListOTAUpdates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: A token used to retrieve the next set of results.
- `"otaUpdateStatus"`: The OTA update job status.
"""
function list_otaupdates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/otaUpdates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_otaupdates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/otaUpdates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_outgoing_certificates()
    list_outgoing_certificates(params::Dict{String,<:Any})

Lists certificates that are being transferred but not yet accepted. Requires permission to
access the ListOutgoingCertificates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If True, the results are returned
  in ascending order, based on the creation date.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_outgoing_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/certificates-out-going";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_outgoing_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/certificates-out-going",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_package_versions(package_name)
    list_package_versions(package_name, params::Dict{String,<:Any})

Lists the software package versions associated to the account. Requires permission to
access the ListPackageVersions action.

# Arguments
- `package_name`: The name of the target software package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
- `"status"`: The status of the package version. For more information, see Package version
  lifecycle.
"""
function list_package_versions(
    packageName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/packages/$(packageName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_package_versions(
    packageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/packages/$(packageName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_packages()
    list_packages(params::Dict{String,<:Any})

Lists the software packages associated to the account. Requires permission to access the
ListPackages action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results returned at one time.
- `"nextToken"`: The token for the next set of results.
"""
function list_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/packages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/packages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_policies()
    list_policies(params::Dict{String,<:Any})

Lists your policies. Requires permission to access the ListPolicies action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If true, the results are returned
  in ascending creation order.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/policies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/policies", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_policy_principals(x-amzn-iot-policy)
    list_policy_principals(x-amzn-iot-policy, params::Dict{String,<:Any})

Lists the principals associated with the specified policy.  Note: This action is deprecated
and works as expected for backward compatibility, but we won't add enhancements. Use
ListTargetsForPolicy instead. Requires permission to access the ListPolicyPrincipals action.

# Arguments
- `x-amzn-iot-policy`: The policy name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If true, the results are returned
  in ascending creation order.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_policy_principals(
    x_amzn_iot_policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/policy-principals",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-iot-policy" => x_amzn_iot_policy)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policy_principals(
    x_amzn_iot_policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/policy-principals",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("x-amzn-iot-policy" => x_amzn_iot_policy)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policy_versions(policy_name)
    list_policy_versions(policy_name, params::Dict{String,<:Any})

Lists the versions of the specified policy and identifies the default version. Requires
permission to access the ListPolicyVersions action.

# Arguments
- `policy_name`: The policy name.

"""
function list_policy_versions(
    policyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/policies/$(policyName)/version";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policy_versions(
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/policies/$(policyName)/version",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_principal_policies(x-amzn-iot-principal)
    list_principal_policies(x-amzn-iot-principal, params::Dict{String,<:Any})

Lists the policies attached to the specified principal. If you use an Cognito identity, the
ID must be in AmazonCognito Identity format.  Note: This action is deprecated and works as
expected for backward compatibility, but we won't add enhancements. Use
ListAttachedPolicies instead. Requires permission to access the ListPrincipalPolicies
action.

# Arguments
- `x-amzn-iot-principal`: The principal. Valid principals are CertificateArn
  (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn
  (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Specifies the order for results. If true, results are returned in
  ascending creation order.
- `"marker"`: The marker for the next set of results.
- `"pageSize"`: The result page size.
"""
function list_principal_policies(
    x_amzn_iot_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/principal-policies",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_principal_policies(
    x_amzn_iot_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/principal-policies",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" =>
                        Dict{String,Any}("x-amzn-iot-principal" => x_amzn_iot_principal),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_principal_things(x-amzn-principal)
    list_principal_things(x-amzn-principal, params::Dict{String,<:Any})

Lists the things associated with the specified principal. A principal can be X.509
certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
identities.  Requires permission to access the ListPrincipalThings action.

# Arguments
- `x-amzn-principal`: The principal.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_principal_things(
    x_amzn_principal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/principals/things",
        Dict{String,Any}(
            "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_principal_things(
    x_amzn_principal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/principals/things",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}("x-amzn-principal" => x_amzn_principal)
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_provisioning_template_versions(template_name)
    list_provisioning_template_versions(template_name, params::Dict{String,<:Any})

A list of provisioning template versions. Requires permission to access the
ListProvisioningTemplateVersions action.

# Arguments
- `template_name`: The name of the provisioning template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: A token to retrieve the next set of results.
"""
function list_provisioning_template_versions(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_provisioning_template_versions(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/provisioning-templates/$(templateName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_provisioning_templates()
    list_provisioning_templates(params::Dict{String,<:Any})

Lists the provisioning templates in your Amazon Web Services account. Requires permission
to access the ListProvisioningTemplates action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: A token to retrieve the next set of results.
"""
function list_provisioning_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/provisioning-templates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_provisioning_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/provisioning-templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_related_resources_for_audit_finding(finding_id)
    list_related_resources_for_audit_finding(finding_id, params::Dict{String,<:Any})

The related resources of an Audit finding. The following resources can be returned from
calling this API:   DEVICE_CERTIFICATE   CA_CERTIFICATE   IOT_POLICY
COGNITO_IDENTITY_POOL   CLIENT_ID   ACCOUNT_SETTINGS   ROLE_ALIAS   IAM_ROLE
ISSUER_CERTIFICATE    This API is similar to DescribeAuditFinding's RelatedResources but
provides pagination and is not limited to 10 resources. When calling DescribeAuditFinding
for the intermediate CA revoked for active device certificates check, RelatedResources will
not be populated. You must use this API, ListRelatedResourcesForAuditFinding, to list the
certificates.

# Arguments
- `finding_id`: The finding Id.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: A token that can be used to retrieve the next set of results, or null if
  there are no additional results.
"""
function list_related_resources_for_audit_finding(
    findingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/relatedResources",
        Dict{String,Any}("findingId" => findingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_related_resources_for_audit_finding(
    findingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/audit/relatedResources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("findingId" => findingId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_role_aliases()
    list_role_aliases(params::Dict{String,<:Any})

Lists the role aliases registered in your account. Requires permission to access the
ListRoleAliases action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Return the list of role aliases in ascending alphabetical order.
- `"marker"`: A marker used to get the next set of results.
- `"pageSize"`: The maximum number of results to return at one time.
"""
function list_role_aliases(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/role-aliases"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_role_aliases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/role-aliases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_scheduled_audits()
    list_scheduled_audits(params::Dict{String,<:Any})

Lists all of your scheduled audits. Requires permission to access the ListScheduledAudits
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time. The default is 25.
- `"nextToken"`: The token for the next set of results.
"""
function list_scheduled_audits(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/audit/scheduledaudits";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_scheduled_audits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/audit/scheduledaudits",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_security_profiles()
    list_security_profiles(params::Dict{String,<:Any})

Lists the Device Defender security profiles you've created. You can filter security
profiles by dimension or custom metric. Requires permission to access the
ListSecurityProfiles action.   dimensionName and metricName cannot be used in the same
request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dimensionName"`: A filter to limit results to the security profiles that use the
  defined dimension. Cannot be used with metricName
- `"maxResults"`: The maximum number of results to return at one time.
- `"metricName"`:  The name of the custom metric. Cannot be used with dimensionName.
- `"nextToken"`: The token for the next set of results.
"""
function list_security_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/security-profiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_security_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/security-profiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_security_profiles_for_target(security_profile_target_arn)
    list_security_profiles_for_target(security_profile_target_arn, params::Dict{String,<:Any})

Lists the Device Defender security profiles attached to a target (thing group). Requires
permission to access the ListSecurityProfilesForTarget action.

# Arguments
- `security_profile_target_arn`: The ARN of the target (thing group) whose attached
  security profiles you want to get.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
- `"recursive"`: If true, return child groups too.
"""
function list_security_profiles_for_target(
    securityProfileTargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/security-profiles-for-target",
        Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_security_profiles_for_target(
    securityProfileTargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/security-profiles-for-target",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("securityProfileTargetArn" => securityProfileTargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_streams()
    list_streams(params::Dict{String,<:Any})

Lists all of the streams in your Amazon Web Services account. Requires permission to access
the ListStreams action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isAscendingOrder"`: Set to true to return the list of streams in ascending order.
- `"maxResults"`: The maximum number of results to return at a time.
- `"nextToken"`: A token used to get the next set of results.
"""
function list_streams(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/streams"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_streams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/streams", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags (metadata) you have assigned to the resource. Requires permission to access
the ListTagsForResource action.

# Arguments
- `resource_arn`: The ARN of the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/tags",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/tags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets_for_policy(policy_name)
    list_targets_for_policy(policy_name, params::Dict{String,<:Any})

List targets for the specified policy. Requires permission to access the
ListTargetsForPolicy action.

# Arguments
- `policy_name`: The policy name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"marker"`: A marker used to get the next set of results.
- `"pageSize"`: The maximum number of results to return at one time.
"""
function list_targets_for_policy(
    policyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/policy-targets/$(policyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_targets_for_policy(
    policyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/policy-targets/$(policyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets_for_security_profile(security_profile_name)
    list_targets_for_security_profile(security_profile_name, params::Dict{String,<:Any})

Lists the targets (thing groups) associated with a given Device Defender security profile.
Requires permission to access the ListTargetsForSecurityProfile action.

# Arguments
- `security_profile_name`: The security profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
"""
function list_targets_for_security_profile(
    securityProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/security-profiles/$(securityProfileName)/targets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_targets_for_security_profile(
    securityProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/security-profiles/$(securityProfileName)/targets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_groups()
    list_thing_groups(params::Dict{String,<:Any})

List the thing groups in your account. Requires permission to access the ListThingGroups
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"namePrefixFilter"`: A filter that limits the results to those with the specified name
  prefix.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"parentGroup"`: A filter that limits the results to those with the specified parent
  group.
- `"recursive"`: If true, return child groups as well.
"""
function list_thing_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/thing-groups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_thing_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_groups_for_thing(thing_name)
    list_thing_groups_for_thing(thing_name, params::Dict{String,<:Any})

List the thing groups to which the specified thing belongs. Requires permission to access
the ListThingGroupsForThing action.

# Arguments
- `thing_name`: The thing name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_thing_groups_for_thing(
    thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/things/$(thingName)/thing-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_thing_groups_for_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/things/$(thingName)/thing-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_principals(thing_name)
    list_thing_principals(thing_name, params::Dict{String,<:Any})

Lists the principals associated with the specified thing. A principal can be X.509
certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
identities. Requires permission to access the ListThingPrincipals action.

# Arguments
- `thing_name`: The name of the thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_thing_principals(
    thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/things/$(thingName)/principals";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_thing_principals(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/things/$(thingName)/principals",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_registration_task_reports(report_type, task_id)
    list_thing_registration_task_reports(report_type, task_id, params::Dict{String,<:Any})

Information about the thing registration tasks.

# Arguments
- `report_type`: The type of task report.
- `task_id`: The id of the task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per request.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_thing_registration_task_reports(
    reportType, taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-registration-tasks/$(taskId)/reports",
        Dict{String,Any}("reportType" => reportType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_thing_registration_task_reports(
    reportType,
    taskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/thing-registration-tasks/$(taskId)/reports",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("reportType" => reportType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_registration_tasks()
    list_thing_registration_tasks(params::Dict{String,<:Any})

List bulk thing provisioning tasks. Requires permission to access the
ListThingRegistrationTasks action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"status"`: The status of the bulk thing provisioning task.
"""
function list_thing_registration_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET",
        "/thing-registration-tasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_thing_registration_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-registration-tasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_thing_types()
    list_thing_types(params::Dict{String,<:Any})

Lists the existing thing types. Requires permission to access the ListThingTypes action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"thingTypeName"`: The name of the thing type.
"""
function list_thing_types(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/thing-types"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_thing_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-types",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_things()
    list_things(params::Dict{String,<:Any})

Lists your things. Use the attributeName and attributeValue parameters to filter your
things. For example, calling ListThings with attributeName=Color and attributeValue=Red
retrieves all things in the registry that contain an attribute Color with the value Red.
For more information, see List Things from the Amazon Web Services IoT Core Developer
Guide. Requires permission to access the ListThings action.  You will not be charged for
calling this API if an Access denied error is returned. You will also not be charged if no
attributes or pagination token was provided in request and no pagination token and no
results were returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributeName"`: The attribute name used to search for things.
- `"attributeValue"`: The attribute value used to search for things.
- `"maxResults"`: The maximum number of results to return in this operation.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"thingTypeName"`: The name of the thing type used to search for things.
- `"usePrefixAttributeValue"`: When true, the action returns the thing resources with
  attribute values that start with the attributeValue provided. When false, or not present,
  the action returns only the thing resources with attribute values that match the entire
  attributeValue provided.
"""
function list_things(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/things"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_things(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/things", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_things_in_billing_group(billing_group_name)
    list_things_in_billing_group(billing_group_name, params::Dict{String,<:Any})

Lists the things you have added to the given billing group. Requires permission to access
the ListThingsInBillingGroup action.

# Arguments
- `billing_group_name`: The name of the billing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per request.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_things_in_billing_group(
    billingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/billing-groups/$(billingGroupName)/things";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_things_in_billing_group(
    billingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/billing-groups/$(billingGroupName)/things",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_things_in_thing_group(thing_group_name)
    list_things_in_thing_group(thing_group_name, params::Dict{String,<:Any})

Lists the things in the specified group. Requires permission to access the
ListThingsInThingGroup action.

# Arguments
- `thing_group_name`: The thing group name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"recursive"`: When true, list things in this thing group and in all child groups as well.
"""
function list_things_in_thing_group(
    thingGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/thing-groups/$(thingGroupName)/things";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_things_in_thing_group(
    thingGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/thing-groups/$(thingGroupName)/things",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_topic_rule_destinations()
    list_topic_rule_destinations(params::Dict{String,<:Any})

Lists all the topic rule destinations in your Amazon Web Services account. Requires
permission to access the ListTopicRuleDestinations action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
"""
function list_topic_rule_destinations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/destinations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_topic_rule_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/destinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_topic_rules()
    list_topic_rules(params::Dict{String,<:Any})

Lists the rules for the specific topic. Requires permission to access the ListTopicRules
action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"ruleDisabled"`: Specifies whether the rule is disabled.
- `"topic"`: The topic.
"""
function list_topic_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot("GET", "/rules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_topic_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET", "/rules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_v2_logging_levels()
    list_v2_logging_levels(params::Dict{String,<:Any})

Lists logging levels. Requires permission to access the ListV2LoggingLevels action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: To retrieve the next set of results, the nextToken value from a previous
  response; otherwise null to receive the first set of results.
- `"targetType"`: The type of resource for which you are configuring logging. Must be
  THING_Group.
"""
function list_v2_logging_levels(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "GET", "/v2LoggingLevel"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_v2_logging_levels(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/v2LoggingLevel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_violation_events(end_time, start_time)
    list_violation_events(end_time, start_time, params::Dict{String,<:Any})

Lists the Device Defender security profile violations discovered during the given time
period. You can use filters to limit the results to those alerts issued for a particular
security profile, behavior, or thing (device). Requires permission to access the
ListViolationEvents action.

# Arguments
- `end_time`: The end time for the alerts to be listed.
- `start_time`: The start time for the alerts to be listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"behaviorCriteriaType"`:  The criteria for a behavior.
- `"listSuppressedAlerts"`:  A list of all suppressed alerts.
- `"maxResults"`: The maximum number of results to return at one time.
- `"nextToken"`: The token for the next set of results.
- `"securityProfileName"`: A filter to limit results to those alerts generated by the
  specified security profile.
- `"thingName"`: A filter to limit results to those alerts caused by the specified thing.
- `"verificationState"`: The verification state of the violation (detect alarm).
"""
function list_violation_events(
    endTime, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "GET",
        "/violation-events",
        Dict{String,Any}("endTime" => endTime, "startTime" => startTime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_violation_events(
    endTime,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "GET",
        "/violation-events",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("endTime" => endTime, "startTime" => startTime),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_verification_state_on_violation(verification_state, violation_id)
    put_verification_state_on_violation(verification_state, violation_id, params::Dict{String,<:Any})

Set a verification state and provide a description of that verification state on a
violation (detect alarm).

# Arguments
- `verification_state`: The verification state of the violation.
- `violation_id`: The violation ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"verificationStateDescription"`: The description of the verification state of the
  violation (detect alarm).
"""
function put_verification_state_on_violation(
    verificationState, violationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/violations/verification-state/$(violationId)",
        Dict{String,Any}("verificationState" => verificationState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_verification_state_on_violation(
    verificationState,
    violationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/violations/verification-state/$(violationId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("verificationState" => verificationState), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_cacertificate(ca_certificate)
    register_cacertificate(ca_certificate, params::Dict{String,<:Any})

Registers a CA certificate with Amazon Web Services IoT Core. There is no limit to the
number of CA certificates you can register in your Amazon Web Services account. You can
register up to 10 CA certificates with the same CA subject field per Amazon Web Services
account. Requires permission to access the RegisterCACertificate action.

# Arguments
- `ca_certificate`: The CA certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"allowAutoRegistration"`: Allows this CA certificate to be used for auto registration of
  device certificates.
- `"certificateMode"`: Describes the certificate mode in which the Certificate Authority
  (CA) will be registered. If the verificationCertificate field is not provided, set
  certificateMode to be SNI_ONLY. If the verificationCertificate field is provided, set
  certificateMode to be DEFAULT. When certificateMode is not provided, it defaults to
  DEFAULT. All the device certificates that are registered using this CA will be registered
  in the same certificate mode as the CA. For more information about certificate mode for
  device certificates, see  certificate mode.
- `"registrationConfig"`: Information about the registration configuration.
- `"setAsActive"`: A boolean value that specifies if the CA certificate is set to active.
  Valid values: ACTIVE | INACTIVE
- `"tags"`: Metadata which can be used to manage the CA certificate.  For URI Request
  parameters use format: ...key1=value1&amp;key2=value2... For the CLI command-line parameter
  use format: &amp;&amp;tags \"key1=value1&amp;key2=value2...\" For the cli-input-json file
  use format: \"tags\": \"key1=value1&amp;key2=value2...\"
- `"verificationCertificate"`: The private key verification certificate. If certificateMode
  is SNI_ONLY, the verificationCertificate field must be empty. If certificateMode is DEFAULT
  or not provided, the verificationCertificate field must not be empty.
"""
function register_cacertificate(
    caCertificate; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/cacertificate",
        Dict{String,Any}("caCertificate" => caCertificate);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_cacertificate(
    caCertificate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/cacertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("caCertificate" => caCertificate), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_certificate(certificate_pem)
    register_certificate(certificate_pem, params::Dict{String,<:Any})

Registers a device certificate with IoT in the same certificate mode as the signing CA. If
you have more than one CA certificate that has the same subject field, you must specify the
CA certificate that was used to sign the device certificate being registered. Requires
permission to access the RegisterCertificate action.

# Arguments
- `certificate_pem`: The certificate data, in PEM format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"caCertificatePem"`: The CA certificate used to sign the device certificate being
  registered.
- `"setAsActive"`: A boolean value that specifies if the certificate is set to active.
  Valid values: ACTIVE | INACTIVE
- `"status"`: The status of the register certificate request. Valid values that you can use
  include ACTIVE, INACTIVE, and REVOKED.
"""
function register_certificate(
    certificatePem; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/certificate/register",
        Dict{String,Any}("certificatePem" => certificatePem);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_certificate(
    certificatePem,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/certificate/register",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("certificatePem" => certificatePem), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_certificate_without_ca(certificate_pem)
    register_certificate_without_ca(certificate_pem, params::Dict{String,<:Any})

Register a certificate that does not have a certificate authority (CA). For supported
certificates, consult  Certificate signing algorithms supported by IoT.

# Arguments
- `certificate_pem`: The certificate data, in PEM format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"status"`: The status of the register certificate request.
"""
function register_certificate_without_ca(
    certificatePem; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/certificate/register-no-ca",
        Dict{String,Any}("certificatePem" => certificatePem);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_certificate_without_ca(
    certificatePem,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/certificate/register-no-ca",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("certificatePem" => certificatePem), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_thing(template_body)
    register_thing(template_body, params::Dict{String,<:Any})

Provisions a thing in the device registry. RegisterThing calls other IoT control plane
APIs. These calls might exceed your account level  IoT Throttling Limits and cause throttle
errors. Please contact Amazon Web Services Customer Support to raise your throttling limits
if necessary. Requires permission to access the RegisterThing action.

# Arguments
- `template_body`: The provisioning template. See Provisioning Devices That Have Device
  Certificates for more information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"parameters"`: The parameters for provisioning a thing. See Provisioning Templates for
  more information.
"""
function register_thing(templateBody; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/things",
        Dict{String,Any}("templateBody" => templateBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_thing(
    templateBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/things",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("templateBody" => templateBody), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_certificate_transfer(certificate_id)
    reject_certificate_transfer(certificate_id, params::Dict{String,<:Any})

Rejects a pending certificate transfer. After IoT rejects a certificate transfer, the
certificate status changes from PENDING_TRANSFER to INACTIVE. To check for pending
certificate transfers, call ListCertificates to enumerate your certificates. This operation
can only be called by the transfer destination. After it is called, the certificate will be
returned to the source's account in the INACTIVE state. Requires permission to access the
RejectCertificateTransfer action.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"rejectReason"`: The reason the certificate transfer was rejected.
"""
function reject_certificate_transfer(
    certificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/reject-certificate-transfer/$(certificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_certificate_transfer(
    certificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/reject-certificate-transfer/$(certificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_thing_from_billing_group()
    remove_thing_from_billing_group(params::Dict{String,<:Any})

Removes the given thing from the billing group. Requires permission to access the
RemoveThingFromBillingGroup action.  This call is asynchronous. It might take several
seconds for the detachment to propagate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"billingGroupArn"`: The ARN of the billing group.
- `"billingGroupName"`: The name of the billing group.
- `"thingArn"`: The ARN of the thing to be removed from the billing group.
- `"thingName"`: The name of the thing to be removed from the billing group.
"""
function remove_thing_from_billing_group(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/billing-groups/removeThingFromBillingGroup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_thing_from_billing_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/billing-groups/removeThingFromBillingGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_thing_from_thing_group()
    remove_thing_from_thing_group(params::Dict{String,<:Any})

Remove the specified thing from the specified group. You must specify either a
thingGroupArn or a thingGroupName to identify the thing group and either a thingArn or a
thingName to identify the thing to remove from the thing group.  Requires permission to
access the RemoveThingFromThingGroup action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"thingArn"`: The ARN of the thing to remove from the group.
- `"thingGroupArn"`: The group ARN.
- `"thingGroupName"`: The group name.
- `"thingName"`: The name of the thing to remove from the group.
"""
function remove_thing_from_thing_group(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/thing-groups/removeThingFromThingGroup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_thing_from_thing_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/thing-groups/removeThingFromThingGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    replace_topic_rule(rule_name, topic_rule_payload)
    replace_topic_rule(rule_name, topic_rule_payload, params::Dict{String,<:Any})

Replaces the rule. You must specify all parameters for the new rule. Creating rules is an
administrator-level action. Any user who has permission to create rules will be able to
access data processed by the rule. Requires permission to access the ReplaceTopicRule
action.

# Arguments
- `rule_name`: The name of the rule.
- `topic_rule_payload`: The rule payload.

"""
function replace_topic_rule(
    ruleName, topicRulePayload; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/rules/$(ruleName)",
        Dict{String,Any}("topicRulePayload" => topicRulePayload);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function replace_topic_rule(
    ruleName,
    topicRulePayload,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/rules/$(ruleName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("topicRulePayload" => topicRulePayload), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_index(query_string)
    search_index(query_string, params::Dict{String,<:Any})

The query search index. Requires permission to access the SearchIndex action.

# Arguments
- `query_string`: The search query string. For more information about the search query
  syntax, see Query syntax.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"indexName"`: The search index name.
- `"maxResults"`: The maximum number of results to return per page at one time. This
  maximum number cannot exceed 100. The response might contain fewer results but will never
  contain more. You can use  nextToken  to retrieve the next set of results until nextToken
  returns NULL.
- `"nextToken"`: The token used to get the next set of results, or null if there are no
  additional results.
- `"queryVersion"`: The query version.
"""
function search_index(queryString; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/indices/search",
        Dict{String,Any}("queryString" => queryString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_index(
    queryString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/indices/search",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("queryString" => queryString), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_default_authorizer(authorizer_name)
    set_default_authorizer(authorizer_name, params::Dict{String,<:Any})

Sets the default authorizer. This will be used if a websocket connection is made without
specifying an authorizer. Requires permission to access the SetDefaultAuthorizer action.

# Arguments
- `authorizer_name`: The authorizer name.

"""
function set_default_authorizer(
    authorizerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/default-authorizer",
        Dict{String,Any}("authorizerName" => authorizerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_default_authorizer(
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/default-authorizer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("authorizerName" => authorizerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_default_policy_version(policy_name, policy_version_id)
    set_default_policy_version(policy_name, policy_version_id, params::Dict{String,<:Any})

Sets the specified version of the specified policy as the policy's default (operative)
version. This action affects all certificates to which the policy is attached. To list the
principals the policy is attached to, use the ListPrincipalPolicies action. Requires
permission to access the SetDefaultPolicyVersion action.

# Arguments
- `policy_name`: The policy name.
- `policy_version_id`: The policy version ID.

"""
function set_default_policy_version(
    policyName, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/policies/$(policyName)/version/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_default_policy_version(
    policyName,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/policies/$(policyName)/version/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_logging_options(logging_options_payload)
    set_logging_options(logging_options_payload, params::Dict{String,<:Any})

Sets the logging options. NOTE: use of this command is not recommended. Use
SetV2LoggingOptions instead. Requires permission to access the SetLoggingOptions action.

# Arguments
- `logging_options_payload`: The logging options payload.

"""
function set_logging_options(
    loggingOptionsPayload; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/loggingOptions",
        Dict{String,Any}("loggingOptionsPayload" => loggingOptionsPayload);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_logging_options(
    loggingOptionsPayload,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/loggingOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("loggingOptionsPayload" => loggingOptionsPayload),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_v2_logging_level(log_level, log_target)
    set_v2_logging_level(log_level, log_target, params::Dict{String,<:Any})

Sets the logging level. Requires permission to access the SetV2LoggingLevel action.

# Arguments
- `log_level`: The log level.
- `log_target`: The log target.

"""
function set_v2_logging_level(
    logLevel, logTarget; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/v2LoggingLevel",
        Dict{String,Any}("logLevel" => logLevel, "logTarget" => logTarget);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_v2_logging_level(
    logLevel,
    logTarget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/v2LoggingLevel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("logLevel" => logLevel, "logTarget" => logTarget),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_v2_logging_options()
    set_v2_logging_options(params::Dict{String,<:Any})

Sets the logging options for the V2 logging service. Requires permission to access the
SetV2LoggingOptions action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultLogLevel"`: The default logging level.
- `"disableAllLogs"`: If true all logs are disabled. The default is false.
- `"roleArn"`: The ARN of the role that allows IoT to write to Cloudwatch logs.
"""
function set_v2_logging_options(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST", "/v2LoggingOptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function set_v2_logging_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/v2LoggingOptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_audit_mitigation_actions_task(audit_check_to_actions_mapping, client_request_token, target, task_id)
    start_audit_mitigation_actions_task(audit_check_to_actions_mapping, client_request_token, target, task_id, params::Dict{String,<:Any})

Starts a task that applies a set of mitigation actions to the specified target. Requires
permission to access the StartAuditMitigationActionsTask action.

# Arguments
- `audit_check_to_actions_mapping`: For an audit check, specifies which mitigation actions
  to apply. Those actions must be defined in your Amazon Web Services accounts.
- `client_request_token`: Each audit mitigation task must have a unique client request
  token. If you try to start a new task with the same token as a task that already exists, an
  exception occurs. If you omit this value, a unique client request token is generated
  automatically.
- `target`: Specifies the audit findings to which the mitigation actions are applied. You
  can apply them to a type of audit check, to all findings from an audit, or to a specific
  set of findings.
- `task_id`: A unique identifier for the task. You can use this identifier to check the
  status of the task or to cancel it.

"""
function start_audit_mitigation_actions_task(
    auditCheckToActionsMapping,
    clientRequestToken,
    target,
    taskId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/mitigationactions/tasks/$(taskId)",
        Dict{String,Any}(
            "auditCheckToActionsMapping" => auditCheckToActionsMapping,
            "clientRequestToken" => clientRequestToken,
            "target" => target,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_audit_mitigation_actions_task(
    auditCheckToActionsMapping,
    clientRequestToken,
    target,
    taskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/mitigationactions/tasks/$(taskId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "auditCheckToActionsMapping" => auditCheckToActionsMapping,
                    "clientRequestToken" => clientRequestToken,
                    "target" => target,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_detect_mitigation_actions_task(actions, client_request_token, target, task_id)
    start_detect_mitigation_actions_task(actions, client_request_token, target, task_id, params::Dict{String,<:Any})

 Starts a Device Defender ML Detect mitigation actions task.  Requires permission to access
the StartDetectMitigationActionsTask action.

# Arguments
- `actions`:  The actions to be performed when a device has unexpected behavior.
- `client_request_token`:  Each mitigation action task must have a unique client request
  token. If you try to create a new task with the same token as a task that already exists,
  an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically
  generate a unique client request.
- `target`:  Specifies the ML Detect findings to which the mitigation actions are applied.
- `task_id`:  The unique identifier of the task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeOnlyActiveViolations"`:  Specifies to list only active violations.
- `"includeSuppressedAlerts"`:  Specifies to include suppressed alerts.
- `"violationEventOccurrenceRange"`:  Specifies the time period of which violation events
  occurred between.
"""
function start_detect_mitigation_actions_task(
    actions,
    clientRequestToken,
    target,
    taskId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/detect/mitigationactions/tasks/$(taskId)",
        Dict{String,Any}(
            "actions" => actions,
            "clientRequestToken" => clientRequestToken,
            "target" => target,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_detect_mitigation_actions_task(
    actions,
    clientRequestToken,
    target,
    taskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/detect/mitigationactions/tasks/$(taskId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actions" => actions,
                    "clientRequestToken" => clientRequestToken,
                    "target" => target,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_on_demand_audit_task(target_check_names)
    start_on_demand_audit_task(target_check_names, params::Dict{String,<:Any})

Starts an on-demand Device Defender audit. Requires permission to access the
StartOnDemandAuditTask action.

# Arguments
- `target_check_names`: Which checks are performed during the audit. The checks you specify
  must be enabled for your account or an exception occurs. Use
  DescribeAccountAuditConfiguration to see the list of all checks, including those that are
  enabled or UpdateAccountAuditConfiguration to select which checks are enabled.

"""
function start_on_demand_audit_task(
    targetCheckNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/audit/tasks",
        Dict{String,Any}("targetCheckNames" => targetCheckNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_on_demand_audit_task(
    targetCheckNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/audit/tasks",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("targetCheckNames" => targetCheckNames), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_thing_registration_task(input_file_bucket, input_file_key, role_arn, template_body)
    start_thing_registration_task(input_file_bucket, input_file_key, role_arn, template_body, params::Dict{String,<:Any})

Creates a bulk thing provisioning task. Requires permission to access the
StartThingRegistrationTask action.

# Arguments
- `input_file_bucket`: The S3 bucket that contains the input file.
- `input_file_key`: The name of input file within the S3 bucket. This file contains a
  newline delimited JSON file. Each line contains the parameter values to provision one
  device (thing).
- `role_arn`: The IAM role ARN that grants permission the input file.
- `template_body`: The provisioning template.

"""
function start_thing_registration_task(
    inputFileBucket,
    inputFileKey,
    roleArn,
    templateBody;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/thing-registration-tasks",
        Dict{String,Any}(
            "inputFileBucket" => inputFileBucket,
            "inputFileKey" => inputFileKey,
            "roleArn" => roleArn,
            "templateBody" => templateBody,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_thing_registration_task(
    inputFileBucket,
    inputFileKey,
    roleArn,
    templateBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/thing-registration-tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "inputFileBucket" => inputFileBucket,
                    "inputFileKey" => inputFileKey,
                    "roleArn" => roleArn,
                    "templateBody" => templateBody,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_thing_registration_task(task_id)
    stop_thing_registration_task(task_id, params::Dict{String,<:Any})

Cancels a bulk thing provisioning task. Requires permission to access the
StopThingRegistrationTask action.

# Arguments
- `task_id`: The bulk thing provisioning task ID.

"""
function stop_thing_registration_task(
    taskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/thing-registration-tasks/$(taskId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_thing_registration_task(
    taskId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/thing-registration-tasks/$(taskId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds to or modifies the tags of the given resource. Tags are metadata which can be used to
manage a resource. Requires permission to access the TagResource action.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tags`: The new or modified tags for the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/tags",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/tags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_authorization(auth_infos)
    test_authorization(auth_infos, params::Dict{String,<:Any})

Tests if a specified principal is authorized to perform an IoT action on a specified
resource. Use this to test and debug the authorization behavior of devices that connect to
the IoT device gateway. Requires permission to access the TestAuthorization action.

# Arguments
- `auth_infos`: A list of authorization info objects. Simulating authorization will create
  a response for each authInfo object in the list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientId"`: The MQTT client ID.
- `"cognitoIdentityPoolId"`: The Cognito identity pool ID.
- `"policyNamesToAdd"`: When testing custom authorization, the policies specified here are
  treated as if they are attached to the principal being authorized.
- `"policyNamesToSkip"`: When testing custom authorization, the policies specified here are
  treated as if they are not attached to the principal being authorized.
- `"principal"`: The principal. Valid principals are CertificateArn
  (arn:aws:iot:region:accountId:cert/certificateId), thingGroupArn
  (arn:aws:iot:region:accountId:thinggroup/groupName) and CognitoId (region:id).
"""
function test_authorization(authInfos; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST",
        "/test-authorization",
        Dict{String,Any}("authInfos" => authInfos);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_authorization(
    authInfos,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/test-authorization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("authInfos" => authInfos), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_invoke_authorizer(authorizer_name)
    test_invoke_authorizer(authorizer_name, params::Dict{String,<:Any})

Tests a custom authorization behavior by invoking a specified custom authorizer. Use this
to test and debug the custom authorization behavior of devices that connect to the IoT
device gateway. Requires permission to access the TestInvokeAuthorizer action.

# Arguments
- `authorizer_name`: The custom authorizer name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"httpContext"`: Specifies a test HTTP authorization request.
- `"mqttContext"`: Specifies a test MQTT authorization request.
- `"tlsContext"`: Specifies a test TLS authorization request.
- `"token"`: The token returned by your custom authentication service.
- `"tokenSignature"`: The signature made with the token and your custom authentication
  service's private key. This value must be Base-64-encoded.
"""
function test_invoke_authorizer(
    authorizerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/authorizer/$(authorizerName)/test";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_invoke_authorizer(
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/authorizer/$(authorizerName)/test",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    transfer_certificate(certificate_id, target_aws_account)
    transfer_certificate(certificate_id, target_aws_account, params::Dict{String,<:Any})

Transfers the specified certificate to the specified Amazon Web Services account. Requires
permission to access the TransferCertificate action. You can cancel the transfer until it
is acknowledged by the recipient. No notification is sent to the transfer destination's
account. It is up to the caller to notify the transfer target. The certificate being
transferred must not be in the ACTIVE state. You can use the UpdateCertificate action to
deactivate it. The certificate must not have any policies attached to it. You can use the
DetachPolicy action to detach them.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)
- `target_aws_account`: The Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"transferMessage"`: The transfer message.
"""
function transfer_certificate(
    certificateId, targetAwsAccount; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/transfer-certificate/$(certificateId)",
        Dict{String,Any}("targetAwsAccount" => targetAwsAccount);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function transfer_certificate(
    certificateId,
    targetAwsAccount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/transfer-certificate/$(certificateId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("targetAwsAccount" => targetAwsAccount), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the given tags (metadata) from the resource. Requires permission to access the
UntagResource action.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tag_keys`: A list of the keys of the tags to be removed from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/untag",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/untag",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_audit_configuration()
    update_account_audit_configuration(params::Dict{String,<:Any})

Configures or reconfigures the Device Defender audit settings for this account. Settings
include how audit notifications are sent and which audit checks are enabled or disabled.
Requires permission to access the UpdateAccountAuditConfiguration action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"auditCheckConfigurations"`: Specifies which audit checks are enabled and disabled for
  this account. Use DescribeAccountAuditConfiguration to see the list of all checks,
  including those that are currently enabled. Some data collection might start immediately
  when certain checks are enabled. When a check is disabled, any data collected so far in
  relation to the check is deleted. You cannot disable a check if it's used by any scheduled
  audit. You must first delete the check from the scheduled audit or delete the scheduled
  audit itself. On the first call to UpdateAccountAuditConfiguration, this parameter is
  required and must specify at least one enabled check.
- `"auditNotificationTargetConfigurations"`: Information about the targets to which audit
  notifications are sent.
- `"roleArn"`: The Amazon Resource Name (ARN) of the role that grants permission to IoT to
  access information about your devices, policies, certificates, and other items as required
  when performing an audit.
"""
function update_account_audit_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/audit/configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account_audit_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/audit/configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_audit_suppression(check_name, resource_identifier)
    update_audit_suppression(check_name, resource_identifier, params::Dict{String,<:Any})

 Updates a Device Defender audit suppression.

# Arguments
- `check_name`:
- `resource_identifier`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  The description of the audit suppression.
- `"expirationDate"`:  The expiration date (epoch timestamp in seconds) that you want the
  suppression to adhere to.
- `"suppressIndefinitely"`:  Indicates whether a suppression should exist indefinitely or
  not.
"""
function update_audit_suppression(
    checkName, resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/audit/suppressions/update",
        Dict{String,Any}(
            "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_audit_suppression(
    checkName,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/audit/suppressions/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "checkName" => checkName, "resourceIdentifier" => resourceIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_authorizer(authorizer_name)
    update_authorizer(authorizer_name, params::Dict{String,<:Any})

Updates an authorizer. Requires permission to access the UpdateAuthorizer action.

# Arguments
- `authorizer_name`: The authorizer name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorizerFunctionArn"`: The ARN of the authorizer's Lambda function.
- `"enableCachingForHttp"`: When true, the result from the authorizer’s Lambda function
  is cached for the time specified in refreshAfterInSeconds. The cached result is used while
  the device reuses the same HTTP connection.
- `"status"`: The status of the update authorizer request.
- `"tokenKeyName"`: The key used to extract the token from the HTTP headers.
- `"tokenSigningPublicKeys"`: The public keys used to verify the token signature.
"""
function update_authorizer(
    authorizerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/authorizer/$(authorizerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_authorizer(
    authorizerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/authorizer/$(authorizerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_billing_group(billing_group_name, billing_group_properties)
    update_billing_group(billing_group_name, billing_group_properties, params::Dict{String,<:Any})

Updates information about the billing group. Requires permission to access the
UpdateBillingGroup action.

# Arguments
- `billing_group_name`: The name of the billing group.
- `billing_group_properties`: The properties of the billing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the billing group. If the version of the
  billing group does not match the expected version specified in the request, the
  UpdateBillingGroup request is rejected with a VersionConflictException.
"""
function update_billing_group(
    billingGroupName,
    billingGroupProperties;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/billing-groups/$(billingGroupName)",
        Dict{String,Any}("billingGroupProperties" => billingGroupProperties);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_billing_group(
    billingGroupName,
    billingGroupProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/billing-groups/$(billingGroupName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("billingGroupProperties" => billingGroupProperties),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_cacertificate(ca_certificate_id)
    update_cacertificate(ca_certificate_id, params::Dict{String,<:Any})

Updates a registered CA certificate. Requires permission to access the UpdateCACertificate
action.

# Arguments
- `ca_certificate_id`: The CA certificate identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"newAutoRegistrationStatus"`: The new value for the auto registration status. Valid
  values are: \"ENABLE\" or \"DISABLE\".
- `"newStatus"`: The updated status of the CA certificate.  Note: The status value
  REGISTER_INACTIVE is deprecated and should not be used.
- `"registrationConfig"`: Information about the registration configuration.
- `"removeAutoRegistration"`: If true, removes auto registration.
"""
function update_cacertificate(
    caCertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/cacertificate/$(caCertificateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_cacertificate(
    caCertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/cacertificate/$(caCertificateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_certificate(certificate_id, new_status)
    update_certificate(certificate_id, new_status, params::Dict{String,<:Any})

Updates the status of the specified certificate. This operation is idempotent. Requires
permission to access the UpdateCertificate action. Certificates must be in the ACTIVE state
to authenticate devices that use a certificate to connect to IoT. Within a few minutes of
updating a certificate from the ACTIVE state to any other state, IoT disconnects all
devices that used that certificate to connect. Devices cannot use a certificate that is not
in the ACTIVE state to reconnect.

# Arguments
- `certificate_id`: The ID of the certificate. (The last part of the certificate ARN
  contains the certificate ID.)
- `new_status`: The new status.  Note: Setting the status to PENDING_TRANSFER or
  PENDING_ACTIVATION will result in an exception being thrown. PENDING_TRANSFER and
  PENDING_ACTIVATION are statuses used internally by IoT. They are not intended for developer
  use.  Note: The status value REGISTER_INACTIVE is deprecated and should not be used.

"""
function update_certificate(
    certificateId, newStatus; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/certificates/$(certificateId)",
        Dict{String,Any}("newStatus" => newStatus);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_certificate(
    certificateId,
    newStatus,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/certificates/$(certificateId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("newStatus" => newStatus), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_certificate_provider(certificate_provider_name)
    update_certificate_provider(certificate_provider_name, params::Dict{String,<:Any})

Updates a certificate provider. Requires permission to access the UpdateCertificateProvider
action.

# Arguments
- `certificate_provider_name`: The name of the certificate provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountDefaultForOperations"`: A list of the operations that the certificate provider
  will use to generate certificates. Valid value: CreateCertificateFromCsr.
- `"lambdaFunctionArn"`: The Lambda function ARN that's associated with the certificate
  provider.
"""
function update_certificate_provider(
    certificateProviderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/certificate-providers/$(certificateProviderName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_certificate_provider(
    certificateProviderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/certificate-providers/$(certificateProviderName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_custom_metric(display_name, metric_name)
    update_custom_metric(display_name, metric_name, params::Dict{String,<:Any})

Updates a Device Defender detect custom metric.  Requires permission to access the
UpdateCustomMetric action.

# Arguments
- `display_name`:  Field represents a friendly name in the console for the custom metric,
  it doesn't have to be unique. Don't use this name as the metric identifier in the device
  metric report. Can be updated.
- `metric_name`:  The name of the custom metric. Cannot be updated.

"""
function update_custom_metric(
    displayName, metricName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/custom-metric/$(metricName)",
        Dict{String,Any}("displayName" => displayName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_custom_metric(
    displayName,
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/custom-metric/$(metricName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("displayName" => displayName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_dimension(name, string_values)
    update_dimension(name, string_values, params::Dict{String,<:Any})

Updates the definition for a dimension. You cannot change the type of a dimension after it
is created (you can delete it and recreate it). Requires permission to access the
UpdateDimension action.

# Arguments
- `name`: A unique identifier for the dimension. Choose something that describes the type
  and value to make it easy to remember what it does.
- `string_values`: Specifies the value or list of values for the dimension. For
  TOPIC_FILTER dimensions, this is a pattern used to match the MQTT topic (for example,
  \"admin/#\").

"""
function update_dimension(
    name, stringValues; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/dimensions/$(name)",
        Dict{String,Any}("stringValues" => stringValues);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_dimension(
    name,
    stringValues,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/dimensions/$(name)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("stringValues" => stringValues), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_configuration(domain_configuration_name)
    update_domain_configuration(domain_configuration_name, params::Dict{String,<:Any})

Updates values stored in the domain configuration. Domain configurations for default
endpoints can't be updated. Requires permission to access the UpdateDomainConfiguration
action.

# Arguments
- `domain_configuration_name`: The name of the domain configuration to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorizerConfig"`: An object that specifies the authorization service for a domain.
- `"domainConfigurationStatus"`: The status to which the domain configuration should be
  updated.
- `"removeAuthorizerConfig"`: Removes the authorization configuration from a domain.
- `"serverCertificateConfig"`: The server certificate configuration.
- `"tlsConfig"`: An object that specifies the TLS configuration for a domain.
"""
function update_domain_configuration(
    domainConfigurationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/domainConfigurations/$(domainConfigurationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_configuration(
    domainConfigurationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/domainConfigurations/$(domainConfigurationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_dynamic_thing_group(thing_group_name, thing_group_properties)
    update_dynamic_thing_group(thing_group_name, thing_group_properties, params::Dict{String,<:Any})

Updates a dynamic thing group. Requires permission to access the UpdateDynamicThingGroup
action.

# Arguments
- `thing_group_name`: The name of the dynamic thing group to update.
- `thing_group_properties`: The dynamic thing group properties to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the dynamic thing group to update.
- `"indexName"`: The dynamic thing group index to update.  Currently one index is
  supported: AWS_Things.
- `"queryString"`: The dynamic thing group search query string to update.
- `"queryVersion"`: The dynamic thing group query version to update.  Currently one query
  version is supported: \"2017-09-30\". If not specified, the query version defaults to this
  value.
"""
function update_dynamic_thing_group(
    thingGroupName, thingGroupProperties; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/dynamic-thing-groups/$(thingGroupName)",
        Dict{String,Any}("thingGroupProperties" => thingGroupProperties);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_dynamic_thing_group(
    thingGroupName,
    thingGroupProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/dynamic-thing-groups/$(thingGroupName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("thingGroupProperties" => thingGroupProperties),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_event_configurations()
    update_event_configurations(params::Dict{String,<:Any})

Updates the event configurations. Requires permission to access the
UpdateEventConfigurations action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"eventConfigurations"`: The new event configuration values.
"""
function update_event_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PATCH",
        "/event-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_event_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/event-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_fleet_metric(index_name, metric_name)
    update_fleet_metric(index_name, metric_name, params::Dict{String,<:Any})

Updates the data for a fleet metric. Requires permission to access the UpdateFleetMetric
action.

# Arguments
- `index_name`: The name of the index to search.
- `metric_name`: The name of the fleet metric to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"aggregationField"`: The field to aggregate.
- `"aggregationType"`: The type of the aggregation query.
- `"description"`: The description of the fleet metric.
- `"expectedVersion"`: The expected version of the fleet metric record in the registry.
- `"period"`: The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1
  day)] and must be multiple of 60.
- `"queryString"`: The search query string.
- `"queryVersion"`: The version of the query.
- `"unit"`: Used to support unit transformation such as milliseconds to seconds. The unit
  must be supported by CW metric.
"""
function update_fleet_metric(
    indexName, metricName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/fleet-metric/$(metricName)",
        Dict{String,Any}("indexName" => indexName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_fleet_metric(
    indexName,
    metricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/fleet-metric/$(metricName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("indexName" => indexName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_indexing_configuration()
    update_indexing_configuration(params::Dict{String,<:Any})

Updates the search configuration. Requires permission to access the
UpdateIndexingConfiguration action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"thingGroupIndexingConfiguration"`: Thing group indexing configuration.
- `"thingIndexingConfiguration"`: Thing indexing configuration.
"""
function update_indexing_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "POST", "/indexing/config"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_indexing_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/indexing/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_job(job_id)
    update_job(job_id, params::Dict{String,<:Any})

Updates supported fields of the specified job. Requires permission to access the UpdateJob
action.

# Arguments
- `job_id`: The ID of the job to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"abortConfig"`: Allows you to create criteria to abort a job.
- `"description"`: A short text description of the job.
- `"jobExecutionsRetryConfig"`: Allows you to create the criteria to retry a job.
- `"jobExecutionsRolloutConfig"`: Allows you to create a staged rollout of the job.
- `"namespaceId"`: The namespace used to indicate that a job is a customer-managed job.
  When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs
  notifications to MQTT topics that contain the value in the following format.
  aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/   The namespaceId feature
  is only supported by IoT Greengrass at this time. For more information, see Setting up IoT
  Greengrass core devices.
- `"presignedUrlConfig"`: Configuration information for pre-signed S3 URLs.
- `"timeoutConfig"`: Specifies the amount of time each device has to finish its execution
  of the job. The timer is started when the job execution status is set to IN_PROGRESS. If
  the job execution status is not set to another terminal state before the time expires, it
  will be automatically set to TIMED_OUT.
"""
function update_job(jobId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PATCH", "/jobs/$(jobId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_job(
    jobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/jobs/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_mitigation_action(action_name)
    update_mitigation_action(action_name, params::Dict{String,<:Any})

Updates the definition for the specified mitigation action. Requires permission to access
the UpdateMitigationAction action.

# Arguments
- `action_name`: The friendly name for the mitigation action. You cannot change the name by
  using UpdateMitigationAction. Instead, you must delete and recreate the mitigation action
  with the new name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionParams"`: Defines the type of action and the parameters for that action.
- `"roleArn"`: The ARN of the IAM role that is used to apply the mitigation action.
"""
function update_mitigation_action(
    actionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/mitigationactions/actions/$(actionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_mitigation_action(
    actionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/mitigationactions/actions/$(actionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_package(package_name)
    update_package(package_name, params::Dict{String,<:Any})

Updates the supported fields for a specific software package. Requires permission to access
the UpdatePackage and GetIndexingConfiguration actions.

# Arguments
- `package_name`: The name of the target software package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"defaultVersionName"`: The name of the default package version.  Note: You cannot name a
  defaultVersion and set unsetDefaultVersion equal to true at the same time.
- `"description"`: The package description.
- `"unsetDefaultVersion"`: Indicates whether you want to remove the named default package
  version from the software package. Set as true to remove the default package version.
  Note: You cannot name a defaultVersion and set unsetDefaultVersion equal to true at the
  same time.
"""
function update_package(packageName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PATCH",
        "/packages/$(packageName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_package(
    packageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/packages/$(packageName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_package_configuration()
    update_package_configuration(params::Dict{String,<:Any})

Updates the software package configuration. Requires permission to access the
UpdatePackageConfiguration and iam:PassRole actions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"versionUpdateByJobsConfig"`: Configuration to manage job's package version reporting.
  This updates the thing's reserved named shadow that the job targets.
"""
function update_package_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PATCH",
        "/package-configuration",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_package_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/package-configuration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_package_version(package_name, version_name)
    update_package_version(package_name, version_name, params::Dict{String,<:Any})

Updates the supported fields for a specific package version. Requires permission to access
the UpdatePackageVersion and GetIndexingConfiguration actions.

# Arguments
- `package_name`: The name of the associated software package.
- `version_name`: The name of the target package version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"action"`: The status that the package version should be assigned. For more information,
  see Package version lifecycle.
- `"attributes"`: Metadata that can be used to define a package version’s configuration.
  For example, the Amazon S3 file location, configuration options that are being sent to the
  device or fleet.   Note: Attributes can be updated only when the package version is in a
  draft state. The combined size of all the attributes on a package version is limited to 3KB.
- `"clientToken"`: A unique case-sensitive identifier that you can provide to ensure the
  idempotency of the request. Don't reuse this client token if a new idempotent request is
  required.
- `"description"`: The package version description.
"""
function update_package_version(
    packageName, versionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_package_version(
    packageName,
    versionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/packages/$(packageName)/versions/$(versionName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_provisioning_template(template_name)
    update_provisioning_template(template_name, params::Dict{String,<:Any})

Updates a provisioning template. Requires permission to access the
UpdateProvisioningTemplate action.

# Arguments
- `template_name`: The name of the provisioning template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultVersionId"`: The ID of the default provisioning template version.
- `"description"`: The description of the provisioning template.
- `"enabled"`: True to enable the provisioning template, otherwise false.
- `"preProvisioningHook"`: Updates the pre-provisioning hook template. Only supports
  template of type FLEET_PROVISIONING. For more information about provisioning template
  types, see type.
- `"provisioningRoleArn"`: The ARN of the role associated with the provisioning template.
  This IoT role grants permission to provision a device.
- `"removePreProvisioningHook"`: Removes pre-provisioning hook template.
"""
function update_provisioning_template(
    templateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/provisioning-templates/$(templateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_provisioning_template(
    templateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/provisioning-templates/$(templateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_role_alias(role_alias)
    update_role_alias(role_alias, params::Dict{String,<:Any})

Updates a role alias. Requires permission to access the UpdateRoleAlias action.

# Arguments
- `role_alias`: The role alias to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"credentialDurationSeconds"`: The number of seconds the credential will be valid. This
  value must be less than or equal to the maximum session duration of the IAM role that the
  role alias references.
- `"roleArn"`: The role ARN.
"""
function update_role_alias(roleAlias; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/role-aliases/$(roleAlias)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_role_alias(
    roleAlias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/role-aliases/$(roleAlias)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_scheduled_audit(scheduled_audit_name)
    update_scheduled_audit(scheduled_audit_name, params::Dict{String,<:Any})

Updates a scheduled audit, including which checks are performed and how often the audit
takes place. Requires permission to access the UpdateScheduledAudit action.

# Arguments
- `scheduled_audit_name`: The name of the scheduled audit. (Max. 128 chars)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dayOfMonth"`: The day of the month on which the scheduled audit takes place. This can
  be 1 through 31 or LAST. This field is required if the frequency parameter is set to
  MONTHLY. If days 29-31 are specified, and the month does not have that many days, the audit
  takes place on the \"LAST\" day of the month.
- `"dayOfWeek"`: The day of the week on which the scheduled audit takes place. This can be
  one of SUN, MON, TUE, WED, THU, FRI, or SAT. This field is required if the \"frequency\"
  parameter is set to WEEKLY or BIWEEKLY.
- `"frequency"`: How often the scheduled audit takes place, either DAILY, WEEKLY, BIWEEKLY,
  or MONTHLY. The start time of each audit is determined by the system.
- `"targetCheckNames"`: Which checks are performed during the scheduled audit. Checks must
  be enabled for your account. (Use DescribeAccountAuditConfiguration to see the list of all
  checks, including those that are enabled or use UpdateAccountAuditConfiguration to select
  which checks are enabled.)
"""
function update_scheduled_audit(
    scheduledAuditName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/audit/scheduledaudits/$(scheduledAuditName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_scheduled_audit(
    scheduledAuditName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/audit/scheduledaudits/$(scheduledAuditName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_security_profile(security_profile_name)
    update_security_profile(security_profile_name, params::Dict{String,<:Any})

Updates a Device Defender security profile. Requires permission to access the
UpdateSecurityProfile action.

# Arguments
- `security_profile_name`: The name of the security profile you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalMetricsToRetain"`:  Please use
  UpdateSecurityProfileRequestadditionalMetricsToRetainV2 instead.  A list of metrics whose
  data is retained (stored). By default, data is retained for any metric used in the
  profile's behaviors, but it is also retained for any metric specified here. Can be used
  with custom metrics; cannot be used with dimensions.
- `"additionalMetricsToRetainV2"`: A list of metrics whose data is retained (stored). By
  default, data is retained for any metric used in the profile's behaviors, but it is also
  retained for any metric specified here. Can be used with custom metrics; cannot be used
  with dimensions.
- `"alertTargets"`: Where the alerts are sent. (Alerts are always sent to the console.)
- `"behaviors"`: Specifies the behaviors that, when violated by a device (thing), cause an
  alert.
- `"deleteAdditionalMetricsToRetain"`: If true, delete all additionalMetricsToRetain
  defined for this security profile. If any additionalMetricsToRetain are defined in the
  current invocation, an exception occurs.
- `"deleteAlertTargets"`: If true, delete all alertTargets defined for this security
  profile. If any alertTargets are defined in the current invocation, an exception occurs.
- `"deleteBehaviors"`: If true, delete all behaviors defined for this security profile. If
  any behaviors are defined in the current invocation, an exception occurs.
- `"deleteMetricsExportConfig"`: Set the value as true to delete metrics export related
  configurations.
- `"expectedVersion"`: The expected version of the security profile. A new version is
  generated whenever the security profile is updated. If you specify a value that is
  different from the actual version, a VersionConflictException is thrown.
- `"metricsExportConfig"`: Specifies the MQTT topic and role ARN required for metric export.
- `"securityProfileDescription"`: A description of the security profile.
"""
function update_security_profile(
    securityProfileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/security-profiles/$(securityProfileName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_security_profile(
    securityProfileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/security-profiles/$(securityProfileName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_stream(stream_id)
    update_stream(stream_id, params::Dict{String,<:Any})

Updates an existing stream. The stream version will be incremented by one. Requires
permission to access the UpdateStream action.

# Arguments
- `stream_id`: The stream ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the stream.
- `"files"`: The files associated with the stream.
- `"roleArn"`: An IAM role that allows the IoT service principal assumes to access your S3
  files.
"""
function update_stream(streamId; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/streams/$(streamId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_stream(
    streamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PUT",
        "/streams/$(streamId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_thing(thing_name)
    update_thing(thing_name, params::Dict{String,<:Any})

Updates the data for a thing. Requires permission to access the UpdateThing action.

# Arguments
- `thing_name`: The name of the thing to update. You can't change a thing's name. To change
  a thing's name, you must create a new thing, give it the new name, and then delete the old
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributePayload"`: A list of thing attributes, a JSON string containing name-value
  pairs. For example:  {\"attributes\":{\"name1\":\"value2\"}}  This data is used to add new
  attributes or update existing attributes.
- `"expectedVersion"`: The expected version of the thing record in the registry. If the
  version of the record in the registry does not match the expected version specified in the
  request, the UpdateThing request is rejected with a VersionConflictException.
- `"removeThingType"`: Remove a thing type association. If true, the association is removed.
- `"thingTypeName"`: The name of the thing type.
"""
function update_thing(thingName; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PATCH",
        "/things/$(thingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_thing(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/things/$(thingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_thing_group(thing_group_name, thing_group_properties)
    update_thing_group(thing_group_name, thing_group_properties, params::Dict{String,<:Any})

Update a thing group. Requires permission to access the UpdateThingGroup action.

# Arguments
- `thing_group_name`: The thing group to update.
- `thing_group_properties`: The thing group properties.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedVersion"`: The expected version of the thing group. If this does not match the
  version of the thing group being updated, the update will fail.
"""
function update_thing_group(
    thingGroupName, thingGroupProperties; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/thing-groups/$(thingGroupName)",
        Dict{String,Any}("thingGroupProperties" => thingGroupProperties);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_thing_group(
    thingGroupName,
    thingGroupProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/thing-groups/$(thingGroupName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("thingGroupProperties" => thingGroupProperties),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_thing_groups_for_thing()
    update_thing_groups_for_thing(params::Dict{String,<:Any})

Updates the groups to which the thing belongs. Requires permission to access the
UpdateThingGroupsForThing action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"overrideDynamicGroups"`: Override dynamic thing groups with static thing groups when
  10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those
  groups are dynamic thing groups, adding a thing to a static group removes the thing from
  the last dynamic group.
- `"thingGroupsToAdd"`: The groups to which the thing will be added.
- `"thingGroupsToRemove"`: The groups from which the thing will be removed.
- `"thingName"`: The thing whose group memberships will be updated.
"""
function update_thing_groups_for_thing(; aws_config::AbstractAWSConfig=current_aws_config())
    return iot(
        "PUT",
        "/thing-groups/updateThingGroupsForThing";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_thing_groups_for_thing(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PUT",
        "/thing-groups/updateThingGroupsForThing",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_topic_rule_destination(arn, status)
    update_topic_rule_destination(arn, status, params::Dict{String,<:Any})

Updates a topic rule destination. You use this to change the status, endpoint URL, or
confirmation URL of the destination. Requires permission to access the
UpdateTopicRuleDestination action.

# Arguments
- `arn`: The ARN of the topic rule destination.
- `status`: The status of the topic rule destination. Valid values are:  IN_PROGRESS  A
  topic rule destination was created but has not been confirmed. You can set status to
  IN_PROGRESS by calling UpdateTopicRuleDestination. Calling UpdateTopicRuleDestination
  causes a new confirmation challenge to be sent to your confirmation endpoint.  ENABLED
  Confirmation was completed, and traffic to this destination is allowed. You can set status
  to DISABLED by calling UpdateTopicRuleDestination.  DISABLED  Confirmation was completed,
  and traffic to this destination is not allowed. You can set status to ENABLED by calling
  UpdateTopicRuleDestination.  ERROR  Confirmation could not be completed, for example if the
  confirmation timed out. You can call GetTopicRuleDestination for details about the error.
  You can set status to IN_PROGRESS by calling UpdateTopicRuleDestination. Calling
  UpdateTopicRuleDestination causes a new confirmation challenge to be sent to your
  confirmation endpoint.

"""
function update_topic_rule_destination(
    arn, status; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "PATCH",
        "/destinations",
        Dict{String,Any}("arn" => arn, "status" => status);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_topic_rule_destination(
    arn,
    status,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "PATCH",
        "/destinations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("arn" => arn, "status" => status), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_security_profile_behaviors(behaviors)
    validate_security_profile_behaviors(behaviors, params::Dict{String,<:Any})

Validates a Device Defender security profile behaviors specification. Requires permission
to access the ValidateSecurityProfileBehaviors action.

# Arguments
- `behaviors`: Specifies the behaviors that, when violated by a device (thing), cause an
  alert.

"""
function validate_security_profile_behaviors(
    behaviors; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iot(
        "POST",
        "/security-profile-behaviors/validate",
        Dict{String,Any}("behaviors" => behaviors);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_security_profile_behaviors(
    behaviors,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iot(
        "POST",
        "/security-profile-behaviors/validate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("behaviors" => behaviors), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
