# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: iotfleetwise
using AWS.Compat
using AWS.UUIDs

"""
    associate_vehicle_fleet(fleet_id, vehicle_name)
    associate_vehicle_fleet(fleet_id, vehicle_name, params::Dict{String,<:Any})

 Adds, or associates, a vehicle with a fleet.

# Arguments
- `fleet_id`:  The ID of a fleet.
- `vehicle_name`:  The unique ID of the vehicle to associate with the fleet.

"""
function associate_vehicle_fleet(
    fleetId, vehicleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "AssociateVehicleFleet",
        Dict{String,Any}("fleetId" => fleetId, "vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_vehicle_fleet(
    fleetId,
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "AssociateVehicleFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("fleetId" => fleetId, "vehicleName" => vehicleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_create_vehicle(vehicles)
    batch_create_vehicle(vehicles, params::Dict{String,<:Any})

 Creates a group, or batch, of vehicles.    You must specify a decoder manifest and a
vehicle model (model manifest) for each vehicle.   For more information, see Create
multiple vehicles (AWS CLI) in the Amazon Web Services IoT FleetWise Developer Guide.

# Arguments
- `vehicles`:  A list of information about each vehicle to create. For more information,
  see the API data type.

"""
function batch_create_vehicle(vehicles; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "BatchCreateVehicle",
        Dict{String,Any}("vehicles" => vehicles);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_create_vehicle(
    vehicles,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "BatchCreateVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicles" => vehicles), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_vehicle(vehicles)
    batch_update_vehicle(vehicles, params::Dict{String,<:Any})

 Updates a group, or batch, of vehicles.   You must specify a decoder manifest and a
vehicle model (model manifest) for each vehicle.   For more information, see Update
multiple vehicles (AWS CLI) in the Amazon Web Services IoT FleetWise Developer Guide.

# Arguments
- `vehicles`:  A list of information about the vehicles to update. For more information,
  see the API data type.

"""
function batch_update_vehicle(vehicles; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "BatchUpdateVehicle",
        Dict{String,Any}("vehicles" => vehicles);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_vehicle(
    vehicles,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "BatchUpdateVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicles" => vehicles), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_campaign(collection_scheme, name, signal_catalog_arn, target_arn)
    create_campaign(collection_scheme, name, signal_catalog_arn, target_arn, params::Dict{String,<:Any})

Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise
Edge Agent software running in vehicles uses campaigns to decide how to collect and
transfer data to the cloud. You create campaigns in the cloud. After you or your team
approve campaigns, Amazon Web Services IoT FleetWise automatically deploys them to
vehicles.  For more information, see Collect and transfer data with campaigns in the Amazon
Web Services IoT FleetWise Developer Guide.

# Arguments
- `collection_scheme`:  The data collection scheme associated with the campaign. You can
  specify a scheme that collects data based on time or an event.
- `name`:  The name of the campaign to create.
- `signal_catalog_arn`: The Amazon Resource Name (ARN) of the signal catalog to associate
  with the campaign.
- `target_arn`:  The ARN of the vehicle or fleet to deploy a campaign to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"compression"`:  (Optional) Whether to compress signals before transmitting data to
  Amazon Web Services IoT FleetWise. If you don't want to compress the signals, use OFF. If
  it's not specified, SNAPPY is used.  Default: SNAPPY
- `"dataDestinationConfigs"`: The destination where the campaign sends data. You can choose
  to send data to be stored in Amazon S3 or Amazon Timestream. Amazon S3 optimizes the cost
  of data storage and provides additional mechanisms to use vehicle data, such as data lakes,
  centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT
  FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on
  multiple Amazon Web Services IoT FleetWise servers for redundancy and high availability.
  You can use Amazon Timestream to access and analyze time series data, and Timestream to
  query vehicle data so that you can identify trends and patterns.
- `"dataExtraDimensions"`:  (Optional) A list of vehicle attributes to associate with a
  campaign.  Enrich the data with specified vehicle attributes. For example, add make and
  model to the campaign, and Amazon Web Services IoT FleetWise will associate the data with
  those attributes as dimensions in Amazon Timestream. You can then query the data against
  make and model. Default: An empty array
- `"description"`: An optional description of the campaign to help identify its purpose.
- `"diagnosticsMode"`:  (Optional) Option for a vehicle to send diagnostic trouble codes to
  Amazon Web Services IoT FleetWise. If you want to send diagnostic trouble codes, use
  SEND_ACTIVE_DTCS. If it's not specified, OFF is used. Default: OFF
- `"expiryTime"`:  (Optional) The time the campaign expires, in seconds since epoch
  (January 1, 1970 at midnight UTC time). Vehicle data isn't collected after the campaign
  expires.  Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
- `"postTriggerCollectionDuration"`:  (Optional) How long (in milliseconds) to collect raw
  data after a triggering event initiates the collection. If it's not specified, 0 is used.
  Default: 0
- `"priority"`: (Optional) A number indicating the priority of one campaign over another
  campaign for a certain vehicle or fleet. A campaign with the lowest value is deployed to
  vehicles before any other campaigns. If it's not specified, 0 is used.  Default: 0
- `"signalsToCollect"`: (Optional) A list of information about signals to collect.
- `"spoolingMode"`: (Optional) Whether to store collected data after a vehicle lost a
  connection with the cloud. After a connection is re-established, the data is automatically
  forwarded to Amazon Web Services IoT FleetWise. If you want to store collected data when a
  vehicle loses connection with the cloud, use TO_DISK. If it's not specified, OFF is used.
  Default: OFF
- `"startTime"`: (Optional) The time, in milliseconds, to deliver a campaign after it was
  approved. If it's not specified, 0 is used. Default: 0
- `"tags"`: Metadata that can be used to manage the campaign.
"""
function create_campaign(
    collectionScheme,
    name,
    signalCatalogArn,
    targetArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateCampaign",
        Dict{String,Any}(
            "collectionScheme" => collectionScheme,
            "name" => name,
            "signalCatalogArn" => signalCatalogArn,
            "targetArn" => targetArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_campaign(
    collectionScheme,
    name,
    signalCatalogArn,
    targetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateCampaign",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "collectionScheme" => collectionScheme,
                    "name" => name,
                    "signalCatalogArn" => signalCatalogArn,
                    "targetArn" => targetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_decoder_manifest(model_manifest_arn, name)
    create_decoder_manifest(model_manifest_arn, name, params::Dict{String,<:Any})

Creates the decoder manifest associated with a model manifest. To create a decoder
manifest, the following must be true:   Every signal decoder has a unique name.   Each
signal decoder is associated with a network interface.   Each network interface has a
unique ID.   The signal decoders are specified in the model manifest.

# Arguments
- `model_manifest_arn`:  The Amazon Resource Name (ARN) of the vehicle model (model
  manifest).
- `name`:  The unique name of the decoder manifest to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the decoder manifest.
- `"networkInterfaces"`:  A list of information about available network interfaces.
- `"signalDecoders"`:  A list of information about signal decoders.
- `"tags"`: Metadata that can be used to manage the decoder manifest.
"""
function create_decoder_manifest(
    modelManifestArn, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "CreateDecoderManifest",
        Dict{String,Any}("modelManifestArn" => modelManifestArn, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_decoder_manifest(
    modelManifestArn,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateDecoderManifest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("modelManifestArn" => modelManifestArn, "name" => name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet(fleet_id, signal_catalog_arn)
    create_fleet(fleet_id, signal_catalog_arn, params::Dict{String,<:Any})

 Creates a fleet that represents a group of vehicles.   You must create both a signal
catalog and vehicles before you can create a fleet.   For more information, see Fleets in
the Amazon Web Services IoT FleetWise Developer Guide.

# Arguments
- `fleet_id`:  The unique ID of the fleet to create.
- `signal_catalog_arn`:  The Amazon Resource Name (ARN) of a signal catalog.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the fleet to create.
- `"tags"`: Metadata that can be used to manage the fleet.
"""
function create_fleet(
    fleetId, signalCatalogArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "CreateFleet",
        Dict{String,Any}("fleetId" => fleetId, "signalCatalogArn" => signalCatalogArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet(
    fleetId,
    signalCatalogArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "fleetId" => fleetId, "signalCatalogArn" => signalCatalogArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_model_manifest(name, nodes, signal_catalog_arn)
    create_model_manifest(name, nodes, signal_catalog_arn, params::Dict{String,<:Any})

 Creates a vehicle model (model manifest) that specifies signals (attributes, branches,
sensors, and actuators).  For more information, see Vehicle models in the Amazon Web
Services IoT FleetWise Developer Guide.

# Arguments
- `name`:  The name of the vehicle model to create.
- `nodes`:  A list of nodes, which are a general abstraction of signals.
- `signal_catalog_arn`:  The Amazon Resource Name (ARN) of a signal catalog.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the vehicle model.
- `"tags"`: Metadata that can be used to manage the vehicle model.
"""
function create_model_manifest(
    name, nodes, signalCatalogArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "CreateModelManifest",
        Dict{String,Any}(
            "name" => name, "nodes" => nodes, "signalCatalogArn" => signalCatalogArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_model_manifest(
    name,
    nodes,
    signalCatalogArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateModelManifest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "nodes" => nodes, "signalCatalogArn" => signalCatalogArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_signal_catalog(name)
    create_signal_catalog(name, params::Dict{String,<:Any})

 Creates a collection of standardized signals that can be reused to create vehicle models.

# Arguments
- `name`:  The name of the signal catalog to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A brief description of the signal catalog.
- `"nodes"`:  A list of information about nodes, which are a general abstraction of
  signals. For more information, see the API data type.
- `"tags"`: Metadata that can be used to manage the signal catalog.
"""
function create_signal_catalog(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "CreateSignalCatalog",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_signal_catalog(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "CreateSignalCatalog",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vehicle(decoder_manifest_arn, model_manifest_arn, vehicle_name)
    create_vehicle(decoder_manifest_arn, model_manifest_arn, vehicle_name, params::Dict{String,<:Any})

 Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles
created from the same vehicle model consist of the same signals inherited from the vehicle
model.   If you have an existing Amazon Web Services IoT thing, you can use Amazon Web
Services IoT FleetWise to create a vehicle and collect data from your thing.   For more
information, see Create a vehicle (AWS CLI) in the Amazon Web Services IoT FleetWise
Developer Guide.

# Arguments
- `decoder_manifest_arn`:  The ARN of a decoder manifest.
- `model_manifest_arn`:  The Amazon Resource Name ARN of a vehicle model.
- `vehicle_name`:  The unique ID of the vehicle to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"associationBehavior"`:  An option to create a new Amazon Web Services IoT thing when
  creating a vehicle, or to validate an existing Amazon Web Services IoT thing as a vehicle.
  Default:
- `"attributes"`: Static information about a vehicle in a key-value pair. For example:
  \"engineType\" : \"1.3 L R2\"  A campaign must include the keys (attribute names) in
  dataExtraDimensions for them to display in Amazon Timestream.
- `"tags"`: Metadata that can be used to manage the vehicle.
"""
function create_vehicle(
    decoderManifestArn,
    modelManifestArn,
    vehicleName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateVehicle",
        Dict{String,Any}(
            "decoderManifestArn" => decoderManifestArn,
            "modelManifestArn" => modelManifestArn,
            "vehicleName" => vehicleName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vehicle(
    decoderManifestArn,
    modelManifestArn,
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "CreateVehicle",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "decoderManifestArn" => decoderManifestArn,
                    "modelManifestArn" => modelManifestArn,
                    "vehicleName" => vehicleName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_campaign(name)
    delete_campaign(name, params::Dict{String,<:Any})

 Deletes a data collection campaign. Deleting a campaign suspends all data collection and
removes it from any vehicles.

# Arguments
- `name`:  The name of the campaign to delete.

"""
function delete_campaign(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteCampaign",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_campaign(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "DeleteCampaign",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_decoder_manifest(name)
    delete_decoder_manifest(name, params::Dict{String,<:Any})

 Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles
associated with it.   If the decoder manifest is successfully deleted, Amazon Web Services
IoT FleetWise sends back an HTTP 200 response with an empty body.

# Arguments
- `name`:  The name of the decoder manifest to delete.

"""
function delete_decoder_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteDecoderManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_decoder_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "DeleteDecoderManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleet(fleet_id)
    delete_fleet(fleet_id, params::Dict{String,<:Any})

 Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the
fleet. For more information, see Delete a fleet (AWS CLI) in the Amazon Web Services IoT
FleetWise Developer Guide.  If the fleet is successfully deleted, Amazon Web Services IoT
FleetWise sends back an HTTP 200 response with an empty body.

# Arguments
- `fleet_id`:  The ID of the fleet to delete.

"""
function delete_fleet(fleetId; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteFleet",
        Dict{String,Any}("fleetId" => fleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleet(
    fleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "DeleteFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleetId" => fleetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_model_manifest(name)
    delete_model_manifest(name, params::Dict{String,<:Any})

 Deletes a vehicle model (model manifest).  If the vehicle model is successfully deleted,
Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.

# Arguments
- `name`:  The name of the model manifest to delete.

"""
function delete_model_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteModelManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_model_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "DeleteModelManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_signal_catalog(name)
    delete_signal_catalog(name, params::Dict{String,<:Any})

 Deletes a signal catalog.   If the signal catalog is successfully deleted, Amazon Web
Services IoT FleetWise sends back an HTTP 200 response with an empty body.

# Arguments
- `name`:  The name of the signal catalog to delete.

"""
function delete_signal_catalog(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteSignalCatalog",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_signal_catalog(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "DeleteSignalCatalog",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vehicle(vehicle_name)
    delete_vehicle(vehicle_name, params::Dict{String,<:Any})

 Deletes a vehicle and removes it from any campaigns.  If the vehicle is successfully
deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty
body.

# Arguments
- `vehicle_name`: The ID of the vehicle to delete.

"""
function delete_vehicle(vehicleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "DeleteVehicle",
        Dict{String,Any}("vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vehicle(
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "DeleteVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicleName" => vehicleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_vehicle_fleet(fleet_id, vehicle_name)
    disassociate_vehicle_fleet(fleet_id, vehicle_name, params::Dict{String,<:Any})

Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet
doesn't delete the vehicle.  If the vehicle is successfully dissociated from a fleet,
Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.

# Arguments
- `fleet_id`:  The unique ID of a fleet.
- `vehicle_name`:  The unique ID of the vehicle to disassociate from the fleet.

"""
function disassociate_vehicle_fleet(
    fleetId, vehicleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "DisassociateVehicleFleet",
        Dict{String,Any}("fleetId" => fleetId, "vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_vehicle_fleet(
    fleetId,
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "DisassociateVehicleFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("fleetId" => fleetId, "vehicleName" => vehicleName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign(name)
    get_campaign(name, params::Dict{String,<:Any})

 Retrieves information about a campaign.

# Arguments
- `name`:  The name of the campaign to retrieve information about.

"""
function get_campaign(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetCampaign",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetCampaign",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_decoder_manifest(name)
    get_decoder_manifest(name, params::Dict{String,<:Any})

 Retrieves information about a created decoder manifest.

# Arguments
- `name`:  The name of the decoder manifest to retrieve information about.

"""
function get_decoder_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetDecoderManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_decoder_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetDecoderManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_encryption_configuration()
    get_encryption_configuration(params::Dict{String,<:Any})

Retrieves the encryption configuration for resources and data in Amazon Web Services IoT
FleetWise.

"""
function get_encryption_configuration(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetEncryptionConfiguration"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_encryption_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetEncryptionConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_fleet(fleet_id)
    get_fleet(fleet_id, params::Dict{String,<:Any})

 Retrieves information about a fleet.

# Arguments
- `fleet_id`:  The ID of the fleet to retrieve information about.

"""
function get_fleet(fleetId; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetFleet",
        Dict{String,Any}("fleetId" => fleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_fleet(
    fleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "GetFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleetId" => fleetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_logging_options()
    get_logging_options(params::Dict{String,<:Any})

Retrieves the logging options.

"""
function get_logging_options(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetLoggingOptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_logging_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetLoggingOptions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_model_manifest(name)
    get_model_manifest(name, params::Dict{String,<:Any})

 Retrieves information about a vehicle model (model manifest).

# Arguments
- `name`:  The name of the vehicle model to retrieve information about.

"""
function get_model_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetModelManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_model_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetModelManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_register_account_status()
    get_register_account_status(params::Dict{String,<:Any})

 Retrieves information about the status of registering your Amazon Web Services account,
IAM, and Amazon Timestream resources so that Amazon Web Services IoT FleetWise can transfer
your vehicle data to the Amazon Web Services Cloud.  For more information, including
step-by-step procedures, see Setting up Amazon Web Services IoT FleetWise.   This API
operation doesn't require input parameters.

"""
function get_register_account_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetRegisterAccountStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_register_account_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetRegisterAccountStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_signal_catalog(name)
    get_signal_catalog(name, params::Dict{String,<:Any})

 Retrieves information about a signal catalog.

# Arguments
- `name`:  The name of the signal catalog to retrieve information about.

"""
function get_signal_catalog(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetSignalCatalog",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_signal_catalog(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "GetSignalCatalog",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_vehicle(vehicle_name)
    get_vehicle(vehicle_name, params::Dict{String,<:Any})

 Retrieves information about a vehicle.

# Arguments
- `vehicle_name`:  The ID of the vehicle to retrieve information about.

"""
function get_vehicle(vehicleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetVehicle",
        Dict{String,Any}("vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_vehicle(
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "GetVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicleName" => vehicleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_vehicle_status(vehicle_name)
    get_vehicle_status(vehicle_name, params::Dict{String,<:Any})

 Retrieves information about the status of a vehicle with any associated campaigns.

# Arguments
- `vehicle_name`:  The ID of the vehicle to retrieve information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function get_vehicle_status(vehicleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "GetVehicleStatus",
        Dict{String,Any}("vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_vehicle_status(
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "GetVehicleStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicleName" => vehicleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_decoder_manifest(name, network_file_definitions)
    import_decoder_manifest(name, network_file_definitions, params::Dict{String,<:Any})

 Creates a decoder manifest using your existing CAN DBC file from your local device.

# Arguments
- `name`:  The name of the decoder manifest to import.
- `network_file_definitions`:  The file to load into an Amazon Web Services account.

"""
function import_decoder_manifest(
    name, networkFileDefinitions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ImportDecoderManifest",
        Dict{String,Any}(
            "name" => name, "networkFileDefinitions" => networkFileDefinitions
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_decoder_manifest(
    name,
    networkFileDefinitions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "ImportDecoderManifest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "networkFileDefinitions" => networkFileDefinitions
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_signal_catalog(name)
    import_signal_catalog(name, params::Dict{String,<:Any})

 Creates a signal catalog using your existing VSS formatted content from your local device.

# Arguments
- `name`: The name of the signal catalog to import.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the signal catalog.
- `"tags"`: Metadata that can be used to manage the signal catalog.
- `"vss"`: The contents of the Vehicle Signal Specification (VSS) configuration. VSS is a
  precise language used to describe and model signals in vehicle networks.
"""
function import_signal_catalog(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ImportSignalCatalog",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_signal_catalog(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ImportSignalCatalog",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_campaigns()
    list_campaigns(params::Dict{String,<:Any})

 Lists information about created campaigns.   This API operation uses pagination. Specify
the nextToken parameter in the request to return more results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
- `"status"`: Optional parameter to filter the results by the status of each created
  campaign in your account. The status can be one of: CREATING, WAITING_FOR_APPROVAL,
  RUNNING, or SUSPENDED.
"""
function list_campaigns(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListCampaigns"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_campaigns(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListCampaigns", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_decoder_manifest_network_interfaces(name)
    list_decoder_manifest_network_interfaces(name, params::Dict{String,<:Any})

 Lists the network interfaces specified in a decoder manifest.   This API operation uses
pagination. Specify the nextToken parameter in the request to return more results.

# Arguments
- `name`:  The name of the decoder manifest to list information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_decoder_manifest_network_interfaces(
    name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListDecoderManifestNetworkInterfaces",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_decoder_manifest_network_interfaces(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListDecoderManifestNetworkInterfaces",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_decoder_manifest_signals(name)
    list_decoder_manifest_signals(name, params::Dict{String,<:Any})

 A list of information about signal decoders specified in a decoder manifest.   This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Arguments
- `name`:  The name of the decoder manifest to list information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_decoder_manifest_signals(
    name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListDecoderManifestSignals",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_decoder_manifest_signals(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListDecoderManifestSignals",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_decoder_manifests()
    list_decoder_manifests(params::Dict{String,<:Any})

 Lists decoder manifests.   This API operation uses pagination. Specify the nextToken
parameter in the request to return more results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"modelManifestArn"`:  The Amazon Resource Name (ARN) of a vehicle model (model manifest)
  associated with the decoder manifest.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_decoder_manifests(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListDecoderManifests"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_decoder_manifests(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListDecoderManifests",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_fleets()
    list_fleets(params::Dict{String,<:Any})

 Retrieves information for each created fleet in an Amazon Web Services account.   This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_fleets(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListFleets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListFleets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_fleets_for_vehicle(vehicle_name)
    list_fleets_for_vehicle(vehicle_name, params::Dict{String,<:Any})

Retrieves a list of IDs for all fleets that the vehicle is associated with.  This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Arguments
- `vehicle_name`:  The ID of the vehicle to retrieve information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_fleets_for_vehicle(
    vehicleName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListFleetsForVehicle",
        Dict{String,Any}("vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_fleets_for_vehicle(
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "ListFleetsForVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicleName" => vehicleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_model_manifest_nodes(name)
    list_model_manifest_nodes(name, params::Dict{String,<:Any})

 Lists information about nodes specified in a vehicle model (model manifest).   This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Arguments
- `name`:  The name of the vehicle model to list information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_model_manifest_nodes(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListModelManifestNodes",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_model_manifest_nodes(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListModelManifestNodes",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_model_manifests()
    list_model_manifests(params::Dict{String,<:Any})

 Retrieves a list of vehicle models (model manifests).   This API operation uses
pagination. Specify the nextToken parameter in the request to return more results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
- `"signalCatalogArn"`:  The ARN of a signal catalog. If you specify a signal catalog, only
  the vehicle models associated with it are returned.
"""
function list_model_manifests(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListModelManifests"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_model_manifests(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListModelManifests", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_signal_catalog_nodes(name)
    list_signal_catalog_nodes(name, params::Dict{String,<:Any})

 Lists of information about the signals (nodes) specified in a signal catalog.   This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Arguments
- `name`:  The name of the signal catalog to list information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
- `"signalNodeType"`: The type of node in the signal catalog.
"""
function list_signal_catalog_nodes(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListSignalCatalogNodes",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_signal_catalog_nodes(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListSignalCatalogNodes",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_signal_catalogs()
    list_signal_catalogs(params::Dict{String,<:Any})

 Lists all the created signal catalogs in an Amazon Web Services account.  You can use to
list information about each signal (node) specified in a signal catalog.  This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_signal_catalogs(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListSignalCatalogs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_signal_catalogs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListSignalCatalogs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags (metadata) you have assigned to the resource.

# Arguments
- `resource_arn`: The ARN of the resource.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vehicles()
    list_vehicles(params::Dict{String,<:Any})

 Retrieves a list of summaries of created vehicles.   This API operation uses pagination.
Specify the nextToken parameter in the request to return more results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributeNames"`: The fully qualified names of the attributes. For example, the fully
  qualified name of an attribute might be Vehicle.Body.Engine.Type.
- `"attributeValues"`: Static information about a vehicle attribute value in string format.
  For example:  \"1.3 L R2\"
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"modelManifestArn"`:  The Amazon Resource Name (ARN) of a vehicle model (model
  manifest). You can use this optional parameter to list only the vehicles created from a
  certain vehicle model.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_vehicles(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListVehicles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_vehicles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "ListVehicles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_vehicles_in_fleet(fleet_id)
    list_vehicles_in_fleet(fleet_id, params::Dict{String,<:Any})

 Retrieves a list of summaries of all vehicles associated with a fleet.   This API
operation uses pagination. Specify the nextToken parameter in the request to return more
results.

# Arguments
- `fleet_id`:  The ID of a fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of items to return, between 1 and 100, inclusive.
- `"nextToken"`: A pagination token for the next set of results. If the results of a search
  are large, only a portion of the results are returned, and a nextToken pagination token is
  returned in the response. To retrieve the next set of results, reissue the search request
  and include the returned token. When all results have been returned, the response does not
  contain a pagination token value.
"""
function list_vehicles_in_fleet(fleetId; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "ListVehiclesInFleet",
        Dict{String,Any}("fleetId" => fleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_vehicles_in_fleet(
    fleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "ListVehiclesInFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleetId" => fleetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_encryption_configuration(encryption_type)
    put_encryption_configuration(encryption_type, params::Dict{String,<:Any})

Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can
encrypt your data and resources using an Amazon Web Services managed key. Or, you can use a
KMS key that you own and manage. For more information, see Data encryption in the Amazon
Web Services IoT FleetWise Developer Guide.

# Arguments
- `encryption_type`: The type of encryption. Choose KMS_BASED_ENCRYPTION to use a KMS key
  or FLEETWISE_DEFAULT_ENCRYPTION to use an Amazon Web Services managed key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"kmsKeyId"`: The ID of the KMS key that is used for encryption.
"""
function put_encryption_configuration(
    encryptionType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "PutEncryptionConfiguration",
        Dict{String,Any}("encryptionType" => encryptionType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_encryption_configuration(
    encryptionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "PutEncryptionConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("encryptionType" => encryptionType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_logging_options(cloud_watch_log_delivery)
    put_logging_options(cloud_watch_log_delivery, params::Dict{String,<:Any})

Creates or updates the logging option.

# Arguments
- `cloud_watch_log_delivery`: Creates or updates the log delivery option to Amazon
  CloudWatch Logs.

"""
function put_logging_options(
    cloudWatchLogDelivery; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "PutLoggingOptions",
        Dict{String,Any}("cloudWatchLogDelivery" => cloudWatchLogDelivery);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_logging_options(
    cloudWatchLogDelivery,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "PutLoggingOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("cloudWatchLogDelivery" => cloudWatchLogDelivery),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_account()
    register_account(params::Dict{String,<:Any})

 This API operation contains deprecated parameters. Register your account again without the
Timestream resources parameter so that Amazon Web Services IoT FleetWise can remove the
Timestream metadata stored. You should then pass the data destination into the
CreateCampaign API operation. You must delete any existing campaigns that include an empty
data destination before you register your account again. For more information, see the
DeleteCampaign API operation. If you want to delete the Timestream inline policy from the
service-linked role, such as to mitigate an overly permissive policy, you must first delete
any existing campaigns. Then delete the service-linked role and register your account again
to enable CloudWatch metrics. For more information, see DeleteServiceLinkedRole in the
Identity and Access Management API Reference.  Registers your Amazon Web Services account,
IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your
vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step
procedures, see Setting up Amazon Web Services IoT FleetWise.   An Amazon Web Services
account is not the same thing as a \"user.\" An Amazon Web Services user is an identity
that you create using Identity and Access Management (IAM) and takes the form of either an
IAM user or an IAM role, both with credentials. A single Amazon Web Services account can,
and typically does, contain many users and roles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"iamResources"`: The IAM resource that allows Amazon Web Services IoT FleetWise to send
  data to Amazon Timestream.
- `"timestreamResources"`:
"""
function register_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "RegisterAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function register_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "RegisterAccount", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds to or modifies the tags of the given resource. Tags are metadata which can be used to
manage a resource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tags`: The new or modified tags for the resource.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the given tags (metadata) from the resource.

# Arguments
- `resource_arn`: The ARN of the resource.
- `tag_keys`: A list of the keys of the tags to be removed from the resource.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_campaign(action, name)
    update_campaign(action, name, params::Dict{String,<:Any})

 Updates a campaign.

# Arguments
- `action`:  Specifies how to update a campaign. The action can be one of the following:
  APPROVE - To approve delivering a data collection scheme to vehicles.     SUSPEND - To
  suspend collecting signal data. The campaign is deleted from vehicles and all vehicles in
  the suspended campaign will stop sending data.    RESUME - To reactivate the SUSPEND
  campaign. The campaign is redeployed to all vehicles and the vehicles will resume sending
  data.    UPDATE - To update a campaign.
- `name`:  The name of the campaign to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataExtraDimensions"`:  A list of vehicle attributes to associate with a signal.
  Default: An empty array
- `"description"`: The description of the campaign.
"""
function update_campaign(action, name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateCampaign",
        Dict{String,Any}("action" => action, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_campaign(
    action,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "UpdateCampaign",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("action" => action, "name" => name), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_decoder_manifest(name)
    update_decoder_manifest(name, params::Dict{String,<:Any})

 Updates a decoder manifest. A decoder manifest can only be updated when the status is
DRAFT. Only ACTIVE decoder manifests can be associated with vehicles.

# Arguments
- `name`:  The name of the decoder manifest to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the decoder manifest to update.
- `"networkInterfacesToAdd"`:  A list of information about the network interfaces to add to
  the decoder manifest.
- `"networkInterfacesToRemove"`:  A list of network interfaces to remove from the decoder
  manifest.
- `"networkInterfacesToUpdate"`:  A list of information about the network interfaces to
  update in the decoder manifest.
- `"signalDecodersToAdd"`:  A list of information about decoding additional signals to add
  to the decoder manifest.
- `"signalDecodersToRemove"`:  A list of signal decoders to remove from the decoder
  manifest.
- `"signalDecodersToUpdate"`:  A list of updated information about decoding signals to
  update in the decoder manifest.
- `"status"`:  The state of the decoder manifest. If the status is ACTIVE, the decoder
  manifest can't be edited. If the status is DRAFT, you can edit the decoder manifest.
"""
function update_decoder_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateDecoderManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_decoder_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "UpdateDecoderManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_fleet(fleet_id)
    update_fleet(fleet_id, params::Dict{String,<:Any})

 Updates the description of an existing fleet.   If the fleet is successfully updated,
Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty HTTP body.

# Arguments
- `fleet_id`:  The ID of the fleet to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  An updated description of the fleet.
"""
function update_fleet(fleetId; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateFleet",
        Dict{String,Any}("fleetId" => fleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_fleet(
    fleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "UpdateFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleetId" => fleetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_model_manifest(name)
    update_model_manifest(name, params::Dict{String,<:Any})

 Updates a vehicle model (model manifest). If created vehicles are associated with a
vehicle model, it can't be updated.

# Arguments
- `name`:  The name of the vehicle model to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the vehicle model.
- `"nodesToAdd"`:  A list of fullyQualifiedName of nodes, which are a general abstraction
  of signals, to add to the vehicle model.
- `"nodesToRemove"`:  A list of fullyQualifiedName of nodes, which are a general
  abstraction of signals, to remove from the vehicle model.
- `"status"`:  The state of the vehicle model. If the status is ACTIVE, the vehicle model
  can't be edited. If the status is DRAFT, you can edit the vehicle model.
"""
function update_model_manifest(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateModelManifest",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_model_manifest(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "UpdateModelManifest",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_signal_catalog(name)
    update_signal_catalog(name, params::Dict{String,<:Any})

 Updates a signal catalog.

# Arguments
- `name`:  The name of the signal catalog to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`:  A brief description of the signal catalog to update.
- `"nodesToAdd"`:  A list of information about nodes to add to the signal catalog.
- `"nodesToRemove"`:  A list of fullyQualifiedName of nodes to remove from the signal
  catalog.
- `"nodesToUpdate"`:  A list of information about nodes to update in the signal catalog.
"""
function update_signal_catalog(name; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateSignalCatalog",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_signal_catalog(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return iotfleetwise(
        "UpdateSignalCatalog",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vehicle(vehicle_name)
    update_vehicle(vehicle_name, params::Dict{String,<:Any})

 Updates a vehicle.

# Arguments
- `vehicle_name`: The unique ID of the vehicle to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributeUpdateMode"`: The method the specified attributes will update the existing
  attributes on the vehicle. UseOverwite to replace the vehicle attributes with the specified
  attributes. Or use Merge to combine all attributes. This is required if attributes are
  present in the input.
- `"attributes"`: Static information about a vehicle in a key-value pair. For example:
  \"engineType\" : \"1.3 L R2\"
- `"decoderManifestArn"`: The ARN of the decoder manifest associated with this vehicle.
- `"modelManifestArn"`: The ARN of a vehicle model (model manifest) associated with the
  vehicle.
"""
function update_vehicle(vehicleName; aws_config::AbstractAWSConfig=current_aws_config())
    return iotfleetwise(
        "UpdateVehicle",
        Dict{String,Any}("vehicleName" => vehicleName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vehicle(
    vehicleName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return iotfleetwise(
        "UpdateVehicle",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("vehicleName" => vehicleName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
