# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: kinesis_analytics_v2
using AWS.Compat
using AWS.UUIDs

"""
    add_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option)
    add_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option, params::Dict{String,<:Any})

Adds an Amazon CloudWatch log stream to monitor application configuration errors.

# Arguments
- `application_name`: The Kinesis Data Analytics application name.
- `cloud_watch_logging_option`: Provides the Amazon CloudWatch log stream Amazon Resource
  Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionalToken"`: A value you use to implement strong concurrency for application
  updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get
  the application's current ConditionalToken using DescribeApplication. For better
  concurrency support, use the ConditionalToken parameter instead of
  CurrentApplicationVersionId.
- `"CurrentApplicationVersionId"`: The version ID of the SQL-based Kinesis Data Analytics
  application. You must provide the CurrentApplicationVersionId or the ConditionalToken.You
  can retrieve the application version ID using DescribeApplication. For better concurrency
  support, use the ConditionalToken parameter instead of CurrentApplicationVersionId.
"""
function add_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOption;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CloudWatchLoggingOption" => CloudWatchLoggingOption,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOption,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CloudWatchLoggingOption" => CloudWatchLoggingOption,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_input(application_name, current_application_version_id, input)
    add_application_input(application_name, current_application_version_id, input, params::Dict{String,<:Any})

 Adds a streaming source to your SQL-based Kinesis Data Analytics application.  You can add
a streaming source when you create an application, or you can use this operation to add a
streaming source after you create an application. For more information, see
CreateApplication. Any configuration update, including adding a streaming source using this
operation, results in a new version of the application. You can use the DescribeApplication
operation to find the current application version.

# Arguments
- `application_name`: The name of your existing application to which you want to add the
  streaming source.
- `current_application_version_id`: The current version of your application. You must
  provide the ApplicationVersionID or the ConditionalToken.You can use the
  DescribeApplication operation to find the current application version.
- `input`: The Input to add.

"""
function add_application_input(
    ApplicationName,
    CurrentApplicationVersionId,
    Input;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationInput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "Input" => Input,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_input(
    ApplicationName,
    CurrentApplicationVersionId,
    Input,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationInput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "Input" => Input,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_input_processing_configuration(application_name, current_application_version_id, input_id, input_processing_configuration)
    add_application_input_processing_configuration(application_name, current_application_version_id, input_id, input_processing_configuration, params::Dict{String,<:Any})

Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An
input processor pre-processes records on the input stream before the application's SQL code
executes. Currently, the only input processor available is Amazon Lambda.

# Arguments
- `application_name`: The name of the application to which you want to add the input
  processing configuration.
- `current_application_version_id`: The version of the application to which you want to add
  the input processing configuration. You can use the DescribeApplication operation to get
  the current application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `input_id`: The ID of the input configuration to add the input processing configuration
  to. You can get a list of the input IDs for an application using the DescribeApplication
  operation.
- `input_processing_configuration`: The InputProcessingConfiguration to add to the
  application.

"""
function add_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    InputProcessingConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "InputId" => InputId,
            "InputProcessingConfiguration" => InputProcessingConfiguration,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    InputProcessingConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "InputId" => InputId,
                    "InputProcessingConfiguration" => InputProcessingConfiguration,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_output(application_name, current_application_version_id, output)
    add_application_output(application_name, current_application_version_id, output, params::Dict{String,<:Any})

Adds an external destination to your SQL-based Kinesis Data Analytics application. If you
want Kinesis Data Analytics to deliver data from an in-application stream within your
application to an external destination (such as an Kinesis data stream, a Kinesis Data
Firehose delivery stream, or an Amazon Lambda function), you add the relevant configuration
to your application using this operation. You can configure one or more outputs for your
application. Each output configuration maps an in-application stream and an external
destination.  You can use one of the output configurations to deliver data from your
in-application error stream to an external destination so that you can analyze the errors.
 Any configuration update, including adding a streaming source using this operation,
results in a new version of the application. You can use the DescribeApplication operation
to find the current application version.

# Arguments
- `application_name`: The name of the application to which you want to add the output
  configuration.
- `current_application_version_id`: The version of the application to which you want to add
  the output configuration. You can use the DescribeApplication operation to get the current
  application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `output`: An array of objects, each describing one output configuration. In the output
  configuration, you specify the name of an in-application stream, a destination (that is, a
  Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon Lambda
  function), and record the formation to use when writing to the destination.

"""
function add_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    Output;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationOutput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "Output" => Output,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    Output,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationOutput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "Output" => Output,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_reference_data_source(application_name, current_application_version_id, reference_data_source)
    add_application_reference_data_source(application_name, current_application_version_id, reference_data_source, params::Dict{String,<:Any})

Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an
in-application table within your application. In the request, you provide the source (S3
bucket name and object key name), name of the in-application table to create, and the
necessary mapping information that describes how data in an Amazon S3 object maps to
columns in the resulting in-application table.

# Arguments
- `application_name`: The name of an existing application.
- `current_application_version_id`: The version of the application for which you are adding
  the reference data source. You can use the DescribeApplication operation to get the current
  application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned.
- `reference_data_source`: The reference data source can be an object in your Amazon S3
  bucket. Kinesis Data Analytics reads the object and copies the data into the in-application
  table that is created. You provide an S3 bucket, object key name, and the resulting
  in-application table that is created.

"""
function add_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceDataSource;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationReferenceDataSource",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "ReferenceDataSource" => ReferenceDataSource,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceDataSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationReferenceDataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "ReferenceDataSource" => ReferenceDataSource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_application_vpc_configuration(application_name, vpc_configuration)
    add_application_vpc_configuration(application_name, vpc_configuration, params::Dict{String,<:Any})

Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use
VPCs to store and access resources securely. Note the following about VPC configurations
for Managed Service for Apache Flink applications:   VPC configurations are not supported
for SQL applications.   When a VPC is added to a Managed Service for Apache Flink
application, the application can no longer be accessed from the Internet directly. To
enable Internet access to the application, add an Internet gateway to your VPC.

# Arguments
- `application_name`: The name of an existing application.
- `vpc_configuration`: Description of the VPC to add to the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionalToken"`: A value you use to implement strong concurrency for application
  updates. You must provide the ApplicationVersionID or the ConditionalToken. You get the
  application's current ConditionalToken using DescribeApplication. For better concurrency
  support, use the ConditionalToken parameter instead of CurrentApplicationVersionId.
- `"CurrentApplicationVersionId"`: The version of the application to which you want to add
  the VPC configuration. You must provide the CurrentApplicationVersionId or the
  ConditionalToken. You can use the DescribeApplication operation to get the current
  application version. If the version specified is not the current version, the
  ConcurrentModificationException is returned. For better concurrency support, use the
  ConditionalToken parameter instead of CurrentApplicationVersionId.
"""
function add_application_vpc_configuration(
    ApplicationName, VpcConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "AddApplicationVpcConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "VpcConfiguration" => VpcConfiguration
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_application_vpc_configuration(
    ApplicationName,
    VpcConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "AddApplicationVpcConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "VpcConfiguration" => VpcConfiguration,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(application_name, runtime_environment, service_execution_role)
    create_application(application_name, runtime_environment, service_execution_role, params::Dict{String,<:Any})

Creates a Managed Service for Apache Flink application. For information about creating a
Managed Service for Apache Flink application, see Creating an Application.

# Arguments
- `application_name`: The name of your application (for example, sample-app).
- `runtime_environment`: The runtime environment for the application.
- `service_execution_role`: The IAM role used by the application to access Kinesis data
  streams, Kinesis Data Firehose delivery streams, Amazon S3 objects, and other external
  resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationConfiguration"`: Use this parameter to configure the application.
- `"ApplicationDescription"`: A summary description of the application.
- `"ApplicationMode"`: Use the STREAMING mode to create a Managed Service for Apache Flink
  application. To create a Managed Service for Apache Flink Studio notebook, use the
  INTERACTIVE mode.
- `"CloudWatchLoggingOptions"`: Use this parameter to configure an Amazon CloudWatch log
  stream to monitor application configuration errors.
- `"Tags"`: A list of one or more tags to assign to the application. A tag is a key-value
  pair that identifies an application. Note that the maximum number of application tags
  includes system tags. The maximum number of user-defined application tags is 50. For more
  information, see Using Tagging.
"""
function create_application(
    ApplicationName,
    RuntimeEnvironment,
    ServiceExecutionRole;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "CreateApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "RuntimeEnvironment" => RuntimeEnvironment,
            "ServiceExecutionRole" => ServiceExecutionRole,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    ApplicationName,
    RuntimeEnvironment,
    ServiceExecutionRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "CreateApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "RuntimeEnvironment" => RuntimeEnvironment,
                    "ServiceExecutionRole" => ServiceExecutionRole,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application_presigned_url(application_name, url_type)
    create_application_presigned_url(application_name, url_type, params::Dict{String,<:Any})

Creates and returns a URL that you can use to connect to an application's extension. The
IAM role or user used to call this API defines the permissions to access the extension.
After the presigned URL is created, no additional permission is required to access this
URL. IAM authorization policies for this API are also enforced for every HTTP request that
attempts to connect to the extension.  You control the amount of time that the URL will be
valid using the SessionExpirationDurationInSeconds parameter. If you do not provide this
parameter, the returned URL is valid for twelve hours.  The URL that you get from a call to
CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If you first try
to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden
error.

# Arguments
- `application_name`: The name of the application.
- `url_type`: The type of the extension for which to create and return a URL. Currently,
  the only valid extension URL type is FLINK_DASHBOARD_URL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SessionExpirationDurationInSeconds"`: The duration in seconds for which the returned
  URL will be valid.
"""
function create_application_presigned_url(
    ApplicationName, UrlType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "CreateApplicationPresignedUrl",
        Dict{String,Any}("ApplicationName" => ApplicationName, "UrlType" => UrlType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application_presigned_url(
    ApplicationName,
    UrlType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "CreateApplicationPresignedUrl",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName, "UrlType" => UrlType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application_snapshot(application_name, snapshot_name)
    create_application_snapshot(application_name, snapshot_name, params::Dict{String,<:Any})

Creates a snapshot of the application's state data.

# Arguments
- `application_name`: The name of an existing application
- `snapshot_name`: An identifier for the application snapshot.

"""
function create_application_snapshot(
    ApplicationName, SnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "CreateApplicationSnapshot",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "SnapshotName" => SnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application_snapshot(
    ApplicationName,
    SnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "CreateApplicationSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName, "SnapshotName" => SnapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_name, create_timestamp)
    delete_application(application_name, create_timestamp, params::Dict{String,<:Any})

Deletes the specified application. Managed Service for Apache Flink halts application
execution and deletes the application.

# Arguments
- `application_name`: The name of the application to delete.
- `create_timestamp`: Use the DescribeApplication operation to get this value.

"""
function delete_application(
    ApplicationName, CreateTimestamp; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "DeleteApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "CreateTimestamp" => CreateTimestamp
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    ApplicationName,
    CreateTimestamp,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CreateTimestamp" => CreateTimestamp,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option_id)
    delete_application_cloud_watch_logging_option(application_name, cloud_watch_logging_option_id, params::Dict{String,<:Any})

Deletes an Amazon CloudWatch log stream from an SQL-based Kinesis Data Analytics
application.

# Arguments
- `application_name`: The application name.
- `cloud_watch_logging_option_id`: The CloudWatchLoggingOptionId of the Amazon CloudWatch
  logging option to delete. You can get the CloudWatchLoggingOptionId by using the
  DescribeApplication operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionalToken"`: A value you use to implement strong concurrency for application
  updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get
  the application's current ConditionalToken using DescribeApplication. For better
  concurrency support, use the ConditionalToken parameter instead of
  CurrentApplicationVersionId.
- `"CurrentApplicationVersionId"`: The version ID of the application. You must provide the
  CurrentApplicationVersionId or the ConditionalToken. You can retrieve the application
  version ID using DescribeApplication. For better concurrency support, use the
  ConditionalToken parameter instead of CurrentApplicationVersionId.
"""
function delete_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOptionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CloudWatchLoggingOptionId" => CloudWatchLoggingOptionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_cloud_watch_logging_option(
    ApplicationName,
    CloudWatchLoggingOptionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationCloudWatchLoggingOption",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CloudWatchLoggingOptionId" => CloudWatchLoggingOptionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_input_processing_configuration(application_name, current_application_version_id, input_id)
    delete_application_input_processing_configuration(application_name, current_application_version_id, input_id, params::Dict{String,<:Any})

Deletes an InputProcessingConfiguration from an input.

# Arguments
- `application_name`: The name of the application.
- `current_application_version_id`: The application version. You can use the
  DescribeApplication operation to get the current application version. If the version
  specified is not the current version, the ConcurrentModificationException is returned.
- `input_id`: The ID of the input configuration from which to delete the input processing
  configuration. You can get a list of the input IDs for an application by using the
  DescribeApplication operation.

"""
function delete_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "InputId" => InputId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_input_processing_configuration(
    ApplicationName,
    CurrentApplicationVersionId,
    InputId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationInputProcessingConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "InputId" => InputId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_output(application_name, current_application_version_id, output_id)
    delete_application_output(application_name, current_application_version_id, output_id, params::Dict{String,<:Any})

Deletes the output destination configuration from your SQL-based Kinesis Data Analytics
application's configuration. Kinesis Data Analytics will no longer write data from the
corresponding in-application stream to the external output destination.

# Arguments
- `application_name`: The application name.
- `current_application_version_id`: The application version. You can use the
  DescribeApplication operation to get the current application version. If the version
  specified is not the current version, the ConcurrentModificationException is returned.
- `output_id`: The ID of the configuration to delete. Each output configuration that is
  added to the application (either when the application is created or later) using the
  AddApplicationOutput operation has a unique ID. You need to provide the ID to uniquely
  identify the output configuration that you want to delete from the application
  configuration. You can use the DescribeApplication operation to get the specific OutputId.

"""
function delete_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    OutputId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationOutput",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "OutputId" => OutputId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_output(
    ApplicationName,
    CurrentApplicationVersionId,
    OutputId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationOutput",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "OutputId" => OutputId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_reference_data_source(application_name, current_application_version_id, reference_id)
    delete_application_reference_data_source(application_name, current_application_version_id, reference_id, params::Dict{String,<:Any})

Deletes a reference data source configuration from the specified SQL-based Kinesis Data
Analytics application's configuration. If the application is running, Kinesis Data
Analytics immediately removes the in-application table that you created using the
AddApplicationReferenceDataSource operation.

# Arguments
- `application_name`: The name of an existing application.
- `current_application_version_id`: The current application version. You can use the
  DescribeApplication operation to get the current application version. If the version
  specified is not the current version, the ConcurrentModificationException is returned.
- `reference_id`: The ID of the reference data source. When you add a reference data source
  to your application using the AddApplicationReferenceDataSource, Kinesis Data Analytics
  assigns an ID. You can use the DescribeApplication operation to get the reference ID.

"""
function delete_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationReferenceDataSource",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
            "ReferenceId" => ReferenceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_reference_data_source(
    ApplicationName,
    CurrentApplicationVersionId,
    ReferenceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationReferenceDataSource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                    "ReferenceId" => ReferenceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_snapshot(application_name, snapshot_creation_timestamp, snapshot_name)
    delete_application_snapshot(application_name, snapshot_creation_timestamp, snapshot_name, params::Dict{String,<:Any})

Deletes a snapshot of application state.

# Arguments
- `application_name`: The name of an existing application.
- `snapshot_creation_timestamp`: The creation timestamp of the application snapshot to
  delete. You can retrieve this value using or .
- `snapshot_name`: The identifier for the snapshot delete.

"""
function delete_application_snapshot(
    ApplicationName,
    SnapshotCreationTimestamp,
    SnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationSnapshot",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "SnapshotCreationTimestamp" => SnapshotCreationTimestamp,
            "SnapshotName" => SnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_snapshot(
    ApplicationName,
    SnapshotCreationTimestamp,
    SnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "SnapshotCreationTimestamp" => SnapshotCreationTimestamp,
                    "SnapshotName" => SnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application_vpc_configuration(application_name, vpc_configuration_id)
    delete_application_vpc_configuration(application_name, vpc_configuration_id, params::Dict{String,<:Any})

Removes a VPC configuration from a Managed Service for Apache Flink application.

# Arguments
- `application_name`: The name of an existing application.
- `vpc_configuration_id`: The ID of the VPC configuration to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionalToken"`: A value you use to implement strong concurrency for application
  updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get
  the application's current ConditionalToken using DescribeApplication. For better
  concurrency support, use the ConditionalToken parameter instead of
  CurrentApplicationVersionId.
- `"CurrentApplicationVersionId"`: The current application version ID. You must provide the
  CurrentApplicationVersionId or the ConditionalToken. You can retrieve the application
  version ID using DescribeApplication. For better concurrency support, use the
  ConditionalToken parameter instead of CurrentApplicationVersionId.
"""
function delete_application_vpc_configuration(
    ApplicationName, VpcConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "DeleteApplicationVpcConfiguration",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "VpcConfigurationId" => VpcConfigurationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application_vpc_configuration(
    ApplicationName,
    VpcConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DeleteApplicationVpcConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "VpcConfigurationId" => VpcConfigurationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application(application_name)
    describe_application(application_name, params::Dict{String,<:Any})

Returns information about a specific Managed Service for Apache Flink application. If you
want to retrieve a list of all applications in your account, use the ListApplications
operation.

# Arguments
- `application_name`: The name of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IncludeAdditionalDetails"`: Displays verbose information about a Managed Service for
  Apache Flink application, including the application's job plan.
"""
function describe_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "DescribeApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DescribeApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application_snapshot(application_name, snapshot_name)
    describe_application_snapshot(application_name, snapshot_name, params::Dict{String,<:Any})

Returns information about a snapshot of application state data.

# Arguments
- `application_name`: The name of an existing application.
- `snapshot_name`: The identifier of an application snapshot. You can retrieve this value
  using .

"""
function describe_application_snapshot(
    ApplicationName, SnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "DescribeApplicationSnapshot",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName, "SnapshotName" => SnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_snapshot(
    ApplicationName,
    SnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DescribeApplicationSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName, "SnapshotName" => SnapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application_version(application_name, application_version_id)
    describe_application_version(application_name, application_version_id, params::Dict{String,<:Any})

Provides a detailed description of a specified version of the application. To see a list of
all the versions of an application, invoke the ListApplicationVersions operation.  This
operation is supported only for Managed Service for Apache Flink.

# Arguments
- `application_name`: The name of the application for which you want to get the version
  description.
- `application_version_id`: The ID of the application version for which you want to get the
  description.

"""
function describe_application_version(
    ApplicationName,
    ApplicationVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DescribeApplicationVersion",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "ApplicationVersionId" => ApplicationVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_version(
    ApplicationName,
    ApplicationVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DescribeApplicationVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "ApplicationVersionId" => ApplicationVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    discover_input_schema(service_execution_role)
    discover_input_schema(service_execution_role, params::Dict{String,<:Any})

Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample
records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose
delivery stream) or Amazon S3 object. In the response, the operation returns the inferred
schema and also the sample records that the operation used to infer the schema.  You can
use the inferred schema when configuring a streaming source for your application. When you
create an application using the Kinesis Data Analytics console, the console uses this
operation to infer a schema and show it in the console user interface.

# Arguments
- `service_execution_role`: The ARN of the role that is used to access the streaming source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InputProcessingConfiguration"`: The InputProcessingConfiguration to use to preprocess
  the records before discovering the schema of the records.
- `"InputStartingPositionConfiguration"`: The point at which you want Kinesis Data
  Analytics to start reading records from the specified streaming source for discovery
  purposes.
- `"ResourceARN"`: The Amazon Resource Name (ARN) of the streaming source.
- `"S3Configuration"`: Specify this parameter to discover a schema from data in an Amazon
  S3 object.
"""
function discover_input_schema(
    ServiceExecutionRole; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "DiscoverInputSchema",
        Dict{String,Any}("ServiceExecutionRole" => ServiceExecutionRole);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function discover_input_schema(
    ServiceExecutionRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "DiscoverInputSchema",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServiceExecutionRole" => ServiceExecutionRole),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_snapshots(application_name)
    list_application_snapshots(application_name, params::Dict{String,<:Any})

Lists information about the current application snapshots.

# Arguments
- `application_name`: The name of an existing application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of application snapshots to list.
- `"NextToken"`: Use this parameter if you receive a NextToken response in a previous
  request that indicates that there is more output available. Set it to the value of the
  previous call's NextToken response to indicate where the output should continue from.
"""
function list_application_snapshots(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "ListApplicationSnapshots",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_snapshots(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "ListApplicationSnapshots",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_versions(application_name)
    list_application_versions(application_name, params::Dict{String,<:Any})

Lists all the versions for the specified application, including versions that were rolled
back. The response also includes a summary of the configuration associated with each
version. To get the complete description of a specific application version, invoke the
DescribeApplicationVersion operation.  This operation is supported only for Managed Service
for Apache Flink.

# Arguments
- `application_name`: The name of the application for which you want to list all versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of versions to list in this invocation of the operation.
- `"NextToken"`: If a previous invocation of this operation returned a pagination token,
  pass it into this value to retrieve the next set of results. For more information about
  pagination, see Using the Amazon Command Line Interface's Pagination Options.
"""
function list_application_versions(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "ListApplicationVersions",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_versions(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "ListApplicationVersions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Returns a list of Managed Service for Apache Flink applications in your account. For each
application, the response includes the application name, Amazon Resource Name (ARN), and
status.  If you want detailed information about a specific application, use
DescribeApplication.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of applications to list.
- `"NextToken"`: If a previous command returned a pagination token, pass it into this value
  to retrieve the next set of results. For more information about pagination, see Using the
  Amazon Command Line Interface's Pagination Options.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return kinesis_analytics_v2(
        "ListApplications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "ListApplications", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the list of key-value tags assigned to the application. For more information, see
Using Tagging.

# Arguments
- `resource_arn`: The ARN of the application for which to retrieve tags.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    rollback_application(application_name, current_application_version_id)
    rollback_application(application_name, current_application_version_id, params::Dict{String,<:Any})

Reverts the application to the previous running version. You can roll back an application
if you suspect it is stuck in a transient status.  You can roll back an application only if
it is in the UPDATING or AUTOSCALING status. When you rollback an application, it loads
state data from the last successful snapshot. If the application has no snapshots, Managed
Service for Apache Flink rejects the rollback request. This action is not supported for
Managed Service for Apache Flink for SQL applications.

# Arguments
- `application_name`: The name of the application.
- `current_application_version_id`: The current application version ID. You can retrieve
  the application version ID using DescribeApplication.

"""
function rollback_application(
    ApplicationName,
    CurrentApplicationVersionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "RollbackApplication",
        Dict{String,Any}(
            "ApplicationName" => ApplicationName,
            "CurrentApplicationVersionId" => CurrentApplicationVersionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function rollback_application(
    ApplicationName,
    CurrentApplicationVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "RollbackApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationName" => ApplicationName,
                    "CurrentApplicationVersionId" => CurrentApplicationVersionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_application(application_name)
    start_application(application_name, params::Dict{String,<:Any})

Starts the specified Managed Service for Apache Flink application. After creating an
application, you must exclusively call this operation to start your application.

# Arguments
- `application_name`: The name of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RunConfiguration"`: Identifies the run configuration (start parameters) of a Managed
  Service for Apache Flink application.
"""
function start_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "StartApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "StartApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_application(application_name)
    stop_application(application_name, params::Dict{String,<:Any})

Stops the application from processing data. You can stop an application only if it is in
the running status, unless you set the Force parameter to true. You can use the
DescribeApplication operation to find the application status.  Managed Service for Apache
Flink takes a snapshot when the application is stopped, unless Force is set to true.

# Arguments
- `application_name`: The name of the running application to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: Set to true to force the application to stop. If you set Force to true,
  Managed Service for Apache Flink stops the application without taking a snapshot.
  Force-stopping your application may lead to data loss or duplication. To prevent data loss
  or duplicate processing of data during application restarts, we recommend you to take
  frequent snapshots of your application.  You can only force stop a Managed Service for
  Apache Flink application. You can't force stop a SQL-based Kinesis Data Analytics
  application. The application must be in the STARTING, UPDATING, STOPPING, AUTOSCALING, or
  RUNNING status.
"""
function stop_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "StopApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "StopApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more key-value tags to a Managed Service for Apache Flink application. Note
that the maximum number of application tags includes system tags. The maximum number of
user-defined application tags is 50. For more information, see Using Tagging.

# Arguments
- `resource_arn`: The ARN of the application to assign the tags.
- `tags`: The key-value tags to assign to the application.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return kinesis_analytics_v2(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from a Managed Service for Apache Flink application. For more
information, see Using Tagging.

# Arguments
- `resource_arn`: The ARN of the Managed Service for Apache Flink application from which to
  remove the tags.
- `tag_keys`: A list of keys of tags to remove from the specified application.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_name)
    update_application(application_name, params::Dict{String,<:Any})

Updates an existing Managed Service for Apache Flink application. Using this operation, you
can update application code, input configuration, and output configuration.  Managed
Service for Apache Flink updates the ApplicationVersionId each time you update your
application.

# Arguments
- `application_name`: The name of the application to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationConfigurationUpdate"`: Describes application configuration updates.
- `"CloudWatchLoggingOptionUpdates"`: Describes application Amazon CloudWatch logging
  option updates. You can only update existing CloudWatch logging options with this action.
  To add a new CloudWatch logging option, use AddApplicationCloudWatchLoggingOption.
- `"ConditionalToken"`: A value you use to implement strong concurrency for application
  updates. You must provide the CurrentApplicationVersionId or the ConditionalToken. You get
  the application's current ConditionalToken using DescribeApplication. For better
  concurrency support, use the ConditionalToken parameter instead of
  CurrentApplicationVersionId.
- `"CurrentApplicationVersionId"`: The current application version ID. You must provide the
  CurrentApplicationVersionId or the ConditionalToken.You can retrieve the application
  version ID using DescribeApplication. For better concurrency support, use the
  ConditionalToken parameter instead of CurrentApplicationVersionId.
- `"RunConfigurationUpdate"`: Describes updates to the application's starting parameters.
- `"RuntimeEnvironmentUpdate"`: Updates the Managed Service for Apache Flink runtime
  environment used to run your code. To avoid issues you must:   Ensure your new jar and
  dependencies are compatible with the new runtime selected.   Ensure your new code's state
  is compatible with the snapshot from which your application will start
- `"ServiceExecutionRoleUpdate"`: Describes updates to the service execution role.
"""
function update_application(
    ApplicationName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kinesis_analytics_v2(
        "UpdateApplication",
        Dict{String,Any}("ApplicationName" => ApplicationName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "UpdateApplication",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ApplicationName" => ApplicationName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application_maintenance_configuration(application_maintenance_configuration_update, application_name)
    update_application_maintenance_configuration(application_maintenance_configuration_update, application_name, params::Dict{String,<:Any})

Updates the maintenance configuration of the Managed Service for Apache Flink application.
You can invoke this operation on an application that is in one of the two following states:
READY or RUNNING. If you invoke it when the application is in a state other than these two
states, it throws a ResourceInUseException. The service makes use of the updated
configuration the next time it schedules maintenance for the application. If you invoke
this operation after the service schedules maintenance, the service will apply the
configuration update the next time it schedules maintenance for the application. This means
that you might not see the maintenance configuration update applied to the maintenance
process that follows a successful invocation of this operation, but to the following
maintenance process instead. To see the current maintenance configuration of your
application, invoke the DescribeApplication operation. For information about application
maintenance, see Managed Service for Apache Flink for Apache Flink Maintenance.  This
operation is supported only for Managed Service for Apache Flink.

# Arguments
- `application_maintenance_configuration_update`: Describes the application maintenance
  configuration update.
- `application_name`: The name of the application for which you want to update the
  maintenance configuration.

"""
function update_application_maintenance_configuration(
    ApplicationMaintenanceConfigurationUpdate,
    ApplicationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "UpdateApplicationMaintenanceConfiguration",
        Dict{String,Any}(
            "ApplicationMaintenanceConfigurationUpdate" =>
                ApplicationMaintenanceConfigurationUpdate,
            "ApplicationName" => ApplicationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application_maintenance_configuration(
    ApplicationMaintenanceConfigurationUpdate,
    ApplicationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kinesis_analytics_v2(
        "UpdateApplicationMaintenanceConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationMaintenanceConfigurationUpdate" =>
                        ApplicationMaintenanceConfigurationUpdate,
                    "ApplicationName" => ApplicationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
