# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: license_manager_linux_subscriptions
using AWS.Compat
using AWS.UUIDs

"""
    get_service_settings()
    get_service_settings(params::Dict{String,<:Any})

Lists the Linux subscriptions service settings.

"""
function get_service_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/GetServiceSettings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/GetServiceSettings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_linux_subscription_instances()
    list_linux_subscription_instances(params::Dict{String,<:Any})

Lists the running Amazon EC2 instances that were discovered with commercial Linux
subscriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of structures that you can use to filter the results to those that
  match one or more sets of key-value pairs that you specify. For example, you can filter by
  the name of AmiID with an optional operator to see subscriptions that match, partially
  match, or don't match a certain Amazon Machine Image (AMI) ID. The valid names for this
  filter are:    AmiID     InstanceID     AccountID     Status     Region     UsageOperation
     ProductCode     InstanceType    The valid Operators for this filter are:    contains
  equals     Notequal
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_linux_subscription_instances(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/ListLinuxSubscriptionInstances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_linux_subscription_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/ListLinuxSubscriptionInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_linux_subscriptions()
    list_linux_subscriptions(params::Dict{String,<:Any})

Lists the Linux subscriptions that have been discovered. If you have linked your
organization, the returned results will include data aggregated across your accounts in
Organizations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An array of structures that you can use to filter the results to those that
  match one or more sets of key-value pairs that you specify. For example, you can filter by
  the name of Subscription with an optional operator to see subscriptions that match,
  partially match, or don't match a certain subscription's name. The valid names for this
  filter are:    Subscription    The valid Operators for this filter are:    contains
  equals     Notequal
- `"MaxResults"`: Maximum number of results to return in a single call.
- `"NextToken"`: Token for the next set of results.
"""
function list_linux_subscriptions(; aws_config::AbstractAWSConfig=current_aws_config())
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/ListLinuxSubscriptions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_linux_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/ListLinuxSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_settings(linux_subscriptions_discovery, linux_subscriptions_discovery_settings)
    update_service_settings(linux_subscriptions_discovery, linux_subscriptions_discovery_settings, params::Dict{String,<:Any})

Updates the service settings for Linux subscriptions.

# Arguments
- `linux_subscriptions_discovery`: Describes if the discovery of Linux subscriptions is
  enabled.
- `linux_subscriptions_discovery_settings`: The settings defined for Linux subscriptions
  discovery. The settings include if Organizations integration has been enabled, and which
  Regions data will be aggregated from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowUpdate"`: Describes if updates are allowed to the service settings for Linux
  subscriptions. If you allow updates, you can aggregate Linux subscription data in more than
  one home Region.
"""
function update_service_settings(
    LinuxSubscriptionsDiscovery,
    LinuxSubscriptionsDiscoverySettings;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/UpdateServiceSettings",
        Dict{String,Any}(
            "LinuxSubscriptionsDiscovery" => LinuxSubscriptionsDiscovery,
            "LinuxSubscriptionsDiscoverySettings" => LinuxSubscriptionsDiscoverySettings,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service_settings(
    LinuxSubscriptionsDiscovery,
    LinuxSubscriptionsDiscoverySettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return license_manager_linux_subscriptions(
        "POST",
        "/subscription/UpdateServiceSettings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LinuxSubscriptionsDiscovery" => LinuxSubscriptionsDiscovery,
                    "LinuxSubscriptionsDiscoverySettings" =>
                        LinuxSubscriptionsDiscoverySettings,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
