# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lightsail
using AWS.Compat
using AWS.UUIDs

"""
    allocate_static_ip(static_ip_name)
    allocate_static_ip(static_ip_name, params::Dict{String,<:Any})

Allocates a static IP address.

# Arguments
- `static_ip_name`: The name of the static IP address.

"""
function allocate_static_ip(
    staticIpName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AllocateStaticIp",
        Dict{String,Any}("staticIpName" => staticIpName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function allocate_static_ip(
    staticIpName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AllocateStaticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("staticIpName" => staticIpName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_certificate_to_distribution(certificate_name, distribution_name)
    attach_certificate_to_distribution(certificate_name, distribution_name, params::Dict{String,<:Any})

Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN)
distribution. After the certificate is attached, your distribution accepts HTTPS traffic
for all of the domains that are associated with the certificate. Use the CreateCertificate
action to create a certificate that you can attach to your distribution.  Only certificates
created in the us-east-1 Amazon Web Services Region can be attached to Lightsail
distributions. Lightsail distributions are global resources that can reference an origin in
any Amazon Web Services Region, and distribute its content globally. However, all
distributions are located in the us-east-1 Region.

# Arguments
- `certificate_name`: The name of the certificate to attach to a distribution. Only
  certificates with a status of ISSUED can be attached to a distribution. Use the
  GetCertificates action to get a list of certificate names that you can specify.  This is
  the name of the certificate resource type and is used only to reference the certificate in
  other API actions. It can be different than the domain name of the certificate. For
  example, your certificate name might be WordPress-Blog-Certificate and the domain name of
  the certificate might be example.com.
- `distribution_name`: The name of the distribution that the certificate will be attached
  to. Use the GetDistributions action to get a list of distribution names that you can
  specify.

"""
function attach_certificate_to_distribution(
    certificateName, distributionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AttachCertificateToDistribution",
        Dict{String,Any}(
            "certificateName" => certificateName, "distributionName" => distributionName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_certificate_to_distribution(
    certificateName,
    distributionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AttachCertificateToDistribution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateName" => certificateName,
                    "distributionName" => distributionName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_disk(disk_name, disk_path, instance_name)
    attach_disk(disk_name, disk_path, instance_name, params::Dict{String,<:Any})

Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to
the instance with the specified disk name. The attach disk operation supports tag-based
access control via resource tags applied to the resource identified by disk name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `disk_name`: The unique Lightsail disk name (my-disk).
- `disk_path`: The disk path to expose to the instance (/dev/xvdf).
- `instance_name`: The name of the Lightsail instance where you want to utilize the storage
  disk.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"autoMounting"`: A Boolean value used to determine the automatic mounting of a storage
  volume to a virtual computer. The default value is False.  This value only applies to
  Lightsail for Research resources.
"""
function attach_disk(
    diskName, diskPath, instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AttachDisk",
        Dict{String,Any}(
            "diskName" => diskName, "diskPath" => diskPath, "instanceName" => instanceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_disk(
    diskName,
    diskPath,
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AttachDisk",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "diskName" => diskName,
                    "diskPath" => diskPath,
                    "instanceName" => instanceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_instances_to_load_balancer(instance_names, load_balancer_name)
    attach_instances_to_load_balancer(instance_names, load_balancer_name, params::Dict{String,<:Any})

Attaches one or more Lightsail instances to a load balancer. After some time, the instances
are attached to the load balancer and the health check status is available. The attach
instances to load balancer operation supports tag-based access control via resource tags
applied to the resource identified by load balancer name. For more information, see the
Lightsail Developer Guide.

# Arguments
- `instance_names`: An array of strings representing the instance name(s) you want to
  attach to your load balancer. An instance must be running before you can attach it to your
  load balancer. There are no additional limits on the number of instances you can attach to
  your load balancer, aside from the limit of Lightsail instances you can create in your
  account (20).
- `load_balancer_name`: The name of the load balancer.

"""
function attach_instances_to_load_balancer(
    instanceNames, loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AttachInstancesToLoadBalancer",
        Dict{String,Any}(
            "instanceNames" => instanceNames, "loadBalancerName" => loadBalancerName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_instances_to_load_balancer(
    instanceNames,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AttachInstancesToLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "instanceNames" => instanceNames, "loadBalancerName" => loadBalancerName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_load_balancer_tls_certificate(certificate_name, load_balancer_name)
    attach_load_balancer_tls_certificate(certificate_name, load_balancer_name, params::Dict{String,<:Any})

Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an
updated, more secure version of Secure Socket Layer (SSL). Once you create and validate
your certificate, you can attach it to your load balancer. You can also use this API to
rotate the certificates on your account. Use the AttachLoadBalancerTlsCertificate action
with the non-attached certificate, and it will replace the existing one and become the
attached certificate. The AttachLoadBalancerTlsCertificate operation supports tag-based
access control via resource tags applied to the resource identified by load balancer name.
For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `certificate_name`: The name of your SSL/TLS certificate.
- `load_balancer_name`: The name of the load balancer to which you want to associate the
  SSL/TLS certificate.

"""
function attach_load_balancer_tls_certificate(
    certificateName, loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AttachLoadBalancerTlsCertificate",
        Dict{String,Any}(
            "certificateName" => certificateName, "loadBalancerName" => loadBalancerName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_load_balancer_tls_certificate(
    certificateName,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AttachLoadBalancerTlsCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateName" => certificateName,
                    "loadBalancerName" => loadBalancerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_static_ip(instance_name, static_ip_name)
    attach_static_ip(instance_name, static_ip_name, params::Dict{String,<:Any})

Attaches a static IP address to a specific Amazon Lightsail instance.

# Arguments
- `instance_name`: The instance name to which you want to attach the static IP address.
- `static_ip_name`: The name of the static IP.

"""
function attach_static_ip(
    instanceName, staticIpName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "AttachStaticIp",
        Dict{String,Any}("instanceName" => instanceName, "staticIpName" => staticIpName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_static_ip(
    instanceName,
    staticIpName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "AttachStaticIp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "instanceName" => instanceName, "staticIpName" => staticIpName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    close_instance_public_ports(instance_name, port_info)
    close_instance_public_ports(instance_name, port_info, params::Dict{String,<:Any})

Closes ports for a specific Amazon Lightsail instance. The CloseInstancePublicPorts action
supports tag-based access control via resource tags applied to the resource identified by
instanceName. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance for which to close ports.
- `port_info`: An object to describe the ports to close for the specified instance.

"""
function close_instance_public_ports(
    instanceName, portInfo; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CloseInstancePublicPorts",
        Dict{String,Any}("instanceName" => instanceName, "portInfo" => portInfo);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function close_instance_public_ports(
    instanceName,
    portInfo,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CloseInstancePublicPorts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceName" => instanceName, "portInfo" => portInfo),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_snapshot(source_region, target_snapshot_name)
    copy_snapshot(source_region, target_snapshot_name, params::Dict{String,<:Any})

Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an
automatic snapshot of an instance or disk as a manual snapshot. This operation can also be
used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web
Services Region to another in Amazon Lightsail. When copying a manual snapshot, be sure to
define the source region, source snapshot name, and target snapshot name parameters. When
copying an automatic snapshot, be sure to define the source region, source resource name,
target snapshot name, and either the restore date or the use latest restorable auto
snapshot parameters.

# Arguments
- `source_region`: The Amazon Web Services Region where the source manual or automatic
  snapshot is located.
- `target_snapshot_name`: The name of the new manual snapshot to be created as a copy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"restoreDate"`: The date of the source automatic snapshot to copy. Use the get auto
  snapshots operation to identify the dates of the available automatic snapshots.
  Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined
  together with the use latest restorable auto snapshot parameter. The restore date and use
  latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter
  only when copying an automatic snapshot as a manual snapshot. For more information, see the
  Amazon Lightsail Developer Guide.
- `"sourceResourceName"`: The name of the source instance or disk from which the source
  automatic snapshot was created. Constraint:   Define this parameter only when copying an
  automatic snapshot as a manual snapshot. For more information, see the Amazon Lightsail
  Developer Guide.
- `"sourceSnapshotName"`: The name of the source manual snapshot to copy. Constraint:
  Define this parameter only when copying a manual snapshot as another manual snapshot.
- `"useLatestRestorableAutoSnapshot"`: A Boolean value to indicate whether to use the
  latest available automatic snapshot of the specified source instance or disk. Constraints:
   This parameter cannot be defined together with the restore date parameter. The use latest
  restorable auto snapshot and restore date parameters are mutually exclusive.   Define this
  parameter only when copying an automatic snapshot as a manual snapshot. For more
  information, see the Amazon Lightsail Developer Guide.
"""
function copy_snapshot(
    sourceRegion, targetSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CopySnapshot",
        Dict{String,Any}(
            "sourceRegion" => sourceRegion, "targetSnapshotName" => targetSnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_snapshot(
    sourceRegion,
    targetSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CopySnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "sourceRegion" => sourceRegion,
                    "targetSnapshotName" => targetSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_bucket(bucket_name, bundle_id)
    create_bucket(bucket_name, bundle_id, params::Dict{String,<:Any})

Creates an Amazon Lightsail bucket. A bucket is a cloud storage resource available in the
Lightsail object storage service. Use buckets to store objects such as data and its
descriptive metadata. For more information about buckets, see Buckets in Amazon Lightsail
in the Amazon Lightsail Developer Guide.

# Arguments
- `bucket_name`: The name for the bucket. For more information about bucket names, see
  Bucket naming rules in Amazon Lightsail in the Amazon Lightsail Developer Guide.
- `bundle_id`: The ID of the bundle to use for the bucket. A bucket bundle specifies the
  monthly cost, storage space, and data transfer quota for a bucket. Use the GetBucketBundles
  action to get a list of bundle IDs that you can specify. Use the UpdateBucketBundle action
  to change the bundle after the bucket is created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enableObjectVersioning"`: A Boolean value that indicates whether to enable versioning
  of objects in the bucket. For more information about versioning, see Enabling and
  suspending object versioning in a bucket in Amazon Lightsail in the Amazon Lightsail
  Developer Guide.
- `"tags"`: The tag keys and optional values to add to the bucket during creation. Use the
  TagResource action to tag the bucket after it's created.
"""
function create_bucket(
    bucketName, bundleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateBucket",
        Dict{String,Any}("bucketName" => bucketName, "bundleId" => bundleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_bucket(
    bucketName,
    bundleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateBucket",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("bucketName" => bucketName, "bundleId" => bundleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_bucket_access_key(bucket_name)
    create_bucket_access_key(bucket_name, params::Dict{String,<:Any})

Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of
an access key ID and corresponding secret access key. Access keys grant full programmatic
access to the specified bucket and its objects. You can have a maximum of two access keys
per bucket. Use the GetBucketAccessKeys action to get a list of current access keys for a
specific bucket. For more information about access keys, see Creating access keys for a
bucket in Amazon Lightsail in the Amazon Lightsail Developer Guide.  The secretAccessKey
value is returned only in response to the CreateBucketAccessKey action. You can get a
secret access key only when you first create an access key; you cannot get the secret
access key later. If you lose the secret access key, you must create a new access key.

# Arguments
- `bucket_name`: The name of the bucket that the new access key will belong to, and grant
  access to.

"""
function create_bucket_access_key(
    bucketName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateBucketAccessKey",
        Dict{String,Any}("bucketName" => bucketName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_bucket_access_key(
    bucketName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateBucketAccessKey",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("bucketName" => bucketName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_certificate(certificate_name, domain_name)
    create_certificate(certificate_name, domain_name, params::Dict{String,<:Any})

Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN)
distribution and a container service. After the certificate is valid, use the
AttachCertificateToDistribution action to use the certificate and its domains with your
distribution. Or use the UpdateContainerService action to use the certificate and its
domains with your container service.  Only certificates created in the us-east-1 Amazon Web
Services Region can be attached to Lightsail distributions. Lightsail distributions are
global resources that can reference an origin in any Amazon Web Services Region, and
distribute its content globally. However, all distributions are located in the us-east-1
Region.

# Arguments
- `certificate_name`: The name for the certificate.
- `domain_name`: The domain name (example.com) for the certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"subjectAlternativeNames"`: An array of strings that specify the alternate domains
  (example2.com) and subdomains (blog.example.com) for the certificate. You can specify a
  maximum of nine alternate domains (in addition to the primary domain name). Wildcard domain
  entries (*.example.com) are not supported.
- `"tags"`: The tag keys and optional values to add to the certificate during create. Use
  the TagResource action to tag a resource after it's created.
"""
function create_certificate(
    certificateName, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateCertificate",
        Dict{String,Any}("certificateName" => certificateName, "domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_certificate(
    certificateName,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateName" => certificateName, "domainName" => domainName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cloud_formation_stack(instances)
    create_cloud_formation_stack(instances, params::Dict{String,<:Any})

Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an
exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record
that can be used to track the AWS CloudFormation stack created. Use the get cloud formation
stack records operation to get a list of the CloudFormation stacks created.  Wait until
after your new Amazon EC2 instance is created before running the create cloud formation
stack operation again with the same export snapshot record.

# Arguments
- `instances`: An array of parameters that will be used to create the new Amazon EC2
  instance. You can only pass one instance entry at a time in this array. You will get an
  invalid parameter error if you pass more than one instance entry in this array.

"""
function create_cloud_formation_stack(
    instances; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateCloudFormationStack",
        Dict{String,Any}("instances" => instances);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cloud_formation_stack(
    instances,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateCloudFormationStack",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instances" => instances), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_contact_method(contact_endpoint, protocol)
    create_contact_method(contact_endpoint, protocol, params::Dict{String,<:Any})

Creates an email or SMS text message contact method. A contact method is used to send you
notifications about your Amazon Lightsail resources. You can add one email address and one
mobile phone number contact method in each Amazon Web Services Region. However, SMS text
messaging is not supported in some Amazon Web Services Regions, and SMS text messages
cannot be sent to some countries/regions. For more information, see Notifications in Amazon
Lightsail.

# Arguments
- `contact_endpoint`: The destination of the contact method, such as an email address or a
  mobile phone number. Use the E.164 format when specifying a mobile phone number. E.164 is a
  standard for the phone number structure used for international telecommunication. Phone
  numbers that follow this format can have a maximum of 15 digits, and they are prefixed with
  the plus character (+) and the country code. For example, a U.S. phone number in E.164
  format would be specified as +1XXX5550100. For more information, see E.164 on Wikipedia.
- `protocol`: The protocol of the contact method, such as Email or SMS (text messaging).
  The SMS protocol is supported only in the following Amazon Web Services Regions.   US East
  (N. Virginia) (us-east-1)   US West (Oregon) (us-west-2)   Europe (Ireland) (eu-west-1)
  Asia Pacific (Tokyo) (ap-northeast-1)   Asia Pacific (Singapore) (ap-southeast-1)   Asia
  Pacific (Sydney) (ap-southeast-2)   For a list of countries/regions where SMS text messages
  can be sent, and the latest Amazon Web Services Regions where SMS text messaging is
  supported, see Supported Regions and Countries in the Amazon SNS Developer Guide. For more
  information about notifications in Amazon Lightsail, see Notifications in Amazon Lightsail.

"""
function create_contact_method(
    contactEndpoint, protocol; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateContactMethod",
        Dict{String,Any}("contactEndpoint" => contactEndpoint, "protocol" => protocol);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_contact_method(
    contactEndpoint,
    protocol,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateContactMethod",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "contactEndpoint" => contactEndpoint, "protocol" => protocol
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_container_service(power, scale, service_name)
    create_container_service(power, scale, service_name, params::Dict{String,<:Any})

Creates an Amazon Lightsail container service. A Lightsail container service is a compute
resource to which you can deploy containers. For more information, see Container services
in Amazon Lightsail in the Lightsail Dev Guide.

# Arguments
- `power`: The power specification for the container service. The power specifies the
  amount of memory, vCPUs, and base monthly cost of each node of the container service. The
  power and scale of a container service makes up its configured capacity. To determine the
  monthly price of your container service, multiply the base price of the power with the
  scale (the number of nodes) of the service. Use the GetContainerServicePowers action to get
  a list of power options that you can specify using this parameter, and their base monthly
  cost.
- `scale`: The scale specification for the container service. The scale specifies the
  allocated compute nodes of the container service. The power and scale of a container
  service makes up its configured capacity. To determine the monthly price of your container
  service, multiply the base price of the power with the scale (the number of nodes) of the
  service.
- `service_name`: The name for the container service. The name that you specify for your
  container service will make up part of its default domain. The default domain of a
  container service is typically
  https://&lt;ServiceName&gt;.&lt;RandomGUID&gt;.&lt;AWSRegion&gt;.cs.amazonlightsail.com. If
  the name of your container service is container-service-1, and it's located in the US East
  (Ohio) Amazon Web Services Region (us-east-2), then the domain for your container service
  will be like the following example:
  https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com  The following
  are the requirements for container service names:   Must be unique within each Amazon Web
  Services Region in your Lightsail account.   Must contain 1 to 63 characters.   Must
  contain only alphanumeric characters and hyphens.   A hyphen (-) can separate words but
  cannot be at the start or end of the name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deployment"`: An object that describes a deployment for the container service. A
  deployment specifies the containers that will be launched on the container service and
  their settings, such as the ports to open, the environment variables to apply, and the
  launch command to run. It also specifies the container that will serve as the public
  endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the
  health check configuration.
- `"privateRegistryAccess"`: An object to describe the configuration for the container
  service to access private container image repositories, such as Amazon Elastic Container
  Registry (Amazon ECR) private repositories. For more information, see Configuring access to
  an Amazon ECR private repository for an Amazon Lightsail container service in the Amazon
  Lightsail Developer Guide.
- `"publicDomainNames"`: The public domain names to use with the container service, such as
  example.com and www.example.com. You can specify up to four public domain names for a
  container service. The domain names that you specify are used when you create a deployment
  with a container configured as the public endpoint of your container service. If you don't
  specify public domain names, then you can use the default domain of the container service.
  You must create and validate an SSL/TLS certificate before you can use public domain names
  with your container service. Use the CreateCertificate action to create a certificate for
  the public domain names you want to use with your container service.  You can specify
  public domain names using a string to array map as shown in the example later on this page.
- `"tags"`: The tag keys and optional values to add to the container service during create.
  Use the TagResource action to tag a resource after it's created. For more information about
  tags in Lightsail, see the Amazon Lightsail Developer Guide.
"""
function create_container_service(
    power, scale, serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateContainerService",
        Dict{String,Any}("power" => power, "scale" => scale, "serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_container_service(
    power,
    scale,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateContainerService",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "power" => power, "scale" => scale, "serviceName" => serviceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_container_service_deployment(service_name)
    create_container_service_deployment(service_name, params::Dict{String,<:Any})

Creates a deployment for your Amazon Lightsail container service. A deployment specifies
the containers that will be launched on the container service and their settings, such as
the ports to open, the environment variables to apply, and the launch command to run. It
also specifies the container that will serve as the public endpoint of the deployment and
its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
You can deploy containers to your container service using container images from a public
registry such as Amazon ECR Public, or from your local machine. For more information, see
Creating container images for your Amazon Lightsail container services in the Amazon
Lightsail Developer Guide.

# Arguments
- `service_name`: The name of the container service for which to create the deployment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"containers"`: An object that describes the settings of the containers that will be
  launched on the container service.
- `"publicEndpoint"`: An object that describes the settings of the public endpoint for the
  container service.
"""
function create_container_service_deployment(
    serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateContainerServiceDeployment",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_container_service_deployment(
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateContainerServiceDeployment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_container_service_registry_login()
    create_container_service_registry_login(params::Dict{String,<:Any})

Creates a temporary set of log in credentials that you can use to log in to the Docker
process on your local machine. After you're logged in, you can use the native Docker
commands to push your local container images to the container image registry of your Amazon
Lightsail account so that you can use them with your Lightsail container service. The log
in credentials expire 12 hours after they are created, at which point you will need to
create a new set of log in credentials.  You can only push container images to the
container service registry of your Lightsail account. You cannot pull container images or
perform any other container image management actions on the container service registry.
After you push your container images to the container image registry of your Lightsail
account, use the RegisterContainerImage action to register the pushed images to a specific
Lightsail container service.  This action is not required if you install and use the
Lightsail Control (lightsailctl) plugin to push container images to your Lightsail
container service. For more information, see Pushing and managing container images on your
Amazon Lightsail container services in the Amazon Lightsail Developer Guide.

"""
function create_container_service_registry_login(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateContainerServiceRegistryLogin";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_container_service_registry_login(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateContainerServiceRegistryLogin",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_disk(availability_zone, disk_name, size_in_gb)
    create_disk(availability_zone, disk_name, size_in_gb, params::Dict{String,<:Any})

Creates a block storage disk that can be attached to an Amazon Lightsail instance in the
same Availability Zone (us-east-2a). The create disk operation supports tag-based access
control via request tags. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `availability_zone`: The Availability Zone where you want to create the disk
  (us-east-2a). Use the same Availability Zone as the Lightsail instance to which you want to
  attach the disk. Use the get regions operation to list the Availability Zones where
  Lightsail is currently available.
- `disk_name`: The unique Lightsail disk name (my-disk).
- `size_in_gb`: The size of the disk in GB (32).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addOns"`: An array of objects that represent the add-ons to enable for the new disk.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_disk(
    availabilityZone, diskName, sizeInGb; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateDisk",
        Dict{String,Any}(
            "availabilityZone" => availabilityZone,
            "diskName" => diskName,
            "sizeInGb" => sizeInGb,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_disk(
    availabilityZone,
    diskName,
    sizeInGb,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDisk",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "availabilityZone" => availabilityZone,
                    "diskName" => diskName,
                    "sizeInGb" => sizeInGb,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_disk_from_snapshot(availability_zone, disk_name, size_in_gb)
    create_disk_from_snapshot(availability_zone, disk_name, size_in_gb, params::Dict{String,<:Any})

Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting
disk can be attached to an Amazon Lightsail instance in the same Availability Zone
(us-east-2a). The create disk from snapshot operation supports tag-based access control via
request tags and resource tags applied to the resource identified by disk snapshot name.
For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `availability_zone`: The Availability Zone where you want to create the disk
  (us-east-2a). Choose the same Availability Zone as the Lightsail instance where you want to
  create the disk. Use the GetRegions operation to list the Availability Zones where
  Lightsail is currently available.
- `disk_name`: The unique Lightsail disk name (my-disk).
- `size_in_gb`: The size of the disk in GB (32).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addOns"`: An array of objects that represent the add-ons to enable for the new disk.
- `"diskSnapshotName"`: The name of the disk snapshot (my-snapshot) from which to create
  the new storage disk. Constraint:   This parameter cannot be defined together with the
  source disk name parameter. The disk snapshot name and source disk name parameters are
  mutually exclusive.
- `"restoreDate"`: The date of the automatic snapshot to use for the new disk. Use the get
  auto snapshots operation to identify the dates of the available automatic snapshots.
  Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined
  together with the use latest restorable auto snapshot parameter. The restore date and use
  latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter
  only when creating a new disk from an automatic snapshot. For more information, see the
  Amazon Lightsail Developer Guide.
- `"sourceDiskName"`: The name of the source disk from which the source automatic snapshot
  was created. Constraints:   This parameter cannot be defined together with the disk
  snapshot name parameter. The source disk name and disk snapshot name parameters are
  mutually exclusive.   Define this parameter only when creating a new disk from an automatic
  snapshot. For more information, see the Amazon Lightsail Developer Guide.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
- `"useLatestRestorableAutoSnapshot"`: A Boolean value to indicate whether to use the
  latest available automatic snapshot. Constraints:   This parameter cannot be defined
  together with the restore date parameter. The use latest restorable auto snapshot and
  restore date parameters are mutually exclusive.   Define this parameter only when creating
  a new disk from an automatic snapshot. For more information, see the Amazon Lightsail
  Developer Guide.
"""
function create_disk_from_snapshot(
    availabilityZone, diskName, sizeInGb; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateDiskFromSnapshot",
        Dict{String,Any}(
            "availabilityZone" => availabilityZone,
            "diskName" => diskName,
            "sizeInGb" => sizeInGb,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_disk_from_snapshot(
    availabilityZone,
    diskName,
    sizeInGb,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDiskFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "availabilityZone" => availabilityZone,
                    "diskName" => diskName,
                    "sizeInGb" => sizeInGb,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_disk_snapshot(disk_snapshot_name)
    create_disk_snapshot(disk_snapshot_name, params::Dict{String,<:Any})

Creates a snapshot of a block storage disk. You can use snapshots for backups, to make
copies of disks, and to save data before shutting down a Lightsail instance. You can take a
snapshot of an attached disk that is in use; however, snapshots only capture data that has
been written to your disk at the time the snapshot command is issued. This may exclude any
data that has been cached by any applications or the operating system. If you can pause any
file systems on the disk long enough to take a snapshot, your snapshot should be complete.
Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk
from within the Lightsail instance, issue the create disk snapshot command, and then
remount the disk to ensure a consistent and complete snapshot. You may remount and use your
disk while the snapshot status is pending. You can also use this operation to create a
snapshot of an instance's system volume. You might want to do this, for example, to recover
data from the system volume of a botched instance or to create a backup of the system
volume like you would for a block storage disk. To create a snapshot of a system volume,
just define the instance name parameter when issuing the snapshot command, and a snapshot
of the defined instance's system volume will be created. After the snapshot is available,
you can create a block storage disk from the snapshot and attach it to a running instance
to access the data on the disk. The create disk snapshot operation supports tag-based
access control via request tags. For more information, see the Amazon Lightsail Developer
Guide.

# Arguments
- `disk_snapshot_name`: The name of the destination disk snapshot (my-disk-snapshot) based
  on the source disk.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"diskName"`: The unique name of the source disk (Disk-Virginia-1).  This parameter
  cannot be defined together with the instance name parameter. The disk name and instance
  name parameters are mutually exclusive.
- `"instanceName"`: The unique name of the source instance (Amazon_Linux-512MB-Virginia-1).
  When this is defined, a snapshot of the instance's system volume is created.  This
  parameter cannot be defined together with the disk name parameter. The instance name and
  disk name parameters are mutually exclusive.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_disk_snapshot(
    diskSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateDiskSnapshot",
        Dict{String,Any}("diskSnapshotName" => diskSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_disk_snapshot(
    diskSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDiskSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("diskSnapshotName" => diskSnapshotName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_distribution(bundle_id, default_cache_behavior, distribution_name, origin)
    create_distribution(bundle_id, default_cache_behavior, distribution_name, origin, params::Dict{String,<:Any})

Creates an Amazon Lightsail content delivery network (CDN) distribution. A distribution is
a globally distributed network of caching servers that improve the performance of your
website or web application hosted on a Lightsail instance. For more information, see
Content delivery networks in Amazon Lightsail.

# Arguments
- `bundle_id`: The bundle ID to use for the distribution. A distribution bundle describes
  the specifications of your distribution, such as the monthly cost and monthly network
  transfer quota. Use the GetDistributionBundles action to get a list of distribution bundle
  IDs that you can specify.
- `default_cache_behavior`: An object that describes the default cache behavior for the
  distribution.
- `distribution_name`: The name for the distribution.
- `origin`: An object that describes the origin resource for the distribution, such as a
  Lightsail instance, bucket, or load balancer. The distribution pulls, caches, and serves
  content from the origin.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cacheBehaviorSettings"`: An object that describes the cache behavior settings for the
  distribution.
- `"cacheBehaviors"`: An array of objects that describe the per-path cache behavior for the
  distribution.
- `"certificateName"`: The name of the SSL/TLS certificate that you want to attach to the
  distribution. Use the GetCertificates action to get a list of certificate names that you
  can specify.
- `"ipAddressType"`: The IP address type for the distribution. The possible values are ipv4
  for IPv4 only, and dualstack for IPv4 and IPv6. The default value is dualstack.
- `"tags"`: The tag keys and optional values to add to the distribution during create. Use
  the TagResource action to tag a resource after it's created.
- `"viewerMinimumTlsProtocolVersion"`: The minimum TLS protocol version for the SSL/TLS
  certificate.
"""
function create_distribution(
    bundleId,
    defaultCacheBehavior,
    distributionName,
    origin;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDistribution",
        Dict{String,Any}(
            "bundleId" => bundleId,
            "defaultCacheBehavior" => defaultCacheBehavior,
            "distributionName" => distributionName,
            "origin" => origin,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_distribution(
    bundleId,
    defaultCacheBehavior,
    distributionName,
    origin,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDistribution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "bundleId" => bundleId,
                    "defaultCacheBehavior" => defaultCacheBehavior,
                    "distributionName" => distributionName,
                    "origin" => origin,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain(domain_name)
    create_domain(domain_name, params::Dict{String,<:Any})

Creates a domain resource for the specified domain (example.com). The create domain
operation supports tag-based access control via request tags. For more information, see the
Amazon Lightsail Developer Guide.

# Arguments
- `domain_name`: The domain name to manage (example.com).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_domain(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "CreateDomain",
        Dict{String,Any}("domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("domainName" => domainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain_entry(domain_entry, domain_name)
    create_domain_entry(domain_entry, domain_name, params::Dict{String,<:Any})

Creates one of the following domain name system (DNS) records in a domain DNS zone: Address
(A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority
(SOA), service locator (SRV), or text (TXT). The create domain entry operation supports
tag-based access control via resource tags applied to the resource identified by domain
name. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `domain_entry`: An array of key-value pairs containing information about the domain entry
  request.
- `domain_name`: The domain name (example.com) for which you want to create the domain
  entry.

"""
function create_domain_entry(
    domainEntry, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateDomainEntry",
        Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain_entry(
    domainEntry,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateDomainEntry",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_guisession_access_details(resource_name)
    create_guisession_access_details(resource_name, params::Dict{String,<:Any})

Creates two URLs that are used to access a virtual computer’s graphical user interface
(GUI) session. The primary URL initiates a web-based NICE DCV session to the virtual
computer's application. The secondary URL initiates a web-based NICE DCV session to the
virtual computer's operating session.  Use StartGUISession to open the session.

# Arguments
- `resource_name`: The resource name.

"""
function create_guisession_access_details(
    resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateGUISessionAccessDetails",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_guisession_access_details(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateGUISessionAccessDetails",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_snapshot(instance_name, instance_snapshot_name)
    create_instance_snapshot(instance_name, instance_snapshot_name, params::Dict{String,<:Any})

Creates a snapshot of a specific virtual private server, or instance. You can use a
snapshot to create a new instance that is based on that snapshot. The create instance
snapshot operation supports tag-based access control via request tags. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The Lightsail instance on which to base your snapshot.
- `instance_snapshot_name`: The name for your new snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_instance_snapshot(
    instanceName, instanceSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateInstanceSnapshot",
        Dict{String,Any}(
            "instanceName" => instanceName, "instanceSnapshotName" => instanceSnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance_snapshot(
    instanceName,
    instanceSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateInstanceSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "instanceName" => instanceName,
                    "instanceSnapshotName" => instanceSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instances(availability_zone, blueprint_id, bundle_id, instance_names)
    create_instances(availability_zone, blueprint_id, bundle_id, instance_names, params::Dict{String,<:Any})

Creates one or more Amazon Lightsail instances. The create instances operation supports
tag-based access control via request tags. For more information, see the Lightsail
Developer Guide.

# Arguments
- `availability_zone`: The Availability Zone in which to create your instance. Use the
  following format: us-east-2a (case sensitive). You can get a list of Availability Zones by
  using the get regions operation. Be sure to add the include Availability Zones parameter to
  your request.
- `blueprint_id`: The ID for a virtual private server image (app_wordpress_x_x or
  app_lamp_x_x). Use the get blueprints operation to return a list of available images (or
  blueprints).  Use active blueprints when creating new instances. Inactive blueprints are
  listed to support customers with existing instances and are not necessarily available to
  create new instances. Blueprints are marked inactive when they become outdated due to
  operating system updates or new application releases.
- `bundle_id`: The bundle of specification information for your virtual private server (or
  instance), including the pricing plan (medium_x_x).
- `instance_names`: The names to use for your new Lightsail instances. Separate multiple
  values using quotation marks and commas, for example:
  [\"MyFirstInstance\",\"MySecondInstance\"]

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addOns"`: An array of objects representing the add-ons to enable for the new instance.
- `"customImageName"`: (Discontinued) The name for your custom image.  In releases prior to
  June 12, 2017, this parameter was ignored by the API. It is now discontinued.
- `"ipAddressType"`: The IP address type for the instance. The possible values are ipv4 for
  IPv4 only, ipv6 for IPv6 only, and dualstack for IPv4 and IPv6. The default value is
  dualstack.
- `"keyPairName"`: The name of your key pair.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
- `"userData"`: A launch script you can create that configures a server with additional
  user data. For example, you might want to run apt-get -y update.  Depending on the machine
  image you choose, the command to get software on your instance varies. Amazon Linux and
  CentOS use yum, Debian and Ubuntu use apt-get, and FreeBSD uses pkg. For a complete list,
  see the Amazon Lightsail Developer Guide.
"""
function create_instances(
    availabilityZone,
    blueprintId,
    bundleId,
    instanceNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateInstances",
        Dict{String,Any}(
            "availabilityZone" => availabilityZone,
            "blueprintId" => blueprintId,
            "bundleId" => bundleId,
            "instanceNames" => instanceNames,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instances(
    availabilityZone,
    blueprintId,
    bundleId,
    instanceNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateInstances",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "availabilityZone" => availabilityZone,
                    "blueprintId" => blueprintId,
                    "bundleId" => bundleId,
                    "instanceNames" => instanceNames,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instances_from_snapshot(availability_zone, bundle_id, instance_names)
    create_instances_from_snapshot(availability_zone, bundle_id, instance_names, params::Dict{String,<:Any})

Creates one or more new instances from a manual or automatic snapshot of an instance. The
create instances from snapshot operation supports tag-based access control via request tags
and resource tags applied to the resource identified by instance snapshot name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `availability_zone`: The Availability Zone where you want to create your instances. Use
  the following formatting: us-east-2a (case sensitive). You can get a list of Availability
  Zones by using the get regions operation. Be sure to add the include Availability Zones
  parameter to your request.
- `bundle_id`: The bundle of specification information for your virtual private server (or
  instance), including the pricing plan (micro_x_x).
- `instance_names`: The names for your new instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"addOns"`: An array of objects representing the add-ons to enable for the new instance.
- `"attachedDiskMapping"`: An object containing information about one or more disk mappings.
- `"instanceSnapshotName"`: The name of the instance snapshot on which you are basing your
  new instances. Use the get instance snapshots operation to return information about your
  existing snapshots. Constraint:   This parameter cannot be defined together with the source
  instance name parameter. The instance snapshot name and source instance name parameters are
  mutually exclusive.
- `"ipAddressType"`: The IP address type for the instance. The possible values are ipv4 for
  IPv4 only, ipv6 for IPv6 only, and dualstack for IPv4 and IPv6. The default value is
  dualstack.
- `"keyPairName"`: The name for your key pair.
- `"restoreDate"`: The date of the automatic snapshot to use for the new instance. Use the
  get auto snapshots operation to identify the dates of the available automatic snapshots.
  Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined
  together with the use latest restorable auto snapshot parameter. The restore date and use
  latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter
  only when creating a new instance from an automatic snapshot. For more information, see the
  Amazon Lightsail Developer Guide.
- `"sourceInstanceName"`: The name of the source instance from which the source automatic
  snapshot was created. Constraints:   This parameter cannot be defined together with the
  instance snapshot name parameter. The source instance name and instance snapshot name
  parameters are mutually exclusive.   Define this parameter only when creating a new
  instance from an automatic snapshot. For more information, see the Amazon Lightsail
  Developer Guide.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
- `"useLatestRestorableAutoSnapshot"`: A Boolean value to indicate whether to use the
  latest available automatic snapshot. Constraints:   This parameter cannot be defined
  together with the restore date parameter. The use latest restorable auto snapshot and
  restore date parameters are mutually exclusive.   Define this parameter only when creating
  a new instance from an automatic snapshot. For more information, see the Amazon Lightsail
  Developer Guide.
- `"userData"`: You can create a launch script that configures a server with additional
  user data. For example, apt-get -y update.  Depending on the machine image you choose, the
  command to get software on your instance varies. Amazon Linux and CentOS use yum, Debian
  and Ubuntu use apt-get, and FreeBSD uses pkg. For a complete list, see the Amazon Lightsail
  Developer Guide.
"""
function create_instances_from_snapshot(
    availabilityZone,
    bundleId,
    instanceNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateInstancesFromSnapshot",
        Dict{String,Any}(
            "availabilityZone" => availabilityZone,
            "bundleId" => bundleId,
            "instanceNames" => instanceNames,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instances_from_snapshot(
    availabilityZone,
    bundleId,
    instanceNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateInstancesFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "availabilityZone" => availabilityZone,
                    "bundleId" => bundleId,
                    "instanceNames" => instanceNames,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_key_pair(key_pair_name)
    create_key_pair(key_pair_name, params::Dict{String,<:Any})

Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.  Use the
DownloadDefaultKeyPair action to create a Lightsail default key pair in an Amazon Web
Services Region where a default key pair does not currently exist.  The create key pair
operation supports tag-based access control via request tags. For more information, see the
Amazon Lightsail Developer Guide.

# Arguments
- `key_pair_name`: The name for your new key pair.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_key_pair(keyPairName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "CreateKeyPair",
        Dict{String,Any}("keyPairName" => keyPairName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_key_pair(
    keyPairName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateKeyPair",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyPairName" => keyPairName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_load_balancer(instance_port, load_balancer_name)
    create_load_balancer(instance_port, load_balancer_name, params::Dict{String,<:Any})

Creates a Lightsail load balancer. To learn more about deciding whether to load balance
your application, see Configure your Lightsail instances for load balancing. You can create
up to 5 load balancers per AWS Region in your account. When you create a load balancer, you
can specify a unique name and port settings. To change additional load balancer settings,
use the UpdateLoadBalancerAttribute operation. The create load balancer operation supports
tag-based access control via request tags. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `instance_port`: The instance port where you're creating your load balancer.
- `load_balancer_name`: The name of your load balancer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"certificateAlternativeNames"`: The optional alternative domains and subdomains to use
  with your SSL/TLS certificate (www.example.com, example.com, m.example.com,
  blog.example.com).
- `"certificateDomainName"`: The domain name with which your certificate is associated
  (example.com). If you specify certificateDomainName, then certificateName is required (and
  vice-versa).
- `"certificateName"`: The name of the SSL/TLS certificate. If you specify certificateName,
  then certificateDomainName is required (and vice-versa).
- `"healthCheckPath"`: The path you provided to perform the load balancer health check. If
  you didn't specify a health check path, Lightsail uses the root path of your website
  (\"/\"). You may want to specify a custom health check path other than the root of your
  application if your home page loads slowly or has a lot of media or scripting on it.
- `"ipAddressType"`: The IP address type for the load balancer. The possible values are
  ipv4 for IPv4 only, ipv6 for IPv6 only, and dualstack for IPv4 and IPv6. The default value
  is dualstack.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
- `"tlsPolicyName"`: The name of the TLS policy to apply to the load balancer. Use the
  GetLoadBalancerTlsPolicies action to get a list of TLS policy names that you can specify.
  For more information about load balancer TLS policies, see Configuring TLS security
  policies on your Amazon Lightsail load balancers in the Amazon Lightsail Developer Guide.
"""
function create_load_balancer(
    instancePort, loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateLoadBalancer",
        Dict{String,Any}(
            "instancePort" => instancePort, "loadBalancerName" => loadBalancerName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_load_balancer(
    instancePort,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "instancePort" => instancePort, "loadBalancerName" => loadBalancerName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_load_balancer_tls_certificate(certificate_domain_name, certificate_name, load_balancer_name)
    create_load_balancer_tls_certificate(certificate_domain_name, certificate_name, load_balancer_name, params::Dict{String,<:Any})

Creates an SSL/TLS certificate for an Amazon Lightsail load balancer. TLS is just an
updated, more secure version of Secure Socket Layer (SSL). The
CreateLoadBalancerTlsCertificate operation supports tag-based access control via resource
tags applied to the resource identified by load balancer name. For more information, see
the Amazon Lightsail Developer Guide.

# Arguments
- `certificate_domain_name`: The domain name (example.com) for your SSL/TLS certificate.
- `certificate_name`: The SSL/TLS certificate name. You can have up to 10 certificates in
  your account at one time. Each Lightsail load balancer can have up to 2 certificates
  associated with it at one time. There is also an overall limit to the number of
  certificates that can be issue in a 365-day period. For more information, see Limits.
- `load_balancer_name`: The load balancer name where you want to create the SSL/TLS
  certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"certificateAlternativeNames"`: An array of strings listing alternative domains and
  subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can
  have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not
  support wildcards (*.example.com).
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_load_balancer_tls_certificate(
    certificateDomainName,
    certificateName,
    loadBalancerName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateLoadBalancerTlsCertificate",
        Dict{String,Any}(
            "certificateDomainName" => certificateDomainName,
            "certificateName" => certificateName,
            "loadBalancerName" => loadBalancerName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_load_balancer_tls_certificate(
    certificateDomainName,
    certificateName,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateLoadBalancerTlsCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateDomainName" => certificateDomainName,
                    "certificateName" => certificateName,
                    "loadBalancerName" => loadBalancerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_relational_database(master_database_name, master_username, relational_database_blueprint_id, relational_database_bundle_id, relational_database_name)
    create_relational_database(master_database_name, master_username, relational_database_blueprint_id, relational_database_bundle_id, relational_database_name, params::Dict{String,<:Any})

Creates a new database in Amazon Lightsail. The create relational database operation
supports tag-based access control via request tags. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `master_database_name`: The meaning of this parameter differs according to the database
  engine you use.  MySQL  The name of the database to create when the Lightsail database
  resource is created. If this parameter isn't specified, no database is created in the
  database resource. Constraints:   Must contain 1 to 64 letters or numbers.   Must begin
  with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).   Can't
  be a word reserved by the specified database engine. For more information about reserved
  words in MySQL, see the Keywords and Reserved Words articles for MySQL 5.6, MySQL 5.7, and
  MySQL 8.0.    PostgreSQL  The name of the database to create when the Lightsail database
  resource is created. If this parameter isn't specified, a database named postgres is
  created in the database resource. Constraints:   Must contain 1 to 63 letters or numbers.
  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-
  9).   Can't be a word reserved by the specified database engine. For more information about
  reserved words in PostgreSQL, see the SQL Key Words articles for PostgreSQL 9.6, PostgreSQL
  10, PostgreSQL 11, and PostgreSQL 12.
- `master_username`: The name for the master user.  MySQL  Constraints:   Required for
  MySQL.   Must be 1 to 16 letters or numbers. Can contain underscores.   First character
  must be a letter.   Can't be a reserved word for the chosen database engine. For more
  information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words
  articles for MySQL 5.6, MySQL 5.7, or MySQL 8.0.    PostgreSQL  Constraints:   Required for
  PostgreSQL.   Must be 1 to 63 letters or numbers. Can contain underscores.   First
  character must be a letter.   Can't be a reserved word for the chosen database engine. For
  more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved
  Words articles for PostgreSQL 9.6, PostgreSQL 10, PostgreSQL 11, and PostgreSQL 12.
- `relational_database_blueprint_id`: The blueprint ID for your new database. A blueprint
  describes the major engine version of a database. You can get a list of database blueprints
  IDs by using the get relational database blueprints operation.
- `relational_database_bundle_id`: The bundle ID for your new database. A bundle describes
  the performance specifications for your database. You can get a list of database bundle IDs
  by using the get relational database bundles operation.
- `relational_database_name`: The name to use for your new Lightsail database resource.
  Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first
  and last character must be a letter or number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"availabilityZone"`: The Availability Zone in which to create your new database. Use the
  us-east-2a case-sensitive format. You can get a list of Availability Zones by using the get
  regions operation. Be sure to add the include relational database Availability Zones
  parameter to your request.
- `"masterUserPassword"`: The password for the master user. The password can include any
  printable ASCII character except \"/\", \"\"\", or \"@\". It cannot contain spaces.  MySQL
  Constraints: Must contain from 8 to 41 characters.  PostgreSQL  Constraints: Must contain
  from 8 to 128 characters.
- `"preferredBackupWindow"`: The daily time range during which automated backups are
  created for your new database if automated backups are enabled. The default is a 30-minute
  window selected at random from an 8-hour block of time for each AWS Region. For more
  information about the preferred backup window time blocks for each region, see the Working
  With Backups guide in the Amazon Relational Database Service documentation. Constraints:
  Must be in the hh24:mi-hh24:mi format. Example: 16:00-16:30    Specified in Coordinated
  Universal Time (UTC).   Must not conflict with the preferred maintenance window.   Must be
  at least 30 minutes.
- `"preferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur on your new database. The default is a 30-minute window selected at random from an
  8-hour block of time for each AWS Region, occurring on a random day of the week.
  Constraints:   Must be in the ddd:hh24:mi-ddd:hh24:mi format.   Valid days: Mon, Tue, Wed,
  Thu, Fri, Sat, Sun.   Must be at least 30 minutes.   Specified in Coordinated Universal
  Time (UTC).   Example: Tue:17:00-Tue:17:30
- `"publiclyAccessible"`: Specifies the accessibility options for your new database. A
  value of true specifies a database that is available to resources outside of your Lightsail
  account. A value of false specifies a database that is available only to your Lightsail
  resources in the same region as your database.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_relational_database(
    masterDatabaseName,
    masterUsername,
    relationalDatabaseBlueprintId,
    relationalDatabaseBundleId,
    relationalDatabaseName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateRelationalDatabase",
        Dict{String,Any}(
            "masterDatabaseName" => masterDatabaseName,
            "masterUsername" => masterUsername,
            "relationalDatabaseBlueprintId" => relationalDatabaseBlueprintId,
            "relationalDatabaseBundleId" => relationalDatabaseBundleId,
            "relationalDatabaseName" => relationalDatabaseName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_relational_database(
    masterDatabaseName,
    masterUsername,
    relationalDatabaseBlueprintId,
    relationalDatabaseBundleId,
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "masterDatabaseName" => masterDatabaseName,
                    "masterUsername" => masterUsername,
                    "relationalDatabaseBlueprintId" => relationalDatabaseBlueprintId,
                    "relationalDatabaseBundleId" => relationalDatabaseBundleId,
                    "relationalDatabaseName" => relationalDatabaseName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_relational_database_from_snapshot(relational_database_name)
    create_relational_database_from_snapshot(relational_database_name, params::Dict{String,<:Any})

Creates a new database from an existing database snapshot in Amazon Lightsail. You can
create a new database from a snapshot in if something goes wrong with your original
database, or to change it to a different plan, such as a high availability or standard
plan. The create relational database from snapshot operation supports tag-based access
control via request tags and resource tags applied to the resource identified by
relationalDatabaseSnapshotName. For more information, see the Amazon Lightsail Developer
Guide.

# Arguments
- `relational_database_name`: The name to use for your new Lightsail database resource.
  Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first
  and last character must be a letter or number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"availabilityZone"`: The Availability Zone in which to create your new database. Use the
  us-east-2a case-sensitive format. You can get a list of Availability Zones by using the get
  regions operation. Be sure to add the include relational database Availability Zones
  parameter to your request.
- `"publiclyAccessible"`: Specifies the accessibility options for your new database. A
  value of true specifies a database that is available to resources outside of your Lightsail
  account. A value of false specifies a database that is available only to your Lightsail
  resources in the same region as your database.
- `"relationalDatabaseBundleId"`: The bundle ID for your new database. A bundle describes
  the performance specifications for your database. You can get a list of database bundle IDs
  by using the get relational database bundles operation. When creating a new database from a
  snapshot, you cannot choose a bundle that is smaller than the bundle of the source database.
- `"relationalDatabaseSnapshotName"`: The name of the database snapshot from which to
  create your new database.
- `"restoreTime"`: The date and time to restore your database from. Constraints:   Must be
  before the latest restorable time for the database.   Cannot be specified if the use latest
  restorable time parameter is true.   Specified in Coordinated Universal Time (UTC).
  Specified in the Unix time format. For example, if you wish to use a restore time of
  October 1, 2018, at 8 PM UTC, then you input 1538424000 as the restore time.
- `"sourceRelationalDatabaseName"`: The name of the source database.
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
- `"useLatestRestorableTime"`: Specifies whether your database is restored from the latest
  backup time. A value of true restores from the latest backup time.  Default: false
  Constraints: Cannot be specified if the restore time parameter is provided.
"""
function create_relational_database_from_snapshot(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "CreateRelationalDatabaseFromSnapshot",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_relational_database_from_snapshot(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateRelationalDatabaseFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_relational_database_snapshot(relational_database_name, relational_database_snapshot_name)
    create_relational_database_snapshot(relational_database_name, relational_database_snapshot_name, params::Dict{String,<:Any})

Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups,
to make copies of a database, and to save data before deleting a database. The create
relational database snapshot operation supports tag-based access control via request tags.
For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `relational_database_name`: The name of the database on which to base your new snapshot.
- `relational_database_snapshot_name`: The name for your new database snapshot.
  Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first
  and last character must be a letter or number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: The tag keys and optional values to add to the resource during create. Use the
  TagResource action to tag a resource after it's created.
"""
function create_relational_database_snapshot(
    relationalDatabaseName,
    relationalDatabaseSnapshotName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateRelationalDatabaseSnapshot",
        Dict{String,Any}(
            "relationalDatabaseName" => relationalDatabaseName,
            "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_relational_database_snapshot(
    relationalDatabaseName,
    relationalDatabaseSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "CreateRelationalDatabaseSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "relationalDatabaseName" => relationalDatabaseName,
                    "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_alarm(alarm_name)
    delete_alarm(alarm_name, params::Dict{String,<:Any})

Deletes an alarm. An alarm is used to monitor a single metric for one of your resources.
When a metric condition is met, the alarm can notify you by email, SMS text message, and a
banner displayed on the Amazon Lightsail console. For more information, see Alarms in
Amazon Lightsail.

# Arguments
- `alarm_name`: The name of the alarm to delete.

"""
function delete_alarm(alarmName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteAlarm",
        Dict{String,Any}("alarmName" => alarmName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_alarm(
    alarmName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteAlarm",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("alarmName" => alarmName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_auto_snapshot(date, resource_name)
    delete_auto_snapshot(date, resource_name, params::Dict{String,<:Any})

Deletes an automatic snapshot of an instance or disk. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `date`: The date of the automatic snapshot to delete in YYYY-MM-DD format. Use the get
  auto snapshots operation to get the available automatic snapshots for a resource.
- `resource_name`: The name of the source instance or disk from which to delete the
  automatic snapshot.

"""
function delete_auto_snapshot(
    date, resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteAutoSnapshot",
        Dict{String,Any}("date" => date, "resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_auto_snapshot(
    date,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteAutoSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("date" => date, "resourceName" => resourceName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bucket(bucket_name)
    delete_bucket(bucket_name, params::Dict{String,<:Any})

Deletes a Amazon Lightsail bucket.  When you delete your bucket, the bucket name is
released and can be reused for a new bucket in your account or another Amazon Web Services
account.

# Arguments
- `bucket_name`: The name of the bucket to delete. Use the GetBuckets action to get a list
  of bucket names that you can specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceDelete"`: A Boolean value that indicates whether to force delete the bucket. You
  must force delete the bucket if it has one of the following conditions:   The bucket is the
  origin of a distribution.   The bucket has instances that were granted access to it using
  the SetResourceAccessForBucket action.   The bucket has objects.   The bucket has access
  keys.    Force deleting a bucket might impact other resources that rely on the bucket, such
  as instances, distributions, or software that use the issued access keys.
"""
function delete_bucket(bucketName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteBucket",
        Dict{String,Any}("bucketName" => bucketName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bucket(
    bucketName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteBucket",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("bucketName" => bucketName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bucket_access_key(access_key_id, bucket_name)
    delete_bucket_access_key(access_key_id, bucket_name, params::Dict{String,<:Any})

Deletes an access key for the specified Amazon Lightsail bucket. We recommend that you
delete an access key if the secret access key is compromised. For more information about
access keys, see Creating access keys for a bucket in Amazon Lightsail in the Amazon
Lightsail Developer Guide.

# Arguments
- `access_key_id`: The ID of the access key to delete. Use the GetBucketAccessKeys action
  to get a list of access key IDs that you can specify.
- `bucket_name`: The name of the bucket that the access key belongs to.

"""
function delete_bucket_access_key(
    accessKeyId, bucketName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteBucketAccessKey",
        Dict{String,Any}("accessKeyId" => accessKeyId, "bucketName" => bucketName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bucket_access_key(
    accessKeyId,
    bucketName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteBucketAccessKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("accessKeyId" => accessKeyId, "bucketName" => bucketName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_certificate(certificate_name)
    delete_certificate(certificate_name, params::Dict{String,<:Any})

Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN)
distribution. Certificates that are currently attached to a distribution cannot be deleted.
Use the DetachCertificateFromDistribution action to detach a certificate from a
distribution.

# Arguments
- `certificate_name`: The name of the certificate to delete. Use the GetCertificates action
  to get a list of certificate names that you can specify.

"""
function delete_certificate(
    certificateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteCertificate",
        Dict{String,Any}("certificateName" => certificateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_certificate(
    certificateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteCertificate",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("certificateName" => certificateName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_contact_method(protocol)
    delete_contact_method(protocol, params::Dict{String,<:Any})

Deletes a contact method. A contact method is used to send you notifications about your
Amazon Lightsail resources. You can add one email address and one mobile phone number
contact method in each Amazon Web Services Region. However, SMS text messaging is not
supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some
countries/regions. For more information, see Notifications in Amazon Lightsail.

# Arguments
- `protocol`: The protocol that will be deleted, such as Email or SMS (text messaging).  To
  delete an Email and an SMS contact method if you added both, you must run separate
  DeleteContactMethod actions to delete each protocol.

"""
function delete_contact_method(protocol; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteContactMethod",
        Dict{String,Any}("protocol" => protocol);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_contact_method(
    protocol,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteContactMethod",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("protocol" => protocol), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_container_image(image, service_name)
    delete_container_image(image, service_name, params::Dict{String,<:Any})

Deletes a container image that is registered to your Amazon Lightsail container service.

# Arguments
- `image`: The name of the container image to delete from the container service. Use the
  GetContainerImages action to get the name of the container images that are registered to a
  container service.  Container images sourced from your Lightsail container service, that
  are registered and stored on your service, start with a colon (:). For example,
  :container-service-1.mystaticwebsite.1. Container images sourced from a public registry
  like Docker Hub don't start with a colon. For example, nginx:latest or nginx.
- `service_name`: The name of the container service for which to delete a registered
  container image.

"""
function delete_container_image(
    image, serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteContainerImage",
        Dict{String,Any}("image" => image, "serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_container_image(
    image,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteContainerImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("image" => image, "serviceName" => serviceName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_container_service(service_name)
    delete_container_service(service_name, params::Dict{String,<:Any})

Deletes your Amazon Lightsail container service.

# Arguments
- `service_name`: The name of the container service to delete.

"""
function delete_container_service(
    serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteContainerService",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_container_service(
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteContainerService",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_disk(disk_name)
    delete_disk(disk_name, params::Dict{String,<:Any})

Deletes the specified block storage disk. The disk must be in the available state (not
attached to a Lightsail instance).  The disk may remain in the deleting state for several
minutes.  The delete disk operation supports tag-based access control via resource tags
applied to the resource identified by disk name. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `disk_name`: The unique name of the disk you want to delete (my-disk).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceDeleteAddOns"`: A Boolean value to indicate whether to delete all add-ons for the
  disk.
"""
function delete_disk(diskName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteDisk",
        Dict{String,Any}("diskName" => diskName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_disk(
    diskName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteDisk",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("diskName" => diskName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_disk_snapshot(disk_snapshot_name)
    delete_disk_snapshot(disk_snapshot_name, params::Dict{String,<:Any})

Deletes the specified disk snapshot. When you make periodic snapshots of a disk, the
snapshots are incremental, and only the blocks on the device that have changed since your
last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not
needed for any other snapshot is removed. So regardless of which prior snapshots have been
deleted, all active snapshots will have access to all the information needed to restore the
disk. The delete disk snapshot operation supports tag-based access control via resource
tags applied to the resource identified by disk snapshot name. For more information, see
the Amazon Lightsail Developer Guide.

# Arguments
- `disk_snapshot_name`: The name of the disk snapshot you want to delete (my-disk-snapshot).

"""
function delete_disk_snapshot(
    diskSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteDiskSnapshot",
        Dict{String,Any}("diskSnapshotName" => diskSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_disk_snapshot(
    diskSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteDiskSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("diskSnapshotName" => diskSnapshotName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_distribution()
    delete_distribution(params::Dict{String,<:Any})

Deletes your Amazon Lightsail content delivery network (CDN) distribution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"distributionName"`: The name of the distribution to delete. Use the GetDistributions
  action to get a list of distribution names that you can specify.
"""
function delete_distribution(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteDistribution"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_distribution(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteDistribution", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    delete_domain(domain_name)
    delete_domain(domain_name, params::Dict{String,<:Any})

Deletes the specified domain recordset and all of its domain records. The delete domain
operation supports tag-based access control via resource tags applied to the resource
identified by domain name. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `domain_name`: The specific domain name to delete.

"""
function delete_domain(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteDomain",
        Dict{String,Any}("domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("domainName" => domainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain_entry(domain_entry, domain_name)
    delete_domain_entry(domain_entry, domain_name, params::Dict{String,<:Any})

Deletes a specific domain entry. The delete domain entry operation supports tag-based
access control via resource tags applied to the resource identified by domain name. For
more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `domain_entry`: An array of key-value pairs containing information about your domain
  entries.
- `domain_name`: The name of the domain entry to delete.

"""
function delete_domain_entry(
    domainEntry, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteDomainEntry",
        Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain_entry(
    domainEntry,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteDomainEntry",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance(instance_name)
    delete_instance(instance_name, params::Dict{String,<:Any})

Deletes an Amazon Lightsail instance. The delete instance operation supports tag-based
access control via resource tags applied to the resource identified by instance name. For
more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceDeleteAddOns"`: A Boolean value to indicate whether to delete all add-ons for the
  instance.
"""
function delete_instance(instanceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteInstance",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_snapshot(instance_snapshot_name)
    delete_instance_snapshot(instance_snapshot_name, params::Dict{String,<:Any})

Deletes a specific snapshot of a virtual private server (or instance). The delete instance
snapshot operation supports tag-based access control via resource tags applied to the
resource identified by instance snapshot name. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `instance_snapshot_name`: The name of the snapshot to delete.

"""
function delete_instance_snapshot(
    instanceSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteInstanceSnapshot",
        Dict{String,Any}("instanceSnapshotName" => instanceSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_snapshot(
    instanceSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteInstanceSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceSnapshotName" => instanceSnapshotName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_key_pair(key_pair_name)
    delete_key_pair(key_pair_name, params::Dict{String,<:Any})

Deletes the specified key pair by removing the public key from Amazon Lightsail. You can
delete key pairs that were created using the ImportKeyPair and CreateKeyPair actions, as
well as the Lightsail default key pair. A new default key pair will not be created unless
you launch an instance without specifying a custom key pair, or you call the
DownloadDefaultKeyPair API.  The delete key pair operation supports tag-based access
control via resource tags applied to the resource identified by key pair name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `key_pair_name`: The name of the key pair to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"expectedFingerprint"`: The RSA fingerprint of the Lightsail default key pair to delete.
   The expectedFingerprint parameter is required only when specifying to delete a Lightsail
  default key pair.
"""
function delete_key_pair(keyPairName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DeleteKeyPair",
        Dict{String,Any}("keyPairName" => keyPairName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_key_pair(
    keyPairName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteKeyPair",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyPairName" => keyPairName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_known_host_keys(instance_name)
    delete_known_host_keys(instance_name, params::Dict{String,<:Any})

Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or
RDP clients to authenticate an instance. This operation enables the Lightsail browser-based
SSH or RDP clients to connect to the instance after a host key mismatch.  Perform this
operation only if you were expecting the host key or certificate mismatch or if you are
familiar with the new host key or certificate on the instance. For more information, see
Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP
client.

# Arguments
- `instance_name`: The name of the instance for which you want to reset the host key or
  certificate.

"""
function delete_known_host_keys(
    instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteKnownHostKeys",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_known_host_keys(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteKnownHostKeys",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_load_balancer(load_balancer_name)
    delete_load_balancer(load_balancer_name, params::Dict{String,<:Any})

Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the
load balancer is deleted, you will need to create a new load balancer, create a new
certificate, and verify domain ownership again. The delete load balancer operation supports
tag-based access control via resource tags applied to the resource identified by load
balancer name. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `load_balancer_name`: The name of the load balancer you want to delete.

"""
function delete_load_balancer(
    loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteLoadBalancer",
        Dict{String,Any}("loadBalancerName" => loadBalancerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_load_balancer(
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("loadBalancerName" => loadBalancerName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_load_balancer_tls_certificate(certificate_name, load_balancer_name)
    delete_load_balancer_tls_certificate(certificate_name, load_balancer_name, params::Dict{String,<:Any})

Deletes an SSL/TLS certificate associated with a Lightsail load balancer. The
DeleteLoadBalancerTlsCertificate operation supports tag-based access control via resource
tags applied to the resource identified by load balancer name. For more information, see
the Amazon Lightsail Developer Guide.

# Arguments
- `certificate_name`: The SSL/TLS certificate name.
- `load_balancer_name`: The load balancer name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: When true, forces the deletion of an SSL/TLS certificate. There can be two
  certificates associated with a Lightsail load balancer: the primary and the backup. The
  force parameter is required when the primary SSL/TLS certificate is in use by an instance
  attached to the load balancer.
"""
function delete_load_balancer_tls_certificate(
    certificateName, loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteLoadBalancerTlsCertificate",
        Dict{String,Any}(
            "certificateName" => certificateName, "loadBalancerName" => loadBalancerName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_load_balancer_tls_certificate(
    certificateName,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteLoadBalancerTlsCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateName" => certificateName,
                    "loadBalancerName" => loadBalancerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_relational_database(relational_database_name)
    delete_relational_database(relational_database_name, params::Dict{String,<:Any})

Deletes a database in Amazon Lightsail. The delete relational database operation supports
tag-based access control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `relational_database_name`: The name of the database that you are deleting.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"finalRelationalDatabaseSnapshotName"`: The name of the database snapshot created if
  skip final snapshot is false, which is the default value for that parameter.  Specifying
  this parameter and also specifying the skip final snapshot parameter to true results in an
  error.  Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.
  The first and last character must be a letter or number.
- `"skipFinalSnapshot"`: Determines whether a final database snapshot is created before
  your database is deleted. If true is specified, no database snapshot is created. If false
  is specified, a database snapshot is created before your database is deleted. You must
  specify the final relational database snapshot name parameter if the skip final snapshot
  parameter is false. Default: false
"""
function delete_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_relational_database_snapshot(relational_database_snapshot_name)
    delete_relational_database_snapshot(relational_database_snapshot_name, params::Dict{String,<:Any})

Deletes a database snapshot in Amazon Lightsail. The delete relational database snapshot
operation supports tag-based access control via resource tags applied to the resource
identified by relationalDatabaseName. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `relational_database_snapshot_name`: The name of the database snapshot that you are
  deleting.

"""
function delete_relational_database_snapshot(
    relationalDatabaseSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DeleteRelationalDatabaseSnapshot",
        Dict{String,Any}(
            "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_relational_database_snapshot(
    relationalDatabaseSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DeleteRelationalDatabaseSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_certificate_from_distribution(distribution_name)
    detach_certificate_from_distribution(distribution_name, params::Dict{String,<:Any})

Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN)
distribution. After the certificate is detached, your distribution stops accepting traffic
for all of the domains that are associated with the certificate.

# Arguments
- `distribution_name`: The name of the distribution from which to detach the certificate.
  Use the GetDistributions action to get a list of distribution names that you can specify.

"""
function detach_certificate_from_distribution(
    distributionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DetachCertificateFromDistribution",
        Dict{String,Any}("distributionName" => distributionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_certificate_from_distribution(
    distributionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DetachCertificateFromDistribution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("distributionName" => distributionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_disk(disk_name)
    detach_disk(disk_name, params::Dict{String,<:Any})

Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any
file systems on the device within your operating system before stopping the instance and
detaching the disk. The detach disk operation supports tag-based access control via
resource tags applied to the resource identified by disk name. For more information, see
the Amazon Lightsail Developer Guide.

# Arguments
- `disk_name`: The unique name of the disk you want to detach from your instance (my-disk).

"""
function detach_disk(diskName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DetachDisk",
        Dict{String,Any}("diskName" => diskName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_disk(
    diskName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DetachDisk",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("diskName" => diskName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_instances_from_load_balancer(instance_names, load_balancer_name)
    detach_instances_from_load_balancer(instance_names, load_balancer_name, params::Dict{String,<:Any})

Detaches the specified instances from a Lightsail load balancer. This operation waits until
the instances are no longer needed before they are detached from the load balancer. The
detach instances from load balancer operation supports tag-based access control via
resource tags applied to the resource identified by load balancer name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_names`: An array of strings containing the names of the instances you want to
  detach from the load balancer.
- `load_balancer_name`: The name of the Lightsail load balancer.

"""
function detach_instances_from_load_balancer(
    instanceNames, loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DetachInstancesFromLoadBalancer",
        Dict{String,Any}(
            "instanceNames" => instanceNames, "loadBalancerName" => loadBalancerName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_instances_from_load_balancer(
    instanceNames,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DetachInstancesFromLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "instanceNames" => instanceNames, "loadBalancerName" => loadBalancerName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_static_ip(static_ip_name)
    detach_static_ip(static_ip_name, params::Dict{String,<:Any})

Detaches a static IP from the Amazon Lightsail instance to which it is attached.

# Arguments
- `static_ip_name`: The name of the static IP to detach from the instance.

"""
function detach_static_ip(staticIpName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DetachStaticIp",
        Dict{String,Any}("staticIpName" => staticIpName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_static_ip(
    staticIpName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DetachStaticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("staticIpName" => staticIpName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_add_on(add_on_type, resource_name)
    disable_add_on(add_on_type, resource_name, params::Dict{String,<:Any})

Disables an add-on for an Amazon Lightsail resource. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `add_on_type`: The add-on type to disable.
- `resource_name`: The name of the source resource for which to disable the add-on.

"""
function disable_add_on(
    addOnType, resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DisableAddOn",
        Dict{String,Any}("addOnType" => addOnType, "resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_add_on(
    addOnType,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "DisableAddOn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("addOnType" => addOnType, "resourceName" => resourceName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    download_default_key_pair()
    download_default_key_pair(params::Dict{String,<:Any})

Downloads the regional Amazon Lightsail default key pair. This action also creates a
Lightsail default key pair if a default key pair does not currently exist in the Amazon Web
Services Region.

"""
function download_default_key_pair(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "DownloadDefaultKeyPair"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function download_default_key_pair(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "DownloadDefaultKeyPair",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_add_on(add_on_request, resource_name)
    enable_add_on(add_on_request, resource_name, params::Dict{String,<:Any})

Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see
the Amazon Lightsail Developer Guide.

# Arguments
- `add_on_request`: An array of strings representing the add-on to enable or modify.
- `resource_name`: The name of the source resource for which to enable or modify the add-on.

"""
function enable_add_on(
    addOnRequest, resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "EnableAddOn",
        Dict{String,Any}("addOnRequest" => addOnRequest, "resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_add_on(
    addOnRequest,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "EnableAddOn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "addOnRequest" => addOnRequest, "resourceName" => resourceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_snapshot(source_snapshot_name)
    export_snapshot(source_snapshot_name, params::Dict{String,<:Any})

Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic
Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be
used with the create cloud formation stack operation to create new Amazon EC2 instances.
Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the
instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported
disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the
same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.  The export
snapshot operation supports tag-based access control via resource tags applied to the
resource identified by source snapshot name. For more information, see the Amazon Lightsail
Developer Guide.  Use the get instance snapshots or get disk snapshots operations to get a
list of snapshots that you can export to Amazon EC2.

# Arguments
- `source_snapshot_name`: The name of the instance or disk snapshot to be exported to
  Amazon EC2.

"""
function export_snapshot(
    sourceSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "ExportSnapshot",
        Dict{String,Any}("sourceSnapshotName" => sourceSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_snapshot(
    sourceSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "ExportSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("sourceSnapshotName" => sourceSnapshotName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_active_names()
    get_active_names(params::Dict{String,<:Any})

Returns the names of all active (not deleted) resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetActiveNames request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_active_names(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetActiveNames"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_active_names(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetActiveNames", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_alarms()
    get_alarms(params::Dict{String,<:Any})

Returns information about the configured alarms. Specify an alarm name in your request to
return information about a specific alarm, or specify a monitored resource name to return
information about all alarms for a specific resource. An alarm is used to monitor a single
metric for one of your resources. When a metric condition is met, the alarm can notify you
by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For
more information, see Alarms in Amazon Lightsail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"alarmName"`: The name of the alarm. Specify an alarm name to return information about a
  specific alarm.
- `"monitoredResourceName"`: The name of the Lightsail resource being monitored by the
  alarm. Specify a monitored resource name to return information about all alarms for a
  specific resource.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetAlarms request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_alarms(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetAlarms"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_alarms(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetAlarms", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_auto_snapshots(resource_name)
    get_auto_snapshots(resource_name, params::Dict{String,<:Any})

Returns the available automatic snapshots for an instance or disk. For more information,
see the Amazon Lightsail Developer Guide.

# Arguments
- `resource_name`: The name of the source instance or disk from which to get automatic
  snapshot information.

"""
function get_auto_snapshots(
    resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetAutoSnapshots",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_auto_snapshots(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetAutoSnapshots",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_blueprints()
    get_blueprints(params::Dict{String,<:Any})

Returns the list of available instance images, or blueprints. You can use a blueprint to
create a new instance already running a specific operating system, as well as a
preinstalled app or development stack. The software each instance is running depends on the
blueprint image you choose.  Use active blueprints when creating new instances. Inactive
blueprints are listed to support customers with existing instances and are not necessarily
available to create new instances. Blueprints are marked inactive when they become outdated
due to operating system updates or new application releases.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appCategory"`: Returns a list of blueprints that are specific to Lightsail for
  Research.  You must use this parameter to view Lightsail for Research blueprints.
- `"includeInactive"`: A Boolean value that indicates whether to include inactive
  (unavailable) blueprints in the response of your request.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetBlueprints request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_blueprints(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetBlueprints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_blueprints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetBlueprints", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_bucket_access_keys(bucket_name)
    get_bucket_access_keys(bucket_name, params::Dict{String,<:Any})

Returns the existing access key IDs for the specified Amazon Lightsail bucket.  This action
does not return the secret access key value of an access key. You can get a secret access
key only when you create it from the response of the CreateBucketAccessKey action. If you
lose the secret access key, you must create a new access key.

# Arguments
- `bucket_name`: The name of the bucket for which to return access keys.

"""
function get_bucket_access_keys(
    bucketName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetBucketAccessKeys",
        Dict{String,Any}("bucketName" => bucketName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bucket_access_keys(
    bucketName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetBucketAccessKeys",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("bucketName" => bucketName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bucket_bundles()
    get_bucket_bundles(params::Dict{String,<:Any})

Returns the bundles that you can apply to a Amazon Lightsail bucket. The bucket bundle
specifies the monthly cost, storage quota, and data transfer quota for a bucket. Use the
UpdateBucketBundle action to update the bundle for a bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeInactive"`: A Boolean value that indicates whether to include inactive
  (unavailable) bundles in the response of your request.
"""
function get_bucket_bundles(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetBucketBundles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_bucket_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetBucketBundles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_bucket_metric_data(bucket_name, end_time, metric_name, period, start_time, statistics, unit)
    get_bucket_metric_data(bucket_name, end_time, metric_name, period, start_time, statistics, unit, params::Dict{String,<:Any})

Returns the data points of a specific metric for an Amazon Lightsail bucket. Metrics report
the utilization of a bucket. View and collect metric data regularly to monitor the number
of objects stored in a bucket (including object versions) and the storage space used by
those objects.

# Arguments
- `bucket_name`: The name of the bucket for which to get metric data.
- `end_time`: The timestamp indicating the latest data to be returned.
- `metric_name`: The metric for which you want to return information. Valid bucket metric
  names are listed below, along with the most useful statistics to include in your request,
  and the published unit value.  These bucket metrics are reported once per day.
  BucketSizeBytes  - The amount of data in bytes stored in a bucket. This value is calculated
  by summing the size of all objects in the bucket (including object versions), including the
  size of all parts for all incomplete multipart uploads to the bucket. Statistics: The most
  useful statistic is Maximum. Unit: The published unit is Bytes.     NumberOfObjects  - The
  total number of objects stored in a bucket. This value is calculated by counting all
  objects in the bucket (including object versions) and the total number of parts for all
  incomplete multipart uploads to the bucket. Statistics: The most useful statistic is
  Average. Unit: The published unit is Count.
- `period`: The granularity, in seconds, of the returned data points.  Bucket storage
  metrics are reported once per day. Therefore, you should specify a period of 86400 seconds,
  which is the number of seconds in a day.
- `start_time`: The timestamp indicating the earliest data to be returned.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - The sum of all values submitted for the matching metric. You
  can use this statistic to determine the total volume of a metric.    Average - The value of
  Sum / SampleCount during the specified period. By comparing this statistic with the Minimum
  and Maximum values, you can determine the full scope of a metric and how close the average
  use is to the Minimum and Maximum values. This comparison helps you to know when to
  increase or decrease your resources.    SampleCount - The count, or number, of data points
  used for the statistical calculation.
- `unit`: The unit for the metric data request. Valid units depend on the metric data being
  requested. For the valid units with each available metric, see the metricName parameter.

"""
function get_bucket_metric_data(
    bucketName,
    endTime,
    metricName,
    period,
    startTime,
    statistics,
    unit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetBucketMetricData",
        Dict{String,Any}(
            "bucketName" => bucketName,
            "endTime" => endTime,
            "metricName" => metricName,
            "period" => period,
            "startTime" => startTime,
            "statistics" => statistics,
            "unit" => unit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bucket_metric_data(
    bucketName,
    endTime,
    metricName,
    period,
    startTime,
    statistics,
    unit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetBucketMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "bucketName" => bucketName,
                    "endTime" => endTime,
                    "metricName" => metricName,
                    "period" => period,
                    "startTime" => startTime,
                    "statistics" => statistics,
                    "unit" => unit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_buckets()
    get_buckets(params::Dict{String,<:Any})

Returns information about one or more Amazon Lightsail buckets. The information returned
includes the synchronization status of the Amazon Simple Storage Service (Amazon S3)
account-level block public access feature for your Lightsail buckets. For more information
about buckets, see Buckets in Amazon Lightsail in the Amazon Lightsail Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"bucketName"`: The name of the bucket for which to return information. When omitted, the
  response includes all of your buckets in the Amazon Web Services Region where the request
  is made.
- `"includeConnectedResources"`: A Boolean value that indicates whether to include
  Lightsail instances that were given access to the bucket using the
  SetResourceAccessForBucket action.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetBuckets request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_buckets(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetBuckets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_buckets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetBuckets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_bundles()
    get_bundles(params::Dict{String,<:Any})

Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
A bundle describes the specifications of an instance, such as the monthly cost, amount of
memory, the number of vCPUs, amount of storage space, and monthly network data transfer
quota.  Bundles are referred to as instance plans in the Lightsail console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"appCategory"`: Returns a list of bundles that are specific to Lightsail for Research.
  You must use this parameter to view Lightsail for Research bundles.
- `"includeInactive"`: A Boolean value that indicates whether to include inactive
  (unavailable) bundles in the response of your request.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetBundles request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_bundles(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetBundles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetBundles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_certificates()
    get_certificates(params::Dict{String,<:Any})

Returns information about one or more Amazon Lightsail SSL/TLS certificates.  To get a
summary of a certificate, omit includeCertificateDetails from your request. The response
will include only the certificate Amazon Resource Name (ARN), certificate name, domain
name, and tags.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"certificateName"`: The name for the certificate for which to return information. When
  omitted, the response includes all of your certificates in the Amazon Web Services Region
  where the request is made.
- `"certificateStatuses"`: The status of the certificates for which to return information.
  For example, specify ISSUED to return only certificates with an ISSUED status. When
  omitted, the response includes all of your certificates in the Amazon Web Services Region
  where the request is made, regardless of their current status.
- `"includeCertificateDetails"`: Indicates whether to include detailed information about
  the certificates in the response. When omitted, the response includes only the certificate
  names, Amazon Resource Names (ARNs), domain names, and tags.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetCertificates request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetCertificates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_cloud_formation_stack_records()
    get_cloud_formation_stack_records(params::Dict{String,<:Any})

Returns the CloudFormation stack record created as a result of the create cloud formation
stack operation. An AWS CloudFormation stack is used to create a new Amazon EC2 instance
from an exported Lightsail snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetClouFormationStackRecords request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_cloud_formation_stack_records(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetCloudFormationStackRecords";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cloud_formation_stack_records(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetCloudFormationStackRecords",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_methods()
    get_contact_methods(params::Dict{String,<:Any})

Returns information about the configured contact methods. Specify a protocol in your
request to return information about a specific contact method. A contact method is used to
send you notifications about your Amazon Lightsail resources. You can add one email address
and one mobile phone number contact method in each Amazon Web Services Region. However, SMS
text messaging is not supported in some Amazon Web Services Regions, and SMS text messages
cannot be sent to some countries/regions. For more information, see Notifications in Amazon
Lightsail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"protocols"`: The protocols used to send notifications, such as Email, or SMS (text
  messaging). Specify a protocol in your request to return information about a specific
  contact method protocol.
"""
function get_contact_methods(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetContactMethods"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_contact_methods(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContactMethods", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_container_apimetadata()
    get_container_apimetadata(params::Dict{String,<:Any})

Returns information about Amazon Lightsail containers, such as the current version of the
Lightsail Control (lightsailctl) plugin.

"""
function get_container_apimetadata(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetContainerAPIMetadata"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_container_apimetadata(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerAPIMetadata",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_images(service_name)
    get_container_images(service_name, params::Dict{String,<:Any})

Returns the container images that are registered to your Amazon Lightsail container
service.  If you created a deployment on your Lightsail container service that uses
container images from a public registry like Docker Hub, those images are not returned as
part of this action. Those images are not registered to your Lightsail container service.

# Arguments
- `service_name`: The name of the container service for which to return registered
  container images.

"""
function get_container_images(
    serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerImages",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_images(
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetContainerImages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_log(container_name, service_name)
    get_container_log(container_name, service_name, params::Dict{String,<:Any})

Returns the log events of a container of your Amazon Lightsail container service. If your
container service has more than one node (i.e., a scale greater than 1), then the log
events that are returned for the specified container are merged from all nodes on your
container service.  Container logs are retained for a certain amount of time. For more
information, see Amazon Lightsail endpoints and quotas in the Amazon Web Services General
Reference.

# Arguments
- `container_name`: The name of the container that is either running or previously ran on
  the container service for which to return a log.
- `service_name`: The name of the container service for which to get a container log.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The end of the time interval for which to get log data. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify 1538427600
  as the end time.   You can convert a human-friendly time to Unix time format using a
  converter like Epoch converter.
- `"filterPattern"`: The pattern to use to filter the returned log events to a specific
  term. The following are a few examples of filter patterns that you can specify:   To return
  all log events, specify a filter pattern of \"\".   To exclude log events that contain the
  ERROR term, and return all other log events, specify a filter pattern of \"-ERROR\".   To
  return log events that contain the ERROR term, specify a filter pattern of \"ERROR\".   To
  return log events that contain both the ERROR and Exception terms, specify a filter pattern
  of \"ERROR Exception\".   To return log events that contain the ERROR or the Exception
  term, specify a filter pattern of \"?ERROR ?Exception\".
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetContainerLog request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
- `"startTime"`: The start of the time interval for which to get log data. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
  1538424000 as the start time.   You can convert a human-friendly time to Unix time format
  using a converter like Epoch converter.
"""
function get_container_log(
    containerName, serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerLog",
        Dict{String,Any}("containerName" => containerName, "serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_log(
    containerName,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetContainerLog",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "containerName" => containerName, "serviceName" => serviceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_service_deployments(service_name)
    get_container_service_deployments(service_name, params::Dict{String,<:Any})

Returns the deployments for your Amazon Lightsail container service A deployment specifies
the settings, such as the ports and launch command, of containers that are deployed to your
container service. The deployments are ordered by version in ascending order. The newest
version is listed at the top of the response.  A set number of deployments are kept before
the oldest one is replaced with the newest one. For more information, see Amazon Lightsail
endpoints and quotas in the Amazon Web Services General Reference.

# Arguments
- `service_name`: The name of the container service for which to return deployments.

"""
function get_container_service_deployments(
    serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerServiceDeployments",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_service_deployments(
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetContainerServiceDeployments",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_service_metric_data(end_time, metric_name, period, service_name, start_time, statistics)
    get_container_service_metric_data(end_time, metric_name, period, service_name, start_time, statistics, params::Dict{String,<:Any})

Returns the data points of a specific metric of your Amazon Lightsail container service.
Metrics report the utilization of your resources. Monitor and collect metric data regularly
to maintain the reliability, availability, and performance of your resources.

# Arguments
- `end_time`: The end time of the time period.
- `metric_name`: The metric for which you want to return information. Valid container
  service metric names are listed below, along with the most useful statistics to include in
  your request, and the published unit value.    CPUUtilization - The average percentage of
  compute units that are currently in use across all nodes of the container service. This
  metric identifies the processing power required to run containers on each node of the
  container service. Statistics: The most useful statistics are Maximum and Average. Unit:
  The published unit is Percent.    MemoryUtilization - The average percentage of available
  memory that is currently in use across all nodes of the container service. This metric
  identifies the memory required to run containers on each node of the container service.
  Statistics: The most useful statistics are Maximum and Average. Unit: The published unit is
  Percent.
- `period`: The granularity, in seconds, of the returned data points. All container service
  metric data is available in 5-minute (300 seconds) granularity.
- `service_name`: The name of the container service for which to get metric data.
- `start_time`: The start time of the time period.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - All values submitted for the matching metric added together.
  You can use this statistic to determine the total volume of a metric.    Average - The
  value of Sum / SampleCount during the specified period. By comparing this statistic with
  the Minimum and Maximum values, you can determine the full scope of a metric and how close
  the average use is to the Minimum and Maximum values. This comparison helps you to know
  when to increase or decrease your resources.    SampleCount - The count, or number, of data
  points used for the statistical calculation.

"""
function get_container_service_metric_data(
    endTime,
    metricName,
    period,
    serviceName,
    startTime,
    statistics;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetContainerServiceMetricData",
        Dict{String,Any}(
            "endTime" => endTime,
            "metricName" => metricName,
            "period" => period,
            "serviceName" => serviceName,
            "startTime" => startTime,
            "statistics" => statistics,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_service_metric_data(
    endTime,
    metricName,
    period,
    serviceName,
    startTime,
    statistics,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetContainerServiceMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "metricName" => metricName,
                    "period" => period,
                    "serviceName" => serviceName,
                    "startTime" => startTime,
                    "statistics" => statistics,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_service_powers()
    get_container_service_powers(params::Dict{String,<:Any})

Returns the list of powers that can be specified for your Amazon Lightsail container
services. The power specifies the amount of memory, the number of vCPUs, and the base price
of the container service.

"""
function get_container_service_powers(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetContainerServicePowers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_container_service_powers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerServicePowers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_container_services()
    get_container_services(params::Dict{String,<:Any})

Returns information about one or more of your Amazon Lightsail container services.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"serviceName"`: The name of the container service for which to return information. When
  omitted, the response includes all of your container services in the Amazon Web Services
  Region where the request is made.
"""
function get_container_services(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetContainerServices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_container_services(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetContainerServices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cost_estimate(end_time, resource_name, start_time)
    get_cost_estimate(end_time, resource_name, start_time, params::Dict{String,<:Any})

Retrieves information about the cost estimate for a specified resource. A cost estimate
will not generate for a resource that has been deleted.

# Arguments
- `end_time`: The cost estimate end time. Constraints:   Specified in Coordinated Universal
  Time (UTC).   Specified in the Unix time format. For example, if you want to use an end
  time of October 1, 2018, at 9 PM UTC, specify 1538427600 as the end time.   You can convert
  a human-friendly time to Unix time format using a converter like Epoch converter.
- `resource_name`: The resource name.
- `start_time`: The cost estimate start time. Constraints:   Specified in Coordinated
  Universal Time (UTC).   Specified in the Unix time format. For example, if you want to use
  a start time of October 1, 2018, at 8 PM UTC, specify 1538424000 as the start time.   You
  can convert a human-friendly time to Unix time format using a converter like Epoch
  converter.

"""
function get_cost_estimate(
    endTime, resourceName, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetCostEstimate",
        Dict{String,Any}(
            "endTime" => endTime, "resourceName" => resourceName, "startTime" => startTime
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cost_estimate(
    endTime,
    resourceName,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetCostEstimate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "resourceName" => resourceName,
                    "startTime" => startTime,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_disk(disk_name)
    get_disk(disk_name, params::Dict{String,<:Any})

Returns information about a specific block storage disk.

# Arguments
- `disk_name`: The name of the disk (my-disk).

"""
function get_disk(diskName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetDisk",
        Dict{String,Any}("diskName" => diskName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_disk(
    diskName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetDisk",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("diskName" => diskName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_disk_snapshot(disk_snapshot_name)
    get_disk_snapshot(disk_snapshot_name, params::Dict{String,<:Any})

Returns information about a specific block storage disk snapshot.

# Arguments
- `disk_snapshot_name`: The name of the disk snapshot (my-disk-snapshot).

"""
function get_disk_snapshot(
    diskSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDiskSnapshot",
        Dict{String,Any}("diskSnapshotName" => diskSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_disk_snapshot(
    diskSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetDiskSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("diskSnapshotName" => diskSnapshotName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_disk_snapshots()
    get_disk_snapshots(params::Dict{String,<:Any})

Returns information about all block storage disk snapshots in your AWS account and region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetDiskSnapshots request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_disk_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetDiskSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_disk_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDiskSnapshots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_disks()
    get_disks(params::Dict{String,<:Any})

Returns information about all block storage disks in your AWS account and region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetDisks request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_disks(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetDisks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_disks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDisks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_distribution_bundles()
    get_distribution_bundles(params::Dict{String,<:Any})

Returns the bundles that can be applied to your Amazon Lightsail content delivery network
(CDN) distributions. A distribution bundle specifies the monthly network transfer quota and
monthly cost of your distribution.

"""
function get_distribution_bundles(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetDistributionBundles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_distribution_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDistributionBundles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_distribution_latest_cache_reset()
    get_distribution_latest_cache_reset(params::Dict{String,<:Any})

Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail
content delivery network (CDN) distribution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"distributionName"`: The name of the distribution for which to return the timestamp of
  the last cache reset. Use the GetDistributions action to get a list of distribution names
  that you can specify. When omitted, the response includes the latest cache reset timestamp
  of all your distributions.
"""
function get_distribution_latest_cache_reset(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDistributionLatestCacheReset";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_distribution_latest_cache_reset(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDistributionLatestCacheReset",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_distribution_metric_data(distribution_name, end_time, metric_name, period, start_time, statistics, unit)
    get_distribution_metric_data(distribution_name, end_time, metric_name, period, start_time, statistics, unit, params::Dict{String,<:Any})

Returns the data points of a specific metric for an Amazon Lightsail content delivery
network (CDN) distribution. Metrics report the utilization of your resources, and the error
counts generated by them. Monitor and collect metric data regularly to maintain the
reliability, availability, and performance of your resources.

# Arguments
- `distribution_name`: The name of the distribution for which to get metric data. Use the
  GetDistributions action to get a list of distribution names that you can specify.
- `end_time`: The end of the time interval for which to get metric data. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify 1538427600
  as the end time.   You can convert a human-friendly time to Unix time format using a
  converter like Epoch converter.
- `metric_name`: The metric for which you want to return information. Valid distribution
  metric names are listed below, along with the most useful statistics to include in your
  request, and the published unit value.     Requests  - The total number of viewer requests
  received by your Lightsail distribution, for all HTTP methods, and for both HTTP and HTTPS
  requests.  Statistics: The most useful statistic is Sum.  Unit: The published unit is None.
      BytesDownloaded  - The number of bytes downloaded by viewers for GET, HEAD, and OPTIONS
  requests.  Statistics: The most useful statistic is Sum.  Unit: The published unit is None.
      BytesUploaded   - The number of bytes uploaded to your origin by your Lightsail
  distribution, using POST and PUT requests.  Statistics: The most useful statistic is Sum.
  Unit: The published unit is None.     TotalErrorRate  - The percentage of all viewer
  requests for which the response's HTTP status code was 4xx or 5xx.  Statistics: The most
  useful statistic is Average.  Unit: The published unit is Percent.     4xxErrorRate  - The
  percentage of all viewer requests for which the response's HTTP status cod was 4xx. In
  these cases, the client or client viewer may have made an error. For example, a status code
  of 404 (Not Found) means that the client requested an object that could not be found.
  Statistics: The most useful statistic is Average.  Unit: The published unit is Percent.
  5xxErrorRate  - The percentage of all viewer requests for which the response's HTTP status
  code was 5xx. In these cases, the origin server did not satisfy the requests. For example,
  a status code of 503 (Service Unavailable) means that the origin server is currently
  unavailable.  Statistics: The most useful statistic is Average.  Unit: The published unit
  is Percent.
- `period`: The granularity, in seconds, for the metric data points that will be returned.
- `start_time`: The start of the time interval for which to get metric data. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
  1538424000 as the start time.   You can convert a human-friendly time to Unix time format
  using a converter like Epoch converter.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - All values submitted for the matching metric added together.
  You can use this statistic to determine the total volume of a metric.    Average - The
  value of Sum / SampleCount during the specified period. By comparing this statistic with
  the Minimum and Maximum values, you can determine the full scope of a metric and how close
  the average use is to the Minimum and Maximum values. This comparison helps you to know
  when to increase or decrease your resources.    SampleCount - The count, or number, of data
  points used for the statistical calculation.
- `unit`: The unit for the metric data request. Valid units depend on the metric data being
  requested. For the valid units with each available metric, see the metricName parameter.

"""
function get_distribution_metric_data(
    distributionName,
    endTime,
    metricName,
    period,
    startTime,
    statistics,
    unit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetDistributionMetricData",
        Dict{String,Any}(
            "distributionName" => distributionName,
            "endTime" => endTime,
            "metricName" => metricName,
            "period" => period,
            "startTime" => startTime,
            "statistics" => statistics,
            "unit" => unit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_distribution_metric_data(
    distributionName,
    endTime,
    metricName,
    period,
    startTime,
    statistics,
    unit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetDistributionMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "distributionName" => distributionName,
                    "endTime" => endTime,
                    "metricName" => metricName,
                    "period" => period,
                    "startTime" => startTime,
                    "statistics" => statistics,
                    "unit" => unit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_distributions()
    get_distributions(params::Dict{String,<:Any})

Returns information about one or more of your Amazon Lightsail content delivery network
(CDN) distributions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"distributionName"`: The name of the distribution for which to return information. When
  omitted, the response includes all of your distributions in the Amazon Web Services Region
  where the request is made.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetDistributions request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_distributions(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetDistributions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_distributions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDistributions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_domain(domain_name)
    get_domain(domain_name, params::Dict{String,<:Any})

Returns information about a specific domain recordset.

# Arguments
- `domain_name`: The domain name for which your want to return information about.

"""
function get_domain(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetDomain",
        Dict{String,Any}("domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("domainName" => domainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domains()
    get_domains(params::Dict{String,<:Any})

Returns a list of all domains in the user's account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetDomains request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_domains(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetDomains"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetDomains", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_export_snapshot_records()
    get_export_snapshot_records(params::Dict{String,<:Any})

Returns all export snapshot records created as a result of the export snapshot operation.
An export snapshot record can be used to create a new Amazon EC2 instance and its related
resources with the CreateCloudFormationStack action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetExportSnapshotRecords request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_export_snapshot_records(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetExportSnapshotRecords"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_export_snapshot_records(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetExportSnapshotRecords",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance(instance_name)
    get_instance(instance_name, params::Dict{String,<:Any})

Returns information about a specific Amazon Lightsail instance, which is a virtual private
server.

# Arguments
- `instance_name`: The name of the instance.

"""
function get_instance(instanceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetInstance",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_access_details(instance_name)
    get_instance_access_details(instance_name, params::Dict{String,<:Any})

Returns temporary SSH keys you can use to connect to a specific virtual private server, or
instance. The get instance access details operation supports tag-based access control via
resource tags applied to the resource identified by instance name. For more information,
see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance to access.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"protocol"`: The protocol to use to connect to your instance. Defaults to ssh.
"""
function get_instance_access_details(
    instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstanceAccessDetails",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_access_details(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstanceAccessDetails",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_metric_data(end_time, instance_name, metric_name, period, start_time, statistics, unit)
    get_instance_metric_data(end_time, instance_name, metric_name, period, start_time, statistics, unit, params::Dict{String,<:Any})

Returns the data points for the specified Amazon Lightsail instance metric, given an
instance name. Metrics report the utilization of your resources, and the error counts
generated by them. Monitor and collect metric data regularly to maintain the reliability,
availability, and performance of your resources.

# Arguments
- `end_time`: The end time of the time period.
- `instance_name`: The name of the instance for which you want to get metrics data.
- `metric_name`: The metric for which you want to return information. Valid instance metric
  names are listed below, along with the most useful statistics to include in your request,
  and the published unit value.     BurstCapacityPercentage  - The percentage of CPU
  performance available for your instance to burst above its baseline. Your instance
  continuously accrues and consumes burst capacity. Burst capacity stops accruing when your
  instance's BurstCapacityPercentage reaches 100%. For more information, see Viewing instance
  burst capacity in Amazon Lightsail.  Statistics: The most useful statistics are Maximum and
  Average.  Unit: The published unit is Percent.     BurstCapacityTime  - The available
  amount of time for your instance to burst at 100% CPU utilization. Your instance
  continuously accrues and consumes burst capacity. Burst capacity time stops accruing when
  your instance's BurstCapacityPercentage metric reaches 100%. Burst capacity time is
  consumed at the full rate only when your instance operates at 100% CPU utilization. For
  example, if your instance operates at 50% CPU utilization in the burstable zone for a
  5-minute period, then it consumes CPU burst capacity minutes at a 50% rate in that period.
  Your instance consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the
  5-minute period. For more information, see Viewing instance burst capacity in Amazon
  Lightsail.  Statistics: The most useful statistics are Maximum and Average.  Unit: The
  published unit is Seconds.     CPUUtilization  - The percentage of allocated compute units
  that are currently in use on the instance. This metric identifies the processing power to
  run the applications on the instance. Tools in your operating system can show a lower
  percentage than Lightsail when the instance is not allocated a full processor core.
  Statistics: The most useful statistics are Maximum and Average.  Unit: The published unit
  is Percent.     NetworkIn  - The number of bytes received on all network interfaces by the
  instance. This metric identifies the volume of incoming network traffic to the instance.
  The number reported is the number of bytes received during the period. Because this metric
  is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.
  Statistics: The most useful statistic is Sum.  Unit: The published unit is Bytes.
  NetworkOut  - The number of bytes sent out on all network interfaces by the instance. This
  metric identifies the volume of outgoing network traffic from the instance. The number
  reported is the number of bytes sent during the period. Because this metric is reported in
  5-minute intervals, divide the reported number by 300 to find Bytes/second.  Statistics:
  The most useful statistic is Sum.  Unit: The published unit is Bytes.     StatusCheckFailed
   - Reports whether the instance passed or failed both the instance status check and the
  system status check. This metric can be either 0 (passed) or 1 (failed). This metric data
  is available in 1-minute (60 seconds) granularity.  Statistics: The most useful statistic
  is Sum.  Unit: The published unit is Count.     StatusCheckFailed_Instance  - Reports
  whether the instance passed or failed the instance status check. This metric can be either
  0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds)
  granularity.  Statistics: The most useful statistic is Sum.  Unit: The published unit is
  Count.     StatusCheckFailed_System  - Reports whether the instance passed or failed the
  system status check. This metric can be either 0 (passed) or 1 (failed). This metric data
  is available in 1-minute (60 seconds) granularity.  Statistics: The most useful statistic
  is Sum.  Unit: The published unit is Count.     MetadataNoToken  - Reports the number of
  times that the instance metadata service was successfully accessed without a token. This
  metric determines if there are any processes accessing instance metadata by using Instance
  Metadata Service Version 1, which doesn't use a token. If all requests use token-backed
  sessions, such as Instance Metadata Service Version 2, then the value is 0.  Statistics:
  The most useful statistic is Sum.  Unit: The published unit is Count.
- `period`: The granularity, in seconds, of the returned data points. The
  StatusCheckFailed, StatusCheckFailed_Instance, and StatusCheckFailed_System instance metric
  data is available in 1-minute (60 seconds) granularity. All other instance metric data is
  available in 5-minute (300 seconds) granularity.
- `start_time`: The start time of the time period.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - All values submitted for the matching metric added together.
  You can use this statistic to determine the total volume of a metric.    Average - The
  value of Sum / SampleCount during the specified period. By comparing this statistic with
  the Minimum and Maximum values, you can determine the full scope of a metric and how close
  the average use is to the Minimum and Maximum values. This comparison helps you to know
  when to increase or decrease your resources.    SampleCount - The count, or number, of data
  points used for the statistical calculation.
- `unit`: The unit for the metric data request. Valid units depend on the metric data being
  requested. For the valid units to specify with each available metric, see the metricName
  parameter.

"""
function get_instance_metric_data(
    endTime,
    instanceName,
    metricName,
    period,
    startTime,
    statistics,
    unit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstanceMetricData",
        Dict{String,Any}(
            "endTime" => endTime,
            "instanceName" => instanceName,
            "metricName" => metricName,
            "period" => period,
            "startTime" => startTime,
            "statistics" => statistics,
            "unit" => unit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_metric_data(
    endTime,
    instanceName,
    metricName,
    period,
    startTime,
    statistics,
    unit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstanceMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "instanceName" => instanceName,
                    "metricName" => metricName,
                    "period" => period,
                    "startTime" => startTime,
                    "statistics" => statistics,
                    "unit" => unit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_port_states(instance_name)
    get_instance_port_states(instance_name, params::Dict{String,<:Any})

Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses
allowed to connect to the instance through the ports, and the protocol.

# Arguments
- `instance_name`: The name of the instance for which to return firewall port states.

"""
function get_instance_port_states(
    instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstancePortStates",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_port_states(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstancePortStates",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_snapshot(instance_snapshot_name)
    get_instance_snapshot(instance_snapshot_name, params::Dict{String,<:Any})

Returns information about a specific instance snapshot.

# Arguments
- `instance_snapshot_name`: The name of the snapshot for which you are requesting
  information.

"""
function get_instance_snapshot(
    instanceSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstanceSnapshot",
        Dict{String,Any}("instanceSnapshotName" => instanceSnapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_snapshot(
    instanceSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstanceSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceSnapshotName" => instanceSnapshotName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_snapshots()
    get_instance_snapshots(params::Dict{String,<:Any})

Returns all instance snapshots for the user's account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetInstanceSnapshots request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_instance_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetInstanceSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_instance_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstanceSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_state(instance_name)
    get_instance_state(instance_name, params::Dict{String,<:Any})

Returns the state of a specific instance. Works on one instance at a time.

# Arguments
- `instance_name`: The name of the instance to get state information about.

"""
function get_instance_state(
    instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstanceState",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_state(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetInstanceState",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instances()
    get_instances(params::Dict{String,<:Any})

Returns information about all Amazon Lightsail virtual private servers, or instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetInstances request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetInstances", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_key_pair(key_pair_name)
    get_key_pair(key_pair_name, params::Dict{String,<:Any})

Returns information about a specific key pair.

# Arguments
- `key_pair_name`: The name of the key pair for which you are requesting information.

"""
function get_key_pair(keyPairName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetKeyPair",
        Dict{String,Any}("keyPairName" => keyPairName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_key_pair(
    keyPairName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetKeyPair",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("keyPairName" => keyPairName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_key_pairs()
    get_key_pairs(params::Dict{String,<:Any})

Returns information about all key pairs in the user's account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeDefaultKeyPair"`: A Boolean value that indicates whether to include the default
  key pair in the response of your request.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetKeyPairs request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_key_pairs(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetKeyPairs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_key_pairs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetKeyPairs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_load_balancer(load_balancer_name)
    get_load_balancer(load_balancer_name, params::Dict{String,<:Any})

Returns information about the specified Lightsail load balancer.

# Arguments
- `load_balancer_name`: The name of the load balancer.

"""
function get_load_balancer(
    loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetLoadBalancer",
        Dict{String,Any}("loadBalancerName" => loadBalancerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_load_balancer(
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetLoadBalancer",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("loadBalancerName" => loadBalancerName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_load_balancer_metric_data(end_time, load_balancer_name, metric_name, period, start_time, statistics, unit)
    get_load_balancer_metric_data(end_time, load_balancer_name, metric_name, period, start_time, statistics, unit, params::Dict{String,<:Any})

Returns information about health metrics for your Lightsail load balancer. Metrics report
the utilization of your resources, and the error counts generated by them. Monitor and
collect metric data regularly to maintain the reliability, availability, and performance of
your resources.

# Arguments
- `end_time`: The end time of the period.
- `load_balancer_name`: The name of the load balancer.
- `metric_name`: The metric for which you want to return information. Valid load balancer
  metric names are listed below, along with the most useful statistics to include in your
  request, and the published unit value.     ClientTLSNegotiationErrorCount  - The number of
  TLS connections initiated by the client that did not establish a session with the load
  balancer due to a TLS error generated by the load balancer. Possible causes include a
  mismatch of ciphers or protocols.  Statistics: The most useful statistic is Sum.  Unit: The
  published unit is Count.     HealthyHostCount  - The number of target instances that are
  considered healthy.  Statistics: The most useful statistic are Average, Minimum, and
  Maximum.  Unit: The published unit is Count.     HTTPCode_Instance_2XX_Count  - The number
  of HTTP 2XX response codes generated by the target instances. This does not include any
  response codes generated by the load balancer.  Statistics: The most useful statistic is
  Sum. Note that Minimum, Maximum, and Average all return 1.  Unit: The published unit is
  Count.     HTTPCode_Instance_3XX_Count  - The number of HTTP 3XX response codes generated
  by the target instances. This does not include any response codes generated by the load
  balancer.  Statistics: The most useful statistic is Sum. Note that Minimum, Maximum, and
  Average all return 1.  Unit: The published unit is Count.     HTTPCode_Instance_4XX_Count
  - The number of HTTP 4XX response codes generated by the target instances. This does not
  include any response codes generated by the load balancer.  Statistics: The most useful
  statistic is Sum. Note that Minimum, Maximum, and Average all return 1.  Unit: The
  published unit is Count.     HTTPCode_Instance_5XX_Count  - The number of HTTP 5XX response
  codes generated by the target instances. This does not include any response codes generated
  by the load balancer.  Statistics: The most useful statistic is Sum. Note that Minimum,
  Maximum, and Average all return 1.  Unit: The published unit is Count.
  HTTPCode_LB_4XX_Count  - The number of HTTP 4XX client error codes that originated from the
  load balancer. Client errors are generated when requests are malformed or incomplete. These
  requests were not received by the target instance. This count does not include response
  codes generated by the target instances.  Statistics: The most useful statistic is Sum.
  Note that Minimum, Maximum, and Average all return 1.  Unit: The published unit is Count.
    HTTPCode_LB_5XX_Count  - The number of HTTP 5XX server error codes that originated from
  the load balancer. This does not include any response codes generated by the target
  instance. This metric is reported if there are no healthy instances attached to the load
  balancer, or if the request rate exceeds the capacity of the instances (spillover) or the
  load balancer.  Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
  and Average all return 1.  Unit: The published unit is Count.     InstanceResponseTime  -
  The time elapsed, in seconds, after the request leaves the load balancer until a response
  from the target instance is received.  Statistics: The most useful statistic is Average.
  Unit: The published unit is Seconds.     RejectedConnectionCount  - The number of
  connections that were rejected because the load balancer had reached its maximum number of
  connections.  Statistics: The most useful statistic is Sum.  Unit: The published unit is
  Count.     RequestCount  - The number of requests processed over IPv4. This count includes
  only the requests with a response generated by a target instance of the load balancer.
  Statistics: The most useful statistic is Sum. Note that Minimum, Maximum, and Average all
  return 1.  Unit: The published unit is Count.     UnhealthyHostCount  - The number of
  target instances that are considered unhealthy.  Statistics: The most useful statistic are
  Average, Minimum, and Maximum.  Unit: The published unit is Count.
- `period`: The granularity, in seconds, of the returned data points.
- `start_time`: The start time of the period.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - All values submitted for the matching metric added together.
  You can use this statistic to determine the total volume of a metric.    Average - The
  value of Sum / SampleCount during the specified period. By comparing this statistic with
  the Minimum and Maximum values, you can determine the full scope of a metric and how close
  the average use is to the Minimum and Maximum values. This comparison helps you to know
  when to increase or decrease your resources.    SampleCount - The count, or number, of data
  points used for the statistical calculation.
- `unit`: The unit for the metric data request. Valid units depend on the metric data being
  requested. For the valid units with each available metric, see the metricName parameter.

"""
function get_load_balancer_metric_data(
    endTime,
    loadBalancerName,
    metricName,
    period,
    startTime,
    statistics,
    unit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetLoadBalancerMetricData",
        Dict{String,Any}(
            "endTime" => endTime,
            "loadBalancerName" => loadBalancerName,
            "metricName" => metricName,
            "period" => period,
            "startTime" => startTime,
            "statistics" => statistics,
            "unit" => unit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_load_balancer_metric_data(
    endTime,
    loadBalancerName,
    metricName,
    period,
    startTime,
    statistics,
    unit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetLoadBalancerMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "loadBalancerName" => loadBalancerName,
                    "metricName" => metricName,
                    "period" => period,
                    "startTime" => startTime,
                    "statistics" => statistics,
                    "unit" => unit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_load_balancer_tls_certificates(load_balancer_name)
    get_load_balancer_tls_certificates(load_balancer_name, params::Dict{String,<:Any})

Returns information about the TLS certificates that are associated with the specified
Lightsail load balancer. TLS is just an updated, more secure version of Secure Socket Layer
(SSL). You can have a maximum of 2 certificates associated with a Lightsail load balancer.
One is active and the other is inactive.

# Arguments
- `load_balancer_name`: The name of the load balancer you associated with your SSL/TLS
  certificate.

"""
function get_load_balancer_tls_certificates(
    loadBalancerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetLoadBalancerTlsCertificates",
        Dict{String,Any}("loadBalancerName" => loadBalancerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_load_balancer_tls_certificates(
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetLoadBalancerTlsCertificates",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("loadBalancerName" => loadBalancerName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_load_balancer_tls_policies()
    get_load_balancer_tls_policies(params::Dict{String,<:Any})

Returns a list of TLS security policies that you can apply to Lightsail load balancers. For
more information about load balancer TLS security policies, see Configuring TLS security
policies on your Amazon Lightsail load balancers in the Amazon Lightsail Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetLoadBalancerTlsPolicies request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_load_balancer_tls_policies(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetLoadBalancerTlsPolicies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_load_balancer_tls_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetLoadBalancerTlsPolicies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_load_balancers()
    get_load_balancers(params::Dict{String,<:Any})

Returns information about all load balancers in an account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetLoadBalancers request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_load_balancers(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetLoadBalancers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_load_balancers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetLoadBalancers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_operation(operation_id)
    get_operation(operation_id, params::Dict{String,<:Any})

Returns information about a specific operation. Operations include events such as when you
create an instance, allocate a static IP, attach a static IP, and so on.

# Arguments
- `operation_id`: A GUID used to identify the operation.

"""
function get_operation(operationId; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetOperation",
        Dict{String,Any}("operationId" => operationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_operation(
    operationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetOperation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("operationId" => operationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_operations()
    get_operations(params::Dict{String,<:Any})

Returns information about all operations. Results are returned from oldest to newest, up to
a maximum of 200. Results can be paged by making each subsequent call to GetOperations use
the maximum (last) statusChangedAt value from the previous request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetOperations request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_operations(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetOperations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_operations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetOperations", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_operations_for_resource(resource_name)
    get_operations_for_resource(resource_name, params::Dict{String,<:Any})

Gets operations for a specific resource (an instance or a static IP).

# Arguments
- `resource_name`: The name of the resource for which you are requesting information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetOperationsForResource request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_operations_for_resource(
    resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetOperationsForResource",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_operations_for_resource(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetOperationsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_regions()
    get_regions(params::Dict{String,<:Any})

Returns a list of all valid regions for Amazon Lightsail. Use the include availability
zones parameter to also return the Availability Zones in a region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeAvailabilityZones"`: A Boolean value indicating whether to also include
  Availability Zones in your get regions request. Availability Zones are indicated with a
  letter: us-east-2a.
- `"includeRelationalDatabaseAvailabilityZones"`: A Boolean value indicating whether to
  also include Availability Zones for databases in your get regions request. Availability
  Zones are indicated with a letter (us-east-2a).
"""
function get_regions(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetRegions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_regions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRegions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_relational_database(relational_database_name)
    get_relational_database(relational_database_name, params::Dict{String,<:Any})

Returns information about a specific database in Amazon Lightsail.

# Arguments
- `relational_database_name`: The name of the database that you are looking up.

"""
function get_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_blueprints()
    get_relational_database_blueprints(params::Dict{String,<:Any})

Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes
the major engine version of a database. You can use a blueprint ID to create a new database
that runs a specific database engine.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabaseBlueprints request. If your results
  are paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_database_blueprints(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseBlueprints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_blueprints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseBlueprints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_bundles()
    get_relational_database_bundles(params::Dict{String,<:Any})

Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the
performance specifications for a database. You can use a bundle ID to create a new database
with explicit performance specifications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeInactive"`: A Boolean value that indicates whether to include inactive
  (unavailable) bundles in the response of your request.
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabaseBundles request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_database_bundles(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseBundles";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseBundles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_events(relational_database_name)
    get_relational_database_events(relational_database_name, params::Dict{String,<:Any})

Returns a list of events for a specific database in Amazon Lightsail.

# Arguments
- `relational_database_name`: The name of the database from which to get events.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"durationInMinutes"`: The number of minutes in the past from which to retrieve events.
  For example, to get all events from the past 2 hours, enter 120. Default: 60  The minimum
  is 1 and the maximum is 14 days (20160 minutes).
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabaseEvents request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_database_events(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseEvents",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_events(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseEvents",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_log_events(log_stream_name, relational_database_name)
    get_relational_database_log_events(log_stream_name, relational_database_name, params::Dict{String,<:Any})

Returns a list of log events for a database in Amazon Lightsail.

# Arguments
- `log_stream_name`: The name of the log stream. Use the get relational database log
  streams operation to get a list of available log streams.
- `relational_database_name`: The name of your database for which to get log events.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The end of the time interval from which to get log events. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
  1538424000 as the end time.
- `"pageToken"`: The token to advance to the next or previous page of results from your
  request. To get a page token, perform an initial GetRelationalDatabaseLogEvents request. If
  your results are paginated, the response will return a next forward token and/or next
  backward token that you can specify as the page token in a subsequent request.
- `"startFromHead"`: Parameter to specify if the log should start from head or tail. If
  true is specified, the log event starts from the head of the log. If false is specified,
  the log event starts from the tail of the log.  For PostgreSQL, the default value of false
  is the only option available.
- `"startTime"`: The start of the time interval from which to get log events. Constraints:
   Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
  1538424000 as the start time.
"""
function get_relational_database_log_events(
    logStreamName,
    relationalDatabaseName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseLogEvents",
        Dict{String,Any}(
            "logStreamName" => logStreamName,
            "relationalDatabaseName" => relationalDatabaseName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_log_events(
    logStreamName,
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseLogEvents",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "logStreamName" => logStreamName,
                    "relationalDatabaseName" => relationalDatabaseName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_log_streams(relational_database_name)
    get_relational_database_log_streams(relational_database_name, params::Dict{String,<:Any})

Returns a list of available log streams for a specific database in Amazon Lightsail.

# Arguments
- `relational_database_name`: The name of your database for which to get log streams.

"""
function get_relational_database_log_streams(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseLogStreams",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_log_streams(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseLogStreams",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_master_user_password(relational_database_name)
    get_relational_database_master_user_password(relational_database_name, params::Dict{String,<:Any})

Returns the current, previous, or pending versions of the master user password for a
Lightsail database. The GetRelationalDatabaseMasterUserPassword operation supports
tag-based access control via resource tags applied to the resource identified by
relationalDatabaseName.

# Arguments
- `relational_database_name`: The name of your database for which to get the master user
  password.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"passwordVersion"`: The password version to return. Specifying CURRENT or PREVIOUS
  returns the current or previous passwords respectively. Specifying PENDING returns the
  newest version of the password that will rotate to CURRENT. After the PENDING password
  rotates to CURRENT, the PENDING password is no longer available. Default: CURRENT
"""
function get_relational_database_master_user_password(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseMasterUserPassword",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_master_user_password(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseMasterUserPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_metric_data(end_time, metric_name, period, relational_database_name, start_time, statistics, unit)
    get_relational_database_metric_data(end_time, metric_name, period, relational_database_name, start_time, statistics, unit, params::Dict{String,<:Any})

Returns the data points of the specified metric for a database in Amazon Lightsail. Metrics
report the utilization of your resources, and the error counts generated by them. Monitor
and collect metric data regularly to maintain the reliability, availability, and
performance of your resources.

# Arguments
- `end_time`: The end of the time interval from which to get metric data. Constraints:
  Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
  1538424000 as the end time.
- `metric_name`: The metric for which you want to return information. Valid relational
  database metric names are listed below, along with the most useful statistics to include in
  your request, and the published unit value. All relational database metric data is
  available in 1-minute (60 seconds) granularity.     CPUUtilization  - The percentage of CPU
  utilization currently in use on the database.  Statistics: The most useful statistics are
  Maximum and Average.  Unit: The published unit is Percent.     DatabaseConnections  - The
  number of database connections in use.  Statistics: The most useful statistics are Maximum
  and Sum.  Unit: The published unit is Count.     DiskQueueDepth  - The number of
  outstanding IOs (read/write requests) that are waiting to access the disk.  Statistics: The
  most useful statistic is Sum.  Unit: The published unit is Count.     FreeStorageSpace  -
  The amount of available storage space.  Statistics: The most useful statistic is Sum.
  Unit: The published unit is Bytes.     NetworkReceiveThroughput  - The incoming (Receive)
  network traffic on the database, including both customer database traffic and AWS traffic
  used for monitoring and replication.  Statistics: The most useful statistic is Average.
  Unit: The published unit is Bytes/Second.     NetworkTransmitThroughput  - The outgoing
  (Transmit) network traffic on the database, including both customer database traffic and
  AWS traffic used for monitoring and replication.  Statistics: The most useful statistic is
  Average.  Unit: The published unit is Bytes/Second.
- `period`: The granularity, in seconds, of the returned data points. All relational
  database metric data is available in 1-minute (60 seconds) granularity.
- `relational_database_name`: The name of your database from which to get metric data.
- `start_time`: The start of the time interval from which to get metric data. Constraints:
   Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For
  example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
  1538424000 as the start time.
- `statistics`: The statistic for the metric. The following statistics are available:
  Minimum - The lowest value observed during the specified period. Use this value to
  determine low volumes of activity for your application.    Maximum - The highest value
  observed during the specified period. Use this value to determine high volumes of activity
  for your application.    Sum - All values submitted for the matching metric added together.
  You can use this statistic to determine the total volume of a metric.    Average - The
  value of Sum / SampleCount during the specified period. By comparing this statistic with
  the Minimum and Maximum values, you can determine the full scope of a metric and how close
  the average use is to the Minimum and Maximum values. This comparison helps you to know
  when to increase or decrease your resources.    SampleCount - The count, or number, of data
  points used for the statistical calculation.
- `unit`: The unit for the metric data request. Valid units depend on the metric data being
  requested. For the valid units with each available metric, see the metricName parameter.

"""
function get_relational_database_metric_data(
    endTime,
    metricName,
    period,
    relationalDatabaseName,
    startTime,
    statistics,
    unit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseMetricData",
        Dict{String,Any}(
            "endTime" => endTime,
            "metricName" => metricName,
            "period" => period,
            "relationalDatabaseName" => relationalDatabaseName,
            "startTime" => startTime,
            "statistics" => statistics,
            "unit" => unit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_metric_data(
    endTime,
    metricName,
    period,
    relationalDatabaseName,
    startTime,
    statistics,
    unit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseMetricData",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "metricName" => metricName,
                    "period" => period,
                    "relationalDatabaseName" => relationalDatabaseName,
                    "startTime" => startTime,
                    "statistics" => statistics,
                    "unit" => unit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_parameters(relational_database_name)
    get_relational_database_parameters(relational_database_name, params::Dict{String,<:Any})

Returns all of the runtime parameters offered by the underlying database software, or
engine, for a specific database in Amazon Lightsail. In addition to the parameter names and
values, this operation returns other information about each parameter. This information
includes whether changes require a reboot, whether the parameter is modifiable, the allowed
values, and the data types.

# Arguments
- `relational_database_name`: The name of your database for which to get parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabaseParameters request. If your results
  are paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_database_parameters(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseParameters",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_parameters(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_snapshot(relational_database_snapshot_name)
    get_relational_database_snapshot(relational_database_snapshot_name, params::Dict{String,<:Any})

Returns information about a specific database snapshot in Amazon Lightsail.

# Arguments
- `relational_database_snapshot_name`: The name of the database snapshot for which to get
  information.

"""
function get_relational_database_snapshot(
    relationalDatabaseSnapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseSnapshot",
        Dict{String,Any}(
            "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_snapshot(
    relationalDatabaseSnapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetRelationalDatabaseSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "relationalDatabaseSnapshotName" => relationalDatabaseSnapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_database_snapshots()
    get_relational_database_snapshots(params::Dict{String,<:Any})

Returns information about all of your database snapshots in Amazon Lightsail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabaseSnapshots request. If your results
  are paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_database_snapshots(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseSnapshots";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_relational_database_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabaseSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_relational_databases()
    get_relational_databases(params::Dict{String,<:Any})

Returns information about all of your databases in Amazon Lightsail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetRelationalDatabases request. If your results are
  paginated, the response will return a next page token that you can specify as the page
  token in a subsequent request.
"""
function get_relational_databases(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetRelationalDatabases"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_relational_databases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetRelationalDatabases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_setup_history(resource_name)
    get_setup_history(resource_name, params::Dict{String,<:Any})

Returns detailed information for five of the most recent SetupInstanceHttps requests that
were ran on the target instance.

# Arguments
- `resource_name`: The name of the resource for which you are requesting information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetSetupHistory request. If your results are paginated,
  the response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_setup_history(resourceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetSetupHistory",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_setup_history(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetSetupHistory",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_static_ip(static_ip_name)
    get_static_ip(static_ip_name, params::Dict{String,<:Any})

Returns information about an Amazon Lightsail static IP.

# Arguments
- `static_ip_name`: The name of the static IP in Lightsail.

"""
function get_static_ip(staticIpName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "GetStaticIp",
        Dict{String,Any}("staticIpName" => staticIpName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_static_ip(
    staticIpName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "GetStaticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("staticIpName" => staticIpName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_static_ips()
    get_static_ips(params::Dict{String,<:Any})

Returns information about all static IPs in the user's account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"pageToken"`: The token to advance to the next page of results from your request. To get
  a page token, perform an initial GetStaticIps request. If your results are paginated, the
  response will return a next page token that you can specify as the page token in a
  subsequent request.
"""
function get_static_ips(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("GetStaticIps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_static_ips(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "GetStaticIps", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    import_key_pair(key_pair_name, public_key_base64)
    import_key_pair(key_pair_name, public_key_base64, params::Dict{String,<:Any})

Imports a public SSH key from a specific key pair.

# Arguments
- `key_pair_name`: The name of the key pair for which you want to import the public key.
- `public_key_base64`: A base64-encoded public key of the ssh-rsa type.

"""
function import_key_pair(
    keyPairName, publicKeyBase64; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "ImportKeyPair",
        Dict{String,Any}(
            "keyPairName" => keyPairName, "publicKeyBase64" => publicKeyBase64
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_key_pair(
    keyPairName,
    publicKeyBase64,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "ImportKeyPair",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "keyPairName" => keyPairName, "publicKeyBase64" => publicKeyBase64
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    is_vpc_peered()
    is_vpc_peered(params::Dict{String,<:Any})

Returns a Boolean value indicating whether your Lightsail VPC is peered.

"""
function is_vpc_peered(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("IsVpcPeered"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function is_vpc_peered(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "IsVpcPeered", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    open_instance_public_ports(instance_name, port_info)
    open_instance_public_ports(instance_name, port_info, params::Dict{String,<:Any})

Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses
allowed to connect to the instance through the ports, and the protocol. The
OpenInstancePublicPorts action supports tag-based access control via resource tags applied
to the resource identified by instanceName. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `instance_name`: The name of the instance for which to open ports.
- `port_info`: An object to describe the ports to open for the specified instance.

"""
function open_instance_public_ports(
    instanceName, portInfo; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "OpenInstancePublicPorts",
        Dict{String,Any}("instanceName" => instanceName, "portInfo" => portInfo);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function open_instance_public_ports(
    instanceName,
    portInfo,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "OpenInstancePublicPorts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceName" => instanceName, "portInfo" => portInfo),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    peer_vpc()
    peer_vpc(params::Dict{String,<:Any})

Peers the Lightsail VPC with the user's default VPC.

"""
function peer_vpc(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("PeerVpc"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function peer_vpc(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "PeerVpc", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_alarm(alarm_name, comparison_operator, evaluation_periods, metric_name, monitored_resource_name, threshold)
    put_alarm(alarm_name, comparison_operator, evaluation_periods, metric_name, monitored_resource_name, threshold, params::Dict{String,<:Any})

Creates or updates an alarm, and associates it with the specified metric. An alarm is used
to monitor a single metric for one of your resources. When a metric condition is met, the
alarm can notify you by email, SMS text message, and a banner displayed on the Amazon
Lightsail console. For more information, see Alarms in Amazon Lightsail. When this action
creates an alarm, the alarm state is immediately set to INSUFFICIENT_DATA. The alarm is
then evaluated and its state is set appropriately. Any actions associated with the new
state are then executed. When you update an existing alarm, its state is left unchanged,
but the update completely overwrites the previous configuration of the alarm. The alarm is
then evaluated with the updated configuration.

# Arguments
- `alarm_name`: The name for the alarm. Specify the name of an existing alarm to update,
  and overwrite the previous configuration of the alarm.
- `comparison_operator`: The arithmetic operation to use when comparing the specified
  statistic to the threshold. The specified statistic value is used as the first operand.
- `evaluation_periods`: The number of most recent periods over which data is compared to
  the specified threshold. If you are setting an \"M out of N\" alarm, this value
  (evaluationPeriods) is the N. If you are setting an alarm that requires that a number of
  consecutive data points be breaching to trigger the alarm, this value specifies the rolling
  period of time in which data points are evaluated. Each evaluation period is five minutes
  long. For example, specify an evaluation period of 24 to evaluate a metric over a rolling
  period of two hours. You can specify a minimum valuation period of 1 (5 minutes), and a
  maximum evaluation period of 288 (24 hours).
- `metric_name`: The name of the metric to associate with the alarm. You can configure up
  to two alarms per metric. The following metrics are available for each resource type:
  Instances: BurstCapacityPercentage, BurstCapacityTime, CPUUtilization, NetworkIn,
  NetworkOut, StatusCheckFailed, StatusCheckFailed_Instance, and StatusCheckFailed_System.
  Load balancers: ClientTLSNegotiationErrorCount, HealthyHostCount, UnhealthyHostCount,
  HTTPCode_LB_4XX_Count, HTTPCode_LB_5XX_Count, HTTPCode_Instance_2XX_Count,
  HTTPCode_Instance_3XX_Count, HTTPCode_Instance_4XX_Count, HTTPCode_Instance_5XX_Count,
  InstanceResponseTime, RejectedConnectionCount, and RequestCount.    Relational databases:
  CPUUtilization, DatabaseConnections, DiskQueueDepth, FreeStorageSpace,
  NetworkReceiveThroughput, and NetworkTransmitThroughput.   For more information about these
  metrics, see Metrics available in Lightsail.
- `monitored_resource_name`: The name of the Lightsail resource that will be monitored.
  Instances, load balancers, and relational databases are the only Lightsail resources that
  can currently be monitored by alarms.
- `threshold`: The value against which the specified statistic is compared.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"contactProtocols"`: The contact protocols to use for the alarm, such as Email, SMS
  (text messaging), or both. A notification is sent via the specified contact protocol if
  notifications are enabled for the alarm, and when the alarm is triggered. A notification is
  not sent if a contact protocol is not specified, if the specified contact protocol is not
  configured in the Amazon Web Services Region, or if notifications are not enabled for the
  alarm using the notificationEnabled paramater. Use the CreateContactMethod action to
  configure a contact protocol in an Amazon Web Services Region.
- `"datapointsToAlarm"`: The number of data points that must be not within the specified
  threshold to trigger the alarm. If you are setting an \"M out of N\" alarm, this value
  (datapointsToAlarm) is the M.
- `"notificationEnabled"`: Indicates whether the alarm is enabled. Notifications are
  enabled by default if you don't specify this parameter.
- `"notificationTriggers"`: The alarm states that trigger a notification. An alarm has the
  following possible states:    ALARM - The metric is outside of the defined threshold.
  INSUFFICIENT_DATA - The alarm has just started, the metric is not available, or not enough
  data is available for the metric to determine the alarm state.    OK - The metric is within
  the defined threshold.   When you specify a notification trigger, the ALARM state must be
  specified. The INSUFFICIENT_DATA and OK states can be specified in addition to the ALARM
  state.   If you specify OK as an alarm trigger, a notification is sent when the alarm
  switches from an ALARM or INSUFFICIENT_DATA alarm state to an OK state. This can be thought
  of as an all clear alarm notification.   If you specify INSUFFICIENT_DATA as the alarm
  trigger, a notification is sent when the alarm switches from an OK or ALARM alarm state to
  an INSUFFICIENT_DATA state.   The notification trigger defaults to ALARM if you don't
  specify this parameter.
- `"treatMissingData"`: Sets how this alarm will handle missing data points. An alarm can
  treat missing data in the following ways:    breaching - Assume the missing data is not
  within the threshold. Missing data counts towards the number of times the metric is not
  within the threshold.    notBreaching - Assume the missing data is within the threshold.
  Missing data does not count towards the number of times the metric is not within the
  threshold.    ignore - Ignore the missing data. Maintains the current alarm state.
  missing - Missing data is treated as missing.   If treatMissingData is not specified, the
  default behavior of missing is used.
"""
function put_alarm(
    alarmName,
    comparisonOperator,
    evaluationPeriods,
    metricName,
    monitoredResourceName,
    threshold;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "PutAlarm",
        Dict{String,Any}(
            "alarmName" => alarmName,
            "comparisonOperator" => comparisonOperator,
            "evaluationPeriods" => evaluationPeriods,
            "metricName" => metricName,
            "monitoredResourceName" => monitoredResourceName,
            "threshold" => threshold,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_alarm(
    alarmName,
    comparisonOperator,
    evaluationPeriods,
    metricName,
    monitoredResourceName,
    threshold,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "PutAlarm",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "alarmName" => alarmName,
                    "comparisonOperator" => comparisonOperator,
                    "evaluationPeriods" => evaluationPeriods,
                    "metricName" => metricName,
                    "monitoredResourceName" => monitoredResourceName,
                    "threshold" => threshold,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_instance_public_ports(instance_name, port_infos)
    put_instance_public_ports(instance_name, port_infos, params::Dict{String,<:Any})

Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses
allowed to connect to the instance through the ports, and the protocol. This action also
closes all currently open ports that are not included in the request. Include all of the
ports and the protocols you want to open in your PutInstancePublicPortsrequest. Or use the
OpenInstancePublicPorts action to open ports without closing currently open ports. The
PutInstancePublicPorts action supports tag-based access control via resource tags applied
to the resource identified by instanceName. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `instance_name`: The name of the instance for which to open ports.
- `port_infos`: An array of objects to describe the ports to open for the specified
  instance.

"""
function put_instance_public_ports(
    instanceName, portInfos; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "PutInstancePublicPorts",
        Dict{String,Any}("instanceName" => instanceName, "portInfos" => portInfos);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_instance_public_ports(
    instanceName,
    portInfos,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "PutInstancePublicPorts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceName" => instanceName, "portInfos" => portInfos),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_instance(instance_name)
    reboot_instance(instance_name, params::Dict{String,<:Any})

Restarts a specific instance. The reboot instance operation supports tag-based access
control via resource tags applied to the resource identified by instance name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance to reboot.

"""
function reboot_instance(instanceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "RebootInstance",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_instance(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "RebootInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_relational_database(relational_database_name)
    reboot_relational_database(relational_database_name, params::Dict{String,<:Any})

Restarts a specific database in Amazon Lightsail. The reboot relational database operation
supports tag-based access control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `relational_database_name`: The name of your database to reboot.

"""
function reboot_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "RebootRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "RebootRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_container_image(digest, label, service_name)
    register_container_image(digest, label, service_name, params::Dict{String,<:Any})

Registers a container image to your Amazon Lightsail container service.  This action is not
required if you install and use the Lightsail Control (lightsailctl) plugin to push
container images to your Lightsail container service. For more information, see Pushing and
managing container images on your Amazon Lightsail container services in the Amazon
Lightsail Developer Guide.

# Arguments
- `digest`: The digest of the container image to be registered.
- `label`: The label for the container image when it's registered to the container service.
  Use a descriptive label that you can use to track the different versions of your registered
  container images. Use the GetContainerImages action to return the container images
  registered to a Lightsail container service. The label is the &lt;imagelabel&gt; portion of
  the following image name example:    :container-service-1.&lt;imagelabel&gt;.1    If the
  name of your container service is mycontainerservice, and the label that you specify is
  mystaticwebsite, then the name of the registered container image will be
  :mycontainerservice.mystaticwebsite.1. The number at the end of these image name examples
  represents the version of the registered container image. If you push and register another
  container image to the same Lightsail container service, with the same label, then the
  version number for the new registered container image will be 2. If you push and register
  another container image, the version number will be 3, and so on.
- `service_name`: The name of the container service for which to register a container image.

"""
function register_container_image(
    digest, label, serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "RegisterContainerImage",
        Dict{String,Any}(
            "digest" => digest, "label" => label, "serviceName" => serviceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_container_image(
    digest,
    label,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "RegisterContainerImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "digest" => digest, "label" => label, "serviceName" => serviceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    release_static_ip(static_ip_name)
    release_static_ip(static_ip_name, params::Dict{String,<:Any})

Deletes a specific static IP from your account.

# Arguments
- `static_ip_name`: The name of the static IP to delete.

"""
function release_static_ip(staticIpName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "ReleaseStaticIp",
        Dict{String,Any}("staticIpName" => staticIpName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function release_static_ip(
    staticIpName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "ReleaseStaticIp",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("staticIpName" => staticIpName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_distribution_cache()
    reset_distribution_cache(params::Dict{String,<:Any})

Deletes currently cached content from your Amazon Lightsail content delivery network (CDN)
distribution. After resetting the cache, the next time a content request is made, your
distribution pulls, serves, and caches it from the origin.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"distributionName"`: The name of the distribution for which to reset cache. Use the
  GetDistributions action to get a list of distribution names that you can specify.
"""
function reset_distribution_cache(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "ResetDistributionCache"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function reset_distribution_cache(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "ResetDistributionCache",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_contact_method_verification(protocol)
    send_contact_method_verification(protocol, params::Dict{String,<:Any})

Sends a verification request to an email contact method to ensure it's owned by the
requester. SMS contact methods don't need to be verified. A contact method is used to send
you notifications about your Amazon Lightsail resources. You can add one email address and
one mobile phone number contact method in each Amazon Web Services Region. However, SMS
text messaging is not supported in some Amazon Web Services Regions, and SMS text messages
cannot be sent to some countries/regions. For more information, see Notifications in Amazon
Lightsail. A verification request is sent to the contact method when you initially create
it. Use this action to send another verification request if a previous verification request
was deleted, or has expired.  Notifications are not sent to an email contact method until
after it is verified, and confirmed as valid.

# Arguments
- `protocol`: The protocol to verify, such as Email or SMS (text messaging).

"""
function send_contact_method_verification(
    protocol; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "SendContactMethodVerification",
        Dict{String,Any}("protocol" => protocol);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_contact_method_verification(
    protocol,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SendContactMethodVerification",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("protocol" => protocol), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_ip_address_type(ip_address_type, resource_name, resource_type)
    set_ip_address_type(ip_address_type, resource_name, resource_type, params::Dict{String,<:Any})

Sets the IP address type for an Amazon Lightsail resource. Use this action to enable
dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource.
Alternately, you can use this action to disable dual-stack, and enable IPv4 only.

# Arguments
- `ip_address_type`: The IP address type to set for the specified resource. The possible
  values are ipv4 for IPv4 only, ipv6 for IPv6 only, and dualstack for IPv4 and IPv6.
- `resource_name`: The name of the resource for which to set the IP address type.
- `resource_type`: The resource type. The resource values are Distribution, Instance, and
  LoadBalancer.  Distribution-related APIs are available only in the N. Virginia (us-east-1)
  Amazon Web Services Region. Set your Amazon Web Services Region configuration to us-east-1
  to create, view, or edit distributions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"acceptBundleUpdate"`: Required parameter to accept the instance bundle update when
  changing to, and from, IPv6-only.  An instance bundle will change when switching from
  dual-stack or ipv4, to ipv6. It also changes when switching from ipv6, to dual-stack or
  ipv4. You must include this parameter in the command to update the bundle. For example, if
  you switch from dual-stack to ipv6, the bundle will be updated, and billing for the
  IPv6-only instance bundle begins immediately.
"""
function set_ip_address_type(
    ipAddressType,
    resourceName,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SetIpAddressType",
        Dict{String,Any}(
            "ipAddressType" => ipAddressType,
            "resourceName" => resourceName,
            "resourceType" => resourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_ip_address_type(
    ipAddressType,
    resourceName,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SetIpAddressType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ipAddressType" => ipAddressType,
                    "resourceName" => resourceName,
                    "resourceType" => resourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_resource_access_for_bucket(access, bucket_name, resource_name)
    set_resource_access_for_bucket(access, bucket_name, resource_name, params::Dict{String,<:Any})

Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
Lightsail buckets currently support setting access for Lightsail instances in the same
Amazon Web Services Region.

# Arguments
- `access`: The access setting. The following access settings are available:    allow -
  Allows access to the bucket and its objects.    deny - Denies access to the bucket and its
  objects. Use this setting to remove access for a resource previously set to allow.
- `bucket_name`: The name of the bucket for which to set access to another Lightsail
  resource.
- `resource_name`: The name of the Lightsail instance for which to set bucket access. The
  instance must be in a running or stopped state.

"""
function set_resource_access_for_bucket(
    access, bucketName, resourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "SetResourceAccessForBucket",
        Dict{String,Any}(
            "access" => access, "bucketName" => bucketName, "resourceName" => resourceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_resource_access_for_bucket(
    access,
    bucketName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SetResourceAccessForBucket",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "access" => access,
                    "bucketName" => bucketName,
                    "resourceName" => resourceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    setup_instance_https(certificate_provider, domain_names, email_address, instance_name)
    setup_instance_https(certificate_provider, domain_names, email_address, instance_name, params::Dict{String,<:Any})

Creates an SSL/TLS certificate that secures traffic for your website. After the certificate
is created, it is installed on the specified Lightsail instance. If you provide more than
one domain name in the request, at least one name must be less than or equal to 63
characters in length.

# Arguments
- `certificate_provider`: The certificate authority that issues the SSL/TLS certificate.
- `domain_names`: The name of the domain and subdomains that were specified for the SSL/TLS
  certificate.
- `email_address`: The contact method for SSL/TLS certificate renewal alerts. You can enter
  one email address.
- `instance_name`: The name of the Lightsail instance.

"""
function setup_instance_https(
    certificateProvider,
    domainNames,
    emailAddress,
    instanceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SetupInstanceHttps",
        Dict{String,Any}(
            "certificateProvider" => certificateProvider,
            "domainNames" => domainNames,
            "emailAddress" => emailAddress,
            "instanceName" => instanceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function setup_instance_https(
    certificateProvider,
    domainNames,
    emailAddress,
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "SetupInstanceHttps",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateProvider" => certificateProvider,
                    "domainNames" => domainNames,
                    "emailAddress" => emailAddress,
                    "instanceName" => instanceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_guisession(resource_name)
    start_guisession(resource_name, params::Dict{String,<:Any})

Initiates a graphical user interface (GUI) session that’s used to access a virtual
computer’s operating system and application. The session will be active for 1 hour. Use
this action to resume the session after it expires.

# Arguments
- `resource_name`: The resource name.

"""
function start_guisession(resourceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "StartGUISession",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_guisession(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StartGUISession",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_instance(instance_name)
    start_instance(instance_name, params::Dict{String,<:Any})

Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance,
use the reboot instance operation.  When you start a stopped instance, Lightsail assigns a
new public IP address to the instance. To use the same IP address after stopping and
starting an instance, create a static IP address and attach it to the instance. For more
information, see the Amazon Lightsail Developer Guide.  The start instance operation
supports tag-based access control via resource tags applied to the resource identified by
instance name. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance (a virtual private server) to start.

"""
function start_instance(instanceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "StartInstance",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_instance(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StartInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_relational_database(relational_database_name)
    start_relational_database(relational_database_name, params::Dict{String,<:Any})

Starts a specific database from a stopped state in Amazon Lightsail. To restart a database,
use the reboot relational database operation. The start relational database operation
supports tag-based access control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `relational_database_name`: The name of your database to start.

"""
function start_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "StartRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StartRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_guisession(resource_name)
    stop_guisession(resource_name, params::Dict{String,<:Any})

Terminates a web-based NICE DCV session that’s used to access a virtual computer’s
operating system or application. The session will close and any unsaved data will be lost.

# Arguments
- `resource_name`: The resource name.

"""
function stop_guisession(resourceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "StopGUISession",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_guisession(
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StopGUISession",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_instance(instance_name)
    stop_instance(instance_name, params::Dict{String,<:Any})

Stops a specific Amazon Lightsail instance that is currently running.  When you start a
stopped instance, Lightsail assigns a new public IP address to the instance. To use the
same IP address after stopping and starting an instance, create a static IP address and
attach it to the instance. For more information, see the Amazon Lightsail Developer Guide.
The stop instance operation supports tag-based access control via resource tags applied to
the resource identified by instance name. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `instance_name`: The name of the instance (a virtual private server) to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: When set to True, forces a Lightsail instance that is stuck in a stopping
  state to stop.  Only use the force parameter if your instance is stuck in the stopping
  state. In any other state, your instance should stop normally without adding this parameter
  to your API request.
"""
function stop_instance(instanceName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "StopInstance",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_instance(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StopInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_relational_database(relational_database_name)
    stop_relational_database(relational_database_name, params::Dict{String,<:Any})

Stops a specific database that is currently running in Amazon Lightsail. The stop
relational database operation supports tag-based access control via resource tags applied
to the resource identified by relationalDatabaseName. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `relational_database_name`: The name of your database to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"relationalDatabaseSnapshotName"`: The name of your new database snapshot to be created
  before stopping your database.
"""
function stop_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "StopRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "StopRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_name, tags)
    tag_resource(resource_name, tags, params::Dict{String,<:Any})

Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a
maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be
unique per resource. For more information about tags, see the Amazon Lightsail Developer
Guide. The tag resource operation supports tag-based access control via request tags and
resource tags applied to the resource identified by resource name. For more information,
see the Amazon Lightsail Developer Guide.

# Arguments
- `resource_name`: The name of the resource to which you are adding tags.
- `tags`: The tag key and optional value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceArn"`: The Amazon Resource Name (ARN) of the resource to which you want to add
  a tag.
"""
function tag_resource(
    resourceName, tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "TagResource",
        Dict{String,Any}("resourceName" => resourceName, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceName,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceName" => resourceName, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_alarm(alarm_name, state)
    test_alarm(alarm_name, state, params::Dict{String,<:Any})

Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification
trigger is configured for the specified alarm, the test also sends a notification to the
notification protocol (Email and/or SMS) configured for the alarm. An alarm is used to
monitor a single metric for one of your resources. When a metric condition is met, the
alarm can notify you by email, SMS text message, and a banner displayed on the Amazon
Lightsail console. For more information, see Alarms in Amazon Lightsail.

# Arguments
- `alarm_name`: The name of the alarm to test.
- `state`: The alarm state to test. An alarm has the following possible states that can be
  tested:    ALARM - The metric is outside of the defined threshold.    INSUFFICIENT_DATA -
  The alarm has just started, the metric is not available, or not enough data is available
  for the metric to determine the alarm state.    OK - The metric is within the defined
  threshold.

"""
function test_alarm(alarmName, state; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "TestAlarm",
        Dict{String,Any}("alarmName" => alarmName, "state" => state);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_alarm(
    alarmName,
    state,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "TestAlarm",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("alarmName" => alarmName, "state" => state), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unpeer_vpc()
    unpeer_vpc(params::Dict{String,<:Any})

Unpeers the Lightsail VPC from the user's default VPC.

"""
function unpeer_vpc(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail("UnpeerVpc"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function unpeer_vpc(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UnpeerVpc", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    untag_resource(resource_name, tag_keys)
    untag_resource(resource_name, tag_keys, params::Dict{String,<:Any})

Deletes the specified set of tag keys and their values from the specified Amazon Lightsail
resource. The untag resource operation supports tag-based access control via request tags
and resource tags applied to the resource identified by resource name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `resource_name`: The name of the resource from which you are removing a tag.
- `tag_keys`: The tag keys to delete from the specified resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceArn"`: The Amazon Resource Name (ARN) of the resource from which you want to
  remove a tag.
"""
function untag_resource(
    resourceName, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UntagResource",
        Dict{String,Any}("resourceName" => resourceName, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceName,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceName" => resourceName, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_bucket(bucket_name)
    update_bucket(bucket_name, params::Dict{String,<:Any})

Updates an existing Amazon Lightsail bucket. Use this action to update the configuration of
an existing bucket, such as versioning, public accessibility, and the Amazon Web Services
accounts that can access the bucket.

# Arguments
- `bucket_name`: The name of the bucket to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accessLogConfig"`: An object that describes the access log configuration for the bucket.
- `"accessRules"`: An object that sets the public accessibility of objects in the specified
  bucket.
- `"readonlyAccessAccounts"`: An array of strings to specify the Amazon Web Services
  account IDs that can access the bucket. You can give a maximum of 10 Amazon Web Services
  accounts access to a bucket.
- `"versioning"`: Specifies whether to enable or suspend versioning of objects in the
  bucket. The following options can be specified:    Enabled - Enables versioning of objects
  in the specified bucket.    Suspended - Suspends versioning of objects in the specified
  bucket. Existing object versions are retained.
"""
function update_bucket(bucketName; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "UpdateBucket",
        Dict{String,Any}("bucketName" => bucketName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_bucket(
    bucketName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateBucket",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("bucketName" => bucketName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_bucket_bundle(bucket_name, bundle_id)
    update_bucket_bundle(bucket_name, bundle_id, params::Dict{String,<:Any})

Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket. A bucket
bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You
can update a bucket's bundle only one time within a monthly Amazon Web Services billing
cycle. To determine if you can update a bucket's bundle, use the GetBuckets action. The
ableToUpdateBundle parameter in the response will indicate whether you can currently update
a bucket's bundle. Update a bucket's bundle if it's consistently going over its storage
space or data transfer quota, or if a bucket's usage is consistently in the lower range of
its storage space or data transfer quota. Due to the unpredictable usage fluctuations that
a bucket might experience, we strongly recommend that you update a bucket's bundle only as
a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a
bucket bundle that will provide the bucket with ample storage space and data transfer for a
long time to come.

# Arguments
- `bucket_name`: The name of the bucket for which to update the bundle.
- `bundle_id`: The ID of the new bundle to apply to the bucket. Use the GetBucketBundles
  action to get a list of bundle IDs that you can specify.

"""
function update_bucket_bundle(
    bucketName, bundleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateBucketBundle",
        Dict{String,Any}("bucketName" => bucketName, "bundleId" => bundleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_bucket_bundle(
    bucketName,
    bundleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateBucketBundle",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("bucketName" => bucketName, "bundleId" => bundleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_container_service(service_name)
    update_container_service(service_name, params::Dict{String,<:Any})

Updates the configuration of your Amazon Lightsail container service, such as its power,
scale, and public domain names.

# Arguments
- `service_name`: The name of the container service to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"isDisabled"`: A Boolean value to indicate whether the container service is disabled.
- `"power"`: The power for the container service. The power specifies the amount of memory,
  vCPUs, and base monthly cost of each node of the container service. The power and scale of
  a container service makes up its configured capacity. To determine the monthly price of
  your container service, multiply the base price of the power with the scale (the number of
  nodes) of the service. Use the GetContainerServicePowers action to view the specifications
  of each power option.
- `"privateRegistryAccess"`: An object to describe the configuration for the container
  service to access private container image repositories, such as Amazon Elastic Container
  Registry (Amazon ECR) private repositories. For more information, see Configuring access to
  an Amazon ECR private repository for an Amazon Lightsail container service in the Amazon
  Lightsail Developer Guide.
- `"publicDomainNames"`: The public domain names to use with the container service, such as
  example.com and www.example.com. You can specify up to four public domain names for a
  container service. The domain names that you specify are used when you create a deployment
  with a container configured as the public endpoint of your container service. If you don't
  specify public domain names, then you can use the default domain of the container service.
  You must create and validate an SSL/TLS certificate before you can use public domain names
  with your container service. Use the CreateCertificate action to create a certificate for
  the public domain names you want to use with your container service.  You can specify
  public domain names using a string to array map as shown in the example later on this page.
- `"scale"`: The scale for the container service. The scale specifies the allocated compute
  nodes of the container service. The power and scale of a container service makes up its
  configured capacity. To determine the monthly price of your container service, multiply the
  base price of the power with the scale (the number of nodes) of the service.
"""
function update_container_service(
    serviceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateContainerService",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_container_service(
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateContainerService",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_distribution(distribution_name)
    update_distribution(distribution_name, params::Dict{String,<:Any})

Updates an existing Amazon Lightsail content delivery network (CDN) distribution. Use this
action to update the configuration of your existing distribution.

# Arguments
- `distribution_name`: The name of the distribution to update. Use the GetDistributions
  action to get a list of distribution names that you can specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cacheBehaviorSettings"`: An object that describes the cache behavior settings for the
  distribution.  The cacheBehaviorSettings specified in your UpdateDistributionRequest will
  replace your distribution's existing settings.
- `"cacheBehaviors"`: An array of objects that describe the per-path cache behavior for the
  distribution.
- `"certificateName"`: The name of the SSL/TLS certificate that you want to attach to the
  distribution. Only certificates with a status of ISSUED can be attached to a distribution.
  Use the GetCertificates action to get a list of certificate names that you can specify.
- `"defaultCacheBehavior"`: An object that describes the default cache behavior for the
  distribution.
- `"isEnabled"`: Indicates whether to enable the distribution.
- `"origin"`: An object that describes the origin resource for the distribution, such as a
  Lightsail instance, bucket, or load balancer. The distribution pulls, caches, and serves
  content from the origin.
- `"useDefaultCertificate"`: Indicates whether the default SSL/TLS certificate is attached
  to the distribution. The default value is true. When true, the distribution uses the
  default domain name such as d111111abcdef8.cloudfront.net.  Set this value to false to
  attach a new certificate to the distribution.
- `"viewerMinimumTlsProtocolVersion"`: Use this parameter to update the minimum TLS
  protocol version for the SSL/TLS certificate that's attached to the distribution.
"""
function update_distribution(
    distributionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateDistribution",
        Dict{String,Any}("distributionName" => distributionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_distribution(
    distributionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateDistribution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("distributionName" => distributionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_distribution_bundle()
    update_distribution_bundle(params::Dict{String,<:Any})

Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution. A
distribution bundle specifies the monthly network transfer quota and monthly cost of your
distribution. Update your distribution's bundle if your distribution is going over its
monthly network transfer quota and is incurring an overage fee. You can update your
distribution's bundle only one time within your monthly Amazon Web Services billing cycle.
To determine if you can update your distribution's bundle, use the GetDistributions action.
The ableToUpdateBundle parameter in the result will indicate whether you can currently
update your distribution's bundle.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"bundleId"`: The bundle ID of the new bundle to apply to your distribution. Use the
  GetDistributionBundles action to get a list of distribution bundle IDs that you can specify.
- `"distributionName"`: The name of the distribution for which to update the bundle. Use
  the GetDistributions action to get a list of distribution names that you can specify.
"""
function update_distribution_bundle(; aws_config::AbstractAWSConfig=current_aws_config())
    return lightsail(
        "UpdateDistributionBundle"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_distribution_bundle(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateDistributionBundle",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_entry(domain_entry, domain_name)
    update_domain_entry(domain_entry, domain_name, params::Dict{String,<:Any})

Updates a domain recordset after it is created. The update domain entry operation supports
tag-based access control via resource tags applied to the resource identified by domain
name. For more information, see the Amazon Lightsail Developer Guide.

# Arguments
- `domain_entry`: An array of key-value pairs containing information about the domain entry.
- `domain_name`: The name of the domain recordset to update.

"""
function update_domain_entry(
    domainEntry, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateDomainEntry",
        Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_entry(
    domainEntry,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateDomainEntry",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domainEntry" => domainEntry, "domainName" => domainName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_instance_metadata_options(instance_name)
    update_instance_metadata_options(instance_name, params::Dict{String,<:Any})

Modifies the Amazon Lightsail instance metadata parameters on a running or stopped
instance. When you modify the parameters on a running instance, the GetInstance or
GetInstances API operation initially responds with a state of pending. After the parameter
modifications are successfully applied, the state changes to applied in subsequent
GetInstance or GetInstances API calls. For more information, see Use IMDSv2 with an Amazon
Lightsail instance in the Amazon Lightsail Developer Guide.

# Arguments
- `instance_name`: The name of the instance for which to update metadata parameters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"httpEndpoint"`: Enables or disables the HTTP metadata endpoint on your instances. If
  this parameter is not specified, the existing state is maintained. If you specify a value
  of disabled, you cannot access your instance metadata.
- `"httpProtocolIpv6"`: Enables or disables the IPv6 endpoint for the instance metadata
  service. This setting applies only when the HTTP metadata endpoint is enabled.  This
  parameter is available only for instances in the Europe (Stockholm) Amazon Web Services
  Region (eu-north-1).
- `"httpPutResponseHopLimit"`: The desired HTTP PUT response hop limit for instance
  metadata requests. A larger number means that the instance metadata requests can travel
  farther. If no parameter is specified, the existing state is maintained.
- `"httpTokens"`: The state of token usage for your instance metadata requests. If the
  parameter is not specified in the request, the default state is optional. If the state is
  optional, you can choose whether to retrieve instance metadata with a signed token header
  on your request. If you retrieve the IAM role credentials without a token, the version 1.0
  role credentials are returned. If you retrieve the IAM role credentials by using a valid
  signed token, the version 2.0 role credentials are returned. If the state is required, you
  must send a signed token header with all instance metadata retrieval requests. In this
  state, retrieving the IAM role credential always returns the version 2.0 credentials. The
  version 1.0 credentials are not available.
"""
function update_instance_metadata_options(
    instanceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateInstanceMetadataOptions",
        Dict{String,Any}("instanceName" => instanceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_instance_metadata_options(
    instanceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateInstanceMetadataOptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("instanceName" => instanceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_load_balancer_attribute(attribute_name, attribute_value, load_balancer_name)
    update_load_balancer_attribute(attribute_name, attribute_value, load_balancer_name, params::Dict{String,<:Any})

Updates the specified attribute for a load balancer. You can only update one attribute at a
time. The update load balancer attribute operation supports tag-based access control via
resource tags applied to the resource identified by load balancer name. For more
information, see the Amazon Lightsail Developer Guide.

# Arguments
- `attribute_name`: The name of the attribute you want to update.
- `attribute_value`: The value that you want to specify for the attribute name. The
  following values are supported depending on what you specify for the attributeName request
  parameter:   If you specify HealthCheckPath for the attributeName request parameter, then
  the attributeValue request parameter must be the path to ping on the target (for example,
  /weather/us/wa/seattle).   If you specify SessionStickinessEnabled for the attributeName
  request parameter, then the attributeValue request parameter must be true to activate
  session stickiness or false to deactivate session stickiness.   If you specify
  SessionStickiness_LB_CookieDurationSeconds for the attributeName request parameter, then
  the attributeValue request parameter must be an interger that represents the cookie
  duration in seconds.   If you specify HttpsRedirectionEnabled for the attributeName request
  parameter, then the attributeValue request parameter must be true to activate HTTP to HTTPS
  redirection or false to deactivate HTTP to HTTPS redirection.   If you specify
  TlsPolicyName for the attributeName request parameter, then the attributeValue request
  parameter must be the name of the TLS policy. Use the GetLoadBalancerTlsPolicies action to
  get a list of TLS policy names that you can specify.
- `load_balancer_name`: The name of the load balancer that you want to modify
  (my-load-balancer.

"""
function update_load_balancer_attribute(
    attributeName,
    attributeValue,
    loadBalancerName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateLoadBalancerAttribute",
        Dict{String,Any}(
            "attributeName" => attributeName,
            "attributeValue" => attributeValue,
            "loadBalancerName" => loadBalancerName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_load_balancer_attribute(
    attributeName,
    attributeValue,
    loadBalancerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateLoadBalancerAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "attributeName" => attributeName,
                    "attributeValue" => attributeValue,
                    "loadBalancerName" => loadBalancerName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_relational_database(relational_database_name)
    update_relational_database(relational_database_name, params::Dict{String,<:Any})

Allows the update of one or more attributes of a database in Amazon Lightsail. Updates are
applied immediately, or in cases where the updates could result in an outage, are applied
during the database's predefined maintenance window. The update relational database
operation supports tag-based access control via resource tags applied to the resource
identified by relationalDatabaseName. For more information, see the Amazon Lightsail
Developer Guide.

# Arguments
- `relational_database_name`: The name of your Lightsail database resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applyImmediately"`: When true, applies changes immediately. When false, applies changes
  during the preferred maintenance window. Some changes may cause an outage. Default: false
- `"caCertificateIdentifier"`: Indicates the certificate that needs to be associated with
  the database.
- `"disableBackupRetention"`: When true, disables automated backup retention for your
  database. Disabling backup retention deletes all automated database backups. Before
  disabling this, you may want to create a snapshot of your database using the create
  relational database snapshot operation. Updates are applied during the next maintenance
  window because this can result in an outage.
- `"enableBackupRetention"`: When true, enables automated backup retention for your
  database. Updates are applied during the next maintenance window because this can result in
  an outage.
- `"masterUserPassword"`: The password for the master user. The password can include any
  printable ASCII character except \"/\", \"\"\", or \"@\". MySQL  Constraints: Must contain
  from 8 to 41 characters.  PostgreSQL  Constraints: Must contain from 8 to 128 characters.
- `"preferredBackupWindow"`: The daily time range during which automated backups are
  created for your database if automated backups are enabled. Constraints:   Must be in the
  hh24:mi-hh24:mi format. Example: 16:00-16:30    Specified in Coordinated Universal Time
  (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30
  minutes.
- `"preferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur on your database. The default is a 30-minute window selected at random from an 8-hour
  block of time for each Amazon Web Services Region, occurring on a random day of the week.
  Constraints:   Must be in the ddd:hh24:mi-ddd:hh24:mi format.   Valid days: Mon, Tue, Wed,
  Thu, Fri, Sat, Sun.   Must be at least 30 minutes.   Specified in Coordinated Universal
  Time (UTC).   Example: Tue:17:00-Tue:17:30
- `"publiclyAccessible"`: Specifies the accessibility options for your database. A value of
  true specifies a database that is available to resources outside of your Lightsail account.
  A value of false specifies a database that is available only to your Lightsail resources in
  the same region as your database.
- `"relationalDatabaseBlueprintId"`: This parameter is used to update the major version of
  the database. Enter the blueprintId for the major version that you want to update to. Use
  the GetRelationalDatabaseBlueprints action to get a list of available blueprint IDs.
- `"rotateMasterUserPassword"`: When true, the master user password is changed to a new
  strong password generated by Lightsail. Use the get relational database master user
  password operation to get the new password.
"""
function update_relational_database(
    relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateRelationalDatabase",
        Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_relational_database(
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateRelationalDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("relationalDatabaseName" => relationalDatabaseName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_relational_database_parameters(parameters, relational_database_name)
    update_relational_database_parameters(parameters, relational_database_name, params::Dict{String,<:Any})

Allows the update of one or more parameters of a database in Amazon Lightsail. Parameter
updates don't cause outages; therefore, their application is not subject to the preferred
maintenance window. However, there are two ways in which parameter updates are applied:
dynamic or pending-reboot. Parameters marked with a dynamic apply type are applied
immediately. Parameters marked with a pending-reboot apply type are applied only after the
database is rebooted using the reboot relational database operation. The update relational
database parameters operation supports tag-based access control via resource tags applied
to the resource identified by relationalDatabaseName. For more information, see the Amazon
Lightsail Developer Guide.

# Arguments
- `parameters`: The database parameters to update.
- `relational_database_name`: The name of your database for which to update parameters.

"""
function update_relational_database_parameters(
    parameters, relationalDatabaseName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lightsail(
        "UpdateRelationalDatabaseParameters",
        Dict{String,Any}(
            "parameters" => parameters, "relationalDatabaseName" => relationalDatabaseName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_relational_database_parameters(
    parameters,
    relationalDatabaseName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lightsail(
        "UpdateRelationalDatabaseParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "parameters" => parameters,
                    "relationalDatabaseName" => relationalDatabaseName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
