# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lookoutmetrics
using AWS.Compat
using AWS.UUIDs

"""
    activate_anomaly_detector(anomaly_detector_arn)
    activate_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Activates an anomaly detector.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector.

"""
function activate_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/ActivateAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ActivateAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    back_test_anomaly_detector(anomaly_detector_arn)
    back_test_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Runs a backtest for anomaly detection for the specified resource.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.

"""
function back_test_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/BackTestAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function back_test_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/BackTestAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_alert(action, alert_name, anomaly_detector_arn)
    create_alert(action, alert_name, anomaly_detector_arn, params::Dict{String,<:Any})

Creates an alert for an anomaly detector.

# Arguments
- `action`: Action that will be triggered when there is an alert.
- `alert_name`: The name of the alert.
- `anomaly_detector_arn`: The ARN of the detector to which the alert is attached.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlertDescription"`: A description of the alert.
- `"AlertFilters"`: The configuration of the alert filters, containing MetricList and
  DimensionFilterList.
- `"AlertSensitivityThreshold"`: An integer from 0 to 100 specifying the alert sensitivity
  threshold.
- `"Tags"`: A list of tags to apply to the alert.
"""
function create_alert(
    Action,
    AlertName,
    AnomalyDetectorArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateAlert",
        Dict{String,Any}(
            "Action" => Action,
            "AlertName" => AlertName,
            "AnomalyDetectorArn" => AnomalyDetectorArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_alert(
    Action,
    AlertName,
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateAlert",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Action" => Action,
                    "AlertName" => AlertName,
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_anomaly_detector(anomaly_detector_config, anomaly_detector_name)
    create_anomaly_detector(anomaly_detector_config, anomaly_detector_name, params::Dict{String,<:Any})

Creates an anomaly detector.

# Arguments
- `anomaly_detector_config`: Contains information about the configuration of the anomaly
  detector.
- `anomaly_detector_name`: The name of the detector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnomalyDetectorDescription"`: A description of the detector.
- `"KmsKeyArn"`: The ARN of the KMS key to use to encrypt your data.
- `"Tags"`: A list of tags to apply to the anomaly detector.
"""
function create_anomaly_detector(
    AnomalyDetectorConfig,
    AnomalyDetectorName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateAnomalyDetector",
        Dict{String,Any}(
            "AnomalyDetectorConfig" => AnomalyDetectorConfig,
            "AnomalyDetectorName" => AnomalyDetectorName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_anomaly_detector(
    AnomalyDetectorConfig,
    AnomalyDetectorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorConfig" => AnomalyDetectorConfig,
                    "AnomalyDetectorName" => AnomalyDetectorName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_metric_set(anomaly_detector_arn, metric_list, metric_set_name, metric_source)
    create_metric_set(anomaly_detector_arn, metric_list, metric_set_name, metric_source, params::Dict{String,<:Any})

Creates a dataset.

# Arguments
- `anomaly_detector_arn`: The ARN of the anomaly detector that will use the dataset.
- `metric_list`: A list of metrics that the dataset will contain.
- `metric_set_name`: The name of the dataset.
- `metric_source`: Contains information about how the source data should be interpreted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DimensionFilterList"`: A list of filters that specify which data is kept for anomaly
  detection.
- `"DimensionList"`: A list of the fields you want to treat as dimensions.
- `"MetricSetDescription"`: A description of the dataset you are creating.
- `"MetricSetFrequency"`: The frequency with which the source data will be analyzed for
  anomalies.
- `"Offset"`: After an interval ends, the amount of seconds that the detector waits before
  importing data. Offset is only supported for S3, Redshift, Athena and datasources.
- `"Tags"`: A list of tags to apply to the dataset.
- `"TimestampColumn"`: Contains information about the column used for tracking time in your
  source data.
- `"Timezone"`: The time zone in which your source data was recorded.
"""
function create_metric_set(
    AnomalyDetectorArn,
    MetricList,
    MetricSetName,
    MetricSource;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateMetricSet",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "MetricList" => MetricList,
            "MetricSetName" => MetricSetName,
            "MetricSource" => MetricSource,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_metric_set(
    AnomalyDetectorArn,
    MetricList,
    MetricSetName,
    MetricSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/CreateMetricSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "MetricList" => MetricList,
                    "MetricSetName" => MetricSetName,
                    "MetricSource" => MetricSource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_anomaly_detector(anomaly_detector_arn)
    deactivate_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Deactivates an anomaly detector.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.

"""
function deactivate_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/DeactivateAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DeactivateAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_alert(alert_arn)
    delete_alert(alert_arn, params::Dict{String,<:Any})

Deletes an alert.

# Arguments
- `alert_arn`: The ARN of the alert to delete.

"""
function delete_alert(AlertArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/DeleteAlert",
        Dict{String,Any}("AlertArn" => AlertArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_alert(
    AlertArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DeleteAlert",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AlertArn" => AlertArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_anomaly_detector(anomaly_detector_arn)
    delete_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Deletes a detector. Deleting an anomaly detector will delete all of its corresponding
resources including any configured datasets and alerts.

# Arguments
- `anomaly_detector_arn`: The ARN of the detector to delete.

"""
function delete_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/DeleteAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DeleteAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_alert(alert_arn)
    describe_alert(alert_arn, params::Dict{String,<:Any})

Describes an alert. Amazon Lookout for Metrics API actions are eventually consistent. If
you do a read operation on a resource immediately after creating or modifying it, use
retries to allow time for the write operation to complete.

# Arguments
- `alert_arn`: The ARN of the alert to describe.

"""
function describe_alert(AlertArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/DescribeAlert",
        Dict{String,Any}("AlertArn" => AlertArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_alert(
    AlertArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DescribeAlert",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AlertArn" => AlertArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_anomaly_detection_executions(anomaly_detector_arn)
    describe_anomaly_detection_executions(anomaly_detector_arn, params::Dict{String,<:Any})

Returns information about the status of the specified anomaly detection jobs.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The number of items to return in the response.
- `"NextToken"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"Timestamp"`: The timestamp of the anomaly detection job.
"""
function describe_anomaly_detection_executions(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/DescribeAnomalyDetectionExecutions",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_anomaly_detection_executions(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DescribeAnomalyDetectionExecutions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_anomaly_detector(anomaly_detector_arn)
    describe_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Describes a detector. Amazon Lookout for Metrics API actions are eventually consistent. If
you do a read operation on a resource immediately after creating or modifying it, use
retries to allow time for the write operation to complete.

# Arguments
- `anomaly_detector_arn`: The ARN of the detector to describe.

"""
function describe_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/DescribeAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DescribeAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_metric_set(metric_set_arn)
    describe_metric_set(metric_set_arn, params::Dict{String,<:Any})

Describes a dataset. Amazon Lookout for Metrics API actions are eventually consistent. If
you do a read operation on a resource immediately after creating or modifying it, use
retries to allow time for the write operation to complete.

# Arguments
- `metric_set_arn`: The ARN of the dataset.

"""
function describe_metric_set(
    MetricSetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/DescribeMetricSet",
        Dict{String,Any}("MetricSetArn" => MetricSetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_metric_set(
    MetricSetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DescribeMetricSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MetricSetArn" => MetricSetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_metric_set_config(anomaly_detector_arn, auto_detection_metric_source)
    detect_metric_set_config(anomaly_detector_arn, auto_detection_metric_source, params::Dict{String,<:Any})

Detects an Amazon S3 dataset's file format, interval, and offset.

# Arguments
- `anomaly_detector_arn`: An anomaly detector ARN.
- `auto_detection_metric_source`: A data source.

"""
function detect_metric_set_config(
    AnomalyDetectorArn,
    AutoDetectionMetricSource;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DetectMetricSetConfig",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "AutoDetectionMetricSource" => AutoDetectionMetricSource,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_metric_set_config(
    AnomalyDetectorArn,
    AutoDetectionMetricSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/DetectMetricSetConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AutoDetectionMetricSource" => AutoDetectionMetricSource,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_anomaly_group(anomaly_detector_arn, anomaly_group_id)
    get_anomaly_group(anomaly_detector_arn, anomaly_group_id, params::Dict{String,<:Any})

Returns details about a group of anomalous metrics.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `anomaly_group_id`: The ID of the anomaly group.

"""
function get_anomaly_group(
    AnomalyDetectorArn, AnomalyGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/GetAnomalyGroup",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn, "AnomalyGroupId" => AnomalyGroupId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_anomaly_group(
    AnomalyDetectorArn,
    AnomalyGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/GetAnomalyGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AnomalyGroupId" => AnomalyGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_quality_metrics(anomaly_detector_arn)
    get_data_quality_metrics(anomaly_detector_arn, params::Dict{String,<:Any})

Returns details about the requested data quality metrics.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector that you
  want to investigate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MetricSetArn"`: The Amazon Resource Name (ARN) of a specific data quality metric set.
"""
function get_data_quality_metrics(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/GetDataQualityMetrics",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_quality_metrics(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/GetDataQualityMetrics",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_feedback(anomaly_detector_arn, anomaly_group_time_series_feedback)
    get_feedback(anomaly_detector_arn, anomaly_group_time_series_feedback, params::Dict{String,<:Any})

Get feedback for an anomaly group.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `anomaly_group_time_series_feedback`: The anomalous metric and group ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
"""
function get_feedback(
    AnomalyDetectorArn,
    AnomalyGroupTimeSeriesFeedback;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/GetFeedback",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "AnomalyGroupTimeSeriesFeedback" => AnomalyGroupTimeSeriesFeedback,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_feedback(
    AnomalyDetectorArn,
    AnomalyGroupTimeSeriesFeedback,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/GetFeedback",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AnomalyGroupTimeSeriesFeedback" => AnomalyGroupTimeSeriesFeedback,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sample_data()
    get_sample_data(params::Dict{String,<:Any})

Returns a selection of sample records from an Amazon S3 datasource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"S3SourceConfig"`: A datasource bucket in Amazon S3.
"""
function get_sample_data(; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST", "/GetSampleData"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_sample_data(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/GetSampleData",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_alerts()
    list_alerts(params::Dict{String,<:Any})

Lists the alerts attached to a detector. Amazon Lookout for Metrics API actions are
eventually consistent. If you do a read operation on a resource immediately after creating
or modifying it, use retries to allow time for the write operation to complete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnomalyDetectorArn"`: The ARN of the alert's detector.
- `"MaxResults"`: The maximum number of results that will be displayed by the request.
- `"NextToken"`: If the result of the previous request is truncated, the response includes
  a NextToken. To retrieve the next set of results, use the token in the next request. Tokens
  expire after 24 hours.
"""
function list_alerts(; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST", "/ListAlerts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_alerts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/ListAlerts",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_anomaly_detectors()
    list_anomaly_detectors(params::Dict{String,<:Any})

Lists the detectors in the current AWS Region. Amazon Lookout for Metrics API actions are
eventually consistent. If you do a read operation on a resource immediately after creating
or modifying it, use retries to allow time for the write operation to complete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: If the result of the previous request was truncated, the response includes
  a NextToken. To retrieve the next set of results, use the token in the next request. Tokens
  expire after 24 hours.
"""
function list_anomaly_detectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/ListAnomalyDetectors";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_anomaly_detectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyDetectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_anomaly_group_related_metrics(anomaly_detector_arn, anomaly_group_id)
    list_anomaly_group_related_metrics(anomaly_detector_arn, anomaly_group_id, params::Dict{String,<:Any})

Returns a list of measures that are potential causes or effects of an anomaly group.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `anomaly_group_id`: The ID of the anomaly group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"RelationshipTypeFilter"`: Filter for potential causes (CAUSE_OF_INPUT_ANOMALY_GROUP) or
  downstream effects (EFFECT_OF_INPUT_ANOMALY_GROUP) of the anomaly group.
"""
function list_anomaly_group_related_metrics(
    AnomalyDetectorArn, AnomalyGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupRelatedMetrics",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn, "AnomalyGroupId" => AnomalyGroupId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_anomaly_group_related_metrics(
    AnomalyDetectorArn,
    AnomalyGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupRelatedMetrics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AnomalyGroupId" => AnomalyGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_anomaly_group_summaries(anomaly_detector_arn, sensitivity_threshold)
    list_anomaly_group_summaries(anomaly_detector_arn, sensitivity_threshold, params::Dict{String,<:Any})

Returns a list of anomaly groups.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `sensitivity_threshold`: The minimum severity score for inclusion in the output.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
"""
function list_anomaly_group_summaries(
    AnomalyDetectorArn,
    SensitivityThreshold;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupSummaries",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "SensitivityThreshold" => SensitivityThreshold,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_anomaly_group_summaries(
    AnomalyDetectorArn,
    SensitivityThreshold,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupSummaries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "SensitivityThreshold" => SensitivityThreshold,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_anomaly_group_time_series(anomaly_detector_arn, anomaly_group_id, metric_name)
    list_anomaly_group_time_series(anomaly_detector_arn, anomaly_group_id, metric_name, params::Dict{String,<:Any})

Gets a list of anomalous metrics for a measure in an anomaly group.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `anomaly_group_id`: The ID of the anomaly group.
- `metric_name`: The name of the measure field.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
"""
function list_anomaly_group_time_series(
    AnomalyDetectorArn,
    AnomalyGroupId,
    MetricName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupTimeSeries",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "AnomalyGroupId" => AnomalyGroupId,
            "MetricName" => MetricName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_anomaly_group_time_series(
    AnomalyDetectorArn,
    AnomalyGroupId,
    MetricName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/ListAnomalyGroupTimeSeries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AnomalyGroupId" => AnomalyGroupId,
                    "MetricName" => MetricName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_metric_sets()
    list_metric_sets(params::Dict{String,<:Any})

Lists the datasets in the current AWS Region. Amazon Lookout for Metrics API actions are
eventually consistent. If you do a read operation on a resource immediately after creating
or modifying it, use retries to allow time for the write operation to complete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnomalyDetectorArn"`: The ARN of the anomaly detector containing the metrics sets to
  list.
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: If the result of the previous request was truncated, the response includes
  a NextToken. To retrieve the next set of results, use the token in the next request. Tokens
  expire after 24 hours.
"""
function list_metric_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST", "/ListMetricSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_metric_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/ListMetricSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets a list of tags for a detector, dataset, or alert.

# Arguments
- `resource_arn`: The resource's Amazon Resource Name (ARN).

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_feedback(anomaly_detector_arn, anomaly_group_time_series_feedback)
    put_feedback(anomaly_detector_arn, anomaly_group_time_series_feedback, params::Dict{String,<:Any})

Add feedback for an anomalous metric.

# Arguments
- `anomaly_detector_arn`: The Amazon Resource Name (ARN) of the anomaly detector.
- `anomaly_group_time_series_feedback`: Feedback for an anomalous metric.

"""
function put_feedback(
    AnomalyDetectorArn,
    AnomalyGroupTimeSeriesFeedback;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/PutFeedback",
        Dict{String,Any}(
            "AnomalyDetectorArn" => AnomalyDetectorArn,
            "AnomalyGroupTimeSeriesFeedback" => AnomalyGroupTimeSeriesFeedback,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_feedback(
    AnomalyDetectorArn,
    AnomalyGroupTimeSeriesFeedback,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/PutFeedback",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AnomalyDetectorArn" => AnomalyDetectorArn,
                    "AnomalyGroupTimeSeriesFeedback" => AnomalyGroupTimeSeriesFeedback,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds tags to a detector, dataset, or alert.

# Arguments
- `resource_arn`: The resource's Amazon Resource Name (ARN).
- `tags`: Tags to apply to the resource. Tag keys and values can contain letters, numbers,
  spaces, and the following symbols: _.:/=+@-

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a detector, dataset, or alert.

# Arguments
- `resource_arn`: The resource's Amazon Resource Name (ARN).
- `tag_keys`: Keys to remove from the resource's tags.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_alert(alert_arn)
    update_alert(alert_arn, params::Dict{String,<:Any})

Make changes to an existing alert.

# Arguments
- `alert_arn`: The ARN of the alert to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Action"`: Action that will be triggered when there is an alert.
- `"AlertDescription"`: A description of the alert.
- `"AlertFilters"`: The configuration of the alert filters, containing MetricList and
  DimensionFilterList.
- `"AlertSensitivityThreshold"`: An integer from 0 to 100 specifying the alert sensitivity
  threshold.
"""
function update_alert(AlertArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/UpdateAlert",
        Dict{String,Any}("AlertArn" => AlertArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_alert(
    AlertArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/UpdateAlert",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AlertArn" => AlertArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_anomaly_detector(anomaly_detector_arn)
    update_anomaly_detector(anomaly_detector_arn, params::Dict{String,<:Any})

Updates a detector. After activation, you can only change a detector's ingestion delay and
description.

# Arguments
- `anomaly_detector_arn`: The ARN of the detector to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnomalyDetectorConfig"`: Contains information about the configuration to which the
  detector will be updated.
- `"AnomalyDetectorDescription"`: The updated detector description.
- `"KmsKeyArn"`: The Amazon Resource Name (ARN) of an AWS KMS encryption key.
"""
function update_anomaly_detector(
    AnomalyDetectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutmetrics(
        "POST",
        "/UpdateAnomalyDetector",
        Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_anomaly_detector(
    AnomalyDetectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/UpdateAnomalyDetector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AnomalyDetectorArn" => AnomalyDetectorArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_metric_set(metric_set_arn)
    update_metric_set(metric_set_arn, params::Dict{String,<:Any})

Updates a dataset.

# Arguments
- `metric_set_arn`: The ARN of the dataset to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DimensionFilterList"`: Describes a list of filters for choosing specific dimensions and
  specific values. Each filter consists of the dimension and one of its values that you want
  to include. When multiple dimensions or values are specified, the dimensions are joined
  with an AND operation and the values are joined with an OR operation.
- `"DimensionList"`: The dimension list.
- `"MetricList"`: The metric list.
- `"MetricSetDescription"`: The dataset's description.
- `"MetricSetFrequency"`: The dataset's interval.
- `"MetricSource"`:
- `"Offset"`: After an interval ends, the amount of seconds that the detector waits before
  importing data. Offset is only supported for S3, Redshift, Athena and datasources.
- `"TimestampColumn"`: The timestamp column.
"""
function update_metric_set(MetricSetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutmetrics(
        "POST",
        "/UpdateMetricSet",
        Dict{String,Any}("MetricSetArn" => MetricSetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_metric_set(
    MetricSetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutmetrics(
        "POST",
        "/UpdateMetricSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MetricSetArn" => MetricSetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
