# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: medical_imaging
using AWS.Compat
using AWS.UUIDs

"""
    copy_image_set(copy_image_set_information, datastore_id, source_image_set_id)
    copy_image_set(copy_image_set_information, datastore_id, source_image_set_id, params::Dict{String,<:Any})

Copy an image set.

# Arguments
- `copy_image_set_information`: Copy image set information.
- `datastore_id`: The data store identifier.
- `source_image_set_id`: The source image set identifier.

"""
function copy_image_set(
    copyImageSetInformation,
    datastoreId,
    sourceImageSetId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(sourceImageSetId)/copyImageSet",
        Dict{String,Any}("copyImageSetInformation" => copyImageSetInformation);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_image_set(
    copyImageSetInformation,
    datastoreId,
    sourceImageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(sourceImageSetId)/copyImageSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("copyImageSetInformation" => copyImageSetInformation),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_datastore(client_token)
    create_datastore(client_token, params::Dict{String,<:Any})

Create a data store.

# Arguments
- `client_token`: A unique identifier for API idempotency.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"datastoreName"`: The data store name.
- `"kmsKeyArn"`: The Amazon Resource Name (ARN) assigned to the Key Management Service
  (KMS) key for accessing encrypted data.
- `"tags"`: The tags provided when creating a data store.
"""
function create_datastore(clientToken; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "POST",
        "/datastore",
        Dict{String,Any}("clientToken" => clientToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_datastore(
    clientToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => clientToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_datastore(datastore_id)
    delete_datastore(datastore_id, params::Dict{String,<:Any})

Delete a data store.  Before a data store can be deleted, you must first delete all image
sets within it.

# Arguments
- `datastore_id`: The data store identifier.

"""
function delete_datastore(datastoreId; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "DELETE",
        "/datastore/$(datastoreId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_datastore(
    datastoreId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "DELETE",
        "/datastore/$(datastoreId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image_set(datastore_id, image_set_id)
    delete_image_set(datastore_id, image_set_id, params::Dict{String,<:Any})

Delete an image set.

# Arguments
- `datastore_id`: The data store identifier.
- `image_set_id`: The image set identifier.

"""
function delete_image_set(
    datastoreId, imageSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/deleteImageSet";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image_set(
    datastoreId,
    imageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/deleteImageSet",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_datastore(datastore_id)
    get_datastore(datastore_id, params::Dict{String,<:Any})

Get data store properties.

# Arguments
- `datastore_id`: The data store identifier.

"""
function get_datastore(datastoreId; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "GET",
        "/datastore/$(datastoreId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_datastore(
    datastoreId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "GET",
        "/datastore/$(datastoreId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_dicomimport_job(datastore_id, job_id)
    get_dicomimport_job(datastore_id, job_id, params::Dict{String,<:Any})

Get the import job properties to learn more about the job or job progress.  The jobStatus
refers to the execution of the import job. Therefore, an import job can return a jobStatus
as COMPLETED even if validation issues are discovered during the import process. If a
jobStatus returns as COMPLETED, we still recommend you review the output manifests written
to S3, as they provide details on the success or failure of individual P10 object imports.

# Arguments
- `datastore_id`: The data store identifier.
- `job_id`: The import job identifier.

"""
function get_dicomimport_job(
    datastoreId, jobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "GET",
        "/getDICOMImportJob/datastore/$(datastoreId)/job/$(jobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_dicomimport_job(
    datastoreId,
    jobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "GET",
        "/getDICOMImportJob/datastore/$(datastoreId)/job/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_frame(datastore_id, image_frame_information, image_set_id)
    get_image_frame(datastore_id, image_frame_information, image_set_id, params::Dict{String,<:Any})

Get an image frame (pixel data) for an image set.

# Arguments
- `datastore_id`: The data store identifier.
- `image_frame_information`: Information about the image frame (pixel data) identifier.
- `image_set_id`: The image set identifier.

"""
function get_image_frame(
    datastoreId,
    imageFrameInformation,
    imageSetId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageFrame",
        Dict{String,Any}("imageFrameInformation" => imageFrameInformation);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_frame(
    datastoreId,
    imageFrameInformation,
    imageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageFrame",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageFrameInformation" => imageFrameInformation),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_set(datastore_id, image_set_id)
    get_image_set(datastore_id, image_set_id, params::Dict{String,<:Any})

Get image set properties.

# Arguments
- `datastore_id`: The data store identifier.
- `image_set_id`: The image set identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The image set version identifier.
"""
function get_image_set(
    datastoreId, imageSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageSet";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_set(
    datastoreId,
    imageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageSet",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_set_metadata(datastore_id, image_set_id)
    get_image_set_metadata(datastore_id, image_set_id, params::Dict{String,<:Any})

Get metadata attributes for an image set.

# Arguments
- `datastore_id`: The data store identifier.
- `image_set_id`: The image set identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The image set version identifier.
"""
function get_image_set_metadata(
    datastoreId, imageSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageSetMetadata";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_set_metadata(
    datastoreId,
    imageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/getImageSetMetadata",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_datastores()
    list_datastores(params::Dict{String,<:Any})

List data stores.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"datastoreStatus"`: The data store status.
- `"maxResults"`: Valid Range: Minimum value of 1. Maximum value of 50.
- `"nextToken"`: The pagination token used to request the list of data stores on the next
  page.
"""
function list_datastores(; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "GET", "/datastore"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_datastores(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "GET", "/datastore", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_dicomimport_jobs(datastore_id)
    list_dicomimport_jobs(datastore_id, params::Dict{String,<:Any})

List import jobs created for a specific data store.

# Arguments
- `datastore_id`: The data store identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"jobStatus"`: The filters for listing import jobs based on status.
- `"maxResults"`: The max results count. The upper bound is determined by load testing.
- `"nextToken"`: The pagination token used to request the list of import jobs on the next
  page.
"""
function list_dicomimport_jobs(
    datastoreId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "GET",
        "/listDICOMImportJobs/datastore/$(datastoreId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_dicomimport_jobs(
    datastoreId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "GET",
        "/listDICOMImportJobs/datastore/$(datastoreId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_image_set_versions(datastore_id, image_set_id)
    list_image_set_versions(datastore_id, image_set_id, params::Dict{String,<:Any})

List image set versions.

# Arguments
- `datastore_id`: The data store identifier.
- `image_set_id`: The image set identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The max results count.
- `"nextToken"`: The pagination token used to request the list of image set versions on the
  next page.
"""
function list_image_set_versions(
    datastoreId, imageSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/listImageSetVersions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_image_set_versions(
    datastoreId,
    imageSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/listImageSetVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all tags associated with a medical imaging resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the medical imaging resource to list
  tags for.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_image_sets(datastore_id)
    search_image_sets(datastore_id, params::Dict{String,<:Any})

Search image sets based on defined input attributes.   SearchImageSets accepts a single
search query parameter and returns a paginated response of all image sets that have the
matching criteria. All date range queries must be input as (lowerBound, upperBound). By
default, SearchImageSets uses the updatedAt field for sorting in descending order from
newest to oldest.

# Arguments
- `datastore_id`: The identifier of the data store where the image sets reside.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that can be returned in a search.
- `"nextToken"`: The token used for pagination of results returned in the response. Use the
  token returned from the previous request to continue results where the previous request
  ended.
- `"searchCriteria"`: The search criteria that filters by applying a maximum of 1 item to
  SearchByAttribute.
"""
function search_image_sets(datastoreId; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/searchImageSets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_image_sets(
    datastoreId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/searchImageSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_dicomimport_job(client_token, data_access_role_arn, datastore_id, input_s3_uri, output_s3_uri)
    start_dicomimport_job(client_token, data_access_role_arn, datastore_id, input_s3_uri, output_s3_uri, params::Dict{String,<:Any})

Start importing bulk data into an ACTIVE data store. The import job imports DICOM P10 files
found in the S3 prefix specified by the inputS3Uri parameter. The import job stores
processing results in the file specified by the outputS3Uri parameter.

# Arguments
- `client_token`: A unique identifier for API idempotency.
- `data_access_role_arn`: The Amazon Resource Name (ARN) of the IAM role that grants
  permission to access medical imaging resources.
- `datastore_id`: The data store identifier.
- `input_s3_uri`: The input prefix path for the S3 bucket that contains the DICOM files to
  be imported.
- `output_s3_uri`: The output prefix of the S3 bucket to upload the results of the DICOM
  import job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"inputOwnerAccountId"`: The account ID of the source S3 bucket owner.
- `"jobName"`: The import job name.
"""
function start_dicomimport_job(
    clientToken,
    dataAccessRoleArn,
    datastoreId,
    inputS3Uri,
    outputS3Uri;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/startDICOMImportJob/datastore/$(datastoreId)",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "dataAccessRoleArn" => dataAccessRoleArn,
            "inputS3Uri" => inputS3Uri,
            "outputS3Uri" => outputS3Uri,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_dicomimport_job(
    clientToken,
    dataAccessRoleArn,
    datastoreId,
    inputS3Uri,
    outputS3Uri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/startDICOMImportJob/datastore/$(datastoreId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "dataAccessRoleArn" => dataAccessRoleArn,
                    "inputS3Uri" => inputS3Uri,
                    "outputS3Uri" => outputS3Uri,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds a user-specifed key and value tag to a medical imaging resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the medical imaging resource that tags
  are being added to.
- `tags`: The user-specified key and value tag pairs added to a medical imaging resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return medical_imaging(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a medical imaging resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the medical imaging resource that tags
  are being removed from.
- `tag_keys`: The keys for the tags to be removed from the medical imaging resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return medical_imaging(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_image_set_metadata(datastore_id, image_set_id, latest_version, update_image_set_metadata_updates)
    update_image_set_metadata(datastore_id, image_set_id, latest_version, update_image_set_metadata_updates, params::Dict{String,<:Any})

Update image set metadata attributes.

# Arguments
- `datastore_id`: The data store identifier.
- `image_set_id`: The image set identifier.
- `latest_version`: The latest image set version identifier.
- `update_image_set_metadata_updates`: Update image set metadata updates.

"""
function update_image_set_metadata(
    datastoreId,
    imageSetId,
    latestVersion,
    updateImageSetMetadataUpdates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/updateImageSetMetadata",
        Dict{String,Any}(
            "latestVersion" => latestVersion,
            "updateImageSetMetadataUpdates" => updateImageSetMetadataUpdates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_image_set_metadata(
    datastoreId,
    imageSetId,
    latestVersion,
    updateImageSetMetadataUpdates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return medical_imaging(
        "POST",
        "/datastore/$(datastoreId)/imageSet/$(imageSetId)/updateImageSetMetadata",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "latestVersion" => latestVersion,
                    "updateImageSetMetadataUpdates" => updateImageSetMetadataUpdates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
