# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: panorama
using AWS.Compat
using AWS.UUIDs

"""
    create_application_instance(default_runtime_context_device, manifest_payload)
    create_application_instance(default_runtime_context_device, manifest_payload, params::Dict{String,<:Any})

Creates an application instance and deploys it to a device.

# Arguments
- `default_runtime_context_device`: A device's ID.
- `manifest_payload`: The application's manifest document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationInstanceIdToReplace"`: The ID of an application instance to replace with the
  new instance.
- `"Description"`: A description for the application instance.
- `"ManifestOverridesPayload"`: Setting overrides for the application manifest.
- `"Name"`: A name for the application instance.
- `"RuntimeRoleArn"`: The ARN of a runtime role for the application instance.
- `"Tags"`: Tags for the application instance.
"""
function create_application_instance(
    DefaultRuntimeContextDevice,
    ManifestPayload;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/application-instances",
        Dict{String,Any}(
            "DefaultRuntimeContextDevice" => DefaultRuntimeContextDevice,
            "ManifestPayload" => ManifestPayload,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application_instance(
    DefaultRuntimeContextDevice,
    ManifestPayload,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/application-instances",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DefaultRuntimeContextDevice" => DefaultRuntimeContextDevice,
                    "ManifestPayload" => ManifestPayload,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_job_for_devices(device_ids, job_type)
    create_job_for_devices(device_ids, job_type, params::Dict{String,<:Any})

Creates a job to run on a device. A job can update a device's software or reboot it.

# Arguments
- `device_ids`: ID of target device.
- `job_type`: The type of job to run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceJobConfig"`: Configuration settings for a software update job.
"""
function create_job_for_devices(
    DeviceIds, JobType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "POST",
        "/jobs",
        Dict{String,Any}("DeviceIds" => DeviceIds, "JobType" => JobType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_job_for_devices(
    DeviceIds,
    JobType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DeviceIds" => DeviceIds, "JobType" => JobType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_node_from_template_job(node_name, output_package_name, output_package_version, template_parameters, template_type)
    create_node_from_template_job(node_name, output_package_name, output_package_version, template_parameters, template_type, params::Dict{String,<:Any})

Creates a camera stream node.

# Arguments
- `node_name`: A name for the node.
- `output_package_name`: An output package name for the node.
- `output_package_version`: An output package version for the node.
- `template_parameters`: Template parameters for the node.
- `template_type`: The type of node.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"JobTags"`: Tags for the job.
- `"NodeDescription"`: A description for the node.
"""
function create_node_from_template_job(
    NodeName,
    OutputPackageName,
    OutputPackageVersion,
    TemplateParameters,
    TemplateType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/packages/template-job",
        Dict{String,Any}(
            "NodeName" => NodeName,
            "OutputPackageName" => OutputPackageName,
            "OutputPackageVersion" => OutputPackageVersion,
            "TemplateParameters" => TemplateParameters,
            "TemplateType" => TemplateType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_node_from_template_job(
    NodeName,
    OutputPackageName,
    OutputPackageVersion,
    TemplateParameters,
    TemplateType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/packages/template-job",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NodeName" => NodeName,
                    "OutputPackageName" => OutputPackageName,
                    "OutputPackageVersion" => OutputPackageVersion,
                    "TemplateParameters" => TemplateParameters,
                    "TemplateType" => TemplateType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_package(package_name)
    create_package(package_name, params::Dict{String,<:Any})

Creates a package and storage location in an Amazon S3 access point.

# Arguments
- `package_name`: A name for the package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags for the package.
"""
function create_package(PackageName; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "POST",
        "/packages",
        Dict{String,Any}("PackageName" => PackageName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_package(
    PackageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/packages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PackageName" => PackageName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_package_import_job(client_token, input_config, job_type, output_config)
    create_package_import_job(client_token, input_config, job_type, output_config, params::Dict{String,<:Any})

Imports a node package.

# Arguments
- `client_token`: A client token for the package import job.
- `input_config`: An input config for the package import job.
- `job_type`: A job type for the package import job.
- `output_config`: An output config for the package import job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"JobTags"`: Tags for the package import job.
"""
function create_package_import_job(
    ClientToken,
    InputConfig,
    JobType,
    OutputConfig;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/packages/import-jobs",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "InputConfig" => InputConfig,
            "JobType" => JobType,
            "OutputConfig" => OutputConfig,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_package_import_job(
    ClientToken,
    InputConfig,
    JobType,
    OutputConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/packages/import-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "InputConfig" => InputConfig,
                    "JobType" => JobType,
                    "OutputConfig" => OutputConfig,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_device(device_id)
    delete_device(device_id, params::Dict{String,<:Any})

Deletes a device.

# Arguments
- `device_id`: The device's ID.

"""
function delete_device(DeviceId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "DELETE",
        "/devices/$(DeviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_device(
    DeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/devices/$(DeviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_package(package_id)
    delete_package(package_id, params::Dict{String,<:Any})

Deletes a package.  To delete a package, you need permission to call s3:DeleteObject in
addition to permissions for the AWS Panorama API.

# Arguments
- `package_id`: The package's ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceDelete"`: Delete the package even if it has artifacts stored in its access point.
  Deletes the package's artifacts from Amazon S3.
"""
function delete_package(PackageId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "DELETE",
        "/packages/$(PackageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_package(
    PackageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/packages/$(PackageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_package_version(package_id, package_version, patch_version)
    deregister_package_version(package_id, package_version, patch_version, params::Dict{String,<:Any})

Deregisters a package version.

# Arguments
- `package_id`: A package ID.
- `package_version`: A package version.
- `patch_version`: A patch version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OwnerAccount"`: An owner account.
- `"UpdatedLatestPatchVersion"`: If the version was marked latest, the new version to maker
  as latest.
"""
function deregister_package_version(
    PackageId,
    PackageVersion,
    PatchVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/packages/$(PackageId)/versions/$(PackageVersion)/patch/$(PatchVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_package_version(
    PackageId,
    PackageVersion,
    PatchVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/packages/$(PackageId)/versions/$(PackageVersion)/patch/$(PatchVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application_instance(application_instance_id)
    describe_application_instance(application_instance_id, params::Dict{String,<:Any})

Returns information about an application instance on a device.

# Arguments
- `application_instance_id`: The application instance's ID.

"""
function describe_application_instance(
    ApplicationInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_instance(
    ApplicationInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application_instance_details(application_instance_id)
    describe_application_instance_details(application_instance_id, params::Dict{String,<:Any})

Returns information about an application instance's configuration manifest.

# Arguments
- `application_instance_id`: The application instance's ID.

"""
function describe_application_instance_details(
    ApplicationInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/details";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_instance_details(
    ApplicationInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/details",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_device(device_id)
    describe_device(device_id, params::Dict{String,<:Any})

Returns information about a device.

# Arguments
- `device_id`: The device's ID.

"""
function describe_device(DeviceId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET",
        "/devices/$(DeviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_device(
    DeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/devices/$(DeviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_device_job(job_id)
    describe_device_job(job_id, params::Dict{String,<:Any})

Returns information about a device job.

# Arguments
- `job_id`: The job's ID.

"""
function describe_device_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET", "/jobs/$(JobId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_device_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/jobs/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_node(node_id)
    describe_node(node_id, params::Dict{String,<:Any})

Returns information about a node.

# Arguments
- `node_id`: The node's ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OwnerAccount"`: The account ID of the node's owner.
"""
function describe_node(NodeId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET", "/nodes/$(NodeId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_node(
    NodeId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/nodes/$(NodeId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_node_from_template_job(job_id)
    describe_node_from_template_job(job_id, params::Dict{String,<:Any})

Returns information about a job to create a camera stream node.

# Arguments
- `job_id`: The job's ID.

"""
function describe_node_from_template_job(
    JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/template-job/$(JobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_node_from_template_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/template-job/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_package(package_id)
    describe_package(package_id, params::Dict{String,<:Any})

Returns information about a package.

# Arguments
- `package_id`: The package's ID.

"""
function describe_package(PackageId; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET",
        "/packages/metadata/$(PackageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_package(
    PackageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/packages/metadata/$(PackageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_package_import_job(job_id)
    describe_package_import_job(job_id, params::Dict{String,<:Any})

Returns information about a package import job.

# Arguments
- `job_id`: The job's ID.

"""
function describe_package_import_job(
    JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/import-jobs/$(JobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_package_import_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/import-jobs/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_package_version(package_id, package_version)
    describe_package_version(package_id, package_version, params::Dict{String,<:Any})

Returns information about a package version.

# Arguments
- `package_id`: The version's ID.
- `package_version`: The version's version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OwnerAccount"`: The version's owner account.
- `"PatchVersion"`: The version's patch version.
"""
function describe_package_version(
    PackageId, PackageVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/metadata/$(PackageId)/versions/$(PackageVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_package_version(
    PackageId,
    PackageVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/packages/metadata/$(PackageId)/versions/$(PackageVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_instance_dependencies(application_instance_id)
    list_application_instance_dependencies(application_instance_id, params::Dict{String,<:Any})

Returns a list of application instance dependencies.

# Arguments
- `application_instance_id`: The application instance's ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of application instance dependencies to return in one
  page of results.
- `"nextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_application_instance_dependencies(
    ApplicationInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/package-dependencies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_instance_dependencies(
    ApplicationInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/package-dependencies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_instance_node_instances(application_instance_id)
    list_application_instance_node_instances(application_instance_id, params::Dict{String,<:Any})

Returns a list of application node instances.

# Arguments
- `application_instance_id`: The node instances' application instance ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of node instances to return in one page of results.
- `"nextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_application_instance_node_instances(
    ApplicationInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/node-instances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_instance_node_instances(
    ApplicationInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/application-instances/$(ApplicationInstanceId)/node-instances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_instances()
    list_application_instances(params::Dict{String,<:Any})

Returns a list of application instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deviceId"`: The application instances' device ID.
- `"maxResults"`: The maximum number of application instances to return in one page of
  results.
- `"nextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
- `"statusFilter"`: Only include instances with a specific status.
"""
function list_application_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET",
        "/application-instances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/application-instances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_devices()
    list_devices(params::Dict{String,<:Any})

Returns a list of devices.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceAggregatedStatusFilter"`: Filter based on a device's status.
- `"MaxResults"`: The maximum number of devices to return in one page of results.
- `"NameFilter"`: Filter based on device's name. Prefixes supported.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
- `"SortBy"`: The target column to be sorted on. Default column sort is CREATED_TIME.
- `"SortOrder"`: The sorting order for the returned list. SortOrder is DESCENDING by
  default based on CREATED_TIME. Otherwise, SortOrder is ASCENDING.
"""
function list_devices(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET", "/devices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_devices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET", "/devices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_devices_jobs()
    list_devices_jobs(params::Dict{String,<:Any})

Returns a list of jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceId"`: Filter results by the job's target device ID.
- `"MaxResults"`: The maximum number of device jobs to return in one page of results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_devices_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama("GET", "/jobs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_devices_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET", "/jobs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_node_from_template_jobs()
    list_node_from_template_jobs(params::Dict{String,<:Any})

Returns a list of camera stream node jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of node from template jobs to return in one page of
  results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_node_from_template_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET",
        "/packages/template-job";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_node_from_template_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/template-job",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_nodes()
    list_nodes(params::Dict{String,<:Any})

Returns a list of nodes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"category"`: Search for nodes by category.
- `"maxResults"`: The maximum number of nodes to return in one page of results.
- `"nextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
- `"ownerAccount"`: Search for nodes by the account ID of the nodes' owner.
- `"packageName"`: Search for nodes by name.
- `"packageVersion"`: Search for nodes by version.
- `"patchVersion"`: Search for nodes by patch version.
"""
function list_nodes(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama("GET", "/nodes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_nodes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET", "/nodes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_package_import_jobs()
    list_package_import_jobs(params::Dict{String,<:Any})

Returns a list of package import jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of package import jobs to return in one page of
  results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_package_import_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET",
        "/packages/import-jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_package_import_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/packages/import-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_packages()
    list_packages(params::Dict{String,<:Any})

Returns a list of packages.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of packages to return in one page of results.
- `"nextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function list_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "GET", "/packages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET", "/packages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags for a resource.

# Arguments
- `resource_arn`: The resource's ARN.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    provision_device(name)
    provision_device(name, params::Dict{String,<:Any})

Creates a device and returns a configuration archive. The configuration archive is a ZIP
file that contains a provisioning certificate that is valid for 5 minutes. Name the
configuration archive certificates-omni_device-name.zip and transfer it to the device
within 5 minutes. Use the included USB storage device and connect it to the USB 3.0 port
next to the HDMI output.

# Arguments
- `name`: A name for the device.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the device.
- `"NetworkingConfiguration"`: A networking configuration for the device.
- `"Tags"`: Tags for the device.
"""
function provision_device(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "POST",
        "/devices",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function provision_device(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "POST",
        "/devices",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_package_version(package_id, package_version, patch_version)
    register_package_version(package_id, package_version, patch_version, params::Dict{String,<:Any})

Registers a package version.

# Arguments
- `package_id`: A package ID.
- `package_version`: A package version.
- `patch_version`: A patch version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MarkLatest"`: Whether to mark the new version as the latest version.
- `"OwnerAccount"`: An owner account.
"""
function register_package_version(
    PackageId,
    PackageVersion,
    PatchVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "PUT",
        "/packages/$(PackageId)/versions/$(PackageVersion)/patch/$(PatchVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_package_version(
    PackageId,
    PackageVersion,
    PatchVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "PUT",
        "/packages/$(PackageId)/versions/$(PackageVersion)/patch/$(PatchVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_application_instance(application_instance_id)
    remove_application_instance(application_instance_id, params::Dict{String,<:Any})

Removes an application instance.

# Arguments
- `application_instance_id`: An application instance ID.

"""
function remove_application_instance(
    ApplicationInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "DELETE",
        "/application-instances/$(ApplicationInstanceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_application_instance(
    ApplicationInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/application-instances/$(ApplicationInstanceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    signal_application_instance_node_instances(application_instance_id, node_signals)
    signal_application_instance_node_instances(application_instance_id, node_signals, params::Dict{String,<:Any})

Signal camera nodes to stop or resume.

# Arguments
- `application_instance_id`: An application instance ID.
- `node_signals`: A list of signals.

"""
function signal_application_instance_node_instances(
    ApplicationInstanceId, NodeSignals; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "PUT",
        "/application-instances/$(ApplicationInstanceId)/node-signals",
        Dict{String,Any}("NodeSignals" => NodeSignals);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function signal_application_instance_node_instances(
    ApplicationInstanceId,
    NodeSignals,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "PUT",
        "/application-instances/$(ApplicationInstanceId)/node-signals",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("NodeSignals" => NodeSignals), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tags a resource.

# Arguments
- `resource_arn`: The resource's ARN.
- `tags`: Tags for the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return panorama(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a resource.

# Arguments
- `resource_arn`: The resource's ARN.
- `tag_keys`: Tag keys to remove.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device_metadata(device_id)
    update_device_metadata(device_id, params::Dict{String,<:Any})

Updates a device's metadata.

# Arguments
- `device_id`: The device's ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the device.
"""
function update_device_metadata(
    DeviceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return panorama(
        "PUT",
        "/devices/$(DeviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device_metadata(
    DeviceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return panorama(
        "PUT",
        "/devices/$(DeviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
