# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: resource_groups_tagging_api
using AWS.Compat
using AWS.UUIDs

"""
    describe_report_creation()
    describe_report_creation(params::Dict{String,<:Any})

Describes the status of the StartReportCreation operation.  You can call this operation
only from the organization's management account and from the us-east-1 Region.

"""
function describe_report_creation(; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "DescribeReportCreation"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_report_creation(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "DescribeReportCreation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_summary()
    get_compliance_summary(params::Dict{String,<:Any})

Returns a table that shows counts of resources that are noncompliant with their tag
policies. For more information on tag policies, see Tag Policies in the Organizations User
Guide.  You can call this operation only from the organization's management account and
from the us-east-1 Region. This operation supports pagination, where the response can be
sent in multiple pages. You should check the PaginationToken response parameter to
determine if there are additional results available to return. Repeat the query, passing
the PaginationToken response parameter value as an input to the next request until you
recieve a null value. A null value for PaginationToken indicates that there are no more
results waiting to be returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GroupBy"`: Specifies a list of attributes to group the counts of noncompliant resources
  by. If supplied, the counts are sorted by those attributes.
- `"MaxResults"`: Specifies the maximum number of results to be returned in each page. A
  query can return fewer than this maximum, even if there are more results still to return.
  You should always check the PaginationToken response value to see if there are more
  results. You can specify a minimum of 1 and a maximum value of 100.
- `"PaginationToken"`: Specifies a PaginationToken response value from a previous request
  to indicate that you want the next page of results. Leave this parameter empty in your
  initial request.
- `"RegionFilters"`: Specifies a list of Amazon Web Services Regions to limit the output
  to. If you use this parameter, the count of returned noncompliant resources includes only
  resources in the specified Regions.
- `"ResourceTypeFilters"`: Specifies that you want the response to include information for
  only resources of the specified types. The format of each resource type is
  service[:resourceType]. For example, specifying a resource type of ec2 returns all Amazon
  EC2 resources (which includes EC2 instances). Specifying a resource type of ec2:instance
  returns only EC2 instances. The string for each service name and resource type is the same
  as that embedded in a resource's Amazon Resource Name (ARN). Consult the  Amazon Web
  Services General Reference  for the following:   For a list of service name strings, see
  Amazon Web Services Service Namespaces.   For resource type strings, see Example ARNs.
  For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services
  Service Namespaces.   You can specify multiple resource types by using a comma separated
  array. The array can include up to 100 items. Note that the length constraint requirement
  applies to each resource type filter.
- `"TagKeyFilters"`: Specifies that you want the response to include information for only
  resources that have tags with the specified tag keys. If you use this parameter, the count
  of returned noncompliant resources includes only resources that have the specified tag keys.
- `"TargetIdFilters"`: Specifies target identifiers (usually, specific account IDs) to
  limit the output by. If you use this parameter, the count of returned noncompliant
  resources includes only resources with the specified target IDs.
"""
function get_compliance_summary(; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "GetComplianceSummary"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_compliance_summary(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "GetComplianceSummary",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resources()
    get_resources(params::Dict{String,<:Any})

Returns all the tagged or previously tagged resources that are located in the specified
Amazon Web Services Region for the account. Depending on what information you want
returned, you can also specify the following:    Filters that specify what tags and
resource types you want returned. The response includes all tags that are associated with
the requested resources.   Information about compliance with the account's effective tag
policy. For more information on tag policies, see Tag Policies in the Organizations User
Guide.    This operation supports pagination, where the response can be sent in multiple
pages. You should check the PaginationToken response parameter to determine if there are
additional results available to return. Repeat the query, passing the PaginationToken
response parameter value as an input to the next request until you recieve a null value. A
null value for PaginationToken indicates that there are no more results waiting to be
returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExcludeCompliantResources"`: Specifies whether to exclude resources that are compliant
  with the tag policy. Set this to true if you are interested in retrieving information on
  noncompliant resources only. You can use this parameter only if the
  IncludeComplianceDetails parameter is also set to true.
- `"IncludeComplianceDetails"`: Specifies whether to include details regarding the
  compliance with the effective tag policy. Set this to true to determine whether resources
  are compliant with the tag policy and to get details.
- `"PaginationToken"`: Specifies a PaginationToken response value from a previous request
  to indicate that you want the next page of results. Leave this parameter empty in your
  initial request.
- `"ResourceARNList"`: Specifies a list of ARNs of resources for which you want to retrieve
  tag data. You can't specify both this parameter and any of the pagination parameters
  (ResourcesPerPage, TagsPerPage, PaginationToken) in the same request. If you specify both,
  you get an Invalid Parameter exception. If a resource specified by this parameter doesn't
  exist, it doesn't generate an error; it simply isn't included in the response. An ARN
  (Amazon Resource Name) uniquely identifies a resource. For more information, see Amazon
  Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services
  General Reference.
- `"ResourceTypeFilters"`: Specifies the resource types that you want included in the
  response. The format of each resource type is service[:resourceType]. For example,
  specifying a resource type of ec2 returns all Amazon EC2 resources (which includes EC2
  instances). Specifying a resource type of ec2:instance returns only EC2 instances.  The
  string for each service name and resource type is the same as that embedded in a resource's
  Amazon Resource Name (ARN). For the list of services whose resources you can use in this
  parameter, see Services that support the Resource Groups Tagging API. You can specify
  multiple resource types by using an array. The array can include up to 100 items. Note that
  the length constraint requirement applies to each resource type filter. For example, the
  following string would limit the response to only Amazon EC2 instances, Amazon S3 buckets,
  or any Audit Manager resource:  ec2:instance,s3:bucket,auditmanager
- `"ResourcesPerPage"`: Specifies the maximum number of results to be returned in each
  page. A query can return fewer than this maximum, even if there are more results still to
  return. You should always check the PaginationToken response value to see if there are more
  results. You can specify a minimum of 1 and a maximum value of 100.
- `"TagFilters"`: Specifies a list of TagFilters (keys and values) to restrict the output
  to only those resources that have tags with the specified keys and, if included, the
  specified values. Each TagFilter must contain a key with values optional. A request can
  include up to 50 keys, and each key can include up to 20 values.  Note the following when
  deciding how to use TagFilters:   If you don't specify a TagFilter, the response includes
  all resources that are currently tagged or ever had a tag. Resources that currently don't
  have tags are shown with an empty tag set, like this: \"Tags\": [].   If you specify more
  than one filter in a single request, the response returns only those resources that satisfy
  all filters.   If you specify a filter that contains more than one value for a key, the
  response returns resources that match any of the specified values for that key.   If you
  don't specify a value for a key, the response returns all resources that are tagged with
  that key, with any or no value. For example, for the following filters: filter1=
  {keyA,{value1}}, filter2={keyB,{value2,value3,value4}}, filter3= {keyC}:
  GetResources({filter1}) returns resources tagged with key1=value1
  GetResources({filter2}) returns resources tagged with key2=value2 or key2=value3 or
  key2=value4     GetResources({filter3}) returns resources tagged with any tag with the key
  key3, and with any or no value    GetResources({filter1,filter2,filter3}) returns resources
  tagged with (key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or
  no value)
- `"TagsPerPage"`: Amazon Web Services recommends using ResourcesPerPage instead of this
  parameter. A limit that restricts the number of tags (key and value pairs) returned by
  GetResources in paginated output. A resource with no tags is counted as having one tag (one
  key and value pair).  GetResources does not split a resource and its associated tags across
  pages. If the specified TagsPerPage would cause such a break, a PaginationToken is returned
  in place of the affected resource and its tags. Use that token in another request to get
  the remaining data. For example, if you specify a TagsPerPage of 100 and the account has 22
  resources with 10 tags each (meaning that each resource has 10 key and value pairs), the
  output will consist of three pages. The first page displays the first 10 resources, each
  with its 10 tags. The second page displays the next 10 resources, each with its 10 tags.
  The third page displays the remaining 2 resources, each with its 10 tags. You can set
  TagsPerPage to a minimum of 100 items up to a maximum of 500 items.
"""
function get_resources(; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "GetResources"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_resources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "GetResources", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_tag_keys()
    get_tag_keys(params::Dict{String,<:Any})

Returns all tag keys currently in use in the specified Amazon Web Services Region for the
calling account. This operation supports pagination, where the response can be sent in
multiple pages. You should check the PaginationToken response parameter to determine if
there are additional results available to return. Repeat the query, passing the
PaginationToken response parameter value as an input to the next request until you recieve
a null value. A null value for PaginationToken indicates that there are no more results
waiting to be returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PaginationToken"`: Specifies a PaginationToken response value from a previous request
  to indicate that you want the next page of results. Leave this parameter empty in your
  initial request.
"""
function get_tag_keys(; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "GetTagKeys"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_tag_keys(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "GetTagKeys", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_tag_values(key)
    get_tag_values(key, params::Dict{String,<:Any})

Returns all tag values for the specified key that are used in the specified Amazon Web
Services Region for the calling account. This operation supports pagination, where the
response can be sent in multiple pages. You should check the PaginationToken response
parameter to determine if there are additional results available to return. Repeat the
query, passing the PaginationToken response parameter value as an input to the next request
until you recieve a null value. A null value for PaginationToken indicates that there are
no more results waiting to be returned.

# Arguments
- `key`: Specifies the tag key for which you want to list all existing values that are
  currently used in the specified Amazon Web Services Region for the calling account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PaginationToken"`: Specifies a PaginationToken response value from a previous request
  to indicate that you want the next page of results. Leave this parameter empty in your
  initial request.
"""
function get_tag_values(Key; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "GetTagValues",
        Dict{String,Any}("Key" => Key);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_tag_values(
    Key, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "GetTagValues",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Key" => Key), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_report_creation(s3_bucket)
    start_report_creation(s3_bucket, params::Dict{String,<:Any})

Generates a report that lists all tagged resources in the accounts across your organization
and tells whether each resource is compliant with the effective tag policy. Compliance data
is refreshed daily. The report is generated asynchronously. The generated report is saved
to the following location:
s3://example-bucket/AwsTagPolicies/o-exampleorgid/YYYY-MM-ddTHH:mm:ssZ/report.csv  You can
call this operation only from the organization's management account and from the us-east-1
Region.

# Arguments
- `s3_bucket`: The name of the Amazon S3 bucket where the report will be stored; for
  example:  awsexamplebucket  For more information on S3 bucket requirements, including an
  example bucket policy, see the example S3 bucket policy on this page.

"""
function start_report_creation(S3Bucket; aws_config::AbstractAWSConfig=current_aws_config())
    return resource_groups_tagging_api(
        "StartReportCreation",
        Dict{String,Any}("S3Bucket" => S3Bucket);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_report_creation(
    S3Bucket,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resource_groups_tagging_api(
        "StartReportCreation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("S3Bucket" => S3Bucket), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resources(resource_arnlist, tags)
    tag_resources(resource_arnlist, tags, params::Dict{String,<:Any})

Applies one or more tags to the specified resources. Note the following:   Not all
resources can have tags. For a list of services with resources that support tagging using
this operation, see Services that support the Resource Groups Tagging API. If the resource
doesn't yet support this operation, the resource's service might support tagging using its
own API operations. For more information, refer to the documentation for that service.
Each resource can have up to 50 tags. For other limits, see Tag Naming and Usage
Conventions in the Amazon Web Services General Reference.    You can only tag resources
that are located in the specified Amazon Web Services Region for the Amazon Web Services
account.   To add tags to a resource, you need the necessary permissions for the service
that the resource belongs to as well as permissions for adding tags. For more information,
see the documentation for each service.    Do not store personally identifiable information
(PII) or other confidential or sensitive information in tags. We use tags to provide you
with billing and administration services. Tags are not intended to be used for private or
sensitive data.   Minimum permissions  In addition to the tag:TagResources permission
required by this operation, you must also have the tagging permission defined by the
service that created the resource. For example, to tag an Amazon EC2 instance using the
TagResources operation, you must have both of the following permissions:    tag:TagResource
    ec2:CreateTags

# Arguments
- `resource_arnlist`: Specifies the list of ARNs of the resources that you want to apply
  tags to. An ARN (Amazon Resource Name) uniquely identifies a resource. For more
  information, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in
  the Amazon Web Services General Reference.
- `tags`: Specifies a list of tags that you want to add to the specified resources. A tag
  consists of a key and a value that you define.

"""
function tag_resources(
    ResourceARNList, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "TagResources",
        Dict{String,Any}("ResourceARNList" => ResourceARNList, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resources(
    ResourceARNList,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resource_groups_tagging_api(
        "TagResources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARNList" => ResourceARNList, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resources(resource_arnlist, tag_keys)
    untag_resources(resource_arnlist, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified resources. When you specify a tag key, the
action removes both that key and its associated value. The operation succeeds even if you
attempt to remove tags from a resource that were already removed. Note the following:   To
remove tags from a resource, you need the necessary permissions for the service that the
resource belongs to as well as permissions for removing tags. For more information, see the
documentation for the service whose resource you want to untag.   You can only tag
resources that are located in the specified Amazon Web Services Region for the calling
Amazon Web Services account.    Minimum permissions  In addition to the tag:UntagResources
permission required by this operation, you must also have the remove tags permission
defined by the service that created the resource. For example, to remove the tags from an
Amazon EC2 instance using the UntagResources operation, you must have both of the following
permissions:    tag:UntagResource     ec2:DeleteTags

# Arguments
- `resource_arnlist`: Specifies a list of ARNs of the resources that you want to remove
  tags from. An ARN (Amazon Resource Name) uniquely identifies a resource. For more
  information, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in
  the Amazon Web Services General Reference.
- `tag_keys`: Specifies a list of tag keys that you want to remove from the specified
  resources.

"""
function untag_resources(
    ResourceARNList, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return resource_groups_tagging_api(
        "UntagResources",
        Dict{String,Any}("ResourceARNList" => ResourceARNList, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resources(
    ResourceARNList,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return resource_groups_tagging_api(
        "UntagResources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceARNList" => ResourceARNList, "TagKeys" => TagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
