# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: robomaker
using AWS.Compat
using AWS.UUIDs

"""
    batch_delete_worlds(worlds)
    batch_delete_worlds(worlds, params::Dict{String,<:Any})

Deletes one or more worlds in a batch operation.

# Arguments
- `worlds`: A list of Amazon Resource Names (arns) that correspond to worlds to delete.

"""
function batch_delete_worlds(worlds; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/batchDeleteWorlds",
        Dict{String,Any}("worlds" => worlds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_worlds(
    worlds, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/batchDeleteWorlds",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("worlds" => worlds), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_describe_simulation_job(jobs)
    batch_describe_simulation_job(jobs, params::Dict{String,<:Any})

Describes one or more simulation jobs.

# Arguments
- `jobs`: A list of Amazon Resource Names (ARNs) of simulation jobs to describe.

"""
function batch_describe_simulation_job(
    jobs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/batchDescribeSimulationJob",
        Dict{String,Any}("jobs" => jobs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_describe_simulation_job(
    jobs, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/batchDescribeSimulationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("jobs" => jobs), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_deployment_job(job)
    cancel_deployment_job(job, params::Dict{String,<:Any})

Cancels the specified deployment job.  This API will no longer be supported as of May 2,
2022. Use it to remove resources that were created for Deployment Service.

# Arguments
- `job`: The deployment job ARN to cancel.

"""
function cancel_deployment_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/cancelDeploymentJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_deployment_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelDeploymentJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_simulation_job(job)
    cancel_simulation_job(job, params::Dict{String,<:Any})

Cancels the specified simulation job.

# Arguments
- `job`: The simulation job ARN to cancel.

"""
function cancel_simulation_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/cancelSimulationJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_simulation_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelSimulationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_simulation_job_batch(batch)
    cancel_simulation_job_batch(batch, params::Dict{String,<:Any})

Cancels a simulation job batch. When you cancel a simulation job batch, you are also
cancelling all of the active simulation jobs created as part of the batch.

# Arguments
- `batch`: The id of the batch to cancel.

"""
function cancel_simulation_job_batch(
    batch; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelSimulationJobBatch",
        Dict{String,Any}("batch" => batch);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_simulation_job_batch(
    batch, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelSimulationJobBatch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("batch" => batch), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_world_export_job(job)
    cancel_world_export_job(job, params::Dict{String,<:Any})

Cancels the specified export job.

# Arguments
- `job`: The Amazon Resource Name (arn) of the world export job to cancel.

"""
function cancel_world_export_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/cancelWorldExportJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_world_export_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelWorldExportJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_world_generation_job(job)
    cancel_world_generation_job(job, params::Dict{String,<:Any})

Cancels the specified world generator job.

# Arguments
- `job`: The Amazon Resource Name (arn) of the world generator job to cancel.

"""
function cancel_world_generation_job(
    job; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelWorldGenerationJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_world_generation_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/cancelWorldGenerationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_deployment_job(client_request_token, deployment_application_configs, fleet)
    create_deployment_job(client_request_token, deployment_application_configs, fleet, params::Dict{String,<:Any})

Deploys a specific version of a robot application to robots in a fleet.  This API is no
longer supported and will throw an error if used.  The robot application must have a
numbered applicationVersion for consistency reasons. To create a new version, use
CreateRobotApplicationVersion or see Creating a Robot Application Version.   After 90 days,
deployment jobs expire and will be deleted. They will no longer be accessible.

# Arguments
- `client_request_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `deployment_application_configs`: The deployment application configuration.
- `fleet`: The Amazon Resource Name (ARN) of the fleet to deploy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deploymentConfig"`: The requested deployment configuration.
- `"tags"`: A map that contains tag keys and tag values that are attached to the deployment
  job.
"""
function create_deployment_job(
    clientRequestToken,
    deploymentApplicationConfigs,
    fleet;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createDeploymentJob",
        Dict{String,Any}(
            "clientRequestToken" => clientRequestToken,
            "deploymentApplicationConfigs" => deploymentApplicationConfigs,
            "fleet" => fleet,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deployment_job(
    clientRequestToken,
    deploymentApplicationConfigs,
    fleet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createDeploymentJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientRequestToken" => clientRequestToken,
                    "deploymentApplicationConfigs" => deploymentApplicationConfigs,
                    "fleet" => fleet,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet(name)
    create_fleet(name, params::Dict{String,<:Any})

Creates a fleet, a logical group of robots running the same robot application.  This API is
no longer supported and will throw an error if used.

# Arguments
- `name`: The name of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A map that contains tag keys and tag values that are attached to the fleet.
"""
function create_fleet(name; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/createFleet",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_robot(architecture, greengrass_group_id, name)
    create_robot(architecture, greengrass_group_id, name, params::Dict{String,<:Any})

Creates a robot.  This API is no longer supported and will throw an error if used.

# Arguments
- `architecture`: The target architecture of the robot.
- `greengrass_group_id`: The Greengrass group id.
- `name`: The name for the robot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A map that contains tag keys and tag values that are attached to the robot.
"""
function create_robot(
    architecture,
    greengrassGroupId,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createRobot",
        Dict{String,Any}(
            "architecture" => architecture,
            "greengrassGroupId" => greengrassGroupId,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_robot(
    architecture,
    greengrassGroupId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createRobot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "architecture" => architecture,
                    "greengrassGroupId" => greengrassGroupId,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_robot_application(name, robot_software_suite)
    create_robot_application(name, robot_software_suite, params::Dict{String,<:Any})

Creates a robot application.

# Arguments
- `name`: The name of the robot application.
- `robot_software_suite`: The robot software suite (ROS distribuition) used by the robot
  application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"environment"`: The object that contains that URI of the Docker image that you use for
  your robot application.
- `"sources"`: The sources of the robot application.
- `"tags"`: A map that contains tag keys and tag values that are attached to the robot
  application.
"""
function create_robot_application(
    name, robotSoftwareSuite; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createRobotApplication",
        Dict{String,Any}("name" => name, "robotSoftwareSuite" => robotSoftwareSuite);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_robot_application(
    name,
    robotSoftwareSuite,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createRobotApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "robotSoftwareSuite" => robotSoftwareSuite
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_robot_application_version(application)
    create_robot_application_version(application, params::Dict{String,<:Any})

Creates a version of a robot application.

# Arguments
- `application`: The application information for the robot application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentRevisionId"`: The current revision id for the robot application. If you provide
  a value and it matches the latest revision ID, a new version will be created.
- `"imageDigest"`: A SHA256 identifier for the Docker image that you use for your robot
  application.
- `"s3Etags"`: The Amazon S3 identifier for the zip file bundle that you use for your robot
  application.
"""
function create_robot_application_version(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createRobotApplicationVersion",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_robot_application_version(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createRobotApplicationVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_simulation_application(name, robot_software_suite, simulation_software_suite)
    create_simulation_application(name, robot_software_suite, simulation_software_suite, params::Dict{String,<:Any})

Creates a simulation application.

# Arguments
- `name`: The name of the simulation application.
- `robot_software_suite`: The robot software suite (ROS distribution) used by the
  simulation application.
- `simulation_software_suite`: The simulation software suite used by the simulation
  application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"environment"`: The object that contains the Docker image URI used to create your
  simulation application.
- `"renderingEngine"`: The rendering engine for the simulation application.
- `"sources"`: The sources of the simulation application.
- `"tags"`: A map that contains tag keys and tag values that are attached to the simulation
  application.
"""
function create_simulation_application(
    name,
    robotSoftwareSuite,
    simulationSoftwareSuite;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createSimulationApplication",
        Dict{String,Any}(
            "name" => name,
            "robotSoftwareSuite" => robotSoftwareSuite,
            "simulationSoftwareSuite" => simulationSoftwareSuite,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_simulation_application(
    name,
    robotSoftwareSuite,
    simulationSoftwareSuite,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createSimulationApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "robotSoftwareSuite" => robotSoftwareSuite,
                    "simulationSoftwareSuite" => simulationSoftwareSuite,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_simulation_application_version(application)
    create_simulation_application_version(application, params::Dict{String,<:Any})

Creates a simulation application with a specific revision id.

# Arguments
- `application`: The application information for the simulation application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentRevisionId"`: The current revision id for the simulation application. If you
  provide a value and it matches the latest revision ID, a new version will be created.
- `"imageDigest"`: The SHA256 digest used to identify the Docker image URI used to created
  the simulation application.
- `"s3Etags"`: The Amazon S3 eTag identifier for the zip file bundle that you use to create
  the simulation application.
"""
function create_simulation_application_version(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createSimulationApplicationVersion",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_simulation_application_version(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createSimulationApplicationVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_simulation_job(iam_role, max_job_duration_in_seconds)
    create_simulation_job(iam_role, max_job_duration_in_seconds, params::Dict{String,<:Any})

Creates a simulation job.  After 90 days, simulation jobs expire and will be deleted. They
will no longer be accessible.

# Arguments
- `iam_role`: The IAM role name that allows the simulation instance to call the AWS APIs
  that are specified in its associated policies on your behalf. This is how credentials are
  passed in to your simulation job.
- `max_job_duration_in_seconds`: The maximum simulation job duration in seconds (up to 14
  days or 1,209,600 seconds. When maxJobDurationInSeconds is reached, the simulation job will
  status will transition to Completed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"compute"`: Compute information for the simulation job.
- `"dataSources"`: Specify data sources to mount read-only files from S3 into your
  simulation. These files are available under /opt/robomaker/datasources/data_source_name.
  There is a limit of 100 files and a combined size of 25GB for all DataSourceConfig objects.
  
- `"failureBehavior"`: The failure behavior the simulation job.  Continue  Leaves the
  instance running for its maximum timeout duration after a 4XX error code.  Fail  Stop the
  simulation job and terminate the instance.
- `"loggingConfig"`: The logging configuration.
- `"outputLocation"`: Location for output files generated by the simulation job.
- `"robotApplications"`: The robot application to use in the simulation job.
- `"simulationApplications"`: The simulation application to use in the simulation job.
- `"tags"`: A map that contains tag keys and tag values that are attached to the simulation
  job.
- `"vpcConfig"`: If your simulation job accesses resources in a VPC, you provide this
  parameter identifying the list of security group IDs and subnet IDs. These must belong to
  the same VPC. You must provide at least one security group and one subnet ID.
"""
function create_simulation_job(
    iamRole, maxJobDurationInSeconds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createSimulationJob",
        Dict{String,Any}(
            "iamRole" => iamRole,
            "maxJobDurationInSeconds" => maxJobDurationInSeconds,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_simulation_job(
    iamRole,
    maxJobDurationInSeconds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createSimulationJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "iamRole" => iamRole,
                    "maxJobDurationInSeconds" => maxJobDurationInSeconds,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_world_export_job(iam_role, output_location, worlds)
    create_world_export_job(iam_role, output_location, worlds, params::Dict{String,<:Any})

Creates a world export job.

# Arguments
- `iam_role`: The IAM role that the world export process uses to access the Amazon S3
  bucket and put the export.
- `output_location`:
- `worlds`: A list of Amazon Resource Names (arns) that correspond to worlds to export.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"tags"`: A map that contains tag keys and tag values that are attached to the world
  export job.
"""
function create_world_export_job(
    iamRole, outputLocation, worlds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createWorldExportJob",
        Dict{String,Any}(
            "iamRole" => iamRole,
            "outputLocation" => outputLocation,
            "worlds" => worlds,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_world_export_job(
    iamRole,
    outputLocation,
    worlds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createWorldExportJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "iamRole" => iamRole,
                    "outputLocation" => outputLocation,
                    "worlds" => worlds,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_world_generation_job(template, world_count)
    create_world_generation_job(template, world_count, params::Dict{String,<:Any})

Creates worlds using the specified template.

# Arguments
- `template`: The Amazon Resource Name (arn) of the world template describing the worlds
  you want to create.
- `world_count`: Information about the world count.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"tags"`: A map that contains tag keys and tag values that are attached to the world
  generator job.
- `"worldTags"`: A map that contains tag keys and tag values that are attached to the
  generated worlds.
"""
function create_world_generation_job(
    template, worldCount; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createWorldGenerationJob",
        Dict{String,Any}(
            "template" => template,
            "worldCount" => worldCount,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_world_generation_job(
    template,
    worldCount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/createWorldGenerationJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "template" => template,
                    "worldCount" => worldCount,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_world_template()
    create_world_template(params::Dict{String,<:Any})

Creates a world template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"name"`: The name of the world template.
- `"tags"`: A map that contains tag keys and tag values that are attached to the world
  template.
- `"templateBody"`: The world template body.
- `"templateLocation"`: The location of the world template.
"""
function create_world_template(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/createWorldTemplate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_world_template(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/createWorldTemplate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleet(fleet)
    delete_fleet(fleet, params::Dict{String,<:Any})

Deletes a fleet.  This API will no longer be supported as of May 2, 2022. Use it to remove
resources that were created for Deployment Service.

# Arguments
- `fleet`: The Amazon Resource Name (ARN) of the fleet.

"""
function delete_fleet(fleet; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/deleteFleet",
        Dict{String,Any}("fleet" => fleet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleet(
    fleet, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/deleteFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleet" => fleet), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_robot(robot)
    delete_robot(robot, params::Dict{String,<:Any})

Deletes a robot.  This API will no longer be supported as of May 2, 2022. Use it to remove
resources that were created for Deployment Service.

# Arguments
- `robot`: The Amazon Resource Name (ARN) of the robot.

"""
function delete_robot(robot; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/deleteRobot",
        Dict{String,Any}("robot" => robot);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_robot(
    robot, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/deleteRobot",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("robot" => robot), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_robot_application(application)
    delete_robot_application(application, params::Dict{String,<:Any})

Deletes a robot application.

# Arguments
- `application`: The Amazon Resource Name (ARN) of the the robot application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationVersion"`: The version of the robot application to delete.
"""
function delete_robot_application(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/deleteRobotApplication",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_robot_application(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/deleteRobotApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_simulation_application(application)
    delete_simulation_application(application, params::Dict{String,<:Any})

Deletes a simulation application.

# Arguments
- `application`: The application information for the simulation application to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationVersion"`: The version of the simulation application to delete.
"""
function delete_simulation_application(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/deleteSimulationApplication",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_simulation_application(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/deleteSimulationApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_world_template(template)
    delete_world_template(template, params::Dict{String,<:Any})

Deletes a world template.

# Arguments
- `template`: The Amazon Resource Name (arn) of the world template you want to delete.

"""
function delete_world_template(template; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/deleteWorldTemplate",
        Dict{String,Any}("template" => template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_world_template(
    template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/deleteWorldTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("template" => template), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_robot(fleet, robot)
    deregister_robot(fleet, robot, params::Dict{String,<:Any})

Deregisters a robot.  This API will no longer be supported as of May 2, 2022. Use it to
remove resources that were created for Deployment Service.

# Arguments
- `fleet`: The Amazon Resource Name (ARN) of the fleet.
- `robot`: The Amazon Resource Name (ARN) of the robot.

"""
function deregister_robot(fleet, robot; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/deregisterRobot",
        Dict{String,Any}("fleet" => fleet, "robot" => robot);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_robot(
    fleet,
    robot,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/deregisterRobot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("fleet" => fleet, "robot" => robot), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_deployment_job(job)
    describe_deployment_job(job, params::Dict{String,<:Any})

Describes a deployment job.  This API will no longer be supported as of May 2, 2022. Use it
to remove resources that were created for Deployment Service.

# Arguments
- `job`: The Amazon Resource Name (ARN) of the deployment job.

"""
function describe_deployment_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeDeploymentJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_deployment_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeDeploymentJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleet(fleet)
    describe_fleet(fleet, params::Dict{String,<:Any})

Describes a fleet.  This API will no longer be supported as of May 2, 2022. Use it to
remove resources that were created for Deployment Service.

# Arguments
- `fleet`: The Amazon Resource Name (ARN) of the fleet.

"""
function describe_fleet(fleet; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeFleet",
        Dict{String,Any}("fleet" => fleet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fleet(
    fleet, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("fleet" => fleet), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_robot(robot)
    describe_robot(robot, params::Dict{String,<:Any})

Describes a robot.  This API will no longer be supported as of May 2, 2022. Use it to
remove resources that were created for Deployment Service.

# Arguments
- `robot`: The Amazon Resource Name (ARN) of the robot to be described.

"""
function describe_robot(robot; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeRobot",
        Dict{String,Any}("robot" => robot);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_robot(
    robot, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeRobot",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("robot" => robot), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_robot_application(application)
    describe_robot_application(application, params::Dict{String,<:Any})

Describes a robot application.

# Arguments
- `application`: The Amazon Resource Name (ARN) of the robot application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationVersion"`: The version of the robot application to describe.
"""
function describe_robot_application(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeRobotApplication",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_robot_application(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/describeRobotApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_simulation_application(application)
    describe_simulation_application(application, params::Dict{String,<:Any})

Describes a simulation application.

# Arguments
- `application`: The application information for the simulation application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"applicationVersion"`: The version of the simulation application to describe.
"""
function describe_simulation_application(
    application; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeSimulationApplication",
        Dict{String,Any}("application" => application);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_simulation_application(
    application,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/describeSimulationApplication",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("application" => application), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_simulation_job(job)
    describe_simulation_job(job, params::Dict{String,<:Any})

Describes a simulation job.

# Arguments
- `job`: The Amazon Resource Name (ARN) of the simulation job to be described.

"""
function describe_simulation_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeSimulationJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_simulation_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeSimulationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_simulation_job_batch(batch)
    describe_simulation_job_batch(batch, params::Dict{String,<:Any})

Describes a simulation job batch.

# Arguments
- `batch`: The id of the batch to describe.

"""
function describe_simulation_job_batch(
    batch; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeSimulationJobBatch",
        Dict{String,Any}("batch" => batch);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_simulation_job_batch(
    batch, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeSimulationJobBatch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("batch" => batch), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_world(world)
    describe_world(world, params::Dict{String,<:Any})

Describes a world.

# Arguments
- `world`: The Amazon Resource Name (arn) of the world you want to describe.

"""
function describe_world(world; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeWorld",
        Dict{String,Any}("world" => world);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_world(
    world, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeWorld",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("world" => world), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_world_export_job(job)
    describe_world_export_job(job, params::Dict{String,<:Any})

Describes a world export job.

# Arguments
- `job`: The Amazon Resource Name (arn) of the world export job to describe.

"""
function describe_world_export_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/describeWorldExportJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_world_export_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeWorldExportJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_world_generation_job(job)
    describe_world_generation_job(job, params::Dict{String,<:Any})

Describes a world generation job.

# Arguments
- `job`: The Amazon Resource Name (arn) of the world generation job to describe.

"""
function describe_world_generation_job(
    job; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeWorldGenerationJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_world_generation_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeWorldGenerationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_world_template(template)
    describe_world_template(template, params::Dict{String,<:Any})

Describes a world template.

# Arguments
- `template`: The Amazon Resource Name (arn) of the world template you want to describe.

"""
function describe_world_template(
    template; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/describeWorldTemplate",
        Dict{String,Any}("template" => template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_world_template(
    template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/describeWorldTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("template" => template), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_world_template_body()
    get_world_template_body(params::Dict{String,<:Any})

Gets the world template body.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"generationJob"`: The Amazon Resource Name (arn) of the world generator job.
- `"template"`: The Amazon Resource Name (arn) of the world template.
"""
function get_world_template_body(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/getWorldTemplateBody";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_world_template_body(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/getWorldTemplateBody",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deployment_jobs()
    list_deployment_jobs(params::Dict{String,<:Any})

Returns a list of deployment jobs for a fleet. You can optionally provide filters to
retrieve specific deployment jobs.  This API will no longer be supported as of May 2, 2022.
Use it to remove resources that were created for Deployment Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. The filter names status and fleetName are
  supported. When filtering, you must use the complete value of the filtered item. You can
  use up to three filters, but they must be for the same named item. For example, if you are
  looking for items with the status InProgress or the status Pending.
- `"maxResults"`: When this parameter is used, ListDeploymentJobs only returns maxResults
  results in a single page along with a nextToken response element. The remaining results of
  the initial request can be seen by sending another ListDeploymentJobs request with the
  returned nextToken value. This value can be between 1 and 200. If this parameter is not
  used, then ListDeploymentJobs returns up to 200 results and a nextToken value if
  applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListDeploymentJobs again and assign that token to the request
  object's nextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
"""
function list_deployment_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listDeploymentJobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_deployment_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listDeploymentJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_fleets()
    list_fleets(params::Dict{String,<:Any})

Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
This API will no longer be supported as of May 2, 2022. Use it to remove resources that
were created for Deployment Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. The filter name name is supported. When
  filtering, you must use the complete value of the filtered item. You can use up to three
  filters.
- `"maxResults"`: When this parameter is used, ListFleets only returns maxResults results
  in a single page along with a nextToken response element. The remaining results of the
  initial request can be seen by sending another ListFleets request with the returned
  nextToken value. This value can be between 1 and 200. If this parameter is not used, then
  ListFleets returns up to 200 results and a nextToken value if applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListFleets again and assign that token to the request object's
  nextToken parameter. If there are no remaining results, the previous response object's
  NextToken parameter is set to null.   This token should be treated as an opaque identifier
  that is only used to retrieve the next items in a list and not for other programmatic
  purposes.
"""
function list_fleets(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST", "/listFleets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listFleets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_robot_applications()
    list_robot_applications(params::Dict{String,<:Any})

Returns a list of robot application. You can optionally provide filters to retrieve
specific robot applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. The filter name name is supported. When
  filtering, you must use the complete value of the filtered item. You can use up to three
  filters.
- `"maxResults"`: When this parameter is used, ListRobotApplications only returns
  maxResults results in a single page along with a nextToken response element. The remaining
  results of the initial request can be seen by sending another ListRobotApplications request
  with the returned nextToken value. This value can be between 1 and 100. If this parameter
  is not used, then ListRobotApplications returns up to 100 results and a nextToken value if
  applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListRobotApplications again and assign that token to the request
  object's nextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
- `"versionQualifier"`: The version qualifier of the robot application.
"""
function list_robot_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listRobotApplications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_robot_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listRobotApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_robots()
    list_robots(params::Dict{String,<:Any})

Returns a list of robots. You can optionally provide filters to retrieve specific robots.
This API will no longer be supported as of May 2, 2022. Use it to remove resources that
were created for Deployment Service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. The filter names status and fleetName are
  supported. When filtering, you must use the complete value of the filtered item. You can
  use up to three filters, but they must be for the same named item. For example, if you are
  looking for items with the status Registered or the status Available.
- `"maxResults"`: When this parameter is used, ListRobots only returns maxResults results
  in a single page along with a nextToken response element. The remaining results of the
  initial request can be seen by sending another ListRobots request with the returned
  nextToken value. This value can be between 1 and 200. If this parameter is not used, then
  ListRobots returns up to 200 results and a nextToken value if applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListRobots again and assign that token to the request object's
  nextToken parameter. If there are no remaining results, the previous response object's
  NextToken parameter is set to null.
"""
function list_robots(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST", "/listRobots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_robots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listRobots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_simulation_applications()
    list_simulation_applications(params::Dict{String,<:Any})

Returns a list of simulation applications. You can optionally provide filters to retrieve
specific simulation applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional list of filters to limit results. The filter name name is
  supported. When filtering, you must use the complete value of the filtered item. You can
  use up to three filters.
- `"maxResults"`: When this parameter is used, ListSimulationApplications only returns
  maxResults results in a single page along with a nextToken response element. The remaining
  results of the initial request can be seen by sending another ListSimulationApplications
  request with the returned nextToken value. This value can be between 1 and 100. If this
  parameter is not used, then ListSimulationApplications returns up to 100 results and a
  nextToken value if applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListSimulationApplications again and assign that token to the
  request object's nextToken parameter. If there are no remaining results, the previous
  response object's NextToken parameter is set to null.
- `"versionQualifier"`: The version qualifier of the simulation application.
"""
function list_simulation_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listSimulationApplications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_simulation_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listSimulationApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_simulation_job_batches()
    list_simulation_job_batches(params::Dict{String,<:Any})

Returns a list simulation job batches. You can optionally provide filters to retrieve
specific simulation batch jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results.
- `"maxResults"`: When this parameter is used, ListSimulationJobBatches only returns
  maxResults results in a single page along with a nextToken response element. The remaining
  results of the initial request can be seen by sending another ListSimulationJobBatches
  request with the returned nextToken value.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListSimulationJobBatches again and assign that token to the
  request object's nextToken parameter. If there are no remaining results, the previous
  response object's NextToken parameter is set to null.
"""
function list_simulation_job_batches(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listSimulationJobBatches";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_simulation_job_batches(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listSimulationJobBatches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_simulation_jobs()
    list_simulation_jobs(params::Dict{String,<:Any})

Returns a list of simulation jobs. You can optionally provide filters to retrieve specific
simulation jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. The filter names status and
  simulationApplicationName and robotApplicationName are supported. When filtering, you must
  use the complete value of the filtered item. You can use up to three filters, but they must
  be for the same named item. For example, if you are looking for items with the status
  Preparing or the status Running.
- `"maxResults"`: When this parameter is used, ListSimulationJobs only returns maxResults
  results in a single page along with a nextToken response element. The remaining results of
  the initial request can be seen by sending another ListSimulationJobs request with the
  returned nextToken value. This value can be between 1 and 1000. If this parameter is not
  used, then ListSimulationJobs returns up to 1000 results and a nextToken value if
  applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListSimulationJobs again and assign that token to the request
  object's nextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
"""
function list_simulation_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listSimulationJobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_simulation_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listSimulationJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all tags on a AWS RoboMaker resource.

# Arguments
- `resource_arn`: The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_world_export_jobs()
    list_world_export_jobs(params::Dict{String,<:Any})

Lists world export jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. You can use generationJobId and
  templateId.
- `"maxResults"`: When this parameter is used, ListWorldExportJobs only returns maxResults
  results in a single page along with a nextToken response element. The remaining results of
  the initial request can be seen by sending another ListWorldExportJobs request with the
  returned nextToken value. This value can be between 1 and 100. If this parameter is not
  used, then ListWorldExportJobs returns up to 100 results and a nextToken value if
  applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListWorldExportJobs again and assign that token to the request
  object's nextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
"""
function list_world_export_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listWorldExportJobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_world_export_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listWorldExportJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_world_generation_jobs()
    list_world_generation_jobs(params::Dict{String,<:Any})

Lists world generator jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. You can use status and templateId.
- `"maxResults"`: When this parameter is used, ListWorldGeneratorJobs only returns
  maxResults results in a single page along with a nextToken response element. The remaining
  results of the initial request can be seen by sending another ListWorldGeneratorJobs
  request with the returned nextToken value. This value can be between 1 and 100. If this
  parameter is not used, then ListWorldGeneratorJobs returns up to 100 results and a
  nextToken value if applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListWorldGenerationJobsRequest again and assign that token to the
  request object's nextToken parameter. If there are no remaining results, the previous
  response object's NextToken parameter is set to null.
"""
function list_world_generation_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listWorldGenerationJobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_world_generation_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listWorldGenerationJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_world_templates()
    list_world_templates(params::Dict{String,<:Any})

Lists world templates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: When this parameter is used, ListWorldTemplates only returns maxResults
  results in a single page along with a nextToken response element. The remaining results of
  the initial request can be seen by sending another ListWorldTemplates request with the
  returned nextToken value. This value can be between 1 and 100. If this parameter is not
  used, then ListWorldTemplates returns up to 100 results and a nextToken value if
  applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListWorldTemplates again and assign that token to the request
  object's nextToken parameter. If there are no remaining results, the previous response
  object's NextToken parameter is set to null.
"""
function list_world_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/listWorldTemplates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_world_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listWorldTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_worlds()
    list_worlds(params::Dict{String,<:Any})

Lists worlds.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Optional filters to limit results. You can use status.
- `"maxResults"`: When this parameter is used, ListWorlds only returns maxResults results
  in a single page along with a nextToken response element. The remaining results of the
  initial request can be seen by sending another ListWorlds request with the returned
  nextToken value. This value can be between 1 and 100. If this parameter is not used, then
  ListWorlds returns up to 100 results and a nextToken value if applicable.
- `"nextToken"`: If the previous paginated request did not return all of the remaining
  results, the response object's nextToken parameter value is set to a token. To retrieve the
  next set of results, call ListWorlds again and assign that token to the request object's
  nextToken parameter. If there are no remaining results, the previous response object's
  NextToken parameter is set to null.
"""
function list_worlds(; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST", "/listWorlds"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_worlds(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/listWorlds",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_robot(fleet, robot)
    register_robot(fleet, robot, params::Dict{String,<:Any})

Registers a robot with a fleet.  This API is no longer supported and will throw an error if
used.

# Arguments
- `fleet`: The Amazon Resource Name (ARN) of the fleet.
- `robot`: The Amazon Resource Name (ARN) of the robot.

"""
function register_robot(fleet, robot; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/registerRobot",
        Dict{String,Any}("fleet" => fleet, "robot" => robot);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_robot(
    fleet,
    robot,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/registerRobot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("fleet" => fleet, "robot" => robot), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restart_simulation_job(job)
    restart_simulation_job(job, params::Dict{String,<:Any})

Restarts a running simulation job.

# Arguments
- `job`: The Amazon Resource Name (ARN) of the simulation job.

"""
function restart_simulation_job(job; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/restartSimulationJob",
        Dict{String,Any}("job" => job);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restart_simulation_job(
    job, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/restartSimulationJob",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("job" => job), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_simulation_job_batch(create_simulation_job_requests)
    start_simulation_job_batch(create_simulation_job_requests, params::Dict{String,<:Any})

Starts a new simulation job batch. The batch is defined using one or more
SimulationJobRequest objects.

# Arguments
- `create_simulation_job_requests`: A list of simulation job requests to create in the
  batch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"batchPolicy"`: The batch policy.
- `"clientRequestToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"tags"`: A map that contains tag keys and tag values that are attached to the deployment
  job batch.
"""
function start_simulation_job_batch(
    createSimulationJobRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/startSimulationJobBatch",
        Dict{String,Any}(
            "createSimulationJobRequests" => createSimulationJobRequests,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_simulation_job_batch(
    createSimulationJobRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/startSimulationJobBatch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "createSimulationJobRequests" => createSimulationJobRequests,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    sync_deployment_job(client_request_token, fleet)
    sync_deployment_job(client_request_token, fleet, params::Dict{String,<:Any})

Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were
added after a deployment.  This API will no longer be supported as of May 2, 2022. Use it
to remove resources that were created for Deployment Service.

# Arguments
- `client_request_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `fleet`: The target fleet for the synchronization.

"""
function sync_deployment_job(
    clientRequestToken, fleet; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/syncDeploymentJob",
        Dict{String,Any}("clientRequestToken" => clientRequestToken, "fleet" => fleet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function sync_deployment_job(
    clientRequestToken,
    fleet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/syncDeploymentJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientRequestToken" => clientRequestToken, "fleet" => fleet
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or edits tags for a AWS RoboMaker resource. Each tag consists of a tag key and a tag
value. Tag keys and tag values are both required, but tag values can be empty strings.  For
information about the rules that apply to tag keys and tag values, see User-Defined Tag
Restrictions in the AWS Billing and Cost Management User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are
  tagging.
- `tags`: A map that contains tag keys and tag values that are attached to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified AWS RoboMaker resource. To remove a tag,
specify the tag key. To change the tag value of an existing tag key, use  TagResource .

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are
  removing tags.
- `tag_keys`: A map that contains tag keys and tag values that will be unattached from the
  resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_robot_application(application, robot_software_suite)
    update_robot_application(application, robot_software_suite, params::Dict{String,<:Any})

Updates a robot application.

# Arguments
- `application`: The application information for the robot application.
- `robot_software_suite`: The robot software suite (ROS distribution) used by the robot
  application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentRevisionId"`: The revision id for the robot application.
- `"environment"`: The object that contains the Docker image URI for your robot application.
- `"sources"`: The sources of the robot application.
"""
function update_robot_application(
    application, robotSoftwareSuite; aws_config::AbstractAWSConfig=current_aws_config()
)
    return robomaker(
        "POST",
        "/updateRobotApplication",
        Dict{String,Any}(
            "application" => application, "robotSoftwareSuite" => robotSoftwareSuite
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_robot_application(
    application,
    robotSoftwareSuite,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/updateRobotApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "application" => application, "robotSoftwareSuite" => robotSoftwareSuite
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_simulation_application(application, robot_software_suite, simulation_software_suite)
    update_simulation_application(application, robot_software_suite, simulation_software_suite, params::Dict{String,<:Any})

Updates a simulation application.

# Arguments
- `application`: The application information for the simulation application.
- `robot_software_suite`: Information about the robot software suite (ROS distribution).
- `simulation_software_suite`: The simulation software suite used by the simulation
  application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentRevisionId"`: The revision id for the robot application.
- `"environment"`: The object that contains the Docker image URI for your simulation
  application.
- `"renderingEngine"`: The rendering engine for the simulation application.
- `"sources"`: The sources of the simulation application.
"""
function update_simulation_application(
    application,
    robotSoftwareSuite,
    simulationSoftwareSuite;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/updateSimulationApplication",
        Dict{String,Any}(
            "application" => application,
            "robotSoftwareSuite" => robotSoftwareSuite,
            "simulationSoftwareSuite" => simulationSoftwareSuite,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_simulation_application(
    application,
    robotSoftwareSuite,
    simulationSoftwareSuite,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/updateSimulationApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "application" => application,
                    "robotSoftwareSuite" => robotSoftwareSuite,
                    "simulationSoftwareSuite" => simulationSoftwareSuite,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_world_template(template)
    update_world_template(template, params::Dict{String,<:Any})

Updates a world template.

# Arguments
- `template`: The Amazon Resource Name (arn) of the world template to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"name"`: The name of the template.
- `"templateBody"`: The world template body.
- `"templateLocation"`: The location of the world template.
"""
function update_world_template(template; aws_config::AbstractAWSConfig=current_aws_config())
    return robomaker(
        "POST",
        "/updateWorldTemplate",
        Dict{String,Any}("template" => template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_world_template(
    template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return robomaker(
        "POST",
        "/updateWorldTemplate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("template" => template), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
