# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sagemaker_runtime
using AWS.Compat
using AWS.UUIDs

"""
    invoke_endpoint(body, endpoint_name)
    invoke_endpoint(body, endpoint_name, params::Dict{String,<:Any})

After you deploy a model into production using Amazon SageMaker hosting services, your
client applications use this API to get inferences from the model hosted at the specified
endpoint.  For an overview of Amazon SageMaker, see How It Works.  Amazon SageMaker strips
all POST headers except those supported by the API. Amazon SageMaker might add additional
headers. You should not rely on the behavior of headers outside those enumerated in the
request syntax.  Calls to InvokeEndpoint are authenticated by using Amazon Web Services
Signature Version 4. For information, see Authenticating Requests (Amazon Web Services
Signature Version 4) in the Amazon S3 API Reference. A customer's model containers must
respond to requests within 60 seconds. The model itself can have a maximum processing time
of 60 seconds before responding to invocations. If your model is going to take 50-60
seconds of processing time, the SDK socket timeout should be set to be 70 seconds.
Endpoints are scoped to an individual account, and are not public. The URL does not contain
the account ID, but Amazon SageMaker determines the account ID from the authentication
token that is supplied by the caller.

# Arguments
- `body`: Provides input data, in the format specified in the ContentType request header.
  Amazon SageMaker passes all of the data in the body to the model.  For information about
  the format of the request body, see Common Data Formats-Inference.
- `endpoint_name`: The name of the endpoint that you specified when you created the
  endpoint using the CreateEndpoint API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Accept"`: The desired MIME type of the inference response from the model container.
- `"Content-Type"`: The MIME type of the input data in the request body.
- `"X-Amzn-SageMaker-Custom-Attributes"`: Provides additional information about a request
  for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The
  information is an opaque value that is forwarded verbatim. You could use this value, for
  example, to provide an ID that you can use to track a request or to provide other metadata
  that a service endpoint was programmed to process. The value must consist of no more than
  1024 visible US-ASCII characters as specified in Section 3.3.6. Field Value Components of
  the Hypertext Transfer Protocol (HTTP/1.1).  The code in your model is responsible for
  setting or updating any custom attributes in the response. If your code does not set this
  value in the response, an empty value is returned. For example, if a custom attribute
  represents the trace ID, your model can prepend the custom attribute with Trace ID: in your
  post-processing function.  This feature is currently supported in the Amazon Web Services
  SDKs but not in the Amazon SageMaker Python SDK.
- `"X-Amzn-SageMaker-Enable-Explanations"`: An optional JMESPath expression used to
  override the EnableExplanations parameter of the ClarifyExplainerConfig API. See the
  EnableExplanations section in the developer guide for more information.
- `"X-Amzn-SageMaker-Inference-Component"`: If the endpoint hosts one or more inference
  components, this parameter specifies the name of inference component to invoke.
- `"X-Amzn-SageMaker-Inference-Id"`: If you provide a value, it is added to the captured
  data when you enable data capture on the endpoint. For information about data capture, see
  Capture Data.
- `"X-Amzn-SageMaker-Target-Container-Hostname"`: If the endpoint hosts multiple containers
  and is configured to use direct invocation, this parameter specifies the host name of the
  container to invoke.
- `"X-Amzn-SageMaker-Target-Model"`: The model to request for inference when invoking a
  multi-model endpoint.
- `"X-Amzn-SageMaker-Target-Variant"`: Specify the production variant to send the inference
  request to when invoking an endpoint that is running two or more variants. Note that this
  parameter overrides the default behavior for the endpoint, which is to distribute the
  invocation traffic based on the variant weights. For information about how to use variant
  targeting to perform a/b testing, see Test models in production
"""
function invoke_endpoint(
    Body, EndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/invocations",
        Dict{String,Any}("Body" => Body);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_endpoint(
    Body,
    EndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/invocations",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Body" => Body), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invoke_endpoint_async(endpoint_name, x-_amzn-_sage_maker-_input_location)
    invoke_endpoint_async(endpoint_name, x-_amzn-_sage_maker-_input_location, params::Dict{String,<:Any})

After you deploy a model into production using Amazon SageMaker hosting services, your
client applications use this API to get inferences from the model hosted at the specified
endpoint in an asynchronous manner. Inference requests sent to this API are enqueued for
asynchronous processing. The processing of the inference request may or may not complete
before you receive a response from this API. The response from this API will not contain
the result of the inference request but contain information about where you can locate it.
Amazon SageMaker strips all POST headers except those supported by the API. Amazon
SageMaker might add additional headers. You should not rely on the behavior of headers
outside those enumerated in the request syntax.  Calls to InvokeEndpointAsync are
authenticated by using Amazon Web Services Signature Version 4. For information, see
Authenticating Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
Reference.

# Arguments
- `endpoint_name`: The name of the endpoint that you specified when you created the
  endpoint using the CreateEndpoint API.
- `x-_amzn-_sage_maker-_input_location`: The Amazon S3 URI where the inference request
  payload is stored.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-SageMaker-Accept"`: The desired MIME type of the inference response from the
  model container.
- `"X-Amzn-SageMaker-Content-Type"`: The MIME type of the input data in the request body.
- `"X-Amzn-SageMaker-Custom-Attributes"`: Provides additional information about a request
  for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The
  information is an opaque value that is forwarded verbatim. You could use this value, for
  example, to provide an ID that you can use to track a request or to provide other metadata
  that a service endpoint was programmed to process. The value must consist of no more than
  1024 visible US-ASCII characters as specified in Section 3.3.6. Field Value Components of
  the Hypertext Transfer Protocol (HTTP/1.1).  The code in your model is responsible for
  setting or updating any custom attributes in the response. If your code does not set this
  value in the response, an empty value is returned. For example, if a custom attribute
  represents the trace ID, your model can prepend the custom attribute with Trace ID: in your
  post-processing function.  This feature is currently supported in the Amazon Web Services
  SDKs but not in the Amazon SageMaker Python SDK.
- `"X-Amzn-SageMaker-Inference-Id"`: The identifier for the inference request. Amazon
  SageMaker will generate an identifier for you if none is specified.
- `"X-Amzn-SageMaker-InvocationTimeoutSeconds"`: Maximum amount of time in seconds a
  request can be processed before it is marked as expired. The default is 15 minutes, or 900
  seconds.
- `"X-Amzn-SageMaker-RequestTTLSeconds"`: Maximum age in seconds a request can be in the
  queue before it is marked as expired. The default is 6 hours, or 21,600 seconds.
"""
function invoke_endpoint_async(
    EndpointName,
    X_Amzn_SageMaker_InputLocation;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/async-invocations",
        Dict{String,Any}(
            "headers" => Dict{String,Any}(
                "X-Amzn-SageMaker-InputLocation" => X_Amzn_SageMaker_InputLocation
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_endpoint_async(
    EndpointName,
    X_Amzn_SageMaker_InputLocation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/async-invocations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "headers" => Dict{String,Any}(
                        "X-Amzn-SageMaker-InputLocation" =>
                            X_Amzn_SageMaker_InputLocation,
                    ),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invoke_endpoint_with_response_stream(body, endpoint_name)
    invoke_endpoint_with_response_stream(body, endpoint_name, params::Dict{String,<:Any})

Invokes a model at the specified endpoint to return the inference response as a stream. The
inference stream provides the response payload incrementally as a series of parts. Before
you can get an inference stream, you must have access to a model that's deployed using
Amazon SageMaker hosting services, and the container for that model must support inference
streaming. For more information that can help you use this API, see the following sections
in the Amazon SageMaker Developer Guide:   For information about how to add streaming
support to a model, see How Containers Serve Requests.   For information about how to
process the streaming response, see Invoke real-time endpoints.   Before you can use this
operation, your IAM permissions must allow the sagemaker:InvokeEndpoint action. For more
information about Amazon SageMaker actions for IAM policies, see Actions, resources, and
condition keys for Amazon SageMaker in the IAM Service Authorization Reference. Amazon
SageMaker strips all POST headers except those supported by the API. Amazon SageMaker might
add additional headers. You should not rely on the behavior of headers outside those
enumerated in the request syntax.  Calls to InvokeEndpointWithResponseStream are
authenticated by using Amazon Web Services Signature Version 4. For information, see
Authenticating Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
Reference.

# Arguments
- `body`: Provides input data, in the format specified in the ContentType request header.
  Amazon SageMaker passes all of the data in the body to the model.  For information about
  the format of the request body, see Common Data Formats-Inference.
- `endpoint_name`: The name of the endpoint that you specified when you created the
  endpoint using the CreateEndpoint API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content-Type"`: The MIME type of the input data in the request body.
- `"X-Amzn-SageMaker-Accept"`: The desired MIME type of the inference response from the
  model container.
- `"X-Amzn-SageMaker-Custom-Attributes"`: Provides additional information about a request
  for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The
  information is an opaque value that is forwarded verbatim. You could use this value, for
  example, to provide an ID that you can use to track a request or to provide other metadata
  that a service endpoint was programmed to process. The value must consist of no more than
  1024 visible US-ASCII characters as specified in Section 3.3.6. Field Value Components of
  the Hypertext Transfer Protocol (HTTP/1.1).  The code in your model is responsible for
  setting or updating any custom attributes in the response. If your code does not set this
  value in the response, an empty value is returned. For example, if a custom attribute
  represents the trace ID, your model can prepend the custom attribute with Trace ID: in your
  post-processing function.  This feature is currently supported in the Amazon Web Services
  SDKs but not in the Amazon SageMaker Python SDK.
- `"X-Amzn-SageMaker-Inference-Component"`: If the endpoint hosts one or more inference
  components, this parameter specifies the name of inference component to invoke for a
  streaming response.
- `"X-Amzn-SageMaker-Inference-Id"`: An identifier that you assign to your request.
- `"X-Amzn-SageMaker-Target-Container-Hostname"`: If the endpoint hosts multiple containers
  and is configured to use direct invocation, this parameter specifies the host name of the
  container to invoke.
- `"X-Amzn-SageMaker-Target-Variant"`: Specify the production variant to send the inference
  request to when invoking an endpoint that is running two or more variants. Note that this
  parameter overrides the default behavior for the endpoint, which is to distribute the
  invocation traffic based on the variant weights. For information about how to use variant
  targeting to perform a/b testing, see Test models in production
"""
function invoke_endpoint_with_response_stream(
    Body, EndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/invocations-response-stream",
        Dict{String,Any}("Body" => Body);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_endpoint_with_response_stream(
    Body,
    EndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sagemaker_runtime(
        "POST",
        "/endpoints/$(EndpointName)/invocations-response-stream",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Body" => Body), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
