# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sesv2
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_metric_data(queries)
    batch_get_metric_data(queries, params::Dict{String,<:Any})

Retrieves batches of metric data collected based on your sending activity. You can execute
this operation no more than 16 times per second, and with at most 160 queries from the
batches per second (cumulative).

# Arguments
- `queries`: A list of queries for metrics to be retrieved.

"""
function batch_get_metric_data(Queries; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/metrics/batch",
        Dict{String,Any}("Queries" => Queries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_metric_data(
    Queries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/metrics/batch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Queries" => Queries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_export_job(job_id)
    cancel_export_job(job_id, params::Dict{String,<:Any})

Cancels an export job.

# Arguments
- `job_id`: The export job ID.

"""
function cancel_export_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "PUT",
        "/v2/email/export-jobs/$(JobId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_export_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/export-jobs/$(JobId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set(configuration_set_name)
    create_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Create a configuration set. Configuration sets are groups of rules that you can apply to
the emails that you send. You apply a configuration set to an email by specifying the name
of the configuration set when you call the Amazon SES API v2. When you apply a
configuration set to an email, all of the rules in that configuration set are applied to
the email.

# Arguments
- `configuration_set_name`: The name of the configuration set. The name can contain up to
  64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_)
  only.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryOptions"`: An object that defines the dedicated IP pool that is used to send
  emails that you send using the configuration set.
- `"ReputationOptions"`: An object that defines whether or not Amazon SES collects
  reputation metrics for the emails that you send that use the configuration set.
- `"SendingOptions"`: An object that defines whether or not Amazon SES can send email that
  you send using the configuration set.
- `"SuppressionOptions"`:
- `"Tags"`: An array of objects that define the tags (keys and values) to associate with
  the configuration set.
- `"TrackingOptions"`: An object that defines the open and click tracking options for
  emails that you send using the configuration set.
- `"VdmOptions"`: An object that defines the VDM options for emails that you send using the
  configuration set.
"""
function create_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/configuration-sets",
        Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/configuration-sets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConfigurationSetName" => ConfigurationSetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration_set_event_destination(configuration_set_name, event_destination, event_destination_name)
    create_configuration_set_event_destination(configuration_set_name, event_destination, event_destination_name, params::Dict{String,<:Any})

Create an event destination. Events include message sends, deliveries, opens, clicks,
bounces, and complaints. Event destinations are places that you can send information about
these events to. For example, you can send event data to Amazon EventBridge and associate a
rule to send the event to the specified target. A single configuration set can include more
than one event destination.

# Arguments
- `configuration_set_name`: The name of the configuration set .
- `event_destination`: An object that defines the event destination.
- `event_destination_name`: A name that identifies the event destination within the
  configuration set.

"""
function create_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations",
        Dict{String,Any}(
            "EventDestination" => EventDestination,
            "EventDestinationName" => EventDestinationName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EventDestination" => EventDestination,
                    "EventDestinationName" => EventDestinationName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_contact(contact_list_name, email_address)
    create_contact(contact_list_name, email_address, params::Dict{String,<:Any})

Creates a contact, which is an end-user who is receiving the email, and adds them to a
contact list.

# Arguments
- `contact_list_name`: The name of the contact list to which the contact should be added.
- `email_address`: The contact's email address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesData"`: The attribute data attached to a contact.
- `"TopicPreferences"`: The contact's preferences for being opted-in to or opted-out of
  topics.
- `"UnsubscribeAll"`: A boolean value status noting if the contact is unsubscribed from all
  contact list topics.
"""
function create_contact(
    ContactListName, EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/contact-lists/$(ContactListName)/contacts",
        Dict{String,Any}("EmailAddress" => EmailAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_contact(
    ContactListName,
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/contact-lists/$(ContactListName)/contacts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EmailAddress" => EmailAddress), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_contact_list(contact_list_name)
    create_contact_list(contact_list_name, params::Dict{String,<:Any})

Creates a contact list.

# Arguments
- `contact_list_name`: The name of the contact list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of what the contact list is about.
- `"Tags"`: The tags associated with a contact list.
- `"Topics"`: An interest group, theme, or label within a list. A contact list can have
  multiple topics.
"""
function create_contact_list(
    ContactListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/contact-lists",
        Dict{String,Any}("ContactListName" => ContactListName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_contact_list(
    ContactListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/contact-lists",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactListName" => ContactListName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject)
    create_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject, params::Dict{String,<:Any})

Creates a new custom verification email template. For more information about custom
verification email templates, see Using custom verification email templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `failure_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is not successfully verified.
- `from_email_address`: The email address that the custom verification email is sent from.
- `success_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is successfully verified.
- `template_content`: The content of the custom verification email. The total size of the
  email must be less than 10 MB. The message body may contain HTML, with some limitations.
  For more information, see Custom verification email frequently asked questions in the
  Amazon SES Developer Guide.
- `template_name`: The name of the custom verification email template.
- `template_subject`: The subject line of the custom verification email.

"""
function create_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/custom-verification-email-templates",
        Dict{String,Any}(
            "FailureRedirectionURL" => FailureRedirectionURL,
            "FromEmailAddress" => FromEmailAddress,
            "SuccessRedirectionURL" => SuccessRedirectionURL,
            "TemplateContent" => TemplateContent,
            "TemplateName" => TemplateName,
            "TemplateSubject" => TemplateSubject,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/custom-verification-email-templates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FailureRedirectionURL" => FailureRedirectionURL,
                    "FromEmailAddress" => FromEmailAddress,
                    "SuccessRedirectionURL" => SuccessRedirectionURL,
                    "TemplateContent" => TemplateContent,
                    "TemplateName" => TemplateName,
                    "TemplateSubject" => TemplateSubject,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dedicated_ip_pool(pool_name)
    create_dedicated_ip_pool(pool_name, params::Dict{String,<:Any})

Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP
addresses that are associated with your Amazon Web Services account. You can associate a
pool with a configuration set. When you send an email that uses that configuration set, the
message is sent from one of the addresses in the associated pool.

# Arguments
- `pool_name`: The name of the dedicated IP pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ScalingMode"`: The type of scaling mode.
- `"Tags"`: An object that defines the tags (keys and values) that you want to associate
  with the pool.
"""
function create_dedicated_ip_pool(
    PoolName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/dedicated-ip-pools",
        Dict{String,Any}("PoolName" => PoolName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dedicated_ip_pool(
    PoolName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/dedicated-ip-pools",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PoolName" => PoolName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_deliverability_test_report(content, from_email_address)
    create_deliverability_test_report(content, from_email_address, params::Dict{String,<:Any})

Create a new predictive inbox placement test. Predictive inbox placement tests can help you
predict how your messages will be handled by various email providers around the world. When
you perform a predictive inbox placement test, you provide a sample message that contains
the content that you plan to send to your customers. Amazon SES then sends that message to
special email addresses spread across several major email providers. After about 24 hours,
the test is complete, and you can use the GetDeliverabilityTestReport operation to view the
results of the test.

# Arguments
- `content`: The HTML body of the message that you sent when you performed the predictive
  inbox placement test.
- `from_email_address`: The email address that the predictive inbox placement test email
  was sent from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReportName"`: A unique name that helps you to identify the predictive inbox placement
  test when you retrieve the results.
- `"Tags"`: An array of objects that define the tags (keys and values) that you want to
  associate with the predictive inbox placement test.
"""
function create_deliverability_test_report(
    Content, FromEmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/deliverability-dashboard/test",
        Dict{String,Any}("Content" => Content, "FromEmailAddress" => FromEmailAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deliverability_test_report(
    Content,
    FromEmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/deliverability-dashboard/test",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Content" => Content, "FromEmailAddress" => FromEmailAddress
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_email_identity(email_identity)
    create_email_identity(email_identity, params::Dict{String,<:Any})

Starts the process of verifying an email identity. An identity is an email address or
domain that you use when you send email. Before you can use an identity to send email, you
first have to verify it. By verifying an identity, you demonstrate that you're the owner of
the identity, and that you've given Amazon SES API v2 permission to send email from the
identity. When you verify an email address, Amazon SES sends an email to the address. Your
email address is verified as soon as you follow the link in the verification email.  When
you verify a domain without specifying the DkimSigningAttributes object, this operation
provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you
then add to the DNS configuration for your domain. Your domain is verified when Amazon SES
detects these records in the DNS configuration for your domain. This verification method is
known as Easy DKIM. Alternatively, you can perform the verification process by providing
your own public-private key pair. This verification method is known as Bring Your Own DKIM
(BYODKIM). To use BYODKIM, your call to the CreateEmailIdentity operation has to include
the DkimSigningAttributes object. When you specify this object, you provide a selector (a
component of the DNS record name that identifies the public key to use for DKIM
authentication) and a private key. When you verify a domain, this operation provides a set
of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the
DNS configuration for your domain. Your domain is verified when Amazon SES detects these
records in the DNS configuration for your domain. For some DNS providers, it can take 72
hours or more to complete the domain verification process. Additionally, you can associate
an existing configuration set with the email identity that you're verifying.

# Arguments
- `email_identity`: The email address or domain to verify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The configuration set to use by default when sending from this
  identity. Note that any configuration set defined in the email sending request takes
  precedence.
- `"DkimSigningAttributes"`: If your request includes this object, Amazon SES configures
  the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or,
  configures the key length to be used for Easy DKIM. You can only specify this object if the
  email identity is a domain, as opposed to an address.
- `"Tags"`: An array of objects that define the tags (keys and values) to associate with
  the email identity.
"""
function create_email_identity(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/identities",
        Dict{String,Any}("EmailIdentity" => EmailIdentity);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_email_identity(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/identities",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EmailIdentity" => EmailIdentity), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_email_identity_policy(email_identity, policy, policy_name)
    create_email_identity_policy(email_identity, policy, policy_name, params::Dict{String,<:Any})

Creates the specified sending authorization policy for the given identity (an email address
or a domain).  This API is for the identity owner only. If you have not verified the
identity, this API will return an error.  Sending authorization is a feature that enables
an identity owner to authorize other senders to use its identities. For information about
using sending authorization, see the Amazon SES Developer Guide. You can execute this
operation no more than once per second.

# Arguments
- `email_identity`: The email identity.
- `policy`: The text of the policy in JSON format. The policy cannot exceed 4 KB. For
  information about the syntax of sending authorization policies, see the Amazon SES
  Developer Guide.
- `policy_name`: The name of the policy. The policy name cannot exceed 64 characters and
  can only include alphanumeric characters, dashes, and underscores.

"""
function create_email_identity_policy(
    EmailIdentity, Policy, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_email_identity_policy(
    EmailIdentity,
    Policy,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_email_template(template_content, template_name)
    create_email_template(template_content, template_name, params::Dict{String,<:Any})

Creates an email template. Email templates enable you to send personalized email to one or
more destinations in a single API operation. For more information, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `template_content`: The content of the email template, composed of a subject line, an
  HTML part, and a text-only part.
- `template_name`: The name of the template.

"""
function create_email_template(
    TemplateContent, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/templates",
        Dict{String,Any}(
            "TemplateContent" => TemplateContent, "TemplateName" => TemplateName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_email_template(
    TemplateContent,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/templates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TemplateContent" => TemplateContent, "TemplateName" => TemplateName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_export_job(export_data_source, export_destination)
    create_export_job(export_data_source, export_destination, params::Dict{String,<:Any})

Creates an export job for a data source and destination. You can execute this operation no
more than once per second.

# Arguments
- `export_data_source`: The data source for the export job.
- `export_destination`: The destination for the export job.

"""
function create_export_job(
    ExportDataSource, ExportDestination; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/export-jobs",
        Dict{String,Any}(
            "ExportDataSource" => ExportDataSource, "ExportDestination" => ExportDestination
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_export_job(
    ExportDataSource,
    ExportDestination,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/export-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ExportDataSource" => ExportDataSource,
                    "ExportDestination" => ExportDestination,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_import_job(import_data_source, import_destination)
    create_import_job(import_data_source, import_destination, params::Dict{String,<:Any})

Creates an import job for a data destination.

# Arguments
- `import_data_source`: The data source for the import job.
- `import_destination`: The destination for the import job.

"""
function create_import_job(
    ImportDataSource, ImportDestination; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/import-jobs",
        Dict{String,Any}(
            "ImportDataSource" => ImportDataSource, "ImportDestination" => ImportDestination
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_import_job(
    ImportDataSource,
    ImportDestination,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/import-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ImportDataSource" => ImportDataSource,
                    "ImportDestination" => ImportDestination,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set(configuration_set_name)
    delete_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Delete an existing configuration set.  Configuration sets are groups of rules that you can
apply to the emails you send. You apply a configuration set to an email by including a
reference to the configuration set in the headers of the email. When you apply a
configuration set to an email, all of the rules in that configuration set are applied to
the email.

# Arguments
- `configuration_set_name`: The name of the configuration set.

"""
function delete_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/configuration-sets/$(ConfigurationSetName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/configuration-sets/$(ConfigurationSetName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration_set_event_destination(configuration_set_name, event_destination_name)
    delete_configuration_set_event_destination(configuration_set_name, event_destination_name, params::Dict{String,<:Any})

Delete an event destination.  Events include message sends, deliveries, opens, clicks,
bounces, and complaints. Event destinations are places that you can send information about
these events to. For example, you can send event data to Amazon EventBridge and associate a
rule to send the event to the specified target.

# Arguments
- `configuration_set_name`: The name of the configuration set that contains the event
  destination to delete.
- `event_destination_name`: The name of the event destination to delete.

"""
function delete_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations/$(EventDestinationName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations/$(EventDestinationName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_contact(contact_list_name, email_address)
    delete_contact(contact_list_name, email_address, params::Dict{String,<:Any})

Removes a contact from a contact list.

# Arguments
- `contact_list_name`: The name of the contact list from which the contact should be
  removed.
- `email_address`: The contact's email address.

"""
function delete_contact(
    ContactListName, EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_contact(
    ContactListName,
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_contact_list(contact_list_name)
    delete_contact_list(contact_list_name, params::Dict{String,<:Any})

Deletes a contact list and all of the contacts on that list.

# Arguments
- `contact_list_name`: The name of the contact list.

"""
function delete_contact_list(
    ContactListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/contact-lists/$(ContactListName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_contact_list(
    ContactListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/contact-lists/$(ContactListName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_verification_email_template(template_name)
    delete_custom_verification_email_template(template_name, params::Dict{String,<:Any})

Deletes an existing custom verification email template. For more information about custom
verification email templates, see Using custom verification email templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the custom verification email template that you want to
  delete.

"""
function delete_custom_verification_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/custom-verification-email-templates/$(TemplateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_verification_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/custom-verification-email-templates/$(TemplateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dedicated_ip_pool(pool_name)
    delete_dedicated_ip_pool(pool_name, params::Dict{String,<:Any})

Delete a dedicated IP pool.

# Arguments
- `pool_name`: The name of the dedicated IP pool that you want to delete.

"""
function delete_dedicated_ip_pool(
    PoolName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/dedicated-ip-pools/$(PoolName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dedicated_ip_pool(
    PoolName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/dedicated-ip-pools/$(PoolName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_email_identity(email_identity)
    delete_email_identity(email_identity, params::Dict{String,<:Any})

Deletes an email identity. An identity can be either an email address or a domain name.

# Arguments
- `email_identity`: The identity (that is, the email address or domain) to delete.

"""
function delete_email_identity(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/identities/$(EmailIdentity)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_email_identity(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/identities/$(EmailIdentity)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_email_identity_policy(email_identity, policy_name)
    delete_email_identity_policy(email_identity, policy_name, params::Dict{String,<:Any})

Deletes the specified sending authorization policy for the given identity (an email address
or a domain). This API returns successfully even if a policy with the specified name does
not exist.  This API is for the identity owner only. If you have not verified the identity,
this API will return an error.  Sending authorization is a feature that enables an identity
owner to authorize other senders to use its identities. For information about using sending
authorization, see the Amazon SES Developer Guide. You can execute this operation no more
than once per second.

# Arguments
- `email_identity`: The email identity.
- `policy_name`: The name of the policy. The policy name cannot exceed 64 characters and
  can only include alphanumeric characters, dashes, and underscores.

"""
function delete_email_identity_policy(
    EmailIdentity, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_email_identity_policy(
    EmailIdentity,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_email_template(template_name)
    delete_email_template(template_name, params::Dict{String,<:Any})

Deletes an email template. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the template to be deleted.

"""
function delete_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/templates/$(TemplateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/templates/$(TemplateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_suppressed_destination(email_address)
    delete_suppressed_destination(email_address, params::Dict{String,<:Any})

Removes an email address from the suppression list for your account.

# Arguments
- `email_address`: The suppressed email destination to remove from the account suppression
  list.

"""
function delete_suppressed_destination(
    EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/suppression/addresses/$(EmailAddress)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_suppressed_destination(
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/suppression/addresses/$(EmailAddress)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account()
    get_account(params::Dict{String,<:Any})

Obtain information about the email-sending status and capabilities of your Amazon SES
account in the current Amazon Web Services Region.

"""
function get_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET", "/v2/email/account"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/account",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_blacklist_reports(blacklist_item_names)
    get_blacklist_reports(blacklist_item_names, params::Dict{String,<:Any})

Retrieve a list of the blacklists that your dedicated IP addresses appear on.

# Arguments
- `blacklist_item_names`: A list of IP addresses that you want to retrieve blacklist
  information about. You can only specify the dedicated IP addresses that you use to send
  email using Amazon SES or Amazon Pinpoint.

"""
function get_blacklist_reports(
    BlacklistItemNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/blacklist-report",
        Dict{String,Any}("BlacklistItemNames" => BlacklistItemNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_blacklist_reports(
    BlacklistItemNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/blacklist-report",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("BlacklistItemNames" => BlacklistItemNames), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_configuration_set(configuration_set_name)
    get_configuration_set(configuration_set_name, params::Dict{String,<:Any})

Get information about an existing configuration set, including the dedicated IP pool that
it's associated with, whether or not it's enabled for sending email, and more.
Configuration sets are groups of rules that you can apply to the emails you send. You apply
a configuration set to an email by including a reference to the configuration set in the
headers of the email. When you apply a configuration set to an email, all of the rules in
that configuration set are applied to the email.

# Arguments
- `configuration_set_name`: The name of the configuration set.

"""
function get_configuration_set(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/configuration-sets/$(ConfigurationSetName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_configuration_set(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/configuration-sets/$(ConfigurationSetName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_configuration_set_event_destinations(configuration_set_name)
    get_configuration_set_event_destinations(configuration_set_name, params::Dict{String,<:Any})

Retrieve a list of event destinations that are associated with a configuration set.  Events
include message sends, deliveries, opens, clicks, bounces, and complaints. Event
destinations are places that you can send information about these events to. For example,
you can send event data to Amazon EventBridge and associate a rule to send the event to the
specified target.

# Arguments
- `configuration_set_name`: The name of the configuration set that contains the event
  destination.

"""
function get_configuration_set_event_destinations(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_configuration_set_event_destinations(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact(contact_list_name, email_address)
    get_contact(contact_list_name, email_address, params::Dict{String,<:Any})

Returns a contact from a contact list.

# Arguments
- `contact_list_name`: The name of the contact list to which the contact belongs.
- `email_address`: The contact's email address.

"""
function get_contact(
    ContactListName, EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact(
    ContactListName,
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_list(contact_list_name)
    get_contact_list(contact_list_name, params::Dict{String,<:Any})

Returns contact list metadata. It does not return any information about the contacts
present in the list.

# Arguments
- `contact_list_name`: The name of the contact list.

"""
function get_contact_list(
    ContactListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/contact-lists/$(ContactListName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact_list(
    ContactListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/contact-lists/$(ContactListName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_custom_verification_email_template(template_name)
    get_custom_verification_email_template(template_name, params::Dict{String,<:Any})

Returns the custom email verification template for the template name you specify. For more
information about custom verification email templates, see Using custom verification email
templates in the Amazon SES Developer Guide. You can execute this operation no more than
once per second.

# Arguments
- `template_name`: The name of the custom verification email template that you want to
  retrieve.

"""
function get_custom_verification_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/custom-verification-email-templates/$(TemplateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_custom_verification_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/custom-verification-email-templates/$(TemplateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_dedicated_ip(ip)
    get_dedicated_ip(ip, params::Dict{String,<:Any})

Get information about a dedicated IP address, including the name of the dedicated IP pool
that it's associated with, as well information about the automatic warm-up process for the
address.

# Arguments
- `ip`: The IP address that you want to obtain more information about. The value you
  specify has to be a dedicated IP address that's assocaited with your Amazon Web Services
  account.

"""
function get_dedicated_ip(IP; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/dedicated-ips/$(IP)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_dedicated_ip(
    IP, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/dedicated-ips/$(IP)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_dedicated_ip_pool(pool_name)
    get_dedicated_ip_pool(pool_name, params::Dict{String,<:Any})

Retrieve information about the dedicated pool.

# Arguments
- `pool_name`: The name of the dedicated IP pool to retrieve.

"""
function get_dedicated_ip_pool(PoolName; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/dedicated-ip-pools/$(PoolName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_dedicated_ip_pool(
    PoolName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/dedicated-ip-pools/$(PoolName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_dedicated_ips()
    get_dedicated_ips(params::Dict{String,<:Any})

List the dedicated IP addresses that are associated with your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to GetDedicatedIps to indicate the
  position of the dedicated IP pool in the list of IP pools.
- `"PageSize"`: The number of results to show in a single call to GetDedicatedIpsRequest.
  If the number of results is larger than the number you specified in this parameter, then
  the response includes a NextToken element, which you can use to obtain additional results.
- `"PoolName"`: The name of the IP pool that the dedicated IP address is associated with.
"""
function get_dedicated_ips(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/dedicated-ips";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_dedicated_ips(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/dedicated-ips",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deliverability_dashboard_options()
    get_deliverability_dashboard_options(params::Dict{String,<:Any})

Retrieve information about the status of the Deliverability dashboard for your account.
When the Deliverability dashboard is enabled, you gain access to reputation,
deliverability, and other metrics for the domains that you use to send email. You also gain
the ability to perform predictive inbox placement tests. When you use the Deliverability
dashboard, you pay a monthly subscription charge, in addition to any other fees that you
accrue by using Amazon SES and other Amazon Web Services services. For more information
about the features and cost of a Deliverability dashboard subscription, see Amazon SES
Pricing.

"""
function get_deliverability_dashboard_options(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deliverability_dashboard_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deliverability_test_report(report_id)
    get_deliverability_test_report(report_id, params::Dict{String,<:Any})

Retrieve the results of a predictive inbox placement test.

# Arguments
- `report_id`: A unique string that identifies the predictive inbox placement test.

"""
function get_deliverability_test_report(
    ReportId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/test-reports/$(ReportId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deliverability_test_report(
    ReportId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/test-reports/$(ReportId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_deliverability_campaign(campaign_id)
    get_domain_deliverability_campaign(campaign_id, params::Dict{String,<:Any})

Retrieve all the deliverability data for a specific campaign. This data is available for a
campaign only if the campaign sent email by using a domain that the Deliverability
dashboard is enabled for.

# Arguments
- `campaign_id`: The unique identifier for the campaign. The Deliverability dashboard
  automatically generates and assigns this identifier to a campaign.

"""
function get_domain_deliverability_campaign(
    CampaignId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/campaigns/$(CampaignId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_deliverability_campaign(
    CampaignId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/campaigns/$(CampaignId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_statistics_report(domain, end_date, start_date)
    get_domain_statistics_report(domain, end_date, start_date, params::Dict{String,<:Any})

Retrieve inbox placement and engagement rates for the domains that you use to send email.

# Arguments
- `domain`: The domain that you want to obtain deliverability metrics for.
- `end_date`: The last day (in Unix time) that you want to obtain domain deliverability
  metrics for. The EndDate that you specify has to be less than or equal to 30 days after the
  StartDate.
- `start_date`: The first day (in Unix time) that you want to obtain domain deliverability
  metrics for.

"""
function get_domain_statistics_report(
    Domain, EndDate, StartDate; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/statistics-report/$(Domain)",
        Dict{String,Any}("EndDate" => EndDate, "StartDate" => StartDate);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_statistics_report(
    Domain,
    EndDate,
    StartDate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/statistics-report/$(Domain)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EndDate" => EndDate, "StartDate" => StartDate),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_email_identity(email_identity)
    get_email_identity(email_identity, params::Dict{String,<:Any})

Provides information about a specific identity, including the identity's verification
status, sending authorization policies, its DKIM authentication status, and its custom
Mail-From settings.

# Arguments
- `email_identity`: The email identity.

"""
function get_email_identity(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/identities/$(EmailIdentity)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_email_identity(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/identities/$(EmailIdentity)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_email_identity_policies(email_identity)
    get_email_identity_policies(email_identity, params::Dict{String,<:Any})

Returns the requested sending authorization policies for the given identity (an email
address or a domain). The policies are returned as a map of policy names to policy
contents. You can retrieve a maximum of 20 policies at a time.  This API is for the
identity owner only. If you have not verified the identity, this API will return an error.
Sending authorization is a feature that enables an identity owner to authorize other
senders to use its identities. For information about using sending authorization, see the
Amazon SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `email_identity`: The email identity.

"""
function get_email_identity_policies(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/identities/$(EmailIdentity)/policies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_email_identity_policies(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/identities/$(EmailIdentity)/policies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_email_template(template_name)
    get_email_template(template_name, params::Dict{String,<:Any})

Displays the template object (which includes the subject line, HTML part and text part) for
the template you specify. You can execute this operation no more than once per second.

# Arguments
- `template_name`: The name of the template.

"""
function get_email_template(
    TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/templates/$(TemplateName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_email_template(
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/templates/$(TemplateName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_export_job(job_id)
    get_export_job(job_id, params::Dict{String,<:Any})

Provides information about an export job.

# Arguments
- `job_id`: The export job ID.

"""
function get_export_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/export-jobs/$(JobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_export_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/export-jobs/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_import_job(job_id)
    get_import_job(job_id, params::Dict{String,<:Any})

Provides information about an import job.

# Arguments
- `job_id`: The ID of the import job.

"""
function get_import_job(JobId; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/import-jobs/$(JobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_import_job(
    JobId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/import-jobs/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_message_insights(message_id)
    get_message_insights(message_id, params::Dict{String,<:Any})

Provides information about a specific message, including the from address, the subject, the
recipient address, email tags, as well as events associated with the message. You can
execute this operation no more than once per second.

# Arguments
- `message_id`:  A MessageId is a unique identifier for a message, and is returned when
  sending emails through Amazon SES.

"""
function get_message_insights(MessageId; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/insights/$(MessageId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_message_insights(
    MessageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/insights/$(MessageId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_suppressed_destination(email_address)
    get_suppressed_destination(email_address, params::Dict{String,<:Any})

Retrieves information about a specific email address that's on the suppression list for
your account.

# Arguments
- `email_address`: The email address that's on the account suppression list.

"""
function get_suppressed_destination(
    EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/suppression/addresses/$(EmailAddress)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_suppressed_destination(
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/suppression/addresses/$(EmailAddress)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_configuration_sets()
    list_configuration_sets(params::Dict{String,<:Any})

List all of the configuration sets associated with your account in the current region.
Configuration sets are groups of rules that you can apply to the emails you send. You apply
a configuration set to an email by including a reference to the configuration set in the
headers of the email. When you apply a configuration set to an email, all of the rules in
that configuration set are applied to the email.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListConfigurationSets to indicate
  the position in the list of configuration sets.
- `"PageSize"`: The number of results to show in a single call to ListConfigurationSets. If
  the number of results is larger than the number you specified in this parameter, then the
  response includes a NextToken element, which you can use to obtain additional results.
"""
function list_configuration_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/configuration-sets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_configuration_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/configuration-sets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_contact_lists()
    list_contact_lists(params::Dict{String,<:Any})

Lists all of the contact lists available.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A string token indicating that there might be additional contact lists
  available to be listed. Use the token provided in the Response to use in the subsequent
  call to ListContactLists with the same parameters to retrieve the next page of contact
  lists.
- `"PageSize"`: Maximum number of contact lists to return at once. Use this parameter to
  paginate results. If additional contact lists exist beyond the specified limit, the
  NextToken element is sent in the response. Use the NextToken value in subsequent requests
  to retrieve additional lists.
"""
function list_contact_lists(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/contact-lists";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_contact_lists(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/contact-lists",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_contacts(contact_list_name)
    list_contacts(contact_list_name, params::Dict{String,<:Any})

Lists the contacts present in a specific contact list.

# Arguments
- `contact_list_name`: The name of the contact list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: A filter that can be applied to a list of contacts.
- `"NextToken"`: A string token indicating that there might be additional contacts
  available to be listed. Use the token provided in the Response to use in the subsequent
  call to ListContacts with the same parameters to retrieve the next page of contacts.
- `"PageSize"`: The number of contacts that may be returned at once, which is dependent on
  if there are more or less contacts than the value of the PageSize. Use this parameter to
  paginate results. If additional contacts exist beyond the specified limit, the NextToken
  element is sent in the response. Use the NextToken value in subsequent requests to retrieve
  additional contacts.
"""
function list_contacts(ContactListName; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/contact-lists/$(ContactListName)/contacts/list";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_contacts(
    ContactListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/contact-lists/$(ContactListName)/contacts/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_verification_email_templates()
    list_custom_verification_email_templates(params::Dict{String,<:Any})

Lists the existing custom verification email templates for your account in the current
Amazon Web Services Region. For more information about custom verification email templates,
see Using custom verification email templates in the Amazon SES Developer Guide. You can
execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to
  ListCustomVerificationEmailTemplates to indicate the position in the list of custom
  verification email templates.
- `"PageSize"`: The number of results to show in a single call to
  ListCustomVerificationEmailTemplates. If the number of results is larger than the number
  you specified in this parameter, then the response includes a NextToken element, which you
  can use to obtain additional results. The value you specify has to be at least 1, and can
  be no more than 50.
"""
function list_custom_verification_email_templates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/custom-verification-email-templates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_custom_verification_email_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/custom-verification-email-templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_dedicated_ip_pools()
    list_dedicated_ip_pools(params::Dict{String,<:Any})

List all of the dedicated IP pools that exist in your Amazon Web Services account in the
current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListDedicatedIpPools to indicate
  the position in the list of dedicated IP pools.
- `"PageSize"`: The number of results to show in a single call to ListDedicatedIpPools. If
  the number of results is larger than the number you specified in this parameter, then the
  response includes a NextToken element, which you can use to obtain additional results.
"""
function list_dedicated_ip_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/dedicated-ip-pools";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_dedicated_ip_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/dedicated-ip-pools",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deliverability_test_reports()
    list_deliverability_test_reports(params::Dict{String,<:Any})

Show a list of the predictive inbox placement tests that you've performed, regardless of
their statuses. For predictive inbox placement tests that are complete, you can use the
GetDeliverabilityTestReport operation to view the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListDeliverabilityTestReports to
  indicate the position in the list of predictive inbox placement tests.
- `"PageSize"`: The number of results to show in a single call to
  ListDeliverabilityTestReports. If the number of results is larger than the number you
  specified in this parameter, then the response includes a NextToken element, which you can
  use to obtain additional results. The value you specify has to be at least 0, and can be no
  more than 1000.
"""
function list_deliverability_test_reports(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/test-reports";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_deliverability_test_reports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/test-reports",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domain_deliverability_campaigns(end_date, start_date, subscribed_domain)
    list_domain_deliverability_campaigns(end_date, start_date, subscribed_domain, params::Dict{String,<:Any})

Retrieve deliverability data for all the campaigns that used a specific domain to send
email during a specified time range. This data is available for a domain only if you
enabled the Deliverability dashboard for the domain.

# Arguments
- `end_date`: The last day that you want to obtain deliverability data for. This value has
  to be less than or equal to 30 days after the value of the StartDate parameter.
- `start_date`: The first day that you want to obtain deliverability data for.
- `subscribed_domain`: The domain to obtain deliverability data for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token that’s returned from a previous call to the
  ListDomainDeliverabilityCampaigns operation. This token indicates the position of a
  campaign in the list of campaigns.
- `"PageSize"`: The maximum number of results to include in response to a single call to
  the ListDomainDeliverabilityCampaigns operation. If the number of results is larger than
  the number that you specify in this parameter, the response includes a NextToken element,
  which you can use to obtain additional results.
"""
function list_domain_deliverability_campaigns(
    EndDate, StartDate, SubscribedDomain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/domains/$(SubscribedDomain)/campaigns",
        Dict{String,Any}("EndDate" => EndDate, "StartDate" => StartDate);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domain_deliverability_campaigns(
    EndDate,
    StartDate,
    SubscribedDomain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/deliverability-dashboard/domains/$(SubscribedDomain)/campaigns",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EndDate" => EndDate, "StartDate" => StartDate),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_email_identities()
    list_email_identities(params::Dict{String,<:Any})

Returns a list of all of the email identities that are associated with your Amazon Web
Services account. An identity can be either an email address or a domain. This operation
returns identities that are verified as well as those that aren't. This operation returns
identities that are associated with Amazon SES and Amazon Pinpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListEmailIdentities to indicate
  the position in the list of identities.
- `"PageSize"`: The number of results to show in a single call to ListEmailIdentities. If
  the number of results is larger than the number you specified in this parameter, then the
  response includes a NextToken element, which you can use to obtain additional results. The
  value you specify has to be at least 0, and can be no more than 1000.
"""
function list_email_identities(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/identities";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_email_identities(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/identities",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_email_templates()
    list_email_templates(params::Dict{String,<:Any})

Lists the email templates present in your Amazon SES account in the current Amazon Web
Services Region. You can execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token returned from a previous call to ListEmailTemplates to indicate
  the position in the list of email templates.
- `"PageSize"`: The number of results to show in a single call to ListEmailTemplates. If
  the number of results is larger than the number you specified in this parameter, then the
  response includes a NextToken element, which you can use to obtain additional results. The
  value you specify has to be at least 1, and can be no more than 100.
"""
function list_email_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET", "/v2/email/templates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_email_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_export_jobs()
    list_export_jobs(params::Dict{String,<:Any})

Lists all of the export jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExportSourceType"`: A value used to list export jobs that have a certain
  ExportSourceType.
- `"JobStatus"`: A value used to list export jobs that have a certain JobStatus.
- `"NextToken"`: The pagination token returned from a previous call to ListExportJobs to
  indicate the position in the list of export jobs.
- `"PageSize"`: Maximum number of export jobs to return at once. Use this parameter to
  paginate results. If additional export jobs exist beyond the specified limit, the NextToken
  element is sent in the response. Use the NextToken value in subsequent calls to
  ListExportJobs to retrieve additional export jobs.
"""
function list_export_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/list-export-jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_export_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/list-export-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_import_jobs()
    list_import_jobs(params::Dict{String,<:Any})

Lists all of the import jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ImportDestinationType"`: The destination of the import job, which can be used to list
  import jobs that have a certain ImportDestinationType.
- `"NextToken"`: A string token indicating that there might be additional import jobs
  available to be listed. Copy this token to a subsequent call to ListImportJobs with the
  same parameters to retrieve the next page of import jobs.
- `"PageSize"`: Maximum number of import jobs to return at once. Use this parameter to
  paginate results. If additional import jobs exist beyond the specified limit, the NextToken
  element is sent in the response. Use the NextToken value in subsequent requests to retrieve
  additional addresses.
"""
function list_import_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/import-jobs/list";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_import_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/import-jobs/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_recommendations()
    list_recommendations(params::Dict{String,<:Any})

Lists the recommendations present in your Amazon SES account in the current Amazon Web
Services Region. You can execute this operation no more than once per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: Filters applied when retrieving recommendations. Can eiter be an individual
  filter, or combinations of STATUS and IMPACT or STATUS and TYPE
- `"NextToken"`: A token returned from a previous call to ListRecommendations to indicate
  the position in the list of recommendations.
- `"PageSize"`: The number of results to show in a single call to ListRecommendations. If
  the number of results is larger than the number you specified in this parameter, then the
  response includes a NextToken element, which you can use to obtain additional results. The
  value you specify has to be at least 1, and can be no more than 100.
"""
function list_recommendations(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/vdm/recommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/vdm/recommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_suppressed_destinations()
    list_suppressed_destinations(params::Dict{String,<:Any})

Retrieves a list of email addresses that are on the suppression list for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EndDate"`: Used to filter the list of suppressed email destinations so that it only
  includes addresses that were added to the list before a specific date.
- `"NextToken"`: A token returned from a previous call to ListSuppressedDestinations to
  indicate the position in the list of suppressed email addresses.
- `"PageSize"`: The number of results to show in a single call to
  ListSuppressedDestinations. If the number of results is larger than the number you
  specified in this parameter, then the response includes a NextToken element, which you can
  use to obtain additional results.
- `"Reason"`: The factors that caused the email address to be added to .
- `"StartDate"`: Used to filter the list of suppressed email destinations so that it only
  includes addresses that were added to the list after a specific date.
"""
function list_suppressed_destinations(; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "GET",
        "/v2/email/suppression/addresses";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_suppressed_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/suppression/addresses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieve a list of the tags (keys and values) that are associated with a specified
resource. A tag is a label that you optionally define and associate with a resource. Each
tag consists of a required tag key and an optional associated tag value. A tag key is a
general label that acts as a category for more specific tag values. A tag value acts as a
descriptor within a tag key.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to retrieve
  tag information for.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "GET",
        "/v2/email/tags",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "GET",
        "/v2/email/tags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_dedicated_ip_warmup_attributes()
    put_account_dedicated_ip_warmup_attributes(params::Dict{String,<:Any})

Enable or disable the automatic warm-up feature for dedicated IP addresses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoWarmupEnabled"`: Enables or disables the automatic warm-up feature for dedicated IP
  addresses that are associated with your Amazon SES account in the current Amazon Web
  Services Region. Set to true to enable the automatic warm-up feature, or set to false to
  disable it.
"""
function put_account_dedicated_ip_warmup_attributes(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/dedicated-ips/warmup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_dedicated_ip_warmup_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/dedicated-ips/warmup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_details(mail_type, use_case_description, website_url)
    put_account_details(mail_type, use_case_description, website_url, params::Dict{String,<:Any})

Update your Amazon SES account details.

# Arguments
- `mail_type`: The type of email your account will send.
- `use_case_description`: A description of the types of email that you plan to send.
- `website_url`: The URL of your website. This information helps us better understand the
  type of content that you plan to send.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalContactEmailAddresses"`: Additional email addresses that you would like to be
  notified regarding Amazon SES matters.
- `"ContactLanguage"`: The language you would prefer to be contacted with.
- `"ProductionAccessEnabled"`: Indicates whether or not your account should have production
  access in the current Amazon Web Services Region. If the value is false, then your account
  is in the sandbox. When your account is in the sandbox, you can only send email to verified
  identities.  If the value is true, then your account has production access. When your
  account has production access, you can send email to any address. The sending quota and
  maximum sending rate for your account vary based on your specific use case.
"""
function put_account_details(
    MailType,
    UseCaseDescription,
    WebsiteURL;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/account/details",
        Dict{String,Any}(
            "MailType" => MailType,
            "UseCaseDescription" => UseCaseDescription,
            "WebsiteURL" => WebsiteURL,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_details(
    MailType,
    UseCaseDescription,
    WebsiteURL,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/account/details",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MailType" => MailType,
                    "UseCaseDescription" => UseCaseDescription,
                    "WebsiteURL" => WebsiteURL,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_sending_attributes()
    put_account_sending_attributes(params::Dict{String,<:Any})

Enable or disable the ability of your account to send email.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SendingEnabled"`: Enables or disables your account's ability to send email. Set to true
  to enable email sending, or set to false to disable email sending.  If Amazon Web Services
  paused your account's ability to send email, you can't use this operation to resume your
  account's ability to send email.
"""
function put_account_sending_attributes(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/sending";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_sending_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/sending",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_suppression_attributes()
    put_account_suppression_attributes(params::Dict{String,<:Any})

Change the settings for the account-level suppression list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SuppressedReasons"`: A list that contains the reasons that email addresses will be
  automatically added to the suppression list for your account. This list can contain any or
  all of the following:    COMPLAINT – Amazon SES adds an email address to the suppression
  list for your account when a message sent to that address results in a complaint.    BOUNCE
  – Amazon SES adds an email address to the suppression list for your account when a
  message sent to that address results in a hard bounce.
"""
function put_account_suppression_attributes(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/suppression";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_suppression_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/suppression",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_account_vdm_attributes(vdm_attributes)
    put_account_vdm_attributes(vdm_attributes, params::Dict{String,<:Any})

Update your Amazon SES account VDM attributes. You can execute this operation no more than
once per second.

# Arguments
- `vdm_attributes`: The VDM attributes that you wish to apply to your Amazon SES account.

"""
function put_account_vdm_attributes(
    VdmAttributes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/account/vdm",
        Dict{String,Any}("VdmAttributes" => VdmAttributes);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_account_vdm_attributes(
    VdmAttributes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/account/vdm",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VdmAttributes" => VdmAttributes), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_delivery_options(configuration_set_name)
    put_configuration_set_delivery_options(configuration_set_name, params::Dict{String,<:Any})

Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to
create groups of dedicated IP addresses for sending specific types of email.

# Arguments
- `configuration_set_name`: The name of the configuration set to associate with a dedicated
  IP pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SendingPoolName"`: The name of the dedicated IP pool to associate with the
  configuration set.
- `"TlsPolicy"`: Specifies whether messages that use the configuration set are required to
  use Transport Layer Security (TLS). If the value is Require, messages are only delivered if
  a TLS connection can be established. If the value is Optional, messages can be delivered in
  plain text if a TLS connection can't be established.
"""
function put_configuration_set_delivery_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/delivery-options";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_delivery_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/delivery-options",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_reputation_options(configuration_set_name)
    put_configuration_set_reputation_options(configuration_set_name, params::Dict{String,<:Any})

Enable or disable collection of reputation metrics for emails that you send using a
particular configuration set in a specific Amazon Web Services Region.

# Arguments
- `configuration_set_name`: The name of the configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReputationMetricsEnabled"`: If true, tracking of reputation metrics is enabled for the
  configuration set. If false, tracking of reputation metrics is disabled for the
  configuration set.
"""
function put_configuration_set_reputation_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/reputation-options";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_reputation_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/reputation-options",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_sending_options(configuration_set_name)
    put_configuration_set_sending_options(configuration_set_name, params::Dict{String,<:Any})

Enable or disable email sending for messages that use a particular configuration set in a
specific Amazon Web Services Region.

# Arguments
- `configuration_set_name`: The name of the configuration set to enable or disable email
  sending for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SendingEnabled"`: If true, email sending is enabled for the configuration set. If
  false, email sending is disabled for the configuration set.
"""
function put_configuration_set_sending_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/sending";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_sending_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/sending",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_suppression_options(configuration_set_name)
    put_configuration_set_suppression_options(configuration_set_name, params::Dict{String,<:Any})

Specify the account suppression list preferences for a configuration set.

# Arguments
- `configuration_set_name`: The name of the configuration set to change the suppression
  list preferences for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SuppressedReasons"`: A list that contains the reasons that email addresses are
  automatically added to the suppression list for your account. This list can contain any or
  all of the following:    COMPLAINT – Amazon SES adds an email address to the suppression
  list for your account when a message sent to that address results in a complaint.    BOUNCE
  – Amazon SES adds an email address to the suppression list for your account when a
  message sent to that address results in a hard bounce.
"""
function put_configuration_set_suppression_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/suppression-options";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_suppression_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/suppression-options",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_tracking_options(configuration_set_name)
    put_configuration_set_tracking_options(configuration_set_name, params::Dict{String,<:Any})

Specify a custom domain to use for open and click tracking elements in email that you send.

# Arguments
- `configuration_set_name`: The name of the configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomRedirectDomain"`: The domain to use to track open and click events.
"""
function put_configuration_set_tracking_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/tracking-options";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_tracking_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/tracking-options",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configuration_set_vdm_options(configuration_set_name)
    put_configuration_set_vdm_options(configuration_set_name, params::Dict{String,<:Any})

Specify VDM preferences for email that you send using the configuration set. You can
execute this operation no more than once per second.

# Arguments
- `configuration_set_name`: The name of the configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VdmOptions"`: The VDM options to apply to the configuration set.
"""
function put_configuration_set_vdm_options(
    ConfigurationSetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/vdm-options";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configuration_set_vdm_options(
    ConfigurationSetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/vdm-options",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_dedicated_ip_in_pool(destination_pool_name, ip)
    put_dedicated_ip_in_pool(destination_pool_name, ip, params::Dict{String,<:Any})

Move a dedicated IP address to an existing dedicated IP pool.  The dedicated IP address
that you specify must already exist, and must be associated with your Amazon Web Services
account.  The dedicated IP pool you specify must already exist. You can create a new pool
by using the CreateDedicatedIpPool operation.

# Arguments
- `destination_pool_name`: The name of the IP pool that you want to add the dedicated IP
  address to. You have to specify an IP pool that already exists.
- `ip`: The IP address that you want to move to the dedicated IP pool. The value you
  specify has to be a dedicated IP address that's associated with your Amazon Web Services
  account.

"""
function put_dedicated_ip_in_pool(
    DestinationPoolName, IP; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ips/$(IP)/pool",
        Dict{String,Any}("DestinationPoolName" => DestinationPoolName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_dedicated_ip_in_pool(
    DestinationPoolName,
    IP,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ips/$(IP)/pool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DestinationPoolName" => DestinationPoolName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_dedicated_ip_pool_scaling_attributes(pool_name, scaling_mode)
    put_dedicated_ip_pool_scaling_attributes(pool_name, scaling_mode, params::Dict{String,<:Any})

Used to convert a dedicated IP pool to a different scaling mode.   MANAGED pools cannot be
converted to STANDARD scaling mode.

# Arguments
- `pool_name`: The name of the dedicated IP pool.
- `scaling_mode`: The scaling mode to apply to the dedicated IP pool.  Changing the scaling
  mode from MANAGED to STANDARD is not supported.

"""
function put_dedicated_ip_pool_scaling_attributes(
    PoolName, ScalingMode; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ip-pools/$(PoolName)/scaling",
        Dict{String,Any}("ScalingMode" => ScalingMode);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_dedicated_ip_pool_scaling_attributes(
    PoolName,
    ScalingMode,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ip-pools/$(PoolName)/scaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ScalingMode" => ScalingMode), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_dedicated_ip_warmup_attributes(ip, warmup_percentage)
    put_dedicated_ip_warmup_attributes(ip, warmup_percentage, params::Dict{String,<:Any})



# Arguments
- `ip`: The dedicated IP address that you want to update the warm-up attributes for.
- `warmup_percentage`: The warm-up percentage that you want to associate with the dedicated
  IP address.

"""
function put_dedicated_ip_warmup_attributes(
    IP, WarmupPercentage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ips/$(IP)/warmup",
        Dict{String,Any}("WarmupPercentage" => WarmupPercentage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_dedicated_ip_warmup_attributes(
    IP,
    WarmupPercentage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/dedicated-ips/$(IP)/warmup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WarmupPercentage" => WarmupPercentage), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_deliverability_dashboard_option(dashboard_enabled)
    put_deliverability_dashboard_option(dashboard_enabled, params::Dict{String,<:Any})

Enable or disable the Deliverability dashboard. When you enable the Deliverability
dashboard, you gain access to reputation, deliverability, and other metrics for the domains
that you use to send email. You also gain the ability to perform predictive inbox placement
tests. When you use the Deliverability dashboard, you pay a monthly subscription charge, in
addition to any other fees that you accrue by using Amazon SES and other Amazon Web
Services services. For more information about the features and cost of a Deliverability
dashboard subscription, see Amazon SES Pricing.

# Arguments
- `dashboard_enabled`: Specifies whether to enable the Deliverability dashboard. To enable
  the dashboard, set this value to true.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SubscribedDomains"`: An array of objects, one for each verified domain that you use to
  send email and enabled the Deliverability dashboard for.
"""
function put_deliverability_dashboard_option(
    DashboardEnabled; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/deliverability-dashboard",
        Dict{String,Any}("DashboardEnabled" => DashboardEnabled);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_deliverability_dashboard_option(
    DashboardEnabled,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/deliverability-dashboard",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DashboardEnabled" => DashboardEnabled), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_email_identity_configuration_set_attributes(email_identity)
    put_email_identity_configuration_set_attributes(email_identity, params::Dict{String,<:Any})

Used to associate a configuration set with an email identity.

# Arguments
- `email_identity`: The email address or domain to associate with a configuration set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The configuration set to associate with an email identity.
"""
function put_email_identity_configuration_set_attributes(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/configuration-set";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_email_identity_configuration_set_attributes(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/configuration-set",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_email_identity_dkim_attributes(email_identity)
    put_email_identity_dkim_attributes(email_identity, params::Dict{String,<:Any})

Used to enable or disable DKIM authentication for an email identity.

# Arguments
- `email_identity`: The email identity.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SigningEnabled"`: Sets the DKIM signing configuration for the identity. When you set
  this value true, then the messages that are sent from the identity are signed using DKIM.
  If you set this value to false, your messages are sent without DKIM signing.
"""
function put_email_identity_dkim_attributes(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/dkim";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_email_identity_dkim_attributes(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/dkim",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_email_identity_dkim_signing_attributes(email_identity, signing_attributes_origin)
    put_email_identity_dkim_signing_attributes(email_identity, signing_attributes_origin, params::Dict{String,<:Any})

Used to configure or change the DKIM authentication settings for an email domain identity.
You can use this operation to do any of the following:   Update the signing attributes for
an identity that uses Bring Your Own DKIM (BYODKIM).   Update the key length that should be
used for Easy DKIM.   Change from using no DKIM authentication to using Easy DKIM.   Change
from using no DKIM authentication to using BYODKIM.   Change from using Easy DKIM to using
BYODKIM.   Change from using BYODKIM to using Easy DKIM.

# Arguments
- `email_identity`: The email identity.
- `signing_attributes_origin`: The method to use to configure DKIM for the identity. There
  are the following possible values:    AWS_SES – Configure DKIM for the identity by using
  Easy DKIM.    EXTERNAL – Configure DKIM for the identity by using Bring Your Own DKIM
  (BYODKIM).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SigningAttributes"`: An object that contains information about the private key and
  selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM
  (BYODKIM) for the identity, or, configures the key length to be used for Easy DKIM.
"""
function put_email_identity_dkim_signing_attributes(
    EmailIdentity,
    SigningAttributesOrigin;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v1/email/identities/$(EmailIdentity)/dkim/signing",
        Dict{String,Any}("SigningAttributesOrigin" => SigningAttributesOrigin);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_email_identity_dkim_signing_attributes(
    EmailIdentity,
    SigningAttributesOrigin,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v1/email/identities/$(EmailIdentity)/dkim/signing",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SigningAttributesOrigin" => SigningAttributesOrigin),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_email_identity_feedback_attributes(email_identity)
    put_email_identity_feedback_attributes(email_identity, params::Dict{String,<:Any})

Used to enable or disable feedback forwarding for an identity. This setting determines what
happens when an identity is used to send an email that results in a bounce or complaint
event. If the value is true, you receive email notifications when bounce or complaint
events occur. These notifications are sent to the address that you specified in the
Return-Path header of the original email. You're required to have a method of tracking
bounces and complaints. If you haven't set up another mechanism for receiving bounce or
complaint notifications (for example, by setting up an event destination), you receive an
email notification when these events occur (even if this setting is disabled).

# Arguments
- `email_identity`: The email identity.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EmailForwardingEnabled"`: Sets the feedback forwarding configuration for the identity.
  If the value is true, you receive email notifications when bounce or complaint events
  occur. These notifications are sent to the address that you specified in the Return-Path
  header of the original email. You're required to have a method of tracking bounces and
  complaints. If you haven't set up another mechanism for receiving bounce or complaint
  notifications (for example, by setting up an event destination), you receive an email
  notification when these events occur (even if this setting is disabled).
"""
function put_email_identity_feedback_attributes(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/feedback";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_email_identity_feedback_attributes(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/feedback",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_email_identity_mail_from_attributes(email_identity)
    put_email_identity_mail_from_attributes(email_identity, params::Dict{String,<:Any})

Used to enable or disable the custom Mail-From domain configuration for an email identity.

# Arguments
- `email_identity`: The verified email identity.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BehaviorOnMxFailure"`: The action to take if the required MX record isn't found when
  you send an email. When you set this value to UseDefaultValue, the mail is sent using
  amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage, the Amazon
  SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the
  email. These behaviors are taken when the custom MAIL FROM domain configuration is in the
  Pending, Failed, and TemporaryFailure states.
- `"MailFromDomain"`:  The custom MAIL FROM domain that you want the verified identity to
  use. The MAIL FROM domain must meet the following criteria:   It has to be a subdomain of
  the verified identity.   It can't be used to receive email.   It can't be used in a
  \"From\" address if the MAIL FROM domain is a destination for feedback forwarding emails.
"""
function put_email_identity_mail_from_attributes(
    EmailIdentity; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/mail-from";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_email_identity_mail_from_attributes(
    EmailIdentity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/mail-from",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_suppressed_destination(email_address, reason)
    put_suppressed_destination(email_address, reason, params::Dict{String,<:Any})

Adds an email address to the suppression list for your account.

# Arguments
- `email_address`: The email address that should be added to the suppression list for your
  account.
- `reason`: The factors that should cause the email address to be added to the suppression
  list for your account.

"""
function put_suppressed_destination(
    EmailAddress, Reason; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/suppression/addresses",
        Dict{String,Any}("EmailAddress" => EmailAddress, "Reason" => Reason);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_suppressed_destination(
    EmailAddress,
    Reason,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/suppression/addresses",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EmailAddress" => EmailAddress, "Reason" => Reason),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_bulk_email(bulk_email_entries, default_content)
    send_bulk_email(bulk_email_entries, default_content, params::Dict{String,<:Any})

Composes an email message to multiple destinations.

# Arguments
- `bulk_email_entries`: The list of bulk email entry objects.
- `default_content`: An object that contains the body of the message. You can specify a
  template message.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when sending the email.
- `"DefaultEmailTags"`: A list of tags, in the form of name/value pairs, to apply to an
  email that you send using the SendEmail operation. Tags correspond to characteristics of
  the email that you define, so that you can publish email sending events.
- `"FeedbackForwardingEmailAddress"`: The address that you want bounce and complaint
  notifications to be sent to.
- `"FeedbackForwardingEmailAddressIdentityArn"`: This parameter is used only for sending
  authorization. It is the ARN of the identity that is associated with the sending
  authorization policy that permits you to use the email address specified in the
  FeedbackForwardingEmailAddress parameter. For example, if the owner of example.com (which
  has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it
  that authorizes you to use feedback@example.com, then you would specify the
  FeedbackForwardingEmailAddressIdentityArn to be
  arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
  FeedbackForwardingEmailAddress to be feedback@example.com. For more information about
  sending authorization, see the Amazon SES Developer Guide.
- `"FromEmailAddress"`: The email address to use as the \"From\" address for the email. The
  address that you specify has to be verified.
- `"FromEmailAddressIdentityArn"`: This parameter is used only for sending authorization.
  It is the ARN of the identity that is associated with the sending authorization policy that
  permits you to use the email address specified in the FromEmailAddress parameter. For
  example, if the owner of example.com (which has ARN
  arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
  authorizes you to use sender@example.com, then you would specify the
  FromEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the FromEmailAddress to be sender@example.com. For more information about sending
  authorization, see the Amazon SES Developer Guide.
- `"ReplyToAddresses"`: The \"Reply-to\" email addresses for the message. When the
  recipient replies to the message, each Reply-to address receives the reply.
"""
function send_bulk_email(
    BulkEmailEntries, DefaultContent; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/outbound-bulk-emails",
        Dict{String,Any}(
            "BulkEmailEntries" => BulkEmailEntries, "DefaultContent" => DefaultContent
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_bulk_email(
    BulkEmailEntries,
    DefaultContent,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/outbound-bulk-emails",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BulkEmailEntries" => BulkEmailEntries,
                    "DefaultContent" => DefaultContent,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_custom_verification_email(email_address, template_name)
    send_custom_verification_email(email_address, template_name, params::Dict{String,<:Any})

Adds an email address to the list of identities for your Amazon SES account in the current
Amazon Web Services Region and attempts to verify it. As a result of executing this
operation, a customized verification email is sent to the specified address. To use this
operation, you must first create a custom verification email template. For more information
about creating and using custom verification email templates, see Using custom verification
email templates in the Amazon SES Developer Guide. You can execute this operation no more
than once per second.

# Arguments
- `email_address`: The email address to verify.
- `template_name`: The name of the custom verification email template to use when sending
  the verification email.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: Name of a configuration set to use when sending the
  verification email.
"""
function send_custom_verification_email(
    EmailAddress, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/outbound-custom-verification-emails",
        Dict{String,Any}("EmailAddress" => EmailAddress, "TemplateName" => TemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_custom_verification_email(
    EmailAddress,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/outbound-custom-verification-emails",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EmailAddress" => EmailAddress, "TemplateName" => TemplateName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_email(content)
    send_email(content, params::Dict{String,<:Any})

Sends an email message. You can use the Amazon SES API v2 to send the following types of
messages:    Simple – A standard email message. When you create this type of message, you
specify the sender, the recipient, and the message body, and Amazon SES assembles the
message for you.    Raw – A raw, MIME-formatted email message. When you send this type of
email, you have to specify all of the message headers, as well as the message body. You can
use this message type to send messages that contain attachments. The message that you
specify has to be a valid MIME message.    Templated – A message that contains
personalization tags. When you send this type of email, Amazon SES API v2 automatically
replaces the tags with values that you specify.

# Arguments
- `content`: An object that contains the body of the message. You can send either a Simple
  message, Raw message, or a Templated message.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationSetName"`: The name of the configuration set to use when sending the email.
- `"Destination"`: An object that contains the recipients of the email message.
- `"EmailTags"`: A list of tags, in the form of name/value pairs, to apply to an email that
  you send using the SendEmail operation. Tags correspond to characteristics of the email
  that you define, so that you can publish email sending events.
- `"FeedbackForwardingEmailAddress"`: The address that you want bounce and complaint
  notifications to be sent to.
- `"FeedbackForwardingEmailAddressIdentityArn"`: This parameter is used only for sending
  authorization. It is the ARN of the identity that is associated with the sending
  authorization policy that permits you to use the email address specified in the
  FeedbackForwardingEmailAddress parameter. For example, if the owner of example.com (which
  has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it
  that authorizes you to use feedback@example.com, then you would specify the
  FeedbackForwardingEmailAddressIdentityArn to be
  arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
  FeedbackForwardingEmailAddress to be feedback@example.com. For more information about
  sending authorization, see the Amazon SES Developer Guide.
- `"FromEmailAddress"`: The email address to use as the \"From\" address for the email. The
  address that you specify has to be verified.
- `"FromEmailAddressIdentityArn"`: This parameter is used only for sending authorization.
  It is the ARN of the identity that is associated with the sending authorization policy that
  permits you to use the email address specified in the FromEmailAddress parameter. For
  example, if the owner of example.com (which has ARN
  arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
  authorizes you to use sender@example.com, then you would specify the
  FromEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
  and the FromEmailAddress to be sender@example.com. For more information about sending
  authorization, see the Amazon SES Developer Guide. For Raw emails, the
  FromEmailAddressIdentityArn value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers
  specified in raw email message content.
- `"ListManagementOptions"`: An object used to specify a list or topic to which an email
  belongs, which will be used when a contact chooses to unsubscribe.
- `"ReplyToAddresses"`: The \"Reply-to\" email addresses for the message. When the
  recipient replies to the message, each Reply-to address receives the reply.
"""
function send_email(Content; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/outbound-emails",
        Dict{String,Any}("Content" => Content);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_email(
    Content,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/outbound-emails",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Content" => Content), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Add one or more tags (keys and values) to a specified resource. A tag is a label that you
optionally define and associate with a resource. Tags can help you categorize and manage
resources in different ways, such as by purpose, owner, environment, or other criteria. A
resource can have as many as 50 tags. Each tag consists of a required tag key and an
associated tag value, both of which you define. A tag key is a general label that acts as
a category for more specific tag values. A tag value acts as a descriptor within a tag key.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to add one
  or more tags to.
- `tags`: A list of the tags that you want to add to the resource. A tag consists of a
  required tag key (Key) and an associated tag value (Value). The maximum length of a tag key
  is 128 characters. The maximum length of a tag value is 256 characters.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return sesv2(
        "POST",
        "/v2/email/tags",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/tags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_render_email_template(template_data, template_name)
    test_render_email_template(template_data, template_name, params::Dict{String,<:Any})

Creates a preview of the MIME content of an email when provided with a template and a set
of replacement data. You can execute this operation no more than once per second.

# Arguments
- `template_data`: A list of replacement values to apply to the template. This parameter is
  a JSON object, typically consisting of key-value pairs in which the keys correspond to
  replacement tags in the email template.
- `template_name`: The name of the template.

"""
function test_render_email_template(
    TemplateData, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "POST",
        "/v2/email/templates/$(TemplateName)/render",
        Dict{String,Any}("TemplateData" => TemplateData);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_render_email_template(
    TemplateData,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "POST",
        "/v2/email/templates/$(TemplateName)/render",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TemplateData" => TemplateData), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Remove one or more tags (keys and values) from a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to remove
  one or more tags from.
- `tag_keys`: The tags (tag keys) that you want to remove from the resource. When you
  specify a tag key, the action removes both that key and its associated tag value. To remove
  more than one tag from the resource, append the TagKeys parameter and argument for each
  additional tag to remove, separated by an ampersand. For example:
  /v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "DELETE",
        "/v2/email/tags",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "DELETE",
        "/v2/email/tags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration_set_event_destination(configuration_set_name, event_destination, event_destination_name)
    update_configuration_set_event_destination(configuration_set_name, event_destination, event_destination_name, params::Dict{String,<:Any})

Update the configuration of an event destination for a configuration set.  Events include
message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are
places that you can send information about these events to. For example, you can send event
data to Amazon EventBridge and associate a rule to send the event to the specified target.

# Arguments
- `configuration_set_name`: The name of the configuration set that contains the event
  destination to modify.
- `event_destination`: An object that defines the event destination.
- `event_destination_name`: The name of the event destination.

"""
function update_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    EventDestinationName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations/$(EventDestinationName)",
        Dict{String,Any}("EventDestination" => EventDestination);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration_set_event_destination(
    ConfigurationSetName,
    EventDestination,
    EventDestinationName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/configuration-sets/$(ConfigurationSetName)/event-destinations/$(EventDestinationName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("EventDestination" => EventDestination), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_contact(contact_list_name, email_address)
    update_contact(contact_list_name, email_address, params::Dict{String,<:Any})

Updates a contact's preferences for a list.  You must specify all existing topic
preferences in the TopicPreferences object, not just the ones that need updating;
otherwise, all your existing preferences will be removed.

# Arguments
- `contact_list_name`: The name of the contact list.
- `email_address`: The contact's email address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesData"`: The attribute data attached to a contact.
- `"TopicPreferences"`: The contact's preference for being opted-in to or opted-out of a
  topic.
- `"UnsubscribeAll"`: A boolean value status noting if the contact is unsubscribed from all
  contact list topics.
"""
function update_contact(
    ContactListName, EmailAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_contact(
    ContactListName,
    EmailAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/contact-lists/$(ContactListName)/contacts/$(EmailAddress)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_contact_list(contact_list_name)
    update_contact_list(contact_list_name, params::Dict{String,<:Any})

Updates contact list metadata. This operation does a complete replacement.

# Arguments
- `contact_list_name`: The name of the contact list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of what the contact list is about.
- `"Topics"`: An interest group, theme, or label within a list. A contact list can have
  multiple topics.
"""
function update_contact_list(
    ContactListName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/contact-lists/$(ContactListName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_contact_list(
    ContactListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/contact-lists/$(ContactListName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject)
    update_custom_verification_email_template(failure_redirection_url, from_email_address, success_redirection_url, template_content, template_name, template_subject, params::Dict{String,<:Any})

Updates an existing custom verification email template. For more information about custom
verification email templates, see Using custom verification email templates in the Amazon
SES Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `failure_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is not successfully verified.
- `from_email_address`: The email address that the custom verification email is sent from.
- `success_redirection_url`: The URL that the recipient of the verification email is sent
  to if his or her address is successfully verified.
- `template_content`: The content of the custom verification email. The total size of the
  email must be less than 10 MB. The message body may contain HTML, with some limitations.
  For more information, see Custom verification email frequently asked questions in the
  Amazon SES Developer Guide.
- `template_name`: The name of the custom verification email template that you want to
  update.
- `template_subject`: The subject line of the custom verification email.

"""
function update_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/custom-verification-email-templates/$(TemplateName)",
        Dict{String,Any}(
            "FailureRedirectionURL" => FailureRedirectionURL,
            "FromEmailAddress" => FromEmailAddress,
            "SuccessRedirectionURL" => SuccessRedirectionURL,
            "TemplateContent" => TemplateContent,
            "TemplateSubject" => TemplateSubject,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_custom_verification_email_template(
    FailureRedirectionURL,
    FromEmailAddress,
    SuccessRedirectionURL,
    TemplateContent,
    TemplateName,
    TemplateSubject,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/custom-verification-email-templates/$(TemplateName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FailureRedirectionURL" => FailureRedirectionURL,
                    "FromEmailAddress" => FromEmailAddress,
                    "SuccessRedirectionURL" => SuccessRedirectionURL,
                    "TemplateContent" => TemplateContent,
                    "TemplateSubject" => TemplateSubject,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_email_identity_policy(email_identity, policy, policy_name)
    update_email_identity_policy(email_identity, policy, policy_name, params::Dict{String,<:Any})

Updates the specified sending authorization policy for the given identity (an email address
or a domain). This API returns successfully even if a policy with the specified name does
not exist.  This API is for the identity owner only. If you have not verified the identity,
this API will return an error.  Sending authorization is a feature that enables an identity
owner to authorize other senders to use its identities. For information about using sending
authorization, see the Amazon SES Developer Guide. You can execute this operation no more
than once per second.

# Arguments
- `email_identity`: The email identity.
- `policy`: The text of the policy in JSON format. The policy cannot exceed 4 KB.  For
  information about the syntax of sending authorization policies, see the Amazon SES
  Developer Guide.
- `policy_name`: The name of the policy. The policy name cannot exceed 64 characters and
  can only include alphanumeric characters, dashes, and underscores.

"""
function update_email_identity_policy(
    EmailIdentity, Policy, PolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_email_identity_policy(
    EmailIdentity,
    Policy,
    PolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/identities/$(EmailIdentity)/policies/$(PolicyName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_email_template(template_content, template_name)
    update_email_template(template_content, template_name, params::Dict{String,<:Any})

Updates an email template. Email templates enable you to send personalized email to one or
more destinations in a single API operation. For more information, see the Amazon SES
Developer Guide. You can execute this operation no more than once per second.

# Arguments
- `template_content`: The content of the email template, composed of a subject line, an
  HTML part, and a text-only part.
- `template_name`: The name of the template.

"""
function update_email_template(
    TemplateContent, TemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sesv2(
        "PUT",
        "/v2/email/templates/$(TemplateName)",
        Dict{String,Any}("TemplateContent" => TemplateContent);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_email_template(
    TemplateContent,
    TemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sesv2(
        "PUT",
        "/v2/email/templates/$(TemplateName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TemplateContent" => TemplateContent), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
