# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: vpc_lattice
using AWS.Compat
using AWS.UUIDs

"""
    batch_update_rule(listener_identifier, rules, service_identifier)
    batch_update_rule(listener_identifier, rules, service_identifier, params::Dict{String,<:Any})

Updates the listener rules in a batch. You can use this operation to change the priority of
listener rules. This can be useful when bulk updating or swapping rule priority.  Required
permissions: vpc-lattice:UpdateRule  For more information, see How Amazon VPC Lattice works
with IAM in the Amazon VPC Lattice User Guide.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `rules`: The rules for the specified listener.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function batch_update_rule(
    listenerIdentifier,
    rules,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules",
        Dict{String,Any}("rules" => rules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_rule(
    listenerIdentifier,
    rules,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("rules" => rules), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_access_log_subscription(destination_arn, resource_identifier)
    create_access_log_subscription(destination_arn, resource_identifier, params::Dict{String,<:Any})

Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data
Firehose. The service network owner can use the access logs to audit the services in the
network. The service network owner can only see access logs from clients and services that
are associated with their service network. Access log entries represent traffic originated
from VPCs associated with that network. For more information, see Access logs in the Amazon
VPC Lattice User Guide.

# Arguments
- `destination_arn`: The Amazon Resource Name (ARN) of the destination. The supported
  destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and
  Amazon S3 buckets.
- `resource_identifier`: The ID or Amazon Resource Name (ARN) of the service network or
  service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"tags"`: The tags for the access log subscription.
"""
function create_access_log_subscription(
    destinationArn, resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/accesslogsubscriptions",
        Dict{String,Any}(
            "destinationArn" => destinationArn,
            "resourceIdentifier" => resourceIdentifier,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_access_log_subscription(
    destinationArn,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/accesslogsubscriptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationArn" => destinationArn,
                    "resourceIdentifier" => resourceIdentifier,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_listener(default_action, name, protocol, service_identifier)
    create_listener(default_action, name, protocol, service_identifier, params::Dict{String,<:Any})

Creates a listener for a service. Before you start using your Amazon VPC Lattice service,
you must add one or more listeners. A listener is a process that checks for connection
requests to your services. For more information, see Listeners in the Amazon VPC Lattice
User Guide.

# Arguments
- `default_action`: The action for the default rule. Each listener has a default rule. The
  default rule is used if no other rules match.
- `name`: The name of the listener. A listener name must be unique within a service. The
  valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last
  character, or immediately after another hyphen.
- `protocol`: The listener protocol.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"port"`: The listener port. You can specify a value from 1 to 65535. For HTTP, the
  default is 80. For HTTPS, the default is 443.
- `"tags"`: The tags for the listener.
"""
function create_listener(
    defaultAction,
    name,
    protocol,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/services/$(serviceIdentifier)/listeners",
        Dict{String,Any}(
            "defaultAction" => defaultAction,
            "name" => name,
            "protocol" => protocol,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_listener(
    defaultAction,
    name,
    protocol,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/services/$(serviceIdentifier)/listeners",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "defaultAction" => defaultAction,
                    "name" => name,
                    "protocol" => protocol,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rule(action, listener_identifier, match, name, priority, service_identifier)
    create_rule(action, listener_identifier, match, name, priority, service_identifier, params::Dict{String,<:Any})

Creates a listener rule. Each listener has a default rule for checking connection requests,
but you can define additional rules. Each rule consists of a priority, one or more actions,
and one or more conditions. For more information, see Listener rules in the Amazon VPC
Lattice User Guide.

# Arguments
- `action`: The action for the default rule.
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `match`: The rule match.
- `name`: The name of the rule. The name must be unique within the listener. The valid
  characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last
  character, or immediately after another hyphen.
- `priority`: The priority assigned to the rule. Each rule for a specific listener must
  have a unique priority. The lower the priority number the higher the priority.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"tags"`: The tags for the rule.
"""
function create_rule(
    action,
    listenerIdentifier,
    match,
    name,
    priority,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules",
        Dict{String,Any}(
            "action" => action,
            "match" => match,
            "name" => name,
            "priority" => priority,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rule(
    action,
    listenerIdentifier,
    match,
    name,
    priority,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "action" => action,
                    "match" => match,
                    "name" => name,
                    "priority" => priority,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service(name)
    create_service(name, params::Dict{String,<:Any})

Creates a service. A service is any software application that can run on instances
containers, or serverless functions within an account or virtual private cloud (VPC). For
more information, see Services in the Amazon VPC Lattice User Guide.

# Arguments
- `name`: The name of the service. The name must be unique within the account. The valid
  characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last
  character, or immediately after another hyphen.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authType"`: The type of IAM policy.    NONE: The resource does not use an IAM policy.
  This is the default.    AWS_IAM: The resource uses an IAM policy. When this type is used,
  auth is enabled and an auth policy is required.
- `"certificateArn"`: The Amazon Resource Name (ARN) of the certificate.
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"customDomainName"`: The custom domain name of the service.
- `"tags"`: The tags for the service.
"""
function create_service(name; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "POST",
        "/services",
        Dict{String,Any}("name" => name, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/services",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_network(name)
    create_service_network(name, params::Dict{String,<:Any})

Creates a service network. A service network is a logical boundary for a collection of
services. You can associate services and VPCs with a service network. For more information,
see Service networks in the Amazon VPC Lattice User Guide.

# Arguments
- `name`: The name of the service network. The name must be unique to the account. The
  valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last
  character, or immediately after another hyphen.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authType"`: The type of IAM policy.    NONE: The resource does not use an IAM policy.
  This is the default.    AWS_IAM: The resource uses an IAM policy. When this type is used,
  auth is enabled and an auth policy is required.
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"tags"`: The tags for the service network.
"""
function create_service_network(name; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "POST",
        "/servicenetworks",
        Dict{String,Any}("name" => name, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_network(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/servicenetworks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_network_service_association(service_identifier, service_network_identifier)
    create_service_network_service_association(service_identifier, service_network_identifier, params::Dict{String,<:Any})

Associates a service with a service network. For more information, see Manage service
associations in the Amazon VPC Lattice User Guide. You can't use this operation if the
service and service network are already associated or if there is a disassociation or
deletion in progress. If the association fails, you can retry the operation by deleting the
association and recreating it. You cannot associate a service and service network that are
shared with a caller. The caller must own either the service or the service network. As a
result of this operation, the association is created in the service network account and the
association owner account.

# Arguments
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.
- `service_network_identifier`: The ID or Amazon Resource Name (ARN) of the service
  network. You must use the ARN if the resources specified in the operation are in different
  accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"tags"`: The tags for the association.
"""
function create_service_network_service_association(
    serviceIdentifier,
    serviceNetworkIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/servicenetworkserviceassociations",
        Dict{String,Any}(
            "serviceIdentifier" => serviceIdentifier,
            "serviceNetworkIdentifier" => serviceNetworkIdentifier,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_network_service_association(
    serviceIdentifier,
    serviceNetworkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/servicenetworkserviceassociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "serviceIdentifier" => serviceIdentifier,
                    "serviceNetworkIdentifier" => serviceNetworkIdentifier,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_service_network_vpc_association(service_network_identifier, vpc_identifier)
    create_service_network_vpc_association(service_network_identifier, vpc_identifier, params::Dict{String,<:Any})

Associates a VPC with a service network. When you associate a VPC with the service network,
it enables all the resources within that VPC to be clients and communicate with other
services in the service network. For more information, see Manage VPC associations in the
Amazon VPC Lattice User Guide. You can't use this operation if there is a disassociation in
progress. If the association fails, retry by deleting the association and recreating it. As
a result of this operation, the association gets created in the service network account and
the VPC owner account. If you add a security group to the service network and VPC
association, the association must continue to always have at least one security group. You
can add or edit security groups at any time. However, to remove all security groups, you
must first delete the association and recreate it without security groups.

# Arguments
- `service_network_identifier`: The ID or Amazon Resource Name (ARN) of the service
  network. You must use the ARN when the resources specified in the operation are in
  different accounts.
- `vpc_identifier`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"securityGroupIds"`: The IDs of the security groups. Security groups aren't added by
  default. You can add a security group to apply network level controls to control which
  resources in a VPC are allowed to access the service network and its services. For more
  information, see Control traffic to resources using security groups in the Amazon VPC User
  Guide.
- `"tags"`: The tags for the association.
"""
function create_service_network_vpc_association(
    serviceNetworkIdentifier,
    vpcIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/servicenetworkvpcassociations",
        Dict{String,Any}(
            "serviceNetworkIdentifier" => serviceNetworkIdentifier,
            "vpcIdentifier" => vpcIdentifier,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_service_network_vpc_association(
    serviceNetworkIdentifier,
    vpcIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/servicenetworkvpcassociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "serviceNetworkIdentifier" => serviceNetworkIdentifier,
                    "vpcIdentifier" => vpcIdentifier,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_target_group(name, type)
    create_target_group(name, type, params::Dict{String,<:Any})

Creates a target group. A target group is a collection of targets, or compute resources,
that run your application or service. A target group can only be used by a single service.
For more information, see Target groups in the Amazon VPC Lattice User Guide.

# Arguments
- `name`: The name of the target group. The name must be unique within the account. The
  valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last
  character, or immediately after another hyphen.
- `type`: The type of target group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. If you retry a request that completed successfully using the
  same client token and parameters, the retry succeeds without performing any actions. If the
  parameters aren't identical, the retry fails.
- `"config"`: The target group configuration.
- `"tags"`: The tags for the target group.
"""
function create_target_group(name, type; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "POST",
        "/targetgroups",
        Dict{String,Any}("name" => name, "type" => type, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_target_group(
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/targetgroups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "type" => type, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access_log_subscription(access_log_subscription_identifier)
    delete_access_log_subscription(access_log_subscription_identifier, params::Dict{String,<:Any})

Deletes the specified access log subscription.

# Arguments
- `access_log_subscription_identifier`: The ID or Amazon Resource Name (ARN) of the access
  log subscription.

"""
function delete_access_log_subscription(
    accessLogSubscriptionIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access_log_subscription(
    accessLogSubscriptionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_auth_policy(resource_identifier)
    delete_auth_policy(resource_identifier, params::Dict{String,<:Any})

Deletes the specified auth policy. If an auth is set to AWS_IAM and the auth policy is
deleted, all requests are denied. If you are trying to remove the auth policy completely,
you must set the auth type to NONE. If auth is enabled on the resource, but no auth policy
is set, all requests are denied.

# Arguments
- `resource_identifier`: The ID or Amazon Resource Name (ARN) of the resource.

"""
function delete_auth_policy(
    resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/authpolicy/$(resourceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_auth_policy(
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/authpolicy/$(resourceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_listener(listener_identifier, service_identifier)
    delete_listener(listener_identifier, service_identifier, params::Dict{String,<:Any})

Deletes the specified listener.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function delete_listener(
    listenerIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_listener(
    listenerIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(resource_arn)
    delete_resource_policy(resource_arn, params::Dict{String,<:Any})

Deletes the specified resource policy.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function delete_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/resourcepolicy/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/resourcepolicy/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rule(listener_identifier, rule_identifier, service_identifier)
    delete_rule(listener_identifier, rule_identifier, service_identifier, params::Dict{String,<:Any})

Deletes a listener rule. Each listener has a default rule for checking connection requests,
but you can define additional rules. Each rule consists of a priority, one or more actions,
and one or more conditions. You can delete additional listener rules, but you cannot delete
the default rule. For more information, see Listener rules in the Amazon VPC Lattice User
Guide.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `rule_identifier`: The ID or Amazon Resource Name (ARN) of the rule.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function delete_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service(service_identifier)
    delete_service(service_identifier, params::Dict{String,<:Any})

Deletes a service. A service can't be deleted if it's associated with a service network. If
you delete a service, all resources related to the service, such as the resource policy,
auth policy, listeners, listener rules, and access log subscriptions, are also deleted. For
more information, see Delete a service in the Amazon VPC Lattice User Guide.

# Arguments
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function delete_service(
    serviceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service(
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/services/$(serviceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_network(service_network_identifier)
    delete_service_network(service_network_identifier, params::Dict{String,<:Any})

Deletes a service network. You can only delete the service network if there is no service
or VPC associated with it. If you delete a service network, all resources related to the
service network, such as the resource policy, auth policy, and access log subscriptions,
are also deleted. For more information, see Delete a service network in the Amazon VPC
Lattice User Guide.

# Arguments
- `service_network_identifier`: The Amazon Resource Name (ARN) or ID of the service network.

"""
function delete_service_network(
    serviceNetworkIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworks/$(serviceNetworkIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_network(
    serviceNetworkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworks/$(serviceNetworkIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_network_service_association(service_network_service_association_identifier)
    delete_service_network_service_association(service_network_service_association_identifier, params::Dict{String,<:Any})

Deletes the association between a specified service and the specific service network. This
operation fails if an association is still in progress.

# Arguments
- `service_network_service_association_identifier`: The ID or Amazon Resource Name (ARN) of
  the association.

"""
function delete_service_network_service_association(
    serviceNetworkServiceAssociationIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworkserviceassociations/$(serviceNetworkServiceAssociationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_network_service_association(
    serviceNetworkServiceAssociationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworkserviceassociations/$(serviceNetworkServiceAssociationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_service_network_vpc_association(service_network_vpc_association_identifier)
    delete_service_network_vpc_association(service_network_vpc_association_identifier, params::Dict{String,<:Any})

Disassociates the VPC from the service network. You can't disassociate the VPC if there is
a create or update association in progress.

# Arguments
- `service_network_vpc_association_identifier`: The ID or Amazon Resource Name (ARN) of the
  association.

"""
function delete_service_network_vpc_association(
    serviceNetworkVpcAssociationIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_service_network_vpc_association(
    serviceNetworkVpcAssociationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_target_group(target_group_identifier)
    delete_target_group(target_group_identifier, params::Dict{String,<:Any})

Deletes a target group. You can't delete a target group if it is used in a listener rule or
if the target group creation is in progress.

# Arguments
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.

"""
function delete_target_group(
    targetGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/targetgroups/$(targetGroupIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_target_group(
    targetGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/targetgroups/$(targetGroupIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_targets(target_group_identifier, targets)
    deregister_targets(target_group_identifier, targets, params::Dict{String,<:Any})

Deregisters the specified targets from the specified target group.

# Arguments
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.
- `targets`: The targets to deregister.

"""
function deregister_targets(
    targetGroupIdentifier, targets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/deregistertargets",
        Dict{String,Any}("targets" => targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_targets(
    targetGroupIdentifier,
    targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/deregistertargets",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("targets" => targets), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_access_log_subscription(access_log_subscription_identifier)
    get_access_log_subscription(access_log_subscription_identifier, params::Dict{String,<:Any})

Retrieves information about the specified access log subscription.

# Arguments
- `access_log_subscription_identifier`: The ID or Amazon Resource Name (ARN) of the access
  log subscription.

"""
function get_access_log_subscription(
    accessLogSubscriptionIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_access_log_subscription(
    accessLogSubscriptionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_auth_policy(resource_identifier)
    get_auth_policy(resource_identifier, params::Dict{String,<:Any})

Retrieves information about the auth policy for the specified service or service network.

# Arguments
- `resource_identifier`: The ID or Amazon Resource Name (ARN) of the service network or
  service.

"""
function get_auth_policy(
    resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/authpolicy/$(resourceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_auth_policy(
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/authpolicy/$(resourceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_listener(listener_identifier, service_identifier)
    get_listener(listener_identifier, service_identifier, params::Dict{String,<:Any})

Retrieves information about the specified listener for the specified service.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function get_listener(
    listenerIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_listener(
    listenerIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(resource_arn)
    get_resource_policy(resource_arn, params::Dict{String,<:Any})

Retrieves information about the resource policy. The resource policy is an IAM policy
created on behalf of the resource owner when they share a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the service network or service.

"""
function get_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/resourcepolicy/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/resourcepolicy/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rule(listener_identifier, rule_identifier, service_identifier)
    get_rule(listener_identifier, rule_identifier, service_identifier, params::Dict{String,<:Any})

Retrieves information about listener rules. You can also retrieve information about the
default listener rule. For more information, see Listener rules in the Amazon VPC Lattice
User Guide.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `rule_identifier`: The ID or Amazon Resource Name (ARN) of the listener rule.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function get_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service(service_identifier)
    get_service(service_identifier, params::Dict{String,<:Any})

Retrieves information about the specified service.

# Arguments
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function get_service(serviceIdentifier; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service(
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_network(service_network_identifier)
    get_service_network(service_network_identifier, params::Dict{String,<:Any})

Retrieves information about the specified service network.

# Arguments
- `service_network_identifier`: The ID or Amazon Resource Name (ARN) of the service network.

"""
function get_service_network(
    serviceNetworkIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworks/$(serviceNetworkIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_network(
    serviceNetworkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/servicenetworks/$(serviceNetworkIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_network_service_association(service_network_service_association_identifier)
    get_service_network_service_association(service_network_service_association_identifier, params::Dict{String,<:Any})

Retrieves information about the specified association between a service network and a
service.

# Arguments
- `service_network_service_association_identifier`: The ID or Amazon Resource Name (ARN) of
  the association.

"""
function get_service_network_service_association(
    serviceNetworkServiceAssociationIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/servicenetworkserviceassociations/$(serviceNetworkServiceAssociationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_network_service_association(
    serviceNetworkServiceAssociationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/servicenetworkserviceassociations/$(serviceNetworkServiceAssociationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_network_vpc_association(service_network_vpc_association_identifier)
    get_service_network_vpc_association(service_network_vpc_association_identifier, params::Dict{String,<:Any})

Retrieves information about the association between a service network and a VPC.

# Arguments
- `service_network_vpc_association_identifier`: The ID or Amazon Resource Name (ARN) of the
  association.

"""
function get_service_network_vpc_association(
    serviceNetworkVpcAssociationIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_network_vpc_association(
    serviceNetworkVpcAssociationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_target_group(target_group_identifier)
    get_target_group(target_group_identifier, params::Dict{String,<:Any})

Retrieves information about the specified target group.

# Arguments
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.

"""
function get_target_group(
    targetGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/targetgroups/$(targetGroupIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_target_group(
    targetGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/targetgroups/$(targetGroupIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_access_log_subscriptions(resource_identifier)
    list_access_log_subscriptions(resource_identifier, params::Dict{String,<:Any})

Lists all access log subscriptions for the specified service network or service.

# Arguments
- `resource_identifier`: The ID or Amazon Resource Name (ARN) of the service network or
  service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
"""
function list_access_log_subscriptions(
    resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/accesslogsubscriptions",
        Dict{String,Any}("resourceIdentifier" => resourceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_access_log_subscriptions(
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/accesslogsubscriptions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("resourceIdentifier" => resourceIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_listeners(service_identifier)
    list_listeners(service_identifier, params::Dict{String,<:Any})

Lists the listeners for the specified service.

# Arguments
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
"""
function list_listeners(
    serviceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_listeners(
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rules(listener_identifier, service_identifier)
    list_rules(listener_identifier, service_identifier, params::Dict{String,<:Any})

Lists the rules for the listener.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
"""
function list_rules(
    listenerIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rules(
    listenerIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_network_service_associations()
    list_service_network_service_associations(params::Dict{String,<:Any})

Lists the associations between the service network and the service. You can filter the list
either by service or service network. You must provide either the service network
identifier or the service identifier. Every association in Amazon VPC Lattice is given a
unique Amazon Resource Name (ARN), such as when a service network is associated with a VPC
or when a service is associated with a service network. If the association is for a
resource that is shared with another account, the association includes the local account ID
as the prefix in the ARN for each account the resource is shared with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
- `"serviceIdentifier"`: The ID or Amazon Resource Name (ARN) of the service.
- `"serviceNetworkIdentifier"`: The ID or Amazon Resource Name (ARN) of the service network.
"""
function list_service_network_service_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworkserviceassociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_service_network_service_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworkserviceassociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_network_vpc_associations()
    list_service_network_vpc_associations(params::Dict{String,<:Any})

Lists the service network and VPC associations. You can filter the list either by VPC or
service network. You must provide either the service network identifier or the VPC
identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
- `"serviceNetworkIdentifier"`: The ID or Amazon Resource Name (ARN) of the service network.
- `"vpcIdentifier"`: The ID or Amazon Resource Name (ARN) of the VPC.
"""
function list_service_network_vpc_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworkvpcassociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_service_network_vpc_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworkvpcassociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_service_networks()
    list_service_networks(params::Dict{String,<:Any})

Lists the service networks owned by the caller account or shared with the caller account.
Also includes the account ID in the ARN to show which account owns the service network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
"""
function list_service_networks(; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "GET", "/servicenetworks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_service_networks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/servicenetworks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_services()
    list_services(params::Dict{String,<:Any})

Lists the services owned by the caller account or shared with the caller account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
"""
function list_services(; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "GET", "/services"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_services(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET", "/services", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_target_groups()
    list_target_groups(params::Dict{String,<:Any})

Lists your target groups. You can narrow your search by using the filters below in your
request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
- `"targetGroupType"`: The target group type.
- `"vpcIdentifier"`: The ID or Amazon Resource Name (ARN) of the VPC.
"""
function list_target_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "GET", "/targetgroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_target_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "GET",
        "/targetgroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets(target_group_identifier)
    list_targets(target_group_identifier, params::Dict{String,<:Any})

Lists the targets for the target group. By default, all targets are included. You can use
this API to check the health status of targets. You can also ﬁlter the results by target.

# Arguments
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: A pagination token for the next page of results.
- `"targets"`: The targets.
"""
function list_targets(
    targetGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/listtargets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_targets(
    targetGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/listtargets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_auth_policy(policy, resource_identifier)
    put_auth_policy(policy, resource_identifier, params::Dict{String,<:Any})

Creates or updates the auth policy. The policy string in JSON must not contain newlines or
blank lines. For more information, see Auth policies in the Amazon VPC Lattice User Guide.

# Arguments
- `policy`: The auth policy. The policy string in JSON must not contain newlines or blank
  lines.
- `resource_identifier`: The ID or Amazon Resource Name (ARN) of the service network or
  service for which the policy is created.

"""
function put_auth_policy(
    policy, resourceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "PUT",
        "/authpolicy/$(resourceIdentifier)",
        Dict{String,Any}("policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_auth_policy(
    policy,
    resourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PUT",
        "/authpolicy/$(resourceIdentifier)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("policy" => policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Attaches a resource-based permission policy to a service or service network. The policy
must contain the same actions and condition statements as the Amazon Web Services Resource
Access Manager permission for sharing services and service networks.

# Arguments
- `policy`: An IAM policy. The policy string in JSON must not contain newlines or blank
  lines.
- `resource_arn`: The ID or Amazon Resource Name (ARN) of the service network or service
  for which the policy is created.

"""
function put_resource_policy(
    policy, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "PUT",
        "/resourcepolicy/$(resourceArn)",
        Dict{String,Any}("policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    policy,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PUT",
        "/resourcepolicy/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("policy" => policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_targets(target_group_identifier, targets)
    register_targets(target_group_identifier, targets, params::Dict{String,<:Any})

Registers the targets with the target group. If it's a Lambda target, you can only have one
target in a target group.

# Arguments
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.
- `targets`: The targets.

"""
function register_targets(
    targetGroupIdentifier, targets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/registertargets",
        Dict{String,Any}("targets" => targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_targets(
    targetGroupIdentifier,
    targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/targetgroups/$(targetGroupIdentifier)/registertargets",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("targets" => targets), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tags to the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: The tags for the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return vpc_lattice(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The tag keys of the tags to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_access_log_subscription(access_log_subscription_identifier, destination_arn)
    update_access_log_subscription(access_log_subscription_identifier, destination_arn, params::Dict{String,<:Any})

Updates the specified access log subscription.

# Arguments
- `access_log_subscription_identifier`: The ID or Amazon Resource Name (ARN) of the access
  log subscription.
- `destination_arn`: The Amazon Resource Name (ARN) of the access log destination.

"""
function update_access_log_subscription(
    accessLogSubscriptionIdentifier,
    destinationArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)",
        Dict{String,Any}("destinationArn" => destinationArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_access_log_subscription(
    accessLogSubscriptionIdentifier,
    destinationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/accesslogsubscriptions/$(accessLogSubscriptionIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("destinationArn" => destinationArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_listener(default_action, listener_identifier, service_identifier)
    update_listener(default_action, listener_identifier, service_identifier, params::Dict{String,<:Any})

Updates the specified listener for the specified service.

# Arguments
- `default_action`: The action for the default rule.
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

"""
function update_listener(
    defaultAction,
    listenerIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)",
        Dict{String,Any}("defaultAction" => defaultAction);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_listener(
    defaultAction,
    listenerIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("defaultAction" => defaultAction), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rule(listener_identifier, rule_identifier, service_identifier)
    update_rule(listener_identifier, rule_identifier, service_identifier, params::Dict{String,<:Any})

Updates a rule for the listener. You can't modify a default listener rule. To modify a
default listener rule, use UpdateListener.

# Arguments
- `listener_identifier`: The ID or Amazon Resource Name (ARN) of the listener.
- `rule_identifier`: The ID or Amazon Resource Name (ARN) of the rule.
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"action"`: Information about the action for the specified listener rule.
- `"match"`: The rule match.
- `"priority"`: The rule priority. A listener can't have multiple rules with the same
  priority.
"""
function update_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rule(
    listenerIdentifier,
    ruleIdentifier,
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)/listeners/$(listenerIdentifier)/rules/$(ruleIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service(service_identifier)
    update_service(service_identifier, params::Dict{String,<:Any})

Updates the specified service.

# Arguments
- `service_identifier`: The ID or Amazon Resource Name (ARN) of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authType"`: The type of IAM policy.    NONE: The resource does not use an IAM policy.
  This is the default.    AWS_IAM: The resource uses an IAM policy. When this type is used,
  auth is enabled and an auth policy is required.
- `"certificateArn"`: The Amazon Resource Name (ARN) of the certificate.
"""
function update_service(
    serviceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service(
    serviceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/services/$(serviceIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_network(auth_type, service_network_identifier)
    update_service_network(auth_type, service_network_identifier, params::Dict{String,<:Any})

Updates the specified service network.

# Arguments
- `auth_type`: The type of IAM policy.    NONE: The resource does not use an IAM policy.
  This is the default.    AWS_IAM: The resource uses an IAM policy. When this type is used,
  auth is enabled and an auth policy is required.
- `service_network_identifier`: The ID or Amazon Resource Name (ARN) of the service network.

"""
function update_service_network(
    authType, serviceNetworkIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "PATCH",
        "/servicenetworks/$(serviceNetworkIdentifier)",
        Dict{String,Any}("authType" => authType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service_network(
    authType,
    serviceNetworkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/servicenetworks/$(serviceNetworkIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("authType" => authType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_network_vpc_association(security_group_ids, service_network_vpc_association_identifier)
    update_service_network_vpc_association(security_group_ids, service_network_vpc_association_identifier, params::Dict{String,<:Any})

Updates the service network and VPC association. If you add a security group to the service
network and VPC association, the association must continue to always have at least one
security group. You can add or edit security groups at any time. However, to remove all
security groups, you must first delete the association and recreate it without security
groups.

# Arguments
- `security_group_ids`: The IDs of the security groups.
- `service_network_vpc_association_identifier`: The ID or Amazon Resource Name (ARN) of the
  association.

"""
function update_service_network_vpc_association(
    securityGroupIds,
    serviceNetworkVpcAssociationIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)",
        Dict{String,Any}("securityGroupIds" => securityGroupIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service_network_vpc_association(
    securityGroupIds,
    serviceNetworkVpcAssociationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/servicenetworkvpcassociations/$(serviceNetworkVpcAssociationIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("securityGroupIds" => securityGroupIds), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_target_group(health_check, target_group_identifier)
    update_target_group(health_check, target_group_identifier, params::Dict{String,<:Any})

Updates the specified target group.

# Arguments
- `health_check`: The health check configuration.
- `target_group_identifier`: The ID or Amazon Resource Name (ARN) of the target group.

"""
function update_target_group(
    healthCheck, targetGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return vpc_lattice(
        "PATCH",
        "/targetgroups/$(targetGroupIdentifier)",
        Dict{String,Any}("healthCheck" => healthCheck);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_target_group(
    healthCheck,
    targetGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return vpc_lattice(
        "PATCH",
        "/targetgroups/$(targetGroupIdentifier)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("healthCheck" => healthCheck), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
