# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: appfabric
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_user_access_tasks(app_bundle_identifier, task_id_list)
    batch_get_user_access_tasks(app_bundle_identifier, task_id_list, params::Dict{String,<:Any})

Gets user access details in a batch request. This action polls data from the tasks that are
kicked off by the StartUserAccessTasks action.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `task_id_list`: The tasks IDs to use for the request.

"""
function batch_get_user_access_tasks(
    appBundleIdentifier, taskIdList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "POST",
        "/useraccess/batchget",
        Dict{String,Any}(
            "appBundleIdentifier" => appBundleIdentifier, "taskIdList" => taskIdList
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_user_access_tasks(
    appBundleIdentifier,
    taskIdList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/useraccess/batchget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appBundleIdentifier" => appBundleIdentifier, "taskIdList" => taskIdList
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    connect_app_authorization(app_authorization_identifier, app_bundle_identifier)
    connect_app_authorization(app_authorization_identifier, app_bundle_identifier, params::Dict{String,<:Any})

Establishes a connection between Amazon Web Services AppFabric and an application, which
allows AppFabric to call the APIs of the application.

# Arguments
- `app_authorization_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the app authorization to use for the request.
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle that contains the app authorization to use for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authRequest"`: Contains OAuth2 authorization information. This is required if the app
  authorization for the request is configured with an OAuth2 (oauth2) authorization type.
"""
function connect_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)/connect";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function connect_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)/connect",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_authorization(app, app_bundle_identifier, auth_type, credential, tenant)
    create_app_authorization(app, app_bundle_identifier, auth_type, credential, tenant, params::Dict{String,<:Any})

Creates an app authorization within an app bundle, which allows AppFabric to connect to an
application.

# Arguments
- `app`: The name of the application. Valid values are:    SLACK     ASANA     JIRA
  M365     M365AUDITLOGS     ZOOM     ZENDESK     OKTA     GOOGLE     DROPBOX     SMARTSHEET
     CISCO
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `auth_type`: The authorization type for the app authorization.
- `credential`: Contains credentials for the application, such as an API key or OAuth2
  client ID and secret. Specify credentials that match the authorization type for your
  request. For example, if the authorization type for your request is OAuth2 (oauth2), then
  you should provide only the OAuth2 credentials.
- `tenant`: Contains information about an application tenant, such as the application
  display name and identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Specifies a unique, case-sensitive identifier that you provide to ensure
  the idempotency of the request. This lets you safely retry the request without accidentally
  performing the same operation a second time. Passing the same value to a later call to an
  operation requires that you also pass the same value for all other parameters. We recommend
  that you use a UUID type of value. If you don't provide this value, then Amazon Web
  Services generates a random one for you. If you retry the operation with the same
  ClientToken, but with different parameters, the retry fails with an
  IdempotentParameterMismatch error.
- `"tags"`: A map of the key-value pairs of the tag or tags to assign to the resource.
"""
function create_app_authorization(
    app,
    appBundleIdentifier,
    authType,
    credential,
    tenant;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/appauthorizations",
        Dict{String,Any}(
            "app" => app,
            "authType" => authType,
            "credential" => credential,
            "tenant" => tenant,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_authorization(
    app,
    appBundleIdentifier,
    authType,
    credential,
    tenant,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/appauthorizations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "app" => app,
                    "authType" => authType,
                    "credential" => credential,
                    "tenant" => tenant,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_bundle()
    create_app_bundle(params::Dict{String,<:Any})

Creates an app bundle to collect data from an application using AppFabric.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Specifies a unique, case-sensitive identifier that you provide to ensure
  the idempotency of the request. This lets you safely retry the request without accidentally
  performing the same operation a second time. Passing the same value to a later call to an
  operation requires that you also pass the same value for all other parameters. We recommend
  that you use a UUID type of value. If you don't provide this value, then Amazon Web
  Services generates a random one for you. If you retry the operation with the same
  ClientToken, but with different parameters, the retry fails with an
  IdempotentParameterMismatch error.
- `"customerManagedKeyIdentifier"`: The Amazon Resource Name (ARN) of the Key Management
  Service (KMS) key to use to encrypt the application data. If this is not specified, an
  Amazon Web Services owned key is used for encryption.
- `"tags"`: A map of the key-value pairs of the tag or tags to assign to the resource.
"""
function create_app_bundle(; aws_config::AbstractAWSConfig=current_aws_config())
    return appfabric(
        "POST",
        "/appbundles",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_bundle(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "POST",
        "/appbundles",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ingestion(app, app_bundle_identifier, ingestion_type, tenant_id)
    create_ingestion(app, app_bundle_identifier, ingestion_type, tenant_id, params::Dict{String,<:Any})

Creates a data ingestion for an application.

# Arguments
- `app`: The name of the application. Valid values are:    SLACK     ASANA     JIRA
  M365     M365AUDITLOGS     ZOOM     ZENDESK     OKTA     GOOGLE     DROPBOX     SMARTSHEET
     CISCO
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_type`: The ingestion type.
- `tenant_id`: The ID of the application tenant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Specifies a unique, case-sensitive identifier that you provide to ensure
  the idempotency of the request. This lets you safely retry the request without accidentally
  performing the same operation a second time. Passing the same value to a later call to an
  operation requires that you also pass the same value for all other parameters. We recommend
  that you use a UUID type of value. If you don't provide this value, then Amazon Web
  Services generates a random one for you. If you retry the operation with the same
  ClientToken, but with different parameters, the retry fails with an
  IdempotentParameterMismatch error.
- `"tags"`: A map of the key-value pairs of the tag or tags to assign to the resource.
"""
function create_ingestion(
    app,
    appBundleIdentifier,
    ingestionType,
    tenantId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions",
        Dict{String,Any}(
            "app" => app,
            "ingestionType" => ingestionType,
            "tenantId" => tenantId,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ingestion(
    app,
    appBundleIdentifier,
    ingestionType,
    tenantId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "app" => app,
                    "ingestionType" => ingestionType,
                    "tenantId" => tenantId,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ingestion_destination(app_bundle_identifier, destination_configuration, ingestion_identifier, processing_configuration)
    create_ingestion_destination(app_bundle_identifier, destination_configuration, ingestion_identifier, processing_configuration, params::Dict{String,<:Any})

Creates an ingestion destination, which specifies how an application's ingested data is
processed by Amazon Web Services AppFabric and where it's delivered.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `destination_configuration`: Contains information about the destination of ingested data.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.
- `processing_configuration`: Contains information about how ingested data is processed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Specifies a unique, case-sensitive identifier that you provide to ensure
  the idempotency of the request. This lets you safely retry the request without accidentally
  performing the same operation a second time. Passing the same value to a later call to an
  operation requires that you also pass the same value for all other parameters. We recommend
  that you use a UUID type of value. If you don't provide this value, then Amazon Web
  Services generates a random one for you. If you retry the operation with the same
  ClientToken, but with different parameters, the retry fails with an
  IdempotentParameterMismatch error.
- `"tags"`: A map of the key-value pairs of the tag or tags to assign to the resource.
"""
function create_ingestion_destination(
    appBundleIdentifier,
    destinationConfiguration,
    ingestionIdentifier,
    processingConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations",
        Dict{String,Any}(
            "destinationConfiguration" => destinationConfiguration,
            "processingConfiguration" => processingConfiguration,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ingestion_destination(
    appBundleIdentifier,
    destinationConfiguration,
    ingestionIdentifier,
    processingConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationConfiguration" => destinationConfiguration,
                    "processingConfiguration" => processingConfiguration,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_authorization(app_authorization_identifier, app_bundle_identifier)
    delete_app_authorization(app_authorization_identifier, app_bundle_identifier, params::Dict{String,<:Any})

Deletes an app authorization. You must delete the associated ingestion before you can
delete an app authorization.

# Arguments
- `app_authorization_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the app authorization to use for the request.
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

"""
function delete_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_bundle(app_bundle_identifier)
    delete_app_bundle(app_bundle_identifier, params::Dict{String,<:Any})

Deletes an app bundle. You must delete all associated app authorizations before you can
delete an app bundle.

# Arguments
- `app_bundle_identifier`: The ID or Amazon Resource Name (ARN) of the app bundle that
  needs to be deleted.

"""
function delete_app_bundle(
    appBundleIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_bundle(
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ingestion(app_bundle_identifier, ingestion_identifier)
    delete_ingestion(app_bundle_identifier, ingestion_identifier, params::Dict{String,<:Any})

Deletes an ingestion. You must stop (disable) the ingestion and you must delete all
associated ingestion destinations before you can delete an app ingestion.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function delete_ingestion(
    appBundleIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ingestion(
    appBundleIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ingestion_destination(app_bundle_identifier, ingestion_destination_identifier, ingestion_identifier)
    delete_ingestion_destination(app_bundle_identifier, ingestion_destination_identifier, ingestion_identifier, params::Dict{String,<:Any})

Deletes an ingestion destination. This deletes the association between an ingestion and
it's destination. It doesn't delete previously ingested data or the storage destination,
such as the Amazon S3 bucket where the data is delivered. If the ingestion destination is
deleted while the associated ingestion is enabled, the ingestion will fail and is
eventually disabled.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_destination_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the ingestion destination to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function delete_ingestion_destination(
    appBundleIdentifier,
    ingestionDestinationIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ingestion_destination(
    appBundleIdentifier,
    ingestionDestinationIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_app_authorization(app_authorization_identifier, app_bundle_identifier)
    get_app_authorization(app_authorization_identifier, app_bundle_identifier, params::Dict{String,<:Any})

Returns information about an app authorization.

# Arguments
- `app_authorization_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the app authorization to use for the request.
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

"""
function get_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_app_bundle(app_bundle_identifier)
    get_app_bundle(app_bundle_identifier, params::Dict{String,<:Any})

Returns information about an app bundle.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

"""
function get_app_bundle(
    appBundleIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_app_bundle(
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ingestion(app_bundle_identifier, ingestion_identifier)
    get_ingestion(app_bundle_identifier, ingestion_identifier, params::Dict{String,<:Any})

Returns information about an ingestion.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function get_ingestion(
    appBundleIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ingestion(
    appBundleIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ingestion_destination(app_bundle_identifier, ingestion_destination_identifier, ingestion_identifier)
    get_ingestion_destination(app_bundle_identifier, ingestion_destination_identifier, ingestion_identifier, params::Dict{String,<:Any})

Returns information about an ingestion destination.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_destination_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the ingestion destination to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function get_ingestion_destination(
    appBundleIdentifier,
    ingestionDestinationIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ingestion_destination(
    appBundleIdentifier,
    ingestionDestinationIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_authorizations(app_bundle_identifier)
    list_app_authorizations(app_bundle_identifier, params::Dict{String,<:Any})

Returns a list of all app authorizations configured for an app bundle.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_app_authorizations(
    appBundleIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/appauthorizations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_authorizations(
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/appauthorizations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_bundles()
    list_app_bundles(params::Dict{String,<:Any})

Returns a list of app bundles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_app_bundles(; aws_config::AbstractAWSConfig=current_aws_config())
    return appfabric(
        "GET", "/appbundles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_app_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "GET", "/appbundles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_ingestion_destinations(app_bundle_identifier, ingestion_identifier)
    list_ingestion_destinations(app_bundle_identifier, ingestion_identifier, params::Dict{String,<:Any})

Returns a list of all ingestion destinations configured for an ingestion.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_ingestion_destinations(
    appBundleIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_ingestion_destinations(
    appBundleIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_ingestions(app_bundle_identifier)
    list_ingestions(app_bundle_identifier, params::Dict{String,<:Any})

Returns a list of all ingestions configured for an app bundle.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that are returned per call. You can use
  nextToken to obtain further pages of results. This is only an upper limit. The actual
  number of results returned per call might be fewer than the specified maximum.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page. Keep all other arguments unchanged. Each
  pagination token expires after 24 hours. Using an expired pagination token will return an
  HTTP 400 InvalidToken error.
"""
function list_ingestions(
    appBundleIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_ingestions(
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/appbundles/$(appBundleIdentifier)/ingestions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags for a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to
  retrieve tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_ingestion(app_bundle_identifier, ingestion_identifier)
    start_ingestion(app_bundle_identifier, ingestion_identifier, params::Dict{String,<:Any})

Starts (enables) an ingestion, which collects data from an application.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function start_ingestion(
    appBundleIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/start";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_ingestion(
    appBundleIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/start",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_user_access_tasks(app_bundle_identifier, email)
    start_user_access_tasks(app_bundle_identifier, email, params::Dict{String,<:Any})

Starts the tasks to search user access status for a specific email address. The tasks are
stopped when the user access status data is found. The tasks are terminated when the API
calls to the application time out.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `email`: The email address of the target user.

"""
function start_user_access_tasks(
    appBundleIdentifier, email; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "POST",
        "/useraccess/start",
        Dict{String,Any}("appBundleIdentifier" => appBundleIdentifier, "email" => email);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_user_access_tasks(
    appBundleIdentifier,
    email,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/useraccess/start",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appBundleIdentifier" => appBundleIdentifier, "email" => email
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_ingestion(app_bundle_identifier, ingestion_identifier)
    stop_ingestion(app_bundle_identifier, ingestion_identifier, params::Dict{String,<:Any})

Stops (disables) an ingestion.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function stop_ingestion(
    appBundleIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_ingestion(
    appBundleIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to tag.
- `tags`: A map of the key-value pairs of the tag or tags to assign to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return appfabric(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag or tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to untag.
- `tag_keys`: The keys of the key-value pairs for the tag or tags you want to remove from
  the specified resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appfabric(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_authorization(app_authorization_identifier, app_bundle_identifier)
    update_app_authorization(app_authorization_identifier, app_bundle_identifier, params::Dict{String,<:Any})

Updates an app authorization within an app bundle, which allows AppFabric to connect to an
application. If the app authorization was in a connected state, updating the app
authorization will set it back to a PendingConnect state.

# Arguments
- `app_authorization_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the app authorization to use for the request.
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"credential"`: Contains credentials for the application, such as an API key or OAuth2
  client ID and secret. Specify credentials that match the authorization type of the app
  authorization to update. For example, if the authorization type of the app authorization is
  OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
- `"tenant"`: Contains information about an application tenant, such as the application
  display name and identifier.
"""
function update_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "PATCH",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_authorization(
    appAuthorizationIdentifier,
    appBundleIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "PATCH",
        "/appbundles/$(appBundleIdentifier)/appauthorizations/$(appAuthorizationIdentifier)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ingestion_destination(app_bundle_identifier, destination_configuration, ingestion_destination_identifier, ingestion_identifier)
    update_ingestion_destination(app_bundle_identifier, destination_configuration, ingestion_destination_identifier, ingestion_identifier, params::Dict{String,<:Any})

Updates an ingestion destination, which specifies how an application's ingested data is
processed by Amazon Web Services AppFabric and where it's delivered.

# Arguments
- `app_bundle_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the app bundle to use for the request.
- `destination_configuration`: Contains information about the destination of ingested data.
- `ingestion_destination_identifier`: The Amazon Resource Name (ARN) or Universal Unique
  Identifier (UUID) of the ingestion destination to use for the request.
- `ingestion_identifier`: The Amazon Resource Name (ARN) or Universal Unique Identifier
  (UUID) of the ingestion to use for the request.

"""
function update_ingestion_destination(
    appBundleIdentifier,
    destinationConfiguration,
    ingestionDestinationIdentifier,
    ingestionIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "PATCH",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)",
        Dict{String,Any}("destinationConfiguration" => destinationConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ingestion_destination(
    appBundleIdentifier,
    destinationConfiguration,
    ingestionDestinationIdentifier,
    ingestionIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appfabric(
        "PATCH",
        "/appbundles/$(appBundleIdentifier)/ingestions/$(ingestionIdentifier)/ingestiondestinations/$(ingestionDestinationIdentifier)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("destinationConfiguration" => destinationConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
