# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: cleanroomsml
using AWS.Compat
using AWS.UUIDs

"""
    create_audience_model(name, training_dataset_arn)
    create_audience_model(name, training_dataset_arn, params::Dict{String,<:Any})

Defines the information necessary to create an audience model. An audience model is a
machine learning model that Clean Rooms ML trains to measure similarity between users.
Clean Rooms ML manages training and storing the audience model. The audience model can be
used in multiple calls to the StartAudienceGenerationJob API.

# Arguments
- `name`: The name of the audience model resource.
- `training_dataset_arn`: The Amazon Resource Name (ARN) of the training dataset for this
  audience model.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the audience model.
- `"kmsKeyArn"`: The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt
  and decrypt customer-owned data in the trained ML model and the associated data.
- `"tags"`: The optional metadata that you apply to the resource to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.
    For each resource, each tag key must be unique, and each tag key can have only one value.
    Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256
  Unicode characters in UTF-8.   If your tagging schema is used across multiple services and
  resources, remember that other services may have restrictions on allowed characters.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do
  not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as
  it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can
  have this prefix. If a tag value has aws as its prefix but the key does not, then Clean
  Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags
  with only the key prefix of aws do not count against your tags per resource limit.
- `"trainingDataEndTime"`: The end date and time of the training window.
- `"trainingDataStartTime"`: The start date and time of the training window.
"""
function create_audience_model(
    name, trainingDatasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "POST",
        "/audience-model",
        Dict{String,Any}("name" => name, "trainingDatasetArn" => trainingDatasetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_audience_model(
    name,
    trainingDatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/audience-model",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "trainingDatasetArn" => trainingDatasetArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configured_audience_model(audience_model_arn, name, output_config, shared_audience_metrics)
    create_configured_audience_model(audience_model_arn, name, output_config, shared_audience_metrics, params::Dict{String,<:Any})

Defines the information necessary to create a configured audience model.

# Arguments
- `audience_model_arn`: The Amazon Resource Name (ARN) of the audience model to use for the
  configured audience model.
- `name`: The name of the configured audience model.
- `output_config`: Configure the Amazon S3 location and IAM Role for audiences created
  using this configured audience model. Each audience will have a unique location. The IAM
  Role must have s3:PutObject permission on the destination Amazon S3 location. If the
  destination is protected with Amazon S3 KMS-SSE, then the Role must also have the required
  KMS permissions.
- `shared_audience_metrics`: Whether audience metrics are shared.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"audienceSizeConfig"`: Configure the list of output sizes of audiences that can be
  created using this configured audience model. A request to StartAudienceGenerationJob that
  uses this configured audience model must have an audienceSize selected from this list. You
  can use the ABSOLUTE AudienceSize to configure out audience sizes using the count of
  identifiers in the output. You can use the Percentage AudienceSize to configure sizes in
  the range 1-100 percent.
- `"childResourceTagOnCreatePolicy"`: Configure how the service tags audience generation
  jobs created using this configured audience model. If you specify NONE, the tags from the
  StartAudienceGenerationJob request determine the tags of the audience generation job. If
  you specify FROM_PARENT_RESOURCE, the audience generation job inherits the tags from the
  configured audience model, by default. Tags in the StartAudienceGenerationJob will override
  the default. When the client is in a different account than the configured audience model,
  the tags from the client are never applied to a resource in the caller's account.
- `"description"`: The description of the configured audience model.
- `"minMatchingSeedSize"`: The minimum number of users from the seed audience that must
  match with users in the training data of the audience model. The default value is 500.
- `"tags"`: The optional metadata that you apply to the resource to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.
    For each resource, each tag key must be unique, and each tag key can have only one value.
    Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256
  Unicode characters in UTF-8.   If your tagging schema is used across multiple services and
  resources, remember that other services may have restrictions on allowed characters.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do
  not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as
  it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can
  have this prefix. If a tag value has aws as its prefix but the key does not, then Clean
  Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags
  with only the key prefix of aws do not count against your tags per resource limit.
"""
function create_configured_audience_model(
    audienceModelArn,
    name,
    outputConfig,
    sharedAudienceMetrics;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/configured-audience-model",
        Dict{String,Any}(
            "audienceModelArn" => audienceModelArn,
            "name" => name,
            "outputConfig" => outputConfig,
            "sharedAudienceMetrics" => sharedAudienceMetrics,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configured_audience_model(
    audienceModelArn,
    name,
    outputConfig,
    sharedAudienceMetrics,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/configured-audience-model",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "audienceModelArn" => audienceModelArn,
                    "name" => name,
                    "outputConfig" => outputConfig,
                    "sharedAudienceMetrics" => sharedAudienceMetrics,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_training_dataset(name, role_arn, training_data)
    create_training_dataset(name, role_arn, training_data, params::Dict{String,<:Any})

Defines the information necessary to create a training dataset. In Clean Rooms ML, the
TrainingDataset is metadata that points to a Glue table, which is read only during
AudienceModel creation.

# Arguments
- `name`: The name of the training dataset. This name must be unique in your account and
  region.
- `role_arn`: The ARN of the IAM role that Clean Rooms ML can assume to read the data
  referred to in the dataSource field of each dataset. Passing a role across AWS accounts is
  not allowed. If you pass a role that isn't in your account, you get an
  AccessDeniedException error.
- `training_data`: An array of information that lists the Dataset objects, which specifies
  the dataset type and details on its location and schema. You must provide a role that has
  read access to these tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the training dataset.
- `"tags"`: The optional metadata that you apply to the resource to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.
    For each resource, each tag key must be unique, and each tag key can have only one value.
    Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256
  Unicode characters in UTF-8.   If your tagging schema is used across multiple services and
  resources, remember that other services may have restrictions on allowed characters.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do
  not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as
  it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can
  have this prefix. If a tag value has aws as its prefix but the key does not, then Clean
  Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags
  with only the key prefix of aws do not count against your tags per resource limit.
"""
function create_training_dataset(
    name, roleArn, trainingData; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "POST",
        "/training-dataset",
        Dict{String,Any}(
            "name" => name, "roleArn" => roleArn, "trainingData" => trainingData
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_training_dataset(
    name,
    roleArn,
    trainingData,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/training-dataset",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "roleArn" => roleArn, "trainingData" => trainingData
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_audience_generation_job(audience_generation_job_arn)
    delete_audience_generation_job(audience_generation_job_arn, params::Dict{String,<:Any})

Deletes the specified audience generation job, and removes all data associated with the job.

# Arguments
- `audience_generation_job_arn`: The Amazon Resource Name (ARN) of the audience generation
  job that you want to delete.

"""
function delete_audience_generation_job(
    audienceGenerationJobArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/audience-generation-job/$(audienceGenerationJobArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_audience_generation_job(
    audienceGenerationJobArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/audience-generation-job/$(audienceGenerationJobArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_audience_model(audience_model_arn)
    delete_audience_model(audience_model_arn, params::Dict{String,<:Any})

Specifies an audience model that you want to delete. You can't delete an audience model if
there are any configured audience models that depend on the audience model.

# Arguments
- `audience_model_arn`: The Amazon Resource Name (ARN) of the audience model that you want
  to delete.

"""
function delete_audience_model(
    audienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/audience-model/$(audienceModelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_audience_model(
    audienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/audience-model/$(audienceModelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configured_audience_model(configured_audience_model_arn)
    delete_configured_audience_model(configured_audience_model_arn, params::Dict{String,<:Any})

Deletes the specified configured audience model. You can't delete a configured audience
model if there are any lookalike models that use the configured audience model. If you
delete a configured audience model, it will be removed from any collaborations that it is
associated to.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that you want to delete.

"""
function delete_configured_audience_model(
    configuredAudienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/configured-audience-model/$(configuredAudienceModelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configured_audience_model(
    configuredAudienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/configured-audience-model/$(configuredAudienceModelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configured_audience_model_policy(configured_audience_model_arn)
    delete_configured_audience_model_policy(configured_audience_model_arn, params::Dict{String,<:Any})

Deletes the specified configured audience model policy.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model policy that you want to delete.

"""
function delete_configured_audience_model_policy(
    configuredAudienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configured_audience_model_policy(
    configuredAudienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_training_dataset(training_dataset_arn)
    delete_training_dataset(training_dataset_arn, params::Dict{String,<:Any})

Specifies a training dataset that you want to delete. You can't delete a training dataset
if there are any audience models that depend on the training dataset. In Clean Rooms ML,
the TrainingDataset is metadata that points to a Glue table, which is read only during
AudienceModel creation. This action deletes the metadata.

# Arguments
- `training_dataset_arn`: The Amazon Resource Name (ARN) of the training dataset that you
  want to delete.

"""
function delete_training_dataset(
    trainingDatasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/training-dataset/$(trainingDatasetArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_training_dataset(
    trainingDatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/training-dataset/$(trainingDatasetArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_audience_generation_job(audience_generation_job_arn)
    get_audience_generation_job(audience_generation_job_arn, params::Dict{String,<:Any})

Returns information about an audience generation job.

# Arguments
- `audience_generation_job_arn`: The Amazon Resource Name (ARN) of the audience generation
  job that you are interested in.

"""
function get_audience_generation_job(
    audienceGenerationJobArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/audience-generation-job/$(audienceGenerationJobArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_audience_generation_job(
    audienceGenerationJobArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/audience-generation-job/$(audienceGenerationJobArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_audience_model(audience_model_arn)
    get_audience_model(audience_model_arn, params::Dict{String,<:Any})

Returns information about an audience model

# Arguments
- `audience_model_arn`: The Amazon Resource Name (ARN) of the audience model that you are
  interested in.

"""
function get_audience_model(
    audienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/audience-model/$(audienceModelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_audience_model(
    audienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/audience-model/$(audienceModelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_configured_audience_model(configured_audience_model_arn)
    get_configured_audience_model(configured_audience_model_arn, params::Dict{String,<:Any})

Returns information about a specified configured audience model.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that you are interested in.

"""
function get_configured_audience_model(
    configuredAudienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model/$(configuredAudienceModelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_configured_audience_model(
    configuredAudienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model/$(configuredAudienceModelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_configured_audience_model_policy(configured_audience_model_arn)
    get_configured_audience_model_policy(configured_audience_model_arn, params::Dict{String,<:Any})

Returns information about a configured audience model policy.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that you are interested in.

"""
function get_configured_audience_model_policy(
    configuredAudienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_configured_audience_model_policy(
    configuredAudienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_training_dataset(training_dataset_arn)
    get_training_dataset(training_dataset_arn, params::Dict{String,<:Any})

Returns information about a training dataset.

# Arguments
- `training_dataset_arn`: The Amazon Resource Name (ARN) of the training dataset that you
  are interested in.

"""
function get_training_dataset(
    trainingDatasetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/training-dataset/$(trainingDatasetArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_training_dataset(
    trainingDatasetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/training-dataset/$(trainingDatasetArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audience_export_jobs()
    list_audience_export_jobs(params::Dict{String,<:Any})

Returns a list of the audience export jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"audienceGenerationJobArn"`: The Amazon Resource Name (ARN) of the audience generation
  job that you are interested in.
- `"maxResults"`: The maximum size of the results that is returned per call.
- `"nextToken"`: The token value retrieved from a previous call to access the next page of
  results.
"""
function list_audience_export_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return cleanroomsml(
        "GET",
        "/audience-export-job";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audience_export_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/audience-export-job",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audience_generation_jobs()
    list_audience_generation_jobs(params::Dict{String,<:Any})

Returns a list of audience generation jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"collaborationId"`: The identifier of the collaboration that contains the audience
  generation jobs that you are interested in.
- `"configuredAudienceModelArn"`: The Amazon Resource Name (ARN) of the configured audience
  model that was used for the audience generation jobs that you are interested in.
- `"maxResults"`: The maximum size of the results that is returned per call.
- `"nextToken"`: The token value retrieved from a previous call to access the next page of
  results.
"""
function list_audience_generation_jobs(; aws_config::AbstractAWSConfig=current_aws_config())
    return cleanroomsml(
        "GET",
        "/audience-generation-job";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_audience_generation_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/audience-generation-job",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_audience_models()
    list_audience_models(params::Dict{String,<:Any})

Returns a list of audience models.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum size of the results that is returned per call.
- `"nextToken"`: The token value retrieved from a previous call to access the next page of
  results.
"""
function list_audience_models(; aws_config::AbstractAWSConfig=current_aws_config())
    return cleanroomsml(
        "GET", "/audience-model"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_audience_models(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/audience-model",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_configured_audience_models()
    list_configured_audience_models(params::Dict{String,<:Any})

Returns a list of the configured audience models.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum size of the results that is returned per call.
- `"nextToken"`: The token value retrieved from a previous call to access the next page of
  results.
"""
function list_configured_audience_models(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_configured_audience_models(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/configured-audience-model",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags for a provided resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you are interested in.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_training_datasets()
    list_training_datasets(params::Dict{String,<:Any})

Returns a list of training datasets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum size of the results that is returned per call.
- `"nextToken"`: The token value retrieved from a previous call to access the next page of
  results.
"""
function list_training_datasets(; aws_config::AbstractAWSConfig=current_aws_config())
    return cleanroomsml(
        "GET", "/training-dataset"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_training_datasets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "GET",
        "/training-dataset",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_configured_audience_model_policy(configured_audience_model_arn, configured_audience_model_policy)
    put_configured_audience_model_policy(configured_audience_model_arn, configured_audience_model_policy, params::Dict{String,<:Any})

Create or update the resource policy for a configured audience model.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that the resource policy will govern.
- `configured_audience_model_policy`: The IAM resource policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"policyExistenceCondition"`: Use this to prevent unexpected concurrent modification of
  the policy.
- `"previousPolicyHash"`: A cryptographic hash of the contents of the policy used to
  prevent unexpected concurrent modification of the policy.
"""
function put_configured_audience_model_policy(
    configuredAudienceModelArn,
    configuredAudienceModelPolicy;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "PUT",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy",
        Dict{String,Any}("configuredAudienceModelPolicy" => configuredAudienceModelPolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_configured_audience_model_policy(
    configuredAudienceModelArn,
    configuredAudienceModelPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "PUT",
        "/configured-audience-model/$(configuredAudienceModelArn)/policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configuredAudienceModelPolicy" => configuredAudienceModelPolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_audience_export_job(audience_generation_job_arn, audience_size, name)
    start_audience_export_job(audience_generation_job_arn, audience_size, name, params::Dict{String,<:Any})

Export an audience of a specified size after you have generated an audience.

# Arguments
- `audience_generation_job_arn`: The Amazon Resource Name (ARN) of the audience generation
  job that you want to export.
- `audience_size`:
- `name`: The name of the audience export job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description of the audience export job.
"""
function start_audience_export_job(
    audienceGenerationJobArn,
    audienceSize,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/audience-export-job",
        Dict{String,Any}(
            "audienceGenerationJobArn" => audienceGenerationJobArn,
            "audienceSize" => audienceSize,
            "name" => name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_audience_export_job(
    audienceGenerationJobArn,
    audienceSize,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/audience-export-job",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "audienceGenerationJobArn" => audienceGenerationJobArn,
                    "audienceSize" => audienceSize,
                    "name" => name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_audience_generation_job(configured_audience_model_arn, name, seed_audience)
    start_audience_generation_job(configured_audience_model_arn, name, seed_audience, params::Dict{String,<:Any})

Information necessary to start the audience generation job.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that is used for this audience generation job.
- `name`: The name of the audience generation job.
- `seed_audience`: The seed audience that is used to generate the audience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"collaborationId"`: The identifier of the collaboration that contains the audience
  generation job.
- `"description"`: The description of the audience generation job.
- `"includeSeedInOutput"`: Whether the seed audience is included in the audience generation
  output.
- `"tags"`: The optional metadata that you apply to the resource to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.
    For each resource, each tag key must be unique, and each tag key can have only one value.
    Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256
  Unicode characters in UTF-8.   If your tagging schema is used across multiple services and
  resources, remember that other services may have restrictions on allowed characters.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do
  not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as
  it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can
  have this prefix. If a tag value has aws as its prefix but the key does not, then Clean
  Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags
  with only the key prefix of aws do not count against your tags per resource limit.
"""
function start_audience_generation_job(
    configuredAudienceModelArn,
    name,
    seedAudience;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/audience-generation-job",
        Dict{String,Any}(
            "configuredAudienceModelArn" => configuredAudienceModelArn,
            "name" => name,
            "seedAudience" => seedAudience,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_audience_generation_job(
    configuredAudienceModelArn,
    name,
    seedAudience,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/audience-generation-job",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configuredAudienceModelArn" => configuredAudienceModelArn,
                    "name" => name,
                    "seedAudience" => seedAudience,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds metadata tags to a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to assign
  tags.
- `tags`: The optional metadata that you apply to the resource to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.
    For each resource, each tag key must be unique, and each tag key can have only one value.
    Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256
  Unicode characters in UTF-8.   If your tagging schema is used across multiple services and
  resources, remember that other services may have restrictions on allowed characters.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do
  not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as
  it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can
  have this prefix. If a tag value has aws as its prefix but the key does not, then Clean
  Rooms considers it to be a user tag and will count against the limit of 50 tags. Tags with
  only the key prefix of aws do not count against your tags per resource limit.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return cleanroomsml(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes metadata tags from a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource that you want to remove
  tags from.
- `tag_keys`: The key values of tags that you want to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configured_audience_model(configured_audience_model_arn)
    update_configured_audience_model(configured_audience_model_arn, params::Dict{String,<:Any})

Provides the information necessary to update a configured audience model. Updates that
impact audience generation jobs take effect when a new job starts, but do not impact
currently running jobs.

# Arguments
- `configured_audience_model_arn`: The Amazon Resource Name (ARN) of the configured
  audience model that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"audienceModelArn"`: The Amazon Resource Name (ARN) of the new audience model that you
  want to use.
- `"audienceSizeConfig"`: The new audience size configuration.
- `"description"`: The new description of the configured audience model.
- `"minMatchingSeedSize"`: The minimum number of users from the seed audience that must
  match with users in the training data of the audience model.
- `"outputConfig"`: The new output configuration.
- `"sharedAudienceMetrics"`: The new value for whether to share audience metrics.
"""
function update_configured_audience_model(
    configuredAudienceModelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cleanroomsml(
        "PATCH",
        "/configured-audience-model/$(configuredAudienceModelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configured_audience_model(
    configuredAudienceModelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cleanroomsml(
        "PATCH",
        "/configured-audience-model/$(configuredAudienceModelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
