# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: marketplace_deployment
using AWS.Compat
using AWS.UUIDs

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all tags that have been added to a deployment parameter resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) associated with the deployment parameter
  resource you want to list tags on.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return marketplace_deployment(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_deployment(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_deployment_parameter(agreement_id, catalog, deployment_parameter, product_id)
    put_deployment_parameter(agreement_id, catalog, deployment_parameter, product_id, params::Dict{String,<:Any})

Creates or updates a deployment parameter and is targeted by catalog and agreementId.

# Arguments
- `agreement_id`: The unique identifier of the agreement.
- `catalog`: The catalog related to the request. Fixed value: AWS Marketplace
- `deployment_parameter`: The deployment parameter targeted to the acceptor of an agreement
  for which to create the AWS Secret Manager resource.
- `product_id`: The product for which AWS Marketplace will save secrets for the buyer’s
  account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token for deployment parameters. A unique identifier for
  the new version.
- `"expirationDate"`: The date when deployment parameters expire and are scheduled for
  deletion.
- `"tags"`: A map of key-value pairs, where each pair represents a tag saved to the
  resource. Tags will only be applied for create operations, and they'll be ignored if the
  resource already exists.
"""
function put_deployment_parameter(
    agreementId,
    catalog,
    deploymentParameter,
    productId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_deployment(
        "POST",
        "/catalogs/$(catalog)/products/$(productId)/deployment-parameters",
        Dict{String,Any}(
            "agreementId" => agreementId,
            "deploymentParameter" => deploymentParameter,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_deployment_parameter(
    agreementId,
    catalog,
    deploymentParameter,
    productId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_deployment(
        "POST",
        "/catalogs/$(catalog)/products/$(productId)/deployment-parameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "agreementId" => agreementId,
                    "deploymentParameter" => deploymentParameter,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn)
    tag_resource(resource_arn, params::Dict{String,<:Any})

Tags a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) associated with the resource you want to
  tag.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A map of key-value pairs, where each pair represents a tag present on the
  resource.
"""
function tag_resource(resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return marketplace_deployment(
        "POST",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_deployment(
        "POST",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag or list of tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) associated with the resource you want to
  remove the tag from.
- `tag_keys`: A list of key names of tags to be removed.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return marketplace_deployment(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_deployment(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
