# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ssm
using AWS.Compat
using AWS.UUIDs

"""
    add_tags_to_resource(resource_id, resource_type, tags)
    add_tags_to_resource(resource_id, resource_type, tags, params::Dict{String,<:Any})

Adds or overwrites one or more tags for the specified resource. Tags are metadata that you
can assign to your automations, documents, managed nodes, maintenance windows, Parameter
Store parameters, and patch baselines. Tags enable you to categorize your resources in
different ways, for example, by purpose, owner, or environment. Each tag consists of a key
and an optional value, both of which you define. For example, you could define a set of
tags for your account's managed nodes that helps you track each node's owner and stack
level. For example:    Key=Owner,Value=DbAdmin     Key=Owner,Value=SysAdmin
Key=Owner,Value=Dev     Key=Stack,Value=Production     Key=Stack,Value=Pre-Production
Key=Stack,Value=Test    Most resources can have a maximum of 50 tags. Automations can have
a maximum of 5 tags. We recommend that you devise a set of tag keys that meets your needs
for each resource type. Using a consistent set of tag keys makes it easier for you to
manage your resources. You can search and filter the resources based on the tags you add.
Tags don't have any semantic meaning to and are interpreted strictly as a string of
characters. For more information about using tags with Amazon Elastic Compute Cloud (Amazon
EC2) instances, see Tag your Amazon EC2 resources in the Amazon EC2 User Guide.

# Arguments
- `resource_id`: The resource ID you want to tag. Use the ID of the resource. Here are some
  examples:  MaintenanceWindow: mw-012345abcde   PatchBaseline: pb-012345abcde   Automation:
  example-c160-4567-8519-012345abcde   OpsMetadata object: ResourceID for tagging is created
  from the Amazon Resource Name (ARN) for the object. Specifically, ResourceID is created
  from the strings that come after the word opsmetadata in the ARN. For example, an
  OpsMetadata object with an ARN of
  arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a ResourceID of
  either aws/ssm/MyGroup/appmanager or /aws/ssm/MyGroup/appmanager. For the Document and
  Parameter values, use the name of the resource. If you're tagging a shared document, you
  must use the full ARN of the document.  ManagedInstance: mi-012345abcde   The
  ManagedInstance type for this API operation is only for on-premises managed nodes. You must
  specify the name of the managed node in the following format: mi-ID_number . For example,
  mi-1a2b3c4d5e6f.
- `resource_type`: Specifies the type of resource you are tagging.  The ManagedInstance
  type for this API operation is for on-premises managed nodes. You must specify the name of
  the managed node in the following format: mi-ID_number . For example, mi-1a2b3c4d5e6f.
- `tags`: One or more tags. The value parameter is required.  Don't enter personally
  identifiable information in this field.

"""
function add_tags_to_resource(
    ResourceId, ResourceType, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "AddTagsToResource",
        Dict{String,Any}(
            "ResourceId" => ResourceId, "ResourceType" => ResourceType, "Tags" => Tags
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceId,
    ResourceType,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ResourceType" => ResourceType,
                    "Tags" => Tags,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_ops_item_related_item(association_type, ops_item_id, resource_type, resource_uri)
    associate_ops_item_related_item(association_type, ops_item_id, resource_type, resource_uri, params::Dict{String,<:Any})

Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can
associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and
OpsCenter are capabilities of Amazon Web Services Systems Manager.

# Arguments
- `association_type`: The type of association that you want to create between an OpsItem
  and a resource. OpsCenter supports IsParentOf and RelatesTo association types.
- `ops_item_id`: The ID of the OpsItem to which you want to associate a resource as a
  related item.
- `resource_type`: The type of resource that you want to associate with an OpsItem.
  OpsCenter supports the following types:  AWS::SSMIncidents::IncidentRecord: an Incident
  Manager incident.   AWS::SSM::Document: a Systems Manager (SSM) document.
- `resource_uri`: The Amazon Resource Name (ARN) of the Amazon Web Services resource that
  you want to associate with the OpsItem.

"""
function associate_ops_item_related_item(
    AssociationType,
    OpsItemId,
    ResourceType,
    ResourceUri;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "AssociateOpsItemRelatedItem",
        Dict{String,Any}(
            "AssociationType" => AssociationType,
            "OpsItemId" => OpsItemId,
            "ResourceType" => ResourceType,
            "ResourceUri" => ResourceUri,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_ops_item_related_item(
    AssociationType,
    OpsItemId,
    ResourceType,
    ResourceUri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "AssociateOpsItemRelatedItem",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationType" => AssociationType,
                    "OpsItemId" => OpsItemId,
                    "ResourceType" => ResourceType,
                    "ResourceUri" => ResourceUri,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_command(command_id)
    cancel_command(command_id, params::Dict{String,<:Any})

Attempts to cancel the command specified by the Command ID. There is no guarantee that the
command will be terminated and the underlying process stopped.

# Arguments
- `command_id`: The ID of the command you want to cancel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceIds"`: (Optional) A list of managed node IDs on which you want to cancel the
  command. If not provided, the command is canceled on every node on which it was requested.
"""
function cancel_command(CommandId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CancelCommand",
        Dict{String,Any}("CommandId" => CommandId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_command(
    CommandId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CancelCommand",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CommandId" => CommandId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_maintenance_window_execution(window_execution_id)
    cancel_maintenance_window_execution(window_execution_id, params::Dict{String,<:Any})

Stops a maintenance window execution that is already in progress and cancels any tasks in
the window that haven't already starting running. Tasks already in progress will continue
to completion.

# Arguments
- `window_execution_id`: The ID of the maintenance window execution to stop.

"""
function cancel_maintenance_window_execution(
    WindowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CancelMaintenanceWindowExecution",
        Dict{String,Any}("WindowExecutionId" => WindowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_maintenance_window_execution(
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CancelMaintenanceWindowExecution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WindowExecutionId" => WindowExecutionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_activation(iam_role)
    create_activation(iam_role, params::Dict{String,<:Any})

Generates an activation code and activation ID you can use to register your on-premises
servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager.
Registering these machines with Systems Manager makes it possible to manage them using
Systems Manager capabilities. You use the activation code and ID when installing SSM Agent
on machines in your hybrid environment. For more information about requirements for
managing on-premises machines using Systems Manager, see Setting up Amazon Web Services
Systems Manager for hybrid and multicloud environments in the Amazon Web Services Systems
Manager User Guide.   Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices,
and on-premises servers and VMs that are configured for Systems Manager are all called
managed nodes.

# Arguments
- `iam_role`: The name of the Identity and Access Management (IAM) role that you want to
  assign to the managed node. This IAM role must provide AssumeRole permissions for the
  Amazon Web Services Systems Manager service principal ssm.amazonaws.com. For more
  information, see Create an IAM service role for a hybrid and multicloud environment in the
  Amazon Web Services Systems Manager User Guide.  You can't specify an IAM service-linked
  role for this parameter. You must create a unique role.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultInstanceName"`: The name of the registered, managed node as it will appear in
  the Amazon Web Services Systems Manager console or when you use the Amazon Web Services
  command line tools to list Systems Manager resources.  Don't enter personally identifiable
  information in this field.
- `"Description"`: A user-defined description of the resource that you want to register
  with Systems Manager.   Don't enter personally identifiable information in this field.
- `"ExpirationDate"`: The date by which this activation request should expire, in timestamp
  format, such as \"2021-07-07T00:00:00\". You can specify a date up to 30 days in advance.
  If you don't provide an expiration date, the activation code expires in 24 hours.
- `"RegistrationLimit"`: Specify the maximum number of managed nodes you want to register.
  The default value is 1.
- `"RegistrationMetadata"`: Reserved for internal use.
- `"Tags"`: Optional metadata that you assign to a resource. Tags enable you to categorize
  a resource in different ways, such as by purpose, owner, or environment. For example, you
  might want to tag an activation to identify which servers or virtual machines (VMs) in your
  on-premises environment you intend to activate. In this case, you could specify the
  following key-value pairs:    Key=OS,Value=Windows     Key=Environment,Value=Production
  When you install SSM Agent on your on-premises servers and VMs, you specify an activation
  ID and code. When you specify the activation ID and code, tags assigned to the activation
  are automatically applied to the on-premises servers or VMs.  You can't add tags to or
  delete tags from an existing activation. You can tag your on-premises servers, edge
  devices, and VMs after they connect to Systems Manager for the first time and are assigned
  a managed node ID. This means they are listed in the Amazon Web Services Systems Manager
  console with an ID that is prefixed with \"mi-\". For information about how to add tags to
  your managed nodes, see AddTagsToResource. For information about how to remove tags from
  your managed nodes, see RemoveTagsFromResource.
"""
function create_activation(IamRole; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CreateActivation",
        Dict{String,Any}("IamRole" => IamRole);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_activation(
    IamRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateActivation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IamRole" => IamRole), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_association(name)
    create_association(name, params::Dict{String,<:Any})

A State Manager association defines the state that you want to maintain on your managed
nodes. For example, an association can specify that anti-virus software must be installed
and running on your managed nodes, or that certain ports must be closed. For static
targets, the association specifies a schedule for when the configuration is reapplied. For
dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services
autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager
applies the configuration when new managed nodes are added to the group. The association
also specifies actions to take when applying the configuration. For example, an association
for anti-virus software might run once a day. If the software isn't installed, then State
Manager installs it. If the software is installed, but the service isn't running, then the
association might instruct State Manager to start the service.

# Arguments
- `name`: The name of the SSM Command document or Automation runbook that contains the
  configuration information for the managed node. You can specify Amazon Web
  Services-predefined documents, documents you created, or a document that is shared with you
  from another Amazon Web Services account. For Systems Manager documents (SSM documents)
  that are shared with you from other Amazon Web Services accounts, you must specify the
  complete SSM document ARN, in the following format:
  arn:partition:ssm:region:account-id:document/document-name   For example:
  arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document  For Amazon Web
  Services-predefined documents and SSM documents you created in your account, you only need
  to specify the document name. For example, AWS-ApplyPatchBaseline or My-Document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`:
- `"ApplyOnlyAtCronInterval"`: By default, when you create a new association, the system
  runs it immediately after it is created and then according to the schedule you specified.
  Specify this option if you don't want an association to run immediately after you create
  it. This parameter isn't supported for rate expressions.
- `"AssociationName"`: Specify a descriptive name for the association.
- `"AutomationTargetParameterName"`: Choose the parameter that will define how your
  automation will branch out. This target is required for associations that use an Automation
  runbook and target resources by using rate controls. Automation is a capability of Amazon
  Web Services Systems Manager.
- `"CalendarNames"`: The names or Amazon Resource Names (ARNs) of the Change Calendar type
  documents you want to gate your associations under. The associations only run when that
  change calendar is open. For more information, see Amazon Web Services Systems Manager
  Change Calendar.
- `"ComplianceSeverity"`: The severity level to assign to the association.
- `"DocumentVersion"`: The document version you want to associate with the targets. Can be
  a specific version or the default version.  State Manager doesn't support running
  associations that use a new version of a document if that document is shared from another
  account. State Manager always runs the default version of a document if shared from another
  account, even though the Systems Manager console shows that a new version was processed. If
  you want to run an association using a new version of a document shared form another
  account, you must set the document version to default.
- `"Duration"`: The number of hours the association can run before it is canceled. Duration
  applies to associations that are currently running, and any pending and in progress
  commands on all targets. If a target was taken offline for the association to run, it is
  made available again immediately, without a reboot.  The Duration parameter applies only
  when both these conditions are true:   The association for which you specify a duration is
  cancelable according to the parameters of the SSM command document or Automation runbook
  associated with this execution.    The command specifies the  ApplyOnlyAtCronInterval
  parameter, which means that the association doesn't run immediately after it is created,
  but only according to the specified schedule.
- `"InstanceId"`: The managed node ID.   InstanceId has been deprecated. To specify a
  managed node ID for an association, use the Targets parameter. Requests that include the
  parameter InstanceID with Systems Manager documents (SSM documents) that use schema version
  2.0 or later will fail. In addition, if you use the parameter InstanceId, you can't use the
  parameters AssociationName, DocumentVersion, MaxErrors, MaxConcurrency, OutputLocation, or
  ScheduleExpression. To use these parameters, you must use the Targets parameter.
- `"MaxConcurrency"`: The maximum number of targets allowed to run the association at the
  same time. You can specify a number, for example 10, or a percentage of the target set, for
  example 10%. The default value is 100%, which means all targets run the association at the
  same time. If a new managed node starts and attempts to run an association while Systems
  Manager is running MaxConcurrency associations, the association is allowed to run. During
  the next association interval, the new managed node will process its association within the
  limit specified for MaxConcurrency.
- `"MaxErrors"`: The number of errors that are allowed before the system stops sending
  requests to run the association on additional targets. You can specify either an absolute
  number of errors, for example 10, or a percentage of the target set, for example 10%. If
  you specify 3, for example, the system stops sending requests when the fourth error is
  received. If you specify 0, then the system stops sending requests after the first error is
  returned. If you run an association on 50 managed nodes and set MaxError to 10%, then the
  system stops sending the request when the sixth error is received. Executions that are
  already running an association when MaxErrors is reached are allowed to complete, but some
  of these executions may fail as well. If you need to ensure that there won't be more than
  max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a
  time.
- `"OutputLocation"`: An Amazon Simple Storage Service (Amazon S3) bucket where you want to
  store the output details of the request.
- `"Parameters"`: The parameters for the runtime configuration of the document.
- `"ScheduleExpression"`: A cron expression when the association will be applied to the
  targets.
- `"ScheduleOffset"`: Number of days to wait after the scheduled day to run an association.
  For example, if you specified a cron schedule of cron(0 0 ? * THU#2 *), you could specify
  an offset of 3 to run the association each Sunday after the second Thursday of the month.
  For more information about cron schedules for associations, see Reference: Cron and rate
  expressions for Systems Manager in the Amazon Web Services Systems Manager User Guide.   To
  use offsets, you must specify the ApplyOnlyAtCronInterval parameter. This option tells the
  system not to run an association immediately after you create it.
- `"SyncCompliance"`: The mode for generating association compliance. You can specify AUTO
  or MANUAL. In AUTO mode, the system uses the status of the association execution to
  determine the compliance status. If the association execution runs successfully, then the
  association is COMPLIANT. If the association execution doesn't run successfully, the
  association is NON-COMPLIANT. In MANUAL mode, you must specify the AssociationId as a
  parameter for the PutComplianceItems API operation. In this case, compliance data isn't
  managed by State Manager. It is managed by your direct call to the PutComplianceItems API
  operation. By default, all associations use AUTO mode.
- `"Tags"`: Adds or overwrites one or more tags for a State Manager association. Tags are
  metadata that you can assign to your Amazon Web Services resources. Tags enable you to
  categorize your resources in different ways, for example, by purpose, owner, or
  environment. Each tag consists of a key and an optional value, both of which you define.
- `"TargetLocations"`: A location is a combination of Amazon Web Services Regions and
  Amazon Web Services accounts where you want to run the association. Use this action to
  create an association in multiple Regions and multiple accounts.
- `"TargetMaps"`: A key-value mapping of document parameters to target resources. Both
  Targets and TargetMaps can't be specified together.
- `"Targets"`: The targets for the association. You can target managed nodes by using tags,
  Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account,
  or individual managed node IDs. You can target all managed nodes in an Amazon Web Services
  account by specifying the InstanceIds key with a value of *. For more information about
  choosing targets for an association, see About targets and rate controls in State Manager
  associations in the Amazon Web Services Systems Manager User Guide.
"""
function create_association(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CreateAssociation",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_association(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CreateAssociation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_association_batch(entries)
    create_association_batch(entries, params::Dict{String,<:Any})

Associates the specified Amazon Web Services Systems Manager document (SSM document) with
the specified managed nodes or targets. When you associate a document with one or more
managed nodes using IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent)
running on the managed node processes the document and configures the node as specified. If
you associate a document with a managed node that already has an associated document, the
system returns the AssociationAlreadyExists exception.

# Arguments
- `entries`: One or more associations.

"""
function create_association_batch(
    Entries; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CreateAssociationBatch",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_association_batch(
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateAssociationBatch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_document(content, name)
    create_document(content, name, params::Dict{String,<:Any})

Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the
actions that Systems Manager performs on your managed nodes. For more information about SSM
documents, including information about supported schemas, features, and syntax, see Amazon
Web Services Systems Manager Documents in the Amazon Web Services Systems Manager User
Guide.

# Arguments
- `content`: The content for the new SSM document in JSON or YAML format. The content of
  the document must not exceed 64KB. This quota also includes the content specified for input
  parameters at runtime. We recommend storing the contents for your new document in an
  external JSON or YAML file and referencing the file in a command. For examples, see the
  following topics in the Amazon Web Services Systems Manager User Guide.    Create an SSM
  document (console)     Create an SSM document (command line)     Create an SSM document
  (API)
- `name`: A name for the SSM document.  You can't use the following strings as document
  name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:
     aws     amazon     amzn     AWSEC2     AWSConfigRemediation     AWSSupport

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attachments"`: A list of key-value pairs that describe attachments to a version of a
  document.
- `"DisplayName"`: An optional field where you can specify a friendly name for the SSM
  document. This value can differ for each version of the document. You can update this value
  at a later time using the UpdateDocument operation.
- `"DocumentFormat"`: Specify the document format for the request. The document format can
  be JSON, YAML, or TEXT. JSON is the default format.
- `"DocumentType"`: The type of document to create.  The DeploymentStrategy document type
  is an internal-use-only document type reserved for AppConfig.
- `"Requires"`: A list of SSM documents required by a document. This parameter is used
  exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM
  document, the user must also specify a required document for validation purposes. In this
  case, an ApplicationConfiguration document requires an ApplicationConfigurationSchema
  document for validation purposes. For more information, see What is AppConfig? in the
  AppConfig User Guide.
- `"Tags"`: Optional metadata that you assign to a resource. Tags enable you to categorize
  a resource in different ways, such as by purpose, owner, or environment. For example, you
  might want to tag an SSM document to identify the types of targets or the environment where
  it will run. In this case, you could specify the following key-value pairs:
  Key=OS,Value=Windows     Key=Environment,Value=Production     To add tags to an existing
  SSM document, use the AddTagsToResource operation.
- `"TargetType"`: Specify a target type to define the kinds of resources the document can
  run on. For example, to run a document on EC2 instances, specify the following value:
  /AWS::EC2::Instance. If you specify a value of '/' the document can run on all types of
  resources. If you don't specify a value, the document can't run on any resources. For a
  list of valid resource types, see Amazon Web Services resource and property types reference
  in the CloudFormation User Guide.
- `"VersionName"`: An optional field specifying the version of the artifact you are
  creating with the document. For example, Release12.1. This value is unique across all
  versions of a document, and can't be changed.
"""
function create_document(Content, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CreateDocument",
        Dict{String,Any}("Content" => Content, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_document(
    Content,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateDocument",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Content" => Content, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_maintenance_window(allow_unassociated_targets, cutoff, duration, name, schedule)
    create_maintenance_window(allow_unassociated_targets, cutoff, duration, name, schedule, params::Dict{String,<:Any})

Creates a new maintenance window.  The value you specify for Duration determines the
specific end time for the maintenance window based on the time it begins. No maintenance
window tasks are permitted to start after the resulting endtime minus the number of hours
you specify for Cutoff. For example, if the maintenance window starts at 3 PM, the duration
is three hours, and the value you specify for Cutoff is one hour, no maintenance window
tasks can start after 5 PM.

# Arguments
- `allow_unassociated_targets`: Enables a maintenance window task to run on managed nodes,
  even if you haven't registered those nodes as targets. If enabled, then you must specify
  the unregistered managed nodes (by node ID) when you register a task with the maintenance
  window. If you don't enable this option, then you must specify previously-registered
  targets when you register a task with the maintenance window.
- `cutoff`: The number of hours before the end of the maintenance window that Amazon Web
  Services Systems Manager stops scheduling new tasks for execution.
- `duration`: The duration of the maintenance window in hours.
- `name`: The name of the maintenance window.
- `schedule`: The schedule of the maintenance window in the form of a cron or rate
  expression.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: User-provided idempotency token.
- `"Description"`: An optional description for the maintenance window. We recommend
  specifying a description to help you organize your maintenance windows.
- `"EndDate"`: The date and time, in ISO-8601 Extended format, for when you want the
  maintenance window to become inactive. EndDate allows you to set a date and time in the
  future when the maintenance window will no longer run.
- `"ScheduleOffset"`: The number of days to wait after the date and time specified by a
  cron expression before running the maintenance window. For example, the following cron
  expression schedules a maintenance window to run on the third Tuesday of every month at
  11:30 PM.  cron(30 23 ? * TUE#3 *)  If the schedule offset is 2, the maintenance window
  won't run until two days later.
- `"ScheduleTimezone"`: The time zone that the scheduled maintenance window executions are
  based on, in Internet Assigned Numbers Authority (IANA) format. For example:
  \"America/Los_Angeles\", \"UTC\", or \"Asia/Seoul\". For more information, see the Time
  Zone Database on the IANA website.
- `"StartDate"`: The date and time, in ISO-8601 Extended format, for when you want the
  maintenance window to become active. StartDate allows you to delay activation of the
  maintenance window until the specified future date.  When using a rate schedule, if you
  provide a start date that occurs in the past, the current date and time are used as the
  start date.
- `"Tags"`: Optional metadata that you assign to a resource. Tags enable you to categorize
  a resource in different ways, such as by purpose, owner, or environment. For example, you
  might want to tag a maintenance window to identify the type of tasks it will run, the types
  of targets, and the environment it will run in. In this case, you could specify the
  following key-value pairs:    Key=TaskType,Value=AgentUpdate     Key=OS,Value=Windows
  Key=Environment,Value=Production     To add tags to an existing maintenance window, use the
  AddTagsToResource operation.
"""
function create_maintenance_window(
    AllowUnassociatedTargets,
    Cutoff,
    Duration,
    Name,
    Schedule;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateMaintenanceWindow",
        Dict{String,Any}(
            "AllowUnassociatedTargets" => AllowUnassociatedTargets,
            "Cutoff" => Cutoff,
            "Duration" => Duration,
            "Name" => Name,
            "Schedule" => Schedule,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_maintenance_window(
    AllowUnassociatedTargets,
    Cutoff,
    Duration,
    Name,
    Schedule,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateMaintenanceWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AllowUnassociatedTargets" => AllowUnassociatedTargets,
                    "Cutoff" => Cutoff,
                    "Duration" => Duration,
                    "Name" => Name,
                    "Schedule" => Schedule,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ops_item(description, source, title)
    create_ops_item(description, source, title, params::Dict{String,<:Any})

Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to
create a new OpsItem. For more information, see Set up OpsCenter in the Amazon Web Services
Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web
Services Systems Manager OpsCenter to view, investigate, and remediate operational issues
impacting the performance and health of their Amazon Web Services resources. For more
information, see Amazon Web Services Systems Manager OpsCenter in the Amazon Web Services
Systems Manager User Guide.

# Arguments
- `description`: User-defined text that contains information about the OpsItem, in Markdown
  format.   Provide enough information so that users viewing this OpsItem for the first time
  understand the issue.
- `source`: The origin of the OpsItem, such as Amazon EC2 or Systems Manager.  The source
  name can't contain the following strings: aws, amazon, and amzn.
- `title`: A short heading that describes the nature of the OpsItem and the impacted
  resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: The target Amazon Web Services account where you want to create an
  OpsItem. To make this call, your account must be configured to work with OpsItems across
  accounts. For more information, see Set up OpsCenter in the Amazon Web Services Systems
  Manager User Guide.
- `"ActualEndTime"`: The time a runbook workflow ended. Currently reported only for the
  OpsItem type /aws/changerequest.
- `"ActualStartTime"`: The time a runbook workflow started. Currently reported only for the
  OpsItem type /aws/changerequest.
- `"Category"`: Specify a category to assign to an OpsItem.
- `"Notifications"`: The Amazon Resource Name (ARN) of an SNS topic where notifications are
  sent when this OpsItem is edited or changed.
- `"OperationalData"`: Operational data is custom data that provides useful reference
  details about the OpsItem. For example, you can specify log files, error strings, license
  keys, troubleshooting tips, or other relevant data. You enter operational data as key-value
  pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20
  KB.  Operational data keys can't begin with the following: amazon, aws, amzn, ssm, /amazon,
  /aws, /amzn, /ssm.  You can choose to make the data searchable by other users in the
  account or you can restrict search access. Searchable data means that all users with access
  to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view
  and search on the specified data. Operational data that isn't searchable is only viewable
  by users who have access to the OpsItem (as provided by the GetOpsItem API operation). Use
  the /aws/resources key in OperationalData to specify a related resource in the request. Use
  the /aws/automations key in OperationalData to associate an Automation runbook with the
  OpsItem. To view Amazon Web Services CLI example commands that use these keys, see Create
  OpsItems manually in the Amazon Web Services Systems Manager User Guide.
- `"OpsItemType"`: The type of OpsItem to create. Systems Manager supports the following
  types of OpsItems:    /aws/issue  This type of OpsItem is used for default OpsItems created
  by OpsCenter.     /aws/changerequest  This type of OpsItem is used by Change Manager for
  reviewing and approving or rejecting change requests.     /aws/insight  This type of
  OpsItem is used by OpsCenter for aggregating and reporting on duplicate OpsItems.
- `"PlannedEndTime"`: The time specified in a change request for a runbook workflow to end.
  Currently supported only for the OpsItem type /aws/changerequest.
- `"PlannedStartTime"`: The time specified in a change request for a runbook workflow to
  start. Currently supported only for the OpsItem type /aws/changerequest.
- `"Priority"`: The importance of this OpsItem in relation to other OpsItems in the system.
- `"RelatedOpsItems"`: One or more OpsItems that share something in common with the current
  OpsItems. For example, related OpsItems can include OpsItems with similar error messages,
  impacted resources, or statuses for the impacted resource.
- `"Severity"`: Specify a severity to assign to an OpsItem.
- `"Tags"`: Optional metadata that you assign to a resource. Tags use a key-value pair. For
  example:  Key=Department,Value=Finance   To add tags to a new OpsItem, a user must have IAM
  permissions for both the ssm:CreateOpsItems operation and the ssm:AddTagsToResource
  operation. To add tags to an existing OpsItem, use the AddTagsToResource operation.
"""
function create_ops_item(
    Description, Source, Title; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CreateOpsItem",
        Dict{String,Any}(
            "Description" => Description, "Source" => Source, "Title" => Title
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ops_item(
    Description,
    Source,
    Title,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateOpsItem",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description, "Source" => Source, "Title" => Title
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ops_metadata(resource_id)
    create_ops_metadata(resource_id, params::Dict{String,<:Any})

If you create a new application in Application Manager, Amazon Web Services Systems Manager
calls this API operation to specify information about the new application, including the
application type.

# Arguments
- `resource_id`: A resource ID for a new Application Manager application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: Metadata for a new Application Manager application.
- `"Tags"`: Optional metadata that you assign to a resource. You can specify a maximum of
  five tags for an OpsMetadata object. Tags enable you to categorize a resource in different
  ways, such as by purpose, owner, or environment. For example, you might want to tag an
  OpsMetadata object to identify an environment or target Amazon Web Services Region. In this
  case, you could specify the following key-value pairs:    Key=Environment,Value=Production
     Key=Region,Value=us-east-2
"""
function create_ops_metadata(ResourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CreateOpsMetadata",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ops_metadata(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateOpsMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_patch_baseline(name)
    create_patch_baseline(name, params::Dict{String,<:Any})

Creates a patch baseline.  For information about valid key-value pairs in PatchFilters for
each supported operating system type, see PatchFilter.

# Arguments
- `name`: The name of the patch baseline.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApprovalRules"`: A set of rules used to include patches in the baseline.
- `"ApprovedPatches"`: A list of explicitly approved patches for the baseline. For
  information about accepted formats for lists of approved patches and rejected patches, see
  About package name formats for approved and rejected patch lists in the Amazon Web Services
  Systems Manager User Guide.
- `"ApprovedPatchesComplianceLevel"`: Defines the compliance level for approved patches.
  When an approved patch is reported as missing, this value describes the severity of the
  compliance violation. The default value is UNSPECIFIED.
- `"ApprovedPatchesEnableNonSecurity"`: Indicates whether the list of approved patches
  includes non-security updates that should be applied to the managed nodes. The default
  value is false. Applies to Linux managed nodes only.
- `"ClientToken"`: User-provided idempotency token.
- `"Description"`: A description of the patch baseline.
- `"GlobalFilters"`: A set of global filters used to include patches in the baseline.
- `"OperatingSystem"`: Defines the operating system the patch baseline applies to. The
  default value is WINDOWS.
- `"RejectedPatches"`: A list of explicitly rejected patches for the baseline. For
  information about accepted formats for lists of approved patches and rejected patches, see
  About package name formats for approved and rejected patch lists in the Amazon Web Services
  Systems Manager User Guide.
- `"RejectedPatchesAction"`: The action for Patch Manager to take on patches included in
  the RejectedPackages list.     ALLOW_AS_DEPENDENCY : A package in the Rejected patches list
  is installed only if it is a dependency of another package. It is considered compliant with
  the patch baseline, and its status is reported as InstalledOther. This is the default
  action if no option is specified.    BLOCK: Packages in the Rejected patches list, and
  packages that include them as dependencies, aren't installed by Patch Manager under any
  circumstances. If a package was installed before it was added to the Rejected patches list,
  or is installed outside of Patch Manager afterward, it's considered noncompliant with the
  patch baseline and its status is reported as InstalledRejected.
- `"Sources"`: Information about the patches to use to update the managed nodes, including
  target operating systems and source repositories. Applies to Linux managed nodes only.
- `"Tags"`: Optional metadata that you assign to a resource. Tags enable you to categorize
  a resource in different ways, such as by purpose, owner, or environment. For example, you
  might want to tag a patch baseline to identify the severity level of patches it specifies
  and the operating system family it applies to. In this case, you could specify the
  following key-value pairs:    Key=PatchSeverity,Value=Critical     Key=OS,Value=Windows
  To add tags to an existing patch baseline, use the AddTagsToResource operation.
"""
function create_patch_baseline(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "CreatePatchBaseline",
        Dict{String,Any}("Name" => Name, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_patch_baseline(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CreatePatchBaseline",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resource_data_sync(sync_name)
    create_resource_data_sync(sync_name, params::Dict{String,<:Any})

A resource data sync helps you view data from multiple sources in a single location. Amazon
Web Services Systems Manager offers two types of resource data sync: SyncToDestination and
SyncFromSource. You can configure Systems Manager Inventory to use the SyncToDestination
type to synchronize Inventory data from multiple Amazon Web Services Regions to a single
Amazon Simple Storage Service (Amazon S3) bucket. For more information, see Configuring
resource data sync for Inventory in the Amazon Web Services Systems Manager User Guide. You
can configure Systems Manager Explorer to use the SyncFromSource type to synchronize
operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web
Services Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and
OpsData from multiple Amazon Web Services accounts and Amazon Web Services Regions or
EntireOrganization by using Organizations. For more information, see Setting up Systems
Manager Explorer to display data from multiple accounts and Regions in the Amazon Web
Services Systems Manager User Guide. A resource data sync is an asynchronous operation that
returns immediately. After a successful initial sync is completed, the system continuously
syncs data. To check the status of a sync, use the ListResourceDataSync.  By default, data
isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3
to ensure secure data storage. We also recommend that you secure access to the Amazon S3
bucket by creating a restrictive bucket policy.

# Arguments
- `sync_name`: A name for the configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"S3Destination"`: Amazon S3 configuration details for the sync. This parameter is
  required if the SyncType value is SyncToDestination.
- `"SyncSource"`: Specify information about the data sources to synchronize. This parameter
  is required if the SyncType value is SyncFromSource.
- `"SyncType"`: Specify SyncToDestination to create a resource data sync that synchronizes
  data to an S3 bucket for Inventory. If you specify SyncToDestination, you must provide a
  value for S3Destination. Specify SyncFromSource to synchronize data from a single account
  and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services
  Regions, as listed in Organizations for Explorer. If you specify SyncFromSource, you must
  provide a value for SyncSource. The default value is SyncToDestination.
"""
function create_resource_data_sync(
    SyncName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "CreateResourceDataSync",
        Dict{String,Any}("SyncName" => SyncName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resource_data_sync(
    SyncName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "CreateResourceDataSync",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SyncName" => SyncName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_activation(activation_id)
    delete_activation(activation_id, params::Dict{String,<:Any})

Deletes an activation. You aren't required to delete an activation. If you delete an
activation, you can no longer use it to register additional managed nodes. Deleting an
activation doesn't de-register managed nodes. You must manually de-register managed nodes.

# Arguments
- `activation_id`: The ID of the activation that you want to delete.

"""
function delete_activation(ActivationId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteActivation",
        Dict{String,Any}("ActivationId" => ActivationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_activation(
    ActivationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteActivation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ActivationId" => ActivationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_association()
    delete_association(params::Dict{String,<:Any})

Disassociates the specified Amazon Web Services Systems Manager document (SSM document)
from the specified managed node. If you created the association by using the Targets
parameter, then you must delete the association by using the association ID. When you
disassociate a document from a managed node, it doesn't change the configuration of the
node. To change the configuration state of a managed node after you disassociate a
document, you must create a new document with the desired configuration and associate it
with the node.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationId"`: The association ID that you want to delete.
- `"InstanceId"`: The managed node ID.   InstanceId has been deprecated. To specify a
  managed node ID for an association, use the Targets parameter. Requests that include the
  parameter InstanceID with Systems Manager documents (SSM documents) that use schema version
  2.0 or later will fail. In addition, if you use the parameter InstanceId, you can't use the
  parameters AssociationName, DocumentVersion, MaxErrors, MaxConcurrency, OutputLocation, or
  ScheduleExpression. To use these parameters, you must use the Targets parameter.
- `"Name"`: The name of the SSM document.
"""
function delete_association(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("DeleteAssociation"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function delete_association(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteAssociation", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    delete_document(name)
    delete_document(name, params::Dict{String,<:Any})

Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed
node associations to the document. Before you delete the document, we recommend that you
use DeleteAssociation to disassociate all managed nodes that are associated with the
document.

# Arguments
- `name`: The name of the document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentVersion"`: The version of the document that you want to delete. If not
  provided, all versions of the document are deleted.
- `"Force"`: Some SSM document types require that you specify a Force flag before you can
  delete the document. For example, you must specify a Force flag to delete a document of
  type ApplicationConfigurationSchema. You can restrict access to the Force flag in an
  Identity and Access Management (IAM) policy.
- `"VersionName"`: The version name of the document that you want to delete. If not
  provided, all versions of the document are deleted.
"""
function delete_document(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteDocument",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_document(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteDocument",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_inventory(type_name)
    delete_inventory(type_name, params::Dict{String,<:Any})

Delete a custom inventory type or the data associated with a custom Inventory type.
Deleting a custom inventory type is also referred to as deleting a custom inventory schema.

# Arguments
- `type_name`: The name of the custom inventory type for which you want to delete either
  all previously collected data or the inventory type itself.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: User-provided idempotency token.
- `"DryRun"`: Use this option to view a summary of the deletion request without deleting
  any data or the data type. This option is useful when you only want to understand what will
  be deleted. Once you validate that the data to be deleted is what you intend to delete, you
  can run the same command without specifying the DryRun option.
- `"SchemaDeleteOption"`: Use the SchemaDeleteOption to delete a custom inventory type
  (schema). If you don't choose this option, the system only deletes existing inventory data
  associated with the custom inventory type. Choose one of the following options:
  DisableSchema: If you choose this option, the system ignores all inventory data for the
  specified version, and any earlier versions. To enable this schema again, you must call the
  PutInventory operation for a version greater than the disabled version. DeleteSchema: This
  option deletes the specified custom type from the Inventory service. You can recreate the
  schema later, if you want.
"""
function delete_inventory(TypeName; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteInventory",
        Dict{String,Any}("TypeName" => TypeName, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_inventory(
    TypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteInventory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TypeName" => TypeName, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_maintenance_window(window_id)
    delete_maintenance_window(window_id, params::Dict{String,<:Any})

Deletes a maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window to delete.

"""
function delete_maintenance_window(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteMaintenanceWindow",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_maintenance_window(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteMaintenanceWindow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ops_item(ops_item_id)
    delete_ops_item(ops_item_id, params::Dict{String,<:Any})

Delete an OpsItem. You must have permission in Identity and Access Management (IAM) to
delete an OpsItem.   Note the following important information about this operation.
Deleting an OpsItem is irreversible. You can't restore a deleted OpsItem.   This operation
uses an eventual consistency model, which means the system can take a few minutes to
complete this operation. If you delete an OpsItem and immediately call, for example,
GetOpsItem, the deleted OpsItem might still appear in the response.    This operation is
idempotent. The system doesn't throw an exception if you repeatedly call this operation for
the same OpsItem. If the first call is successful, all additional calls return the same
successful response as the first call.   This operation doesn't support cross-account
calls. A delegated administrator or management account can't delete OpsItems in other
accounts, even if OpsCenter has been set up for cross-account administration. For more
information about cross-account administration, see Setting up OpsCenter to centrally
manage OpsItems across accounts in the Systems Manager User Guide.

# Arguments
- `ops_item_id`: The ID of the OpsItem that you want to delete.

"""
function delete_ops_item(OpsItemId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteOpsItem",
        Dict{String,Any}("OpsItemId" => OpsItemId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ops_item(
    OpsItemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteOpsItem",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsItemId" => OpsItemId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ops_metadata(ops_metadata_arn)
    delete_ops_metadata(ops_metadata_arn, params::Dict{String,<:Any})

Delete OpsMetadata related to an application.

# Arguments
- `ops_metadata_arn`: The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.

"""
function delete_ops_metadata(
    OpsMetadataArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteOpsMetadata",
        Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ops_metadata(
    OpsMetadataArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteOpsMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_parameter(name)
    delete_parameter(name, params::Dict{String,<:Any})

Delete a parameter from the system. After deleting a parameter, wait for at least 30
seconds to create a parameter with the same name.

# Arguments
- `name`: The name of the parameter to delete.  You can't enter the Amazon Resource Name
  (ARN) for a parameter, only the parameter name itself.

"""
function delete_parameter(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteParameter",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_parameter(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteParameter",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_parameters(names)
    delete_parameters(names, params::Dict{String,<:Any})

Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to
create a parameter with the same name.

# Arguments
- `names`: The names of the parameters to delete. After deleting a parameter, wait for at
  least 30 seconds to create a parameter with the same name.  You can't enter the Amazon
  Resource Name (ARN) for a parameter, only the parameter name itself.

"""
function delete_parameters(Names; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DeleteParameters",
        Dict{String,Any}("Names" => Names);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_parameters(
    Names, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteParameters",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Names" => Names), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_patch_baseline(baseline_id)
    delete_patch_baseline(baseline_id, params::Dict{String,<:Any})

Deletes a patch baseline.

# Arguments
- `baseline_id`: The ID of the patch baseline to delete.

"""
function delete_patch_baseline(
    BaselineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeletePatchBaseline",
        Dict{String,Any}("BaselineId" => BaselineId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_patch_baseline(
    BaselineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeletePatchBaseline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BaselineId" => BaselineId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_data_sync(sync_name)
    delete_resource_data_sync(sync_name, params::Dict{String,<:Any})

Deletes a resource data sync configuration. After the configuration is deleted, changes to
data on managed nodes are no longer synced to or from the target. Deleting a sync
configuration doesn't delete data.

# Arguments
- `sync_name`: The name of the configuration to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SyncType"`: Specify the type of resource data sync to delete.
"""
function delete_resource_data_sync(
    SyncName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteResourceDataSync",
        Dict{String,Any}("SyncName" => SyncName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_data_sync(
    SyncName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteResourceDataSync",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SyncName" => SyncName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(policy_hash, policy_id, resource_arn)
    delete_resource_policy(policy_hash, policy_id, resource_arn, params::Dict{String,<:Any})

Deletes a Systems Manager resource policy. A resource policy helps you to define the IAM
entity (for example, an Amazon Web Services account) that can manage your Systems Manager
resources. The following resources support Systems Manager resource policies.
OpsItemGroup - The resource policy for OpsItemGroup enables Amazon Web Services accounts to
view and interact with OpsCenter operational work items (OpsItems).    Parameter - The
resource policy is used to share a parameter with other accounts using Resource Access
Manager (RAM). For more information about cross-account sharing of parameters, see Working
with shared parameters in the Amazon Web Services Systems Manager User Guide.

# Arguments
- `policy_hash`: ID of the current policy version. The hash helps to prevent multiple calls
  from attempting to overwrite a policy.
- `policy_id`: The policy ID.
- `resource_arn`: Amazon Resource Name (ARN) of the resource to which the policies are
  attached.

"""
function delete_resource_policy(
    PolicyHash, PolicyId, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            "PolicyHash" => PolicyHash, "PolicyId" => PolicyId, "ResourceArn" => ResourceArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    PolicyHash,
    PolicyId,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyHash" => PolicyHash,
                    "PolicyId" => PolicyId,
                    "ResourceArn" => ResourceArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_managed_instance(instance_id)
    deregister_managed_instance(instance_id, params::Dict{String,<:Any})

Removes the server or virtual machine from the list of registered servers. You can
reregister the node again at any time. If you don't plan to use Run Command on the server,
we suggest uninstalling SSM Agent first.

# Arguments
- `instance_id`: The ID assigned to the managed node when you registered it using the
  activation process.

"""
function deregister_managed_instance(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeregisterManagedInstance",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_managed_instance(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeregisterManagedInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_patch_baseline_for_patch_group(baseline_id, patch_group)
    deregister_patch_baseline_for_patch_group(baseline_id, patch_group, params::Dict{String,<:Any})

Removes a patch group from a patch baseline.

# Arguments
- `baseline_id`: The ID of the patch baseline to deregister the patch group from.
- `patch_group`: The name of the patch group that should be deregistered from the patch
  baseline.

"""
function deregister_patch_baseline_for_patch_group(
    BaselineId, PatchGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeregisterPatchBaselineForPatchGroup",
        Dict{String,Any}("BaselineId" => BaselineId, "PatchGroup" => PatchGroup);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_patch_baseline_for_patch_group(
    BaselineId,
    PatchGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeregisterPatchBaselineForPatchGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("BaselineId" => BaselineId, "PatchGroup" => PatchGroup),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_target_from_maintenance_window(window_id, window_target_id)
    deregister_target_from_maintenance_window(window_id, window_target_id, params::Dict{String,<:Any})

Removes a target from a maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window the target should be removed from.
- `window_target_id`: The ID of the target definition to remove.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Safe"`: The system checks if the target is being referenced by a task. If the target is
  being referenced, the system returns an error and doesn't deregister the target from the
  maintenance window.
"""
function deregister_target_from_maintenance_window(
    WindowId, WindowTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeregisterTargetFromMaintenanceWindow",
        Dict{String,Any}("WindowId" => WindowId, "WindowTargetId" => WindowTargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_target_from_maintenance_window(
    WindowId,
    WindowTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeregisterTargetFromMaintenanceWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "WindowId" => WindowId, "WindowTargetId" => WindowTargetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_task_from_maintenance_window(window_id, window_task_id)
    deregister_task_from_maintenance_window(window_id, window_task_id, params::Dict{String,<:Any})

Removes a task from a maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window the task should be removed from.
- `window_task_id`: The ID of the task to remove from the maintenance window.

"""
function deregister_task_from_maintenance_window(
    WindowId, WindowTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DeregisterTaskFromMaintenanceWindow",
        Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_task_from_maintenance_window(
    WindowId,
    WindowTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DeregisterTaskFromMaintenanceWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_activations()
    describe_activations(params::Dict{String,<:Any})

Describes details about the activation, such as the date and time the activation was
created, its expiration date, the Identity and Access Management (IAM) role assigned to the
managed nodes in the activation, and the number of nodes registered by using this
activation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A filter to view information about your activations.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function describe_activations(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeActivations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_activations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeActivations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_association()
    describe_association(params::Dict{String,<:Any})

Describes the association for the specified target or managed node. If you created the
association by using the Targets parameter, then you must retrieve the association by using
the association ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationId"`: The association ID for which you want information.
- `"AssociationVersion"`: Specify the association version to retrieve. To view the latest
  version, either specify LATEST for this parameter, or omit this parameter. To view a list
  of all associations for a managed node, use ListAssociations. To get a list of versions for
  a specific association, use ListAssociationVersions.
- `"InstanceId"`: The managed node ID.
- `"Name"`: The name of the SSM document.
"""
function describe_association(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeAssociation"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_association(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAssociation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_association_execution_targets(association_id, execution_id)
    describe_association_execution_targets(association_id, execution_id, params::Dict{String,<:Any})

Views information about a specific execution of a specific association.

# Arguments
- `association_id`: The association ID that includes the execution for which you want to
  view details.
- `execution_id`: The execution ID for which you want to view details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters for the request. You can specify the following filters and values.
  Status (EQUAL) ResourceId (EQUAL) ResourceType (EQUAL)
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function describe_association_execution_targets(
    AssociationId, ExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAssociationExecutionTargets",
        Dict{String,Any}("AssociationId" => AssociationId, "ExecutionId" => ExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_association_execution_targets(
    AssociationId,
    ExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeAssociationExecutionTargets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationId" => AssociationId, "ExecutionId" => ExecutionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_association_executions(association_id)
    describe_association_executions(association_id, params::Dict{String,<:Any})

Views all executions for a specific association ID.

# Arguments
- `association_id`: The association ID for which you want to view execution history details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters for the request. You can specify the following filters and values.
  ExecutionId (EQUAL) Status (EQUAL) CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function describe_association_executions(
    AssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAssociationExecutions",
        Dict{String,Any}("AssociationId" => AssociationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_association_executions(
    AssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeAssociationExecutions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AssociationId" => AssociationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_automation_executions()
    describe_automation_executions(params::Dict{String,<:Any})

Provides details about all active and terminated Automation executions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters used to limit the scope of executions that are requested.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_automation_executions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAutomationExecutions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_automation_executions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAutomationExecutions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_automation_step_executions(automation_execution_id)
    describe_automation_step_executions(automation_execution_id, params::Dict{String,<:Any})

Information about all active and terminated step executions in an Automation workflow.

# Arguments
- `automation_execution_id`: The Automation execution ID for which you want step execution
  descriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters to limit the number of step executions returned by the
  request.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"ReverseOrder"`: Indicates whether to list step executions in reverse order by start
  time. The default value is 'false'.
"""
function describe_automation_step_executions(
    AutomationExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAutomationStepExecutions",
        Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_automation_step_executions(
    AutomationExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeAutomationStepExecutions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_available_patches()
    describe_available_patches(params::Dict{String,<:Any})

Lists all patches eligible to be included in a patch baseline.  Currently,
DescribeAvailablePatches supports only the Amazon Linux 1, Amazon Linux 2, and Windows
Server operating systems.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each element in the array is a structure containing a key-value pair.
  Windows Server  Supported keys for Windows Server managed node patches include the
  following:     PATCH_SET   Sample values: OS | APPLICATION      PRODUCT   Sample values:
  WindowsServer2012 | Office 2010 | MicrosoftDefenderAntivirus      PRODUCT_FAMILY   Sample
  values: Windows | Office      MSRC_SEVERITY   Sample values: ServicePacks | Important |
  Moderate      CLASSIFICATION   Sample values: ServicePacks | SecurityUpdates |
  DefinitionUpdates      PATCH_ID   Sample values: KB123456 | KB4516046     Linux   When
  specifying filters for Linux patches, you must specify a key-pair for PRODUCT. For example,
  using the Command Line Interface (CLI), the following command fails:  aws ssm
  describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615  However, the
  following command succeeds:  aws ssm describe-available-patches --filters
  Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615   Supported keys for
  Linux managed node patches include the following:     PRODUCT   Sample values:
  AmazonLinux2018.03 | AmazonLinux2.0      NAME   Sample values: kernel-headers |
  samba-python | php      SEVERITY   Sample values: Critical | Important | Medium | Low
  EPOCH   Sample values: 0 | 1      VERSION   Sample values: 78.6.1 | 4.10.16      RELEASE
  Sample values: 9.56.amzn1 | 1.amzn2      ARCH   Sample values: i686 | x86_64
  REPOSITORY   Sample values: Core | Updates      ADVISORY_ID   Sample values: ALAS-2018-1058
  | ALAS2-2021-1594      CVE_ID   Sample values: CVE-2018-3615 | CVE-2020-1472
  BUGZILLA_ID   Sample values: 1463241
- `"MaxResults"`: The maximum number of patches to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_available_patches(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeAvailablePatches"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_available_patches(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeAvailablePatches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_document(name)
    describe_document(name, params::Dict{String,<:Any})

Describes the specified Amazon Web Services Systems Manager document (SSM document).

# Arguments
- `name`: The name of the SSM document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentVersion"`: The document version for which you want information. Can be a
  specific version or the default version.
- `"VersionName"`: An optional field specifying the version of the artifact associated with
  the document. For example, 12.6. This value is unique across all versions of a document,
  and can't be changed.
"""
function describe_document(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeDocument",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_document(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeDocument",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_document_permission(name, permission_type)
    describe_document_permission(name, permission_type, params::Dict{String,<:Any})

Describes the permissions for a Amazon Web Services Systems Manager document (SSM
document). If you created the document, you are the owner. If a document is shared, it can
either be shared privately (by specifying a user's Amazon Web Services account ID) or
publicly (All).

# Arguments
- `name`: The name of the document for which you are the owner.
- `permission_type`: The permission type for the document. The permission type can be Share.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_document_permission(
    Name, PermissionType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeDocumentPermission",
        Dict{String,Any}("Name" => Name, "PermissionType" => PermissionType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_document_permission(
    Name,
    PermissionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeDocumentPermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "PermissionType" => PermissionType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_effective_instance_associations(instance_id)
    describe_effective_instance_associations(instance_id, params::Dict{String,<:Any})

All associations for the managed nodes.

# Arguments
- `instance_id`: The managed node ID for which you want to view all associations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_effective_instance_associations(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeEffectiveInstanceAssociations",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_effective_instance_associations(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeEffectiveInstanceAssociations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_effective_patches_for_patch_baseline(baseline_id)
    describe_effective_patches_for_patch_baseline(baseline_id, params::Dict{String,<:Any})

Retrieves the current effective patches (the patch and the approval state) for the
specified patch baseline. Applies to patch baselines for Windows only.

# Arguments
- `baseline_id`: The ID of the patch baseline to retrieve the effective patches for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of patches to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_effective_patches_for_patch_baseline(
    BaselineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeEffectivePatchesForPatchBaseline",
        Dict{String,Any}("BaselineId" => BaselineId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_effective_patches_for_patch_baseline(
    BaselineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeEffectivePatchesForPatchBaseline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BaselineId" => BaselineId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_associations_status(instance_id)
    describe_instance_associations_status(instance_id, params::Dict{String,<:Any})

The status of the associations for the managed nodes.

# Arguments
- `instance_id`: The managed node IDs for which you want association status information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_instance_associations_status(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstanceAssociationsStatus",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_associations_status(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeInstanceAssociationsStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_information()
    describe_instance_information(params::Dict{String,<:Any})

Provides information about one or more of your managed nodes, including the operating
system platform, SSM Agent version, association status, and IP address. This operation does
not return information for nodes that are either Stopped or Terminated. If you specify one
or more node IDs, the operation returns information for those managed nodes. If you don't
specify node IDs, it returns information for all your managed nodes. If you specify a node
ID that isn't valid or a node that you don't own, you receive an error.  The IamRole field
returned for this API operation is the Identity and Access Management (IAM) role assigned
to on-premises managed nodes. This operation does not return the IAM role for EC2
instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters. Use a filter to return a more specific list of managed
  nodes. You can filter based on tags applied to your managed nodes. Tag filters can't be
  combined with other filter types. Use this Filters data type instead of
  InstanceInformationFilterList, which is deprecated.
- `"InstanceInformationFilterList"`: This is a legacy method. We recommend that you don't
  use this method. Instead, use the Filters data type. Filters enables you to return node
  information by filtering based on tags applied to managed nodes.  Attempting to use
  InstanceInformationFilterList and Filters leads to an exception error.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
  The default value is 10 items.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_instance_information(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeInstanceInformation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_information(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstanceInformation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_patch_states(instance_ids)
    describe_instance_patch_states(instance_ids, params::Dict{String,<:Any})

Retrieves the high-level patch state of one or more managed nodes.

# Arguments
- `instance_ids`: The ID of the managed node for which patch state information should be
  retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of managed nodes to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_instance_patch_states(
    InstanceIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstancePatchStates",
        Dict{String,Any}("InstanceIds" => InstanceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_patch_states(
    InstanceIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeInstancePatchStates",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceIds" => InstanceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_patch_states_for_patch_group(patch_group)
    describe_instance_patch_states_for_patch_group(patch_group, params::Dict{String,<:Any})

Retrieves the high-level patch state for the managed nodes in the specified patch group.

# Arguments
- `patch_group`: The name of the patch group for which the patch state information should
  be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each entry in the array is a structure containing:   Key (string between 1
  and 200 characters)   Values (array containing a single string)   Type (string \"Equal\",
  \"NotEqual\", \"LessThan\", \"GreaterThan\")
- `"MaxResults"`: The maximum number of patches to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_instance_patch_states_for_patch_group(
    PatchGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstancePatchStatesForPatchGroup",
        Dict{String,Any}("PatchGroup" => PatchGroup);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_patch_states_for_patch_group(
    PatchGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeInstancePatchStatesForPatchGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PatchGroup" => PatchGroup), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_patches(instance_id)
    describe_instance_patches(instance_id, params::Dict{String,<:Any})

Retrieves information about the patches on the specified managed node and their state
relative to the patch baseline being used for the node.

# Arguments
- `instance_id`: The ID of the managed node whose patch state information should be
  retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each element in the array is a structure containing a key-value pair.
  Supported keys for DescribeInstancePatchesinclude the following:     Classification
  Sample values: Security | SecurityUpdates      KBId   Sample values: KB4480056 |
  java-1.7.0-openjdk.x86_64      Severity   Sample values: Important | Medium | Low
  State   Sample values: Installed | InstalledOther | InstalledPendingReboot  For lists of
  all State values, see Understanding patch compliance state values in the Amazon Web
  Services Systems Manager User Guide.
- `"MaxResults"`: The maximum number of patches to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_instance_patches(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstancePatches",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_patches(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeInstancePatches",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_properties()
    describe_instance_properties(params::Dict{String,<:Any})

An API operation used by the Systems Manager console to display information about Systems
Manager managed nodes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FiltersWithOperator"`: The request filters to use with the operator.
- `"InstancePropertyFilterList"`: An array of instance property filters.
- `"MaxResults"`: The maximum number of items to return for the call. The call also returns
  a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token provided by a previous request to use to return the next set of
  properties.
"""
function describe_instance_properties(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeInstanceProperties"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_instance_properties(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInstanceProperties",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_inventory_deletions()
    describe_inventory_deletions(params::Dict{String,<:Any})

Describes a specific delete inventory operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeletionId"`: Specify the delete inventory ID for which you want information. This ID
  was returned by the DeleteInventory operation.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function describe_inventory_deletions(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeInventoryDeletions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_inventory_deletions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeInventoryDeletions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_execution_task_invocations(task_id, window_execution_id)
    describe_maintenance_window_execution_task_invocations(task_id, window_execution_id, params::Dict{String,<:Any})

Retrieves the individual task executions (one per target) for a particular task run as part
of a maintenance window execution.

# Arguments
- `task_id`: The ID of the specific task in the maintenance window task that should be
  retrieved.
- `window_execution_id`: The ID of the maintenance window execution the task is part of.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional filters used to scope down the returned task invocations. The
  supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS,
  FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_window_execution_task_invocations(
    TaskId, WindowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowExecutionTaskInvocations",
        Dict{String,Any}("TaskId" => TaskId, "WindowExecutionId" => WindowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_execution_task_invocations(
    TaskId,
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowExecutionTaskInvocations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TaskId" => TaskId, "WindowExecutionId" => WindowExecutionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_execution_tasks(window_execution_id)
    describe_maintenance_window_execution_tasks(window_execution_id, params::Dict{String,<:Any})

For a given maintenance window execution, lists the tasks that were run.

# Arguments
- `window_execution_id`: The ID of the maintenance window execution whose task executions
  should be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional filters used to scope down the returned tasks. The supported filter
  key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED,
  TIMED_OUT, CANCELLING, and CANCELLED.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_window_execution_tasks(
    WindowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowExecutionTasks",
        Dict{String,Any}("WindowExecutionId" => WindowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_execution_tasks(
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowExecutionTasks",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WindowExecutionId" => WindowExecutionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_executions(window_id)
    describe_maintenance_window_executions(window_id, params::Dict{String,<:Any})

Lists the executions of a maintenance window. This includes information about when the
maintenance window was scheduled to be active, and information about tasks registered and
run with the maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window whose executions should be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each entry in the array is a structure containing:   Key. A string between 1
  and 128 characters. Supported keys include ExecutedBefore and ExecutedAfter.   Values. An
  array of strings, each between 1 and 256 characters. Supported values are date/time strings
  in a valid ISO 8601 date/time format, such as 2021-11-04T05:00:00Z.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_window_executions(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowExecutions",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_executions(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowExecutions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_schedule()
    describe_maintenance_window_schedule(params::Dict{String,<:Any})

Retrieves information about upcoming executions of a maintenance window.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Filters used to limit the range of results. For example, you can limit
  maintenance window executions to only those scheduled before or after a certain date and
  time.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"ResourceType"`: The type of resource you want to retrieve information about. For
  example, INSTANCE.
- `"Targets"`: The managed node ID or key-value pair to retrieve information about.
- `"WindowId"`: The ID of the maintenance window to retrieve information about.
"""
function describe_maintenance_window_schedule(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowSchedule";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_schedule(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowSchedule",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_targets(window_id)
    describe_maintenance_window_targets(window_id, params::Dict{String,<:Any})

Lists the targets registered with the maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window whose targets should be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional filters that can be used to narrow down the scope of the returned
  window targets. The supported filter keys are Type, WindowTargetId, and OwnerInformation.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_window_targets(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowTargets",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_targets(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowTargets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_window_tasks(window_id)
    describe_maintenance_window_tasks(window_id, params::Dict{String,<:Any})

Lists the tasks in a maintenance window.  For maintenance window tasks without a specified
target, you can't supply values for --max-errors and --max-concurrency. Instead, the system
inserts a placeholder value of 1, which may be reported in the response to this command.
These values don't affect the running of your task and can be ignored.

# Arguments
- `window_id`: The ID of the maintenance window whose tasks should be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional filters used to narrow down the scope of the returned tasks. The
  supported filter keys are WindowTaskId, TaskArn, Priority, and TaskType.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_window_tasks(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowTasks",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_window_tasks(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowTasks",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_windows()
    describe_maintenance_windows(params::Dict{String,<:Any})

Retrieves the maintenance windows in an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Optional filters used to narrow down the scope of the returned maintenance
  windows. Supported filter keys are Name and Enabled. For example, Name=MyMaintenanceWindow
  and Enabled=True.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_windows(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeMaintenanceWindows"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_maintenance_windows(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindows",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_windows_for_target(resource_type, targets)
    describe_maintenance_windows_for_target(resource_type, targets, params::Dict{String,<:Any})

Retrieves information about the maintenance window targets or tasks that a managed node is
associated with.

# Arguments
- `resource_type`: The type of resource you want to retrieve information about. For
  example, INSTANCE.
- `targets`: The managed node ID or key-value pair to retrieve information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_maintenance_windows_for_target(
    ResourceType, Targets; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeMaintenanceWindowsForTarget",
        Dict{String,Any}("ResourceType" => ResourceType, "Targets" => Targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_windows_for_target(
    ResourceType,
    Targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribeMaintenanceWindowsForTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceType" => ResourceType, "Targets" => Targets),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ops_items()
    describe_ops_items(params::Dict{String,<:Any})

Query a set of OpsItems. You must have permission in Identity and Access Management (IAM)
to query a list of OpsItems. For more information, see Set up OpsCenter in the Amazon Web
Services Systems Manager User Guide. Operations engineers and IT professionals use Amazon
Web Services Systems Manager OpsCenter to view, investigate, and remediate operational
issues impacting the performance and health of their Amazon Web Services resources. For
more information, see Amazon Web Services Systems Manager OpsCenter in the Amazon Web
Services Systems Manager User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"OpsItemFilters"`: One or more filters to limit the response.   Key: CreatedTime
  Operations: GreaterThan, LessThan   Key: LastModifiedBy Operations: Contains, Equals   Key:
  LastModifiedTime Operations: GreaterThan, LessThan   Key: Priority Operations: Equals
  Key: Source Operations: Contains, Equals   Key: Status Operations: Equals   Key: Title*
  Operations: Equals,Contains   Key: OperationalData** Operations: Equals   Key:
  OperationalDataKey Operations: Equals   Key: OperationalDataValue Operations: Equals,
  Contains   Key: OpsItemId Operations: Equals   Key: ResourceId Operations: Contains   Key:
  AutomationId Operations: Equals   Key: AccountId Operations: Equals   *The Equals operator
  for Title matches the first 100 characters. If you specify more than 100 characters, they
  system returns an error that the filter value exceeds the length limit. **If you filter the
  response by using the OperationalData operator, specify a key-value pair by using the
  following JSON format: {\"key\":\"key_name\",\"value\":\"a_value\"}
"""
function describe_ops_items(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("DescribeOpsItems"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ops_items(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeOpsItems", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_parameters()
    describe_parameters(params::Dict{String,<:Any})

Lists the parameters in your Amazon Web Services account or the parameters shared with you
when you enable the Shared option. Request results are returned on a best-effort basis. If
you specify MaxResults in the request, the response includes information up to the limit
specified. The number of items returned, however, can be between zero and the value of
MaxResults. If the service reaches an internal limit while processing the results, it stops
the operation and returns the matching values up to that point and a NextToken. You can
specify the NextToken in a subsequent call to get the next set of results.  If you change
the KMS key alias for the KMS key used to encrypt a parameter, then you must also update
the key alias the parameter uses to reference KMS. Otherwise, DescribeParameters retrieves
whatever the original key alias was referencing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This data type is deprecated. Instead, use ParameterFilters.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"ParameterFilters"`: Filters to limit the request results.
- `"Shared"`: Lists parameters that are shared with you.  By default when using this
  option, the command returns parameters that have been shared using a standard Resource
  Access Manager Resource Share. In order for a parameter that was shared using the
  PutResourcePolicy command to be returned, the associated RAM Resource Share Created From
  Policy must have been promoted to a standard Resource Share using the RAM
  PromoteResourceShareCreatedFromPolicy API operation. For more information about sharing
  parameters, see Working with shared parameters in the Amazon Web Services Systems Manager
  User Guide.
"""
function describe_parameters(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("DescribeParameters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_parameters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeParameters", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_patch_baselines()
    describe_patch_baselines(params::Dict{String,<:Any})

Lists the patch baselines in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each element in the array is a structure containing a key-value pair.
  Supported keys for DescribePatchBaselines include the following:     NAME_PREFIX   Sample
  values: AWS- | My-      OWNER   Sample values: AWS | Self      OPERATING_SYSTEM   Sample
  values: AMAZON_LINUX | SUSE | WINDOWS
- `"MaxResults"`: The maximum number of patch baselines to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_patch_baselines(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribePatchBaselines"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_patch_baselines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribePatchBaselines",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_patch_group_state(patch_group)
    describe_patch_group_state(patch_group, params::Dict{String,<:Any})

Returns high-level aggregated patch compliance state information for a patch group.

# Arguments
- `patch_group`: The name of the patch group whose patch snapshot should be retrieved.

"""
function describe_patch_group_state(
    PatchGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribePatchGroupState",
        Dict{String,Any}("PatchGroup" => PatchGroup);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_patch_group_state(
    PatchGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribePatchGroupState",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PatchGroup" => PatchGroup), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_patch_groups()
    describe_patch_groups(params::Dict{String,<:Any})

Lists all patch groups that have been registered with patch baselines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: Each element in the array is a structure containing a key-value pair.
  Supported keys for DescribePatchGroups include the following:     NAME_PREFIX   Sample
  values: AWS- | My-.     OPERATING_SYSTEM   Sample values: AMAZON_LINUX | SUSE | WINDOWS
- `"MaxResults"`: The maximum number of patch groups to return (per page).
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_patch_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribePatchGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_patch_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribePatchGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_patch_properties(operating_system, property)
    describe_patch_properties(operating_system, property, params::Dict{String,<:Any})

Lists the properties of available patches organized by product, product family,
classification, severity, and other properties of available patches. You can use the
reported properties in the filters you specify in requests for operations such as
CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches, and
DescribePatchBaselines. The following section lists the properties that can be used in
filters for each major operating system type:  AMAZON_LINUX  Valid properties: PRODUCT |
CLASSIFICATION | SEVERITY   AMAZON_LINUX_2  Valid properties: PRODUCT | CLASSIFICATION |
SEVERITY   CENTOS  Valid properties: PRODUCT | CLASSIFICATION | SEVERITY   DEBIAN  Valid
properties: PRODUCT | PRIORITY   MACOS  Valid properties: PRODUCT | CLASSIFICATION
ORACLE_LINUX  Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
REDHAT_ENTERPRISE_LINUX  Valid properties: PRODUCT | CLASSIFICATION | SEVERITY   SUSE
Valid properties: PRODUCT | CLASSIFICATION | SEVERITY   UBUNTU  Valid properties: PRODUCT |
PRIORITY   WINDOWS  Valid properties: PRODUCT | PRODUCT_FAMILY | CLASSIFICATION |
MSRC_SEVERITY

# Arguments
- `operating_system`: The operating system type for which to list patches.
- `property`: The patch property for which you want to view patch details.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"PatchSet"`: Indicates whether to list patches for the Windows operating system or for
  applications released by Microsoft. Not applicable for the Linux or macOS operating systems.
"""
function describe_patch_properties(
    OperatingSystem, Property; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribePatchProperties",
        Dict{String,Any}("OperatingSystem" => OperatingSystem, "Property" => Property);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_patch_properties(
    OperatingSystem,
    Property,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DescribePatchProperties",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OperatingSystem" => OperatingSystem, "Property" => Property
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_sessions(state)
    describe_sessions(state, params::Dict{String,<:Any})

Retrieves a list of all active sessions (both connected and disconnected) or terminated
sessions from the past 30 days.

# Arguments
- `state`: The session status to retrieve a list of sessions for. For example, \"Active\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters to limit the type of sessions returned by the request.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function describe_sessions(State; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "DescribeSessions",
        Dict{String,Any}("State" => State);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_sessions(
    State, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DescribeSessions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("State" => State), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_ops_item_related_item(association_id, ops_item_id)
    disassociate_ops_item_related_item(association_id, ops_item_id, params::Dict{String,<:Any})

Deletes the association between an OpsItem and a related item. For example, this API
operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a
capability of Amazon Web Services Systems Manager.

# Arguments
- `association_id`: The ID of the association for which you want to delete an association
  between the OpsItem and a related item.
- `ops_item_id`: The ID of the OpsItem for which you want to delete an association between
  the OpsItem and a related item.

"""
function disassociate_ops_item_related_item(
    AssociationId, OpsItemId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "DisassociateOpsItemRelatedItem",
        Dict{String,Any}("AssociationId" => AssociationId, "OpsItemId" => OpsItemId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_ops_item_related_item(
    AssociationId,
    OpsItemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "DisassociateOpsItemRelatedItem",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationId" => AssociationId, "OpsItemId" => OpsItemId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_automation_execution(automation_execution_id)
    get_automation_execution(automation_execution_id, params::Dict{String,<:Any})

Get detailed information about a particular Automation execution.

# Arguments
- `automation_execution_id`: The unique identifier for an existing automation execution to
  examine. The execution ID is returned by StartAutomationExecution when the execution of an
  Automation runbook is initiated.

"""
function get_automation_execution(
    AutomationExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetAutomationExecution",
        Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_automation_execution(
    AutomationExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetAutomationExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_calendar_state(calendar_names)
    get_calendar_state(calendar_names, params::Dict{String,<:Any})

Gets the state of a Amazon Web Services Systems Manager change calendar at the current time
or a specified time. If you specify a time, GetCalendarState returns the state of the
calendar at that specific time, and returns the next time that the change calendar state
will transition. If you don't specify a time, GetCalendarState uses the current time.
Change Calendar entries have two possible states: OPEN or CLOSED. If you specify more than
one calendar in a request, the command returns the status of OPEN only if all calendars in
the request are open. If one or more calendars in the request are closed, the status
returned is CLOSED. For more information about Change Calendar, a capability of Amazon Web
Services Systems Manager, see Amazon Web Services Systems Manager Change Calendar in the
Amazon Web Services Systems Manager User Guide.

# Arguments
- `calendar_names`: The names or Amazon Resource Names (ARNs) of the Systems Manager
  documents (SSM documents) that represent the calendar entries for which you want to get the
  state.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AtTime"`: (Optional) The specific time for which you want to get calendar state
  information, in ISO 8601 format. If you don't specify a value or AtTime, the current time
  is used.
"""
function get_calendar_state(
    CalendarNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetCalendarState",
        Dict{String,Any}("CalendarNames" => CalendarNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_calendar_state(
    CalendarNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetCalendarState",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CalendarNames" => CalendarNames), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_command_invocation(command_id, instance_id)
    get_command_invocation(command_id, instance_id, params::Dict{String,<:Any})

Returns detailed information about command execution for an invocation or plugin.
GetCommandInvocation only gives the execution status of a plugin in a document. To get the
command execution status on a specific managed node, use ListCommandInvocations. To get the
command execution status across managed nodes, use ListCommands.

# Arguments
- `command_id`: (Required) The parent command ID of the invocation plugin.
- `instance_id`: (Required) The ID of the managed node targeted by the command. A managed
  node can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and
  on-premises server or VM in your hybrid environment that is configured for Amazon Web
  Services Systems Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PluginName"`: The name of the step for which you want detailed results. If the document
  contains only one step, you can omit the name and details for that step. If the document
  contains more than one step, you must specify the name of the step for which you want to
  view details. Be sure to specify the name of the step, not the name of a plugin like
  aws:RunShellScript. To find the PluginName, check the document content and find the name of
  the step you want details for. Alternatively, use ListCommandInvocations with the CommandId
  and Details parameters. The PluginName is the Name attribute of the CommandPlugin object in
  the CommandPlugins list.
"""
function get_command_invocation(
    CommandId, InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetCommandInvocation",
        Dict{String,Any}("CommandId" => CommandId, "InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_command_invocation(
    CommandId,
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetCommandInvocation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CommandId" => CommandId, "InstanceId" => InstanceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connection_status(target)
    get_connection_status(target, params::Dict{String,<:Any})

Retrieves the Session Manager connection status for a managed node to determine whether it
is running and ready to receive Session Manager connections.

# Arguments
- `target`: The managed node ID.

"""
function get_connection_status(Target; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetConnectionStatus",
        Dict{String,Any}("Target" => Target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connection_status(
    Target, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetConnectionStatus",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Target" => Target), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_default_patch_baseline()
    get_default_patch_baseline(params::Dict{String,<:Any})

Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating
multiple default patch baselines. For example, you can create a default patch baseline for
each operating system. If you don't specify an operating system value, the default patch
baseline for Windows is returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OperatingSystem"`: Returns the default patch baseline for the specified operating
  system.
"""
function get_default_patch_baseline(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetDefaultPatchBaseline"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_default_patch_baseline(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetDefaultPatchBaseline",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deployable_patch_snapshot_for_instance(instance_id, snapshot_id)
    get_deployable_patch_snapshot_for_instance(instance_id, snapshot_id, params::Dict{String,<:Any})

Retrieves the current snapshot for the patch baseline the managed node uses. This API is
primarily used by the AWS-RunPatchBaseline Systems Manager document (SSM document).  If you
run the command locally, such as with the Command Line Interface (CLI), the system attempts
to use your local Amazon Web Services credentials and the operation fails. To avoid this,
you can run the command in the Amazon Web Services Systems Manager console. Use Run
Command, a capability of Amazon Web Services Systems Manager, with an SSM document that
enables you to target a managed node with a script or command. For example, run the command
using the AWS-RunShellScript document or the AWS-RunPowerShellScript document.

# Arguments
- `instance_id`: The ID of the managed node for which the appropriate patch snapshot should
  be retrieved.
- `snapshot_id`: The snapshot ID provided by the user when running AWS-RunPatchBaseline.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BaselineOverride"`: Defines the basic information about a patch baseline override.
"""
function get_deployable_patch_snapshot_for_instance(
    InstanceId, SnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetDeployablePatchSnapshotForInstance",
        Dict{String,Any}("InstanceId" => InstanceId, "SnapshotId" => SnapshotId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deployable_patch_snapshot_for_instance(
    InstanceId,
    SnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetDeployablePatchSnapshotForInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "SnapshotId" => SnapshotId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_document(name)
    get_document(name, params::Dict{String,<:Any})

Gets the contents of the specified Amazon Web Services Systems Manager document (SSM
document).

# Arguments
- `name`: The name of the SSM document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentFormat"`: Returns the document in the specified format. The document format can
  be either JSON or YAML. JSON is the default format.
- `"DocumentVersion"`: The document version for which you want information.
- `"VersionName"`: An optional field specifying the version of the artifact associated with
  the document. For example, 12.6. This value is unique across all versions of a document and
  can't be changed.
"""
function get_document(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetDocument",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_document(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetDocument",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_inventory()
    get_inventory(params::Dict{String,<:Any})

Query inventory information. This includes managed node status, such as Stopped or
Terminated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Aggregators"`: Returns counts of inventory types based on one or more expressions. For
  example, if you aggregate by using an expression that uses the
  AWS:InstanceInformation.PlatformType type, you can see a count of how many Windows and
  Linux managed nodes exist in your inventoried fleet.
- `"Filters"`: One or more filters. Use a filter to return a more specific list of results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"ResultAttributes"`: The list of inventory item types to return.
"""
function get_inventory(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("GetInventory"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_inventory(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetInventory", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_inventory_schema()
    get_inventory_schema(params::Dict{String,<:Any})

Return a list of inventory type names for the account, or return a list of attribute names
for a specific Inventory item type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Aggregator"`: Returns inventory schemas that support aggregation. For example, this
  call returns the AWS:InstanceInformation type, because it supports aggregation based on the
  PlatformName, PlatformType, and PlatformVersion attributes.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"SubType"`: Returns the sub-type schema for a specified inventory type.
- `"TypeName"`: The type of inventory item to return.
"""
function get_inventory_schema(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("GetInventorySchema"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_inventory_schema(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetInventorySchema", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_maintenance_window(window_id)
    get_maintenance_window(window_id, params::Dict{String,<:Any})

Retrieves a maintenance window.

# Arguments
- `window_id`: The ID of the maintenance window for which you want to retrieve information.

"""
function get_maintenance_window(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetMaintenanceWindow",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_maintenance_window(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_maintenance_window_execution(window_execution_id)
    get_maintenance_window_execution(window_execution_id, params::Dict{String,<:Any})

Retrieves details about a specific a maintenance window execution.

# Arguments
- `window_execution_id`: The ID of the maintenance window execution that includes the task.

"""
function get_maintenance_window_execution(
    WindowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetMaintenanceWindowExecution",
        Dict{String,Any}("WindowExecutionId" => WindowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_maintenance_window_execution(
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindowExecution",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WindowExecutionId" => WindowExecutionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_maintenance_window_execution_task(task_id, window_execution_id)
    get_maintenance_window_execution_task(task_id, window_execution_id, params::Dict{String,<:Any})

Retrieves the details about a specific task run as part of a maintenance window execution.

# Arguments
- `task_id`: The ID of the specific task execution in the maintenance window task that
  should be retrieved.
- `window_execution_id`: The ID of the maintenance window execution that includes the task.

"""
function get_maintenance_window_execution_task(
    TaskId, WindowExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetMaintenanceWindowExecutionTask",
        Dict{String,Any}("TaskId" => TaskId, "WindowExecutionId" => WindowExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_maintenance_window_execution_task(
    TaskId,
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindowExecutionTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TaskId" => TaskId, "WindowExecutionId" => WindowExecutionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_maintenance_window_execution_task_invocation(invocation_id, task_id, window_execution_id)
    get_maintenance_window_execution_task_invocation(invocation_id, task_id, window_execution_id, params::Dict{String,<:Any})

Retrieves information about a specific task running on a specific target.

# Arguments
- `invocation_id`: The invocation ID to retrieve.
- `task_id`: The ID of the specific task in the maintenance window task that should be
  retrieved.
- `window_execution_id`: The ID of the maintenance window execution for which the task is a
  part.

"""
function get_maintenance_window_execution_task_invocation(
    InvocationId,
    TaskId,
    WindowExecutionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindowExecutionTaskInvocation",
        Dict{String,Any}(
            "InvocationId" => InvocationId,
            "TaskId" => TaskId,
            "WindowExecutionId" => WindowExecutionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_maintenance_window_execution_task_invocation(
    InvocationId,
    TaskId,
    WindowExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindowExecutionTaskInvocation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InvocationId" => InvocationId,
                    "TaskId" => TaskId,
                    "WindowExecutionId" => WindowExecutionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_maintenance_window_task(window_id, window_task_id)
    get_maintenance_window_task(window_id, window_task_id, params::Dict{String,<:Any})

Retrieves the details of a maintenance window task.  For maintenance window tasks without a
specified target, you can't supply values for --max-errors and --max-concurrency. Instead,
the system inserts a placeholder value of 1, which may be reported in the response to this
command. These values don't affect the running of your task and can be ignored.  To
retrieve a list of tasks in a maintenance window, instead use the
DescribeMaintenanceWindowTasks command.

# Arguments
- `window_id`: The maintenance window ID that includes the task to retrieve.
- `window_task_id`: The maintenance window task ID to retrieve.

"""
function get_maintenance_window_task(
    WindowId, WindowTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetMaintenanceWindowTask",
        Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_maintenance_window_task(
    WindowId,
    WindowTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetMaintenanceWindowTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ops_item(ops_item_id)
    get_ops_item(ops_item_id, params::Dict{String,<:Any})

Get information about an OpsItem by using the ID. You must have permission in Identity and
Access Management (IAM) to view information about an OpsItem. For more information, see Set
up OpsCenter in the Amazon Web Services Systems Manager User Guide. Operations engineers
and IT professionals use Amazon Web Services Systems Manager OpsCenter to view,
investigate, and remediate operational issues impacting the performance and health of their
Amazon Web Services resources. For more information, see Amazon Web Services Systems
Manager OpsCenter in the Amazon Web Services Systems Manager User Guide.

# Arguments
- `ops_item_id`: The ID of the OpsItem that you want to get.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OpsItemArn"`: The OpsItem Amazon Resource Name (ARN).
"""
function get_ops_item(OpsItemId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetOpsItem",
        Dict{String,Any}("OpsItemId" => OpsItemId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ops_item(
    OpsItemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetOpsItem",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsItemId" => OpsItemId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ops_metadata(ops_metadata_arn)
    get_ops_metadata(ops_metadata_arn, params::Dict{String,<:Any})

View operational metadata related to an application in Application Manager.

# Arguments
- `ops_metadata_arn`: The Amazon Resource Name (ARN) of an OpsMetadata Object to view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function get_ops_metadata(
    OpsMetadataArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetOpsMetadata",
        Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ops_metadata(
    OpsMetadataArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetOpsMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ops_summary()
    get_ops_summary(params::Dict{String,<:Any})

View a summary of operations metadata (OpsData) based on specified filters and aggregators.
OpsData can include information about Amazon Web Services Systems Manager OpsCenter
operational workitems (OpsItems) as well as information about any Amazon Web Services
resource or service configured to report OpsData to Amazon Web Services Systems Manager
Explorer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Aggregators"`: Optional aggregators that return counts of OpsData based on one or more
  expressions.
- `"Filters"`: Optional filters used to scope down the returned OpsData.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"ResultAttributes"`: The OpsData data type to return.
- `"SyncName"`: Specify the name of a resource data sync to get.
"""
function get_ops_summary(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("GetOpsSummary"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_ops_summary(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetOpsSummary", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_parameter(name)
    get_parameter(name, params::Dict{String,<:Any})

Get information about a single parameter by specifying the parameter name.  To get
information about more than one parameter at a time, use the GetParameters operation.

# Arguments
- `name`: The name or Amazon Resource Name (ARN) of the parameter that you want to query.
  For parameters shared with you from another account, you must use the full ARN. To query by
  parameter label, use \"Name\": \"name:label\". To query by parameter version, use \"Name\":
  \"name:version\". For more information about shared parameters, see Working with shared
  parameters in the Amazon Web Services Systems Manager User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WithDecryption"`: Return decrypted values for secure string parameters. This flag is
  ignored for String and StringList parameter types.
"""
function get_parameter(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetParameter",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_parameter(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetParameter",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_parameter_history(name)
    get_parameter_history(name, params::Dict{String,<:Any})

Retrieves the history of all changes to a parameter.  If you change the KMS key alias for
the KMS key used to encrypt a parameter, then you must also update the key alias the
parameter uses to reference KMS. Otherwise, GetParameterHistory retrieves whatever the
original key alias was referencing.

# Arguments
- `name`: The name or Amazon Resource Name (ARN) of the parameter for which you want to
  review history. For parameters shared with you from another account, you must use the full
  ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"WithDecryption"`: Return decrypted values for secure string parameters. This flag is
  ignored for String and StringList parameter types.
"""
function get_parameter_history(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetParameterHistory",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_parameter_history(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetParameterHistory",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_parameters(names)
    get_parameters(names, params::Dict{String,<:Any})

Get information about one or more parameters by specifying multiple parameter names.  To
get information about a single parameter, you can use the GetParameter operation instead.

# Arguments
- `names`: The names or Amazon Resource Names (ARNs) of the parameters that you want to
  query. For parameters shared with you from another account, you must use the full ARNs. To
  query by parameter label, use \"Name\": \"name:label\". To query by parameter version, use
  \"Name\": \"name:version\".  The results for GetParameters requests are listed in
  alphabetical order in query responses.  For information about shared parameters, see
  Working with shared parameters in the Amazon Web Services Systems Manager User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"WithDecryption"`: Return decrypted secure string value. Return decrypted values for
  secure string parameters. This flag is ignored for String and StringList parameter types.
"""
function get_parameters(Names; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetParameters",
        Dict{String,Any}("Names" => Names);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_parameters(
    Names, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetParameters",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Names" => Names), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_parameters_by_path(path)
    get_parameters_by_path(path, params::Dict{String,<:Any})

Retrieve information about one or more parameters in a specific hierarchy.  Request results
are returned on a best-effort basis. If you specify MaxResults in the request, the response
includes information up to the limit specified. The number of items returned, however, can
be between zero and the value of MaxResults. If the service reaches an internal limit while
processing the results, it stops the operation and returns the matching values up to that
point and a NextToken. You can specify the NextToken in a subsequent call to get the next
set of results.

# Arguments
- `path`: The hierarchy for the parameter. Hierarchies start with a forward slash (/). The
  hierarchy is the parameter name except the last part of the parameter. For the API call to
  succeed, the last part of the parameter name can't be in the path. A parameter name
  hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy:
  /Finance/Prod/IAD/WinServ2016/license33

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"ParameterFilters"`: Filters to limit the request results.  The following Key values are
  supported for GetParametersByPath: Type, KeyId, and Label. The following Key values aren't
  supported for GetParametersByPath: tag, DataType, Name, Path, and Tier.
- `"Recursive"`: Retrieve all parameters within a hierarchy.  If a user has access to a
  path, then the user can access all levels of that path. For example, if a user has
  permission to access path /a, then the user can also access /a/b. Even if a user has
  explicitly been denied access in IAM for parameter /a/b, they can still call the
  GetParametersByPath API operation recursively for /a and view /a/b.
- `"WithDecryption"`: Retrieve all parameters in a hierarchy with their value decrypted.
"""
function get_parameters_by_path(Path; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetParametersByPath",
        Dict{String,Any}("Path" => Path);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_parameters_by_path(
    Path, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetParametersByPath",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Path" => Path), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_patch_baseline(baseline_id)
    get_patch_baseline(baseline_id, params::Dict{String,<:Any})

Retrieves information about a patch baseline.

# Arguments
- `baseline_id`: The ID of the patch baseline to retrieve.  To retrieve information about
  an Amazon Web Services managed patch baseline, specify the full Amazon Resource Name (ARN)
  of the baseline. For example, for the baseline AWS-AmazonLinuxDefaultPatchBaseline, specify
  arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7 instead of
  pb-0e392de35e7c563b7.

"""
function get_patch_baseline(BaselineId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetPatchBaseline",
        Dict{String,Any}("BaselineId" => BaselineId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_patch_baseline(
    BaselineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetPatchBaseline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BaselineId" => BaselineId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_patch_baseline_for_patch_group(patch_group)
    get_patch_baseline_for_patch_group(patch_group, params::Dict{String,<:Any})

Retrieves the patch baseline that should be used for the specified patch group.

# Arguments
- `patch_group`: The name of the patch group whose patch baseline should be retrieved.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OperatingSystem"`: Returns the operating system rule specified for patch groups using
  the patch baseline.
"""
function get_patch_baseline_for_patch_group(
    PatchGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetPatchBaselineForPatchGroup",
        Dict{String,Any}("PatchGroup" => PatchGroup);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_patch_baseline_for_patch_group(
    PatchGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetPatchBaselineForPatchGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PatchGroup" => PatchGroup), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policies(resource_arn)
    get_resource_policies(resource_arn, params::Dict{String,<:Any})

Returns an array of the Policy object.

# Arguments
- `resource_arn`: Amazon Resource Name (ARN) of the resource to which the policies are
  attached.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function get_resource_policies(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "GetResourcePolicies",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policies(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetResourcePolicies",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_setting(setting_id)
    get_service_setting(setting_id, params::Dict{String,<:Any})

 ServiceSetting is an account-level setting for an Amazon Web Services service. This
setting defines how a user interacts with or uses a service or a feature of a service. For
example, if an Amazon Web Services service charges money to the account based on feature or
service usage, then the Amazon Web Services service team might create a default setting of
false. This means the user can't use this feature unless they change the setting to true
and intentionally opt in for a paid feature. Services map a SettingId object to a setting
value. Amazon Web Services services teams define the default value for a SettingId. You
can't create a new SettingId, but you can overwrite the default value if you have the
ssm:UpdateServiceSetting permission for the setting. Use the UpdateServiceSetting API
operation to change the default setting. Or use the ResetServiceSetting to change the value
back to the original value defined by the Amazon Web Services service team. Query the
current service setting for the Amazon Web Services account.

# Arguments
- `setting_id`: The ID of the service setting to get. The setting ID can be one of the
  following.    /ssm/managed-instance/default-ec2-instance-management-role
  /ssm/automation/customer-script-log-destination
  /ssm/automation/customer-script-log-group-name
  /ssm/documents/console/public-sharing-permission     /ssm/managed-instance/activation-tier
     /ssm/opsinsights/opscenter     /ssm/parameter-store/default-parameter-tier
  /ssm/parameter-store/high-throughput-enabled

"""
function get_service_setting(SettingId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "GetServiceSetting",
        Dict{String,Any}("SettingId" => SettingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_setting(
    SettingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "GetServiceSetting",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SettingId" => SettingId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    label_parameter_version(labels, name)
    label_parameter_version(labels, name, params::Dict{String,<:Any})

A parameter label is a user-defined alias to help you manage different versions of a
parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically
saves a new version and increments the version number by one. A label can help you remember
the purpose of a parameter when there are multiple versions.  Parameter labels have the
following requirements and restrictions.   A version of a parameter can have a maximum of
10 labels.   You can't attach the same label to different versions of the same parameter.
For example, if version 1 has the label Production, then you can't attach Production to
version 2.   You can move a label from one version of a parameter to another.   You can't
create a label when you create a new parameter. You must attach a label to a specific
version of a parameter.   If you no longer want to use a parameter label, then you can
either delete it or move it to a different version of a parameter.   A label can have a
maximum of 100 characters.   Labels can contain letters (case sensitive), numbers, periods
(.), hyphens (-), or underscores (_).   Labels can't begin with a number, \"aws\" or
\"ssm\" (not case sensitive). If a label fails to meet these requirements, then the label
isn't associated with a parameter and the system displays it in the list of InvalidLabels.

# Arguments
- `labels`: One or more labels to attach to the specified parameter version.
- `name`: The parameter name on which you want to attach one or more labels.  You can't
  enter the Amazon Resource Name (ARN) for a parameter, only the parameter name itself.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ParameterVersion"`: The specific version of the parameter on which you want to attach
  one or more labels. If no version is specified, the system attaches the label to the latest
  version.
"""
function label_parameter_version(
    Labels, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "LabelParameterVersion",
        Dict{String,Any}("Labels" => Labels, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function label_parameter_version(
    Labels,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "LabelParameterVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Labels" => Labels, "Name" => Name), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_association_versions(association_id)
    list_association_versions(association_id, params::Dict{String,<:Any})

Retrieves all versions of an association for a specific association ID.

# Arguments
- `association_id`: The association ID for which you want to view all versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_association_versions(
    AssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListAssociationVersions",
        Dict{String,Any}("AssociationId" => AssociationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_association_versions(
    AssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ListAssociationVersions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AssociationId" => AssociationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_associations()
    list_associations(params::Dict{String,<:Any})

Returns all State Manager associations in the current Amazon Web Services account and
Amazon Web Services Region. You can limit the results to a specific State Manager
association document or managed node by specifying a filter. State Manager is a capability
of Amazon Web Services Systems Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationFilterList"`: One or more filters. Use a filter to return a more specific
  list of results.  Filtering associations using the InstanceID attribute only returns legacy
  associations created using the InstanceID attribute. Associations targeting the managed
  node that are part of the Target Attributes ResourceGroup or Tags aren't returned.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function list_associations(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("ListAssociations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListAssociations", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_command_invocations()
    list_command_invocations(params::Dict{String,<:Any})

An invocation is copy of a command sent to a specific managed node. A command can apply to
one or more managed nodes. A command invocation applies to one managed node. For example,
if a user runs SendCommand against three managed nodes, then a command invocation is
created for each requested managed node ID. ListCommandInvocations provide status about
command execution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CommandId"`: (Optional) The invocations for a specific command ID.
- `"Details"`: (Optional) If set this returns the response of the command executions and
  any command output. The default value is false.
- `"Filters"`: (Optional) One or more filters. Use a filter to return a more specific list
  of results.
- `"InstanceId"`: (Optional) The command execution details for a specific managed node ID.
- `"MaxResults"`: (Optional) The maximum number of items to return for this call. The call
  also returns a token that you can specify in a subsequent call to get the next set of
  results.
- `"NextToken"`: (Optional) The token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_command_invocations(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListCommandInvocations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_command_invocations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListCommandInvocations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_commands()
    list_commands(params::Dict{String,<:Any})

Lists the commands requested by users of the Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CommandId"`: (Optional) If provided, lists only the specified command.
- `"Filters"`: (Optional) One or more filters. Use a filter to return a more specific list
  of results.
- `"InstanceId"`: (Optional) Lists commands issued against this managed node ID.  You can't
  specify a managed node ID in the same command that you specify Status = Pending. This is
  because the command hasn't reached the managed node yet.
- `"MaxResults"`: (Optional) The maximum number of items to return for this call. The call
  also returns a token that you can specify in a subsequent call to get the next set of
  results.
- `"NextToken"`: (Optional) The token for the next set of items to return. (You received
  this token from a previous call.)
"""
function list_commands(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("ListCommands"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_commands(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListCommands", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_compliance_items()
    list_compliance_items(params::Dict{String,<:Any})

For a specified resource ID, this API operation returns a list of compliance statuses for
different resource types. Currently, you can only specify one resource ID per call. List
results depend on the criteria specified in the filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more compliance filters. Use a filter to return a more specific list
  of results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"ResourceIds"`: The ID for the resources from which to get compliance information.
  Currently, you can only specify one resource ID.
- `"ResourceTypes"`: The type of resource from which to get compliance information.
  Currently, the only supported resource type is ManagedInstance.
"""
function list_compliance_items(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListComplianceItems"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_compliance_items(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListComplianceItems",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_compliance_summaries()
    list_compliance_summaries(params::Dict{String,<:Any})

Returns a summary count of compliant and non-compliant resources for a compliance type. For
example, this call can return State Manager associations, patches, or custom compliance
types according to the filter criteria that you specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more compliance or inventory filters. Use a filter to return a more
  specific list of results.
- `"MaxResults"`: The maximum number of items to return for this call. Currently, you can
  specify null or 50. The call also returns a token that you can specify in a subsequent call
  to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_compliance_summaries(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListComplianceSummaries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_compliance_summaries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListComplianceSummaries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_document_metadata_history(metadata, name)
    list_document_metadata_history(metadata, name, params::Dict{String,<:Any})

Information about approval reviews for a version of a change template in Change Manager.

# Arguments
- `metadata`: The type of data for which details are being requested. Currently, the only
  supported value is DocumentReviews.
- `name`: The name of the change template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentVersion"`: The version of the change template.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function list_document_metadata_history(
    Metadata, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListDocumentMetadataHistory",
        Dict{String,Any}("Metadata" => Metadata, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_document_metadata_history(
    Metadata,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ListDocumentMetadataHistory",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Metadata" => Metadata, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_document_versions(name)
    list_document_versions(name, params::Dict{String,<:Any})

List all versions for a document.

# Arguments
- `name`: The name of the document. You can specify an Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function list_document_versions(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListDocumentVersions",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_document_versions(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListDocumentVersions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_documents()
    list_documents(params::Dict{String,<:Any})

Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and
Amazon Web Services Region. You can limit the results of this request by using a filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentFilterList"`: This data type is deprecated. Instead, use Filters.
- `"Filters"`: One or more DocumentKeyValuesFilter objects. Use a filter to return a more
  specific list of results. For keys, you can specify one or more key-value pair tags that
  have been applied to a document. Other valid keys include Owner, Name, PlatformTypes,
  DocumentType, and TargetType. For example, to return documents you own use
  Key=Owner,Values=Self. To specify a custom key-value pair, use the format
  Key=tag:tagName,Values=valueName.  This API operation only supports filtering documents by
  using a single tag key and one or more tag values. For example:
  Key=tag:tagName,Values=valueName1,valueName2
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function list_documents(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("ListDocuments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_documents(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListDocuments", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_inventory_entries(instance_id, type_name)
    list_inventory_entries(instance_id, type_name, params::Dict{String,<:Any})

A list of inventory items returned by the request.

# Arguments
- `instance_id`: The managed node ID for which you want inventory information.
- `type_name`: The type of inventory item for which you want information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters. Use a filter to return a more specific list of results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
"""
function list_inventory_entries(
    InstanceId, TypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListInventoryEntries",
        Dict{String,Any}("InstanceId" => InstanceId, "TypeName" => TypeName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_inventory_entries(
    InstanceId,
    TypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ListInventoryEntries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "TypeName" => TypeName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_ops_item_events()
    list_ops_item_events(params::Dict{String,<:Any})

Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon
Web Services account. You can limit the results to events associated with specific OpsItems
by specifying a filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more OpsItem filters. Use a filter to return a more specific list of
  results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_ops_item_events(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("ListOpsItemEvents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_ops_item_events(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListOpsItemEvents", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_ops_item_related_items()
    list_ops_item_related_items(params::Dict{String,<:Any})

Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem.
OpsCenter is a capability of Amazon Web Services Systems Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more OpsItem filters. Use a filter to return a more specific list of
  results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a previous call.)
- `"OpsItemId"`: The ID of the OpsItem for which you want to list all related-item
  resources.
"""
function list_ops_item_related_items(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListOpsItemRelatedItems"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_ops_item_related_items(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListOpsItemRelatedItems",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_ops_metadata()
    list_ops_metadata(params::Dict{String,<:Any})

Amazon Web Services Systems Manager calls this API operation when displaying all
Application Manager OpsMetadata objects or blobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters to limit the number of OpsMetadata objects returned by
  the call.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_ops_metadata(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm("ListOpsMetadata"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_ops_metadata(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListOpsMetadata", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_resource_compliance_summaries()
    list_resource_compliance_summaries(params::Dict{String,<:Any})

Returns a resource-level summary count. The summary includes information about compliant
and non-compliant statuses and detailed compliance-item severity counts, according to the
filter criteria you specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: One or more filters. Use a filter to return a more specific list of results.
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_resource_compliance_summaries(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListResourceComplianceSummaries";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resource_compliance_summaries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListResourceComplianceSummaries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_data_sync()
    list_resource_data_sync(params::Dict{String,<:Any})

Lists your resource data sync configurations. Includes information about the last time a
sync attempted to start, the last sync status, and the last time a sync successfully
completed. The number of sync configurations might be too large to return using a single
call to ListResourceDataSync. You can limit the number of sync configurations returned by
using the MaxResults parameter. To determine whether there are more sync configurations to
list, check the value of NextToken in the output. If there are more sync configurations to
list, you can request them by specifying the NextToken returned in the call to the
parameter of a subsequent call.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"SyncType"`: View a list of resource data syncs according to the sync type. Specify
  SyncToDestination to view resource data syncs that synchronize data to an Amazon S3 bucket.
  Specify SyncFromSource to view resource data syncs from Organizations or from multiple
  Amazon Web Services Regions.
"""
function list_resource_data_sync(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ListResourceDataSync"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resource_data_sync(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListResourceDataSync",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_id, resource_type)
    list_tags_for_resource(resource_id, resource_type, params::Dict{String,<:Any})

Returns a list of the tags assigned to the specified resource. For information about the ID
format for each supported resource type, see AddTagsToResource.

# Arguments
- `resource_id`: The resource ID for which you want to see a list of tags.
- `resource_type`: Returns a list of tags for a specific resource type.

"""
function list_tags_for_resource(
    ResourceId, ResourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ListTagsForResource",
        Dict{String,Any}("ResourceId" => ResourceId, "ResourceType" => ResourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceId,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId, "ResourceType" => ResourceType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_document_permission(name, permission_type)
    modify_document_permission(name, permission_type, params::Dict{String,<:Any})

Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately.
If you share a document privately, you must specify the Amazon Web Services user IDs for
those people who can use the document. If you share a document publicly, you must specify
All as the account ID.

# Arguments
- `name`: The name of the document that you want to share.
- `permission_type`: The permission type for the document. The permission type can be Share.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountIdsToAdd"`: The Amazon Web Services users that should have access to the
  document. The account IDs can either be a group of account IDs or All.
- `"AccountIdsToRemove"`: The Amazon Web Services users that should no longer have access
  to the document. The Amazon Web Services user can either be a group of account IDs or All.
  This action has a higher priority than AccountIdsToAdd. If you specify an ID to add and the
  same ID to remove, the system removes access to the document.
- `"SharedDocumentVersion"`: (Optional) The version of the document to share. If it isn't
  specified, the system choose the Default version to share.
"""
function modify_document_permission(
    Name, PermissionType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ModifyDocumentPermission",
        Dict{String,Any}("Name" => Name, "PermissionType" => PermissionType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_document_permission(
    Name,
    PermissionType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ModifyDocumentPermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "PermissionType" => PermissionType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_compliance_items(compliance_type, execution_summary, items, resource_id, resource_type)
    put_compliance_items(compliance_type, execution_summary, items, resource_id, resource_type, params::Dict{String,<:Any})

Registers a compliance type and other compliance details on a designated resource. This
operation lets you register custom compliance details with a resource. This call overwrites
existing compliance information on the resource, so you must provide a full list of
compliance items each time that you send the request. ComplianceType can be one of the
following:   ExecutionId: The execution ID when the patch, association, or custom
compliance item was applied.   ExecutionType: Specify patch, association, or Custom:string.
  ExecutionTime. The time the patch, association, or custom compliance item was applied to
the managed node.   Id: The patch, association, or custom compliance ID.   Title: A title.
 Status: The status of the compliance item. For example, approved for patches, or Failed
for associations.   Severity: A patch severity. For example, Critical.   DocumentName: An
SSM document name. For example, AWS-RunPatchBaseline.   DocumentVersion: An SSM document
version number. For example, 4.   Classification: A patch classification. For example,
security updates.   PatchBaselineId: A patch baseline ID.   PatchSeverity: A patch
severity. For example, Critical.   PatchState: A patch state. For example,
InstancesWithFailedPatches.   PatchGroup: The name of a patch group.   InstalledTime: The
time the association, patch, or custom compliance item was applied to the resource. Specify
the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'

# Arguments
- `compliance_type`: Specify the compliance type. For example, specify Association (for a
  State Manager association), Patch, or Custom:string.
- `execution_summary`: A summary of the call execution that includes an execution ID, the
  type of execution (for example, Command), and the date/time of the execution using a
  datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'
- `items`: Information about the compliance as defined by the resource type. For example,
  for a patch compliance type, Items includes information about the PatchSeverity,
  Classification, and so on.
- `resource_id`: Specify an ID for this resource. For a managed node, this is the node ID.
- `resource_type`: Specify the type of resource. ManagedInstance is currently the only
  supported resource type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ItemContentHash"`: MD5 or SHA-256 content hash. The content hash is used to determine
  if existing information should be overwritten or ignored. If the content hashes match, the
  request to put compliance information is ignored.
- `"UploadType"`: The mode for uploading compliance items. You can specify COMPLETE or
  PARTIAL. In COMPLETE mode, the system overwrites all existing compliance information for
  the resource. You must provide a full list of compliance items each time you send the
  request. In PARTIAL mode, the system overwrites compliance information for a specific
  association. The association must be configured with SyncCompliance set to MANUAL. By
  default, all requests use COMPLETE mode.  This attribute is only valid for association
  compliance.
"""
function put_compliance_items(
    ComplianceType,
    ExecutionSummary,
    Items,
    ResourceId,
    ResourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "PutComplianceItems",
        Dict{String,Any}(
            "ComplianceType" => ComplianceType,
            "ExecutionSummary" => ExecutionSummary,
            "Items" => Items,
            "ResourceId" => ResourceId,
            "ResourceType" => ResourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_compliance_items(
    ComplianceType,
    ExecutionSummary,
    Items,
    ResourceId,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "PutComplianceItems",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ComplianceType" => ComplianceType,
                    "ExecutionSummary" => ExecutionSummary,
                    "Items" => Items,
                    "ResourceId" => ResourceId,
                    "ResourceType" => ResourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_inventory(instance_id, items)
    put_inventory(instance_id, items, params::Dict{String,<:Any})

Bulk update custom inventory items on one or more managed nodes. The request adds an
inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.

# Arguments
- `instance_id`: An managed node ID where you want to add or update inventory items.
- `items`: The inventory items that you want to add or update on managed nodes.

"""
function put_inventory(
    InstanceId, Items; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "PutInventory",
        Dict{String,Any}("InstanceId" => InstanceId, "Items" => Items);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_inventory(
    InstanceId,
    Items,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "PutInventory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "Items" => Items),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_parameter(name, value)
    put_parameter(name, value, params::Dict{String,<:Any})

Add a parameter to the system.

# Arguments
- `name`: The fully qualified name of the parameter that you want to add to the system.
  You can't enter the Amazon Resource Name (ARN) for a parameter, only the parameter name
  itself.  The fully qualified name includes the complete hierarchy of the parameter path and
  name. For parameters in a hierarchy, you must include a leading forward slash character (/)
  when you create or reference a parameter. For example: /Dev/DBServer/MySQL/db-string13
  Naming Constraints:   Parameter names are case sensitive.   A parameter name must be unique
  within an Amazon Web Services Region   A parameter name can't be prefixed with \"aws\" or
  \"ssm\" (case-insensitive).   Parameter names can include only the following symbols and
  letters: a-zA-Z0-9_.-  In addition, the slash character ( / ) is used to delineate
  hierarchies in parameter names. For example: /Dev/Production/East/Project-ABC/MyParameter
   A parameter name can't include spaces.   Parameter hierarchies are limited to a maximum
  depth of fifteen levels.   For additional information about valid values for parameter
  names, see Creating Systems Manager parameters in the Amazon Web Services Systems Manager
  User Guide.  The maximum length constraint of 2048 characters listed below includes 1037
  characters reserved for internal use by Systems Manager. The maximum length for a parameter
  name that you create is 1011 characters. This includes the characters in the ARN that
  precede the name you specify, such as arn:aws:ssm:us-east-2:111122223333:parameter/.
- `value`: The parameter value that you want to add to the system. Standard parameters have
  a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.  Parameters can't be
  referenced or nested in the values of other parameters. You can't include {{}} or
  {{ssm:parameter-name}} in a parameter value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowedPattern"`: A regular expression used to validate the parameter value. For
  example, for String types with values restricted to numbers, you can specify the following:
  AllowedPattern=^d+
- `"DataType"`: The data type for a String parameter. Supported data types include plain
  text and Amazon Machine Image (AMI) IDs.  The following data type values are supported.
  text     aws:ec2:image     aws:ssm:integration    When you create a String parameter and
  specify aws:ec2:image, Amazon Web Services Systems Manager validates the parameter value is
  in the required format, such as ami-12345abcdeEXAMPLE, and that the specified AMI is
  available in your Amazon Web Services account.  If the action is successful, the service
  sends back an HTTP 200 response which indicates a successful PutParameter call for all
  cases except for data type aws:ec2:image. If you call PutParameter with aws:ec2:image data
  type, a successful HTTP 200 response does not guarantee that your parameter was
  successfully created or updated. The aws:ec2:image value is validated asynchronously, and
  the PutParameter call returns before the validation is complete. If you submit an invalid
  AMI value, the PutParameter operation will return success, but the asynchronous validation
  will fail and the parameter will not be created or updated. To monitor whether your
  aws:ec2:image parameters are created successfully, see Setting up notifications or trigger
  actions based on Parameter Store events. For more information about AMI format validation ,
  see Native parameter support for Amazon Machine Image IDs.
- `"Description"`: Information about the parameter that you want to add to the system.
  Optional but recommended.  Don't enter personally identifiable information in this field.
- `"KeyId"`: The Key Management Service (KMS) ID that you want to use to encrypt a
  parameter. Use a custom key for better security. Required for parameters that use the
  SecureString data type. If you don't specify a key ID, the system uses the default key
  associated with your Amazon Web Services account which is not as secure as using a custom
  key.   To use a custom KMS key, choose the SecureString data type with the Key ID
  parameter.
- `"Overwrite"`: Overwrite an existing parameter. The default value is false.
- `"Policies"`: One or more policies to apply to a parameter. This operation takes a JSON
  array. Parameter Store, a capability of Amazon Web Services Systems Manager supports the
  following policy types: Expiration: This policy deletes the parameter after it expires.
  When you create the policy, you specify the expiration date. You can update the expiration
  date and time by updating the policy. Updating the parameter doesn't affect the expiration
  date and time. When the expiration time is reached, Parameter Store deletes the parameter.
  ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that
  notifies you about the expiration. By using this policy, you can receive notification
  before or after the expiration time is reached, in units of days or hours.
  NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't
  been modified for a specified period of time. This policy type is useful when, for example,
  a secret needs to be changed within a period of time, but it hasn't been changed. All
  existing policies are preserved until you send new policies or an empty policy. For more
  information about parameter policies, see Assigning parameter policies.
- `"Tags"`: Optional metadata that you assign to a resource. Tags enable you to categorize
  a resource in different ways, such as by purpose, owner, or environment. For example, you
  might want to tag a Systems Manager parameter to identify the type of resource to which it
  applies, the environment, or the type of configuration data referenced by the parameter. In
  this case, you could specify the following key-value pairs:    Key=Resource,Value=S3bucket
     Key=OS,Value=Windows     Key=ParameterType,Value=LicenseKey     To add tags to an
  existing Systems Manager parameter, use the AddTagsToResource operation.
- `"Tier"`: The parameter tier to assign to a parameter. Parameter Store offers a standard
  tier and an advanced tier for parameters. Standard parameters have a content size limit of
  4 KB and can't be configured to use parameter policies. You can create a maximum of 10,000
  standard parameters for each Region in an Amazon Web Services account. Standard parameters
  are offered at no additional cost.  Advanced parameters have a content size limit of 8 KB
  and can be configured to use parameter policies. You can create a maximum of 100,000
  advanced parameters for each Region in an Amazon Web Services account. Advanced parameters
  incur a charge. For more information, see Managing parameter tiers in the Amazon Web
  Services Systems Manager User Guide. You can change a standard parameter to an advanced
  parameter any time. But you can't revert an advanced parameter to a standard parameter.
  Reverting an advanced parameter to a standard parameter would result in data loss because
  the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also
  remove any policies attached to the parameter. Lastly, advanced parameters use a different
  form of encryption than standard parameters.  If you no longer need an advanced parameter,
  or if you no longer want to incur charges for an advanced parameter, you must delete it and
  recreate it as a new standard parameter.   Using the Default Tier Configuration  In
  PutParameter requests, you can specify the tier to create the parameter in. Whenever you
  specify a tier in the request, Parameter Store creates or updates the parameter according
  to that request. However, if you don't specify a tier in a request, Parameter Store assigns
  the tier based on the current Parameter Store default tier configuration. The default tier
  when you begin using Parameter Store is the standard-parameter tier. If you use the
  advanced-parameter tier, you can specify one of the following as the default:    Advanced:
  With this option, Parameter Store evaluates all requests as advanced parameters.
  Intelligent-Tiering: With this option, Parameter Store evaluates each request to determine
  if the parameter is standard or advanced.  If the request doesn't include any options that
  require an advanced parameter, the parameter is created in the standard-parameter tier. If
  one or more options requiring an advanced parameter are included in the request, Parameter
  Store create a parameter in the advanced-parameter tier. This approach helps control your
  parameter-related costs by always creating standard parameters unless an advanced parameter
  is necessary.    Options that require an advanced parameter include the following:   The
  content size of the parameter is more than 4 KB.   The parameter uses a parameter policy.
  More than 10,000 parameters already exist in your Amazon Web Services account in the
  current Amazon Web Services Region.   For more information about configuring the default
  tier option, see Specifying a default parameter tier in the Amazon Web Services Systems
  Manager User Guide.
- `"Type"`: The type of parameter that you want to add to the system.   SecureString isn't
  currently supported for CloudFormation templates.  Items in a StringList must be separated
  by a comma (,). You can't use other punctuation or special character to escape items in the
  list. If you have a parameter value that requires a comma, then use the String data type.
  Specifying a parameter type isn't required when updating a parameter. You must specify a
  parameter type when creating a parameter.
"""
function put_parameter(Name, Value; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "PutParameter",
        Dict{String,Any}("Name" => Name, "Value" => Value);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_parameter(
    Name,
    Value,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "PutParameter",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Name" => Name, "Value" => Value), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Creates or updates a Systems Manager resource policy. A resource policy helps you to define
the IAM entity (for example, an Amazon Web Services account) that can manage your Systems
Manager resources. The following resources support Systems Manager resource policies.
OpsItemGroup - The resource policy for OpsItemGroup enables Amazon Web Services accounts to
view and interact with OpsCenter operational work items (OpsItems).    Parameter - The
resource policy is used to share a parameter with other accounts using Resource Access
Manager (RAM).  To share a parameter, it must be in the advanced parameter tier. For
information about parameter tiers, see Managing parameter tiers. For information about
changing an existing standard parameter to an advanced parameter, see Changing a standard
parameter to an advanced parameter. To share a SecureString parameter, it must be encrypted
with a customer managed key, and you must share the key separately through Key Management
Service. Amazon Web Services managed keys cannot be shared. Parameters encrypted with the
default Amazon Web Services managed key can be updated to use a customer managed key
instead. For KMS key definitions, see KMS concepts in the Key Management Service Developer
Guide.  While you can share a parameter using the Systems Manager PutResourcePolicy
operation, we recommend using Resource Access Manager (RAM) instead. This is because using
PutResourcePolicy requires the extra step of promoting the parameter to a standard RAM
Resource Share using the RAM PromoteResourceShareCreatedFromPolicy API operation.
Otherwise, the parameter won't be returned by the Systems Manager DescribeParameters API
operation using the --shared option. For more information, see Sharing a parameter in the
Amazon Web Services Systems Manager User Guide

# Arguments
- `policy`: A policy you want to associate with a resource.
- `resource_arn`: Amazon Resource Name (ARN) of the resource to which you want to attach a
  policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PolicyHash"`: ID of the current policy version. The hash helps to prevent a situation
  where multiple users attempt to overwrite a policy. You must provide this hash when
  updating or deleting a policy.
- `"PolicyId"`: The policy ID.
"""
function put_resource_policy(
    Policy, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "PutResourcePolicy",
        Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Policy,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "PutResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_default_patch_baseline(baseline_id)
    register_default_patch_baseline(baseline_id, params::Dict{String,<:Any})

Defines the default patch baseline for the relevant operating system. To reset the Amazon
Web Services-predefined patch baseline as the default, specify the full patch baseline
Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed instead of
pb-0574b43a65ea646ed.

# Arguments
- `baseline_id`: The ID of the patch baseline that should be the default patch baseline.

"""
function register_default_patch_baseline(
    BaselineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "RegisterDefaultPatchBaseline",
        Dict{String,Any}("BaselineId" => BaselineId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_default_patch_baseline(
    BaselineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "RegisterDefaultPatchBaseline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BaselineId" => BaselineId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_patch_baseline_for_patch_group(baseline_id, patch_group)
    register_patch_baseline_for_patch_group(baseline_id, patch_group, params::Dict{String,<:Any})

Registers a patch baseline for a patch group.

# Arguments
- `baseline_id`: The ID of the patch baseline to register with the patch group.
- `patch_group`: The name of the patch group to be registered with the patch baseline.

"""
function register_patch_baseline_for_patch_group(
    BaselineId, PatchGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "RegisterPatchBaselineForPatchGroup",
        Dict{String,Any}("BaselineId" => BaselineId, "PatchGroup" => PatchGroup);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_patch_baseline_for_patch_group(
    BaselineId,
    PatchGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "RegisterPatchBaselineForPatchGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("BaselineId" => BaselineId, "PatchGroup" => PatchGroup),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_target_with_maintenance_window(resource_type, targets, window_id)
    register_target_with_maintenance_window(resource_type, targets, window_id, params::Dict{String,<:Any})

Registers a target with a maintenance window.

# Arguments
- `resource_type`: The type of target being registered with the maintenance window.
- `targets`: The targets to register with the maintenance window. In other words, the
  managed nodes to run commands on when the maintenance window runs.  If a single maintenance
  window task is registered with multiple targets, its task invocations occur sequentially
  and not in parallel. If your task must run on multiple targets at the same time, register a
  task for each target individually and assign each task the same priority level.  You can
  specify targets using managed node IDs, resource group names, or tags that have been
  applied to managed nodes.  Example 1: Specify managed node IDs
  Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;
  Example 2: Use tag key-pairs applied to managed nodes
  Key=tag:&lt;my-tag-key&gt;,Values=&lt;my-tag-value-1&gt;,&lt;my-tag-value-2&gt;   Example
  3: Use tag-keys applied to managed nodes
  Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;   Example 4: Use resource
  group names  Key=resource-groups:Name,Values=&lt;resource-group-name&gt;   Example 5: Use
  filters for resource group types
  Key=resource-groups:ResourceTypeFilters,Values=&lt;resource-type-1&gt;,&lt;resource-type-2&g
  t;   For Key=resource-groups:ResourceTypeFilters, specify resource types in the following
  format  Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC
  For more information about these examples formats, including the best use case for each
  one, see Examples: Register targets with a maintenance window in the Amazon Web Services
  Systems Manager User Guide.
- `window_id`: The ID of the maintenance window the target should be registered with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: User-provided idempotency token.
- `"Description"`: An optional description for the target.
- `"Name"`: An optional name for the target.
- `"OwnerInformation"`: User-provided value that will be included in any Amazon CloudWatch
  Events events raised while running tasks for these targets in this maintenance window.
"""
function register_target_with_maintenance_window(
    ResourceType, Targets, WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "RegisterTargetWithMaintenanceWindow",
        Dict{String,Any}(
            "ResourceType" => ResourceType,
            "Targets" => Targets,
            "WindowId" => WindowId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_target_with_maintenance_window(
    ResourceType,
    Targets,
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "RegisterTargetWithMaintenanceWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceType" => ResourceType,
                    "Targets" => Targets,
                    "WindowId" => WindowId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_task_with_maintenance_window(task_arn, task_type, window_id)
    register_task_with_maintenance_window(task_arn, task_type, window_id, params::Dict{String,<:Any})

Adds a new task to a maintenance window.

# Arguments
- `task_arn`: The ARN of the task to run.
- `task_type`: The type of task being registered.
- `window_id`: The ID of the maintenance window the task should be added to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`: The CloudWatch alarm you want to apply to your maintenance window
  task.
- `"ClientToken"`: User-provided idempotency token.
- `"CutoffBehavior"`: Indicates whether tasks should continue to run after the cutoff time
  specified in the maintenance windows is reached.     CONTINUE_TASK: When the cutoff time is
  reached, any tasks that are running continue. The default value.    CANCEL_TASK:   For
  Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task
  invocations that are already running continue, but no new task invocations are started.
  For Run Command tasks: When the cutoff time is reached, the system sends a CancelCommand
  operation that attempts to cancel the command associated with the task. However, there is
  no guarantee that the command will be terminated and the underlying process stopped.   The
  status for tasks that are not completed is TIMED_OUT.
- `"Description"`: An optional description for the task.
- `"LoggingInfo"`: A structure containing information about an Amazon Simple Storage
  Service (Amazon S3) bucket to write managed node-level logs to.    LoggingInfo has been
  deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs,
  instead use the OutputS3BucketName and OutputS3KeyPrefix options in the
  TaskInvocationParameters structure. For information about how Amazon Web Services Systems
  Manager handles these options for the supported maintenance window task types, see
  MaintenanceWindowTaskInvocationParameters.
- `"MaxConcurrency"`: The maximum number of targets this task can be run for, in parallel.
  Although this element is listed as \"Required: No\", a value can be omitted only when you
  are registering or updating a targetless task You must provide a value in all other cases.
  For maintenance window tasks without a target specified, you can't supply a value for this
  option. Instead, the system inserts a placeholder value of 1. This value doesn't affect the
  running of your task.
- `"MaxErrors"`: The maximum number of errors allowed before this task stops being
  scheduled.  Although this element is listed as \"Required: No\", a value can be omitted
  only when you are registering or updating a targetless task You must provide a value in all
  other cases. For maintenance window tasks without a target specified, you can't supply a
  value for this option. Instead, the system inserts a placeholder value of 1. This value
  doesn't affect the running of your task.
- `"Name"`: An optional name for the task.
- `"Priority"`: The priority of the task in the maintenance window, the lower the number
  the higher the priority. Tasks in a maintenance window are scheduled in priority order with
  tasks that have the same priority scheduled in parallel.
- `"ServiceRoleArn"`: The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
  Services Systems Manager to assume when running a maintenance window task. If you do not
  specify a service role ARN, Systems Manager uses a service-linked role in your account. If
  no appropriate service-linked role for Systems Manager exists in your account, it is
  created when you run RegisterTaskWithMaintenanceWindow. However, for an improved security
  posture, we strongly recommend creating a custom policy and custom service role for running
  your maintenance window tasks. The policy can be crafted to provide only the permissions
  needed for your particular maintenance window tasks. For more information, see Setting up
  maintenance windows in the in the Amazon Web Services Systems Manager User Guide.
- `"Targets"`: The targets (either managed nodes or maintenance window targets).  One or
  more targets must be specified for maintenance window Run Command-type tasks. Depending on
  the task, targets are optional for other maintenance window task types (Automation, Lambda,
  and Step Functions). For more information about running tasks that don't specify targets,
  see Registering maintenance window tasks without targets in the Amazon Web Services Systems
  Manager User Guide.  Specify managed nodes using the following format:
  Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;  Specify maintenance
  window targets using the following format:
  Key=WindowTargetIds,Values=&lt;window-target-id-1&gt;,&lt;window-target-id-2&gt;
- `"TaskInvocationParameters"`: The parameters that the task should use during execution.
  Populate only the fields that match the task type. All other fields should be empty.
- `"TaskParameters"`: The parameters that should be passed to the task when it is run.
  TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
  instead use the Parameters option in the TaskInvocationParameters structure. For
  information about how Systems Manager handles these options for the supported maintenance
  window task types, see MaintenanceWindowTaskInvocationParameters.
"""
function register_task_with_maintenance_window(
    TaskArn, TaskType, WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "RegisterTaskWithMaintenanceWindow",
        Dict{String,Any}(
            "TaskArn" => TaskArn,
            "TaskType" => TaskType,
            "WindowId" => WindowId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_task_with_maintenance_window(
    TaskArn,
    TaskType,
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "RegisterTaskWithMaintenanceWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TaskArn" => TaskArn,
                    "TaskType" => TaskType,
                    "WindowId" => WindowId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_id, resource_type, tag_keys)
    remove_tags_from_resource(resource_id, resource_type, tag_keys, params::Dict{String,<:Any})

Removes tag keys from the specified resource.

# Arguments
- `resource_id`: The ID of the resource from which you want to remove tags. For example:
  ManagedInstance: mi-012345abcde MaintenanceWindow: mw-012345abcde  Automation:
  example-c160-4567-8519-012345abcde  PatchBaseline: pb-012345abcde OpsMetadata object:
  ResourceID for tagging is created from the Amazon Resource Name (ARN) for the object.
  Specifically, ResourceID is created from the strings that come after the word opsmetadata
  in the ARN. For example, an OpsMetadata object with an ARN of
  arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a ResourceID of
  either aws/ssm/MyGroup/appmanager or /aws/ssm/MyGroup/appmanager. For the Document and
  Parameter values, use the name of the resource.  The ManagedInstance type for this API
  operation is only for on-premises managed nodes. Specify the name of the managed node in
  the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.
- `resource_type`: The type of resource from which you want to remove a tag.  The
  ManagedInstance type for this API operation is only for on-premises managed nodes. Specify
  the name of the managed node in the following format: mi-ID_number . For example,
  mi-1a2b3c4d5e6f.
- `tag_keys`: Tag keys that you want to remove from the specified resource.

"""
function remove_tags_from_resource(
    ResourceId, ResourceType, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            "ResourceId" => ResourceId, "ResourceType" => ResourceType, "TagKeys" => TagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceId,
    ResourceType,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "ResourceType" => ResourceType,
                    "TagKeys" => TagKeys,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_service_setting(setting_id)
    reset_service_setting(setting_id, params::Dict{String,<:Any})

 ServiceSetting is an account-level setting for an Amazon Web Services service. This
setting defines how a user interacts with or uses a service or a feature of a service. For
example, if an Amazon Web Services service charges money to the account based on feature or
service usage, then the Amazon Web Services service team might create a default setting of
\"false\". This means the user can't use this feature unless they change the setting to
\"true\" and intentionally opt in for a paid feature. Services map a SettingId object to a
setting value. Amazon Web Services services teams define the default value for a SettingId.
You can't create a new SettingId, but you can overwrite the default value if you have the
ssm:UpdateServiceSetting permission for the setting. Use the GetServiceSetting API
operation to view the current value. Use the UpdateServiceSetting API operation to change
the default setting.  Reset the service setting for the account to the default value as
provisioned by the Amazon Web Services service team.

# Arguments
- `setting_id`: The Amazon Resource Name (ARN) of the service setting to reset. The setting
  ID can be one of the following.
  /ssm/managed-instance/default-ec2-instance-management-role
  /ssm/automation/customer-script-log-destination
  /ssm/automation/customer-script-log-group-name
  /ssm/documents/console/public-sharing-permission     /ssm/managed-instance/activation-tier
     /ssm/opsinsights/opscenter     /ssm/parameter-store/default-parameter-tier
  /ssm/parameter-store/high-throughput-enabled

"""
function reset_service_setting(
    SettingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "ResetServiceSetting",
        Dict{String,Any}("SettingId" => SettingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_service_setting(
    SettingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ResetServiceSetting",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SettingId" => SettingId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resume_session(session_id)
    resume_session(session_id, params::Dict{String,<:Any})

Reconnects a session to a managed node after it has been disconnected. Connections can be
resumed for disconnected sessions, but not terminated sessions.  This command is primarily
for use by client machines to automatically reconnect during intermittent network issues.
It isn't intended for any other use.

# Arguments
- `session_id`: The ID of the disconnected session to resume.

"""
function resume_session(SessionId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "ResumeSession",
        Dict{String,Any}("SessionId" => SessionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resume_session(
    SessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "ResumeSession",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SessionId" => SessionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_automation_signal(automation_execution_id, signal_type)
    send_automation_signal(automation_execution_id, signal_type, params::Dict{String,<:Any})

Sends a signal to an Automation execution to change the current behavior or status of the
execution.

# Arguments
- `automation_execution_id`: The unique identifier for an existing Automation execution
  that you want to send the signal to.
- `signal_type`: The type of signal to send to an Automation execution.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Payload"`: The data sent with the signal. The data schema depends on the type of signal
  used in the request. For Approve and Reject signal types, the payload is an optional
  comment that you can send with the signal type. For example:  Comment=\"Looks good\"  For
  StartStep and Resume signal types, you must send the name of the Automation step to start
  or resume as the payload. For example:  StepName=\"step1\"  For the StopStep signal type,
  you must send the step execution ID as the payload. For example:
  StepExecutionId=\"97fff367-fc5a-4299-aed8-0123456789ab\"
"""
function send_automation_signal(
    AutomationExecutionId, SignalType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "SendAutomationSignal",
        Dict{String,Any}(
            "AutomationExecutionId" => AutomationExecutionId, "SignalType" => SignalType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_automation_signal(
    AutomationExecutionId,
    SignalType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "SendAutomationSignal",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AutomationExecutionId" => AutomationExecutionId,
                    "SignalType" => SignalType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_command(document_name)
    send_command(document_name, params::Dict{String,<:Any})

Runs commands on one or more managed nodes.

# Arguments
- `document_name`: The name of the Amazon Web Services Systems Manager document (SSM
  document) to run. This can be a public document or a custom document. To run a shared
  document belonging to another account, specify the document Amazon Resource Name (ARN). For
  more information about how to use shared documents, see Sharing SSM documents in the Amazon
  Web Services Systems Manager User Guide.  If you specify a document name or ARN that hasn't
  been shared with your account, you receive an InvalidDocument error.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`: The CloudWatch alarm you want to apply to your command.
- `"CloudWatchOutputConfig"`: Enables Amazon Web Services Systems Manager to send Run
  Command output to Amazon CloudWatch Logs. Run Command is a capability of Amazon Web
  Services Systems Manager.
- `"Comment"`: User-specified information about the command, such as a brief description of
  what the command should do.
- `"DocumentHash"`: The Sha256 or Sha1 hash created by the system when the document was
  created.   Sha1 hashes have been deprecated.
- `"DocumentHashType"`: Sha256 or Sha1.  Sha1 hashes have been deprecated.
- `"DocumentVersion"`: The SSM document version to use in the request. You can specify
  DEFAULT, LATEST, or a specific version number. If you run commands by using the Command
  Line Interface (Amazon Web Services CLI), then you must escape the first two options by
  using a backslash. If you specify a version number, then you don't need to use the
  backslash. For example: --document-version \"DEFAULT\" --document-version \"LATEST\"
  --document-version \"3\"
- `"InstanceIds"`: The IDs of the managed nodes where the command should run. Specifying
  managed node IDs is most useful when you are targeting a limited number of managed nodes,
  though you can specify up to 50 IDs. To target a larger number of managed nodes, or if you
  prefer not to list individual node IDs, we recommend using the Targets option instead.
  Using Targets, which accepts tag key-value pairs to identify the managed nodes to send
  commands to, you can a send command to tens, hundreds, or thousands of nodes at once. For
  more information about how to use targets, see Run commands at scale in the Amazon Web
  Services Systems Manager User Guide.
- `"MaxConcurrency"`: (Optional) The maximum number of managed nodes that are allowed to
  run the command at the same time. You can specify a number such as 10 or a percentage such
  as 10%. The default value is 50. For more information about how to use MaxConcurrency, see
  Using concurrency controls in the Amazon Web Services Systems Manager User Guide.
- `"MaxErrors"`: The maximum number of errors allowed without the command failing. When the
  command fails one more time beyond the value of MaxErrors, the systems stops sending the
  command to additional targets. You can specify a number like 10 or a percentage like 10%.
  The default value is 0. For more information about how to use MaxErrors, see Using error
  controls in the Amazon Web Services Systems Manager User Guide.
- `"NotificationConfig"`: Configurations for sending notifications.
- `"OutputS3BucketName"`: The name of the S3 bucket where command execution responses
  should be stored.
- `"OutputS3KeyPrefix"`: The directory structure within the S3 bucket where the responses
  should be stored.
- `"OutputS3Region"`: (Deprecated) You can no longer specify this parameter. The system
  ignores it. Instead, Systems Manager automatically determines the Amazon Web Services
  Region of the S3 bucket.
- `"Parameters"`: The required and optional parameters specified in the document being run.
- `"ServiceRoleArn"`: The ARN of the Identity and Access Management (IAM) service role to
  use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run
  Command commands. This role must provide the sns:Publish permission for your notification
  topic. For information about creating and using this service role, see Monitoring Systems
  Manager status changes using Amazon SNS notifications in the Amazon Web Services Systems
  Manager User Guide.
- `"Targets"`: An array of search criteria that targets managed nodes using a Key,Value
  combination that you specify. Specifying targets is most useful when you want to send a
  command to a large number of managed nodes at once. Using Targets, which accepts tag
  key-value pairs to identify managed nodes, you can send a command to tens, hundreds, or
  thousands of nodes at once. To send a command to a smaller number of managed nodes, you can
  use the InstanceIds option instead. For more information about how to use targets, see Run
  commands at scale in the Amazon Web Services Systems Manager User Guide.
- `"TimeoutSeconds"`: If this time is reached and the command hasn't already started
  running, it won't run.
"""
function send_command(DocumentName; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "SendCommand",
        Dict{String,Any}("DocumentName" => DocumentName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_command(
    DocumentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "SendCommand",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DocumentName" => DocumentName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_associations_once(association_ids)
    start_associations_once(association_ids, params::Dict{String,<:Any})

Runs an association immediately and only one time. This operation can be helpful when
troubleshooting associations.

# Arguments
- `association_ids`: The association IDs that you want to run immediately and only one time.

"""
function start_associations_once(
    AssociationIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "StartAssociationsOnce",
        Dict{String,Any}("AssociationIds" => AssociationIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_associations_once(
    AssociationIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "StartAssociationsOnce",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AssociationIds" => AssociationIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_automation_execution(document_name)
    start_automation_execution(document_name, params::Dict{String,<:Any})

Initiates execution of an Automation runbook.

# Arguments
- `document_name`: The name of the SSM document to run. This can be a public document or a
  custom document. To run a shared document belonging to another account, specify the
  document ARN. For more information about how to use shared documents, see Sharing SSM
  documents in the Amazon Web Services Systems Manager User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`: The CloudWatch alarm you want to apply to your automation.
- `"ClientToken"`: User-provided idempotency token. The token must be unique, is case
  insensitive, enforces the UUID format, and can't be reused.
- `"DocumentVersion"`: The version of the Automation runbook to use for this execution.
- `"MaxConcurrency"`: The maximum number of targets allowed to run this task in parallel.
  You can specify a number, such as 10, or a percentage, such as 10%. The default value is 10.
- `"MaxErrors"`: The number of errors that are allowed before the system stops running the
  automation on additional targets. You can specify either an absolute number of errors, for
  example 10, or a percentage of the target set, for example 10%. If you specify 3, for
  example, the system stops running the automation when the fourth error is received. If you
  specify 0, then the system stops running the automation on additional targets after the
  first error result is returned. If you run an automation on 50 resources and set max-errors
  to 10%, then the system stops running the automation on additional targets when the sixth
  error is received. Executions that are already running an automation when max-errors is
  reached are allowed to complete, but some of these executions may fail as well. If you need
  to ensure that there won't be more than max-errors failed executions, set max-concurrency
  to 1 so the executions proceed one at a time.
- `"Mode"`: The execution mode of the automation. Valid modes include the following: Auto
  and Interactive. The default mode is Auto.
- `"Parameters"`: A key-value map of execution parameters, which match the declared
  parameters in the Automation runbook.
- `"Tags"`: Optional metadata that you assign to a resource. You can specify a maximum of
  five tags for an automation. Tags enable you to categorize a resource in different ways,
  such as by purpose, owner, or environment. For example, you might want to tag an automation
  to identify an environment or operating system. In this case, you could specify the
  following key-value pairs:    Key=environment,Value=test     Key=OS,Value=Windows     To
  add tags to an existing automation, use the AddTagsToResource operation.
- `"TargetLocations"`: A location is a combination of Amazon Web Services Regions and/or
  Amazon Web Services accounts where you want to run the automation. Use this operation to
  start an automation in multiple Amazon Web Services Regions and multiple Amazon Web
  Services accounts. For more information, see Running Automation workflows in multiple
  Amazon Web Services Regions and Amazon Web Services accounts in the Amazon Web Services
  Systems Manager User Guide.
- `"TargetMaps"`: A key-value mapping of document parameters to target resources. Both
  Targets and TargetMaps can't be specified together.
- `"TargetParameterName"`: The name of the parameter used as the target resource for the
  rate-controlled execution. Required if you specify targets.
- `"Targets"`: A key-value mapping to target resources. Required if you specify
  TargetParameterName.
"""
function start_automation_execution(
    DocumentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "StartAutomationExecution",
        Dict{String,Any}("DocumentName" => DocumentName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_automation_execution(
    DocumentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "StartAutomationExecution",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DocumentName" => DocumentName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_change_request_execution(document_name, runbooks)
    start_change_request_execution(document_name, runbooks, params::Dict{String,<:Any})

Creates a change request for Change Manager. The Automation runbooks specified in the
change request run only after all required approvals for the change request have been
received.

# Arguments
- `document_name`: The name of the change template document to run during the runbook
  workflow.
- `runbooks`: Information about the Automation runbooks that are run during the runbook
  workflow.  The Automation runbooks specified for the runbook workflow can't run until all
  required approvals for the change request have been received.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoApprove"`: Indicates whether the change request can be approved automatically
  without the need for manual approvals. If AutoApprovable is enabled in a change template,
  then setting AutoApprove to true in StartChangeRequestExecution creates a change request
  that bypasses approver review.  Change Calendar restrictions are not bypassed in this
  scenario. If the state of an associated calendar is CLOSED, change freeze approvers must
  still grant permission for this change request to run. If they don't, the change won't be
  processed until the calendar state is again OPEN.
- `"ChangeDetails"`: User-provided details about the change. If no details are provided,
  content specified in the Template information section of the associated change template is
  added.
- `"ChangeRequestName"`: The name of the change request associated with the runbook
  workflow to be run.
- `"ClientToken"`: The user-provided idempotency token. The token must be unique, is case
  insensitive, enforces the UUID format, and can't be reused.
- `"DocumentVersion"`: The version of the change template document to run during the
  runbook workflow.
- `"Parameters"`: A key-value map of parameters that match the declared parameters in the
  change template document.
- `"ScheduledEndTime"`: The time that the requester expects the runbook workflow related to
  the change request to complete. The time is an estimate only that the requester provides
  for reviewers.
- `"ScheduledTime"`: The date and time specified in the change request to run the
  Automation runbooks.  The Automation runbooks specified for the runbook workflow can't run
  until all required approvals for the change request have been received.
- `"Tags"`: Optional metadata that you assign to a resource. You can specify a maximum of
  five tags for a change request. Tags enable you to categorize a resource in different ways,
  such as by purpose, owner, or environment. For example, you might want to tag a change
  request to identify an environment or target Amazon Web Services Region. In this case, you
  could specify the following key-value pairs:    Key=Environment,Value=Production
  Key=Region,Value=us-east-2
"""
function start_change_request_execution(
    DocumentName, Runbooks; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "StartChangeRequestExecution",
        Dict{String,Any}("DocumentName" => DocumentName, "Runbooks" => Runbooks);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_change_request_execution(
    DocumentName,
    Runbooks,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "StartChangeRequestExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DocumentName" => DocumentName, "Runbooks" => Runbooks),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_session(target)
    start_session(target, params::Dict{String,<:Any})

Initiates a connection to a target (for example, a managed node) for a Session Manager
session. Returns a URL and token that can be used to open a WebSocket connection for
sending input and receiving outputs.  Amazon Web Services CLI usage: start-session is an
interactive command that requires the Session Manager plugin to be installed on the client
machine making the call. For information, see Install the Session Manager plugin for the
Amazon Web Services CLI in the Amazon Web Services Systems Manager User Guide. Amazon Web
Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon
Web Services Tools for PowerShell on Windows local machines.

# Arguments
- `target`: The managed node to connect to for the session.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentName"`: The name of the SSM document you want to use to define the type of
  session, input parameters, or preferences for the session. For example,
  SSM-SessionManagerRunShell. You can call the GetDocument API to verify the document exists
  before attempting to start a session. If no document name is provided, a shell to the
  managed node is launched by default. For more information, see Start a session in the
  Amazon Web Services Systems Manager User Guide.
- `"Parameters"`: The values you want to specify for the parameters defined in the Session
  document.
- `"Reason"`: The reason for connecting to the instance. This value is included in the
  details for the Amazon CloudWatch Events event created when you start the session.
"""
function start_session(Target; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "StartSession",
        Dict{String,Any}("Target" => Target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_session(
    Target, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "StartSession",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Target" => Target), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_automation_execution(automation_execution_id)
    stop_automation_execution(automation_execution_id, params::Dict{String,<:Any})

Stop an Automation that is currently running.

# Arguments
- `automation_execution_id`: The execution ID of the Automation to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Type"`: The stop request type. Valid types include the following: Cancel and Complete.
  The default type is Cancel.
"""
function stop_automation_execution(
    AutomationExecutionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "StopAutomationExecution",
        Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_automation_execution(
    AutomationExecutionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "StopAutomationExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AutomationExecutionId" => AutomationExecutionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_session(session_id)
    terminate_session(session_id, params::Dict{String,<:Any})

Permanently ends a session and closes the data connection between the Session Manager
client and SSM Agent on the managed node. A terminated session can't be resumed.

# Arguments
- `session_id`: The ID of the session to terminate.

"""
function terminate_session(SessionId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "TerminateSession",
        Dict{String,Any}("SessionId" => SessionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_session(
    SessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "TerminateSession",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SessionId" => SessionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unlabel_parameter_version(labels, name, parameter_version)
    unlabel_parameter_version(labels, name, parameter_version, params::Dict{String,<:Any})

Remove a label or labels from a parameter.

# Arguments
- `labels`: One or more labels to delete from the specified parameter version.
- `name`: The name of the parameter from which you want to delete one or more labels.  You
  can't enter the Amazon Resource Name (ARN) for a parameter, only the parameter name itself.
- `parameter_version`: The specific version of the parameter which you want to delete one
  or more labels from. If it isn't present, the call will fail.

"""
function unlabel_parameter_version(
    Labels, Name, ParameterVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UnlabelParameterVersion",
        Dict{String,Any}(
            "Labels" => Labels, "Name" => Name, "ParameterVersion" => ParameterVersion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unlabel_parameter_version(
    Labels,
    Name,
    ParameterVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UnlabelParameterVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Labels" => Labels,
                    "Name" => Name,
                    "ParameterVersion" => ParameterVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_association(association_id)
    update_association(association_id, params::Dict{String,<:Any})

Updates an association. You can update the association name and version, the document
version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When
you call UpdateAssociation, the system removes all optional parameters from the request and
overwrites the association with null values for those parameters. This is by design. You
must specify all optional parameters in the call, even if you are not changing the
parameters. This includes the Name parameter. Before calling this API action, we recommend
that you call the DescribeAssociation API operation and make a note of all optional
parameters required for your UpdateAssociation call. In order to call this API operation, a
user, group, or role must be granted permission to call the DescribeAssociation API
operation. If you don't have permission to call DescribeAssociation, then you receive the
following error: An error occurred (AccessDeniedException) when calling the
UpdateAssociation operation: User: &lt;user_arn&gt; isn't authorized to perform:
ssm:DescribeAssociation on resource: &lt;resource_arn&gt;   When you update an association,
the association immediately runs against the specified targets. You can add the
ApplyOnlyAtCronInterval parameter to run the association during the next schedule run.

# Arguments
- `association_id`: The ID of the association you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`:
- `"ApplyOnlyAtCronInterval"`: By default, when you update an association, the system runs
  it immediately after it is updated and then according to the schedule you specified.
  Specify this option if you don't want an association to run immediately after you update
  it. This parameter isn't supported for rate expressions. If you chose this option when you
  created an association and later you edit that association or you make changes to the SSM
  document on which that association is based (by using the Documents page in the console),
  State Manager applies the association at the next specified cron interval. For example, if
  you chose the Latest version of an SSM document when you created an association and you
  edit the association by choosing a different document version on the Documents page, State
  Manager applies the association at the next specified cron interval if you previously
  selected this option. If this option wasn't selected, State Manager immediately runs the
  association. You can reset this option. To do so, specify the
  no-apply-only-at-cron-interval parameter when you update the association from the command
  line. This parameter forces the association to run immediately after updating it and
  according to the interval specified.
- `"AssociationName"`: The name of the association that you want to update.
- `"AssociationVersion"`: This parameter is provided for concurrency control purposes. You
  must specify the latest association version in the service. If you want to ensure that this
  request succeeds, either specify LATEST, or omit this parameter.
- `"AutomationTargetParameterName"`: Choose the parameter that will define how your
  automation will branch out. This target is required for associations that use an Automation
  runbook and target resources by using rate controls. Automation is a capability of Amazon
  Web Services Systems Manager.
- `"CalendarNames"`: The names or Amazon Resource Names (ARNs) of the Change Calendar type
  documents you want to gate your associations under. The associations only run when that
  change calendar is open. For more information, see Amazon Web Services Systems Manager
  Change Calendar.
- `"ComplianceSeverity"`: The severity level to assign to the association.
- `"DocumentVersion"`: The document version you want update for the association.   State
  Manager doesn't support running associations that use a new version of a document if that
  document is shared from another account. State Manager always runs the default version of a
  document if shared from another account, even though the Systems Manager console shows that
  a new version was processed. If you want to run an association using a new version of a
  document shared form another account, you must set the document version to default.
- `"Duration"`: The number of hours the association can run before it is canceled. Duration
  applies to associations that are currently running, and any pending and in progress
  commands on all targets. If a target was taken offline for the association to run, it is
  made available again immediately, without a reboot.  The Duration parameter applies only
  when both these conditions are true:   The association for which you specify a duration is
  cancelable according to the parameters of the SSM command document or Automation runbook
  associated with this execution.    The command specifies the  ApplyOnlyAtCronInterval
  parameter, which means that the association doesn't run immediately after it is updated,
  but only according to the specified schedule.
- `"MaxConcurrency"`: The maximum number of targets allowed to run the association at the
  same time. You can specify a number, for example 10, or a percentage of the target set, for
  example 10%. The default value is 100%, which means all targets run the association at the
  same time. If a new managed node starts and attempts to run an association while Systems
  Manager is running MaxConcurrency associations, the association is allowed to run. During
  the next association interval, the new managed node will process its association within the
  limit specified for MaxConcurrency.
- `"MaxErrors"`: The number of errors that are allowed before the system stops sending
  requests to run the association on additional targets. You can specify either an absolute
  number of errors, for example 10, or a percentage of the target set, for example 10%. If
  you specify 3, for example, the system stops sending requests when the fourth error is
  received. If you specify 0, then the system stops sending requests after the first error is
  returned. If you run an association on 50 managed nodes and set MaxError to 10%, then the
  system stops sending the request when the sixth error is received. Executions that are
  already running an association when MaxErrors is reached are allowed to complete, but some
  of these executions may fail as well. If you need to ensure that there won't be more than
  max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a
  time.
- `"Name"`: The name of the SSM Command document or Automation runbook that contains the
  configuration information for the managed node. You can specify Amazon Web
  Services-predefined documents, documents you created, or a document that is shared with you
  from another account. For Systems Manager document (SSM document) that are shared with you
  from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in
  the following format:  arn:aws:ssm:region:account-id:document/document-name   For example:
  arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document  For Amazon Web
  Services-predefined documents and SSM documents you created in your account, you only need
  to specify the document name. For example, AWS-ApplyPatchBaseline or My-Document.
- `"OutputLocation"`: An S3 bucket where you want to store the results of this request.
- `"Parameters"`: The parameters you want to update for the association. If you create a
  parameter using Parameter Store, a capability of Amazon Web Services Systems Manager, you
  can reference the parameter using {{ssm:parameter-name}}.
- `"ScheduleExpression"`: The cron expression used to schedule the association that you
  want to update.
- `"ScheduleOffset"`: Number of days to wait after the scheduled day to run an association.
  For example, if you specified a cron schedule of cron(0 0 ? * THU#2 *), you could specify
  an offset of 3 to run the association each Sunday after the second Thursday of the month.
  For more information about cron schedules for associations, see Reference: Cron and rate
  expressions for Systems Manager in the Amazon Web Services Systems Manager User Guide.   To
  use offsets, you must specify the ApplyOnlyAtCronInterval parameter. This option tells the
  system not to run an association immediately after you create it.
- `"SyncCompliance"`: The mode for generating association compliance. You can specify AUTO
  or MANUAL. In AUTO mode, the system uses the status of the association execution to
  determine the compliance status. If the association execution runs successfully, then the
  association is COMPLIANT. If the association execution doesn't run successfully, the
  association is NON-COMPLIANT. In MANUAL mode, you must specify the AssociationId as a
  parameter for the PutComplianceItems API operation. In this case, compliance data isn't
  managed by State Manager, a capability of Amazon Web Services Systems Manager. It is
  managed by your direct call to the PutComplianceItems API operation. By default, all
  associations use AUTO mode.
- `"TargetLocations"`: A location is a combination of Amazon Web Services Regions and
  Amazon Web Services accounts where you want to run the association. Use this action to
  update an association in multiple Regions and multiple accounts.
- `"TargetMaps"`: A key-value mapping of document parameters to target resources. Both
  Targets and TargetMaps can't be specified together.
- `"Targets"`: The targets of the association.
"""
function update_association(
    AssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateAssociation",
        Dict{String,Any}("AssociationId" => AssociationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_association(
    AssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateAssociation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AssociationId" => AssociationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_association_status(association_status, instance_id, name)
    update_association_status(association_status, instance_id, name, params::Dict{String,<:Any})

Updates the status of the Amazon Web Services Systems Manager document (SSM document)
associated with the specified managed node.  UpdateAssociationStatus is primarily used by
the Amazon Web Services Systems Manager Agent (SSM Agent) to report status updates about
your associations and is only used for associations created with the InstanceId legacy
parameter.

# Arguments
- `association_status`: The association status.
- `instance_id`: The managed node ID.
- `name`: The name of the SSM document.

"""
function update_association_status(
    AssociationStatus, InstanceId, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateAssociationStatus",
        Dict{String,Any}(
            "AssociationStatus" => AssociationStatus,
            "InstanceId" => InstanceId,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_association_status(
    AssociationStatus,
    InstanceId,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateAssociationStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationStatus" => AssociationStatus,
                    "InstanceId" => InstanceId,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_document(content, name)
    update_document(content, name, params::Dict{String,<:Any})

Updates one or more values for an SSM document.

# Arguments
- `content`: A valid JSON or YAML string.
- `name`: The name of the SSM document that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attachments"`: A list of key-value pairs that describe attachments to a version of a
  document.
- `"DisplayName"`: The friendly name of the SSM document that you want to update. This
  value can differ for each version of the document. If you don't specify a value for this
  parameter in your request, the existing value is applied to the new document version.
- `"DocumentFormat"`: Specify the document format for the new document version. Systems
  Manager supports JSON and YAML documents. JSON is the default format.
- `"DocumentVersion"`: The version of the document that you want to update. Currently,
  Systems Manager supports updating only the latest version of the document. You can specify
  the version number of the latest version or use the LATEST variable.  If you change a
  document version for a State Manager association, Systems Manager immediately runs the
  association unless you previously specifed the apply-only-at-cron-interval parameter.
- `"TargetType"`: Specify a new target type for the document.
- `"VersionName"`: An optional field specifying the version of the artifact you are
  updating with the document. For example, 12.6. This value is unique across all versions of
  a document, and can't be changed.
"""
function update_document(Content, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "UpdateDocument",
        Dict{String,Any}("Content" => Content, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_document(
    Content,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateDocument",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Content" => Content, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_document_default_version(document_version, name)
    update_document_default_version(document_version, name, params::Dict{String,<:Any})

Set the default version of a document.   If you change a document version for a State
Manager association, Systems Manager immediately runs the association unless you previously
specifed the apply-only-at-cron-interval parameter.

# Arguments
- `document_version`: The version of a custom document that you want to set as the default
  version.
- `name`: The name of a custom document that you want to set as the default version.

"""
function update_document_default_version(
    DocumentVersion, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateDocumentDefaultVersion",
        Dict{String,Any}("DocumentVersion" => DocumentVersion, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_document_default_version(
    DocumentVersion,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateDocumentDefaultVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DocumentVersion" => DocumentVersion, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_document_metadata(document_reviews, name)
    update_document_metadata(document_reviews, name, params::Dict{String,<:Any})

Updates information related to approval reviews for a specific version of a change template
in Change Manager.

# Arguments
- `document_reviews`: The change template review details to update.
- `name`: The name of the change template for which a version's metadata is to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DocumentVersion"`: The version of a change template in which to update approval
  metadata.
"""
function update_document_metadata(
    DocumentReviews, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateDocumentMetadata",
        Dict{String,Any}("DocumentReviews" => DocumentReviews, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_document_metadata(
    DocumentReviews,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateDocumentMetadata",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DocumentReviews" => DocumentReviews, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_maintenance_window(window_id)
    update_maintenance_window(window_id, params::Dict{String,<:Any})

Updates an existing maintenance window. Only specified parameters are modified.  The value
you specify for Duration determines the specific end time for the maintenance window based
on the time it begins. No maintenance window tasks are permitted to start after the
resulting endtime minus the number of hours you specify for Cutoff. For example, if the
maintenance window starts at 3 PM, the duration is three hours, and the value you specify
for Cutoff is one hour, no maintenance window tasks can start after 5 PM.

# Arguments
- `window_id`: The ID of the maintenance window to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowUnassociatedTargets"`: Whether targets must be registered with the maintenance
  window before tasks can be defined for those targets.
- `"Cutoff"`: The number of hours before the end of the maintenance window that Amazon Web
  Services Systems Manager stops scheduling new tasks for execution.
- `"Description"`: An optional description for the update request.
- `"Duration"`: The duration of the maintenance window in hours.
- `"Enabled"`: Whether the maintenance window is enabled.
- `"EndDate"`: The date and time, in ISO-8601 Extended format, for when you want the
  maintenance window to become inactive. EndDate allows you to set a date and time in the
  future when the maintenance window will no longer run.
- `"Name"`: The name of the maintenance window.
- `"Replace"`: If True, then all fields that are required by the CreateMaintenanceWindow
  operation are also required for this API request. Optional fields that aren't specified are
  set to null.
- `"Schedule"`: The schedule of the maintenance window in the form of a cron or rate
  expression.
- `"ScheduleOffset"`: The number of days to wait after the date and time specified by a
  cron expression before running the maintenance window. For example, the following cron
  expression schedules a maintenance window to run the third Tuesday of every month at 11:30
  PM.  cron(30 23 ? * TUE#3 *)  If the schedule offset is 2, the maintenance window won't run
  until two days later.
- `"ScheduleTimezone"`: The time zone that the scheduled maintenance window executions are
  based on, in Internet Assigned Numbers Authority (IANA) format. For example:
  \"America/Los_Angeles\", \"UTC\", or \"Asia/Seoul\". For more information, see the Time
  Zone Database on the IANA website.
- `"StartDate"`: The date and time, in ISO-8601 Extended format, for when you want the
  maintenance window to become active. StartDate allows you to delay activation of the
  maintenance window until the specified future date.  When using a rate schedule, if you
  provide a start date that occurs in the past, the current date and time are used as the
  start date.
"""
function update_maintenance_window(
    WindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateMaintenanceWindow",
        Dict{String,Any}("WindowId" => WindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_maintenance_window(
    WindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateMaintenanceWindow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WindowId" => WindowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_maintenance_window_target(window_id, window_target_id)
    update_maintenance_window_target(window_id, window_target_id, params::Dict{String,<:Any})

Modifies the target of an existing maintenance window. You can change the following:   Name
  Description   Owner   IDs for an ID target   Tags for a Tag target   From any supported
tag type to another. The three supported tag types are ID target, Tag target, and resource
group. For more information, see Target.    If a parameter is null, then the corresponding
field isn't modified.

# Arguments
- `window_id`: The maintenance window ID with which to modify the target.
- `window_target_id`: The target ID to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description for the update.
- `"Name"`: A name for the update.
- `"OwnerInformation"`: User-provided value that will be included in any Amazon CloudWatch
  Events events raised while running tasks for these targets in this maintenance window.
- `"Replace"`: If True, then all fields that are required by the
  RegisterTargetWithMaintenanceWindow operation are also required for this API request.
  Optional fields that aren't specified are set to null.
- `"Targets"`: The targets to add or replace.
"""
function update_maintenance_window_target(
    WindowId, WindowTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateMaintenanceWindowTarget",
        Dict{String,Any}("WindowId" => WindowId, "WindowTargetId" => WindowTargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_maintenance_window_target(
    WindowId,
    WindowTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateMaintenanceWindowTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "WindowId" => WindowId, "WindowTargetId" => WindowTargetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_maintenance_window_task(window_id, window_task_id)
    update_maintenance_window_task(window_id, window_task_id, params::Dict{String,<:Any})

Modifies a task assigned to a maintenance window. You can't change the task type, but you
can change the following values:    TaskARN. For example, you can change a RUN_COMMAND task
from AWS-RunPowerShellScript to AWS-RunShellScript.    ServiceRoleArn
TaskInvocationParameters     Priority     MaxConcurrency     MaxErrors     One or more
targets must be specified for maintenance window Run Command-type tasks. Depending on the
task, targets are optional for other maintenance window task types (Automation, Lambda, and
Step Functions). For more information about running tasks that don't specify targets, see
Registering maintenance window tasks without targets in the Amazon Web Services Systems
Manager User Guide.  If the value for a parameter in UpdateMaintenanceWindowTask is null,
then the corresponding field isn't modified. If you set Replace to true, then all fields
required by the RegisterTaskWithMaintenanceWindow operation are required for this request.
Optional fields that aren't specified are set to null.  When you update a maintenance
window task that has options specified in TaskInvocationParameters, you must provide again
all the TaskInvocationParameters values that you want to retain. The values you don't
specify again are removed. For example, suppose that when you registered a Run Command
task, you specified TaskInvocationParameters values for Comment, NotificationConfig, and
OutputS3BucketName. If you update the maintenance window task and specify only a different
OutputS3BucketName value, the values for Comment and NotificationConfig are removed.

# Arguments
- `window_id`: The maintenance window ID that contains the task to modify.
- `window_task_id`: The task ID to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlarmConfiguration"`: The CloudWatch alarm you want to apply to your maintenance window
  task.
- `"CutoffBehavior"`: Indicates whether tasks should continue to run after the cutoff time
  specified in the maintenance windows is reached.     CONTINUE_TASK: When the cutoff time is
  reached, any tasks that are running continue. The default value.    CANCEL_TASK:   For
  Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task
  invocations that are already running continue, but no new task invocations are started.
  For Run Command tasks: When the cutoff time is reached, the system sends a CancelCommand
  operation that attempts to cancel the command associated with the task. However, there is
  no guarantee that the command will be terminated and the underlying process stopped.   The
  status for tasks that are not completed is TIMED_OUT.
- `"Description"`: The new task description to specify.
- `"LoggingInfo"`: The new logging location in Amazon S3 to specify.   LoggingInfo has been
  deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs,
  instead use the OutputS3BucketName and OutputS3KeyPrefix options in the
  TaskInvocationParameters structure. For information about how Amazon Web Services Systems
  Manager handles these options for the supported maintenance window task types, see
  MaintenanceWindowTaskInvocationParameters.
- `"MaxConcurrency"`: The new MaxConcurrency value you want to specify. MaxConcurrency is
  the number of targets that are allowed to run this task, in parallel.  Although this
  element is listed as \"Required: No\", a value can be omitted only when you are registering
  or updating a targetless task You must provide a value in all other cases. For maintenance
  window tasks without a target specified, you can't supply a value for this option. Instead,
  the system inserts a placeholder value of 1. This value doesn't affect the running of your
  task.
- `"MaxErrors"`: The new MaxErrors value to specify. MaxErrors is the maximum number of
  errors that are allowed before the task stops being scheduled.  Although this element is
  listed as \"Required: No\", a value can be omitted only when you are registering or
  updating a targetless task You must provide a value in all other cases. For maintenance
  window tasks without a target specified, you can't supply a value for this option. Instead,
  the system inserts a placeholder value of 1. This value doesn't affect the running of your
  task.
- `"Name"`: The new task name to specify.
- `"Priority"`: The new task priority to specify. The lower the number, the higher the
  priority. Tasks that have the same priority are scheduled in parallel.
- `"Replace"`: If True, then all fields that are required by the
  RegisterTaskWithMaintenanceWindow operation are also required for this API request.
  Optional fields that aren't specified are set to null.
- `"ServiceRoleArn"`: The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
  Services Systems Manager to assume when running a maintenance window task. If you do not
  specify a service role ARN, Systems Manager uses a service-linked role in your account. If
  no appropriate service-linked role for Systems Manager exists in your account, it is
  created when you run RegisterTaskWithMaintenanceWindow. However, for an improved security
  posture, we strongly recommend creating a custom policy and custom service role for running
  your maintenance window tasks. The policy can be crafted to provide only the permissions
  needed for your particular maintenance window tasks. For more information, see Setting up
  maintenance windows in the in the Amazon Web Services Systems Manager User Guide.
- `"Targets"`: The targets (either managed nodes or tags) to modify. Managed nodes are
  specified using the format Key=instanceids,Values=instanceID_1,instanceID_2. Tags are
  specified using the format  Key=tag_name,Values=tag_value.   One or more targets must be
  specified for maintenance window Run Command-type tasks. Depending on the task, targets are
  optional for other maintenance window task types (Automation, Lambda, and Step Functions).
  For more information about running tasks that don't specify targets, see Registering
  maintenance window tasks without targets in the Amazon Web Services Systems Manager User
  Guide.
- `"TaskArn"`: The task ARN to modify.
- `"TaskInvocationParameters"`: The parameters that the task should use during execution.
  Populate only the fields that match the task type. All other fields should be empty.  When
  you update a maintenance window task that has options specified in
  TaskInvocationParameters, you must provide again all the TaskInvocationParameters values
  that you want to retain. The values you don't specify again are removed. For example,
  suppose that when you registered a Run Command task, you specified TaskInvocationParameters
  values for Comment, NotificationConfig, and OutputS3BucketName. If you update the
  maintenance window task and specify only a different OutputS3BucketName value, the values
  for Comment and NotificationConfig are removed.
- `"TaskParameters"`: The parameters to modify.   TaskParameters has been deprecated. To
  specify parameters to pass to a task when it runs, instead use the Parameters option in the
  TaskInvocationParameters structure. For information about how Systems Manager handles these
  options for the supported maintenance window task types, see
  MaintenanceWindowTaskInvocationParameters.  The map has the following format: Key: string,
  between 1 and 255 characters Value: an array of strings, each string is between 1 and 255
  characters
"""
function update_maintenance_window_task(
    WindowId, WindowTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateMaintenanceWindowTask",
        Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_maintenance_window_task(
    WindowId,
    WindowTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateMaintenanceWindowTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WindowId" => WindowId, "WindowTaskId" => WindowTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_managed_instance_role(iam_role, instance_id)
    update_managed_instance_role(iam_role, instance_id, params::Dict{String,<:Any})

Changes the Identity and Access Management (IAM) role that is assigned to the on-premises
server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid
nodes during the activation process. For more information, see CreateActivation.

# Arguments
- `iam_role`: The name of the Identity and Access Management (IAM) role that you want to
  assign to the managed node. This IAM role must provide AssumeRole permissions for the
  Amazon Web Services Systems Manager service principal ssm.amazonaws.com. For more
  information, see Create an IAM service role for a hybrid and multicloud environment in the
  Amazon Web Services Systems Manager User Guide.  You can't specify an IAM service-linked
  role for this parameter. You must create a unique role.
- `instance_id`: The ID of the managed node where you want to update the role.

"""
function update_managed_instance_role(
    IamRole, InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateManagedInstanceRole",
        Dict{String,Any}("IamRole" => IamRole, "InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_managed_instance_role(
    IamRole,
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateManagedInstanceRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IamRole" => IamRole, "InstanceId" => InstanceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ops_item(ops_item_id)
    update_ops_item(ops_item_id, params::Dict{String,<:Any})

Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM)
to update an OpsItem. For more information, see Set up OpsCenter in the Amazon Web Services
Systems Manager User Guide. Operations engineers and IT professionals use Amazon Web
Services Systems Manager OpsCenter to view, investigate, and remediate operational issues
impacting the performance and health of their Amazon Web Services resources. For more
information, see Amazon Web Services Systems Manager OpsCenter in the Amazon Web Services
Systems Manager User Guide.

# Arguments
- `ops_item_id`: The ID of the OpsItem.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ActualEndTime"`: The time a runbook workflow ended. Currently reported only for the
  OpsItem type /aws/changerequest.
- `"ActualStartTime"`: The time a runbook workflow started. Currently reported only for the
  OpsItem type /aws/changerequest.
- `"Category"`: Specify a new category for an OpsItem.
- `"Description"`: User-defined text that contains information about the OpsItem, in
  Markdown format.
- `"Notifications"`: The Amazon Resource Name (ARN) of an SNS topic where notifications are
  sent when this OpsItem is edited or changed.
- `"OperationalData"`: Add new keys or edit existing key-value pairs of the OperationalData
  map in the OpsItem object. Operational data is custom data that provides useful reference
  details about the OpsItem. For example, you can specify log files, error strings, license
  keys, troubleshooting tips, or other relevant data. You enter operational data as key-value
  pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20
  KB.  Operational data keys can't begin with the following: amazon, aws, amzn, ssm, /amazon,
  /aws, /amzn, /ssm.  You can choose to make the data searchable by other users in the
  account or you can restrict search access. Searchable data means that all users with access
  to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view
  and search on the specified data. Operational data that isn't searchable is only viewable
  by users who have access to the OpsItem (as provided by the GetOpsItem API operation). Use
  the /aws/resources key in OperationalData to specify a related resource in the request. Use
  the /aws/automations key in OperationalData to associate an Automation runbook with the
  OpsItem. To view Amazon Web Services CLI example commands that use these keys, see Creating
  OpsItems manually in the Amazon Web Services Systems Manager User Guide.
- `"OperationalDataToDelete"`: Keys that you want to remove from the OperationalData map.
- `"OpsItemArn"`: The OpsItem Amazon Resource Name (ARN).
- `"PlannedEndTime"`: The time specified in a change request for a runbook workflow to end.
  Currently supported only for the OpsItem type /aws/changerequest.
- `"PlannedStartTime"`: The time specified in a change request for a runbook workflow to
  start. Currently supported only for the OpsItem type /aws/changerequest.
- `"Priority"`: The importance of this OpsItem in relation to other OpsItems in the system.
- `"RelatedOpsItems"`: One or more OpsItems that share something in common with the current
  OpsItems. For example, related OpsItems can include OpsItems with similar error messages,
  impacted resources, or statuses for the impacted resource.
- `"Severity"`: Specify a new severity for an OpsItem.
- `"Status"`: The OpsItem status. Status can be Open, In Progress, or Resolved. For more
  information, see Editing OpsItem details in the Amazon Web Services Systems Manager User
  Guide.
- `"Title"`: A short heading that describes the nature of the OpsItem and the impacted
  resource.
"""
function update_ops_item(OpsItemId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm(
        "UpdateOpsItem",
        Dict{String,Any}("OpsItemId" => OpsItemId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ops_item(
    OpsItemId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateOpsItem",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsItemId" => OpsItemId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ops_metadata(ops_metadata_arn)
    update_ops_metadata(ops_metadata_arn, params::Dict{String,<:Any})

Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in
Application Manager.

# Arguments
- `ops_metadata_arn`: The Amazon Resource Name (ARN) of the OpsMetadata Object to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KeysToDelete"`: The metadata keys to delete from the OpsMetadata object.
- `"MetadataToUpdate"`: Metadata to add to an OpsMetadata object.
"""
function update_ops_metadata(
    OpsMetadataArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateOpsMetadata",
        Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ops_metadata(
    OpsMetadataArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateOpsMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OpsMetadataArn" => OpsMetadataArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_patch_baseline(baseline_id)
    update_patch_baseline(baseline_id, params::Dict{String,<:Any})

Modifies an existing patch baseline. Fields not specified in the request are left
unchanged.  For information about valid key-value pairs in PatchFilters for each supported
operating system type, see PatchFilter.

# Arguments
- `baseline_id`: The ID of the patch baseline to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApprovalRules"`: A set of rules used to include patches in the baseline.
- `"ApprovedPatches"`: A list of explicitly approved patches for the baseline. For
  information about accepted formats for lists of approved patches and rejected patches, see
  About package name formats for approved and rejected patch lists in the Amazon Web Services
  Systems Manager User Guide.
- `"ApprovedPatchesComplianceLevel"`: Assigns a new compliance severity level to an
  existing patch baseline.
- `"ApprovedPatchesEnableNonSecurity"`: Indicates whether the list of approved patches
  includes non-security updates that should be applied to the managed nodes. The default
  value is false. Applies to Linux managed nodes only.
- `"Description"`: A description of the patch baseline.
- `"GlobalFilters"`: A set of global filters used to include patches in the baseline.
- `"Name"`: The name of the patch baseline.
- `"RejectedPatches"`: A list of explicitly rejected patches for the baseline. For
  information about accepted formats for lists of approved patches and rejected patches, see
  About package name formats for approved and rejected patch lists in the Amazon Web Services
  Systems Manager User Guide.
- `"RejectedPatchesAction"`: The action for Patch Manager to take on patches included in
  the RejectedPackages list.     ALLOW_AS_DEPENDENCY : A package in the Rejected patches list
  is installed only if it is a dependency of another package. It is considered compliant with
  the patch baseline, and its status is reported as InstalledOther. This is the default
  action if no option is specified.    BLOCK: Packages in the Rejected patches list, and
  packages that include them as dependencies, aren't installed by Patch Manager under any
  circumstances. If a package was installed before it was added to the Rejected patches list,
  or is installed outside of Patch Manager afterward, it's considered noncompliant with the
  patch baseline and its status is reported as InstalledRejected.
- `"Replace"`: If True, then all fields that are required by the CreatePatchBaseline
  operation are also required for this API request. Optional fields that aren't specified are
  set to null.
- `"Sources"`: Information about the patches to use to update the managed nodes, including
  target operating systems and source repositories. Applies to Linux managed nodes only.
"""
function update_patch_baseline(
    BaselineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdatePatchBaseline",
        Dict{String,Any}("BaselineId" => BaselineId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_patch_baseline(
    BaselineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdatePatchBaseline",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BaselineId" => BaselineId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resource_data_sync(sync_name, sync_source, sync_type)
    update_resource_data_sync(sync_name, sync_source, sync_type, params::Dict{String,<:Any})

Update a resource data sync. After you create a resource data sync for a Region, you can't
change the account options for that sync. For example, if you create a sync in the
us-east-2 (Ohio) Region and you choose the Include only the current account option, you
can't edit that sync later and choose the Include all accounts from my Organizations
configuration option. Instead, you must delete the first resource data sync, and create a
new one.  This API operation only supports a resource data sync that was created with a
SyncFromSource SyncType.

# Arguments
- `sync_name`: The name of the resource data sync you want to update.
- `sync_source`: Specify information about the data sources to synchronize.
- `sync_type`: The type of resource data sync. The supported SyncType is SyncFromSource.

"""
function update_resource_data_sync(
    SyncName, SyncSource, SyncType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateResourceDataSync",
        Dict{String,Any}(
            "SyncName" => SyncName, "SyncSource" => SyncSource, "SyncType" => SyncType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resource_data_sync(
    SyncName,
    SyncSource,
    SyncType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateResourceDataSync",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SyncName" => SyncName,
                    "SyncSource" => SyncSource,
                    "SyncType" => SyncType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_service_setting(setting_id, setting_value)
    update_service_setting(setting_id, setting_value, params::Dict{String,<:Any})

 ServiceSetting is an account-level setting for an Amazon Web Services service. This
setting defines how a user interacts with or uses a service or a feature of a service. For
example, if an Amazon Web Services service charges money to the account based on feature or
service usage, then the Amazon Web Services service team might create a default setting of
\"false\". This means the user can't use this feature unless they change the setting to
\"true\" and intentionally opt in for a paid feature. Services map a SettingId object to a
setting value. Amazon Web Services services teams define the default value for a SettingId.
You can't create a new SettingId, but you can overwrite the default value if you have the
ssm:UpdateServiceSetting permission for the setting. Use the GetServiceSetting API
operation to view the current value. Or, use the ResetServiceSetting to change the value
back to the original value defined by the Amazon Web Services service team. Update the
service setting for the account.

# Arguments
- `setting_id`: The Amazon Resource Name (ARN) of the service setting to update. For
  example,
  arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enable
  d. The setting ID can be one of the following.
  /ssm/managed-instance/default-ec2-instance-management-role
  /ssm/automation/customer-script-log-destination
  /ssm/automation/customer-script-log-group-name
  /ssm/documents/console/public-sharing-permission     /ssm/managed-instance/activation-tier
     /ssm/opsinsights/opscenter     /ssm/parameter-store/default-parameter-tier
  /ssm/parameter-store/high-throughput-enabled     Permissions to update the
  /ssm/managed-instance/default-ec2-instance-management-role setting should only be provided
  to administrators. Implement least privilege access when allowing individuals to configure
  or modify the Default Host Management Configuration.
- `setting_value`: The new value to specify for the service setting. The following list
  specifies the available values for each setting.   For
  /ssm/managed-instance/default-ec2-instance-management-role, enter the name of an IAM role.
    For /ssm/automation/customer-script-log-destination, enter CloudWatch.   For
  /ssm/automation/customer-script-log-group-name, enter the name of an Amazon CloudWatch Logs
  log group.   For /ssm/documents/console/public-sharing-permission, enter Enable or Disable.
    For /ssm/managed-instance/activation-tier, enter standard or advanced.    For
  /ssm/opsinsights/opscenter, enter Enabled or Disabled.    For
  /ssm/parameter-store/default-parameter-tier, enter Standard, Advanced, or
  Intelligent-Tiering    For /ssm/parameter-store/high-throughput-enabled, enter true or
  false.

"""
function update_service_setting(
    SettingId, SettingValue; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm(
        "UpdateServiceSetting",
        Dict{String,Any}("SettingId" => SettingId, "SettingValue" => SettingValue);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_service_setting(
    SettingId,
    SettingValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm(
        "UpdateServiceSetting",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SettingId" => SettingId, "SettingValue" => SettingValue),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
