# Introduction

The purpose of these "Getting started" tutorials is to teach new users the
basics of Julia and JuMP.

## How these tutorials are structured

Having a high-level overview of how this part of the documentation is structured
will help you know where to look for certain things.

 * The "Getting started with" tutorials are basic introductions to different
   aspects of JuMP and Julia. If you are new to JuMP and Julia, start by reading
   them in the following order:
   * [Getting started with Julia](@ref)
   * [Getting started with JuMP](@ref)
   * [Getting started with sets and indexing](@ref)
   * [Getting started with data and plotting](@ref)
 * Julia has a reputation for being "fast." Unfortunately, it is also easy to
   write _slow_ Julia code. [Performance tips](@ref) contains a number of
   important tips on how to improve the performance of models you write in JuMP.
 * [Design patterns for larger models](@ref) is a more advanced tutorial
   that is aimed at users writing large JuMP models. It's in the "Getting
   started" section to give you an early preview of how JuMP makes it easy to
   structure larger models. If you are new to JuMP you may want to skip
   or briefly skim this tutorial, and come back to it once you have written a
   few JuMP models.
