## Vern6
struct Vern6ExtraStages{T, T2}
    c10::T2
    a1001::T
    a1004::T
    a1005::T
    a1006::T
    a1007::T
    a1008::T
    a1009::T
    c11::T2
    a1101::T
    a1104::T
    a1105::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    a1110::T
    c12::T2
    a1201::T
    a1204::T
    a1205::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1210::T
    a1211::T
end

function Vern6ExtraStages(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    # Extra stages for Order 5
    c10 = convert(T2, 0.5)
    a1001 = convert(T, 0.016524159013572806)
    a1004 = convert(T, 0.3053128187514179)
    a1005 = convert(T, 0.2071200938201979)
    a1006 = convert(T, -1.293879140655123)
    a1007 = convert(T, 57.11988411588149)
    a1008 = convert(T, -55.87979207510932)
    a1009 = convert(T, 0.024830028297766014)
    # Extra stages for Order 6
    c11 = convert(T2, 0.828)
    a1101 = convert(T, 0.038150081818627744)
    a1104 = convert(T, 0.2502358252513705)
    a1105 = convert(T, 0.3249441447817608)
    a1106 = convert(T, 1.8224606658327962)
    a1107 = convert(T, -67.7137233269262)
    a1108 = convert(T, 66.03587911808127)
    a1109 = convert(T, -0.0363881087495127)
    a1110 = convert(T, 0.106441599909888)
    c12 = convert(T2, 0.28)
    a1201 = convert(T, 0.11178168039666012)
    a1204 = convert(T, 0.025757505109345213)
    a1205 = convert(T, 3.785140856363646)
    a1206 = convert(T, 92.34088993695727)
    a1207 = convert(T, -3819.461508432344)
    a1208 = convert(T, 3732.492711530704)
    a1209 = convert(T, -1.0756940209963033)
    a1210 = convert(T, -3.231539970732086)
    a1211 = convert(T, -4.707539085458635)

    Vern6ExtraStages(c10, a1001, a1004, a1005, a1006, a1007, a1008, a1009, c11, a1101,
        a1104, a1105, a1106, a1107, a1108, a1109, a1110, c12, a1201, a1204,
        a1205, a1206, a1207, a1208, a1209, a1210, a1211)
end

function Vern6ExtraStages(T, T2)
    # Extra stages for Order 5
    c10 = convert(T2, 1 // 2)
    a1001 = convert(T,
        BigInt(35289331988986254405692535758830683) //
        BigInt(2135620454874580332949729350544993288))
    a1004 = convert(T,
        BigInt(313937014583068512255490687992212890625) //
        BigInt(1028247080705354654473994781524199691557))
    a1005 = convert(T,
        BigInt(1309307687253621245836726130885318359375) //
        BigInt(6321490412177191231557635904400612215708))
    a1006 = convert(T,
        -BigInt(35295844079877524186147726060781875) //
        BigInt(27279088881521314684841470427640876))
    a1007 = convert(T,
        BigInt(794353492803973228770716697389421875) //
        BigInt(13906777037439977359946774228636361))
    a1008 = convert(T,
        -BigInt(15228408956329265381787438679500067) //
        BigInt(272520859345009876882656783678732))
    a1009 = convert(T, 28587810357600962662801 // 1151340224617184234295192)
    # Extra stages for Order 6
    c11 = convert(T2, 207 // 250)
    a1101 = convert(T,
        BigInt(2486392061981208591025761263164027224438868971) //
        BigInt(65173964076983042387381877152862343994140625000))
    a1104 = convert(T,
        BigInt(2330654500023704838558579323179918419669) //
        BigInt(9313832252765893609365894760182968220625))
    a1105 = convert(T,
        BigInt(5283259505481013273874688940942473187741) //
        BigInt(16258977397575080328080339260289640472500))
    a1106 = convert(T,
        BigInt(9989685106081485386057729811605187743723) //
        BigInt(5481427003263510055949691042076757812500))
    a1107 = convert(T,
        -BigInt(65815640423883764662985178413751186161) //
        BigInt(971969007022721623945108012714453125))
    a1108 = convert(T,
        BigInt(183066350554023250298437927498791289370414247) //
        BigInt(2772225538584491748887703284492309570312500))
    a1109 = convert(T,
        -426178927623072052719640507155669 //
        11712038417736656029207275390625000)
    a1110 = convert(T, 3248339841 // 30517578125)
    c12 = convert(T2, 7 // 25)
    a1201 = convert(T,
        BigInt(4676747786898097735038451956075910033997933945857) //
        BigInt(41838231186922043164464169766109251031526972656250))
    a1204 = convert(T,
        BigInt(1320032412954312695441306548681592444623240) //
        BigInt(51248457773784347881352490499724836575577977))
    a1205 = convert(T,
        BigInt(2087002134582726310861746540254017903014374710) //
        BigInt(551367099344274428347227263044005314054687829))
    a1206 = convert(T,
        BigInt(3432932836484348829479408524345545011748570706) //
        BigInt(37176735450871998946806722732624135633015625))
    a1207 = convert(T,
        -BigInt(2316434358511265475362584844804601519943610264) //
        BigInt(606481922490173339581866127622363581143375))
    a1208 = convert(T,
        BigInt(82514605285282414051716141603447021470923168793) //
        BigInt(22107104196177512751528507591142367597656250))
    a1209 = convert(T,
        -BigInt(7560161019374651900153317984708038834) //
        BigInt(7028170531590816328729091157353515625))
    a1210 = convert(T,
        -BigInt(21655450552377696842870155771710589332) //
        BigInt(6701278878958685336695179940732421875))
    a1211 = convert(T,
        -3194830887993202085244614477336220 //
        678662636676110315314332975245759)

    Vern6ExtraStages(c10, a1001, a1004, a1005, a1006, a1007, a1008, a1009, c11, a1101,
        a1104, a1105, a1106, a1107, a1108, a1109, a1110, c12, a1201, a1204,
        a1205, a1206, a1207, a1208, a1209, a1210, a1211)
end

"""
Coefficients for the polynomial
bᵢΘ = ri1*Θ + ri2*Θ^2 + ri3*Θ^3 + ...
"""
struct Vern6InterpolationCoefficients{T}
    r011::T
    r012::T
    r013::T
    r014::T
    r015::T
    r016::T
    r042::T
    r043::T
    r044::T
    r045::T
    r046::T
    r052::T
    r053::T
    r054::T
    r055::T
    r056::T
    r062::T
    r063::T
    r064::T
    r065::T
    r066::T
    r072::T
    r073::T
    r074::T
    r075::T
    r076::T
    r082::T
    r083::T
    r084::T
    r085::T
    r086::T
    r092::T
    r093::T
    r094::T
    r095::T
    r096::T
    r102::T
    r103::T
    r104::T
    r105::T
    r106::T
    r112::T
    r113::T
    r114::T
    r115::T
    r116::T
    r122::T
    r123::T
    r124::T
    r125::T
    r126::T
end

function Vern6InterpolationCoefficients(T::Type{<:CompiledFloats})
    r011 = convert(T, 1)
    r012 = convert(T, -7.778593856495576)
    r013 = convert(T, 27.0524385722671)
    r014 = convert(T, -45.780190114576975)
    r015 = convert(T, 36.723777410436384)
    r016 = convert(T, -11.183042432947357)
    r042 = convert(T, 16.632102138279762)
    r043 = convert(T, -86.25583404770623)
    r044 = convert(T, 171.73305461826962)
    r045 = convert(T, -149.67744091315947)
    r046 = convert(T, 47.826380659879696)
    r052 = convert(T, 27.10835046149758)
    r053 = convert(T, -140.58676162962996)
    r054 = convert(T, 279.90447579689163)
    r055 = convert(T, -243.95644583707966)
    r056 = convert(T, 77.95131832728772)
    r062 = convert(T, 283.70753264670356)
    r063 = convert(T, -1471.3371557366656)
    r064 = convert(T, 2929.3928569314394)
    r065 = convert(T, -2553.17199842168)
    r066 = convert(T, 815.8141610498723)
    r072 = convert(T, -11365.512865164834)
    r073 = convert(T, 58942.74718938947)
    r074 = convert(T, -117353.43045697975)
    r075 = convert(T, 102281.77209230464)
    r076 = convert(T, -32682.059078573824)
    r082 = convert(T, 11100.250191051131)
    r083 = convert(T, -57567.067013355576)
    r084 = convert(T, 114614.48808378985)
    r085 = convert(T, -99894.591091309)
    r086 = convert(T, 31919.283963225014)
    r092 = convert(T, -3.0022825150732126)
    r093 = convert(T, 14.946122435958785)
    r094 = convert(T, -27.826954732510288)
    r095 = convert(T, 21.824672217437076)
    r096 = convert(T, -5.941557405812358)
    r102 = convert(T, -19.610347376201034)
    r103 = convert(T, 93.13370014508226)
    r104 = convert(T, -165.3493635542416)
    r105 = convert(T, 129.73901617804057)
    r106 = convert(T, -37.91300539268019)
    r112 = convert(T, -18.23029074639409)
    r113 = convert(T, 96.74593449012313)
    r114 = convert(T, -199.08634973839895)
    r115 = convert(T, 180.85605899200485)
    r116 = convert(T, -60.285352997334954)
    r122 = convert(T, -13.563796638614157)
    r123 = convert(T, 90.62137973668116)
    r124 = convert(T, -204.04515601697273)
    r125 = convert(T, 190.48135937835858)
    r126 = convert(T, -63.493786459452856)

    Vern6InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r042, r043, r044,
        r045, r046, r052, r053, r054, r055, r056, r062, r063,
        r064, r065, r066, r072, r073, r074, r075, r076, r082,
        r083, r084, r085, r086, r092, r093, r094, r095, r096,
        r102, r103, r104, r105, r106, r112, r113, r114, r115,
        r116, r122, r123, r124, r125, r126)
end

function Vern6InterpolationCoefficients(T)
    r011 = convert(T, 1)
    r012 = convert(T, -940811006205413129 // 120948724610397495)
    r013 = convert(T, 88342864458754360181 // 3265615564480732365)
    r014 = convert(T, -99667000922033025307 // 2177077042987154910)
    r015 = convert(T, 7995049273203130972 // 217707704298715491)
    r016 = convert(T, -7303903485456272500 // 653123112896146473)
    r042 = convert(T, 2214248281250000 // 133130993475189)
    r043 = convert(T, -49918013252500000000 // 578720428636646583)
    r044 = convert(T, 1440368506953125000 // 8387252588936907)
    r045 = convert(T, -28873797587500000000 // 192906809545548861)
    r046 = convert(T, 27678103515625000000 // 578720428636646583)
    r052 = convert(T, 893038428789062500 // 32943296570459319)
    r053 = convert(T, -125047567320625000000 // 889469007402401613)
    r054 = convert(T, 82988785418183593750 // 296489669134133871)
    r055 = convert(T, -72330565909375000000 // 296489669134133871)
    r056 = convert(T, 69335281738281250000 // 889469007402401613)
    r062 = convert(T, 40331864555500 // 142160006043)
    r063 = convert(T, -5647463071672000 // 3838320163161)
    r064 = convert(T, 3747982556193250 // 1279440054387)
    r065 = convert(T, -3266630520520000 // 1279440054387)
    r066 = convert(T, 3131355943750000 // 3838320163161)
    r072 = convert(T, -143250206750000 // 12603936879)
    r073 = convert(T, 461347522996000000 // 7827044801859)
    r074 = convert(T, -13312037070125000 // 113435431911)
    r075 = convert(T, 266854670860000000 // 2609014933953)
    r076 = convert(T, -255803940625000000 // 7827044801859)
    r082 = convert(T, 3753451420391 // 338141155)
    r083 = convert(T, -3679035166143248 // 63908678295)
    r084 = convert(T, 4883240297928691 // 42605785530)
    r085 = convert(T, -425608752364336 // 4260578553)
    r086 = convert(T, 407983850042500 // 12781735659)
    r092 = convert(T, -69713 // 23220)
    r093 = convert(T, 4685161 // 313470)
    r094 = convert(T, -135239 // 4860)
    r095 = convert(T, 228046 // 10449)
    r096 = convert(T, -186250 // 31347)
    r102 = convert(T, -132664 // 6765)
    r103 = convert(T, 17011336 // 182655)
    r104 = convert(T, -10067296 // 60885)
    r105 = convert(T, 1579832 // 12177)
    r106 = convert(T, -1385000 // 36531)
    r112 = convert(T, -2734375000 // 149990751)
    r113 = convert(T, 391796875000 // 4049750277)
    r114 = convert(T, -6250000000 // 31393413)
    r115 = convert(T, 244140625000 // 1349916759)
    r116 = convert(T, -244140625000 // 4049750277)
    r122 = convert(T, -15453125 // 1139292)
    r123 = convert(T, 1393796875 // 15380442)
    r124 = convert(T, -2092203125 // 10253628)
    r125 = convert(T, 488281250 // 2563407)
    r126 = convert(T, -488281250 // 7690221)

    Vern6InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r042, r043, r044,
        r045, r046, r052, r053, r054, r055, r056, r062, r063,
        r064, r065, r066, r072, r073, r074, r075, r076, r082,
        r083, r084, r085, r086, r092, r093, r094, r095, r096,
        r102, r103, r104, r105, r106, r112, r113, r114, r115,
        r116, r122, r123, r124, r125, r126)
end

"""
From Verner's Website
"""
struct Vern6Tableau{T, T2}
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    a21::T
    a31::T
    a32::T
    a41::T
    a43::T
    a51::T
    a53::T
    a54::T
    a61::T
    a63::T
    a64::T
    a65::T
    a71::T
    a73::T
    a74::T
    a75::T
    a76::T
    a81::T
    a83::T
    a84::T
    a85::T
    a86::T
    a87::T
    a91::T
    a94::T
    a95::T
    a96::T
    a97::T
    a98::T
    btilde1::T
    btilde4::T
    btilde5::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    extra::Vern6ExtraStages{T, T2}
    interp::Vern6InterpolationCoefficients{T}
end

function Vern6Tableau(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c1 = convert(T2, 0.06)
    c2 = convert(T2, 0.09593333333333333)
    c3 = convert(T2, 0.1439)
    c4 = convert(T2, 0.4973)
    c5 = convert(T2, 0.9725)
    c6 = convert(T2, 0.9995)
    a21 = convert(T, 0.06)
    a31 = convert(T, 0.019239962962962962)
    a32 = convert(T, 0.07669337037037037)
    a41 = convert(T, 0.035975)
    a43 = convert(T, 0.107925)
    a51 = convert(T, 1.3186834152331484)
    a53 = convert(T, -5.042058063628562)
    a54 = convert(T, 4.220674648395414)
    a61 = convert(T, -41.87259166432751)
    a63 = convert(T, 159.43256216313748)
    a64 = convert(T, -122.11921356501004)
    a65 = convert(T, 5.531743066200053)
    a71 = convert(T, -54.430156935316504)
    a73 = convert(T, 207.06725136501848)
    a74 = convert(T, -158.61081378459)
    a75 = convert(T, 6.991816585950242)
    a76 = convert(T, -0.01859723106220323)
    a81 = convert(T, -54.66374178728198)
    a83 = convert(T, 207.95280625538936)
    a84 = convert(T, -159.2889574744995)
    a85 = convert(T, 7.018743740796944)
    a86 = convert(T, -0.018338785905045722)
    a87 = convert(T, -0.0005119484997882099)
    a91 = convert(T, 0.03438957868357036)
    a94 = convert(T, 0.25826245556335037)
    a95 = convert(T, 0.4209371189673537)
    a96 = convert(T, 4.40539646966931)
    a97 = convert(T, -176.48311902429865)
    a98 = convert(T, 172.36413340141507)
    # b1   =convert(T,0.04301298296577122)
    # b4   =convert(T,0.23882842561019763)
    # b5   =convert(T,0.44938719155539175)
    # b6   =convert(T,2.2956854086040193)
    # b7   =convert(T,-73.02457612433467)
    # b8   =convert(T,70.96432878226597)
    # b9   =convert(T,0.03333333333333333)
    btilde1 = convert(T, 0.008623404282200854)
    btilde4 = convert(T, -0.019434029953152708)
    btilde5 = convert(T, 0.028450072588037983)
    btilde6 = convert(T, -2.1097110610652914)
    btilde7 = convert(T, 103.45854289996397)
    btilde8 = convert(T, -101.39980461914912)
    btilde9 = convert(T, 0.03333333333333333)

    extra = Vern6ExtraStages(T, T2)
    interp = Vern6InterpolationCoefficients(T)

    Vern6Tableau(c1, c2, c3, c4, c5, c6, a21, a31, a32, a41, a43, a51, a53, a54, a61, a63,
        a64, a65, a71, a73, a74, a75, a76, a81, a83, a84, a85, a86, a87, a91, a94,
        a95, a96, a97, a98, btilde1, btilde4, btilde5, btilde6, btilde7, btilde8,
        btilde9, extra, interp)
end

function Vern6Tableau(T, T2)
    c1 = convert(T2, 3 // 50)
    c2 = convert(T2, 1439 // 15000)
    c3 = convert(T2, 1439 // 10000)
    c4 = convert(T2, 4973 // 10000)
    c5 = convert(T2, 389 // 400)
    c6 = convert(T2, 1999 // 2000)
    a21 = convert(T, 3 // 50)
    a31 = convert(T, 519479 // 27000000)
    a32 = convert(T, 2070721 // 27000000)
    a41 = convert(T, 1439 // 40000)
    a43 = convert(T, 4317 // 40000)
    a51 = convert(T, 109225017611 // 82828840000)
    a53 = convert(T, -417627820623 // 82828840000)
    a54 = convert(T, 43699198143 // 10353605000)
    a61 = convert(T, -8036815292643907349452552172369 // 191934985946683241245914401600)
    a63 = convert(T, 246134619571490020064824665 // 1543816496655405117602368)
    a64 = convert(T, -13880495956885686234074067279 // 113663489566254201783474344)
    a65 = convert(T, 755005057777788994734129 // 136485922925633667082436)
    a71 = convert(T,
        -BigInt(1663299841566102097180506666498880934230261) //
        BigInt(30558424506156170307020957791311384232000))
    a73 = convert(T,
        130838124195285491799043628811093033 // 631862949514135618861563657970240)
    a74 = convert(T,
        -BigInt(3287100453856023634160618787153901962873) //
        BigInt(20724314915376755629135711026851409200))
    a75 = convert(T,
        2771826790140332140865242520369241 // 396438716042723436917079980147600)
    a76 = convert(T, -1799166916139193 // 96743806114007800)
    a81 = convert(T,
        -BigInt(832144750039369683895428386437986853923637763) //
        BigInt(15222974550069600748763651844667619945204887))
    a83 = convert(T,
        818622075710363565982285196611368750 //
        3936576237903728151856072395343129)
    a84 = convert(T,
        -BigInt(9818985165491658464841194581385463434793741875) //
        BigInt(61642597962658994069869370923196463581866011))
    a85 = convert(T,
        BigInt(31796692141848558720425711042548134769375) //
        BigInt(4530254033500045975557858016006308628092))
    a86 = convert(T, -14064542118843830075 // 766928748264306853644)
    a87 = convert(T, -1424670304836288125 // 2782839104764768088217)
    a91 = convert(T, 382735282417 // 11129397249634)
    a94 = convert(T, 5535620703125000 // 21434089949505429)
    a95 = convert(T, 13867056347656250 // 32943296570459319)
    a96 = convert(T, 626271188750 // 142160006043)
    a97 = convert(T, -51160788125000 // 289890548217)
    a98 = convert(T, 163193540017 // 946795234)
    # b1   =convert(T,124310637869885675646798613//2890072468789466426596827670)
    # b4   =convert(T,265863151737164990361330921875//1113197271463372303940319369579)
    # b5   =convert(T,3075493557174030806536302953125//6843749922042323876546949699876)
    # b6   =convert(T,67798000008733879813263055//29532792147666737550036372)
    # b7   =convert(T,-1099436585155390846238326375//15055706496446408859196167)
    # b8   =convert(T,26171252653086373181571802//368794478890732346033505)
    # b9   =convert(T,1//30)
    btilde1 = convert(T, 12461131651614938103148389 // 1445036234394733213298413835)
    btilde4 = convert(T, -21633909117387045317965953125 // 1113197271463372303940319369579)
    btilde5 = convert(T, 21633909117387045317965953125 // 760416658004702652949661077764)
    btilde6 = convert(T, -6922850917563854501749105 // 3281421349740748616670708)
    btilde7 = convert(T, 173071272939096362543727625 // 1672856277382934317688463)
    btilde8 = convert(T, -74791376208282344108625901 // 737588957781464692067010)
    btilde9 = convert(T, 1 // 30)

    extra = Vern6ExtraStages(T, T2)
    interp = Vern6InterpolationCoefficients(T)

    Vern6Tableau(c1, c2, c3, c4, c5, c6, a21, a31, a32, a41, a43, a51, a53, a54, a61, a63,
        a64, a65, a71, a73, a74, a75, a76, a81, a83, a84, a85, a86, a87, a91, a94,
        a95, a96, a97, a98, btilde1, btilde4, btilde5, btilde6, btilde7, btilde8,
        btilde9, extra, interp)
end

## Vern7
struct Vern7ExtraStages{T, T2}
    c11::T2
    a1101::T
    a1104::T
    a1105::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    c12::T2
    a1201::T
    a1204::T
    a1205::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1211::T
    c13::T2
    a1301::T
    a1304::T
    a1305::T
    a1306::T
    a1307::T
    a1308::T
    a1309::T
    a1311::T
    a1312::T
    c14::T2
    a1401::T
    a1404::T
    a1405::T
    a1406::T
    a1407::T
    a1408::T
    a1409::T
    a1411::T
    a1412::T
    a1413::T
    c15::T2
    a1501::T
    a1504::T
    a1505::T
    a1506::T
    a1507::T
    a1508::T
    a1509::T
    a1511::T
    a1512::T
    a1513::T
    c16::T2
    a1601::T
    a1604::T
    a1605::T
    a1606::T
    a1607::T
    a1608::T
    a1609::T
    a1611::T
    a1612::T
    a1613::T
end

@fold function Vern7ExtraStages(::Type{T},
        ::Type{T2}) where {T <: CompiledFloats,
        T2 <: CompiledFloats}
    c11 = convert(T2, 1)
    a1101 = convert(T, 0.04715561848627222)
    a1104 = convert(T, 0.25750564298434153)
    a1105 = convert(T, 0.2621665397741262)
    a1106 = convert(T, 0.15216092656738558)
    a1107 = convert(T, 0.49399691700324844)
    a1108 = convert(T, -0.29430311714032503)
    a1109 = convert(T, 0.0813174723249511)
    c12 = convert(T2, 0.29)
    a1201 = convert(T, 0.0523222769159969)
    a1204 = convert(T, 0.22495861826705715)
    a1205 = convert(T, 0.017443709248776376)
    a1206 = convert(T, -0.007669379876829393)
    a1207 = convert(T, 0.03435896044073285)
    a1208 = convert(T, -0.0410209723009395)
    a1209 = convert(T, 0.025651133005205617)
    a1211 = convert(T, -0.0160443457)
    c13 = convert(T2, 0.125)
    a1301 = convert(T, 0.053053341257859085)
    a1304 = convert(T, 0.12195301011401886)
    a1305 = convert(T, 0.017746840737602496)
    a1306 = convert(T, -0.0005928372667681495)
    a1307 = convert(T, 0.008381833970853752)
    a1308 = convert(T, -0.01293369259698612)
    a1309 = convert(T, 0.009412056815253861)
    a1311 = convert(T, -0.005353253107275676)
    a1312 = convert(T, -0.06666729992455811)
    c14 = convert(T2, 0.25)
    a1401 = convert(T, 0.03887903257436304)
    a1404 = convert(T, -0.0024403203308301317)
    a1405 = convert(T, -0.0013928917214672623)
    a1406 = convert(T, -0.00047446291558680135)
    a1407 = convert(T, 0.00039207932413159514)
    a1408 = convert(T, -0.00040554733285128004)
    a1409 = convert(T, 0.00019897093147716726)
    a1411 = convert(T, -0.00010278198793179169)
    a1412 = convert(T, 0.03385661513870267)
    a1413 = convert(T, 0.1814893063199928)
    c15 = convert(T2, 0.53)
    a1501 = convert(T, 0.05723681204690013)
    a1504 = convert(T, 0.22265948066761182)
    a1505 = convert(T, 0.12344864200186899)
    a1506 = convert(T, 0.04006332526666491)
    a1507 = convert(T, -0.05269894848581452)
    a1508 = convert(T, 0.04765971214244523)
    a1509 = convert(T, -0.02138895885042213)
    a1511 = convert(T, 0.015193891064036402)
    a1512 = convert(T, 0.12060546716289655)
    a1513 = convert(T, -0.022779423016187374)
    c16 = convert(T2, 0.79)
    a1601 = convert(T, 0.051372038802756814)
    a1604 = convert(T, 0.5414214473439406)
    a1605 = convert(T, 0.350399806692184)
    a1606 = convert(T, 0.14193112269692182)
    a1607 = convert(T, 0.10527377478429423)
    a1608 = convert(T, -0.031081847805874016)
    a1609 = convert(T, -0.007401883149519145)
    a1611 = convert(T, -0.006377932504865363)
    a1612 = convert(T, -0.17325495908361865)
    a1613 = convert(T, -0.18228156777622026)

    Vern7ExtraStages(c11, a1101, a1104, a1105, a1106, a1107, a1108, a1109, c12, a1201,
        a1204, a1205, a1206, a1207, a1208, a1209, a1211, c13, a1301, a1304,
        a1305, a1306, a1307, a1308, a1309, a1311, a1312, c14, a1401, a1404,
        a1405, a1406, a1407, a1408, a1409, a1411, a1412, a1413, c15, a1501,
        a1504, a1505, a1506, a1507, a1508, a1509, a1511, a1512, a1513, c16,
        a1601, a1604, a1605, a1606, a1607, a1608, a1609, a1611, a1612, a1613)
end

@fold function Vern7ExtraStages(::Type{T}, ::Type{T2}) where {T, T2}
    c11 = convert(T2, 1)
    a1101 = convert(T, big" .4715561848627222170431765108838175679569e-1")
    a1104 = convert(T, big" .2575056429843415189596436101037687580986")
    a1105 = convert(T, big" .2621665397741262047713863095764527711129")
    a1106 = convert(T, big" .1521609265673855740323133199165117535523")
    a1107 = convert(T, big" .4939969170032484246907175893227876844296")
    a1108 = convert(T, big"-.2943031171403250441557244744092703429139")
    a1109 = convert(T, big" .8131747232495109999734599440136761892478e-1")
    c12 = convert(T2, 29 // 100)
    a1201 = convert(T, big" .5232227691599689815470932256735029887614e-1")
    a1204 = convert(T, big" .2249586182670571550244187743667190903405")
    a1205 = convert(T, big" .1744370924877637539031751304611402542578e-1")
    a1206 = convert(T, big"-.7669379876829393188009028209348812321417e-2")
    a1207 = convert(T, big" .3435896044073284645684381456417912794447e-1")
    a1208 = convert(T, big"-.4102097230093949839125144540100346681769e-1")
    a1209 = convert(T, big" .2565113300520561655297104906598973655221e-1")
    a1211 = convert(T, big"-.160443457e-1")
    c13 = convert(T2, 1 // 8)
    a1301 = convert(T, big" .5305334125785908638834747243817578898946e-1")
    a1304 = convert(T, big" .1219530101140188607092225622195251463666")
    a1305 = convert(T, big" .1774684073760249704011573985936092552347e-1")
    a1306 = convert(T, big"-.5928372667681494328907467430302313286925e-3")
    a1307 = convert(T, big" .8381833970853750873624781948796072714855e-2")
    a1308 = convert(T, big"-.1293369259698611956700998079778496462996e-1")
    a1309 = convert(T, big" .9412056815253860804791356641605087829772e-2")
    a1311 = convert(T, big"-.5353253107275676032399320754008272222345e-2")
    a1312 = convert(T, big"-.6666729992455811078380186481263955324311e-1")
    c14 = convert(T2, 1 // 4)
    a1401 = convert(T, big" .3887903257436303686399931060834951327899e-1")
    a1404 = convert(T, big"-.2440320330830131517910045090190069290791e-2")
    a1405 = convert(T, big"-.1392891721467262281273220992320214734208e-2")
    a1406 = convert(T, big"-.4744629155868013465038358934145339168472e-3")
    a1407 = convert(T, big" .3920793241315951369383517310870803393356e-3")
    a1408 = convert(T, big"-.4055473328512800136385880031750264996936e-3")
    a1409 = convert(T, big" .1989709314771672628794304728258886009267e-3")
    a1411 = convert(T, big"-.1027819879317916884712606136811051029682e-3")
    a1412 = convert(T, big" .3385661513870266715302548402957613704604e-1")
    a1413 = convert(T, big" .1814893063199928004309543737509423302792")
    c15 = convert(T2, 53 // 100)
    a1501 = convert(T, big" .5723681204690012909606837582140921695189e-1")
    a1504 = convert(T, big" .2226594806676118099285816235023183680020")
    a1505 = convert(T, big" .1234486420018689904911221497830317287757")
    a1506 = convert(T, big" .4006332526666490875113688731927762275433e-1")
    a1507 = convert(T, big"-.5269894848581452066926326838943832327366e-1")
    a1508 = convert(T, big" .4765971214244522856887315416093212596338e-1")
    a1509 = convert(T, big"-.2138895885042213036387863538386958914368e-1")
    a1511 = convert(T, big" .1519389106403640165459624646184297766866e-1")
    a1512 = convert(T, big" .1206054671628965554251364472502413614358")
    a1513 = convert(T, big"-.2277942301618737288237298052574548913451e-1")
    c16 = convert(T2, 79 // 100)
    a1601 = convert(T, big" .5137203880275681426595607279552927584506e-1")
    a1604 = convert(T, big" .5414214473439405582401399378307410450482")
    a1605 = convert(T, big" .3503998066921840081154745647747846804810")
    a1606 = convert(T, big" .1419311226969218216861835872156617148040")
    a1607 = convert(T, big" .1052737747842942254816302629823570359198")
    a1608 = convert(T, big"-.3108184780587401700842726199589213259835e-1")
    a1609 = convert(T, big"-.7401883149519145061791854716430279714483e-2")
    a1611 = convert(T, big"-.6377932504865363437569726480040013149706e-2")
    a1612 = convert(T, big"-.1732549590836186403386348310205265959935")
    a1613 = convert(T, big"-.1822815677762202619429607513861847306420")

    Vern7ExtraStages(c11, a1101, a1104, a1105, a1106, a1107, a1108, a1109, c12, a1201,
        a1204, a1205, a1206, a1207, a1208, a1209, a1211, c13, a1301, a1304,
        a1305, a1306, a1307, a1308, a1309, a1311, a1312, c14, a1401, a1404,
        a1405, a1406, a1407, a1408, a1409, a1411, a1412, a1413, c15, a1501,
        a1504, a1505, a1506, a1507, a1508, a1509, a1511, a1512, a1513, c16,
        a1601, a1604, a1605, a1606, a1607, a1608, a1609, a1611, a1612, a1613)
end

struct Vern7InterpolationCoefficients{T}
    r011::T
    r012::T
    r013::T
    r014::T
    r015::T
    r016::T
    r017::T
    r042::T
    r043::T
    r044::T
    r045::T
    r046::T
    r047::T
    r052::T
    r053::T
    r054::T
    r055::T
    r056::T
    r057::T
    r062::T
    r063::T
    r064::T
    r065::T
    r066::T
    r067::T
    r072::T
    r073::T
    r074::T
    r075::T
    r076::T
    r077::T
    r082::T
    r083::T
    r084::T
    r085::T
    r086::T
    r087::T
    r092::T
    r093::T
    r094::T
    r095::T
    r096::T
    r097::T
    r112::T
    r113::T
    r114::T
    r115::T
    r116::T
    r117::T
    r122::T
    r123::T
    r124::T
    r125::T
    r126::T
    r127::T
    r132::T
    r133::T
    r134::T
    r135::T
    r136::T
    r137::T
    r142::T
    r143::T
    r144::T
    r145::T
    r146::T
    r147::T
    r152::T
    r153::T
    r154::T
    r155::T
    r156::T
    r157::T
    r162::T
    r163::T
    r164::T
    r165::T
    r166::T
    r167::T
end

@fold function Vern7InterpolationCoefficients(::Type{T}) where {T <: CompiledFloats}
    r011 = convert(T, 1)
    r012 = convert(T, -8.413387198332767)
    r013 = convert(T, 33.675508884490895)
    r014 = convert(T, -70.80159089484886)
    r015 = convert(T, 80.64695108301298)
    r016 = convert(T, -47.19413969837522)
    r017 = convert(T, 11.133813442539243)
    r042 = convert(T, 8.754921980674396)
    r043 = convert(T, -88.4596828699771)
    r044 = convert(T, 346.9017638429916)
    r045 = convert(T, -629.2580030059837)
    r046 = convert(T, 529.6773755604193)
    r047 = convert(T, -167.35886986514018)
    r052 = convert(T, 8.913387586637922)
    r053 = convert(T, -90.06081846893218)
    r054 = convert(T, 353.1807459217058)
    r055 = convert(T, -640.6476819744374)
    r056 = convert(T, 539.2646279047156)
    r057 = convert(T, -170.38809442991547)
    r062 = convert(T, 5.1733120298478)
    r063 = convert(T, -52.271115900055385)
    r064 = convert(T, 204.9853867374073)
    r065 = convert(T, -371.8306118563603)
    r066 = convert(T, 312.9880934374529)
    r067 = convert(T, -98.89290352172495)
    r072 = convert(T, 16.79537744079696)
    r073 = convert(T, -169.70040000059728)
    r074 = convert(T, 665.4937727009246)
    r075 = convert(T, -1207.1638892336007)
    r076 = convert(T, 1016.1291515818546)
    r077 = convert(T, -321.06001557237494)
    r082 = convert(T, -10.005997536098665)
    r083 = convert(T, 101.1005433052275)
    r084 = convert(T, -396.47391512378437)
    r085 = convert(T, 719.1787707014183)
    r086 = convert(T, -605.3681033918824)
    r087 = convert(T, 191.27439892797935)
    r092 = convert(T, 2.764708833638599)
    r093 = convert(T, -27.934602637390462)
    r094 = convert(T, 109.54779186137893)
    r095 = convert(T, -198.7128113064482)
    r096 = convert(T, 167.26633571640318)
    r097 = convert(T, -52.85010499525706)
    r112 = convert(T, -2.1696320280163506)
    r113 = convert(T, 22.016696037569876)
    r114 = convert(T, -86.90152427798948)
    r115 = convert(T, 159.22388973861476)
    r116 = convert(T, -135.9618306534588)
    r117 = convert(T, 43.792401183280006)
    r122 = convert(T, -4.890070188793804)
    r123 = convert(T, 22.75407737425176)
    r124 = convert(T, -30.78034218537731)
    r125 = convert(T, -2.797194317207249)
    r126 = convert(T, 31.369456637508403)
    r127 = convert(T, -15.655927320381801)
    r132 = convert(T, 10.862170929551967)
    r133 = convert(T, -50.542971417827104)
    r134 = convert(T, 68.37148040407511)
    r135 = convert(T, 6.213326521632409)
    r136 = convert(T, -69.68006323194157)
    r137 = convert(T, 34.776056794509195)
    r142 = convert(T, -11.37286691922923)
    r143 = convert(T, 130.79058078246717)
    r144 = convert(T, -488.65113677785604)
    r145 = convert(T, 832.2148793276441)
    r146 = convert(T, -664.7743368554426)
    r147 = convert(T, 201.79288044241662)
    r152 = convert(T, -5.919778732715007)
    r153 = convert(T, 63.27679965889219)
    r154 = convert(T, -265.432682088738)
    r155 = convert(T, 520.1009254140611)
    r156 = convert(T, -467.412109533902)
    r157 = convert(T, 155.3868452824017)
    r162 = convert(T, -10.492146197961823)
    r163 = convert(T, 105.35538525188011)
    r164 = convert(T, -409.43975011988937)
    r165 = convert(T, 732.831448907654)
    r166 = convert(T, -606.3044574733512)
    r167 = convert(T, 188.0495196316683)

    Vern7InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r042, r043,
        r044, r045, r046, r047, r052, r053, r054, r055, r056,
        r057, r062, r063, r064, r065, r066, r067, r072, r073,
        r074, r075, r076, r077, r082, r083, r084, r085, r086,
        r087, r092, r093, r094, r095, r096, r097, r112, r113,
        r114, r115, r116, r117, r122, r123, r124, r125, r126,
        r127, r132, r133, r134, r135, r136, r137, r142, r143,
        r144, r145, r146, r147, r152, r153, r154, r155, r156,
        r157, r162, r163, r164, r165, r166, r167)
end

@fold function Vern7InterpolationCoefficients(::Type{T}) where {T}
    r011 = convert(T, big" 1")
    r012 = convert(T, big"-8.413387198332767469319987751201351965810")
    r013 = convert(T, big" 33.67550888449089654479469983556967202215")
    r014 = convert(T, big"-70.80159089484886164618905961010838757357")
    r015 = convert(T, big" 80.64695108301297872968868805293298389704")
    r016 = convert(T, big"-47.19413969837521580145883430419406103536")
    r017 = convert(T, big" 11.13381344253924186418881142808952641234")
    r042 = convert(T, big" 8.754921980674397160629587282876763437696")
    r043 = convert(T, big"-88.45968286997709426134300934922618655402")
    r044 = convert(T, big" 346.9017638429916309499891288356321692825")
    r045 = convert(T, big"-629.2580030059837046812187141184986252218")
    r046 = convert(T, big" 529.6773755604192983874116479833480529304")
    r047 = convert(T, big"-167.3588698651401860365089970240284051167")
    r052 = convert(T, big" 8.913387586637921662996190126913331844214")
    r053 = convert(T, big"-90.06081846893217794712014609702916991513")
    r054 = convert(T, big" 353.1807459217057824951538014683541349020")
    r055 = convert(T, big"-640.6476819744374433668701027882567716886")
    r056 = convert(T, big" 539.2646279047155261551781390920363285084")
    r057 = convert(T, big"-170.3880944299154827945664954924414008798")
    r062 = convert(T, big" 5.173312029847800338889849068990984974299")
    r063 = convert(T, big"-52.27111590005538823385270070373176751689")
    r064 = convert(T, big" 204.9853867374073094711024260808085419491")
    r065 = convert(T, big"-371.8306118563602890875634623992262437796")
    r066 = convert(T, big" 312.9880934374529000210073972654145891826")
    r067 = convert(T, big"-98.89290352172494693555119599233959305606")
    r072 = convert(T, big" 16.79537744079695986364946329034055578253")
    r073 = convert(T, big"-169.7004000005972744435739149730966805754")
    r074 = convert(T, big" 665.4937727009246303131700313781960584913")
    r075 = convert(T, big"-1207.163889233600728395392916633015853882")
    r076 = convert(T, big" 1016.129151581854603280159105697386989470")
    r077 = convert(T, big"-321.0600155723749421933210511704882816019")
    r082 = convert(T, big"-10.00599753609866476866352971232058330270")
    r083 = convert(T, big" 101.1005433052275068199636113246449312792")
    r084 = convert(T, big"-396.4739151237843754958939772727577263768")
    r085 = convert(T, big" 719.1787707014182914108130834128646525498")
    r086 = convert(T, big"-605.3681033918824350795711030652978269725")
    r087 = convert(T, big" 191.2743989279793520691961908384572824802")
    r092 = convert(T, big" 2.764708833638599139713222853969606774131")
    r093 = convert(T, big"-27.93460263739046178114640484830267988046")
    r094 = convert(T, big" 109.5477918613789217803046856340175757800")
    r095 = convert(T, big"-198.7128113064482116421691972646370773711")
    r096 = convert(T, big" 167.2663357164031670694252647113936863857")
    r097 = convert(T, big"-52.85010499525706346613022509203974406942")
    r112 = convert(T, big"-2.169632028016350481156919876642428429100")
    r113 = convert(T, big" 22.01669603756987625585768587320929912766")
    r114 = convert(T, big"-86.90152427798948350846176288615482496306")
    r115 = convert(T, big" 159.2238897386147443720253338471077193471")
    r116 = convert(T, big"-135.9618306534587908363115231453760181702")
    r117 = convert(T, big" 43.79240118328000419804718618785625308759")
    r122 = convert(T, big"-4.890070188793803933769786966428026149549")
    r123 = convert(T, big" 22.75407737425176120799532459991506803585")
    r124 = convert(T, big"-30.78034218537730965082079824005797506535")
    r125 = convert(T, big"-2.797194317207249021142015125037024035537")
    r126 = convert(T, big" 31.36945663750840183161406140272783187147")
    r127 = convert(T, big"-15.65592732038180043387678567111987465689")
    r132 = convert(T, big" 10.86217092955196715517224349929627754387")
    r133 = convert(T, big"-50.54297141782710697188187875653305700081")
    r134 = convert(T, big" 68.37148040407511827604242008548181691494")
    r135 = convert(T, big" 6.213326521632409162585500428935637861213")
    r136 = convert(T, big"-69.68006323194158104163196358466588618336")
    r137 = convert(T, big" 34.77605679450919341971367832748521086414")
    r142 = convert(T, big"-11.37286691922922915922346687401389055763")
    r143 = convert(T, big" 130.7905807824671644130452602841032046030")
    r144 = convert(T, big"-488.6511367778560207543260583489312609826")
    r145 = convert(T, big" 832.2148793276440873476229585070779183432")
    r146 = convert(T, big"-664.7743368554426242883314487337054193624")
    r147 = convert(T, big" 201.7928804424166224412127551654694479565")
    r152 = convert(T, big"-5.919778732715006698693070786679427540601")
    r153 = convert(T, big" 63.27679965889218829298274978013773800731")
    r154 = convert(T, big"-265.4326820887379575820873554556433306580")
    r155 = convert(T, big" 520.1009254140610824835871087519714692468")
    r156 = convert(T, big"-467.4121095339020118993777963241667608460")
    r157 = convert(T, big" 155.3868452824017054035883640343803117904")
    r162 = convert(T, big"-10.49214619796182281022379415510181241136")
    r163 = convert(T, big" 105.3553852518801101042787230303396283676")
    r164 = convert(T, big"-409.4397501198893846479834816688367917005")
    r165 = convert(T, big" 732.8314489076540326880337353277812147333")
    r166 = convert(T, big"-606.3044574733512377981129469949015057785")
    r167 = convert(T, big" 188.0495196316683024640077644607192667895")

    Vern7InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r042, r043,
        r044, r045, r046, r047, r052, r053, r054, r055, r056,
        r057, r062, r063, r064, r065, r066, r067, r072, r073,
        r074, r075, r076, r077, r082, r083, r084, r085, r086,
        r087, r092, r093, r094, r095, r096, r097, r112, r113,
        r114, r115, r116, r117, r122, r123, r124, r125, r126,
        r127, r132, r133, r134, r135, r136, r137, r142, r143,
        r144, r145, r146, r147, r152, r153, r154, r155, r156,
        r157, r162, r163, r164, r165, r166, r167)
end

struct Vern7Tableau{T, T2}
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    a021::T
    a031::T
    a032::T
    a041::T
    a043::T
    a051::T
    a053::T
    a054::T
    a061::T
    a063::T
    a064::T
    a065::T
    a071::T
    a073::T
    a074::T
    a075::T
    a076::T
    a081::T
    a083::T
    a084::T
    a085::T
    a086::T
    a087::T
    a091::T
    a093::T
    a094::T
    a095::T
    a096::T
    a097::T
    a098::T
    a101::T
    a103::T
    a104::T
    a105::T
    a106::T
    a107::T
    b1::T
    b4::T
    b5::T
    b6::T
    b7::T
    b8::T
    b9::T
    btilde1::T
    btilde4::T
    btilde5::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    btilde10::T
end

@fold function Vern7Tableau(::Type{T},
        ::Type{T2}) where {T <: CompiledFloats, T2 <: CompiledFloats}
    c2 = convert(T2, 0.005)
    c3 = convert(T2, 0.10888888888888888)
    c4 = convert(T2, 0.16333333333333333)
    c5 = convert(T2, 0.4555)
    c6 = convert(T2, 0.6095094489978381)
    c7 = convert(T2, 0.884)
    c8 = convert(T2, 0.925)
    a021 = convert(T, 0.005)
    a031 = convert(T, -1.07679012345679)
    a032 = convert(T, 1.185679012345679)
    a041 = convert(T, 0.04083333333333333)
    a043 = convert(T, 0.1225)
    a051 = convert(T, 0.6389139236255726)
    a053 = convert(T, -2.455672638223657)
    a054 = convert(T, 2.272258714598084)
    a061 = convert(T, -2.6615773750187572)
    a063 = convert(T, 10.804513886456137)
    a064 = convert(T, -8.3539146573962)
    a065 = convert(T, 0.820487594956657)
    a071 = convert(T, 6.067741434696772)
    a073 = convert(T, -24.711273635911088)
    a074 = convert(T, 20.427517930788895)
    a075 = convert(T, -1.9061579788166472)
    a076 = convert(T, 1.006172249242068)
    a081 = convert(T, 12.054670076253203)
    a083 = convert(T, -49.75478495046899)
    a084 = convert(T, 41.142888638604674)
    a085 = convert(T, -4.461760149974004)
    a086 = convert(T, 2.042334822239175)
    a087 = convert(T, -0.09834843665406107)
    a091 = convert(T, 10.138146522881808)
    a093 = convert(T, -42.6411360317175)
    a094 = convert(T, 35.76384003992257)
    a095 = convert(T, -4.3480228403929075)
    a096 = convert(T, 2.0098622683770357)
    a097 = convert(T, 0.3487490460338272)
    a098 = convert(T, -0.27143900510483127)
    a101 = convert(T, -45.030072034298676)
    a103 = convert(T, 187.3272437654589)
    a104 = convert(T, -154.02882369350186)
    a105 = convert(T, 18.56465306347536)
    a106 = convert(T, -7.141809679295079)
    a107 = convert(T, 1.3088085781613787)
    b1 = convert(T, 0.04715561848627222)
    b4 = convert(T, 0.25750564298434153)
    b5 = convert(T, 0.26216653977412624)
    b6 = convert(T, 0.15216092656738558)
    b7 = convert(T, 0.4939969170032485)
    b8 = convert(T, -0.29430311714032503)
    b9 = convert(T, 0.08131747232495111)
    # bhat1     =  convert(T,0.044608606606341174)
    # bhat4     =  convert(T,0.26716403785713727)
    # bhat5     =  convert(T,0.22010183001772932)
    # bhat6     =  convert(T,0.2188431703143157)
    # bhat7     =  convert(T,0.22898717054112028)
    # bhat10    =  convert(T,0.02029518466335628)
    btilde1 = convert(T, 0.002547011879931045)
    btilde4 = convert(T, -0.00965839487279575)
    btilde5 = convert(T, 0.04206470975639691)
    btilde6 = convert(T, -0.0666822437469301)
    btilde7 = convert(T, 0.2650097464621281)
    btilde8 = convert(T, -0.29430311714032503)
    btilde9 = convert(T, 0.08131747232495111)
    btilde10 = convert(T, -0.02029518466335628)

    Vern7Tableau(
        c2, c3, c4, c5, c6, c7, c8, a021, a031, a032, a041, a043, a051, a053, a054,
        a061, a063, a064, a065, a071, a073, a074, a075, a076, a081, a083, a084,
        a085, a086, a087, a091, a093, a094, a095, a096, a097, a098, a101, a103,
        a104, a105, a106, a107, b1, b4, b5, b6, b7, b8, b9, btilde1, btilde4,
        btilde5, btilde6, btilde7, btilde8, btilde9, btilde10)
end

@fold function Vern7Tableau(::Type{T}, ::Type{T2}) where {T, T2}
    c2 = convert(T2, 1 // 200)
    c3 = convert(T2, 49 // 450)
    c4 = convert(T2, 49 // 300)
    c5 = convert(T2, 911 // 2000)
    c6 = convert(T2, 3480084980 // 5709648941)
    c7 = convert(T2, 221 // 250)
    c8 = convert(T2, 37 // 40)
    a021 = convert(T, 1 // 200)
    a031 = convert(T, -4361 // 4050)
    a032 = convert(T, 2401 // 2025)
    a041 = convert(T, 49 // 1200)
    a043 = convert(T, 49 // 400)
    a051 = convert(T, 2454451729 // 3841600000)
    a053 = convert(T, -9433712007 // 3841600000)
    a054 = convert(T, 4364554539 // 1920800000)
    a061 = convert(T,
        -BigInt(6187101755456742839167388910402379177523537620) //
        BigInt(2324599620333464857202963610201679332423082271))
    a063 = convert(T,
        BigInt(27569888999279458303270493567994248533230000) //
        BigInt(2551701010245296220859455115479340650299761))
    a064 = convert(T,
        -BigInt(37368161901278864592027018689858091583238040000) //
        BigInt(4473131870960004275166624817435284159975481033))
    a065 = convert(T,
        BigInt(1392547243220807196190880383038194667840000000) //
        BigInt(1697219131380493083996999253929006193143549863))
    a071 = convert(T, 11272026205260557297236918526339 // 1857697188743815510261537500000)
    a073 = convert(T, -48265918242888069 // 1953194276993750)
    a074 = convert(T, 26726983360888651136155661781228 // 1308381343805114800955157615625)
    a075 = convert(T, -2090453318815827627666994432 // 1096684189897834170412307919)
    a076 = convert(T,
        BigInt(1148577938985388929671582486744843844943428041509) //
        BigInt(1141532118233823914568777901158338927629837500000))
    a081 = convert(T,
        BigInt(1304457204588839386329181466225966641) //
        BigInt(108211771565488329642169667802016000))
    a083 = convert(T, -1990261989751005 // 40001418792832)
    a084 = convert(T,
        BigInt(2392691599894847687194643439066780106875) //
        BigInt(58155654089143548047476915856270826016))
    a085 = convert(T,
        -BigInt(1870932273351008733802814881998561250) //
        BigInt(419326053051486744762255151208232123))
    a086 = convert(T,
        BigInt(1043329047173803328972823866240311074041739158858792987034783181) //
        BigInt(510851127745017966999893975119259285040213723744255237522144000))
    a087 = convert(T, -311918858557595100410788125 // 3171569057622789618800376448)
    a091 = convert(T,
        BigInt(17579784273699839132265404100877911157) //
        BigInt(1734023495717116205617154737841023480))
    a093 = convert(T, -18539365951217471064750 // 434776548575709731377)
    a094 = convert(T,
        BigInt(447448655912568142291911830292656995992000) //
        BigInt(12511202807447096607487664209063950964109))
    a095 = convert(T,
        -BigInt(65907597316483030274308429593905808000000) //
        BigInt(15158061430635748897861852383197382130691))
    a096 = convert(T,
        BigInt(273847823027445129865693702689010278588244606493753883568739168819449761) //
        BigInt(136252034448398939768371761610231099586032870552034688235302796640584360))
    a097 = convert(T,
        BigInt(694664732797172504668206847646718750) //
        BigInt(1991875650119463976442052358853258111))
    a098 = convert(T,
        -19705319055289176355560129234220800 //
        72595753317320295604316217197876507)
    a101 = convert(T,
        -511858190895337044664743508805671 // 11367030248263048398341724647960)
    a103 = convert(T, 2822037469238841750 // 15064746656776439)
    a104 = convert(T,
        -BigInt(23523744880286194122061074624512868000) //
        BigInt(152723005449262599342117017051789699))
    a105 = convert(T,
        BigInt(10685036369693854448650967542704000000) //
        BigInt(575558095977344459903303055137999707))
    a106 = convert(T,
        -BigInt(6259648732772142303029374363607629515525848829303541906422993) //
        BigInt(876479353814142962817551241844706205620792843316435566420120))
    a107 = convert(T,
        17380896627486168667542032602031250 //
        13279937889697320236613879977356033)
    b1 = convert(T, 96762636172307789 // 2051985304794103980)
    b4 = convert(T, 312188947591288252500000 // 1212357694274963646019729)
    b5 = convert(T, 13550580884964304000000000000 // 51686919683339547115937980629)
    b6 = convert(T,
        BigInt(72367769693133178898676076432831566019684378142853445230956642801) //
        BigInt(475600216991873963561768100160364792981629064220601844848928537580))
    b7 = convert(T, 1619421054120605468750 // 3278200730370057108183)
    b8 = convert(T, -66898316144057728000 // 227310933007074849597)
    b9 = convert(T, 181081444637946577 // 2226845467039736466)
    # bhat1     =  convert(T,117807213929927//2640907728177740)
    # bhat4     =  convert(T,4758744518816629500000//17812069906509312711137)
    # bhat5     =  convert(T,1730775233574080000000000//7863520414322158392809673)
    # bhat6     =  convert(T,BigInt(2682653613028767167314032381891560552585218935572349997)//BigInt(12258338284789875762081637252125169126464880985167722660))
    # bhat7     =  convert(T,40977117022675781250//178949401077111131341)
    # bhat10    =  convert(T,2152106665253777//106040260335225546)
    btilde1 = convert(T, 522643094875451 // 205198530479410398)
    btilde4 = convert(T, -550343178903849903000000 // 56980811630923291362927263)
    btilde5 = convert(T, 197654115880170560000000000 // 4698810880303595192357998239)
    btilde6 = convert(T,
        BigInt(-3171408959554499061315206389277085667739969057641653677018211151) //
        BigInt(47560021699187396356176810016036479298162906422060184484892853758))
    btilde7 = convert(T, 40831491787144609375000 // 154075434327392684084601)
    btilde8 = convert(T, -66898316144057728000 // 227310933007074849597)
    btilde9 = convert(T, 181081444637946577 // 2226845467039736466)
    btilde10 = convert(T, -2152106665253777 // 106040260335225546)

    Vern7Tableau(
        c2, c3, c4, c5, c6, c7, c8, a021, a031, a032, a041, a043, a051, a053, a054,
        a061, a063, a064, a065, a071, a073, a074, a075, a076, a081, a083, a084,
        a085, a086, a087, a091, a093, a094, a095, a096, a097, a098, a101, a103,
        a104, a105, a106, a107, b1, b4, b5, b6, b7, b8, b9, btilde1, btilde4,
        btilde5, btilde6, btilde7, btilde8, btilde9, btilde10)
end

## Vern8
struct Vern8ExtraStages{T, T2}
    c14::T2
    a1401::T
    a1406::T
    a1407::T
    a1408::T
    a1409::T
    a1410::T
    a1411::T
    a1412::T
    c15::T2
    a1501::T
    a1506::T
    a1507::T
    a1508::T
    a1509::T
    a1510::T
    a1511::T
    a1512::T
    a1514::T
    c16::T2
    a1601::T
    a1606::T
    a1607::T
    a1608::T
    a1609::T
    a1610::T
    a1611::T
    a1612::T
    a1614::T
    a1615::T
    c17::T2
    a1701::T
    a1706::T
    a1707::T
    a1708::T
    a1709::T
    a1710::T
    a1711::T
    a1712::T
    a1714::T
    a1715::T
    a1716::T
    c18::T2
    a1801::T
    a1806::T
    a1807::T
    a1808::T
    a1809::T
    a1810::T
    a1811::T
    a1812::T
    a1814::T
    a1815::T
    a1816::T
    a1817::T
    c19::T2
    a1901::T
    a1906::T
    a1907::T
    a1908::T
    a1909::T
    a1910::T
    a1911::T
    a1912::T
    a1914::T
    a1915::T
    a1916::T
    a1917::T
    c20::T2
    a2001::T
    a2006::T
    a2007::T
    a2008::T
    a2009::T
    a2010::T
    a2011::T
    a2012::T
    a2014::T
    a2015::T
    a2016::T
    a2017::T
    c21::T2
    a2101::T
    a2106::T
    a2107::T
    a2108::T
    a2109::T
    a2110::T
    a2111::T
    a2112::T
    a2114::T
    a2115::T
    a2116::T
    a2117::T
end

function Vern8ExtraStages(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c14 = convert(T2, 1)
    a1401 = convert(T, 0.04427989419007951)
    a1406 = convert(T, 0.3541049391724449)
    a1407 = convert(T, 0.2479692154956438)
    a1408 = convert(T, -15.694202038838084)
    a1409 = convert(T, 25.084064965558564)
    a1410 = convert(T, -31.738367786260277)
    a1411 = convert(T, 22.938283273988784)
    a1412 = convert(T, -0.2361324633071542)
    c15 = convert(T2, 0.3110177634953864)
    a1501 = convert(T, 0.04620700646754963)
    a1506 = convert(T, 0.045039041608424805)
    a1507 = convert(T, 0.23368166977134244)
    a1508 = convert(T, 37.83901368421068)
    a1509 = convert(T, -15.949113289454246)
    a1510 = convert(T, 23.028368351816102)
    a1511 = convert(T, -44.85578507769412)
    a1512 = convert(T, -0.06379858768647444)
    a1514 = convert(T, -0.012595035543861663)
    c16 = convert(T2, 0.1725)
    a1601 = convert(T, 0.05037946855482041)
    a1606 = convert(T, 0.041098361310460796)
    a1607 = convert(T, 0.17180541533481958)
    a1608 = convert(T, 4.614105319981519)
    a1609 = convert(T, -1.7916678830853965)
    a1610 = convert(T, 2.531658930485041)
    a1611 = convert(T, -5.324977860205731)
    a1612 = convert(T, -0.03065532595385635)
    a1614 = convert(T, -0.005254479979429613)
    a1615 = convert(T, -0.08399194644224793)
    c17 = convert(T2, 0.7846)
    a1701 = convert(T, 0.0408289713299708)
    a1706 = convert(T, 0.4244479514247632)
    a1707 = convert(T, 0.23260915312752345)
    a1708 = convert(T, 2.677982520711806)
    a1709 = convert(T, 0.7420826657338945)
    a1710 = convert(T, 0.1460377847941461)
    a1711 = convert(T, -3.579344509890565)
    a1712 = convert(T, 0.11388443896001738)
    a1714 = convert(T, 0.012677906510331901)
    a1715 = convert(T, -0.07443436349946675)
    a1716 = convert(T, 0.047827480797578516)
    c18 = convert(T2, 0.37)
    a1801 = convert(T, 0.052126823936684136)
    a1806 = convert(T, 0.053925083967447975)
    a1807 = convert(T, 0.01660758097434641)
    a1808 = convert(T, -4.45448575792678)
    a1809 = convert(T, 6.835218278632146)
    a1810 = convert(T, -8.711334822181994)
    a1811 = convert(T, 6.491635839232917)
    a1812 = convert(T, -0.07072551809844346)
    a1814 = convert(T, -0.018540314919932164)
    a1815 = convert(T, 0.023504021054353848)
    a1816 = convert(T, 0.2344795103407822)
    a1817 = convert(T, -0.08241072501152899)
    c19 = convert(T2, 0.5)
    a1901 = convert(T, 0.05020102870355714)
    a1906 = convert(T, 0.1552209034795498)
    a1907 = convert(T, 0.1264268424089235)
    a1908 = convert(T, -5.149206303539847)
    a1909 = convert(T, 8.46834099903693)
    a1910 = convert(T, -10.662130681081495)
    a1911 = convert(T, 7.541833224959729)
    a1912 = convert(T, -0.07436968113832143)
    a1914 = convert(T, -0.020558876866183826)
    a1915 = convert(T, 0.07753795264710298)
    a1916 = convert(T, 0.10462592203525443)
    a1917 = convert(T, -0.11792133064519794)
    c20 = convert(T2, 0.7)
    a2001 = convert(T, 0.03737341446457826)
    a2006 = convert(T, 0.35049307053383166)
    a2007 = convert(T, 0.49226528193730257)
    a2008 = convert(T, 8.553695439359313)
    a2009 = convert(T, -10.353172990305913)
    a2010 = convert(T, 13.83320427252915)
    a2011 = convert(T, -12.280924330784618)
    a2012 = convert(T, 0.17191515956565098)
    a2014 = convert(T, 0.036415831143144964)
    a2015 = convert(T, 0.02961920580288763)
    a2016 = convert(T, -0.2651793938627067)
    a2017 = convert(T, 0.09429503961738067)
    c21 = convert(T2, 0.9)
    a2101 = convert(T, 0.039390583455282506)
    a2106 = convert(T, 0.3558516141234424)
    a2107 = convert(T, 0.419738222595261)
    a2108 = convert(T, 0.8720449778071941)
    a2109 = convert(T, 0.8989520834876595)
    a2110 = convert(T, -0.6305806161059884)
    a2111 = convert(T, -1.1218872205954835)
    a2112 = convert(T, 0.04298219512400197)
    a2114 = convert(T, 0.013325575668739157)
    a2115 = convert(T, 0.018762270539641482)
    a2116 = convert(T, -0.18594111329221055)
    a2117 = convert(T, 0.17736142719246029)

    Vern8ExtraStages(c14, a1401, a1406, a1407, a1408, a1409, a1410, a1411, a1412, c15,
        a1501, a1506, a1507, a1508, a1509, a1510, a1511, a1512, a1514, c16,
        a1601, a1606, a1607, a1608, a1609, a1610, a1611, a1612, a1614, a1615,
        c17, a1701, a1706, a1707, a1708, a1709, a1710, a1711, a1712, a1714,
        a1715, a1716, c18, a1801, a1806, a1807, a1808, a1809, a1810, a1811,
        a1812, a1814, a1815, a1816, a1817, c19, a1901, a1906, a1907, a1908,
        a1909, a1910, a1911, a1912, a1914, a1915, a1916, a1917, c20, a2001,
        a2006, a2007, a2008, a2009, a2010, a2011, a2012, a2014, a2015, a2016,
        a2017, c21, a2101, a2106, a2107, a2108, a2109, a2110, a2111, a2112,
        a2114, a2115, a2116, a2117)
end

function Vern8ExtraStages(T, T2)
    c14 = convert(T2, 1)
    a1401 = convert(T, big" .4427989419007951074716746668098518862111e-1")
    a1406 = convert(T, big" .3541049391724448744815552028733568354121")
    a1407 = convert(T, big" .2479692154956437828667629415370663023884")
    a1408 = convert(T, big"-15.69420203883808405099207034271191213468")
    a1409 = convert(T, big" 25.08406496555856261343930031237186278518")
    a1410 = convert(T, big"-31.73836778626027646833156112007297739997")
    a1411 = convert(T, big" 22.93828327398878395231483560344797018313")
    a1412 = convert(T, big"-.2361324633071542145259900641263517600737")
    c15 = convert(T2, big" .3110177634953863863927417318829099695921")
    a1501 = convert(T, big" .4620700646754963101730413150238116432863e-1")
    a1506 = convert(T, big" .4503904160842480866828520384400679697151e-1")
    a1507 = convert(T, big" .2336816697713424410788701065340221126565")
    a1508 = convert(T, big" 37.83901368421067410780338220861855254153")
    a1509 = convert(T, big"-15.94911328945424610266139490307397370835")
    a1510 = convert(T, big" 23.02836835181610285142510596329590091940")
    a1511 = convert(T, big"-44.85578507769412524816130998016948002745")
    a1512 = convert(T, big"-.6379858768647444009509067402330140781326e-1")
    a1514 = convert(T, big"-.1259503554386166268241032464519842162533e-1")
    c16 = convert(T2, 69 // 400)
    a1601 = convert(T, big" .5037946855482040993065158747220696112586e-1")
    a1606 = convert(T, big" .4109836131046079339916530614028848248545e-1")
    a1607 = convert(T, big" .1718054153348195783296309209549424619697")
    a1608 = convert(T, big" 4.61410531998151886974342237185977124648")
    a1609 = convert(T, big"-1.791667883085396449712744996746836471721")
    a1610 = convert(T, big" 2.531658930485041408462243518792913614971")
    a1611 = convert(T, big"-5.32497786020573071925718815977276269909")
    a1612 = convert(T, big"-.3065532595385634734924449496356513113607e-1")
    a1614 = convert(T, big"-.5254479979429613570549519094377878106127e-2")
    a1615 = convert(T, big"-.8399194644224792997538653464258058697156e-1")
    c17 = convert(T2, 7846 // 10000)
    a1701 = convert(T, big" .4082897132997079620207118756242653796386e-1")
    a1706 = convert(T, big" .4244479514247632218892086657732332485609")
    a1707 = convert(T, big" .2326091531275234539465100096964845486081")
    a1708 = convert(T, big" 2.677982520711806062780528871014035962908")
    a1709 = convert(T, big" .7420826657338945216477607044022963622057")
    a1710 = convert(T, big" .1460377847941461193920992339731312296021")
    a1711 = convert(T, big"-3.579344509890565218033356743825917680543")
    a1712 = convert(T, big" .1138844389600173704531638716149985665239")
    a1714 = convert(T, big" .1267790651033190047378693537615687232109e-1")
    a1715 = convert(T, big"-.7443436349946674429752785032561552478382e-1")
    a1716 = convert(T, big" .4782748079757851554575511473876987663388e-1")
    c18 = convert(T2, 37 // 100)
    a1801 = convert(T, big" .5212682393668413629928136927994514676607e-1")
    a1806 = convert(T, big" .5392508396744797718209106862347065628649e-1")
    a1807 = convert(T, big" .1660758097434640828541930599928251901718e-1")
    a1808 = convert(T, big"-4.454485757926779655418936993298463071587")
    a1809 = convert(T, big" 6.835218278632146381711296817968152631469")
    a1810 = convert(T, big"-8.711334822181993739847172734848837971169")
    a1811 = convert(T, big" 6.491635839232917053651267142703105653517")
    a1812 = convert(T, big"-.7072551809844346422069985227700294651922e-1")
    a1814 = convert(T, big"-.1854031491993216429111842937941202966440e-1")
    a1815 = convert(T, big" .2350402105435384645116542087045962190647e-1")
    a1816 = convert(T, big" .2344795103407822090556377813402774776461")
    a1817 = convert(T, big"-.8241072501152898885823089698097768766651e-1")
    c19 = convert(T2, 1 // 2)
    a1901 = convert(T, big" .5020102870355713598699964419977883461362e-1")
    a1906 = convert(T, big" .1552209034795498114932226104700567642339")
    a1907 = convert(T, big" .1264268424089234914713091134864747506300")
    a1908 = convert(T, big"-5.14920630353984701704917414605721854951")
    a1909 = convert(T, big" 8.46834099903692926607453176331494311551")
    a1910 = convert(T, big"-10.66213068108149527544209836207095498430")
    a1911 = convert(T, big" 7.54183322495972836290996201569018333903")
    a1912 = convert(T, big"-.743696811383214243944066492459357053774e-1")
    a1914 = convert(T, big"-.2055887686618382619339821759221121764364e-1")
    a1915 = convert(T, big" .775379526471029807261782993777862395844e-1")
    a1916 = convert(T, big" .1046259220352544296313761971333987587377")
    a1917 = convert(T, big"-.1179213306451979352145022687063013455111")
    c20 = convert(T2, 7 // 10)
    a2001 = convert(T, big" .3737341446457825692757506548800094134977e-1")
    a2006 = convert(T, big" .3504930705338316406767087468339071089224")
    a2007 = convert(T, big" .4922652819373025433298989824173484805373")
    a2008 = convert(T, big" 8.553695439359312242284304421725315855379")
    a2009 = convert(T, big"-10.35317299030591348532574006719207803272")
    a2010 = convert(T, big" 13.83320427252914990351082875460544773493")
    a2011 = convert(T, big"-12.28092433078461863729523583784519048012")
    a2012 = convert(T, big" .1719151595656509762746810113378644307112")
    a2014 = convert(T, big" .3641583114314496380113822384214528216140e-1")
    a2015 = convert(T, big" .2961920580288763054890146412520723429115e-1")
    a2016 = convert(T, big"-.2651793938627067002647615623738425030047")
    a2017 = convert(T, big" .942950396173806655317007970358739475630e-1")
    c21 = convert(T2, 9 // 10)
    a2101 = convert(T, big" .3939058345528250943410670634923521987132e-1")
    a2106 = convert(T, big" .3558516141234424183136697322755323715063")
    a2107 = convert(T, big" .4197382225952610029372225526720065366258")
    a2108 = convert(T, big" .872044977807194166293172525204036071060")
    a2109 = convert(T, big" .898952083487659486126627160171417043611")
    a2110 = convert(T, big"-.630580616105988359023456649527853470403")
    a2111 = convert(T, big"-1.121887220595483550736681645425215081433")
    a2112 = convert(T, big" .4298219512400197176967511031829197714867e-1")
    a2114 = convert(T, big" .1332557566873915707013495891889190564164e-1")
    a2115 = convert(T, big" .1876227053964148034446101291928097773800e-1")
    a2116 = convert(T, big"-.1859411132922105570515379368592596513699")
    a2117 = convert(T, big" .1773614271924602745226064729836361000042")

    Vern8ExtraStages(c14, a1401, a1406, a1407, a1408, a1409, a1410, a1411, a1412, c15,
        a1501, a1506, a1507, a1508, a1509, a1510, a1511, a1512, a1514, c16,
        a1601, a1606, a1607, a1608, a1609, a1610, a1611, a1612, a1614, a1615,
        c17, a1701, a1706, a1707, a1708, a1709, a1710, a1711, a1712, a1714,
        a1715, a1716, c18, a1801, a1806, a1807, a1808, a1809, a1810, a1811,
        a1812, a1814, a1815, a1816, a1817, c19, a1901, a1906, a1907, a1908,
        a1909, a1910, a1911, a1912, a1914, a1915, a1916, a1917, c20, a2001,
        a2006, a2007, a2008, a2009, a2010, a2011, a2012, a2014, a2015, a2016,
        a2017, c21, a2101, a2106, a2107, a2108, a2109, a2110, a2111, a2112,
        a2114, a2115, a2116, a2117)
end

struct Vern8InterpolationCoefficients{T}
    r011::T
    r012::T
    r013::T
    r014::T
    r015::T
    r016::T
    r017::T
    r018::T
    r062::T
    r063::T
    r064::T
    r065::T
    r066::T
    r067::T
    r068::T
    r072::T
    r073::T
    r074::T
    r075::T
    r076::T
    r077::T
    r078::T
    r082::T
    r083::T
    r084::T
    r085::T
    r086::T
    r087::T
    r088::T
    r092::T
    r093::T
    r094::T
    r095::T
    r096::T
    r097::T
    r098::T
    r102::T
    r103::T
    r104::T
    r105::T
    r106::T
    r107::T
    r108::T
    r112::T
    r113::T
    r114::T
    r115::T
    r116::T
    r117::T
    r118::T
    r122::T
    r123::T
    r124::T
    r125::T
    r126::T
    r127::T
    r128::T
    r142::T
    r143::T
    r144::T
    r145::T
    r146::T
    r147::T
    r148::T
    r152::T
    r153::T
    r154::T
    r155::T
    r156::T
    r157::T
    r158::T
    r162::T
    r163::T
    r164::T
    r165::T
    r166::T
    r167::T
    r168::T
    r172::T
    r173::T
    r174::T
    r175::T
    r176::T
    r177::T
    r178::T
    r182::T
    r183::T
    r184::T
    r185::T
    r186::T
    r187::T
    r188::T
    r192::T
    r193::T
    r194::T
    r195::T
    r196::T
    r197::T
    r198::T
    r202::T
    r203::T
    r204::T
    r205::T
    r206::T
    r207::T
    r208::T
    r212::T
    r213::T
    r214::T
    r215::T
    r216::T
    r217::T
    r218::T
end

function Vern8InterpolationCoefficients(T::Type{<:CompiledFloats})
    r011 = convert(T, 1)
    r012 = convert(T, -10.039154650554519)
    r013 = convert(T, 53.79210495862331)
    r014 = convert(T, -165.0579057235472)
    r015 = convert(T, 298.026456543461)
    r016 = convert(T, -311.91254487079004)
    r017 = convert(T, 174.60598526911716)
    r018 = convert(T, -40.37066163211959)
    r062 = convert(T, 158.1976739121776)
    r063 = convert(T, -1543.96141721949)
    r064 = convert(T, 6241.39874782878)
    r065 = convert(T, -13136.516156406109)
    r066 = convert(T, 15106.948493169599)
    r067 = convert(T, -8996.489626298231)
    r068 = convert(T, 2170.776389952444)
    r072 = convert(T, 110.78115200797782)
    r073 = convert(T, -1081.1905145356177)
    r074 = convert(T, 4370.666940459977)
    r075 = convert(T, -9199.113723922197)
    r076 = convert(T, 10578.949209629855)
    r077 = convert(T, -6299.975594978841)
    r078 = convert(T, 1520.1305005543413)
    r082 = convert(T, -7011.442038211314)
    r083 = convert(T, 68429.55220744078)
    r084 = convert(T, -276623.5714822198)
    r085 = convert(T, 582220.4545548494)
    r086 = convert(T, -669551.5244611246)
    r087 = convert(T, 398731.3087623333)
    r088 = convert(T, -96210.47174510667)
    r092 = convert(T, 11206.397569848148)
    r093 = convert(T, -109371.04854950662)
    r094 = convert(T, 442127.8393698155)
    r095 = convert(T, -930563.7629864562)
    r096 = convert(T, 1.0701451335855902e6)
    r097 = convert(T, -637292.8058429047)
    r098 = convert(T, 153773.3309185794)
    r102 = convert(T, -14179.231640455684)
    r103 = convert(T, 138385.00931963572)
    r104 = convert(T, -559415.549024087)
    r105 = convert(T, 1.1774237946992505e6)
    r106 = convert(T, -1.3540333227908213e6)
    r107 = convert(T, 806353.893882505)
    r108 = convert(T, -194566.3328138133)
    r112 = convert(T, 10247.761767921746)
    r113 = convert(T, -100015.05326375231)
    r114 = convert(T, 404306.62401434296)
    r115 = convert(T, -850959.9711689702)
    r116 = convert(T, 978601.0462088685)
    r117 = convert(T, -582776.4729907749)
    r118 = convert(T, 140619.0037156383)
    r122 = convert(T, -105.49303976850968)
    r123 = convert(T, 1029.5801395803103)
    r124 = convert(T, -4162.034181876453)
    r125 = convert(T, 8759.996193602336)
    r126 = convert(T, -10073.965556886049)
    r127 = convert(T, 5999.247741473951)
    r128 = convert(T, -1447.5674285888924)
    r142 = convert(T, -14.863613373267432)
    r143 = convert(T, 145.76359364894867)
    r144 = convert(T, -587.6557063401914)
    r145 = convert(T, 1227.3721512545558)
    r146 = convert(T, -1394.4931057405536)
    r147 = convert(T, 816.8562950730669)
    r148 = convert(T, -192.97961452255882)
    r152 = convert(T, 14.349685752905462)
    r153 = convert(T, -150.29493444816657)
    r154 = convert(T, 629.481242570029)
    r155 = convert(T, -1352.5182073090607)
    r156 = convert(T, 1575.8969337088804)
    r157 = convert(T, -946.7876580472948)
    r158 = convert(T, 229.87293777270722)
    r162 = convert(T, -102.54524701110401)
    r163 = convert(T, 1074.0326612646807)
    r164 = convert(T, -4498.377917100411)
    r165 = convert(T, 9665.320624003281)
    r166 = convert(T, -11261.62224831288)
    r167 = convert(T, 6765.902468760784)
    r168 = convert(T, -1642.7103416043497)
    r172 = convert(T, -38.13206313286474)
    r173 = convert(T, 399.3854658292329)
    r174 = convert(T, -1672.7487204919717)
    r175 = convert(T, 3594.1072548585666)
    r176 = convert(T, -4187.7015568029265)
    r177 = convert(T, 2515.9412806490636)
    r178 = convert(T, -610.8516609091005)
    r182 = convert(T, -66.38279583069588)
    r183 = convert(T, 595.8297683881103)
    r184 = convert(T, -2188.7370600929717)
    r185 = convert(T, 4213.839795282853)
    r186 = convert(T, -4484.035731929197)
    r187 = convert(T, 2500.6482514253466)
    r188 = convert(T, -571.1622272434449)
    r192 = convert(T, -90.4188757317306)
    r193 = convert(T, 931.9503884048154)
    r194 = convert(T, -3962.898377713156)
    r195 = convert(T, 8733.31742002555)
    r196 = convert(T, -10445.908189887661)
    r197 = convert(T, 6426.218942917599)
    r198 = convert(T, -1592.261308015418)
    r202 = convert(T, -59.738843630388715)
    r203 = convert(T, 544.8870146891725)
    r204 = convert(T, -2090.4303749263127)
    r205 = convert(T, 4194.418982707227)
    r206 = convert(T, -4603.369436819628)
    r207 = convert(T, 2619.2014135592976)
    r208 = convert(T, -604.9687555793671)
    r212 = convert(T, -59.20053764683937)
    r213 = convert(T, 571.7660156218088)
    r214 = convert(T, -2308.9495644453605)
    r215 = convert(T, 4881.2341106861395)
    r216 = convert(T, -5660.118807771202)
    r217 = convert(T, 3408.7066890374217)
    r218 = convert(T, -833.4379054819676)

    Vern8InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r018, r062,
        r063, r064, r065, r066, r067, r068, r072, r073, r074,
        r075, r076, r077, r078, r082, r083, r084, r085, r086,
        r087, r088, r092, r093, r094, r095, r096, r097, r098,
        r102, r103, r104, r105, r106, r107, r108, r112, r113,
        r114, r115, r116, r117, r118, r122, r123, r124, r125,
        r126, r127, r128, r142, r143, r144, r145, r146, r147,
        r148, r152, r153, r154, r155, r156, r157, r158, r162,
        r163, r164, r165, r166, r167, r168, r172, r173, r174,
        r175, r176, r177, r178, r182, r183, r184, r185, r186,
        r187, r188, r192, r193, r194, r195, r196, r197, r198,
        r202, r203, r204, r205, r206, r207, r208, r212, r213,
        r214, r215, r216, r217, r218)
end

function Vern8InterpolationCoefficients(T)
    r011 = convert(T, big" 1")
    r012 = convert(T, big"-10.03915465055451898280745009553727015838")
    r013 = convert(T, big" 53.79210495862331394937504547285261606206")
    r014 = convert(T, big"-165.0579057235472167092186792753028629327")
    r015 = convert(T, big" 298.0264565434610102489744601822776142620")
    r016 = convert(T, big"-311.9125448707900689751032283191627986699")
    r017 = convert(T, big" 174.6059852691171542761046061351126284335")
    r018 = convert(T, big"-40.37066163211959429657758663355894180800")
    r062 = convert(T, big" 158.1976739121776138067531004299642556045")
    r063 = convert(T, big"-1543.961417219490013383329186557376850919")
    r064 = convert(T, big" 6241.398747828780065219699818963300847515")
    r065 = convert(T, big"-13136.51615640610824674042591770724411138")
    r066 = convert(T, big" 15106.94849316959941770760848348143558467")
    r067 = convert(T, big"-8996.489626298230413000758717864256649583")
    r068 = convert(T, big" 2170.776389952444021264933974457050280938")
    r072 = convert(T, big" 110.7811520079778201620910891542159716196")
    r073 = convert(T, big"-1081.190514535617748557462051373884811281")
    r074 = convert(T, big" 4370.666940459977376891679103587685016930")
    r075 = convert(T, big"-9199.113723922197066947453657458673365167")
    r076 = convert(T, big" 10578.94920962985483690180716390515207397")
    r077 = convert(T, big"-6299.975594978841008450271944308599363057")
    r078 = convert(T, big" 1520.130500554341433782477059435641543286")
    r082 = convert(T, big"-7011.442038211314089634068023254940106045")
    r083 = convert(T, big" 68429.55220744077890209519664603903716349")
    r084 = convert(T, big"-276623.5714822198169288202316196287008724")
    r085 = convert(T, big" 582220.4545548494658856503006312634684934")
    r086 = convert(T, big"-669551.5244611245601905652331468068626208")
    r087 = convert(T, big" 398731.3087623332757943809792249308827732")
    r088 = convert(T, big"-96210.47174510666745715793578288559674281")
    r092 = convert(T, big" 11206.39756984814734031374482605836502113")
    r093 = convert(T, big"-109371.0485495066182770525095928736321803")
    r094 = convert(T, big" 442127.8393698154661543505844693555049508")
    r095 = convert(T, big"-930563.7629864562145364082427559715712707")
    r096 = convert(T, big" 1070145.133585590072636708771436125254933")
    r097 = convert(T, big"-637292.8058429046904373075590712408701797")
    r098 = convert(T, big" 153773.3309185793956820086499888593205888")
    r102 = convert(T, big"-14179.23164045568390825368995504736244876")
    r103 = convert(T, big" 138385.0093196357218693716546019209270760")
    r104 = convert(T, big"-559415.5490240869974273158302752589638112")
    r105 = convert(T, big" 1177423.794699250413603625249340565972051")
    r106 = convert(T, big"-1354033.322790821429356166591306087001182")
    r107 = convert(T, big" 806353.8938825050195016379699232308969498")
    r108 = convert(T, big"-194566.3328138133045593670938904445416121")
    r112 = convert(T, big" 10247.76176792174468727263230424253072668")
    r113 = convert(T, big"-100015.0532637523107509874155382267979521")
    r114 = convert(T, big" 404306.6240143429367125014776377339233105")
    r115 = convert(T, big"-850959.9711689702682710993795157496434280")
    r116 = convert(T, big" 978601.0462088684697300958464199995189771")
    r117 = convert(T, big"-582776.4729907748855939796622931794117500")
    r118 = convert(T, big" 140619.0037156383022701488158207833280861")
    r122 = convert(T, big"-105.4930397685096787379931952745881034169")
    r123 = convert(T, big" 1029.580139580310194120073236423148130618")
    r124 = convert(T, big"-4162.034181876452751021493197688100770349")
    r125 = convert(T, big" 8759.996193602336131526447045580160767641")
    r126 = convert(T, big"-10073.96555688604885441046004449728532151")
    r127 = convert(T, big" 5999.247741473950186438936812025268574829")
    r128 = convert(T, big"-1447.567428588892382130036646632729629570")
    r142 = convert(T, big"-14.86361337326743122469601010648237947608")
    r143 = convert(T, big" 145.7635936489486611601020590400812969906")
    r144 = convert(T, big"-587.6557063401913588520708808169444817103")
    r145 = convert(T, big" 1227.372151254555709980234511427063838550")
    r146 = convert(T, big"-1394.493105740553645217117387304216418608")
    r147 = convert(T, big" 816.8562950730668774494805290335070403105")
    r148 = convert(T, big"-192.9796145225588132959328212730088960570")
    r152 = convert(T, big" 14.34968575290546223276673100484047073648")
    r153 = convert(T, big"-150.2949344481665658851785896351738227010")
    r154 = convert(T, big" 629.4812425700290706612346725243246098946")
    r155 = convert(T, big"-1352.518207309060677914698908083510085133")
    r156 = convert(T, big" 1575.896933708880305858556996706058962503")
    r157 = convert(T, big"-946.7876580472948045886633971120598201035")
    r158 = convert(T, big" 229.8729377727072096359824945955196848017")
    r162 = convert(T, big"-102.5452470111040085560664290210906322518")
    r163 = convert(T, big" 1074.032661264680594125263250545103109541")
    r164 = convert(T, big"-4498.377917100410634753487685261882069653")
    r165 = convert(T, big" 9665.320624003280508099125255751992581938")
    r166 = convert(T, big"-11261.62224831288113545795903649800929060")
    r167 = convert(T, big" 6765.902468760784366342575368188597359812")
    r168 = convert(T, big"-1642.710341604349689799450723704711058784")
    r172 = convert(T, big"-38.13206313286473398334122725888547021750")
    r173 = convert(T, big" 399.3854658292328681862496726489289700594")
    r174 = convert(T, big"-1672.748720491971752312231602599596419744")
    r175 = convert(T, big" 3594.107254858566583822606674735752304040")
    r176 = convert(T, big"-4187.701556802926199931725021751236897492")
    r177 = convert(T, big" 2515.941280649063720613355430002270532846")
    r178 = convert(T, big"-610.8516609091004863949139257772330194915")
    r182 = convert(T, big"-66.38279583069588062871084016403504860018")
    r183 = convert(T, big" 595.8297683881103280237377269355990794854")
    r184 = convert(T, big"-2188.737060092971609278770563269347103559")
    r185 = convert(T, big" 4213.839795282852421559730676511794767863")
    r186 = convert(T, big"-4484.035731929196864370162258757955490985")
    r187 = convert(T, big" 2500.648251425346544829791147364129986790")
    r188 = convert(T, big"-571.1622272434449401356158886201861909946")
    r192 = convert(T, big"-90.41887573173058787343992868450872085904")
    r193 = convert(T, big" 931.9503884048153706496188381219698380844")
    r194 = convert(T, big"-3962.898377713156165984683269799703910403")
    r195 = convert(T, big" 8733.317420025551238329244389917866097896")
    r196 = convert(T, big"-10445.90818988766053535212385670877957360")
    r197 = convert(T, big" 6426.218942917598693647793004359979629852")
    r198 = convert(T, big"-1592.261308015418013416409177206823360972")
    r202 = convert(T, big"-59.73884363038871206457816967313835076801")
    r203 = convert(T, big" 544.8870146891724527559861176467523778088")
    r204 = convert(T, big"-2090.430374926312850791322527518588562537")
    r205 = convert(T, big" 4194.418982707226648046953315742901721971")
    r206 = convert(T, big"-4603.369436819628073439413527693451638704")
    r207 = convert(T, big" 2619.201413559297614510795648037620577207")
    r208 = convert(T, big"-604.9687555793670790184208565420961249773")
    r212 = convert(T, big"-59.20053764683937384859682230934791521325")
    r213 = convert(T, big" 571.7660156218088014286377638724659591261")
    r214 = convert(T, big"-2308.949564445360683785335401047607870804")
    r215 = convert(T, big" 4881.234110686139058221334453291392021952")
    r216 = convert(T, big"-5660.118807771202003386701685793459298252")
    r217 = convert(T, big" 3408.706689037421803199133730396931709513")
    r218 = convert(T, big"-833.4379054819676018284720384103746063216")

    Vern8InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r018, r062,
        r063, r064, r065, r066, r067, r068, r072, r073, r074,
        r075, r076, r077, r078, r082, r083, r084, r085, r086,
        r087, r088, r092, r093, r094, r095, r096, r097, r098,
        r102, r103, r104, r105, r106, r107, r108, r112, r113,
        r114, r115, r116, r117, r118, r122, r123, r124, r125,
        r126, r127, r128, r142, r143, r144, r145, r146, r147,
        r148, r152, r153, r154, r155, r156, r157, r158, r162,
        r163, r164, r165, r166, r167, r168, r172, r173, r174,
        r175, r176, r177, r178, r182, r183, r184, r185, r186,
        r187, r188, r192, r193, r194, r195, r196, r197, r198,
        r202, r203, r204, r205, r206, r207, r208, r212, r213,
        r214, r215, r216, r217, r218)
end

struct Vern8Tableau{T, T2}
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    c11::T2
    a0201::T
    a0301::T
    a0302::T
    a0401::T
    a0403::T
    a0501::T
    a0503::T
    a0504::T
    a0601::T
    a0604::T
    a0605::T
    a0701::T
    a0704::T
    a0705::T
    a0706::T
    a0801::T
    a0804::T
    a0805::T
    a0806::T
    a0807::T
    a0901::T
    a0904::T
    a0905::T
    a0906::T
    a0907::T
    a0908::T
    a1001::T
    a1004::T
    a1005::T
    a1006::T
    a1007::T
    a1008::T
    a1009::T
    a1101::T
    a1104::T
    a1105::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    a1110::T
    a1201::T
    a1204::T
    a1205::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1210::T
    a1211::T
    a1301::T
    a1304::T
    a1305::T
    a1306::T
    a1307::T
    a1308::T
    a1309::T
    a1310::T
    b1::T
    b6::T
    b7::T
    b8::T
    b9::T
    b10::T
    b11::T
    b12::T
    btilde1::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    btilde10::T
    btilde11::T
    btilde12::T
    btilde13::T
    extra::Vern8ExtraStages{T, T2}
    interp::Vern8InterpolationCoefficients{T}
end

function Vern8Tableau(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c2 = convert(T2, 0.05)
    c3 = convert(T2, 0.1065625)
    c4 = convert(T2, 0.15984375)
    c5 = convert(T2, 0.39)
    c6 = convert(T2, 0.465)
    c7 = convert(T2, 0.155)
    c8 = convert(T2, 0.943)
    c9 = convert(T2, 0.901802041735857)
    c10 = convert(T2, 0.909)
    c11 = convert(T2, 0.94)
    #c12   =convert(T2, 1)
    #c13   =convert(T2, 1)
    a0201 = convert(T, 0.05)
    a0301 = convert(T, -0.0069931640625)
    a0302 = convert(T, 0.1135556640625)
    a0401 = convert(T, 0.0399609375)
    a0403 = convert(T, 0.1198828125)
    a0501 = convert(T, 0.36139756280045754)
    a0503 = convert(T, -1.3415240667004928)
    a0504 = convert(T, 1.3701265039000352)
    a0601 = convert(T, 0.049047202797202795)
    a0604 = convert(T, 0.23509720422144048)
    a0605 = convert(T, 0.18085559298135673)
    a0701 = convert(T, 0.06169289044289044)
    a0704 = convert(T, 0.11236568314640277)
    a0705 = convert(T, -0.03885046071451367)
    a0706 = convert(T, 0.01979188712522046)
    a0801 = convert(T, -1.767630240222327)
    a0804 = convert(T, -62.5)
    a0805 = convert(T, -6.061889377376669)
    a0806 = convert(T, 5.6508231982227635)
    a0807 = convert(T, 65.62169641937624)
    a0901 = convert(T, -1.1809450665549708)
    a0904 = convert(T, -41.50473441114321)
    a0905 = convert(T, -4.434438319103725)
    a0906 = convert(T, 4.260408188586133)
    a0907 = convert(T, 43.75364022446172)
    a0908 = convert(T, 0.00787142548991231)
    a1001 = convert(T, -1.2814059994414884)
    a1004 = convert(T, -45.047139960139866)
    a1005 = convert(T, -4.731362069449576)
    a1006 = convert(T, 4.514967016593808)
    a1007 = convert(T, 47.44909557172985)
    a1008 = convert(T, 0.01059228297111661)
    a1009 = convert(T, -0.0057468422638446166)
    a1101 = convert(T, -1.7244701342624853)
    a1104 = convert(T, -60.92349008483054)
    a1105 = convert(T, -5.951518376222392)
    a1106 = convert(T, 5.556523730698456)
    a1107 = convert(T, 63.98301198033305)
    a1108 = convert(T, 0.014642028250414961)
    a1109 = convert(T, 0.06460408772358203)
    a1110 = convert(T, -0.0793032316900888)
    a1201 = convert(T, -3.301622667747079)
    a1204 = convert(T, -118.01127235975251)
    a1205 = convert(T, -10.141422388456112)
    a1206 = convert(T, 9.139311332232058)
    a1207 = convert(T, 123.37594282840426)
    a1208 = convert(T, 4.62324437887458)
    a1209 = convert(T, -3.3832777380682018)
    a1210 = convert(T, 4.527592100324618)
    a1211 = convert(T, -5.828495485811623)
    a1301 = convert(T, -3.039515033766309)
    a1304 = convert(T, -109.26086808941763)
    a1305 = convert(T, -9.290642497400293)
    a1306 = convert(T, 8.43050498176491)
    a1307 = convert(T, 114.20100103783314)
    a1308 = convert(T, -0.9637271342145479)
    a1309 = convert(T, -5.0348840888021895)
    a1310 = convert(T, 5.958130824002923)
    b1 = convert(T, 0.04427989419007951)
    b6 = convert(T, 0.3541049391724449)
    b7 = convert(T, 0.24796921549564377)
    b8 = convert(T, -15.694202038838085)
    b9 = convert(T, 25.084064965558564)
    b10 = convert(T, -31.738367786260277)
    b11 = convert(T, 22.938283273988784)
    b12 = convert(T, -0.2361324633071542)
    # bhat1 = convert(T,0.044312615229089795)
    # bhat6 = convert(T,0.35460956423432266)
    # bhat7 = convert(T,0.2478480431366653)
    # bhat8 = convert(T,4.4481347324757845)
    # bhat9 = convert(T,19.846886366118735)
    # bhat10= convert(T,-23.58162337746562)
    # bhat13= convert(T,-0.36016794372897754)
    btilde1 = convert(T, -3.272103901028138e-5)
    btilde6 = convert(T, -0.0005046250618777704)
    btilde7 = convert(T, 0.0001211723589784759)
    btilde8 = convert(T, -20.142336771313868)
    btilde9 = convert(T, 5.2371785994398286)
    btilde10 = convert(T, -8.156744408794658)
    btilde11 = convert(T, 22.938283273988784)
    btilde12 = convert(T, -0.2361324633071542)
    btilde13 = convert(T, 0.36016794372897754)

    extra = Vern8ExtraStages(T, T2)
    interp = Vern8InterpolationCoefficients(T)

    Vern8Tableau(c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, a0201, a0301, a0302, a0401,
        a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701, a0704, a0705,
        a0706, a0801, a0804, a0805, a0806, a0807, a0901, a0904, a0905, a0906,
        a0907, a0908, a1001, a1004, a1005, a1006, a1007, a1008, a1009, a1101,
        a1104, a1105, a1106, a1107, a1108, a1109, a1110, a1201, a1204, a1205,
        a1206, a1207, a1208, a1209, a1210, a1211, a1301, a1304, a1305, a1306,
        a1307, a1308, a1309, a1310, b1, b6, b7, b8, b9, b10, b11, b12, btilde1,
        btilde6, btilde7, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13,
        extra, interp)
end

function Vern8Tableau(T, T2)
    c2 = convert(T2, 1 // 20)
    c3 = convert(T2, 341 // 3200)
    c4 = convert(T2, 1023 // 6400)
    c5 = convert(T2, 39 // 100)
    c6 = convert(T2, 93 // 200)
    c7 = convert(T2, 31 // 200)
    c8 = convert(T2, 943 // 1000)
    c9 = convert(T2, 7067558016280 // 7837150160667)
    c10 = convert(T2, 909 // 1000)
    c11 = convert(T2, 47 // 50)
    #c12   =convert(T2, 1)
    #c13   =convert(T2, 1)
    a0201 = convert(T, 1 // 20)
    a0301 = convert(T, -7161 // 1024000)
    a0302 = convert(T, 116281 // 1024000)
    a0401 = convert(T, 1023 // 25600)
    a0403 = convert(T, 3069 // 25600)
    a0501 = convert(T, 4202367 // 11628100)
    a0503 = convert(T, -3899844 // 2907025)
    a0504 = convert(T, 3982992 // 2907025)
    a0601 = convert(T, 5611 // 114400)
    a0604 = convert(T, 31744 // 135025)
    a0605 = convert(T, 923521 // 5106400)
    a0701 = convert(T, 21173 // 343200)
    a0704 = convert(T, 8602624 // 76559175)
    a0705 = convert(T, -26782109 // 689364000)
    a0706 = convert(T, 5611 // 283500)
    a0801 = convert(T, -1221101821869329 // 690812928000000)
    a0804 = convert(T, -125 // 2)
    a0805 = convert(T, -1024030607959889 // 168929280000000)
    a0806 = convert(T, 1501408353528689 // 265697280000000)
    a0807 = convert(T, 6070139212132283 // 92502016000000)
    a0901 = convert(T,
        -BigInt(1472514264486215803881384708877264246346044433307094207829051978044531801133057155) //
        BigInt(1246894801620032001157059621643986024803301558393487900440453636168046069686436608))
    a0904 = convert(T,
        -BigInt(5172294311085668458375175655246981230039025336933699114138315270772319372469280000) //
        BigInt(124619381004809145897278630571215298365257079410236252921850936749076487132995191))
    a0905 = convert(T,
        -BigInt(12070679258469254807978936441733187949484571516120469966534514296406891652614970375) //
        BigInt(2722031154761657221710478184531100699497284085048389015085076961673446140398628096))
    a0906 = convert(T,
        BigInt(780125155843893641323090552530431036567795592568497182701460674803126770111481625) //
        BigInt(183110425412731972197889874507158786859226102980861859505241443073629143100805376))
    a0907 = convert(T,
        BigInt(664113122959911642134782135839106469928140328160577035357155340392950009492511875) //
        BigInt(15178465598586248136333023107295349175279765150089078301139943253016877823170816))
    a0908 = convert(T,
        BigInt(10332848184452015604056836767286656859124007796970668046446015775000000) //
        BigInt(1312703550036033648073834248740727914537972028638950165249582733679393783))
    a1001 = convert(T,
        -BigInt(29055573360337415088538618442231036441314060511) //
        BigInt(22674759891089577691327962602370597632000000000))
    a1004 = convert(T, -20462749524591049105403365239069 // 454251913499893469596231268750)
    a1005 = convert(T,
        -180269259803172281163724663224981097 //
        38100922558256871086579832832000000)
    a1006 = convert(T,
        BigInt(21127670214172802870128286992003940810655221489) //
        BigInt(4679473877997892906145822697976708633673728000))
    a1007 = convert(T,
        BigInt(318607235173649312405151265849660869927653414425413) //
        BigInt(6714716715558965303132938072935465423910912000000))
    a1008 = convert(T,
        212083202434519082281842245535894 //
        20022426044775672563822865371173879)
    a1009 = convert(T,
        -BigInt(2698404929400842518721166485087129798562269848229517793703413951226714583) //
        BigInt(469545674913934315077000442080871141884676035902717550325616728175875000000))
    a1101 = convert(T,
        -BigInt(2342659845814086836951207140065609179073838476242943917) //
        BigInt(1358480961351056777022231400139158760857532162795520000))
    a1104 = convert(T, -996286030132538159613930889652 // 16353068885996164905464325675)
    a1105 = convert(T, -26053085959256534152588089363841 // 4377552804565683061011299942400)
    a1106 = convert(T,
        BigInt(20980822345096760292224086794978105312644533925634933539) //
        BigInt(3775889992007550803878727839115494641972212962174156800))
    a1107 = convert(T,
        BigInt(890722993756379186418929622095833835264322635782294899) //
        BigInt(13921242001395112657501941955594013822830119803764736))
    a1108 = convert(T,
        BigInt(161021426143124178389075121929246710833125) //
        BigInt(10997207722131034650667041364346422894371443))
    a1109 = convert(T,
        BigInt(300760669768102517834232497565452434946672266195876496371874262392684852243925359864884962513) //
        BigInt(4655443337501346455585065336604505603760824779615521285751892810315680492364106674524398280000))
    a1110 = convert(T, -31155237437111730665923206875 // 392862141594230515010338956291)
    a1201 = convert(T,
        -BigInt(2866556991825663971778295329101033887534912787724034363) //
        BigInt(868226711619262703011213925016143612030669233795338240))
    a1204 = convert(T,
        -BigInt(16957088714171468676387054358954754000) //
        BigInt(143690415119654683326368228101570221))
    a1205 = convert(T,
        -BigInt(4583493974484572912949314673356033540575) //
        BigInt(451957703655250747157313034270335135744))
    a1206 = convert(T,
        BigInt(2346305388553404258656258473446184419154740172519949575) //
        BigInt(256726716407895402892744978301151486254183185289662464))
    a1207 = convert(T,
        BigInt(1657121559319846802171283690913610698586256573484808662625) //
        BigInt(13431480411255146477259155104956093505361644432088109056))
    a1208 = convert(T,
        BigInt(345685379554677052215495825476969226377187500) //
        BigInt(74771167436930077221667203179551347546362089))
    a1209 = convert(T,
        -BigInt(3205890962717072542791434312152727534008102774023210240571361570757249056167015230160352087048674542196011) //
        BigInt(947569549683965814783015124451273604984657747127257615372449205973192657306017239103491074738324033259120))
    a1210 = convert(T,
        BigInt(40279545832706233433100438588458933210937500) //
        BigInt(8896460842799482846916972126377338947215101))
    a1211 = convert(T,
        -BigInt(6122933601070769591613093993993358877250) //
        BigInt(1050517001510235513198246721302027675953))
    a1301 = convert(T,
        -BigInt(618675905535482500672800859344538410358660153899637) //
        BigInt(203544282118214047100119475340667684874292102389760))
    a1304 = convert(T,
        -BigInt(4411194916804718600478400319122931000) //
        BigInt(40373053902469967450761491269633019))
    a1305 = convert(T,
        -BigInt(16734711409449292534539422531728520225) //
        BigInt(1801243715290088669307203927210237952))
    a1306 = convert(T,
        BigInt(135137519757054679098042184152749677761254751865630525) //
        BigInt(16029587794486289597771326361911895112703716593983488))
    a1307 = convert(T,
        BigInt(38937568367409876012548551903492196137929710431584875) //
        BigInt(340956454090191606099548798001469306974758443147264))
    a1308 = convert(T,
        -BigInt(6748865855011993037732355335815350667265625) //
        BigInt(7002880395717424621213565406715087764770357))
    a1309 = convert(T,
        -BigInt(1756005520307450928195422767042525091954178296002788308926563193523662404739779789732685671) //
        BigInt(348767814578469983605688098046186480904607278021030540735333862087061574934154942830062320))
    a1310 = convert(T,
        BigInt(53381024589235611084013897674181629296875) //
        BigInt(8959357584795694524874969598508592944141))
    b1 = convert(T, 44901867737754616851973 // 1014046409980231013380680)
    b6 = convert(T, 791638675191615279648100000 // 2235604725089973126411512319)
    b7 = convert(T, 3847749490868980348119500000 // 15517045062138271618141237517)
    b8 = convert(T, -13734512432397741476562500000 // 875132892924995907746928783)
    b9 = convert(T,
        BigInt(12274765470313196878428812037740635050319234276006986398294443554969616342274215316330684448207141) //
        BigInt(489345147493715517650385834143510934888829280686609654482896526796523353052166757299452852166040))
    b10 = convert(T, -9798363684577739445312500000 // 308722986341456031822630699)
    b11 = convert(T, 282035543183190840068750 // 12295407629873040425991)
    b12 = convert(T, -306814272936976936753 // 1299331183183744997286)
    # bhat1 = convert(T, 10835401739407019406577//244521829356935137978320)
    # bhat6 = convert(T, 13908189778321895491375000//39221135527894265375640567)
    # bhat7 = convert(T, 73487947527027243487625000//296504045773342769773399443)
    # bhat8 = convert(T, 68293140641257649609375000//15353208647806945749946119)
    # bhat9 = convert(T, BigInt(22060647948996678611017711379974578860522018208949721559448560203338437626022142776381)//BigInt(1111542009262325874512959185795727215759010577565736079641376621381577236680929558640))
    # bhat10= convert(T,-547971229495642458203125000//23237214025700991642563601)
    # bhat13= convert(T,-28735456870978964189//79783493704265043693)
    btilde1 = convert(T, -225628434546552672055 // 6895515587865570890988624)
    btilde6 = convert(T, -1128142172732763360275000 // 2235604725089973126411512319)
    btilde7 = convert(T, 5640710863663816801375000 // 46551135186414814854423712551)
    btilde8 = convert(T, -17627221448949427504296875000 // 875132892924995907746928783)
    btilde9 = convert(T,
        BigInt(17426957952517932078050241885889670195876481434157580946550703126433816616672116622859678756257765) //
        BigInt(3327547002957265520022623672175874357244039108668945650483696382216358800754733949636279394729072))
    btilde10 = convert(T, -17627221448949427504296875000 // 2161060904390192222758414893)
    btilde11 = convert(T, 282035543183190840068750 // 12295407629873040425991)
    btilde12 = convert(T, -306814272936976936753 // 1299331183183744997286)
    btilde13 = convert(T, 28735456870978964189 // 79783493704265043693)

    extra = Vern8ExtraStages(T, T2)
    interp = Vern8InterpolationCoefficients(T)

    Vern8Tableau(c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, a0201, a0301, a0302, a0401,
        a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701, a0704, a0705,
        a0706, a0801, a0804, a0805, a0806, a0807, a0901, a0904, a0905, a0906,
        a0907, a0908, a1001, a1004, a1005, a1006, a1007, a1008, a1009, a1101,
        a1104, a1105, a1106, a1107, a1108, a1109, a1110, a1201, a1204, a1205,
        a1206, a1207, a1208, a1209, a1210, a1211, a1301, a1304, a1305, a1306,
        a1307, a1308, a1309, a1310, b1, b6, b7, b8, b9, b10, b11, b12, btilde1,
        btilde6, btilde7, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13,
        extra, interp)
end

## Vern9
struct Vern9ExtraStages{T, T2}
    c17::T2
    a1701::T
    a1708::T
    a1709::T
    a1710::T
    a1711::T
    a1712::T
    a1713::T
    a1714::T
    a1715::T
    c18::T2
    a1801::T
    a1808::T
    a1809::T
    a1810::T
    a1811::T
    a1812::T
    a1813::T
    a1814::T
    a1815::T
    a1817::T
    c19::T2
    a1901::T
    a1908::T
    a1909::T
    a1910::T
    a1911::T
    a1912::T
    a1913::T
    a1914::T
    a1915::T
    a1917::T
    a1918::T
    c20::T2
    a2001::T
    a2008::T
    a2009::T
    a2010::T
    a2011::T
    a2012::T
    a2013::T
    a2014::T
    a2015::T
    a2017::T
    a2018::T
    a2019::T
    c21::T2
    a2101::T
    a2108::T
    a2109::T
    a2110::T
    a2111::T
    a2112::T
    a2113::T
    a2114::T
    a2115::T
    a2117::T
    a2118::T
    a2119::T
    a2120::T
    c22::T2
    a2201::T
    a2208::T
    a2209::T
    a2210::T
    a2211::T
    a2212::T
    a2213::T
    a2214::T
    a2215::T
    a2217::T
    a2218::T
    a2219::T
    a2220::T
    a2221::T
    c23::T2
    a2301::T
    a2308::T
    a2309::T
    a2310::T
    a2311::T
    a2312::T
    a2313::T
    a2314::T
    a2315::T
    a2317::T
    a2318::T
    a2319::T
    a2320::T
    a2321::T
    c24::T2
    a2401::T
    a2408::T
    a2409::T
    a2410::T
    a2411::T
    a2412::T
    a2413::T
    a2414::T
    a2415::T
    a2417::T
    a2418::T
    a2419::T
    a2420::T
    a2421::T
    c25::T2
    a2501::T
    a2508::T
    a2509::T
    a2510::T
    a2511::T
    a2512::T
    a2513::T
    a2514::T
    a2515::T
    a2517::T
    a2518::T
    a2519::T
    a2520::T
    a2521::T
    c26::T2
    a2601::T
    a2608::T
    a2609::T
    a2610::T
    a2611::T
    a2612::T
    a2613::T
    a2614::T
    a2615::T
    a2617::T
    a2618::T
    a2619::T
    a2620::T
    a2621::T
end

@fold function Vern9ExtraStages(::Type{T},
        ::Type{T2}) where {T <: CompiledFloats,
        T2 <: CompiledFloats}
    #  FIVE ADDITIONAL STAGES FOR INTERPOLANT OF ORDER  8
    c17 = convert(T2, 1)
    a1701 = convert(T, 0.014611976858423152)
    a1708 = convert(T, -0.3915211862331339)
    a1709 = convert(T, 0.23109325002895065)
    a1710 = convert(T, 0.12747667699928525)
    a1711 = convert(T, 0.2246434176204158)
    a1712 = convert(T, 0.5684352689748513)
    a1713 = convert(T, 0.058258715572158275)
    a1714 = convert(T, 0.13643174034822156)
    a1715 = convert(T, 0.030570139830827976)
    c18 = convert(T2, 0.7404185470631561)
    a1801 = convert(T, 0.015499736681895594)
    a1808 = convert(T, 0.3355153219059635)
    a1809 = convert(T, 0.20036139441918607)
    a1810 = convert(T, 0.12520606592835493)
    a1811 = convert(T, 0.22986763931842066)
    a1812 = convert(T, -0.20202506534761813)
    a1813 = convert(T, 0.05917103230665457)
    a1814 = convert(T, -0.026518347830476387)
    a1815 = convert(T, -0.023840946021309713)
    a1817 = convert(T, 0.027181715702085017)
    c19 = convert(T2, 0.888)
    a1901 = convert(T, 0.013024539431143383)
    a1908 = convert(T, -0.7452850902413112)
    a1909 = convert(T, 0.2643867896429301)
    a1910 = convert(T, 0.1313961758372754)
    a1911 = convert(T, 0.21672538151229273)
    a1912 = convert(T, 0.8734117564076053)
    a1913 = convert(T, 0.011859056439357767)
    a1914 = convert(T, 0.05876002941689551)
    a1915 = convert(T, 0.003266518630202088)
    a1917 = convert(T, -0.00895930864841793)
    a1918 = convert(T, 0.06941415157202692)
    c20 = convert(T2, 0.696)
    a2001 = convert(T, 0.013970899969259426)
    a2008 = convert(T, -0.46657653359576745)
    a2009 = convert(T, 0.24163727872162571)
    a2010 = convert(T, 0.12903633413456747)
    a2011 = convert(T, 0.22167006717351054)
    a2012 = convert(T, 0.6257275123364645)
    a2013 = convert(T, 0.04355312415679284)
    a2014 = convert(T, 0.10119624916672908)
    a2015 = convert(T, 0.01808582254679721)
    a2017 = convert(T, -0.020798755876891697)
    a2018 = convert(T, -0.09022232517086219)
    a2019 = convert(T, -0.12127967356222542)
    c21 = convert(T2, 0.487)
    a2101 = convert(T, 0.016046388883181127)
    a2108 = convert(T, 0.09517712399458336)
    a2109 = convert(T, 0.13591872646553177)
    a2110 = convert(T, 0.1237765280959854)
    a2111 = convert(T, 0.2335656264102966)
    a2112 = convert(T, -0.09051508172625873)
    a2113 = convert(T, -0.02537574270006131)
    a2114 = convert(T, -0.13596316968871622)
    a2115 = convert(T, -0.04679214284145113)
    a2117 = convert(T, 0.05177958859391748)
    a2118 = convert(T, 0.09672595677476774)
    a2119 = convert(T, 0.14773126903407427)
    a2120 = convert(T, -0.11507507129585039)

    #  FIVE ADDITIONAL STAGES FOR INTERPOLANT OF ORDER  9
    c22 = convert(T2, 0.025)
    a2201 = convert(T, 0.018029186238936207)
    a2208 = convert(T, 0.06983601042028874)
    a2209 = convert(T, -0.025412476607916634)
    a2210 = convert(T, 0.008487827035463275)
    a2211 = convert(T, -0.002427525516089802)
    a2212 = convert(T, -0.10478397528938199)
    a2213 = convert(T, -0.014731477952480419)
    a2214 = convert(T, -0.03916338390816177)
    a2215 = convert(T, -0.010056573432939595)
    a2217 = convert(T, 0.011025103922048344)
    a2218 = convert(T, 0.005092830749095398)
    a2219 = convert(T, 0.04759715599420645)
    a2220 = convert(T, 0.03386307003288383)
    a2221 = convert(T, 0.02764422831404798)
    c23 = convert(T2, 0.15)
    a2301 = convert(T, 0.01677431640522778)
    a2308 = convert(T, 0.6220437408820475)
    a2309 = convert(T, -0.2060859809768842)
    a2310 = convert(T, 0.11563949897660589)
    a2311 = convert(T, 0.026641017933783588)
    a2312 = convert(T, -0.937681079341877)
    a2313 = convert(T, -0.13678064667021603)
    a2314 = convert(T, -0.3678480995268297)
    a2315 = convert(T, -0.09547871314402478)
    a2317 = convert(T, 0.10134920184223697)
    a2318 = convert(T, -0.08911323084568594)
    a2319 = convert(T, 0.46641409889747604)
    a2320 = convert(T, 0.450273629235458)
    a2321 = convert(T, 0.18385224633268188)
    c24 = convert(T2, 0.32)
    a2401 = convert(T, 0.010711497314914442)
    a2408 = convert(T, -0.07094336118221108)
    a2409 = convert(T, 0.10021649003400916)
    a2410 = convert(T, 0.13834539804680251)
    a2411 = convert(T, 0.17963306335781634)
    a2412 = convert(T, 0.09048246545576182)
    a2413 = convert(T, -0.005460662294523339)
    a2414 = convert(T, -0.030004579051196197)
    a2415 = convert(T, -0.011451920269627991)
    a2417 = convert(T, 0.010033946861093851)
    a2418 = convert(T, -0.09506485282809046)
    a2419 = convert(T, 0.04853358804093592)
    a2420 = convert(T, 0.08013325919783924)
    a2421 = convert(T, -0.1251643326835242)
    c25 = convert(T2, 0.78)
    a2501 = convert(T, 0.014101720888692213)
    a2508 = convert(T, -0.3713379753704491)
    a2509 = convert(T, 0.22312655481171803)
    a2510 = convert(T, 0.12870053459181202)
    a2511 = convert(T, 0.22246006596754947)
    a2512 = convert(T, 0.5382853042550702)
    a2513 = convert(T, 0.05417202616988763)
    a2514 = convert(T, 0.1256968791308744)
    a2515 = convert(T, 0.027844927890020542)
    a2517 = convert(T, -0.0307740924620506)
    a2518 = convert(T, 0.008569805293689777)
    a2519 = convert(T, -0.15351746905870445)
    a2520 = convert(T, -0.021799570305481963)
    a2521 = convert(T, 0.014471288197371868)
    c26 = convert(T2, 0.96)
    a2601 = convert(T, 0.014246004117356466)
    a2608 = convert(T, -0.3767107393295407)
    a2609 = convert(T, 0.22523997807304214)
    a2610 = convert(T, 0.128360307629253)
    a2611 = convert(T, 0.22302387052616926)
    a2612 = convert(T, 0.5463127827750747)
    a2613 = convert(T, 0.0552619079137578)
    a2614 = convert(T, 0.12856135087499826)
    a2615 = convert(T, 0.028572506812964065)
    a2617 = convert(T, -0.02398761886357109)
    a2618 = convert(T, 0.055562244589105095)
    a2619 = convert(T, -0.017406756507628386)
    a2620 = convert(T, -0.03815462365996979)
    a2621 = convert(T, 0.011118785048989178)

    Vern9ExtraStages(c17, a1701, a1708, a1709, a1710, a1711, a1712, a1713, a1714, a1715,
        c18, a1801, a1808, a1809, a1810, a1811, a1812, a1813, a1814, a1815,
        a1817, c19, a1901, a1908, a1909, a1910, a1911, a1912, a1913, a1914,
        a1915, a1917, a1918, c20, a2001, a2008, a2009, a2010, a2011, a2012,
        a2013, a2014, a2015, a2017, a2018, a2019, c21, a2101, a2108, a2109,
        a2110, a2111, a2112, a2113, a2114, a2115, a2117, a2118, a2119, a2120,
        c22, a2201, a2208, a2209, a2210, a2211, a2212, a2213, a2214, a2215,
        a2217, a2218, a2219, a2220, a2221, c23, a2301, a2308, a2309, a2310,
        a2311, a2312, a2313, a2314, a2315, a2317, a2318, a2319, a2320, a2321,
        c24, a2401, a2408, a2409, a2410, a2411, a2412, a2413, a2414, a2415,
        a2417, a2418, a2419, a2420, a2421, c25, a2501, a2508, a2509, a2510,
        a2511, a2512, a2513, a2514, a2515, a2517, a2518, a2519, a2520, a2521,
        c26, a2601, a2608, a2609, a2610, a2611, a2612, a2613, a2614, a2615,
        a2617, a2618, a2619, a2620, a2621)
end

@fold function Vern9ExtraStages(::Type{T}, ::Type{T2}) where {T, T2}
    #  FIVE ADDITIONAL STAGES FOR INTERPOLANT OF ORDER  8
    c17 = convert(T2, 1)
    a1701 = convert(T, big" .1461197685842315252051541915018784713459e-1")
    a1708 = convert(T, big"-.3915211862331339089410228267288242030810")
    a1709 = convert(T, big" .2310932500289506415909675644868993669908")
    a1710 = convert(T, big" .1274766769992852382560589467488989175618")
    a1711 = convert(T, big" .2246434176204157731566981937082069688984")
    a1712 = convert(T, big" .5684352689748512932705226972873692126743")
    a1713 = convert(T, big" .5825871557215827200814768021863420902155e-1")
    a1714 = convert(T, big" .1364317403482215641609022744494239843327")
    a1715 = convert(T, big" .3057013983082797397721005067920369646664e-1")
    c18 = convert(T2, big" .7404185470631561083004100761798676215811")
    a1801 = convert(T, big" .1549973668189559302279946863304789372788e-1")
    a1808 = convert(T, big" .3355153219059635054403439303177105512242")
    a1809 = convert(T, big" .2003613944191860651552622660712101217322")
    a1810 = convert(T, big" .1252060659283549312946162355194540994211")
    a1811 = convert(T, big" .2298676393184206750544046308957155868736")
    a1812 = convert(T, big"-.2020250653476181447824906889122391003637")
    a1813 = convert(T, big" .5917103230665456601422111997583025339897e-1")
    a1814 = convert(T, big"-.2651834783047638681693835956996437528251e-1")
    a1815 = convert(T, big"-.2384094602130971415278110567256446033405e-1")
    a1817 = convert(T, big" .2718171570208501807097257892166705118335e-1")
    c19 = convert(T2, 888 // 1000)
    a1901 = convert(T, big" .1302453943114338366054520296881099431474e-1")
    a1908 = convert(T, big"-.7452850902413112085299330666038981625179")
    a1909 = convert(T, big" .2643867896429300961465132150322749722129")
    a1910 = convert(T, big" .1313961758372753932588328082078842388890")
    a1911 = convert(T, big" .2167253815122927263092467187957410643315")
    a1912 = convert(T, big" .8734117564076052559016338094938888451419")
    a1913 = convert(T, big" .1185905643935776688228545787724340848142e-1")
    a1914 = convert(T, big" .5876002941689550612992712203494447529933e-1")
    a1915 = convert(T, big" .3266518630202087866399279690939423159022e-2")
    a1917 = convert(T, big"-.8959308648417929824525368306101792182274e-2")
    a1918 = convert(T, big" .6941415157202692219907482080827253287034e-1")
    c20 = convert(T2, 696 // 1000)
    a2001 = convert(T, big" .1397089996925942721283716334050740168797e-1")
    a2008 = convert(T, big"-.4665765335957674596054673402956853940520")
    a2009 = convert(T, big" .2416372787216257077935214889875485248580")
    a2010 = convert(T, big" .1290363341345674735721677437066933999929")
    a2011 = convert(T, big" .2216700671735105311080225734522323922813")
    a2012 = convert(T, big" .6257275123364644931771253383573999863003")
    a2013 = convert(T, big" .4355312415679284117869124964829805160429e-1")
    a2014 = convert(T, big" .1011962491667290833450024852274278874501")
    a2015 = convert(T, big" .1808582254679721049279369742685497400353e-1")
    a2017 = convert(T, big"-.2079875587689169691156509689282083267654e-1")
    a2018 = convert(T, big"-.9022232517086218976198252891464664868640e-1")
    a2019 = convert(T, big"-.1212796735622254216011467740438097427634")
    c21 = convert(T2, 487 // 1000)
    a2101 = convert(T, big" .1604638888318112738641232352800290501904e-1")
    a2108 = convert(T, big" .9517712399458336651642257453589397190702e-1")
    a2109 = convert(T, big" .1359187264655317806136927180199100622471")
    a2110 = convert(T, big" .1237765280959854006935081364365637515893")
    a2111 = convert(T, big" .2335656264102966047058755123098072346246")
    a2112 = convert(T, big"-.9051508172625873314662090873741762206189e-1")
    a2113 = convert(T, big"-.2537574270006131028513276914038326155331e-1")
    a2114 = convert(T, big"-.1359631696887162048002744757083947500478")
    a2115 = convert(T, big"-.4679214284145113075088049469061349990847e-1")
    a2117 = convert(T, big" .5177958859391748239949773879090325427473e-1")
    a2118 = convert(T, big" .9672595677476773313884172931875718705561e-1")
    a2119 = convert(T, big" .1477312690340742769720989417101989769314")
    a2120 = convert(T, big"-.1150750712958503934434410263732282100773")

    #  FIVE ADDITIONAL STAGES FOR INTERPOLANT OF ORDER  9
    c22 = convert(T2, 1 // 40)
    a2201 = convert(T, big" .1802918623893620731908165792176564180038e-1")
    a2208 = convert(T, big" .6983601042028873702545973390560096201728e-1")
    a2209 = convert(T, big"-.2541247660791663512384395986842781657182e-1")
    a2210 = convert(T, big" .8487827035463274491721441398893680307535e-2")
    a2211 = convert(T, big"-.2427525516089801645451101966852425715128e-2")
    a2212 = convert(T, big"-.1047839752893819879012607694745789515746")
    a2213 = convert(T, big"-.1473147795248041942353840372690095884761e-1")
    a2214 = convert(T, big"-.3916338390816177165706892282751065537530e-1")
    a2215 = convert(T, big"-.1005657343293959419073236542225421561652e-1")
    a2217 = convert(T, big" .1102510392204834322538452331445716455061e-1")
    a2218 = convert(T, big" .5092830749095398308703438556315975226108e-2")
    a2219 = convert(T, big" .4759715599420644505591133410826632557391e-1")
    a2220 = convert(T, big" .3386307003288382751110965442296681690349e-1")
    a2221 = convert(T, big" .2764422831404797700452373965825845732168e-1")
    c23 = convert(T2, 15 // 100)
    a2301 = convert(T, big" .1677431640522778042988664067637191163626e-1")
    a2308 = convert(T, big" .6220437408820475326702539861577894278533")
    a2309 = convert(T, big"-.2060859809768841878234097076241307428139")
    a2310 = convert(T, big" .1156394989766058889629372195583391792474")
    a2311 = convert(T, big" .2664101793378358946544219293685167025971e-1")
    a2312 = convert(T, big"-.9376810793418770527505892794460093668860")
    a2313 = convert(T, big"-.1367806466702160302637074581619101741312")
    a2314 = convert(T, big"-.3678480995268296672182605288991379118419")
    a2315 = convert(T, big"-.9547871314402478902820445838193201497337e-1")
    a2317 = convert(T, big" .1013492018422369748729008873270013785313")
    a2318 = convert(T, big"-.8911323084568593396468400926074881389560e-1")
    a2319 = convert(T, big" .4664140988974760478895528270623735057521")
    a2320 = convert(T, big" .4502736292354579812232681662308722738519")
    a2321 = convert(T, big" .1838522463326818655346135218242696774099")
    c24 = convert(T2, 32 // 100)
    a2401 = convert(T, big" .1071149731491444187554380927165768658192e-1")
    a2408 = convert(T, big"-.7094336118221108191937165464264324417735e-1")
    a2409 = convert(T, big" .1002164900340091596740582334112699697590")
    a2410 = convert(T, big" .1383453980468025108839271214703390659581")
    a2411 = convert(T, big" .1796330633578163411338104055485109917477")
    a2412 = convert(T, big" .9048246545576180974879274948815422276563e-1")
    a2413 = convert(T, big"-.5460662294523338383345981122023862069115e-2")
    a2414 = convert(T, big"-.3000457905119619782973021046143166498567e-1")
    a2415 = convert(T, big"-.1145192026962799093665613252151017277867e-1")
    a2417 = convert(T, big" .1003394686109385076849515422360600302176e-1")
    a2418 = convert(T, big"-.9506485282809046129031027932806241113157e-1")
    a2419 = convert(T, big" .4853358804093591445756711642658478691640e-1")
    a2420 = convert(T, big" .8013325919783924638483373011297347396327e-1")
    a2421 = convert(T, big"-.1251643326835242045676140618774248455713")
    c25 = convert(T2, 78 // 100)
    a2501 = convert(T, big" .1410172088869221367153586187761994182069e-1")
    a2508 = convert(T, big"-.3713379753704491105936205420001801316029")
    a2509 = convert(T, big" .2231265548117180273161442520179150684520")
    a2510 = convert(T, big" .1287005345918120122888629169443916280865")
    a2511 = convert(T, big" .2224600659675494761192249831098918110654")
    a2512 = convert(T, big" .5382853042550701952740528638168708946100")
    a2513 = convert(T, big" .5417202616988763101781128062036252796548e-1")
    a2514 = convert(T, big" .1256968791308743925752109039299467082975")
    a2515 = convert(T, big" .2784492789002054061504430663197543089132e-1")
    a2517 = convert(T, big"-.3077409246205059733390460511525401688205e-1")
    a2518 = convert(T, big" .8569805293689777608077303071761466118035e-2")
    a2519 = convert(T, big"-.1535174690587044615794997685221990516897")
    a2520 = convert(T, big"-.2179957030548196497189489878038029238243e-1")
    a2521 = convert(T, big" .1447128819737186799295514239727801525027e-1")
    c26 = convert(T2, 96 // 100)
    a2601 = convert(T, big" .1424600411735646609296566581447532773183e-1")
    a2608 = convert(T, big"-.3767107393295407091303982522049390741260")
    a2609 = convert(T, big" .2252399780730421480874737297000189000070")
    a2610 = convert(T, big" .1283603076292529988314451246143633426068")
    a2611 = convert(T, big" .2230238705261692544876826347415151339678")
    a2612 = convert(T, big" .5463127827750747224899202176094949607118")
    a2613 = convert(T, big" .5526190791375779994553849469706124289752e-1")
    a2614 = convert(T, big" .1285613508749982456581494397108686240388")
    a2615 = convert(T, big" .2857250681296406482698934635829147899039e-1")
    a2617 = convert(T, big"-.2398761886357108720930416967644499057175e-1")
    a2618 = convert(T, big" .5556224458910509454379297181908734648749e-1")
    a2619 = convert(T, big"-.1740675650762838674257930398070760254668e-1")
    a2620 = convert(T, big"-.3815462365996979065575121886854199471011e-1")
    a2621 = convert(T, big" .1111878504898917877407531966545730451506e-1")

    Vern9ExtraStages(c17, a1701, a1708, a1709, a1710, a1711, a1712, a1713, a1714, a1715,
        c18, a1801, a1808, a1809, a1810, a1811, a1812, a1813, a1814, a1815,
        a1817, c19, a1901, a1908, a1909, a1910, a1911, a1912, a1913, a1914,
        a1915, a1917, a1918, c20, a2001, a2008, a2009, a2010, a2011, a2012,
        a2013, a2014, a2015, a2017, a2018, a2019, c21, a2101, a2108, a2109,
        a2110, a2111, a2112, a2113, a2114, a2115, a2117, a2118, a2119, a2120,
        c22, a2201, a2208, a2209, a2210, a2211, a2212, a2213, a2214, a2215,
        a2217, a2218, a2219, a2220, a2221, c23, a2301, a2308, a2309, a2310,
        a2311, a2312, a2313, a2314, a2315, a2317, a2318, a2319, a2320, a2321,
        c24, a2401, a2408, a2409, a2410, a2411, a2412, a2413, a2414, a2415,
        a2417, a2418, a2419, a2420, a2421, c25, a2501, a2508, a2509, a2510,
        a2511, a2512, a2513, a2514, a2515, a2517, a2518, a2519, a2520, a2521,
        c26, a2601, a2608, a2609, a2610, a2611, a2612, a2613, a2614, a2615,
        a2617, a2618, a2619, a2620, a2621)
end

struct Vern9InterpolationCoefficients{T}
    r011::T
    r012::T
    r013::T
    r014::T
    r015::T
    r016::T
    r017::T
    r018::T
    r019::T
    r082::T
    r083::T
    r084::T
    r085::T
    r086::T
    r087::T
    r088::T
    r089::T
    r092::T
    r093::T
    r094::T
    r095::T
    r096::T
    r097::T
    r098::T
    r099::T
    r102::T
    r103::T
    r104::T
    r105::T
    r106::T
    r107::T
    r108::T
    r109::T
    r112::T
    r113::T
    r114::T
    r115::T
    r116::T
    r117::T
    r118::T
    r119::T
    r122::T
    r123::T
    r124::T
    r125::T
    r126::T
    r127::T
    r128::T
    r129::T
    r132::T
    r133::T
    r134::T
    r135::T
    r136::T
    r137::T
    r138::T
    r139::T
    r142::T
    r143::T
    r144::T
    r145::T
    r146::T
    r147::T
    r148::T
    r149::T
    r152::T
    r153::T
    r154::T
    r155::T
    r156::T
    r157::T
    r158::T
    r159::T
    r172::T
    r173::T
    r174::T
    r175::T
    r176::T
    r177::T
    r178::T
    r179::T
    r182::T
    r183::T
    r184::T
    r185::T
    r186::T
    r187::T
    r188::T
    r189::T
    r192::T
    r193::T
    r194::T
    r195::T
    r196::T
    r197::T
    r198::T
    r199::T
    r202::T
    r203::T
    r204::T
    r205::T
    r206::T
    r207::T
    r208::T
    r209::T
    r212::T
    r213::T
    r214::T
    r215::T
    r216::T
    r217::T
    r218::T
    r219::T
    r222::T
    r223::T
    r224::T
    r225::T
    r226::T
    r227::T
    r228::T
    r229::T
    r232::T
    r233::T
    r234::T
    r235::T
    r236::T
    r237::T
    r238::T
    r239::T
    r242::T
    r243::T
    r244::T
    r245::T
    r246::T
    r247::T
    r248::T
    r249::T
    r252::T
    r253::T
    r254::T
    r255::T
    r256::T
    r257::T
    r258::T
    r259::T
    r262::T
    r263::T
    r264::T
    r265::T
    r266::T
    r267::T
    r268::T
    r269::T
end

@fold function Vern9InterpolationCoefficients(::Type{T}) where {T <: CompiledFloats}
    r011 = convert(T, 1)
    r012 = convert(T, -28.330488700617398)
    r013 = convert(T, 257.6535452078578)
    r014 = convert(T, -1152.1544557434572)
    r015 = convert(T, 2909.390878345409)
    r016 = convert(T, -4355.005172868188)
    r017 = convert(T, 3834.083497036262)
    r018 = convert(T, -1835.419052683407)
    r019 = convert(T, 368.7958613829998)
    r082 = convert(T, 2.649656243770091)
    r083 = convert(T, -96.30312807816006)
    r084 = convert(T, 869.3095462492796)
    r085 = convert(T, -3395.688567551074)
    r086 = convert(T, 6796.933987158715)
    r087 = convert(T, -7340.848417712072)
    r088 = convert(T, 4082.8488969923656)
    r089 = convert(T, -919.2934944890586)
    r092 = convert(T, -1.5639451819287329)
    r093 = convert(T, 56.8423973927286)
    r094 = convert(T, -513.1052300304285)
    r095 = convert(T, 2004.2867021103232)
    r096 = convert(T, -4011.8533059139295)
    r097 = convert(T, 4332.895839278586)
    r098 = convert(T, -2409.8793479371448)
    r099 = convert(T, 542.6079835318221)
    r102 = convert(T, -0.8627103334967224)
    r103 = convert(T, 31.355653751851733)
    r104 = convert(T, -283.0413682227354)
    r105 = convert(T, 1105.613463426007)
    r106 = convert(T, -2213.0362006784526)
    r107 = convert(T, 2390.1310977541207)
    r108 = convert(T, -1329.3482661468738)
    r109 = convert(T, 299.31580712657853)
    r112 = convert(T, -1.5202953379012147)
    r113 = convert(T, 55.25592121120227)
    r114 = convert(T, -498.7844190970741)
    r115 = convert(T, 1948.346888525776)
    r116 = convert(T, -3899.8821364075516)
    r117 = convert(T, 4211.964345158858)
    r118 = convert(T, -2342.619408856117)
    r119 = convert(T, 527.4637482204279)
    r122 = convert(T, -3.8469388441255234)
    r123 = convert(T, 139.81898409868404)
    r124 = convert(T, -1262.1186876216004)
    r125 = convert(T, 4930.075848057311)
    r126 = convert(T, -9868.21948606954)
    r127 = convert(T, 10657.908924348867)
    r128 = convert(T, -5927.738759872814)
    r129 = convert(T, 1334.688551172191)
    r132 = convert(T, -0.39427130612001415)
    r133 = convert(T, 14.329994760676497)
    r134 = convert(T, -129.35406659945582)
    r135 = convert(T, 505.28160770025175)
    r136 = convert(T, -1011.3900801394333)
    r137 = convert(T, 1092.3250517818917)
    r138 = convert(T, -607.531701930281)
    r139 = convert(T, 136.79172444804232)
    r142 = convert(T, -0.9233145622082102)
    r143 = convert(T, 33.55834582309799)
    r144 = convert(T, -302.9246397549736)
    r145 = convert(T, 1183.2813069678675)
    r146 = convert(T, -2368.4989867901113)
    r147 = convert(T, 2558.034559755808)
    r148 = convert(T, -1422.7331755778803)
    r149 = convert(T, 320.3423358787482)
    r152 = convert(T, -0.20688628029300538)
    r153 = convert(T, 7.519388975651663)
    r154 = convert(T, -67.87605708082904)
    r155 = convert(T, 265.136799698415)
    r156 = convert(T, -530.7074807559026)
    r157 = convert(T, 573.176549564149)
    r158 = convert(T, -318.7905688834869)
    r159 = convert(T, 71.77882490212657)
    r172 = convert(T, -0.44724419067440996)
    r173 = convert(T, 16.44684676010504)
    r174 = convert(T, -154.40861059212955)
    r175 = convert(T, 641.8986298540249)
    r176 = convert(T, -1391.9392256879823)
    r177 = convert(T, 1643.890568302952)
    r178 = convert(T, -1004.0652972233179)
    r179 = convert(T, 248.6243327770223)
    r182 = convert(T, -0.1507876007899798)
    r183 = convert(T, 5.527328824824632)
    r184 = convert(T, -51.33833743084619)
    r185 = convert(T, 209.60220027032804)
    r186 = convert(T, -442.7692650421826)
    r187 = convert(T, 505.0579312588053)
    r188 = convert(T, -295.63364106156195)
    r189 = convert(T, 69.70457078142275)
    r192 = convert(T, -0.6413652207435296)
    r193 = convert(T, 23.510132486246846)
    r194 = convert(T, -218.36426832469724)
    r195 = convert(T, 891.5292818535365)
    r196 = convert(T, -1883.290177206008)
    r197 = convert(T, 2148.2309544883997)
    r198 = convert(T, -1257.4584015217124)
    r199 = convert(T, 296.4838434449778)
    r202 = convert(T, 1.8107293134448457)
    r203 = convert(T, -66.37479657295337)
    r204 = convert(T, 616.4952025401107)
    r205 = convert(T, -2517.0030307773227)
    r206 = convert(T, 5316.984175781034)
    r207 = convert(T, -6064.976140789574)
    r208 = convert(T, 3550.1095388883914)
    r209 = convert(T, -837.0456783831302)
    r212 = convert(T, 0.05176008760353718)
    r213 = convert(T, -1.8973378625803488)
    r214 = convert(T, 17.622648207936294)
    r215 = convert(T, -71.94907400242467)
    r216 = convert(T, 151.9871383765666)
    r217 = convert(T, -173.36864987478606)
    r218 = convert(T, 101.4806461521468)
    r219 = convert(T, -23.927131084462175)
    r222 = convert(T, 31.321782556688)
    r223 = convert(T, -355.6570858339106)
    r224 = convert(T, 1752.6852824895159)
    r225 = convert(T, -4708.092293138363)
    r226 = convert(T, 7370.900776193489)
    r227 = convert(T, -6716.504964764566)
    r228 = convert(T, 3303.940398161186)
    r229 = convert(T, -678.5938956640391)
    r232 = convert(T, -2.7196073341859246)
    r233 = convert(T, 86.64045615858264)
    r234 = convert(T, -454.1926030939031)
    r235 = convert(T, 1014.7492211005434)
    r236 = convert(T, -1133.583456714544)
    r237 = convert(T, 610.4671827718666)
    r238 = convert(T, -109.02334994495438)
    r239 = convert(T, -12.337842943405471)
    r242 = convert(T, 3.1772148014329233)
    r243 = convert(T, -113.8098697715143)
    r244 = convert(T, 978.0935981825675)
    r245 = convert(T, -3575.1293776236703)
    r246 = convert(T, 6764.3615198384505)
    r247 = convert(T, -6987.161043852012)
    r248 = convert(T, 3751.9057627895713)
    r249 = convert(T, -821.4378043648254)
    r252 = convert(T, 0.877284308346553)
    r253 = convert(T, -31.51810423988375)
    r254 = convert(T, 273.1229151353221)
    r255 = convert(T, -993.2198643101782)
    r256 = convert(T, 1787.888078312664)
    r257 = convert(T, -1677.394835799641)
    r258 = convert(T, 781.3579535062688)
    r259 = convert(T, -141.11342691289855)
    r262 = convert(T, 1.7194275817987157)
    r263 = convert(T, -62.89867309250732)
    r264 = convert(T, 580.333550787398)
    r265 = convert(T, -2348.110620506761)
    r266 = convert(T, 4921.119298612906)
    r267 = convert(T, -5597.912448707917)
    r268 = convert(T, 3288.5977751496216)
    r269 = convert(T, -782.8483098245397)

    Vern9InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r018, r019,
        r082, r083, r084, r085, r086, r087, r088, r089, r092,
        r093, r094, r095, r096, r097, r098, r099, r102, r103,
        r104, r105, r106, r107, r108, r109, r112, r113, r114,
        r115, r116, r117, r118, r119, r122, r123, r124, r125,
        r126, r127, r128, r129, r132, r133, r134, r135, r136,
        r137, r138, r139, r142, r143, r144, r145, r146, r147,
        r148, r149, r152, r153, r154, r155, r156, r157, r158,
        r159, r172, r173, r174, r175, r176, r177, r178, r179,
        r182, r183, r184, r185, r186, r187, r188, r189, r192,
        r193, r194, r195, r196, r197, r198, r199, r202, r203,
        r204, r205, r206, r207, r208, r209, r212, r213, r214,
        r215, r216, r217, r218, r219, r222, r223, r224, r225,
        r226, r227, r228, r229, r232, r233, r234, r235, r236,
        r237, r238, r239, r242, r243, r244, r245, r246, r247,
        r248, r249, r252, r253, r254, r255, r256, r257, r258,
        r259, r262, r263, r264, r265, r266, r267, r268, r269)
end

function Vern9InterpolationCoefficients(T)
    r011 = convert(T, 1)
    r012 = convert(T, big"-28.33048870061739823290767301658881994700")
    r013 = convert(T, big" 257.6535452078577977252092979905248156497")
    r014 = convert(T, big"-1152.154455743457311528752964691951881858")
    r015 = convert(T, big" 2909.390878345408890936564599116550031880")
    r016 = convert(T, big"-4355.005172868188498048946108887283528629")
    r017 = convert(T, big" 3834.083497036262189455855371796461857871")
    r018 = convert(T, big"-1835.419052683407081215583427992189311730")
    r019 = convert(T, big" 368.7958613829998340610814211036270246107")
    r082 = convert(T, big" 2.649656243770091212685381903551424676261")
    r083 = convert(T, big"-96.30312807816005963630382777245983513008")
    r084 = convert(T, big" 869.3095462492795755338599928089438369769")
    r085 = convert(T, big"-3395.688567551074115525201961265641584358")
    r086 = convert(T, big" 6796.933987158715680563278170147156885480")
    r087 = convert(T, big"-7340.848417712071304684606060804637321789")
    r088 = convert(T, big" 4082.848896992365666259441580054990759905")
    r089 = convert(T, big"-919.2934944890586676320942978986329899642")
    r092 = convert(T, big"-1.563945181928732780647121505551017046606")
    r093 = convert(T, big" 56.84239739272860000194549791973820565214")
    r094 = convert(T, big"-513.1052300304284642178552372517916694426")
    r095 = convert(T, big" 2004.286702110323162741493515173880535381")
    r096 = convert(T, big"-4011.853305913929339500285683507736138334")
    r097 = convert(T, big" 4332.895839278586189971336003691596594090")
    r098 = convert(T, big"-2409.879347937144606091337260195738587773")
    r099 = convert(T, big" 542.6079835318221405169412532400889768401")
    r102 = convert(T, big"-.8627103334967223830653368770735555216700")
    r103 = convert(T, big" 31.35565375185173442495465167501846267906")
    r104 = convert(T, big"-283.0413682227354209126847112083546012674")
    r105 = convert(T, big" 1105.613463426006937052739159664962261462")
    r106 = convert(T, big"-2213.036200678452629288185991597653042989")
    r107 = convert(T, big" 2390.131097754120588994847482867886207858")
    r108 = convert(T, big"-1329.348266146873716496636094950745123424")
    r109 = convert(T, big" 299.3158071265785138462868993727082901209")
    r112 = convert(T, big"-1.520295337901214839055193576160469820911")
    r113 = convert(T, big" 55.25592121120227100440616045452813504748")
    r114 = convert(T, big"-498.7844190970740738969945498750124435385")
    r115 = convert(T, big" 1948.346888525776056658403461666308795237")
    r116 = convert(T, big"-3899.882136407551390287649940376076923682")
    r117 = convert(T, big" 4211.964345158858030803618536151121927765")
    r118 = convert(T, big"-2342.619408856117128087568672414857706561")
    r119 = convert(T, big" 527.4637482204278644179968961638568925209")
    r122 = convert(T, big"-3.846938844125523400516071820264700141179")
    r123 = convert(T, big" 139.8189840986840520353362018994734906611")
    r124 = convert(T, big"-1262.118687621600386514715930156791825893")
    r125 = convert(T, big" 4930.075848057311658057235318456802793199")
    r126 = convert(T, big"-9868.219486069539059368988308801366826185")
    r127 = convert(T, big" 10657.90892434886730229746304583865145121")
    r128 = convert(T, big"-5927.738759872814112912292792695856187255")
    r129 = convert(T, big" 1334.688551172190921099749059976639173619")
    r132 = convert(T, big"-.3942713061200141454309326713125653612517")
    r133 = convert(T, big" 14.32999476067649707020689155180345562459")
    r134 = convert(T, big"-129.3540665994558117853022852051786116929")
    r135 = convert(T, big" 505.2816077002517600897861155496606850457")
    r136 = convert(T, big"-1011.390080139433268878243655218566636574")
    r137 = convert(T, big" 1092.325051781891697669369143688906543465")
    r138 = convert(T, big"-607.5317019302810290917918493845279272648")
    r139 = convert(T, big" 136.7917244480423273434147193694336909663")
    r142 = convert(T, big"-.9233145622082101394378429409444333268499")
    r143 = convert(T, big" 33.55834582309798808260613735851232640640")
    r144 = convert(T, big"-302.9246397549735936661321348695774835448")
    r145 = convert(T, big" 1183.281306967867553342903125095128753568")
    r146 = convert(T, big"-2368.498986790111516106072390247333149007")
    r147 = convert(T, big" 2558.034559755808027369106332027405169828")
    r148 = convert(T, big"-1422.733175577880214903071122439856598476")
    r149 = convert(T, big" 320.3423358787481875842587982911148385364")
    r152 = convert(T, big"-.2068862802930053801253649628830330891017")
    r153 = convert(T, big" 7.519388975651662772174695012120581518594")
    r154 = convert(T, big"-67.87605708082904058354114755731111898667")
    r155 = convert(T, big" 265.1367996984150421661637988925923843021")
    r156 = convert(T, big"-530.7074807559025368587558119659212235622")
    r157 = convert(T, big" 573.1765495641490277116961329189087439579")
    r158 = convert(T, big"-318.7905688834868978004500126002971837241")
    r159 = convert(T, big" 71.77882490212657594681492031347005327988")
    r172 = convert(T, big"-.4472441906744099441704338175964823026105")
    r173 = convert(T, big" 16.44684676010503791623763886833381020592")
    r174 = convert(T, big"-154.4086105921295528355180056633078150675")
    r175 = convert(T, big" 641.8986298540248497333509289273669726482")
    r176 = convert(T, big"-1391.939225687982391028602609567895699003")
    r177 = convert(T, big" 1643.890568302952013019278202625162156841")
    r178 = convert(T, big"-1004.065297223317845596795060426393517046")
    r179 = convert(T, big" 248.6243327770222987362193390543305737239")
    r182 = convert(T, big"-.1507876007899797948720901584434839156279")
    r183 = convert(T, big" 5.527328824824632235316362126620825363280")
    r184 = convert(T, big"-51.33833743084618751433903968701557585387")
    r185 = convert(T, big" 209.6022002703280347991393999433060881829")
    r186 = convert(T, big"-442.7692650421825928714839983614217797969")
    r187 = convert(T, big" 505.0579312588052893780948070449787925777")
    r188 = convert(T, big"-295.6336410615619366143935619944592839974")
    r189 = convert(T, big" 69.70457078142274038253812108643441743987")
    r192 = convert(T, big"-.6413652207435296452288504944964177537185")
    r193 = convert(T, big" 23.51013248624684600263471193689787394701")
    r194 = convert(T, big"-218.3642683246972281497485359238725613162")
    r195 = convert(T, big" 891.5292818535365634586829868055833114383")
    r196 = convert(T, big"-1883.290177206007885518558760085145850658")
    r197 = convert(T, big" 2148.230954488399755970660772306573864434")
    r198 = convert(T, big"-1257.458401521712336970840850120592935471")
    r199 = convert(T, big" 296.4838434449778148523985255750527153802")
    r202 = convert(T, big" 1.810729313444845732964058528284532356045")
    r203 = convert(T, big"-66.37479657295337371220255196726289169374")
    r204 = convert(T, big" 616.4952025401106511929691356878863855003")
    r205 = convert(T, big"-2517.003030777322559684753470471663859295")
    r206 = convert(T, big" 5316.984175781033401491488704359579721604")
    r207 = convert(T, big"-6064.976140789574108556866601189158423779")
    r208 = convert(T, big" 3550.109538888391317555902194852386816092")
    r209 = convert(T, big"-837.0456783831301740195014698000522807852")
    r212 = convert(T, big".5176008760353717918864555990277480363987e-1")
    r213 = convert(T, big"-1.897337862580348756406065418550014243949")
    r214 = convert(T, big" 17.62264820793629244181715147639285955422")
    r215 = convert(T, big"-71.94907400242465946110661282550878163878")
    r216 = convert(T, big" 151.9871383765666045085018751235590550206")
    r217 = convert(T, big"-173.3686498747860565970136435029707518663")
    r218 = convert(T, big" 101.4806461521468075879782291473158292931")
    r219 = convert(T, big"-23.92713108446217690295957956014097092250")
    r222 = convert(T, big" 31.32178255668799909977422939838912846070")
    r223 = convert(T, big"-355.6570858339106059687054319211280026146")
    r224 = convert(T, big" 1752.685282489515979253875884672206842255")
    r225 = convert(T, big"-4708.092293138363367969732154806019707156")
    r226 = convert(T, big" 7370.900776193488713149861391844801840850")
    r227 = convert(T, big"-6716.504964764565347011489385051202629762")
    r228 = convert(T, big" 3303.940398161185772296756776169088470785")
    r229 = convert(T, big"-678.5938956640391428503413103061359428182")
    r232 = convert(T, big"-2.719607334185924760747802644504744092917")
    r233 = convert(T, big" 86.64045615858264001154848875638486632034")
    r234 = convert(T, big"-454.1926030939030807863651114984001402596")
    r235 = convert(T, big" 1014.749221100543425314268817989377200147")
    r236 = convert(T, big"-1133.583456714543865890388885909333783663")
    r237 = convert(T, big" 610.4671827718666569168001429679645990946")
    r238 = convert(T, big"-109.0233499449543802317396567002119357593")
    r239 = convert(T, big"-12.33784294340547057337599296127606178639")
    r242 = convert(T, big" 3.177214801432923432265738869490200556403")
    r243 = convert(T, big"-113.8098697715142983214434051918276259885")
    r244 = convert(T, big" 978.0935981825675014833003847211971070224")
    r245 = convert(T, big"-3575.129377623670076451027372711378100786")
    r246 = convert(T, big" 6764.361519838450570830405988615992045681")
    r247 = convert(T, big"-6987.161043852012362644872233028628887679")
    r248 = convert(T, big" 3751.905762789571137088934326513342858381")
    r249 = convert(T, big"-821.4378043648253954175634277881875971878")
    r252 = convert(T, big" .8772843083465530069477626269697233842708")
    r253 = convert(T, big"-31.51810423988375104361582759389916060143")
    r254 = convert(T, big" 273.1229151353221133842213845530391043248")
    r255 = convert(T, big"-993.2198643101781966584366870874238565290")
    r256 = convert(T, big" 1787.888078312663987193988385659681964836")
    r257 = convert(T, big"-1677.394835799640950953367739332661886275")
    r258 = convert(T, big" 781.3579535062687952504707744453846824540")
    r259 = convert(T, big"-141.1134269128985501802080532710905715931")
    r262 = convert(T, big" 1.719427581798715782378897599231938082126")
    r263 = convert(T, big"-62.89867309250732184389962568482931880335")
    r264 = convert(T, big" 580.3335507873980391019057196688995930872")
    r265 = convert(T, big"-2348.110620506760958600472968113883922730")
    r266 = convert(T, big" 4921.119298612906015908637628774963068611")
    r267 = convert(T, big"-5597.912448707916639109910311016358007839")
    r268 = convert(T, big" 3288.597775149621789973016480733216881572")
    r269 = convert(T, big"-782.8483098245396412116558219612402319811")

    Vern9InterpolationCoefficients(r011, r012, r013, r014, r015, r016, r017, r018, r019,
        r082, r083, r084, r085, r086, r087, r088, r089, r092,
        r093, r094, r095, r096, r097, r098, r099, r102, r103,
        r104, r105, r106, r107, r108, r109, r112, r113, r114,
        r115, r116, r117, r118, r119, r122, r123, r124, r125,
        r126, r127, r128, r129, r132, r133, r134, r135, r136,
        r137, r138, r139, r142, r143, r144, r145, r146, r147,
        r148, r149, r152, r153, r154, r155, r156, r157, r158,
        r159, r172, r173, r174, r175, r176, r177, r178, r179,
        r182, r183, r184, r185, r186, r187, r188, r189, r192,
        r193, r194, r195, r196, r197, r198, r199, r202, r203,
        r204, r205, r206, r207, r208, r209, r212, r213, r214,
        r215, r216, r217, r218, r219, r222, r223, r224, r225,
        r226, r227, r228, r229, r232, r233, r234, r235, r236,
        r237, r238, r239, r242, r243, r244, r245, r246, r247,
        r248, r249, r252, r253, r254, r255, r256, r257, r258,
        r259, r262, r263, r264, r265, r266, r267, r268, r269)
end

"""
From Verner's Website
"""
struct Vern9Tableau{T, T2}
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    c11::T2
    c12::T2
    c13::T2
    a0201::T
    a0301::T
    a0302::T
    a0401::T
    a0403::T
    a0501::T
    a0503::T
    a0504::T
    a0601::T
    a0604::T
    a0605::T
    a0701::T
    a0704::T
    a0705::T
    a0706::T
    a0801::T
    a0806::T
    a0807::T
    a0901::T
    a0906::T
    a0907::T
    a0908::T
    a1001::T
    a1006::T
    a1007::T
    a1008::T
    a1009::T
    a1101::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    a1110::T
    a1201::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1210::T
    a1211::T
    a1301::T
    a1306::T
    a1307::T
    a1308::T
    a1309::T
    a1310::T
    a1311::T
    a1312::T
    a1401::T
    a1406::T
    a1407::T
    a1408::T
    a1409::T
    a1410::T
    a1411::T
    a1412::T
    a1413::T
    a1501::T
    a1506::T
    a1507::T
    a1508::T
    a1509::T
    a1510::T
    a1511::T
    a1512::T
    a1513::T
    a1514::T
    a1601::T
    a1606::T
    a1607::T
    a1608::T
    a1609::T
    a1610::T
    a1611::T
    a1612::T
    a1613::T
    b1::T
    b8::T
    b9::T
    b10::T
    b11::T
    b12::T
    b13::T
    b14::T
    b15::T
    btilde1::T
    btilde8::T
    btilde9::T
    btilde10::T
    btilde11::T
    btilde12::T
    btilde13::T
    btilde14::T
    btilde15::T
    btilde16::T
end

@fold function Vern9Tableau(::Type{T},
        ::Type{T2}) where {T <: CompiledFloats, T2 <: CompiledFloats}
    c1 = convert(T2, 0.03462)
    c2 = convert(T2, 0.09702435063878045)
    c3 = convert(T2, 0.14553652595817068)
    c4 = convert(T2, 0.561)
    c5 = convert(T2, 0.22900791159048503)
    c6 = convert(T2, 0.544992088409515)
    c7 = convert(T2, 0.645)
    c8 = convert(T2, 0.48375)
    c9 = convert(T2, 0.06757)
    c10 = convert(T2, 0.25)
    c11 = convert(T2, 0.6590650618730999)
    c12 = convert(T2, 0.8206)
    c13 = convert(T2, 0.9012)
    a0201 = convert(T, 0.03462)
    a0301 = convert(T, -0.03893354388572875)
    a0302 = convert(T, 0.13595789452450918)
    a0401 = convert(T, 0.03638413148954267)
    a0403 = convert(T, 0.10915239446862801)
    a0501 = convert(T, 2.0257639143939694)
    a0503 = convert(T, -7.638023836496291)
    a0504 = convert(T, 6.173259922102322)
    a0601 = convert(T, 0.05112275589406061)
    a0604 = convert(T, 0.17708237945550218)
    a0605 = convert(T, 0.0008027762409222536)
    a0701 = convert(T, 0.13160063579752163)
    a0704 = convert(T, -0.2957276252669636)
    a0705 = convert(T, 0.08781378035642955)
    a0706 = convert(T, 0.6213052975225274)
    a0801 = convert(T, 0.07166666666666667)
    a0806 = convert(T, 0.33055335789153195)
    a0807 = convert(T, 0.2427799754418014)
    a0901 = convert(T, 0.071806640625)
    a0906 = convert(T, 0.3294380283228177)
    a0907 = convert(T, 0.1165190029271823)
    a0908 = convert(T, -0.034013671875)
    a1001 = convert(T, 0.04836757646340646)
    a1006 = convert(T, 0.03928989925676164)
    a1007 = convert(T, 0.10547409458903446)
    a1008 = convert(T, -0.021438652846483126)
    a1009 = convert(T, -0.10412291746271944)
    a1101 = convert(T, -0.026645614872014785)
    a1106 = convert(T, 0.03333333333333333)
    a1107 = convert(T, -0.1631072244872467)
    a1108 = convert(T, 0.03396081684127761)
    a1109 = convert(T, 0.1572319413814626)
    a1110 = convert(T, 0.21522674780318796)
    a1201 = convert(T, 0.03689009248708622)
    a1206 = convert(T, -0.1465181576725543)
    a1207 = convert(T, 0.2242577768172024)
    a1208 = convert(T, 0.02294405717066073)
    a1209 = convert(T, -0.0035850052905728597)
    a1210 = convert(T, 0.08669223316444385)
    a1211 = convert(T, 0.43838406519683376)
    a1301 = convert(T, -0.4866012215113341)
    a1306 = convert(T, -6.304602650282853)
    a1307 = convert(T, -0.2812456182894729)
    a1308 = convert(T, -2.679019236219849)
    a1309 = convert(T, 0.5188156639241577)
    a1310 = convert(T, 1.3653531876033418)
    a1311 = convert(T, 5.8850910885039465)
    a1312 = convert(T, 2.8028087862720628)
    a1401 = convert(T, 0.4185367457753472)
    a1406 = convert(T, 6.724547581906459)
    a1407 = convert(T, -0.42544428016461133)
    a1408 = convert(T, 3.3432791530012653)
    a1409 = convert(T, 0.6170816631175374)
    a1410 = convert(T, -0.9299661239399329)
    a1411 = convert(T, -6.099948804751011)
    a1412 = convert(T, -3.002206187889399)
    a1413 = convert(T, 0.2553202529443446)
    a1501 = convert(T, -0.7793740861228848)
    a1506 = convert(T, -13.937342538107776)
    a1507 = convert(T, 1.2520488533793563)
    a1508 = convert(T, -14.691500408016868)
    a1509 = convert(T, -0.494705058533141)
    a1510 = convert(T, 2.2429749091462368)
    a1511 = convert(T, 13.367893803828643)
    a1512 = convert(T, 14.396650486650687)
    a1513 = convert(T, -0.79758133317768)
    a1514 = convert(T, 0.4409353709534278)
    a1601 = convert(T, 2.0580513374668867)
    a1606 = convert(T, 22.357937727968032)
    a1607 = convert(T, 0.9094981099755646)
    a1608 = convert(T, 35.89110098240264)
    a1609 = convert(T, -3.442515027624454)
    a1610 = convert(T, -4.865481358036369)
    a1611 = convert(T, -18.909803813543427)
    a1612 = convert(T, -34.26354448030452)
    a1613 = convert(T, 1.2647565216956427)
    b1 = convert(T, 0.014611976858423152)
    b8 = convert(T, -0.3915211862331339)
    b9 = convert(T, 0.23109325002895065)
    b10 = convert(T, 0.12747667699928525)
    b11 = convert(T, 0.2246434176204158)
    b12 = convert(T, 0.5684352689748513)
    b13 = convert(T, 0.058258715572158275)
    b14 = convert(T, 0.13643174034822156)
    b15 = convert(T, 0.030570139830827976)
    # bhat1  =convert(T,0.01996996514886773)
    # bhat8  =convert(T,2.19149930494933)
    # bhat9  =convert(T,0.08857071848208438)
    # bhat10 =convert(T,0.11405602348659656)
    # bhat11 =convert(T,0.2533163805345107)
    # bhat12 =convert(T,-2.056564386240941)
    # bhat13 =convert(T,0.340809679901312)
    # bhat16 =convert(T,0.04834231373823958)
    btilde1 = convert(T, -0.005357988290444578)
    btilde8 = convert(T, -2.583020491182464)
    btilde9 = convert(T, 0.14252253154686625)
    btilde10 = convert(T, 0.013420653512688676)
    btilde11 = convert(T, -0.02867296291409493)
    btilde12 = convert(T, 2.624999655215792)
    btilde13 = convert(T, -0.2825509643291537)
    btilde14 = convert(T, 0.13643174034822156)
    btilde15 = convert(T, 0.030570139830827976)
    btilde16 = convert(T, -0.04834231373823958)

    Vern9Tableau(c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, a0201, a0301,
        a0302, a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0806, a0807, a0901, a0906, a0907, a0908,
        a1001, a1006, a1007, a1008, a1009, a1101, a1106, a1107, a1108, a1109,
        a1110, a1201, a1206, a1207, a1208, a1209, a1210, a1211, a1301, a1306,
        a1307, a1308, a1309, a1310, a1311, a1312, a1401, a1406, a1407, a1408,
        a1409, a1410, a1411, a1412, a1413, a1501, a1506, a1507, a1508, a1509,
        a1510, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608, a1609,
        a1610, a1611, a1612, a1613, b1, b8, b9, b10, b11, b12, b13, b14, b15,
        btilde1, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13,
        btilde14, btilde15, btilde16)
end

@fold function Vern9Tableau(::Type{T}, ::Type{T2}) where {T, T2}
    c1 = convert(T2, 1731 // 50000)
    c2 = convert(T2,
        BigInt(7630049) // BigInt(53810000) -
        BigInt(983539) // BigInt(53810000) * 6^(1 // 2))
    c3 = convert(T2,
        BigInt(22890147) // BigInt(107620000) -
        BigInt(2950617) // BigInt(107620000) * 6^(1 // 2))
    c4 = convert(T2, 561 // 1000)
    c5 = convert(T2, BigInt(387) // BigInt(1000) - BigInt(129) // BigInt(2000) * 6^(1 // 2))
    c6 = convert(T2, BigInt(387) // BigInt(1000) + BigInt(129) // BigInt(2000) * 6^(1 // 2))
    c7 = convert(T2, 129 // 200)
    c8 = convert(T2, 387 // 800)
    c9 = convert(T2, 6757 // 100000)
    c10 = convert(T2, 1 // 4)
    c11 = convert(T2, 1427971650951258372 // 2166662646162554701)
    c12 = convert(T2, 4103 // 5000)
    c13 = convert(T2, 2253 // 2500)
    a0201 = convert(T, 1731 // 50000)
    a0301 = convert(T,
        -BigInt(177968356965557) // BigInt(1002427673820000) +
        BigInt(14180534491313) // BigInt(250606918455000) * 6^(1 // 2))
    a0302 = convert(T,
        BigInt(64021741529527) // BigInt(200485534764000) -
        BigInt(7504450763411) // BigInt(100242767382000) * 6^(1 // 2))
    a0401 = convert(T,
        BigInt(22890147) // BigInt(430480000) -
        BigInt(2950617) // BigInt(430480000) * 6^(1 // 2))
    a0403 = convert(T,
        BigInt(68670441) // BigInt(430480000) -
        BigInt(8851851) // BigInt(430480000) * 6^(1 // 2))
    a0501 = convert(T,
        BigInt(592203994261020339) // BigInt(513126355505556250) +
        BigInt(730386990293623641) // BigInt(2052505422022225000) * 6^(1 // 2))
    a0503 = convert(T,
        -BigInt(8712153884182794903) // BigInt(2052505422022225000) -
        BigInt(2843421359195851533) // BigInt(2052505422022225000) * 6^(1 // 2))
    a0504 = convert(T,
        BigInt(1873698362223295443) // BigInt(513126355505556250) +
        BigInt(528258592225556973) // BigInt(513126355505556250) * 6^(1 // 2))
    a0601 = convert(T,
        BigInt(11380823631) // BigInt(157617812000) -
        BigInt(339148869) // BigInt(39404453000) * 6^(1 // 2))
    a0604 = convert(T,
        BigInt(16193232887091831) // BigInt(58864341808507450) -
        BigInt(2355345717024309) // BigInt(58864341808507450) * 6^(1 // 2))
    a0605 = convert(T,
        BigInt(165912282616977) // BigInt(4179075230308000) -
        BigInt(33181894472511) // BigInt(2089537615154000) * 6^(1 // 2))
    a0701 = convert(T,
        BigInt(26523528363) // BigInt(231790900000) +
        BigInt(863255358) // BigInt(123138915625) * 6^(1 // 2))
    a0704 = convert(T,
        -BigInt(38208748178016484817787) // BigInt(842517966262441068418750) -
        BigInt(86118788556282369822807) // BigInt(842517966262441068418750) *
        6^(1 // 2))
    a0705 = convert(T,
        BigInt(92362336407446913) // BigInt(290322814529044000) -
        BigInt(232039320950012997) // BigInt(2467743923496874000) * 6^(1 // 2))
    a0706 = convert(T,
        -BigInt(362925891) // BigInt(1690350537500) +
        BigInt(857800423623) // BigInt(3380701075000) * 6^(1 // 2))
    a0801 = convert(T, 43 // 600)
    a0806 = convert(T, BigInt(43) // BigInt(150) + BigInt(43) // BigInt(2400) * 6^(1 // 2))
    a0807 = convert(T, BigInt(43) // BigInt(150) - BigInt(43) // BigInt(2400) * 6^(1 // 2))
    a0901 = convert(T, 7353 // 102400)
    a0906 = convert(T,
        BigInt(22833) // BigInt(102400) +
        BigInt(8901) // BigInt(204800) * 6^(1 // 2))
    a0907 = convert(T,
        BigInt(22833) // BigInt(102400) -
        BigInt(8901) // BigInt(204800) * 6^(1 // 2))
    a0908 = convert(T, -3483 // 102400)
    a1001 = convert(T, 376708742472214988700853 // 7788456028125000000000000)
    a1006 = convert(T,
        BigInt(187914666753956840195279) // BigInt(2596152009375000000000000) -
        BigInt(210440846556290693268911) // BigInt(15576912056250000000000000) *
        6^(1 // 2))
    a1007 = convert(T,
        BigInt(187914666753956840195279) // BigInt(2596152009375000000000000) +
        BigInt(210440846556290693268911) // BigInt(15576912056250000000000000) *
        6^(1 // 2))
    a1008 = convert(T, -18552667221896744226647 // 865384003125000000000000)
    a1009 = convert(T, -3167799860072183913409 // 30423656359863281250000)
    a1101 = convert(T,
        -BigInt(426968570497) // BigInt(54394415898750) -
        BigInt(92754382349) // BigInt(12087647977500) * 6^(1 // 2))
    a1106 = convert(T, 1 // 30)
    a1107 = convert(T,
        -BigInt(2865012129681958) // BigInt(114898584332330625) -
        BigInt(12962517687655099) // BigInt(229797168664661250) * 6^(1 // 2))
    a1108 = convert(T,
        BigInt(4389715333607) // BigInt(309890657317500) +
        BigInt(92754382349) // BigInt(11477431752500) * 6^(1 // 2))
    a1109 = convert(T,
        BigInt(4990058173976) // BigInt(83757096376875) +
        BigInt(371017529396) // BigInt(9306344041875) * 6^(1 // 2))
    a1110 = convert(T,
        BigInt(1099523524595993125000) // BigInt(6257667909869756018891) +
        BigInt(100957348037989687500) // BigInt(6257667909869756018891) *
        6^(1 // 2))
    a1201 = convert(T,
        BigInt(18382031104798403869938539009154656587521498573595595063164077882800315372787284683238439478955141517997198007108623761931447163756) //
        BigInt(13974256944499724344918960993890933614161025322970450047932688998095008528620821239604734608111291769444706187497807869179550841329375) +
        BigInt(407885778185158609210793892517582595305896470756467612636796259611491408260896413446883450891351622914818800693274034252252905536) //
        BigInt(28084926388601226073624096169175002956970191576455110633226765141161372294098693275117181239385312198137508846535933127837167926875) *
        6^(1 // 2))
    a1206 = convert(T,
        -BigInt(333881311789849411971573472868128281438202210721723123251742145367734582887577395547778228760174068758086134389952015563403904) //
        BigInt(2270872004608103037127689848604039623086639035441372934050180593816493796129405349914148981460714202232988727738778494557727635) +
        BigInt(4819272892477768171373308666720689121421091953625792970278044071549950640195056472955523769829034800621890424847009130000000) //
        BigInt(23162894447002650978702436455761204155483718161502003927311842056928236720519934569124319610899284862776485022935540644488821877) *
        6^(1 // 2))
    a1207 = convert(T,
        -BigInt(136666607496463622270135608863772076443625468798139480390426740993024803946981763209348364716108721312822619845726151693667598437699964416) //
        BigInt(3719286465342404274788585327254180828195282427342057650194855634917821113563432870681372043512520401887141437067106105683944802332422369375) +
        BigInt(169845085565361336805556009296394374527636952379388961026066628725155521832762086875632366996477567928657535912191396155566765457826139904) //
        BigInt(1593979913718173260623679425966077497797978183146596135797795272107637620098614087434873732933937315094489187314474045293119200999609586875) *
        6^(1 // 2))
    a1208 = convert(T,
        BigInt(5610987899273278525411960528081442902198567594809764379756195673673265700551076812883925583370253765702553235594764427173637673766208) //
        BigInt(92881598198144033018278804740626334135423356791639598109358867770361609232846012626732332450844264293840456574956036349633197336361875) -
        BigInt(5587476413495323413846491678323049250765705078855720721052003556321800113162964567765526724539063327600257543743479921263738432) //
        BigInt(365303089362201664516413596925286161494473575337115296250511752859728108868696929614024803255122785403232359817965288739565550625) *
        6^(1 // 2))
    a1209 = convert(T,
        BigInt(54598539818083615233566148602203244896696958910734339754065270985433507945162707737759469214674480807272210648148477499238783276259328) //
        BigInt(301247919092298852634886875129959310794662932014184499827145075851637298698312074030567479239502011693447423026416040794479934024058125) -
        BigInt(6526172450962537747372702280281321524894343532103481802188740153783862532174342615150135214261625966637100811092384548036046488576) //
        BigInt(86490932843037281836028387921320502668579653176624892284566487468170341285762869374265713247057712228954184044334206372230816544375) *
        6^(1 // 2))
    a1210 = convert(T,
        BigInt(9391667348404584010955422210328707125006120661611061908889750805619418785820948002455890360939221912190524731087070645107486913457760000000) //
        BigInt(58157266968773020612419028503738708303515285854970725662326801531295387265784849843172223645193277229358434488742203091272981931739152584783) -
        BigInt(8108825145085088104344721048166325225173729495689364696426720161112012414227752328969720658987315654179873760357725235734000399440000000) //
        BigInt(265558296661064021061274102756797754810572081529546692522040189640618206693081506133206500662983001047298787619827411375675716583283801757) *
        6^(1 // 2))
    a1211 = convert(T,
        BigInt(123461712659887915177271339396606860810479028777869348014870450606260914019560285661288212498128400476015695960341952) //
        BigInt(281629106670320674754245209358840703704235147307838896741075511220826056829047205614324978253226176275078922716132461))
    a1301 = convert(T,
        -BigInt(56042772675322042139227629978042586330633622706053363946766144416933631) //
        BigInt(58808540772323190525590122613223430507352118534557342666015625000000000) +
        BigInt(281404579734699232141455524604487724159024972527) //
        BigInt(1478009944832743180452316204077188415527343750000) * 6^(1 // 2))
    a1306 = convert(T,
        -BigInt(1027163900229750356561238237947225332675621517) //
        BigInt(179261894431132664078747698292867431640625000) -
        BigInt(2745292391641202525373103979336813513372321) //
        BigInt(11702216468464340311060649744558385937500000) * 6^(1 // 2))
    a1307 = convert(T,
        -BigInt(157229999853748227305165773364426925282378072238332930121) //
        BigInt(36699907367985458573273204094330716033963413238525390625) +
        BigInt(5757606442802795095318986067317837904184278650664590252101) //
        BigInt(3523191107326604023034227593055748739260487670898437500000) *
        6^(1 // 2))
    a1308 = convert(T,
        -BigInt(9311448168593934146015965019904013602133802943325818346622781285907057) //
        BigInt(4255970849010124217193135449668739985401313363005576159362792968750000) -
        BigInt(844213739204097696424366573813463172477074917581) //
        BigInt(4210188359946578336976868164966163024902343750000) * 6^(1 // 2))
    a1309 = convert(T,
        BigInt(885774233856672590222951867695327816457340130391639153070521335485617578) //
        BigInt(301098541380295011015469248465465290112505656143757799934635162353515625) -
        BigInt(281404579734699232141455524604487724159024972527) //
        BigInt(284481916364737983221402322504830303192138671875) * 6^(1 // 2))
    a1310 = convert(T,
        BigInt(315479116729780153956412124052199685097744239386639023787359107959254802182) //
        BigInt(134481850506505848012587842215515574380212543200894932329128471154748828125) -
        BigInt(2940396453647872276646068776592292229737651937934623) //
        BigInt(7345465058781983710795837429530784777245286520703125) *
        6^(1 // 2))
    a1311 = convert(T,
        BigInt(2250996163406545378616532039018846586217631599453822541) //
        BigInt(382491303797095993563304148204275636433504028320312500))
    a1312 = convert(T,
        BigInt(2689340957307691853294902388334454003959378146957529866233529251986359392336044151708949720958809747970514366293458424272174024493) //
        BigInt(959516386019578808500569114780871708466894752280482835105408027815194895319055443842782227102120493960805649575561796875000000000))
    a1401 = convert(T,
        BigInt(47342003848024391498707976847688893013083074441159779465719863625051668939887702630319) //
        BigInt(44802546873926050730401222636656855760802419993852060264615320801485392456054687500000) -
        BigInt(866369530987077991125562402829092187100493209601) //
        BigInt(3325522375873672156017711459173673934936523437500) * 6^(1 // 2))
    a1406 = convert(T,
        BigInt(871779321807802447463310035318238762878527157) //
        BigInt(134446420823349498059060773719650573730468750) +
        BigInt(107641268480999396081848975271849857994818) //
        BigInt(1097082793918531904161935913552348681640625) * 6^(1 // 2))
    a1407 = convert(T,
        BigInt(496103786351862292800034805114190705484800743513354117014) //
        BigInt(110099722103956375719819612282992148101890239715576171875) -
        BigInt(1329938412606197485769312599390307351191540891599374831099) //
        BigInt(660598332623738254318917673697952888611341438293457031250) *
        6^(1 // 2))
    a1408 = convert(T,
        BigInt(40774077277747636354598451708891165494123131383777235229538611989392175193285994266471) //
        BigInt(15264290546248162101058985941588079518256741255377031736357946125713524703979492187500) +
        BigInt(123767075855296855875080343261298883871499029943) //
        BigInt(451091609994276250390378731960660324096679687500) * 6^(1 // 2))
    a1409 = convert(T,
        -BigInt(10522038608500556459828649038302068473735749030796372764961618751973793724796364606986664) //
        BigInt(3899417425005422254034574000397382862235892829653375835197340918271556055507659912109375) +
        BigInt(3465478123948311964502249611316368748401972838404) //
        BigInt(2560337247282641848992620902543472728729248046875) * 6^(1 // 2))
    a1410 = convert(T,
        -BigInt(27843764471262693189365201135620670490328475323282820219474851621693895769527094334687108984) //
        BigInt(12257041066285164222002594300605593929434139193022166317802121412999357024704596261133984375) +
        BigInt(574774300271998598683873114105472016699241495055292) //
        BigInt(1049352151254569101542262489932969253892183788671875) *
        6^(1 // 2))
    a1411 = convert(T,
        -BigInt(34241134351848245624232809437676889009431930503529853032576417589898516) //
        BigInt(5613347824358651981100985009024281007603230062439942682713165283203125))
    a1412 = convert(T,
        -BigInt(3432044375893932378102368568052286501033850910516999202088532705211633432793920547702800961532438008401883737341854688972639605334600163938610268855705742764072609) //
        BigInt(1143174106341682260971647690410567292143926198650927778920823267461111371275907599801714870165813394147519068210931766844494994616580258435518181434575195312500000))
    a1413 = convert(T,
        BigInt(4746930876023919335079451612726717649218264199984) //
        BigInt(18592065538407049755200144388134089346432755594877))
    a1501 = convert(T,
        -BigInt(25188329249258825443748527038142409879923012133738985313265430932280250855708601) //
        BigInt(11370641325574469312056961874077298550827642308774647316995717036347558064286250) +
        BigInt(1234273058981860170179592598535508631343082535549881956) //
        BigInt(2105633771469628744518390642968552144069898845895808125) *
        6^(1 // 2))
    a1506 = convert(T,
        -BigInt(54821142119685055562477216205428613949905430396088) //
        BigInt(3959439837009461289085587746748097947393101278095) -
        BigInt(1511276753825982856072891469504471256664975925000) //
        BigInt(40386286337496505148672995016830599063409633036569) * 6^(1 // 2))
    a1507 = convert(T,
        -BigInt(60922424274061599918603524049390657305431262635197540405697952) //
        BigInt(6484861747489032169774584624759953148531564032417461909516875) +
        BigInt(84558575751635978733109961893984238786929550462615375699341616) //
        BigInt(19454585242467096509323753874279859445594692097252385728550625) *
        6^(1 // 2))
    a1508 = convert(T,
        -BigInt(116118147575045169733222875835719955334334798191459879782123534889390467935109772) //
        BigInt(8810626901954835245672275131295870892503713957512170681453300814988417642493125) -
        BigInt(176324722711694310025656085505072661620440362221411708) //
        BigInt(285619406719829107485771207042040133465420149964555625) *
        6^(1 // 2))
    a1509 = convert(T,
        BigInt(17769448722513898342276837490665097286927607247073335618566987143467294900183033216) //
        BigInt(2551217008137889615056342146084561867122485163596619283719957742418751029506356875) -
        BigInt(19748368943709762722873481576568138101489320568798111296) //
        BigInt(6484554262322259071286545935997129135111813687175650625) *
        6^(1 // 2))
    a1510 = convert(T,
        BigInt(97659266139124074818193264801929547781659926543786381510190954184218570746215033823993530000000) //
        BigInt(18560076654469706205963482908787056850812308205603127326855360961727608242796551101182080033599) -
        BigInt(85297084611782122474911131363078900058888025224607913745000000) //
        BigInt(69210659450201393843166746722954036326338355649915383851733911) *
        6^(1 // 2))
    a1511 = convert(T,
        BigInt(473389749049752963256114649231353822492912259509649519870869750525) //
        BigInt(35412440882360341799798842428365422941216508121322622479260846291))
    a1512 = convert(T,
        BigInt(33351439245158438248073494056784144097872912773415904536400728387690334563968394114702414108807505158106385116468732853458202899966748488718531545706559142895903144848764637) //
        BigInt(2316611025327287427714802011322252886090793904989900621592365627649097578102163572190502232425490606773312310665593424982745744299371285598588298606088543376742054644818966))
    a1513 = convert(T,
        -BigInt(38714992656958413389743252726016897599283911682945255636643554687500000) //
        BigInt(48540494926971587499294589382572212036169135429877901702347521300421767))
    a1514 = convert(T,
        BigInt(14800250200940323717124616175641261235119295795768814717803955078125) //
        BigInt(33565577125141877760287380588632421223433194078156948298488471160489))
    a1601 = convert(T,
        BigInt(2305785696086397561080858186939897173645641331085041313944389849986584101287) //
        BigInt(617508244345282265819087370078275122671246164669900462139876057008239440000) -
        BigInt(85404623305589712632165905233974183137607899140719) //
        BigInt(124822287169084833758410283469525117460541643292500) *
        6^(1 // 2))
    a1606 = convert(T,
        BigInt(102903996961580448264190625267026062654799259083) //
        BigInt(5046398084890004857481629999673320438819484730) +
        BigInt(41320925487304219313300272052128374567081128125) //
        BigInt(51473260465878049546312625996667868475958744246) * 6^(1 // 2))
    a1607 = convert(T,
        BigInt(62798443349876457506718920843975661399949564598018488144466) //
        BigInt(4132553498782573324058263582553715220777051359780141380625) -
        BigInt(72308807081932961554425711089716771013571419950657300729103) //
        BigInt(12397660496347719972174790747661145662331154079340424141875) *
        6^(1 // 2))
    a1608 = convert(T,
        BigInt(1794909142126482564390848522924225553221469019751470544959297614654661293377) //
        BigInt(52596481193994264435601626109752988674679691644275456716633975785978672500) +
        BigInt(12200660472227101804595129319139169019658271305817) //
        BigInt(16931561456559959115207709344056578263397760602500) * 6^(1 // 2))
    a1609 = convert(T,
        -BigInt(2775244732780109667342845612394739319115662636371477300455747022423270475907256) //
        BigInt(228417153675584029725018045422706955827996328208181619436454383447149337555625) +
        BigInt(341618493222358850528663620935896732550431596562876) //
        BigInt(96101338378773357469245211954911505447551097205625) * 6^(1 // 2))
    a1610 = convert(T,
        -BigInt(27680554659769016623530979176727448251292244310769996015342190819068970556083063125000) //
        BigInt(3299557777429648960576561382256606844677258438797072955341581354051375036522231471437) +
        BigInt(4426552127579895373479670356100179759944766558141730312500) //
        BigInt(3077113738667320707748877199804636746494977000658967987677) *
        6^(1 // 2))
    a1611 = convert(T,
        -BigInt(292603171929706291053929402159930330736639136252680853622275) //
        BigInt(15473622826279161150227076887290262443510550964275858143964))
    a1612 = convert(T,
        -BigInt(9815717129569106988569302193220999343824932084582093647596086931754666098662594153095258988516305165794739744873539829069617203523509136682216933020431) //
        BigInt(286476991170934153076146641094402171801937250068596542931028678669501762253287693294397689327797388113854588113430063939405071979092547998950955940992))
    a1613 = convert(T,
        BigInt(2729491144709837905799148766650782532906050298971406518524169921875) //
        BigInt(2158115888622139473142775812109447802920656149243127309253686951469))
    b1 = convert(T,
        8198160366203173411119943711500331 // 561057579384085860167277847128765528)
    b8 = convert(T,
        -BigInt(455655493073428838813281446213740000000) //
        BigInt(1163808011150910561240464225837312497869))
    b9 = convert(T,
        BigInt(19965163648706008081135075746915614720000000) //
        BigInt(86394404190537086868394686205782432516544599))
    b10 = convert(T,
        BigInt(89231107919981418705566970804343750000000000000000000000) //
        BigInt(699979870988335674445594679856445060562597693583175985391))
    b11 = convert(T,
        47104273954945906713184913871143492 //
        209684639122339601934631113492763467)
    b12 = convert(T,
        BigInt(20845004421404500464010584740796750650832176798370383084226351294730731196673647311062330972740734737279503119387627146381678677156136042524139311907482802844083) //
        BigInt(36670849891136373020238225328265100250605144718501926305140966586758054847604681466336103169284755987753542321202462371554120593858149755539878561976786592389608))
    b13 = convert(T,
        BigInt(6053037282142306509795911286909179687500000000) //
        BigInt(103899257350518063455290077573775162739725126989))
    b14 = convert(T,
        BigInt(917401104920993498360358406096725463867187500) //
        BigInt(6724249815911346653315790737453607382989551463))
    b15 = convert(T,
        2585449557665268951371699596493957 // 84574345160764140163208606048427531)
    # bhat1  =convert(T,552562031208180939317806684253//27669654257734667858523344041464)
    # bhat8  =convert(T,221223388631423597589898601690000000//100946136798587090054685074667127461)
    # bhat9  =convert(T,BigInt(101835408791305297984657812561920000000)//BigInt(1149763833200743759976506650241312100139))
    # bhat10 =convert(T,BigInt(1313720309077630014453239843750000000000000000000)//BigInt(11518201923215510989126466531107437037395719117133))
    # bhat11 =convert(T,4833611232701440504508086151728//19081321241454145230196661524503)
    # bhat12 =convert(T,-BigInt(2129662374582324648106919795703373645353118273066742230724172731025813964712473647144010599206669825382719359113196238857709025512340589957)//BigInt(1035543739272367080885190546201097218891268728118207332592595987554851882972292670881794178380097716583123063485287435793657425889233080568))
    # bhat13 =convert(T,BigInt(1084761591753640855844358063964843750000000)//BigInt(3182895486031249071938549691320502488733423))
    # bhat16 =convert(T,1839190071060649887127895100784//38045139523510634351420875415397)
    btilde1 = convert(T,
        -1503069970302555747713611212548875 //
        280528789692042930083638923564382764)
    btilde8 = convert(T,
        BigInt(-3006139940605111495427222425097750000000) //
        BigInt(1163808011150910561240464225837312497869))
    btilde9 = convert(T,
        BigInt(12313149196718536685269903053200384000000000) //
        BigInt(86394404190537086868394686205782432516544599))
    btilde10 = convert(T,
        BigInt(9394187314390973423210070078430468750000000000000000000) //
        BigInt(699979870988335674445594679856445060562597693583175985391))
    btilde11 = convert(T,
        -6012279881210222990854444850195500 //
        209684639122339601934631113492763467)
    btilde12 = convert(T,
        BigInt(48130484160351526969737032053650002390763871764386160830857331738750104951318921056416737791402447075630390197043182920376678624912056972204118525928289962576625) //
        BigInt(18335424945568186510119112664132550125302572359250963152570483293379027423802340733168051584642377993876771160601231185777060296929074877769939280988393296194804))
    btilde13 = convert(T,
        BigInt(-29356835357471791947531468995095214843750000000) //
        BigInt(103899257350518063455290077573775162739725126989))
    btilde14 = convert(T,
        BigInt(917401104920993498360358406096725463867187500) //
        BigInt(6724249815911346653315790737453607382989551463))
    btilde15 = convert(T,
        2585449557665268951371699596493957 //
        84574345160764140163208606048427531)
    btilde16 = convert(T,
        -1839190071060649887127895100784 // 38045139523510634351420875415397)

    Vern9Tableau(c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, a0201, a0301,
        a0302, a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0806, a0807, a0901, a0906, a0907, a0908,
        a1001, a1006, a1007, a1008, a1009, a1101, a1106, a1107, a1108, a1109,
        a1110, a1201, a1206, a1207, a1208, a1209, a1210, a1211, a1301, a1306,
        a1307, a1308, a1309, a1310, a1311, a1312, a1401, a1406, a1407, a1408,
        a1409, a1410, a1411, a1412, a1413, a1501, a1506, a1507, a1508, a1509,
        a1510, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608, a1609,
        a1610, a1611, a1612, a1613, b1, b8, b9, b10, b11, b12, b13, b14, b15,
        btilde1, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13,
        btilde14, btilde15, btilde16)
end

"""
RKV76.IIa - A 'most efficient' Runge--Kutta (10:7(6)) pair
From Verner's Website
"""
struct RKV76IIaTableau{T, T2}
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    a21::T
    a31::T
    a32::T
    a41::T
    a42::T
    a43::T
    a51::T
    a52::T
    a53::T
    a54::T
    a61::T
    a62::T
    a63::T
    a64::T
    a65::T
    a71::T
    a72::T
    a73::T
    a74::T
    a75::T
    a76::T
    a81::T
    a82::T
    a83::T
    a84::T
    a85::T
    a86::T
    a87::T
    a91::T
    a92::T
    a93::T
    a94::T
    a95::T
    a96::T
    a97::T
    a98::T
    a101::T
    a102::T
    a103::T
    a104::T
    a105::T
    a106::T
    a107::T
    a108::T
    a109::T
    b1::T
    b2::T
    b3::T
    b4::T
    b5::T
    b6::T
    b7::T
    b8::T
    b9::T
    b10::T
    bh1::T
    bh2::T
    bh3::T
    bh4::T
    bh5::T
    bh6::T
    bh7::T
    bh8::T
    bh9::T
    bh10::T
end

function RKV76IIaTableau(T, T2)
    c1  = convert(T2, BigFloat("0"))
    c2  = convert(T2, BigFloat("0.069"))
    c3  = convert(T2, BigFloat("0.118"))
    c4  = convert(T2, BigFloat("0.177"))
    c5  = convert(T2, BigFloat("0.501"))
    c6  = convert(T2, BigFloat("0.7737799115305331003715765296862487670813"))
    c7  = convert(T2, BigFloat("0.994"))
    c8  = convert(T2, BigFloat("0.998"))
    c9  = convert(T2, BigFloat("1"))
    c10 = convert(T2, BigFloat("1"))

    # Butcher tableau A matrix
    a21  = convert(T, BigFloat("0.069"))
    a31  = convert(T, BigFloat("0.01710144927536231884057971014492753623188"))
    a32  = convert(T, BigFloat("0.1008985507246376811594202898550724637681"))
    a41  = convert(T, BigFloat("0.04425"))
    a42  = convert(T, BigFloat("0"))
    a43  = convert(T, BigFloat("0.13275"))
    a51  = convert(T, BigFloat("0.7353445130709566216604424016087331226659"))
    a52  = convert(T, BigFloat("0"))
    a53  = convert(T, BigFloat("-2.830160657856937661591496696351623096811"))
    a54  = convert(T, BigFloat("2.595816144785981039931054294742889974145"))
    a61  = convert(T, BigFloat("-12.21580485360407974005910916471598682362"))
    a62  = convert(T, BigFloat("0"))
    a63  = convert(T, BigFloat("48.82665485823736062335980699373053427134"))
    a64  = convert(T, BigFloat("-38.55615592319928364666616600329792491404"))
    a65  = convert(T, BigFloat("2.719085830096535863737044703969626233400"))
    a71  = convert(T, BigFloat("108.8614188704176574066699618897203578466"))
    a72  = convert(T, BigFloat("0"))
    a73  = convert(T, BigFloat("-432.4521181775777896358931629332707752654"))
    a74  = convert(T, BigFloat("343.9115281800118289547200158889409233641"))
    a75  = convert(T, BigFloat("-20.55041135925273709189369488701721016265"))
    a76  = convert(T, BigFloat("1.223582486401040366396880041626704217305"))
    a81  = convert(T, BigFloat("113.4755131883738522204615568160304033854"))
    a82  = convert(T, BigFloat("0"))
    a83  = convert(T, BigFloat("-450.8122021555997002820400438087344405365"))
    a84  = convert(T, BigFloat("358.5132765190089889943579090008312808216"))
    a85  = convert(T, BigFloat("-21.45046667648445540174055882443151176550"))
    a86  = convert(T, BigFloat("1.274053318605952891766776667539031508649"))
    a87  = convert(T, BigFloat("-0.002174193904638422805639851234763413667602"))
    a91  = convert(T, BigFloat("115.6996223324232534824963925993127275021"))
    a92  = convert(T, BigFloat("0"))
    a93  = convert(T, BigFloat("-459.6635446100248030478961869239726305957"))
    a94  = convert(T, BigFloat("365.5534717131745930309149378867953890507"))
    a95  = convert(T, BigFloat("-21.88511586349784824146225495848432937529"))
    a96  = convert(T, BigFloat("1.298718109698721459187976480852777474315"))
    a97  = convert(T, BigFloat("-0.00005318700918481883515898878747322241917739"))
    a98  = convert(T, BigFloat("-0.003098494764731864405706095716460833640254"))
    a101 = convert(T, BigFloat("124.1543935612464600014576130437603883332"))
    a102 = convert(T, BigFloat("0"))
    a103 = convert(T, BigFloat("-493.2318713314597046194663569971348299332"))
    a104 = convert(T, BigFloat("392.2086219315800762927575562172365337929"))
    a105 = convert(T, BigFloat("-23.48641564290853341361596821616234280392"))
    a106 = convert(T, BigFloat("1.362322948908907509911149920532561575254"))
    a107 = convert(T, BigFloat("-0.007051467367205771043993968232310964220061"))
    a108 = convert(T, BigFloat("0"))
    a109 = convert(T, BigFloat("0"))

    # High order weights
    b1  = convert(T, BigFloat("0.05163520172057869163393251056217968836723"))
    b2  = convert(T, BigFloat("0"))
    b3  = convert(T, BigFloat("0"))
    b4  = convert(T, BigFloat("0.2767172535461648728769641534539952501983"))
    b5  = convert(T, BigFloat("0.3374175285287150670818592701488271741753"))
    b6  = convert(T, BigFloat("0.1884488267810967803491085059046161195540"))
    b7  = convert(T, BigFloat("24.54134121634868026791753618430192161716"))
    b8  = convert(T, BigFloat("-68.81190284469011946382716084194838780382"))
    b9  = convert(T, BigFloat("44.41634281776488378396776021757684795437"))
    b10 = convert(T, BigFloat("0"))

    # Low order weights
    bh1  = convert(T, BigFloat("0.05089676583692947576073561095512200263213"))
    bh2  = convert(T, BigFloat("0"))
    bh3  = convert(T, BigFloat("0"))
    bh4  = convert(T, BigFloat("0.2793777374763233901369432426263934138476"))
    bh5  = convert(T, BigFloat("0.3281330142746535239936396881369403928344"))
    bh6  = convert(T, BigFloat("0.224172121818615103358179483735013"))
    bh7 = convert(T, BigFloat("0.7874574778015076584344903106189416715189"))
    bh8 = convert(T, BigFloat("0"))
    bh9 = convert(T, BigFloat("0"))
    bh10 = convert(T, BigFloat("-0.6700371172080291516839883360724104817561"))

    RKV76IIaTableau(c1, c2, c3, c4, c5, c6, c7, c8, c9, c10,
                    a21, a31, a32, a41, a42, a43, a51, a52, a53, a54,
                    a61, a62, a63, a64, a65, a71, a72, a73, a74, a75, a76,
                    a81, a82, a83, a84, a85, a86, a87,
                    a91, a92, a93, a94, a95, a96, a97, a98,
                    a101, a102, a103, a104, a105, a106, a107, a108, a109,
                    b1, b2, b3, b4, b5, b6, b7, b8, b9, b10,
                    bh1, bh2, bh3, bh4, bh5, bh6, bh7, bh8, bh9, bh10)
end
