function SROCK1ConstantCache{T}(zprev) where {T}
    ms = SVector{10, Int}(3, 5, 7, 10, 25, 50, 75, 100, 150, 200)
    mη = SVector{10, T}(2.2, 12.0, 13.0, 14.3, 20.3, 27.2, 32.1, 36.0, 42.1, 46.7)
    SROCK1ConstantCache{typeof(zprev), T}(ms, mη, zprev, 1, one(T))
end

function SROCK2ConstantCache{T}(zprev) where {T}
    ms = SVector{46, Int}(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
        17, 18, 19, 20, 22, 24, 26, 28, 30, 33, 36, 39, 43,
        47, 51, 56, 61, 66, 72, 78, 85, 93, 102, 112, 123, 135, 148, 163, 180, 198)
    recf = [
        0.1794612899156781e+00,
        0.9326607661089206e-01,
        0.1268473641290642e+00,
        0.2103378190528467e-01,
        0.5786627125519110e-01,
        0.7776456841673992e-01,
        0.2157791817707098e-01,
        0.9528922876588625e-01,
        0.8723622960881585e-01,
        0.3957407527591189e-01,
        0.5338681630900877e-01,
        0.2247986572029358e-01,
        0.6393794866013653e-01,
        0.8616759602466630e-01,
        0.7433164225960258e-01,
        0.1608966052260327e+00,
        0.2881884349012583e-01,
        0.3903194468364506e-01,
        0.2315538732440072e-01,
        0.4666180548151659e-01,
        0.8821448969005685e-01,
        0.5288869100008489e-01,
        0.1558852247558841e+00,
        0.5955157767537859e-01,
        0.2309801425356076e+00,
        0.2193602641069006e-01,
        0.2980001095383432e-01,
        0.2364036352805737e-01,
        0.3566742298660092e-01,
        0.9017696352896830e-01,
        0.4023410528284037e-01,
        0.1575736612169138e+00,
        0.4421100494822930e-01,
        0.2217430621508580e+00,
        0.4869809870617736e-01,
        0.2940499060453847e+00,
        0.1726461340854506e-01,
        0.2350655101084081e-01,
        0.2399195202240830e-01,
        0.2817607209777294e-01,
        0.9173675182820953e-01,
        0.3176838133583184e-01,
        0.1600219376374877e+00,
        0.3469194451695863e-01,
        0.2221486436776174e+00,
        0.3738763501161190e-01,
        0.2814712676591709e+00,
        0.4053195010515956e-01,
        0.3498597719348680e+00,
        0.1394572558988917e-01,
        0.1901965402711647e-01,
        0.2425291169233543e-01,
        0.2282720812165174e-01,
        0.9294575674653435e-01,
        0.2575013323611407e-01,
        0.1622227426315588e+00,
        0.2807705415789230e-01,
        0.2243919049772138e+00,
        0.3005377306193452e-01,
        0.2802435651401261e+00,
        0.3196472247412495e-01,
        0.3348331353768858e+00,
        0.3423680369928859e-01,
        0.3989016641565190e+00,
        0.1150212461258425e-01,
        0.1570710434739234e-01,
        0.2445103607680476e-01,
        0.1887147450684578e-01,
        0.9388711032641100e-01,
        0.2130209293934879e-01,
        0.1640457400037581e+00,
        0.2322314183593871e-01,
        0.2267657098371261e+00,
        0.2480419563989607e-01,
        0.2818605427391582e+00,
        0.2620108024481186e-01,
        0.3319747646481704e+00,
        0.2760343567567814e-01,
        0.3822711818317003e+00,
        0.2928725018247521e-01,
        0.4419889482818066e+00,
        0.9650189035331108e-02,
        0.1319127118048348e-01,
        0.2460463437251803e-01,
        0.1586242507387037e-01,
        0.9462914691841271e-01,
        0.1791697874611395e-01,
        0.1655306545097223e+00,
        0.1953741662819831e-01,
        0.2288845437800309e+00,
        0.2085448736610660e-01,
        0.2840687821706643e+00,
        0.2197276738303543e-01,
        0.3327621634208670e+00,
        0.2299581340430604e-01,
        0.3779528907207973e+00,
        0.2405334751606276e-01,
        0.4244163000944219e+00,
        0.2532773055505536e-01,
        0.4799238174596328e+00,
        0.8212831461177801e-02,
        0.1123533801931148e-01,
        0.2472592539190680e-01,
        0.1351988263110243e-01,
        0.9522208667469109e-01,
        0.1527968649293853e-01,
        0.1667413647253854e+00,
        0.1666740304836073e-01,
        0.2306916351605186e+00,
        0.1778972104750926e-01,
        0.2862271893660237e+00,
        0.1872598244401872e-01,
        0.3345934460509904e+00,
        0.1954407472805166e-01,
        0.3778520013827246e+00,
        0.2031544030249000e-01,
        0.4188775043096391e+00,
        0.2113066217102199e-01,
        0.4619185110779211e+00,
        0.2211266742157054e-01,
        0.5134449754977242e+00,
        0.7074719613815112e-02,
        0.9684509591053977e-02,
        0.2482326781574381e-01,
        0.1166040318768419e-01,
        0.9570219065303219e-01,
        0.1318459890146430e-01,
        0.1677351729038757e+00,
        0.1438717215812115e-01,
        0.2322139970245483e+00,
        0.1535795943897448e-01,
        0.2881631572191675e+00,
        0.1616136143489047e-01,
        0.3366119552764601e+00,
        0.1684787625840699e-01,
        0.3791920530521655e+00,
        0.1746359793359561e-01,
        0.4179163657739238e+00,
        0.1805925334195525e-01,
        0.4554086296687285e+00,
        0.1869919690078058e-01,
        0.4953803203133830e+00,
        0.1946782991114719e-01,
        0.5431953913817005e+00,
        0.6158116280205625e-02,
        0.8434133870779752e-02,
        0.2490250308471492e-01,
        0.1015973796908432e-01,
        0.9609568511780181e-01,
        0.1149255448537381e-01,
        0.1685578212579456e+00,
        0.1254496388900155e-01,
        0.2334953976202505e+00,
        0.1339412026724050e-01,
        0.2898496927042313e+00,
        0.1409430683259744e-01,
        0.3385311597112782e+00,
        0.1468607650095395e-01,
        0.3809553853632720e+00,
        0.1520306181269769e-01,
        0.4187183922578105e+00,
        0.1567773486210682e-01,
        0.4536627812581018e+00,
        0.1614693417033556e-01,
        0.4881324072137513e+00,
        0.1665708022899876e-01,
        0.5253402953586265e+00,
        0.1726712768780420e-01,
        0.5697310475495430e+00,
        0.5408899288459016e-02,
        0.7411165652735432e-02,
        0.2496784203339785e-01,
        0.8931010375660927e-02,
        0.9642194989632852e-01,
        0.1010622203571924e-01,
        0.1692450860120974e+00,
        0.1103497280658699e-01,
        0.2345784420179126e+00,
        0.1178444954979593e-01,
        0.2913056300783272e+00,
        0.1240145878830343e-01,
        0.3402656182942943e+00,
        0.1292005530031986e-01,
        0.3827567779382510e+00,
        0.1336687811001040e-01,
        0.4201602339064523e+00,
        0.1376523513966666e-01,
        0.4539235794662016e+00,
        0.1413868046925951e-01,
        0.4856954694207845e+00,
        0.1451444200099929e-01,
        0.5175484724211766e+00,
        0.1492644572980292e-01,
        0.5522503690808819e+00,
        0.1541651122328756e-01,
        0.5934874290489524e+00,
        0.4788707289765767e-02,
        0.6563722805402352e-02,
        0.2502230585699310e-01,
        0.7912416503013329e-02,
        0.9669512238638367e-01,
        0.8956313102014822e-02,
        0.1698239427218661e+00,
        0.9781969024648538e-02,
        0.2354985079518828e+00,
        0.1044851744036037e-01,
        0.2925601105800896e+00,
        0.1099693219507985e-01,
        0.3418012690877302e+00,
        0.1145659208699840e-01,
        0.3844521174650939e+00,
        0.1184970544276362e-01,
        0.4217763245489749e+00,
        0.1219446847463953e-01,
        0.4550117593290032e+00,
        0.1250758855429112e-01,
        0.4854408050495134e+00,
        0.1280655793511545e-01,
        0.5145268041703330e+00,
        0.1311180392585363e-01,
        0.5440941264902900e+00,
        0.1344843304771755e-01,
        0.5765229845165943e+00,
        0.1384655622092475e-01,
        0.6148795064211108e+00,
        0.4269409473142479e-02,
        0.5853691221954542e-02,
        0.2506818803768801e-01,
        0.7058488452666192e-02,
        0.9692609816181726e-01,
        0.7991811416685026e-02,
        0.1703157380843560e+00,
        0.8730579305889177e-02,
        0.2362853743226745e+00,
        0.9327287399213484e-02,
        0.2936438651173445e+00,
        0.9818197983040463e-02,
        0.3431514772416978e+00,
        0.1022909697576184e-01,
        0.3859958359229893e+00,
        0.1057909230023007e-01,
        0.4233725763238417e+00,
        0.1088320687501712e-01,
        0.4564025740290915e+00,
        0.1115430586715170e-01,
        0.4861671131891395e+00,
        0.1140470198717317e-01,
        0.5137949407970326e+00,
        0.1164762828827466e-01,
        0.5405812657784165e+00,
        0.1189859698528282e-01,
        0.5681279106485080e+00,
        0.1217639078124160e-01,
        0.5984802463148428e+00,
        0.1250297795297910e-01,
        0.6341959825388761e+00,
        0.3830262680422776e-02,
        0.5252924239469980e-02,
        0.2510718258012232e-01,
        0.6335607341496969e-02,
        0.9712300411103620e-01,
        0.7174964200736387e-02,
        0.1707366515477548e+00,
        0.7839821469171156e-02,
        0.2369623770049865e+00,
        0.8377122084280812e-02,
        0.2945833847967025e+00,
        0.8819233466500510e-02,
        0.3443363340392364e+00,
        0.9189060633588098e-02,
        0.3873807210303031e+00,
        0.9503378800566590e-02,
        0.4248706039873364e+00,
        0.9775047051845269e-02,
        0.4578585641947919e+00,
        0.1001457306569686e-01,
        0.4873111192988822e+00,
        0.1023132837651919e-01,
        0.5141675256404127e+00,
        0.1043459649534057e-01,
        0.5394214279393358e+00,
        0.1063454146082206e-01,
        0.5642188354052674e+00,
        0.1084307018096031e-01,
        0.5899649430016252e+00,
        0.1107438039614643e-01,
        0.6184184090843611e+00,
        0.1134470195438803e-01,
        0.6517206797990772e+00,
        0.3454097785831183e-02,
        0.4738087690909603e-02,
        0.2514098616718916e-01,
        0.5715864568881495e-02,
        0.9729414530950285e-01,
        0.6474399737140852e-02,
        0.1711037123670141e+00,
        0.7075625560198937e-02,
        0.2375553213635903e+00,
        0.7561765789488958e-02,
        0.2954111541648083e+00,
        0.7961900378019848e-02,
        0.3453896252983967e+00,
        0.8296546652001753e-02,
        0.3886303020948080e+00,
        0.8580623356383655e-02,
        0.4262600339398994e+00,
        0.8825386359541219e-02,
        0.4592889162561250e+00,
        0.9039751450513938e-02,
        0.4886139630455138e+00,
        0.9231266796183848e-02,
        0.5150610315193943e+00,
        0.9406897826583457e-02,
        0.5394434170928742e+00,
        0.9573720059444631e-02,
        0.5626311157802961e+00,
        0.9739556257960886e-02,
        0.5856281920506604e+00,
        0.9913518363761172e-02,
        0.6096518917386764e+00,
        0.1010629643624125e-01,
        0.6361953557375821e+00,
        0.1032986385558493e-01,
        0.6670333276830246e+00,
        0.3131660281084644e-02,
        0.4296601495430642e-02,
        0.2516987418923732e-01,
        0.5184210888756367e-02,
        0.9744072529384443e-01,
        0.5873198129887241e-02,
        0.1714189769006723e+00,
        0.6419613566950146e-02,
        0.2380664100570842e+00,
        0.6861660893085171e-02,
        0.2961280333876439e+00,
        0.7225632384805198e-02,
        0.3463080420218410e+00,
        0.7530044942257158e-02,
        0.3897316580976775e+00,
        0.7788304877568383e-02,
        0.4275077537500284e+00,
        0.8010430934156830e-02,
        0.4606200718057599e+00,
        0.8204207591967734e-02,
        0.4899241115804965e+00,
        0.8376002129523446e-02,
        0.5161793704075401e+00,
        0.8531389917004647e-02,
        0.5400945718660145e+00,
        0.8675676859844067e-02,
        0.5623795630774431e+00,
        0.8814368379677447e-02,
        0.5838024839647016e+00,
        0.8953595816500299e-02,
        0.6052506199023559e+00,
        0.9100459154569437e-02,
        0.6277890216584121e+00,
        0.9263166205736671e-02,
        0.6527013571399886e+00,
        0.9450740555370751e-02,
        0.6814810379908328e+00,
        0.2843902743022214e-02,
        0.3902467368190393e-02,
        0.2519598783827689e-01,
        0.4709429895823432e-02,
        0.9757348323445656e-01,
        0.5336152661315786e-02,
        0.1717052034351406e+00,
        0.5833455676281756e-02,
        0.2385318286257855e+00,
        0.6235971415149352e-02,
        0.2967834040784211e+00,
        0.6567522559559145e-02,
        0.3471521575495951e+00,
        0.6844866528765064e-02,
        0.3907519751170857e+00,
        0.7080101687099548e-02,
        0.4286785748173565e+00,
        0.7282213357366904e-02,
        0.4618976089399920e+00,
        0.7458094741776693e-02,
        0.4912372216070018e+00,
        0.7613251892383208e-02,
        0.5174141871126332e+00,
        0.7752321382046524e-02,
        0.5410706897885087e+00,
        0.7879480568321315e-02,
        0.5628149979263304e+00,
        0.7998799282231232e-02,
        0.5832647350414633e+00,
        0.8114557939046675e-02,
        0.6030926481771959e+00,
        0.8231531848213922e-02,
        0.6230734887604330e+00,
        0.8355206753895567e-02,
        0.6441267697250795e+00,
        0.8491839744291131e-02,
        0.6673428282976036e+00,
        0.8648214015485162e-02,
        0.6939680907913989e+00,
        0.2388386682754135e-02,
        0.3278278227000989e-02,
        0.2523707236937346e-01,
        0.3957198838737114e-02,
        0.9778285117940603e-01,
        0.4484932501394734e-02,
        0.1721579526332683e+00,
        0.4904057483051761e-02,
        0.2392707453970052e+00,
        0.5243583901636578e-02,
        0.2978287368553751e+00,
        0.5523456007427060e-02,
        0.3485067686781220e+00,
        0.5757685183723855e-02,
        0.3924033610212076e+00,
        0.5956358204781419e-02,
        0.4305980352749587e+00,
        0.6126919713095007e-02,
        0.4640361265644109e+00,
        0.6275007901630985e-02,
        0.4935170207127558e+00,
        0.6405016526854853e-02,
        0.5197143572851120e+00,
        0.6520488779186820e-02,
        0.5432046533152863e+00,
        0.6624408123666273e-02,
        0.5644970257796814e+00,
        0.6719427053538581e-02,
        0.5840623664365776e+00,
        0.6808059512718916e-02,
        0.6023621974962409e+00,
        0.6892851836922015e-02,
        0.6198777517486085e+00,
        0.6976537015760206e-02,
        0.6371392310474401e+00,
        0.7062164945929763e-02,
        0.6547536993606798e+00,
        0.7153184521396811e-02,
        0.6734273362784953e+00,
        0.7253430606435754e-02,
        0.6939734212185117e+00,
        0.7366943161281851e-02,
        0.7172914790760468e+00,
        0.2034217998243191e-02,
        0.2792734020582961e-02,
        0.2526908982706098e-01,
        0.3371787305020115e-02,
        0.9794643062684199e-01,
        0.3822201062511950e-02,
        0.1725128108619325e+00,
        0.4180174912236582e-02,
        0.2398521447789659e+00,
        0.4470370456915701e-02,
        0.2986551495007976e+00,
        0.4709737539597480e-02,
        0.3495841277608567e+00,
        0.4910176531706057e-02,
        0.3937272155460690e+00,
        0.5080243210917943e-02,
        0.4321540636611387e+00,
        0.5226234784652425e-02,
        0.4657990145921906e+00,
        0.5352893648837146e-02,
        0.4954473934553277e+00,
        0.5463875356202293e-02,
        0.5217531788617480e+00,
        0.5562069670587001e-02,
        0.5452642338468077e+00,
        0.5649829175907964e-02,
        0.5664474938420431e+00,
        0.5729139522573558e-02,
        0.5857122023051498e+00,
        0.5801753106324432e-02,
        0.6034312542567038e+00,
        0.5869300229750696e-02,
        0.6199612865321288e+00,
        0.5933386406539511e-02,
        0.6356621535317655e+00,
        0.5995679940966749e-02,
        0.6509160921778130e+00,
        0.6057989063542723e-02,
        0.6661462081376089e+00,
        0.6122321685397079e-02,
        0.6818327797828450e+00,
        0.6190912476732130e-02,
        0.6985240974244095e+00,
        0.6266191569573649e-02,
        0.7168360261395987e+00,
        0.6350658968555684e-02,
        0.7374314365934664e+00,
        0.1753390300533029e-02,
        0.2407592405123618e-02,
        0.2529453985226700e-01,
        0.2907262330175829e-02,
        0.9807671703676038e-01,
        0.3296143053353250e-02,
        0.1727961462451250e+00,
        0.3605393786629613e-02,
        0.2403177529025610e+00,
        0.3856241133152162e-02,
        0.2993193629853389e+00,
        0.4063271707574896e-02,
        0.3504538499243808e+00,
        0.4236723270781009e-02,
        0.3948018542411614e+00,
        0.4383951358482999e-02,
        0.4334263916612830e+00,
        0.4510362519918408e-02,
        0.4672550951343391e+00,
        0.4620017586359210e-02,
        0.4970655128750277e+00,
        0.4716030788908096e-02,
        0.5235015776135139e+00,
        0.4800840911719355e-02,
        0.5470972903869747e+00,
        0.4876401000932111e-02,
        0.5682998788764699e+00,
        0.4944315587632199e-02,
        0.5874903820382004e+00,
        0.5005943872710219e-02,
        0.6050015924522462e+00,
        0.5062480886612362e-02,
        0.6211339094140743e+00,
        0.5115024538196171e-02,
        0.6361697673414449e+00,
        0.5164633649628788e-02,
        0.6503872077614197e+00,
        0.5212379842880342e-02,
        0.6640729475349860e+00,
        0.5259393975018879e-02,
        0.6775349550821846e+00,
        0.5306905271212799e-02,
        0.6911140242391297e+00,
        0.5356268008877997e-02,
        0.7051930501274516e+00,
        0.5408966392479879e-02,
        0.7202015894622125e+00,
        0.5466583459521371e-02,
        0.7366118374462400e+00,
        0.5530715851949468e-02,
        0.7549206082556241e+00,
        0.1526985597447617e-02,
        0.2096996473761840e-02,
        0.2531509673360445e-01,
        0.2532539440756325e-02,
        0.9818212210216928e-01,
        0.2871665019548934e-02,
        0.1730258242612469e+00,
        0.3141479576178890e-02,
        0.2406960805778798e+00,
        0.3360448272795954e-02,
        0.2998605891705305e+00,
        0.3541258850863859e-02,
        0.3511649206182530e+00,
        0.3692814597959592e-02,
        0.3956840637564039e+00,
        0.3821509918296340e-02,
        0.4344762665775814e+00,
        0.3932041593754749e-02,
        0.4684646795111045e+00,
        0.4027932600409154e-02,
        0.4984220865031195e+00,
        0.4111877834418150e-02,
        0.5249867454711314e+00,
        0.4185977901331621e-02,
        0.5486853051737176e+00,
        0.4251901290680174e-02,
        0.5699549871771356e+00,
        0.4310999960360177e-02,
        0.5891629130044663e+00,
        0.4364394207792517e-02,
        0.6066224358437886e+00,
        0.4413037135908646e-02,
        0.6226069634301489e+00,
        0.4457765549253931e-02,
        0.6373618910220726e+00,
        0.4499341872619412e-02,
        0.6511152177198366e+00,
        0.4538490146036315e-02,
        0.6640873078294923e+00,
        0.4575927973865173e-02,
        0.6765001110571239e+00,
        0.4612395244609121e-02,
        0.6885859633887566e+00,
        0.4648679290544145e-02,
        0.7005958269983906e+00,
        0.4685634750981115e-02,
        0.7128064532627977e+00,
        0.4724194620734037e-02,
        0.7255254273702650e+00,
        0.4765366815800576e-02,
        0.7390923556807402e+00,
        0.4810208361466176e-02,
        0.7538736313498631e+00,
        0.4859767798035730e-02,
        0.7702474410767316e+00,
        0.1341778429126211e-02,
        0.1842856050972565e-02,
        0.2533193854590164e-01,
        0.2225855496752996e-02,
        0.9826859006407132e-01,
        0.2524180832845478e-02,
        0.1732145392603280e+00,
        0.2761629971248482e-02,
        0.2410075282122661e+00,
        0.2954414092304398e-02,
        0.3003071440620802e+00,
        0.3113671483601745e-02,
        0.3517531700231469e+00,
        0.3247217194092525e-02,
        0.3964161974860505e+00,
        0.3360662822142730e-02,
        0.4353508843394245e+00,
        0.3458128531982532e-02,
        0.4694771791546352e+00,
        0.3542702530515273e-02,
        0.4995646943102908e+00,
        0.3616743969933074e-02,
        0.5262481851213445e+00,
        0.3682087306007793e-02,
        0.5500500545141821e+00,
        0.3740183451080423e-02,
        0.5714020312900166e+00,
        0.3792199619292558e-02,
        0.5906638632386166e+00,
        0.3839091722399387e-02,
        0.6081388453953844e+00,
        0.3881658284331042e-02,
        0.6240866310409383e+00,
        0.3920581807177477e-02,
        0.6387339085746301e+00,
        0.3956461592009382e-02,
        0.6522834922619609e+00,
        0.3989840752967416e-02,
        0.6649222876852415e+00,
        0.4021229291927125e-02,
        0.6768284931080795e+00,
        0.4051124448454234e-02,
        0.6881782931898644e+00,
        0.4080028981647300e-02,
        0.6991521843388895e+00,
        0.4108467479283411e-02,
        0.7099409264259735e+00,
        0.4137000143073717e-02,
        0.7207509236661780e+00,
        0.4166232701476242e-02,
        0.7318085765567045e+00,
        0.4196820124371787e-02,
        0.7433628001322098e+00,
        0.4229460707743591e-02,
        0.7556844737332599e+00,
        0.4264876064174216e-02,
        0.7690611204503529e+00,
        0.4303772042593957e-02,
        0.7837847386079905e+00,
        0.1121314683543782e-02,
        0.1540263996358294e-02,
        0.2535201582246297e-01,
        0.1860616782749459e-02,
        0.9837180081070001e-01,
        0.2110257847461394e-02,
        0.1734401492675452e+00,
        0.2309054725495130e-02,
        0.2413805649139678e+00,
        0.2470541128098822e-02,
        0.3008431837086572e+00,
        0.2604015187479208e-02,
        0.3524611103987945e+00,
        0.2716000109093522e-02,
        0.3972999402435936e+00,
        0.2811178999641960e-02,
        0.4364103598053284e+00,
        0.2892989192294541e-02,
        0.4707089285552096e+00,
        0.2964005631609554e-02,
        0.5009621096861159e+00,
        0.3026193412069002e-02,
        0.5278014394899639e+00,
        0.3081077890619739e-02,
        0.5517457095527168e+00,
        0.3129861843706196e-02,
        0.5732222749918362e+00,
        0.3173507910562157e-02,
        0.5925852995229407e+00,
        0.3212797846468413e-02,
        0.6101307283827272e+00,
        0.3248376022424070e-02,
        0.6261084073494506e+00,
        0.3280782072682338e-02,
        0.6407319017471913e+00,
        0.3310475987498136e-02,
        0.6541865362303725e+00,
        0.3337857911967330e-02,
        0.6666360953708608e+00,
        0.3363284226199348e-02,
        0.6782285398626227e+00,
        0.3387081014309363e-02,
        0.6891010163282705e+00,
        0.3409555695216232e-02,
        0.6993843710724037e+00,
        0.3431007330102873e-02,
        0.7092073156356478e+00,
        0.3451735898380667e-02,
        0.7187003283870178e+00,
        0.3472050613465582e-02,
        0.7279993040305766e+00,
        0.3492277104239913e-02,
        0.7372488732478574e+00,
        0.3512762995683089e-02,
        0.7466051990304045e+00,
        0.3533881070388274e-02,
        0.7562379075535515e+00,
        0.3556028788751684e-02,
        0.7663306282943305e+00,
        0.3579622533335547e-02,
        0.7770794116956159e+00,
        0.3605084625764653e-02,
        0.7886880974410957e+00,
        0.3632821128406038e-02,
        0.8013595930224617e+00,
        0.9510596127542824e-03,
        0.1306530384822369e-02,
        0.2536754145655561e-01,
        0.1578428318009605e-02,
        0.9845171104183325e-01,
        0.1790384464545768e-02,
        0.1736150904003335e+00,
        0.1959236797520781e-02,
        0.2416703438788951e+00,
        0.2096455322227467e-02,
        0.3012604613663233e+00,
        0.2209920074417597e-02,
        0.3530135437139923e+00,
        0.2305159021830049e-02,
        0.3979914926982783e+00,
        0.2386140355447109e-02,
        0.4372421218440167e+00,
        0.2455776174573485e-02,
        0.4716796241323911e+00,
        0.2516247355295036e-02,
        0.5020683797660233e+00,
        0.2569217475366734e-02,
        0.5290379452961959e+00,
        0.2615976824974766e-02,
        0.5531050686294569e+00,
        0.2657541470416690e-02,
        0.5746948225947125e+00,
        0.2694722818617351e-02,
        0.5941586518170510e+00,
        0.2728177434091533e-02,
        0.6117891098846177e+00,
        0.2758443393525188e-02,
        0.6278316916720729e+00,
        0.2785967312803683e-02,
        0.6424943013679313e+00,
        0.2811124820961013e-02,
        0.6559548636293389e+00,
        0.2834236378150614e-02,
        0.6683675049794192e+00,
        0.2855579757979202e-02,
        0.6798676490616872e+00,
        0.2875400127857228e-02,
        0.6905762965442401e+00,
        0.2893918395849096e-02,
        0.7006037006910071e+00,
        0.2911338305155523e-02,
        0.7100526010841707e+00,
        0.2927852618951001e-02,
        0.7190211375279999e+00,
        0.2943648628770056e-02,
        0.7276055302511653e+00,
        0.2958913124102285e-02,
        0.7359025774945679e+00,
        0.2973836867449520e-02,
        0.7440119836573593e+00,
        0.2988618517881438e-02,
        0.7520384865047949e+00,
        0.3003467829003067e-02,
        0.7600936967329708e+00,
        0.3018607809042993e-02,
        0.7682974943112553e+00,
        0.3034275371809675e-02,
        0.7767787422315526e+00,
        0.3050719837809893e-02,
        0.7856749823571740e+00,
        0.3068198491381527e-02,
        0.7951306800776951e+00,
        0.3086968312155531e-02,
        0.8052935061547398e+00,
        0.3107273055760290e-02,
        0.8163081231039382e+00,
        0.8168405299925574e-03,
        0.1122235164426433e-02,
        0.2537979319269659e-01,
        0.1355887567479481e-02,
        0.9851483086228864e-01,
        0.1538080541563495e-02,
        0.1737534362414166e+00,
        0.1683267147792567e-02,
        0.2418998259562802e+00,
        0.1801292850812278e-02,
        0.3015914511597799e+00,
        0.1898921476480742e-02,
        0.3534525616677698e+00,
        0.1980897763334222e-02,
        0.3985422441814719e+00,
        0.2050627450222160e-02,
        0.4379061538920372e+00,
        0.2110609627253456e-02,
        0.4724567457971343e+00,
        0.2162715579344156e-02,
        0.5029569229728563e+00,
        0.2208372378885260e-02,
        0.5300349067999921e+00,
        0.2248686443403842e-02,
        0.5542061521610998e+00,
        0.2284528486070424e-02,
        0.5758943864439198e+00,
        0.2316593115008434e-02,
        0.5954495572468082e+00,
        0.2345441446771229e-02,
        0.6131624579583983e+00,
        0.2371532122833287e-02,
        0.6292764292152166e+00,
        0.2395244271202193e-02,
        0.6439966702794445e+00,
        0.2416894786788224e-02,
        0.6574976613071741e+00,
        0.2436751550587987e-02,
        0.6699291171394233e+00,
        0.2455043712749272e-02,
        0.6814208098492533e+00,
        0.2471969833678045e-02,
        0.6920865249452547e+00,
        0.2487704452255031e-02,
        0.7020273575786585e+00,
        0.2502403494283208e-02,
        0.7113345090150194e+00,
        0.2516208823898241e-02,
        0.7200917075437527e+00,
        0.2529252160257252e-02,
        0.7283773493344920e+00,
        0.2541658520726186e-02,
        0.7362664311381890e+00,
        0.2553549302394987e-02,
        0.7438323260356781e+00,
        0.2565045070295341e-02,
        0.7511484336838515e+00,
        0.2576268078538789e-02,
        0.7582897158118264e+00,
        0.2587344505847411e-02,
        0.7653341042347025e+00,
        0.2598406336420720e-02,
        0.7723637406308460e+00,
        0.2609592758562768e-02,
        0.7794659733020046e+00,
        0.2621050886496552e-02,
        0.7867339953288847e+00,
        0.2632935537833889e-02,
        0.7942669615898086e+00,
        0.2645407727623461e-02,
        0.8021693721981406e+00,
        0.2658631484279102e-02,
        0.8105494642340256e+00,
        0.2672768576741324e-02,
        0.8195163250963701e+00,
        0.2687970799566830e-02,
        0.8291754492311013e+00,
        0.6779619032019482e-03,
        0.9315109162316307e-03,
        0.2539248163813982e-01,
        0.1125546650705646e-02,
        0.9858025661395591e-01,
        0.1276892135791717e-02,
        0.1738969874989156e+00,
        0.1397535825902466e-02,
        0.2421382412064102e+00,
        0.1495644371531161e-02,
        0.3019358267641449e+00,
        0.1576828175558173e-02,
        0.3539100964089328e+00,
        0.1645022736116236e-02,
        0.3991173116956755e+00,
        0.1703052777188943e-02,
        0.4386009869035954e+00,
        0.1752990885928625e-02,
        0.4732718824089663e+00,
        0.1796388809395077e-02,
        0.5038914977622926e+00,
        0.1834429731186084e-02,
        0.5310868327976426e+00,
        0.1868030737964622e-02,
        0.5553722186397624e+00,
        0.1897913248880432e-02,
        0.5771702844407484e+00,
        0.1924652401977583e-02,
        0.5968298361224380e+00,
        0.1948712334483372e-02,
        0.6146404100545767e+00,
        0.1970471824369135e-02,
        0.6308438946964407e+00,
        0.1990243228225435e-02,
        0.6456437499005518e+00,
        0.2008286680798674e-02,
        0.6592123207734590e+00,
        0.2024820896049421e-02,
        0.6716966627198852e+00,
        0.2040031498715453e-02,
        0.6832232108862492e+00,
        0.2054077540780530e-02,
        0.6939015548982263e+00,
        0.2067096670752565e-02,
        0.7038275213823140e+00,
        0.2079209295013150e-02,
        0.7130857211033993e+00,
        0.2090521980414542e-02,
        0.7217516823653617e+00,
        0.2101130283221459e-02,
        0.7298936653027928e+00,
        0.2111121143106236e-02,
        0.7375742308368269e+00,
        0.2120574946574002e-02,
        0.7448516217331510e+00,
        0.2129567338002603e-02,
        0.7517810000528958e+00,
        0.2138170835613056e-02,
        0.7584155742314791e+00,
        0.2146456292026427e-02,
        0.7648076391248480e+00,
        0.2154494222946041e-02,
        0.7710095427995872e+00,
        0.2162356011555635e-02,
        0.7770745838488886e+00,
        0.2170114979286494e-02,
        0.7830578318730199e+00,
        0.2177847294739602e-02,
        0.7890168508176265e+00,
        0.2185632671118797e-02,
        0.7950122895929717e+00,
        0.2193554778405604e-02,
        0.8011082865424130e+00,
        0.2201701270375675e-02,
        0.8073726141153927e+00,
        0.2210163300386258e-02,
        0.8138764685711868e+00,
        0.2219034377453016e-02,
        0.8206937889887615e+00,
        0.2228408401671311e-02,
        0.8278999743285053e+00,
        0.2238376724427438e-02,
        0.8355698630075664e+00,
        0.2249024115421597e-02,
        0.8437748549346639e+00,
        0.5717171765067005e-03,
        0.7855819755678591e-03,
        0.2540219552841172e-01,
        0.9492803029534314e-03,
        0.9863038311884588e-01,
        0.1076991591417719e-02,
        0.1740070746137774e+00,
        0.1178820912278011e-02,
        0.2423212835361945e+00,
        0.1261652009696089e-02,
        0.3022005646620261e+00,
        0.1330213911048136e-02,
        0.3542623490383656e+00,
        0.1387823796651901e-02,
        0.3995607968545022e+00,
        0.1436862514566579e-02,
        0.4391378457027524e+00,
        0.1479076886266864e-02,
        0.4739030248719332e+00,
        0.1515774672793500e-02,
        0.5046168340722528e+00,
        0.1547952929687645e-02,
        0.5319054272436042e+00,
        0.1576384371750672e-02,
        0.5562823875920914e+00,
        0.1601676728454795e-02,
        0.5781696502895681e+00,
        0.1624314356699193e-02,
        0.5979153431712045e+00,
        0.1644687957566232e-02,
        0.6158083043507766e+00,
        0.1663116161966728e-02,
        0.6320896668598296e+00,
        0.1679861458243818e-02,
        0.6469620376959935e+00,
        0.1695142117261203e-02,
        0.6605967661879515e+00,
        0.1709141243106296e-02,
        0.6731397164733577e+00,
        0.1722013731055875e-02,
        0.6847158755342791e+00,
        0.1733891682879084e-02,
        0.6954330559199739e+00,
        0.1744888672268816e-02,
        0.7053848938737558e+00,
        0.1755103144742999e-02,
        0.7146532979347533e+00,
        0.1764621160512043e-02,
        0.7233104679728801e+00,
        0.1773518635044922e-02,
        0.7314205777797613e+00,
        0.1781863193450182e-02,
        0.7390411938444027e+00,
        0.1789715726676655e-02,
        0.7462244872361469e+00,
        0.1797131716770826e-02,
        0.7530182833863068e+00,
        0.1804162382812431e-02,
        0.7594669850655551e+00,
        0.1810855687135456e-02,
        0.7656123962667175e+00,
        0.1817257231900906e-02,
        0.7714944684438817e+00,
        0.1823411068174413e-02,
        0.7771519851570839e+00,
        0.1829360432715894e-02,
        0.7826231962275617e+00,
        0.1835148421173907e-02,
        0.7879464076688663e+00,
        0.1840818599844342e-02,
        0.7931605286026111e+00,
        0.1846415551221751e-02,
        0.7983055707993119e+00,
        0.1851985340937259e-02,
        0.8034230901440029e+00,
        0.1857575885138658e-02,
        0.8085565520117598e+00,
        0.1863237187886467e-02,
        0.8137515941551513e+00,
        0.1869021407926604e-02,
        0.8190561513413812e+00,
        0.1874982703844713e-02,
        0.8245203960095123e+00,
        0.1881176797227895e-02,
        0.8301964394574721e+00,
        0.1887660186864975e-02,
        0.8361377299185951e+00,
        0.1894488945824785e-02,
        0.8423980794999191e+00,
        0.1901717040890795e-02,
        0.8490302543125971e+00,
        0.1909394134299323e-02,
        0.8560840749607826e+00,
        0.4886273679748824e-03,
        0.6714437954649780e-03,
        0.2540979640585205e-01,
        0.8113983041306847e-03,
        0.9866962915608751e-01,
        0.9206047809355559e-03,
        0.1740933291741878e+00,
        0.1007696615844565e-02,
        0.2424648238198073e+00,
        0.1078555077304152e-02,
        0.3024083787838030e+00,
        0.1137220495111209e-02,
        0.3545391775646764e+00,
        0.1186526928471642e-02,
        0.3999097732746233e+00,
        0.1228508433020824e-02,
        0.4395609067610286e+00,
        0.1264657346363223e-02,
        0.4744011819765317e+00,
        0.1296090864949680e-02,
        0.5051903569581037e+00,
        0.1323660708324793e-02,
        0.5325539695623672e+00,
        0.1348026906055910e-02,
        0.5570050719753680e+00,
        0.1369708506508536e-02,
        0.5789651232823036e+00,
        0.1389119124621932e-02,
        0.5987818060211025e+00,
        0.1406592323781286e-02,
        0.6167435227777786e+00,
        0.1422400048200691e-02,
        0.6330909609625438e+00,
        0.1436766218460017e-02,
        0.6480262517065541e+00,
        0.1449876904280157e-02,
        0.6617202166442876e+00,
        0.1461888037961801e-02,
        0.6743181164063009e+00,
        0.1472931335824075e-02,
        0.6859442313853145e+00,
        0.1483118897071317e-02,
        0.6967055330639804e+00,
        0.1492546815085222e-02,
        0.7066946457906411e+00,
        0.1501298043441827e-02,
        0.7159922532405723e+00,
        0.1509444694127518e-02,
        0.7246690686840157e+00,
        0.1517049899494373e-02,
        0.7327874613555573e+00,
        0.1524169336541220e-02,
        0.7404028107621932e+00,
        0.1530852488184009e-02,
        0.7475646451451914e+00,
        0.1537143698611175e-02,
        0.7543176083360913e+00,
        0.1543083066767105e-02,
        0.7607022900146448e+00,
        0.1548707212186899e-02,
        0.7667559471993193e+00,
        0.1554049939909855e-02,
        0.7725131391565733e+00,
        0.1559142825373070e-02,
        0.7780062934020589e+00,
        0.1564015735548671e-02,
        0.7832662167717693e+00,
        0.1568697298775154e-02,
        0.7883225624132202e+00,
        0.1573215332462839e-02,
        0.7932042607791593e+00,
        0.1577597234898074e-02,
        0.7979399201221365e+00,
        0.1581870344542036e-02,
        0.8025581994310868e+00,
        0.1586062267357487e-02,
        0.8070881540792818e+00,
        0.1590201169665478e-02,
        0.8115595515386726e+00,
        0.1594316030726550e-02,
        0.8160031512482756e+00,
        0.1598436845587962e-02,
        0.8204509390209540e+00,
        0.1602594764727253e-02,
        0.8249363021965111e+00,
        0.1606822152724702e-02,
        0.8294941271358440e+00,
        0.1611152543807615e-02,
        0.8341607957498925e+00,
        0.1615620467991531e-02,
        0.8389740528796195e+00,
        0.1620261118280227e-02,
        0.8439727120207893e+00,
        0.1625109827821845e-02,
        0.8491961639288420e+00,
        0.1630201327174513e-02,
        0.8546836521716283e+00,
        0.1635568757273152e-02,
        0.8604732831634605e+00,
        0.1641242424784281e-02,
        0.8666007472872529e+00,
        0.4079721290191449e-03,
        0.5606390646000299e-03,
        0.2541717774246925e-01,
        0.6775302011759068e-03,
        0.9870776119617667e-01,
        0.7687559860220674e-03,
        0.1741771883435951e+00,
        0.8415222726271052e-03,
        0.2426044825025154e+00,
        0.9007379123407699e-03,
        0.3026107489587744e+00,
        0.9497751982407300e-03,
        0.3548090209828054e+00,
        0.9909995793709382e-03,
        0.4002503224647114e+00,
        0.1026108754684635e-02,
        0.4399742629913482e+00,
        0.1056348256439421e-02,
        0.4748885789654610e+00,
        0.1082650488031221e-02,
        0.5057523403210778e+00,
        0.1105726258156915e-02,
        0.5331905211809378e+00,
        0.1126126368448291e-02,
        0.5577156967903346e+00,
        0.1144283937532252e-02,
        0.5797489091761477e+00,
        0.1160544069671673e-02,
        0.5996374632935472e+00,
        0.1175185037186027e-02,
        0.6176694070801912e+00,
        0.1188433661215005e-02,
        0.6340850818085325e+00,
        0.1200476654074482e-02,
        0.6490862674574624e+00,
        0.1211469103358439e-02,
        0.6628434159685319e+00,
        0.1221540901759423e-02,
        0.6755013855037041e+00,
        0.1230801679415364e-02,
        0.6871840056733981e+00,
        0.1239344630375328e-02,
        0.6979977314932807e+00,
        0.1247249512545108e-02,
        0.7080345854591738e+00,
        0.1254585023077141e-02,
        0.7173745414939689e+00,
        0.1261410697040181e-02,
        0.7260874694062653e+00,
        0.1267778438847666e-02,
        0.7342347316708526e+00,
        0.1273733768408534e-02,
        0.7418705038821782e+00,
        0.1279316843997812e-02,
        0.7490428746151535e+00,
        0.1284563309197927e-02,
        0.7557947684726961e+00,
        0.1289505000406732e-02,
        0.7621647269098429e+00,
        0.1294170543282941e-02,
        0.7681875743244604e+00,
        0.1298585860357731e-02,
        0.7738949913863433e+00,
        0.1302774607351322e-02,
        0.7793160132569095e+00,
        0.1306758552112867e-02,
        0.7844774669407445e+00,
        0.1310557907271291e-02,
        0.7894043592864977e+00,
        0.1314191625436819e-02,
        0.7941202249469652e+00,
        0.1317677663971441e-02,
        0.7986474417822638e+00,
        0.1321033224831176e-02,
        0.8030075196380616e+00,
        0.1324274973678666e-02,
        0.8072213670641986e+00,
        0.1327419241294216e-02,
        0.8113095392825265e+00,
        0.1330482209212664e-02,
        0.8152924695008139e+00,
        0.1333480080427699e-02,
        0.8191906844434980e+00,
        0.1336429234887632e-02,
        0.8230250036771799e+00,
        0.1339346368318267e-02,
        0.8268167209024656e+00,
        0.1342248611619848e-02,
        0.8305877638256554e+00,
        0.1345153626679458e-02,
        0.8343608274878259e+00,
        0.1348079672919514e-02,
        0.8381594740079385e+00,
        0.1351045637295423e-02,
        0.8420081896122813e+00,
        0.1354071018825960e-02,
        0.8459323876377299e+00,
        0.1357175857202399e-02,
        0.8499583440311814e+00,
        0.1360380593752449e-02,
        0.8541130499173916e+00,
        0.1363705852281417e-02,
        0.8584239643605064e+00,
        0.1367172127403134e-02,
        0.8629186498951948e+00,
        0.1370799369307807e-02,
        0.8676242742545543e+00,
        0.1374606456942832e-02,
        0.8725669645681554e+00,
        0.1378610556753209e-02,
        0.8777710057814074e+00,
        0.3457584334322357e-03,
        0.4751621453940012e-03,
        0.2542287327621289e-01,
        0.5742529802903852e-03,
        0.9873719754448177e-01,
        0.6515970827455522e-03,
        0.1742419598034706e+00,
        0.7132998513406398e-03,
        0.2427124231693788e+00,
        0.7635205129753468e-03,
        0.3027672771691929e+00,
        0.8051163841037499e-03,
        0.3550179179580828e+00,
        0.8400916805185935e-03,
        0.4005142108161735e+00,
        0.8698848276663640e-03,
        0.4402949133244795e+00,
        0.8955511242402197e-03,
        0.4752671131865228e+00,
        0.9178805496049455e-03,
        0.5061893703422927e+00,
        0.9374753213346000e-03,
        0.5336862457066851e+00,
        0.9548020787478288e-03,
        0.5582699698916923e+00,
        0.9702277440292999e-03,
        0.5803612891309488e+00,
        0.9840446600062942e-03,
        0.6003072470093884e+00,
        0.9964885371329648e-03,
        0.6183956534407280e+00,
        0.1007751484296832e-02,
        0.6348666260010463e+00,
        0.1017991617422186e-02,
        0.6499217274752063e+00,
        0.1027340245776507e-02,
        0.6637311918729225e+00,
        0.1035907317136567e-02,
        0.6764396515818053e+00,
        0.1043785593537480e-02,
        0.6881706952754520e+00,
        0.1051053889330778e-02,
        0.6990305140455065e+00,
        0.1057779608173888e-02,
        0.7091108348943870e+00,
        0.1064020749985821e-02,
        0.7184912951109098e+00,
        0.1069827513031319e-02,
        0.7272413759474827e+00,
        0.1075243583787733e-02,
        0.7354219871919199e+00,
        0.1080307183927825e-02,
        0.7430867737680106e+00,
        0.1085051926828077e-02,
        0.7502831998805611e+00,
        0.1089507523598374e-02,
        0.7570534542643864e+00,
        0.1093700369430917e-02,
        0.7634352109083323e+00,
        0.1097654034185638e-02,
        0.7694622725315966e+00,
        0.1101389675935647e-02,
        0.7751651185850800e+00,
        0.1104926392241615e-02,
        0.7805713752558724e+00,
        0.1108281520887288e-02,
        0.7857062215827314e+00,
        0.1111470899456480e-02,
        0.7905927431287384e+00,
        0.1114509091294428e-02,
        0.7952522425401743e+00,
        0.1117409583946746e-02,
        0.7997045146224264e+00,
        0.1120184965012693e-02,
        0.8039680921873576e+00,
        0.1122847079414237e-02,
        0.8080604677961332e+00,
        0.1125407171312882e-02,
        0.8119982955768120e+00,
        0.1127876013259072e-02,
        0.8157975764884198e+00,
        0.1130264024599364e-02,
        0.8194738296925913e+00,
        0.1132581380665879e-02,
        0.8230422520462021e+00,
        0.1134838113807109e-02,
        0.8265178671142719e+00,
        0.1137044206868379e-02,
        0.8299156644956935e+00,
        0.1139209679276770e-02,
        0.8332507296316362e+00,
        0.1141344665414018e-02,
        0.8365383636069283e+00,
        0.1143459484459602e-02,
        0.8397941917404019e+00,
        0.1145564700346352e-02,
        0.8430342589770379e+00,
        0.1147671169888255e-02,
        0.8462751092344150e+00,
        0.1149790076517388e-02,
        0.8495338449183082e+00,
        0.1151932946415512e-02,
        0.8528281618190179e+00,
        0.1154111643169411e-02,
        0.8561763535592529e+00,
        0.1156338336456831e-02,
        0.8595972787361906e+00,
        0.1158625439740416e-02,
        0.8631102829627566e+00,
        0.1160985511591647e-02,
        0.8667350672783336e+00,
        0.1163431115191409e-02,
        0.8704914940179440e+00,
        0.1165974630888303e-02,
        0.8743993213928760e+00,
        0.1168628017588916e-02,
        0.8784778589727296e+00,
        0.1171402520361833e-02,
        0.8827455382208639e+00,
        0.1174308324102304e-02,
        0.8872193954732928e+00,
        0.2967633115387107e-03,
        0.4078420646640203e-03,
        0.2542735980046100e-01,
        0.4929083178239419e-03,
        0.9876039342539503e-01,
        0.5593126751285800e-03,
        0.1742930216852869e+00,
        0.6122943067439731e-03,
        0.2427975603509948e+00,
        0.6554223612098552e-03,
        0.3028908101007459e+00,
        0.6911487848386306e-03,
        0.3551828911240184e+00,
        0.7211934487136871e-03,
        0.4007227692617545e+00,
        0.7467906965300383e-03,
        0.4405485438561624e+00,
        0.7688460941907184e-03,
        0.4755668043199200e+00,
        0.7880375248105768e-03,
        0.5065357215285611e+00,
        0.8048817439819273e-03,
        0.5340795437694515e+00,
        0.8197791606092136e-03,
        0.5587102435529917e+00,
        0.8330446107364092e-03,
        0.5808483484024387e+00,
        0.8449289291109885e-03,
        0.6008407117558368e+00,
        0.8556343498905160e-03,
        0.6189749738875788e+00,
        0.8653256884173914e-03,
        0.6354910969728228e+00,
        0.8741385860890042e-03,
        0.6505904974988862e+00,
        0.8821856763681789e-03,
        0.6644432678330569e+00,
        0.8895612564439208e-03,
        0.6771938992957999e+00,
        0.8963448693257790e-03,
        0.6889658361211737e+00,
        0.9026040810144197e-03,
        0.6998651175897177e+00,
        0.9083966557751288e-03,
        0.7099833073204581e+00,
        0.9137722762541778e-03,
        0.7193998631153847e+00,
        0.9187739158093501e-03,
        0.7281840656590849e+00,
        0.9234389425261854e-03,
        0.7363965975579181e+00,
        0.9278000143753827e-03,
        0.7440908437477774e+00,
        0.9318858104408874e-03,
        0.7513139686822109e+00,
        0.9357216324926973e-03,
        0.7581078137561323e+00,
        0.9393299032829178e-03,
        0.7645096492310164e+00,
        0.9427305820375386e-03,
        0.7705528078328676e+00,
        0.9459415131589371e-03,
        0.7762672216898303e+00,
        0.9489787207614479e-03,
        0.7816798799835950e+00,
        0.9518566590593747e-03,
        0.7868152213232364e+00,
        0.9545884266143449e-03,
        0.7916954721972490e+00,
        0.9571859508813780e-03,
        0.7963409407568194e+00,
        0.9596601482630737e-03,
        0.8007702735070883e+00,
        0.9620210639090244e-03,
        0.8050006811385999e+00,
        0.9642779947228965e-03,
        0.8090481386453148e+00,
        0.9664395984170945e-03,
        0.8129275639917815e+00,
        0.9685139909496511e-03,
        0.8166529788658923e+00,
        0.9705088342629528e-03,
        0.8202376544499068e+00,
        0.9724314158979084e-03,
        0.8236942446328719e+00,
        0.9742887217632853e-03,
        0.8270349086491756e+00,
        0.9760875030844708e-03,
        0.8302714247416513e+00,
        0.9778343383275471e-03,
        0.8334152960971942e+00,
        0.9795356906837479e-03,
        0.8364778499742661e+00,
        0.9811979614979323e-03,
        0.8394703306225847e+00,
        0.9828275398255846e-03,
        0.8424039862746810e+00,
        0.9844308480999043e-03,
        0.8452901501569875e+00,
        0.9860143836786285e-03,
        0.8481403151159906e+00,
        0.9875847558152446e-03,
        0.8509662010755018e+00,
        0.9891487173585097e-03,
        0.8537798141289355e+00,
        0.9907131902268242e-03,
        0.8565934956229708e+00,
        0.9922852834316175e-03,
        0.8594199591072303e+00,
        0.9938723021413952e-03,
        0.8622723125149068e+00,
        0.9954817459946895e-03,
        0.8651640624148244e+00,
        0.9971212946004986e-03,
        0.8681090966584658e+00,
        0.9987987779301984e-03,
        0.8711216412695179e+00,
        0.1000522129134342e-02,
        0.8742161870354788e+00,
        0.1002299317248640e-02,
        0.8774073810231204e+00,
        0.1004138257331534e-02,
        0.8807098782305657e+00,
        0.1006046695854091e-02,
        0.8841381489021722e+00,
        0.1008032069698879e-02,
        0.8877062377737649e+00,
        0.1010101337974326e-02,
        0.8914274727949142e+00,
        0.1012260787062656e-02,
        0.8953141227940432e+00,
        0.2505764977838404e-03,
        0.3443770249124342e-03,
        0.2543158995016821e-01,
        0.4162174537078318e-03,
        0.9878227034153308e-01,
        0.4723030362070807e-03,
        0.1743411977575627e+00,
        0.5170566942884504e-03,
        0.2428779209209343e+00,
        0.5534915375556028e-03,
        0.3030074710503266e+00,
        0.5836775268839070e-03,
        0.3553387763770640e+00,
        0.6090665945021940e-03,
        0.4009199654813231e+00,
        0.6307007808156645e-03,
        0.4407885275977928e+00,
        0.6493445644344517e-03,
        0.4758505926393938e+00,
        0.6655702083843857e-03,
        0.5068639748553351e+00,
        0.6798139474548506e-03,
        0.5344526379872747e+00,
        0.6924137931820147e-03,
        0.5591283215877272e+00,
        0.7036355137975163e-03,
        0.5813113577588189e+00,
        0.7136908453729490e-03,
        0.6013484321270596e+00,
        0.7227504933228287e-03,
        0.6195270375256310e+00,
        0.7309535721159746e-03,
        0.6360870035914407e+00,
        0.7384145655048229e-03,
        0.6512296248800408e+00,
        0.7452285316469442e-03,
        0.6651248789020748e+00,
        0.7514750465678792e-03,
        0.6779171461479578e+00,
        0.7572212276838003e-03,
        0.6897297612797826e+00,
        0.7625240776755495e-03,
        0.7006686526246470e+00,
        0.7674323201021287e-03,
        0.7108252688389807e+00,
        0.7719878506216157e-03,
        0.7202789460425201e+00,
        0.7762268944500497e-03,
        0.7290988336445309e+00,
        0.7801809371337034e-03,
        0.7373454702759427e+00,
        0.7838774788105678e-03,
        0.7450720807914899e+00,
        0.7873406498722635e-03,
        0.7523256496919639e+00,
        0.7905917169405165e-03,
        0.7591478143617146e+00,
        0.7936495014053848e-03,
        0.7655756123276436e+00,
        0.7965307277851307e-03,
        0.7716421096510724e+00,
        0.7992503154034614e-03,
        0.7773769320588682e+00,
        0.8018216240149106e-03,
        0.7828067161269425e+00,
        0.8042566618112444e-03,
        0.7879554944635353e+00,
        0.8065662625429530e-03,
        0.7928450261873953e+00,
        0.8087602371674192e-03,
        0.7974950818949961e+00,
        0.8108475043988473e-03,
        0.8019236906381128e+00,
        0.8128362037173276e-03,
        0.8061473550943380e+00,
        0.8147337937451987e-03,
        0.8101812400362133e+00,
        0.8165471383802039e-03,
        0.8140393383338362e+00,
        0.8182825826579203e-03,
        0.8177346180177749e+00,
        0.8199460199784433e-03,
        0.8212791533500792e+00,
        0.8215429520572276e-03,
        0.8246842423744935e+00,
        0.8230785427339746e-03,
        0.8279605130215852e+00,
        0.8245576665860399e-03,
        0.8311180195135344e+00,
        0.8259849531356726e-03,
        0.8341663305331678e+00,
        0.8273648273067869e-03,
        0.8371146103813345e+00,
        0.8287015466714560e-03,
        0.8399716941366764e+00,
        0.8299992359243829e-03,
        0.8427461576444749e+00,
        0.8312619189314546e-03,
        0.8454463829899002e+00,
        0.8324935486128937e-03,
        0.8480806199498299e+00,
        0.8336980348396690e-03,
        0.8506570437613245e+00,
        0.8348792704412902e-03,
        0.8531838093892227e+00,
        0.8360411553417403e-03,
        0.8556691023160556e+00,
        0.8371876187562825e-03,
        0.8581211857109087e+00,
        0.8383226392937222e-03,
        0.8605484436569011e+00,
        0.8394502627153142e-03,
        0.8629594199271572e+00,
        0.8405746170023279e-03,
        0.8653628515950123e+00,
        0.8416999242793960e-03,
        0.8677676965453935e+00,
        0.8428305090311761e-03,
        0.8701831537222023e+00,
        0.8439708019376514e-03,
        0.8726186747045624e+00,
        0.8451253385421383e-03,
        0.8750839649592925e+00,
        0.8462987518610647e-03,
        0.8775889728776909e+00,
        0.8474957579532225e-03,
        0.8801438644857288e+00,
        0.8487211333982720e-03,
        0.8827589815370717e+00,
        0.8499796836021254e-03,
        0.8854447805825755e+00,
        0.8512762008654021e-03,
        0.8882117505884698e+00,
        0.8526154112376473e-03,
        0.8910703067843766e+00,
        0.8540019093532560e-03,
        0.8940306587022231e+00,
        0.8554400807241641e-03,
        0.8971026508610441e+00,
        0.8569340113668948e-03,
        0.9002955753026496e+00,
        0.8584873851806726e-03,
        0.9036179562250074e+00,
        0.2143902298924797e-03,
        0.2946512237154931e-03,
        0.2543490463324859e-01,
        0.3561260688438285e-03,
        0.9879941719514369e-01,
        0.4041230092741482e-03,
        0.1743789695511629e+00,
        0.4424256774627034e-03,
        0.2429409502831179e+00,
        0.4736116853150793e-03,
        0.3030990118950347e+00,
        0.4994518169910726e-03,
        0.3554611561972349e+00,
        0.5211881524129952e-03,
        0.4010748630839990e+00,
        0.5397121201514141e-03,
        0.4409771509224894e+00,
        0.5556777014490634e-03,
        0.4760737966263269e+00,
        0.5695744414699151e-03,
        0.5071223419498457e+00,
        0.5817755161210044e-03,
        0.5347465345706520e+00,
        0.5925700732976313e-03,
        0.5594579384248554e+00,
        0.6021854581155787e-03,
        0.5816767395342153e+00,
        0.6108027921070821e-03,
        0.6017494993293330e+00,
        0.6185680956696988e-03,
        0.6199636028202163e+00,
        0.6256003634582641e-03,
        0.6365587841093024e+00,
        0.6319975186065948e-03,
        0.6517362513852718e+00,
        0.6378408654613904e-03,
        0.6656659024902249e+00,
        0.6431984629598351e-03,
        0.6784920429133774e+00,
        0.6481277109801403e-03,
        0.6903379352397969e+00,
        0.6526773552254315e-03,
        0.7013094370793644e+00,
        0.6568890572555564e-03,
        0.7114979262641195e+00,
        0.6607986356285067e-03,
        0.7209826665497649e+00,
        0.6644370556787454e-03,
        0.7298327319935689e+00,
        0.6678312253083076e-03,
        0.7381085813804109e+00,
        0.6710046397087699e-03,
        0.7458633536247841e+00,
        0.6739779074395309e-03,
        0.7531439394662658e+00,
        0.6767691825904827e-03,
        0.7599918728233108e+00,
        0.6793945220531763e-03,
        0.7664440759826728e+00,
        0.6818681826575195e-03,
        0.7725334857075471e+00,
        0.6842028697103579e-03,
        0.7782895818427216e+00,
        0.6864099460208997e-03,
        0.7837388357016260e+00,
        0.6884996086172708e-03,
        0.7889050921541919e+00,
        0.6904810389048264e-03,
        0.7938098966818099e+00,
        0.6923625308852660e-03,
        0.7984727765644702e+00,
        0.6941516011688034e-03,
        0.8029114836923505e+00,
        0.6958550838122305e-03,
        0.8071422051557240e+00,
        0.6974792124607250e-03,
        0.8111797466910577e+00,
        0.6990296918282764e-03,
        0.8150376931919887e+00,
        0.7005117601960532e-03,
        0.8187285497884573e+00,
        0.7019302443210675e-03,
        0.8222638664221132e+00,
        0.7032896079146326e-03,
        0.8256543483749294e+00,
        0.7045939946601219e-03,
        0.8289099548200989e+00,
        0.7058472665836456e-03,
        0.8320399871433695e+00,
        0.7070530384625938e-03,
        0.8350531685159762e+00,
        0.7082147088500877e-03,
        0.8379577159767848e+00,
        0.7093354882038982e-03,
        0.8407614060927453e+00,
        0.7104184245328271e-03,
        0.8434716351063775e+00,
        0.7114664269090819e-03,
        0.8460954743411380e+00,
        0.7124822871394600e-03,
        0.8486397215154378e+00,
        0.7134686998392874e-03,
        0.8511109485098599e+00,
        0.7144282811093860e-03,
        0.8535155460363737e+00,
        0.7153635859765056e-03,
        0.8558597655701624e+00,
        0.7162771247204472e-03,
        0.8581497588214944e+00,
        0.7171713781754927e-03,
        0.8603916149446070e+00,
        0.7180488120588147e-03,
        0.8625913956007934e+00,
        0.7189118903434776e-03,
        0.8647551679119477e+00,
        0.7197630876577540e-03,
        0.8668890352571068e+00,
        0.7206049006551845e-03,
        0.8689991657766132e+00,
        0.7214398582606628e-03,
        0.8710918183552704e+00,
        0.7222705306565306e-03,
        0.8731733657564531e+00,
        0.7230995368291464e-03,
        0.8752503144732032e+00,
        0.7239295504508160e-03,
        0.8773293207500719e+00,
        0.7247633038248635e-03,
        0.8794172021118196e+00,
        0.7256035895739055e-03,
        0.8815209436139331e+00,
        0.7264532597045066e-03,
        0.8836476979083573e+00,
        0.7273152216374242e-03,
        0.8858047781004107e+00,
        0.7281924307543494e-03,
        0.8879996422658111e+00,
        0.7290878789830281e-03,
        0.8902398684083558e+00,
        0.7300045789273423e-03,
        0.8925331185794968e+00,
        0.7309455430526645e-03,
        0.8948870908635684e+00,
        0.7319137574656844e-03,
        0.8973094579716888e+00,
        0.7329121498886438e-03,
        0.8998077913001904e+00,
        0.7339435515274697e-03,
        0.9023894695138696e+00,
        0.7350106526783481e-03,
        0.9050615710285062e+00,
        0.7361159521134971e-03,
        0.9078307502075817e+00,
        0.7372617005379830e-03,
        0.9107030976677650e+00,
        0.1812712131805553e-03,
        0.2491384321187703e-03,
        0.2543793868003920e-01,
        0.3011236389389571e-03,
        0.9881511572468257e-01,
        0.3417143692905089e-03,
        0.1744135601545568e+00,
        0.3741093236630491e-03,
        0.2429986895349530e+00,
        0.4004876411801612e-03,
        0.3031829004247381e+00,
        0.4223463640195241e-03,
        0.3555733525259414e+00,
        0.4407355613198239e-03,
        0.4012169377011952e+00,
        0.4564088559640470e-03,
        0.4411502489205138e+00,
        0.4699191284978094e-03,
        0.4762787454763390e+00,
        0.4816802419109510e-03,
        0.5073597250977332e+00,
        0.4920076781544193e-03,
        0.5350167430251173e+00,
        0.5011458800384139e-03,
        0.5597612077529058e+00,
        0.5092870408844213e-03,
        0.5820131769183957e+00,
        0.5165842754910700e-03,
        0.6021191036853046e+00,
        0.5231610232704372e-03,
        0.6203662799505060e+00,
        0.5291178753295886e-03,
        0.6369943582199482e+00,
        0.5345376082578074e-03,
        0.6522044738696901e+00,
        0.5394889485099423e-03,
        0.6661664586032026e+00,
        0.5440294242631437e-03,
        0.6790245567662842e+00,
        0.5482075518868509e-03,
        0.6909019734144254e+00,
        0.5520645308096385e-03,
        0.7019045110624699e+00,
        0.5556355707323485e-03,
        0.7121234938350971e+00,
        0.5589509407679369e-03,
        0.7216381322017054e+00,
        0.5620368060492128e-03,
        0.7305174464276960e+00,
        0.5649159003089793e-03,
        0.7388218400819079e+00,
        0.5676080707139590e-03,
        0.7466043945017325e+00,
        0.5701307223629278e-03,
        0.7539119395110627e+00,
        0.5724991833517420e-03,
        0.7607859437362659e+00,
        0.5747270064854298e-03,
        0.7672632586796091e+00,
        0.5768262201098143e-03,
        0.7733767436165075e+00,
        0.5788075378120540e-03,
        0.7791557928788411e+00,
        0.5806805346667902e-03,
        0.7846267827935451e+00,
        0.5824537961143980e-03,
        0.7898134521798050e+00,
        0.5841350443286614e-03,
        0.7947372276555162e+00,
        0.5857312459743304e-03,
        0.7994175029023208e+00,
        0.5872487045051270e-03,
        0.8038718793655162e+00,
        0.5886931395613308e-03,
        0.8081163745265718e+00,
        0.5900697555567861e-03,
        0.8121656028098705e+00,
        0.5913833011706530e-03,
        0.8160329333161330e+00,
        0.5926381211586964e-03,
        0.8197306278697833e+00,
        0.5938382016564763e-03,
        0.8232699622928324e+00,
        0.5949872099502598e-03,
        0.8266613333475188e+00,
        0.5960885295313444e-03,
        0.8299143534033866e+00,
        0.5971452911184121e-03,
        0.8330379345654622e+00,
        0.5981604002247400e-03,
        0.8360403637358284e+00,
        0.5991365617580406e-03,
        0.8389293698608987e+00,
        0.6000763020667812e-03,
        0.8417121844328502e+00,
        0.6009819887851800e-03,
        0.8443955961593316e+00,
        0.6018558487773787e-03,
        0.8469860005853584e+00,
        0.6026999844377125e-03,
        0.8494894453408740e+00,
        0.6035163885670166e-03,
        0.8519116715931933e+00,
        0.6043069580133006e-03,
        0.8542581522025076e+00,
        0.6050735062378763e-03,
        0.8565341270083502e+00,
        0.6058177749442889e-03,
        0.8587446356133339e+00,
        0.6065414448864817e-03,
        0.8608945479758220e+00,
        0.6072461459539104e-03,
        0.8629885930739860e+00,
        0.6079334666143073e-03,
        0.8650313858586231e+00,
        0.6086049627790323e-03,
        0.8670274526700236e+00,
        0.6092621661410419e-03,
        0.8689812552540616e+00,
        0.6099065920211252e-03,
        0.8708972134736309e+00,
        0.6105397467438793e-03,
        0.8727797267727406e+00,
        0.6111631345506714e-03,
        0.8746331944112725e+00,
        0.6117782640423093e-03,
        0.8764620344479443e+00,
        0.6123866541291380e-03,
        0.8782707014068333e+00,
        0.6129898394506246e-03,
        0.8800637025184370e+00,
        0.6135893752100950e-03,
        0.8818456123793366e+00,
        0.6141868413530916e-03,
        0.8836210858249036e+00,
        0.6147838459998774e-03,
        0.8853948687571734e+00,
        0.6153820280240385e-03,
        0.8871718066152805e+00,
        0.6159830586501987e-03,
        0.8889568501193103e+00,
        0.6165886419249452e-03,
        0.8907550578610847e+00,
        0.6172005138967517e-03,
        0.8925715952587398e+00,
        0.6178204403237505e-03,
        0.8944117293380552e+00,
        0.6184502127136527e-03,
        0.8962808187550784e+00,
        0.6190916424892084e-03,
        0.8981842984351409e+00,
        0.6197465530668733e-03,
        0.9001276581771762e+00,
        0.6204167696375895e-03,
        0.9021164145644403e+00,
        0.6211041064488501e-03,
        0.9041560755392406e+00,
        0.6218103514087190e-03,
        0.9062520970467020e+00,
        0.6225372478675618e-03,
        0.9084098312380427e+00,
        0.6232864734841831e-03,
        0.9106344658545083e+00,
        0.6240596161519326e-03,
        0.9129309545958600e+00,
        0.6248581470486960e-03,
        0.9153039385179171e+00,
        0.6256833909833134e-03,
        0.9177576588059725e+00,
        0.1520214237712800e-03,
        0.2089413039628107e-03,
        0.2544061844919076e-01,
        0.2525434029450244e-03,
        0.9882898388671699e-01,
        0.2865906408583821e-03,
        0.1744441250170073e+00,
        0.3137652564915279e-03,
        0.2430497235076716e+00,
        0.3358945562695622e-03,
        0.3032570714471141e+00,
        0.3542338804453592e-03,
        0.3556725894600452e+00,
        0.3696637616173895e-03,
        0.4013426546343276e+00,
        0.3828161474542172e-03,
        0.4413034887132714e+00,
        0.3941546527609132e-03,
        0.4764602748670496e+00,
        0.4040263187063507e-03,
        0.5075700996286871e+00,
        0.4126956886076392e-03,
        0.5352563525449359e+00,
        0.4203677355440847e-03,
        0.5600303090493647e+00,
        0.4272036184847955e-03,
        0.5823119175989039e+00,
        0.4333317268557089e-03,
        0.6024475399611718e+00,
        0.4388555655790971e-03,
        0.6207243900791431e+00,
        0.4438594799484181e-03,
        0.6373820527872740e+00,
        0.4484128767232627e-03,
        0.6526216037234880e+00,
        0.4525733807537433e-03,
        0.6666128210012832e+00,
        0.4563892263945745e-03,
        0.6794999001357331e+00,
        0.4599010909485004e-03,
        0.6914060010021446e+00,
        0.4631435158655601e-03,
        0.7024368836752101e+00,
        0.4661460196359733e-03,
        0.7126838318080794e+00,
        0.4689339774940904e-03,
        0.7222260166914516e+00,
        0.4715293228925426e-03,
        0.7311324200920038e+00,
        0.4739511114194688e-03,
        0.7394634071847610e+00,
        0.4762159775818406e-03,
        0.7472720204610868e+00,
        0.4783385074390325e-03,
        0.7546050498913561e+00,
        0.4803315446135938e-03,
        0.7615039226740586e+00,
        0.4822064431621426e-03,
        0.7680054467191980e+00,
        0.4839732777639475e-03,
        0.7741424349221077e+00,
        0.4856410194012131e-03,
        0.7799442317805824e+00,
        0.4872176829669196e-03,
        0.7854371596157800e+00,
        0.4887104519025023e-03,
        0.7906448982918555e+00,
        0.4901257839368306e-03,
        0.7955888096768238e+00,
        0.4914695011954675e-03,
        0.8002882159858926e+00,
        0.4927468673202736e-03,
        0.8047606394754871e+00,
        0.4939626537433801e-03,
        0.8090220096175752e+00,
        0.4951211968659503e-03,
        0.8130868428076891e+00,
        0.4962264475780244e-03,
        0.8169683987907728e+00,
        0.4972820143036731e-03,
        0.8206788172836932e+00,
        0.4982912005523597e-03,
        0.8242292376985011e+00,
        0.4992570377925784e-03,
        0.8276299044001774e+00,
        0.5001823143295755e-03,
        0.8308902595461131e+00,
        0.5010696007591026e-03,
        0.8340190252357240e+00,
        0.5019212724788590e-03,
        0.8370242764345617e+00,
        0.5027395296647642e-03,
        0.8399135059177911e+00,
        0.5035264150574445e-03,
        0.8426936822947919e+00,
        0.5042838298529326e-03,
        0.8453713020233193e+00,
        0.5050135479486603e-03,
        0.8479524361928227e+00,
        0.5057172287598274e-03,
        0.8504427727478738e+00,
        0.5063964287909282e-03,
        0.8528476547306911e+00,
        0.5070526121216016e-03,
        0.8551721150436168e+00,
        0.5076871599442239e-03,
        0.8574209081657413e+00,
        0.5083013792721207e-03,
        0.8595985392007632e+00,
        0.5088965109213798e-03,
        0.8617092905839876e+00,
        0.5094737368555486e-03,
        0.8637572467337869e+00,
        0.5100341869706155e-03,
        0.8657463168957334e+00,
        0.5105789453872895e-03,
        0.8676802563950228e+00,
        0.5111090563084296e-03,
        0.8695626864839279e+00,
        0.5116255294913210e-03,
        0.8713971129451628e+00,
        0.5121293453771310e-03,
        0.8731869435885925e+00,
        0.5126214599131585e-03,
        0.8749355047571672e+00,
        0.5131028090972410e-03,
        0.8766460569378331e+00,
        0.5135743132677963e-03,
        0.8783218095540483e+00,
        0.5140368811573158e-03,
        0.8799659349980495e+00,
        0.5144914137215976e-03,
        0.8815815819428285e+00,
        0.5149388077515203e-03,
        0.8831718879555870e+00,
        0.5153799592686180e-03,
        0.8847399914159621e+00,
        0.5158157667000665e-03,
        0.8862890427233201e+00,
        0.5162471338228604e-03,
        0.8878222147576811e+00,
        0.5166749724609052e-03,
        0.8893427125382002e+00,
        0.5171002049124420e-03,
        0.8908537820014690e+00,
        0.5175237660786470e-03,
        0.8923587177991490e+00,
        0.5179466052574159e-03,
        0.8938608699906167e+00,
        0.5183696875592966e-03,
        0.8953636494814934e+00,
        0.5187939948953462e-03,
        0.8968705320333607e+00,
        0.5192205264794681e-03,
        0.8983850606439769e+00,
        0.5196502987807066e-03,
        0.8999108460714149e+00,
        0.5200843448542496e-03,
        0.9014515652504507e+00,
        0.5205237129738048e-03,
        0.9030109573261521e+00,
        0.5209694644829235e-03,
        0.9045928170091283e+00,
        0.5214226707791797e-03,
        0.9062009849407291e+00,
        0.5218844093433793e-03,
        0.9078393347463627e+00,
        0.5223557587267653e-03,
        0.9095117564530361e+00,
        0.5228377924131475e-03,
        0.9112221359554993e+00,
        0.5233315714807396e-03,
        0.9129743302365174e+00,
        0.5238381360009637e-03,
        0.9147721380834732e+00,
        0.5243584951293212e-03,
        0.9166192660984713e+00,
        0.5248936158673047e-03,
        0.9185192898749830e+00,
        0.5254444105047963e-03,
        0.9204756103131890e+00,
        0.5260117227898333e-03,
        0.9224914051702910e+00,
        0.5265963129170898e-03,
        0.9245695760920818e+00,
        0.1268446182127322e-03,
        0.1743404286829759e-03,
        0.2544292517172434e-01,
        0.2107251564740404e-03,
        0.9884092351738187e-01,
        0.2391381657362996e-03,
        0.1744704449940017e+00,
        0.2618172499590152e-03,
        0.2430936807628649e+00,
        0.2802869400172751e-03,
        0.3033209758285258e+00,
        0.2955945748575447e-03,
        0.3557581181745550e+00,
        0.3084747892467032e-03,
        0.4014510452519073e+00,
        0.3194548214120799e-03,
        0.4414356626653468e+00,
        0.3289214677172303e-03,
        0.4766169192502833e+00,
        0.3371642657758759e-03,
        0.5077517230370061e+00,
        0.3444039242024864e-03,
        0.5354633241883532e+00,
        0.3508114513703712e-03,
        0.5602628868037311e+00,
        0.3565213009364801e-03,
        0.5825702685336475e+00,
        0.3616405864628345e-03,
        0.6027317556351184e+00,
        0.3662556600075083e-03,
        0.6210344981187767e+00,
        0.3704368884625953e-03,
        0.6377180257702407e+00,
        0.3742421752675708e-03,
        0.6529833660710770e+00,
        0.3777195940186037e-03,
        0.6670002543718940e+00,
        0.3809093836500495e-03,
        0.6799128476679434e+00,
        0.3838454780905802e-03,
        0.6918442706570039e+00,
        0.3865566919752524e-03,
        0.7029002508578049e+00,
        0.3890676491299710e-03,
        0.7131720413986303e+00,
        0.3913995164996082e-03,
        0.7227387845799725e+00,
        0.3935705893726759e-03,
        0.7316694342837096e+00,
        0.3955967618362022e-03,
        0.7400243285231667e+00,
        0.3974919078428414e-03,
        0.7478564830001711e+00,
        0.3992681920658595e-03,
        0.7552126609359470e+00,
        0.4009363251645967e-03,
        0.7621342624977909e+00,
        0.4025057747089784e-03,
        0.7686580679613385e+00,
        0.4039849404875170e-03,
        0.7748168616577529e+00,
        0.4053813010180153e-03,
        0.7806399582528606e+00,
        0.4067015366299700e-03,
        0.7861536486134770e+00,
        0.4079516333750262e-03,
        0.7913815791511374e+00,
        0.4091369711617666e-03,
        0.7963450758813084e+00,
        0.4102623988415600e-03,
        0.8010634223351132e+00,
        0.4113322984474455e-03,
        0.8055540987877207e+00,
        0.4123506403741368e-03,
        0.8098329889290022e+00,
        0.4133210309588080e-03,
        0.8139145590258739e+00,
        0.4142467536602034e-03,
        0.8178120137564664e+00,
        0.4151308048232806e-03,
        0.8215374321909360e+00,
        0.4159759248469224e-03,
        0.8251018868189340e+00,
        0.4167846254347061e-03,
        0.8285155480533462e+00,
        0.4175592134966781e-03,
        0.8317877762533697e+00,
        0.4183018121784048e-03,
        0.8349272029911109e+00,
        0.4190143794182329e-03,
        0.8379418030218164e+00,
        0.4196987243715124e-03,
        0.8408389581983645e+00,
        0.4203565219890266e-03,
        0.8436255143875690e+00,
        0.4209893259940189e-03,
        0.8463078322926154e+00,
        0.4215985804664407e-03,
        0.8488918329572650e+00,
        0.4221856302130706e-03,
        0.8513830386190436e+00,
        0.4227517300769591e-03,
        0.8537866094869954e+00,
        0.4232980533183947e-03,
        0.8561073769418921e+00,
        0.4238256991815968e-03,
        0.8583498735907137e+00,
        0.4243356997460570e-03,
        0.8605183605508547e+00,
        0.4248290261484384e-03,
        0.8626168522912827e+00,
        0.4253065942498067e-03,
        0.8646491393164755e+00,
        0.4257692698134273e-03,
        0.8666188089433132e+00,
        0.4262178732501410e-03,
        0.8685292643902939e+00,
        0.4266531839812305e-03,
        0.8703837423717154e+00,
        0.4270759444625287e-03,
        0.8721853293661955e+00,
        0.4274868639081453e-03,
        0.8739369767085355e+00,
        0.4278866217474832e-03,
        0.8756415146360238e+00,
        0.4282758708450621e-03,
        0.8773016654044247e+00,
        0.4286552405089854e-03,
        0.8789200555747797e+00,
        0.4290253393105878e-03,
        0.8804992275594572e+00,
        0.4293867577348235e-03,
        0.8820416505043871e+00,
        0.4297400706782409e-03,
        0.8835497305738722e+00,
        0.4300858398088763e-03,
        0.8850258206945885e+00,
        0.4304246158000579e-03,
        0.8864722298061936e+00,
        0.4307569404478835e-03,
        0.8878912316572020e+00,
        0.4310833486799939e-03,
        0.8892850731763069e+00,
        0.4314043704611773e-03,
        0.8906559824410115e+00,
        0.4317205325992682e-03,
        0.8920061762571498e+00,
        0.4320323604527339e-03,
        0.8933378673545269e+00,
        0.4323403795392380e-03,
        0.8946532711953979e+00,
        0.4326451170423202e-03,
        0.8959546123837375e+00,
        0.4329471032111149e-03,
        0.8972441306541727e+00,
        0.4332468726457380e-03,
        0.8985240864099954e+00,
        0.4335449654585917e-03,
        0.8997967657697997e+00,
        0.4338419282993692e-03,
        0.9010644850719940e+00,
        0.4341383152289965e-03,
        0.9023295947757297e+00,
        0.4344346884251275e-03,
        0.9035944826856999e+00,
        0.4347316186991527e-03,
        0.9048615764168997e+00,
        0.4350296858020064e-03,
        0.9061333450039083e+00,
        0.4353294784934289e-03,
        0.9074122995477561e+00,
        0.4356315943468108e-03,
        0.9087009927822184e+00,
        0.4359366392594052e-03,
        0.9100020174307473e+00,
        0.4362452266356344e-03,
        0.9113180032156295e+00,
        0.4365579762095740e-03,
        0.9126516123728104e+00,
        0.4368755124715989e-03,
        0.9140055335197583e+00,
        0.4371984626638003e-03,
        0.9153824737204230e+00,
        0.4375274543093129e-03,
        0.9167851485915539e+00,
        0.4378631122423307e-03,
        0.9182162702992493e+00,
        0.4382060551085620e-03,
        0.9196785333045526e+00,
        0.4385568913104083e-03,
        0.9211745977331760e+00,
        0.4389162143774648e-03,
        0.9227070702680383e+00,
        0.4392845977512571e-03,
        0.9242784824952105e+00,
        0.4396625889836182e-03,
        0.9258912666749617e+00,
        0.4400507033609156e-03,
        0.9275477289606028e+00,
        0.4404494169815118e-03,
        0.9292500201491721e+00,
        0.4408591593313590e-03,
        0.9310001041198086e+00,
        0.1055644989267907e-03,
        0.1450940149574984e-03,
        0.2544487491553157e-01,
        0.1753772719352769e-03,
        0.9885101688865597e-01,
        0.1990267012200822e-03,
        0.1744926990200333e+00,
        0.2179045108524649e-03,
        0.2431308553318966e+00,
        0.2332793641731550e-03,
        0.3033750329426410e+00,
        0.2460228232089687e-03,
        0.3558304876736915e+00,
        0.2567462279756849e-03,
        0.4015427879008645e+00,
        0.2658883294937232e-03,
        0.4415475744961243e+00,
        0.2737710071803561e-03,
        0.4767496006654743e+00,
        0.2806352044648509e-03,
        0.5079056259634127e+00,
        0.2866645871705139e-03,
        0.5356387851068741e+00,
        0.2920014619138971e-03,
        0.5604601504270702e+00,
        0.2967577154420555e-03,
        0.5827895051312843e+00,
        0.3010224827883186e-03,
        0.6029730739429139e+00,
        0.3048676217987417e-03,
        0.6212979551152507e+00,
        0.3083516878734000e-03,
        0.6380036341864078e+00,
        0.3115228646427098e-03,
        0.6532911002313850e+00,
        0.3144211555866268e-03,
        0.6673300547852067e+00,
        0.3170800443702226e-03,
        0.6802646246666912e+00,
        0.3195277677802438e-03,
        0.6922179072993687e+00,
        0.3217883024392515e-03,
        0.7032956052494281e+00,
        0.3238821374603807e-03,
        0.7135889485487379e+00,
        0.3258268851960003e-03,
        0.7231770578766950e+00,
        0.3276377682377606e-03,
        0.7321288666512480e+00,
        0.3293280109066263e-03,
        0.7405046933069390e+00,
        0.3309091563550510e-03,
        0.7483575346135667e+00,
        0.3323913252386479e-03,
        0.7557341352926834e+00,
        0.3337834281257755e-03,
        0.7626758772463315e+00,
        0.3350933410056701e-03,
        0.7692195225318236e+00,
        0.3363280511552274e-03,
        0.7753978371270195e+00,
        0.3374937790390407e-03,
        0.7812401170290845e+00,
        0.3385960807104609e-03,
        0.7867726339385476e+00,
        0.3396399342555158e-03,
        0.7920190144159111e+00,
        0.3406298131057851e-03,
        0.7970005637462622e+00,
        0.3415697484891286e-03,
        0.8017365436465392e+00,
        0.3424633828504657e-03,
        0.8062444112774049e+00,
        0.3433140157303645e-03,
        0.8105400256832551e+00,
        0.3441246433158771e-03,
        0.8146378267077895e+00,
        0.3448979926599179e-03,
        0.8185509905633486e+00,
        0.3456365513904324e-03,
        0.8222915655269199e+00,
        0.3463425935893944e-03,
        0.8258705906609294e+00,
        0.3470182024071915e-03,
        0.8292981999865211e+00,
        0.3476652898847084e-03,
        0.8325837141504723e+00,
        0.3482856143791181e-03,
        0.8357357213079810e+00,
        0.3488807959266790e-03,
        0.8387621486794669e+00,
        0.3494523298240878e-03,
        0.8416703260200142e+00,
        0.3500015986670602e-03,
        0.8444670420569842e+00,
        0.3505298830491450e-03,
        0.8471585947980716e+00,
        0.3510383710940082e-03,
        0.8497508364833812e+00,
        0.3515281669694799e-03,
        0.8522492138466825e+00,
        0.3520002985106894e-03,
        0.8546588042593751e+00,
        0.3524557240619330e-03,
        0.8569843482530394e+00,
        0.3528953386319557e-03,
        0.8592302788504310e+00,
        0.3533199794446321e-03,
        0.8614007480784993e+00,
        0.3537304309562248e-03,
        0.8634996509889043e+00,
        0.3541274294011706e-03,
        0.8655306474702691e+00,
        0.3545116669204490e-03,
        0.8674971821009717e+00,
        0.3548837953198046e-03,
        0.8694025022607404e+00,
        0.3552444294992589e-03,
        0.8712496746929433e+00,
        0.3555941505903093e-03,
        0.8730416006866108e+00,
        0.3559335088328495e-03,
        0.8747810300273897e+00,
        0.3562630262200606e-03,
        0.8764705738493466e+00,
        0.3565831989362264e-03,
        0.8781127165044531e+00,
        0.3568944996095447e-03,
        0.8797098265533606e+00,
        0.3571973793994888e-03,
        0.8812641669694672e+00,
        0.3574922699360495e-03,
        0.8827779046380256e+00,
        0.3577795851262342e-03,
        0.8842531192229806e+00,
        0.3580597228414603e-03,
        0.8856918114661521e+00,
        0.3583330664979325e-03,
        0.8870959109761732e+00,
        0.3585999865407079e-03,
        0.8884672835581080e+00,
        0.3588608418408972e-03,
        0.8898077381288096e+00,
        0.3591159810143158e-03,
        0.8911190332577230e+00,
        0.3593657436688535e-03,
        0.8924028833679230e+00,
        0.3596104615868662e-03,
        0.8936609646275998e+00,
        0.3598504598479910e-03,
        0.8948949205579224e+00,
        0.3600860578969333e-03,
        0.8961063673791346e+00,
        0.3603175705599569e-03,
        0.8972968991128310e+00,
        0.3605453090130204e-03,
        0.8984680924545586e+00,
        0.3607695817037281e-03,
        0.8996215114271492e+00,
        0.3609906952284962e-03,
        0.9007587118214661e+00,
        0.3612089551655714e-03,
        0.9018812454275019e+00,
        0.3614246668637566e-03,
        0.9029906640549621e+00,
        0.3616381361859153e-03,
        0.9040885233385761e+00,
        0.3618496702055102e-03,
        0.9051763863193673e+00,
        0.3620595778536006e-03,
        0.9062558267889668e+00,
        0.3622681705128622e-03,
        0.9073284323797515e+00,
        0.3624757625543019e-03,
        0.9083958073791226e+00,
        0.3626826718114261e-03,
        0.9094595752416100e+00,
        0.3628892199856792e-03,
        0.9105213807677069e+00,
        0.3630957329760065e-03,
        0.9115828919134202e+00,
        0.3633025411244249e-03,
        0.9126458011895109e+00,
        0.3635099793685103e-03,
        0.9137118266043415e+00,
        0.3637183872907533e-03,
        0.9147827120992093e+00,
        0.3639281090538103e-03,
        0.9158602274201335e+00,
        0.3641394932098118e-03,
        0.9169461673653735e+00,
        0.3643528923711136e-03,
        0.9180423503436506e+00,
        0.3645686627292243e-03,
        0.9191506161742795e+00,
        0.3647871634081525e-03,
        0.9202728230574016e+00,
        0.3650087556381453e-03,
        0.9214108436404823e+00,
        0.3652338017357785e-03,
        0.9225665601064491e+00,
        0.3654626638766759e-03,
        0.9237418582096152e+00,
        0.3656957026478399e-03,
        0.9249386201881679e+00,
        0.3659332753677379e-03,
        0.9261587164868569e+00,
        0.3661757341639742e-03,
        0.9274039962309573e+00,
        0.3664234238006590e-03,
        0.9286762764029628e+00,
        0.3666766792505202e-03,
        0.9299773296871511e+00,
        0.3669358230104597e-03,
        0.9313088709644671e+00,
        0.3672011621636608e-03,
        0.9326725424613703e+00,
        0.3674729851965463e-03,
        0.9340698975815723e+00,
        0.3677515585848630e-03,
        0.9355023834790327e+00,
        0.3680371231699034e-03,
        0.9369713224641266e+00,
        0.8780076664716276e-04,
        0.1206797894237555e-03,
        0.2544650247967021e-01,
        0.1458689907141319e-03,
        0.9885944344034912e-01,
        0.1655410204684315e-03,
        0.1745112808102761e+00,
        0.1812446142239127e-03,
        0.2431619011038030e+00,
        0.1940348805295792e-03,
        0.3034201872483507e+00,
        0.2046366722127249e-03,
        0.3558909526523158e+00,
        0.2135584233839305e-03,
        0.4016194593852736e+00,
        0.2211650307991108e-03,
        0.4416411290854953e+00,
        0.2277241922738999e-03,
        0.4768605533838495e+00,
        0.2334362932843276e-03,
        0.5080343695969284e+00,
        0.2384540829843639e-03,
        0.5357856177524436e+00,
        0.2428959131113313e-03,
        0.5606252952358727e+00,
        0.2468548359474569e-03,
        0.5829731247513873e+00,
        0.2504049817295676e-03,
        0.6031752812789858e+00,
        0.2536061116756343e-03,
        0.6215188214764482e+00,
        0.2565069236788439e-03,
        0.6382431955471400e+00,
        0.2591474896792285e-03,
        0.6535493621049741e+00,
        0.2615610783797454e-03,
        0.6676069960615446e+00,
        0.2637755361065909e-03,
        0.6805602006643017e+00,
        0.2658143454788651e-03,
        0.6925320522129640e+00,
        0.2676974460335837e-03,
        0.7036282341255100e+00,
        0.2694418768222108e-03,
        0.7139399588872692e+00,
        0.2710622843532818e-03,
        0.7235463309319510e+00,
        0.2725713276157303e-03,
        0.7325162684867130e+00,
        0.2739800036682437e-03,
        0.7409100756455830e+00,
        0.2752979113613955e-03,
        0.7487807355146596e+00,
        0.2765334664638627e-03,
        0.7561749796785543e+00,
        0.2776940783128682e-03,
        0.7631341772964979e+00,
        0.2787862957738123e-03,
        0.7696950779572316e+00,
        0.2798159285470986e-03,
        0.7758904353334187e+00,
        0.2807881485415345e-03,
        0.7817495331755640e+00,
        0.2817075750299807e-03,
        0.7872986308948055e+00,
        0.2825783465328497e-03,
        0.7925613426197803e+00,
        0.2834041817797840e-03,
        0.7975589609612814e+00,
        0.2841884316364275e-03,
        0.8023107346178518e+00,
        0.2849341235200138e-03,
        0.8068341072829448e+00,
        0.2856439995410211e-03,
        0.8111449239759836e+00,
        0.2863205493808272e-03,
        0.8152576098436540e+00,
        0.2869660387338721e-03,
        0.8191853256086143e+00,
        0.2875825339972447e-03,
        0.8229401031375546e+00,
        0.2881719237731651e-03,
        0.8265329640257898e+00,
        0.2887359376546216e-03,
        0.8299740236251799e+00,
        0.2892761626868619e-03,
        0.8332725825556256e+00,
        0.2897940578339750e-03,
        0.8364372074214862e+00,
        0.2902909667276428e-03,
        0.8394758021901656e+00,
        0.2907681289320944e-03,
        0.8423956714705967e+00,
        0.2912266899236334e-03,
        0.8452035767462418e+00,
        0.2916677099534407e-03,
        0.8479057864639630e+00,
        0.2920921719375913e-03,
        0.8505081207514051e+00,
        0.2925009884974771e-03,
        0.8530159914271018e+00,
        0.2928950082563857e-03,
        0.8554344378758767e+00,
        0.2932750214832763e-03,
        0.8577681592844462e+00,
        0.2936417651623478e-03,
        0.8600215436661002e+00,
        0.2939959275564363e-03,
        0.8621986940470617e+00,
        0.2943381523232877e-03,
        0.8643034521390155e+00,
        0.2946690422360806e-03,
        0.8663394197810720e+00,
        0.2949891625530086e-03,
        0.8683099783990099e+00,
        0.2952990440750963e-03,
        0.8702183066991327e+00,
        0.2955991859265754e-03,
        0.8720673967877357e+00,
        0.2958900580879658e-03,
        0.8738600688843806e+00,
        0.2961721037083923e-03,
        0.8755989847774060e+00,
        0.2964457412205325e-03,
        0.8772866601529093e+00,
        0.2967113662788715e-03,
        0.8789254759134587e+00,
        0.2969693535395673e-03,
        0.8805176885897160e+00,
        0.2972200582981628e-03,
        0.8820654399367039e+00,
        0.2974638179995708e-03,
        0.8835707657964145e+00,
        0.2977009536331723e-03,
        0.8850356042996281e+00,
        0.2979317710244726e-03,
        0.8864618034720409e+00,
        0.2981565620335326e-03,
        0.8878511283029286e+00,
        0.2983756056693069e-03,
        0.8892052673284969e+00,
        0.2985891691280583e-03,
        0.8905258387766696e+00,
        0.2987975087631656e-03,
        0.8918143963152597e+00,
        0.2990008709928799e-03,
        0.8930724344411763e+00,
        0.2991994931519033e-03,
        0.8943013935444719e+00,
        0.2993936042920544e-03,
        0.8955026646775683e+00,
        0.2995834259367309e-03,
        0.8966775940568730e+00,
        0.2997691727933844e-03,
        0.8978274873211489e+00,
        0.2999510534277608e-03,
        0.8989536135684026e+00,
        0.3001292709032479e-03,
        0.9000572091906636e+00,
        0.3003040233882832e-03,
        0.9011394815238150e+00,
        0.3004755047344127e-03,
        0.9022016123275653e+00,
        0.3006439050272616e-03,
        0.9032447611087047e+00,
        0.3008094111123485e-03,
        0.9042700682989381e+00,
        0.3009722070973778e-03,
        0.9052786582968102e+00,
        0.3011324748323426e-03,
        0.9062716423815145e+00,
        0.3012903943684867e-03,
        0.9072501215046918e+00,
        0.3014461443968870e-03,
        0.9082151889646557e+00,
        0.3015999026671373e-03,
        0.9091679329658161e+00,
        0.3017518463863298e-03,
        0.9101094390643967e+00,
        0.3019021525982453e-03,
        0.9110407924998413e+00,
        0.3020509985423700e-03,
        0.9119630804095697e+00,
        0.3021985619920632e-03,
        0.9128773939229608e+00,
        0.3023450215708908e-03,
        0.9137848301286094e+00,
        0.3024905570458278e-03,
        0.9146864939070101e+00,
        0.3026353495957124e-03,
        0.9155834996188661e+00,
        0.3027795820529983e-03,
        0.9164769726372038e+00,
        0.3029234391165164e-03,
        0.9173680507093950e+00,
        0.3030671075326073e-03,
        0.9182578851330556e+00,
        0.3032107762416357e-03,
        0.9191476417276118e+00,
        0.3033546364865421e-03,
        0.9200385015811228e+00,
        0.3034988818797365e-03,
        0.9209316615497335e+00,
        0.3036437084242899e-03,
        0.9218283344849421e+00,
        0.3037893144850508e-03,
        0.9227297491617354e+00,
        0.3039359007049947e-03,
        0.9236371498786060e+00,
        0.3040836698618365e-03,
        0.9245517956985898e+00,
        0.3042328266596891e-03,
        0.9254749592987897e+00,
        0.3043835774503590e-03,
        0.9264079253944743e+00,
        0.3045361298787459e-03,
        0.9273519887028263e+00,
        0.3046906924467665e-03,
        0.9283084514108677e+00,
        0.3048474739902782e-03,
        0.9292786201121033e+00,
        0.3050066830636484e-03,
        0.9302638021771222e+00,
        0.3051685272269233e-03,
        0.9312653015248920e+00,
        0.3053332122310158e-03,
        0.9322844137639074e+00,
        0.3055009410969733e-03,
        0.9333224206758433e+00,
        0.3056719130862303e-03,
        0.9343805840190375e+00,
        0.3058463225598092e-03,
        0.9354601386351341e+00,
        0.3060243577257252e-03,
        0.9365622848496463e+00,
        0.3062061992753964e-03,
        0.9376881801661726e+00,
        0.3063920189116574e-03,
        0.9388389302645763e+00,
        0.3065819777730374e-03,
        0.9400155793256640e+00,
        0.3067762247612739e-03,
        0.9412190997187711e+00,
        0.3069748947815949e-03,
        0.9424503811041136e+00,
        0.7309194121921337e-04,
        0.1004637913909749e-03,
        0.2544785012683798e-01,
        0.1214344266344417e-03,
        0.9886642145889684e-01,
        0.1378124012607418e-03,
        0.1745266702959460e+00,
        0.1508869219533374e-03,
        0.2431876171096405e+00,
        0.1615362906618204e-03,
        0.3034575961449956e+00,
        0.1703638961634086e-03,
        0.3559410557392941e+00,
        0.1777929742443069e-03,
        0.4016830055695095e+00,
        0.1841272759437895e-03,
        0.4417186869611078e+00,
        0.1895896409160979e-03,
        0.4769525589580654e+00,
        0.1943468759030283e-03,
        0.5081411588464865e+00,
        0.1985261336437941e-03,
        0.5359074494195392e+00,
        0.2022259333499051e-03,
        0.5607623671619424e+00,
        0.2055237341359384e-03,
        0.5831255858225246e+00,
        0.2084812437801258e-03,
        0.6033432403229687e+00,
        0.2111482088116174e-03,
        0.6217023539986306e+00,
        0.2135651662786688e-03,
        0.6384423489057279e+00,
        0.2157654726972967e-03,
        0.6537641595402491e+00,
        0.2177768213406241e-03,
        0.6678374398703551e+00,
        0.2196223917129092e-03,
        0.6808062747278515e+00,
        0.2213217308213229e-03,
        0.6927937240286020e+00,
        0.2228914362913128e-03,
        0.7039054564531154e+00,
        0.2243456912849616e-03,
        0.7142326710923299e+00,
        0.2256966873287446e-03,
        0.7238544600868844e+00,
        0.2269549614676161e-03,
        0.7328397302769779e+00,
        0.2281296672953758e-03,
        0.7412487751160227e+00,
        0.2292287944844476e-03,
        0.7491345676832047e+00,
        0.2302593478625398e-03,
        0.7565438300381136e+00,
        0.2312274944605136e-03,
        0.7635179222210341e+00,
        0.2321386850119108e-03,
        0.7700935850242779e+00,
        0.2329977549303630e-03,
        0.7763035635723555e+00,
        0.2338090086934327e-03,
        0.7821771332486441e+00,
        0.2345762907259228e-03,
        0.7877405452160454e+00,
        0.2353030452346481e-03,
        0.7930174054153139e+00,
        0.2359923669511411e-03,
        0.7980289982735111e+00,
        0.2366470443530013e-03,
        0.8027945642546851e+00,
        0.2372695966322588e-03,
        0.8073315387125080e+00,
        0.2378623054406560e-03,
        0.8116557581664309e+00,
        0.2384272422525216e-03,
        0.8157816390470166e+00,
        0.2389662920348844e-03,
        0.8197223330870221e+00,
        0.2394811737932779e-03,
        0.8234898628296190e+00,
        0.2399734584639214e-03,
        0.8270952401504242e+00,
        0.2404445845437014e-03,
        0.8305485702196599e+00,
        0.2408958717848132e-03,
        0.8338591429442381e+00,
        0.2413285332280931e-03,
        0.8370355136106796e+00,
        0.2417436858056495e-03,
        0.8400855741856878e+00,
        0.2421423597075709e-03,
        0.8430166165116897e+00,
        0.2425255066777939e-03,
        0.8458353884515460e+00,
        0.2428940073795231e-03,
        0.8485481438833696e+00,
        0.2432486779499734e-03,
        0.8511606873176778e+00,
        0.2435902758469355e-03,
        0.8536784138006696e+00,
        0.2439195050751448e-03,
        0.8561063446757747e+00,
        0.2442370208681859e-03,
        0.8584491596979498e+00,
        0.2445434338913074e-03,
        0.8607112259291628e+00,
        0.2448393140217253e-03,
        0.8628966237872216e+00,
        0.2451251937555122e-03,
        0.8650091705719897e+00,
        0.2454015712837818e-03,
        0.8670524417517986e+00,
        0.2456689132754098e-03,
        0.8690297902574413e+00,
        0.2459276573988435e-03,
        0.8709443640006192e+00,
        0.2461782146115141e-03,
        0.8727991218073733e+00,
        0.2464209712418874e-03,
        0.8745968479342314e+00,
        0.2466562908861773e-03,
        0.8763401653150385e+00,
        0.2468845161391411e-03,
        0.8780315476692500e+00,
        0.2471059701761088e-03,
        0.8796733305874988e+00,
        0.2473209582014312e-03,
        0.8812677216971869e+00,
        0.2475297687768076e-03,
        0.8828168099994235e+00,
        0.2477326750414573e-03,
        0.8843225744586169e+00,
        0.2479299358347776e-03,
        0.8857868919172412e+00,
        0.2481217967309792e-03,
        0.8872115444005592e+00,
        0.2483084909941748e-03,
        0.8885982258692703e+00,
        0.2484902404615005e-03,
        0.8899485484720331e+00,
        0.2486672563610595e-03,
        0.8912640483444853e+00,
        0.2488397400707827e-03,
        0.8925461909966710e+00,
        0.2490078838236775e-03,
        0.8937963763265875e+00,
        0.2491718713643894e-03,
        0.8950159432938443e+00,
        0.2493318785615123e-03,
        0.8962061742840980e+00,
        0.2494880739796445e-03,
        0.8973682991919632e+00,
        0.2496406194148037e-03,
        0.8985034992474405e+00,
        0.2497896703964584e-03,
        0.8996129106085194e+00,
        0.2499353766591264e-03,
        0.9006976277404708e+00,
        0.2500778825862051e-03,
        0.9017587066004092e+00,
        0.2502173276284460e-03,
        0.9027971676439548e+00,
        0.2503538466992535e-03,
        0.9038139986692414e+00,
        0.2504875705487804e-03,
        0.9048101575120641e+00,
        0.2506186261185988e-03,
        0.9057865746046461e+00,
        0.2507471368785526e-03,
        0.9067441554092800e+00,
        0.2508732231472320e-03,
        0.9076837827369850e+00,
        0.2509970023973650e-03,
        0.9086063189602724e+00,
        0.2511185895472782e-03,
        0.9095126081281425e+00,
        0.2512380972394480e-03,
        0.9104034779905169e+00,
        0.2513556361070412e-03,
        0.9112797419384428e+00,
        0.2514713150292236e-03,
        0.9121422008655769e+00,
        0.2515852413759041e-03,
        0.9129916449556555e+00,
        0.2516975212424692e-03,
        0.9138288553998849e+00,
        0.2518082596749575e-03,
        0.9146546060474243e+00,
        0.2519175608860183e-03,
        0.9154696649913860e+00,
        0.2520255284618921e-03,
        0.9162747960920304e+00,
        0.2521322655605479e-03,
        0.9170707604380880e+00,
        0.2522378751010061e-03,
        0.9178583177463857e+00,
        0.2523424599437699e-03,
        0.9186382276991902e+00,
        0.2524461230621790e-03,
        0.9194112512179023e+00,
        0.2525489677043914e-03,
        0.9201781516709387e+00,
        0.2526510975455835e-03,
        0.9209396960128159e+00,
        0.2527526168298444e-03,
        0.9216966558506134e+00,
        0.2528536305011233e-03,
        0.9224498084331230e+00,
        0.2529542443224635e-03,
        0.9231999375571040e+00,
        0.2530545649826379e-03,
        0.9239478343841470e+00,
        0.2531547001891691e-03,
        0.9246942981607159e+00,
        0.2532547587465925e-03,
        0.9254401368329844e+00,
        0.2533548506186903e-03,
        0.9261861675471153e+00,
        0.2534550869732947e-03,
        0.9269332170246625e+00,
        0.2535555802081323e-03,
        0.9276821218018076e+00,
        0.2536564439560544e-03,
        0.9284337283201880e+00,
        0.2537577930678808e-03,
        0.9291888928561548e+00,
        0.2538597435709706e-03,
        0.9299484812744167e+00,
        0.2539624126015323e-03,
        0.9307133685912200e+00,
        0.2540659183085976e-03,
        0.9314844383314877e+00,
        0.2541703797275094e-03,
        0.9322625816637383e+00,
        0.2542759166207297e-03,
        0.9330486962961403e+00,
        0.2543826492837433e-03,
        0.9338436851167795e+00,
        0.2544906983138460e-03,
        0.9346484545611477e+00,
        0.2546001843396463e-03,
        0.9354639126900528e+00,
        0.2547112277091971e-03,
        0.9362909669616406e+00,
        0.2548239481348102e-03,
        0.9371305216820521e+00,
        0.2549384642927942e-03,
        0.9379834751204702e+00,
        0.2550548933766077e-03,
        0.9388507162759753e+00,
        0.2551733506022396e-03,
        0.9397331212857866e+00,
        0.2552939486650164e-03,
        0.9406315494671578e+00,
        0.2554167971475084e-03,
        0.9415468389884580e+00,
        0.2555420018787558e-03,
        0.9424798021688484e+00,
        0.2556696642456735e-03,
        0.9434312204104797e+00,
        0.2557998804582168e-03,
        0.9444018387723074e+00,
        0.2559327407706962e-03,
        0.9453923602004483e+00,
        0.2560683286625224e-03,
        0.9464034394364762e+00,
        0.2562067199826295e-03,
        0.9474356766321346e+00,
        0.6097078489116776e-04,
        0.8380405076108355e-04,
        0.2544896065932850e-01,
        0.1012978969826672e-03,
        0.9887217219781226e-01,
        0.1149608733516808e-03,
        0.1745393544210289e+00,
        0.1258683390053939e-03,
        0.2432088150280462e+00,
        0.1347529092969161e-03,
        0.3034884369920806e+00,
        0.1421178877684437e-03,
        0.3559823686685004e+00,
        0.1483163075228666e-03,
        0.4017354125928528e+00,
        0.1536015360676195e-03,
        0.4417826623358451e+00,
        0.1581594503691672e-03,
        0.4770284685054013e+00,
        0.1621291886747866e-03,
        0.5082292867703224e+00,
        0.1656168126296357e-03,
        0.5360080170824175e+00,
        0.1687044997776278e-03,
        0.5608755465361002e+00,
        0.1714568607858636e-03,
        0.5832515093250096e+00,
        0.1739253676423436e-03,
        0.6034820081391302e+00,
        0.1761515150836057e-03,
        0.6218540396252812e+00,
        0.1781691159294222e-03,
        0.6386070034090316e+00,
        0.1800059934918693e-03,
        0.6539418148701861e+00,
        0.1816852471937282e-03,
        0.6680281114720945e+00,
        0.1832262113807821e-03,
        0.6810099636217561e+00,
        0.1846451904182646e-03,
        0.6930104184833876e+00,
        0.1859560284988198e-03,
        0.7041351333436702e+00,
        0.1871705558346453e-03,
        0.7144752970102477e+00,
        0.1882989413512779e-03,
        0.7241099922548785e+00,
        0.1893499739181992e-03,
        0.7331081173060140e+00,
        0.1903312884234792e-03,
        0.7415299576349032e+00,
        0.1912495488900670e-03,
        0.7494284788635305e+00,
        0.1921105978487627e-03,
        0.7568503960324043e+00,
        0.1929195789948627e-03,
        0.7638370625278608e+00,
        0.1936810385340217e-03,
        0.7704252127912312e+00,
        0.1943990094098548e-03,
        0.7766475858453091e+00,
        0.1950770816902051e-03,
        0.7825334511739168e+00,
        0.1957184616920660e-03,
        0.7881090542005848e+00,
        0.1963260218904405e-03,
        0.7933979952488399e+00,
        0.1969023432430833e-03,
        0.7984215532155936e+00,
        0.1974497512412977e-03,
        0.8031989630889407e+00,
        0.1979703467447663e-03,
        0.8077476547694436e+00,
        0.1984660324594830e-03,
        0.8120834593159135e+00,
        0.1989385357600094e-03,
        0.8162207876608769e+00,
        0.1993894284313026e-03,
        0.8201727859718991e+00,
        0.1998201438042677e-03,
        0.8239514711297960e+00,
        0.2002319916776369e-03,
        0.8275678492200949e+00,
        0.2006261713526632e-03,
        0.8310320194637810e+00,
        0.2010037830532616e-03,
        0.8343532656268659e+00,
        0.2013658379601603e-03,
        0.8375401366294502e+00,
        0.2017132670514090e-03,
        0.8406005178108765e+00,
        0.2020469289116992e-03,
        0.8435416940880705e+00,
        0.2023676166481832e-03,
        0.8463704060610680e+00,
        0.2026760640298827e-03,
        0.8490928999664670e+00,
        0.2029729509505747e-03,
        0.8517149722508350e+00,
        0.2032589083006388e-03,
        0.8542420094276686e+00,
        0.2035345223212339e-03,
        0.8566790237898599e+00,
        0.2038003385039595e-03,
        0.8590306854719521e+00,
        0.2040568650905127e-03,
        0.8613013512904316e+00,
        0.2043045762195164e-03,
        0.8634950907340174e+00,
        0.2045439147614532e-03,
        0.8656157094277920e+00,
        0.2047752948773090e-03,
        0.8676667703537839e+00,
        0.2049991043319707e-03,
        0.8696516130751836e+00,
        0.2052157065895086e-03,
        0.8715733711808579e+00,
        0.2054254427141078e-03,
        0.8734349881404843e+00,
        0.2056286330975070e-03,
        0.8752392317378276e+00,
        0.2058255790312958e-03,
        0.8769887072299080e+00,
        0.2060165641402434e-03,
        0.8786858693626248e+00,
        0.2062018556909442e-03,
        0.8803330333584298e+00,
        0.2063817057884218e-03,
        0.8819323849785773e+00,
        0.2065563524718971e-03,
        0.8834859897510554e+00,
        0.2067260207196752e-03,
        0.8849958014452854e+00,
        0.2068909233720063e-03,
        0.8864636698658907e+00,
        0.2070512619798147e-03,
        0.8878913480301039e+00,
        0.2072072275863421e-03,
        0.8892804987865693e+00,
        0.2073590014480071e-03,
        0.8906327009272852e+00,
        0.2075067557001234e-03,
        0.8919494548391176e+00,
        0.2076506539725411e-03,
        0.8932321877366053e+00,
        0.2077908519597573e-03,
        0.8944822585136047e+00,
        0.2079274979495885e-03,
        0.8957009622476075e+00,
        0.2080607333140918e-03,
        0.8968895343872672e+00,
        0.2081906929660589e-03,
        0.8980491546507244e+00,
        0.2083175057840894e-03,
        0.8991809506596934e+00,
        0.2084412950089600e-03,
        0.9002860013319247e+00,
        0.2085621786137507e-03,
        0.9013653400525538e+00,
        0.2086802696499600e-03,
        0.9024199576429591e+00,
        0.2087956765716353e-03,
        0.9034508051440569e+00,
        0.2089085035393573e-03,
        0.9044587964294366e+00,
        0.2090188507057549e-03,
        0.9054448106623624e+00,
        0.2091268144840720e-03,
        0.9064096946094280e+00,
        0.2092324878011760e-03,
        0.9073542648225251e+00,
        0.2093359603362731e-03,
        0.9082793096997696e+00,
        0.2094373187464826e-03,
        0.9091855914351026e+00,
        0.2095366468803258e-03,
        0.9100738478654410e+00,
        0.2096340259800857e-03,
        0.9109447942234819e+00,
        0.2097295348739169e-03,
        0.9117991248035615e+00,
        0.2098232501585007e-03,
        0.9126375145473211e+00,
        0.2099152463729734e-03,
        0.9134606205553340e+00,
        0.2100055961647897e-03,
        0.9142690835302997e+00,
        0.2100943704481180e-03,
        0.9150635291568929e+00,
        0.2101816385553131e-03,
        0.9158445694228796e+00,
        0.2102674683819544e-03,
        0.9166128038856619e+00,
        0.2103519265258884e-03,
        0.9173688208879894e+00,
        0.2104350784206675e-03,
        0.9181131987261704e+00,
        0.2105169884637311e-03,
        0.9188465067737359e+00,
        0.2105977201396311e-03,
        0.9195693065631350e+00,
        0.2106773361385627e-03,
        0.9202821528276868e+00,
        0.2107558984704203e-03,
        0.9209855945056615e+00,
        0.2108334685745573e-03,
        0.9216801757080246e+00,
        0.2109101074253908e-03,
        0.9223664366510376e+00,
        0.2109858756339512e-03,
        0.9230449145545729e+00,
        0.2110608335454401e-03,
        0.9237161445066656e+00,
        0.2111350413328171e-03,
        0.9243806602944845e+00,
        0.2112085590864012e-03,
        0.9250389952015636e+00,
        0.2112814468994273e-03,
        0.9256916827707871e+00,
        0.2113537649494626e-03,
        0.9263392575322679e+00,
        0.2114255735755424e-03,
        0.9269822556948962e+00,
        0.2114969333508442e-03,
        0.9276212157999659e+00,
        0.2115679051506757e-03,
        0.9282566793349052e+00,
        0.2116385502155082e-03,
        0.9288891913047499e+00,
        0.2117089302087404e-03,
        0.9295193007585984e+00,
        0.2117791072688329e-03,
        0.9301475612678799e+00,
        0.2118491440554076e-03,
        0.9307745313528513e+00,
        0.2119191037888559e-03,
        0.9314007748533154e+00,
        0.2119890502829553e-03,
        0.9320268612391253e+00,
        0.2120590479699442e-03,
        0.9326533658556098e+00,
        0.2121291619174575e-03,
        0.9332808700986251e+00,
        0.2121994578366795e-03,
        0.9339099615135131e+00,
        0.2122700020810254e-03,
        0.9345412338118337e+00,
        0.2123408616346198e-03,
        0.9351752867993358e+00,
        0.2124121040897991e-03,
        0.9358127262082568e+00,
        0.2124837976128301e-03,
        0.9364541634266928e+00,
        0.2125560108970050e-03,
        0.9371002151174706e+00,
        0.2126288131022461e-03,
        0.9377515027186954e+00,
        0.2127022737803375e-03,
        0.9384086518179469e+00,
        0.2127764627848895e-03,
        0.9390722913919686e+00,
        0.2128514501651432e-03,
        0.9397430529036528e+00,
        0.2129273060427348e-03,
        0.9404215692481872e+00,
        0.2130041004705666e-03,
        0.9411084735403966e+00,
        0.2130819032729711e-03,
        0.9418043977356298e+00,
        0.2131607838664165e-03,
        0.9425099710769944e+00,
        0.2132408110600791e-03,
        0.9432258183623697e+00,
        0.2133220528357081e-03,
        0.9439525580254419e+00,
        0.2134045761063316e-03,
        0.9446908000260153e+00,
        0.2134884464535012e-03,
        0.9454411435460905e+00,
        0.2135737278429450e-03,
        0.9462041744896647e+00,
        0.2136604823187037e-03,
        0.9469804627859271e+00,
        0.2137487696760521e-03,
        0.9477705594974885e+00,
        0.2138386471137701e-03,
        0.9485749937375257e+00,
        0.2139301688666145e-03,
        0.9493942694022146e+00,
        0.2140233858191606e-03,
        0.9502288617275928e+00,
        0.2141183451025241e-03,
        0.9510792136830037e+00,
        0.2142150896758442e-03,
        0.9519457322165201e+00,
        0.5038843819242724e-04,
        0.6925910573206593e-04,
        0.2544993017457056e-01,
        0.8371726902993700e-04,
        0.9887719305509405e-01,
        0.9500958703765661e-04,
        0.1745504296500425e+00,
        0.1040247370141086e-03,
        0.2432273260547244e+00,
        0.1113681540690559e-03,
        0.3035153719186541e+00,
        0.1174557699843303e-03,
        0.3560184543414467e+00,
        0.1225793327188225e-03,
        0.4017811956457096e+00,
        0.1269482262440711e-03,
        0.4418385610275083e+00,
        0.1307160600652860e-03,
        0.4770948070394370e+00,
        0.1339978185876816e-03,
        0.5083063187019734e+00,
        0.1368811515412669e-03,
        0.5360959417043054e+00,
        0.1394339707035654e-03,
        0.5609745206153379e+00,
        0.1417096704842709e-03,
        0.5833616556836523e+00,
        0.1437507874107348e-03,
        0.6036034220420834e+00,
        0.1455916127490372e-03,
        0.6219867936141575e+00,
        0.1472600893816645e-03,
        0.6387511510142359e+00,
        0.1487792104243456e-03,
        0.6540973934997754e+00,
        0.1501680651407632e-03,
        0.6681951446873501e+00,
        0.1514426313109642e-03,
        0.6811884629495294e+00,
        0.1526163827196775e-03,
        0.6932003848740875e+00,
        0.1537007600492208e-03,
        0.7043365583549521e+00,
        0.1547055396155196e-03,
        0.7146881637760102e+00,
        0.1556391248364784e-03,
        0.7243342762844463e+00,
        0.1565087786427017e-03,
        0.7333437871476419e+00,
        0.1573208103069447e-03,
        0.7417769754298066e+00,
        0.1580807267724731e-03,
        0.7496868008107239e+00,
        0.1587933560956882e-03,
        0.7571199727801611e+00,
        0.1594629488101686e-03,
        0.7641178395042019e+00,
        0.1600932616793006e-03,
        0.7707171304832252e+00,
        0.1606876273022243e-03,
        0.7769505800349328e+00,
        0.1612490122811637e-03,
        0.7828474531366270e+00,
        0.1617800660822615e-03,
        0.7884339908714920e+00,
        0.1622831622801481e-03,
        0.7937337893603658e+00,
        0.1627604335348945e-03,
        0.7987681234096885e+00,
        0.1632138013840797e-03,
        0.8035562240062770e+00,
        0.1636450017242930e-03,
        0.8081155171174660e+00,
        0.1640556066920045e-03,
        0.8124618299171829e+00,
        0.1644470435232973e-03,
        0.8166095694827731e+00,
        0.1648206108678467e-03,
        0.8205718781384362e+00,
        0.1651774929489843e-03,
        0.8243607689160389e+00,
        0.1655187718942932e-03,
        0.8279872440294369e+00,
        0.1658454385065429e-03,
        0.8314613987881412e+00,
        0.1661584017002631e-03,
        0.8347925129896938e+00,
        0.1664584967928401e-03,
        0.8379891315112622e+00,
        0.1667464928090865e-03,
        0.8410591355569131e+00,
        0.1670230989335329e-03,
        0.8440098057975293e+00,
        0.1672889702242240e-03,
        0.8468478784572497e+00,
        0.1675447126847760e-03,
        0.8495795952470572e+00,
        0.1677908877772391e-03,
        0.8522107479174399e+00,
        0.1680280164464030e-03,
        0.8547467180936171e+00,
        0.1682565827161736e-03,
        0.8571925129651890e+00,
        0.1684770369102029e-03,
        0.8595527973243928e+00,
        0.1686897985418176e-03,
        0.8618319223811186e+00,
        0.1688952589122240e-03,
        0.8640339517265517e+00,
        0.1690937834508111e-03,
        0.8661626847691907e+00,
        0.1692857138269685e-03,
        0.8682216779257585e+00,
        0.1694713698590671e-03,
        0.8702142638140924e+00,
        0.1696510512430158e-03,
        0.8721435686645843e+00,
        0.1698250391200247e-03,
        0.8740125281403963e+00,
        0.1699935975008061e-03,
        0.8758239017338748e+00,
        0.1701569745613678e-03,
        0.8775802858868165e+00,
        0.1703154038237586e-03,
        0.8792841259650484e+00,
        0.1704691052335605e-03,
        0.8809377272028146e+00,
        0.1706182861445670e-03,
        0.8825432647193950e+00,
        0.1707631422198987e-03,
        0.8841027926989548e+00,
        0.1709038582577726e-03,
        0.8856182528146059e+00,
        0.1710406089492363e-03,
        0.8870914819688771e+00,
        0.1711735595743775e-03,
        0.8885242194150492e+00,
        0.1713028666428259e-03,
        0.8899181133170080e+00,
        0.1714286784837430e-03,
        0.8912747267992473e+00,
        0.1715511357899551e-03,
        0.8925955435333450e+00,
        0.1716703721204033e-03,
        0.8938819729025228e+00,
        0.1717865143646592e-03,
        0.8951353547817279e+00,
        0.1718996831728790e-03,
        0.8963569639669645e+00,
        0.1720099933542312e-03,
        0.8975480142843037e+00,
        0.1721175542465397e-03,
        0.8987096624060582e+00,
        0.1722224700596145e-03,
        0.8998430113989865e+00,
        0.1723248401945090e-03,
        0.9009491140270437e+00,
        0.1724247595407294e-03,
        0.9020289758291009e+00,
        0.1725223187532327e-03,
        0.9030835579901713e+00,
        0.1726176045108827e-03,
        0.9041137800229966e+00,
        0.1727106997578779e-03,
        0.9051205222753303e+00,
        0.1728016839295312e-03,
        0.9061046282768895e+00,
        0.1728906331636581e-03,
        0.9070669069387198e+00,
        0.1729776204987175e-03,
        0.9080081346166083e+00,
        0.1730627160597527e-03,
        0.9089290570491782e+00,
        0.1731459872330869e-03,
        0.9098303911803945e+00,
        0.1732274988306475e-03,
        0.9107128268753881e+00,
        0.1733073132447196e-03,
        0.9115770285377644e+00,
        0.1733854905938624e-03,
        0.9124236366358845e+00,
        0.1734620888606598e-03,
        0.9132532691449957e+00,
        0.1735371640219225e-03,
        0.9140665229115264e+00,
        0.1736107701719091e-03,
        0.9148639749453516e+00,
        0.1736829596390858e-03,
        0.9156461836453693e+00,
        0.1737537830969034e-03,
        0.9164136899633000e+00,
        0.1738232896690321e-03,
        0.9171670185102322e+00,
        0.1738915270294578e-03,
        0.9179066786100761e+00,
        0.1739585414978131e-03,
        0.9186331653037572e+00,
        0.1740243781302842e-03,
        0.9193469603076764e+00,
        0.1740890808064089e-03,
        0.9200485329296795e+00,
        0.1741526923120535e-03,
        0.9207383409455176e+00,
        0.1742152544188343e-03,
        0.9214168314385361e+00,
        0.1742768079602262e-03,
        0.9220844416050994e+00,
        0.1743373929045788e-03,
        0.9227415995280490e+00,
        0.1743970484252448e-03,
        0.9233887249202853e+00,
        0.1744558129680012e-03,
        0.9240262298403793e+00,
        0.1745137243159310e-03,
        0.9246545193819353e+00,
        0.1745708196519153e-03,
        0.9252739923382533e+00,
        0.1746271356188670e-03,
        0.9258850418436779e+00,
        0.1746827083778257e-03,
        0.9264880559928549e+00,
        0.1747375736640159e-03,
        0.9270834184389665e+00,
        0.1747917668409568e-03,
        0.9276715089718623e+00,
        0.1748453229526972e-03,
        0.9282527040768544e+00,
        0.1748982767742368e-03,
        0.9288273774748004e+00,
        0.1749506628601784e-03,
        0.9293959006439499e+00,
        0.1750025155916436e-03,
        0.9299586433238869e+00,
        0.1750538692214704e-03,
        0.9305159740017549e+00,
        0.1751047579176975e-03,
        0.9310682603808031e+00,
        0.1751552158053241e-03,
        0.9316158698311472e+00,
        0.1752052770063228e-03,
        0.9321591698224861e+00,
        0.1752549756778664e-03,
        0.9326985283383640e+00,
        0.1753043460487161e-03,
        0.9332343142714111e+00,
        0.1753534224537021e-03,
        0.9337668977988398e+00,
        0.1754022393662154e-03,
        0.9342966507373076e+00,
        0.1754508314286094e-03,
        0.9348239468760963e+00,
        0.1754992334803999e-03,
        0.9353491622873846e+00,
        0.1755474805841303e-03,
        0.9358726756122197e+00,
        0.1755956080487566e-03,
        0.9363948683206198e+00,
        0.1756436514503888e-03,
        0.9369161249440563e+00,
        0.1756916466502072e-03,
        0.9374368332783890e+00,
        0.1757396298093589e-03,
        0.9379573845551401e+00,
        0.1757876374006189e-03,
        0.9384781735788145e+00,
        0.1758357062165868e-03,
        0.9389995988277885e+00,
        0.1758838733741719e-03,
        0.9395220625161108e+00,
        0.1759321763151046e-03,
        0.9400459706133823e+00,
        0.1759806528021968e-03,
        0.9405717328197126e+00,
        0.1760293409110582e-03,
        0.9410997624925852e+00,
        0.1760782790169647e-03,
        0.9416304765223171e+00,
        0.1761275057765599e-03,
        0.9421642951526550e+00,
        0.1761770601040649e-03,
        0.9427016417429337e+00,
        0.1762269811416588e-03,
        0.9432429424681213e+00,
        0.1762773082236904e-03,
        0.9437886259529981e+00,
        0.1763280808343769e-03,
        0.9443391228366760e+00,
        0.1763793385586478e-03,
        0.9448948652636468e+00,
        0.1764311210257938e-03,
        0.9454562862975816e+00,
        0.1764834678455926e-03,
        0.9460238192541732e+00,
        0.1765364185365951e-03,
        0.9465978969494375e+00,
        0.1765900124462755e-03,
        0.9471789508600694e+00,
        0.1766442886627730e-03,
        0.9477674101926942e+00,
        0.1766992859179855e-03,
        0.9483637008591625e+00,
        0.1767550424818139e-03,
        0.9489682443554301e+00,
        0.1768115960474016e-03,
        0.9495814565420250e+00,
        0.1768689836072686e-03,
        0.9502037463246646e+00,
        0.1769272413203024e-03,
        0.9508355142342285e+00,
        0.1769864043696395e-03,
        0.9514771509060350e+00,
        0.1770465068115518e-03,
        0.9521290354592114e+00,
        0.1771075814155438e-03,
        0.9527915337778898e+00,
        0.1771696594959625e-03,
        0.9534649966970047e+00,
        0.1772327707355348e-03,
        0.9541497580966158e+00,
        0.1772969430013587e-03,
        0.9548461329099190e+00,
        0.1773622021540052e-03,
        0.9555544150514501e+00,
        0.1774285718505145e-03,
        0.9562748752734012e+00,
        0.4141439367791228e-04,
        0.5692455280094251e-04,
        0.2545075230958515e-01,
        0.6880819048293672e-04,
        0.9888145093055719e-01,
        0.7808989690617372e-04,
        0.1745598225673840e+00,
        0.8550005185877480e-04,
        0.2432430266865816e+00,
        0.9153624710259941e-04,
        0.3035382198764821e+00,
        0.9654032678652594e-04,
        0.3560490681596453e+00,
        0.1007520715550410e-03,
        0.4018200414988670e+00,
        0.1043435691172141e-03,
        0.4418859966836131e+00,
        0.1074410674826558e-03,
        0.4771511109577878e+00,
        0.1101390695970056e-03,
        0.5083717098779069e+00,
        0.1125096126676353e-03,
        0.5361705935601133e+00,
        0.1146085117292486e-03,
        0.5610585709493248e+00,
        0.1164796503201761e-03,
        0.5834552139424401e+00,
        0.1181579881289340e-03,
        0.6037065747337148e+00,
        0.1196717082477531e-03,
        0.6220996084034542e+00,
        0.1210437761733641e-03,
        0.6388736798670074e+00,
        0.1222930892987222e-03,
        0.6542296751290908e+00,
        0.1234353365269360e-03,
        0.6683372064799513e+00,
        0.1244836495012513e-03,
        0.6813403224997011e+00,
        0.1254491018862550e-03,
        0.6933620512173756e+00,
        0.1263410963843689e-03,
        0.7045080329697024e+00,
        0.1271676677918698e-03,
        0.7148694414033631e+00,
        0.1279357225503386e-03,
        0.7245253456049399e+00,
        0.1286512297599230e-03,
        0.7335446313434784e+00,
        0.1293193747303500e-03,
        0.7419875726551162e+00,
        0.1299446833543593e-03,
        0.7499071245871521e+00,
        0.1305311235624521e-03,
        0.7573499923313203e+00,
        0.1310821886317202e-03,
        0.7643575200396533e+00,
        0.1316009660202284e-03,
        0.7709664334404412e+00,
        0.1320901945745293e-03,
        0.7772094632859758e+00,
        0.1325523123360135e-03,
        0.7831158711649373e+00,
        0.1329894966984371e-03,
        0.7887118949231211e+00,
        0.1334036983057875e-03,
        0.7940211275731494e+00,
        0.1337966697989137e-03,
        0.7990648409231811e+00,
        0.1341699903007926e-03,
        0.8038622630547293e+00,
        0.1345250863590139e-03,
        0.8084308171076828e+00,
        0.1348632499289629e-03,
        0.8127863274927396e+00,
        0.1351856538739728e-03,
        0.8169431985757714e+00,
        0.1354933653731529e-03,
        0.8209145700097322e+00,
        0.1357873575589372e-03,
        0.8247124521846697e+00,
        0.1360685196510050e-03,
        0.8283478446917955e+00,
        0.1363376658083228e-03,
        0.8318308402273038e+00,
        0.1365955428844750e-03,
        0.8351707159751699e+00,
        0.1368428372415219e-03,
        0.8383760141893339e+00,
        0.1370801807530195e-03,
        0.8414546134316254e+00,
        0.1373081561065382e-03,
        0.8444137917023124e+00,
        0.1375273014991923e-03,
        0.8472602825170738e+00,
        0.1377381148057014e-03,
        0.8500003248309528e+00,
        0.1379410572868236e-03,
        0.8526397075811507e+00,
        0.1381365568962136e-03,
        0.8551838095120960e+00,
        0.1383250112355325e-03,
        0.8576376348545903e+00,
        0.1385067902006957e-03,
        0.8600058453531640e+00,
        0.1386822383562781e-03,
        0.8622927890697443e+00,
        0.1388516770701086e-03,
        0.8645025263354547e+00,
        0.1390154064358504e-03,
        0.8666388531742509e+00,
        0.1391737070077414e-03,
        0.8687053224808631e+00,
        0.1393268413685703e-03,
        0.8707052632000881e+00,
        0.1394750555493091e-03,
        0.8726417977239585e+00,
        0.1396185803165322e-03,
        0.8745178576969695e+00,
        0.1397576323417808e-03,
        0.8763361983967452e+00,
        0.1398924152653265e-03,
        0.8780994118377522e+00,
        0.1400231206653106e-03,
        0.8798099387284804e+00,
        0.1401499289419495e-03,
        0.8814700793975387e+00,
        0.1402730101253844e-03,
        0.8830820037910464e+00,
        0.1403925246147742e-03,
        0.8846477606322743e+00,
        0.1405086238553824e-03,
        0.8861692858244719e+00,
        0.1406214509596627e-03,
        0.8876484101690279e+00,
        0.1407311412776921e-03,
        0.8890868664633782e+00,
        0.1408378229217274e-03,
        0.8904862960362619e+00,
        0.1409416172491532e-03,
        0.8918482547719127e+00,
        0.1410426393076430e-03,
        0.8931742186694573e+00,
        0.1411409982459610e-03,
        0.8944655889790835e+00,
        0.1412367976934811e-03,
        0.8957236969523653e+00,
        0.1413301361111912e-03,
        0.8969498082404222e+00,
        0.1414211071166758e-03,
        0.8981451269702901e+00,
        0.1415097997853232e-03,
        0.8993107995269396e+00,
        0.1415962989297887e-03,
        0.9004479180657531e+00,
        0.1416806853595467e-03,
        0.9015575237779278e+00,
        0.1417630361221969e-03,
        0.9026406099291728e+00,
        0.1418434247280258e-03,
        0.9036981246901897e+00,
        0.1419219213591954e-03,
        0.9047309737757363e+00,
        0.1419985930647974e-03,
        0.9057400229075616e+00,
        0.1420735039429043e-03,
        0.9067261001151347e+00,
        0.1421467153106468e-03,
        0.9076899978868622e+00,
        0.1422182858632548e-03,
        0.9086324751833850e+00,
        0.1422882718229183e-03,
        0.9095542593235423e+00,
        0.1423567270782516e-03,
        0.9104560477526908e+00,
        0.1424237033150753e-03,
        0.9113385097022479e+00,
        0.1424892501391719e-03,
        0.9122022877485889e+00,
        0.1425534151916154e-03,
        0.9130479992787559e+00,
        0.1426162442572255e-03,
        0.9138762378698273e+00,
        0.1426777813666525e-03,
        0.9146875745882436e+00,
        0.1427380688925579e-03,
        0.9154825592148789e+00,
        0.1427971476403172e-03,
        0.9162617214011930e+00,
        0.1428550569336404e-03,
        0.9170255717613750e+00,
        0.1429118346954711e-03,
        0.9177746029050118e+00,
        0.1429675175245004e-03,
        0.9185092904144644e+00,
        0.1430221407676021e-03,
        0.9192300937708136e+00,
        0.1430757385884771e-03,
        0.9199374572319491e+00,
        0.1431283440327680e-03,
        0.9206318106661012e+00,
        0.1431799890898880e-03,
        0.9213135703438758e+00,
        0.1432307047517914e-03,
        0.9219831396916189e+00,
        0.1432805210688911e-03,
        0.9226409100087367e+00,
        0.1433294672033191e-03,
        0.9232872611513990e+00,
        0.1433775714797077e-03,
        0.9239225621848796e+00,
        0.1434248614336570e-03,
        0.9245471720066236e+00,
        0.1434713638580431e-03,
        0.9251614399419788e+00,
        0.1435171048473090e-03,
        0.9257657063143877e+00,
        0.1435621098398706e-03,
        0.9263603029917071e+00,
        0.1436064036587590e-03,
        0.9269455539101992e+00,
        0.1436500105506133e-03,
        0.9275217755776247e+00,
        0.1436929542231280e-03,
        0.9280892775567625e+00,
        0.1437352578810521e-03,
        0.9286483629305795e+00,
        0.1437769442608283e-03,
        0.9291993287501823e+00,
        0.1438180356639552e-03,
        0.9297424664665897e+00,
        0.1438585539891476e-03,
        0.9302780623472868e+00,
        0.1438985207633644e-03,
        0.9308063978784351e+00,
        0.1439379571717663e-03,
        0.9313277501535416e+00,
        0.1439768840866617e-03,
        0.9318423922493136e+00,
        0.1440153220954916e-03,
        0.9323505935893585e+00,
        0.1440532915279006e-03,
        0.9328526202963160e+00,
        0.1440908124819338e-03,
        0.9333487355329478e+00,
        0.1441279048493981e-03,
        0.9338391998326430e+00,
        0.1441645883404158e-03,
        0.9343242714197350e+00,
        0.1442008825071996e-03,
        0.9348042065199632e+00,
        0.1442368067670687e-03,
        0.9352792596613518e+00,
        0.1442723804247230e-03,
        0.9357496839657160e+00,
        0.1443076226937871e-03,
        0.9362157314309450e+00,
        0.1443425527176319e-03,
        0.9366776532041510e+00,
        0.1443771895894746e-03,
        0.9371356998457099e+00,
        0.1444115523717566e-03,
        0.9375901215841609e+00,
        0.1444456601147895e-03,
        0.9380411685618638e+00,
        0.1444795318746588e-03,
        0.9384890910712563e+00,
        0.1445131867303672e-03,
        0.9389341397814829e+00,
        0.1445466438001951e-03,
        0.9393765659551052e+00,
        0.1445799222572509e-03,
        0.9398166216545342e+00,
        0.1446130413441780e-03,
        0.9402545599377586e+00,
        0.1446460203869812e-03,
        0.9406906350428731e+00,
        0.1446788788079280e-03,
        0.9411251025608388e+00,
        0.1447116361374763e-03,
        0.9415582195958393e+00,
        0.1447443120251743e-03,
        0.9419902449125173e+00,
        0.1447769262494714e-03,
        0.9424214390693087e+00,
        0.1448094987263750e-03,
        0.9428520645370120e+00,
        0.1448420495168817e-03,
        0.9432823858016560e+00,
        0.1448745988331048e-03,
        0.9437126694506553e+00,
        0.1449071670430162e-03,
        0.9441431842411634e+00,
        0.1449397746737126e-03,
        0.9445742011494633e+00,
        0.1449724424131142e-03,
        0.9450059934001559e+00,
        0.1450051911099938e-03,
        0.9454388364738392e+00,
        0.1450380417722341e-03,
        0.9458730080918976e+00,
        0.1450710155632024e-03,
        0.9463087881769580e+00,
        0.1451041337961289e-03,
        0.9467464587875015e+00,
        0.1451374179263711e-03,
        0.9471863040250684e+00,
        0.1451708895414430e-03,
        0.9476286099124387e+00,
        0.1452045703486834e-03,
        0.9480736642411287e+00,
        0.1452384821604381e-03,
        0.9485217563865096e+00,
        0.1452726468766264e-03,
        0.9489731770888300e+00,
        0.1453070864645653e-03,
        0.9494282181984106e+00,
        0.1453418229359214e-03,
        0.9498871723832843e+00,
        0.1453768783206665e-03,
        0.9503503327975676e+00,
        0.1454122746379124e-03,
        0.9508179927088858e+00,
        0.1454480338635091e-03,
        0.9512904450832298e+00,
        0.1454841778942922e-03,
        0.9517679821256925e+00,
        0.1455207285088794e-03,
        0.9522508947756375e+00,
        0.1455577073249200e-03,
        0.9527394721549711e+00,
        0.1455951357527194e-03,
        0.9532340009683443e+00,
        0.1456330349451717e-03,
        0.9537347648542913e+00,
        0.1456714257439507e-03,
        0.9542420436865237e+00,
        0.1457103286219321e-03,
        0.9547561128248467e+00,
        0.1457497636218381e-03,
        0.9552772423154445e+00,
        0.1457897502911246e-03,
        0.9558056960406009e+00,
        0.1458303076131549e-03,
        0.9563417308182725e+00,
        0.1458714539347385e-03,
        0.9568855954523308e+00,
        0.1459132068901443e-03,
        0.9574375297347150e+00,
        0.1459555833217350e-03,
        0.9579977634012095e+00,
        0.1459985991974088e-03,
        0.9585665150430652e+00,
        0.1460422695250747e-03,
        0.9591439909772242e+00,
        0.1460866082644329e-03,
        0.9597303840784822e+00,
        0.1461316282363772e-03,
        0.9603258725775255e+00,
        0.3429496445563442e-04,
        0.4713901805892190e-04,
        0.2545140450924156e-01,
        0.5698005902228804e-04,
        0.9888482887297308e-01,
        0.6466651548721230e-04,
        0.1745672748051217e+00,
        0.7080319239456011e-04,
        0.2432554843126429e+00,
        0.7580213079430914e-04,
        0.3035563500747286e+00,
        0.7994640198168629e-04,
        0.3560733630370389e+00,
        0.8343456150015368e-04,
        0.4018508725952348e+00,
        0.8640911033247278e-04,
        0.4419236498367694e+00,
        0.8897459090834537e-04,
        0.4771958093843240e+00,
        0.9120925845958284e-04,
        0.5084236299136395e+00,
        0.9317276496329196e-04,
        0.5362298756774806e+00,
        0.9491132926180562e-04,
        0.5611253276477577e+00,
        0.9646129005158931e-04,
        0.5835295355152852e+00,
        0.9785159643187923e-04,
        0.6037885335602648e+00,
        0.9910558598615794e-04,
        0.6221892621956204e+00,
        0.1002422757479970e-03,
        0.6389710741614672e+00,
        0.1012773140638229e-03,
        0.6543348452257979e+00,
        0.1022236924158808e-03,
        0.6684501789683020e+00,
        0.1030922846881736e-03,
        0.6814611164733789e+00,
        0.1038922606077670e-03,
        0.6934906792512014e+00,
        0.1046314062227422e-03,
        0.7046445019124451e+00,
        0.1053163748547551e-03,
        0.7150137530267155e+00,
        0.1059528854651743e-03,
        0.7246774971389701e+00,
        0.1065458808280527e-03,
        0.7337046159216464e+00,
        0.1070996546816144e-03,
        0.7421553796866258e+00,
        0.1076179547185671e-03,
        0.7500827400704289e+00,
        0.1081040665980620e-03,
        0.7575333991194183e+00,
        0.1085608829314993e-03,
        0.7645486980661065e+00,
        0.1089909602824242e-03,
        0.7711653599123298e+00,
        0.1093965665385209e-03,
        0.7774161128496167e+00,
        0.1097797204987463e-03,
        0.7833302160485503e+00,
        0.1101422251266719e-03,
        0.7889339050599856e+00,
        0.1104856956203599e-03,
        0.7942507707081078e+00,
        0.1108115832166325e-03,
        0.7993020827048136e+00,
        0.1111211954666116e-03,
        0.8041070671151008e+00,
        0.1114157135775683e-03,
        0.8086831451312193e+00,
        0.1116962073042465e-03,
        0.8130461392755103e+00,
        0.1119636477840458e-03,
        0.8172104520762232e+00,
        0.1122189186395992e-03,
        0.8211892213917328e+00,
        0.1124628256154204e-03,
        0.8249944558535597e+00,
        0.1126961049694284e-03,
        0.8286371533240165e+00,
        0.1129194308029721e-03,
        0.8321274047940588e+00,
        0.1131334214826889e-03,
        0.8354744857604805e+00,
        0.1133386452827434e-03,
        0.8386869368027751e+00,
        0.1135356253556231e-03,
        0.8417726348159536e+00,
        0.1137248441228562e-03,
        0.8447388561361401e+00,
        0.1139067471630854e-03,
        0.8475923326126939e+00,
        0.1140817466633488e-03,
        0.8503393015273689e+00,
        0.1142502244897405e-03,
        0.8529855501323292e+00,
        0.1144125349255261e-03,
        0.8555364554704203e+00,
        0.1145690071179690e-03,
        0.8579970200494635e+00,
        0.1147199472693837e-03,
        0.8603719038646763e+00,
        0.1148656406030670e-03,
        0.8626654531972963e+00,
        0.1150063531306337e-03,
        0.8648817265611982e+00,
        0.1151423332437714e-03,
        0.8670245181211878e+00,
        0.1152738131504335e-03,
        0.8690973788654197e+00,
        0.1154010101729216e-03,
        0.8711036357789597e+00,
        0.1155241279231094e-03,
        0.8730464092349987e+00,
        0.1156433573681646e-03,
        0.8749286287938791e+00,
        0.1157588777984930e-03,
        0.8767530475772949e+00,
        0.1158708577082165e-03,
        0.8785222553652559e+00,
        0.1159794555972724e-03,
        0.8802386905462134e+00,
        0.1160848207031594e-03,
        0.8819046510357806e+00,
        0.1161870936694311e-03,
        0.8835223042664072e+00,
        0.1162864071572288e-03,
        0.8850936963389428e+00,
        0.1163828864054445e-03,
        0.8866207604170093e+00,
        0.1164766497444822e-03,
        0.8881053244363083e+00,
        0.1165678090680486e-03,
        0.8895491181932601e+00,
        0.1166564702669258e-03,
        0.8909537798705543e+00,
        0.1167427336282587e-03,
        0.8923208620511820e+00,
        0.1168266942035215e-03,
        0.8936518372671990e+00,
        0.1169084421479998e-03,
        0.8949481031247646e+00,
        0.1169880630343355e-03,
        0.8962109870428230e+00,
        0.1170656381424237e-03,
        0.8974417506390828e+00,
        0.1171412447277278e-03,
        0.8986415937936533e+00,
        0.1172149562698677e-03,
        0.8998116584177496e+00,
        0.1172868427031662e-03,
        0.9009530319522595e+00,
        0.1173569706306669e-03,
        0.9020667506186153e+00,
        0.1174254035230018e-03,
        0.9031538024423191e+00,
        0.1174922019033529e-03,
        0.9042151300675857e+00,
        0.1175574235196376e-03,
        0.9052516333798847e+00,
        0.1176211235049476e-03,
        0.9062641719516429e+00,
        0.1176833545271722e-03,
        0.9072535673250101e+00,
        0.1177441669286597e-03,
        0.9082206051443592e+00,
        0.1178036088566899e-03,
        0.9091660371500875e+00,
        0.1178617263854677e-03,
        0.9100905830442862e+00,
        0.1179185636302828e-03,
        0.9109949322379410e+00,
        0.1179741628544263e-03,
        0.9118797454885111e+00,
        0.1180285645694077e-03,
        0.9127456564359945e+00,
        0.1180818076289649e-03,
        0.9135932730449129e+00,
        0.1181339293173255e-03,
        0.9144231789590457e+00,
        0.1181849654321338e-03,
        0.9152359347751857e+00,
        0.1182349503624295e-03,
        0.9160320792416857e+00,
        0.1182839171620296e-03,
        0.9168121303871106e+00,
        0.1183318976186388e-03,
        0.9175765865838867e+00,
        0.1183789223189884e-03,
        0.9183259275514641e+00,
        0.1184250207102780e-03,
        0.9190606153031572e+00,
        0.1184702211581763e-03,
        0.9197810950405108e+00,
        0.1185145510016160e-03,
        0.9204877959987503e+00,
        0.1185580366045994e-03,
        0.9211811322466059e+00,
        0.1186007034052168e-03,
        0.9218615034435585e+00,
        0.1186425759620638e-03,
        0.9225292955573307e+00,
        0.1186836779982295e-03,
        0.9231848815442406e+00,
        0.1187240324430169e-03,
        0.9238286219948466e+00,
        0.1187636614715423e-03,
        0.9244608657471405e+00,
        0.1188025865423529e-03,
        0.9250819504693824e+00,
        0.1188408284331903e-03,
        0.9256922032145273e+00,
        0.1188784072750181e-03,
        0.9262919409480546e+00,
        0.1189153425844261e-03,
        0.9268814710508878e+00,
        0.1189516532945120e-03,
        0.9274610917989764e+00,
        0.1189873577843384e-03,
        0.9280310928210021e+00,
        0.1190224739070536e-03,
        0.9285917555355758e+00,
        0.1190570190167592e-03,
        0.9291433535691963e+00,
        0.1190910099942032e-03,
        0.9296861531561591e+00,
        0.1191244632713702e-03,
        0.9302204135215227e+00,
        0.1191573948550362e-03,
        0.9307463872481658e+00,
        0.1191898203493515e-03,
        0.9312643206289019e+00,
        0.1192217549775109e-03,
        0.9317744540045509e+00,
        0.1192532136025640e-03,
        0.9322770220888102e+00,
        0.1192842107474197e-03,
        0.9327722542807087e+00,
        0.1193147606140906e-03,
        0.9332603749653780e+00,
        0.1193448771022213e-03,
        0.9337416038038212e+00,
        0.1193745738269449e-03,
        0.9342161560123183e+00,
        0.1194038641361023e-03,
        0.9346842426320593e+00,
        0.1194327611268635e-03,
        0.9351460707895552e+00,
        0.1194612776617823e-03,
        0.9356018439483411e+00,
        0.1194894263843151e-03,
        0.9360517621524420e+00,
        0.1195172197338335e-03,
        0.9364960222620436e+00,
        0.1195446699601559e-03,
        0.9369348181817692e+00,
        0.1195717891376224e-03,
        0.9373683410819361e+00,
        0.1195985891787351e-03,
        0.9377967796131314e+00,
        0.1196250818473841e-03,
        0.9382203201144163e+00,
        0.1196512787716769e-03,
        0.9386391468154388e+00,
        0.1196771914563876e-03,
        0.9390534420327067e+00,
        0.1197028312950406e-03,
        0.9394633863602434e+00,
        0.1197282095816411e-03,
        0.9398691588548227e+00,
        0.1197533375220634e-03,
        0.9402709372159495e+00,
        0.1197782262451063e-03,
        0.9406688979607300e+00,
        0.1198028868132232e-03,
        0.9410632165937440e+00,
        0.1198273302329317e-03,
        0.9414540677720091e+00,
        0.1198515674649078e-03,
        0.9418416254650982e+00,
        0.1198756094337670e-03,
        0.9422260631104450e+00,
        0.1198994670375319e-03,
        0.9426075537638465e+00,
        0.1199231511567857e-03,
        0.9429862702451438e+00,
        0.1199466726635097e-03,
        0.9433623852790360e+00,
        0.1199700424295984e-03,
        0.9437360716309537e+00,
        0.1199932713350474e-03,
        0.9441075022378914e+00,
        0.1200163702758047e-03,
        0.9444768503340695e+00,
        0.1200393501712764e-03,
        0.9448442895712680e+00,
        0.1200622219714742e-03,
        0.9452099941336445e+00,
        0.1200849966637913e-03,
        0.9455741388468206e+00,
        0.1201076852793909e-03,
        0.9459368992809881e+00,
        0.1201302988991895e-03,
        0.9462984518477588e+00,
        0.1201528486594163e-03,
        0.9466589738904483e+00,
        0.1201753457567260e-03,
        0.9470186437674542e+00,
        0.1201978014528419e-03,
        0.9473776409283557e+00,
        0.1202202270787045e-03,
        0.9477361459823309e+00,
        0.1202426340380965e-03,
        0.9480943407584549e+00,
        0.1202650338107162e-03,
        0.9484524083574091e+00,
        0.1202874379546662e-03,
        0.9488105331941014e+00,
        0.1203098581083251e-03,
        0.9491689010306607e+00,
        0.1203323059915656e-03,
        0.9495276989992437e+00,
        0.1203547934062821e-03,
        0.9498871156140531e+00,
        0.1203773322361880e-03,
        0.9502473407719423e+00,
        0.1203999344458418e-03,
        0.9506085657409490e+00,
        0.1204226120788594e-03,
        0.9509709831360716e+00,
        0.1204453772552672e-03,
        0.9513347868815795e+00,
        0.1204682421679518e-03,
        0.9517001721591189e+00,
        0.1204912190781571e-03,
        0.9520673353408602e+00,
        0.1205143203099825e-03,
        0.9524364739069084e+00,
        0.1205375582438321e-03,
        0.9528077863461864e+00,
        0.1205609453087660e-03,
        0.9531814720399889e+00,
        0.1205844939737027e-03,
        0.9535577311273962e+00,
        0.1206082167374240e-03,
        0.9539367643517374e+00,
        0.1206321261173331e-03,
        0.9543187728872938e+00,
        0.1206562346369151e-03,
        0.9547039581454467e+00,
        0.1206805548118562e-03,
        0.9550925215594878e+00,
        0.1207050991347726e-03,
        0.9554846643473366e+00,
        0.1207298800585086e-03,
        0.9558805872514442e+00,
        0.1207549099779616e-03,
        0.9562804902552012e+00,
        0.1207802012103997e-03,
        0.9566845722752253e+00,
        0.1208057659742362e-03,
        0.9570930308289628e+00,
        0.1208316163662374e-03,
        0.9575060616771147e+00,
        0.1208577643371385e-03,
        0.9579238584404855e+00,
        0.1208842216656548e-03,
        0.9583466121909501e+00,
        0.1209109999308791e-03,
        0.9587745110163490e+00,
        0.1209381104830662e-03,
        0.9592077395592462e+00,
        0.1209655644128141e-03,
        0.9596464785296278e+00,
        0.1209933725186615e-03,
        0.9600909041917725e+00,
        0.1210215452731320e-03,
        0.9605411878256951e+00,
        0.1210500927872672e-03,
        0.9609974951637526e+00,
        0.1210790247737047e-03,
        0.9614599858031973e+00,
        0.1211083505083695e-03,
        0.9619288125956789e+00,
        0.1211380787908609e-03,
        0.9624041210149244e+00,
        0.1211682179036361e-03,
        0.9628860485040654e+00,
        0.1211987755701019e-03,
        0.9633747238043349e+00,
        0.1212297589117476e-03,
        0.9638702662671197e+00
    ]
    mσ = SVector{46, T}(0.4102693550421609e+00, 0.3889624104727243e+00,
        0.3804692420283886e+00, 0.3760815680865637e+00,
        0.3735177579729938e+00, 0.3719340231904236e+00,
        0.3708571145968057e+00, 0.3700947006022557e+00,
        0.3695328931459086e+00, 0.3691085831661758e+00,
        0.3687813249652330e+00, 0.3685244707068931e+00,
        0.3683185599507446e+00, 0.3681542178682514e+00,
        0.3680181997765286e+00, 0.3679084456991284e+00,
        0.3678181571053212e+00, 0.3678314333608541e+00,
        0.3677897070402892e+00, 0.3681800192470787e+00,
        0.3681272993461229e+00, 0.3680840569645587e+00,
        0.3680522380648169e+00, 0.3680263578626069e+00,
        0.3680061275157194e+00, 0.3679837719607466e+00,
        0.3679668653311732e+00, 0.3679542340323301e+00,
        0.3679429332584250e+00, 0.3679349432021754e+00,
        0.3679290943359695e+00, 0.3679242023884676e+00,
        0.3679207541681089e+00, 0.3679185472223537e+00,
        0.3679168690130640e+00, 0.3679158588043139e+00,
        0.3679154592969145e+00, 0.3679154025286917e+00,
        0.3679157536198652e+00, 0.3679163676763697e+00,
        0.3679171904021983e+00, 0.3679181786833088e+00,
        0.3679192462983425e+00, 0.3679204323079710e+00,
        0.3679216942157868e+00, 0.3679229127010114e+00)
    mτ = SVector{46, T}(0.4495196112243335e+00, 0.4219428123056774e+00,
        0.4084335547255627e+00, 0.4009301129475925e+00,
        0.3963598727888637e+00, 0.3934034185789226e+00,
        0.3913676516238603e+00, 0.3899091428928617e+00,
        0.3888276962996660e+00, 0.3880048656683555e+00,
        0.3873650613539532e+00, 0.3868583585730354e+00,
        0.3864499054795832e+00, 0.3861178821587815e+00,
        0.3858426294881124e+00, 0.3856144554520791e+00,
        0.3854228843194507e+00, 0.3853156085078759e+00,
        0.3851902798680153e+00, 0.3853705093720269e+00,
        0.3851957294861824e+00, 0.3850587241670235e+00,
        0.3849515900397918e+00, 0.3848648995575697e+00,
        0.3847945082231300e+00, 0.3847117224407400e+00,
        0.3846478726309070e+00, 0.3845979020112835e+00,
        0.3845472492329918e+00, 0.3845088319509754e+00,
        0.3844789634065264e+00, 0.3844504092359686e+00,
        0.3844285235163634e+00, 0.3844115660464609e+00,
        0.3843957877945634e+00, 0.3843835767106759e+00,
        0.3843727001444428e+00, 0.3843632394180673e+00,
        0.3843553120908175e+00, 0.3843487746818896e+00,
        0.3843434800804404e+00, 0.3843392605995229e+00,
        0.3843359163858929e+00, 0.3843331309176606e+00,
        0.3843309056586355e+00, 0.3843292556220249e+00)
    recf2 = [0.30054882432319852e+00, 3.22956177884372447e-002,
        0.65120991030208131e+00, 0.63927408285239784e+00,
        0.18817870484330687e+00, 0.12949086796142287e+00,
        0.36929228994973123e+00, 0.79423840471651530e+00,
        0.12664547192283679e+00, 0.21664108914571936e+00,
        0.20317486666283888e+00, 0.68973985242086411e+00,
        9.21908883216204372e-002, 0.29196113742928459e+00,
        0.12953776672666439e+00, 0.64753069741124225e+00,
        7.04674356597705248e-002, 0.35542681683117394e+00,
        9.07656559588879974e-002, 0.63308457287703845e+00,
        5.56972163240425158e-002, 0.40821116352399822e+00,
        6.75873603555146030e-002, 0.62987020691884099e+00,
        4.52314510540424083e-002, 0.45349195419520988e+00,
        5.26792640272769619e-002, 0.63544049146955495e+00,
        3.75090089431679499e-002, 0.49254878544097452e+00,
        4.24187172939975016e-002, 0.64492463446289439e+00,
        3.16359249842285209e-002, 0.52655925121329283e+00,
        3.50084592084723006e-002, 0.65625931086167177e+00,
        2.70567578115501507e-002, 0.55637314400053972e+00,
        2.94518530499679777e-002, 0.66820831119420498e+00,
        2.34133112197160119e-002, 0.58269051732740407e+00,
        2.51619619046079893e-002, 0.68016212648713559e+00,
        2.04646775547950611e-002, 0.60607513381042866e+00,
        2.17715740132157810e-002, 0.69180700798111705e+00,
        1.80438530603851781e-002, 0.62699968191049693e+00,
        1.90405563718173375e-002, 0.70301681552660245e+00,
        1.60303791898168714e-002, 0.64578676274480384e+00,
        1.68036691319633329e-002, 0.71364055291529882e+00,
        1.43381155595692263e-002, 0.66279314317681104e+00,
        1.49474698654232484e-002, 0.72374979043766230e+00,
        1.29010469345403229e-002, 0.67820698333699947e+00,
        1.33876019527344771e-002, 0.73325173459248638e+00,
        1.16704063750699676e-002, 0.69225809088374535e+00,
        1.20635867943110296e-002, 0.74220670880892559e+00,
        1.05960860068959762e-002, 0.70409774151149940e+00,
        1.09137157668129162e-002, 0.74912368794796913e+00,
        9.67196979334120598e-003, 0.71571912134789384e+00,
        9.93328940958853462e-003, 0.75682127872922034e+00,
        8.83088049264354157e-003, 0.72531148608154128e+00,
        9.04470405177602854e-003, 0.76252635111977451e+00,
        7.49752975344448926e-003, 0.74429703765376476e+00,
        7.64800434979143792e-003, 0.77578014029362463e+00,
        6.44662499627499889e-003, 0.76096815709763777e+00,
        6.55579137697651689e-003, 0.78800467003589447e+00,
        5.60281614024690528e-003, 0.77561094416327303e+00,
        5.68395304265941533e-003, 0.79908793271372636e+00,
        4.91498711563015476e-003, 0.78857537163140357e+00,
        4.97655964855825590e-003, 0.80915785321209388e+00,
        4.34677636099067670e-003, 0.80013067395467885e+00,
        4.39435175554785291e-003, 0.81832611676512312e+00,
        3.66318896127087925e-003, 0.81528210787427102e+00,
        3.69645225382438190e-003, 0.83060983150728429e+00,
        3.12932516261230477e-003, 0.82830703488869506e+00,
        3.15328263217450966e-003, 0.84139832970083195e+00,
        2.70436963378157917e-003, 0.83962253184943458e+00,
        2.72206342429737571e-003, 0.85093545781738889e+00,
        2.26042359759308711e-003, 0.85257910142895765e+00,
        2.27263024268829815e-003, 0.86203477403609596e+00,
        1.91756286498312467e-003, 0.86360400196773612e+00,
        1.92625566335835651e-003, 0.87162622634542208e+00,
        1.64724830462023466e-003, 0.87309774409059548e+00,
        1.65360632024389928e-003, 0.87999012957388845e+00,
        1.38282637180050312e-003, 0.88325788374442715e+00,
        1.38726529640400696e-003, 0.88904518573092806e+00,
        1.17735415652783261e-003, 0.89191446947557840e+00,
        1.18054684817541270e-003, 0.89684312191677840e+00,
        1.01451581092078117e-003, 0.89937700618801175e+00,
        1.01687067063979284e-003, 0.90362505621891864e+00,
        8.60103370174555371e-004, 0.90707730831681010e+00,
        8.61784495458673642e-004, 0.91067987206956114e+00,
        7.38449838715945724e-004, 0.91368398581287302e+00,
        7.39681931222742860e-004, 0.91677790158328409e+00,
        6.26536494339523871e-004, 0.92029586163588439e+00,
        6.27418391065155223e-004, 0.92292169625918086e+00,
        5.27198841477638535e-004, 0.92671269154766700e+00,
        5.27819852569725331e-004, 0.92892292628852668e+00,
        4.41280305422330659e-004, 0.93279972419751356e+00,
        4.41713167579480665e-004, 0.93465036777095101e+00,
        3.68329890353293618e-004, 0.93847789237229962e+00,
        3.68630038146788787e-004, 0.94002310606534123e+00,
        3.07178106908066945e-004, 0.94371021901868613e+00,
        3.07385962489261657e-004, 0.94499930303266455e+00,
        2.56347982062857336e-004, 0.94848961070657511e+00,
        2.56492172806663330e-004, 0.94956571249033128e+00,
        2.14313657894793703e-004, 0.95282878437120277e+00,
        2.14414083069790993e-004, 0.95372869329467769e+00,
        1.77496073342213158e-004, 0.95700775895946888e+00,
        1.77564725268418032e-004, 0.95775328386720671e+00,
        1.46177341030384291e-004, 0.96093061882940878e+00,
        1.46223756910301701e-004, 0.96154476805768796e+00,
        1.21261174404466404e-004, 0.96437278515162772e+00,
        1.21293027834230952e-004, 0.96488237891070616e+00
    ]
    mα = SVector{46, T}(1.0292175779085888e0,
        1.1711426157873857e0,
        1.2891787318896388e0,
        1.3700397217280607e0,
        1.4302791631568559e0,
        1.4782093408024377e0,
        1.516334027924159e0,
        1.5475988097126931e0,
        1.5737160337226037e0,
        1.5959315531956058e0,
        1.6150939953884995e0,
        1.6318133984601482e0,
        1.6465196972300669e0,
        1.659614432610494e0,
        1.67129422100608e0,
        1.6818474251390105e0,
        1.6914121284472068e0,
        1.7015535221197022e0,
        1.709840773771184e0,
        1.7232927879815139e0,
        1.7367827079155858e0,
        1.7481922291308314e0,
        1.7580559977582033e0,
        1.7666397849288047e0,
        1.7741946820706174e0,
        1.7839762257308416e0,
        1.7922570412176893e0,
        1.7993647293953894e0,
        1.8074256520810972e0,
        1.8142056832103326e0,
        1.819986883764463e0,
        1.826122183655859e0,
        1.8313031171465501e0,
        1.8357402691831322e0,
        1.8402891266399672e0,
        1.8441678181128414e0,
        1.8480312856160626e0,
        1.8517598757543596e0,
        1.8552799194744996e0,
        1.8585480291268521e0,
        1.8615467734561677e0,
        1.864275803993039e0,
        1.866744876869206e0,
        1.869115278174705e0,
        1.8713339241767621e0,
        1.8732755097069358e0)

    SROCK2ConstantCache{typeof(zprev), T}(ms, recf, mσ, mτ, recf2, mα, zprev, 1, 1, 1)
end

function SROCKEMConstantCache{T}(zprev) where {T}
    ms = SVector{10, Int}(3, 5, 7, 10, 25, 50, 75, 100, 150, 200)
    mη = SVector{10, T}(2.2, 12.0, 13.0, 14.3, 20.3, 27.2, 32.1, 36.0, 42.1, 46.7)
    SROCKEMConstantCache{typeof(zprev), T}(ms, mη, zprev, 1, one(T))
end

function SKSROCKConstantCache{T}(zprev) where {T}
    mc = [
        BigFloat(0.26789785655263484005021761920362001162625207936341643711230697056067440637189),
        BigFloat(0.1881246803739400380828320444984360439454960181213766656888129101056134983409417),
        BigFloat(0.1508369237974007964368931936300286707012216705133677960797375443164570733410783),
        BigFloat(0.1300694892790507643567154983268333066829492518540674488507581205297485785084135),
        BigFloat(0.1172753075678571810794275012744560554418272060522253965294777670251093793066376),
        BigFloat(0.1088431916501864575013805042626366059746254126513416347019220520410718073487922),
        BigFloat(0.1030045763615199041312550032396654413846754172792371086959274850112157583010051),
        BigFloat(0.09880385162249490585396266337133439175090434072043399637120985233990699510900764),
        BigFloat(0.09568673818075103108583461111124492851617529152823723906481039554249303272610928),
        BigFloat(0.09331381825494520833661534082962938389139391287905118174431104639046061374976943),
        BigFloat(0.09146803716840217228351049896437507191821118969324699866024338951073488526182161),
        BigFloat(0.09000553514656751567879751709882832885510018488011513153068998901263978094623957),
        BigFloat(0.0888280398052332354757610707224680551896128753249971325934502312688987067741843),
        BigFloat(0.08786665387850800406084200504437018640137748500627572622234093417022026993915416),
        BigFloat(0.08707196939486703735837744753007014068486260675103956390946965679671834854840533),
        BigFloat(0.08640784193836786631914435540114389621704975501014730642686245943616443642142571),
        BigFloat(0.08584735828898708831985115712377308874672554058425427560369828015676133176480728),
        BigFloat(0.08537015931085043541042031043145527841696863981582614344773148706452428261150014),
        BigFloat(0.08496062306764195010239839927065368651933909107569318301742462000799178364188833),
        BigFloat(0.08460660718460837973781709855888272482191634980545831942230372177420230851656487),
        BigFloat(0.08429856267566263727436708927044072362403252012262346817617485646731393322510314),
        BigFloat(0.08402889933849525066638846027022056453576379558849297753648120450771275602645343),
        BigFloat(0.08379152454853375659306372794535782775614164493166516426302522806218326216869419),
        BigFloat(0.08358150351106012323042695841305134848114452097824352953182281814580372484145578),
        BigFloat(0.0833948058546874024881588292472532474160780197947497145740607477134459032709625),
        BigFloat(0.08322811444275360810256483846605595493093107279773158777098320153143428355210525),
        BigFloat(0.08307867958600025821145066311430561095446071036556424745709734459379144428604502),
        BigFloat(0.08294420677327354670907078127509338460675308468266139136203468105922434551313946),
        BigFloat(0.0828227694166281892440407291526548571884267579901653018071868614987474676641638),
        BigFloat(0.0827127404539156660313253221756723228853707785042891496840209773215396416100653),
        BigFloat(0.08261273830200882500648232204705375526719778389736709595040791449127845615805284),
        BigFloat(0.0825215838277458180588015816622613111394886450678667609206025374063857971220911),
        BigFloat(0.08243826584808354427467061214772886992993032673370904510019708006571569560052148),
        BigFloat(0.08236191328462072292236297826570512020012424890849777558693476015990001540268758),
        BigFloat(0.08229177254797213419682043134669965623658966003159058421522053079071239780405431),
        BigFloat(0.08222718906095574904070487940663502502284957419698146571426332112564406347756568),
        BigFloat(0.08216759207864252333401223607165742650690377911013439862969207200275793962063689),
        BigFloat(0.08211248215088954279864226547543198224231673697215630322212830063163834425565681),
        BigFloat(0.08206142071531446327394638395391131255945166139530099138190880202995675680259328),
        BigFloat(0.0820140214174714222701439470939474310162208127766731992316151399117598283053819),
        BigFloat(0.08196994283873418756325750599464020536642002330216805199736027116654546855013896),
        BigFloat(0.0819288823772769360464060356288073750349811529860255230362473381097431350033321),
        BigFloat(0.08189057107813006312554994553112630127270014492719993935162903774259421739776988),
        BigFloat(0.08185476924796414162625919465175670004919637392053037383316794082612507595914729),
        BigFloat(0.08182126272155047533955086851508257843783804597679216326888096159911969141975432),
        BigFloat(0.08178985967166609449157144173202315982368204696263554957146276435177506753701941),
        BigFloat(0.0817603878739969472536512416694441402886712939992182221639364938993070252034103),
        BigFloat(0.08173269235444473982280987400440206649667717013190547600237534314234401151355948),
        BigFloat(0.08170663335900313382602125325959752318689080789358759794753813280020739791355592),
        BigFloat(0.08168208459668761404433382670163564427890197248830764417043545668688689244796045),
        BigFloat(0.08165893171438403186957453150195059996001327676415788784179954036505832466213985),
        BigFloat(0.08163707096931617495457644713096231679734228210016751179198707377115170911213767),
        BigFloat(0.08161640807043017624478049235805080739578125234830109037126028179807271256523731),
        BigFloat(0.08159685716459513380504790620593894367696800324168817564118497646921506585530421),
        BigFloat(0.08157833994731629080174939792277679422064590074376004044881069436107800654258145),
        BigFloat(0.08156078488080147347232377552516159580457999762273426257268371751698132503530511),
        BigFloat(0.08154412650483440401409962479211848278387840026379450674595310920197699442643064),
        BigFloat(0.08152830482808706885256549794841553869521931923983665864140662528312424163000948),
        BigFloat(0.08151326478932559203349390579052966513181869333077846828365067308752884105576071),
        BigFloat(0.08149895577949305350154301712181013148699679691490468017432180875085731799879805),
        BigFloat(0.08148533121693946125929127155387041709465875353498591044348859300605042771902351),
        BigFloat(0.08147234816915515446418104008535068557803302886297555090493136681097982665202912),
        BigFloat(0.08145996701528316178732327875430477429451004159542975238798209627542407389316183),
        BigFloat(0.08144815114446620558836067045784942208160473740534979119177627498337711644866111),
        BigFloat(0.08143686668574791374818557069886182045464756128197692575017713818328331808930449),
        BigFloat(0.08142608226581415341765907078286725422656644899306704040679336755592024222778326),
        BigFloat(0.08141576879134475351097139979232695294485166585764496944235369541003913229774793),
        BigFloat(0.0814058992531611004489537371069220396954932702115350696741378991672798799712235),
        BigFloat(0.0813964485497118698374867967137110989599344966668784302511487287148124635302462),
        BigFloat(0.08138739332774641192829252676016256244596998513421379227987010049847542416731546),
        BigFloat(0.08137871183829049438406780751121526093126750059199129642542113585003888999066509),
        BigFloat(0.08137038380626846901664010752344120187711534733207056149100137150700155634773763),
        BigFloat(0.08136239031231471883673576564990091299653293318219075174481466545022216638126624),
        BigFloat(0.08135471368548987942143268225697186807194207487984509918432749392136479666829958),
        BigFloat(0.0813473374057675476115618333584153207580495644484216312847384105386792831292964),
        BigFloat(0.08134024601528815058117203614275899546625861503273409912604693564424934508626955),
        BigFloat(0.08133342503749102964055635447360512685926349242669373119311550633536828572248946),
        BigFloat(0.08132686090333587437170891424695216383463814160643067196765981623422922931935426),
        BigFloat(0.08132054088391236520692671952333623437194590985482812437076905746347977712761306),
        BigFloat(0.08131445302881390382946885187069670070736014298433437760477119232465165889181946),
        BigFloat(0.08130858610971904881376863497051262472920739705524855052451206603090077323964922),
        BigFloat(0.08130292956868394429593739191460702478435684386641396551649497572313708714844343),
        BigFloat(0.0812974734707016762182694580662740073416593543708215448176136529971146217295113),
        BigFloat(0.08129220846013101225272207416602412744882699683871780616664219687114136368496911),
        BigFloat(0.08128712572063815243007429531312505879447018199891527803079674730946710123558111),
        BigFloat(0.08128221693833160674526051324933846039250143784466280325576133969331728592684352),
        BigFloat(0.08127747426780270235898270654939688121102292653698463153160179409718958423924917),
        BigFloat(0.08127289030081300809482566716530092041595027732443128714807434409401096801568339),
        BigFloat(0.08126845803739558322038107742622364579532792454387255380164158304220992608563592),
        BigFloat(0.0812641708591597896799619845473556341518250741158353299156276669858429281513755),
        BigFloat(0.08126002250460978183083121557350686898775665772156805952629085007665251160334082),
        BigFloat(0.08125600704630499303144046393840515317857907998320559869261465200685818087761437),
        BigFloat(0.08125211886970722549818988921895963966812461345748573686625022323096009779282108),
        BigFloat(0.081248352653573538619269657711768673332360645316487891285248736654221235629404),
        BigFloat(0.08124470335176721410747861852373387946068573845284986643691396322197885409134537),
        BigFloat(0.08124116617637082310034814123898656838222909936396550320101223715060994541444034),
        BigFloat(0.08123773658199597918146018782693353749971198924583565899653963580084381585297331),
        BigFloat(0.08123441025119386306761775955504740905597595316953345688367644517571686137655395),
        BigFloat(0.08123118308087916460505480686083424911885605637644965238623555603301763201859554),
        BigFloat(0.0812280511696878074044837736215415152114669862570693375484735088754906971213808),
        BigFloat(0.08122501080619579072960753101760456246305728160608403245544553000963597453511184),
        BigFloat(0.08122205845793278157832074748399559227036422983337985999475820747803897955443715),
        BigFloat(0.08121919076112978761723378155876254521962796800295933232977211218711678352664214),
        BigFloat(0.08121640451114540113537879678116947652407186173354273443440685867364226950157231),
        BigFloat(0.08121369665351978085763850342286276424228371567356801787167994971419085968667454),
        BigFloat(0.08121106427560978152991785033699539527389003403782215639863490750900568395832363),
        BigFloat(0.08120850459876249446019810982820342964943198394095759889414706352931808758727911),
        BigFloat(0.08120601497098796469395911346058090542281321367809714334508964609682940390410648),
        BigFloat(0.08120359286009503701872394265058378785220826878733456634711915127118886118907813),
        BigFloat(0.08120123584725718459877143133557883608646890131119387674137802233949581710949734),
        BigFloat(0.08119894162097781850341812909958722521788745948912389661903969892832543118223163),
        BigFloat(0.08119670797142698855144927779756276025649912882617712478651197808930134811207304),
        BigFloat(0.08119453278512358799663594871482102542628794532087288536521131860740386828706101),
        BigFloat(0.08119241403993918656771116043969060057318625340312618851398550110875204925900888),
        BigFloat(0.08119034980040145614624180007174219218339111804398710327159473293745640329688352),
        BigFloat(0.0811883382132768369914399784760079555010168644277582148514681613582785450033496),
        BigFloat(0.08118637750341363435353153376305492974439206348343088969664375269133019366102573),
        BigFloat(0.08118446596982814856167597432502397265955359080733868605750536210907691623140314),
        BigFloat(0.08118260198201773794239529957868380543809099803185735277074211849049501946650906),
        BigFloat(0.08118078397648590378043158518521336474038242977215867526993612345526670080617581),
        BigFloat(0.08117901045346557950495638973637174970890679075353723964710152100972150411976207),
        BigFloat(0.08117727997382781097598671490573152762227263173926794300637668998709808861577602),
        BigFloat(0.08117559115616393893754640588632057838441567899599923803240944312882614980839923),
        BigFloat(0.08117394267403024543271503810773044433488499586463116767903594723031643684394616),
        BigFloat(0.08117233325334480961272283207486386172126777341087882553306587959229775807319493),
        BigFloat(0.08117076166992704069117080856227577310787189976184358585930754297601552410891539),
        BigFloat(0.0811692267471710220310872285580428284759319904932443758834828283192026897945234),
        BigFloat(0.08116772735384441525881647786654235619113351505154374442957508612386915865078014),
        BigFloat(0.0811662624020052411908152794998305094747366862951432444428625065370258965892414),
        BigFloat(0.0811648308450293791606035670108581735948032418227490588784438201361887376146339),
        BigFloat(0.08116343167574211161227924040187287201386888618237698296511545201590894482213046),
        BigFloat(0.08116206392464748983306557872243149384034972471223429303673656997648109596929072),
        BigFloat(0.08116072665824971239008289842579509587945454156937960434978794470323059442198822),
        BigFloat(0.0811594189774610929142121173945409760502277530133469391503079618981560800224661),
        BigFloat(0.08115814001609155079819894827705770497509169786314428996759088159286293905231902),
        BigFloat(0.08115688893941488939436243510697104307061744924677608152647963035146309703259057),
        BigFloat(0.08115566494280743346249248491845971795831294490927134308614290625145640767970851),
        BigFloat(0.08115446725045488280762055994294214196161706112176482753472116304919646865534251),
        BigFloat(0.08115329511412350397726198306282298543723609933346267215414248979164212735145485),
        BigFloat(0.08115214781199202813011523990479535330453368170621335091037083716348123207300714),
        BigFloat(0.08115102464754085218266449555716953753542393145582767339357202118870483927239851),
        BigFloat(0.08114992494849535340614599838428534444623717046303772271021777769988872658331236),
        BigFloat(0.08114884806582032599404690955778130476360404136918605237972921620338652312634844),
        BigFloat(0.08114779337276273286025301475814330790871818710964063754922532217631026613702652),
        BigFloat(0.08114676026394013807992083857570524224371990908889123019320935398796175356522048),
        BigFloat(0.08114574815447234588609813058236948669674542325848315110677574862643553733868919),
        BigFloat(0.08114475647915392184647179995769734669219011066355834793639669628282891588877807),
        BigFloat(0.08114378469166541155879669536166396624748110964462202191967283985551979909452359),
        BigFloat(0.08114283226382120264990775042360448688993661526623088208813330187405191096143577),
        BigFloat(0.08114189868485209771343995732254643457226464568685434305788954986514139359982429),
        BigFloat(0.0811409834607207796944206420554971042479693152896744994802021661142390836987739),
        BigFloat(0.08114008611346845769540754048611631979113071924915928174037797830582194821291905),
        BigFloat(0.08113920618059108076523619251380082877567254635535294002724997486369687191517636),
        BigFloat(0.08113834321444360042357520843514733040994116916263419996459989458415478231576528),
        BigFloat(0.08113749678167084992104562007704038502940506332759336006617862420054992888500592),
        BigFloat(0.08113666646266368995019534544669105689139034846448463829914983247370684503038529),
        BigFloat(0.08113585185103914709035657371317100191518370143121507331319535159454364104222343),
        BigFloat(0.08113505255314334304379634448801670785641247877508062862129121802556435995017505),
        BigFloat(0.08113426818757608002958819308338516609660648924144696522469791556048816888648637),
        BigFloat(0.08113349838473601084894610811085757734800296333508706880651234719777407408513671),
        BigFloat(0.08113274278638538140264578317846278236664944410766641158172459449720780067444562),
        BigFloat(0.08113200104523338908827746762466367657103589793913798104171717107893454151021537),
        BigFloat(0.0811312728245372527741112903312520167936986751518219055935380720681237227970203),
        BigFloat(0.08113055779772013916149635490898182310051922874920943607797161112096726975458115),
        BigFloat(0.08112985564800513651701433826562431897332354468055660578222350146618203544718075),
        BigFloat(0.08112916606806451017224030034591414174410671339687403619722538158139633640657839),
        BigFloat(0.08112848875968351503236602120104304778665577861047337875448559116931343677944024),
        BigFloat(0.08112782343343807877186875216927423553260374243892356513918023789473651347141297),
        BigFloat(0.08112716980838570558089685018717779228677932504347842503941544986529891255716385),
        BigFloat(0.08112652761176898440429793220449473691042061678699636918554486764471151697253687),
        BigFloat(0.08112589657873111772042299732138299721459631049270425190984340964491411246344765),
        BigFloat(0.08112527645204291716392226875600031214031415556423906596777969418071795041977695),
        BigFloat(0.0811246669818407408220482485788869370903305067467435911893549046287822001186841),
        BigFloat(0.08112406792537487393589809236567949214478456168283878407894373110780753356345493),
        BigFloat(0.08112347904676788011760099625938877922945186787224450631816484180844981587610877),
        BigFloat(0.08112290011678247414590577080575557211130699267711589733471715955908978278268844),
        BigFloat(0.08112233091259849001384293396977959465683525448344762950082336455009566449378181),
        BigFloat(0.08112177121759853925515052539381013720270400432193890998682686136902058978558618),
        BigFloat(0.08112122082116197474754369738277898498720744071482331473911287464018562761912924),
        BigFloat(0.081120679518466794252198966895390734273425132262612471218653169800689829270446),
        BigFloat(0.08112014711029913596684217911293561343698294959091082788577733637775634369627493),
        BigFloat(0.08111962340287003540703772366497991614790880125354768353848833833506848785117643),
        BigFloat(0.08111910820763912904508105137555623200676591227606658612201654088133553702996211),
        BigFloat(0.0811186013411450053829293996396660808367389371790163841587112405820352195683659),
        BigFloat(0.08111810262484191856598848758462850171326071714873517367180822402769163155123805),
        BigFloat(0.08111761188494259330615980371981341325946563532315176485448121913917433449627367),
        BigFloat(0.08111712895226686282015541819660841064886902613934685401387952748831698200763262),
        BigFloat(0.08111665366209589374468231720779567259005406479381776301758087165059692991129112),
        BigFloat(0.08111618585403176360302240349119166920519329383189866626924737317603467441200003),
        BigFloat(0.08111572537186216740466192394342167056968517880914733149046454843722421075519632),
        BigFloat(0.08111527206343004039553367128407070183069853764676377199157204979898508825242435),
        BigFloat(0.08111482578050789387356351579437611486613844965288099407643880630039608763921876),
        BigFloat(0.08111438637867667037299743981181175033827802306402151286617109035019250606899872),
        BigFloat(0.08111395371720893342999793598998427910117378503357782323030712479481929746236225),
        BigFloat(0.08111352765895621559806823830961291304407721167915985958622149577029561299101183),
        BigFloat(0.08111310807024035641018998956050466400760658276830111156045114448513872770794423),
        BigFloat(0.08111269482074866960882348173939097960945895774858963914509582810906187889382135),
        BigFloat(0.08111228778343278620737571255449243287396573385097933663207156867894902445436264),
        BigFloat(0.08111188683441102682831579683769190688696703009473358499461646405939113163146417)
    ]

    mα = [
        BigFloat(-0.7250361664394941270175300199981244948384231569369087699834612268023556863328762),
        BigFloat(-0.5713820489367103619961054336989960238684247145313397821246841371901023788419462),
        BigFloat(-0.8594097517775080627520967036551814801350447398431885530718018156072797727144424),
        BigFloat(-1.206375357960830373143441581045600653974533773000549267960222547245981668877011),
        BigFloat(-1.560670564394328725921778220351498505784984992987018132438662659104913284665401),
        BigFloat(-1.912315937782126292082806936839486870612894296206820663975762629939644766389722),
        BigFloat(-2.259597016691487342932744178597696587011868621466273382120141853509899678247959),
        BigFloat(-2.602715329888624149290206005474285019563550621961178567196883265712290349836532),
        BigFloat(-2.942273278593293072255919459971082822495026756802322298084655856990139890493337),
        BigFloat(-3.278880446025793141418271917014751631097585018847092814307951775164839379828819),
        BigFloat(-3.613059410098077307187866375419967339992157168598364206191388671043083514559653),
        BigFloat(-3.945235916095532688851864418323208479101333572808379701334801073293294736005818),
        BigFloat(-4.275751300280458770778370504121542624284765735440687523266447793399482620551367),
        BigFloat(-4.604878570523772965156563508098802653804582357753050659080106447767445915324814),
        BigFloat(-4.932836860902311172361234117470929381488140427259578901243676395927139321465706),
        BigFloat(-5.259803158759664966864624151420900095922208647082406077260204013506215313745336),
        BigFloat(-5.5859214626268618079860644151621957741640088897248953257952675737161975279205),
        BigFloat(-5.911309834728018708111706227813995448235705263015887425450710835202764899419247),
        BigFloat(-6.236065815519444230785329809792679503051015642646708001387608514089842465262805),
        BigFloat(-6.560270590263213020869396687629033868302994115727772028090036866088969471309447),
        BigFloat(-6.883992211457104735168285504153784924094603475134590388301421906591591439334571),
        BigFloat(-7.207288107101452041454011950637914218770543385475030702193812710015753169446927),
        BigFloat(-7.530207046901213511627446650940758364014585032532989423987128655247150337648245),
        BigFloat(-7.852790694811121268174356260182686677414574573943436878067205845072893810932072),
        BigFloat(-8.175074843890183523379310669412602527278636300305453440990016942148996846989095),
        BigFloat(-8.497090405485716629303184918831222650232638206278587397471665987321803478152794),
        BigFloat(-8.818864207097800869358569408474614632465340521880131903183530726206882332168825),
        BigFloat(-9.140419640200634771222426183929834275170919900400938605232293350035303610313878),
        BigFloat(-9.461777189578039943481358285391604442661450453623938123086356112546748416252631),
        BigFloat(-9.782954868464383528476146035458817819440459106223728309555512854349692036708181),
        BigFloat(-10.10396857831636095455880086345293910384717650748002490352865954565841941179286),
        BigFloat(-10.42483240790267732368446252019857207870564267108140860844472912566589471378371),
        BigFloat(-10.74555888324464853213955371315470265456402891452797013254284555544752605921737),
        BigFloat(-11.06615917752118578864622620475477653422641475192986328475273011512141744059552),
        BigFloat(-11.38664328818351515326914831379936503129640256813335072511075297056197173384537),
        BigFloat(-11.70702018707354391110126304170364439875153968094260857592359237346703026630355),
        BigFloat(-12.02729794820517736539182460787727563717750113998208313612085039199431608921203),
        BigFloat(-12.34748385697569771958047992058439391038069830355621188233977492008544995468565),
        BigFloat(-12.66758450386873490361549634691982283841505856616206731353950837301966110311528),
        BigFloat(-12.98760586514928079790234210805626369902621420878257880315881730715672649615702),
        BigFloat(-13.3075533726026617727036915198716592364831257786641334382464253746363289896571),
        BigFloat(-13.62743197400898594955514033873508670689629215215679290364503429520073938730323),
        BigFloat(-13.94724618575358070897197163408041621797740879114200465116226174806529334095369),
        BigFloat(-14.26700013873786099730681538462602885754778600190539995088195491105846112059695),
        BigFloat(-14.58669761856268397326198110813122570212165068306348827621022560158082166879697),
        BigFloat(-14.906342100798780990047336435431580808907574448117417735460446576507203439037),
        BigFloat(-15.22593678202943460015749368100203026425554531156071693456633176401268295019117),
        BigFloat(-15.54548460724376326928603275461213509261736210494048282676997698476547806860202),
        BigFloat(-15.86498829407049458482895712590333745763730979138738914849355903946210798702396),
        BigFloat(-16.18445035426853133567702195057012067433626801522840901882462626648944686099003),
        BigFloat(-16.50387311282921255835188961456481034423291837998859704665000067716507487991576),
        BigFloat(-16.82325872499375122972390450284048548840609600588364409653864557427672045600346),
        BigFloat(-17.14260919144612490189797375588031646770187701529070593361860999575468053491574),
        BigFloat(-17.46192637190527556196394152267872008907556732640550795444260675075681308302482),
        BigFloat(-17.78121199730967906520383025710121006743787008238265315642152669669599841362343),
        BigFloat(-18.10046768076122581080796221515520115774936811932688524893765636055400714089077),
        BigFloat(-18.41969492737313815401209244562138066503043473732139373662386630642808990273726),
        BigFloat(-18.73889514314770021586694058100151214060300372862643388667257486964398489811393),
        BigFloat(-19.05806964299336813217738234245529961245630688110842371079122891901971661023777),
        BigFloat(-19.37721965797693013767966518613744971709321584941263962927781440543464466594053),
        BigFloat(-19.69634634189443696638138283318448930599354621853902521477970065604846655280235),
        BigFloat(-20.0154507772343250634401536764394908444242708602719565591853065338706902549031),
        BigFloat(-20.33453398059725878197023021679528442988246956598752653339238156662547179658954),
        BigFloat(-20.65359690762951453734389250265110815148772037404861148979124922254696163441364),
        BigFloat(-20.9726404575200448523127579795365099170976949413173788567803024837245973965258),
        BigFloat(-21.29166547710554616579990595485170708516988249427392450883316975762120257410734),
        BigFloat(-21.61067276462278705476728226364143429818456355571748890615546804880729668022192),
        BigFloat(-21.92966307314302815694127090368507105179769692532748766961398873812962105463169),
        BigFloat(-22.24863711371949259427978859578923117897417129173584637119442842515578160742503),
        BigFloat(-22.56759555827545046527547222129512130621729173092387235850907741443688047828969),
        BigFloat(-22.8865390422574985919042524206830576061836461363111723501119070444889157658631),
        BigFloat(-23.20546816707599219152942381050043367656169707529963031327114915573057409093563),
        BigFloat(-23.52438350235227145363233897917013638654124462631433963134833079888426303690178),
        BigFloat(-23.84328558799028280146413901462170334459627302274023407119029554340380652923972),
        BigFloat(-24.16217493608838725361590243747739598127140408106072291539166064059474456835234),
        BigFloat(-24.48105203270554693226378511292354199533971028958955165090425643168402540721684),
        BigFloat(-24.79991733949465965282716846979015889440979058160497434030807805797489419782652),
        BigFloat(-25.11877129521454842489057198676823932025975716154130009568631615889483929052323),
        BigFloat(-25.43761431713098832900828587684970632337097247539943894596936647038804585487001),
        BigFloat(-25.75644680231615089228408283225306088948410060759179414817569400945479252136782),
        BigFloat(-26.07526912885495123869797851698962628850148412623672300497204961999135928094259),
        BigFloat(-26.39408165696598328843051777265762901651696943510516511474124712530636593810863),
        BigFloat(-26.71288473004401209154437224195127835021793191679004327943912647281907979834057),
        BigFloat(-27.03167867563035036738791416427249166207283654743602459101129751344179445248796),
        BigFloat(-27.35046380631687004852910192633202353173475304321490341516221319435454542665609),
        BigFloat(-27.66924042058888170567566377213034278722253235866982343766997642196491730521047),
        BigFloat(-27.98800880361164867001984035938633741059824234165810712520667143397332330876853),
        BigFloat(-28.3067692279648827682106367173616042874241147073749321020168580920556293089017),
        BigFloat(-28.62552195432918982122056403155328312410186114175424313482065507909764222604273),
        BigFloat(-28.94426723212809100435142013361198958127403437482928858161209230015309499893122),
        BigFloat(-29.26300530012893691240813263681261647362807923761253851547481347715090182039393),
        BigFloat(-29.58173638700575126538114444558529197273558591357139594301531313039899172823864),
        BigFloat(-29.90046071186678756576685570328184290705229270106461146857826260093063335835505),
        BigFloat(-30.21917848474935196608701626980347723728669415230966117988095172950740334727393),
        BigFloat(-30.53788990708423671610263269065830971843555509213096661549350074704344729135842),
        BigFloat(-30.85659517213191869327549426069552319553827087983463105781446392608793760989722),
        BigFloat(-31.17529446539250477245150471905333494489247862454325540211187486353462502915987),
        BigFloat(-31.49398796499124846438410264675993852534676529177825979313651791061327602254067),
        BigFloat(-31.81267584204131883362729399235728410316083158021758039775348197146585866706926),
        BigFloat(-32.13135826098537184238434157371185319670635541724017063795025252239546701288635),
        BigFloat(-32.4500353799173547491301285896849127042763614275406815364181882969311102036448),
        BigFloat(-32.76870735088586493704590267988216451036321259143733071880597264249312376668181),
        BigFloat(-33.08737432018028458774962343887667476235659069289705075582034887972238198583317),
        BigFloat(-33.40603642860082108051426933965540546374051990800187077108953462004807934006852),
        BigFloat(-33.72469381171349910488945840560514040481602157504474133286837836717895677020691),
        BigFloat(-34.04334660009107352306297668874277261120020285917683190643092617165731265551059),
        BigFloat(-34.36199491954076137541988060580122458641939828489238007929546868845690975672941),
        BigFloat(-34.68063889131962651928833851053239080642074022377837174308109809504453912201385),
        BigFloat(-34.99927863233839071349818202727193437579500138552695042510551548263462033097957),
        BigFloat(-35.31791425535439004684871529964701563319919252614826731418262101121727952690427),
        BigFloat(-35.63654586915434503837699897977151567998829037713925128263686796295270154647219),
        BigFloat(-35.9551735787275661330133087316763330967281239845045207796948044520832630895781),
        BigFloat(-36.27379748543017333531875287308858473808040471417208317309057664728573655597553),
        BigFloat(-36.59241768714086905627878420243478896002306108689644781068257603772680297408139),
        BigFloat(-36.91103427840876661229608199135821331742068869461654533919877569698198835417083),
        BigFloat(-37.22964735059374295634648282878129995366545919713642269205131708384523727271012),
        BigFloat(-37.54825699199975290692381659747100855275629364738225661400692818303700068254961),
        BigFloat(-37.86686328800151316020062128522294961907272446078478453644529321364123313827578),
        BigFloat(-38.18546632116493753309572509756221523612109272517605277330394536621199350989045),
        BigFloat(-38.50406617136168001515896000937838912603105440517730107943311425928718094579286),
        BigFloat(-38.82266291587811914635502425485135987089859232087737854701477693443542414522871),
        BigFloat(-39.1412566295190958409644357196418012702651383492040019292014583665992415687865),
        BigFloat(-39.45984738470669691260932884940674561638212080096667381685187436955831811592588),
        BigFloat(-39.77843525157435810102376837336917562668355313861719834988267172515198892653599),
        BigFloat(-40.09702029805654324719145662038118280186437169816205205951632426377584126330448),
        BigFloat(-40.415602589974240308869467016087872018074708735350549202544564138416794951162),
        BigFloat(-40.73418219111650006086645011675338030023446760430857883317453520429689176901122),
        BigFloat(-41.05275916331822949908412867179229989618908406986020018993648327847358320386061),
        BigFloat(-41.3713335665344390866654954993848062568481747527912055890876421812955877524683),
        BigFloat(-41.68990545891113097345424108262128069049954960204274824758860090954580858537281),
        BigFloat(-42.00847489685300412104194146924824777184916206081343994056666631555179033309552),
        BigFloat(-42.32704193508814181497794489384328003822797889181279535334694200126954892758911),
        BigFloat(-42.6456066267298372881172701361437754835778524296053472750436560097223636396192),
        BigFloat(-42.96416902333570406389345006298486869780433845785437942277557464582764017524832),
        BigFloat(-43.28272917496420910888299536396940231116948035798830995368962369927965299481647),
        BigFloat(-43.6012871302287589174305253648144575408173963805093194355458940258033215832155),
        BigFloat(-43.91984293634946119776333413486447975041053351155878263962353269434720868763085),
        BigFloat(-44.23839663920267785246804028429714531449433511256278771521042651940601959287747),
        BigFloat(-44.55694828336847841278719971020090981848730291730981466916968448743983278763497),
        BigFloat(-44.87549791217609696487003191021297551819287218736126666693273535901585459630146),
        BigFloat(-45.19404556774748986820453021902371422141072864887835197347515383136838593960867),
        BigFloat(-45.51259129103908618547316640517562283216045643580972599051325439988776557859156),
        BigFloat(-45.83113512188181769451590358835995024443003837509993085630166890728046932362405),
        BigFloat(-46.1496770990195106142933062609106652040325447219962742708096675527757062632954),
        BigFloat(-46.46821726014571672674733062644554795445005282725836376890475512311231552970626),
        BigFloat(-46.78675564193905739583708603167486323979492423786712729258787254930712276969554),
        BigFloat(-47.10529228009715005578743407605111104879617799683942804476336180633341754203199),
        BigFloat(-47.42382720936918304604888422851315985005420497045685062907066248672579912707079),
        BigFloat(-47.74236046358720119515635322365177175435253105834883809217956851001470206922266),
        BigFloat(-48.06089207569616128523482581958186980353326276345277534993359741192489644651019),
        BigFloat(-48.3794220777828134500020041583018504078541692329080604163144556661565522354918),
        BigFloat(-48.69795050110346165937958240177427261399868368450874711497575349520817601048237),
        BigFloat(-49.01647737611065371173843581238734047788156974309490754550422910678873676923624),
        BigFloat(-49.3350027324788485796690902181314515985338440797651518314068527386288917495544),
        BigFloat(-49.65352659912910652703393096287583188406691350850801987312284344532352113855742),
        BigFloat(-49.97204900425284512465816740164754381493607468778415256566865588232951129429861),
        BigFloat(-50.29056997533470213072706746708014049925849562488979945368924677299715280657605),
        BigFloat(-50.60908953917454416174229069354797060871226313588420370202116454147991883491718),
        BigFloat(-50.92760772190865815326174152033226959096263759567900587149247690404951533359487),
        BigFloat(-51.24612454903016078962298527487706855754809104733459375475017605525648383342014),
        BigFloat(-51.56464004540865936191684090715293300294031434041270714248116197923209576008616),
        BigFloat(-51.88315423530919588755720862653105047850204788334993978024442463041764669680293),
        BigFloat(-52.20166714241050478721092751615355653647049054154345666747709070289456711669998),
        BigFloat(-52.52017878982261296030736494797639010203151609717839060561919745241174342554137),
        BigFloat(-52.8386892001038097238890579362822227979487384463830195983223589462662405683815),
        BigFloat(-53.15719839527701277656253522637113984967371679530714528041858559805045273283933),
        BigFloat(-53.47570639684555511543302985459904317128766753072781974717100087201696499357023),
        BigFloat(-53.79421322580841666510773493244197321365830669094598859530398608301538481404721),
        BigFloat(-54.1127189026749232703386597291198711166300627378703259025846477125725945264499),
        BigFloat(-54.43122344747893465409858644858894294075711902070264188510584759267795567193774),
        BigFloat(-54.74972687979254194751748483607950838709597307248399058804594118748330388863971),
        BigFloat(-55.06822921873929445403674244370606132269913367086055010007028624063742021937293),
        BigFloat(-55.38673048300697441444450135138608829372811536047854914128560387271620542474444),
        BigFloat(-55.70523069085993768939885693019642124794161012010976502632989801313036979629885),
        BigFloat(-56.02372986015103746905780403955744487544674323890485974929208377283941430923796),
        BigFloat(-56.34222800833314735310489315404259394661360277825627410002216950701096830531012),
        BigFloat(-56.66072515247029941652445366288143371340329475113290854893167072609565854397537),
        BigFloat(-56.97922130924845218481461104337600491000069254264903000295245543912051076564431),
        BigFloat(-57.29771649498590278493351242906295917232264404723624267288003894984104798263103),
        BigFloat(-57.61621072564335691327775883299754744008420084538029561695701332200117731299705),
        BigFloat(-57.9347040168336696676279788709788493578971767746366275155657996214742149703794),
        BigFloat(-58.2531963838312697246058028128544684904799934707913168135861765269513658250506),
        BigFloat(-58.57168784158127880620852875264931832146172391289380455692829083103108024325628),
        BigFloat(-58.89017840470833786695380544723982569234454855619806100757440840219256956153722),
        BigFloat(-59.20866808752515094569406874498896662497100220142707995649685196140098564449812),
        BigFloat(-59.5271569040407571619472541824588577735330706462635526967644407821058237715672),
        BigFloat(-59.84564486796854089440997485565980795214369513671734300351998399494728469373808),
        BigFloat(-60.16413199273398975801617029172234287358751001015430587788065095433072228465295),
        BigFloat(-60.48261829148220959438879960109771819561702731149265424508751549525501066068915),
        BigFloat(-60.80110377708520530777727200045920865915489633695145753228522453598703916682703),
        BigFloat(-61.11958846214893601361012777677021164093012527561349362486457279975045604281604),
        BigFloat(-61.43807235902015261870690086498982610837868027957783906092604100667145002087461),
        BigFloat(-61.75655547979302562012240078841033327053058317134598307469221558723886612308125),
        BigFloat(-62.07503783631557059272639379655354196673925542583839885039055971164174833708847),
        BigFloat(-62.3935194401958785331827148311771543258732538782087888597826593464816042800892),
        BigFloat(-62.71200030280815793925766697989550304421945351636789562435643770908542245182274),
        BigFloat(-63.03048043529859522767165658196990688230885216842649089367542469075449525233177),
        BigFloat(-63.34895984859103983036149929474306173136274811900439554325372733622492299707714),
        BigFloat(-63.66743855339252005743024079247202212218507541954943232981775983888925602813779)
    ]

    SKSROCKConstantCache{typeof(zprev), T}(mc, mα, zprev)
end

function TangXiaoSROCK2ConstantCache{T}(zprev) where {T}
    ms = SVector{46, Int}(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
        17, 18, 19, 20, 22, 24, 26, 28, 30, 33, 36, 39, 43,
        47, 51, 56, 61, 66, 72, 78, 85, 93, 102, 112, 123, 135, 148, 163, 180, 198)
    recf = [
        0.1794612899156781e+00,
        0.9326607661089206e-01,
        0.1268473641290642e+00,
        0.2103378190528467e-01,
        0.5786627125519110e-01,
        0.7776456841673992e-01,
        0.2157791817707098e-01,
        0.9528922876588625e-01,
        0.8723622960881585e-01,
        0.3957407527591189e-01,
        0.5338681630900877e-01,
        0.2247986572029358e-01,
        0.6393794866013653e-01,
        0.8616759602466630e-01,
        0.7433164225960258e-01,
        0.1608966052260327e+00,
        0.2881884349012583e-01,
        0.3903194468364506e-01,
        0.2315538732440072e-01,
        0.4666180548151659e-01,
        0.8821448969005685e-01,
        0.5288869100008489e-01,
        0.1558852247558841e+00,
        0.5955157767537859e-01,
        0.2309801425356076e+00,
        0.2193602641069006e-01,
        0.2980001095383432e-01,
        0.2364036352805737e-01,
        0.3566742298660092e-01,
        0.9017696352896830e-01,
        0.4023410528284037e-01,
        0.1575736612169138e+00,
        0.4421100494822930e-01,
        0.2217430621508580e+00,
        0.4869809870617736e-01,
        0.2940499060453847e+00,
        0.1726461340854506e-01,
        0.2350655101084081e-01,
        0.2399195202240830e-01,
        0.2817607209777294e-01,
        0.9173675182820953e-01,
        0.3176838133583184e-01,
        0.1600219376374877e+00,
        0.3469194451695863e-01,
        0.2221486436776174e+00,
        0.3738763501161190e-01,
        0.2814712676591709e+00,
        0.4053195010515956e-01,
        0.3498597719348680e+00,
        0.1394572558988917e-01,
        0.1901965402711647e-01,
        0.2425291169233543e-01,
        0.2282720812165174e-01,
        0.9294575674653435e-01,
        0.2575013323611407e-01,
        0.1622227426315588e+00,
        0.2807705415789230e-01,
        0.2243919049772138e+00,
        0.3005377306193452e-01,
        0.2802435651401261e+00,
        0.3196472247412495e-01,
        0.3348331353768858e+00,
        0.3423680369928859e-01,
        0.3989016641565190e+00,
        0.1150212461258425e-01,
        0.1570710434739234e-01,
        0.2445103607680476e-01,
        0.1887147450684578e-01,
        0.9388711032641100e-01,
        0.2130209293934879e-01,
        0.1640457400037581e+00,
        0.2322314183593871e-01,
        0.2267657098371261e+00,
        0.2480419563989607e-01,
        0.2818605427391582e+00,
        0.2620108024481186e-01,
        0.3319747646481704e+00,
        0.2760343567567814e-01,
        0.3822711818317003e+00,
        0.2928725018247521e-01,
        0.4419889482818066e+00,
        0.9650189035331108e-02,
        0.1319127118048348e-01,
        0.2460463437251803e-01,
        0.1586242507387037e-01,
        0.9462914691841271e-01,
        0.1791697874611395e-01,
        0.1655306545097223e+00,
        0.1953741662819831e-01,
        0.2288845437800309e+00,
        0.2085448736610660e-01,
        0.2840687821706643e+00,
        0.2197276738303543e-01,
        0.3327621634208670e+00,
        0.2299581340430604e-01,
        0.3779528907207973e+00,
        0.2405334751606276e-01,
        0.4244163000944219e+00,
        0.2532773055505536e-01,
        0.4799238174596328e+00,
        0.8212831461177801e-02,
        0.1123533801931148e-01,
        0.2472592539190680e-01,
        0.1351988263110243e-01,
        0.9522208667469109e-01,
        0.1527968649293853e-01,
        0.1667413647253854e+00,
        0.1666740304836073e-01,
        0.2306916351605186e+00,
        0.1778972104750926e-01,
        0.2862271893660237e+00,
        0.1872598244401872e-01,
        0.3345934460509904e+00,
        0.1954407472805166e-01,
        0.3778520013827246e+00,
        0.2031544030249000e-01,
        0.4188775043096391e+00,
        0.2113066217102199e-01,
        0.4619185110779211e+00,
        0.2211266742157054e-01,
        0.5134449754977242e+00,
        0.7074719613815112e-02,
        0.9684509591053977e-02,
        0.2482326781574381e-01,
        0.1166040318768419e-01,
        0.9570219065303219e-01,
        0.1318459890146430e-01,
        0.1677351729038757e+00,
        0.1438717215812115e-01,
        0.2322139970245483e+00,
        0.1535795943897448e-01,
        0.2881631572191675e+00,
        0.1616136143489047e-01,
        0.3366119552764601e+00,
        0.1684787625840699e-01,
        0.3791920530521655e+00,
        0.1746359793359561e-01,
        0.4179163657739238e+00,
        0.1805925334195525e-01,
        0.4554086296687285e+00,
        0.1869919690078058e-01,
        0.4953803203133830e+00,
        0.1946782991114719e-01,
        0.5431953913817005e+00,
        0.6158116280205625e-02,
        0.8434133870779752e-02,
        0.2490250308471492e-01,
        0.1015973796908432e-01,
        0.9609568511780181e-01,
        0.1149255448537381e-01,
        0.1685578212579456e+00,
        0.1254496388900155e-01,
        0.2334953976202505e+00,
        0.1339412026724050e-01,
        0.2898496927042313e+00,
        0.1409430683259744e-01,
        0.3385311597112782e+00,
        0.1468607650095395e-01,
        0.3809553853632720e+00,
        0.1520306181269769e-01,
        0.4187183922578105e+00,
        0.1567773486210682e-01,
        0.4536627812581018e+00,
        0.1614693417033556e-01,
        0.4881324072137513e+00,
        0.1665708022899876e-01,
        0.5253402953586265e+00,
        0.1726712768780420e-01,
        0.5697310475495430e+00,
        0.5408899288459016e-02,
        0.7411165652735432e-02,
        0.2496784203339785e-01,
        0.8931010375660927e-02,
        0.9642194989632852e-01,
        0.1010622203571924e-01,
        0.1692450860120974e+00,
        0.1103497280658699e-01,
        0.2345784420179126e+00,
        0.1178444954979593e-01,
        0.2913056300783272e+00,
        0.1240145878830343e-01,
        0.3402656182942943e+00,
        0.1292005530031986e-01,
        0.3827567779382510e+00,
        0.1336687811001040e-01,
        0.4201602339064523e+00,
        0.1376523513966666e-01,
        0.4539235794662016e+00,
        0.1413868046925951e-01,
        0.4856954694207845e+00,
        0.1451444200099929e-01,
        0.5175484724211766e+00,
        0.1492644572980292e-01,
        0.5522503690808819e+00,
        0.1541651122328756e-01,
        0.5934874290489524e+00,
        0.4788707289765767e-02,
        0.6563722805402352e-02,
        0.2502230585699310e-01,
        0.7912416503013329e-02,
        0.9669512238638367e-01,
        0.8956313102014822e-02,
        0.1698239427218661e+00,
        0.9781969024648538e-02,
        0.2354985079518828e+00,
        0.1044851744036037e-01,
        0.2925601105800896e+00,
        0.1099693219507985e-01,
        0.3418012690877302e+00,
        0.1145659208699840e-01,
        0.3844521174650939e+00,
        0.1184970544276362e-01,
        0.4217763245489749e+00,
        0.1219446847463953e-01,
        0.4550117593290032e+00,
        0.1250758855429112e-01,
        0.4854408050495134e+00,
        0.1280655793511545e-01,
        0.5145268041703330e+00,
        0.1311180392585363e-01,
        0.5440941264902900e+00,
        0.1344843304771755e-01,
        0.5765229845165943e+00,
        0.1384655622092475e-01,
        0.6148795064211108e+00,
        0.4269409473142479e-02,
        0.5853691221954542e-02,
        0.2506818803768801e-01,
        0.7058488452666192e-02,
        0.9692609816181726e-01,
        0.7991811416685026e-02,
        0.1703157380843560e+00,
        0.8730579305889177e-02,
        0.2362853743226745e+00,
        0.9327287399213484e-02,
        0.2936438651173445e+00,
        0.9818197983040463e-02,
        0.3431514772416978e+00,
        0.1022909697576184e-01,
        0.3859958359229893e+00,
        0.1057909230023007e-01,
        0.4233725763238417e+00,
        0.1088320687501712e-01,
        0.4564025740290915e+00,
        0.1115430586715170e-01,
        0.4861671131891395e+00,
        0.1140470198717317e-01,
        0.5137949407970326e+00,
        0.1164762828827466e-01,
        0.5405812657784165e+00,
        0.1189859698528282e-01,
        0.5681279106485080e+00,
        0.1217639078124160e-01,
        0.5984802463148428e+00,
        0.1250297795297910e-01,
        0.6341959825388761e+00,
        0.3830262680422776e-02,
        0.5252924239469980e-02,
        0.2510718258012232e-01,
        0.6335607341496969e-02,
        0.9712300411103620e-01,
        0.7174964200736387e-02,
        0.1707366515477548e+00,
        0.7839821469171156e-02,
        0.2369623770049865e+00,
        0.8377122084280812e-02,
        0.2945833847967025e+00,
        0.8819233466500510e-02,
        0.3443363340392364e+00,
        0.9189060633588098e-02,
        0.3873807210303031e+00,
        0.9503378800566590e-02,
        0.4248706039873364e+00,
        0.9775047051845269e-02,
        0.4578585641947919e+00,
        0.1001457306569686e-01,
        0.4873111192988822e+00,
        0.1023132837651919e-01,
        0.5141675256404127e+00,
        0.1043459649534057e-01,
        0.5394214279393358e+00,
        0.1063454146082206e-01,
        0.5642188354052674e+00,
        0.1084307018096031e-01,
        0.5899649430016252e+00,
        0.1107438039614643e-01,
        0.6184184090843611e+00,
        0.1134470195438803e-01,
        0.6517206797990772e+00,
        0.3454097785831183e-02,
        0.4738087690909603e-02,
        0.2514098616718916e-01,
        0.5715864568881495e-02,
        0.9729414530950285e-01,
        0.6474399737140852e-02,
        0.1711037123670141e+00,
        0.7075625560198937e-02,
        0.2375553213635903e+00,
        0.7561765789488958e-02,
        0.2954111541648083e+00,
        0.7961900378019848e-02,
        0.3453896252983967e+00,
        0.8296546652001753e-02,
        0.3886303020948080e+00,
        0.8580623356383655e-02,
        0.4262600339398994e+00,
        0.8825386359541219e-02,
        0.4592889162561250e+00,
        0.9039751450513938e-02,
        0.4886139630455138e+00,
        0.9231266796183848e-02,
        0.5150610315193943e+00,
        0.9406897826583457e-02,
        0.5394434170928742e+00,
        0.9573720059444631e-02,
        0.5626311157802961e+00,
        0.9739556257960886e-02,
        0.5856281920506604e+00,
        0.9913518363761172e-02,
        0.6096518917386764e+00,
        0.1010629643624125e-01,
        0.6361953557375821e+00,
        0.1032986385558493e-01,
        0.6670333276830246e+00,
        0.3131660281084644e-02,
        0.4296601495430642e-02,
        0.2516987418923732e-01,
        0.5184210888756367e-02,
        0.9744072529384443e-01,
        0.5873198129887241e-02,
        0.1714189769006723e+00,
        0.6419613566950146e-02,
        0.2380664100570842e+00,
        0.6861660893085171e-02,
        0.2961280333876439e+00,
        0.7225632384805198e-02,
        0.3463080420218410e+00,
        0.7530044942257158e-02,
        0.3897316580976775e+00,
        0.7788304877568383e-02,
        0.4275077537500284e+00,
        0.8010430934156830e-02,
        0.4606200718057599e+00,
        0.8204207591967734e-02,
        0.4899241115804965e+00,
        0.8376002129523446e-02,
        0.5161793704075401e+00,
        0.8531389917004647e-02,
        0.5400945718660145e+00,
        0.8675676859844067e-02,
        0.5623795630774431e+00,
        0.8814368379677447e-02,
        0.5838024839647016e+00,
        0.8953595816500299e-02,
        0.6052506199023559e+00,
        0.9100459154569437e-02,
        0.6277890216584121e+00,
        0.9263166205736671e-02,
        0.6527013571399886e+00,
        0.9450740555370751e-02,
        0.6814810379908328e+00,
        0.2843902743022214e-02,
        0.3902467368190393e-02,
        0.2519598783827689e-01,
        0.4709429895823432e-02,
        0.9757348323445656e-01,
        0.5336152661315786e-02,
        0.1717052034351406e+00,
        0.5833455676281756e-02,
        0.2385318286257855e+00,
        0.6235971415149352e-02,
        0.2967834040784211e+00,
        0.6567522559559145e-02,
        0.3471521575495951e+00,
        0.6844866528765064e-02,
        0.3907519751170857e+00,
        0.7080101687099548e-02,
        0.4286785748173565e+00,
        0.7282213357366904e-02,
        0.4618976089399920e+00,
        0.7458094741776693e-02,
        0.4912372216070018e+00,
        0.7613251892383208e-02,
        0.5174141871126332e+00,
        0.7752321382046524e-02,
        0.5410706897885087e+00,
        0.7879480568321315e-02,
        0.5628149979263304e+00,
        0.7998799282231232e-02,
        0.5832647350414633e+00,
        0.8114557939046675e-02,
        0.6030926481771959e+00,
        0.8231531848213922e-02,
        0.6230734887604330e+00,
        0.8355206753895567e-02,
        0.6441267697250795e+00,
        0.8491839744291131e-02,
        0.6673428282976036e+00,
        0.8648214015485162e-02,
        0.6939680907913989e+00,
        0.2388386682754135e-02,
        0.3278278227000989e-02,
        0.2523707236937346e-01,
        0.3957198838737114e-02,
        0.9778285117940603e-01,
        0.4484932501394734e-02,
        0.1721579526332683e+00,
        0.4904057483051761e-02,
        0.2392707453970052e+00,
        0.5243583901636578e-02,
        0.2978287368553751e+00,
        0.5523456007427060e-02,
        0.3485067686781220e+00,
        0.5757685183723855e-02,
        0.3924033610212076e+00,
        0.5956358204781419e-02,
        0.4305980352749587e+00,
        0.6126919713095007e-02,
        0.4640361265644109e+00,
        0.6275007901630985e-02,
        0.4935170207127558e+00,
        0.6405016526854853e-02,
        0.5197143572851120e+00,
        0.6520488779186820e-02,
        0.5432046533152863e+00,
        0.6624408123666273e-02,
        0.5644970257796814e+00,
        0.6719427053538581e-02,
        0.5840623664365776e+00,
        0.6808059512718916e-02,
        0.6023621974962409e+00,
        0.6892851836922015e-02,
        0.6198777517486085e+00,
        0.6976537015760206e-02,
        0.6371392310474401e+00,
        0.7062164945929763e-02,
        0.6547536993606798e+00,
        0.7153184521396811e-02,
        0.6734273362784953e+00,
        0.7253430606435754e-02,
        0.6939734212185117e+00,
        0.7366943161281851e-02,
        0.7172914790760468e+00,
        0.2034217998243191e-02,
        0.2792734020582961e-02,
        0.2526908982706098e-01,
        0.3371787305020115e-02,
        0.9794643062684199e-01,
        0.3822201062511950e-02,
        0.1725128108619325e+00,
        0.4180174912236582e-02,
        0.2398521447789659e+00,
        0.4470370456915701e-02,
        0.2986551495007976e+00,
        0.4709737539597480e-02,
        0.3495841277608567e+00,
        0.4910176531706057e-02,
        0.3937272155460690e+00,
        0.5080243210917943e-02,
        0.4321540636611387e+00,
        0.5226234784652425e-02,
        0.4657990145921906e+00,
        0.5352893648837146e-02,
        0.4954473934553277e+00,
        0.5463875356202293e-02,
        0.5217531788617480e+00,
        0.5562069670587001e-02,
        0.5452642338468077e+00,
        0.5649829175907964e-02,
        0.5664474938420431e+00,
        0.5729139522573558e-02,
        0.5857122023051498e+00,
        0.5801753106324432e-02,
        0.6034312542567038e+00,
        0.5869300229750696e-02,
        0.6199612865321288e+00,
        0.5933386406539511e-02,
        0.6356621535317655e+00,
        0.5995679940966749e-02,
        0.6509160921778130e+00,
        0.6057989063542723e-02,
        0.6661462081376089e+00,
        0.6122321685397079e-02,
        0.6818327797828450e+00,
        0.6190912476732130e-02,
        0.6985240974244095e+00,
        0.6266191569573649e-02,
        0.7168360261395987e+00,
        0.6350658968555684e-02,
        0.7374314365934664e+00,
        0.1753390300533029e-02,
        0.2407592405123618e-02,
        0.2529453985226700e-01,
        0.2907262330175829e-02,
        0.9807671703676038e-01,
        0.3296143053353250e-02,
        0.1727961462451250e+00,
        0.3605393786629613e-02,
        0.2403177529025610e+00,
        0.3856241133152162e-02,
        0.2993193629853389e+00,
        0.4063271707574896e-02,
        0.3504538499243808e+00,
        0.4236723270781009e-02,
        0.3948018542411614e+00,
        0.4383951358482999e-02,
        0.4334263916612830e+00,
        0.4510362519918408e-02,
        0.4672550951343391e+00,
        0.4620017586359210e-02,
        0.4970655128750277e+00,
        0.4716030788908096e-02,
        0.5235015776135139e+00,
        0.4800840911719355e-02,
        0.5470972903869747e+00,
        0.4876401000932111e-02,
        0.5682998788764699e+00,
        0.4944315587632199e-02,
        0.5874903820382004e+00,
        0.5005943872710219e-02,
        0.6050015924522462e+00,
        0.5062480886612362e-02,
        0.6211339094140743e+00,
        0.5115024538196171e-02,
        0.6361697673414449e+00,
        0.5164633649628788e-02,
        0.6503872077614197e+00,
        0.5212379842880342e-02,
        0.6640729475349860e+00,
        0.5259393975018879e-02,
        0.6775349550821846e+00,
        0.5306905271212799e-02,
        0.6911140242391297e+00,
        0.5356268008877997e-02,
        0.7051930501274516e+00,
        0.5408966392479879e-02,
        0.7202015894622125e+00,
        0.5466583459521371e-02,
        0.7366118374462400e+00,
        0.5530715851949468e-02,
        0.7549206082556241e+00,
        0.1526985597447617e-02,
        0.2096996473761840e-02,
        0.2531509673360445e-01,
        0.2532539440756325e-02,
        0.9818212210216928e-01,
        0.2871665019548934e-02,
        0.1730258242612469e+00,
        0.3141479576178890e-02,
        0.2406960805778798e+00,
        0.3360448272795954e-02,
        0.2998605891705305e+00,
        0.3541258850863859e-02,
        0.3511649206182530e+00,
        0.3692814597959592e-02,
        0.3956840637564039e+00,
        0.3821509918296340e-02,
        0.4344762665775814e+00,
        0.3932041593754749e-02,
        0.4684646795111045e+00,
        0.4027932600409154e-02,
        0.4984220865031195e+00,
        0.4111877834418150e-02,
        0.5249867454711314e+00,
        0.4185977901331621e-02,
        0.5486853051737176e+00,
        0.4251901290680174e-02,
        0.5699549871771356e+00,
        0.4310999960360177e-02,
        0.5891629130044663e+00,
        0.4364394207792517e-02,
        0.6066224358437886e+00,
        0.4413037135908646e-02,
        0.6226069634301489e+00,
        0.4457765549253931e-02,
        0.6373618910220726e+00,
        0.4499341872619412e-02,
        0.6511152177198366e+00,
        0.4538490146036315e-02,
        0.6640873078294923e+00,
        0.4575927973865173e-02,
        0.6765001110571239e+00,
        0.4612395244609121e-02,
        0.6885859633887566e+00,
        0.4648679290544145e-02,
        0.7005958269983906e+00,
        0.4685634750981115e-02,
        0.7128064532627977e+00,
        0.4724194620734037e-02,
        0.7255254273702650e+00,
        0.4765366815800576e-02,
        0.7390923556807402e+00,
        0.4810208361466176e-02,
        0.7538736313498631e+00,
        0.4859767798035730e-02,
        0.7702474410767316e+00,
        0.1341778429126211e-02,
        0.1842856050972565e-02,
        0.2533193854590164e-01,
        0.2225855496752996e-02,
        0.9826859006407132e-01,
        0.2524180832845478e-02,
        0.1732145392603280e+00,
        0.2761629971248482e-02,
        0.2410075282122661e+00,
        0.2954414092304398e-02,
        0.3003071440620802e+00,
        0.3113671483601745e-02,
        0.3517531700231469e+00,
        0.3247217194092525e-02,
        0.3964161974860505e+00,
        0.3360662822142730e-02,
        0.4353508843394245e+00,
        0.3458128531982532e-02,
        0.4694771791546352e+00,
        0.3542702530515273e-02,
        0.4995646943102908e+00,
        0.3616743969933074e-02,
        0.5262481851213445e+00,
        0.3682087306007793e-02,
        0.5500500545141821e+00,
        0.3740183451080423e-02,
        0.5714020312900166e+00,
        0.3792199619292558e-02,
        0.5906638632386166e+00,
        0.3839091722399387e-02,
        0.6081388453953844e+00,
        0.3881658284331042e-02,
        0.6240866310409383e+00,
        0.3920581807177477e-02,
        0.6387339085746301e+00,
        0.3956461592009382e-02,
        0.6522834922619609e+00,
        0.3989840752967416e-02,
        0.6649222876852415e+00,
        0.4021229291927125e-02,
        0.6768284931080795e+00,
        0.4051124448454234e-02,
        0.6881782931898644e+00,
        0.4080028981647300e-02,
        0.6991521843388895e+00,
        0.4108467479283411e-02,
        0.7099409264259735e+00,
        0.4137000143073717e-02,
        0.7207509236661780e+00,
        0.4166232701476242e-02,
        0.7318085765567045e+00,
        0.4196820124371787e-02,
        0.7433628001322098e+00,
        0.4229460707743591e-02,
        0.7556844737332599e+00,
        0.4264876064174216e-02,
        0.7690611204503529e+00,
        0.4303772042593957e-02,
        0.7837847386079905e+00,
        0.1121314683543782e-02,
        0.1540263996358294e-02,
        0.2535201582246297e-01,
        0.1860616782749459e-02,
        0.9837180081070001e-01,
        0.2110257847461394e-02,
        0.1734401492675452e+00,
        0.2309054725495130e-02,
        0.2413805649139678e+00,
        0.2470541128098822e-02,
        0.3008431837086572e+00,
        0.2604015187479208e-02,
        0.3524611103987945e+00,
        0.2716000109093522e-02,
        0.3972999402435936e+00,
        0.2811178999641960e-02,
        0.4364103598053284e+00,
        0.2892989192294541e-02,
        0.4707089285552096e+00,
        0.2964005631609554e-02,
        0.5009621096861159e+00,
        0.3026193412069002e-02,
        0.5278014394899639e+00,
        0.3081077890619739e-02,
        0.5517457095527168e+00,
        0.3129861843706196e-02,
        0.5732222749918362e+00,
        0.3173507910562157e-02,
        0.5925852995229407e+00,
        0.3212797846468413e-02,
        0.6101307283827272e+00,
        0.3248376022424070e-02,
        0.6261084073494506e+00,
        0.3280782072682338e-02,
        0.6407319017471913e+00,
        0.3310475987498136e-02,
        0.6541865362303725e+00,
        0.3337857911967330e-02,
        0.6666360953708608e+00,
        0.3363284226199348e-02,
        0.6782285398626227e+00,
        0.3387081014309363e-02,
        0.6891010163282705e+00,
        0.3409555695216232e-02,
        0.6993843710724037e+00,
        0.3431007330102873e-02,
        0.7092073156356478e+00,
        0.3451735898380667e-02,
        0.7187003283870178e+00,
        0.3472050613465582e-02,
        0.7279993040305766e+00,
        0.3492277104239913e-02,
        0.7372488732478574e+00,
        0.3512762995683089e-02,
        0.7466051990304045e+00,
        0.3533881070388274e-02,
        0.7562379075535515e+00,
        0.3556028788751684e-02,
        0.7663306282943305e+00,
        0.3579622533335547e-02,
        0.7770794116956159e+00,
        0.3605084625764653e-02,
        0.7886880974410957e+00,
        0.3632821128406038e-02,
        0.8013595930224617e+00,
        0.9510596127542824e-03,
        0.1306530384822369e-02,
        0.2536754145655561e-01,
        0.1578428318009605e-02,
        0.9845171104183325e-01,
        0.1790384464545768e-02,
        0.1736150904003335e+00,
        0.1959236797520781e-02,
        0.2416703438788951e+00,
        0.2096455322227467e-02,
        0.3012604613663233e+00,
        0.2209920074417597e-02,
        0.3530135437139923e+00,
        0.2305159021830049e-02,
        0.3979914926982783e+00,
        0.2386140355447109e-02,
        0.4372421218440167e+00,
        0.2455776174573485e-02,
        0.4716796241323911e+00,
        0.2516247355295036e-02,
        0.5020683797660233e+00,
        0.2569217475366734e-02,
        0.5290379452961959e+00,
        0.2615976824974766e-02,
        0.5531050686294569e+00,
        0.2657541470416690e-02,
        0.5746948225947125e+00,
        0.2694722818617351e-02,
        0.5941586518170510e+00,
        0.2728177434091533e-02,
        0.6117891098846177e+00,
        0.2758443393525188e-02,
        0.6278316916720729e+00,
        0.2785967312803683e-02,
        0.6424943013679313e+00,
        0.2811124820961013e-02,
        0.6559548636293389e+00,
        0.2834236378150614e-02,
        0.6683675049794192e+00,
        0.2855579757979202e-02,
        0.6798676490616872e+00,
        0.2875400127857228e-02,
        0.6905762965442401e+00,
        0.2893918395849096e-02,
        0.7006037006910071e+00,
        0.2911338305155523e-02,
        0.7100526010841707e+00,
        0.2927852618951001e-02,
        0.7190211375279999e+00,
        0.2943648628770056e-02,
        0.7276055302511653e+00,
        0.2958913124102285e-02,
        0.7359025774945679e+00,
        0.2973836867449520e-02,
        0.7440119836573593e+00,
        0.2988618517881438e-02,
        0.7520384865047949e+00,
        0.3003467829003067e-02,
        0.7600936967329708e+00,
        0.3018607809042993e-02,
        0.7682974943112553e+00,
        0.3034275371809675e-02,
        0.7767787422315526e+00,
        0.3050719837809893e-02,
        0.7856749823571740e+00,
        0.3068198491381527e-02,
        0.7951306800776951e+00,
        0.3086968312155531e-02,
        0.8052935061547398e+00,
        0.3107273055760290e-02,
        0.8163081231039382e+00,
        0.8168405299925574e-03,
        0.1122235164426433e-02,
        0.2537979319269659e-01,
        0.1355887567479481e-02,
        0.9851483086228864e-01,
        0.1538080541563495e-02,
        0.1737534362414166e+00,
        0.1683267147792567e-02,
        0.2418998259562802e+00,
        0.1801292850812278e-02,
        0.3015914511597799e+00,
        0.1898921476480742e-02,
        0.3534525616677698e+00,
        0.1980897763334222e-02,
        0.3985422441814719e+00,
        0.2050627450222160e-02,
        0.4379061538920372e+00,
        0.2110609627253456e-02,
        0.4724567457971343e+00,
        0.2162715579344156e-02,
        0.5029569229728563e+00,
        0.2208372378885260e-02,
        0.5300349067999921e+00,
        0.2248686443403842e-02,
        0.5542061521610998e+00,
        0.2284528486070424e-02,
        0.5758943864439198e+00,
        0.2316593115008434e-02,
        0.5954495572468082e+00,
        0.2345441446771229e-02,
        0.6131624579583983e+00,
        0.2371532122833287e-02,
        0.6292764292152166e+00,
        0.2395244271202193e-02,
        0.6439966702794445e+00,
        0.2416894786788224e-02,
        0.6574976613071741e+00,
        0.2436751550587987e-02,
        0.6699291171394233e+00,
        0.2455043712749272e-02,
        0.6814208098492533e+00,
        0.2471969833678045e-02,
        0.6920865249452547e+00,
        0.2487704452255031e-02,
        0.7020273575786585e+00,
        0.2502403494283208e-02,
        0.7113345090150194e+00,
        0.2516208823898241e-02,
        0.7200917075437527e+00,
        0.2529252160257252e-02,
        0.7283773493344920e+00,
        0.2541658520726186e-02,
        0.7362664311381890e+00,
        0.2553549302394987e-02,
        0.7438323260356781e+00,
        0.2565045070295341e-02,
        0.7511484336838515e+00,
        0.2576268078538789e-02,
        0.7582897158118264e+00,
        0.2587344505847411e-02,
        0.7653341042347025e+00,
        0.2598406336420720e-02,
        0.7723637406308460e+00,
        0.2609592758562768e-02,
        0.7794659733020046e+00,
        0.2621050886496552e-02,
        0.7867339953288847e+00,
        0.2632935537833889e-02,
        0.7942669615898086e+00,
        0.2645407727623461e-02,
        0.8021693721981406e+00,
        0.2658631484279102e-02,
        0.8105494642340256e+00,
        0.2672768576741324e-02,
        0.8195163250963701e+00,
        0.2687970799566830e-02,
        0.8291754492311013e+00,
        0.6779619032019482e-03,
        0.9315109162316307e-03,
        0.2539248163813982e-01,
        0.1125546650705646e-02,
        0.9858025661395591e-01,
        0.1276892135791717e-02,
        0.1738969874989156e+00,
        0.1397535825902466e-02,
        0.2421382412064102e+00,
        0.1495644371531161e-02,
        0.3019358267641449e+00,
        0.1576828175558173e-02,
        0.3539100964089328e+00,
        0.1645022736116236e-02,
        0.3991173116956755e+00,
        0.1703052777188943e-02,
        0.4386009869035954e+00,
        0.1752990885928625e-02,
        0.4732718824089663e+00,
        0.1796388809395077e-02,
        0.5038914977622926e+00,
        0.1834429731186084e-02,
        0.5310868327976426e+00,
        0.1868030737964622e-02,
        0.5553722186397624e+00,
        0.1897913248880432e-02,
        0.5771702844407484e+00,
        0.1924652401977583e-02,
        0.5968298361224380e+00,
        0.1948712334483372e-02,
        0.6146404100545767e+00,
        0.1970471824369135e-02,
        0.6308438946964407e+00,
        0.1990243228225435e-02,
        0.6456437499005518e+00,
        0.2008286680798674e-02,
        0.6592123207734590e+00,
        0.2024820896049421e-02,
        0.6716966627198852e+00,
        0.2040031498715453e-02,
        0.6832232108862492e+00,
        0.2054077540780530e-02,
        0.6939015548982263e+00,
        0.2067096670752565e-02,
        0.7038275213823140e+00,
        0.2079209295013150e-02,
        0.7130857211033993e+00,
        0.2090521980414542e-02,
        0.7217516823653617e+00,
        0.2101130283221459e-02,
        0.7298936653027928e+00,
        0.2111121143106236e-02,
        0.7375742308368269e+00,
        0.2120574946574002e-02,
        0.7448516217331510e+00,
        0.2129567338002603e-02,
        0.7517810000528958e+00,
        0.2138170835613056e-02,
        0.7584155742314791e+00,
        0.2146456292026427e-02,
        0.7648076391248480e+00,
        0.2154494222946041e-02,
        0.7710095427995872e+00,
        0.2162356011555635e-02,
        0.7770745838488886e+00,
        0.2170114979286494e-02,
        0.7830578318730199e+00,
        0.2177847294739602e-02,
        0.7890168508176265e+00,
        0.2185632671118797e-02,
        0.7950122895929717e+00,
        0.2193554778405604e-02,
        0.8011082865424130e+00,
        0.2201701270375675e-02,
        0.8073726141153927e+00,
        0.2210163300386258e-02,
        0.8138764685711868e+00,
        0.2219034377453016e-02,
        0.8206937889887615e+00,
        0.2228408401671311e-02,
        0.8278999743285053e+00,
        0.2238376724427438e-02,
        0.8355698630075664e+00,
        0.2249024115421597e-02,
        0.8437748549346639e+00,
        0.5717171765067005e-03,
        0.7855819755678591e-03,
        0.2540219552841172e-01,
        0.9492803029534314e-03,
        0.9863038311884588e-01,
        0.1076991591417719e-02,
        0.1740070746137774e+00,
        0.1178820912278011e-02,
        0.2423212835361945e+00,
        0.1261652009696089e-02,
        0.3022005646620261e+00,
        0.1330213911048136e-02,
        0.3542623490383656e+00,
        0.1387823796651901e-02,
        0.3995607968545022e+00,
        0.1436862514566579e-02,
        0.4391378457027524e+00,
        0.1479076886266864e-02,
        0.4739030248719332e+00,
        0.1515774672793500e-02,
        0.5046168340722528e+00,
        0.1547952929687645e-02,
        0.5319054272436042e+00,
        0.1576384371750672e-02,
        0.5562823875920914e+00,
        0.1601676728454795e-02,
        0.5781696502895681e+00,
        0.1624314356699193e-02,
        0.5979153431712045e+00,
        0.1644687957566232e-02,
        0.6158083043507766e+00,
        0.1663116161966728e-02,
        0.6320896668598296e+00,
        0.1679861458243818e-02,
        0.6469620376959935e+00,
        0.1695142117261203e-02,
        0.6605967661879515e+00,
        0.1709141243106296e-02,
        0.6731397164733577e+00,
        0.1722013731055875e-02,
        0.6847158755342791e+00,
        0.1733891682879084e-02,
        0.6954330559199739e+00,
        0.1744888672268816e-02,
        0.7053848938737558e+00,
        0.1755103144742999e-02,
        0.7146532979347533e+00,
        0.1764621160512043e-02,
        0.7233104679728801e+00,
        0.1773518635044922e-02,
        0.7314205777797613e+00,
        0.1781863193450182e-02,
        0.7390411938444027e+00,
        0.1789715726676655e-02,
        0.7462244872361469e+00,
        0.1797131716770826e-02,
        0.7530182833863068e+00,
        0.1804162382812431e-02,
        0.7594669850655551e+00,
        0.1810855687135456e-02,
        0.7656123962667175e+00,
        0.1817257231900906e-02,
        0.7714944684438817e+00,
        0.1823411068174413e-02,
        0.7771519851570839e+00,
        0.1829360432715894e-02,
        0.7826231962275617e+00,
        0.1835148421173907e-02,
        0.7879464076688663e+00,
        0.1840818599844342e-02,
        0.7931605286026111e+00,
        0.1846415551221751e-02,
        0.7983055707993119e+00,
        0.1851985340937259e-02,
        0.8034230901440029e+00,
        0.1857575885138658e-02,
        0.8085565520117598e+00,
        0.1863237187886467e-02,
        0.8137515941551513e+00,
        0.1869021407926604e-02,
        0.8190561513413812e+00,
        0.1874982703844713e-02,
        0.8245203960095123e+00,
        0.1881176797227895e-02,
        0.8301964394574721e+00,
        0.1887660186864975e-02,
        0.8361377299185951e+00,
        0.1894488945824785e-02,
        0.8423980794999191e+00,
        0.1901717040890795e-02,
        0.8490302543125971e+00,
        0.1909394134299323e-02,
        0.8560840749607826e+00,
        0.4886273679748824e-03,
        0.6714437954649780e-03,
        0.2540979640585205e-01,
        0.8113983041306847e-03,
        0.9866962915608751e-01,
        0.9206047809355559e-03,
        0.1740933291741878e+00,
        0.1007696615844565e-02,
        0.2424648238198073e+00,
        0.1078555077304152e-02,
        0.3024083787838030e+00,
        0.1137220495111209e-02,
        0.3545391775646764e+00,
        0.1186526928471642e-02,
        0.3999097732746233e+00,
        0.1228508433020824e-02,
        0.4395609067610286e+00,
        0.1264657346363223e-02,
        0.4744011819765317e+00,
        0.1296090864949680e-02,
        0.5051903569581037e+00,
        0.1323660708324793e-02,
        0.5325539695623672e+00,
        0.1348026906055910e-02,
        0.5570050719753680e+00,
        0.1369708506508536e-02,
        0.5789651232823036e+00,
        0.1389119124621932e-02,
        0.5987818060211025e+00,
        0.1406592323781286e-02,
        0.6167435227777786e+00,
        0.1422400048200691e-02,
        0.6330909609625438e+00,
        0.1436766218460017e-02,
        0.6480262517065541e+00,
        0.1449876904280157e-02,
        0.6617202166442876e+00,
        0.1461888037961801e-02,
        0.6743181164063009e+00,
        0.1472931335824075e-02,
        0.6859442313853145e+00,
        0.1483118897071317e-02,
        0.6967055330639804e+00,
        0.1492546815085222e-02,
        0.7066946457906411e+00,
        0.1501298043441827e-02,
        0.7159922532405723e+00,
        0.1509444694127518e-02,
        0.7246690686840157e+00,
        0.1517049899494373e-02,
        0.7327874613555573e+00,
        0.1524169336541220e-02,
        0.7404028107621932e+00,
        0.1530852488184009e-02,
        0.7475646451451914e+00,
        0.1537143698611175e-02,
        0.7543176083360913e+00,
        0.1543083066767105e-02,
        0.7607022900146448e+00,
        0.1548707212186899e-02,
        0.7667559471993193e+00,
        0.1554049939909855e-02,
        0.7725131391565733e+00,
        0.1559142825373070e-02,
        0.7780062934020589e+00,
        0.1564015735548671e-02,
        0.7832662167717693e+00,
        0.1568697298775154e-02,
        0.7883225624132202e+00,
        0.1573215332462839e-02,
        0.7932042607791593e+00,
        0.1577597234898074e-02,
        0.7979399201221365e+00,
        0.1581870344542036e-02,
        0.8025581994310868e+00,
        0.1586062267357487e-02,
        0.8070881540792818e+00,
        0.1590201169665478e-02,
        0.8115595515386726e+00,
        0.1594316030726550e-02,
        0.8160031512482756e+00,
        0.1598436845587962e-02,
        0.8204509390209540e+00,
        0.1602594764727253e-02,
        0.8249363021965111e+00,
        0.1606822152724702e-02,
        0.8294941271358440e+00,
        0.1611152543807615e-02,
        0.8341607957498925e+00,
        0.1615620467991531e-02,
        0.8389740528796195e+00,
        0.1620261118280227e-02,
        0.8439727120207893e+00,
        0.1625109827821845e-02,
        0.8491961639288420e+00,
        0.1630201327174513e-02,
        0.8546836521716283e+00,
        0.1635568757273152e-02,
        0.8604732831634605e+00,
        0.1641242424784281e-02,
        0.8666007472872529e+00,
        0.4079721290191449e-03,
        0.5606390646000299e-03,
        0.2541717774246925e-01,
        0.6775302011759068e-03,
        0.9870776119617667e-01,
        0.7687559860220674e-03,
        0.1741771883435951e+00,
        0.8415222726271052e-03,
        0.2426044825025154e+00,
        0.9007379123407699e-03,
        0.3026107489587744e+00,
        0.9497751982407300e-03,
        0.3548090209828054e+00,
        0.9909995793709382e-03,
        0.4002503224647114e+00,
        0.1026108754684635e-02,
        0.4399742629913482e+00,
        0.1056348256439421e-02,
        0.4748885789654610e+00,
        0.1082650488031221e-02,
        0.5057523403210778e+00,
        0.1105726258156915e-02,
        0.5331905211809378e+00,
        0.1126126368448291e-02,
        0.5577156967903346e+00,
        0.1144283937532252e-02,
        0.5797489091761477e+00,
        0.1160544069671673e-02,
        0.5996374632935472e+00,
        0.1175185037186027e-02,
        0.6176694070801912e+00,
        0.1188433661215005e-02,
        0.6340850818085325e+00,
        0.1200476654074482e-02,
        0.6490862674574624e+00,
        0.1211469103358439e-02,
        0.6628434159685319e+00,
        0.1221540901759423e-02,
        0.6755013855037041e+00,
        0.1230801679415364e-02,
        0.6871840056733981e+00,
        0.1239344630375328e-02,
        0.6979977314932807e+00,
        0.1247249512545108e-02,
        0.7080345854591738e+00,
        0.1254585023077141e-02,
        0.7173745414939689e+00,
        0.1261410697040181e-02,
        0.7260874694062653e+00,
        0.1267778438847666e-02,
        0.7342347316708526e+00,
        0.1273733768408534e-02,
        0.7418705038821782e+00,
        0.1279316843997812e-02,
        0.7490428746151535e+00,
        0.1284563309197927e-02,
        0.7557947684726961e+00,
        0.1289505000406732e-02,
        0.7621647269098429e+00,
        0.1294170543282941e-02,
        0.7681875743244604e+00,
        0.1298585860357731e-02,
        0.7738949913863433e+00,
        0.1302774607351322e-02,
        0.7793160132569095e+00,
        0.1306758552112867e-02,
        0.7844774669407445e+00,
        0.1310557907271291e-02,
        0.7894043592864977e+00,
        0.1314191625436819e-02,
        0.7941202249469652e+00,
        0.1317677663971441e-02,
        0.7986474417822638e+00,
        0.1321033224831176e-02,
        0.8030075196380616e+00,
        0.1324274973678666e-02,
        0.8072213670641986e+00,
        0.1327419241294216e-02,
        0.8113095392825265e+00,
        0.1330482209212664e-02,
        0.8152924695008139e+00,
        0.1333480080427699e-02,
        0.8191906844434980e+00,
        0.1336429234887632e-02,
        0.8230250036771799e+00,
        0.1339346368318267e-02,
        0.8268167209024656e+00,
        0.1342248611619848e-02,
        0.8305877638256554e+00,
        0.1345153626679458e-02,
        0.8343608274878259e+00,
        0.1348079672919514e-02,
        0.8381594740079385e+00,
        0.1351045637295423e-02,
        0.8420081896122813e+00,
        0.1354071018825960e-02,
        0.8459323876377299e+00,
        0.1357175857202399e-02,
        0.8499583440311814e+00,
        0.1360380593752449e-02,
        0.8541130499173916e+00,
        0.1363705852281417e-02,
        0.8584239643605064e+00,
        0.1367172127403134e-02,
        0.8629186498951948e+00,
        0.1370799369307807e-02,
        0.8676242742545543e+00,
        0.1374606456942832e-02,
        0.8725669645681554e+00,
        0.1378610556753209e-02,
        0.8777710057814074e+00,
        0.3457584334322357e-03,
        0.4751621453940012e-03,
        0.2542287327621289e-01,
        0.5742529802903852e-03,
        0.9873719754448177e-01,
        0.6515970827455522e-03,
        0.1742419598034706e+00,
        0.7132998513406398e-03,
        0.2427124231693788e+00,
        0.7635205129753468e-03,
        0.3027672771691929e+00,
        0.8051163841037499e-03,
        0.3550179179580828e+00,
        0.8400916805185935e-03,
        0.4005142108161735e+00,
        0.8698848276663640e-03,
        0.4402949133244795e+00,
        0.8955511242402197e-03,
        0.4752671131865228e+00,
        0.9178805496049455e-03,
        0.5061893703422927e+00,
        0.9374753213346000e-03,
        0.5336862457066851e+00,
        0.9548020787478288e-03,
        0.5582699698916923e+00,
        0.9702277440292999e-03,
        0.5803612891309488e+00,
        0.9840446600062942e-03,
        0.6003072470093884e+00,
        0.9964885371329648e-03,
        0.6183956534407280e+00,
        0.1007751484296832e-02,
        0.6348666260010463e+00,
        0.1017991617422186e-02,
        0.6499217274752063e+00,
        0.1027340245776507e-02,
        0.6637311918729225e+00,
        0.1035907317136567e-02,
        0.6764396515818053e+00,
        0.1043785593537480e-02,
        0.6881706952754520e+00,
        0.1051053889330778e-02,
        0.6990305140455065e+00,
        0.1057779608173888e-02,
        0.7091108348943870e+00,
        0.1064020749985821e-02,
        0.7184912951109098e+00,
        0.1069827513031319e-02,
        0.7272413759474827e+00,
        0.1075243583787733e-02,
        0.7354219871919199e+00,
        0.1080307183927825e-02,
        0.7430867737680106e+00,
        0.1085051926828077e-02,
        0.7502831998805611e+00,
        0.1089507523598374e-02,
        0.7570534542643864e+00,
        0.1093700369430917e-02,
        0.7634352109083323e+00,
        0.1097654034185638e-02,
        0.7694622725315966e+00,
        0.1101389675935647e-02,
        0.7751651185850800e+00,
        0.1104926392241615e-02,
        0.7805713752558724e+00,
        0.1108281520887288e-02,
        0.7857062215827314e+00,
        0.1111470899456480e-02,
        0.7905927431287384e+00,
        0.1114509091294428e-02,
        0.7952522425401743e+00,
        0.1117409583946746e-02,
        0.7997045146224264e+00,
        0.1120184965012693e-02,
        0.8039680921873576e+00,
        0.1122847079414237e-02,
        0.8080604677961332e+00,
        0.1125407171312882e-02,
        0.8119982955768120e+00,
        0.1127876013259072e-02,
        0.8157975764884198e+00,
        0.1130264024599364e-02,
        0.8194738296925913e+00,
        0.1132581380665879e-02,
        0.8230422520462021e+00,
        0.1134838113807109e-02,
        0.8265178671142719e+00,
        0.1137044206868379e-02,
        0.8299156644956935e+00,
        0.1139209679276770e-02,
        0.8332507296316362e+00,
        0.1141344665414018e-02,
        0.8365383636069283e+00,
        0.1143459484459602e-02,
        0.8397941917404019e+00,
        0.1145564700346352e-02,
        0.8430342589770379e+00,
        0.1147671169888255e-02,
        0.8462751092344150e+00,
        0.1149790076517388e-02,
        0.8495338449183082e+00,
        0.1151932946415512e-02,
        0.8528281618190179e+00,
        0.1154111643169411e-02,
        0.8561763535592529e+00,
        0.1156338336456831e-02,
        0.8595972787361906e+00,
        0.1158625439740416e-02,
        0.8631102829627566e+00,
        0.1160985511591647e-02,
        0.8667350672783336e+00,
        0.1163431115191409e-02,
        0.8704914940179440e+00,
        0.1165974630888303e-02,
        0.8743993213928760e+00,
        0.1168628017588916e-02,
        0.8784778589727296e+00,
        0.1171402520361833e-02,
        0.8827455382208639e+00,
        0.1174308324102304e-02,
        0.8872193954732928e+00,
        0.2967633115387107e-03,
        0.4078420646640203e-03,
        0.2542735980046100e-01,
        0.4929083178239419e-03,
        0.9876039342539503e-01,
        0.5593126751285800e-03,
        0.1742930216852869e+00,
        0.6122943067439731e-03,
        0.2427975603509948e+00,
        0.6554223612098552e-03,
        0.3028908101007459e+00,
        0.6911487848386306e-03,
        0.3551828911240184e+00,
        0.7211934487136871e-03,
        0.4007227692617545e+00,
        0.7467906965300383e-03,
        0.4405485438561624e+00,
        0.7688460941907184e-03,
        0.4755668043199200e+00,
        0.7880375248105768e-03,
        0.5065357215285611e+00,
        0.8048817439819273e-03,
        0.5340795437694515e+00,
        0.8197791606092136e-03,
        0.5587102435529917e+00,
        0.8330446107364092e-03,
        0.5808483484024387e+00,
        0.8449289291109885e-03,
        0.6008407117558368e+00,
        0.8556343498905160e-03,
        0.6189749738875788e+00,
        0.8653256884173914e-03,
        0.6354910969728228e+00,
        0.8741385860890042e-03,
        0.6505904974988862e+00,
        0.8821856763681789e-03,
        0.6644432678330569e+00,
        0.8895612564439208e-03,
        0.6771938992957999e+00,
        0.8963448693257790e-03,
        0.6889658361211737e+00,
        0.9026040810144197e-03,
        0.6998651175897177e+00,
        0.9083966557751288e-03,
        0.7099833073204581e+00,
        0.9137722762541778e-03,
        0.7193998631153847e+00,
        0.9187739158093501e-03,
        0.7281840656590849e+00,
        0.9234389425261854e-03,
        0.7363965975579181e+00,
        0.9278000143753827e-03,
        0.7440908437477774e+00,
        0.9318858104408874e-03,
        0.7513139686822109e+00,
        0.9357216324926973e-03,
        0.7581078137561323e+00,
        0.9393299032829178e-03,
        0.7645096492310164e+00,
        0.9427305820375386e-03,
        0.7705528078328676e+00,
        0.9459415131589371e-03,
        0.7762672216898303e+00,
        0.9489787207614479e-03,
        0.7816798799835950e+00,
        0.9518566590593747e-03,
        0.7868152213232364e+00,
        0.9545884266143449e-03,
        0.7916954721972490e+00,
        0.9571859508813780e-03,
        0.7963409407568194e+00,
        0.9596601482630737e-03,
        0.8007702735070883e+00,
        0.9620210639090244e-03,
        0.8050006811385999e+00,
        0.9642779947228965e-03,
        0.8090481386453148e+00,
        0.9664395984170945e-03,
        0.8129275639917815e+00,
        0.9685139909496511e-03,
        0.8166529788658923e+00,
        0.9705088342629528e-03,
        0.8202376544499068e+00,
        0.9724314158979084e-03,
        0.8236942446328719e+00,
        0.9742887217632853e-03,
        0.8270349086491756e+00,
        0.9760875030844708e-03,
        0.8302714247416513e+00,
        0.9778343383275471e-03,
        0.8334152960971942e+00,
        0.9795356906837479e-03,
        0.8364778499742661e+00,
        0.9811979614979323e-03,
        0.8394703306225847e+00,
        0.9828275398255846e-03,
        0.8424039862746810e+00,
        0.9844308480999043e-03,
        0.8452901501569875e+00,
        0.9860143836786285e-03,
        0.8481403151159906e+00,
        0.9875847558152446e-03,
        0.8509662010755018e+00,
        0.9891487173585097e-03,
        0.8537798141289355e+00,
        0.9907131902268242e-03,
        0.8565934956229708e+00,
        0.9922852834316175e-03,
        0.8594199591072303e+00,
        0.9938723021413952e-03,
        0.8622723125149068e+00,
        0.9954817459946895e-03,
        0.8651640624148244e+00,
        0.9971212946004986e-03,
        0.8681090966584658e+00,
        0.9987987779301984e-03,
        0.8711216412695179e+00,
        0.1000522129134342e-02,
        0.8742161870354788e+00,
        0.1002299317248640e-02,
        0.8774073810231204e+00,
        0.1004138257331534e-02,
        0.8807098782305657e+00,
        0.1006046695854091e-02,
        0.8841381489021722e+00,
        0.1008032069698879e-02,
        0.8877062377737649e+00,
        0.1010101337974326e-02,
        0.8914274727949142e+00,
        0.1012260787062656e-02,
        0.8953141227940432e+00,
        0.2505764977838404e-03,
        0.3443770249124342e-03,
        0.2543158995016821e-01,
        0.4162174537078318e-03,
        0.9878227034153308e-01,
        0.4723030362070807e-03,
        0.1743411977575627e+00,
        0.5170566942884504e-03,
        0.2428779209209343e+00,
        0.5534915375556028e-03,
        0.3030074710503266e+00,
        0.5836775268839070e-03,
        0.3553387763770640e+00,
        0.6090665945021940e-03,
        0.4009199654813231e+00,
        0.6307007808156645e-03,
        0.4407885275977928e+00,
        0.6493445644344517e-03,
        0.4758505926393938e+00,
        0.6655702083843857e-03,
        0.5068639748553351e+00,
        0.6798139474548506e-03,
        0.5344526379872747e+00,
        0.6924137931820147e-03,
        0.5591283215877272e+00,
        0.7036355137975163e-03,
        0.5813113577588189e+00,
        0.7136908453729490e-03,
        0.6013484321270596e+00,
        0.7227504933228287e-03,
        0.6195270375256310e+00,
        0.7309535721159746e-03,
        0.6360870035914407e+00,
        0.7384145655048229e-03,
        0.6512296248800408e+00,
        0.7452285316469442e-03,
        0.6651248789020748e+00,
        0.7514750465678792e-03,
        0.6779171461479578e+00,
        0.7572212276838003e-03,
        0.6897297612797826e+00,
        0.7625240776755495e-03,
        0.7006686526246470e+00,
        0.7674323201021287e-03,
        0.7108252688389807e+00,
        0.7719878506216157e-03,
        0.7202789460425201e+00,
        0.7762268944500497e-03,
        0.7290988336445309e+00,
        0.7801809371337034e-03,
        0.7373454702759427e+00,
        0.7838774788105678e-03,
        0.7450720807914899e+00,
        0.7873406498722635e-03,
        0.7523256496919639e+00,
        0.7905917169405165e-03,
        0.7591478143617146e+00,
        0.7936495014053848e-03,
        0.7655756123276436e+00,
        0.7965307277851307e-03,
        0.7716421096510724e+00,
        0.7992503154034614e-03,
        0.7773769320588682e+00,
        0.8018216240149106e-03,
        0.7828067161269425e+00,
        0.8042566618112444e-03,
        0.7879554944635353e+00,
        0.8065662625429530e-03,
        0.7928450261873953e+00,
        0.8087602371674192e-03,
        0.7974950818949961e+00,
        0.8108475043988473e-03,
        0.8019236906381128e+00,
        0.8128362037173276e-03,
        0.8061473550943380e+00,
        0.8147337937451987e-03,
        0.8101812400362133e+00,
        0.8165471383802039e-03,
        0.8140393383338362e+00,
        0.8182825826579203e-03,
        0.8177346180177749e+00,
        0.8199460199784433e-03,
        0.8212791533500792e+00,
        0.8215429520572276e-03,
        0.8246842423744935e+00,
        0.8230785427339746e-03,
        0.8279605130215852e+00,
        0.8245576665860399e-03,
        0.8311180195135344e+00,
        0.8259849531356726e-03,
        0.8341663305331678e+00,
        0.8273648273067869e-03,
        0.8371146103813345e+00,
        0.8287015466714560e-03,
        0.8399716941366764e+00,
        0.8299992359243829e-03,
        0.8427461576444749e+00,
        0.8312619189314546e-03,
        0.8454463829899002e+00,
        0.8324935486128937e-03,
        0.8480806199498299e+00,
        0.8336980348396690e-03,
        0.8506570437613245e+00,
        0.8348792704412902e-03,
        0.8531838093892227e+00,
        0.8360411553417403e-03,
        0.8556691023160556e+00,
        0.8371876187562825e-03,
        0.8581211857109087e+00,
        0.8383226392937222e-03,
        0.8605484436569011e+00,
        0.8394502627153142e-03,
        0.8629594199271572e+00,
        0.8405746170023279e-03,
        0.8653628515950123e+00,
        0.8416999242793960e-03,
        0.8677676965453935e+00,
        0.8428305090311761e-03,
        0.8701831537222023e+00,
        0.8439708019376514e-03,
        0.8726186747045624e+00,
        0.8451253385421383e-03,
        0.8750839649592925e+00,
        0.8462987518610647e-03,
        0.8775889728776909e+00,
        0.8474957579532225e-03,
        0.8801438644857288e+00,
        0.8487211333982720e-03,
        0.8827589815370717e+00,
        0.8499796836021254e-03,
        0.8854447805825755e+00,
        0.8512762008654021e-03,
        0.8882117505884698e+00,
        0.8526154112376473e-03,
        0.8910703067843766e+00,
        0.8540019093532560e-03,
        0.8940306587022231e+00,
        0.8554400807241641e-03,
        0.8971026508610441e+00,
        0.8569340113668948e-03,
        0.9002955753026496e+00,
        0.8584873851806726e-03,
        0.9036179562250074e+00,
        0.2143902298924797e-03,
        0.2946512237154931e-03,
        0.2543490463324859e-01,
        0.3561260688438285e-03,
        0.9879941719514369e-01,
        0.4041230092741482e-03,
        0.1743789695511629e+00,
        0.4424256774627034e-03,
        0.2429409502831179e+00,
        0.4736116853150793e-03,
        0.3030990118950347e+00,
        0.4994518169910726e-03,
        0.3554611561972349e+00,
        0.5211881524129952e-03,
        0.4010748630839990e+00,
        0.5397121201514141e-03,
        0.4409771509224894e+00,
        0.5556777014490634e-03,
        0.4760737966263269e+00,
        0.5695744414699151e-03,
        0.5071223419498457e+00,
        0.5817755161210044e-03,
        0.5347465345706520e+00,
        0.5925700732976313e-03,
        0.5594579384248554e+00,
        0.6021854581155787e-03,
        0.5816767395342153e+00,
        0.6108027921070821e-03,
        0.6017494993293330e+00,
        0.6185680956696988e-03,
        0.6199636028202163e+00,
        0.6256003634582641e-03,
        0.6365587841093024e+00,
        0.6319975186065948e-03,
        0.6517362513852718e+00,
        0.6378408654613904e-03,
        0.6656659024902249e+00,
        0.6431984629598351e-03,
        0.6784920429133774e+00,
        0.6481277109801403e-03,
        0.6903379352397969e+00,
        0.6526773552254315e-03,
        0.7013094370793644e+00,
        0.6568890572555564e-03,
        0.7114979262641195e+00,
        0.6607986356285067e-03,
        0.7209826665497649e+00,
        0.6644370556787454e-03,
        0.7298327319935689e+00,
        0.6678312253083076e-03,
        0.7381085813804109e+00,
        0.6710046397087699e-03,
        0.7458633536247841e+00,
        0.6739779074395309e-03,
        0.7531439394662658e+00,
        0.6767691825904827e-03,
        0.7599918728233108e+00,
        0.6793945220531763e-03,
        0.7664440759826728e+00,
        0.6818681826575195e-03,
        0.7725334857075471e+00,
        0.6842028697103579e-03,
        0.7782895818427216e+00,
        0.6864099460208997e-03,
        0.7837388357016260e+00,
        0.6884996086172708e-03,
        0.7889050921541919e+00,
        0.6904810389048264e-03,
        0.7938098966818099e+00,
        0.6923625308852660e-03,
        0.7984727765644702e+00,
        0.6941516011688034e-03,
        0.8029114836923505e+00,
        0.6958550838122305e-03,
        0.8071422051557240e+00,
        0.6974792124607250e-03,
        0.8111797466910577e+00,
        0.6990296918282764e-03,
        0.8150376931919887e+00,
        0.7005117601960532e-03,
        0.8187285497884573e+00,
        0.7019302443210675e-03,
        0.8222638664221132e+00,
        0.7032896079146326e-03,
        0.8256543483749294e+00,
        0.7045939946601219e-03,
        0.8289099548200989e+00,
        0.7058472665836456e-03,
        0.8320399871433695e+00,
        0.7070530384625938e-03,
        0.8350531685159762e+00,
        0.7082147088500877e-03,
        0.8379577159767848e+00,
        0.7093354882038982e-03,
        0.8407614060927453e+00,
        0.7104184245328271e-03,
        0.8434716351063775e+00,
        0.7114664269090819e-03,
        0.8460954743411380e+00,
        0.7124822871394600e-03,
        0.8486397215154378e+00,
        0.7134686998392874e-03,
        0.8511109485098599e+00,
        0.7144282811093860e-03,
        0.8535155460363737e+00,
        0.7153635859765056e-03,
        0.8558597655701624e+00,
        0.7162771247204472e-03,
        0.8581497588214944e+00,
        0.7171713781754927e-03,
        0.8603916149446070e+00,
        0.7180488120588147e-03,
        0.8625913956007934e+00,
        0.7189118903434776e-03,
        0.8647551679119477e+00,
        0.7197630876577540e-03,
        0.8668890352571068e+00,
        0.7206049006551845e-03,
        0.8689991657766132e+00,
        0.7214398582606628e-03,
        0.8710918183552704e+00,
        0.7222705306565306e-03,
        0.8731733657564531e+00,
        0.7230995368291464e-03,
        0.8752503144732032e+00,
        0.7239295504508160e-03,
        0.8773293207500719e+00,
        0.7247633038248635e-03,
        0.8794172021118196e+00,
        0.7256035895739055e-03,
        0.8815209436139331e+00,
        0.7264532597045066e-03,
        0.8836476979083573e+00,
        0.7273152216374242e-03,
        0.8858047781004107e+00,
        0.7281924307543494e-03,
        0.8879996422658111e+00,
        0.7290878789830281e-03,
        0.8902398684083558e+00,
        0.7300045789273423e-03,
        0.8925331185794968e+00,
        0.7309455430526645e-03,
        0.8948870908635684e+00,
        0.7319137574656844e-03,
        0.8973094579716888e+00,
        0.7329121498886438e-03,
        0.8998077913001904e+00,
        0.7339435515274697e-03,
        0.9023894695138696e+00,
        0.7350106526783481e-03,
        0.9050615710285062e+00,
        0.7361159521134971e-03,
        0.9078307502075817e+00,
        0.7372617005379830e-03,
        0.9107030976677650e+00,
        0.1812712131805553e-03,
        0.2491384321187703e-03,
        0.2543793868003920e-01,
        0.3011236389389571e-03,
        0.9881511572468257e-01,
        0.3417143692905089e-03,
        0.1744135601545568e+00,
        0.3741093236630491e-03,
        0.2429986895349530e+00,
        0.4004876411801612e-03,
        0.3031829004247381e+00,
        0.4223463640195241e-03,
        0.3555733525259414e+00,
        0.4407355613198239e-03,
        0.4012169377011952e+00,
        0.4564088559640470e-03,
        0.4411502489205138e+00,
        0.4699191284978094e-03,
        0.4762787454763390e+00,
        0.4816802419109510e-03,
        0.5073597250977332e+00,
        0.4920076781544193e-03,
        0.5350167430251173e+00,
        0.5011458800384139e-03,
        0.5597612077529058e+00,
        0.5092870408844213e-03,
        0.5820131769183957e+00,
        0.5165842754910700e-03,
        0.6021191036853046e+00,
        0.5231610232704372e-03,
        0.6203662799505060e+00,
        0.5291178753295886e-03,
        0.6369943582199482e+00,
        0.5345376082578074e-03,
        0.6522044738696901e+00,
        0.5394889485099423e-03,
        0.6661664586032026e+00,
        0.5440294242631437e-03,
        0.6790245567662842e+00,
        0.5482075518868509e-03,
        0.6909019734144254e+00,
        0.5520645308096385e-03,
        0.7019045110624699e+00,
        0.5556355707323485e-03,
        0.7121234938350971e+00,
        0.5589509407679369e-03,
        0.7216381322017054e+00,
        0.5620368060492128e-03,
        0.7305174464276960e+00,
        0.5649159003089793e-03,
        0.7388218400819079e+00,
        0.5676080707139590e-03,
        0.7466043945017325e+00,
        0.5701307223629278e-03,
        0.7539119395110627e+00,
        0.5724991833517420e-03,
        0.7607859437362659e+00,
        0.5747270064854298e-03,
        0.7672632586796091e+00,
        0.5768262201098143e-03,
        0.7733767436165075e+00,
        0.5788075378120540e-03,
        0.7791557928788411e+00,
        0.5806805346667902e-03,
        0.7846267827935451e+00,
        0.5824537961143980e-03,
        0.7898134521798050e+00,
        0.5841350443286614e-03,
        0.7947372276555162e+00,
        0.5857312459743304e-03,
        0.7994175029023208e+00,
        0.5872487045051270e-03,
        0.8038718793655162e+00,
        0.5886931395613308e-03,
        0.8081163745265718e+00,
        0.5900697555567861e-03,
        0.8121656028098705e+00,
        0.5913833011706530e-03,
        0.8160329333161330e+00,
        0.5926381211586964e-03,
        0.8197306278697833e+00,
        0.5938382016564763e-03,
        0.8232699622928324e+00,
        0.5949872099502598e-03,
        0.8266613333475188e+00,
        0.5960885295313444e-03,
        0.8299143534033866e+00,
        0.5971452911184121e-03,
        0.8330379345654622e+00,
        0.5981604002247400e-03,
        0.8360403637358284e+00,
        0.5991365617580406e-03,
        0.8389293698608987e+00,
        0.6000763020667812e-03,
        0.8417121844328502e+00,
        0.6009819887851800e-03,
        0.8443955961593316e+00,
        0.6018558487773787e-03,
        0.8469860005853584e+00,
        0.6026999844377125e-03,
        0.8494894453408740e+00,
        0.6035163885670166e-03,
        0.8519116715931933e+00,
        0.6043069580133006e-03,
        0.8542581522025076e+00,
        0.6050735062378763e-03,
        0.8565341270083502e+00,
        0.6058177749442889e-03,
        0.8587446356133339e+00,
        0.6065414448864817e-03,
        0.8608945479758220e+00,
        0.6072461459539104e-03,
        0.8629885930739860e+00,
        0.6079334666143073e-03,
        0.8650313858586231e+00,
        0.6086049627790323e-03,
        0.8670274526700236e+00,
        0.6092621661410419e-03,
        0.8689812552540616e+00,
        0.6099065920211252e-03,
        0.8708972134736309e+00,
        0.6105397467438793e-03,
        0.8727797267727406e+00,
        0.6111631345506714e-03,
        0.8746331944112725e+00,
        0.6117782640423093e-03,
        0.8764620344479443e+00,
        0.6123866541291380e-03,
        0.8782707014068333e+00,
        0.6129898394506246e-03,
        0.8800637025184370e+00,
        0.6135893752100950e-03,
        0.8818456123793366e+00,
        0.6141868413530916e-03,
        0.8836210858249036e+00,
        0.6147838459998774e-03,
        0.8853948687571734e+00,
        0.6153820280240385e-03,
        0.8871718066152805e+00,
        0.6159830586501987e-03,
        0.8889568501193103e+00,
        0.6165886419249452e-03,
        0.8907550578610847e+00,
        0.6172005138967517e-03,
        0.8925715952587398e+00,
        0.6178204403237505e-03,
        0.8944117293380552e+00,
        0.6184502127136527e-03,
        0.8962808187550784e+00,
        0.6190916424892084e-03,
        0.8981842984351409e+00,
        0.6197465530668733e-03,
        0.9001276581771762e+00,
        0.6204167696375895e-03,
        0.9021164145644403e+00,
        0.6211041064488501e-03,
        0.9041560755392406e+00,
        0.6218103514087190e-03,
        0.9062520970467020e+00,
        0.6225372478675618e-03,
        0.9084098312380427e+00,
        0.6232864734841831e-03,
        0.9106344658545083e+00,
        0.6240596161519326e-03,
        0.9129309545958600e+00,
        0.6248581470486960e-03,
        0.9153039385179171e+00,
        0.6256833909833134e-03,
        0.9177576588059725e+00,
        0.1520214237712800e-03,
        0.2089413039628107e-03,
        0.2544061844919076e-01,
        0.2525434029450244e-03,
        0.9882898388671699e-01,
        0.2865906408583821e-03,
        0.1744441250170073e+00,
        0.3137652564915279e-03,
        0.2430497235076716e+00,
        0.3358945562695622e-03,
        0.3032570714471141e+00,
        0.3542338804453592e-03,
        0.3556725894600452e+00,
        0.3696637616173895e-03,
        0.4013426546343276e+00,
        0.3828161474542172e-03,
        0.4413034887132714e+00,
        0.3941546527609132e-03,
        0.4764602748670496e+00,
        0.4040263187063507e-03,
        0.5075700996286871e+00,
        0.4126956886076392e-03,
        0.5352563525449359e+00,
        0.4203677355440847e-03,
        0.5600303090493647e+00,
        0.4272036184847955e-03,
        0.5823119175989039e+00,
        0.4333317268557089e-03,
        0.6024475399611718e+00,
        0.4388555655790971e-03,
        0.6207243900791431e+00,
        0.4438594799484181e-03,
        0.6373820527872740e+00,
        0.4484128767232627e-03,
        0.6526216037234880e+00,
        0.4525733807537433e-03,
        0.6666128210012832e+00,
        0.4563892263945745e-03,
        0.6794999001357331e+00,
        0.4599010909485004e-03,
        0.6914060010021446e+00,
        0.4631435158655601e-03,
        0.7024368836752101e+00,
        0.4661460196359733e-03,
        0.7126838318080794e+00,
        0.4689339774940904e-03,
        0.7222260166914516e+00,
        0.4715293228925426e-03,
        0.7311324200920038e+00,
        0.4739511114194688e-03,
        0.7394634071847610e+00,
        0.4762159775818406e-03,
        0.7472720204610868e+00,
        0.4783385074390325e-03,
        0.7546050498913561e+00,
        0.4803315446135938e-03,
        0.7615039226740586e+00,
        0.4822064431621426e-03,
        0.7680054467191980e+00,
        0.4839732777639475e-03,
        0.7741424349221077e+00,
        0.4856410194012131e-03,
        0.7799442317805824e+00,
        0.4872176829669196e-03,
        0.7854371596157800e+00,
        0.4887104519025023e-03,
        0.7906448982918555e+00,
        0.4901257839368306e-03,
        0.7955888096768238e+00,
        0.4914695011954675e-03,
        0.8002882159858926e+00,
        0.4927468673202736e-03,
        0.8047606394754871e+00,
        0.4939626537433801e-03,
        0.8090220096175752e+00,
        0.4951211968659503e-03,
        0.8130868428076891e+00,
        0.4962264475780244e-03,
        0.8169683987907728e+00,
        0.4972820143036731e-03,
        0.8206788172836932e+00,
        0.4982912005523597e-03,
        0.8242292376985011e+00,
        0.4992570377925784e-03,
        0.8276299044001774e+00,
        0.5001823143295755e-03,
        0.8308902595461131e+00,
        0.5010696007591026e-03,
        0.8340190252357240e+00,
        0.5019212724788590e-03,
        0.8370242764345617e+00,
        0.5027395296647642e-03,
        0.8399135059177911e+00,
        0.5035264150574445e-03,
        0.8426936822947919e+00,
        0.5042838298529326e-03,
        0.8453713020233193e+00,
        0.5050135479486603e-03,
        0.8479524361928227e+00,
        0.5057172287598274e-03,
        0.8504427727478738e+00,
        0.5063964287909282e-03,
        0.8528476547306911e+00,
        0.5070526121216016e-03,
        0.8551721150436168e+00,
        0.5076871599442239e-03,
        0.8574209081657413e+00,
        0.5083013792721207e-03,
        0.8595985392007632e+00,
        0.5088965109213798e-03,
        0.8617092905839876e+00,
        0.5094737368555486e-03,
        0.8637572467337869e+00,
        0.5100341869706155e-03,
        0.8657463168957334e+00,
        0.5105789453872895e-03,
        0.8676802563950228e+00,
        0.5111090563084296e-03,
        0.8695626864839279e+00,
        0.5116255294913210e-03,
        0.8713971129451628e+00,
        0.5121293453771310e-03,
        0.8731869435885925e+00,
        0.5126214599131585e-03,
        0.8749355047571672e+00,
        0.5131028090972410e-03,
        0.8766460569378331e+00,
        0.5135743132677963e-03,
        0.8783218095540483e+00,
        0.5140368811573158e-03,
        0.8799659349980495e+00,
        0.5144914137215976e-03,
        0.8815815819428285e+00,
        0.5149388077515203e-03,
        0.8831718879555870e+00,
        0.5153799592686180e-03,
        0.8847399914159621e+00,
        0.5158157667000665e-03,
        0.8862890427233201e+00,
        0.5162471338228604e-03,
        0.8878222147576811e+00,
        0.5166749724609052e-03,
        0.8893427125382002e+00,
        0.5171002049124420e-03,
        0.8908537820014690e+00,
        0.5175237660786470e-03,
        0.8923587177991490e+00,
        0.5179466052574159e-03,
        0.8938608699906167e+00,
        0.5183696875592966e-03,
        0.8953636494814934e+00,
        0.5187939948953462e-03,
        0.8968705320333607e+00,
        0.5192205264794681e-03,
        0.8983850606439769e+00,
        0.5196502987807066e-03,
        0.8999108460714149e+00,
        0.5200843448542496e-03,
        0.9014515652504507e+00,
        0.5205237129738048e-03,
        0.9030109573261521e+00,
        0.5209694644829235e-03,
        0.9045928170091283e+00,
        0.5214226707791797e-03,
        0.9062009849407291e+00,
        0.5218844093433793e-03,
        0.9078393347463627e+00,
        0.5223557587267653e-03,
        0.9095117564530361e+00,
        0.5228377924131475e-03,
        0.9112221359554993e+00,
        0.5233315714807396e-03,
        0.9129743302365174e+00,
        0.5238381360009637e-03,
        0.9147721380834732e+00,
        0.5243584951293212e-03,
        0.9166192660984713e+00,
        0.5248936158673047e-03,
        0.9185192898749830e+00,
        0.5254444105047963e-03,
        0.9204756103131890e+00,
        0.5260117227898333e-03,
        0.9224914051702910e+00,
        0.5265963129170898e-03,
        0.9245695760920818e+00,
        0.1268446182127322e-03,
        0.1743404286829759e-03,
        0.2544292517172434e-01,
        0.2107251564740404e-03,
        0.9884092351738187e-01,
        0.2391381657362996e-03,
        0.1744704449940017e+00,
        0.2618172499590152e-03,
        0.2430936807628649e+00,
        0.2802869400172751e-03,
        0.3033209758285258e+00,
        0.2955945748575447e-03,
        0.3557581181745550e+00,
        0.3084747892467032e-03,
        0.4014510452519073e+00,
        0.3194548214120799e-03,
        0.4414356626653468e+00,
        0.3289214677172303e-03,
        0.4766169192502833e+00,
        0.3371642657758759e-03,
        0.5077517230370061e+00,
        0.3444039242024864e-03,
        0.5354633241883532e+00,
        0.3508114513703712e-03,
        0.5602628868037311e+00,
        0.3565213009364801e-03,
        0.5825702685336475e+00,
        0.3616405864628345e-03,
        0.6027317556351184e+00,
        0.3662556600075083e-03,
        0.6210344981187767e+00,
        0.3704368884625953e-03,
        0.6377180257702407e+00,
        0.3742421752675708e-03,
        0.6529833660710770e+00,
        0.3777195940186037e-03,
        0.6670002543718940e+00,
        0.3809093836500495e-03,
        0.6799128476679434e+00,
        0.3838454780905802e-03,
        0.6918442706570039e+00,
        0.3865566919752524e-03,
        0.7029002508578049e+00,
        0.3890676491299710e-03,
        0.7131720413986303e+00,
        0.3913995164996082e-03,
        0.7227387845799725e+00,
        0.3935705893726759e-03,
        0.7316694342837096e+00,
        0.3955967618362022e-03,
        0.7400243285231667e+00,
        0.3974919078428414e-03,
        0.7478564830001711e+00,
        0.3992681920658595e-03,
        0.7552126609359470e+00,
        0.4009363251645967e-03,
        0.7621342624977909e+00,
        0.4025057747089784e-03,
        0.7686580679613385e+00,
        0.4039849404875170e-03,
        0.7748168616577529e+00,
        0.4053813010180153e-03,
        0.7806399582528606e+00,
        0.4067015366299700e-03,
        0.7861536486134770e+00,
        0.4079516333750262e-03,
        0.7913815791511374e+00,
        0.4091369711617666e-03,
        0.7963450758813084e+00,
        0.4102623988415600e-03,
        0.8010634223351132e+00,
        0.4113322984474455e-03,
        0.8055540987877207e+00,
        0.4123506403741368e-03,
        0.8098329889290022e+00,
        0.4133210309588080e-03,
        0.8139145590258739e+00,
        0.4142467536602034e-03,
        0.8178120137564664e+00,
        0.4151308048232806e-03,
        0.8215374321909360e+00,
        0.4159759248469224e-03,
        0.8251018868189340e+00,
        0.4167846254347061e-03,
        0.8285155480533462e+00,
        0.4175592134966781e-03,
        0.8317877762533697e+00,
        0.4183018121784048e-03,
        0.8349272029911109e+00,
        0.4190143794182329e-03,
        0.8379418030218164e+00,
        0.4196987243715124e-03,
        0.8408389581983645e+00,
        0.4203565219890266e-03,
        0.8436255143875690e+00,
        0.4209893259940189e-03,
        0.8463078322926154e+00,
        0.4215985804664407e-03,
        0.8488918329572650e+00,
        0.4221856302130706e-03,
        0.8513830386190436e+00,
        0.4227517300769591e-03,
        0.8537866094869954e+00,
        0.4232980533183947e-03,
        0.8561073769418921e+00,
        0.4238256991815968e-03,
        0.8583498735907137e+00,
        0.4243356997460570e-03,
        0.8605183605508547e+00,
        0.4248290261484384e-03,
        0.8626168522912827e+00,
        0.4253065942498067e-03,
        0.8646491393164755e+00,
        0.4257692698134273e-03,
        0.8666188089433132e+00,
        0.4262178732501410e-03,
        0.8685292643902939e+00,
        0.4266531839812305e-03,
        0.8703837423717154e+00,
        0.4270759444625287e-03,
        0.8721853293661955e+00,
        0.4274868639081453e-03,
        0.8739369767085355e+00,
        0.4278866217474832e-03,
        0.8756415146360238e+00,
        0.4282758708450621e-03,
        0.8773016654044247e+00,
        0.4286552405089854e-03,
        0.8789200555747797e+00,
        0.4290253393105878e-03,
        0.8804992275594572e+00,
        0.4293867577348235e-03,
        0.8820416505043871e+00,
        0.4297400706782409e-03,
        0.8835497305738722e+00,
        0.4300858398088763e-03,
        0.8850258206945885e+00,
        0.4304246158000579e-03,
        0.8864722298061936e+00,
        0.4307569404478835e-03,
        0.8878912316572020e+00,
        0.4310833486799939e-03,
        0.8892850731763069e+00,
        0.4314043704611773e-03,
        0.8906559824410115e+00,
        0.4317205325992682e-03,
        0.8920061762571498e+00,
        0.4320323604527339e-03,
        0.8933378673545269e+00,
        0.4323403795392380e-03,
        0.8946532711953979e+00,
        0.4326451170423202e-03,
        0.8959546123837375e+00,
        0.4329471032111149e-03,
        0.8972441306541727e+00,
        0.4332468726457380e-03,
        0.8985240864099954e+00,
        0.4335449654585917e-03,
        0.8997967657697997e+00,
        0.4338419282993692e-03,
        0.9010644850719940e+00,
        0.4341383152289965e-03,
        0.9023295947757297e+00,
        0.4344346884251275e-03,
        0.9035944826856999e+00,
        0.4347316186991527e-03,
        0.9048615764168997e+00,
        0.4350296858020064e-03,
        0.9061333450039083e+00,
        0.4353294784934289e-03,
        0.9074122995477561e+00,
        0.4356315943468108e-03,
        0.9087009927822184e+00,
        0.4359366392594052e-03,
        0.9100020174307473e+00,
        0.4362452266356344e-03,
        0.9113180032156295e+00,
        0.4365579762095740e-03,
        0.9126516123728104e+00,
        0.4368755124715989e-03,
        0.9140055335197583e+00,
        0.4371984626638003e-03,
        0.9153824737204230e+00,
        0.4375274543093129e-03,
        0.9167851485915539e+00,
        0.4378631122423307e-03,
        0.9182162702992493e+00,
        0.4382060551085620e-03,
        0.9196785333045526e+00,
        0.4385568913104083e-03,
        0.9211745977331760e+00,
        0.4389162143774648e-03,
        0.9227070702680383e+00,
        0.4392845977512571e-03,
        0.9242784824952105e+00,
        0.4396625889836182e-03,
        0.9258912666749617e+00,
        0.4400507033609156e-03,
        0.9275477289606028e+00,
        0.4404494169815118e-03,
        0.9292500201491721e+00,
        0.4408591593313590e-03,
        0.9310001041198086e+00,
        0.1055644989267907e-03,
        0.1450940149574984e-03,
        0.2544487491553157e-01,
        0.1753772719352769e-03,
        0.9885101688865597e-01,
        0.1990267012200822e-03,
        0.1744926990200333e+00,
        0.2179045108524649e-03,
        0.2431308553318966e+00,
        0.2332793641731550e-03,
        0.3033750329426410e+00,
        0.2460228232089687e-03,
        0.3558304876736915e+00,
        0.2567462279756849e-03,
        0.4015427879008645e+00,
        0.2658883294937232e-03,
        0.4415475744961243e+00,
        0.2737710071803561e-03,
        0.4767496006654743e+00,
        0.2806352044648509e-03,
        0.5079056259634127e+00,
        0.2866645871705139e-03,
        0.5356387851068741e+00,
        0.2920014619138971e-03,
        0.5604601504270702e+00,
        0.2967577154420555e-03,
        0.5827895051312843e+00,
        0.3010224827883186e-03,
        0.6029730739429139e+00,
        0.3048676217987417e-03,
        0.6212979551152507e+00,
        0.3083516878734000e-03,
        0.6380036341864078e+00,
        0.3115228646427098e-03,
        0.6532911002313850e+00,
        0.3144211555866268e-03,
        0.6673300547852067e+00,
        0.3170800443702226e-03,
        0.6802646246666912e+00,
        0.3195277677802438e-03,
        0.6922179072993687e+00,
        0.3217883024392515e-03,
        0.7032956052494281e+00,
        0.3238821374603807e-03,
        0.7135889485487379e+00,
        0.3258268851960003e-03,
        0.7231770578766950e+00,
        0.3276377682377606e-03,
        0.7321288666512480e+00,
        0.3293280109066263e-03,
        0.7405046933069390e+00,
        0.3309091563550510e-03,
        0.7483575346135667e+00,
        0.3323913252386479e-03,
        0.7557341352926834e+00,
        0.3337834281257755e-03,
        0.7626758772463315e+00,
        0.3350933410056701e-03,
        0.7692195225318236e+00,
        0.3363280511552274e-03,
        0.7753978371270195e+00,
        0.3374937790390407e-03,
        0.7812401170290845e+00,
        0.3385960807104609e-03,
        0.7867726339385476e+00,
        0.3396399342555158e-03,
        0.7920190144159111e+00,
        0.3406298131057851e-03,
        0.7970005637462622e+00,
        0.3415697484891286e-03,
        0.8017365436465392e+00,
        0.3424633828504657e-03,
        0.8062444112774049e+00,
        0.3433140157303645e-03,
        0.8105400256832551e+00,
        0.3441246433158771e-03,
        0.8146378267077895e+00,
        0.3448979926599179e-03,
        0.8185509905633486e+00,
        0.3456365513904324e-03,
        0.8222915655269199e+00,
        0.3463425935893944e-03,
        0.8258705906609294e+00,
        0.3470182024071915e-03,
        0.8292981999865211e+00,
        0.3476652898847084e-03,
        0.8325837141504723e+00,
        0.3482856143791181e-03,
        0.8357357213079810e+00,
        0.3488807959266790e-03,
        0.8387621486794669e+00,
        0.3494523298240878e-03,
        0.8416703260200142e+00,
        0.3500015986670602e-03,
        0.8444670420569842e+00,
        0.3505298830491450e-03,
        0.8471585947980716e+00,
        0.3510383710940082e-03,
        0.8497508364833812e+00,
        0.3515281669694799e-03,
        0.8522492138466825e+00,
        0.3520002985106894e-03,
        0.8546588042593751e+00,
        0.3524557240619330e-03,
        0.8569843482530394e+00,
        0.3528953386319557e-03,
        0.8592302788504310e+00,
        0.3533199794446321e-03,
        0.8614007480784993e+00,
        0.3537304309562248e-03,
        0.8634996509889043e+00,
        0.3541274294011706e-03,
        0.8655306474702691e+00,
        0.3545116669204490e-03,
        0.8674971821009717e+00,
        0.3548837953198046e-03,
        0.8694025022607404e+00,
        0.3552444294992589e-03,
        0.8712496746929433e+00,
        0.3555941505903093e-03,
        0.8730416006866108e+00,
        0.3559335088328495e-03,
        0.8747810300273897e+00,
        0.3562630262200606e-03,
        0.8764705738493466e+00,
        0.3565831989362264e-03,
        0.8781127165044531e+00,
        0.3568944996095447e-03,
        0.8797098265533606e+00,
        0.3571973793994888e-03,
        0.8812641669694672e+00,
        0.3574922699360495e-03,
        0.8827779046380256e+00,
        0.3577795851262342e-03,
        0.8842531192229806e+00,
        0.3580597228414603e-03,
        0.8856918114661521e+00,
        0.3583330664979325e-03,
        0.8870959109761732e+00,
        0.3585999865407079e-03,
        0.8884672835581080e+00,
        0.3588608418408972e-03,
        0.8898077381288096e+00,
        0.3591159810143158e-03,
        0.8911190332577230e+00,
        0.3593657436688535e-03,
        0.8924028833679230e+00,
        0.3596104615868662e-03,
        0.8936609646275998e+00,
        0.3598504598479910e-03,
        0.8948949205579224e+00,
        0.3600860578969333e-03,
        0.8961063673791346e+00,
        0.3603175705599569e-03,
        0.8972968991128310e+00,
        0.3605453090130204e-03,
        0.8984680924545586e+00,
        0.3607695817037281e-03,
        0.8996215114271492e+00,
        0.3609906952284962e-03,
        0.9007587118214661e+00,
        0.3612089551655714e-03,
        0.9018812454275019e+00,
        0.3614246668637566e-03,
        0.9029906640549621e+00,
        0.3616381361859153e-03,
        0.9040885233385761e+00,
        0.3618496702055102e-03,
        0.9051763863193673e+00,
        0.3620595778536006e-03,
        0.9062558267889668e+00,
        0.3622681705128622e-03,
        0.9073284323797515e+00,
        0.3624757625543019e-03,
        0.9083958073791226e+00,
        0.3626826718114261e-03,
        0.9094595752416100e+00,
        0.3628892199856792e-03,
        0.9105213807677069e+00,
        0.3630957329760065e-03,
        0.9115828919134202e+00,
        0.3633025411244249e-03,
        0.9126458011895109e+00,
        0.3635099793685103e-03,
        0.9137118266043415e+00,
        0.3637183872907533e-03,
        0.9147827120992093e+00,
        0.3639281090538103e-03,
        0.9158602274201335e+00,
        0.3641394932098118e-03,
        0.9169461673653735e+00,
        0.3643528923711136e-03,
        0.9180423503436506e+00,
        0.3645686627292243e-03,
        0.9191506161742795e+00,
        0.3647871634081525e-03,
        0.9202728230574016e+00,
        0.3650087556381453e-03,
        0.9214108436404823e+00,
        0.3652338017357785e-03,
        0.9225665601064491e+00,
        0.3654626638766759e-03,
        0.9237418582096152e+00,
        0.3656957026478399e-03,
        0.9249386201881679e+00,
        0.3659332753677379e-03,
        0.9261587164868569e+00,
        0.3661757341639742e-03,
        0.9274039962309573e+00,
        0.3664234238006590e-03,
        0.9286762764029628e+00,
        0.3666766792505202e-03,
        0.9299773296871511e+00,
        0.3669358230104597e-03,
        0.9313088709644671e+00,
        0.3672011621636608e-03,
        0.9326725424613703e+00,
        0.3674729851965463e-03,
        0.9340698975815723e+00,
        0.3677515585848630e-03,
        0.9355023834790327e+00,
        0.3680371231699034e-03,
        0.9369713224641266e+00,
        0.8780076664716276e-04,
        0.1206797894237555e-03,
        0.2544650247967021e-01,
        0.1458689907141319e-03,
        0.9885944344034912e-01,
        0.1655410204684315e-03,
        0.1745112808102761e+00,
        0.1812446142239127e-03,
        0.2431619011038030e+00,
        0.1940348805295792e-03,
        0.3034201872483507e+00,
        0.2046366722127249e-03,
        0.3558909526523158e+00,
        0.2135584233839305e-03,
        0.4016194593852736e+00,
        0.2211650307991108e-03,
        0.4416411290854953e+00,
        0.2277241922738999e-03,
        0.4768605533838495e+00,
        0.2334362932843276e-03,
        0.5080343695969284e+00,
        0.2384540829843639e-03,
        0.5357856177524436e+00,
        0.2428959131113313e-03,
        0.5606252952358727e+00,
        0.2468548359474569e-03,
        0.5829731247513873e+00,
        0.2504049817295676e-03,
        0.6031752812789858e+00,
        0.2536061116756343e-03,
        0.6215188214764482e+00,
        0.2565069236788439e-03,
        0.6382431955471400e+00,
        0.2591474896792285e-03,
        0.6535493621049741e+00,
        0.2615610783797454e-03,
        0.6676069960615446e+00,
        0.2637755361065909e-03,
        0.6805602006643017e+00,
        0.2658143454788651e-03,
        0.6925320522129640e+00,
        0.2676974460335837e-03,
        0.7036282341255100e+00,
        0.2694418768222108e-03,
        0.7139399588872692e+00,
        0.2710622843532818e-03,
        0.7235463309319510e+00,
        0.2725713276157303e-03,
        0.7325162684867130e+00,
        0.2739800036682437e-03,
        0.7409100756455830e+00,
        0.2752979113613955e-03,
        0.7487807355146596e+00,
        0.2765334664638627e-03,
        0.7561749796785543e+00,
        0.2776940783128682e-03,
        0.7631341772964979e+00,
        0.2787862957738123e-03,
        0.7696950779572316e+00,
        0.2798159285470986e-03,
        0.7758904353334187e+00,
        0.2807881485415345e-03,
        0.7817495331755640e+00,
        0.2817075750299807e-03,
        0.7872986308948055e+00,
        0.2825783465328497e-03,
        0.7925613426197803e+00,
        0.2834041817797840e-03,
        0.7975589609612814e+00,
        0.2841884316364275e-03,
        0.8023107346178518e+00,
        0.2849341235200138e-03,
        0.8068341072829448e+00,
        0.2856439995410211e-03,
        0.8111449239759836e+00,
        0.2863205493808272e-03,
        0.8152576098436540e+00,
        0.2869660387338721e-03,
        0.8191853256086143e+00,
        0.2875825339972447e-03,
        0.8229401031375546e+00,
        0.2881719237731651e-03,
        0.8265329640257898e+00,
        0.2887359376546216e-03,
        0.8299740236251799e+00,
        0.2892761626868619e-03,
        0.8332725825556256e+00,
        0.2897940578339750e-03,
        0.8364372074214862e+00,
        0.2902909667276428e-03,
        0.8394758021901656e+00,
        0.2907681289320944e-03,
        0.8423956714705967e+00,
        0.2912266899236334e-03,
        0.8452035767462418e+00,
        0.2916677099534407e-03,
        0.8479057864639630e+00,
        0.2920921719375913e-03,
        0.8505081207514051e+00,
        0.2925009884974771e-03,
        0.8530159914271018e+00,
        0.2928950082563857e-03,
        0.8554344378758767e+00,
        0.2932750214832763e-03,
        0.8577681592844462e+00,
        0.2936417651623478e-03,
        0.8600215436661002e+00,
        0.2939959275564363e-03,
        0.8621986940470617e+00,
        0.2943381523232877e-03,
        0.8643034521390155e+00,
        0.2946690422360806e-03,
        0.8663394197810720e+00,
        0.2949891625530086e-03,
        0.8683099783990099e+00,
        0.2952990440750963e-03,
        0.8702183066991327e+00,
        0.2955991859265754e-03,
        0.8720673967877357e+00,
        0.2958900580879658e-03,
        0.8738600688843806e+00,
        0.2961721037083923e-03,
        0.8755989847774060e+00,
        0.2964457412205325e-03,
        0.8772866601529093e+00,
        0.2967113662788715e-03,
        0.8789254759134587e+00,
        0.2969693535395673e-03,
        0.8805176885897160e+00,
        0.2972200582981628e-03,
        0.8820654399367039e+00,
        0.2974638179995708e-03,
        0.8835707657964145e+00,
        0.2977009536331723e-03,
        0.8850356042996281e+00,
        0.2979317710244726e-03,
        0.8864618034720409e+00,
        0.2981565620335326e-03,
        0.8878511283029286e+00,
        0.2983756056693069e-03,
        0.8892052673284969e+00,
        0.2985891691280583e-03,
        0.8905258387766696e+00,
        0.2987975087631656e-03,
        0.8918143963152597e+00,
        0.2990008709928799e-03,
        0.8930724344411763e+00,
        0.2991994931519033e-03,
        0.8943013935444719e+00,
        0.2993936042920544e-03,
        0.8955026646775683e+00,
        0.2995834259367309e-03,
        0.8966775940568730e+00,
        0.2997691727933844e-03,
        0.8978274873211489e+00,
        0.2999510534277608e-03,
        0.8989536135684026e+00,
        0.3001292709032479e-03,
        0.9000572091906636e+00,
        0.3003040233882832e-03,
        0.9011394815238150e+00,
        0.3004755047344127e-03,
        0.9022016123275653e+00,
        0.3006439050272616e-03,
        0.9032447611087047e+00,
        0.3008094111123485e-03,
        0.9042700682989381e+00,
        0.3009722070973778e-03,
        0.9052786582968102e+00,
        0.3011324748323426e-03,
        0.9062716423815145e+00,
        0.3012903943684867e-03,
        0.9072501215046918e+00,
        0.3014461443968870e-03,
        0.9082151889646557e+00,
        0.3015999026671373e-03,
        0.9091679329658161e+00,
        0.3017518463863298e-03,
        0.9101094390643967e+00,
        0.3019021525982453e-03,
        0.9110407924998413e+00,
        0.3020509985423700e-03,
        0.9119630804095697e+00,
        0.3021985619920632e-03,
        0.9128773939229608e+00,
        0.3023450215708908e-03,
        0.9137848301286094e+00,
        0.3024905570458278e-03,
        0.9146864939070101e+00,
        0.3026353495957124e-03,
        0.9155834996188661e+00,
        0.3027795820529983e-03,
        0.9164769726372038e+00,
        0.3029234391165164e-03,
        0.9173680507093950e+00,
        0.3030671075326073e-03,
        0.9182578851330556e+00,
        0.3032107762416357e-03,
        0.9191476417276118e+00,
        0.3033546364865421e-03,
        0.9200385015811228e+00,
        0.3034988818797365e-03,
        0.9209316615497335e+00,
        0.3036437084242899e-03,
        0.9218283344849421e+00,
        0.3037893144850508e-03,
        0.9227297491617354e+00,
        0.3039359007049947e-03,
        0.9236371498786060e+00,
        0.3040836698618365e-03,
        0.9245517956985898e+00,
        0.3042328266596891e-03,
        0.9254749592987897e+00,
        0.3043835774503590e-03,
        0.9264079253944743e+00,
        0.3045361298787459e-03,
        0.9273519887028263e+00,
        0.3046906924467665e-03,
        0.9283084514108677e+00,
        0.3048474739902782e-03,
        0.9292786201121033e+00,
        0.3050066830636484e-03,
        0.9302638021771222e+00,
        0.3051685272269233e-03,
        0.9312653015248920e+00,
        0.3053332122310158e-03,
        0.9322844137639074e+00,
        0.3055009410969733e-03,
        0.9333224206758433e+00,
        0.3056719130862303e-03,
        0.9343805840190375e+00,
        0.3058463225598092e-03,
        0.9354601386351341e+00,
        0.3060243577257252e-03,
        0.9365622848496463e+00,
        0.3062061992753964e-03,
        0.9376881801661726e+00,
        0.3063920189116574e-03,
        0.9388389302645763e+00,
        0.3065819777730374e-03,
        0.9400155793256640e+00,
        0.3067762247612739e-03,
        0.9412190997187711e+00,
        0.3069748947815949e-03,
        0.9424503811041136e+00,
        0.7309194121921337e-04,
        0.1004637913909749e-03,
        0.2544785012683798e-01,
        0.1214344266344417e-03,
        0.9886642145889684e-01,
        0.1378124012607418e-03,
        0.1745266702959460e+00,
        0.1508869219533374e-03,
        0.2431876171096405e+00,
        0.1615362906618204e-03,
        0.3034575961449956e+00,
        0.1703638961634086e-03,
        0.3559410557392941e+00,
        0.1777929742443069e-03,
        0.4016830055695095e+00,
        0.1841272759437895e-03,
        0.4417186869611078e+00,
        0.1895896409160979e-03,
        0.4769525589580654e+00,
        0.1943468759030283e-03,
        0.5081411588464865e+00,
        0.1985261336437941e-03,
        0.5359074494195392e+00,
        0.2022259333499051e-03,
        0.5607623671619424e+00,
        0.2055237341359384e-03,
        0.5831255858225246e+00,
        0.2084812437801258e-03,
        0.6033432403229687e+00,
        0.2111482088116174e-03,
        0.6217023539986306e+00,
        0.2135651662786688e-03,
        0.6384423489057279e+00,
        0.2157654726972967e-03,
        0.6537641595402491e+00,
        0.2177768213406241e-03,
        0.6678374398703551e+00,
        0.2196223917129092e-03,
        0.6808062747278515e+00,
        0.2213217308213229e-03,
        0.6927937240286020e+00,
        0.2228914362913128e-03,
        0.7039054564531154e+00,
        0.2243456912849616e-03,
        0.7142326710923299e+00,
        0.2256966873287446e-03,
        0.7238544600868844e+00,
        0.2269549614676161e-03,
        0.7328397302769779e+00,
        0.2281296672953758e-03,
        0.7412487751160227e+00,
        0.2292287944844476e-03,
        0.7491345676832047e+00,
        0.2302593478625398e-03,
        0.7565438300381136e+00,
        0.2312274944605136e-03,
        0.7635179222210341e+00,
        0.2321386850119108e-03,
        0.7700935850242779e+00,
        0.2329977549303630e-03,
        0.7763035635723555e+00,
        0.2338090086934327e-03,
        0.7821771332486441e+00,
        0.2345762907259228e-03,
        0.7877405452160454e+00,
        0.2353030452346481e-03,
        0.7930174054153139e+00,
        0.2359923669511411e-03,
        0.7980289982735111e+00,
        0.2366470443530013e-03,
        0.8027945642546851e+00,
        0.2372695966322588e-03,
        0.8073315387125080e+00,
        0.2378623054406560e-03,
        0.8116557581664309e+00,
        0.2384272422525216e-03,
        0.8157816390470166e+00,
        0.2389662920348844e-03,
        0.8197223330870221e+00,
        0.2394811737932779e-03,
        0.8234898628296190e+00,
        0.2399734584639214e-03,
        0.8270952401504242e+00,
        0.2404445845437014e-03,
        0.8305485702196599e+00,
        0.2408958717848132e-03,
        0.8338591429442381e+00,
        0.2413285332280931e-03,
        0.8370355136106796e+00,
        0.2417436858056495e-03,
        0.8400855741856878e+00,
        0.2421423597075709e-03,
        0.8430166165116897e+00,
        0.2425255066777939e-03,
        0.8458353884515460e+00,
        0.2428940073795231e-03,
        0.8485481438833696e+00,
        0.2432486779499734e-03,
        0.8511606873176778e+00,
        0.2435902758469355e-03,
        0.8536784138006696e+00,
        0.2439195050751448e-03,
        0.8561063446757747e+00,
        0.2442370208681859e-03,
        0.8584491596979498e+00,
        0.2445434338913074e-03,
        0.8607112259291628e+00,
        0.2448393140217253e-03,
        0.8628966237872216e+00,
        0.2451251937555122e-03,
        0.8650091705719897e+00,
        0.2454015712837818e-03,
        0.8670524417517986e+00,
        0.2456689132754098e-03,
        0.8690297902574413e+00,
        0.2459276573988435e-03,
        0.8709443640006192e+00,
        0.2461782146115141e-03,
        0.8727991218073733e+00,
        0.2464209712418874e-03,
        0.8745968479342314e+00,
        0.2466562908861773e-03,
        0.8763401653150385e+00,
        0.2468845161391411e-03,
        0.8780315476692500e+00,
        0.2471059701761088e-03,
        0.8796733305874988e+00,
        0.2473209582014312e-03,
        0.8812677216971869e+00,
        0.2475297687768076e-03,
        0.8828168099994235e+00,
        0.2477326750414573e-03,
        0.8843225744586169e+00,
        0.2479299358347776e-03,
        0.8857868919172412e+00,
        0.2481217967309792e-03,
        0.8872115444005592e+00,
        0.2483084909941748e-03,
        0.8885982258692703e+00,
        0.2484902404615005e-03,
        0.8899485484720331e+00,
        0.2486672563610595e-03,
        0.8912640483444853e+00,
        0.2488397400707827e-03,
        0.8925461909966710e+00,
        0.2490078838236775e-03,
        0.8937963763265875e+00,
        0.2491718713643894e-03,
        0.8950159432938443e+00,
        0.2493318785615123e-03,
        0.8962061742840980e+00,
        0.2494880739796445e-03,
        0.8973682991919632e+00,
        0.2496406194148037e-03,
        0.8985034992474405e+00,
        0.2497896703964584e-03,
        0.8996129106085194e+00,
        0.2499353766591264e-03,
        0.9006976277404708e+00,
        0.2500778825862051e-03,
        0.9017587066004092e+00,
        0.2502173276284460e-03,
        0.9027971676439548e+00,
        0.2503538466992535e-03,
        0.9038139986692414e+00,
        0.2504875705487804e-03,
        0.9048101575120641e+00,
        0.2506186261185988e-03,
        0.9057865746046461e+00,
        0.2507471368785526e-03,
        0.9067441554092800e+00,
        0.2508732231472320e-03,
        0.9076837827369850e+00,
        0.2509970023973650e-03,
        0.9086063189602724e+00,
        0.2511185895472782e-03,
        0.9095126081281425e+00,
        0.2512380972394480e-03,
        0.9104034779905169e+00,
        0.2513556361070412e-03,
        0.9112797419384428e+00,
        0.2514713150292236e-03,
        0.9121422008655769e+00,
        0.2515852413759041e-03,
        0.9129916449556555e+00,
        0.2516975212424692e-03,
        0.9138288553998849e+00,
        0.2518082596749575e-03,
        0.9146546060474243e+00,
        0.2519175608860183e-03,
        0.9154696649913860e+00,
        0.2520255284618921e-03,
        0.9162747960920304e+00,
        0.2521322655605479e-03,
        0.9170707604380880e+00,
        0.2522378751010061e-03,
        0.9178583177463857e+00,
        0.2523424599437699e-03,
        0.9186382276991902e+00,
        0.2524461230621790e-03,
        0.9194112512179023e+00,
        0.2525489677043914e-03,
        0.9201781516709387e+00,
        0.2526510975455835e-03,
        0.9209396960128159e+00,
        0.2527526168298444e-03,
        0.9216966558506134e+00,
        0.2528536305011233e-03,
        0.9224498084331230e+00,
        0.2529542443224635e-03,
        0.9231999375571040e+00,
        0.2530545649826379e-03,
        0.9239478343841470e+00,
        0.2531547001891691e-03,
        0.9246942981607159e+00,
        0.2532547587465925e-03,
        0.9254401368329844e+00,
        0.2533548506186903e-03,
        0.9261861675471153e+00,
        0.2534550869732947e-03,
        0.9269332170246625e+00,
        0.2535555802081323e-03,
        0.9276821218018076e+00,
        0.2536564439560544e-03,
        0.9284337283201880e+00,
        0.2537577930678808e-03,
        0.9291888928561548e+00,
        0.2538597435709706e-03,
        0.9299484812744167e+00,
        0.2539624126015323e-03,
        0.9307133685912200e+00,
        0.2540659183085976e-03,
        0.9314844383314877e+00,
        0.2541703797275094e-03,
        0.9322625816637383e+00,
        0.2542759166207297e-03,
        0.9330486962961403e+00,
        0.2543826492837433e-03,
        0.9338436851167795e+00,
        0.2544906983138460e-03,
        0.9346484545611477e+00,
        0.2546001843396463e-03,
        0.9354639126900528e+00,
        0.2547112277091971e-03,
        0.9362909669616406e+00,
        0.2548239481348102e-03,
        0.9371305216820521e+00,
        0.2549384642927942e-03,
        0.9379834751204702e+00,
        0.2550548933766077e-03,
        0.9388507162759753e+00,
        0.2551733506022396e-03,
        0.9397331212857866e+00,
        0.2552939486650164e-03,
        0.9406315494671578e+00,
        0.2554167971475084e-03,
        0.9415468389884580e+00,
        0.2555420018787558e-03,
        0.9424798021688484e+00,
        0.2556696642456735e-03,
        0.9434312204104797e+00,
        0.2557998804582168e-03,
        0.9444018387723074e+00,
        0.2559327407706962e-03,
        0.9453923602004483e+00,
        0.2560683286625224e-03,
        0.9464034394364762e+00,
        0.2562067199826295e-03,
        0.9474356766321346e+00,
        0.6097078489116776e-04,
        0.8380405076108355e-04,
        0.2544896065932850e-01,
        0.1012978969826672e-03,
        0.9887217219781226e-01,
        0.1149608733516808e-03,
        0.1745393544210289e+00,
        0.1258683390053939e-03,
        0.2432088150280462e+00,
        0.1347529092969161e-03,
        0.3034884369920806e+00,
        0.1421178877684437e-03,
        0.3559823686685004e+00,
        0.1483163075228666e-03,
        0.4017354125928528e+00,
        0.1536015360676195e-03,
        0.4417826623358451e+00,
        0.1581594503691672e-03,
        0.4770284685054013e+00,
        0.1621291886747866e-03,
        0.5082292867703224e+00,
        0.1656168126296357e-03,
        0.5360080170824175e+00,
        0.1687044997776278e-03,
        0.5608755465361002e+00,
        0.1714568607858636e-03,
        0.5832515093250096e+00,
        0.1739253676423436e-03,
        0.6034820081391302e+00,
        0.1761515150836057e-03,
        0.6218540396252812e+00,
        0.1781691159294222e-03,
        0.6386070034090316e+00,
        0.1800059934918693e-03,
        0.6539418148701861e+00,
        0.1816852471937282e-03,
        0.6680281114720945e+00,
        0.1832262113807821e-03,
        0.6810099636217561e+00,
        0.1846451904182646e-03,
        0.6930104184833876e+00,
        0.1859560284988198e-03,
        0.7041351333436702e+00,
        0.1871705558346453e-03,
        0.7144752970102477e+00,
        0.1882989413512779e-03,
        0.7241099922548785e+00,
        0.1893499739181992e-03,
        0.7331081173060140e+00,
        0.1903312884234792e-03,
        0.7415299576349032e+00,
        0.1912495488900670e-03,
        0.7494284788635305e+00,
        0.1921105978487627e-03,
        0.7568503960324043e+00,
        0.1929195789948627e-03,
        0.7638370625278608e+00,
        0.1936810385340217e-03,
        0.7704252127912312e+00,
        0.1943990094098548e-03,
        0.7766475858453091e+00,
        0.1950770816902051e-03,
        0.7825334511739168e+00,
        0.1957184616920660e-03,
        0.7881090542005848e+00,
        0.1963260218904405e-03,
        0.7933979952488399e+00,
        0.1969023432430833e-03,
        0.7984215532155936e+00,
        0.1974497512412977e-03,
        0.8031989630889407e+00,
        0.1979703467447663e-03,
        0.8077476547694436e+00,
        0.1984660324594830e-03,
        0.8120834593159135e+00,
        0.1989385357600094e-03,
        0.8162207876608769e+00,
        0.1993894284313026e-03,
        0.8201727859718991e+00,
        0.1998201438042677e-03,
        0.8239514711297960e+00,
        0.2002319916776369e-03,
        0.8275678492200949e+00,
        0.2006261713526632e-03,
        0.8310320194637810e+00,
        0.2010037830532616e-03,
        0.8343532656268659e+00,
        0.2013658379601603e-03,
        0.8375401366294502e+00,
        0.2017132670514090e-03,
        0.8406005178108765e+00,
        0.2020469289116992e-03,
        0.8435416940880705e+00,
        0.2023676166481832e-03,
        0.8463704060610680e+00,
        0.2026760640298827e-03,
        0.8490928999664670e+00,
        0.2029729509505747e-03,
        0.8517149722508350e+00,
        0.2032589083006388e-03,
        0.8542420094276686e+00,
        0.2035345223212339e-03,
        0.8566790237898599e+00,
        0.2038003385039595e-03,
        0.8590306854719521e+00,
        0.2040568650905127e-03,
        0.8613013512904316e+00,
        0.2043045762195164e-03,
        0.8634950907340174e+00,
        0.2045439147614532e-03,
        0.8656157094277920e+00,
        0.2047752948773090e-03,
        0.8676667703537839e+00,
        0.2049991043319707e-03,
        0.8696516130751836e+00,
        0.2052157065895086e-03,
        0.8715733711808579e+00,
        0.2054254427141078e-03,
        0.8734349881404843e+00,
        0.2056286330975070e-03,
        0.8752392317378276e+00,
        0.2058255790312958e-03,
        0.8769887072299080e+00,
        0.2060165641402434e-03,
        0.8786858693626248e+00,
        0.2062018556909442e-03,
        0.8803330333584298e+00,
        0.2063817057884218e-03,
        0.8819323849785773e+00,
        0.2065563524718971e-03,
        0.8834859897510554e+00,
        0.2067260207196752e-03,
        0.8849958014452854e+00,
        0.2068909233720063e-03,
        0.8864636698658907e+00,
        0.2070512619798147e-03,
        0.8878913480301039e+00,
        0.2072072275863421e-03,
        0.8892804987865693e+00,
        0.2073590014480071e-03,
        0.8906327009272852e+00,
        0.2075067557001234e-03,
        0.8919494548391176e+00,
        0.2076506539725411e-03,
        0.8932321877366053e+00,
        0.2077908519597573e-03,
        0.8944822585136047e+00,
        0.2079274979495885e-03,
        0.8957009622476075e+00,
        0.2080607333140918e-03,
        0.8968895343872672e+00,
        0.2081906929660589e-03,
        0.8980491546507244e+00,
        0.2083175057840894e-03,
        0.8991809506596934e+00,
        0.2084412950089600e-03,
        0.9002860013319247e+00,
        0.2085621786137507e-03,
        0.9013653400525538e+00,
        0.2086802696499600e-03,
        0.9024199576429591e+00,
        0.2087956765716353e-03,
        0.9034508051440569e+00,
        0.2089085035393573e-03,
        0.9044587964294366e+00,
        0.2090188507057549e-03,
        0.9054448106623624e+00,
        0.2091268144840720e-03,
        0.9064096946094280e+00,
        0.2092324878011760e-03,
        0.9073542648225251e+00,
        0.2093359603362731e-03,
        0.9082793096997696e+00,
        0.2094373187464826e-03,
        0.9091855914351026e+00,
        0.2095366468803258e-03,
        0.9100738478654410e+00,
        0.2096340259800857e-03,
        0.9109447942234819e+00,
        0.2097295348739169e-03,
        0.9117991248035615e+00,
        0.2098232501585007e-03,
        0.9126375145473211e+00,
        0.2099152463729734e-03,
        0.9134606205553340e+00,
        0.2100055961647897e-03,
        0.9142690835302997e+00,
        0.2100943704481180e-03,
        0.9150635291568929e+00,
        0.2101816385553131e-03,
        0.9158445694228796e+00,
        0.2102674683819544e-03,
        0.9166128038856619e+00,
        0.2103519265258884e-03,
        0.9173688208879894e+00,
        0.2104350784206675e-03,
        0.9181131987261704e+00,
        0.2105169884637311e-03,
        0.9188465067737359e+00,
        0.2105977201396311e-03,
        0.9195693065631350e+00,
        0.2106773361385627e-03,
        0.9202821528276868e+00,
        0.2107558984704203e-03,
        0.9209855945056615e+00,
        0.2108334685745573e-03,
        0.9216801757080246e+00,
        0.2109101074253908e-03,
        0.9223664366510376e+00,
        0.2109858756339512e-03,
        0.9230449145545729e+00,
        0.2110608335454401e-03,
        0.9237161445066656e+00,
        0.2111350413328171e-03,
        0.9243806602944845e+00,
        0.2112085590864012e-03,
        0.9250389952015636e+00,
        0.2112814468994273e-03,
        0.9256916827707871e+00,
        0.2113537649494626e-03,
        0.9263392575322679e+00,
        0.2114255735755424e-03,
        0.9269822556948962e+00,
        0.2114969333508442e-03,
        0.9276212157999659e+00,
        0.2115679051506757e-03,
        0.9282566793349052e+00,
        0.2116385502155082e-03,
        0.9288891913047499e+00,
        0.2117089302087404e-03,
        0.9295193007585984e+00,
        0.2117791072688329e-03,
        0.9301475612678799e+00,
        0.2118491440554076e-03,
        0.9307745313528513e+00,
        0.2119191037888559e-03,
        0.9314007748533154e+00,
        0.2119890502829553e-03,
        0.9320268612391253e+00,
        0.2120590479699442e-03,
        0.9326533658556098e+00,
        0.2121291619174575e-03,
        0.9332808700986251e+00,
        0.2121994578366795e-03,
        0.9339099615135131e+00,
        0.2122700020810254e-03,
        0.9345412338118337e+00,
        0.2123408616346198e-03,
        0.9351752867993358e+00,
        0.2124121040897991e-03,
        0.9358127262082568e+00,
        0.2124837976128301e-03,
        0.9364541634266928e+00,
        0.2125560108970050e-03,
        0.9371002151174706e+00,
        0.2126288131022461e-03,
        0.9377515027186954e+00,
        0.2127022737803375e-03,
        0.9384086518179469e+00,
        0.2127764627848895e-03,
        0.9390722913919686e+00,
        0.2128514501651432e-03,
        0.9397430529036528e+00,
        0.2129273060427348e-03,
        0.9404215692481872e+00,
        0.2130041004705666e-03,
        0.9411084735403966e+00,
        0.2130819032729711e-03,
        0.9418043977356298e+00,
        0.2131607838664165e-03,
        0.9425099710769944e+00,
        0.2132408110600791e-03,
        0.9432258183623697e+00,
        0.2133220528357081e-03,
        0.9439525580254419e+00,
        0.2134045761063316e-03,
        0.9446908000260153e+00,
        0.2134884464535012e-03,
        0.9454411435460905e+00,
        0.2135737278429450e-03,
        0.9462041744896647e+00,
        0.2136604823187037e-03,
        0.9469804627859271e+00,
        0.2137487696760521e-03,
        0.9477705594974885e+00,
        0.2138386471137701e-03,
        0.9485749937375257e+00,
        0.2139301688666145e-03,
        0.9493942694022146e+00,
        0.2140233858191606e-03,
        0.9502288617275928e+00,
        0.2141183451025241e-03,
        0.9510792136830037e+00,
        0.2142150896758442e-03,
        0.9519457322165201e+00,
        0.5038843819242724e-04,
        0.6925910573206593e-04,
        0.2544993017457056e-01,
        0.8371726902993700e-04,
        0.9887719305509405e-01,
        0.9500958703765661e-04,
        0.1745504296500425e+00,
        0.1040247370141086e-03,
        0.2432273260547244e+00,
        0.1113681540690559e-03,
        0.3035153719186541e+00,
        0.1174557699843303e-03,
        0.3560184543414467e+00,
        0.1225793327188225e-03,
        0.4017811956457096e+00,
        0.1269482262440711e-03,
        0.4418385610275083e+00,
        0.1307160600652860e-03,
        0.4770948070394370e+00,
        0.1339978185876816e-03,
        0.5083063187019734e+00,
        0.1368811515412669e-03,
        0.5360959417043054e+00,
        0.1394339707035654e-03,
        0.5609745206153379e+00,
        0.1417096704842709e-03,
        0.5833616556836523e+00,
        0.1437507874107348e-03,
        0.6036034220420834e+00,
        0.1455916127490372e-03,
        0.6219867936141575e+00,
        0.1472600893816645e-03,
        0.6387511510142359e+00,
        0.1487792104243456e-03,
        0.6540973934997754e+00,
        0.1501680651407632e-03,
        0.6681951446873501e+00,
        0.1514426313109642e-03,
        0.6811884629495294e+00,
        0.1526163827196775e-03,
        0.6932003848740875e+00,
        0.1537007600492208e-03,
        0.7043365583549521e+00,
        0.1547055396155196e-03,
        0.7146881637760102e+00,
        0.1556391248364784e-03,
        0.7243342762844463e+00,
        0.1565087786427017e-03,
        0.7333437871476419e+00,
        0.1573208103069447e-03,
        0.7417769754298066e+00,
        0.1580807267724731e-03,
        0.7496868008107239e+00,
        0.1587933560956882e-03,
        0.7571199727801611e+00,
        0.1594629488101686e-03,
        0.7641178395042019e+00,
        0.1600932616793006e-03,
        0.7707171304832252e+00,
        0.1606876273022243e-03,
        0.7769505800349328e+00,
        0.1612490122811637e-03,
        0.7828474531366270e+00,
        0.1617800660822615e-03,
        0.7884339908714920e+00,
        0.1622831622801481e-03,
        0.7937337893603658e+00,
        0.1627604335348945e-03,
        0.7987681234096885e+00,
        0.1632138013840797e-03,
        0.8035562240062770e+00,
        0.1636450017242930e-03,
        0.8081155171174660e+00,
        0.1640556066920045e-03,
        0.8124618299171829e+00,
        0.1644470435232973e-03,
        0.8166095694827731e+00,
        0.1648206108678467e-03,
        0.8205718781384362e+00,
        0.1651774929489843e-03,
        0.8243607689160389e+00,
        0.1655187718942932e-03,
        0.8279872440294369e+00,
        0.1658454385065429e-03,
        0.8314613987881412e+00,
        0.1661584017002631e-03,
        0.8347925129896938e+00,
        0.1664584967928401e-03,
        0.8379891315112622e+00,
        0.1667464928090865e-03,
        0.8410591355569131e+00,
        0.1670230989335329e-03,
        0.8440098057975293e+00,
        0.1672889702242240e-03,
        0.8468478784572497e+00,
        0.1675447126847760e-03,
        0.8495795952470572e+00,
        0.1677908877772391e-03,
        0.8522107479174399e+00,
        0.1680280164464030e-03,
        0.8547467180936171e+00,
        0.1682565827161736e-03,
        0.8571925129651890e+00,
        0.1684770369102029e-03,
        0.8595527973243928e+00,
        0.1686897985418176e-03,
        0.8618319223811186e+00,
        0.1688952589122240e-03,
        0.8640339517265517e+00,
        0.1690937834508111e-03,
        0.8661626847691907e+00,
        0.1692857138269685e-03,
        0.8682216779257585e+00,
        0.1694713698590671e-03,
        0.8702142638140924e+00,
        0.1696510512430158e-03,
        0.8721435686645843e+00,
        0.1698250391200247e-03,
        0.8740125281403963e+00,
        0.1699935975008061e-03,
        0.8758239017338748e+00,
        0.1701569745613678e-03,
        0.8775802858868165e+00,
        0.1703154038237586e-03,
        0.8792841259650484e+00,
        0.1704691052335605e-03,
        0.8809377272028146e+00,
        0.1706182861445670e-03,
        0.8825432647193950e+00,
        0.1707631422198987e-03,
        0.8841027926989548e+00,
        0.1709038582577726e-03,
        0.8856182528146059e+00,
        0.1710406089492363e-03,
        0.8870914819688771e+00,
        0.1711735595743775e-03,
        0.8885242194150492e+00,
        0.1713028666428259e-03,
        0.8899181133170080e+00,
        0.1714286784837430e-03,
        0.8912747267992473e+00,
        0.1715511357899551e-03,
        0.8925955435333450e+00,
        0.1716703721204033e-03,
        0.8938819729025228e+00,
        0.1717865143646592e-03,
        0.8951353547817279e+00,
        0.1718996831728790e-03,
        0.8963569639669645e+00,
        0.1720099933542312e-03,
        0.8975480142843037e+00,
        0.1721175542465397e-03,
        0.8987096624060582e+00,
        0.1722224700596145e-03,
        0.8998430113989865e+00,
        0.1723248401945090e-03,
        0.9009491140270437e+00,
        0.1724247595407294e-03,
        0.9020289758291009e+00,
        0.1725223187532327e-03,
        0.9030835579901713e+00,
        0.1726176045108827e-03,
        0.9041137800229966e+00,
        0.1727106997578779e-03,
        0.9051205222753303e+00,
        0.1728016839295312e-03,
        0.9061046282768895e+00,
        0.1728906331636581e-03,
        0.9070669069387198e+00,
        0.1729776204987175e-03,
        0.9080081346166083e+00,
        0.1730627160597527e-03,
        0.9089290570491782e+00,
        0.1731459872330869e-03,
        0.9098303911803945e+00,
        0.1732274988306475e-03,
        0.9107128268753881e+00,
        0.1733073132447196e-03,
        0.9115770285377644e+00,
        0.1733854905938624e-03,
        0.9124236366358845e+00,
        0.1734620888606598e-03,
        0.9132532691449957e+00,
        0.1735371640219225e-03,
        0.9140665229115264e+00,
        0.1736107701719091e-03,
        0.9148639749453516e+00,
        0.1736829596390858e-03,
        0.9156461836453693e+00,
        0.1737537830969034e-03,
        0.9164136899633000e+00,
        0.1738232896690321e-03,
        0.9171670185102322e+00,
        0.1738915270294578e-03,
        0.9179066786100761e+00,
        0.1739585414978131e-03,
        0.9186331653037572e+00,
        0.1740243781302842e-03,
        0.9193469603076764e+00,
        0.1740890808064089e-03,
        0.9200485329296795e+00,
        0.1741526923120535e-03,
        0.9207383409455176e+00,
        0.1742152544188343e-03,
        0.9214168314385361e+00,
        0.1742768079602262e-03,
        0.9220844416050994e+00,
        0.1743373929045788e-03,
        0.9227415995280490e+00,
        0.1743970484252448e-03,
        0.9233887249202853e+00,
        0.1744558129680012e-03,
        0.9240262298403793e+00,
        0.1745137243159310e-03,
        0.9246545193819353e+00,
        0.1745708196519153e-03,
        0.9252739923382533e+00,
        0.1746271356188670e-03,
        0.9258850418436779e+00,
        0.1746827083778257e-03,
        0.9264880559928549e+00,
        0.1747375736640159e-03,
        0.9270834184389665e+00,
        0.1747917668409568e-03,
        0.9276715089718623e+00,
        0.1748453229526972e-03,
        0.9282527040768544e+00,
        0.1748982767742368e-03,
        0.9288273774748004e+00,
        0.1749506628601784e-03,
        0.9293959006439499e+00,
        0.1750025155916436e-03,
        0.9299586433238869e+00,
        0.1750538692214704e-03,
        0.9305159740017549e+00,
        0.1751047579176975e-03,
        0.9310682603808031e+00,
        0.1751552158053241e-03,
        0.9316158698311472e+00,
        0.1752052770063228e-03,
        0.9321591698224861e+00,
        0.1752549756778664e-03,
        0.9326985283383640e+00,
        0.1753043460487161e-03,
        0.9332343142714111e+00,
        0.1753534224537021e-03,
        0.9337668977988398e+00,
        0.1754022393662154e-03,
        0.9342966507373076e+00,
        0.1754508314286094e-03,
        0.9348239468760963e+00,
        0.1754992334803999e-03,
        0.9353491622873846e+00,
        0.1755474805841303e-03,
        0.9358726756122197e+00,
        0.1755956080487566e-03,
        0.9363948683206198e+00,
        0.1756436514503888e-03,
        0.9369161249440563e+00,
        0.1756916466502072e-03,
        0.9374368332783890e+00,
        0.1757396298093589e-03,
        0.9379573845551401e+00,
        0.1757876374006189e-03,
        0.9384781735788145e+00,
        0.1758357062165868e-03,
        0.9389995988277885e+00,
        0.1758838733741719e-03,
        0.9395220625161108e+00,
        0.1759321763151046e-03,
        0.9400459706133823e+00,
        0.1759806528021968e-03,
        0.9405717328197126e+00,
        0.1760293409110582e-03,
        0.9410997624925852e+00,
        0.1760782790169647e-03,
        0.9416304765223171e+00,
        0.1761275057765599e-03,
        0.9421642951526550e+00,
        0.1761770601040649e-03,
        0.9427016417429337e+00,
        0.1762269811416588e-03,
        0.9432429424681213e+00,
        0.1762773082236904e-03,
        0.9437886259529981e+00,
        0.1763280808343769e-03,
        0.9443391228366760e+00,
        0.1763793385586478e-03,
        0.9448948652636468e+00,
        0.1764311210257938e-03,
        0.9454562862975816e+00,
        0.1764834678455926e-03,
        0.9460238192541732e+00,
        0.1765364185365951e-03,
        0.9465978969494375e+00,
        0.1765900124462755e-03,
        0.9471789508600694e+00,
        0.1766442886627730e-03,
        0.9477674101926942e+00,
        0.1766992859179855e-03,
        0.9483637008591625e+00,
        0.1767550424818139e-03,
        0.9489682443554301e+00,
        0.1768115960474016e-03,
        0.9495814565420250e+00,
        0.1768689836072686e-03,
        0.9502037463246646e+00,
        0.1769272413203024e-03,
        0.9508355142342285e+00,
        0.1769864043696395e-03,
        0.9514771509060350e+00,
        0.1770465068115518e-03,
        0.9521290354592114e+00,
        0.1771075814155438e-03,
        0.9527915337778898e+00,
        0.1771696594959625e-03,
        0.9534649966970047e+00,
        0.1772327707355348e-03,
        0.9541497580966158e+00,
        0.1772969430013587e-03,
        0.9548461329099190e+00,
        0.1773622021540052e-03,
        0.9555544150514501e+00,
        0.1774285718505145e-03,
        0.9562748752734012e+00,
        0.4141439367791228e-04,
        0.5692455280094251e-04,
        0.2545075230958515e-01,
        0.6880819048293672e-04,
        0.9888145093055719e-01,
        0.7808989690617372e-04,
        0.1745598225673840e+00,
        0.8550005185877480e-04,
        0.2432430266865816e+00,
        0.9153624710259941e-04,
        0.3035382198764821e+00,
        0.9654032678652594e-04,
        0.3560490681596453e+00,
        0.1007520715550410e-03,
        0.4018200414988670e+00,
        0.1043435691172141e-03,
        0.4418859966836131e+00,
        0.1074410674826558e-03,
        0.4771511109577878e+00,
        0.1101390695970056e-03,
        0.5083717098779069e+00,
        0.1125096126676353e-03,
        0.5361705935601133e+00,
        0.1146085117292486e-03,
        0.5610585709493248e+00,
        0.1164796503201761e-03,
        0.5834552139424401e+00,
        0.1181579881289340e-03,
        0.6037065747337148e+00,
        0.1196717082477531e-03,
        0.6220996084034542e+00,
        0.1210437761733641e-03,
        0.6388736798670074e+00,
        0.1222930892987222e-03,
        0.6542296751290908e+00,
        0.1234353365269360e-03,
        0.6683372064799513e+00,
        0.1244836495012513e-03,
        0.6813403224997011e+00,
        0.1254491018862550e-03,
        0.6933620512173756e+00,
        0.1263410963843689e-03,
        0.7045080329697024e+00,
        0.1271676677918698e-03,
        0.7148694414033631e+00,
        0.1279357225503386e-03,
        0.7245253456049399e+00,
        0.1286512297599230e-03,
        0.7335446313434784e+00,
        0.1293193747303500e-03,
        0.7419875726551162e+00,
        0.1299446833543593e-03,
        0.7499071245871521e+00,
        0.1305311235624521e-03,
        0.7573499923313203e+00,
        0.1310821886317202e-03,
        0.7643575200396533e+00,
        0.1316009660202284e-03,
        0.7709664334404412e+00,
        0.1320901945745293e-03,
        0.7772094632859758e+00,
        0.1325523123360135e-03,
        0.7831158711649373e+00,
        0.1329894966984371e-03,
        0.7887118949231211e+00,
        0.1334036983057875e-03,
        0.7940211275731494e+00,
        0.1337966697989137e-03,
        0.7990648409231811e+00,
        0.1341699903007926e-03,
        0.8038622630547293e+00,
        0.1345250863590139e-03,
        0.8084308171076828e+00,
        0.1348632499289629e-03,
        0.8127863274927396e+00,
        0.1351856538739728e-03,
        0.8169431985757714e+00,
        0.1354933653731529e-03,
        0.8209145700097322e+00,
        0.1357873575589372e-03,
        0.8247124521846697e+00,
        0.1360685196510050e-03,
        0.8283478446917955e+00,
        0.1363376658083228e-03,
        0.8318308402273038e+00,
        0.1365955428844750e-03,
        0.8351707159751699e+00,
        0.1368428372415219e-03,
        0.8383760141893339e+00,
        0.1370801807530195e-03,
        0.8414546134316254e+00,
        0.1373081561065382e-03,
        0.8444137917023124e+00,
        0.1375273014991923e-03,
        0.8472602825170738e+00,
        0.1377381148057014e-03,
        0.8500003248309528e+00,
        0.1379410572868236e-03,
        0.8526397075811507e+00,
        0.1381365568962136e-03,
        0.8551838095120960e+00,
        0.1383250112355325e-03,
        0.8576376348545903e+00,
        0.1385067902006957e-03,
        0.8600058453531640e+00,
        0.1386822383562781e-03,
        0.8622927890697443e+00,
        0.1388516770701086e-03,
        0.8645025263354547e+00,
        0.1390154064358504e-03,
        0.8666388531742509e+00,
        0.1391737070077414e-03,
        0.8687053224808631e+00,
        0.1393268413685703e-03,
        0.8707052632000881e+00,
        0.1394750555493091e-03,
        0.8726417977239585e+00,
        0.1396185803165322e-03,
        0.8745178576969695e+00,
        0.1397576323417808e-03,
        0.8763361983967452e+00,
        0.1398924152653265e-03,
        0.8780994118377522e+00,
        0.1400231206653106e-03,
        0.8798099387284804e+00,
        0.1401499289419495e-03,
        0.8814700793975387e+00,
        0.1402730101253844e-03,
        0.8830820037910464e+00,
        0.1403925246147742e-03,
        0.8846477606322743e+00,
        0.1405086238553824e-03,
        0.8861692858244719e+00,
        0.1406214509596627e-03,
        0.8876484101690279e+00,
        0.1407311412776921e-03,
        0.8890868664633782e+00,
        0.1408378229217274e-03,
        0.8904862960362619e+00,
        0.1409416172491532e-03,
        0.8918482547719127e+00,
        0.1410426393076430e-03,
        0.8931742186694573e+00,
        0.1411409982459610e-03,
        0.8944655889790835e+00,
        0.1412367976934811e-03,
        0.8957236969523653e+00,
        0.1413301361111912e-03,
        0.8969498082404222e+00,
        0.1414211071166758e-03,
        0.8981451269702901e+00,
        0.1415097997853232e-03,
        0.8993107995269396e+00,
        0.1415962989297887e-03,
        0.9004479180657531e+00,
        0.1416806853595467e-03,
        0.9015575237779278e+00,
        0.1417630361221969e-03,
        0.9026406099291728e+00,
        0.1418434247280258e-03,
        0.9036981246901897e+00,
        0.1419219213591954e-03,
        0.9047309737757363e+00,
        0.1419985930647974e-03,
        0.9057400229075616e+00,
        0.1420735039429043e-03,
        0.9067261001151347e+00,
        0.1421467153106468e-03,
        0.9076899978868622e+00,
        0.1422182858632548e-03,
        0.9086324751833850e+00,
        0.1422882718229183e-03,
        0.9095542593235423e+00,
        0.1423567270782516e-03,
        0.9104560477526908e+00,
        0.1424237033150753e-03,
        0.9113385097022479e+00,
        0.1424892501391719e-03,
        0.9122022877485889e+00,
        0.1425534151916154e-03,
        0.9130479992787559e+00,
        0.1426162442572255e-03,
        0.9138762378698273e+00,
        0.1426777813666525e-03,
        0.9146875745882436e+00,
        0.1427380688925579e-03,
        0.9154825592148789e+00,
        0.1427971476403172e-03,
        0.9162617214011930e+00,
        0.1428550569336404e-03,
        0.9170255717613750e+00,
        0.1429118346954711e-03,
        0.9177746029050118e+00,
        0.1429675175245004e-03,
        0.9185092904144644e+00,
        0.1430221407676021e-03,
        0.9192300937708136e+00,
        0.1430757385884771e-03,
        0.9199374572319491e+00,
        0.1431283440327680e-03,
        0.9206318106661012e+00,
        0.1431799890898880e-03,
        0.9213135703438758e+00,
        0.1432307047517914e-03,
        0.9219831396916189e+00,
        0.1432805210688911e-03,
        0.9226409100087367e+00,
        0.1433294672033191e-03,
        0.9232872611513990e+00,
        0.1433775714797077e-03,
        0.9239225621848796e+00,
        0.1434248614336570e-03,
        0.9245471720066236e+00,
        0.1434713638580431e-03,
        0.9251614399419788e+00,
        0.1435171048473090e-03,
        0.9257657063143877e+00,
        0.1435621098398706e-03,
        0.9263603029917071e+00,
        0.1436064036587590e-03,
        0.9269455539101992e+00,
        0.1436500105506133e-03,
        0.9275217755776247e+00,
        0.1436929542231280e-03,
        0.9280892775567625e+00,
        0.1437352578810521e-03,
        0.9286483629305795e+00,
        0.1437769442608283e-03,
        0.9291993287501823e+00,
        0.1438180356639552e-03,
        0.9297424664665897e+00,
        0.1438585539891476e-03,
        0.9302780623472868e+00,
        0.1438985207633644e-03,
        0.9308063978784351e+00,
        0.1439379571717663e-03,
        0.9313277501535416e+00,
        0.1439768840866617e-03,
        0.9318423922493136e+00,
        0.1440153220954916e-03,
        0.9323505935893585e+00,
        0.1440532915279006e-03,
        0.9328526202963160e+00,
        0.1440908124819338e-03,
        0.9333487355329478e+00,
        0.1441279048493981e-03,
        0.9338391998326430e+00,
        0.1441645883404158e-03,
        0.9343242714197350e+00,
        0.1442008825071996e-03,
        0.9348042065199632e+00,
        0.1442368067670687e-03,
        0.9352792596613518e+00,
        0.1442723804247230e-03,
        0.9357496839657160e+00,
        0.1443076226937871e-03,
        0.9362157314309450e+00,
        0.1443425527176319e-03,
        0.9366776532041510e+00,
        0.1443771895894746e-03,
        0.9371356998457099e+00,
        0.1444115523717566e-03,
        0.9375901215841609e+00,
        0.1444456601147895e-03,
        0.9380411685618638e+00,
        0.1444795318746588e-03,
        0.9384890910712563e+00,
        0.1445131867303672e-03,
        0.9389341397814829e+00,
        0.1445466438001951e-03,
        0.9393765659551052e+00,
        0.1445799222572509e-03,
        0.9398166216545342e+00,
        0.1446130413441780e-03,
        0.9402545599377586e+00,
        0.1446460203869812e-03,
        0.9406906350428731e+00,
        0.1446788788079280e-03,
        0.9411251025608388e+00,
        0.1447116361374763e-03,
        0.9415582195958393e+00,
        0.1447443120251743e-03,
        0.9419902449125173e+00,
        0.1447769262494714e-03,
        0.9424214390693087e+00,
        0.1448094987263750e-03,
        0.9428520645370120e+00,
        0.1448420495168817e-03,
        0.9432823858016560e+00,
        0.1448745988331048e-03,
        0.9437126694506553e+00,
        0.1449071670430162e-03,
        0.9441431842411634e+00,
        0.1449397746737126e-03,
        0.9445742011494633e+00,
        0.1449724424131142e-03,
        0.9450059934001559e+00,
        0.1450051911099938e-03,
        0.9454388364738392e+00,
        0.1450380417722341e-03,
        0.9458730080918976e+00,
        0.1450710155632024e-03,
        0.9463087881769580e+00,
        0.1451041337961289e-03,
        0.9467464587875015e+00,
        0.1451374179263711e-03,
        0.9471863040250684e+00,
        0.1451708895414430e-03,
        0.9476286099124387e+00,
        0.1452045703486834e-03,
        0.9480736642411287e+00,
        0.1452384821604381e-03,
        0.9485217563865096e+00,
        0.1452726468766264e-03,
        0.9489731770888300e+00,
        0.1453070864645653e-03,
        0.9494282181984106e+00,
        0.1453418229359214e-03,
        0.9498871723832843e+00,
        0.1453768783206665e-03,
        0.9503503327975676e+00,
        0.1454122746379124e-03,
        0.9508179927088858e+00,
        0.1454480338635091e-03,
        0.9512904450832298e+00,
        0.1454841778942922e-03,
        0.9517679821256925e+00,
        0.1455207285088794e-03,
        0.9522508947756375e+00,
        0.1455577073249200e-03,
        0.9527394721549711e+00,
        0.1455951357527194e-03,
        0.9532340009683443e+00,
        0.1456330349451717e-03,
        0.9537347648542913e+00,
        0.1456714257439507e-03,
        0.9542420436865237e+00,
        0.1457103286219321e-03,
        0.9547561128248467e+00,
        0.1457497636218381e-03,
        0.9552772423154445e+00,
        0.1457897502911246e-03,
        0.9558056960406009e+00,
        0.1458303076131549e-03,
        0.9563417308182725e+00,
        0.1458714539347385e-03,
        0.9568855954523308e+00,
        0.1459132068901443e-03,
        0.9574375297347150e+00,
        0.1459555833217350e-03,
        0.9579977634012095e+00,
        0.1459985991974088e-03,
        0.9585665150430652e+00,
        0.1460422695250747e-03,
        0.9591439909772242e+00,
        0.1460866082644329e-03,
        0.9597303840784822e+00,
        0.1461316282363772e-03,
        0.9603258725775255e+00,
        0.3429496445563442e-04,
        0.4713901805892190e-04,
        0.2545140450924156e-01,
        0.5698005902228804e-04,
        0.9888482887297308e-01,
        0.6466651548721230e-04,
        0.1745672748051217e+00,
        0.7080319239456011e-04,
        0.2432554843126429e+00,
        0.7580213079430914e-04,
        0.3035563500747286e+00,
        0.7994640198168629e-04,
        0.3560733630370389e+00,
        0.8343456150015368e-04,
        0.4018508725952348e+00,
        0.8640911033247278e-04,
        0.4419236498367694e+00,
        0.8897459090834537e-04,
        0.4771958093843240e+00,
        0.9120925845958284e-04,
        0.5084236299136395e+00,
        0.9317276496329196e-04,
        0.5362298756774806e+00,
        0.9491132926180562e-04,
        0.5611253276477577e+00,
        0.9646129005158931e-04,
        0.5835295355152852e+00,
        0.9785159643187923e-04,
        0.6037885335602648e+00,
        0.9910558598615794e-04,
        0.6221892621956204e+00,
        0.1002422757479970e-03,
        0.6389710741614672e+00,
        0.1012773140638229e-03,
        0.6543348452257979e+00,
        0.1022236924158808e-03,
        0.6684501789683020e+00,
        0.1030922846881736e-03,
        0.6814611164733789e+00,
        0.1038922606077670e-03,
        0.6934906792512014e+00,
        0.1046314062227422e-03,
        0.7046445019124451e+00,
        0.1053163748547551e-03,
        0.7150137530267155e+00,
        0.1059528854651743e-03,
        0.7246774971389701e+00,
        0.1065458808280527e-03,
        0.7337046159216464e+00,
        0.1070996546816144e-03,
        0.7421553796866258e+00,
        0.1076179547185671e-03,
        0.7500827400704289e+00,
        0.1081040665980620e-03,
        0.7575333991194183e+00,
        0.1085608829314993e-03,
        0.7645486980661065e+00,
        0.1089909602824242e-03,
        0.7711653599123298e+00,
        0.1093965665385209e-03,
        0.7774161128496167e+00,
        0.1097797204987463e-03,
        0.7833302160485503e+00,
        0.1101422251266719e-03,
        0.7889339050599856e+00,
        0.1104856956203599e-03,
        0.7942507707081078e+00,
        0.1108115832166325e-03,
        0.7993020827048136e+00,
        0.1111211954666116e-03,
        0.8041070671151008e+00,
        0.1114157135775683e-03,
        0.8086831451312193e+00,
        0.1116962073042465e-03,
        0.8130461392755103e+00,
        0.1119636477840458e-03,
        0.8172104520762232e+00,
        0.1122189186395992e-03,
        0.8211892213917328e+00,
        0.1124628256154204e-03,
        0.8249944558535597e+00,
        0.1126961049694284e-03,
        0.8286371533240165e+00,
        0.1129194308029721e-03,
        0.8321274047940588e+00,
        0.1131334214826889e-03,
        0.8354744857604805e+00,
        0.1133386452827434e-03,
        0.8386869368027751e+00,
        0.1135356253556231e-03,
        0.8417726348159536e+00,
        0.1137248441228562e-03,
        0.8447388561361401e+00,
        0.1139067471630854e-03,
        0.8475923326126939e+00,
        0.1140817466633488e-03,
        0.8503393015273689e+00,
        0.1142502244897405e-03,
        0.8529855501323292e+00,
        0.1144125349255261e-03,
        0.8555364554704203e+00,
        0.1145690071179690e-03,
        0.8579970200494635e+00,
        0.1147199472693837e-03,
        0.8603719038646763e+00,
        0.1148656406030670e-03,
        0.8626654531972963e+00,
        0.1150063531306337e-03,
        0.8648817265611982e+00,
        0.1151423332437714e-03,
        0.8670245181211878e+00,
        0.1152738131504335e-03,
        0.8690973788654197e+00,
        0.1154010101729216e-03,
        0.8711036357789597e+00,
        0.1155241279231094e-03,
        0.8730464092349987e+00,
        0.1156433573681646e-03,
        0.8749286287938791e+00,
        0.1157588777984930e-03,
        0.8767530475772949e+00,
        0.1158708577082165e-03,
        0.8785222553652559e+00,
        0.1159794555972724e-03,
        0.8802386905462134e+00,
        0.1160848207031594e-03,
        0.8819046510357806e+00,
        0.1161870936694311e-03,
        0.8835223042664072e+00,
        0.1162864071572288e-03,
        0.8850936963389428e+00,
        0.1163828864054445e-03,
        0.8866207604170093e+00,
        0.1164766497444822e-03,
        0.8881053244363083e+00,
        0.1165678090680486e-03,
        0.8895491181932601e+00,
        0.1166564702669258e-03,
        0.8909537798705543e+00,
        0.1167427336282587e-03,
        0.8923208620511820e+00,
        0.1168266942035215e-03,
        0.8936518372671990e+00,
        0.1169084421479998e-03,
        0.8949481031247646e+00,
        0.1169880630343355e-03,
        0.8962109870428230e+00,
        0.1170656381424237e-03,
        0.8974417506390828e+00,
        0.1171412447277278e-03,
        0.8986415937936533e+00,
        0.1172149562698677e-03,
        0.8998116584177496e+00,
        0.1172868427031662e-03,
        0.9009530319522595e+00,
        0.1173569706306669e-03,
        0.9020667506186153e+00,
        0.1174254035230018e-03,
        0.9031538024423191e+00,
        0.1174922019033529e-03,
        0.9042151300675857e+00,
        0.1175574235196376e-03,
        0.9052516333798847e+00,
        0.1176211235049476e-03,
        0.9062641719516429e+00,
        0.1176833545271722e-03,
        0.9072535673250101e+00,
        0.1177441669286597e-03,
        0.9082206051443592e+00,
        0.1178036088566899e-03,
        0.9091660371500875e+00,
        0.1178617263854677e-03,
        0.9100905830442862e+00,
        0.1179185636302828e-03,
        0.9109949322379410e+00,
        0.1179741628544263e-03,
        0.9118797454885111e+00,
        0.1180285645694077e-03,
        0.9127456564359945e+00,
        0.1180818076289649e-03,
        0.9135932730449129e+00,
        0.1181339293173255e-03,
        0.9144231789590457e+00,
        0.1181849654321338e-03,
        0.9152359347751857e+00,
        0.1182349503624295e-03,
        0.9160320792416857e+00,
        0.1182839171620296e-03,
        0.9168121303871106e+00,
        0.1183318976186388e-03,
        0.9175765865838867e+00,
        0.1183789223189884e-03,
        0.9183259275514641e+00,
        0.1184250207102780e-03,
        0.9190606153031572e+00,
        0.1184702211581763e-03,
        0.9197810950405108e+00,
        0.1185145510016160e-03,
        0.9204877959987503e+00,
        0.1185580366045994e-03,
        0.9211811322466059e+00,
        0.1186007034052168e-03,
        0.9218615034435585e+00,
        0.1186425759620638e-03,
        0.9225292955573307e+00,
        0.1186836779982295e-03,
        0.9231848815442406e+00,
        0.1187240324430169e-03,
        0.9238286219948466e+00,
        0.1187636614715423e-03,
        0.9244608657471405e+00,
        0.1188025865423529e-03,
        0.9250819504693824e+00,
        0.1188408284331903e-03,
        0.9256922032145273e+00,
        0.1188784072750181e-03,
        0.9262919409480546e+00,
        0.1189153425844261e-03,
        0.9268814710508878e+00,
        0.1189516532945120e-03,
        0.9274610917989764e+00,
        0.1189873577843384e-03,
        0.9280310928210021e+00,
        0.1190224739070536e-03,
        0.9285917555355758e+00,
        0.1190570190167592e-03,
        0.9291433535691963e+00,
        0.1190910099942032e-03,
        0.9296861531561591e+00,
        0.1191244632713702e-03,
        0.9302204135215227e+00,
        0.1191573948550362e-03,
        0.9307463872481658e+00,
        0.1191898203493515e-03,
        0.9312643206289019e+00,
        0.1192217549775109e-03,
        0.9317744540045509e+00,
        0.1192532136025640e-03,
        0.9322770220888102e+00,
        0.1192842107474197e-03,
        0.9327722542807087e+00,
        0.1193147606140906e-03,
        0.9332603749653780e+00,
        0.1193448771022213e-03,
        0.9337416038038212e+00,
        0.1193745738269449e-03,
        0.9342161560123183e+00,
        0.1194038641361023e-03,
        0.9346842426320593e+00,
        0.1194327611268635e-03,
        0.9351460707895552e+00,
        0.1194612776617823e-03,
        0.9356018439483411e+00,
        0.1194894263843151e-03,
        0.9360517621524420e+00,
        0.1195172197338335e-03,
        0.9364960222620436e+00,
        0.1195446699601559e-03,
        0.9369348181817692e+00,
        0.1195717891376224e-03,
        0.9373683410819361e+00,
        0.1195985891787351e-03,
        0.9377967796131314e+00,
        0.1196250818473841e-03,
        0.9382203201144163e+00,
        0.1196512787716769e-03,
        0.9386391468154388e+00,
        0.1196771914563876e-03,
        0.9390534420327067e+00,
        0.1197028312950406e-03,
        0.9394633863602434e+00,
        0.1197282095816411e-03,
        0.9398691588548227e+00,
        0.1197533375220634e-03,
        0.9402709372159495e+00,
        0.1197782262451063e-03,
        0.9406688979607300e+00,
        0.1198028868132232e-03,
        0.9410632165937440e+00,
        0.1198273302329317e-03,
        0.9414540677720091e+00,
        0.1198515674649078e-03,
        0.9418416254650982e+00,
        0.1198756094337670e-03,
        0.9422260631104450e+00,
        0.1198994670375319e-03,
        0.9426075537638465e+00,
        0.1199231511567857e-03,
        0.9429862702451438e+00,
        0.1199466726635097e-03,
        0.9433623852790360e+00,
        0.1199700424295984e-03,
        0.9437360716309537e+00,
        0.1199932713350474e-03,
        0.9441075022378914e+00,
        0.1200163702758047e-03,
        0.9444768503340695e+00,
        0.1200393501712764e-03,
        0.9448442895712680e+00,
        0.1200622219714742e-03,
        0.9452099941336445e+00,
        0.1200849966637913e-03,
        0.9455741388468206e+00,
        0.1201076852793909e-03,
        0.9459368992809881e+00,
        0.1201302988991895e-03,
        0.9462984518477588e+00,
        0.1201528486594163e-03,
        0.9466589738904483e+00,
        0.1201753457567260e-03,
        0.9470186437674542e+00,
        0.1201978014528419e-03,
        0.9473776409283557e+00,
        0.1202202270787045e-03,
        0.9477361459823309e+00,
        0.1202426340380965e-03,
        0.9480943407584549e+00,
        0.1202650338107162e-03,
        0.9484524083574091e+00,
        0.1202874379546662e-03,
        0.9488105331941014e+00,
        0.1203098581083251e-03,
        0.9491689010306607e+00,
        0.1203323059915656e-03,
        0.9495276989992437e+00,
        0.1203547934062821e-03,
        0.9498871156140531e+00,
        0.1203773322361880e-03,
        0.9502473407719423e+00,
        0.1203999344458418e-03,
        0.9506085657409490e+00,
        0.1204226120788594e-03,
        0.9509709831360716e+00,
        0.1204453772552672e-03,
        0.9513347868815795e+00,
        0.1204682421679518e-03,
        0.9517001721591189e+00,
        0.1204912190781571e-03,
        0.9520673353408602e+00,
        0.1205143203099825e-03,
        0.9524364739069084e+00,
        0.1205375582438321e-03,
        0.9528077863461864e+00,
        0.1205609453087660e-03,
        0.9531814720399889e+00,
        0.1205844939737027e-03,
        0.9535577311273962e+00,
        0.1206082167374240e-03,
        0.9539367643517374e+00,
        0.1206321261173331e-03,
        0.9543187728872938e+00,
        0.1206562346369151e-03,
        0.9547039581454467e+00,
        0.1206805548118562e-03,
        0.9550925215594878e+00,
        0.1207050991347726e-03,
        0.9554846643473366e+00,
        0.1207298800585086e-03,
        0.9558805872514442e+00,
        0.1207549099779616e-03,
        0.9562804902552012e+00,
        0.1207802012103997e-03,
        0.9566845722752253e+00,
        0.1208057659742362e-03,
        0.9570930308289628e+00,
        0.1208316163662374e-03,
        0.9575060616771147e+00,
        0.1208577643371385e-03,
        0.9579238584404855e+00,
        0.1208842216656548e-03,
        0.9583466121909501e+00,
        0.1209109999308791e-03,
        0.9587745110163490e+00,
        0.1209381104830662e-03,
        0.9592077395592462e+00,
        0.1209655644128141e-03,
        0.9596464785296278e+00,
        0.1209933725186615e-03,
        0.9600909041917725e+00,
        0.1210215452731320e-03,
        0.9605411878256951e+00,
        0.1210500927872672e-03,
        0.9609974951637526e+00,
        0.1210790247737047e-03,
        0.9614599858031973e+00,
        0.1211083505083695e-03,
        0.9619288125956789e+00,
        0.1211380787908609e-03,
        0.9624041210149244e+00,
        0.1211682179036361e-03,
        0.9628860485040654e+00,
        0.1211987755701019e-03,
        0.9633747238043349e+00,
        0.1212297589117476e-03,
        0.9638702662671197e+00
    ]
    mσ = SVector{46, T}(0.4102693550421609e+00, 0.3889624104727243e+00,
        0.3804692420283886e+00, 0.3760815680865637e+00,
        0.3735177579729938e+00, 0.3719340231904236e+00,
        0.3708571145968057e+00, 0.3700947006022557e+00,
        0.3695328931459086e+00, 0.3691085831661758e+00,
        0.3687813249652330e+00, 0.3685244707068931e+00,
        0.3683185599507446e+00, 0.3681542178682514e+00,
        0.3680181997765286e+00, 0.3679084456991284e+00,
        0.3678181571053212e+00, 0.3678314333608541e+00,
        0.3677897070402892e+00, 0.3681800192470787e+00,
        0.3681272993461229e+00, 0.3680840569645587e+00,
        0.3680522380648169e+00, 0.3680263578626069e+00,
        0.3680061275157194e+00, 0.3679837719607466e+00,
        0.3679668653311732e+00, 0.3679542340323301e+00,
        0.3679429332584250e+00, 0.3679349432021754e+00,
        0.3679290943359695e+00, 0.3679242023884676e+00,
        0.3679207541681089e+00, 0.3679185472223537e+00,
        0.3679168690130640e+00, 0.3679158588043139e+00,
        0.3679154592969145e+00, 0.3679154025286917e+00,
        0.3679157536198652e+00, 0.3679163676763697e+00,
        0.3679171904021983e+00, 0.3679181786833088e+00,
        0.3679192462983425e+00, 0.3679204323079710e+00,
        0.3679216942157868e+00, 0.3679229127010114e+00)
    mτ = SVector{46, T}(0.4495196112243335e+00, 0.4219428123056774e+00,
        0.4084335547255627e+00, 0.4009301129475925e+00,
        0.3963598727888637e+00, 0.3934034185789226e+00,
        0.3913676516238603e+00, 0.3899091428928617e+00,
        0.3888276962996660e+00, 0.3880048656683555e+00,
        0.3873650613539532e+00, 0.3868583585730354e+00,
        0.3864499054795832e+00, 0.3861178821587815e+00,
        0.3858426294881124e+00, 0.3856144554520791e+00,
        0.3854228843194507e+00, 0.3853156085078759e+00,
        0.3851902798680153e+00, 0.3853705093720269e+00,
        0.3851957294861824e+00, 0.3850587241670235e+00,
        0.3849515900397918e+00, 0.3848648995575697e+00,
        0.3847945082231300e+00, 0.3847117224407400e+00,
        0.3846478726309070e+00, 0.3845979020112835e+00,
        0.3845472492329918e+00, 0.3845088319509754e+00,
        0.3844789634065264e+00, 0.3844504092359686e+00,
        0.3844285235163634e+00, 0.3844115660464609e+00,
        0.3843957877945634e+00, 0.3843835767106759e+00,
        0.3843727001444428e+00, 0.3843632394180673e+00,
        0.3843553120908175e+00, 0.3843487746818896e+00,
        0.3843434800804404e+00, 0.3843392605995229e+00,
        0.3843359163858929e+00, 0.3843331309176606e+00,
        0.3843309056586355e+00, 0.3843292556220249e+00)
    recf2 = [0.30054882432319852e+00, 3.22956177884372447e-002,
        0.65120991030208131e+00, 0.63927408285239784e+00,
        0.18817870484330687e+00, 0.12949086796142287e+00,
        0.36929228994973123e+00, 0.79423840471651530e+00,
        0.12664547192283679e+00, 0.21664108914571936e+00,
        0.20317486666283888e+00, 0.68973985242086411e+00,
        9.21908883216204372e-002, 0.29196113742928459e+00,
        0.12953776672666439e+00, 0.64753069741124225e+00,
        7.04674356597705248e-002, 0.35542681683117394e+00,
        9.07656559588879974e-002, 0.63308457287703845e+00,
        5.56972163240425158e-002, 0.40821116352399822e+00,
        6.75873603555146030e-002, 0.62987020691884099e+00,
        4.52314510540424083e-002, 0.45349195419520988e+00,
        5.26792640272769619e-002, 0.63544049146955495e+00,
        3.75090089431679499e-002, 0.49254878544097452e+00,
        4.24187172939975016e-002, 0.64492463446289439e+00,
        3.16359249842285209e-002, 0.52655925121329283e+00,
        3.50084592084723006e-002, 0.65625931086167177e+00,
        2.70567578115501507e-002, 0.55637314400053972e+00,
        2.94518530499679777e-002, 0.66820831119420498e+00,
        2.34133112197160119e-002, 0.58269051732740407e+00,
        2.51619619046079893e-002, 0.68016212648713559e+00,
        2.04646775547950611e-002, 0.60607513381042866e+00,
        2.17715740132157810e-002, 0.69180700798111705e+00,
        1.80438530603851781e-002, 0.62699968191049693e+00,
        1.90405563718173375e-002, 0.70301681552660245e+00,
        1.60303791898168714e-002, 0.64578676274480384e+00,
        1.68036691319633329e-002, 0.71364055291529882e+00,
        1.43381155595692263e-002, 0.66279314317681104e+00,
        1.49474698654232484e-002, 0.72374979043766230e+00,
        1.29010469345403229e-002, 0.67820698333699947e+00,
        1.33876019527344771e-002, 0.73325173459248638e+00,
        1.16704063750699676e-002, 0.69225809088374535e+00,
        1.20635867943110296e-002, 0.74220670880892559e+00,
        1.05960860068959762e-002, 0.70409774151149940e+00,
        1.09137157668129162e-002, 0.74912368794796913e+00,
        9.67196979334120598e-003, 0.71571912134789384e+00,
        9.93328940958853462e-003, 0.75682127872922034e+00,
        8.83088049264354157e-003, 0.72531148608154128e+00,
        9.04470405177602854e-003, 0.76252635111977451e+00,
        7.49752975344448926e-003, 0.74429703765376476e+00,
        7.64800434979143792e-003, 0.77578014029362463e+00,
        6.44662499627499889e-003, 0.76096815709763777e+00,
        6.55579137697651689e-003, 0.78800467003589447e+00,
        5.60281614024690528e-003, 0.77561094416327303e+00,
        5.68395304265941533e-003, 0.79908793271372636e+00,
        4.91498711563015476e-003, 0.78857537163140357e+00,
        4.97655964855825590e-003, 0.80915785321209388e+00,
        4.34677636099067670e-003, 0.80013067395467885e+00,
        4.39435175554785291e-003, 0.81832611676512312e+00,
        3.66318896127087925e-003, 0.81528210787427102e+00,
        3.69645225382438190e-003, 0.83060983150728429e+00,
        3.12932516261230477e-003, 0.82830703488869506e+00,
        3.15328263217450966e-003, 0.84139832970083195e+00,
        2.70436963378157917e-003, 0.83962253184943458e+00,
        2.72206342429737571e-003, 0.85093545781738889e+00,
        2.26042359759308711e-003, 0.85257910142895765e+00,
        2.27263024268829815e-003, 0.86203477403609596e+00,
        1.91756286498312467e-003, 0.86360400196773612e+00,
        1.92625566335835651e-003, 0.87162622634542208e+00,
        1.64724830462023466e-003, 0.87309774409059548e+00,
        1.65360632024389928e-003, 0.87999012957388845e+00,
        1.38282637180050312e-003, 0.88325788374442715e+00,
        1.38726529640400696e-003, 0.88904518573092806e+00,
        1.17735415652783261e-003, 0.89191446947557840e+00,
        1.18054684817541270e-003, 0.89684312191677840e+00,
        1.01451581092078117e-003, 0.89937700618801175e+00,
        1.01687067063979284e-003, 0.90362505621891864e+00,
        8.60103370174555371e-004, 0.90707730831681010e+00,
        8.61784495458673642e-004, 0.91067987206956114e+00,
        7.38449838715945724e-004, 0.91368398581287302e+00,
        7.39681931222742860e-004, 0.91677790158328409e+00,
        6.26536494339523871e-004, 0.92029586163588439e+00,
        6.27418391065155223e-004, 0.92292169625918086e+00,
        5.27198841477638535e-004, 0.92671269154766700e+00,
        5.27819852569725331e-004, 0.92892292628852668e+00,
        4.41280305422330659e-004, 0.93279972419751356e+00,
        4.41713167579480665e-004, 0.93465036777095101e+00,
        3.68329890353293618e-004, 0.93847789237229962e+00,
        3.68630038146788787e-004, 0.94002310606534123e+00,
        3.07178106908066945e-004, 0.94371021901868613e+00,
        3.07385962489261657e-004, 0.94499930303266455e+00,
        2.56347982062857336e-004, 0.94848961070657511e+00,
        2.56492172806663330e-004, 0.94956571249033128e+00,
        2.14313657894793703e-004, 0.95282878437120277e+00,
        2.14414083069790993e-004, 0.95372869329467769e+00,
        1.77496073342213158e-004, 0.95700775895946888e+00,
        1.77564725268418032e-004, 0.95775328386720671e+00,
        1.46177341030384291e-004, 0.96093061882940878e+00,
        1.46223756910301701e-004, 0.96154476805768796e+00,
        1.21261174404466404e-004, 0.96437278515162772e+00,
        1.21293027834230952e-004, 0.96488237891070616e+00
    ]

    mα = SVector{5, T}(1.0, 1.0, 1.25, 1.29, 1.33)

    mn̂ = SVector{5, Int}(2, 2, 2, 3, 4)
    c1 = SVector{13, T}(0, 1, 0, 1, -0.5, 1.5, 0, -1.8, 2.8, 0, 0, -4.3, 5.3)
    c2 = SVector{13, T}(-0.7538, 1.7538, -2.7962, 3.7962, -0.0817, 1.0817,
        -2.0400, 2.7066, 0.3334, -4.7462, 5.2462, 0.2500, 0.2500)
    TangXiaoSROCK2ConstantCache{typeof(zprev), T}(
        ms, recf, mσ, mτ, recf2, mα, mn̂, c1, c2, zprev, 1, 1, 1, 1)
end

function KomBurSROCK2ConstantCache{T}(zprev) where {T}
    ms = SVector{46, Int}(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
        17, 18, 19, 20, 22, 24, 26, 28, 30, 33, 36, 39, 43,
        47, 51, 56, 61, 66, 72, 78, 85, 93, 102, 112, 123, 135, 148, 163, 180, 198)
    recf = [
        0.1794612899156781e+00,
        0.9326607661089206e-01,
        0.1268473641290642e+00,
        0.2103378190528467e-01,
        0.5786627125519110e-01,
        0.7776456841673992e-01,
        0.2157791817707098e-01,
        0.9528922876588625e-01,
        0.8723622960881585e-01,
        0.3957407527591189e-01,
        0.5338681630900877e-01,
        0.2247986572029358e-01,
        0.6393794866013653e-01,
        0.8616759602466630e-01,
        0.7433164225960258e-01,
        0.1608966052260327e+00,
        0.2881884349012583e-01,
        0.3903194468364506e-01,
        0.2315538732440072e-01,
        0.4666180548151659e-01,
        0.8821448969005685e-01,
        0.5288869100008489e-01,
        0.1558852247558841e+00,
        0.5955157767537859e-01,
        0.2309801425356076e+00,
        0.2193602641069006e-01,
        0.2980001095383432e-01,
        0.2364036352805737e-01,
        0.3566742298660092e-01,
        0.9017696352896830e-01,
        0.4023410528284037e-01,
        0.1575736612169138e+00,
        0.4421100494822930e-01,
        0.2217430621508580e+00,
        0.4869809870617736e-01,
        0.2940499060453847e+00,
        0.1726461340854506e-01,
        0.2350655101084081e-01,
        0.2399195202240830e-01,
        0.2817607209777294e-01,
        0.9173675182820953e-01,
        0.3176838133583184e-01,
        0.1600219376374877e+00,
        0.3469194451695863e-01,
        0.2221486436776174e+00,
        0.3738763501161190e-01,
        0.2814712676591709e+00,
        0.4053195010515956e-01,
        0.3498597719348680e+00,
        0.1394572558988917e-01,
        0.1901965402711647e-01,
        0.2425291169233543e-01,
        0.2282720812165174e-01,
        0.9294575674653435e-01,
        0.2575013323611407e-01,
        0.1622227426315588e+00,
        0.2807705415789230e-01,
        0.2243919049772138e+00,
        0.3005377306193452e-01,
        0.2802435651401261e+00,
        0.3196472247412495e-01,
        0.3348331353768858e+00,
        0.3423680369928859e-01,
        0.3989016641565190e+00,
        0.1150212461258425e-01,
        0.1570710434739234e-01,
        0.2445103607680476e-01,
        0.1887147450684578e-01,
        0.9388711032641100e-01,
        0.2130209293934879e-01,
        0.1640457400037581e+00,
        0.2322314183593871e-01,
        0.2267657098371261e+00,
        0.2480419563989607e-01,
        0.2818605427391582e+00,
        0.2620108024481186e-01,
        0.3319747646481704e+00,
        0.2760343567567814e-01,
        0.3822711818317003e+00,
        0.2928725018247521e-01,
        0.4419889482818066e+00,
        0.9650189035331108e-02,
        0.1319127118048348e-01,
        0.2460463437251803e-01,
        0.1586242507387037e-01,
        0.9462914691841271e-01,
        0.1791697874611395e-01,
        0.1655306545097223e+00,
        0.1953741662819831e-01,
        0.2288845437800309e+00,
        0.2085448736610660e-01,
        0.2840687821706643e+00,
        0.2197276738303543e-01,
        0.3327621634208670e+00,
        0.2299581340430604e-01,
        0.3779528907207973e+00,
        0.2405334751606276e-01,
        0.4244163000944219e+00,
        0.2532773055505536e-01,
        0.4799238174596328e+00,
        0.8212831461177801e-02,
        0.1123533801931148e-01,
        0.2472592539190680e-01,
        0.1351988263110243e-01,
        0.9522208667469109e-01,
        0.1527968649293853e-01,
        0.1667413647253854e+00,
        0.1666740304836073e-01,
        0.2306916351605186e+00,
        0.1778972104750926e-01,
        0.2862271893660237e+00,
        0.1872598244401872e-01,
        0.3345934460509904e+00,
        0.1954407472805166e-01,
        0.3778520013827246e+00,
        0.2031544030249000e-01,
        0.4188775043096391e+00,
        0.2113066217102199e-01,
        0.4619185110779211e+00,
        0.2211266742157054e-01,
        0.5134449754977242e+00,
        0.7074719613815112e-02,
        0.9684509591053977e-02,
        0.2482326781574381e-01,
        0.1166040318768419e-01,
        0.9570219065303219e-01,
        0.1318459890146430e-01,
        0.1677351729038757e+00,
        0.1438717215812115e-01,
        0.2322139970245483e+00,
        0.1535795943897448e-01,
        0.2881631572191675e+00,
        0.1616136143489047e-01,
        0.3366119552764601e+00,
        0.1684787625840699e-01,
        0.3791920530521655e+00,
        0.1746359793359561e-01,
        0.4179163657739238e+00,
        0.1805925334195525e-01,
        0.4554086296687285e+00,
        0.1869919690078058e-01,
        0.4953803203133830e+00,
        0.1946782991114719e-01,
        0.5431953913817005e+00,
        0.6158116280205625e-02,
        0.8434133870779752e-02,
        0.2490250308471492e-01,
        0.1015973796908432e-01,
        0.9609568511780181e-01,
        0.1149255448537381e-01,
        0.1685578212579456e+00,
        0.1254496388900155e-01,
        0.2334953976202505e+00,
        0.1339412026724050e-01,
        0.2898496927042313e+00,
        0.1409430683259744e-01,
        0.3385311597112782e+00,
        0.1468607650095395e-01,
        0.3809553853632720e+00,
        0.1520306181269769e-01,
        0.4187183922578105e+00,
        0.1567773486210682e-01,
        0.4536627812581018e+00,
        0.1614693417033556e-01,
        0.4881324072137513e+00,
        0.1665708022899876e-01,
        0.5253402953586265e+00,
        0.1726712768780420e-01,
        0.5697310475495430e+00,
        0.5408899288459016e-02,
        0.7411165652735432e-02,
        0.2496784203339785e-01,
        0.8931010375660927e-02,
        0.9642194989632852e-01,
        0.1010622203571924e-01,
        0.1692450860120974e+00,
        0.1103497280658699e-01,
        0.2345784420179126e+00,
        0.1178444954979593e-01,
        0.2913056300783272e+00,
        0.1240145878830343e-01,
        0.3402656182942943e+00,
        0.1292005530031986e-01,
        0.3827567779382510e+00,
        0.1336687811001040e-01,
        0.4201602339064523e+00,
        0.1376523513966666e-01,
        0.4539235794662016e+00,
        0.1413868046925951e-01,
        0.4856954694207845e+00,
        0.1451444200099929e-01,
        0.5175484724211766e+00,
        0.1492644572980292e-01,
        0.5522503690808819e+00,
        0.1541651122328756e-01,
        0.5934874290489524e+00,
        0.4788707289765767e-02,
        0.6563722805402352e-02,
        0.2502230585699310e-01,
        0.7912416503013329e-02,
        0.9669512238638367e-01,
        0.8956313102014822e-02,
        0.1698239427218661e+00,
        0.9781969024648538e-02,
        0.2354985079518828e+00,
        0.1044851744036037e-01,
        0.2925601105800896e+00,
        0.1099693219507985e-01,
        0.3418012690877302e+00,
        0.1145659208699840e-01,
        0.3844521174650939e+00,
        0.1184970544276362e-01,
        0.4217763245489749e+00,
        0.1219446847463953e-01,
        0.4550117593290032e+00,
        0.1250758855429112e-01,
        0.4854408050495134e+00,
        0.1280655793511545e-01,
        0.5145268041703330e+00,
        0.1311180392585363e-01,
        0.5440941264902900e+00,
        0.1344843304771755e-01,
        0.5765229845165943e+00,
        0.1384655622092475e-01,
        0.6148795064211108e+00,
        0.4269409473142479e-02,
        0.5853691221954542e-02,
        0.2506818803768801e-01,
        0.7058488452666192e-02,
        0.9692609816181726e-01,
        0.7991811416685026e-02,
        0.1703157380843560e+00,
        0.8730579305889177e-02,
        0.2362853743226745e+00,
        0.9327287399213484e-02,
        0.2936438651173445e+00,
        0.9818197983040463e-02,
        0.3431514772416978e+00,
        0.1022909697576184e-01,
        0.3859958359229893e+00,
        0.1057909230023007e-01,
        0.4233725763238417e+00,
        0.1088320687501712e-01,
        0.4564025740290915e+00,
        0.1115430586715170e-01,
        0.4861671131891395e+00,
        0.1140470198717317e-01,
        0.5137949407970326e+00,
        0.1164762828827466e-01,
        0.5405812657784165e+00,
        0.1189859698528282e-01,
        0.5681279106485080e+00,
        0.1217639078124160e-01,
        0.5984802463148428e+00,
        0.1250297795297910e-01,
        0.6341959825388761e+00,
        0.3830262680422776e-02,
        0.5252924239469980e-02,
        0.2510718258012232e-01,
        0.6335607341496969e-02,
        0.9712300411103620e-01,
        0.7174964200736387e-02,
        0.1707366515477548e+00,
        0.7839821469171156e-02,
        0.2369623770049865e+00,
        0.8377122084280812e-02,
        0.2945833847967025e+00,
        0.8819233466500510e-02,
        0.3443363340392364e+00,
        0.9189060633588098e-02,
        0.3873807210303031e+00,
        0.9503378800566590e-02,
        0.4248706039873364e+00,
        0.9775047051845269e-02,
        0.4578585641947919e+00,
        0.1001457306569686e-01,
        0.4873111192988822e+00,
        0.1023132837651919e-01,
        0.5141675256404127e+00,
        0.1043459649534057e-01,
        0.5394214279393358e+00,
        0.1063454146082206e-01,
        0.5642188354052674e+00,
        0.1084307018096031e-01,
        0.5899649430016252e+00,
        0.1107438039614643e-01,
        0.6184184090843611e+00,
        0.1134470195438803e-01,
        0.6517206797990772e+00,
        0.3454097785831183e-02,
        0.4738087690909603e-02,
        0.2514098616718916e-01,
        0.5715864568881495e-02,
        0.9729414530950285e-01,
        0.6474399737140852e-02,
        0.1711037123670141e+00,
        0.7075625560198937e-02,
        0.2375553213635903e+00,
        0.7561765789488958e-02,
        0.2954111541648083e+00,
        0.7961900378019848e-02,
        0.3453896252983967e+00,
        0.8296546652001753e-02,
        0.3886303020948080e+00,
        0.8580623356383655e-02,
        0.4262600339398994e+00,
        0.8825386359541219e-02,
        0.4592889162561250e+00,
        0.9039751450513938e-02,
        0.4886139630455138e+00,
        0.9231266796183848e-02,
        0.5150610315193943e+00,
        0.9406897826583457e-02,
        0.5394434170928742e+00,
        0.9573720059444631e-02,
        0.5626311157802961e+00,
        0.9739556257960886e-02,
        0.5856281920506604e+00,
        0.9913518363761172e-02,
        0.6096518917386764e+00,
        0.1010629643624125e-01,
        0.6361953557375821e+00,
        0.1032986385558493e-01,
        0.6670333276830246e+00,
        0.3131660281084644e-02,
        0.4296601495430642e-02,
        0.2516987418923732e-01,
        0.5184210888756367e-02,
        0.9744072529384443e-01,
        0.5873198129887241e-02,
        0.1714189769006723e+00,
        0.6419613566950146e-02,
        0.2380664100570842e+00,
        0.6861660893085171e-02,
        0.2961280333876439e+00,
        0.7225632384805198e-02,
        0.3463080420218410e+00,
        0.7530044942257158e-02,
        0.3897316580976775e+00,
        0.7788304877568383e-02,
        0.4275077537500284e+00,
        0.8010430934156830e-02,
        0.4606200718057599e+00,
        0.8204207591967734e-02,
        0.4899241115804965e+00,
        0.8376002129523446e-02,
        0.5161793704075401e+00,
        0.8531389917004647e-02,
        0.5400945718660145e+00,
        0.8675676859844067e-02,
        0.5623795630774431e+00,
        0.8814368379677447e-02,
        0.5838024839647016e+00,
        0.8953595816500299e-02,
        0.6052506199023559e+00,
        0.9100459154569437e-02,
        0.6277890216584121e+00,
        0.9263166205736671e-02,
        0.6527013571399886e+00,
        0.9450740555370751e-02,
        0.6814810379908328e+00,
        0.2843902743022214e-02,
        0.3902467368190393e-02,
        0.2519598783827689e-01,
        0.4709429895823432e-02,
        0.9757348323445656e-01,
        0.5336152661315786e-02,
        0.1717052034351406e+00,
        0.5833455676281756e-02,
        0.2385318286257855e+00,
        0.6235971415149352e-02,
        0.2967834040784211e+00,
        0.6567522559559145e-02,
        0.3471521575495951e+00,
        0.6844866528765064e-02,
        0.3907519751170857e+00,
        0.7080101687099548e-02,
        0.4286785748173565e+00,
        0.7282213357366904e-02,
        0.4618976089399920e+00,
        0.7458094741776693e-02,
        0.4912372216070018e+00,
        0.7613251892383208e-02,
        0.5174141871126332e+00,
        0.7752321382046524e-02,
        0.5410706897885087e+00,
        0.7879480568321315e-02,
        0.5628149979263304e+00,
        0.7998799282231232e-02,
        0.5832647350414633e+00,
        0.8114557939046675e-02,
        0.6030926481771959e+00,
        0.8231531848213922e-02,
        0.6230734887604330e+00,
        0.8355206753895567e-02,
        0.6441267697250795e+00,
        0.8491839744291131e-02,
        0.6673428282976036e+00,
        0.8648214015485162e-02,
        0.6939680907913989e+00,
        0.2388386682754135e-02,
        0.3278278227000989e-02,
        0.2523707236937346e-01,
        0.3957198838737114e-02,
        0.9778285117940603e-01,
        0.4484932501394734e-02,
        0.1721579526332683e+00,
        0.4904057483051761e-02,
        0.2392707453970052e+00,
        0.5243583901636578e-02,
        0.2978287368553751e+00,
        0.5523456007427060e-02,
        0.3485067686781220e+00,
        0.5757685183723855e-02,
        0.3924033610212076e+00,
        0.5956358204781419e-02,
        0.4305980352749587e+00,
        0.6126919713095007e-02,
        0.4640361265644109e+00,
        0.6275007901630985e-02,
        0.4935170207127558e+00,
        0.6405016526854853e-02,
        0.5197143572851120e+00,
        0.6520488779186820e-02,
        0.5432046533152863e+00,
        0.6624408123666273e-02,
        0.5644970257796814e+00,
        0.6719427053538581e-02,
        0.5840623664365776e+00,
        0.6808059512718916e-02,
        0.6023621974962409e+00,
        0.6892851836922015e-02,
        0.6198777517486085e+00,
        0.6976537015760206e-02,
        0.6371392310474401e+00,
        0.7062164945929763e-02,
        0.6547536993606798e+00,
        0.7153184521396811e-02,
        0.6734273362784953e+00,
        0.7253430606435754e-02,
        0.6939734212185117e+00,
        0.7366943161281851e-02,
        0.7172914790760468e+00,
        0.2034217998243191e-02,
        0.2792734020582961e-02,
        0.2526908982706098e-01,
        0.3371787305020115e-02,
        0.9794643062684199e-01,
        0.3822201062511950e-02,
        0.1725128108619325e+00,
        0.4180174912236582e-02,
        0.2398521447789659e+00,
        0.4470370456915701e-02,
        0.2986551495007976e+00,
        0.4709737539597480e-02,
        0.3495841277608567e+00,
        0.4910176531706057e-02,
        0.3937272155460690e+00,
        0.5080243210917943e-02,
        0.4321540636611387e+00,
        0.5226234784652425e-02,
        0.4657990145921906e+00,
        0.5352893648837146e-02,
        0.4954473934553277e+00,
        0.5463875356202293e-02,
        0.5217531788617480e+00,
        0.5562069670587001e-02,
        0.5452642338468077e+00,
        0.5649829175907964e-02,
        0.5664474938420431e+00,
        0.5729139522573558e-02,
        0.5857122023051498e+00,
        0.5801753106324432e-02,
        0.6034312542567038e+00,
        0.5869300229750696e-02,
        0.6199612865321288e+00,
        0.5933386406539511e-02,
        0.6356621535317655e+00,
        0.5995679940966749e-02,
        0.6509160921778130e+00,
        0.6057989063542723e-02,
        0.6661462081376089e+00,
        0.6122321685397079e-02,
        0.6818327797828450e+00,
        0.6190912476732130e-02,
        0.6985240974244095e+00,
        0.6266191569573649e-02,
        0.7168360261395987e+00,
        0.6350658968555684e-02,
        0.7374314365934664e+00,
        0.1753390300533029e-02,
        0.2407592405123618e-02,
        0.2529453985226700e-01,
        0.2907262330175829e-02,
        0.9807671703676038e-01,
        0.3296143053353250e-02,
        0.1727961462451250e+00,
        0.3605393786629613e-02,
        0.2403177529025610e+00,
        0.3856241133152162e-02,
        0.2993193629853389e+00,
        0.4063271707574896e-02,
        0.3504538499243808e+00,
        0.4236723270781009e-02,
        0.3948018542411614e+00,
        0.4383951358482999e-02,
        0.4334263916612830e+00,
        0.4510362519918408e-02,
        0.4672550951343391e+00,
        0.4620017586359210e-02,
        0.4970655128750277e+00,
        0.4716030788908096e-02,
        0.5235015776135139e+00,
        0.4800840911719355e-02,
        0.5470972903869747e+00,
        0.4876401000932111e-02,
        0.5682998788764699e+00,
        0.4944315587632199e-02,
        0.5874903820382004e+00,
        0.5005943872710219e-02,
        0.6050015924522462e+00,
        0.5062480886612362e-02,
        0.6211339094140743e+00,
        0.5115024538196171e-02,
        0.6361697673414449e+00,
        0.5164633649628788e-02,
        0.6503872077614197e+00,
        0.5212379842880342e-02,
        0.6640729475349860e+00,
        0.5259393975018879e-02,
        0.6775349550821846e+00,
        0.5306905271212799e-02,
        0.6911140242391297e+00,
        0.5356268008877997e-02,
        0.7051930501274516e+00,
        0.5408966392479879e-02,
        0.7202015894622125e+00,
        0.5466583459521371e-02,
        0.7366118374462400e+00,
        0.5530715851949468e-02,
        0.7549206082556241e+00,
        0.1526985597447617e-02,
        0.2096996473761840e-02,
        0.2531509673360445e-01,
        0.2532539440756325e-02,
        0.9818212210216928e-01,
        0.2871665019548934e-02,
        0.1730258242612469e+00,
        0.3141479576178890e-02,
        0.2406960805778798e+00,
        0.3360448272795954e-02,
        0.2998605891705305e+00,
        0.3541258850863859e-02,
        0.3511649206182530e+00,
        0.3692814597959592e-02,
        0.3956840637564039e+00,
        0.3821509918296340e-02,
        0.4344762665775814e+00,
        0.3932041593754749e-02,
        0.4684646795111045e+00,
        0.4027932600409154e-02,
        0.4984220865031195e+00,
        0.4111877834418150e-02,
        0.5249867454711314e+00,
        0.4185977901331621e-02,
        0.5486853051737176e+00,
        0.4251901290680174e-02,
        0.5699549871771356e+00,
        0.4310999960360177e-02,
        0.5891629130044663e+00,
        0.4364394207792517e-02,
        0.6066224358437886e+00,
        0.4413037135908646e-02,
        0.6226069634301489e+00,
        0.4457765549253931e-02,
        0.6373618910220726e+00,
        0.4499341872619412e-02,
        0.6511152177198366e+00,
        0.4538490146036315e-02,
        0.6640873078294923e+00,
        0.4575927973865173e-02,
        0.6765001110571239e+00,
        0.4612395244609121e-02,
        0.6885859633887566e+00,
        0.4648679290544145e-02,
        0.7005958269983906e+00,
        0.4685634750981115e-02,
        0.7128064532627977e+00,
        0.4724194620734037e-02,
        0.7255254273702650e+00,
        0.4765366815800576e-02,
        0.7390923556807402e+00,
        0.4810208361466176e-02,
        0.7538736313498631e+00,
        0.4859767798035730e-02,
        0.7702474410767316e+00,
        0.1341778429126211e-02,
        0.1842856050972565e-02,
        0.2533193854590164e-01,
        0.2225855496752996e-02,
        0.9826859006407132e-01,
        0.2524180832845478e-02,
        0.1732145392603280e+00,
        0.2761629971248482e-02,
        0.2410075282122661e+00,
        0.2954414092304398e-02,
        0.3003071440620802e+00,
        0.3113671483601745e-02,
        0.3517531700231469e+00,
        0.3247217194092525e-02,
        0.3964161974860505e+00,
        0.3360662822142730e-02,
        0.4353508843394245e+00,
        0.3458128531982532e-02,
        0.4694771791546352e+00,
        0.3542702530515273e-02,
        0.4995646943102908e+00,
        0.3616743969933074e-02,
        0.5262481851213445e+00,
        0.3682087306007793e-02,
        0.5500500545141821e+00,
        0.3740183451080423e-02,
        0.5714020312900166e+00,
        0.3792199619292558e-02,
        0.5906638632386166e+00,
        0.3839091722399387e-02,
        0.6081388453953844e+00,
        0.3881658284331042e-02,
        0.6240866310409383e+00,
        0.3920581807177477e-02,
        0.6387339085746301e+00,
        0.3956461592009382e-02,
        0.6522834922619609e+00,
        0.3989840752967416e-02,
        0.6649222876852415e+00,
        0.4021229291927125e-02,
        0.6768284931080795e+00,
        0.4051124448454234e-02,
        0.6881782931898644e+00,
        0.4080028981647300e-02,
        0.6991521843388895e+00,
        0.4108467479283411e-02,
        0.7099409264259735e+00,
        0.4137000143073717e-02,
        0.7207509236661780e+00,
        0.4166232701476242e-02,
        0.7318085765567045e+00,
        0.4196820124371787e-02,
        0.7433628001322098e+00,
        0.4229460707743591e-02,
        0.7556844737332599e+00,
        0.4264876064174216e-02,
        0.7690611204503529e+00,
        0.4303772042593957e-02,
        0.7837847386079905e+00,
        0.1121314683543782e-02,
        0.1540263996358294e-02,
        0.2535201582246297e-01,
        0.1860616782749459e-02,
        0.9837180081070001e-01,
        0.2110257847461394e-02,
        0.1734401492675452e+00,
        0.2309054725495130e-02,
        0.2413805649139678e+00,
        0.2470541128098822e-02,
        0.3008431837086572e+00,
        0.2604015187479208e-02,
        0.3524611103987945e+00,
        0.2716000109093522e-02,
        0.3972999402435936e+00,
        0.2811178999641960e-02,
        0.4364103598053284e+00,
        0.2892989192294541e-02,
        0.4707089285552096e+00,
        0.2964005631609554e-02,
        0.5009621096861159e+00,
        0.3026193412069002e-02,
        0.5278014394899639e+00,
        0.3081077890619739e-02,
        0.5517457095527168e+00,
        0.3129861843706196e-02,
        0.5732222749918362e+00,
        0.3173507910562157e-02,
        0.5925852995229407e+00,
        0.3212797846468413e-02,
        0.6101307283827272e+00,
        0.3248376022424070e-02,
        0.6261084073494506e+00,
        0.3280782072682338e-02,
        0.6407319017471913e+00,
        0.3310475987498136e-02,
        0.6541865362303725e+00,
        0.3337857911967330e-02,
        0.6666360953708608e+00,
        0.3363284226199348e-02,
        0.6782285398626227e+00,
        0.3387081014309363e-02,
        0.6891010163282705e+00,
        0.3409555695216232e-02,
        0.6993843710724037e+00,
        0.3431007330102873e-02,
        0.7092073156356478e+00,
        0.3451735898380667e-02,
        0.7187003283870178e+00,
        0.3472050613465582e-02,
        0.7279993040305766e+00,
        0.3492277104239913e-02,
        0.7372488732478574e+00,
        0.3512762995683089e-02,
        0.7466051990304045e+00,
        0.3533881070388274e-02,
        0.7562379075535515e+00,
        0.3556028788751684e-02,
        0.7663306282943305e+00,
        0.3579622533335547e-02,
        0.7770794116956159e+00,
        0.3605084625764653e-02,
        0.7886880974410957e+00,
        0.3632821128406038e-02,
        0.8013595930224617e+00,
        0.9510596127542824e-03,
        0.1306530384822369e-02,
        0.2536754145655561e-01,
        0.1578428318009605e-02,
        0.9845171104183325e-01,
        0.1790384464545768e-02,
        0.1736150904003335e+00,
        0.1959236797520781e-02,
        0.2416703438788951e+00,
        0.2096455322227467e-02,
        0.3012604613663233e+00,
        0.2209920074417597e-02,
        0.3530135437139923e+00,
        0.2305159021830049e-02,
        0.3979914926982783e+00,
        0.2386140355447109e-02,
        0.4372421218440167e+00,
        0.2455776174573485e-02,
        0.4716796241323911e+00,
        0.2516247355295036e-02,
        0.5020683797660233e+00,
        0.2569217475366734e-02,
        0.5290379452961959e+00,
        0.2615976824974766e-02,
        0.5531050686294569e+00,
        0.2657541470416690e-02,
        0.5746948225947125e+00,
        0.2694722818617351e-02,
        0.5941586518170510e+00,
        0.2728177434091533e-02,
        0.6117891098846177e+00,
        0.2758443393525188e-02,
        0.6278316916720729e+00,
        0.2785967312803683e-02,
        0.6424943013679313e+00,
        0.2811124820961013e-02,
        0.6559548636293389e+00,
        0.2834236378150614e-02,
        0.6683675049794192e+00,
        0.2855579757979202e-02,
        0.6798676490616872e+00,
        0.2875400127857228e-02,
        0.6905762965442401e+00,
        0.2893918395849096e-02,
        0.7006037006910071e+00,
        0.2911338305155523e-02,
        0.7100526010841707e+00,
        0.2927852618951001e-02,
        0.7190211375279999e+00,
        0.2943648628770056e-02,
        0.7276055302511653e+00,
        0.2958913124102285e-02,
        0.7359025774945679e+00,
        0.2973836867449520e-02,
        0.7440119836573593e+00,
        0.2988618517881438e-02,
        0.7520384865047949e+00,
        0.3003467829003067e-02,
        0.7600936967329708e+00,
        0.3018607809042993e-02,
        0.7682974943112553e+00,
        0.3034275371809675e-02,
        0.7767787422315526e+00,
        0.3050719837809893e-02,
        0.7856749823571740e+00,
        0.3068198491381527e-02,
        0.7951306800776951e+00,
        0.3086968312155531e-02,
        0.8052935061547398e+00,
        0.3107273055760290e-02,
        0.8163081231039382e+00,
        0.8168405299925574e-03,
        0.1122235164426433e-02,
        0.2537979319269659e-01,
        0.1355887567479481e-02,
        0.9851483086228864e-01,
        0.1538080541563495e-02,
        0.1737534362414166e+00,
        0.1683267147792567e-02,
        0.2418998259562802e+00,
        0.1801292850812278e-02,
        0.3015914511597799e+00,
        0.1898921476480742e-02,
        0.3534525616677698e+00,
        0.1980897763334222e-02,
        0.3985422441814719e+00,
        0.2050627450222160e-02,
        0.4379061538920372e+00,
        0.2110609627253456e-02,
        0.4724567457971343e+00,
        0.2162715579344156e-02,
        0.5029569229728563e+00,
        0.2208372378885260e-02,
        0.5300349067999921e+00,
        0.2248686443403842e-02,
        0.5542061521610998e+00,
        0.2284528486070424e-02,
        0.5758943864439198e+00,
        0.2316593115008434e-02,
        0.5954495572468082e+00,
        0.2345441446771229e-02,
        0.6131624579583983e+00,
        0.2371532122833287e-02,
        0.6292764292152166e+00,
        0.2395244271202193e-02,
        0.6439966702794445e+00,
        0.2416894786788224e-02,
        0.6574976613071741e+00,
        0.2436751550587987e-02,
        0.6699291171394233e+00,
        0.2455043712749272e-02,
        0.6814208098492533e+00,
        0.2471969833678045e-02,
        0.6920865249452547e+00,
        0.2487704452255031e-02,
        0.7020273575786585e+00,
        0.2502403494283208e-02,
        0.7113345090150194e+00,
        0.2516208823898241e-02,
        0.7200917075437527e+00,
        0.2529252160257252e-02,
        0.7283773493344920e+00,
        0.2541658520726186e-02,
        0.7362664311381890e+00,
        0.2553549302394987e-02,
        0.7438323260356781e+00,
        0.2565045070295341e-02,
        0.7511484336838515e+00,
        0.2576268078538789e-02,
        0.7582897158118264e+00,
        0.2587344505847411e-02,
        0.7653341042347025e+00,
        0.2598406336420720e-02,
        0.7723637406308460e+00,
        0.2609592758562768e-02,
        0.7794659733020046e+00,
        0.2621050886496552e-02,
        0.7867339953288847e+00,
        0.2632935537833889e-02,
        0.7942669615898086e+00,
        0.2645407727623461e-02,
        0.8021693721981406e+00,
        0.2658631484279102e-02,
        0.8105494642340256e+00,
        0.2672768576741324e-02,
        0.8195163250963701e+00,
        0.2687970799566830e-02,
        0.8291754492311013e+00,
        0.6779619032019482e-03,
        0.9315109162316307e-03,
        0.2539248163813982e-01,
        0.1125546650705646e-02,
        0.9858025661395591e-01,
        0.1276892135791717e-02,
        0.1738969874989156e+00,
        0.1397535825902466e-02,
        0.2421382412064102e+00,
        0.1495644371531161e-02,
        0.3019358267641449e+00,
        0.1576828175558173e-02,
        0.3539100964089328e+00,
        0.1645022736116236e-02,
        0.3991173116956755e+00,
        0.1703052777188943e-02,
        0.4386009869035954e+00,
        0.1752990885928625e-02,
        0.4732718824089663e+00,
        0.1796388809395077e-02,
        0.5038914977622926e+00,
        0.1834429731186084e-02,
        0.5310868327976426e+00,
        0.1868030737964622e-02,
        0.5553722186397624e+00,
        0.1897913248880432e-02,
        0.5771702844407484e+00,
        0.1924652401977583e-02,
        0.5968298361224380e+00,
        0.1948712334483372e-02,
        0.6146404100545767e+00,
        0.1970471824369135e-02,
        0.6308438946964407e+00,
        0.1990243228225435e-02,
        0.6456437499005518e+00,
        0.2008286680798674e-02,
        0.6592123207734590e+00,
        0.2024820896049421e-02,
        0.6716966627198852e+00,
        0.2040031498715453e-02,
        0.6832232108862492e+00,
        0.2054077540780530e-02,
        0.6939015548982263e+00,
        0.2067096670752565e-02,
        0.7038275213823140e+00,
        0.2079209295013150e-02,
        0.7130857211033993e+00,
        0.2090521980414542e-02,
        0.7217516823653617e+00,
        0.2101130283221459e-02,
        0.7298936653027928e+00,
        0.2111121143106236e-02,
        0.7375742308368269e+00,
        0.2120574946574002e-02,
        0.7448516217331510e+00,
        0.2129567338002603e-02,
        0.7517810000528958e+00,
        0.2138170835613056e-02,
        0.7584155742314791e+00,
        0.2146456292026427e-02,
        0.7648076391248480e+00,
        0.2154494222946041e-02,
        0.7710095427995872e+00,
        0.2162356011555635e-02,
        0.7770745838488886e+00,
        0.2170114979286494e-02,
        0.7830578318730199e+00,
        0.2177847294739602e-02,
        0.7890168508176265e+00,
        0.2185632671118797e-02,
        0.7950122895929717e+00,
        0.2193554778405604e-02,
        0.8011082865424130e+00,
        0.2201701270375675e-02,
        0.8073726141153927e+00,
        0.2210163300386258e-02,
        0.8138764685711868e+00,
        0.2219034377453016e-02,
        0.8206937889887615e+00,
        0.2228408401671311e-02,
        0.8278999743285053e+00,
        0.2238376724427438e-02,
        0.8355698630075664e+00,
        0.2249024115421597e-02,
        0.8437748549346639e+00,
        0.5717171765067005e-03,
        0.7855819755678591e-03,
        0.2540219552841172e-01,
        0.9492803029534314e-03,
        0.9863038311884588e-01,
        0.1076991591417719e-02,
        0.1740070746137774e+00,
        0.1178820912278011e-02,
        0.2423212835361945e+00,
        0.1261652009696089e-02,
        0.3022005646620261e+00,
        0.1330213911048136e-02,
        0.3542623490383656e+00,
        0.1387823796651901e-02,
        0.3995607968545022e+00,
        0.1436862514566579e-02,
        0.4391378457027524e+00,
        0.1479076886266864e-02,
        0.4739030248719332e+00,
        0.1515774672793500e-02,
        0.5046168340722528e+00,
        0.1547952929687645e-02,
        0.5319054272436042e+00,
        0.1576384371750672e-02,
        0.5562823875920914e+00,
        0.1601676728454795e-02,
        0.5781696502895681e+00,
        0.1624314356699193e-02,
        0.5979153431712045e+00,
        0.1644687957566232e-02,
        0.6158083043507766e+00,
        0.1663116161966728e-02,
        0.6320896668598296e+00,
        0.1679861458243818e-02,
        0.6469620376959935e+00,
        0.1695142117261203e-02,
        0.6605967661879515e+00,
        0.1709141243106296e-02,
        0.6731397164733577e+00,
        0.1722013731055875e-02,
        0.6847158755342791e+00,
        0.1733891682879084e-02,
        0.6954330559199739e+00,
        0.1744888672268816e-02,
        0.7053848938737558e+00,
        0.1755103144742999e-02,
        0.7146532979347533e+00,
        0.1764621160512043e-02,
        0.7233104679728801e+00,
        0.1773518635044922e-02,
        0.7314205777797613e+00,
        0.1781863193450182e-02,
        0.7390411938444027e+00,
        0.1789715726676655e-02,
        0.7462244872361469e+00,
        0.1797131716770826e-02,
        0.7530182833863068e+00,
        0.1804162382812431e-02,
        0.7594669850655551e+00,
        0.1810855687135456e-02,
        0.7656123962667175e+00,
        0.1817257231900906e-02,
        0.7714944684438817e+00,
        0.1823411068174413e-02,
        0.7771519851570839e+00,
        0.1829360432715894e-02,
        0.7826231962275617e+00,
        0.1835148421173907e-02,
        0.7879464076688663e+00,
        0.1840818599844342e-02,
        0.7931605286026111e+00,
        0.1846415551221751e-02,
        0.7983055707993119e+00,
        0.1851985340937259e-02,
        0.8034230901440029e+00,
        0.1857575885138658e-02,
        0.8085565520117598e+00,
        0.1863237187886467e-02,
        0.8137515941551513e+00,
        0.1869021407926604e-02,
        0.8190561513413812e+00,
        0.1874982703844713e-02,
        0.8245203960095123e+00,
        0.1881176797227895e-02,
        0.8301964394574721e+00,
        0.1887660186864975e-02,
        0.8361377299185951e+00,
        0.1894488945824785e-02,
        0.8423980794999191e+00,
        0.1901717040890795e-02,
        0.8490302543125971e+00,
        0.1909394134299323e-02,
        0.8560840749607826e+00,
        0.4886273679748824e-03,
        0.6714437954649780e-03,
        0.2540979640585205e-01,
        0.8113983041306847e-03,
        0.9866962915608751e-01,
        0.9206047809355559e-03,
        0.1740933291741878e+00,
        0.1007696615844565e-02,
        0.2424648238198073e+00,
        0.1078555077304152e-02,
        0.3024083787838030e+00,
        0.1137220495111209e-02,
        0.3545391775646764e+00,
        0.1186526928471642e-02,
        0.3999097732746233e+00,
        0.1228508433020824e-02,
        0.4395609067610286e+00,
        0.1264657346363223e-02,
        0.4744011819765317e+00,
        0.1296090864949680e-02,
        0.5051903569581037e+00,
        0.1323660708324793e-02,
        0.5325539695623672e+00,
        0.1348026906055910e-02,
        0.5570050719753680e+00,
        0.1369708506508536e-02,
        0.5789651232823036e+00,
        0.1389119124621932e-02,
        0.5987818060211025e+00,
        0.1406592323781286e-02,
        0.6167435227777786e+00,
        0.1422400048200691e-02,
        0.6330909609625438e+00,
        0.1436766218460017e-02,
        0.6480262517065541e+00,
        0.1449876904280157e-02,
        0.6617202166442876e+00,
        0.1461888037961801e-02,
        0.6743181164063009e+00,
        0.1472931335824075e-02,
        0.6859442313853145e+00,
        0.1483118897071317e-02,
        0.6967055330639804e+00,
        0.1492546815085222e-02,
        0.7066946457906411e+00,
        0.1501298043441827e-02,
        0.7159922532405723e+00,
        0.1509444694127518e-02,
        0.7246690686840157e+00,
        0.1517049899494373e-02,
        0.7327874613555573e+00,
        0.1524169336541220e-02,
        0.7404028107621932e+00,
        0.1530852488184009e-02,
        0.7475646451451914e+00,
        0.1537143698611175e-02,
        0.7543176083360913e+00,
        0.1543083066767105e-02,
        0.7607022900146448e+00,
        0.1548707212186899e-02,
        0.7667559471993193e+00,
        0.1554049939909855e-02,
        0.7725131391565733e+00,
        0.1559142825373070e-02,
        0.7780062934020589e+00,
        0.1564015735548671e-02,
        0.7832662167717693e+00,
        0.1568697298775154e-02,
        0.7883225624132202e+00,
        0.1573215332462839e-02,
        0.7932042607791593e+00,
        0.1577597234898074e-02,
        0.7979399201221365e+00,
        0.1581870344542036e-02,
        0.8025581994310868e+00,
        0.1586062267357487e-02,
        0.8070881540792818e+00,
        0.1590201169665478e-02,
        0.8115595515386726e+00,
        0.1594316030726550e-02,
        0.8160031512482756e+00,
        0.1598436845587962e-02,
        0.8204509390209540e+00,
        0.1602594764727253e-02,
        0.8249363021965111e+00,
        0.1606822152724702e-02,
        0.8294941271358440e+00,
        0.1611152543807615e-02,
        0.8341607957498925e+00,
        0.1615620467991531e-02,
        0.8389740528796195e+00,
        0.1620261118280227e-02,
        0.8439727120207893e+00,
        0.1625109827821845e-02,
        0.8491961639288420e+00,
        0.1630201327174513e-02,
        0.8546836521716283e+00,
        0.1635568757273152e-02,
        0.8604732831634605e+00,
        0.1641242424784281e-02,
        0.8666007472872529e+00,
        0.4079721290191449e-03,
        0.5606390646000299e-03,
        0.2541717774246925e-01,
        0.6775302011759068e-03,
        0.9870776119617667e-01,
        0.7687559860220674e-03,
        0.1741771883435951e+00,
        0.8415222726271052e-03,
        0.2426044825025154e+00,
        0.9007379123407699e-03,
        0.3026107489587744e+00,
        0.9497751982407300e-03,
        0.3548090209828054e+00,
        0.9909995793709382e-03,
        0.4002503224647114e+00,
        0.1026108754684635e-02,
        0.4399742629913482e+00,
        0.1056348256439421e-02,
        0.4748885789654610e+00,
        0.1082650488031221e-02,
        0.5057523403210778e+00,
        0.1105726258156915e-02,
        0.5331905211809378e+00,
        0.1126126368448291e-02,
        0.5577156967903346e+00,
        0.1144283937532252e-02,
        0.5797489091761477e+00,
        0.1160544069671673e-02,
        0.5996374632935472e+00,
        0.1175185037186027e-02,
        0.6176694070801912e+00,
        0.1188433661215005e-02,
        0.6340850818085325e+00,
        0.1200476654074482e-02,
        0.6490862674574624e+00,
        0.1211469103358439e-02,
        0.6628434159685319e+00,
        0.1221540901759423e-02,
        0.6755013855037041e+00,
        0.1230801679415364e-02,
        0.6871840056733981e+00,
        0.1239344630375328e-02,
        0.6979977314932807e+00,
        0.1247249512545108e-02,
        0.7080345854591738e+00,
        0.1254585023077141e-02,
        0.7173745414939689e+00,
        0.1261410697040181e-02,
        0.7260874694062653e+00,
        0.1267778438847666e-02,
        0.7342347316708526e+00,
        0.1273733768408534e-02,
        0.7418705038821782e+00,
        0.1279316843997812e-02,
        0.7490428746151535e+00,
        0.1284563309197927e-02,
        0.7557947684726961e+00,
        0.1289505000406732e-02,
        0.7621647269098429e+00,
        0.1294170543282941e-02,
        0.7681875743244604e+00,
        0.1298585860357731e-02,
        0.7738949913863433e+00,
        0.1302774607351322e-02,
        0.7793160132569095e+00,
        0.1306758552112867e-02,
        0.7844774669407445e+00,
        0.1310557907271291e-02,
        0.7894043592864977e+00,
        0.1314191625436819e-02,
        0.7941202249469652e+00,
        0.1317677663971441e-02,
        0.7986474417822638e+00,
        0.1321033224831176e-02,
        0.8030075196380616e+00,
        0.1324274973678666e-02,
        0.8072213670641986e+00,
        0.1327419241294216e-02,
        0.8113095392825265e+00,
        0.1330482209212664e-02,
        0.8152924695008139e+00,
        0.1333480080427699e-02,
        0.8191906844434980e+00,
        0.1336429234887632e-02,
        0.8230250036771799e+00,
        0.1339346368318267e-02,
        0.8268167209024656e+00,
        0.1342248611619848e-02,
        0.8305877638256554e+00,
        0.1345153626679458e-02,
        0.8343608274878259e+00,
        0.1348079672919514e-02,
        0.8381594740079385e+00,
        0.1351045637295423e-02,
        0.8420081896122813e+00,
        0.1354071018825960e-02,
        0.8459323876377299e+00,
        0.1357175857202399e-02,
        0.8499583440311814e+00,
        0.1360380593752449e-02,
        0.8541130499173916e+00,
        0.1363705852281417e-02,
        0.8584239643605064e+00,
        0.1367172127403134e-02,
        0.8629186498951948e+00,
        0.1370799369307807e-02,
        0.8676242742545543e+00,
        0.1374606456942832e-02,
        0.8725669645681554e+00,
        0.1378610556753209e-02,
        0.8777710057814074e+00,
        0.3457584334322357e-03,
        0.4751621453940012e-03,
        0.2542287327621289e-01,
        0.5742529802903852e-03,
        0.9873719754448177e-01,
        0.6515970827455522e-03,
        0.1742419598034706e+00,
        0.7132998513406398e-03,
        0.2427124231693788e+00,
        0.7635205129753468e-03,
        0.3027672771691929e+00,
        0.8051163841037499e-03,
        0.3550179179580828e+00,
        0.8400916805185935e-03,
        0.4005142108161735e+00,
        0.8698848276663640e-03,
        0.4402949133244795e+00,
        0.8955511242402197e-03,
        0.4752671131865228e+00,
        0.9178805496049455e-03,
        0.5061893703422927e+00,
        0.9374753213346000e-03,
        0.5336862457066851e+00,
        0.9548020787478288e-03,
        0.5582699698916923e+00,
        0.9702277440292999e-03,
        0.5803612891309488e+00,
        0.9840446600062942e-03,
        0.6003072470093884e+00,
        0.9964885371329648e-03,
        0.6183956534407280e+00,
        0.1007751484296832e-02,
        0.6348666260010463e+00,
        0.1017991617422186e-02,
        0.6499217274752063e+00,
        0.1027340245776507e-02,
        0.6637311918729225e+00,
        0.1035907317136567e-02,
        0.6764396515818053e+00,
        0.1043785593537480e-02,
        0.6881706952754520e+00,
        0.1051053889330778e-02,
        0.6990305140455065e+00,
        0.1057779608173888e-02,
        0.7091108348943870e+00,
        0.1064020749985821e-02,
        0.7184912951109098e+00,
        0.1069827513031319e-02,
        0.7272413759474827e+00,
        0.1075243583787733e-02,
        0.7354219871919199e+00,
        0.1080307183927825e-02,
        0.7430867737680106e+00,
        0.1085051926828077e-02,
        0.7502831998805611e+00,
        0.1089507523598374e-02,
        0.7570534542643864e+00,
        0.1093700369430917e-02,
        0.7634352109083323e+00,
        0.1097654034185638e-02,
        0.7694622725315966e+00,
        0.1101389675935647e-02,
        0.7751651185850800e+00,
        0.1104926392241615e-02,
        0.7805713752558724e+00,
        0.1108281520887288e-02,
        0.7857062215827314e+00,
        0.1111470899456480e-02,
        0.7905927431287384e+00,
        0.1114509091294428e-02,
        0.7952522425401743e+00,
        0.1117409583946746e-02,
        0.7997045146224264e+00,
        0.1120184965012693e-02,
        0.8039680921873576e+00,
        0.1122847079414237e-02,
        0.8080604677961332e+00,
        0.1125407171312882e-02,
        0.8119982955768120e+00,
        0.1127876013259072e-02,
        0.8157975764884198e+00,
        0.1130264024599364e-02,
        0.8194738296925913e+00,
        0.1132581380665879e-02,
        0.8230422520462021e+00,
        0.1134838113807109e-02,
        0.8265178671142719e+00,
        0.1137044206868379e-02,
        0.8299156644956935e+00,
        0.1139209679276770e-02,
        0.8332507296316362e+00,
        0.1141344665414018e-02,
        0.8365383636069283e+00,
        0.1143459484459602e-02,
        0.8397941917404019e+00,
        0.1145564700346352e-02,
        0.8430342589770379e+00,
        0.1147671169888255e-02,
        0.8462751092344150e+00,
        0.1149790076517388e-02,
        0.8495338449183082e+00,
        0.1151932946415512e-02,
        0.8528281618190179e+00,
        0.1154111643169411e-02,
        0.8561763535592529e+00,
        0.1156338336456831e-02,
        0.8595972787361906e+00,
        0.1158625439740416e-02,
        0.8631102829627566e+00,
        0.1160985511591647e-02,
        0.8667350672783336e+00,
        0.1163431115191409e-02,
        0.8704914940179440e+00,
        0.1165974630888303e-02,
        0.8743993213928760e+00,
        0.1168628017588916e-02,
        0.8784778589727296e+00,
        0.1171402520361833e-02,
        0.8827455382208639e+00,
        0.1174308324102304e-02,
        0.8872193954732928e+00,
        0.2967633115387107e-03,
        0.4078420646640203e-03,
        0.2542735980046100e-01,
        0.4929083178239419e-03,
        0.9876039342539503e-01,
        0.5593126751285800e-03,
        0.1742930216852869e+00,
        0.6122943067439731e-03,
        0.2427975603509948e+00,
        0.6554223612098552e-03,
        0.3028908101007459e+00,
        0.6911487848386306e-03,
        0.3551828911240184e+00,
        0.7211934487136871e-03,
        0.4007227692617545e+00,
        0.7467906965300383e-03,
        0.4405485438561624e+00,
        0.7688460941907184e-03,
        0.4755668043199200e+00,
        0.7880375248105768e-03,
        0.5065357215285611e+00,
        0.8048817439819273e-03,
        0.5340795437694515e+00,
        0.8197791606092136e-03,
        0.5587102435529917e+00,
        0.8330446107364092e-03,
        0.5808483484024387e+00,
        0.8449289291109885e-03,
        0.6008407117558368e+00,
        0.8556343498905160e-03,
        0.6189749738875788e+00,
        0.8653256884173914e-03,
        0.6354910969728228e+00,
        0.8741385860890042e-03,
        0.6505904974988862e+00,
        0.8821856763681789e-03,
        0.6644432678330569e+00,
        0.8895612564439208e-03,
        0.6771938992957999e+00,
        0.8963448693257790e-03,
        0.6889658361211737e+00,
        0.9026040810144197e-03,
        0.6998651175897177e+00,
        0.9083966557751288e-03,
        0.7099833073204581e+00,
        0.9137722762541778e-03,
        0.7193998631153847e+00,
        0.9187739158093501e-03,
        0.7281840656590849e+00,
        0.9234389425261854e-03,
        0.7363965975579181e+00,
        0.9278000143753827e-03,
        0.7440908437477774e+00,
        0.9318858104408874e-03,
        0.7513139686822109e+00,
        0.9357216324926973e-03,
        0.7581078137561323e+00,
        0.9393299032829178e-03,
        0.7645096492310164e+00,
        0.9427305820375386e-03,
        0.7705528078328676e+00,
        0.9459415131589371e-03,
        0.7762672216898303e+00,
        0.9489787207614479e-03,
        0.7816798799835950e+00,
        0.9518566590593747e-03,
        0.7868152213232364e+00,
        0.9545884266143449e-03,
        0.7916954721972490e+00,
        0.9571859508813780e-03,
        0.7963409407568194e+00,
        0.9596601482630737e-03,
        0.8007702735070883e+00,
        0.9620210639090244e-03,
        0.8050006811385999e+00,
        0.9642779947228965e-03,
        0.8090481386453148e+00,
        0.9664395984170945e-03,
        0.8129275639917815e+00,
        0.9685139909496511e-03,
        0.8166529788658923e+00,
        0.9705088342629528e-03,
        0.8202376544499068e+00,
        0.9724314158979084e-03,
        0.8236942446328719e+00,
        0.9742887217632853e-03,
        0.8270349086491756e+00,
        0.9760875030844708e-03,
        0.8302714247416513e+00,
        0.9778343383275471e-03,
        0.8334152960971942e+00,
        0.9795356906837479e-03,
        0.8364778499742661e+00,
        0.9811979614979323e-03,
        0.8394703306225847e+00,
        0.9828275398255846e-03,
        0.8424039862746810e+00,
        0.9844308480999043e-03,
        0.8452901501569875e+00,
        0.9860143836786285e-03,
        0.8481403151159906e+00,
        0.9875847558152446e-03,
        0.8509662010755018e+00,
        0.9891487173585097e-03,
        0.8537798141289355e+00,
        0.9907131902268242e-03,
        0.8565934956229708e+00,
        0.9922852834316175e-03,
        0.8594199591072303e+00,
        0.9938723021413952e-03,
        0.8622723125149068e+00,
        0.9954817459946895e-03,
        0.8651640624148244e+00,
        0.9971212946004986e-03,
        0.8681090966584658e+00,
        0.9987987779301984e-03,
        0.8711216412695179e+00,
        0.1000522129134342e-02,
        0.8742161870354788e+00,
        0.1002299317248640e-02,
        0.8774073810231204e+00,
        0.1004138257331534e-02,
        0.8807098782305657e+00,
        0.1006046695854091e-02,
        0.8841381489021722e+00,
        0.1008032069698879e-02,
        0.8877062377737649e+00,
        0.1010101337974326e-02,
        0.8914274727949142e+00,
        0.1012260787062656e-02,
        0.8953141227940432e+00,
        0.2505764977838404e-03,
        0.3443770249124342e-03,
        0.2543158995016821e-01,
        0.4162174537078318e-03,
        0.9878227034153308e-01,
        0.4723030362070807e-03,
        0.1743411977575627e+00,
        0.5170566942884504e-03,
        0.2428779209209343e+00,
        0.5534915375556028e-03,
        0.3030074710503266e+00,
        0.5836775268839070e-03,
        0.3553387763770640e+00,
        0.6090665945021940e-03,
        0.4009199654813231e+00,
        0.6307007808156645e-03,
        0.4407885275977928e+00,
        0.6493445644344517e-03,
        0.4758505926393938e+00,
        0.6655702083843857e-03,
        0.5068639748553351e+00,
        0.6798139474548506e-03,
        0.5344526379872747e+00,
        0.6924137931820147e-03,
        0.5591283215877272e+00,
        0.7036355137975163e-03,
        0.5813113577588189e+00,
        0.7136908453729490e-03,
        0.6013484321270596e+00,
        0.7227504933228287e-03,
        0.6195270375256310e+00,
        0.7309535721159746e-03,
        0.6360870035914407e+00,
        0.7384145655048229e-03,
        0.6512296248800408e+00,
        0.7452285316469442e-03,
        0.6651248789020748e+00,
        0.7514750465678792e-03,
        0.6779171461479578e+00,
        0.7572212276838003e-03,
        0.6897297612797826e+00,
        0.7625240776755495e-03,
        0.7006686526246470e+00,
        0.7674323201021287e-03,
        0.7108252688389807e+00,
        0.7719878506216157e-03,
        0.7202789460425201e+00,
        0.7762268944500497e-03,
        0.7290988336445309e+00,
        0.7801809371337034e-03,
        0.7373454702759427e+00,
        0.7838774788105678e-03,
        0.7450720807914899e+00,
        0.7873406498722635e-03,
        0.7523256496919639e+00,
        0.7905917169405165e-03,
        0.7591478143617146e+00,
        0.7936495014053848e-03,
        0.7655756123276436e+00,
        0.7965307277851307e-03,
        0.7716421096510724e+00,
        0.7992503154034614e-03,
        0.7773769320588682e+00,
        0.8018216240149106e-03,
        0.7828067161269425e+00,
        0.8042566618112444e-03,
        0.7879554944635353e+00,
        0.8065662625429530e-03,
        0.7928450261873953e+00,
        0.8087602371674192e-03,
        0.7974950818949961e+00,
        0.8108475043988473e-03,
        0.8019236906381128e+00,
        0.8128362037173276e-03,
        0.8061473550943380e+00,
        0.8147337937451987e-03,
        0.8101812400362133e+00,
        0.8165471383802039e-03,
        0.8140393383338362e+00,
        0.8182825826579203e-03,
        0.8177346180177749e+00,
        0.8199460199784433e-03,
        0.8212791533500792e+00,
        0.8215429520572276e-03,
        0.8246842423744935e+00,
        0.8230785427339746e-03,
        0.8279605130215852e+00,
        0.8245576665860399e-03,
        0.8311180195135344e+00,
        0.8259849531356726e-03,
        0.8341663305331678e+00,
        0.8273648273067869e-03,
        0.8371146103813345e+00,
        0.8287015466714560e-03,
        0.8399716941366764e+00,
        0.8299992359243829e-03,
        0.8427461576444749e+00,
        0.8312619189314546e-03,
        0.8454463829899002e+00,
        0.8324935486128937e-03,
        0.8480806199498299e+00,
        0.8336980348396690e-03,
        0.8506570437613245e+00,
        0.8348792704412902e-03,
        0.8531838093892227e+00,
        0.8360411553417403e-03,
        0.8556691023160556e+00,
        0.8371876187562825e-03,
        0.8581211857109087e+00,
        0.8383226392937222e-03,
        0.8605484436569011e+00,
        0.8394502627153142e-03,
        0.8629594199271572e+00,
        0.8405746170023279e-03,
        0.8653628515950123e+00,
        0.8416999242793960e-03,
        0.8677676965453935e+00,
        0.8428305090311761e-03,
        0.8701831537222023e+00,
        0.8439708019376514e-03,
        0.8726186747045624e+00,
        0.8451253385421383e-03,
        0.8750839649592925e+00,
        0.8462987518610647e-03,
        0.8775889728776909e+00,
        0.8474957579532225e-03,
        0.8801438644857288e+00,
        0.8487211333982720e-03,
        0.8827589815370717e+00,
        0.8499796836021254e-03,
        0.8854447805825755e+00,
        0.8512762008654021e-03,
        0.8882117505884698e+00,
        0.8526154112376473e-03,
        0.8910703067843766e+00,
        0.8540019093532560e-03,
        0.8940306587022231e+00,
        0.8554400807241641e-03,
        0.8971026508610441e+00,
        0.8569340113668948e-03,
        0.9002955753026496e+00,
        0.8584873851806726e-03,
        0.9036179562250074e+00,
        0.2143902298924797e-03,
        0.2946512237154931e-03,
        0.2543490463324859e-01,
        0.3561260688438285e-03,
        0.9879941719514369e-01,
        0.4041230092741482e-03,
        0.1743789695511629e+00,
        0.4424256774627034e-03,
        0.2429409502831179e+00,
        0.4736116853150793e-03,
        0.3030990118950347e+00,
        0.4994518169910726e-03,
        0.3554611561972349e+00,
        0.5211881524129952e-03,
        0.4010748630839990e+00,
        0.5397121201514141e-03,
        0.4409771509224894e+00,
        0.5556777014490634e-03,
        0.4760737966263269e+00,
        0.5695744414699151e-03,
        0.5071223419498457e+00,
        0.5817755161210044e-03,
        0.5347465345706520e+00,
        0.5925700732976313e-03,
        0.5594579384248554e+00,
        0.6021854581155787e-03,
        0.5816767395342153e+00,
        0.6108027921070821e-03,
        0.6017494993293330e+00,
        0.6185680956696988e-03,
        0.6199636028202163e+00,
        0.6256003634582641e-03,
        0.6365587841093024e+00,
        0.6319975186065948e-03,
        0.6517362513852718e+00,
        0.6378408654613904e-03,
        0.6656659024902249e+00,
        0.6431984629598351e-03,
        0.6784920429133774e+00,
        0.6481277109801403e-03,
        0.6903379352397969e+00,
        0.6526773552254315e-03,
        0.7013094370793644e+00,
        0.6568890572555564e-03,
        0.7114979262641195e+00,
        0.6607986356285067e-03,
        0.7209826665497649e+00,
        0.6644370556787454e-03,
        0.7298327319935689e+00,
        0.6678312253083076e-03,
        0.7381085813804109e+00,
        0.6710046397087699e-03,
        0.7458633536247841e+00,
        0.6739779074395309e-03,
        0.7531439394662658e+00,
        0.6767691825904827e-03,
        0.7599918728233108e+00,
        0.6793945220531763e-03,
        0.7664440759826728e+00,
        0.6818681826575195e-03,
        0.7725334857075471e+00,
        0.6842028697103579e-03,
        0.7782895818427216e+00,
        0.6864099460208997e-03,
        0.7837388357016260e+00,
        0.6884996086172708e-03,
        0.7889050921541919e+00,
        0.6904810389048264e-03,
        0.7938098966818099e+00,
        0.6923625308852660e-03,
        0.7984727765644702e+00,
        0.6941516011688034e-03,
        0.8029114836923505e+00,
        0.6958550838122305e-03,
        0.8071422051557240e+00,
        0.6974792124607250e-03,
        0.8111797466910577e+00,
        0.6990296918282764e-03,
        0.8150376931919887e+00,
        0.7005117601960532e-03,
        0.8187285497884573e+00,
        0.7019302443210675e-03,
        0.8222638664221132e+00,
        0.7032896079146326e-03,
        0.8256543483749294e+00,
        0.7045939946601219e-03,
        0.8289099548200989e+00,
        0.7058472665836456e-03,
        0.8320399871433695e+00,
        0.7070530384625938e-03,
        0.8350531685159762e+00,
        0.7082147088500877e-03,
        0.8379577159767848e+00,
        0.7093354882038982e-03,
        0.8407614060927453e+00,
        0.7104184245328271e-03,
        0.8434716351063775e+00,
        0.7114664269090819e-03,
        0.8460954743411380e+00,
        0.7124822871394600e-03,
        0.8486397215154378e+00,
        0.7134686998392874e-03,
        0.8511109485098599e+00,
        0.7144282811093860e-03,
        0.8535155460363737e+00,
        0.7153635859765056e-03,
        0.8558597655701624e+00,
        0.7162771247204472e-03,
        0.8581497588214944e+00,
        0.7171713781754927e-03,
        0.8603916149446070e+00,
        0.7180488120588147e-03,
        0.8625913956007934e+00,
        0.7189118903434776e-03,
        0.8647551679119477e+00,
        0.7197630876577540e-03,
        0.8668890352571068e+00,
        0.7206049006551845e-03,
        0.8689991657766132e+00,
        0.7214398582606628e-03,
        0.8710918183552704e+00,
        0.7222705306565306e-03,
        0.8731733657564531e+00,
        0.7230995368291464e-03,
        0.8752503144732032e+00,
        0.7239295504508160e-03,
        0.8773293207500719e+00,
        0.7247633038248635e-03,
        0.8794172021118196e+00,
        0.7256035895739055e-03,
        0.8815209436139331e+00,
        0.7264532597045066e-03,
        0.8836476979083573e+00,
        0.7273152216374242e-03,
        0.8858047781004107e+00,
        0.7281924307543494e-03,
        0.8879996422658111e+00,
        0.7290878789830281e-03,
        0.8902398684083558e+00,
        0.7300045789273423e-03,
        0.8925331185794968e+00,
        0.7309455430526645e-03,
        0.8948870908635684e+00,
        0.7319137574656844e-03,
        0.8973094579716888e+00,
        0.7329121498886438e-03,
        0.8998077913001904e+00,
        0.7339435515274697e-03,
        0.9023894695138696e+00,
        0.7350106526783481e-03,
        0.9050615710285062e+00,
        0.7361159521134971e-03,
        0.9078307502075817e+00,
        0.7372617005379830e-03,
        0.9107030976677650e+00,
        0.1812712131805553e-03,
        0.2491384321187703e-03,
        0.2543793868003920e-01,
        0.3011236389389571e-03,
        0.9881511572468257e-01,
        0.3417143692905089e-03,
        0.1744135601545568e+00,
        0.3741093236630491e-03,
        0.2429986895349530e+00,
        0.4004876411801612e-03,
        0.3031829004247381e+00,
        0.4223463640195241e-03,
        0.3555733525259414e+00,
        0.4407355613198239e-03,
        0.4012169377011952e+00,
        0.4564088559640470e-03,
        0.4411502489205138e+00,
        0.4699191284978094e-03,
        0.4762787454763390e+00,
        0.4816802419109510e-03,
        0.5073597250977332e+00,
        0.4920076781544193e-03,
        0.5350167430251173e+00,
        0.5011458800384139e-03,
        0.5597612077529058e+00,
        0.5092870408844213e-03,
        0.5820131769183957e+00,
        0.5165842754910700e-03,
        0.6021191036853046e+00,
        0.5231610232704372e-03,
        0.6203662799505060e+00,
        0.5291178753295886e-03,
        0.6369943582199482e+00,
        0.5345376082578074e-03,
        0.6522044738696901e+00,
        0.5394889485099423e-03,
        0.6661664586032026e+00,
        0.5440294242631437e-03,
        0.6790245567662842e+00,
        0.5482075518868509e-03,
        0.6909019734144254e+00,
        0.5520645308096385e-03,
        0.7019045110624699e+00,
        0.5556355707323485e-03,
        0.7121234938350971e+00,
        0.5589509407679369e-03,
        0.7216381322017054e+00,
        0.5620368060492128e-03,
        0.7305174464276960e+00,
        0.5649159003089793e-03,
        0.7388218400819079e+00,
        0.5676080707139590e-03,
        0.7466043945017325e+00,
        0.5701307223629278e-03,
        0.7539119395110627e+00,
        0.5724991833517420e-03,
        0.7607859437362659e+00,
        0.5747270064854298e-03,
        0.7672632586796091e+00,
        0.5768262201098143e-03,
        0.7733767436165075e+00,
        0.5788075378120540e-03,
        0.7791557928788411e+00,
        0.5806805346667902e-03,
        0.7846267827935451e+00,
        0.5824537961143980e-03,
        0.7898134521798050e+00,
        0.5841350443286614e-03,
        0.7947372276555162e+00,
        0.5857312459743304e-03,
        0.7994175029023208e+00,
        0.5872487045051270e-03,
        0.8038718793655162e+00,
        0.5886931395613308e-03,
        0.8081163745265718e+00,
        0.5900697555567861e-03,
        0.8121656028098705e+00,
        0.5913833011706530e-03,
        0.8160329333161330e+00,
        0.5926381211586964e-03,
        0.8197306278697833e+00,
        0.5938382016564763e-03,
        0.8232699622928324e+00,
        0.5949872099502598e-03,
        0.8266613333475188e+00,
        0.5960885295313444e-03,
        0.8299143534033866e+00,
        0.5971452911184121e-03,
        0.8330379345654622e+00,
        0.5981604002247400e-03,
        0.8360403637358284e+00,
        0.5991365617580406e-03,
        0.8389293698608987e+00,
        0.6000763020667812e-03,
        0.8417121844328502e+00,
        0.6009819887851800e-03,
        0.8443955961593316e+00,
        0.6018558487773787e-03,
        0.8469860005853584e+00,
        0.6026999844377125e-03,
        0.8494894453408740e+00,
        0.6035163885670166e-03,
        0.8519116715931933e+00,
        0.6043069580133006e-03,
        0.8542581522025076e+00,
        0.6050735062378763e-03,
        0.8565341270083502e+00,
        0.6058177749442889e-03,
        0.8587446356133339e+00,
        0.6065414448864817e-03,
        0.8608945479758220e+00,
        0.6072461459539104e-03,
        0.8629885930739860e+00,
        0.6079334666143073e-03,
        0.8650313858586231e+00,
        0.6086049627790323e-03,
        0.8670274526700236e+00,
        0.6092621661410419e-03,
        0.8689812552540616e+00,
        0.6099065920211252e-03,
        0.8708972134736309e+00,
        0.6105397467438793e-03,
        0.8727797267727406e+00,
        0.6111631345506714e-03,
        0.8746331944112725e+00,
        0.6117782640423093e-03,
        0.8764620344479443e+00,
        0.6123866541291380e-03,
        0.8782707014068333e+00,
        0.6129898394506246e-03,
        0.8800637025184370e+00,
        0.6135893752100950e-03,
        0.8818456123793366e+00,
        0.6141868413530916e-03,
        0.8836210858249036e+00,
        0.6147838459998774e-03,
        0.8853948687571734e+00,
        0.6153820280240385e-03,
        0.8871718066152805e+00,
        0.6159830586501987e-03,
        0.8889568501193103e+00,
        0.6165886419249452e-03,
        0.8907550578610847e+00,
        0.6172005138967517e-03,
        0.8925715952587398e+00,
        0.6178204403237505e-03,
        0.8944117293380552e+00,
        0.6184502127136527e-03,
        0.8962808187550784e+00,
        0.6190916424892084e-03,
        0.8981842984351409e+00,
        0.6197465530668733e-03,
        0.9001276581771762e+00,
        0.6204167696375895e-03,
        0.9021164145644403e+00,
        0.6211041064488501e-03,
        0.9041560755392406e+00,
        0.6218103514087190e-03,
        0.9062520970467020e+00,
        0.6225372478675618e-03,
        0.9084098312380427e+00,
        0.6232864734841831e-03,
        0.9106344658545083e+00,
        0.6240596161519326e-03,
        0.9129309545958600e+00,
        0.6248581470486960e-03,
        0.9153039385179171e+00,
        0.6256833909833134e-03,
        0.9177576588059725e+00,
        0.1520214237712800e-03,
        0.2089413039628107e-03,
        0.2544061844919076e-01,
        0.2525434029450244e-03,
        0.9882898388671699e-01,
        0.2865906408583821e-03,
        0.1744441250170073e+00,
        0.3137652564915279e-03,
        0.2430497235076716e+00,
        0.3358945562695622e-03,
        0.3032570714471141e+00,
        0.3542338804453592e-03,
        0.3556725894600452e+00,
        0.3696637616173895e-03,
        0.4013426546343276e+00,
        0.3828161474542172e-03,
        0.4413034887132714e+00,
        0.3941546527609132e-03,
        0.4764602748670496e+00,
        0.4040263187063507e-03,
        0.5075700996286871e+00,
        0.4126956886076392e-03,
        0.5352563525449359e+00,
        0.4203677355440847e-03,
        0.5600303090493647e+00,
        0.4272036184847955e-03,
        0.5823119175989039e+00,
        0.4333317268557089e-03,
        0.6024475399611718e+00,
        0.4388555655790971e-03,
        0.6207243900791431e+00,
        0.4438594799484181e-03,
        0.6373820527872740e+00,
        0.4484128767232627e-03,
        0.6526216037234880e+00,
        0.4525733807537433e-03,
        0.6666128210012832e+00,
        0.4563892263945745e-03,
        0.6794999001357331e+00,
        0.4599010909485004e-03,
        0.6914060010021446e+00,
        0.4631435158655601e-03,
        0.7024368836752101e+00,
        0.4661460196359733e-03,
        0.7126838318080794e+00,
        0.4689339774940904e-03,
        0.7222260166914516e+00,
        0.4715293228925426e-03,
        0.7311324200920038e+00,
        0.4739511114194688e-03,
        0.7394634071847610e+00,
        0.4762159775818406e-03,
        0.7472720204610868e+00,
        0.4783385074390325e-03,
        0.7546050498913561e+00,
        0.4803315446135938e-03,
        0.7615039226740586e+00,
        0.4822064431621426e-03,
        0.7680054467191980e+00,
        0.4839732777639475e-03,
        0.7741424349221077e+00,
        0.4856410194012131e-03,
        0.7799442317805824e+00,
        0.4872176829669196e-03,
        0.7854371596157800e+00,
        0.4887104519025023e-03,
        0.7906448982918555e+00,
        0.4901257839368306e-03,
        0.7955888096768238e+00,
        0.4914695011954675e-03,
        0.8002882159858926e+00,
        0.4927468673202736e-03,
        0.8047606394754871e+00,
        0.4939626537433801e-03,
        0.8090220096175752e+00,
        0.4951211968659503e-03,
        0.8130868428076891e+00,
        0.4962264475780244e-03,
        0.8169683987907728e+00,
        0.4972820143036731e-03,
        0.8206788172836932e+00,
        0.4982912005523597e-03,
        0.8242292376985011e+00,
        0.4992570377925784e-03,
        0.8276299044001774e+00,
        0.5001823143295755e-03,
        0.8308902595461131e+00,
        0.5010696007591026e-03,
        0.8340190252357240e+00,
        0.5019212724788590e-03,
        0.8370242764345617e+00,
        0.5027395296647642e-03,
        0.8399135059177911e+00,
        0.5035264150574445e-03,
        0.8426936822947919e+00,
        0.5042838298529326e-03,
        0.8453713020233193e+00,
        0.5050135479486603e-03,
        0.8479524361928227e+00,
        0.5057172287598274e-03,
        0.8504427727478738e+00,
        0.5063964287909282e-03,
        0.8528476547306911e+00,
        0.5070526121216016e-03,
        0.8551721150436168e+00,
        0.5076871599442239e-03,
        0.8574209081657413e+00,
        0.5083013792721207e-03,
        0.8595985392007632e+00,
        0.5088965109213798e-03,
        0.8617092905839876e+00,
        0.5094737368555486e-03,
        0.8637572467337869e+00,
        0.5100341869706155e-03,
        0.8657463168957334e+00,
        0.5105789453872895e-03,
        0.8676802563950228e+00,
        0.5111090563084296e-03,
        0.8695626864839279e+00,
        0.5116255294913210e-03,
        0.8713971129451628e+00,
        0.5121293453771310e-03,
        0.8731869435885925e+00,
        0.5126214599131585e-03,
        0.8749355047571672e+00,
        0.5131028090972410e-03,
        0.8766460569378331e+00,
        0.5135743132677963e-03,
        0.8783218095540483e+00,
        0.5140368811573158e-03,
        0.8799659349980495e+00,
        0.5144914137215976e-03,
        0.8815815819428285e+00,
        0.5149388077515203e-03,
        0.8831718879555870e+00,
        0.5153799592686180e-03,
        0.8847399914159621e+00,
        0.5158157667000665e-03,
        0.8862890427233201e+00,
        0.5162471338228604e-03,
        0.8878222147576811e+00,
        0.5166749724609052e-03,
        0.8893427125382002e+00,
        0.5171002049124420e-03,
        0.8908537820014690e+00,
        0.5175237660786470e-03,
        0.8923587177991490e+00,
        0.5179466052574159e-03,
        0.8938608699906167e+00,
        0.5183696875592966e-03,
        0.8953636494814934e+00,
        0.5187939948953462e-03,
        0.8968705320333607e+00,
        0.5192205264794681e-03,
        0.8983850606439769e+00,
        0.5196502987807066e-03,
        0.8999108460714149e+00,
        0.5200843448542496e-03,
        0.9014515652504507e+00,
        0.5205237129738048e-03,
        0.9030109573261521e+00,
        0.5209694644829235e-03,
        0.9045928170091283e+00,
        0.5214226707791797e-03,
        0.9062009849407291e+00,
        0.5218844093433793e-03,
        0.9078393347463627e+00,
        0.5223557587267653e-03,
        0.9095117564530361e+00,
        0.5228377924131475e-03,
        0.9112221359554993e+00,
        0.5233315714807396e-03,
        0.9129743302365174e+00,
        0.5238381360009637e-03,
        0.9147721380834732e+00,
        0.5243584951293212e-03,
        0.9166192660984713e+00,
        0.5248936158673047e-03,
        0.9185192898749830e+00,
        0.5254444105047963e-03,
        0.9204756103131890e+00,
        0.5260117227898333e-03,
        0.9224914051702910e+00,
        0.5265963129170898e-03,
        0.9245695760920818e+00,
        0.1268446182127322e-03,
        0.1743404286829759e-03,
        0.2544292517172434e-01,
        0.2107251564740404e-03,
        0.9884092351738187e-01,
        0.2391381657362996e-03,
        0.1744704449940017e+00,
        0.2618172499590152e-03,
        0.2430936807628649e+00,
        0.2802869400172751e-03,
        0.3033209758285258e+00,
        0.2955945748575447e-03,
        0.3557581181745550e+00,
        0.3084747892467032e-03,
        0.4014510452519073e+00,
        0.3194548214120799e-03,
        0.4414356626653468e+00,
        0.3289214677172303e-03,
        0.4766169192502833e+00,
        0.3371642657758759e-03,
        0.5077517230370061e+00,
        0.3444039242024864e-03,
        0.5354633241883532e+00,
        0.3508114513703712e-03,
        0.5602628868037311e+00,
        0.3565213009364801e-03,
        0.5825702685336475e+00,
        0.3616405864628345e-03,
        0.6027317556351184e+00,
        0.3662556600075083e-03,
        0.6210344981187767e+00,
        0.3704368884625953e-03,
        0.6377180257702407e+00,
        0.3742421752675708e-03,
        0.6529833660710770e+00,
        0.3777195940186037e-03,
        0.6670002543718940e+00,
        0.3809093836500495e-03,
        0.6799128476679434e+00,
        0.3838454780905802e-03,
        0.6918442706570039e+00,
        0.3865566919752524e-03,
        0.7029002508578049e+00,
        0.3890676491299710e-03,
        0.7131720413986303e+00,
        0.3913995164996082e-03,
        0.7227387845799725e+00,
        0.3935705893726759e-03,
        0.7316694342837096e+00,
        0.3955967618362022e-03,
        0.7400243285231667e+00,
        0.3974919078428414e-03,
        0.7478564830001711e+00,
        0.3992681920658595e-03,
        0.7552126609359470e+00,
        0.4009363251645967e-03,
        0.7621342624977909e+00,
        0.4025057747089784e-03,
        0.7686580679613385e+00,
        0.4039849404875170e-03,
        0.7748168616577529e+00,
        0.4053813010180153e-03,
        0.7806399582528606e+00,
        0.4067015366299700e-03,
        0.7861536486134770e+00,
        0.4079516333750262e-03,
        0.7913815791511374e+00,
        0.4091369711617666e-03,
        0.7963450758813084e+00,
        0.4102623988415600e-03,
        0.8010634223351132e+00,
        0.4113322984474455e-03,
        0.8055540987877207e+00,
        0.4123506403741368e-03,
        0.8098329889290022e+00,
        0.4133210309588080e-03,
        0.8139145590258739e+00,
        0.4142467536602034e-03,
        0.8178120137564664e+00,
        0.4151308048232806e-03,
        0.8215374321909360e+00,
        0.4159759248469224e-03,
        0.8251018868189340e+00,
        0.4167846254347061e-03,
        0.8285155480533462e+00,
        0.4175592134966781e-03,
        0.8317877762533697e+00,
        0.4183018121784048e-03,
        0.8349272029911109e+00,
        0.4190143794182329e-03,
        0.8379418030218164e+00,
        0.4196987243715124e-03,
        0.8408389581983645e+00,
        0.4203565219890266e-03,
        0.8436255143875690e+00,
        0.4209893259940189e-03,
        0.8463078322926154e+00,
        0.4215985804664407e-03,
        0.8488918329572650e+00,
        0.4221856302130706e-03,
        0.8513830386190436e+00,
        0.4227517300769591e-03,
        0.8537866094869954e+00,
        0.4232980533183947e-03,
        0.8561073769418921e+00,
        0.4238256991815968e-03,
        0.8583498735907137e+00,
        0.4243356997460570e-03,
        0.8605183605508547e+00,
        0.4248290261484384e-03,
        0.8626168522912827e+00,
        0.4253065942498067e-03,
        0.8646491393164755e+00,
        0.4257692698134273e-03,
        0.8666188089433132e+00,
        0.4262178732501410e-03,
        0.8685292643902939e+00,
        0.4266531839812305e-03,
        0.8703837423717154e+00,
        0.4270759444625287e-03,
        0.8721853293661955e+00,
        0.4274868639081453e-03,
        0.8739369767085355e+00,
        0.4278866217474832e-03,
        0.8756415146360238e+00,
        0.4282758708450621e-03,
        0.8773016654044247e+00,
        0.4286552405089854e-03,
        0.8789200555747797e+00,
        0.4290253393105878e-03,
        0.8804992275594572e+00,
        0.4293867577348235e-03,
        0.8820416505043871e+00,
        0.4297400706782409e-03,
        0.8835497305738722e+00,
        0.4300858398088763e-03,
        0.8850258206945885e+00,
        0.4304246158000579e-03,
        0.8864722298061936e+00,
        0.4307569404478835e-03,
        0.8878912316572020e+00,
        0.4310833486799939e-03,
        0.8892850731763069e+00,
        0.4314043704611773e-03,
        0.8906559824410115e+00,
        0.4317205325992682e-03,
        0.8920061762571498e+00,
        0.4320323604527339e-03,
        0.8933378673545269e+00,
        0.4323403795392380e-03,
        0.8946532711953979e+00,
        0.4326451170423202e-03,
        0.8959546123837375e+00,
        0.4329471032111149e-03,
        0.8972441306541727e+00,
        0.4332468726457380e-03,
        0.8985240864099954e+00,
        0.4335449654585917e-03,
        0.8997967657697997e+00,
        0.4338419282993692e-03,
        0.9010644850719940e+00,
        0.4341383152289965e-03,
        0.9023295947757297e+00,
        0.4344346884251275e-03,
        0.9035944826856999e+00,
        0.4347316186991527e-03,
        0.9048615764168997e+00,
        0.4350296858020064e-03,
        0.9061333450039083e+00,
        0.4353294784934289e-03,
        0.9074122995477561e+00,
        0.4356315943468108e-03,
        0.9087009927822184e+00,
        0.4359366392594052e-03,
        0.9100020174307473e+00,
        0.4362452266356344e-03,
        0.9113180032156295e+00,
        0.4365579762095740e-03,
        0.9126516123728104e+00,
        0.4368755124715989e-03,
        0.9140055335197583e+00,
        0.4371984626638003e-03,
        0.9153824737204230e+00,
        0.4375274543093129e-03,
        0.9167851485915539e+00,
        0.4378631122423307e-03,
        0.9182162702992493e+00,
        0.4382060551085620e-03,
        0.9196785333045526e+00,
        0.4385568913104083e-03,
        0.9211745977331760e+00,
        0.4389162143774648e-03,
        0.9227070702680383e+00,
        0.4392845977512571e-03,
        0.9242784824952105e+00,
        0.4396625889836182e-03,
        0.9258912666749617e+00,
        0.4400507033609156e-03,
        0.9275477289606028e+00,
        0.4404494169815118e-03,
        0.9292500201491721e+00,
        0.4408591593313590e-03,
        0.9310001041198086e+00,
        0.1055644989267907e-03,
        0.1450940149574984e-03,
        0.2544487491553157e-01,
        0.1753772719352769e-03,
        0.9885101688865597e-01,
        0.1990267012200822e-03,
        0.1744926990200333e+00,
        0.2179045108524649e-03,
        0.2431308553318966e+00,
        0.2332793641731550e-03,
        0.3033750329426410e+00,
        0.2460228232089687e-03,
        0.3558304876736915e+00,
        0.2567462279756849e-03,
        0.4015427879008645e+00,
        0.2658883294937232e-03,
        0.4415475744961243e+00,
        0.2737710071803561e-03,
        0.4767496006654743e+00,
        0.2806352044648509e-03,
        0.5079056259634127e+00,
        0.2866645871705139e-03,
        0.5356387851068741e+00,
        0.2920014619138971e-03,
        0.5604601504270702e+00,
        0.2967577154420555e-03,
        0.5827895051312843e+00,
        0.3010224827883186e-03,
        0.6029730739429139e+00,
        0.3048676217987417e-03,
        0.6212979551152507e+00,
        0.3083516878734000e-03,
        0.6380036341864078e+00,
        0.3115228646427098e-03,
        0.6532911002313850e+00,
        0.3144211555866268e-03,
        0.6673300547852067e+00,
        0.3170800443702226e-03,
        0.6802646246666912e+00,
        0.3195277677802438e-03,
        0.6922179072993687e+00,
        0.3217883024392515e-03,
        0.7032956052494281e+00,
        0.3238821374603807e-03,
        0.7135889485487379e+00,
        0.3258268851960003e-03,
        0.7231770578766950e+00,
        0.3276377682377606e-03,
        0.7321288666512480e+00,
        0.3293280109066263e-03,
        0.7405046933069390e+00,
        0.3309091563550510e-03,
        0.7483575346135667e+00,
        0.3323913252386479e-03,
        0.7557341352926834e+00,
        0.3337834281257755e-03,
        0.7626758772463315e+00,
        0.3350933410056701e-03,
        0.7692195225318236e+00,
        0.3363280511552274e-03,
        0.7753978371270195e+00,
        0.3374937790390407e-03,
        0.7812401170290845e+00,
        0.3385960807104609e-03,
        0.7867726339385476e+00,
        0.3396399342555158e-03,
        0.7920190144159111e+00,
        0.3406298131057851e-03,
        0.7970005637462622e+00,
        0.3415697484891286e-03,
        0.8017365436465392e+00,
        0.3424633828504657e-03,
        0.8062444112774049e+00,
        0.3433140157303645e-03,
        0.8105400256832551e+00,
        0.3441246433158771e-03,
        0.8146378267077895e+00,
        0.3448979926599179e-03,
        0.8185509905633486e+00,
        0.3456365513904324e-03,
        0.8222915655269199e+00,
        0.3463425935893944e-03,
        0.8258705906609294e+00,
        0.3470182024071915e-03,
        0.8292981999865211e+00,
        0.3476652898847084e-03,
        0.8325837141504723e+00,
        0.3482856143791181e-03,
        0.8357357213079810e+00,
        0.3488807959266790e-03,
        0.8387621486794669e+00,
        0.3494523298240878e-03,
        0.8416703260200142e+00,
        0.3500015986670602e-03,
        0.8444670420569842e+00,
        0.3505298830491450e-03,
        0.8471585947980716e+00,
        0.3510383710940082e-03,
        0.8497508364833812e+00,
        0.3515281669694799e-03,
        0.8522492138466825e+00,
        0.3520002985106894e-03,
        0.8546588042593751e+00,
        0.3524557240619330e-03,
        0.8569843482530394e+00,
        0.3528953386319557e-03,
        0.8592302788504310e+00,
        0.3533199794446321e-03,
        0.8614007480784993e+00,
        0.3537304309562248e-03,
        0.8634996509889043e+00,
        0.3541274294011706e-03,
        0.8655306474702691e+00,
        0.3545116669204490e-03,
        0.8674971821009717e+00,
        0.3548837953198046e-03,
        0.8694025022607404e+00,
        0.3552444294992589e-03,
        0.8712496746929433e+00,
        0.3555941505903093e-03,
        0.8730416006866108e+00,
        0.3559335088328495e-03,
        0.8747810300273897e+00,
        0.3562630262200606e-03,
        0.8764705738493466e+00,
        0.3565831989362264e-03,
        0.8781127165044531e+00,
        0.3568944996095447e-03,
        0.8797098265533606e+00,
        0.3571973793994888e-03,
        0.8812641669694672e+00,
        0.3574922699360495e-03,
        0.8827779046380256e+00,
        0.3577795851262342e-03,
        0.8842531192229806e+00,
        0.3580597228414603e-03,
        0.8856918114661521e+00,
        0.3583330664979325e-03,
        0.8870959109761732e+00,
        0.3585999865407079e-03,
        0.8884672835581080e+00,
        0.3588608418408972e-03,
        0.8898077381288096e+00,
        0.3591159810143158e-03,
        0.8911190332577230e+00,
        0.3593657436688535e-03,
        0.8924028833679230e+00,
        0.3596104615868662e-03,
        0.8936609646275998e+00,
        0.3598504598479910e-03,
        0.8948949205579224e+00,
        0.3600860578969333e-03,
        0.8961063673791346e+00,
        0.3603175705599569e-03,
        0.8972968991128310e+00,
        0.3605453090130204e-03,
        0.8984680924545586e+00,
        0.3607695817037281e-03,
        0.8996215114271492e+00,
        0.3609906952284962e-03,
        0.9007587118214661e+00,
        0.3612089551655714e-03,
        0.9018812454275019e+00,
        0.3614246668637566e-03,
        0.9029906640549621e+00,
        0.3616381361859153e-03,
        0.9040885233385761e+00,
        0.3618496702055102e-03,
        0.9051763863193673e+00,
        0.3620595778536006e-03,
        0.9062558267889668e+00,
        0.3622681705128622e-03,
        0.9073284323797515e+00,
        0.3624757625543019e-03,
        0.9083958073791226e+00,
        0.3626826718114261e-03,
        0.9094595752416100e+00,
        0.3628892199856792e-03,
        0.9105213807677069e+00,
        0.3630957329760065e-03,
        0.9115828919134202e+00,
        0.3633025411244249e-03,
        0.9126458011895109e+00,
        0.3635099793685103e-03,
        0.9137118266043415e+00,
        0.3637183872907533e-03,
        0.9147827120992093e+00,
        0.3639281090538103e-03,
        0.9158602274201335e+00,
        0.3641394932098118e-03,
        0.9169461673653735e+00,
        0.3643528923711136e-03,
        0.9180423503436506e+00,
        0.3645686627292243e-03,
        0.9191506161742795e+00,
        0.3647871634081525e-03,
        0.9202728230574016e+00,
        0.3650087556381453e-03,
        0.9214108436404823e+00,
        0.3652338017357785e-03,
        0.9225665601064491e+00,
        0.3654626638766759e-03,
        0.9237418582096152e+00,
        0.3656957026478399e-03,
        0.9249386201881679e+00,
        0.3659332753677379e-03,
        0.9261587164868569e+00,
        0.3661757341639742e-03,
        0.9274039962309573e+00,
        0.3664234238006590e-03,
        0.9286762764029628e+00,
        0.3666766792505202e-03,
        0.9299773296871511e+00,
        0.3669358230104597e-03,
        0.9313088709644671e+00,
        0.3672011621636608e-03,
        0.9326725424613703e+00,
        0.3674729851965463e-03,
        0.9340698975815723e+00,
        0.3677515585848630e-03,
        0.9355023834790327e+00,
        0.3680371231699034e-03,
        0.9369713224641266e+00,
        0.8780076664716276e-04,
        0.1206797894237555e-03,
        0.2544650247967021e-01,
        0.1458689907141319e-03,
        0.9885944344034912e-01,
        0.1655410204684315e-03,
        0.1745112808102761e+00,
        0.1812446142239127e-03,
        0.2431619011038030e+00,
        0.1940348805295792e-03,
        0.3034201872483507e+00,
        0.2046366722127249e-03,
        0.3558909526523158e+00,
        0.2135584233839305e-03,
        0.4016194593852736e+00,
        0.2211650307991108e-03,
        0.4416411290854953e+00,
        0.2277241922738999e-03,
        0.4768605533838495e+00,
        0.2334362932843276e-03,
        0.5080343695969284e+00,
        0.2384540829843639e-03,
        0.5357856177524436e+00,
        0.2428959131113313e-03,
        0.5606252952358727e+00,
        0.2468548359474569e-03,
        0.5829731247513873e+00,
        0.2504049817295676e-03,
        0.6031752812789858e+00,
        0.2536061116756343e-03,
        0.6215188214764482e+00,
        0.2565069236788439e-03,
        0.6382431955471400e+00,
        0.2591474896792285e-03,
        0.6535493621049741e+00,
        0.2615610783797454e-03,
        0.6676069960615446e+00,
        0.2637755361065909e-03,
        0.6805602006643017e+00,
        0.2658143454788651e-03,
        0.6925320522129640e+00,
        0.2676974460335837e-03,
        0.7036282341255100e+00,
        0.2694418768222108e-03,
        0.7139399588872692e+00,
        0.2710622843532818e-03,
        0.7235463309319510e+00,
        0.2725713276157303e-03,
        0.7325162684867130e+00,
        0.2739800036682437e-03,
        0.7409100756455830e+00,
        0.2752979113613955e-03,
        0.7487807355146596e+00,
        0.2765334664638627e-03,
        0.7561749796785543e+00,
        0.2776940783128682e-03,
        0.7631341772964979e+00,
        0.2787862957738123e-03,
        0.7696950779572316e+00,
        0.2798159285470986e-03,
        0.7758904353334187e+00,
        0.2807881485415345e-03,
        0.7817495331755640e+00,
        0.2817075750299807e-03,
        0.7872986308948055e+00,
        0.2825783465328497e-03,
        0.7925613426197803e+00,
        0.2834041817797840e-03,
        0.7975589609612814e+00,
        0.2841884316364275e-03,
        0.8023107346178518e+00,
        0.2849341235200138e-03,
        0.8068341072829448e+00,
        0.2856439995410211e-03,
        0.8111449239759836e+00,
        0.2863205493808272e-03,
        0.8152576098436540e+00,
        0.2869660387338721e-03,
        0.8191853256086143e+00,
        0.2875825339972447e-03,
        0.8229401031375546e+00,
        0.2881719237731651e-03,
        0.8265329640257898e+00,
        0.2887359376546216e-03,
        0.8299740236251799e+00,
        0.2892761626868619e-03,
        0.8332725825556256e+00,
        0.2897940578339750e-03,
        0.8364372074214862e+00,
        0.2902909667276428e-03,
        0.8394758021901656e+00,
        0.2907681289320944e-03,
        0.8423956714705967e+00,
        0.2912266899236334e-03,
        0.8452035767462418e+00,
        0.2916677099534407e-03,
        0.8479057864639630e+00,
        0.2920921719375913e-03,
        0.8505081207514051e+00,
        0.2925009884974771e-03,
        0.8530159914271018e+00,
        0.2928950082563857e-03,
        0.8554344378758767e+00,
        0.2932750214832763e-03,
        0.8577681592844462e+00,
        0.2936417651623478e-03,
        0.8600215436661002e+00,
        0.2939959275564363e-03,
        0.8621986940470617e+00,
        0.2943381523232877e-03,
        0.8643034521390155e+00,
        0.2946690422360806e-03,
        0.8663394197810720e+00,
        0.2949891625530086e-03,
        0.8683099783990099e+00,
        0.2952990440750963e-03,
        0.8702183066991327e+00,
        0.2955991859265754e-03,
        0.8720673967877357e+00,
        0.2958900580879658e-03,
        0.8738600688843806e+00,
        0.2961721037083923e-03,
        0.8755989847774060e+00,
        0.2964457412205325e-03,
        0.8772866601529093e+00,
        0.2967113662788715e-03,
        0.8789254759134587e+00,
        0.2969693535395673e-03,
        0.8805176885897160e+00,
        0.2972200582981628e-03,
        0.8820654399367039e+00,
        0.2974638179995708e-03,
        0.8835707657964145e+00,
        0.2977009536331723e-03,
        0.8850356042996281e+00,
        0.2979317710244726e-03,
        0.8864618034720409e+00,
        0.2981565620335326e-03,
        0.8878511283029286e+00,
        0.2983756056693069e-03,
        0.8892052673284969e+00,
        0.2985891691280583e-03,
        0.8905258387766696e+00,
        0.2987975087631656e-03,
        0.8918143963152597e+00,
        0.2990008709928799e-03,
        0.8930724344411763e+00,
        0.2991994931519033e-03,
        0.8943013935444719e+00,
        0.2993936042920544e-03,
        0.8955026646775683e+00,
        0.2995834259367309e-03,
        0.8966775940568730e+00,
        0.2997691727933844e-03,
        0.8978274873211489e+00,
        0.2999510534277608e-03,
        0.8989536135684026e+00,
        0.3001292709032479e-03,
        0.9000572091906636e+00,
        0.3003040233882832e-03,
        0.9011394815238150e+00,
        0.3004755047344127e-03,
        0.9022016123275653e+00,
        0.3006439050272616e-03,
        0.9032447611087047e+00,
        0.3008094111123485e-03,
        0.9042700682989381e+00,
        0.3009722070973778e-03,
        0.9052786582968102e+00,
        0.3011324748323426e-03,
        0.9062716423815145e+00,
        0.3012903943684867e-03,
        0.9072501215046918e+00,
        0.3014461443968870e-03,
        0.9082151889646557e+00,
        0.3015999026671373e-03,
        0.9091679329658161e+00,
        0.3017518463863298e-03,
        0.9101094390643967e+00,
        0.3019021525982453e-03,
        0.9110407924998413e+00,
        0.3020509985423700e-03,
        0.9119630804095697e+00,
        0.3021985619920632e-03,
        0.9128773939229608e+00,
        0.3023450215708908e-03,
        0.9137848301286094e+00,
        0.3024905570458278e-03,
        0.9146864939070101e+00,
        0.3026353495957124e-03,
        0.9155834996188661e+00,
        0.3027795820529983e-03,
        0.9164769726372038e+00,
        0.3029234391165164e-03,
        0.9173680507093950e+00,
        0.3030671075326073e-03,
        0.9182578851330556e+00,
        0.3032107762416357e-03,
        0.9191476417276118e+00,
        0.3033546364865421e-03,
        0.9200385015811228e+00,
        0.3034988818797365e-03,
        0.9209316615497335e+00,
        0.3036437084242899e-03,
        0.9218283344849421e+00,
        0.3037893144850508e-03,
        0.9227297491617354e+00,
        0.3039359007049947e-03,
        0.9236371498786060e+00,
        0.3040836698618365e-03,
        0.9245517956985898e+00,
        0.3042328266596891e-03,
        0.9254749592987897e+00,
        0.3043835774503590e-03,
        0.9264079253944743e+00,
        0.3045361298787459e-03,
        0.9273519887028263e+00,
        0.3046906924467665e-03,
        0.9283084514108677e+00,
        0.3048474739902782e-03,
        0.9292786201121033e+00,
        0.3050066830636484e-03,
        0.9302638021771222e+00,
        0.3051685272269233e-03,
        0.9312653015248920e+00,
        0.3053332122310158e-03,
        0.9322844137639074e+00,
        0.3055009410969733e-03,
        0.9333224206758433e+00,
        0.3056719130862303e-03,
        0.9343805840190375e+00,
        0.3058463225598092e-03,
        0.9354601386351341e+00,
        0.3060243577257252e-03,
        0.9365622848496463e+00,
        0.3062061992753964e-03,
        0.9376881801661726e+00,
        0.3063920189116574e-03,
        0.9388389302645763e+00,
        0.3065819777730374e-03,
        0.9400155793256640e+00,
        0.3067762247612739e-03,
        0.9412190997187711e+00,
        0.3069748947815949e-03,
        0.9424503811041136e+00,
        0.7309194121921337e-04,
        0.1004637913909749e-03,
        0.2544785012683798e-01,
        0.1214344266344417e-03,
        0.9886642145889684e-01,
        0.1378124012607418e-03,
        0.1745266702959460e+00,
        0.1508869219533374e-03,
        0.2431876171096405e+00,
        0.1615362906618204e-03,
        0.3034575961449956e+00,
        0.1703638961634086e-03,
        0.3559410557392941e+00,
        0.1777929742443069e-03,
        0.4016830055695095e+00,
        0.1841272759437895e-03,
        0.4417186869611078e+00,
        0.1895896409160979e-03,
        0.4769525589580654e+00,
        0.1943468759030283e-03,
        0.5081411588464865e+00,
        0.1985261336437941e-03,
        0.5359074494195392e+00,
        0.2022259333499051e-03,
        0.5607623671619424e+00,
        0.2055237341359384e-03,
        0.5831255858225246e+00,
        0.2084812437801258e-03,
        0.6033432403229687e+00,
        0.2111482088116174e-03,
        0.6217023539986306e+00,
        0.2135651662786688e-03,
        0.6384423489057279e+00,
        0.2157654726972967e-03,
        0.6537641595402491e+00,
        0.2177768213406241e-03,
        0.6678374398703551e+00,
        0.2196223917129092e-03,
        0.6808062747278515e+00,
        0.2213217308213229e-03,
        0.6927937240286020e+00,
        0.2228914362913128e-03,
        0.7039054564531154e+00,
        0.2243456912849616e-03,
        0.7142326710923299e+00,
        0.2256966873287446e-03,
        0.7238544600868844e+00,
        0.2269549614676161e-03,
        0.7328397302769779e+00,
        0.2281296672953758e-03,
        0.7412487751160227e+00,
        0.2292287944844476e-03,
        0.7491345676832047e+00,
        0.2302593478625398e-03,
        0.7565438300381136e+00,
        0.2312274944605136e-03,
        0.7635179222210341e+00,
        0.2321386850119108e-03,
        0.7700935850242779e+00,
        0.2329977549303630e-03,
        0.7763035635723555e+00,
        0.2338090086934327e-03,
        0.7821771332486441e+00,
        0.2345762907259228e-03,
        0.7877405452160454e+00,
        0.2353030452346481e-03,
        0.7930174054153139e+00,
        0.2359923669511411e-03,
        0.7980289982735111e+00,
        0.2366470443530013e-03,
        0.8027945642546851e+00,
        0.2372695966322588e-03,
        0.8073315387125080e+00,
        0.2378623054406560e-03,
        0.8116557581664309e+00,
        0.2384272422525216e-03,
        0.8157816390470166e+00,
        0.2389662920348844e-03,
        0.8197223330870221e+00,
        0.2394811737932779e-03,
        0.8234898628296190e+00,
        0.2399734584639214e-03,
        0.8270952401504242e+00,
        0.2404445845437014e-03,
        0.8305485702196599e+00,
        0.2408958717848132e-03,
        0.8338591429442381e+00,
        0.2413285332280931e-03,
        0.8370355136106796e+00,
        0.2417436858056495e-03,
        0.8400855741856878e+00,
        0.2421423597075709e-03,
        0.8430166165116897e+00,
        0.2425255066777939e-03,
        0.8458353884515460e+00,
        0.2428940073795231e-03,
        0.8485481438833696e+00,
        0.2432486779499734e-03,
        0.8511606873176778e+00,
        0.2435902758469355e-03,
        0.8536784138006696e+00,
        0.2439195050751448e-03,
        0.8561063446757747e+00,
        0.2442370208681859e-03,
        0.8584491596979498e+00,
        0.2445434338913074e-03,
        0.8607112259291628e+00,
        0.2448393140217253e-03,
        0.8628966237872216e+00,
        0.2451251937555122e-03,
        0.8650091705719897e+00,
        0.2454015712837818e-03,
        0.8670524417517986e+00,
        0.2456689132754098e-03,
        0.8690297902574413e+00,
        0.2459276573988435e-03,
        0.8709443640006192e+00,
        0.2461782146115141e-03,
        0.8727991218073733e+00,
        0.2464209712418874e-03,
        0.8745968479342314e+00,
        0.2466562908861773e-03,
        0.8763401653150385e+00,
        0.2468845161391411e-03,
        0.8780315476692500e+00,
        0.2471059701761088e-03,
        0.8796733305874988e+00,
        0.2473209582014312e-03,
        0.8812677216971869e+00,
        0.2475297687768076e-03,
        0.8828168099994235e+00,
        0.2477326750414573e-03,
        0.8843225744586169e+00,
        0.2479299358347776e-03,
        0.8857868919172412e+00,
        0.2481217967309792e-03,
        0.8872115444005592e+00,
        0.2483084909941748e-03,
        0.8885982258692703e+00,
        0.2484902404615005e-03,
        0.8899485484720331e+00,
        0.2486672563610595e-03,
        0.8912640483444853e+00,
        0.2488397400707827e-03,
        0.8925461909966710e+00,
        0.2490078838236775e-03,
        0.8937963763265875e+00,
        0.2491718713643894e-03,
        0.8950159432938443e+00,
        0.2493318785615123e-03,
        0.8962061742840980e+00,
        0.2494880739796445e-03,
        0.8973682991919632e+00,
        0.2496406194148037e-03,
        0.8985034992474405e+00,
        0.2497896703964584e-03,
        0.8996129106085194e+00,
        0.2499353766591264e-03,
        0.9006976277404708e+00,
        0.2500778825862051e-03,
        0.9017587066004092e+00,
        0.2502173276284460e-03,
        0.9027971676439548e+00,
        0.2503538466992535e-03,
        0.9038139986692414e+00,
        0.2504875705487804e-03,
        0.9048101575120641e+00,
        0.2506186261185988e-03,
        0.9057865746046461e+00,
        0.2507471368785526e-03,
        0.9067441554092800e+00,
        0.2508732231472320e-03,
        0.9076837827369850e+00,
        0.2509970023973650e-03,
        0.9086063189602724e+00,
        0.2511185895472782e-03,
        0.9095126081281425e+00,
        0.2512380972394480e-03,
        0.9104034779905169e+00,
        0.2513556361070412e-03,
        0.9112797419384428e+00,
        0.2514713150292236e-03,
        0.9121422008655769e+00,
        0.2515852413759041e-03,
        0.9129916449556555e+00,
        0.2516975212424692e-03,
        0.9138288553998849e+00,
        0.2518082596749575e-03,
        0.9146546060474243e+00,
        0.2519175608860183e-03,
        0.9154696649913860e+00,
        0.2520255284618921e-03,
        0.9162747960920304e+00,
        0.2521322655605479e-03,
        0.9170707604380880e+00,
        0.2522378751010061e-03,
        0.9178583177463857e+00,
        0.2523424599437699e-03,
        0.9186382276991902e+00,
        0.2524461230621790e-03,
        0.9194112512179023e+00,
        0.2525489677043914e-03,
        0.9201781516709387e+00,
        0.2526510975455835e-03,
        0.9209396960128159e+00,
        0.2527526168298444e-03,
        0.9216966558506134e+00,
        0.2528536305011233e-03,
        0.9224498084331230e+00,
        0.2529542443224635e-03,
        0.9231999375571040e+00,
        0.2530545649826379e-03,
        0.9239478343841470e+00,
        0.2531547001891691e-03,
        0.9246942981607159e+00,
        0.2532547587465925e-03,
        0.9254401368329844e+00,
        0.2533548506186903e-03,
        0.9261861675471153e+00,
        0.2534550869732947e-03,
        0.9269332170246625e+00,
        0.2535555802081323e-03,
        0.9276821218018076e+00,
        0.2536564439560544e-03,
        0.9284337283201880e+00,
        0.2537577930678808e-03,
        0.9291888928561548e+00,
        0.2538597435709706e-03,
        0.9299484812744167e+00,
        0.2539624126015323e-03,
        0.9307133685912200e+00,
        0.2540659183085976e-03,
        0.9314844383314877e+00,
        0.2541703797275094e-03,
        0.9322625816637383e+00,
        0.2542759166207297e-03,
        0.9330486962961403e+00,
        0.2543826492837433e-03,
        0.9338436851167795e+00,
        0.2544906983138460e-03,
        0.9346484545611477e+00,
        0.2546001843396463e-03,
        0.9354639126900528e+00,
        0.2547112277091971e-03,
        0.9362909669616406e+00,
        0.2548239481348102e-03,
        0.9371305216820521e+00,
        0.2549384642927942e-03,
        0.9379834751204702e+00,
        0.2550548933766077e-03,
        0.9388507162759753e+00,
        0.2551733506022396e-03,
        0.9397331212857866e+00,
        0.2552939486650164e-03,
        0.9406315494671578e+00,
        0.2554167971475084e-03,
        0.9415468389884580e+00,
        0.2555420018787558e-03,
        0.9424798021688484e+00,
        0.2556696642456735e-03,
        0.9434312204104797e+00,
        0.2557998804582168e-03,
        0.9444018387723074e+00,
        0.2559327407706962e-03,
        0.9453923602004483e+00,
        0.2560683286625224e-03,
        0.9464034394364762e+00,
        0.2562067199826295e-03,
        0.9474356766321346e+00,
        0.6097078489116776e-04,
        0.8380405076108355e-04,
        0.2544896065932850e-01,
        0.1012978969826672e-03,
        0.9887217219781226e-01,
        0.1149608733516808e-03,
        0.1745393544210289e+00,
        0.1258683390053939e-03,
        0.2432088150280462e+00,
        0.1347529092969161e-03,
        0.3034884369920806e+00,
        0.1421178877684437e-03,
        0.3559823686685004e+00,
        0.1483163075228666e-03,
        0.4017354125928528e+00,
        0.1536015360676195e-03,
        0.4417826623358451e+00,
        0.1581594503691672e-03,
        0.4770284685054013e+00,
        0.1621291886747866e-03,
        0.5082292867703224e+00,
        0.1656168126296357e-03,
        0.5360080170824175e+00,
        0.1687044997776278e-03,
        0.5608755465361002e+00,
        0.1714568607858636e-03,
        0.5832515093250096e+00,
        0.1739253676423436e-03,
        0.6034820081391302e+00,
        0.1761515150836057e-03,
        0.6218540396252812e+00,
        0.1781691159294222e-03,
        0.6386070034090316e+00,
        0.1800059934918693e-03,
        0.6539418148701861e+00,
        0.1816852471937282e-03,
        0.6680281114720945e+00,
        0.1832262113807821e-03,
        0.6810099636217561e+00,
        0.1846451904182646e-03,
        0.6930104184833876e+00,
        0.1859560284988198e-03,
        0.7041351333436702e+00,
        0.1871705558346453e-03,
        0.7144752970102477e+00,
        0.1882989413512779e-03,
        0.7241099922548785e+00,
        0.1893499739181992e-03,
        0.7331081173060140e+00,
        0.1903312884234792e-03,
        0.7415299576349032e+00,
        0.1912495488900670e-03,
        0.7494284788635305e+00,
        0.1921105978487627e-03,
        0.7568503960324043e+00,
        0.1929195789948627e-03,
        0.7638370625278608e+00,
        0.1936810385340217e-03,
        0.7704252127912312e+00,
        0.1943990094098548e-03,
        0.7766475858453091e+00,
        0.1950770816902051e-03,
        0.7825334511739168e+00,
        0.1957184616920660e-03,
        0.7881090542005848e+00,
        0.1963260218904405e-03,
        0.7933979952488399e+00,
        0.1969023432430833e-03,
        0.7984215532155936e+00,
        0.1974497512412977e-03,
        0.8031989630889407e+00,
        0.1979703467447663e-03,
        0.8077476547694436e+00,
        0.1984660324594830e-03,
        0.8120834593159135e+00,
        0.1989385357600094e-03,
        0.8162207876608769e+00,
        0.1993894284313026e-03,
        0.8201727859718991e+00,
        0.1998201438042677e-03,
        0.8239514711297960e+00,
        0.2002319916776369e-03,
        0.8275678492200949e+00,
        0.2006261713526632e-03,
        0.8310320194637810e+00,
        0.2010037830532616e-03,
        0.8343532656268659e+00,
        0.2013658379601603e-03,
        0.8375401366294502e+00,
        0.2017132670514090e-03,
        0.8406005178108765e+00,
        0.2020469289116992e-03,
        0.8435416940880705e+00,
        0.2023676166481832e-03,
        0.8463704060610680e+00,
        0.2026760640298827e-03,
        0.8490928999664670e+00,
        0.2029729509505747e-03,
        0.8517149722508350e+00,
        0.2032589083006388e-03,
        0.8542420094276686e+00,
        0.2035345223212339e-03,
        0.8566790237898599e+00,
        0.2038003385039595e-03,
        0.8590306854719521e+00,
        0.2040568650905127e-03,
        0.8613013512904316e+00,
        0.2043045762195164e-03,
        0.8634950907340174e+00,
        0.2045439147614532e-03,
        0.8656157094277920e+00,
        0.2047752948773090e-03,
        0.8676667703537839e+00,
        0.2049991043319707e-03,
        0.8696516130751836e+00,
        0.2052157065895086e-03,
        0.8715733711808579e+00,
        0.2054254427141078e-03,
        0.8734349881404843e+00,
        0.2056286330975070e-03,
        0.8752392317378276e+00,
        0.2058255790312958e-03,
        0.8769887072299080e+00,
        0.2060165641402434e-03,
        0.8786858693626248e+00,
        0.2062018556909442e-03,
        0.8803330333584298e+00,
        0.2063817057884218e-03,
        0.8819323849785773e+00,
        0.2065563524718971e-03,
        0.8834859897510554e+00,
        0.2067260207196752e-03,
        0.8849958014452854e+00,
        0.2068909233720063e-03,
        0.8864636698658907e+00,
        0.2070512619798147e-03,
        0.8878913480301039e+00,
        0.2072072275863421e-03,
        0.8892804987865693e+00,
        0.2073590014480071e-03,
        0.8906327009272852e+00,
        0.2075067557001234e-03,
        0.8919494548391176e+00,
        0.2076506539725411e-03,
        0.8932321877366053e+00,
        0.2077908519597573e-03,
        0.8944822585136047e+00,
        0.2079274979495885e-03,
        0.8957009622476075e+00,
        0.2080607333140918e-03,
        0.8968895343872672e+00,
        0.2081906929660589e-03,
        0.8980491546507244e+00,
        0.2083175057840894e-03,
        0.8991809506596934e+00,
        0.2084412950089600e-03,
        0.9002860013319247e+00,
        0.2085621786137507e-03,
        0.9013653400525538e+00,
        0.2086802696499600e-03,
        0.9024199576429591e+00,
        0.2087956765716353e-03,
        0.9034508051440569e+00,
        0.2089085035393573e-03,
        0.9044587964294366e+00,
        0.2090188507057549e-03,
        0.9054448106623624e+00,
        0.2091268144840720e-03,
        0.9064096946094280e+00,
        0.2092324878011760e-03,
        0.9073542648225251e+00,
        0.2093359603362731e-03,
        0.9082793096997696e+00,
        0.2094373187464826e-03,
        0.9091855914351026e+00,
        0.2095366468803258e-03,
        0.9100738478654410e+00,
        0.2096340259800857e-03,
        0.9109447942234819e+00,
        0.2097295348739169e-03,
        0.9117991248035615e+00,
        0.2098232501585007e-03,
        0.9126375145473211e+00,
        0.2099152463729734e-03,
        0.9134606205553340e+00,
        0.2100055961647897e-03,
        0.9142690835302997e+00,
        0.2100943704481180e-03,
        0.9150635291568929e+00,
        0.2101816385553131e-03,
        0.9158445694228796e+00,
        0.2102674683819544e-03,
        0.9166128038856619e+00,
        0.2103519265258884e-03,
        0.9173688208879894e+00,
        0.2104350784206675e-03,
        0.9181131987261704e+00,
        0.2105169884637311e-03,
        0.9188465067737359e+00,
        0.2105977201396311e-03,
        0.9195693065631350e+00,
        0.2106773361385627e-03,
        0.9202821528276868e+00,
        0.2107558984704203e-03,
        0.9209855945056615e+00,
        0.2108334685745573e-03,
        0.9216801757080246e+00,
        0.2109101074253908e-03,
        0.9223664366510376e+00,
        0.2109858756339512e-03,
        0.9230449145545729e+00,
        0.2110608335454401e-03,
        0.9237161445066656e+00,
        0.2111350413328171e-03,
        0.9243806602944845e+00,
        0.2112085590864012e-03,
        0.9250389952015636e+00,
        0.2112814468994273e-03,
        0.9256916827707871e+00,
        0.2113537649494626e-03,
        0.9263392575322679e+00,
        0.2114255735755424e-03,
        0.9269822556948962e+00,
        0.2114969333508442e-03,
        0.9276212157999659e+00,
        0.2115679051506757e-03,
        0.9282566793349052e+00,
        0.2116385502155082e-03,
        0.9288891913047499e+00,
        0.2117089302087404e-03,
        0.9295193007585984e+00,
        0.2117791072688329e-03,
        0.9301475612678799e+00,
        0.2118491440554076e-03,
        0.9307745313528513e+00,
        0.2119191037888559e-03,
        0.9314007748533154e+00,
        0.2119890502829553e-03,
        0.9320268612391253e+00,
        0.2120590479699442e-03,
        0.9326533658556098e+00,
        0.2121291619174575e-03,
        0.9332808700986251e+00,
        0.2121994578366795e-03,
        0.9339099615135131e+00,
        0.2122700020810254e-03,
        0.9345412338118337e+00,
        0.2123408616346198e-03,
        0.9351752867993358e+00,
        0.2124121040897991e-03,
        0.9358127262082568e+00,
        0.2124837976128301e-03,
        0.9364541634266928e+00,
        0.2125560108970050e-03,
        0.9371002151174706e+00,
        0.2126288131022461e-03,
        0.9377515027186954e+00,
        0.2127022737803375e-03,
        0.9384086518179469e+00,
        0.2127764627848895e-03,
        0.9390722913919686e+00,
        0.2128514501651432e-03,
        0.9397430529036528e+00,
        0.2129273060427348e-03,
        0.9404215692481872e+00,
        0.2130041004705666e-03,
        0.9411084735403966e+00,
        0.2130819032729711e-03,
        0.9418043977356298e+00,
        0.2131607838664165e-03,
        0.9425099710769944e+00,
        0.2132408110600791e-03,
        0.9432258183623697e+00,
        0.2133220528357081e-03,
        0.9439525580254419e+00,
        0.2134045761063316e-03,
        0.9446908000260153e+00,
        0.2134884464535012e-03,
        0.9454411435460905e+00,
        0.2135737278429450e-03,
        0.9462041744896647e+00,
        0.2136604823187037e-03,
        0.9469804627859271e+00,
        0.2137487696760521e-03,
        0.9477705594974885e+00,
        0.2138386471137701e-03,
        0.9485749937375257e+00,
        0.2139301688666145e-03,
        0.9493942694022146e+00,
        0.2140233858191606e-03,
        0.9502288617275928e+00,
        0.2141183451025241e-03,
        0.9510792136830037e+00,
        0.2142150896758442e-03,
        0.9519457322165201e+00,
        0.5038843819242724e-04,
        0.6925910573206593e-04,
        0.2544993017457056e-01,
        0.8371726902993700e-04,
        0.9887719305509405e-01,
        0.9500958703765661e-04,
        0.1745504296500425e+00,
        0.1040247370141086e-03,
        0.2432273260547244e+00,
        0.1113681540690559e-03,
        0.3035153719186541e+00,
        0.1174557699843303e-03,
        0.3560184543414467e+00,
        0.1225793327188225e-03,
        0.4017811956457096e+00,
        0.1269482262440711e-03,
        0.4418385610275083e+00,
        0.1307160600652860e-03,
        0.4770948070394370e+00,
        0.1339978185876816e-03,
        0.5083063187019734e+00,
        0.1368811515412669e-03,
        0.5360959417043054e+00,
        0.1394339707035654e-03,
        0.5609745206153379e+00,
        0.1417096704842709e-03,
        0.5833616556836523e+00,
        0.1437507874107348e-03,
        0.6036034220420834e+00,
        0.1455916127490372e-03,
        0.6219867936141575e+00,
        0.1472600893816645e-03,
        0.6387511510142359e+00,
        0.1487792104243456e-03,
        0.6540973934997754e+00,
        0.1501680651407632e-03,
        0.6681951446873501e+00,
        0.1514426313109642e-03,
        0.6811884629495294e+00,
        0.1526163827196775e-03,
        0.6932003848740875e+00,
        0.1537007600492208e-03,
        0.7043365583549521e+00,
        0.1547055396155196e-03,
        0.7146881637760102e+00,
        0.1556391248364784e-03,
        0.7243342762844463e+00,
        0.1565087786427017e-03,
        0.7333437871476419e+00,
        0.1573208103069447e-03,
        0.7417769754298066e+00,
        0.1580807267724731e-03,
        0.7496868008107239e+00,
        0.1587933560956882e-03,
        0.7571199727801611e+00,
        0.1594629488101686e-03,
        0.7641178395042019e+00,
        0.1600932616793006e-03,
        0.7707171304832252e+00,
        0.1606876273022243e-03,
        0.7769505800349328e+00,
        0.1612490122811637e-03,
        0.7828474531366270e+00,
        0.1617800660822615e-03,
        0.7884339908714920e+00,
        0.1622831622801481e-03,
        0.7937337893603658e+00,
        0.1627604335348945e-03,
        0.7987681234096885e+00,
        0.1632138013840797e-03,
        0.8035562240062770e+00,
        0.1636450017242930e-03,
        0.8081155171174660e+00,
        0.1640556066920045e-03,
        0.8124618299171829e+00,
        0.1644470435232973e-03,
        0.8166095694827731e+00,
        0.1648206108678467e-03,
        0.8205718781384362e+00,
        0.1651774929489843e-03,
        0.8243607689160389e+00,
        0.1655187718942932e-03,
        0.8279872440294369e+00,
        0.1658454385065429e-03,
        0.8314613987881412e+00,
        0.1661584017002631e-03,
        0.8347925129896938e+00,
        0.1664584967928401e-03,
        0.8379891315112622e+00,
        0.1667464928090865e-03,
        0.8410591355569131e+00,
        0.1670230989335329e-03,
        0.8440098057975293e+00,
        0.1672889702242240e-03,
        0.8468478784572497e+00,
        0.1675447126847760e-03,
        0.8495795952470572e+00,
        0.1677908877772391e-03,
        0.8522107479174399e+00,
        0.1680280164464030e-03,
        0.8547467180936171e+00,
        0.1682565827161736e-03,
        0.8571925129651890e+00,
        0.1684770369102029e-03,
        0.8595527973243928e+00,
        0.1686897985418176e-03,
        0.8618319223811186e+00,
        0.1688952589122240e-03,
        0.8640339517265517e+00,
        0.1690937834508111e-03,
        0.8661626847691907e+00,
        0.1692857138269685e-03,
        0.8682216779257585e+00,
        0.1694713698590671e-03,
        0.8702142638140924e+00,
        0.1696510512430158e-03,
        0.8721435686645843e+00,
        0.1698250391200247e-03,
        0.8740125281403963e+00,
        0.1699935975008061e-03,
        0.8758239017338748e+00,
        0.1701569745613678e-03,
        0.8775802858868165e+00,
        0.1703154038237586e-03,
        0.8792841259650484e+00,
        0.1704691052335605e-03,
        0.8809377272028146e+00,
        0.1706182861445670e-03,
        0.8825432647193950e+00,
        0.1707631422198987e-03,
        0.8841027926989548e+00,
        0.1709038582577726e-03,
        0.8856182528146059e+00,
        0.1710406089492363e-03,
        0.8870914819688771e+00,
        0.1711735595743775e-03,
        0.8885242194150492e+00,
        0.1713028666428259e-03,
        0.8899181133170080e+00,
        0.1714286784837430e-03,
        0.8912747267992473e+00,
        0.1715511357899551e-03,
        0.8925955435333450e+00,
        0.1716703721204033e-03,
        0.8938819729025228e+00,
        0.1717865143646592e-03,
        0.8951353547817279e+00,
        0.1718996831728790e-03,
        0.8963569639669645e+00,
        0.1720099933542312e-03,
        0.8975480142843037e+00,
        0.1721175542465397e-03,
        0.8987096624060582e+00,
        0.1722224700596145e-03,
        0.8998430113989865e+00,
        0.1723248401945090e-03,
        0.9009491140270437e+00,
        0.1724247595407294e-03,
        0.9020289758291009e+00,
        0.1725223187532327e-03,
        0.9030835579901713e+00,
        0.1726176045108827e-03,
        0.9041137800229966e+00,
        0.1727106997578779e-03,
        0.9051205222753303e+00,
        0.1728016839295312e-03,
        0.9061046282768895e+00,
        0.1728906331636581e-03,
        0.9070669069387198e+00,
        0.1729776204987175e-03,
        0.9080081346166083e+00,
        0.1730627160597527e-03,
        0.9089290570491782e+00,
        0.1731459872330869e-03,
        0.9098303911803945e+00,
        0.1732274988306475e-03,
        0.9107128268753881e+00,
        0.1733073132447196e-03,
        0.9115770285377644e+00,
        0.1733854905938624e-03,
        0.9124236366358845e+00,
        0.1734620888606598e-03,
        0.9132532691449957e+00,
        0.1735371640219225e-03,
        0.9140665229115264e+00,
        0.1736107701719091e-03,
        0.9148639749453516e+00,
        0.1736829596390858e-03,
        0.9156461836453693e+00,
        0.1737537830969034e-03,
        0.9164136899633000e+00,
        0.1738232896690321e-03,
        0.9171670185102322e+00,
        0.1738915270294578e-03,
        0.9179066786100761e+00,
        0.1739585414978131e-03,
        0.9186331653037572e+00,
        0.1740243781302842e-03,
        0.9193469603076764e+00,
        0.1740890808064089e-03,
        0.9200485329296795e+00,
        0.1741526923120535e-03,
        0.9207383409455176e+00,
        0.1742152544188343e-03,
        0.9214168314385361e+00,
        0.1742768079602262e-03,
        0.9220844416050994e+00,
        0.1743373929045788e-03,
        0.9227415995280490e+00,
        0.1743970484252448e-03,
        0.9233887249202853e+00,
        0.1744558129680012e-03,
        0.9240262298403793e+00,
        0.1745137243159310e-03,
        0.9246545193819353e+00,
        0.1745708196519153e-03,
        0.9252739923382533e+00,
        0.1746271356188670e-03,
        0.9258850418436779e+00,
        0.1746827083778257e-03,
        0.9264880559928549e+00,
        0.1747375736640159e-03,
        0.9270834184389665e+00,
        0.1747917668409568e-03,
        0.9276715089718623e+00,
        0.1748453229526972e-03,
        0.9282527040768544e+00,
        0.1748982767742368e-03,
        0.9288273774748004e+00,
        0.1749506628601784e-03,
        0.9293959006439499e+00,
        0.1750025155916436e-03,
        0.9299586433238869e+00,
        0.1750538692214704e-03,
        0.9305159740017549e+00,
        0.1751047579176975e-03,
        0.9310682603808031e+00,
        0.1751552158053241e-03,
        0.9316158698311472e+00,
        0.1752052770063228e-03,
        0.9321591698224861e+00,
        0.1752549756778664e-03,
        0.9326985283383640e+00,
        0.1753043460487161e-03,
        0.9332343142714111e+00,
        0.1753534224537021e-03,
        0.9337668977988398e+00,
        0.1754022393662154e-03,
        0.9342966507373076e+00,
        0.1754508314286094e-03,
        0.9348239468760963e+00,
        0.1754992334803999e-03,
        0.9353491622873846e+00,
        0.1755474805841303e-03,
        0.9358726756122197e+00,
        0.1755956080487566e-03,
        0.9363948683206198e+00,
        0.1756436514503888e-03,
        0.9369161249440563e+00,
        0.1756916466502072e-03,
        0.9374368332783890e+00,
        0.1757396298093589e-03,
        0.9379573845551401e+00,
        0.1757876374006189e-03,
        0.9384781735788145e+00,
        0.1758357062165868e-03,
        0.9389995988277885e+00,
        0.1758838733741719e-03,
        0.9395220625161108e+00,
        0.1759321763151046e-03,
        0.9400459706133823e+00,
        0.1759806528021968e-03,
        0.9405717328197126e+00,
        0.1760293409110582e-03,
        0.9410997624925852e+00,
        0.1760782790169647e-03,
        0.9416304765223171e+00,
        0.1761275057765599e-03,
        0.9421642951526550e+00,
        0.1761770601040649e-03,
        0.9427016417429337e+00,
        0.1762269811416588e-03,
        0.9432429424681213e+00,
        0.1762773082236904e-03,
        0.9437886259529981e+00,
        0.1763280808343769e-03,
        0.9443391228366760e+00,
        0.1763793385586478e-03,
        0.9448948652636468e+00,
        0.1764311210257938e-03,
        0.9454562862975816e+00,
        0.1764834678455926e-03,
        0.9460238192541732e+00,
        0.1765364185365951e-03,
        0.9465978969494375e+00,
        0.1765900124462755e-03,
        0.9471789508600694e+00,
        0.1766442886627730e-03,
        0.9477674101926942e+00,
        0.1766992859179855e-03,
        0.9483637008591625e+00,
        0.1767550424818139e-03,
        0.9489682443554301e+00,
        0.1768115960474016e-03,
        0.9495814565420250e+00,
        0.1768689836072686e-03,
        0.9502037463246646e+00,
        0.1769272413203024e-03,
        0.9508355142342285e+00,
        0.1769864043696395e-03,
        0.9514771509060350e+00,
        0.1770465068115518e-03,
        0.9521290354592114e+00,
        0.1771075814155438e-03,
        0.9527915337778898e+00,
        0.1771696594959625e-03,
        0.9534649966970047e+00,
        0.1772327707355348e-03,
        0.9541497580966158e+00,
        0.1772969430013587e-03,
        0.9548461329099190e+00,
        0.1773622021540052e-03,
        0.9555544150514501e+00,
        0.1774285718505145e-03,
        0.9562748752734012e+00,
        0.4141439367791228e-04,
        0.5692455280094251e-04,
        0.2545075230958515e-01,
        0.6880819048293672e-04,
        0.9888145093055719e-01,
        0.7808989690617372e-04,
        0.1745598225673840e+00,
        0.8550005185877480e-04,
        0.2432430266865816e+00,
        0.9153624710259941e-04,
        0.3035382198764821e+00,
        0.9654032678652594e-04,
        0.3560490681596453e+00,
        0.1007520715550410e-03,
        0.4018200414988670e+00,
        0.1043435691172141e-03,
        0.4418859966836131e+00,
        0.1074410674826558e-03,
        0.4771511109577878e+00,
        0.1101390695970056e-03,
        0.5083717098779069e+00,
        0.1125096126676353e-03,
        0.5361705935601133e+00,
        0.1146085117292486e-03,
        0.5610585709493248e+00,
        0.1164796503201761e-03,
        0.5834552139424401e+00,
        0.1181579881289340e-03,
        0.6037065747337148e+00,
        0.1196717082477531e-03,
        0.6220996084034542e+00,
        0.1210437761733641e-03,
        0.6388736798670074e+00,
        0.1222930892987222e-03,
        0.6542296751290908e+00,
        0.1234353365269360e-03,
        0.6683372064799513e+00,
        0.1244836495012513e-03,
        0.6813403224997011e+00,
        0.1254491018862550e-03,
        0.6933620512173756e+00,
        0.1263410963843689e-03,
        0.7045080329697024e+00,
        0.1271676677918698e-03,
        0.7148694414033631e+00,
        0.1279357225503386e-03,
        0.7245253456049399e+00,
        0.1286512297599230e-03,
        0.7335446313434784e+00,
        0.1293193747303500e-03,
        0.7419875726551162e+00,
        0.1299446833543593e-03,
        0.7499071245871521e+00,
        0.1305311235624521e-03,
        0.7573499923313203e+00,
        0.1310821886317202e-03,
        0.7643575200396533e+00,
        0.1316009660202284e-03,
        0.7709664334404412e+00,
        0.1320901945745293e-03,
        0.7772094632859758e+00,
        0.1325523123360135e-03,
        0.7831158711649373e+00,
        0.1329894966984371e-03,
        0.7887118949231211e+00,
        0.1334036983057875e-03,
        0.7940211275731494e+00,
        0.1337966697989137e-03,
        0.7990648409231811e+00,
        0.1341699903007926e-03,
        0.8038622630547293e+00,
        0.1345250863590139e-03,
        0.8084308171076828e+00,
        0.1348632499289629e-03,
        0.8127863274927396e+00,
        0.1351856538739728e-03,
        0.8169431985757714e+00,
        0.1354933653731529e-03,
        0.8209145700097322e+00,
        0.1357873575589372e-03,
        0.8247124521846697e+00,
        0.1360685196510050e-03,
        0.8283478446917955e+00,
        0.1363376658083228e-03,
        0.8318308402273038e+00,
        0.1365955428844750e-03,
        0.8351707159751699e+00,
        0.1368428372415219e-03,
        0.8383760141893339e+00,
        0.1370801807530195e-03,
        0.8414546134316254e+00,
        0.1373081561065382e-03,
        0.8444137917023124e+00,
        0.1375273014991923e-03,
        0.8472602825170738e+00,
        0.1377381148057014e-03,
        0.8500003248309528e+00,
        0.1379410572868236e-03,
        0.8526397075811507e+00,
        0.1381365568962136e-03,
        0.8551838095120960e+00,
        0.1383250112355325e-03,
        0.8576376348545903e+00,
        0.1385067902006957e-03,
        0.8600058453531640e+00,
        0.1386822383562781e-03,
        0.8622927890697443e+00,
        0.1388516770701086e-03,
        0.8645025263354547e+00,
        0.1390154064358504e-03,
        0.8666388531742509e+00,
        0.1391737070077414e-03,
        0.8687053224808631e+00,
        0.1393268413685703e-03,
        0.8707052632000881e+00,
        0.1394750555493091e-03,
        0.8726417977239585e+00,
        0.1396185803165322e-03,
        0.8745178576969695e+00,
        0.1397576323417808e-03,
        0.8763361983967452e+00,
        0.1398924152653265e-03,
        0.8780994118377522e+00,
        0.1400231206653106e-03,
        0.8798099387284804e+00,
        0.1401499289419495e-03,
        0.8814700793975387e+00,
        0.1402730101253844e-03,
        0.8830820037910464e+00,
        0.1403925246147742e-03,
        0.8846477606322743e+00,
        0.1405086238553824e-03,
        0.8861692858244719e+00,
        0.1406214509596627e-03,
        0.8876484101690279e+00,
        0.1407311412776921e-03,
        0.8890868664633782e+00,
        0.1408378229217274e-03,
        0.8904862960362619e+00,
        0.1409416172491532e-03,
        0.8918482547719127e+00,
        0.1410426393076430e-03,
        0.8931742186694573e+00,
        0.1411409982459610e-03,
        0.8944655889790835e+00,
        0.1412367976934811e-03,
        0.8957236969523653e+00,
        0.1413301361111912e-03,
        0.8969498082404222e+00,
        0.1414211071166758e-03,
        0.8981451269702901e+00,
        0.1415097997853232e-03,
        0.8993107995269396e+00,
        0.1415962989297887e-03,
        0.9004479180657531e+00,
        0.1416806853595467e-03,
        0.9015575237779278e+00,
        0.1417630361221969e-03,
        0.9026406099291728e+00,
        0.1418434247280258e-03,
        0.9036981246901897e+00,
        0.1419219213591954e-03,
        0.9047309737757363e+00,
        0.1419985930647974e-03,
        0.9057400229075616e+00,
        0.1420735039429043e-03,
        0.9067261001151347e+00,
        0.1421467153106468e-03,
        0.9076899978868622e+00,
        0.1422182858632548e-03,
        0.9086324751833850e+00,
        0.1422882718229183e-03,
        0.9095542593235423e+00,
        0.1423567270782516e-03,
        0.9104560477526908e+00,
        0.1424237033150753e-03,
        0.9113385097022479e+00,
        0.1424892501391719e-03,
        0.9122022877485889e+00,
        0.1425534151916154e-03,
        0.9130479992787559e+00,
        0.1426162442572255e-03,
        0.9138762378698273e+00,
        0.1426777813666525e-03,
        0.9146875745882436e+00,
        0.1427380688925579e-03,
        0.9154825592148789e+00,
        0.1427971476403172e-03,
        0.9162617214011930e+00,
        0.1428550569336404e-03,
        0.9170255717613750e+00,
        0.1429118346954711e-03,
        0.9177746029050118e+00,
        0.1429675175245004e-03,
        0.9185092904144644e+00,
        0.1430221407676021e-03,
        0.9192300937708136e+00,
        0.1430757385884771e-03,
        0.9199374572319491e+00,
        0.1431283440327680e-03,
        0.9206318106661012e+00,
        0.1431799890898880e-03,
        0.9213135703438758e+00,
        0.1432307047517914e-03,
        0.9219831396916189e+00,
        0.1432805210688911e-03,
        0.9226409100087367e+00,
        0.1433294672033191e-03,
        0.9232872611513990e+00,
        0.1433775714797077e-03,
        0.9239225621848796e+00,
        0.1434248614336570e-03,
        0.9245471720066236e+00,
        0.1434713638580431e-03,
        0.9251614399419788e+00,
        0.1435171048473090e-03,
        0.9257657063143877e+00,
        0.1435621098398706e-03,
        0.9263603029917071e+00,
        0.1436064036587590e-03,
        0.9269455539101992e+00,
        0.1436500105506133e-03,
        0.9275217755776247e+00,
        0.1436929542231280e-03,
        0.9280892775567625e+00,
        0.1437352578810521e-03,
        0.9286483629305795e+00,
        0.1437769442608283e-03,
        0.9291993287501823e+00,
        0.1438180356639552e-03,
        0.9297424664665897e+00,
        0.1438585539891476e-03,
        0.9302780623472868e+00,
        0.1438985207633644e-03,
        0.9308063978784351e+00,
        0.1439379571717663e-03,
        0.9313277501535416e+00,
        0.1439768840866617e-03,
        0.9318423922493136e+00,
        0.1440153220954916e-03,
        0.9323505935893585e+00,
        0.1440532915279006e-03,
        0.9328526202963160e+00,
        0.1440908124819338e-03,
        0.9333487355329478e+00,
        0.1441279048493981e-03,
        0.9338391998326430e+00,
        0.1441645883404158e-03,
        0.9343242714197350e+00,
        0.1442008825071996e-03,
        0.9348042065199632e+00,
        0.1442368067670687e-03,
        0.9352792596613518e+00,
        0.1442723804247230e-03,
        0.9357496839657160e+00,
        0.1443076226937871e-03,
        0.9362157314309450e+00,
        0.1443425527176319e-03,
        0.9366776532041510e+00,
        0.1443771895894746e-03,
        0.9371356998457099e+00,
        0.1444115523717566e-03,
        0.9375901215841609e+00,
        0.1444456601147895e-03,
        0.9380411685618638e+00,
        0.1444795318746588e-03,
        0.9384890910712563e+00,
        0.1445131867303672e-03,
        0.9389341397814829e+00,
        0.1445466438001951e-03,
        0.9393765659551052e+00,
        0.1445799222572509e-03,
        0.9398166216545342e+00,
        0.1446130413441780e-03,
        0.9402545599377586e+00,
        0.1446460203869812e-03,
        0.9406906350428731e+00,
        0.1446788788079280e-03,
        0.9411251025608388e+00,
        0.1447116361374763e-03,
        0.9415582195958393e+00,
        0.1447443120251743e-03,
        0.9419902449125173e+00,
        0.1447769262494714e-03,
        0.9424214390693087e+00,
        0.1448094987263750e-03,
        0.9428520645370120e+00,
        0.1448420495168817e-03,
        0.9432823858016560e+00,
        0.1448745988331048e-03,
        0.9437126694506553e+00,
        0.1449071670430162e-03,
        0.9441431842411634e+00,
        0.1449397746737126e-03,
        0.9445742011494633e+00,
        0.1449724424131142e-03,
        0.9450059934001559e+00,
        0.1450051911099938e-03,
        0.9454388364738392e+00,
        0.1450380417722341e-03,
        0.9458730080918976e+00,
        0.1450710155632024e-03,
        0.9463087881769580e+00,
        0.1451041337961289e-03,
        0.9467464587875015e+00,
        0.1451374179263711e-03,
        0.9471863040250684e+00,
        0.1451708895414430e-03,
        0.9476286099124387e+00,
        0.1452045703486834e-03,
        0.9480736642411287e+00,
        0.1452384821604381e-03,
        0.9485217563865096e+00,
        0.1452726468766264e-03,
        0.9489731770888300e+00,
        0.1453070864645653e-03,
        0.9494282181984106e+00,
        0.1453418229359214e-03,
        0.9498871723832843e+00,
        0.1453768783206665e-03,
        0.9503503327975676e+00,
        0.1454122746379124e-03,
        0.9508179927088858e+00,
        0.1454480338635091e-03,
        0.9512904450832298e+00,
        0.1454841778942922e-03,
        0.9517679821256925e+00,
        0.1455207285088794e-03,
        0.9522508947756375e+00,
        0.1455577073249200e-03,
        0.9527394721549711e+00,
        0.1455951357527194e-03,
        0.9532340009683443e+00,
        0.1456330349451717e-03,
        0.9537347648542913e+00,
        0.1456714257439507e-03,
        0.9542420436865237e+00,
        0.1457103286219321e-03,
        0.9547561128248467e+00,
        0.1457497636218381e-03,
        0.9552772423154445e+00,
        0.1457897502911246e-03,
        0.9558056960406009e+00,
        0.1458303076131549e-03,
        0.9563417308182725e+00,
        0.1458714539347385e-03,
        0.9568855954523308e+00,
        0.1459132068901443e-03,
        0.9574375297347150e+00,
        0.1459555833217350e-03,
        0.9579977634012095e+00,
        0.1459985991974088e-03,
        0.9585665150430652e+00,
        0.1460422695250747e-03,
        0.9591439909772242e+00,
        0.1460866082644329e-03,
        0.9597303840784822e+00,
        0.1461316282363772e-03,
        0.9603258725775255e+00,
        0.3429496445563442e-04,
        0.4713901805892190e-04,
        0.2545140450924156e-01,
        0.5698005902228804e-04,
        0.9888482887297308e-01,
        0.6466651548721230e-04,
        0.1745672748051217e+00,
        0.7080319239456011e-04,
        0.2432554843126429e+00,
        0.7580213079430914e-04,
        0.3035563500747286e+00,
        0.7994640198168629e-04,
        0.3560733630370389e+00,
        0.8343456150015368e-04,
        0.4018508725952348e+00,
        0.8640911033247278e-04,
        0.4419236498367694e+00,
        0.8897459090834537e-04,
        0.4771958093843240e+00,
        0.9120925845958284e-04,
        0.5084236299136395e+00,
        0.9317276496329196e-04,
        0.5362298756774806e+00,
        0.9491132926180562e-04,
        0.5611253276477577e+00,
        0.9646129005158931e-04,
        0.5835295355152852e+00,
        0.9785159643187923e-04,
        0.6037885335602648e+00,
        0.9910558598615794e-04,
        0.6221892621956204e+00,
        0.1002422757479970e-03,
        0.6389710741614672e+00,
        0.1012773140638229e-03,
        0.6543348452257979e+00,
        0.1022236924158808e-03,
        0.6684501789683020e+00,
        0.1030922846881736e-03,
        0.6814611164733789e+00,
        0.1038922606077670e-03,
        0.6934906792512014e+00,
        0.1046314062227422e-03,
        0.7046445019124451e+00,
        0.1053163748547551e-03,
        0.7150137530267155e+00,
        0.1059528854651743e-03,
        0.7246774971389701e+00,
        0.1065458808280527e-03,
        0.7337046159216464e+00,
        0.1070996546816144e-03,
        0.7421553796866258e+00,
        0.1076179547185671e-03,
        0.7500827400704289e+00,
        0.1081040665980620e-03,
        0.7575333991194183e+00,
        0.1085608829314993e-03,
        0.7645486980661065e+00,
        0.1089909602824242e-03,
        0.7711653599123298e+00,
        0.1093965665385209e-03,
        0.7774161128496167e+00,
        0.1097797204987463e-03,
        0.7833302160485503e+00,
        0.1101422251266719e-03,
        0.7889339050599856e+00,
        0.1104856956203599e-03,
        0.7942507707081078e+00,
        0.1108115832166325e-03,
        0.7993020827048136e+00,
        0.1111211954666116e-03,
        0.8041070671151008e+00,
        0.1114157135775683e-03,
        0.8086831451312193e+00,
        0.1116962073042465e-03,
        0.8130461392755103e+00,
        0.1119636477840458e-03,
        0.8172104520762232e+00,
        0.1122189186395992e-03,
        0.8211892213917328e+00,
        0.1124628256154204e-03,
        0.8249944558535597e+00,
        0.1126961049694284e-03,
        0.8286371533240165e+00,
        0.1129194308029721e-03,
        0.8321274047940588e+00,
        0.1131334214826889e-03,
        0.8354744857604805e+00,
        0.1133386452827434e-03,
        0.8386869368027751e+00,
        0.1135356253556231e-03,
        0.8417726348159536e+00,
        0.1137248441228562e-03,
        0.8447388561361401e+00,
        0.1139067471630854e-03,
        0.8475923326126939e+00,
        0.1140817466633488e-03,
        0.8503393015273689e+00,
        0.1142502244897405e-03,
        0.8529855501323292e+00,
        0.1144125349255261e-03,
        0.8555364554704203e+00,
        0.1145690071179690e-03,
        0.8579970200494635e+00,
        0.1147199472693837e-03,
        0.8603719038646763e+00,
        0.1148656406030670e-03,
        0.8626654531972963e+00,
        0.1150063531306337e-03,
        0.8648817265611982e+00,
        0.1151423332437714e-03,
        0.8670245181211878e+00,
        0.1152738131504335e-03,
        0.8690973788654197e+00,
        0.1154010101729216e-03,
        0.8711036357789597e+00,
        0.1155241279231094e-03,
        0.8730464092349987e+00,
        0.1156433573681646e-03,
        0.8749286287938791e+00,
        0.1157588777984930e-03,
        0.8767530475772949e+00,
        0.1158708577082165e-03,
        0.8785222553652559e+00,
        0.1159794555972724e-03,
        0.8802386905462134e+00,
        0.1160848207031594e-03,
        0.8819046510357806e+00,
        0.1161870936694311e-03,
        0.8835223042664072e+00,
        0.1162864071572288e-03,
        0.8850936963389428e+00,
        0.1163828864054445e-03,
        0.8866207604170093e+00,
        0.1164766497444822e-03,
        0.8881053244363083e+00,
        0.1165678090680486e-03,
        0.8895491181932601e+00,
        0.1166564702669258e-03,
        0.8909537798705543e+00,
        0.1167427336282587e-03,
        0.8923208620511820e+00,
        0.1168266942035215e-03,
        0.8936518372671990e+00,
        0.1169084421479998e-03,
        0.8949481031247646e+00,
        0.1169880630343355e-03,
        0.8962109870428230e+00,
        0.1170656381424237e-03,
        0.8974417506390828e+00,
        0.1171412447277278e-03,
        0.8986415937936533e+00,
        0.1172149562698677e-03,
        0.8998116584177496e+00,
        0.1172868427031662e-03,
        0.9009530319522595e+00,
        0.1173569706306669e-03,
        0.9020667506186153e+00,
        0.1174254035230018e-03,
        0.9031538024423191e+00,
        0.1174922019033529e-03,
        0.9042151300675857e+00,
        0.1175574235196376e-03,
        0.9052516333798847e+00,
        0.1176211235049476e-03,
        0.9062641719516429e+00,
        0.1176833545271722e-03,
        0.9072535673250101e+00,
        0.1177441669286597e-03,
        0.9082206051443592e+00,
        0.1178036088566899e-03,
        0.9091660371500875e+00,
        0.1178617263854677e-03,
        0.9100905830442862e+00,
        0.1179185636302828e-03,
        0.9109949322379410e+00,
        0.1179741628544263e-03,
        0.9118797454885111e+00,
        0.1180285645694077e-03,
        0.9127456564359945e+00,
        0.1180818076289649e-03,
        0.9135932730449129e+00,
        0.1181339293173255e-03,
        0.9144231789590457e+00,
        0.1181849654321338e-03,
        0.9152359347751857e+00,
        0.1182349503624295e-03,
        0.9160320792416857e+00,
        0.1182839171620296e-03,
        0.9168121303871106e+00,
        0.1183318976186388e-03,
        0.9175765865838867e+00,
        0.1183789223189884e-03,
        0.9183259275514641e+00,
        0.1184250207102780e-03,
        0.9190606153031572e+00,
        0.1184702211581763e-03,
        0.9197810950405108e+00,
        0.1185145510016160e-03,
        0.9204877959987503e+00,
        0.1185580366045994e-03,
        0.9211811322466059e+00,
        0.1186007034052168e-03,
        0.9218615034435585e+00,
        0.1186425759620638e-03,
        0.9225292955573307e+00,
        0.1186836779982295e-03,
        0.9231848815442406e+00,
        0.1187240324430169e-03,
        0.9238286219948466e+00,
        0.1187636614715423e-03,
        0.9244608657471405e+00,
        0.1188025865423529e-03,
        0.9250819504693824e+00,
        0.1188408284331903e-03,
        0.9256922032145273e+00,
        0.1188784072750181e-03,
        0.9262919409480546e+00,
        0.1189153425844261e-03,
        0.9268814710508878e+00,
        0.1189516532945120e-03,
        0.9274610917989764e+00,
        0.1189873577843384e-03,
        0.9280310928210021e+00,
        0.1190224739070536e-03,
        0.9285917555355758e+00,
        0.1190570190167592e-03,
        0.9291433535691963e+00,
        0.1190910099942032e-03,
        0.9296861531561591e+00,
        0.1191244632713702e-03,
        0.9302204135215227e+00,
        0.1191573948550362e-03,
        0.9307463872481658e+00,
        0.1191898203493515e-03,
        0.9312643206289019e+00,
        0.1192217549775109e-03,
        0.9317744540045509e+00,
        0.1192532136025640e-03,
        0.9322770220888102e+00,
        0.1192842107474197e-03,
        0.9327722542807087e+00,
        0.1193147606140906e-03,
        0.9332603749653780e+00,
        0.1193448771022213e-03,
        0.9337416038038212e+00,
        0.1193745738269449e-03,
        0.9342161560123183e+00,
        0.1194038641361023e-03,
        0.9346842426320593e+00,
        0.1194327611268635e-03,
        0.9351460707895552e+00,
        0.1194612776617823e-03,
        0.9356018439483411e+00,
        0.1194894263843151e-03,
        0.9360517621524420e+00,
        0.1195172197338335e-03,
        0.9364960222620436e+00,
        0.1195446699601559e-03,
        0.9369348181817692e+00,
        0.1195717891376224e-03,
        0.9373683410819361e+00,
        0.1195985891787351e-03,
        0.9377967796131314e+00,
        0.1196250818473841e-03,
        0.9382203201144163e+00,
        0.1196512787716769e-03,
        0.9386391468154388e+00,
        0.1196771914563876e-03,
        0.9390534420327067e+00,
        0.1197028312950406e-03,
        0.9394633863602434e+00,
        0.1197282095816411e-03,
        0.9398691588548227e+00,
        0.1197533375220634e-03,
        0.9402709372159495e+00,
        0.1197782262451063e-03,
        0.9406688979607300e+00,
        0.1198028868132232e-03,
        0.9410632165937440e+00,
        0.1198273302329317e-03,
        0.9414540677720091e+00,
        0.1198515674649078e-03,
        0.9418416254650982e+00,
        0.1198756094337670e-03,
        0.9422260631104450e+00,
        0.1198994670375319e-03,
        0.9426075537638465e+00,
        0.1199231511567857e-03,
        0.9429862702451438e+00,
        0.1199466726635097e-03,
        0.9433623852790360e+00,
        0.1199700424295984e-03,
        0.9437360716309537e+00,
        0.1199932713350474e-03,
        0.9441075022378914e+00,
        0.1200163702758047e-03,
        0.9444768503340695e+00,
        0.1200393501712764e-03,
        0.9448442895712680e+00,
        0.1200622219714742e-03,
        0.9452099941336445e+00,
        0.1200849966637913e-03,
        0.9455741388468206e+00,
        0.1201076852793909e-03,
        0.9459368992809881e+00,
        0.1201302988991895e-03,
        0.9462984518477588e+00,
        0.1201528486594163e-03,
        0.9466589738904483e+00,
        0.1201753457567260e-03,
        0.9470186437674542e+00,
        0.1201978014528419e-03,
        0.9473776409283557e+00,
        0.1202202270787045e-03,
        0.9477361459823309e+00,
        0.1202426340380965e-03,
        0.9480943407584549e+00,
        0.1202650338107162e-03,
        0.9484524083574091e+00,
        0.1202874379546662e-03,
        0.9488105331941014e+00,
        0.1203098581083251e-03,
        0.9491689010306607e+00,
        0.1203323059915656e-03,
        0.9495276989992437e+00,
        0.1203547934062821e-03,
        0.9498871156140531e+00,
        0.1203773322361880e-03,
        0.9502473407719423e+00,
        0.1203999344458418e-03,
        0.9506085657409490e+00,
        0.1204226120788594e-03,
        0.9509709831360716e+00,
        0.1204453772552672e-03,
        0.9513347868815795e+00,
        0.1204682421679518e-03,
        0.9517001721591189e+00,
        0.1204912190781571e-03,
        0.9520673353408602e+00,
        0.1205143203099825e-03,
        0.9524364739069084e+00,
        0.1205375582438321e-03,
        0.9528077863461864e+00,
        0.1205609453087660e-03,
        0.9531814720399889e+00,
        0.1205844939737027e-03,
        0.9535577311273962e+00,
        0.1206082167374240e-03,
        0.9539367643517374e+00,
        0.1206321261173331e-03,
        0.9543187728872938e+00,
        0.1206562346369151e-03,
        0.9547039581454467e+00,
        0.1206805548118562e-03,
        0.9550925215594878e+00,
        0.1207050991347726e-03,
        0.9554846643473366e+00,
        0.1207298800585086e-03,
        0.9558805872514442e+00,
        0.1207549099779616e-03,
        0.9562804902552012e+00,
        0.1207802012103997e-03,
        0.9566845722752253e+00,
        0.1208057659742362e-03,
        0.9570930308289628e+00,
        0.1208316163662374e-03,
        0.9575060616771147e+00,
        0.1208577643371385e-03,
        0.9579238584404855e+00,
        0.1208842216656548e-03,
        0.9583466121909501e+00,
        0.1209109999308791e-03,
        0.9587745110163490e+00,
        0.1209381104830662e-03,
        0.9592077395592462e+00,
        0.1209655644128141e-03,
        0.9596464785296278e+00,
        0.1209933725186615e-03,
        0.9600909041917725e+00,
        0.1210215452731320e-03,
        0.9605411878256951e+00,
        0.1210500927872672e-03,
        0.9609974951637526e+00,
        0.1210790247737047e-03,
        0.9614599858031973e+00,
        0.1211083505083695e-03,
        0.9619288125956789e+00,
        0.1211380787908609e-03,
        0.9624041210149244e+00,
        0.1211682179036361e-03,
        0.9628860485040654e+00,
        0.1211987755701019e-03,
        0.9633747238043349e+00,
        0.1212297589117476e-03,
        0.9638702662671197e+00
    ]
    mσ = SVector{46, T}(0.4102693550421609e+00, 0.3889624104727243e+00,
        0.3804692420283886e+00, 0.3760815680865637e+00,
        0.3735177579729938e+00, 0.3719340231904236e+00,
        0.3708571145968057e+00, 0.3700947006022557e+00,
        0.3695328931459086e+00, 0.3691085831661758e+00,
        0.3687813249652330e+00, 0.3685244707068931e+00,
        0.3683185599507446e+00, 0.3681542178682514e+00,
        0.3680181997765286e+00, 0.3679084456991284e+00,
        0.3678181571053212e+00, 0.3678314333608541e+00,
        0.3677897070402892e+00, 0.3681800192470787e+00,
        0.3681272993461229e+00, 0.3680840569645587e+00,
        0.3680522380648169e+00, 0.3680263578626069e+00,
        0.3680061275157194e+00, 0.3679837719607466e+00,
        0.3679668653311732e+00, 0.3679542340323301e+00,
        0.3679429332584250e+00, 0.3679349432021754e+00,
        0.3679290943359695e+00, 0.3679242023884676e+00,
        0.3679207541681089e+00, 0.3679185472223537e+00,
        0.3679168690130640e+00, 0.3679158588043139e+00,
        0.3679154592969145e+00, 0.3679154025286917e+00,
        0.3679157536198652e+00, 0.3679163676763697e+00,
        0.3679171904021983e+00, 0.3679181786833088e+00,
        0.3679192462983425e+00, 0.3679204323079710e+00,
        0.3679216942157868e+00, 0.3679229127010114e+00)
    mτ = SVector{46, T}(0.4495196112243335e+00, 0.4219428123056774e+00,
        0.4084335547255627e+00, 0.4009301129475925e+00,
        0.3963598727888637e+00, 0.3934034185789226e+00,
        0.3913676516238603e+00, 0.3899091428928617e+00,
        0.3888276962996660e+00, 0.3880048656683555e+00,
        0.3873650613539532e+00, 0.3868583585730354e+00,
        0.3864499054795832e+00, 0.3861178821587815e+00,
        0.3858426294881124e+00, 0.3856144554520791e+00,
        0.3854228843194507e+00, 0.3853156085078759e+00,
        0.3851902798680153e+00, 0.3853705093720269e+00,
        0.3851957294861824e+00, 0.3850587241670235e+00,
        0.3849515900397918e+00, 0.3848648995575697e+00,
        0.3847945082231300e+00, 0.3847117224407400e+00,
        0.3846478726309070e+00, 0.3845979020112835e+00,
        0.3845472492329918e+00, 0.3845088319509754e+00,
        0.3844789634065264e+00, 0.3844504092359686e+00,
        0.3844285235163634e+00, 0.3844115660464609e+00,
        0.3843957877945634e+00, 0.3843835767106759e+00,
        0.3843727001444428e+00, 0.3843632394180673e+00,
        0.3843553120908175e+00, 0.3843487746818896e+00,
        0.3843434800804404e+00, 0.3843392605995229e+00,
        0.3843359163858929e+00, 0.3843331309176606e+00,
        0.3843309056586355e+00, 0.3843292556220249e+00)
    mδ = [
        0.00000000000000000000E+00, 0.00000000000000000000E+00, 0.00000000000000000000E+00,
        0.00000000000000000000E+00, 0.00000000000000000000E+00,
        0.00000000000000000000E+00, 0.00000000000000000000E+00, 0.00000000000000000000E+00,
        8.12486977620918337365E-01, -7.28773097927745921858E-01,
        1.53929833723406918384E+00, -6.78718088284711697006E-01,
        1.43212456755519709572E+00, 4.69463753837576026603E-01,
        5.85741165636162538311E-01, -3.01798440203253166198E-01,
        7.22794646403900136216E-01, -7.72743471613596225635E-01,
        1.48864530417844757754E+00, -8.08919150726661426532E-01,
        1.56730014222299964335E+00, 4.80304059269694363216E-01,
        6.15262864189998048282E-01, -3.37185931963354194683E-01,
        6.69549393958325376912E-01, -8.24499978553264635995E-01,
        1.48300948111634650303E+00, -9.50113460986385096126E-01,
        1.70875672126540380482E+00, 4.88326395135466213249E-01,
        6.34151038283412473306E-01, -3.63834173139859977860E-01,
        6.34207872425405211220E-01, -8.73882963458454877999E-01,
        1.49406837909541156492E+00, -1.09933681675998233645E+00,
        1.85628508730990638381E+00, 4.94687753552846082654E-01,
        6.46686069394870248993E-01, -3.84425552397792284288E-01,
        6.09159586843019295823E-01, -9.18826895906841674014E-01,
        1.51196828497054757849E+00, -1.25518898579702769397E+00,
        2.00952346736980397400E+00, 4.99898564899495282207E-01,
        6.55102366393049993295E-01, -4.00666449719768995473E-01,
        5.90439393740833817711E-01, -9.58188929024483842750E-01,
        1.53133029933645648603E+00, -1.41516837357593467048E+00,
        2.16661618456661571722E+00, 5.04406680776642425273E-01,
        6.60759697066070531818E-01, -4.13718566852031910352E-01,
        5.75950976659376155748E-01, -9.92586881514073105714E-01,
        1.55047214693893194527E+00, -1.57840060204922349312E+00,
        2.32691090315541201295E+00, 5.08438555764117375067E-01,
        6.64462818005689321242E-01, -4.24391072663618176487E-01,
        5.64417245953287263728E-01, -1.02264749891516093272E+00,
        1.56859062953197985666E+00, -1.74411508219371042930E+00,
        2.48975957687965931165E+00, 5.12159289287928610944E-01,
        6.66739958098745178060E-01, -4.33254752700724906651E-01,
        5.55035203505951821803E-01, -1.04903593285798578162E+00,
        1.58544086320984564114E+00, -1.91183926768898323032E+00,
        2.65474064528942835793E+00, 5.15673299236026756873E-01,
        6.67943829149933618737E-01, -4.40715750785515248000E-01,
        5.47265973988849552758E-01, -1.07231527124365109484E+00,
        1.60097101904264980537E+00, -2.08119734461619650925E+00,
        2.82150167641991510910E+00, 5.19053446722100142252E-01,
        6.68321777724915121957E-01, -4.47070892643296664362E-01,
        5.40735255755895536559E-01, -1.09295788477564101886E+00,
        1.61522533179418394136E+00, -2.25189657689606605911E+00,
        2.98975740129848602082E+00, 5.22350101167714278984E-01,
        6.68051803573460951508E-01, -4.52541080338755268781E-01,
        5.35171215781020689648E-01, -1.11134149958549200429E+00,
        1.62827090163155672066E+00, -2.42367147309386680707E+00,
        3.15924375171004913425E+00, 5.25601156848068264452E-01,
        6.67266309936709555426E-01, -4.57295188168595492693E-01,
        5.30386975709441613070E-01, -1.12782896140613492579E+00,
        1.64025788258900250694E+00, -2.59642784874174210553E+00,
        3.32985399580253599556E+00, 5.28823187697707675973E-01,
        6.66060669210347190804E-01, -4.61457709847260976748E-01,
        5.26222645785342993091E-01, -1.14264370414273205394E+00,
        1.65122852710315563268E+00, -2.76990532703624651488E+00,
        3.50132791722927282487E+00, 5.32042588913535927411E-01,
        6.64514246968258975664E-01, -4.65134245688768593083E-01,
        5.22579530971793100917E-01, -1.15606174981276532401E+00,
        1.66134808593834411139E+00, -2.94411818048287824408E+00,
        3.67366142823498348754E+00, 5.35259502080899815926E-01,
        6.62681355958110111512E-01, -4.68397610286904683979E-01,
        5.19364612931348371546E-01, -1.16825016942566798838E+00,
        1.67067972862282467254E+00, -3.11892058061154061312E+00,
        3.84670306505961393607E+00, 5.38485916689240481459E-01,
        6.60609999653738923778E-01, -4.71313431894906082290E-01,
        5.16788829811506201475E-01, -1.18033724906386903564E+00,
        1.68059049977076186296E+00, -3.29713092519016152282E+00,
        4.02308698159837595301E+00, 5.41483093192069005863E-01,
        6.58263893676738196648E-01, -4.73790930460592772321E-01,
        5.14304998507076689357E-01, -1.19073377613372373156E+00,
        1.68887564848401487622E+00, -3.47367860708368797226E+00,
        4.19804476672436729552E+00, 5.44676448882342341621E-01,
        6.55806604911024154231E-01, -4.76116894152687172593E-01,
        5.13589960088082628912E-01, -1.20515606553499048780E+00,
        1.70303038891054157949E+00, -3.66393701497361021460E+00,
        4.38598395349574764284E+00, 5.46671182266296720032E-01,
        6.52744230594774927551E-01, -4.77368474338934219338E-01,
        5.09739159130538118192E-01, -1.22199936143675453976E+00,
        1.71674113695163756502E+00, -4.01964986530396764085E+00,
        4.73898327663567249879E+00, 5.53127293624248724909E-01,
        6.47232142799416877756E-01, -4.81026025091960744725E-01,
        5.06520527894656823163E-01, -1.23635691131351750144E+00,
        1.72855545114196712752E+00, -4.37589514233806814560E+00,
        5.09283711217454928581E+00, 5.59711331901396394676E-01,
        6.41344728595288197458E-01, -4.84114090660203451925E-01,
        5.03803276287673604972E-01, -1.24877789707185804777E+00,
        1.73889257847652687735E+00, -4.73278235935597237543E+00,
        5.44759349212519247159E+00, 5.66396276676344494948E-01,
        6.35164281428605242474E-01, -4.86749425335729641265E-01,
        5.01471681002465719875E-01, -1.25959816565347270408E+00,
        1.74797203735196067747E+00, -5.09009183035491069583E+00,
        5.80299819311344492260E+00, 5.73181725164965245154E-01,
        6.28753608453937089533E-01, -4.89028970860368107915E-01,
        4.99453792983181434613E-01, -1.26911806685642878556E+00,
        1.75602403394953295043E+00, -5.44779395469228550869E+00,
        6.15898600310954731526E+00, 5.80053342188716122227E-01,
        6.22155984589057483184E-01, -4.91017278360511798841E-01,
        4.96891614247332674239E-01, -1.28142897286063844968E+00,
        1.76652666434294845342E+00, -5.98495176416156286154E+00,
        6.69387196523634308479E+00, 5.90502497722946905569E-01,
        6.11981310083296176155E-01, -4.93563606731462858478E-01,
        4.94757835449870145785E-01, -1.29183940727705727923E+00,
        1.77548002405115621791E+00, -6.52261564700799734052E+00,
        7.22956455582453356421E+00, 6.01104491030294370317E-01,
        6.01545930427517498458E-01, -4.95701512641275645091E-01,
        4.92955435112093302498E-01, -1.30075966178445185639E+00,
        1.78320672530745235827E+00, -7.06069598330517954819E+00,
        7.76591812321693737747E+00, 6.11834544482442616535E-01,
        5.90908170993480674671E-01, -4.97520575564165461922E-01,
        4.90950865514343173197E-01, -1.31084732228014431173E+00,
        1.79201079829462075100E+00, -7.77869460791076388367E+00,
        8.48192114792998562503E+00, 6.26304235765283403269E-01,
        5.76481826672101653813E-01, -4.99559522418163315721E-01,
        4.89290673656125271133E-01, -1.31931113113468635870E+00,
        1.79944706307159490577E+00, -8.49712580583305305819E+00,
        9.19864161957896649878E+00, 6.40933705788380372468E-01,
        5.61842025093213543176E-01, -5.01259917135680475055E-01,
        4.87893002571168196698E-01, -1.32651079511428862570E+00,
        1.80580770410030896956E+00, -9.21588277931848377497E+00,
        9.91591643489136498950E+00, 6.55695105765415101490E-01,
        5.47038281802224492783E-01, -5.02699731994758379740E-01,
        4.86430405399539524228E-01, -1.33412979918831582691E+00,
        1.81257595476641360128E+00, -1.01147091127954628143E+01,
        1.08131467820558650761E+01, 6.74296962980636449980E-01,
        5.28355940439588663191E-01, -5.04215234159822851304E-01,
        4.85209377935768312244E-01, -1.34054678585182850752E+00,
        1.81830433404417799092E+00, -1.10138341230877233311E+01,
        1.17109049342339957856E+01, 6.93037072897787677694E-01,
        5.09520730098204783084E-01, -5.05486991849720006279E-01,
        4.84175729782202711008E-01, -1.34602748463379752957E+00,
        1.82321853487022514204E+00, -1.19132124199752904591E+01,
        1.26090991612751560061E+01, 7.11888069421483144403E-01,
        4.90567373407577718542E-01, -5.06568701529195315892E-01,
        4.83126770220811022599E-01, -1.35163161291760795256E+00,
        1.82826350353962313550E+00, -1.29927160503633615383E+01,
        1.36873758035293972125E+01, 7.34629346797795606177E-01,
        4.67701563841374710696E-01, -5.07671157473134642726E-01,
        4.82240630576944849620E-01, -1.35639803101299618932E+00,
        1.83257021361753221132E+00, -1.40724292419831765993E+01,
        1.47660322097545412825E+01, 7.57477634847223574824E-01,
        4.44731539280507670621E-01, -5.08606206356366562226E-01,
        4.81367156621396127885E-01, -1.36113271821622814461E+00,
        1.83686390640311002081E+00, -1.53323244273312778038E+01,
        1.60248655639733479603E+01, 7.84241434589183555528E-01,
        4.17831296042478749180E-01, -5.09531593989592148160E-01,
        4.80531163012565954748E-01, -1.36569073148173135741E+00,
        1.84101098764632071595E+00, -1.67724121092828698253E+01,
        1.74639192966393345609E+01, 8.14944291548999934247E-01,
        3.86983337882212522215E-01, -5.10420442074747720806E-01,
        4.79749020242059833272E-01, -1.36998241801911678434E+00,
        1.84492857996521910763E+00, -1.83927271415090676685E+01,
        1.90832501718852015331E+01, 8.49600663929823164729E-01,
        3.52177408428784415426E-01, -5.11255041982473715564E-01,
        4.79028593400465650431E-01, -1.37395702074126282848E+00,
        1.84856758184263047857E+00, -2.01932729967363779480E+01,
        2.08828751980543900884E+01, 8.88220808772766089744E-01,
        3.13407707501851930737E-01, -5.12026314956605880081E-01,
        4.78372530027749476264E-01, -1.37759523473755559956E+00,
        1.85190788567904290355E+00, -2.21740562692915954914E+01,
        2.28628075587272940312E+01, 9.30809799267995601264E-01,
        2.70672336930477278575E-01, -5.12730846762774340106E-01,
        4.77779801063204719502E-01, -1.38089853702655061825E+00,
        1.85494855616308576614E+00, -2.43350799264012238513E+01,
        2.50230519271598596000E+01, 9.77369259847096275005E-01,
        2.23971941573455075423E-01, -5.13369200661915601715E-01,
        4.77246930697155851376E-01, -1.38388083497830479102E+00,
        1.85770008879250446260E+00, -2.66763359215418330255E+01,
        2.73635987907443544252E+01, 1.02789905825291165000E+00,
        1.73308375056936652543E-01, -5.13944564107326902888E-01,
        4.76738441547139881594E-01, -1.38673810457560919237E+00,
        1.86034197600837918185E+00, -2.93779298257507282786E+01,
        3.00645082809940281081E+01, 1.08629265414392617148E+00,
        1.14780731660905133982E-01, -5.14494930561531476014E-01,
        4.76265313632665625218E-01, -1.38940709710215504053E+00,
        1.86281489505945694605E+00, -3.24398788705648806736E+01,
        3.31258135412493377876E+01, 1.15256112877260078669E+00,
        4.83817578537822285464E-02, -5.15008215941925901268E-01,
        4.75853455945482924601E-01, -1.39173849595384809046E+00, 1.86497905481692169999E+00,
        -3.56820646881624356100E+01, 3.63674334307575103930E+01,
        1.22280637509052486722E+00, -2.19816640227445720239E-02,
        -5.15455968472705512180E-01
    ]

    KomBurSROCK2ConstantCache{typeof(zprev), T}(ms, recf, mσ, mτ, mδ, zprev, 1, 1, 1)
end

function SROCKC2ConstantCache{T}(zprev) where {T}
    ms = SVector{46, Int}(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
        17, 18, 19, 20, 22, 24, 26, 28, 30, 33, 36, 39, 43,
        47, 51, 56, 61, 66, 72, 78, 85, 93, 102, 112, 123, 135, 148, 163, 180, 198)
    recf = [
        0.1794612899156781e+00,
        0.9326607661089206e-01,
        0.1268473641290642e+00,
        0.2103378190528467e-01,
        0.5786627125519110e-01,
        0.7776456841673992e-01,
        0.2157791817707098e-01,
        0.9528922876588625e-01,
        0.8723622960881585e-01,
        0.3957407527591189e-01,
        0.5338681630900877e-01,
        0.2247986572029358e-01,
        0.6393794866013653e-01,
        0.8616759602466630e-01,
        0.7433164225960258e-01,
        0.1608966052260327e+00,
        0.2881884349012583e-01,
        0.3903194468364506e-01,
        0.2315538732440072e-01,
        0.4666180548151659e-01,
        0.8821448969005685e-01,
        0.5288869100008489e-01,
        0.1558852247558841e+00,
        0.5955157767537859e-01,
        0.2309801425356076e+00,
        0.2193602641069006e-01,
        0.2980001095383432e-01,
        0.2364036352805737e-01,
        0.3566742298660092e-01,
        0.9017696352896830e-01,
        0.4023410528284037e-01,
        0.1575736612169138e+00,
        0.4421100494822930e-01,
        0.2217430621508580e+00,
        0.4869809870617736e-01,
        0.2940499060453847e+00,
        0.1726461340854506e-01,
        0.2350655101084081e-01,
        0.2399195202240830e-01,
        0.2817607209777294e-01,
        0.9173675182820953e-01,
        0.3176838133583184e-01,
        0.1600219376374877e+00,
        0.3469194451695863e-01,
        0.2221486436776174e+00,
        0.3738763501161190e-01,
        0.2814712676591709e+00,
        0.4053195010515956e-01,
        0.3498597719348680e+00,
        0.1394572558988917e-01,
        0.1901965402711647e-01,
        0.2425291169233543e-01,
        0.2282720812165174e-01,
        0.9294575674653435e-01,
        0.2575013323611407e-01,
        0.1622227426315588e+00,
        0.2807705415789230e-01,
        0.2243919049772138e+00,
        0.3005377306193452e-01,
        0.2802435651401261e+00,
        0.3196472247412495e-01,
        0.3348331353768858e+00,
        0.3423680369928859e-01,
        0.3989016641565190e+00,
        0.1150212461258425e-01,
        0.1570710434739234e-01,
        0.2445103607680476e-01,
        0.1887147450684578e-01,
        0.9388711032641100e-01,
        0.2130209293934879e-01,
        0.1640457400037581e+00,
        0.2322314183593871e-01,
        0.2267657098371261e+00,
        0.2480419563989607e-01,
        0.2818605427391582e+00,
        0.2620108024481186e-01,
        0.3319747646481704e+00,
        0.2760343567567814e-01,
        0.3822711818317003e+00,
        0.2928725018247521e-01,
        0.4419889482818066e+00,
        0.9650189035331108e-02,
        0.1319127118048348e-01,
        0.2460463437251803e-01,
        0.1586242507387037e-01,
        0.9462914691841271e-01,
        0.1791697874611395e-01,
        0.1655306545097223e+00,
        0.1953741662819831e-01,
        0.2288845437800309e+00,
        0.2085448736610660e-01,
        0.2840687821706643e+00,
        0.2197276738303543e-01,
        0.3327621634208670e+00,
        0.2299581340430604e-01,
        0.3779528907207973e+00,
        0.2405334751606276e-01,
        0.4244163000944219e+00,
        0.2532773055505536e-01,
        0.4799238174596328e+00,
        0.8212831461177801e-02,
        0.1123533801931148e-01,
        0.2472592539190680e-01,
        0.1351988263110243e-01,
        0.9522208667469109e-01,
        0.1527968649293853e-01,
        0.1667413647253854e+00,
        0.1666740304836073e-01,
        0.2306916351605186e+00,
        0.1778972104750926e-01,
        0.2862271893660237e+00,
        0.1872598244401872e-01,
        0.3345934460509904e+00,
        0.1954407472805166e-01,
        0.3778520013827246e+00,
        0.2031544030249000e-01,
        0.4188775043096391e+00,
        0.2113066217102199e-01,
        0.4619185110779211e+00,
        0.2211266742157054e-01,
        0.5134449754977242e+00,
        0.7074719613815112e-02,
        0.9684509591053977e-02,
        0.2482326781574381e-01,
        0.1166040318768419e-01,
        0.9570219065303219e-01,
        0.1318459890146430e-01,
        0.1677351729038757e+00,
        0.1438717215812115e-01,
        0.2322139970245483e+00,
        0.1535795943897448e-01,
        0.2881631572191675e+00,
        0.1616136143489047e-01,
        0.3366119552764601e+00,
        0.1684787625840699e-01,
        0.3791920530521655e+00,
        0.1746359793359561e-01,
        0.4179163657739238e+00,
        0.1805925334195525e-01,
        0.4554086296687285e+00,
        0.1869919690078058e-01,
        0.4953803203133830e+00,
        0.1946782991114719e-01,
        0.5431953913817005e+00,
        0.6158116280205625e-02,
        0.8434133870779752e-02,
        0.2490250308471492e-01,
        0.1015973796908432e-01,
        0.9609568511780181e-01,
        0.1149255448537381e-01,
        0.1685578212579456e+00,
        0.1254496388900155e-01,
        0.2334953976202505e+00,
        0.1339412026724050e-01,
        0.2898496927042313e+00,
        0.1409430683259744e-01,
        0.3385311597112782e+00,
        0.1468607650095395e-01,
        0.3809553853632720e+00,
        0.1520306181269769e-01,
        0.4187183922578105e+00,
        0.1567773486210682e-01,
        0.4536627812581018e+00,
        0.1614693417033556e-01,
        0.4881324072137513e+00,
        0.1665708022899876e-01,
        0.5253402953586265e+00,
        0.1726712768780420e-01,
        0.5697310475495430e+00,
        0.5408899288459016e-02,
        0.7411165652735432e-02,
        0.2496784203339785e-01,
        0.8931010375660927e-02,
        0.9642194989632852e-01,
        0.1010622203571924e-01,
        0.1692450860120974e+00,
        0.1103497280658699e-01,
        0.2345784420179126e+00,
        0.1178444954979593e-01,
        0.2913056300783272e+00,
        0.1240145878830343e-01,
        0.3402656182942943e+00,
        0.1292005530031986e-01,
        0.3827567779382510e+00,
        0.1336687811001040e-01,
        0.4201602339064523e+00,
        0.1376523513966666e-01,
        0.4539235794662016e+00,
        0.1413868046925951e-01,
        0.4856954694207845e+00,
        0.1451444200099929e-01,
        0.5175484724211766e+00,
        0.1492644572980292e-01,
        0.5522503690808819e+00,
        0.1541651122328756e-01,
        0.5934874290489524e+00,
        0.4788707289765767e-02,
        0.6563722805402352e-02,
        0.2502230585699310e-01,
        0.7912416503013329e-02,
        0.9669512238638367e-01,
        0.8956313102014822e-02,
        0.1698239427218661e+00,
        0.9781969024648538e-02,
        0.2354985079518828e+00,
        0.1044851744036037e-01,
        0.2925601105800896e+00,
        0.1099693219507985e-01,
        0.3418012690877302e+00,
        0.1145659208699840e-01,
        0.3844521174650939e+00,
        0.1184970544276362e-01,
        0.4217763245489749e+00,
        0.1219446847463953e-01,
        0.4550117593290032e+00,
        0.1250758855429112e-01,
        0.4854408050495134e+00,
        0.1280655793511545e-01,
        0.5145268041703330e+00,
        0.1311180392585363e-01,
        0.5440941264902900e+00,
        0.1344843304771755e-01,
        0.5765229845165943e+00,
        0.1384655622092475e-01,
        0.6148795064211108e+00,
        0.4269409473142479e-02,
        0.5853691221954542e-02,
        0.2506818803768801e-01,
        0.7058488452666192e-02,
        0.9692609816181726e-01,
        0.7991811416685026e-02,
        0.1703157380843560e+00,
        0.8730579305889177e-02,
        0.2362853743226745e+00,
        0.9327287399213484e-02,
        0.2936438651173445e+00,
        0.9818197983040463e-02,
        0.3431514772416978e+00,
        0.1022909697576184e-01,
        0.3859958359229893e+00,
        0.1057909230023007e-01,
        0.4233725763238417e+00,
        0.1088320687501712e-01,
        0.4564025740290915e+00,
        0.1115430586715170e-01,
        0.4861671131891395e+00,
        0.1140470198717317e-01,
        0.5137949407970326e+00,
        0.1164762828827466e-01,
        0.5405812657784165e+00,
        0.1189859698528282e-01,
        0.5681279106485080e+00,
        0.1217639078124160e-01,
        0.5984802463148428e+00,
        0.1250297795297910e-01,
        0.6341959825388761e+00,
        0.3830262680422776e-02,
        0.5252924239469980e-02,
        0.2510718258012232e-01,
        0.6335607341496969e-02,
        0.9712300411103620e-01,
        0.7174964200736387e-02,
        0.1707366515477548e+00,
        0.7839821469171156e-02,
        0.2369623770049865e+00,
        0.8377122084280812e-02,
        0.2945833847967025e+00,
        0.8819233466500510e-02,
        0.3443363340392364e+00,
        0.9189060633588098e-02,
        0.3873807210303031e+00,
        0.9503378800566590e-02,
        0.4248706039873364e+00,
        0.9775047051845269e-02,
        0.4578585641947919e+00,
        0.1001457306569686e-01,
        0.4873111192988822e+00,
        0.1023132837651919e-01,
        0.5141675256404127e+00,
        0.1043459649534057e-01,
        0.5394214279393358e+00,
        0.1063454146082206e-01,
        0.5642188354052674e+00,
        0.1084307018096031e-01,
        0.5899649430016252e+00,
        0.1107438039614643e-01,
        0.6184184090843611e+00,
        0.1134470195438803e-01,
        0.6517206797990772e+00,
        0.3454097785831183e-02,
        0.4738087690909603e-02,
        0.2514098616718916e-01,
        0.5715864568881495e-02,
        0.9729414530950285e-01,
        0.6474399737140852e-02,
        0.1711037123670141e+00,
        0.7075625560198937e-02,
        0.2375553213635903e+00,
        0.7561765789488958e-02,
        0.2954111541648083e+00,
        0.7961900378019848e-02,
        0.3453896252983967e+00,
        0.8296546652001753e-02,
        0.3886303020948080e+00,
        0.8580623356383655e-02,
        0.4262600339398994e+00,
        0.8825386359541219e-02,
        0.4592889162561250e+00,
        0.9039751450513938e-02,
        0.4886139630455138e+00,
        0.9231266796183848e-02,
        0.5150610315193943e+00,
        0.9406897826583457e-02,
        0.5394434170928742e+00,
        0.9573720059444631e-02,
        0.5626311157802961e+00,
        0.9739556257960886e-02,
        0.5856281920506604e+00,
        0.9913518363761172e-02,
        0.6096518917386764e+00,
        0.1010629643624125e-01,
        0.6361953557375821e+00,
        0.1032986385558493e-01,
        0.6670333276830246e+00,
        0.3131660281084644e-02,
        0.4296601495430642e-02,
        0.2516987418923732e-01,
        0.5184210888756367e-02,
        0.9744072529384443e-01,
        0.5873198129887241e-02,
        0.1714189769006723e+00,
        0.6419613566950146e-02,
        0.2380664100570842e+00,
        0.6861660893085171e-02,
        0.2961280333876439e+00,
        0.7225632384805198e-02,
        0.3463080420218410e+00,
        0.7530044942257158e-02,
        0.3897316580976775e+00,
        0.7788304877568383e-02,
        0.4275077537500284e+00,
        0.8010430934156830e-02,
        0.4606200718057599e+00,
        0.8204207591967734e-02,
        0.4899241115804965e+00,
        0.8376002129523446e-02,
        0.5161793704075401e+00,
        0.8531389917004647e-02,
        0.5400945718660145e+00,
        0.8675676859844067e-02,
        0.5623795630774431e+00,
        0.8814368379677447e-02,
        0.5838024839647016e+00,
        0.8953595816500299e-02,
        0.6052506199023559e+00,
        0.9100459154569437e-02,
        0.6277890216584121e+00,
        0.9263166205736671e-02,
        0.6527013571399886e+00,
        0.9450740555370751e-02,
        0.6814810379908328e+00,
        0.2843902743022214e-02,
        0.3902467368190393e-02,
        0.2519598783827689e-01,
        0.4709429895823432e-02,
        0.9757348323445656e-01,
        0.5336152661315786e-02,
        0.1717052034351406e+00,
        0.5833455676281756e-02,
        0.2385318286257855e+00,
        0.6235971415149352e-02,
        0.2967834040784211e+00,
        0.6567522559559145e-02,
        0.3471521575495951e+00,
        0.6844866528765064e-02,
        0.3907519751170857e+00,
        0.7080101687099548e-02,
        0.4286785748173565e+00,
        0.7282213357366904e-02,
        0.4618976089399920e+00,
        0.7458094741776693e-02,
        0.4912372216070018e+00,
        0.7613251892383208e-02,
        0.5174141871126332e+00,
        0.7752321382046524e-02,
        0.5410706897885087e+00,
        0.7879480568321315e-02,
        0.5628149979263304e+00,
        0.7998799282231232e-02,
        0.5832647350414633e+00,
        0.8114557939046675e-02,
        0.6030926481771959e+00,
        0.8231531848213922e-02,
        0.6230734887604330e+00,
        0.8355206753895567e-02,
        0.6441267697250795e+00,
        0.8491839744291131e-02,
        0.6673428282976036e+00,
        0.8648214015485162e-02,
        0.6939680907913989e+00,
        0.2388386682754135e-02,
        0.3278278227000989e-02,
        0.2523707236937346e-01,
        0.3957198838737114e-02,
        0.9778285117940603e-01,
        0.4484932501394734e-02,
        0.1721579526332683e+00,
        0.4904057483051761e-02,
        0.2392707453970052e+00,
        0.5243583901636578e-02,
        0.2978287368553751e+00,
        0.5523456007427060e-02,
        0.3485067686781220e+00,
        0.5757685183723855e-02,
        0.3924033610212076e+00,
        0.5956358204781419e-02,
        0.4305980352749587e+00,
        0.6126919713095007e-02,
        0.4640361265644109e+00,
        0.6275007901630985e-02,
        0.4935170207127558e+00,
        0.6405016526854853e-02,
        0.5197143572851120e+00,
        0.6520488779186820e-02,
        0.5432046533152863e+00,
        0.6624408123666273e-02,
        0.5644970257796814e+00,
        0.6719427053538581e-02,
        0.5840623664365776e+00,
        0.6808059512718916e-02,
        0.6023621974962409e+00,
        0.6892851836922015e-02,
        0.6198777517486085e+00,
        0.6976537015760206e-02,
        0.6371392310474401e+00,
        0.7062164945929763e-02,
        0.6547536993606798e+00,
        0.7153184521396811e-02,
        0.6734273362784953e+00,
        0.7253430606435754e-02,
        0.6939734212185117e+00,
        0.7366943161281851e-02,
        0.7172914790760468e+00,
        0.2034217998243191e-02,
        0.2792734020582961e-02,
        0.2526908982706098e-01,
        0.3371787305020115e-02,
        0.9794643062684199e-01,
        0.3822201062511950e-02,
        0.1725128108619325e+00,
        0.4180174912236582e-02,
        0.2398521447789659e+00,
        0.4470370456915701e-02,
        0.2986551495007976e+00,
        0.4709737539597480e-02,
        0.3495841277608567e+00,
        0.4910176531706057e-02,
        0.3937272155460690e+00,
        0.5080243210917943e-02,
        0.4321540636611387e+00,
        0.5226234784652425e-02,
        0.4657990145921906e+00,
        0.5352893648837146e-02,
        0.4954473934553277e+00,
        0.5463875356202293e-02,
        0.5217531788617480e+00,
        0.5562069670587001e-02,
        0.5452642338468077e+00,
        0.5649829175907964e-02,
        0.5664474938420431e+00,
        0.5729139522573558e-02,
        0.5857122023051498e+00,
        0.5801753106324432e-02,
        0.6034312542567038e+00,
        0.5869300229750696e-02,
        0.6199612865321288e+00,
        0.5933386406539511e-02,
        0.6356621535317655e+00,
        0.5995679940966749e-02,
        0.6509160921778130e+00,
        0.6057989063542723e-02,
        0.6661462081376089e+00,
        0.6122321685397079e-02,
        0.6818327797828450e+00,
        0.6190912476732130e-02,
        0.6985240974244095e+00,
        0.6266191569573649e-02,
        0.7168360261395987e+00,
        0.6350658968555684e-02,
        0.7374314365934664e+00,
        0.1753390300533029e-02,
        0.2407592405123618e-02,
        0.2529453985226700e-01,
        0.2907262330175829e-02,
        0.9807671703676038e-01,
        0.3296143053353250e-02,
        0.1727961462451250e+00,
        0.3605393786629613e-02,
        0.2403177529025610e+00,
        0.3856241133152162e-02,
        0.2993193629853389e+00,
        0.4063271707574896e-02,
        0.3504538499243808e+00,
        0.4236723270781009e-02,
        0.3948018542411614e+00,
        0.4383951358482999e-02,
        0.4334263916612830e+00,
        0.4510362519918408e-02,
        0.4672550951343391e+00,
        0.4620017586359210e-02,
        0.4970655128750277e+00,
        0.4716030788908096e-02,
        0.5235015776135139e+00,
        0.4800840911719355e-02,
        0.5470972903869747e+00,
        0.4876401000932111e-02,
        0.5682998788764699e+00,
        0.4944315587632199e-02,
        0.5874903820382004e+00,
        0.5005943872710219e-02,
        0.6050015924522462e+00,
        0.5062480886612362e-02,
        0.6211339094140743e+00,
        0.5115024538196171e-02,
        0.6361697673414449e+00,
        0.5164633649628788e-02,
        0.6503872077614197e+00,
        0.5212379842880342e-02,
        0.6640729475349860e+00,
        0.5259393975018879e-02,
        0.6775349550821846e+00,
        0.5306905271212799e-02,
        0.6911140242391297e+00,
        0.5356268008877997e-02,
        0.7051930501274516e+00,
        0.5408966392479879e-02,
        0.7202015894622125e+00,
        0.5466583459521371e-02,
        0.7366118374462400e+00,
        0.5530715851949468e-02,
        0.7549206082556241e+00,
        0.1526985597447617e-02,
        0.2096996473761840e-02,
        0.2531509673360445e-01,
        0.2532539440756325e-02,
        0.9818212210216928e-01,
        0.2871665019548934e-02,
        0.1730258242612469e+00,
        0.3141479576178890e-02,
        0.2406960805778798e+00,
        0.3360448272795954e-02,
        0.2998605891705305e+00,
        0.3541258850863859e-02,
        0.3511649206182530e+00,
        0.3692814597959592e-02,
        0.3956840637564039e+00,
        0.3821509918296340e-02,
        0.4344762665775814e+00,
        0.3932041593754749e-02,
        0.4684646795111045e+00,
        0.4027932600409154e-02,
        0.4984220865031195e+00,
        0.4111877834418150e-02,
        0.5249867454711314e+00,
        0.4185977901331621e-02,
        0.5486853051737176e+00,
        0.4251901290680174e-02,
        0.5699549871771356e+00,
        0.4310999960360177e-02,
        0.5891629130044663e+00,
        0.4364394207792517e-02,
        0.6066224358437886e+00,
        0.4413037135908646e-02,
        0.6226069634301489e+00,
        0.4457765549253931e-02,
        0.6373618910220726e+00,
        0.4499341872619412e-02,
        0.6511152177198366e+00,
        0.4538490146036315e-02,
        0.6640873078294923e+00,
        0.4575927973865173e-02,
        0.6765001110571239e+00,
        0.4612395244609121e-02,
        0.6885859633887566e+00,
        0.4648679290544145e-02,
        0.7005958269983906e+00,
        0.4685634750981115e-02,
        0.7128064532627977e+00,
        0.4724194620734037e-02,
        0.7255254273702650e+00,
        0.4765366815800576e-02,
        0.7390923556807402e+00,
        0.4810208361466176e-02,
        0.7538736313498631e+00,
        0.4859767798035730e-02,
        0.7702474410767316e+00,
        0.1341778429126211e-02,
        0.1842856050972565e-02,
        0.2533193854590164e-01,
        0.2225855496752996e-02,
        0.9826859006407132e-01,
        0.2524180832845478e-02,
        0.1732145392603280e+00,
        0.2761629971248482e-02,
        0.2410075282122661e+00,
        0.2954414092304398e-02,
        0.3003071440620802e+00,
        0.3113671483601745e-02,
        0.3517531700231469e+00,
        0.3247217194092525e-02,
        0.3964161974860505e+00,
        0.3360662822142730e-02,
        0.4353508843394245e+00,
        0.3458128531982532e-02,
        0.4694771791546352e+00,
        0.3542702530515273e-02,
        0.4995646943102908e+00,
        0.3616743969933074e-02,
        0.5262481851213445e+00,
        0.3682087306007793e-02,
        0.5500500545141821e+00,
        0.3740183451080423e-02,
        0.5714020312900166e+00,
        0.3792199619292558e-02,
        0.5906638632386166e+00,
        0.3839091722399387e-02,
        0.6081388453953844e+00,
        0.3881658284331042e-02,
        0.6240866310409383e+00,
        0.3920581807177477e-02,
        0.6387339085746301e+00,
        0.3956461592009382e-02,
        0.6522834922619609e+00,
        0.3989840752967416e-02,
        0.6649222876852415e+00,
        0.4021229291927125e-02,
        0.6768284931080795e+00,
        0.4051124448454234e-02,
        0.6881782931898644e+00,
        0.4080028981647300e-02,
        0.6991521843388895e+00,
        0.4108467479283411e-02,
        0.7099409264259735e+00,
        0.4137000143073717e-02,
        0.7207509236661780e+00,
        0.4166232701476242e-02,
        0.7318085765567045e+00,
        0.4196820124371787e-02,
        0.7433628001322098e+00,
        0.4229460707743591e-02,
        0.7556844737332599e+00,
        0.4264876064174216e-02,
        0.7690611204503529e+00,
        0.4303772042593957e-02,
        0.7837847386079905e+00,
        0.1121314683543782e-02,
        0.1540263996358294e-02,
        0.2535201582246297e-01,
        0.1860616782749459e-02,
        0.9837180081070001e-01,
        0.2110257847461394e-02,
        0.1734401492675452e+00,
        0.2309054725495130e-02,
        0.2413805649139678e+00,
        0.2470541128098822e-02,
        0.3008431837086572e+00,
        0.2604015187479208e-02,
        0.3524611103987945e+00,
        0.2716000109093522e-02,
        0.3972999402435936e+00,
        0.2811178999641960e-02,
        0.4364103598053284e+00,
        0.2892989192294541e-02,
        0.4707089285552096e+00,
        0.2964005631609554e-02,
        0.5009621096861159e+00,
        0.3026193412069002e-02,
        0.5278014394899639e+00,
        0.3081077890619739e-02,
        0.5517457095527168e+00,
        0.3129861843706196e-02,
        0.5732222749918362e+00,
        0.3173507910562157e-02,
        0.5925852995229407e+00,
        0.3212797846468413e-02,
        0.6101307283827272e+00,
        0.3248376022424070e-02,
        0.6261084073494506e+00,
        0.3280782072682338e-02,
        0.6407319017471913e+00,
        0.3310475987498136e-02,
        0.6541865362303725e+00,
        0.3337857911967330e-02,
        0.6666360953708608e+00,
        0.3363284226199348e-02,
        0.6782285398626227e+00,
        0.3387081014309363e-02,
        0.6891010163282705e+00,
        0.3409555695216232e-02,
        0.6993843710724037e+00,
        0.3431007330102873e-02,
        0.7092073156356478e+00,
        0.3451735898380667e-02,
        0.7187003283870178e+00,
        0.3472050613465582e-02,
        0.7279993040305766e+00,
        0.3492277104239913e-02,
        0.7372488732478574e+00,
        0.3512762995683089e-02,
        0.7466051990304045e+00,
        0.3533881070388274e-02,
        0.7562379075535515e+00,
        0.3556028788751684e-02,
        0.7663306282943305e+00,
        0.3579622533335547e-02,
        0.7770794116956159e+00,
        0.3605084625764653e-02,
        0.7886880974410957e+00,
        0.3632821128406038e-02,
        0.8013595930224617e+00,
        0.9510596127542824e-03,
        0.1306530384822369e-02,
        0.2536754145655561e-01,
        0.1578428318009605e-02,
        0.9845171104183325e-01,
        0.1790384464545768e-02,
        0.1736150904003335e+00,
        0.1959236797520781e-02,
        0.2416703438788951e+00,
        0.2096455322227467e-02,
        0.3012604613663233e+00,
        0.2209920074417597e-02,
        0.3530135437139923e+00,
        0.2305159021830049e-02,
        0.3979914926982783e+00,
        0.2386140355447109e-02,
        0.4372421218440167e+00,
        0.2455776174573485e-02,
        0.4716796241323911e+00,
        0.2516247355295036e-02,
        0.5020683797660233e+00,
        0.2569217475366734e-02,
        0.5290379452961959e+00,
        0.2615976824974766e-02,
        0.5531050686294569e+00,
        0.2657541470416690e-02,
        0.5746948225947125e+00,
        0.2694722818617351e-02,
        0.5941586518170510e+00,
        0.2728177434091533e-02,
        0.6117891098846177e+00,
        0.2758443393525188e-02,
        0.6278316916720729e+00,
        0.2785967312803683e-02,
        0.6424943013679313e+00,
        0.2811124820961013e-02,
        0.6559548636293389e+00,
        0.2834236378150614e-02,
        0.6683675049794192e+00,
        0.2855579757979202e-02,
        0.6798676490616872e+00,
        0.2875400127857228e-02,
        0.6905762965442401e+00,
        0.2893918395849096e-02,
        0.7006037006910071e+00,
        0.2911338305155523e-02,
        0.7100526010841707e+00,
        0.2927852618951001e-02,
        0.7190211375279999e+00,
        0.2943648628770056e-02,
        0.7276055302511653e+00,
        0.2958913124102285e-02,
        0.7359025774945679e+00,
        0.2973836867449520e-02,
        0.7440119836573593e+00,
        0.2988618517881438e-02,
        0.7520384865047949e+00,
        0.3003467829003067e-02,
        0.7600936967329708e+00,
        0.3018607809042993e-02,
        0.7682974943112553e+00,
        0.3034275371809675e-02,
        0.7767787422315526e+00,
        0.3050719837809893e-02,
        0.7856749823571740e+00,
        0.3068198491381527e-02,
        0.7951306800776951e+00,
        0.3086968312155531e-02,
        0.8052935061547398e+00,
        0.3107273055760290e-02,
        0.8163081231039382e+00,
        0.8168405299925574e-03,
        0.1122235164426433e-02,
        0.2537979319269659e-01,
        0.1355887567479481e-02,
        0.9851483086228864e-01,
        0.1538080541563495e-02,
        0.1737534362414166e+00,
        0.1683267147792567e-02,
        0.2418998259562802e+00,
        0.1801292850812278e-02,
        0.3015914511597799e+00,
        0.1898921476480742e-02,
        0.3534525616677698e+00,
        0.1980897763334222e-02,
        0.3985422441814719e+00,
        0.2050627450222160e-02,
        0.4379061538920372e+00,
        0.2110609627253456e-02,
        0.4724567457971343e+00,
        0.2162715579344156e-02,
        0.5029569229728563e+00,
        0.2208372378885260e-02,
        0.5300349067999921e+00,
        0.2248686443403842e-02,
        0.5542061521610998e+00,
        0.2284528486070424e-02,
        0.5758943864439198e+00,
        0.2316593115008434e-02,
        0.5954495572468082e+00,
        0.2345441446771229e-02,
        0.6131624579583983e+00,
        0.2371532122833287e-02,
        0.6292764292152166e+00,
        0.2395244271202193e-02,
        0.6439966702794445e+00,
        0.2416894786788224e-02,
        0.6574976613071741e+00,
        0.2436751550587987e-02,
        0.6699291171394233e+00,
        0.2455043712749272e-02,
        0.6814208098492533e+00,
        0.2471969833678045e-02,
        0.6920865249452547e+00,
        0.2487704452255031e-02,
        0.7020273575786585e+00,
        0.2502403494283208e-02,
        0.7113345090150194e+00,
        0.2516208823898241e-02,
        0.7200917075437527e+00,
        0.2529252160257252e-02,
        0.7283773493344920e+00,
        0.2541658520726186e-02,
        0.7362664311381890e+00,
        0.2553549302394987e-02,
        0.7438323260356781e+00,
        0.2565045070295341e-02,
        0.7511484336838515e+00,
        0.2576268078538789e-02,
        0.7582897158118264e+00,
        0.2587344505847411e-02,
        0.7653341042347025e+00,
        0.2598406336420720e-02,
        0.7723637406308460e+00,
        0.2609592758562768e-02,
        0.7794659733020046e+00,
        0.2621050886496552e-02,
        0.7867339953288847e+00,
        0.2632935537833889e-02,
        0.7942669615898086e+00,
        0.2645407727623461e-02,
        0.8021693721981406e+00,
        0.2658631484279102e-02,
        0.8105494642340256e+00,
        0.2672768576741324e-02,
        0.8195163250963701e+00,
        0.2687970799566830e-02,
        0.8291754492311013e+00,
        0.6779619032019482e-03,
        0.9315109162316307e-03,
        0.2539248163813982e-01,
        0.1125546650705646e-02,
        0.9858025661395591e-01,
        0.1276892135791717e-02,
        0.1738969874989156e+00,
        0.1397535825902466e-02,
        0.2421382412064102e+00,
        0.1495644371531161e-02,
        0.3019358267641449e+00,
        0.1576828175558173e-02,
        0.3539100964089328e+00,
        0.1645022736116236e-02,
        0.3991173116956755e+00,
        0.1703052777188943e-02,
        0.4386009869035954e+00,
        0.1752990885928625e-02,
        0.4732718824089663e+00,
        0.1796388809395077e-02,
        0.5038914977622926e+00,
        0.1834429731186084e-02,
        0.5310868327976426e+00,
        0.1868030737964622e-02,
        0.5553722186397624e+00,
        0.1897913248880432e-02,
        0.5771702844407484e+00,
        0.1924652401977583e-02,
        0.5968298361224380e+00,
        0.1948712334483372e-02,
        0.6146404100545767e+00,
        0.1970471824369135e-02,
        0.6308438946964407e+00,
        0.1990243228225435e-02,
        0.6456437499005518e+00,
        0.2008286680798674e-02,
        0.6592123207734590e+00,
        0.2024820896049421e-02,
        0.6716966627198852e+00,
        0.2040031498715453e-02,
        0.6832232108862492e+00,
        0.2054077540780530e-02,
        0.6939015548982263e+00,
        0.2067096670752565e-02,
        0.7038275213823140e+00,
        0.2079209295013150e-02,
        0.7130857211033993e+00,
        0.2090521980414542e-02,
        0.7217516823653617e+00,
        0.2101130283221459e-02,
        0.7298936653027928e+00,
        0.2111121143106236e-02,
        0.7375742308368269e+00,
        0.2120574946574002e-02,
        0.7448516217331510e+00,
        0.2129567338002603e-02,
        0.7517810000528958e+00,
        0.2138170835613056e-02,
        0.7584155742314791e+00,
        0.2146456292026427e-02,
        0.7648076391248480e+00,
        0.2154494222946041e-02,
        0.7710095427995872e+00,
        0.2162356011555635e-02,
        0.7770745838488886e+00,
        0.2170114979286494e-02,
        0.7830578318730199e+00,
        0.2177847294739602e-02,
        0.7890168508176265e+00,
        0.2185632671118797e-02,
        0.7950122895929717e+00,
        0.2193554778405604e-02,
        0.8011082865424130e+00,
        0.2201701270375675e-02,
        0.8073726141153927e+00,
        0.2210163300386258e-02,
        0.8138764685711868e+00,
        0.2219034377453016e-02,
        0.8206937889887615e+00,
        0.2228408401671311e-02,
        0.8278999743285053e+00,
        0.2238376724427438e-02,
        0.8355698630075664e+00,
        0.2249024115421597e-02,
        0.8437748549346639e+00,
        0.5717171765067005e-03,
        0.7855819755678591e-03,
        0.2540219552841172e-01,
        0.9492803029534314e-03,
        0.9863038311884588e-01,
        0.1076991591417719e-02,
        0.1740070746137774e+00,
        0.1178820912278011e-02,
        0.2423212835361945e+00,
        0.1261652009696089e-02,
        0.3022005646620261e+00,
        0.1330213911048136e-02,
        0.3542623490383656e+00,
        0.1387823796651901e-02,
        0.3995607968545022e+00,
        0.1436862514566579e-02,
        0.4391378457027524e+00,
        0.1479076886266864e-02,
        0.4739030248719332e+00,
        0.1515774672793500e-02,
        0.5046168340722528e+00,
        0.1547952929687645e-02,
        0.5319054272436042e+00,
        0.1576384371750672e-02,
        0.5562823875920914e+00,
        0.1601676728454795e-02,
        0.5781696502895681e+00,
        0.1624314356699193e-02,
        0.5979153431712045e+00,
        0.1644687957566232e-02,
        0.6158083043507766e+00,
        0.1663116161966728e-02,
        0.6320896668598296e+00,
        0.1679861458243818e-02,
        0.6469620376959935e+00,
        0.1695142117261203e-02,
        0.6605967661879515e+00,
        0.1709141243106296e-02,
        0.6731397164733577e+00,
        0.1722013731055875e-02,
        0.6847158755342791e+00,
        0.1733891682879084e-02,
        0.6954330559199739e+00,
        0.1744888672268816e-02,
        0.7053848938737558e+00,
        0.1755103144742999e-02,
        0.7146532979347533e+00,
        0.1764621160512043e-02,
        0.7233104679728801e+00,
        0.1773518635044922e-02,
        0.7314205777797613e+00,
        0.1781863193450182e-02,
        0.7390411938444027e+00,
        0.1789715726676655e-02,
        0.7462244872361469e+00,
        0.1797131716770826e-02,
        0.7530182833863068e+00,
        0.1804162382812431e-02,
        0.7594669850655551e+00,
        0.1810855687135456e-02,
        0.7656123962667175e+00,
        0.1817257231900906e-02,
        0.7714944684438817e+00,
        0.1823411068174413e-02,
        0.7771519851570839e+00,
        0.1829360432715894e-02,
        0.7826231962275617e+00,
        0.1835148421173907e-02,
        0.7879464076688663e+00,
        0.1840818599844342e-02,
        0.7931605286026111e+00,
        0.1846415551221751e-02,
        0.7983055707993119e+00,
        0.1851985340937259e-02,
        0.8034230901440029e+00,
        0.1857575885138658e-02,
        0.8085565520117598e+00,
        0.1863237187886467e-02,
        0.8137515941551513e+00,
        0.1869021407926604e-02,
        0.8190561513413812e+00,
        0.1874982703844713e-02,
        0.8245203960095123e+00,
        0.1881176797227895e-02,
        0.8301964394574721e+00,
        0.1887660186864975e-02,
        0.8361377299185951e+00,
        0.1894488945824785e-02,
        0.8423980794999191e+00,
        0.1901717040890795e-02,
        0.8490302543125971e+00,
        0.1909394134299323e-02,
        0.8560840749607826e+00,
        0.4886273679748824e-03,
        0.6714437954649780e-03,
        0.2540979640585205e-01,
        0.8113983041306847e-03,
        0.9866962915608751e-01,
        0.9206047809355559e-03,
        0.1740933291741878e+00,
        0.1007696615844565e-02,
        0.2424648238198073e+00,
        0.1078555077304152e-02,
        0.3024083787838030e+00,
        0.1137220495111209e-02,
        0.3545391775646764e+00,
        0.1186526928471642e-02,
        0.3999097732746233e+00,
        0.1228508433020824e-02,
        0.4395609067610286e+00,
        0.1264657346363223e-02,
        0.4744011819765317e+00,
        0.1296090864949680e-02,
        0.5051903569581037e+00,
        0.1323660708324793e-02,
        0.5325539695623672e+00,
        0.1348026906055910e-02,
        0.5570050719753680e+00,
        0.1369708506508536e-02,
        0.5789651232823036e+00,
        0.1389119124621932e-02,
        0.5987818060211025e+00,
        0.1406592323781286e-02,
        0.6167435227777786e+00,
        0.1422400048200691e-02,
        0.6330909609625438e+00,
        0.1436766218460017e-02,
        0.6480262517065541e+00,
        0.1449876904280157e-02,
        0.6617202166442876e+00,
        0.1461888037961801e-02,
        0.6743181164063009e+00,
        0.1472931335824075e-02,
        0.6859442313853145e+00,
        0.1483118897071317e-02,
        0.6967055330639804e+00,
        0.1492546815085222e-02,
        0.7066946457906411e+00,
        0.1501298043441827e-02,
        0.7159922532405723e+00,
        0.1509444694127518e-02,
        0.7246690686840157e+00,
        0.1517049899494373e-02,
        0.7327874613555573e+00,
        0.1524169336541220e-02,
        0.7404028107621932e+00,
        0.1530852488184009e-02,
        0.7475646451451914e+00,
        0.1537143698611175e-02,
        0.7543176083360913e+00,
        0.1543083066767105e-02,
        0.7607022900146448e+00,
        0.1548707212186899e-02,
        0.7667559471993193e+00,
        0.1554049939909855e-02,
        0.7725131391565733e+00,
        0.1559142825373070e-02,
        0.7780062934020589e+00,
        0.1564015735548671e-02,
        0.7832662167717693e+00,
        0.1568697298775154e-02,
        0.7883225624132202e+00,
        0.1573215332462839e-02,
        0.7932042607791593e+00,
        0.1577597234898074e-02,
        0.7979399201221365e+00,
        0.1581870344542036e-02,
        0.8025581994310868e+00,
        0.1586062267357487e-02,
        0.8070881540792818e+00,
        0.1590201169665478e-02,
        0.8115595515386726e+00,
        0.1594316030726550e-02,
        0.8160031512482756e+00,
        0.1598436845587962e-02,
        0.8204509390209540e+00,
        0.1602594764727253e-02,
        0.8249363021965111e+00,
        0.1606822152724702e-02,
        0.8294941271358440e+00,
        0.1611152543807615e-02,
        0.8341607957498925e+00,
        0.1615620467991531e-02,
        0.8389740528796195e+00,
        0.1620261118280227e-02,
        0.8439727120207893e+00,
        0.1625109827821845e-02,
        0.8491961639288420e+00,
        0.1630201327174513e-02,
        0.8546836521716283e+00,
        0.1635568757273152e-02,
        0.8604732831634605e+00,
        0.1641242424784281e-02,
        0.8666007472872529e+00,
        0.4079721290191449e-03,
        0.5606390646000299e-03,
        0.2541717774246925e-01,
        0.6775302011759068e-03,
        0.9870776119617667e-01,
        0.7687559860220674e-03,
        0.1741771883435951e+00,
        0.8415222726271052e-03,
        0.2426044825025154e+00,
        0.9007379123407699e-03,
        0.3026107489587744e+00,
        0.9497751982407300e-03,
        0.3548090209828054e+00,
        0.9909995793709382e-03,
        0.4002503224647114e+00,
        0.1026108754684635e-02,
        0.4399742629913482e+00,
        0.1056348256439421e-02,
        0.4748885789654610e+00,
        0.1082650488031221e-02,
        0.5057523403210778e+00,
        0.1105726258156915e-02,
        0.5331905211809378e+00,
        0.1126126368448291e-02,
        0.5577156967903346e+00,
        0.1144283937532252e-02,
        0.5797489091761477e+00,
        0.1160544069671673e-02,
        0.5996374632935472e+00,
        0.1175185037186027e-02,
        0.6176694070801912e+00,
        0.1188433661215005e-02,
        0.6340850818085325e+00,
        0.1200476654074482e-02,
        0.6490862674574624e+00,
        0.1211469103358439e-02,
        0.6628434159685319e+00,
        0.1221540901759423e-02,
        0.6755013855037041e+00,
        0.1230801679415364e-02,
        0.6871840056733981e+00,
        0.1239344630375328e-02,
        0.6979977314932807e+00,
        0.1247249512545108e-02,
        0.7080345854591738e+00,
        0.1254585023077141e-02,
        0.7173745414939689e+00,
        0.1261410697040181e-02,
        0.7260874694062653e+00,
        0.1267778438847666e-02,
        0.7342347316708526e+00,
        0.1273733768408534e-02,
        0.7418705038821782e+00,
        0.1279316843997812e-02,
        0.7490428746151535e+00,
        0.1284563309197927e-02,
        0.7557947684726961e+00,
        0.1289505000406732e-02,
        0.7621647269098429e+00,
        0.1294170543282941e-02,
        0.7681875743244604e+00,
        0.1298585860357731e-02,
        0.7738949913863433e+00,
        0.1302774607351322e-02,
        0.7793160132569095e+00,
        0.1306758552112867e-02,
        0.7844774669407445e+00,
        0.1310557907271291e-02,
        0.7894043592864977e+00,
        0.1314191625436819e-02,
        0.7941202249469652e+00,
        0.1317677663971441e-02,
        0.7986474417822638e+00,
        0.1321033224831176e-02,
        0.8030075196380616e+00,
        0.1324274973678666e-02,
        0.8072213670641986e+00,
        0.1327419241294216e-02,
        0.8113095392825265e+00,
        0.1330482209212664e-02,
        0.8152924695008139e+00,
        0.1333480080427699e-02,
        0.8191906844434980e+00,
        0.1336429234887632e-02,
        0.8230250036771799e+00,
        0.1339346368318267e-02,
        0.8268167209024656e+00,
        0.1342248611619848e-02,
        0.8305877638256554e+00,
        0.1345153626679458e-02,
        0.8343608274878259e+00,
        0.1348079672919514e-02,
        0.8381594740079385e+00,
        0.1351045637295423e-02,
        0.8420081896122813e+00,
        0.1354071018825960e-02,
        0.8459323876377299e+00,
        0.1357175857202399e-02,
        0.8499583440311814e+00,
        0.1360380593752449e-02,
        0.8541130499173916e+00,
        0.1363705852281417e-02,
        0.8584239643605064e+00,
        0.1367172127403134e-02,
        0.8629186498951948e+00,
        0.1370799369307807e-02,
        0.8676242742545543e+00,
        0.1374606456942832e-02,
        0.8725669645681554e+00,
        0.1378610556753209e-02,
        0.8777710057814074e+00,
        0.3457584334322357e-03,
        0.4751621453940012e-03,
        0.2542287327621289e-01,
        0.5742529802903852e-03,
        0.9873719754448177e-01,
        0.6515970827455522e-03,
        0.1742419598034706e+00,
        0.7132998513406398e-03,
        0.2427124231693788e+00,
        0.7635205129753468e-03,
        0.3027672771691929e+00,
        0.8051163841037499e-03,
        0.3550179179580828e+00,
        0.8400916805185935e-03,
        0.4005142108161735e+00,
        0.8698848276663640e-03,
        0.4402949133244795e+00,
        0.8955511242402197e-03,
        0.4752671131865228e+00,
        0.9178805496049455e-03,
        0.5061893703422927e+00,
        0.9374753213346000e-03,
        0.5336862457066851e+00,
        0.9548020787478288e-03,
        0.5582699698916923e+00,
        0.9702277440292999e-03,
        0.5803612891309488e+00,
        0.9840446600062942e-03,
        0.6003072470093884e+00,
        0.9964885371329648e-03,
        0.6183956534407280e+00,
        0.1007751484296832e-02,
        0.6348666260010463e+00,
        0.1017991617422186e-02,
        0.6499217274752063e+00,
        0.1027340245776507e-02,
        0.6637311918729225e+00,
        0.1035907317136567e-02,
        0.6764396515818053e+00,
        0.1043785593537480e-02,
        0.6881706952754520e+00,
        0.1051053889330778e-02,
        0.6990305140455065e+00,
        0.1057779608173888e-02,
        0.7091108348943870e+00,
        0.1064020749985821e-02,
        0.7184912951109098e+00,
        0.1069827513031319e-02,
        0.7272413759474827e+00,
        0.1075243583787733e-02,
        0.7354219871919199e+00,
        0.1080307183927825e-02,
        0.7430867737680106e+00,
        0.1085051926828077e-02,
        0.7502831998805611e+00,
        0.1089507523598374e-02,
        0.7570534542643864e+00,
        0.1093700369430917e-02,
        0.7634352109083323e+00,
        0.1097654034185638e-02,
        0.7694622725315966e+00,
        0.1101389675935647e-02,
        0.7751651185850800e+00,
        0.1104926392241615e-02,
        0.7805713752558724e+00,
        0.1108281520887288e-02,
        0.7857062215827314e+00,
        0.1111470899456480e-02,
        0.7905927431287384e+00,
        0.1114509091294428e-02,
        0.7952522425401743e+00,
        0.1117409583946746e-02,
        0.7997045146224264e+00,
        0.1120184965012693e-02,
        0.8039680921873576e+00,
        0.1122847079414237e-02,
        0.8080604677961332e+00,
        0.1125407171312882e-02,
        0.8119982955768120e+00,
        0.1127876013259072e-02,
        0.8157975764884198e+00,
        0.1130264024599364e-02,
        0.8194738296925913e+00,
        0.1132581380665879e-02,
        0.8230422520462021e+00,
        0.1134838113807109e-02,
        0.8265178671142719e+00,
        0.1137044206868379e-02,
        0.8299156644956935e+00,
        0.1139209679276770e-02,
        0.8332507296316362e+00,
        0.1141344665414018e-02,
        0.8365383636069283e+00,
        0.1143459484459602e-02,
        0.8397941917404019e+00,
        0.1145564700346352e-02,
        0.8430342589770379e+00,
        0.1147671169888255e-02,
        0.8462751092344150e+00,
        0.1149790076517388e-02,
        0.8495338449183082e+00,
        0.1151932946415512e-02,
        0.8528281618190179e+00,
        0.1154111643169411e-02,
        0.8561763535592529e+00,
        0.1156338336456831e-02,
        0.8595972787361906e+00,
        0.1158625439740416e-02,
        0.8631102829627566e+00,
        0.1160985511591647e-02,
        0.8667350672783336e+00,
        0.1163431115191409e-02,
        0.8704914940179440e+00,
        0.1165974630888303e-02,
        0.8743993213928760e+00,
        0.1168628017588916e-02,
        0.8784778589727296e+00,
        0.1171402520361833e-02,
        0.8827455382208639e+00,
        0.1174308324102304e-02,
        0.8872193954732928e+00,
        0.2967633115387107e-03,
        0.4078420646640203e-03,
        0.2542735980046100e-01,
        0.4929083178239419e-03,
        0.9876039342539503e-01,
        0.5593126751285800e-03,
        0.1742930216852869e+00,
        0.6122943067439731e-03,
        0.2427975603509948e+00,
        0.6554223612098552e-03,
        0.3028908101007459e+00,
        0.6911487848386306e-03,
        0.3551828911240184e+00,
        0.7211934487136871e-03,
        0.4007227692617545e+00,
        0.7467906965300383e-03,
        0.4405485438561624e+00,
        0.7688460941907184e-03,
        0.4755668043199200e+00,
        0.7880375248105768e-03,
        0.5065357215285611e+00,
        0.8048817439819273e-03,
        0.5340795437694515e+00,
        0.8197791606092136e-03,
        0.5587102435529917e+00,
        0.8330446107364092e-03,
        0.5808483484024387e+00,
        0.8449289291109885e-03,
        0.6008407117558368e+00,
        0.8556343498905160e-03,
        0.6189749738875788e+00,
        0.8653256884173914e-03,
        0.6354910969728228e+00,
        0.8741385860890042e-03,
        0.6505904974988862e+00,
        0.8821856763681789e-03,
        0.6644432678330569e+00,
        0.8895612564439208e-03,
        0.6771938992957999e+00,
        0.8963448693257790e-03,
        0.6889658361211737e+00,
        0.9026040810144197e-03,
        0.6998651175897177e+00,
        0.9083966557751288e-03,
        0.7099833073204581e+00,
        0.9137722762541778e-03,
        0.7193998631153847e+00,
        0.9187739158093501e-03,
        0.7281840656590849e+00,
        0.9234389425261854e-03,
        0.7363965975579181e+00,
        0.9278000143753827e-03,
        0.7440908437477774e+00,
        0.9318858104408874e-03,
        0.7513139686822109e+00,
        0.9357216324926973e-03,
        0.7581078137561323e+00,
        0.9393299032829178e-03,
        0.7645096492310164e+00,
        0.9427305820375386e-03,
        0.7705528078328676e+00,
        0.9459415131589371e-03,
        0.7762672216898303e+00,
        0.9489787207614479e-03,
        0.7816798799835950e+00,
        0.9518566590593747e-03,
        0.7868152213232364e+00,
        0.9545884266143449e-03,
        0.7916954721972490e+00,
        0.9571859508813780e-03,
        0.7963409407568194e+00,
        0.9596601482630737e-03,
        0.8007702735070883e+00,
        0.9620210639090244e-03,
        0.8050006811385999e+00,
        0.9642779947228965e-03,
        0.8090481386453148e+00,
        0.9664395984170945e-03,
        0.8129275639917815e+00,
        0.9685139909496511e-03,
        0.8166529788658923e+00,
        0.9705088342629528e-03,
        0.8202376544499068e+00,
        0.9724314158979084e-03,
        0.8236942446328719e+00,
        0.9742887217632853e-03,
        0.8270349086491756e+00,
        0.9760875030844708e-03,
        0.8302714247416513e+00,
        0.9778343383275471e-03,
        0.8334152960971942e+00,
        0.9795356906837479e-03,
        0.8364778499742661e+00,
        0.9811979614979323e-03,
        0.8394703306225847e+00,
        0.9828275398255846e-03,
        0.8424039862746810e+00,
        0.9844308480999043e-03,
        0.8452901501569875e+00,
        0.9860143836786285e-03,
        0.8481403151159906e+00,
        0.9875847558152446e-03,
        0.8509662010755018e+00,
        0.9891487173585097e-03,
        0.8537798141289355e+00,
        0.9907131902268242e-03,
        0.8565934956229708e+00,
        0.9922852834316175e-03,
        0.8594199591072303e+00,
        0.9938723021413952e-03,
        0.8622723125149068e+00,
        0.9954817459946895e-03,
        0.8651640624148244e+00,
        0.9971212946004986e-03,
        0.8681090966584658e+00,
        0.9987987779301984e-03,
        0.8711216412695179e+00,
        0.1000522129134342e-02,
        0.8742161870354788e+00,
        0.1002299317248640e-02,
        0.8774073810231204e+00,
        0.1004138257331534e-02,
        0.8807098782305657e+00,
        0.1006046695854091e-02,
        0.8841381489021722e+00,
        0.1008032069698879e-02,
        0.8877062377737649e+00,
        0.1010101337974326e-02,
        0.8914274727949142e+00,
        0.1012260787062656e-02,
        0.8953141227940432e+00,
        0.2505764977838404e-03,
        0.3443770249124342e-03,
        0.2543158995016821e-01,
        0.4162174537078318e-03,
        0.9878227034153308e-01,
        0.4723030362070807e-03,
        0.1743411977575627e+00,
        0.5170566942884504e-03,
        0.2428779209209343e+00,
        0.5534915375556028e-03,
        0.3030074710503266e+00,
        0.5836775268839070e-03,
        0.3553387763770640e+00,
        0.6090665945021940e-03,
        0.4009199654813231e+00,
        0.6307007808156645e-03,
        0.4407885275977928e+00,
        0.6493445644344517e-03,
        0.4758505926393938e+00,
        0.6655702083843857e-03,
        0.5068639748553351e+00,
        0.6798139474548506e-03,
        0.5344526379872747e+00,
        0.6924137931820147e-03,
        0.5591283215877272e+00,
        0.7036355137975163e-03,
        0.5813113577588189e+00,
        0.7136908453729490e-03,
        0.6013484321270596e+00,
        0.7227504933228287e-03,
        0.6195270375256310e+00,
        0.7309535721159746e-03,
        0.6360870035914407e+00,
        0.7384145655048229e-03,
        0.6512296248800408e+00,
        0.7452285316469442e-03,
        0.6651248789020748e+00,
        0.7514750465678792e-03,
        0.6779171461479578e+00,
        0.7572212276838003e-03,
        0.6897297612797826e+00,
        0.7625240776755495e-03,
        0.7006686526246470e+00,
        0.7674323201021287e-03,
        0.7108252688389807e+00,
        0.7719878506216157e-03,
        0.7202789460425201e+00,
        0.7762268944500497e-03,
        0.7290988336445309e+00,
        0.7801809371337034e-03,
        0.7373454702759427e+00,
        0.7838774788105678e-03,
        0.7450720807914899e+00,
        0.7873406498722635e-03,
        0.7523256496919639e+00,
        0.7905917169405165e-03,
        0.7591478143617146e+00,
        0.7936495014053848e-03,
        0.7655756123276436e+00,
        0.7965307277851307e-03,
        0.7716421096510724e+00,
        0.7992503154034614e-03,
        0.7773769320588682e+00,
        0.8018216240149106e-03,
        0.7828067161269425e+00,
        0.8042566618112444e-03,
        0.7879554944635353e+00,
        0.8065662625429530e-03,
        0.7928450261873953e+00,
        0.8087602371674192e-03,
        0.7974950818949961e+00,
        0.8108475043988473e-03,
        0.8019236906381128e+00,
        0.8128362037173276e-03,
        0.8061473550943380e+00,
        0.8147337937451987e-03,
        0.8101812400362133e+00,
        0.8165471383802039e-03,
        0.8140393383338362e+00,
        0.8182825826579203e-03,
        0.8177346180177749e+00,
        0.8199460199784433e-03,
        0.8212791533500792e+00,
        0.8215429520572276e-03,
        0.8246842423744935e+00,
        0.8230785427339746e-03,
        0.8279605130215852e+00,
        0.8245576665860399e-03,
        0.8311180195135344e+00,
        0.8259849531356726e-03,
        0.8341663305331678e+00,
        0.8273648273067869e-03,
        0.8371146103813345e+00,
        0.8287015466714560e-03,
        0.8399716941366764e+00,
        0.8299992359243829e-03,
        0.8427461576444749e+00,
        0.8312619189314546e-03,
        0.8454463829899002e+00,
        0.8324935486128937e-03,
        0.8480806199498299e+00,
        0.8336980348396690e-03,
        0.8506570437613245e+00,
        0.8348792704412902e-03,
        0.8531838093892227e+00,
        0.8360411553417403e-03,
        0.8556691023160556e+00,
        0.8371876187562825e-03,
        0.8581211857109087e+00,
        0.8383226392937222e-03,
        0.8605484436569011e+00,
        0.8394502627153142e-03,
        0.8629594199271572e+00,
        0.8405746170023279e-03,
        0.8653628515950123e+00,
        0.8416999242793960e-03,
        0.8677676965453935e+00,
        0.8428305090311761e-03,
        0.8701831537222023e+00,
        0.8439708019376514e-03,
        0.8726186747045624e+00,
        0.8451253385421383e-03,
        0.8750839649592925e+00,
        0.8462987518610647e-03,
        0.8775889728776909e+00,
        0.8474957579532225e-03,
        0.8801438644857288e+00,
        0.8487211333982720e-03,
        0.8827589815370717e+00,
        0.8499796836021254e-03,
        0.8854447805825755e+00,
        0.8512762008654021e-03,
        0.8882117505884698e+00,
        0.8526154112376473e-03,
        0.8910703067843766e+00,
        0.8540019093532560e-03,
        0.8940306587022231e+00,
        0.8554400807241641e-03,
        0.8971026508610441e+00,
        0.8569340113668948e-03,
        0.9002955753026496e+00,
        0.8584873851806726e-03,
        0.9036179562250074e+00,
        0.2143902298924797e-03,
        0.2946512237154931e-03,
        0.2543490463324859e-01,
        0.3561260688438285e-03,
        0.9879941719514369e-01,
        0.4041230092741482e-03,
        0.1743789695511629e+00,
        0.4424256774627034e-03,
        0.2429409502831179e+00,
        0.4736116853150793e-03,
        0.3030990118950347e+00,
        0.4994518169910726e-03,
        0.3554611561972349e+00,
        0.5211881524129952e-03,
        0.4010748630839990e+00,
        0.5397121201514141e-03,
        0.4409771509224894e+00,
        0.5556777014490634e-03,
        0.4760737966263269e+00,
        0.5695744414699151e-03,
        0.5071223419498457e+00,
        0.5817755161210044e-03,
        0.5347465345706520e+00,
        0.5925700732976313e-03,
        0.5594579384248554e+00,
        0.6021854581155787e-03,
        0.5816767395342153e+00,
        0.6108027921070821e-03,
        0.6017494993293330e+00,
        0.6185680956696988e-03,
        0.6199636028202163e+00,
        0.6256003634582641e-03,
        0.6365587841093024e+00,
        0.6319975186065948e-03,
        0.6517362513852718e+00,
        0.6378408654613904e-03,
        0.6656659024902249e+00,
        0.6431984629598351e-03,
        0.6784920429133774e+00,
        0.6481277109801403e-03,
        0.6903379352397969e+00,
        0.6526773552254315e-03,
        0.7013094370793644e+00,
        0.6568890572555564e-03,
        0.7114979262641195e+00,
        0.6607986356285067e-03,
        0.7209826665497649e+00,
        0.6644370556787454e-03,
        0.7298327319935689e+00,
        0.6678312253083076e-03,
        0.7381085813804109e+00,
        0.6710046397087699e-03,
        0.7458633536247841e+00,
        0.6739779074395309e-03,
        0.7531439394662658e+00,
        0.6767691825904827e-03,
        0.7599918728233108e+00,
        0.6793945220531763e-03,
        0.7664440759826728e+00,
        0.6818681826575195e-03,
        0.7725334857075471e+00,
        0.6842028697103579e-03,
        0.7782895818427216e+00,
        0.6864099460208997e-03,
        0.7837388357016260e+00,
        0.6884996086172708e-03,
        0.7889050921541919e+00,
        0.6904810389048264e-03,
        0.7938098966818099e+00,
        0.6923625308852660e-03,
        0.7984727765644702e+00,
        0.6941516011688034e-03,
        0.8029114836923505e+00,
        0.6958550838122305e-03,
        0.8071422051557240e+00,
        0.6974792124607250e-03,
        0.8111797466910577e+00,
        0.6990296918282764e-03,
        0.8150376931919887e+00,
        0.7005117601960532e-03,
        0.8187285497884573e+00,
        0.7019302443210675e-03,
        0.8222638664221132e+00,
        0.7032896079146326e-03,
        0.8256543483749294e+00,
        0.7045939946601219e-03,
        0.8289099548200989e+00,
        0.7058472665836456e-03,
        0.8320399871433695e+00,
        0.7070530384625938e-03,
        0.8350531685159762e+00,
        0.7082147088500877e-03,
        0.8379577159767848e+00,
        0.7093354882038982e-03,
        0.8407614060927453e+00,
        0.7104184245328271e-03,
        0.8434716351063775e+00,
        0.7114664269090819e-03,
        0.8460954743411380e+00,
        0.7124822871394600e-03,
        0.8486397215154378e+00,
        0.7134686998392874e-03,
        0.8511109485098599e+00,
        0.7144282811093860e-03,
        0.8535155460363737e+00,
        0.7153635859765056e-03,
        0.8558597655701624e+00,
        0.7162771247204472e-03,
        0.8581497588214944e+00,
        0.7171713781754927e-03,
        0.8603916149446070e+00,
        0.7180488120588147e-03,
        0.8625913956007934e+00,
        0.7189118903434776e-03,
        0.8647551679119477e+00,
        0.7197630876577540e-03,
        0.8668890352571068e+00,
        0.7206049006551845e-03,
        0.8689991657766132e+00,
        0.7214398582606628e-03,
        0.8710918183552704e+00,
        0.7222705306565306e-03,
        0.8731733657564531e+00,
        0.7230995368291464e-03,
        0.8752503144732032e+00,
        0.7239295504508160e-03,
        0.8773293207500719e+00,
        0.7247633038248635e-03,
        0.8794172021118196e+00,
        0.7256035895739055e-03,
        0.8815209436139331e+00,
        0.7264532597045066e-03,
        0.8836476979083573e+00,
        0.7273152216374242e-03,
        0.8858047781004107e+00,
        0.7281924307543494e-03,
        0.8879996422658111e+00,
        0.7290878789830281e-03,
        0.8902398684083558e+00,
        0.7300045789273423e-03,
        0.8925331185794968e+00,
        0.7309455430526645e-03,
        0.8948870908635684e+00,
        0.7319137574656844e-03,
        0.8973094579716888e+00,
        0.7329121498886438e-03,
        0.8998077913001904e+00,
        0.7339435515274697e-03,
        0.9023894695138696e+00,
        0.7350106526783481e-03,
        0.9050615710285062e+00,
        0.7361159521134971e-03,
        0.9078307502075817e+00,
        0.7372617005379830e-03,
        0.9107030976677650e+00,
        0.1812712131805553e-03,
        0.2491384321187703e-03,
        0.2543793868003920e-01,
        0.3011236389389571e-03,
        0.9881511572468257e-01,
        0.3417143692905089e-03,
        0.1744135601545568e+00,
        0.3741093236630491e-03,
        0.2429986895349530e+00,
        0.4004876411801612e-03,
        0.3031829004247381e+00,
        0.4223463640195241e-03,
        0.3555733525259414e+00,
        0.4407355613198239e-03,
        0.4012169377011952e+00,
        0.4564088559640470e-03,
        0.4411502489205138e+00,
        0.4699191284978094e-03,
        0.4762787454763390e+00,
        0.4816802419109510e-03,
        0.5073597250977332e+00,
        0.4920076781544193e-03,
        0.5350167430251173e+00,
        0.5011458800384139e-03,
        0.5597612077529058e+00,
        0.5092870408844213e-03,
        0.5820131769183957e+00,
        0.5165842754910700e-03,
        0.6021191036853046e+00,
        0.5231610232704372e-03,
        0.6203662799505060e+00,
        0.5291178753295886e-03,
        0.6369943582199482e+00,
        0.5345376082578074e-03,
        0.6522044738696901e+00,
        0.5394889485099423e-03,
        0.6661664586032026e+00,
        0.5440294242631437e-03,
        0.6790245567662842e+00,
        0.5482075518868509e-03,
        0.6909019734144254e+00,
        0.5520645308096385e-03,
        0.7019045110624699e+00,
        0.5556355707323485e-03,
        0.7121234938350971e+00,
        0.5589509407679369e-03,
        0.7216381322017054e+00,
        0.5620368060492128e-03,
        0.7305174464276960e+00,
        0.5649159003089793e-03,
        0.7388218400819079e+00,
        0.5676080707139590e-03,
        0.7466043945017325e+00,
        0.5701307223629278e-03,
        0.7539119395110627e+00,
        0.5724991833517420e-03,
        0.7607859437362659e+00,
        0.5747270064854298e-03,
        0.7672632586796091e+00,
        0.5768262201098143e-03,
        0.7733767436165075e+00,
        0.5788075378120540e-03,
        0.7791557928788411e+00,
        0.5806805346667902e-03,
        0.7846267827935451e+00,
        0.5824537961143980e-03,
        0.7898134521798050e+00,
        0.5841350443286614e-03,
        0.7947372276555162e+00,
        0.5857312459743304e-03,
        0.7994175029023208e+00,
        0.5872487045051270e-03,
        0.8038718793655162e+00,
        0.5886931395613308e-03,
        0.8081163745265718e+00,
        0.5900697555567861e-03,
        0.8121656028098705e+00,
        0.5913833011706530e-03,
        0.8160329333161330e+00,
        0.5926381211586964e-03,
        0.8197306278697833e+00,
        0.5938382016564763e-03,
        0.8232699622928324e+00,
        0.5949872099502598e-03,
        0.8266613333475188e+00,
        0.5960885295313444e-03,
        0.8299143534033866e+00,
        0.5971452911184121e-03,
        0.8330379345654622e+00,
        0.5981604002247400e-03,
        0.8360403637358284e+00,
        0.5991365617580406e-03,
        0.8389293698608987e+00,
        0.6000763020667812e-03,
        0.8417121844328502e+00,
        0.6009819887851800e-03,
        0.8443955961593316e+00,
        0.6018558487773787e-03,
        0.8469860005853584e+00,
        0.6026999844377125e-03,
        0.8494894453408740e+00,
        0.6035163885670166e-03,
        0.8519116715931933e+00,
        0.6043069580133006e-03,
        0.8542581522025076e+00,
        0.6050735062378763e-03,
        0.8565341270083502e+00,
        0.6058177749442889e-03,
        0.8587446356133339e+00,
        0.6065414448864817e-03,
        0.8608945479758220e+00,
        0.6072461459539104e-03,
        0.8629885930739860e+00,
        0.6079334666143073e-03,
        0.8650313858586231e+00,
        0.6086049627790323e-03,
        0.8670274526700236e+00,
        0.6092621661410419e-03,
        0.8689812552540616e+00,
        0.6099065920211252e-03,
        0.8708972134736309e+00,
        0.6105397467438793e-03,
        0.8727797267727406e+00,
        0.6111631345506714e-03,
        0.8746331944112725e+00,
        0.6117782640423093e-03,
        0.8764620344479443e+00,
        0.6123866541291380e-03,
        0.8782707014068333e+00,
        0.6129898394506246e-03,
        0.8800637025184370e+00,
        0.6135893752100950e-03,
        0.8818456123793366e+00,
        0.6141868413530916e-03,
        0.8836210858249036e+00,
        0.6147838459998774e-03,
        0.8853948687571734e+00,
        0.6153820280240385e-03,
        0.8871718066152805e+00,
        0.6159830586501987e-03,
        0.8889568501193103e+00,
        0.6165886419249452e-03,
        0.8907550578610847e+00,
        0.6172005138967517e-03,
        0.8925715952587398e+00,
        0.6178204403237505e-03,
        0.8944117293380552e+00,
        0.6184502127136527e-03,
        0.8962808187550784e+00,
        0.6190916424892084e-03,
        0.8981842984351409e+00,
        0.6197465530668733e-03,
        0.9001276581771762e+00,
        0.6204167696375895e-03,
        0.9021164145644403e+00,
        0.6211041064488501e-03,
        0.9041560755392406e+00,
        0.6218103514087190e-03,
        0.9062520970467020e+00,
        0.6225372478675618e-03,
        0.9084098312380427e+00,
        0.6232864734841831e-03,
        0.9106344658545083e+00,
        0.6240596161519326e-03,
        0.9129309545958600e+00,
        0.6248581470486960e-03,
        0.9153039385179171e+00,
        0.6256833909833134e-03,
        0.9177576588059725e+00,
        0.1520214237712800e-03,
        0.2089413039628107e-03,
        0.2544061844919076e-01,
        0.2525434029450244e-03,
        0.9882898388671699e-01,
        0.2865906408583821e-03,
        0.1744441250170073e+00,
        0.3137652564915279e-03,
        0.2430497235076716e+00,
        0.3358945562695622e-03,
        0.3032570714471141e+00,
        0.3542338804453592e-03,
        0.3556725894600452e+00,
        0.3696637616173895e-03,
        0.4013426546343276e+00,
        0.3828161474542172e-03,
        0.4413034887132714e+00,
        0.3941546527609132e-03,
        0.4764602748670496e+00,
        0.4040263187063507e-03,
        0.5075700996286871e+00,
        0.4126956886076392e-03,
        0.5352563525449359e+00,
        0.4203677355440847e-03,
        0.5600303090493647e+00,
        0.4272036184847955e-03,
        0.5823119175989039e+00,
        0.4333317268557089e-03,
        0.6024475399611718e+00,
        0.4388555655790971e-03,
        0.6207243900791431e+00,
        0.4438594799484181e-03,
        0.6373820527872740e+00,
        0.4484128767232627e-03,
        0.6526216037234880e+00,
        0.4525733807537433e-03,
        0.6666128210012832e+00,
        0.4563892263945745e-03,
        0.6794999001357331e+00,
        0.4599010909485004e-03,
        0.6914060010021446e+00,
        0.4631435158655601e-03,
        0.7024368836752101e+00,
        0.4661460196359733e-03,
        0.7126838318080794e+00,
        0.4689339774940904e-03,
        0.7222260166914516e+00,
        0.4715293228925426e-03,
        0.7311324200920038e+00,
        0.4739511114194688e-03,
        0.7394634071847610e+00,
        0.4762159775818406e-03,
        0.7472720204610868e+00,
        0.4783385074390325e-03,
        0.7546050498913561e+00,
        0.4803315446135938e-03,
        0.7615039226740586e+00,
        0.4822064431621426e-03,
        0.7680054467191980e+00,
        0.4839732777639475e-03,
        0.7741424349221077e+00,
        0.4856410194012131e-03,
        0.7799442317805824e+00,
        0.4872176829669196e-03,
        0.7854371596157800e+00,
        0.4887104519025023e-03,
        0.7906448982918555e+00,
        0.4901257839368306e-03,
        0.7955888096768238e+00,
        0.4914695011954675e-03,
        0.8002882159858926e+00,
        0.4927468673202736e-03,
        0.8047606394754871e+00,
        0.4939626537433801e-03,
        0.8090220096175752e+00,
        0.4951211968659503e-03,
        0.8130868428076891e+00,
        0.4962264475780244e-03,
        0.8169683987907728e+00,
        0.4972820143036731e-03,
        0.8206788172836932e+00,
        0.4982912005523597e-03,
        0.8242292376985011e+00,
        0.4992570377925784e-03,
        0.8276299044001774e+00,
        0.5001823143295755e-03,
        0.8308902595461131e+00,
        0.5010696007591026e-03,
        0.8340190252357240e+00,
        0.5019212724788590e-03,
        0.8370242764345617e+00,
        0.5027395296647642e-03,
        0.8399135059177911e+00,
        0.5035264150574445e-03,
        0.8426936822947919e+00,
        0.5042838298529326e-03,
        0.8453713020233193e+00,
        0.5050135479486603e-03,
        0.8479524361928227e+00,
        0.5057172287598274e-03,
        0.8504427727478738e+00,
        0.5063964287909282e-03,
        0.8528476547306911e+00,
        0.5070526121216016e-03,
        0.8551721150436168e+00,
        0.5076871599442239e-03,
        0.8574209081657413e+00,
        0.5083013792721207e-03,
        0.8595985392007632e+00,
        0.5088965109213798e-03,
        0.8617092905839876e+00,
        0.5094737368555486e-03,
        0.8637572467337869e+00,
        0.5100341869706155e-03,
        0.8657463168957334e+00,
        0.5105789453872895e-03,
        0.8676802563950228e+00,
        0.5111090563084296e-03,
        0.8695626864839279e+00,
        0.5116255294913210e-03,
        0.8713971129451628e+00,
        0.5121293453771310e-03,
        0.8731869435885925e+00,
        0.5126214599131585e-03,
        0.8749355047571672e+00,
        0.5131028090972410e-03,
        0.8766460569378331e+00,
        0.5135743132677963e-03,
        0.8783218095540483e+00,
        0.5140368811573158e-03,
        0.8799659349980495e+00,
        0.5144914137215976e-03,
        0.8815815819428285e+00,
        0.5149388077515203e-03,
        0.8831718879555870e+00,
        0.5153799592686180e-03,
        0.8847399914159621e+00,
        0.5158157667000665e-03,
        0.8862890427233201e+00,
        0.5162471338228604e-03,
        0.8878222147576811e+00,
        0.5166749724609052e-03,
        0.8893427125382002e+00,
        0.5171002049124420e-03,
        0.8908537820014690e+00,
        0.5175237660786470e-03,
        0.8923587177991490e+00,
        0.5179466052574159e-03,
        0.8938608699906167e+00,
        0.5183696875592966e-03,
        0.8953636494814934e+00,
        0.5187939948953462e-03,
        0.8968705320333607e+00,
        0.5192205264794681e-03,
        0.8983850606439769e+00,
        0.5196502987807066e-03,
        0.8999108460714149e+00,
        0.5200843448542496e-03,
        0.9014515652504507e+00,
        0.5205237129738048e-03,
        0.9030109573261521e+00,
        0.5209694644829235e-03,
        0.9045928170091283e+00,
        0.5214226707791797e-03,
        0.9062009849407291e+00,
        0.5218844093433793e-03,
        0.9078393347463627e+00,
        0.5223557587267653e-03,
        0.9095117564530361e+00,
        0.5228377924131475e-03,
        0.9112221359554993e+00,
        0.5233315714807396e-03,
        0.9129743302365174e+00,
        0.5238381360009637e-03,
        0.9147721380834732e+00,
        0.5243584951293212e-03,
        0.9166192660984713e+00,
        0.5248936158673047e-03,
        0.9185192898749830e+00,
        0.5254444105047963e-03,
        0.9204756103131890e+00,
        0.5260117227898333e-03,
        0.9224914051702910e+00,
        0.5265963129170898e-03,
        0.9245695760920818e+00,
        0.1268446182127322e-03,
        0.1743404286829759e-03,
        0.2544292517172434e-01,
        0.2107251564740404e-03,
        0.9884092351738187e-01,
        0.2391381657362996e-03,
        0.1744704449940017e+00,
        0.2618172499590152e-03,
        0.2430936807628649e+00,
        0.2802869400172751e-03,
        0.3033209758285258e+00,
        0.2955945748575447e-03,
        0.3557581181745550e+00,
        0.3084747892467032e-03,
        0.4014510452519073e+00,
        0.3194548214120799e-03,
        0.4414356626653468e+00,
        0.3289214677172303e-03,
        0.4766169192502833e+00,
        0.3371642657758759e-03,
        0.5077517230370061e+00,
        0.3444039242024864e-03,
        0.5354633241883532e+00,
        0.3508114513703712e-03,
        0.5602628868037311e+00,
        0.3565213009364801e-03,
        0.5825702685336475e+00,
        0.3616405864628345e-03,
        0.6027317556351184e+00,
        0.3662556600075083e-03,
        0.6210344981187767e+00,
        0.3704368884625953e-03,
        0.6377180257702407e+00,
        0.3742421752675708e-03,
        0.6529833660710770e+00,
        0.3777195940186037e-03,
        0.6670002543718940e+00,
        0.3809093836500495e-03,
        0.6799128476679434e+00,
        0.3838454780905802e-03,
        0.6918442706570039e+00,
        0.3865566919752524e-03,
        0.7029002508578049e+00,
        0.3890676491299710e-03,
        0.7131720413986303e+00,
        0.3913995164996082e-03,
        0.7227387845799725e+00,
        0.3935705893726759e-03,
        0.7316694342837096e+00,
        0.3955967618362022e-03,
        0.7400243285231667e+00,
        0.3974919078428414e-03,
        0.7478564830001711e+00,
        0.3992681920658595e-03,
        0.7552126609359470e+00,
        0.4009363251645967e-03,
        0.7621342624977909e+00,
        0.4025057747089784e-03,
        0.7686580679613385e+00,
        0.4039849404875170e-03,
        0.7748168616577529e+00,
        0.4053813010180153e-03,
        0.7806399582528606e+00,
        0.4067015366299700e-03,
        0.7861536486134770e+00,
        0.4079516333750262e-03,
        0.7913815791511374e+00,
        0.4091369711617666e-03,
        0.7963450758813084e+00,
        0.4102623988415600e-03,
        0.8010634223351132e+00,
        0.4113322984474455e-03,
        0.8055540987877207e+00,
        0.4123506403741368e-03,
        0.8098329889290022e+00,
        0.4133210309588080e-03,
        0.8139145590258739e+00,
        0.4142467536602034e-03,
        0.8178120137564664e+00,
        0.4151308048232806e-03,
        0.8215374321909360e+00,
        0.4159759248469224e-03,
        0.8251018868189340e+00,
        0.4167846254347061e-03,
        0.8285155480533462e+00,
        0.4175592134966781e-03,
        0.8317877762533697e+00,
        0.4183018121784048e-03,
        0.8349272029911109e+00,
        0.4190143794182329e-03,
        0.8379418030218164e+00,
        0.4196987243715124e-03,
        0.8408389581983645e+00,
        0.4203565219890266e-03,
        0.8436255143875690e+00,
        0.4209893259940189e-03,
        0.8463078322926154e+00,
        0.4215985804664407e-03,
        0.8488918329572650e+00,
        0.4221856302130706e-03,
        0.8513830386190436e+00,
        0.4227517300769591e-03,
        0.8537866094869954e+00,
        0.4232980533183947e-03,
        0.8561073769418921e+00,
        0.4238256991815968e-03,
        0.8583498735907137e+00,
        0.4243356997460570e-03,
        0.8605183605508547e+00,
        0.4248290261484384e-03,
        0.8626168522912827e+00,
        0.4253065942498067e-03,
        0.8646491393164755e+00,
        0.4257692698134273e-03,
        0.8666188089433132e+00,
        0.4262178732501410e-03,
        0.8685292643902939e+00,
        0.4266531839812305e-03,
        0.8703837423717154e+00,
        0.4270759444625287e-03,
        0.8721853293661955e+00,
        0.4274868639081453e-03,
        0.8739369767085355e+00,
        0.4278866217474832e-03,
        0.8756415146360238e+00,
        0.4282758708450621e-03,
        0.8773016654044247e+00,
        0.4286552405089854e-03,
        0.8789200555747797e+00,
        0.4290253393105878e-03,
        0.8804992275594572e+00,
        0.4293867577348235e-03,
        0.8820416505043871e+00,
        0.4297400706782409e-03,
        0.8835497305738722e+00,
        0.4300858398088763e-03,
        0.8850258206945885e+00,
        0.4304246158000579e-03,
        0.8864722298061936e+00,
        0.4307569404478835e-03,
        0.8878912316572020e+00,
        0.4310833486799939e-03,
        0.8892850731763069e+00,
        0.4314043704611773e-03,
        0.8906559824410115e+00,
        0.4317205325992682e-03,
        0.8920061762571498e+00,
        0.4320323604527339e-03,
        0.8933378673545269e+00,
        0.4323403795392380e-03,
        0.8946532711953979e+00,
        0.4326451170423202e-03,
        0.8959546123837375e+00,
        0.4329471032111149e-03,
        0.8972441306541727e+00,
        0.4332468726457380e-03,
        0.8985240864099954e+00,
        0.4335449654585917e-03,
        0.8997967657697997e+00,
        0.4338419282993692e-03,
        0.9010644850719940e+00,
        0.4341383152289965e-03,
        0.9023295947757297e+00,
        0.4344346884251275e-03,
        0.9035944826856999e+00,
        0.4347316186991527e-03,
        0.9048615764168997e+00,
        0.4350296858020064e-03,
        0.9061333450039083e+00,
        0.4353294784934289e-03,
        0.9074122995477561e+00,
        0.4356315943468108e-03,
        0.9087009927822184e+00,
        0.4359366392594052e-03,
        0.9100020174307473e+00,
        0.4362452266356344e-03,
        0.9113180032156295e+00,
        0.4365579762095740e-03,
        0.9126516123728104e+00,
        0.4368755124715989e-03,
        0.9140055335197583e+00,
        0.4371984626638003e-03,
        0.9153824737204230e+00,
        0.4375274543093129e-03,
        0.9167851485915539e+00,
        0.4378631122423307e-03,
        0.9182162702992493e+00,
        0.4382060551085620e-03,
        0.9196785333045526e+00,
        0.4385568913104083e-03,
        0.9211745977331760e+00,
        0.4389162143774648e-03,
        0.9227070702680383e+00,
        0.4392845977512571e-03,
        0.9242784824952105e+00,
        0.4396625889836182e-03,
        0.9258912666749617e+00,
        0.4400507033609156e-03,
        0.9275477289606028e+00,
        0.4404494169815118e-03,
        0.9292500201491721e+00,
        0.4408591593313590e-03,
        0.9310001041198086e+00,
        0.1055644989267907e-03,
        0.1450940149574984e-03,
        0.2544487491553157e-01,
        0.1753772719352769e-03,
        0.9885101688865597e-01,
        0.1990267012200822e-03,
        0.1744926990200333e+00,
        0.2179045108524649e-03,
        0.2431308553318966e+00,
        0.2332793641731550e-03,
        0.3033750329426410e+00,
        0.2460228232089687e-03,
        0.3558304876736915e+00,
        0.2567462279756849e-03,
        0.4015427879008645e+00,
        0.2658883294937232e-03,
        0.4415475744961243e+00,
        0.2737710071803561e-03,
        0.4767496006654743e+00,
        0.2806352044648509e-03,
        0.5079056259634127e+00,
        0.2866645871705139e-03,
        0.5356387851068741e+00,
        0.2920014619138971e-03,
        0.5604601504270702e+00,
        0.2967577154420555e-03,
        0.5827895051312843e+00,
        0.3010224827883186e-03,
        0.6029730739429139e+00,
        0.3048676217987417e-03,
        0.6212979551152507e+00,
        0.3083516878734000e-03,
        0.6380036341864078e+00,
        0.3115228646427098e-03,
        0.6532911002313850e+00,
        0.3144211555866268e-03,
        0.6673300547852067e+00,
        0.3170800443702226e-03,
        0.6802646246666912e+00,
        0.3195277677802438e-03,
        0.6922179072993687e+00,
        0.3217883024392515e-03,
        0.7032956052494281e+00,
        0.3238821374603807e-03,
        0.7135889485487379e+00,
        0.3258268851960003e-03,
        0.7231770578766950e+00,
        0.3276377682377606e-03,
        0.7321288666512480e+00,
        0.3293280109066263e-03,
        0.7405046933069390e+00,
        0.3309091563550510e-03,
        0.7483575346135667e+00,
        0.3323913252386479e-03,
        0.7557341352926834e+00,
        0.3337834281257755e-03,
        0.7626758772463315e+00,
        0.3350933410056701e-03,
        0.7692195225318236e+00,
        0.3363280511552274e-03,
        0.7753978371270195e+00,
        0.3374937790390407e-03,
        0.7812401170290845e+00,
        0.3385960807104609e-03,
        0.7867726339385476e+00,
        0.3396399342555158e-03,
        0.7920190144159111e+00,
        0.3406298131057851e-03,
        0.7970005637462622e+00,
        0.3415697484891286e-03,
        0.8017365436465392e+00,
        0.3424633828504657e-03,
        0.8062444112774049e+00,
        0.3433140157303645e-03,
        0.8105400256832551e+00,
        0.3441246433158771e-03,
        0.8146378267077895e+00,
        0.3448979926599179e-03,
        0.8185509905633486e+00,
        0.3456365513904324e-03,
        0.8222915655269199e+00,
        0.3463425935893944e-03,
        0.8258705906609294e+00,
        0.3470182024071915e-03,
        0.8292981999865211e+00,
        0.3476652898847084e-03,
        0.8325837141504723e+00,
        0.3482856143791181e-03,
        0.8357357213079810e+00,
        0.3488807959266790e-03,
        0.8387621486794669e+00,
        0.3494523298240878e-03,
        0.8416703260200142e+00,
        0.3500015986670602e-03,
        0.8444670420569842e+00,
        0.3505298830491450e-03,
        0.8471585947980716e+00,
        0.3510383710940082e-03,
        0.8497508364833812e+00,
        0.3515281669694799e-03,
        0.8522492138466825e+00,
        0.3520002985106894e-03,
        0.8546588042593751e+00,
        0.3524557240619330e-03,
        0.8569843482530394e+00,
        0.3528953386319557e-03,
        0.8592302788504310e+00,
        0.3533199794446321e-03,
        0.8614007480784993e+00,
        0.3537304309562248e-03,
        0.8634996509889043e+00,
        0.3541274294011706e-03,
        0.8655306474702691e+00,
        0.3545116669204490e-03,
        0.8674971821009717e+00,
        0.3548837953198046e-03,
        0.8694025022607404e+00,
        0.3552444294992589e-03,
        0.8712496746929433e+00,
        0.3555941505903093e-03,
        0.8730416006866108e+00,
        0.3559335088328495e-03,
        0.8747810300273897e+00,
        0.3562630262200606e-03,
        0.8764705738493466e+00,
        0.3565831989362264e-03,
        0.8781127165044531e+00,
        0.3568944996095447e-03,
        0.8797098265533606e+00,
        0.3571973793994888e-03,
        0.8812641669694672e+00,
        0.3574922699360495e-03,
        0.8827779046380256e+00,
        0.3577795851262342e-03,
        0.8842531192229806e+00,
        0.3580597228414603e-03,
        0.8856918114661521e+00,
        0.3583330664979325e-03,
        0.8870959109761732e+00,
        0.3585999865407079e-03,
        0.8884672835581080e+00,
        0.3588608418408972e-03,
        0.8898077381288096e+00,
        0.3591159810143158e-03,
        0.8911190332577230e+00,
        0.3593657436688535e-03,
        0.8924028833679230e+00,
        0.3596104615868662e-03,
        0.8936609646275998e+00,
        0.3598504598479910e-03,
        0.8948949205579224e+00,
        0.3600860578969333e-03,
        0.8961063673791346e+00,
        0.3603175705599569e-03,
        0.8972968991128310e+00,
        0.3605453090130204e-03,
        0.8984680924545586e+00,
        0.3607695817037281e-03,
        0.8996215114271492e+00,
        0.3609906952284962e-03,
        0.9007587118214661e+00,
        0.3612089551655714e-03,
        0.9018812454275019e+00,
        0.3614246668637566e-03,
        0.9029906640549621e+00,
        0.3616381361859153e-03,
        0.9040885233385761e+00,
        0.3618496702055102e-03,
        0.9051763863193673e+00,
        0.3620595778536006e-03,
        0.9062558267889668e+00,
        0.3622681705128622e-03,
        0.9073284323797515e+00,
        0.3624757625543019e-03,
        0.9083958073791226e+00,
        0.3626826718114261e-03,
        0.9094595752416100e+00,
        0.3628892199856792e-03,
        0.9105213807677069e+00,
        0.3630957329760065e-03,
        0.9115828919134202e+00,
        0.3633025411244249e-03,
        0.9126458011895109e+00,
        0.3635099793685103e-03,
        0.9137118266043415e+00,
        0.3637183872907533e-03,
        0.9147827120992093e+00,
        0.3639281090538103e-03,
        0.9158602274201335e+00,
        0.3641394932098118e-03,
        0.9169461673653735e+00,
        0.3643528923711136e-03,
        0.9180423503436506e+00,
        0.3645686627292243e-03,
        0.9191506161742795e+00,
        0.3647871634081525e-03,
        0.9202728230574016e+00,
        0.3650087556381453e-03,
        0.9214108436404823e+00,
        0.3652338017357785e-03,
        0.9225665601064491e+00,
        0.3654626638766759e-03,
        0.9237418582096152e+00,
        0.3656957026478399e-03,
        0.9249386201881679e+00,
        0.3659332753677379e-03,
        0.9261587164868569e+00,
        0.3661757341639742e-03,
        0.9274039962309573e+00,
        0.3664234238006590e-03,
        0.9286762764029628e+00,
        0.3666766792505202e-03,
        0.9299773296871511e+00,
        0.3669358230104597e-03,
        0.9313088709644671e+00,
        0.3672011621636608e-03,
        0.9326725424613703e+00,
        0.3674729851965463e-03,
        0.9340698975815723e+00,
        0.3677515585848630e-03,
        0.9355023834790327e+00,
        0.3680371231699034e-03,
        0.9369713224641266e+00,
        0.8780076664716276e-04,
        0.1206797894237555e-03,
        0.2544650247967021e-01,
        0.1458689907141319e-03,
        0.9885944344034912e-01,
        0.1655410204684315e-03,
        0.1745112808102761e+00,
        0.1812446142239127e-03,
        0.2431619011038030e+00,
        0.1940348805295792e-03,
        0.3034201872483507e+00,
        0.2046366722127249e-03,
        0.3558909526523158e+00,
        0.2135584233839305e-03,
        0.4016194593852736e+00,
        0.2211650307991108e-03,
        0.4416411290854953e+00,
        0.2277241922738999e-03,
        0.4768605533838495e+00,
        0.2334362932843276e-03,
        0.5080343695969284e+00,
        0.2384540829843639e-03,
        0.5357856177524436e+00,
        0.2428959131113313e-03,
        0.5606252952358727e+00,
        0.2468548359474569e-03,
        0.5829731247513873e+00,
        0.2504049817295676e-03,
        0.6031752812789858e+00,
        0.2536061116756343e-03,
        0.6215188214764482e+00,
        0.2565069236788439e-03,
        0.6382431955471400e+00,
        0.2591474896792285e-03,
        0.6535493621049741e+00,
        0.2615610783797454e-03,
        0.6676069960615446e+00,
        0.2637755361065909e-03,
        0.6805602006643017e+00,
        0.2658143454788651e-03,
        0.6925320522129640e+00,
        0.2676974460335837e-03,
        0.7036282341255100e+00,
        0.2694418768222108e-03,
        0.7139399588872692e+00,
        0.2710622843532818e-03,
        0.7235463309319510e+00,
        0.2725713276157303e-03,
        0.7325162684867130e+00,
        0.2739800036682437e-03,
        0.7409100756455830e+00,
        0.2752979113613955e-03,
        0.7487807355146596e+00,
        0.2765334664638627e-03,
        0.7561749796785543e+00,
        0.2776940783128682e-03,
        0.7631341772964979e+00,
        0.2787862957738123e-03,
        0.7696950779572316e+00,
        0.2798159285470986e-03,
        0.7758904353334187e+00,
        0.2807881485415345e-03,
        0.7817495331755640e+00,
        0.2817075750299807e-03,
        0.7872986308948055e+00,
        0.2825783465328497e-03,
        0.7925613426197803e+00,
        0.2834041817797840e-03,
        0.7975589609612814e+00,
        0.2841884316364275e-03,
        0.8023107346178518e+00,
        0.2849341235200138e-03,
        0.8068341072829448e+00,
        0.2856439995410211e-03,
        0.8111449239759836e+00,
        0.2863205493808272e-03,
        0.8152576098436540e+00,
        0.2869660387338721e-03,
        0.8191853256086143e+00,
        0.2875825339972447e-03,
        0.8229401031375546e+00,
        0.2881719237731651e-03,
        0.8265329640257898e+00,
        0.2887359376546216e-03,
        0.8299740236251799e+00,
        0.2892761626868619e-03,
        0.8332725825556256e+00,
        0.2897940578339750e-03,
        0.8364372074214862e+00,
        0.2902909667276428e-03,
        0.8394758021901656e+00,
        0.2907681289320944e-03,
        0.8423956714705967e+00,
        0.2912266899236334e-03,
        0.8452035767462418e+00,
        0.2916677099534407e-03,
        0.8479057864639630e+00,
        0.2920921719375913e-03,
        0.8505081207514051e+00,
        0.2925009884974771e-03,
        0.8530159914271018e+00,
        0.2928950082563857e-03,
        0.8554344378758767e+00,
        0.2932750214832763e-03,
        0.8577681592844462e+00,
        0.2936417651623478e-03,
        0.8600215436661002e+00,
        0.2939959275564363e-03,
        0.8621986940470617e+00,
        0.2943381523232877e-03,
        0.8643034521390155e+00,
        0.2946690422360806e-03,
        0.8663394197810720e+00,
        0.2949891625530086e-03,
        0.8683099783990099e+00,
        0.2952990440750963e-03,
        0.8702183066991327e+00,
        0.2955991859265754e-03,
        0.8720673967877357e+00,
        0.2958900580879658e-03,
        0.8738600688843806e+00,
        0.2961721037083923e-03,
        0.8755989847774060e+00,
        0.2964457412205325e-03,
        0.8772866601529093e+00,
        0.2967113662788715e-03,
        0.8789254759134587e+00,
        0.2969693535395673e-03,
        0.8805176885897160e+00,
        0.2972200582981628e-03,
        0.8820654399367039e+00,
        0.2974638179995708e-03,
        0.8835707657964145e+00,
        0.2977009536331723e-03,
        0.8850356042996281e+00,
        0.2979317710244726e-03,
        0.8864618034720409e+00,
        0.2981565620335326e-03,
        0.8878511283029286e+00,
        0.2983756056693069e-03,
        0.8892052673284969e+00,
        0.2985891691280583e-03,
        0.8905258387766696e+00,
        0.2987975087631656e-03,
        0.8918143963152597e+00,
        0.2990008709928799e-03,
        0.8930724344411763e+00,
        0.2991994931519033e-03,
        0.8943013935444719e+00,
        0.2993936042920544e-03,
        0.8955026646775683e+00,
        0.2995834259367309e-03,
        0.8966775940568730e+00,
        0.2997691727933844e-03,
        0.8978274873211489e+00,
        0.2999510534277608e-03,
        0.8989536135684026e+00,
        0.3001292709032479e-03,
        0.9000572091906636e+00,
        0.3003040233882832e-03,
        0.9011394815238150e+00,
        0.3004755047344127e-03,
        0.9022016123275653e+00,
        0.3006439050272616e-03,
        0.9032447611087047e+00,
        0.3008094111123485e-03,
        0.9042700682989381e+00,
        0.3009722070973778e-03,
        0.9052786582968102e+00,
        0.3011324748323426e-03,
        0.9062716423815145e+00,
        0.3012903943684867e-03,
        0.9072501215046918e+00,
        0.3014461443968870e-03,
        0.9082151889646557e+00,
        0.3015999026671373e-03,
        0.9091679329658161e+00,
        0.3017518463863298e-03,
        0.9101094390643967e+00,
        0.3019021525982453e-03,
        0.9110407924998413e+00,
        0.3020509985423700e-03,
        0.9119630804095697e+00,
        0.3021985619920632e-03,
        0.9128773939229608e+00,
        0.3023450215708908e-03,
        0.9137848301286094e+00,
        0.3024905570458278e-03,
        0.9146864939070101e+00,
        0.3026353495957124e-03,
        0.9155834996188661e+00,
        0.3027795820529983e-03,
        0.9164769726372038e+00,
        0.3029234391165164e-03,
        0.9173680507093950e+00,
        0.3030671075326073e-03,
        0.9182578851330556e+00,
        0.3032107762416357e-03,
        0.9191476417276118e+00,
        0.3033546364865421e-03,
        0.9200385015811228e+00,
        0.3034988818797365e-03,
        0.9209316615497335e+00,
        0.3036437084242899e-03,
        0.9218283344849421e+00,
        0.3037893144850508e-03,
        0.9227297491617354e+00,
        0.3039359007049947e-03,
        0.9236371498786060e+00,
        0.3040836698618365e-03,
        0.9245517956985898e+00,
        0.3042328266596891e-03,
        0.9254749592987897e+00,
        0.3043835774503590e-03,
        0.9264079253944743e+00,
        0.3045361298787459e-03,
        0.9273519887028263e+00,
        0.3046906924467665e-03,
        0.9283084514108677e+00,
        0.3048474739902782e-03,
        0.9292786201121033e+00,
        0.3050066830636484e-03,
        0.9302638021771222e+00,
        0.3051685272269233e-03,
        0.9312653015248920e+00,
        0.3053332122310158e-03,
        0.9322844137639074e+00,
        0.3055009410969733e-03,
        0.9333224206758433e+00,
        0.3056719130862303e-03,
        0.9343805840190375e+00,
        0.3058463225598092e-03,
        0.9354601386351341e+00,
        0.3060243577257252e-03,
        0.9365622848496463e+00,
        0.3062061992753964e-03,
        0.9376881801661726e+00,
        0.3063920189116574e-03,
        0.9388389302645763e+00,
        0.3065819777730374e-03,
        0.9400155793256640e+00,
        0.3067762247612739e-03,
        0.9412190997187711e+00,
        0.3069748947815949e-03,
        0.9424503811041136e+00,
        0.7309194121921337e-04,
        0.1004637913909749e-03,
        0.2544785012683798e-01,
        0.1214344266344417e-03,
        0.9886642145889684e-01,
        0.1378124012607418e-03,
        0.1745266702959460e+00,
        0.1508869219533374e-03,
        0.2431876171096405e+00,
        0.1615362906618204e-03,
        0.3034575961449956e+00,
        0.1703638961634086e-03,
        0.3559410557392941e+00,
        0.1777929742443069e-03,
        0.4016830055695095e+00,
        0.1841272759437895e-03,
        0.4417186869611078e+00,
        0.1895896409160979e-03,
        0.4769525589580654e+00,
        0.1943468759030283e-03,
        0.5081411588464865e+00,
        0.1985261336437941e-03,
        0.5359074494195392e+00,
        0.2022259333499051e-03,
        0.5607623671619424e+00,
        0.2055237341359384e-03,
        0.5831255858225246e+00,
        0.2084812437801258e-03,
        0.6033432403229687e+00,
        0.2111482088116174e-03,
        0.6217023539986306e+00,
        0.2135651662786688e-03,
        0.6384423489057279e+00,
        0.2157654726972967e-03,
        0.6537641595402491e+00,
        0.2177768213406241e-03,
        0.6678374398703551e+00,
        0.2196223917129092e-03,
        0.6808062747278515e+00,
        0.2213217308213229e-03,
        0.6927937240286020e+00,
        0.2228914362913128e-03,
        0.7039054564531154e+00,
        0.2243456912849616e-03,
        0.7142326710923299e+00,
        0.2256966873287446e-03,
        0.7238544600868844e+00,
        0.2269549614676161e-03,
        0.7328397302769779e+00,
        0.2281296672953758e-03,
        0.7412487751160227e+00,
        0.2292287944844476e-03,
        0.7491345676832047e+00,
        0.2302593478625398e-03,
        0.7565438300381136e+00,
        0.2312274944605136e-03,
        0.7635179222210341e+00,
        0.2321386850119108e-03,
        0.7700935850242779e+00,
        0.2329977549303630e-03,
        0.7763035635723555e+00,
        0.2338090086934327e-03,
        0.7821771332486441e+00,
        0.2345762907259228e-03,
        0.7877405452160454e+00,
        0.2353030452346481e-03,
        0.7930174054153139e+00,
        0.2359923669511411e-03,
        0.7980289982735111e+00,
        0.2366470443530013e-03,
        0.8027945642546851e+00,
        0.2372695966322588e-03,
        0.8073315387125080e+00,
        0.2378623054406560e-03,
        0.8116557581664309e+00,
        0.2384272422525216e-03,
        0.8157816390470166e+00,
        0.2389662920348844e-03,
        0.8197223330870221e+00,
        0.2394811737932779e-03,
        0.8234898628296190e+00,
        0.2399734584639214e-03,
        0.8270952401504242e+00,
        0.2404445845437014e-03,
        0.8305485702196599e+00,
        0.2408958717848132e-03,
        0.8338591429442381e+00,
        0.2413285332280931e-03,
        0.8370355136106796e+00,
        0.2417436858056495e-03,
        0.8400855741856878e+00,
        0.2421423597075709e-03,
        0.8430166165116897e+00,
        0.2425255066777939e-03,
        0.8458353884515460e+00,
        0.2428940073795231e-03,
        0.8485481438833696e+00,
        0.2432486779499734e-03,
        0.8511606873176778e+00,
        0.2435902758469355e-03,
        0.8536784138006696e+00,
        0.2439195050751448e-03,
        0.8561063446757747e+00,
        0.2442370208681859e-03,
        0.8584491596979498e+00,
        0.2445434338913074e-03,
        0.8607112259291628e+00,
        0.2448393140217253e-03,
        0.8628966237872216e+00,
        0.2451251937555122e-03,
        0.8650091705719897e+00,
        0.2454015712837818e-03,
        0.8670524417517986e+00,
        0.2456689132754098e-03,
        0.8690297902574413e+00,
        0.2459276573988435e-03,
        0.8709443640006192e+00,
        0.2461782146115141e-03,
        0.8727991218073733e+00,
        0.2464209712418874e-03,
        0.8745968479342314e+00,
        0.2466562908861773e-03,
        0.8763401653150385e+00,
        0.2468845161391411e-03,
        0.8780315476692500e+00,
        0.2471059701761088e-03,
        0.8796733305874988e+00,
        0.2473209582014312e-03,
        0.8812677216971869e+00,
        0.2475297687768076e-03,
        0.8828168099994235e+00,
        0.2477326750414573e-03,
        0.8843225744586169e+00,
        0.2479299358347776e-03,
        0.8857868919172412e+00,
        0.2481217967309792e-03,
        0.8872115444005592e+00,
        0.2483084909941748e-03,
        0.8885982258692703e+00,
        0.2484902404615005e-03,
        0.8899485484720331e+00,
        0.2486672563610595e-03,
        0.8912640483444853e+00,
        0.2488397400707827e-03,
        0.8925461909966710e+00,
        0.2490078838236775e-03,
        0.8937963763265875e+00,
        0.2491718713643894e-03,
        0.8950159432938443e+00,
        0.2493318785615123e-03,
        0.8962061742840980e+00,
        0.2494880739796445e-03,
        0.8973682991919632e+00,
        0.2496406194148037e-03,
        0.8985034992474405e+00,
        0.2497896703964584e-03,
        0.8996129106085194e+00,
        0.2499353766591264e-03,
        0.9006976277404708e+00,
        0.2500778825862051e-03,
        0.9017587066004092e+00,
        0.2502173276284460e-03,
        0.9027971676439548e+00,
        0.2503538466992535e-03,
        0.9038139986692414e+00,
        0.2504875705487804e-03,
        0.9048101575120641e+00,
        0.2506186261185988e-03,
        0.9057865746046461e+00,
        0.2507471368785526e-03,
        0.9067441554092800e+00,
        0.2508732231472320e-03,
        0.9076837827369850e+00,
        0.2509970023973650e-03,
        0.9086063189602724e+00,
        0.2511185895472782e-03,
        0.9095126081281425e+00,
        0.2512380972394480e-03,
        0.9104034779905169e+00,
        0.2513556361070412e-03,
        0.9112797419384428e+00,
        0.2514713150292236e-03,
        0.9121422008655769e+00,
        0.2515852413759041e-03,
        0.9129916449556555e+00,
        0.2516975212424692e-03,
        0.9138288553998849e+00,
        0.2518082596749575e-03,
        0.9146546060474243e+00,
        0.2519175608860183e-03,
        0.9154696649913860e+00,
        0.2520255284618921e-03,
        0.9162747960920304e+00,
        0.2521322655605479e-03,
        0.9170707604380880e+00,
        0.2522378751010061e-03,
        0.9178583177463857e+00,
        0.2523424599437699e-03,
        0.9186382276991902e+00,
        0.2524461230621790e-03,
        0.9194112512179023e+00,
        0.2525489677043914e-03,
        0.9201781516709387e+00,
        0.2526510975455835e-03,
        0.9209396960128159e+00,
        0.2527526168298444e-03,
        0.9216966558506134e+00,
        0.2528536305011233e-03,
        0.9224498084331230e+00,
        0.2529542443224635e-03,
        0.9231999375571040e+00,
        0.2530545649826379e-03,
        0.9239478343841470e+00,
        0.2531547001891691e-03,
        0.9246942981607159e+00,
        0.2532547587465925e-03,
        0.9254401368329844e+00,
        0.2533548506186903e-03,
        0.9261861675471153e+00,
        0.2534550869732947e-03,
        0.9269332170246625e+00,
        0.2535555802081323e-03,
        0.9276821218018076e+00,
        0.2536564439560544e-03,
        0.9284337283201880e+00,
        0.2537577930678808e-03,
        0.9291888928561548e+00,
        0.2538597435709706e-03,
        0.9299484812744167e+00,
        0.2539624126015323e-03,
        0.9307133685912200e+00,
        0.2540659183085976e-03,
        0.9314844383314877e+00,
        0.2541703797275094e-03,
        0.9322625816637383e+00,
        0.2542759166207297e-03,
        0.9330486962961403e+00,
        0.2543826492837433e-03,
        0.9338436851167795e+00,
        0.2544906983138460e-03,
        0.9346484545611477e+00,
        0.2546001843396463e-03,
        0.9354639126900528e+00,
        0.2547112277091971e-03,
        0.9362909669616406e+00,
        0.2548239481348102e-03,
        0.9371305216820521e+00,
        0.2549384642927942e-03,
        0.9379834751204702e+00,
        0.2550548933766077e-03,
        0.9388507162759753e+00,
        0.2551733506022396e-03,
        0.9397331212857866e+00,
        0.2552939486650164e-03,
        0.9406315494671578e+00,
        0.2554167971475084e-03,
        0.9415468389884580e+00,
        0.2555420018787558e-03,
        0.9424798021688484e+00,
        0.2556696642456735e-03,
        0.9434312204104797e+00,
        0.2557998804582168e-03,
        0.9444018387723074e+00,
        0.2559327407706962e-03,
        0.9453923602004483e+00,
        0.2560683286625224e-03,
        0.9464034394364762e+00,
        0.2562067199826295e-03,
        0.9474356766321346e+00,
        0.6097078489116776e-04,
        0.8380405076108355e-04,
        0.2544896065932850e-01,
        0.1012978969826672e-03,
        0.9887217219781226e-01,
        0.1149608733516808e-03,
        0.1745393544210289e+00,
        0.1258683390053939e-03,
        0.2432088150280462e+00,
        0.1347529092969161e-03,
        0.3034884369920806e+00,
        0.1421178877684437e-03,
        0.3559823686685004e+00,
        0.1483163075228666e-03,
        0.4017354125928528e+00,
        0.1536015360676195e-03,
        0.4417826623358451e+00,
        0.1581594503691672e-03,
        0.4770284685054013e+00,
        0.1621291886747866e-03,
        0.5082292867703224e+00,
        0.1656168126296357e-03,
        0.5360080170824175e+00,
        0.1687044997776278e-03,
        0.5608755465361002e+00,
        0.1714568607858636e-03,
        0.5832515093250096e+00,
        0.1739253676423436e-03,
        0.6034820081391302e+00,
        0.1761515150836057e-03,
        0.6218540396252812e+00,
        0.1781691159294222e-03,
        0.6386070034090316e+00,
        0.1800059934918693e-03,
        0.6539418148701861e+00,
        0.1816852471937282e-03,
        0.6680281114720945e+00,
        0.1832262113807821e-03,
        0.6810099636217561e+00,
        0.1846451904182646e-03,
        0.6930104184833876e+00,
        0.1859560284988198e-03,
        0.7041351333436702e+00,
        0.1871705558346453e-03,
        0.7144752970102477e+00,
        0.1882989413512779e-03,
        0.7241099922548785e+00,
        0.1893499739181992e-03,
        0.7331081173060140e+00,
        0.1903312884234792e-03,
        0.7415299576349032e+00,
        0.1912495488900670e-03,
        0.7494284788635305e+00,
        0.1921105978487627e-03,
        0.7568503960324043e+00,
        0.1929195789948627e-03,
        0.7638370625278608e+00,
        0.1936810385340217e-03,
        0.7704252127912312e+00,
        0.1943990094098548e-03,
        0.7766475858453091e+00,
        0.1950770816902051e-03,
        0.7825334511739168e+00,
        0.1957184616920660e-03,
        0.7881090542005848e+00,
        0.1963260218904405e-03,
        0.7933979952488399e+00,
        0.1969023432430833e-03,
        0.7984215532155936e+00,
        0.1974497512412977e-03,
        0.8031989630889407e+00,
        0.1979703467447663e-03,
        0.8077476547694436e+00,
        0.1984660324594830e-03,
        0.8120834593159135e+00,
        0.1989385357600094e-03,
        0.8162207876608769e+00,
        0.1993894284313026e-03,
        0.8201727859718991e+00,
        0.1998201438042677e-03,
        0.8239514711297960e+00,
        0.2002319916776369e-03,
        0.8275678492200949e+00,
        0.2006261713526632e-03,
        0.8310320194637810e+00,
        0.2010037830532616e-03,
        0.8343532656268659e+00,
        0.2013658379601603e-03,
        0.8375401366294502e+00,
        0.2017132670514090e-03,
        0.8406005178108765e+00,
        0.2020469289116992e-03,
        0.8435416940880705e+00,
        0.2023676166481832e-03,
        0.8463704060610680e+00,
        0.2026760640298827e-03,
        0.8490928999664670e+00,
        0.2029729509505747e-03,
        0.8517149722508350e+00,
        0.2032589083006388e-03,
        0.8542420094276686e+00,
        0.2035345223212339e-03,
        0.8566790237898599e+00,
        0.2038003385039595e-03,
        0.8590306854719521e+00,
        0.2040568650905127e-03,
        0.8613013512904316e+00,
        0.2043045762195164e-03,
        0.8634950907340174e+00,
        0.2045439147614532e-03,
        0.8656157094277920e+00,
        0.2047752948773090e-03,
        0.8676667703537839e+00,
        0.2049991043319707e-03,
        0.8696516130751836e+00,
        0.2052157065895086e-03,
        0.8715733711808579e+00,
        0.2054254427141078e-03,
        0.8734349881404843e+00,
        0.2056286330975070e-03,
        0.8752392317378276e+00,
        0.2058255790312958e-03,
        0.8769887072299080e+00,
        0.2060165641402434e-03,
        0.8786858693626248e+00,
        0.2062018556909442e-03,
        0.8803330333584298e+00,
        0.2063817057884218e-03,
        0.8819323849785773e+00,
        0.2065563524718971e-03,
        0.8834859897510554e+00,
        0.2067260207196752e-03,
        0.8849958014452854e+00,
        0.2068909233720063e-03,
        0.8864636698658907e+00,
        0.2070512619798147e-03,
        0.8878913480301039e+00,
        0.2072072275863421e-03,
        0.8892804987865693e+00,
        0.2073590014480071e-03,
        0.8906327009272852e+00,
        0.2075067557001234e-03,
        0.8919494548391176e+00,
        0.2076506539725411e-03,
        0.8932321877366053e+00,
        0.2077908519597573e-03,
        0.8944822585136047e+00,
        0.2079274979495885e-03,
        0.8957009622476075e+00,
        0.2080607333140918e-03,
        0.8968895343872672e+00,
        0.2081906929660589e-03,
        0.8980491546507244e+00,
        0.2083175057840894e-03,
        0.8991809506596934e+00,
        0.2084412950089600e-03,
        0.9002860013319247e+00,
        0.2085621786137507e-03,
        0.9013653400525538e+00,
        0.2086802696499600e-03,
        0.9024199576429591e+00,
        0.2087956765716353e-03,
        0.9034508051440569e+00,
        0.2089085035393573e-03,
        0.9044587964294366e+00,
        0.2090188507057549e-03,
        0.9054448106623624e+00,
        0.2091268144840720e-03,
        0.9064096946094280e+00,
        0.2092324878011760e-03,
        0.9073542648225251e+00,
        0.2093359603362731e-03,
        0.9082793096997696e+00,
        0.2094373187464826e-03,
        0.9091855914351026e+00,
        0.2095366468803258e-03,
        0.9100738478654410e+00,
        0.2096340259800857e-03,
        0.9109447942234819e+00,
        0.2097295348739169e-03,
        0.9117991248035615e+00,
        0.2098232501585007e-03,
        0.9126375145473211e+00,
        0.2099152463729734e-03,
        0.9134606205553340e+00,
        0.2100055961647897e-03,
        0.9142690835302997e+00,
        0.2100943704481180e-03,
        0.9150635291568929e+00,
        0.2101816385553131e-03,
        0.9158445694228796e+00,
        0.2102674683819544e-03,
        0.9166128038856619e+00,
        0.2103519265258884e-03,
        0.9173688208879894e+00,
        0.2104350784206675e-03,
        0.9181131987261704e+00,
        0.2105169884637311e-03,
        0.9188465067737359e+00,
        0.2105977201396311e-03,
        0.9195693065631350e+00,
        0.2106773361385627e-03,
        0.9202821528276868e+00,
        0.2107558984704203e-03,
        0.9209855945056615e+00,
        0.2108334685745573e-03,
        0.9216801757080246e+00,
        0.2109101074253908e-03,
        0.9223664366510376e+00,
        0.2109858756339512e-03,
        0.9230449145545729e+00,
        0.2110608335454401e-03,
        0.9237161445066656e+00,
        0.2111350413328171e-03,
        0.9243806602944845e+00,
        0.2112085590864012e-03,
        0.9250389952015636e+00,
        0.2112814468994273e-03,
        0.9256916827707871e+00,
        0.2113537649494626e-03,
        0.9263392575322679e+00,
        0.2114255735755424e-03,
        0.9269822556948962e+00,
        0.2114969333508442e-03,
        0.9276212157999659e+00,
        0.2115679051506757e-03,
        0.9282566793349052e+00,
        0.2116385502155082e-03,
        0.9288891913047499e+00,
        0.2117089302087404e-03,
        0.9295193007585984e+00,
        0.2117791072688329e-03,
        0.9301475612678799e+00,
        0.2118491440554076e-03,
        0.9307745313528513e+00,
        0.2119191037888559e-03,
        0.9314007748533154e+00,
        0.2119890502829553e-03,
        0.9320268612391253e+00,
        0.2120590479699442e-03,
        0.9326533658556098e+00,
        0.2121291619174575e-03,
        0.9332808700986251e+00,
        0.2121994578366795e-03,
        0.9339099615135131e+00,
        0.2122700020810254e-03,
        0.9345412338118337e+00,
        0.2123408616346198e-03,
        0.9351752867993358e+00,
        0.2124121040897991e-03,
        0.9358127262082568e+00,
        0.2124837976128301e-03,
        0.9364541634266928e+00,
        0.2125560108970050e-03,
        0.9371002151174706e+00,
        0.2126288131022461e-03,
        0.9377515027186954e+00,
        0.2127022737803375e-03,
        0.9384086518179469e+00,
        0.2127764627848895e-03,
        0.9390722913919686e+00,
        0.2128514501651432e-03,
        0.9397430529036528e+00,
        0.2129273060427348e-03,
        0.9404215692481872e+00,
        0.2130041004705666e-03,
        0.9411084735403966e+00,
        0.2130819032729711e-03,
        0.9418043977356298e+00,
        0.2131607838664165e-03,
        0.9425099710769944e+00,
        0.2132408110600791e-03,
        0.9432258183623697e+00,
        0.2133220528357081e-03,
        0.9439525580254419e+00,
        0.2134045761063316e-03,
        0.9446908000260153e+00,
        0.2134884464535012e-03,
        0.9454411435460905e+00,
        0.2135737278429450e-03,
        0.9462041744896647e+00,
        0.2136604823187037e-03,
        0.9469804627859271e+00,
        0.2137487696760521e-03,
        0.9477705594974885e+00,
        0.2138386471137701e-03,
        0.9485749937375257e+00,
        0.2139301688666145e-03,
        0.9493942694022146e+00,
        0.2140233858191606e-03,
        0.9502288617275928e+00,
        0.2141183451025241e-03,
        0.9510792136830037e+00,
        0.2142150896758442e-03,
        0.9519457322165201e+00,
        0.5038843819242724e-04,
        0.6925910573206593e-04,
        0.2544993017457056e-01,
        0.8371726902993700e-04,
        0.9887719305509405e-01,
        0.9500958703765661e-04,
        0.1745504296500425e+00,
        0.1040247370141086e-03,
        0.2432273260547244e+00,
        0.1113681540690559e-03,
        0.3035153719186541e+00,
        0.1174557699843303e-03,
        0.3560184543414467e+00,
        0.1225793327188225e-03,
        0.4017811956457096e+00,
        0.1269482262440711e-03,
        0.4418385610275083e+00,
        0.1307160600652860e-03,
        0.4770948070394370e+00,
        0.1339978185876816e-03,
        0.5083063187019734e+00,
        0.1368811515412669e-03,
        0.5360959417043054e+00,
        0.1394339707035654e-03,
        0.5609745206153379e+00,
        0.1417096704842709e-03,
        0.5833616556836523e+00,
        0.1437507874107348e-03,
        0.6036034220420834e+00,
        0.1455916127490372e-03,
        0.6219867936141575e+00,
        0.1472600893816645e-03,
        0.6387511510142359e+00,
        0.1487792104243456e-03,
        0.6540973934997754e+00,
        0.1501680651407632e-03,
        0.6681951446873501e+00,
        0.1514426313109642e-03,
        0.6811884629495294e+00,
        0.1526163827196775e-03,
        0.6932003848740875e+00,
        0.1537007600492208e-03,
        0.7043365583549521e+00,
        0.1547055396155196e-03,
        0.7146881637760102e+00,
        0.1556391248364784e-03,
        0.7243342762844463e+00,
        0.1565087786427017e-03,
        0.7333437871476419e+00,
        0.1573208103069447e-03,
        0.7417769754298066e+00,
        0.1580807267724731e-03,
        0.7496868008107239e+00,
        0.1587933560956882e-03,
        0.7571199727801611e+00,
        0.1594629488101686e-03,
        0.7641178395042019e+00,
        0.1600932616793006e-03,
        0.7707171304832252e+00,
        0.1606876273022243e-03,
        0.7769505800349328e+00,
        0.1612490122811637e-03,
        0.7828474531366270e+00,
        0.1617800660822615e-03,
        0.7884339908714920e+00,
        0.1622831622801481e-03,
        0.7937337893603658e+00,
        0.1627604335348945e-03,
        0.7987681234096885e+00,
        0.1632138013840797e-03,
        0.8035562240062770e+00,
        0.1636450017242930e-03,
        0.8081155171174660e+00,
        0.1640556066920045e-03,
        0.8124618299171829e+00,
        0.1644470435232973e-03,
        0.8166095694827731e+00,
        0.1648206108678467e-03,
        0.8205718781384362e+00,
        0.1651774929489843e-03,
        0.8243607689160389e+00,
        0.1655187718942932e-03,
        0.8279872440294369e+00,
        0.1658454385065429e-03,
        0.8314613987881412e+00,
        0.1661584017002631e-03,
        0.8347925129896938e+00,
        0.1664584967928401e-03,
        0.8379891315112622e+00,
        0.1667464928090865e-03,
        0.8410591355569131e+00,
        0.1670230989335329e-03,
        0.8440098057975293e+00,
        0.1672889702242240e-03,
        0.8468478784572497e+00,
        0.1675447126847760e-03,
        0.8495795952470572e+00,
        0.1677908877772391e-03,
        0.8522107479174399e+00,
        0.1680280164464030e-03,
        0.8547467180936171e+00,
        0.1682565827161736e-03,
        0.8571925129651890e+00,
        0.1684770369102029e-03,
        0.8595527973243928e+00,
        0.1686897985418176e-03,
        0.8618319223811186e+00,
        0.1688952589122240e-03,
        0.8640339517265517e+00,
        0.1690937834508111e-03,
        0.8661626847691907e+00,
        0.1692857138269685e-03,
        0.8682216779257585e+00,
        0.1694713698590671e-03,
        0.8702142638140924e+00,
        0.1696510512430158e-03,
        0.8721435686645843e+00,
        0.1698250391200247e-03,
        0.8740125281403963e+00,
        0.1699935975008061e-03,
        0.8758239017338748e+00,
        0.1701569745613678e-03,
        0.8775802858868165e+00,
        0.1703154038237586e-03,
        0.8792841259650484e+00,
        0.1704691052335605e-03,
        0.8809377272028146e+00,
        0.1706182861445670e-03,
        0.8825432647193950e+00,
        0.1707631422198987e-03,
        0.8841027926989548e+00,
        0.1709038582577726e-03,
        0.8856182528146059e+00,
        0.1710406089492363e-03,
        0.8870914819688771e+00,
        0.1711735595743775e-03,
        0.8885242194150492e+00,
        0.1713028666428259e-03,
        0.8899181133170080e+00,
        0.1714286784837430e-03,
        0.8912747267992473e+00,
        0.1715511357899551e-03,
        0.8925955435333450e+00,
        0.1716703721204033e-03,
        0.8938819729025228e+00,
        0.1717865143646592e-03,
        0.8951353547817279e+00,
        0.1718996831728790e-03,
        0.8963569639669645e+00,
        0.1720099933542312e-03,
        0.8975480142843037e+00,
        0.1721175542465397e-03,
        0.8987096624060582e+00,
        0.1722224700596145e-03,
        0.8998430113989865e+00,
        0.1723248401945090e-03,
        0.9009491140270437e+00,
        0.1724247595407294e-03,
        0.9020289758291009e+00,
        0.1725223187532327e-03,
        0.9030835579901713e+00,
        0.1726176045108827e-03,
        0.9041137800229966e+00,
        0.1727106997578779e-03,
        0.9051205222753303e+00,
        0.1728016839295312e-03,
        0.9061046282768895e+00,
        0.1728906331636581e-03,
        0.9070669069387198e+00,
        0.1729776204987175e-03,
        0.9080081346166083e+00,
        0.1730627160597527e-03,
        0.9089290570491782e+00,
        0.1731459872330869e-03,
        0.9098303911803945e+00,
        0.1732274988306475e-03,
        0.9107128268753881e+00,
        0.1733073132447196e-03,
        0.9115770285377644e+00,
        0.1733854905938624e-03,
        0.9124236366358845e+00,
        0.1734620888606598e-03,
        0.9132532691449957e+00,
        0.1735371640219225e-03,
        0.9140665229115264e+00,
        0.1736107701719091e-03,
        0.9148639749453516e+00,
        0.1736829596390858e-03,
        0.9156461836453693e+00,
        0.1737537830969034e-03,
        0.9164136899633000e+00,
        0.1738232896690321e-03,
        0.9171670185102322e+00,
        0.1738915270294578e-03,
        0.9179066786100761e+00,
        0.1739585414978131e-03,
        0.9186331653037572e+00,
        0.1740243781302842e-03,
        0.9193469603076764e+00,
        0.1740890808064089e-03,
        0.9200485329296795e+00,
        0.1741526923120535e-03,
        0.9207383409455176e+00,
        0.1742152544188343e-03,
        0.9214168314385361e+00,
        0.1742768079602262e-03,
        0.9220844416050994e+00,
        0.1743373929045788e-03,
        0.9227415995280490e+00,
        0.1743970484252448e-03,
        0.9233887249202853e+00,
        0.1744558129680012e-03,
        0.9240262298403793e+00,
        0.1745137243159310e-03,
        0.9246545193819353e+00,
        0.1745708196519153e-03,
        0.9252739923382533e+00,
        0.1746271356188670e-03,
        0.9258850418436779e+00,
        0.1746827083778257e-03,
        0.9264880559928549e+00,
        0.1747375736640159e-03,
        0.9270834184389665e+00,
        0.1747917668409568e-03,
        0.9276715089718623e+00,
        0.1748453229526972e-03,
        0.9282527040768544e+00,
        0.1748982767742368e-03,
        0.9288273774748004e+00,
        0.1749506628601784e-03,
        0.9293959006439499e+00,
        0.1750025155916436e-03,
        0.9299586433238869e+00,
        0.1750538692214704e-03,
        0.9305159740017549e+00,
        0.1751047579176975e-03,
        0.9310682603808031e+00,
        0.1751552158053241e-03,
        0.9316158698311472e+00,
        0.1752052770063228e-03,
        0.9321591698224861e+00,
        0.1752549756778664e-03,
        0.9326985283383640e+00,
        0.1753043460487161e-03,
        0.9332343142714111e+00,
        0.1753534224537021e-03,
        0.9337668977988398e+00,
        0.1754022393662154e-03,
        0.9342966507373076e+00,
        0.1754508314286094e-03,
        0.9348239468760963e+00,
        0.1754992334803999e-03,
        0.9353491622873846e+00,
        0.1755474805841303e-03,
        0.9358726756122197e+00,
        0.1755956080487566e-03,
        0.9363948683206198e+00,
        0.1756436514503888e-03,
        0.9369161249440563e+00,
        0.1756916466502072e-03,
        0.9374368332783890e+00,
        0.1757396298093589e-03,
        0.9379573845551401e+00,
        0.1757876374006189e-03,
        0.9384781735788145e+00,
        0.1758357062165868e-03,
        0.9389995988277885e+00,
        0.1758838733741719e-03,
        0.9395220625161108e+00,
        0.1759321763151046e-03,
        0.9400459706133823e+00,
        0.1759806528021968e-03,
        0.9405717328197126e+00,
        0.1760293409110582e-03,
        0.9410997624925852e+00,
        0.1760782790169647e-03,
        0.9416304765223171e+00,
        0.1761275057765599e-03,
        0.9421642951526550e+00,
        0.1761770601040649e-03,
        0.9427016417429337e+00,
        0.1762269811416588e-03,
        0.9432429424681213e+00,
        0.1762773082236904e-03,
        0.9437886259529981e+00,
        0.1763280808343769e-03,
        0.9443391228366760e+00,
        0.1763793385586478e-03,
        0.9448948652636468e+00,
        0.1764311210257938e-03,
        0.9454562862975816e+00,
        0.1764834678455926e-03,
        0.9460238192541732e+00,
        0.1765364185365951e-03,
        0.9465978969494375e+00,
        0.1765900124462755e-03,
        0.9471789508600694e+00,
        0.1766442886627730e-03,
        0.9477674101926942e+00,
        0.1766992859179855e-03,
        0.9483637008591625e+00,
        0.1767550424818139e-03,
        0.9489682443554301e+00,
        0.1768115960474016e-03,
        0.9495814565420250e+00,
        0.1768689836072686e-03,
        0.9502037463246646e+00,
        0.1769272413203024e-03,
        0.9508355142342285e+00,
        0.1769864043696395e-03,
        0.9514771509060350e+00,
        0.1770465068115518e-03,
        0.9521290354592114e+00,
        0.1771075814155438e-03,
        0.9527915337778898e+00,
        0.1771696594959625e-03,
        0.9534649966970047e+00,
        0.1772327707355348e-03,
        0.9541497580966158e+00,
        0.1772969430013587e-03,
        0.9548461329099190e+00,
        0.1773622021540052e-03,
        0.9555544150514501e+00,
        0.1774285718505145e-03,
        0.9562748752734012e+00,
        0.4141439367791228e-04,
        0.5692455280094251e-04,
        0.2545075230958515e-01,
        0.6880819048293672e-04,
        0.9888145093055719e-01,
        0.7808989690617372e-04,
        0.1745598225673840e+00,
        0.8550005185877480e-04,
        0.2432430266865816e+00,
        0.9153624710259941e-04,
        0.3035382198764821e+00,
        0.9654032678652594e-04,
        0.3560490681596453e+00,
        0.1007520715550410e-03,
        0.4018200414988670e+00,
        0.1043435691172141e-03,
        0.4418859966836131e+00,
        0.1074410674826558e-03,
        0.4771511109577878e+00,
        0.1101390695970056e-03,
        0.5083717098779069e+00,
        0.1125096126676353e-03,
        0.5361705935601133e+00,
        0.1146085117292486e-03,
        0.5610585709493248e+00,
        0.1164796503201761e-03,
        0.5834552139424401e+00,
        0.1181579881289340e-03,
        0.6037065747337148e+00,
        0.1196717082477531e-03,
        0.6220996084034542e+00,
        0.1210437761733641e-03,
        0.6388736798670074e+00,
        0.1222930892987222e-03,
        0.6542296751290908e+00,
        0.1234353365269360e-03,
        0.6683372064799513e+00,
        0.1244836495012513e-03,
        0.6813403224997011e+00,
        0.1254491018862550e-03,
        0.6933620512173756e+00,
        0.1263410963843689e-03,
        0.7045080329697024e+00,
        0.1271676677918698e-03,
        0.7148694414033631e+00,
        0.1279357225503386e-03,
        0.7245253456049399e+00,
        0.1286512297599230e-03,
        0.7335446313434784e+00,
        0.1293193747303500e-03,
        0.7419875726551162e+00,
        0.1299446833543593e-03,
        0.7499071245871521e+00,
        0.1305311235624521e-03,
        0.7573499923313203e+00,
        0.1310821886317202e-03,
        0.7643575200396533e+00,
        0.1316009660202284e-03,
        0.7709664334404412e+00,
        0.1320901945745293e-03,
        0.7772094632859758e+00,
        0.1325523123360135e-03,
        0.7831158711649373e+00,
        0.1329894966984371e-03,
        0.7887118949231211e+00,
        0.1334036983057875e-03,
        0.7940211275731494e+00,
        0.1337966697989137e-03,
        0.7990648409231811e+00,
        0.1341699903007926e-03,
        0.8038622630547293e+00,
        0.1345250863590139e-03,
        0.8084308171076828e+00,
        0.1348632499289629e-03,
        0.8127863274927396e+00,
        0.1351856538739728e-03,
        0.8169431985757714e+00,
        0.1354933653731529e-03,
        0.8209145700097322e+00,
        0.1357873575589372e-03,
        0.8247124521846697e+00,
        0.1360685196510050e-03,
        0.8283478446917955e+00,
        0.1363376658083228e-03,
        0.8318308402273038e+00,
        0.1365955428844750e-03,
        0.8351707159751699e+00,
        0.1368428372415219e-03,
        0.8383760141893339e+00,
        0.1370801807530195e-03,
        0.8414546134316254e+00,
        0.1373081561065382e-03,
        0.8444137917023124e+00,
        0.1375273014991923e-03,
        0.8472602825170738e+00,
        0.1377381148057014e-03,
        0.8500003248309528e+00,
        0.1379410572868236e-03,
        0.8526397075811507e+00,
        0.1381365568962136e-03,
        0.8551838095120960e+00,
        0.1383250112355325e-03,
        0.8576376348545903e+00,
        0.1385067902006957e-03,
        0.8600058453531640e+00,
        0.1386822383562781e-03,
        0.8622927890697443e+00,
        0.1388516770701086e-03,
        0.8645025263354547e+00,
        0.1390154064358504e-03,
        0.8666388531742509e+00,
        0.1391737070077414e-03,
        0.8687053224808631e+00,
        0.1393268413685703e-03,
        0.8707052632000881e+00,
        0.1394750555493091e-03,
        0.8726417977239585e+00,
        0.1396185803165322e-03,
        0.8745178576969695e+00,
        0.1397576323417808e-03,
        0.8763361983967452e+00,
        0.1398924152653265e-03,
        0.8780994118377522e+00,
        0.1400231206653106e-03,
        0.8798099387284804e+00,
        0.1401499289419495e-03,
        0.8814700793975387e+00,
        0.1402730101253844e-03,
        0.8830820037910464e+00,
        0.1403925246147742e-03,
        0.8846477606322743e+00,
        0.1405086238553824e-03,
        0.8861692858244719e+00,
        0.1406214509596627e-03,
        0.8876484101690279e+00,
        0.1407311412776921e-03,
        0.8890868664633782e+00,
        0.1408378229217274e-03,
        0.8904862960362619e+00,
        0.1409416172491532e-03,
        0.8918482547719127e+00,
        0.1410426393076430e-03,
        0.8931742186694573e+00,
        0.1411409982459610e-03,
        0.8944655889790835e+00,
        0.1412367976934811e-03,
        0.8957236969523653e+00,
        0.1413301361111912e-03,
        0.8969498082404222e+00,
        0.1414211071166758e-03,
        0.8981451269702901e+00,
        0.1415097997853232e-03,
        0.8993107995269396e+00,
        0.1415962989297887e-03,
        0.9004479180657531e+00,
        0.1416806853595467e-03,
        0.9015575237779278e+00,
        0.1417630361221969e-03,
        0.9026406099291728e+00,
        0.1418434247280258e-03,
        0.9036981246901897e+00,
        0.1419219213591954e-03,
        0.9047309737757363e+00,
        0.1419985930647974e-03,
        0.9057400229075616e+00,
        0.1420735039429043e-03,
        0.9067261001151347e+00,
        0.1421467153106468e-03,
        0.9076899978868622e+00,
        0.1422182858632548e-03,
        0.9086324751833850e+00,
        0.1422882718229183e-03,
        0.9095542593235423e+00,
        0.1423567270782516e-03,
        0.9104560477526908e+00,
        0.1424237033150753e-03,
        0.9113385097022479e+00,
        0.1424892501391719e-03,
        0.9122022877485889e+00,
        0.1425534151916154e-03,
        0.9130479992787559e+00,
        0.1426162442572255e-03,
        0.9138762378698273e+00,
        0.1426777813666525e-03,
        0.9146875745882436e+00,
        0.1427380688925579e-03,
        0.9154825592148789e+00,
        0.1427971476403172e-03,
        0.9162617214011930e+00,
        0.1428550569336404e-03,
        0.9170255717613750e+00,
        0.1429118346954711e-03,
        0.9177746029050118e+00,
        0.1429675175245004e-03,
        0.9185092904144644e+00,
        0.1430221407676021e-03,
        0.9192300937708136e+00,
        0.1430757385884771e-03,
        0.9199374572319491e+00,
        0.1431283440327680e-03,
        0.9206318106661012e+00,
        0.1431799890898880e-03,
        0.9213135703438758e+00,
        0.1432307047517914e-03,
        0.9219831396916189e+00,
        0.1432805210688911e-03,
        0.9226409100087367e+00,
        0.1433294672033191e-03,
        0.9232872611513990e+00,
        0.1433775714797077e-03,
        0.9239225621848796e+00,
        0.1434248614336570e-03,
        0.9245471720066236e+00,
        0.1434713638580431e-03,
        0.9251614399419788e+00,
        0.1435171048473090e-03,
        0.9257657063143877e+00,
        0.1435621098398706e-03,
        0.9263603029917071e+00,
        0.1436064036587590e-03,
        0.9269455539101992e+00,
        0.1436500105506133e-03,
        0.9275217755776247e+00,
        0.1436929542231280e-03,
        0.9280892775567625e+00,
        0.1437352578810521e-03,
        0.9286483629305795e+00,
        0.1437769442608283e-03,
        0.9291993287501823e+00,
        0.1438180356639552e-03,
        0.9297424664665897e+00,
        0.1438585539891476e-03,
        0.9302780623472868e+00,
        0.1438985207633644e-03,
        0.9308063978784351e+00,
        0.1439379571717663e-03,
        0.9313277501535416e+00,
        0.1439768840866617e-03,
        0.9318423922493136e+00,
        0.1440153220954916e-03,
        0.9323505935893585e+00,
        0.1440532915279006e-03,
        0.9328526202963160e+00,
        0.1440908124819338e-03,
        0.9333487355329478e+00,
        0.1441279048493981e-03,
        0.9338391998326430e+00,
        0.1441645883404158e-03,
        0.9343242714197350e+00,
        0.1442008825071996e-03,
        0.9348042065199632e+00,
        0.1442368067670687e-03,
        0.9352792596613518e+00,
        0.1442723804247230e-03,
        0.9357496839657160e+00,
        0.1443076226937871e-03,
        0.9362157314309450e+00,
        0.1443425527176319e-03,
        0.9366776532041510e+00,
        0.1443771895894746e-03,
        0.9371356998457099e+00,
        0.1444115523717566e-03,
        0.9375901215841609e+00,
        0.1444456601147895e-03,
        0.9380411685618638e+00,
        0.1444795318746588e-03,
        0.9384890910712563e+00,
        0.1445131867303672e-03,
        0.9389341397814829e+00,
        0.1445466438001951e-03,
        0.9393765659551052e+00,
        0.1445799222572509e-03,
        0.9398166216545342e+00,
        0.1446130413441780e-03,
        0.9402545599377586e+00,
        0.1446460203869812e-03,
        0.9406906350428731e+00,
        0.1446788788079280e-03,
        0.9411251025608388e+00,
        0.1447116361374763e-03,
        0.9415582195958393e+00,
        0.1447443120251743e-03,
        0.9419902449125173e+00,
        0.1447769262494714e-03,
        0.9424214390693087e+00,
        0.1448094987263750e-03,
        0.9428520645370120e+00,
        0.1448420495168817e-03,
        0.9432823858016560e+00,
        0.1448745988331048e-03,
        0.9437126694506553e+00,
        0.1449071670430162e-03,
        0.9441431842411634e+00,
        0.1449397746737126e-03,
        0.9445742011494633e+00,
        0.1449724424131142e-03,
        0.9450059934001559e+00,
        0.1450051911099938e-03,
        0.9454388364738392e+00,
        0.1450380417722341e-03,
        0.9458730080918976e+00,
        0.1450710155632024e-03,
        0.9463087881769580e+00,
        0.1451041337961289e-03,
        0.9467464587875015e+00,
        0.1451374179263711e-03,
        0.9471863040250684e+00,
        0.1451708895414430e-03,
        0.9476286099124387e+00,
        0.1452045703486834e-03,
        0.9480736642411287e+00,
        0.1452384821604381e-03,
        0.9485217563865096e+00,
        0.1452726468766264e-03,
        0.9489731770888300e+00,
        0.1453070864645653e-03,
        0.9494282181984106e+00,
        0.1453418229359214e-03,
        0.9498871723832843e+00,
        0.1453768783206665e-03,
        0.9503503327975676e+00,
        0.1454122746379124e-03,
        0.9508179927088858e+00,
        0.1454480338635091e-03,
        0.9512904450832298e+00,
        0.1454841778942922e-03,
        0.9517679821256925e+00,
        0.1455207285088794e-03,
        0.9522508947756375e+00,
        0.1455577073249200e-03,
        0.9527394721549711e+00,
        0.1455951357527194e-03,
        0.9532340009683443e+00,
        0.1456330349451717e-03,
        0.9537347648542913e+00,
        0.1456714257439507e-03,
        0.9542420436865237e+00,
        0.1457103286219321e-03,
        0.9547561128248467e+00,
        0.1457497636218381e-03,
        0.9552772423154445e+00,
        0.1457897502911246e-03,
        0.9558056960406009e+00,
        0.1458303076131549e-03,
        0.9563417308182725e+00,
        0.1458714539347385e-03,
        0.9568855954523308e+00,
        0.1459132068901443e-03,
        0.9574375297347150e+00,
        0.1459555833217350e-03,
        0.9579977634012095e+00,
        0.1459985991974088e-03,
        0.9585665150430652e+00,
        0.1460422695250747e-03,
        0.9591439909772242e+00,
        0.1460866082644329e-03,
        0.9597303840784822e+00,
        0.1461316282363772e-03,
        0.9603258725775255e+00,
        0.3429496445563442e-04,
        0.4713901805892190e-04,
        0.2545140450924156e-01,
        0.5698005902228804e-04,
        0.9888482887297308e-01,
        0.6466651548721230e-04,
        0.1745672748051217e+00,
        0.7080319239456011e-04,
        0.2432554843126429e+00,
        0.7580213079430914e-04,
        0.3035563500747286e+00,
        0.7994640198168629e-04,
        0.3560733630370389e+00,
        0.8343456150015368e-04,
        0.4018508725952348e+00,
        0.8640911033247278e-04,
        0.4419236498367694e+00,
        0.8897459090834537e-04,
        0.4771958093843240e+00,
        0.9120925845958284e-04,
        0.5084236299136395e+00,
        0.9317276496329196e-04,
        0.5362298756774806e+00,
        0.9491132926180562e-04,
        0.5611253276477577e+00,
        0.9646129005158931e-04,
        0.5835295355152852e+00,
        0.9785159643187923e-04,
        0.6037885335602648e+00,
        0.9910558598615794e-04,
        0.6221892621956204e+00,
        0.1002422757479970e-03,
        0.6389710741614672e+00,
        0.1012773140638229e-03,
        0.6543348452257979e+00,
        0.1022236924158808e-03,
        0.6684501789683020e+00,
        0.1030922846881736e-03,
        0.6814611164733789e+00,
        0.1038922606077670e-03,
        0.6934906792512014e+00,
        0.1046314062227422e-03,
        0.7046445019124451e+00,
        0.1053163748547551e-03,
        0.7150137530267155e+00,
        0.1059528854651743e-03,
        0.7246774971389701e+00,
        0.1065458808280527e-03,
        0.7337046159216464e+00,
        0.1070996546816144e-03,
        0.7421553796866258e+00,
        0.1076179547185671e-03,
        0.7500827400704289e+00,
        0.1081040665980620e-03,
        0.7575333991194183e+00,
        0.1085608829314993e-03,
        0.7645486980661065e+00,
        0.1089909602824242e-03,
        0.7711653599123298e+00,
        0.1093965665385209e-03,
        0.7774161128496167e+00,
        0.1097797204987463e-03,
        0.7833302160485503e+00,
        0.1101422251266719e-03,
        0.7889339050599856e+00,
        0.1104856956203599e-03,
        0.7942507707081078e+00,
        0.1108115832166325e-03,
        0.7993020827048136e+00,
        0.1111211954666116e-03,
        0.8041070671151008e+00,
        0.1114157135775683e-03,
        0.8086831451312193e+00,
        0.1116962073042465e-03,
        0.8130461392755103e+00,
        0.1119636477840458e-03,
        0.8172104520762232e+00,
        0.1122189186395992e-03,
        0.8211892213917328e+00,
        0.1124628256154204e-03,
        0.8249944558535597e+00,
        0.1126961049694284e-03,
        0.8286371533240165e+00,
        0.1129194308029721e-03,
        0.8321274047940588e+00,
        0.1131334214826889e-03,
        0.8354744857604805e+00,
        0.1133386452827434e-03,
        0.8386869368027751e+00,
        0.1135356253556231e-03,
        0.8417726348159536e+00,
        0.1137248441228562e-03,
        0.8447388561361401e+00,
        0.1139067471630854e-03,
        0.8475923326126939e+00,
        0.1140817466633488e-03,
        0.8503393015273689e+00,
        0.1142502244897405e-03,
        0.8529855501323292e+00,
        0.1144125349255261e-03,
        0.8555364554704203e+00,
        0.1145690071179690e-03,
        0.8579970200494635e+00,
        0.1147199472693837e-03,
        0.8603719038646763e+00,
        0.1148656406030670e-03,
        0.8626654531972963e+00,
        0.1150063531306337e-03,
        0.8648817265611982e+00,
        0.1151423332437714e-03,
        0.8670245181211878e+00,
        0.1152738131504335e-03,
        0.8690973788654197e+00,
        0.1154010101729216e-03,
        0.8711036357789597e+00,
        0.1155241279231094e-03,
        0.8730464092349987e+00,
        0.1156433573681646e-03,
        0.8749286287938791e+00,
        0.1157588777984930e-03,
        0.8767530475772949e+00,
        0.1158708577082165e-03,
        0.8785222553652559e+00,
        0.1159794555972724e-03,
        0.8802386905462134e+00,
        0.1160848207031594e-03,
        0.8819046510357806e+00,
        0.1161870936694311e-03,
        0.8835223042664072e+00,
        0.1162864071572288e-03,
        0.8850936963389428e+00,
        0.1163828864054445e-03,
        0.8866207604170093e+00,
        0.1164766497444822e-03,
        0.8881053244363083e+00,
        0.1165678090680486e-03,
        0.8895491181932601e+00,
        0.1166564702669258e-03,
        0.8909537798705543e+00,
        0.1167427336282587e-03,
        0.8923208620511820e+00,
        0.1168266942035215e-03,
        0.8936518372671990e+00,
        0.1169084421479998e-03,
        0.8949481031247646e+00,
        0.1169880630343355e-03,
        0.8962109870428230e+00,
        0.1170656381424237e-03,
        0.8974417506390828e+00,
        0.1171412447277278e-03,
        0.8986415937936533e+00,
        0.1172149562698677e-03,
        0.8998116584177496e+00,
        0.1172868427031662e-03,
        0.9009530319522595e+00,
        0.1173569706306669e-03,
        0.9020667506186153e+00,
        0.1174254035230018e-03,
        0.9031538024423191e+00,
        0.1174922019033529e-03,
        0.9042151300675857e+00,
        0.1175574235196376e-03,
        0.9052516333798847e+00,
        0.1176211235049476e-03,
        0.9062641719516429e+00,
        0.1176833545271722e-03,
        0.9072535673250101e+00,
        0.1177441669286597e-03,
        0.9082206051443592e+00,
        0.1178036088566899e-03,
        0.9091660371500875e+00,
        0.1178617263854677e-03,
        0.9100905830442862e+00,
        0.1179185636302828e-03,
        0.9109949322379410e+00,
        0.1179741628544263e-03,
        0.9118797454885111e+00,
        0.1180285645694077e-03,
        0.9127456564359945e+00,
        0.1180818076289649e-03,
        0.9135932730449129e+00,
        0.1181339293173255e-03,
        0.9144231789590457e+00,
        0.1181849654321338e-03,
        0.9152359347751857e+00,
        0.1182349503624295e-03,
        0.9160320792416857e+00,
        0.1182839171620296e-03,
        0.9168121303871106e+00,
        0.1183318976186388e-03,
        0.9175765865838867e+00,
        0.1183789223189884e-03,
        0.9183259275514641e+00,
        0.1184250207102780e-03,
        0.9190606153031572e+00,
        0.1184702211581763e-03,
        0.9197810950405108e+00,
        0.1185145510016160e-03,
        0.9204877959987503e+00,
        0.1185580366045994e-03,
        0.9211811322466059e+00,
        0.1186007034052168e-03,
        0.9218615034435585e+00,
        0.1186425759620638e-03,
        0.9225292955573307e+00,
        0.1186836779982295e-03,
        0.9231848815442406e+00,
        0.1187240324430169e-03,
        0.9238286219948466e+00,
        0.1187636614715423e-03,
        0.9244608657471405e+00,
        0.1188025865423529e-03,
        0.9250819504693824e+00,
        0.1188408284331903e-03,
        0.9256922032145273e+00,
        0.1188784072750181e-03,
        0.9262919409480546e+00,
        0.1189153425844261e-03,
        0.9268814710508878e+00,
        0.1189516532945120e-03,
        0.9274610917989764e+00,
        0.1189873577843384e-03,
        0.9280310928210021e+00,
        0.1190224739070536e-03,
        0.9285917555355758e+00,
        0.1190570190167592e-03,
        0.9291433535691963e+00,
        0.1190910099942032e-03,
        0.9296861531561591e+00,
        0.1191244632713702e-03,
        0.9302204135215227e+00,
        0.1191573948550362e-03,
        0.9307463872481658e+00,
        0.1191898203493515e-03,
        0.9312643206289019e+00,
        0.1192217549775109e-03,
        0.9317744540045509e+00,
        0.1192532136025640e-03,
        0.9322770220888102e+00,
        0.1192842107474197e-03,
        0.9327722542807087e+00,
        0.1193147606140906e-03,
        0.9332603749653780e+00,
        0.1193448771022213e-03,
        0.9337416038038212e+00,
        0.1193745738269449e-03,
        0.9342161560123183e+00,
        0.1194038641361023e-03,
        0.9346842426320593e+00,
        0.1194327611268635e-03,
        0.9351460707895552e+00,
        0.1194612776617823e-03,
        0.9356018439483411e+00,
        0.1194894263843151e-03,
        0.9360517621524420e+00,
        0.1195172197338335e-03,
        0.9364960222620436e+00,
        0.1195446699601559e-03,
        0.9369348181817692e+00,
        0.1195717891376224e-03,
        0.9373683410819361e+00,
        0.1195985891787351e-03,
        0.9377967796131314e+00,
        0.1196250818473841e-03,
        0.9382203201144163e+00,
        0.1196512787716769e-03,
        0.9386391468154388e+00,
        0.1196771914563876e-03,
        0.9390534420327067e+00,
        0.1197028312950406e-03,
        0.9394633863602434e+00,
        0.1197282095816411e-03,
        0.9398691588548227e+00,
        0.1197533375220634e-03,
        0.9402709372159495e+00,
        0.1197782262451063e-03,
        0.9406688979607300e+00,
        0.1198028868132232e-03,
        0.9410632165937440e+00,
        0.1198273302329317e-03,
        0.9414540677720091e+00,
        0.1198515674649078e-03,
        0.9418416254650982e+00,
        0.1198756094337670e-03,
        0.9422260631104450e+00,
        0.1198994670375319e-03,
        0.9426075537638465e+00,
        0.1199231511567857e-03,
        0.9429862702451438e+00,
        0.1199466726635097e-03,
        0.9433623852790360e+00,
        0.1199700424295984e-03,
        0.9437360716309537e+00,
        0.1199932713350474e-03,
        0.9441075022378914e+00,
        0.1200163702758047e-03,
        0.9444768503340695e+00,
        0.1200393501712764e-03,
        0.9448442895712680e+00,
        0.1200622219714742e-03,
        0.9452099941336445e+00,
        0.1200849966637913e-03,
        0.9455741388468206e+00,
        0.1201076852793909e-03,
        0.9459368992809881e+00,
        0.1201302988991895e-03,
        0.9462984518477588e+00,
        0.1201528486594163e-03,
        0.9466589738904483e+00,
        0.1201753457567260e-03,
        0.9470186437674542e+00,
        0.1201978014528419e-03,
        0.9473776409283557e+00,
        0.1202202270787045e-03,
        0.9477361459823309e+00,
        0.1202426340380965e-03,
        0.9480943407584549e+00,
        0.1202650338107162e-03,
        0.9484524083574091e+00,
        0.1202874379546662e-03,
        0.9488105331941014e+00,
        0.1203098581083251e-03,
        0.9491689010306607e+00,
        0.1203323059915656e-03,
        0.9495276989992437e+00,
        0.1203547934062821e-03,
        0.9498871156140531e+00,
        0.1203773322361880e-03,
        0.9502473407719423e+00,
        0.1203999344458418e-03,
        0.9506085657409490e+00,
        0.1204226120788594e-03,
        0.9509709831360716e+00,
        0.1204453772552672e-03,
        0.9513347868815795e+00,
        0.1204682421679518e-03,
        0.9517001721591189e+00,
        0.1204912190781571e-03,
        0.9520673353408602e+00,
        0.1205143203099825e-03,
        0.9524364739069084e+00,
        0.1205375582438321e-03,
        0.9528077863461864e+00,
        0.1205609453087660e-03,
        0.9531814720399889e+00,
        0.1205844939737027e-03,
        0.9535577311273962e+00,
        0.1206082167374240e-03,
        0.9539367643517374e+00,
        0.1206321261173331e-03,
        0.9543187728872938e+00,
        0.1206562346369151e-03,
        0.9547039581454467e+00,
        0.1206805548118562e-03,
        0.9550925215594878e+00,
        0.1207050991347726e-03,
        0.9554846643473366e+00,
        0.1207298800585086e-03,
        0.9558805872514442e+00,
        0.1207549099779616e-03,
        0.9562804902552012e+00,
        0.1207802012103997e-03,
        0.9566845722752253e+00,
        0.1208057659742362e-03,
        0.9570930308289628e+00,
        0.1208316163662374e-03,
        0.9575060616771147e+00,
        0.1208577643371385e-03,
        0.9579238584404855e+00,
        0.1208842216656548e-03,
        0.9583466121909501e+00,
        0.1209109999308791e-03,
        0.9587745110163490e+00,
        0.1209381104830662e-03,
        0.9592077395592462e+00,
        0.1209655644128141e-03,
        0.9596464785296278e+00,
        0.1209933725186615e-03,
        0.9600909041917725e+00,
        0.1210215452731320e-03,
        0.9605411878256951e+00,
        0.1210500927872672e-03,
        0.9609974951637526e+00,
        0.1210790247737047e-03,
        0.9614599858031973e+00,
        0.1211083505083695e-03,
        0.9619288125956789e+00,
        0.1211380787908609e-03,
        0.9624041210149244e+00,
        0.1211682179036361e-03,
        0.9628860485040654e+00,
        0.1211987755701019e-03,
        0.9633747238043349e+00,
        0.1212297589117476e-03,
        0.9638702662671197e+00
    ]
    mσ = SVector{46, T}(0.4102693550421609e+00, 0.3889624104727243e+00,
        0.3804692420283886e+00, 0.3760815680865637e+00,
        0.3735177579729938e+00, 0.3719340231904236e+00,
        0.3708571145968057e+00, 0.3700947006022557e+00,
        0.3695328931459086e+00, 0.3691085831661758e+00,
        0.3687813249652330e+00, 0.3685244707068931e+00,
        0.3683185599507446e+00, 0.3681542178682514e+00,
        0.3680181997765286e+00, 0.3679084456991284e+00,
        0.3678181571053212e+00, 0.3678314333608541e+00,
        0.3677897070402892e+00, 0.3681800192470787e+00,
        0.3681272993461229e+00, 0.3680840569645587e+00,
        0.3680522380648169e+00, 0.3680263578626069e+00,
        0.3680061275157194e+00, 0.3679837719607466e+00,
        0.3679668653311732e+00, 0.3679542340323301e+00,
        0.3679429332584250e+00, 0.3679349432021754e+00,
        0.3679290943359695e+00, 0.3679242023884676e+00,
        0.3679207541681089e+00, 0.3679185472223537e+00,
        0.3679168690130640e+00, 0.3679158588043139e+00,
        0.3679154592969145e+00, 0.3679154025286917e+00,
        0.3679157536198652e+00, 0.3679163676763697e+00,
        0.3679171904021983e+00, 0.3679181786833088e+00,
        0.3679192462983425e+00, 0.3679204323079710e+00,
        0.3679216942157868e+00, 0.3679229127010114e+00)
    mτ = SVector{46, T}(0.4495196112243335e+00, 0.4219428123056774e+00,
        0.4084335547255627e+00, 0.4009301129475925e+00,
        0.3963598727888637e+00, 0.3934034185789226e+00,
        0.3913676516238603e+00, 0.3899091428928617e+00,
        0.3888276962996660e+00, 0.3880048656683555e+00,
        0.3873650613539532e+00, 0.3868583585730354e+00,
        0.3864499054795832e+00, 0.3861178821587815e+00,
        0.3858426294881124e+00, 0.3856144554520791e+00,
        0.3854228843194507e+00, 0.3853156085078759e+00,
        0.3851902798680153e+00, 0.3853705093720269e+00,
        0.3851957294861824e+00, 0.3850587241670235e+00,
        0.3849515900397918e+00, 0.3848648995575697e+00,
        0.3847945082231300e+00, 0.3847117224407400e+00,
        0.3846478726309070e+00, 0.3845979020112835e+00,
        0.3845472492329918e+00, 0.3845088319509754e+00,
        0.3844789634065264e+00, 0.3844504092359686e+00,
        0.3844285235163634e+00, 0.3844115660464609e+00,
        0.3843957877945634e+00, 0.3843835767106759e+00,
        0.3843727001444428e+00, 0.3843632394180673e+00,
        0.3843553120908175e+00, 0.3843487746818896e+00,
        0.3843434800804404e+00, 0.3843392605995229e+00,
        0.3843359163858929e+00, 0.3843331309176606e+00,
        0.3843309056586355e+00, 0.3843292556220249e+00)
    SROCKC2ConstantCache{typeof(zprev), T}(ms, recf, mσ, mτ, zprev, 1, 1, 1)
end
