/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.SerializationErrors;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrRichCallableReference;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010\u0013\u001a\u00020\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u001e2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/IrInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/checkers/IrInlineDeclarationChecker$InlineFunctionInfo;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "visitType", "container", "Lorg/jetbrains/kotlin/ir/IrElement;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "data", "visitElement", "element", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitRichCallableReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrRichCallableReference;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitInlinedFunctionBlock", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "InlineFunctionInfo", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineDeclarationChecker.kt\norg/jetbrains/kotlin/backend/common/checkers/IrInlineDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,118:1\n1#2:119\n2275#3,2:120\n*S KotlinDebug\n*F\n+ 1 IrInlineDeclarationChecker.kt\norg/jetbrains/kotlin/backend/common/checkers/IrInlineDeclarationChecker\n*L\n53#1:120,2\n*E\n"})
public final class IrInlineDeclarationChecker
extends IrTypeVisitor<Unit, InlineFunctionInfo> {
    @NotNull
    private final IrDiagnosticReporter diagnosticReporter;

    public IrInlineDeclarationChecker(@NotNull IrDiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter(diagnosticReporter, "diagnosticReporter");
        this.diagnosticReporter = diagnosticReporter;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitType(@NotNull IrElement container, @NotNull IrType type, @Nullable InlineFunctionInfo data) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(type, "type");
        v0 = data;
        if (v0 == null || (v0 = v0.getInlineFunction()) == null) {
            return;
        }
        inlineFunction = v0;
        v1 = IrTypesKt.getClassifierOrNull(type);
        if (v1 == null) ** GOTO lbl-1000
        it = var10_5 = v1;
        $i$a$-takeIf-IrInlineDeclarationChecker$visitType$klass$1 = false;
        v1 = it.isBound() != false ? var10_5 : null;
        if (v1 != null) {
            v2 = v1.getOwner();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        var7_9 = v2;
        v3 = var7_9 instanceof IrClass != false ? (IrClass)var7_9 : null;
        if (v3 == null) {
            return;
        }
        klass = v3;
        if (!data.getInsideEffectivelyPrivateDeclaration() && IrVisibilityUtilKt.isEffectivelyPrivate(klass)) {
            block9: {
                $this$none$iv = IrUtilsKt.getParents(klass);
                $i$f$none = false;
                var8_13 = $this$none$iv.iterator();
                while (var8_13.hasNext()) {
                    it = element$iv = var8_13.next();
                    $i$a$-none-IrInlineDeclarationChecker$visitType$1 = false;
                    if (!Intrinsics.areEqual(it, inlineFunction)) continue;
                    v4 = false;
                    break block9;
                }
                v4 = true;
            }
            if (v4) {
                if (((Collection)data.getInliningPath()).isEmpty() == false) {
                    this.diagnosticReporter.at((IrElement)CollectionsKt.first(data.getInliningPath()), data.getFile()).report(SerializationErrors.INSTANCE.getIR_PRIVATE_TYPE_USED_IN_NON_PRIVATE_INLINE_FUNCTION_CASCADING(), inlineFunction, klass, data.getInliningPath());
                } else {
                    this.diagnosticReporter.at(container, data.getFile()).report(SerializationErrors.INSTANCE.getIR_PRIVATE_TYPE_USED_IN_NON_PRIVATE_INLINE_FUNCTION(), inlineFunction, klass);
                }
            }
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        element.acceptChildren(this, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        declaration.acceptChildren(this, new InlineFunctionInfo(declaration, false, null, null, 14, null));
    }

    @Override
    public void visitRichCallableReference(@NotNull IrRichCallableReference<?> expression2, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitRichCallableReference(expression2, data2);
        Object object = data2;
        if (object == null || (object = ((InlineFunctionInfo)object).getInlineFunction()) == null) {
            return;
        }
        Object inlineFunction = object;
        Object obj = expression2.getReflectionTargetSymbol();
        IrSymbolOwner irSymbolOwner = obj != null ? obj.getOwner() : null;
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility reflectionTarget = irDeclarationWithVisibility;
        if (IrVisibilityUtilKt.isEffectivelyPrivate(reflectionTarget) && !data2.getInsideEffectivelyPrivateDeclaration()) {
            if (!((Collection)data2.getInliningPath()).isEmpty()) {
                this.diagnosticReporter.at((IrElement)CollectionsKt.first(data2.getInliningPath()), data2.getFile()).report(SerializationErrors.INSTANCE.getIR_PRIVATE_CALLABLE_REFERENCED_BY_NON_PRIVATE_INLINE_FUNCTION_CASCADING(), inlineFunction, reflectionTarget, data2.getInliningPath());
            } else {
                this.diagnosticReporter.at((IrElement)expression2, data2.getFile()).report(SerializationErrors.INSTANCE.getIR_PRIVATE_CALLABLE_REFERENCED_BY_NON_PRIVATE_INLINE_FUNCTION(), inlineFunction, reflectionTarget);
            }
        }
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        InlineFunctionInfo inlineFunctionInfo = data2;
        declaration.acceptChildren(this, inlineFunctionInfo != null ? InlineFunctionInfo.insideDeclaration$default(inlineFunctionInfo, declaration, null, 2, null) : null);
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(inlinedBlock, "inlinedBlock");
        InlineFunctionInfo inlineFunctionInfo = data2;
        inlinedBlock.acceptChildren(this, inlineFunctionInfo != null ? InlineFunctionInfo.copy$default(inlineFunctionInfo, null, false, null, CollectionsKt.plus((Collection)data2.getInliningPath(), inlinedBlock), 7, null) : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable InlineFunctionInfo data2) {
        InlineFunctionInfo inlineFunctionInfo;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrFunction irFunction = declaration;
        IrVisitor irVisitor = this;
        InlineFunctionInfo inlineFunctionInfo2 = data2;
        if (inlineFunctionInfo2 != null) {
            void it;
            IrFunction irFunction2;
            IrFunction irFunction3 = irFunction2 = declaration;
            IrDeclaration irDeclaration = declaration;
            InlineFunctionInfo inlineFunctionInfo3 = inlineFunctionInfo2;
            IrVisitor irVisitor2 = irVisitor;
            IrFunction irFunction4 = irFunction;
            boolean bl = false;
            boolean bl2 = it.isInline();
            irFunction = irFunction4;
            irVisitor = irVisitor2;
            inlineFunctionInfo = inlineFunctionInfo3.insideDeclaration(irDeclaration, bl2 ? irFunction2 : null);
        } else {
            inlineFunctionInfo = null;
        }
        irFunction.acceptChildren(irVisitor, inlineFunctionInfo);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable InlineFunctionInfo data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        expression2.acceptChildren(this, data2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J9\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/IrInlineDeclarationChecker$InlineFunctionInfo;", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "insideEffectivelyPrivateDeclaration", "", "inlineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "inliningPath", "", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;ZLorg/jetbrains/kotlin/ir/declarations/IrFunction;Ljava/util/List;)V", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getInsideEffectivelyPrivateDeclaration", "()Z", "getInlineFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getInliningPath", "()Ljava/util/List;", "insideDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.serialization.common"})
    public static final class InlineFunctionInfo {
        @NotNull
        private final IrFile file;
        private final boolean insideEffectivelyPrivateDeclaration;
        @Nullable
        private final IrFunction inlineFunction;
        @NotNull
        private final List<IrInlinedFunctionBlock> inliningPath;

        public InlineFunctionInfo(@NotNull IrFile file, boolean insideEffectivelyPrivateDeclaration, @Nullable IrFunction inlineFunction, @NotNull List<? extends IrInlinedFunctionBlock> inliningPath) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(inliningPath, "inliningPath");
            this.file = file;
            this.insideEffectivelyPrivateDeclaration = insideEffectivelyPrivateDeclaration;
            this.inlineFunction = inlineFunction;
            this.inliningPath = inliningPath;
        }

        public /* synthetic */ InlineFunctionInfo(IrFile irFile, boolean bl, IrFunction irFunction, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                irFunction = null;
            }
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(irFile, bl, irFunction, list);
        }

        @NotNull
        public final IrFile getFile() {
            return this.file;
        }

        public final boolean getInsideEffectivelyPrivateDeclaration() {
            return this.insideEffectivelyPrivateDeclaration;
        }

        @Nullable
        public final IrFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final List<IrInlinedFunctionBlock> getInliningPath() {
            return this.inliningPath;
        }

        @NotNull
        public final InlineFunctionInfo insideDeclaration(@NotNull IrDeclaration declaration, @Nullable IrFunction inlineFunction) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (this.inlineFunction != null) {
                return this;
            }
            if (!(declaration instanceof IrDeclarationWithVisibility)) {
                return this;
            }
            return new InlineFunctionInfo(this.file, this.insideEffectivelyPrivateDeclaration || !IrVisibilityUtilKt.isNonPrivate((IrDeclarationWithVisibility)declaration), inlineFunction, null, 8, null);
        }

        public static /* synthetic */ InlineFunctionInfo insideDeclaration$default(InlineFunctionInfo inlineFunctionInfo, IrDeclaration irDeclaration, IrFunction irFunction, int n2, Object object) {
            if ((n2 & 2) != 0) {
                irFunction = inlineFunctionInfo.inlineFunction;
            }
            return inlineFunctionInfo.insideDeclaration(irDeclaration, irFunction);
        }

        @NotNull
        public final IrFile component1() {
            return this.file;
        }

        public final boolean component2() {
            return this.insideEffectivelyPrivateDeclaration;
        }

        @Nullable
        public final IrFunction component3() {
            return this.inlineFunction;
        }

        @NotNull
        public final List<IrInlinedFunctionBlock> component4() {
            return this.inliningPath;
        }

        @NotNull
        public final InlineFunctionInfo copy(@NotNull IrFile file, boolean insideEffectivelyPrivateDeclaration, @Nullable IrFunction inlineFunction, @NotNull List<? extends IrInlinedFunctionBlock> inliningPath) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(inliningPath, "inliningPath");
            return new InlineFunctionInfo(file, insideEffectivelyPrivateDeclaration, inlineFunction, inliningPath);
        }

        public static /* synthetic */ InlineFunctionInfo copy$default(InlineFunctionInfo inlineFunctionInfo, IrFile irFile, boolean bl, IrFunction irFunction, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irFile = inlineFunctionInfo.file;
            }
            if ((n2 & 2) != 0) {
                bl = inlineFunctionInfo.insideEffectivelyPrivateDeclaration;
            }
            if ((n2 & 4) != 0) {
                irFunction = inlineFunctionInfo.inlineFunction;
            }
            if ((n2 & 8) != 0) {
                list = inlineFunctionInfo.inliningPath;
            }
            return inlineFunctionInfo.copy(irFile, bl, irFunction, list);
        }

        @NotNull
        public String toString() {
            return "InlineFunctionInfo(file=" + this.file + ", insideEffectivelyPrivateDeclaration=" + this.insideEffectivelyPrivateDeclaration + ", inlineFunction=" + this.inlineFunction + ", inliningPath=" + this.inliningPath + ')';
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.insideEffectivelyPrivateDeclaration);
            result2 = result2 * 31 + (this.inlineFunction == null ? 0 : this.inlineFunction.hashCode());
            result2 = result2 * 31 + ((Object)this.inliningPath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlineFunctionInfo)) {
                return false;
            }
            InlineFunctionInfo inlineFunctionInfo = (InlineFunctionInfo)other;
            if (!Intrinsics.areEqual(this.file, inlineFunctionInfo.file)) {
                return false;
            }
            if (this.insideEffectivelyPrivateDeclaration != inlineFunctionInfo.insideEffectivelyPrivateDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual(this.inlineFunction, inlineFunctionInfo.inlineFunction)) {
                return false;
            }
            return Intrinsics.areEqual(this.inliningPath, inlineFunctionInfo.inliningPath);
        }
    }
}

