/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.fir;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.fir.KtSourceFileDiagnosticPos;
import org.jetbrains.kotlin.cli.common.fir.SequentialFilePositionFinder;
import org.jetbrains.kotlin.cli.common.fir.SequentialPositionFinder;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticRangeUtils;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithSource;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithoutSource;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J*\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter;", "", "<init>", "()V", "reportToMessageCollector", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "renderDiagnosticName", "throwFirstErrorAsException", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "reportByFile", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "", "reportDiagnosticToMessageCollector", "diagnostic", "location", "reporter", "throwErrorDiagnosticAsException", "InFileDiagnosticsComparator", "cli"})
@SourceDebugExtension(value={"SMAP\nFirDiagnosticsCompilerResultsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDiagnosticsCompilerResultsReporter.kt\norg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1761#2,3:250\n1761#2,3:253\n1761#2,3:256\n1285#2,2:259\n1299#2,4:261\n1#3:265\n*S KotlinDebug\n*F\n+ 1 FirDiagnosticsCompilerResultsReporter.kt\norg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter\n*L\n27#1:250,3\n28#1:253,3\n29#1:256,3\n67#1:259,2\n67#1:261,4\n*E\n"})
public final class FirDiagnosticsCompilerResultsReporter {
    @NotNull
    public static final FirDiagnosticsCompilerResultsReporter INSTANCE = new FirDiagnosticsCompilerResultsReporter();

    private FirDiagnosticsCompilerResultsReporter() {
    }

    public final boolean reportToMessageCollector(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageCollector messageCollector, boolean renderDiagnosticName) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        AnalyzerWithCompilerReport.Companion companion;
        boolean bl4;
        block11: {
            boolean bl5;
            KtDiagnostic it;
            Iterable $this$any$iv;
            boolean $i$f$any;
            block10: {
                boolean bl6;
                block9: {
                    Intrinsics.checkNotNullParameter(diagnosticsCollector, "diagnosticsCollector");
                    Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
                    boolean it2 = bl4 = this.reportByFile(diagnosticsCollector, (arg_0, arg_1) -> FirDiagnosticsCompilerResultsReporter.reportToMessageCollector$lambda$0(messageCollector, renderDiagnosticName, arg_0, arg_1));
                    boolean bl7 = false;
                    Iterable iterable = diagnosticsCollector.getDiagnostics();
                    companion = AnalyzerWithCompilerReport.Companion;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KtDiagnostic)element$iv;
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual(it.getFactory(), FirErrors.INSTANCE.getINCOMPATIBLE_CLASS())) continue;
                            bl6 = true;
                            break block9;
                        }
                        bl6 = false;
                    }
                }
                bl3 = bl6;
                $this$any$iv = diagnosticsCollector.getDiagnostics();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KtDiagnostic)element$iv;
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), FirErrors.INSTANCE.getPRE_RELEASE_CLASS())) continue;
                        bl5 = true;
                        break block10;
                    }
                    bl5 = false;
                }
            }
            bl2 = bl5;
            $this$any$iv = diagnosticsCollector.getDiagnostics();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KtDiagnostic)element$iv;
                    boolean bl10 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), FirErrors.INSTANCE.getIR_WITH_UNSTABLE_ABI_COMPILED_CLASS())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean bl11 = bl;
        companion.reportSpecialErrors(bl3, bl2, bl11, messageCollector);
        return bl4;
    }

    public final boolean throwFirstErrorAsException(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter(diagnosticsCollector, "diagnosticsCollector");
        Intrinsics.checkNotNullParameter(messageRenderer, "messageRenderer");
        return this.reportByFile(diagnosticsCollector, (arg_0, arg_1) -> FirDiagnosticsCompilerResultsReporter.throwFirstErrorAsException$lambda$0(messageRenderer, arg_0, arg_1));
    }

    public static /* synthetic */ boolean throwFirstErrorAsException$default(FirDiagnosticsCompilerResultsReporter firDiagnosticsCompilerResultsReporter, BaseDiagnosticsCollector baseDiagnosticsCollector, MessageRenderer messageRenderer, int n2, Object object) {
        if ((n2 & 2) != 0) {
            MessageRenderer messageRenderer2 = MessageRenderer.PLAIN_RELATIVE_PATHS;
            Intrinsics.checkNotNullExpressionValue(messageRenderer2, "PLAIN_RELATIVE_PATHS");
            messageRenderer = messageRenderer2;
        }
        return firDiagnosticsCompilerResultsReporter.throwFirstErrorAsException(baseDiagnosticsCollector, messageRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean reportByFile(BaseDiagnosticsCollector diagnosticsCollector, Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit> report2) {
        boolean hasErrors = false;
        for (String filePath : diagnosticsCollector.getDiagnosticsByFilePath().keySet()) {
            Lazy<SequentialFilePositionFinder> positionFinder = LazyKt.lazy(() -> FirDiagnosticsCompilerResultsReporter.reportByFile$lambda$0(filePath));
            try {
                Map map2;
                List<KtDiagnostic> diagnosticList;
                List<KtDiagnostic> list = diagnosticsCollector.getDiagnosticsByFilePath().get(filePath);
                if (list == null) {
                    list = diagnosticList = CollectionsKt.emptyList();
                }
                if (positionFinder.getValue() != null) {
                    void $this$associateWithTo$iv$iv;
                    TreeSet<Integer> treeSet;
                    boolean bl = false;
                    TreeSet<Integer> $this$reportByFile_u24lambda_u241_u240 = treeSet = new TreeSet<Integer>();
                    boolean bl2 = false;
                    for (KtDiagnostic diagnostic : diagnosticList) {
                        if (!(diagnostic instanceof KtDiagnosticWithSource) || diagnostic instanceof KtPsiDiagnostic) continue;
                        TextRange range = ((KtDiagnosticWithSource)diagnostic).getFirstRange();
                        $this$reportByFile_u24lambda_u241_u240.add(range.getStartOffset());
                        $this$reportByFile_u24lambda_u241_u240.add(range.getEndOffset());
                    }
                    TreeSet<Integer> sortedOffsets = treeSet;
                    Iterable $this$associateWith$iv = sortedOffsets;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    Iterable iterable = $this$associateWith$iv;
                    Map destination$iv$iv = result$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        void it;
                        SequentialFilePositionFinder finder;
                        int n2 = ((Number)element$iv$iv).intValue();
                        Object t2 = element$iv$iv;
                        Map map3 = destination$iv$iv;
                        boolean bl3 = false;
                        KtSourceFileDiagnosticPos ktSourceFileDiagnosticPos = SequentialPositionFinder.findNextPosition$default(finder, (int)it, false, 2, null);
                        map3.put(t2, ktSourceFileDiagnosticPos);
                    }
                    map2 = destination$iv$iv;
                } else {
                    map2 = null;
                }
                Map offsetsToPositions = map2;
                for (KtDiagnostic diagnostic : CollectionsKt.sortedWith((Iterable)diagnosticList, InFileDiagnosticsComparator.INSTANCE)) {
                    CompilerMessageSourceLocation compilerMessageSourceLocation;
                    KtDiagnostic ktDiagnostic = diagnostic;
                    if (ktDiagnostic instanceof KtDiagnosticWithoutSource) {
                        compilerMessageSourceLocation = null;
                    } else if (ktDiagnostic instanceof KtDiagnosticWithSource) {
                        if ((KtDiagnosticWithSource)diagnostic instanceof KtPsiDiagnostic) {
                            PsiFile file = ((KtPsiDiagnostic)((Object)diagnostic)).getElement().getPsi().getContainingFile();
                            compilerMessageSourceLocation = MessageUtil.psiFileToMessageLocation(file, file.getName(), DiagnosticUtils.getLineAndColumnRange(file, ((KtDiagnosticWithSource)diagnostic).getTextRanges()));
                        } else {
                            CompilerMessageLocationWithRange compilerMessageLocationWithRange;
                            if (offsetsToPositions != null) {
                                boolean bl = false;
                                TextRange range = ((KtDiagnosticWithSource)diagnostic).getFirstRange();
                                Object v2 = offsetsToPositions.get(range.getStartOffset());
                                Intrinsics.checkNotNull(v2);
                                KtSourceFileDiagnosticPos start = (KtSourceFileDiagnosticPos)v2;
                                Object v3 = offsetsToPositions.get(range.getEndOffset());
                                Intrinsics.checkNotNull(v3);
                                KtSourceFileDiagnosticPos end = (KtSourceFileDiagnosticPos)v3;
                                compilerMessageLocationWithRange = MessageUtil.createMessageLocation(filePath, start.getLineContent(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
                            } else {
                                compilerMessageLocationWithRange = null;
                            }
                            compilerMessageSourceLocation = compilerMessageLocationWithRange;
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    CompilerMessageSourceLocation location = compilerMessageSourceLocation;
                    report2.invoke(diagnostic, location);
                    hasErrors = hasErrors || diagnostic.getSeverity() == Severity.ERROR;
                }
            }
            finally {
                if (!positionFinder.isInitialized()) continue;
                SequentialFilePositionFinder sequentialFilePositionFinder = positionFinder.getValue();
                if (sequentialFilePositionFinder == null) continue;
                sequentialFilePositionFinder.close();
            }
        }
        return hasErrors;
    }

    private final void reportDiagnosticToMessageCollector(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageCollector reporter, boolean renderDiagnosticName) {
        String string;
        CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
        String message2 = diagnostic.renderMessage();
        boolean bl = renderDiagnosticName;
        if (bl) {
            string = '[' + diagnostic.getFactoryName() + "] " + message2;
        } else if (!bl) {
            string = message2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String textToRender = string;
        reporter.report(severity, textToRender, location);
    }

    private final void throwErrorDiagnosticAsException(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageRenderer messageRenderer) {
        if (diagnostic.getSeverity() == Severity.ERROR) {
            CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
            String message2 = diagnostic.renderMessage();
            String diagnosticText = messageRenderer.render(severity, message2, location);
            throw new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText);
        }
    }

    private static final Unit reportToMessageCollector$lambda$0(MessageCollector $messageCollector, boolean $renderDiagnosticName, KtDiagnostic diagnostic, CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        INSTANCE.reportDiagnosticToMessageCollector(diagnostic, location, $messageCollector, $renderDiagnosticName);
        return Unit.INSTANCE;
    }

    private static final Unit throwFirstErrorAsException$lambda$0(MessageRenderer $messageRenderer, KtDiagnostic diagnostic, CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        INSTANCE.throwErrorDiagnosticAsException(diagnostic, location, $messageRenderer);
        return Unit.INSTANCE;
    }

    private static final SequentialFilePositionFinder reportByFile$lambda$0(String $filePath) {
        File file;
        String string = $filePath;
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            file = new File(p0);
        } else {
            file = null;
        }
        File file2 = file;
        return file2 != null && file2.isFile() ? new SequentialFilePositionFinder(file2) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$InFileDiagnosticsComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "<init>", "()V", "compare", "", "o1", "o2", "cli"})
    private static final class InFileDiagnosticsComparator
    implements Comparator<KtDiagnostic> {
        @NotNull
        public static final InFileDiagnosticsComparator INSTANCE = new InFileDiagnosticsComparator();

        private InFileDiagnosticsComparator() {
        }

        @Override
        public int compare(@NotNull KtDiagnostic o1, @NotNull KtDiagnostic o2) {
            Intrinsics.checkNotNullParameter(o1, "o1");
            Intrinsics.checkNotNullParameter(o2, "o2");
            TextRange range1 = o1.getFirstRange();
            TextRange range2 = o2.getFirstRange();
            return !Intrinsics.areEqual(range1, range2) ? DiagnosticRangeUtils.TEXT_RANGE_COMPARATOR.compare(range1, range2) : o1.getFactory().getName().compareTo(o2.getFactory().getName());
        }
    }
}

