/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.SyntaxTreeBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicReferenceParser;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

@ApiStatus.Experimental
public class BasicDeclarationParser {
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.LPARENTH);
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW);
    private static final TokenSet METHOD_PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW, JavaTokenType.SEMICOLON);
    private final TokenSet TYPE_START;
    private final TokenSet RESOURCE_EXPRESSIONS;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicDeclarationParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicDeclarationParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.TYPE_START = TokenSet.orSet(BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT, JavaTokenType.VAR_KEYWORD));
        this.RESOURCE_EXPRESSIONS = TokenSet.create(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION, this.myJavaElementTypeContainer.THIS_EXPRESSION, this.myJavaElementTypeContainer.METHOD_CALL_EXPRESSION, this.myJavaElementTypeContainer.NEW_EXPRESSION);
    }

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = BasicJavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration, boolean isAnnotation, BaseContext context2) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        boolean isRecord = BasicDeclarationParser.isRecordToken(builder, keywordTokenType);
        if (isRecord) {
            if (builder.lookAhead(1) != JavaTokenType.IDENTIFIER) {
                declaration.drop();
                return null;
            }
            IElementType afterIdent = builder.lookAhead(2);
            if (context2 == BaseContext.CODE_BLOCK && afterIdent != JavaTokenType.LPARENTH && afterIdent != JavaTokenType.LT) {
                PsiBuilderUtil.advance(builder, 2);
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lt.or.lparen", new Object[0]));
                declaration.drop();
                return null;
            }
            builder.remapCurrentToken(JavaTokenType.RECORD_KEYWORD);
            keywordTokenType = JavaTokenType.RECORD_KEYWORD;
        }
        assert (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        BasicReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder);
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseElementList(builder, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, this.myJavaElementTypeContainer.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, this.myJavaElementTypeContainer.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "permits".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.PERMITS_KEYWORD);
        }
        if (builder.getTokenType() == JavaTokenType.PERMITS_KEYWORD) {
            refParser.parseReferenceList(builder, JavaTokenType.PERMITS_KEYWORD, this.myJavaElementTypeContainer.PERMITS_LIST, JavaTokenType.COMMA);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS, this.myWhiteSpaceAndCommentSetHolder);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        boolean first2 = true;
        while (builder.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null && builder.getTokenType() == JavaTokenType.COMMA && first2 && (next = builder.lookAhead(1)) != JavaTokenType.SEMICOLON && next != JavaTokenType.RBRACE) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            first2 = false;
            int commaCount = 0;
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                if (commaCount > 0) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                builder.advanceLexer();
                ++commaCount;
            }
            if (commaCount != 0 || builder.getTokenType() == null || builder.getTokenType() == JavaTokenType.SEMICOLON) continue;
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder);
            } else {
                BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                BasicJavaParserUtil.done(constantInit, this.myJavaElementTypeContainer.ENUM_CONSTANT_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            }
            BasicJavaParserUtil.done(constant, this.myJavaElementTypeContainer.ENUM_CONSTANT, this.myWhiteSpaceAndCommentSetHolder);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        BaseContext context2 = isAnnotation ? BaseContext.ANNOTATION_INTERFACE : BaseContext.CLASS;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, context2);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder, BaseContext context2) {
        IElementType tokenType;
        if (builder == null) {
            BasicDeclarationParser.$$$reportNull$$$0(1);
        }
        if ((tokenType = builder.getTokenType()) == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context2 == BaseContext.FILE || context2 == BaseContext.CODE_BLOCK) {
                return null;
            }
        } else if (!(BasicDeclarationParser.isRecordToken(builder, tokenType) || BasicDeclarationParser.isSealedToken(builder, tokenType) || BasicDeclarationParser.isNonSealedToken(builder, tokenType) || this.TYPE_START.contains(tokenType) && tokenType != JavaTokenType.AT)) {
            if (tokenType instanceof ILazyParseableElementType) {
                builder.advanceLexer();
                return null;
            }
            if (!(BasicElementTypes.BASIC_MODIFIER_BIT_SET.contains(tokenType) || BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context2 != BaseContext.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect(builder, JavaTokenType.AT)) {
            if (builder.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result2 = this.parseClassFromKeyword(builder, declaration, true, context2);
                return result2 != null ? result2 : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType()) || BasicDeclarationParser.isRecordToken(builder, builder.getTokenType())) {
            PsiBuilder.Marker result3 = this.parseClassFromKeyword(builder, declaration, false, context2);
            return result3 != null ? result3 : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == JavaTokenType.LT && context2 != BaseContext.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder);
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            if (context2 == BaseContext.CODE_BLOCK) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier.or.type", new Object[0]), null);
                declaration.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder);
            assert (codeBlock != null) : builder.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), codeBlock);
            }
            BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            return declaration;
        }
        BasicReferenceParser.TypeInfo type2 = null;
        if (this.TYPE_START.contains(builder.getTokenType())) {
            PsiBuilder.Marker pos = builder.mark();
            int flags = 5;
            if (context2 == BaseContext.CODE_BLOCK) {
                flags |= 0x80;
            }
            if ((type2 = this.myParser.getReferenceParser().parseTypeInfo(builder, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder.getTokenType() == JavaTokenType.LPARENTH || builder.getTokenType() == JavaTokenType.LBRACE) {
                    if (context2 == BaseContext.CODE_BLOCK) {
                        declaration.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder);
                    if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder.mark();
                        builder.advanceLexer();
                        primitive.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder, declaration, false, true);
                    }
                    if (builder.getTokenType() == JavaTokenType.LBRACE) {
                        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.THROWS_LIST);
                        return this.parseMethodBody(builder, declaration, false);
                    }
                    declaration.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type2 == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaPsiBundle.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (context2 != BaseContext.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type2.isPrimitive && builder.getTokenType() != JavaTokenType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
                }
                builder.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration.drop();
                return modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (builder.getTokenType() == JavaTokenType.LPARENTH && (context2 == BaseContext.CLASS || context2 == BaseContext.ANNOTATION_INTERFACE || context2 == BaseContext.FILE)) {
            if (typeParams == null) {
                BasicJavaParserUtil.emptyElement(type2.marker, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration, context2 == BaseContext.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
        }
        return this.parseFieldOrLocalVariable(builder, declaration, declarationStart, context2);
    }

    static boolean isRecordToken(PsiBuilder builder, IElementType tokenType) {
        if (tokenType == JavaTokenType.IDENTIFIER && "record".equals(builder.getTokenText()) && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            LanguageLevel level = BasicJavaParserUtil.getLanguageLevel(builder);
            return JavaFeature.RECORDS.isSufficient(level);
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder, IElementType tokenType) {
        return JavaFeature.SEALED_CLASSES.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder)) && tokenType == JavaTokenType.IDENTIFIER && "sealed".equals(builder.getTokenText());
    }

    static boolean isNonSealedToken(PsiBuilder builder, IElementType tokenType) {
        if (!JavaFeature.SEALED_CLASSES.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder)) || tokenType != JavaTokenType.IDENTIFIER || !"non".equals(builder.getTokenText()) || builder.lookAhead(1) != JavaTokenType.MINUS || builder.lookAhead(2) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder.mark();
        PsiBuilderUtil.advance(builder, 2);
        boolean isNonSealed = "sealed".equals(builder.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder, BasicElementTypes.BASIC_MODIFIER_BIT_SET);
        if (pair == null) {
            BasicDeclarationParser.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (BasicDeclarationParser.isSealedToken(builder, tokenType)) {
                builder.remapCurrentToken(JavaTokenType.SEALED_KEYWORD);
                tokenType = JavaTokenType.SEALED_KEYWORD;
            }
            if (BasicDeclarationParser.isNonSealedToken(builder, tokenType)) {
                PsiBuilder.Marker nonSealed = builder.mark();
                PsiBuilderUtil.advance(builder, 3);
                nonSealed.collapse(JavaTokenType.NON_SEALED_KEYWORD);
                isEmpty = false;
                continue;
            }
            if (modifiers.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || BasicElementTypes.BASIC_KEYWORD_BIT_SET.contains(builder.lookAhead(1))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(modList, isEmpty);
        if (pair == null) {
            BasicDeclarationParser.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        this.parseParameterList(builder);
        this.eatBrackets(builder, constructor ? "expected.lbrace" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, this.myJavaElementTypeContainer.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect(builder, JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder);
        }
        return this.parseMethodBody(builder, declaration, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text = builder.getOriginalText();
            block0: do {
                for (int i2 = builder.getCurrentOffset() - 1; i2 >= 0; --i2) {
                    char ch = text.charAt(i2);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect(builder, APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON) && builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        }
        BasicJavaParserUtil.done(declaration, anno ? this.myJavaElementTypeContainer.ANNOTATION_METHOD : this.myJavaElementTypeContainer.METHOD, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = declaration;
        if (marker == null) {
            BasicDeclarationParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    public void parseParameterList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder, boolean typed) {
        this.parseElementList(builder, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder, ListType type2) {
        boolean lambda = type2 == ListType.LAMBDA_TYPED || type2 == ListType.LAMBDA_UNTYPED;
        boolean resources = type2 == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder.mark();
        boolean leftParenth = PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH);
        assert (lambda || leftParenth) : builder.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        SyntaxTreeBuilder.Marker invalidElements = null;
        String errorMessage2 = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || type2.getStopperTypes().contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda ? "expected.parameter" : "expected.identifier.or.type";
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage2);
                }
                invalidElements = null;
                if (!leftParenth) break;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type2 == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder, true, false, false, false) : (resources ? this.parseResource(builder) : (lambda ? this.parseLambdaParameter(builder, type2 == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage2, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message(noElementMsg, new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage2 = JavaPsiBundle.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage2);
        }
        BasicJavaParserUtil.done(elementList, type2.getNodeType(this.myJavaElementTypeContainer), this.myWhiteSpaceAndCommentSetHolder);
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder, true, typeFlags, isParameter ? this.myJavaElementTypeContainer.PARAMETER : this.myJavaElementTypeContainer.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null && this.RESOURCE_EXPRESSIONS.contains(BasicJavaParserUtil.exprType(expr)) && builder.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(this.myJavaElementTypeContainer.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder, true, 128, this.myJavaElementTypeContainer.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder, boolean typed) {
        int flags = 2;
        if (JavaFeature.VAR_LAMBDA_PARAMETER.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder))) {
            flags |= 0x80;
        }
        return this.parseListElement(builder, typed, flags, this.myJavaElementTypeContainer.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean typed, int typeFlags, IElementType type2) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        if (typed) {
            int flags = 5 | typeFlags;
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.TYPE);
            }
        }
        if (typed && ((tokenType = builder.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
            if (expr != null && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.THIS_EXPRESSION) {
                mark.drop();
                BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RECEIVER_PARAMETER, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (type2 == this.myJavaElementTypeContainer.PARAMETER || type2 == this.myJavaElementTypeContainer.RECORD_COMPONENT) {
                this.eatBrackets(builder, null);
                BasicJavaParserUtil.done(param, type2, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (BasicJavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RESOURCE_VARIABLE, this.myWhiteSpaceAndCommentSetHolder);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration, int declarationStart, BaseContext context2) {
        boolean shouldRollback;
        IElementType varType;
        if (context2 == BaseContext.CLASS || context2 == BaseContext.ANNOTATION_INTERFACE || context2 == BaseContext.FILE) {
            varType = this.myJavaElementTypeContainer.FIELD;
        } else if (context2 == BaseContext.CODE_BLOCK) {
            varType = this.myJavaElementTypeContainer.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context2);
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != JavaTokenType.COMMA) break;
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
            builder.advanceLexer();
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward(text, spaceEnd - 1, "\n\r \t");
                int lineStart = CharArrayUtil.shiftBackwardUntil(text, spaceEnd, "\n\r");
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward(text, lineStart, "\n\r \t");
                    declaration.rollbackTo();
                    return this.parse(BasicJavaParserUtil.stoppingBuilder(builder, newBufferEnd), context2);
                }
            }
            if (!unclosed) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
        }
        return declaration;
    }

    private boolean eatBrackets(PsiBuilder builder, @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") String errorKey) {
        boolean paired;
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        int count2 = 0;
        while (true) {
            this.parseAnnotations(builder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) break;
            ++count2;
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) break;
            ++count2;
        }
        if (count2 == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count2 % 2 == 0;
        if (!paired) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        }
        if (classRef == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        BasicJavaParserUtil.done(anno, this.myJavaElementTypeContainer.ANNOTATION, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            BasicDeclarationParser.$$$reportNull$$$0(5);
        }
        return marker;
    }

    private void parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder.mark();
                PsiBuilder.Marker errorEnd = builder.mark();
                builder.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaPsiBundle.message("annotation.name.is.missing", new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                builder.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder, false);
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
    }

    private boolean parseAnnotationParameter(PsiBuilder builder, boolean mayBeSimple) {
        PsiBuilder.Marker pair = builder.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder);
            if (builder.getTokenType() != JavaTokenType.EQ) {
                BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
                return false;
            }
            pair.rollbackTo();
            pair = builder.mark();
        }
        boolean hasName = BasicJavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier");
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder);
        BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
        return hasName;
    }

    public void parseAnnotationValue(PsiBuilder builder) {
        PsiBuilder.Marker result2 = this.doParseAnnotationValue(builder);
        if (result2 == null) {
            result2 = builder.mark();
            result2.error(JavaPsiBundle.message("expected.value", new Object[0]));
        }
    }

    @Nullable
    private PsiBuilder.Marker doParseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        PsiBuilder.Marker result2 = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder) : (tokenType == JavaTokenType.LBRACE ? this.myParser.getExpressionParser().parseArrayInitializer(builder, this.myJavaElementTypeContainer.ANNOTATION_ARRAY_INITIALIZER, this::doParseAnnotationValue, "expected.value") : this.myParser.getExpressionParser().parseConditional(builder));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicDeclarationParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicDeclarationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BaseContext {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType(AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer javaElementTypeContainer) {
            if (this == RESOURCE) {
                return javaElementTypeContainer.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return javaElementTypeContainer.RECORD_HEADER;
            }
            return javaElementTypeContainer.PARAMETER_LIST;
        }

        TokenSet getStopperTypes() {
            if (this == METHOD) {
                return METHOD_PARAM_LIST_STOPPERS;
            }
            return PARAM_LIST_STOPPERS;
        }
    }
}

