/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorFilter;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorProcessingKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ProcessResult;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerLevelProcessor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirActualizingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultStarImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0017\u001a\u00020\u000bJ\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u000b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J$\u0010\u001f\u001a\u00020 2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ScopeBasedTowerLevel;", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevel;", "Lorg/jetbrains/kotlin/fir/SessionHolder;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "givenScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "givenExtensionReceiverOptions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "withHideMembersOnly", "", "constructorFilter", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConstructorFilter;", "dispatchReceiverForStatics", "Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Ljava/util/List;ZLorg/jetbrains/kotlin/fir/resolve/calls/ConstructorFilter;Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "scope", "areThereExtensionReceiverOptions", "dispatchReceiverValue", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "candidate", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "shouldSkipCandidateWithInconsistentExtensionReceiver", "consumeCallableCandidate", "", "processor", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelProcessor;", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "info", "processPropertiesByName", "processObjectsByName", "resolve"})
@SourceDebugExtension(value={"SMAP\nTowerLevels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerLevels.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/ScopeBasedTowerLevel\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirScope.kt\norg/jetbrains/kotlin/fir/scopes/FirScopeKt\n*L\n1#1,517:1\n24#2:518\n11561#3:519\n11896#3,3:520\n37#4,2:523\n2746#5,3:525\n124#6,2:528\n*S KotlinDebug\n*F\n+ 1 TowerLevels.kt\norg/jetbrains/kotlin/fir/resolve/calls/tower/ScopeBasedTowerLevel\n*L\n403#1:518\n416#1:519\n416#1:520,3\n416#1:523,2\n420#1:525,3\n501#1:528,2\n*E\n"})
public final class ScopeBasedTowerLevel
extends TowerLevel
implements SessionHolder {
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private final List<FirExpression> givenExtensionReceiverOptions;
    private final boolean withHideMembersOnly;
    @NotNull
    private final ConstructorFilter constructorFilter;
    @Nullable
    private final ExpressionReceiverValue dispatchReceiverForStatics;
    @NotNull
    private final FirScope scope;

    public ScopeBasedTowerLevel(@NotNull BodyResolveComponents bodyResolveComponents, @NotNull FirScope givenScope, @NotNull List<? extends FirExpression> givenExtensionReceiverOptions, boolean withHideMembersOnly, @NotNull ConstructorFilter constructorFilter, @Nullable ExpressionReceiverValue dispatchReceiverForStatics) {
        Intrinsics.checkNotNullParameter(bodyResolveComponents, "bodyResolveComponents");
        Intrinsics.checkNotNullParameter(givenScope, "givenScope");
        Intrinsics.checkNotNullParameter(givenExtensionReceiverOptions, "givenExtensionReceiverOptions");
        Intrinsics.checkNotNullParameter((Object)constructorFilter, "constructorFilter");
        this.bodyResolveComponents = bodyResolveComponents;
        this.givenExtensionReceiverOptions = givenExtensionReceiverOptions;
        this.withHideMembersOnly = withHideMembersOnly;
        this.constructorFilter = constructorFilter;
        this.dispatchReceiverForStatics = dispatchReceiverForStatics;
        this.scope = LanguageVersionUtilsKt.isEnabled(this, LanguageFeature.MultiPlatformProjects) ? (FirScope)new FirActualizingScope(givenScope) : givenScope;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.bodyResolveComponents.getSession();
    }

    public final boolean areThereExtensionReceiverOptions() {
        return !((Collection)this.givenExtensionReceiverOptions).isEmpty();
    }

    private final ReceiverValue dispatchReceiverValue(FirCallableSymbol<?> candidate2, CallInfo callInfo) {
        ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData((FirCallableDeclaration)candidate2.getFir());
        if (importedFromObjectOrStaticData != null) {
            ImportedFromObjectOrStaticData<FirCallableDeclaration> data2 = importedFromObjectOrStaticData;
            boolean bl = false;
            ClassId objectClassId = data2.getObjectClassId();
            FirClassLikeSymbol<?> symbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(objectClassId);
            if (symbol instanceof FirRegularClassSymbol) {
                KtSourceElement ktSourceElement = callInfo.getCallSite().getSource();
                return new ExpressionReceiverValue(ResolveUtilsKt.toImplicitResolvedQualifierReceiver((FirRegularClassSymbol)symbol, this.bodyResolveComponents, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ImplicitReceiver.INSTANCE, 0, 0, 6, null) : null));
            }
        }
        if (candidate2 instanceof FirBackingFieldSymbol) {
            ConeClassLikeLookupTag lookupTag = ClassMembersKt.dispatchReceiverClassLookupTagOrNull(((FirBackingField)((FirBackingFieldSymbol)candidate2).getFir()).getPropertySymbol());
            return lookupTag != null ? (ReceiverValue)this.bodyResolveComponents.getImplicitValueStorage().lastDispatchReceiver(arg_0 -> ScopeBasedTowerLevel.dispatchReceiverValue$lambda$1(this, lookupTag, arg_0)) : null;
        }
        FirCallableSymbol<?> $this$isStatic$iv = candidate2;
        boolean $i$f$isStatic = false;
        if ($this$isStatic$iv.getRawStatus().isStatic()) {
            return this.dispatchReceiverForStatics;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldSkipCandidateWithInconsistentExtensionReceiver(FirCallableSymbol<?> candidate2) {
        boolean bl;
        block6: {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            if (!(this.scope instanceof FirDefaultStarImportingScope) || !this.areThereExtensionReceiverOptions()) {
                return false;
            }
            ConeTypeProjection[] coneTypeProjectionArray = candidate2.getResolvedReceiverType();
            ConeClassLikeType coneClassLikeType = coneTypeProjectionArray instanceof ConeClassLikeType ? (ConeClassLikeType)coneTypeProjectionArray : null;
            if (coneClassLikeType == null) {
                return false;
            }
            ConeClassLikeType declarationReceiverType = coneClassLikeType;
            coneTypeProjectionArray = declarationReceiverType.getTypeArguments();
            ConeClassLikeLookupTag coneClassLikeLookupTag = declarationReceiverType.getLookupTag();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                void item$iv$iv;
                void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i2];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ConeStarProjection.INSTANCE);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ConeClassLikeType startProjectedDeclarationReceiverType = TypeConstructionUtilsKt.constructClassType$default(coneClassLikeLookupTag, thisCollection$iv.toArray(new ConeStarProjection[0]), true, null, 4, null);
            Iterable $this$none$iv = this.givenExtensionReceiverOptions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirExpression extensionReceiver = (FirExpression)element$iv;
                    boolean bl3 = false;
                    ConeKotlinType extensionReceiverType = FirTypeUtilsKt.getResolvedType(extensionReceiver);
                    boolean bl4 = !(extensionReceiverType instanceof ConeClassLikeType) ? true : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(this.getSession()), (KotlinTypeMarker)extensionReceiverType, (KotlinTypeMarker)startProjectedDeclarationReceiverType, false, 8, null);
                    if (!bl4) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void consumeCallableCandidate(FirCallableSymbol<?> candidate2, CallInfo callInfo, TowerLevelProcessor processor) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)candidate2, FirResolvePhase.TYPES);
        if (this.withHideMembersOnly && !FirAnnotationUtilsKt.hasAnnotationWithClassId((FirBasedSymbol)candidate2, StandardClassIds.Annotations.INSTANCE.getHidesMembers(), this.getSession())) {
            return;
        }
        boolean receiverExpected = this.withHideMembersOnly || this.areThereExtensionReceiverOptions();
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)candidate2.getFir()).getReceiverParameter();
        FirTypeRef candidateReceiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (candidateReceiverTypeRef == null == receiverExpected) {
            return;
        }
        ReceiverValue dispatchReceiverValue = this.dispatchReceiverValue(candidate2, callInfo);
        if (dispatchReceiverValue == null && this.shouldSkipCandidateWithInconsistentExtensionReceiver(candidate2)) {
            return;
        }
        Object object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData((FirCallableDeclaration)candidate2.getFir());
        if (object == null || (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) == null || (object = ((FirCallableDeclaration)object).getSymbol()) == null) {
            object = candidate2;
        }
        FirCallableSymbol<?> unwrappedCandidate = object;
        ReceiverValue receiverValue = dispatchReceiverValue;
        TowerLevelProcessor.consumeCandidate$default(processor, unwrappedCandidate, receiverValue != null ? receiverValue.getReceiverExpression() : null, this.givenExtensionReceiverOptions, this.scope, false, false, 48, null);
    }

    @Override
    @NotNull
    public ProcessResult processFunctionsByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        ConstructorProcessingKt.processFunctionsAndConstructorsByName(this.scope, info, this.getSession(), this.bodyResolveComponents, this.constructorFilter, arg_0 -> ScopeBasedTowerLevel.processFunctionsByName$lambda$0(lookupTracker, info, empty2, this, processor, arg_0));
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    @Override
    @NotNull
    public ProcessResult processPropertiesByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        this.scope.processPropertiesByName(info.getName(), arg_0 -> ScopeBasedTowerLevel.processPropertiesByName$lambda$0(lookupTracker, info, empty2, this, processor, arg_0));
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProcessResult processObjectsByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        void name$iv;
        void $this$processClassifiersByName$iv;
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        FirScope firScope = this.scope;
        Name name2 = info.getName();
        Function1<FirClassifierSymbol, Unit> processor$iv = arg_0 -> ScopeBasedTowerLevel.processObjectsByName$lambda$0(empty2, processor, this, arg_0);
        boolean $i$f$processClassifiersByName = false;
        $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
            final /* synthetic */ Function1 $processor;
            {
                this.$processor = $processor;
            }

            public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                Intrinsics.checkNotNullParameter(symbol, "symbol");
                Intrinsics.checkNotNullParameter(coneSubstitutor, "<unused var>");
                this.$processor.invoke(symbol);
            }
        });
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    private static final boolean dispatchReceiverValue$lambda$1(ScopeBasedTowerLevel this$0, ConeClassLikeLookupTag $lookupTag, ImplicitReceiverValue implicitReceiverValue) {
        Intrinsics.checkNotNullParameter(implicitReceiverValue, "implicitReceiverValue");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getLookupTagIfAny(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this$0, implicitReceiverValue.getType())), $lookupTag);
    }

    private static final Unit processFunctionsByName$lambda$0(FirLookupTrackerComponent $lookupTracker, CallInfo $info, Ref.BooleanRef $empty, ScopeBasedTowerLevel this$0, TowerLevelProcessor $processor, FirCallableSymbol candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        FirLookupTrackerComponent firLookupTrackerComponent = $lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallableCandidateAsLookup(firLookupTrackerComponent, candidate2, $info.getCallSite().getSource(), $info.getContainingFile().getSource());
        }
        $empty.element = false;
        this$0.consumeCallableCandidate(candidate2, $info, $processor);
        return Unit.INSTANCE;
    }

    private static final Unit processPropertiesByName$lambda$0(FirLookupTrackerComponent $lookupTracker, CallInfo $info, Ref.BooleanRef $empty, ScopeBasedTowerLevel this$0, TowerLevelProcessor $processor, FirVariableSymbol candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        FirLookupTrackerComponent firLookupTrackerComponent = $lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallableCandidateAsLookup(firLookupTrackerComponent, candidate2, $info.getCallSite().getSource(), $info.getContainingFile().getSource());
        }
        $empty.element = false;
        this$0.consumeCallableCandidate(candidate2, $info, $processor);
        return Unit.INSTANCE;
    }

    private static final Unit processObjectsByName$lambda$0(Ref.BooleanRef $empty, TowerLevelProcessor $processor, ScopeBasedTowerLevel this$0, FirClassifierSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $empty.element = false;
        TowerLevelProcessor.consumeCandidate$default($processor, it, null, CollectionsKt.emptyList(), this$0.scope, true, false, 32, null);
        return Unit.INSTANCE;
    }
}

