/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.impl.ClassNodeSnapshotter;
import org.jetbrains.kotlin.incremental.impl.ConstantValueExternalizer;
import org.jetbrains.kotlin.incremental.impl.SelectiveClassVisitor;
import org.jetbrains.kotlin.incremental.impl.UtilsKt;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.inline.InlineFunctionOrAccessor;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import shadow.org.jetbrains.org.objectweb.asm.ClassReader;
import shadow.org.jetbrains.org.objectweb.asm.ClassVisitor;
import shadow.org.jetbrains.org.objectweb.asm.tree.ClassNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.FieldNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/impl/ExtraClassInfoGenerator;", "", "<init>", "()V", "makeClassVisitor", "Lshadow/org/jetbrains/org/objectweb/asm/ClassVisitor;", "classNode", "Lshadow/org/jetbrains/org/objectweb/asm/tree/ClassNode;", "calculateInlineMethodHash", "", "methodSignature", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMemberSignature$Method;", "inlinedClassPrefix", "", "ownMethodHash", "getExtraInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$ExtraInfo;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classContents", "", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nExtraClassInfoGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtraClassInfoGenerator.kt\norg/jetbrains/kotlin/incremental/impl/ExtraClassInfoGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1208#2,2:134\n1236#2,4:136\n1193#2,2:140\n1267#2,4:142\n1193#2,2:146\n1267#2,4:148\n*S KotlinDebug\n*F\n+ 1 ExtraClassInfoGenerator.kt\norg/jetbrains/kotlin/incremental/impl/ExtraClassInfoGenerator\n*L\n43#1:134,2\n43#1:136,4\n81#1:140,2\n81#1:142,4\n106#1:146,2\n106#1:148,4\n*E\n"})
public class ExtraClassInfoGenerator {
    @NotNull
    protected ClassVisitor makeClassVisitor(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter(classNode, "classNode");
        return classNode;
    }

    protected long calculateInlineMethodHash(@NotNull JvmMemberSignature.Method methodSignature, @NotNull String inlinedClassPrefix, long ownMethodHash) {
        Intrinsics.checkNotNullParameter(methodSignature, "methodSignature");
        Intrinsics.checkNotNullParameter(inlinedClassPrefix, "inlinedClassPrefix");
        return ownMethodHash;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinClassInfo.ExtraInfo getExtraInfo(@NotNull KotlinClassHeader classHeader, @NotNull byte[] classContents) {
        void $this$associateTo$iv$iv;
        void $this$associateTo$iv$iv2;
        Iterable it;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(classHeader, "classHeader");
        Intrinsics.checkNotNullParameter(classContents, "classContents");
        Iterable $this$associateBy$iv = InlineUtilKt.inlineFunctionsAndAccessors(classHeader, true);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            InlineFunctionOrAccessor inlineFunctionOrAccessor = (InlineFunctionOrAccessor)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getJvmMethodSignature(), element$iv$iv);
        }
        Map inlineFunctionsAndAccessors = destination$iv$iv;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classContents);
        SelectiveClassVisitor selectiveClassVisitor = new SelectiveClassVisitor(this.makeClassVisitor(classNode), ExtraClassInfoGenerator::getExtraInfo$lambda$1, (arg_0, arg_1) -> ExtraClassInfoGenerator.getExtraInfo$lambda$2(inlineFunctionsAndAccessors, arg_0, arg_1));
        int parsingOptions = !inlineFunctionsAndAccessors.isEmpty() ? 0 : 3;
        classReader.accept(selectiveClassVisitor, parsingOptions);
        ClassNodeSnapshotter.INSTANCE.sortClassMembers(classNode);
        List<MethodNode> list = classNode.methods;
        Intrinsics.checkNotNullExpressionValue(list, "methods");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        it = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map3 = destination$iv$iv2;
            Object methodNode = (MethodNode)element$iv$iv;
            boolean bl = false;
            String string = ((MethodNode)methodNode).name;
            Intrinsics.checkNotNullExpressionValue(string, "name");
            String string2 = ((MethodNode)methodNode).desc;
            Intrinsics.checkNotNullExpressionValue(string2, "desc");
            JvmMemberSignature.Method methodSignature = new JvmMemberSignature.Method(string, string2);
            String innerClassPrefix = classNode.name + '$' + ((MethodNode)methodNode).name;
            Intrinsics.checkNotNull(methodNode);
            long methodHash = ClassNodeSnapshotter.INSTANCE.snapshotMethod((MethodNode)methodNode, classNode.version);
            Object v2 = inlineFunctionsAndAccessors.get(methodSignature);
            Intrinsics.checkNotNull(v2);
            methodNode = TuplesKt.to(v2, this.calculateInlineMethodHash(methodSignature, innerClassPrefix, methodHash));
            map3.put(((Pair)methodNode).getFirst(), ((Pair)methodNode).getSecond());
        }
        Map inlineFunctionOrAccessorSnapshots = destination$iv$iv2;
        Long classSnapshotExcludingMembers = classHeader.getKind() == KotlinClassHeader.Kind.CLASS ? Long.valueOf(ClassNodeSnapshotter.INSTANCE.snapshotClassExcludingMembers(classNode, true, inlineFunctionOrAccessorSnapshots.isEmpty())) : null;
        List<FieldNode> list2 = classNode.fields;
        Intrinsics.checkNotNullExpressionValue(list2, "fields");
        Iterable $this$associate$iv2 = list2;
        boolean $i$f$associate2 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv2, 10)), 16);
        Iterable $i$f$associateTo22 = $this$associate$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map4 = destination$iv$iv3;
            FieldNode fieldNode = (FieldNode)element$iv$iv;
            boolean bl = false;
            String string = fieldNode.name;
            DataExternalizer dataExternalizer = ConstantValueExternalizer.INSTANCE;
            Object object = fieldNode.value;
            Intrinsics.checkNotNull(object);
            Pair<String, Long> pair = TuplesKt.to(string, UtilsKt.hashToLong(ExternalizersKt.toByteArray(dataExternalizer, object)));
            map4.put(pair.getFirst(), pair.getSecond());
        }
        Map constantSnapshots = destination$iv$iv3;
        return new KotlinClassInfo.ExtraInfo(classSnapshotExcludingMembers, constantSnapshots, inlineFunctionOrAccessorSnapshots);
    }

    private static final boolean getExtraInfo$lambda$1(JvmMemberSignature.Field field, boolean isPrivate, boolean isConstant) {
        Intrinsics.checkNotNullParameter(field, "<unused var>");
        return !isPrivate && isConstant;
    }

    private static final boolean getExtraInfo$lambda$2(Map $inlineFunctionsAndAccessors, JvmMemberSignature.Method method, boolean bl) {
        Intrinsics.checkNotNullParameter(method, "method");
        return $inlineFunctionsAndAccessors.keySet().contains(method);
    }
}

