/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u0015J#\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002\u00a2\u0006\u0002\u0010\u0018R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/StronglyConnectedComponents;", "T", "", "enumerateOutgoingEdges", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getEnumerateOutgoingEdges", "()Lkotlin/jvm/functions/Function1;", "visited", "", "stack", "", "reversedGraph", "", "visit", "", "edge", "(Ljava/lang/Object;)V", "findComponents", "", "visitTransposedEdge", "component", "(Ljava/lang/Object;Ljava/util/List;)V", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nStronglyConnectedComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StronglyConnectedComponents.kt\norg/jetbrains/kotlin/backend/wasm/utils/StronglyConnectedComponents\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,52:1\n382#2,7:53\n*S KotlinDebug\n*F\n+ 1 StronglyConnectedComponents.kt\norg/jetbrains/kotlin/backend/wasm/utils/StronglyConnectedComponents\n*L\n19#1:53,7\n*E\n"})
public final class StronglyConnectedComponents<T> {
    @NotNull
    private final Function1<T, Sequence<T>> enumerateOutgoingEdges;
    @NotNull
    private final Set<T> visited;
    @NotNull
    private final List<T> stack;
    @NotNull
    private final Map<T, Set<T>> reversedGraph;

    public StronglyConnectedComponents(@NotNull Function1<? super T, ? extends Sequence<? extends T>> enumerateOutgoingEdges) {
        Intrinsics.checkNotNullParameter(enumerateOutgoingEdges, "enumerateOutgoingEdges");
        this.enumerateOutgoingEdges = enumerateOutgoingEdges;
        this.visited = new LinkedHashSet();
        this.stack = new ArrayList();
        this.reversedGraph = new LinkedHashMap();
    }

    @NotNull
    public final Function1<T, Sequence<T>> getEnumerateOutgoingEdges() {
        return this.enumerateOutgoingEdges;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(T edge) {
        if (this.visited.add(edge)) {
            Iterator<T> iterator2 = this.enumerateOutgoingEdges.invoke(edge).iterator();
            while (iterator2.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                T outgoingEdge = iterator2.next();
                Map<T, Set<T>> map2 = this.reversedGraph;
                T key$iv = outgoingEdge;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(edge);
                this.visit(outgoingEdge);
            }
            UtilsKt.push(this.stack, edge);
        }
    }

    @NotNull
    public final List<List<T>> findComponents() {
        this.visited.clear();
        List result2 = new ArrayList();
        while (!((Collection)this.stack).isEmpty()) {
            T edge = UtilsKt.pop(this.stack);
            if (!this.visited.add(edge)) continue;
            List component = new ArrayList();
            this.visitTransposedEdge(edge, component);
            result2.add(component);
        }
        CollectionsKt.reverse(result2);
        return result2;
    }

    private final void visitTransposedEdge(T edge, List<T> component) {
        component.add(edge);
        Set<T> outgoingEdges = this.reversedGraph.get(edge);
        if (outgoingEdges != null) {
            for (T outgoingEdge : outgoingEdges) {
                if (!this.visited.add(outgoingEdge)) continue;
                this.visitTransposedEdge(outgoingEdge, component);
            }
        }
    }
}

