/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import java.util.concurrent.CancellationException;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.concurrency.ThreadContext;
import org.jetbrains.kotlin.com.intellij.openapi.progress.CeProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return ThreadContext.currentThreadContext().get(Job.Key);
    }

    public static void checkCancelled() {
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive(currentJob);
            }
            catch (CancellationException e2) {
                throw new CeProcessCanceledException(e2);
            }
        }
    }

    public static boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        try {
            if (Cancellation.isInNonCancelableSection()) {
                return computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                T t2 = computable.compute();
                return t2;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e2) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

