/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import shadow.org.jetbrains.org.objectweb.asm.ClassReader;
import shadow.org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create("java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(1);
        }
        this(manager, file, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(3);
        }
        super(manager, file, eventSystemEnabled, JavaLanguage.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        FileIndexFacade fileIndex;
        if (project == null) {
            ClassFileViewProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            ClassFileViewProvider.$$$reportNull$$$0(6);
        }
        if (!(fileIndex = FileIndexFacade.getInstance(project)).isInLibraryClasses(file) && fileIndex.isInSource(file)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file)) {
                return new ClsFileImpl(this);
            }
        }
        catch (Exception e2) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file.getPath(), e2);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file) {
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(7);
        }
        return ClassFileViewProvider.detectInnerClass(file, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            ClassFileViewProvider.$$$reportNull$$$0(8);
        }
        if (content == null) {
            ClassFileViewProvider.$$$reportNull$$$0(9);
        }
        return ClassFileViewProvider.detectInnerClass(file, content);
    }

    private static boolean detectInnerClass(VirtualFile file, byte @Nullable [] content) {
        String name2 = file.getNameWithoutExtension();
        int p2 = name2.lastIndexOf(36, name2.length() - 2);
        if (p2 <= 0) {
            return false;
        }
        Boolean isInner2 = IS_INNER_CLASS.get(file);
        if (isInner2 != null) {
            return isInner2;
        }
        if (content == null) {
            try {
                content = file.contentsToByteArray(false);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref<Boolean> ref = Ref.create(Boolean.FALSE);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(589824){

            @Override
            public void visitOuterClass(String owner, String name2, String desc) {
                ref.set(Boolean.TRUE);
            }

            @Override
            public void visitInnerClass(String name2, String outer, String inner, int access) {
                if (className.equals(name2)) {
                    ref.set(Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner2 = ref.get();
        IS_INNER_CLASS.set(file, isInner2);
        return isInner2;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy2) {
        if (copy2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(10);
        }
        return new ClassFileViewProvider(this.getManager(), copy2, false);
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, this.getBaseLanguage());
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language2) {
        PsiFile file;
        if (language2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(11);
        }
        if ((file = this.getPsi(language2)) instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt(file, offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.findReferenceAt(offset, this.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language2) {
        PsiFile file;
        if (language2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(12);
        }
        if ((file = this.getPsi(language2)) instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt(file, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isInnerClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createCopy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementAt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

