/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.Scope;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDeclarationScope;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"resolveTemporaryNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "resolveNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "liftUsedNames", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/Scope;", "computeScopes", "backend.js"})
@SourceDebugExtension(value={"SMAP\nresolveTemporaryNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1869#3,2:147\n1869#3,2:149\n*S KotlinDebug\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n*L\n51#1:147,2\n62#1:149,2\n*E\n"})
public final class ResolveTemporaryNamesKt {
    public static final void resolveTemporaryNames(@NotNull JsNode $this$resolveTemporaryNames) {
        Intrinsics.checkNotNullParameter($this$resolveTemporaryNames, "<this>");
        Map<JsName, JsName> renamings = ResolveTemporaryNamesKt.resolveNames($this$resolveTemporaryNames);
        $this$resolveTemporaryNames.accept(new RecursiveJsVisitor(renamings){
            final /* synthetic */ Map<JsName, JsName> $renamings;
            {
                this.$renamings = $renamings;
            }

            protected void visitElement(JsNode node) {
                block1: {
                    JsName name2;
                    Intrinsics.checkNotNullParameter(node, "node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name2 = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = this.$renamings.get(name2);
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }
        });
    }

    private static final Map<JsName, JsName> resolveNames(JsNode $this$resolveNames) {
        Scope rootScope = ResolveTemporaryNamesKt.liftUsedNames(ResolveTemporaryNamesKt.computeScopes($this$resolveNames));
        HashMap<JsName, JsName> replacements = new HashMap<JsName, JsName>();
        ResolveTemporaryNamesKt.resolveNames$traverse(replacements, rootScope);
        return replacements;
    }

    private static final Scope liftUsedNames(Scope $this$liftUsedNames) {
        ResolveTemporaryNamesKt.liftUsedNames$traverse($this$liftUsedNames);
        return $this$liftUsedNames;
    }

    private static final Scope computeScopes(JsNode $this$computeScopes) {
        Scope rootScope = new Scope();
        $this$computeScopes.accept(new RecursiveJsVisitor(rootScope){
            private Scope currentScope;
            {
                this.currentScope = $rootScope;
            }

            public final Scope getCurrentScope() {
                return this.currentScope;
            }

            public final void setCurrentScope(Scope scope2) {
                Intrinsics.checkNotNullParameter(scope2, "<set-?>");
                this.currentScope = scope2;
            }

            public void visitClass(JsClass x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
                JsName jsName = x2.getName();
                if (jsName != null) {
                    JsName it = jsName;
                    boolean bl = false;
                    ((Collection)this.currentScope.getDeclaredNames()).add(it);
                }
                JsFunction jsFunction = x2.getConstructor();
                if (jsFunction != null) {
                    jsFunction.accept(this);
                }
                JsExpression jsExpression = x2.getBaseClass();
                if (jsExpression != null) {
                    jsExpression.accept(this);
                }
                Iterable $this$forEach$iv = x2.getMembers();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsFunction it = (JsFunction)element$iv;
                    boolean bl = false;
                    this.visitFunction(it, false);
                }
            }

            public void visitFunction(JsFunction x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
                this.visitFunction(x2, true);
            }

            /*
             * WARNING - void declaration
             */
            public final void visitFunction(JsFunction x2, boolean shouldReserveName) {
                void $this$mapTo$iv$iv;
                void $this$visitFunction_u24lambda_u244;
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter(x2, "x");
                Object object3 = x2.getName();
                if (object3 != null) {
                    object2 = object3;
                    JsName it = object2;
                    boolean bl = false;
                    object3 = shouldReserveName ? object2 : null;
                    if (object3 != null) {
                        it = object3;
                        boolean bl2 = false;
                        ((Collection)this.currentScope.getDeclaredNames()).add(it);
                    }
                }
                Scope oldScope = this.currentScope;
                object2 = object = new Scope();
                Object object4 = this;
                boolean bl = false;
                ((Collection)this.currentScope.getChildren()).add($this$visitFunction_u24lambda_u244);
                object4.currentScope = object;
                object = this.currentScope.getDeclaredNames();
                List<JsParameter> list = x2.getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    object4 = destination$iv$iv;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNullExpressionValue(jsName, "getName(...)");
                    object4.add(jsName);
                }
                object2 = (List)destination$iv$iv;
                CollectionsKt.addAll(object, object2);
                super.visitFunction(x2);
                this.currentScope = oldScope;
            }

            public void visitCatch(JsCatch x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x2.getParameter().getName());
                super.visitCatch(x2);
            }

            public void visit(JsVars.JsVar x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x2.getName());
                super.visit(x2);
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                if (nameRef.getQualifier() == null) {
                    JsName name2 = nameRef.getName();
                    Collection collection = this.currentScope.getUsedNames();
                    JsName jsName = name2;
                    if (jsName == null) {
                        JsName jsName2 = JsDynamicScope.INSTANCE.declareName(nameRef.getIdent());
                        jsName = jsName2;
                        Intrinsics.checkNotNullExpressionValue(jsName2, "declareName(...)");
                    }
                    collection.add(jsName);
                }
                super.visitNameRef(nameRef);
            }

            public void visitImport(JsImport jsImport) {
                Intrinsics.checkNotNullParameter(jsImport, "import");
                JsImport.Target target = jsImport.getTarget();
                if (!(target instanceof JsImport.Target.Effect)) {
                    if (target instanceof JsImport.Target.All) {
                        JsName jsName = ((JsImport.Target.All)target).getAlias().getName();
                        if (jsName != null) {
                            JsName it = jsName;
                            boolean bl = false;
                            ((Collection)this.currentScope.getDeclaredNames()).add(it);
                        }
                    } else if (target instanceof JsImport.Target.Default) {
                        JsName jsName = ((JsImport.Target.Default)target).getName().getName();
                        if (jsName != null) {
                            JsName it = jsName;
                            boolean bl = false;
                            ((Collection)this.currentScope.getDeclaredNames()).add(it);
                        }
                    } else if (target instanceof JsImport.Target.Elements) {
                        Iterable $this$forEach$iv = ((JsImport.Target.Elements)target).getElements();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsImport.Element it = (JsImport.Element)element$iv;
                            boolean bl = false;
                            Collection collection = this.currentScope.getDeclaredNames();
                            HasMetadata hasMetadata = it.getAlias();
                            if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                                hasMetadata = it.getName();
                            }
                            collection.add(hasMetadata);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                super.visitImport(jsImport);
            }

            public void visitBreak(JsBreak x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
            }

            public void visitContinue(JsContinue x2) {
                Intrinsics.checkNotNullParameter(x2, "x");
            }
        });
        return rootScope;
    }

    private static final void resolveNames$traverse(HashMap<JsName, JsName> replacements, Scope scope2) {
        Set<String> occupiedNames = SequencesKt.toMutableSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)scope2.getDeclaredNames()), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$0), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$1));
        CollectionsKt.addAll((Collection)occupiedNames, SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)scope2.getUsedNames()), arg_0 -> ResolveTemporaryNamesKt.resolveNames$traverse$lambda$2(replacements, arg_0)));
        HashMap nextSuffix = new HashMap();
        Iterator<JsName> iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)scope2.getDeclaredNames()), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$3).iterator();
        while (iterator2.hasNext()) {
            JsName jsName;
            String resolvedName;
            JsName temporaryName = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(temporaryName.getIdent(), "getIdent(...)");
            Integer n2 = nextSuffix.getOrDefault(temporaryName.getIdent(), 0);
            Intrinsics.checkNotNullExpressionValue(n2, "getOrDefault(...)");
            int suffix = ((Number)n2).intValue();
            while (JsDeclarationScope.Companion.getRESERVED_WORDS().contains(resolvedName) || occupiedNames.contains(resolvedName)) {
                resolvedName = temporaryName.getIdent() + '_' + suffix++;
            }
            ((Map)nextSuffix).put(temporaryName.getIdent(), suffix);
            Map map2 = replacements;
            JsName $this$resolveNames_u24traverse_u24lambda_u244 = jsName = JsDynamicScope.INSTANCE.declareName(resolvedName);
            boolean bl = false;
            $this$resolveNames_u24traverse_u24lambda_u244.copyMetadataFrom(temporaryName);
            map2.put(temporaryName, jsName);
            ((Collection)occupiedNames).add(resolvedName);
        }
        Iterable $this$forEach$iv = scope2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope p0 = (Scope)element$iv;
            boolean bl = false;
            ResolveTemporaryNamesKt.resolveNames$traverse(replacements, p0);
        }
    }

    private static final boolean resolveNames$traverse$lambda$0(JsName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isTemporary();
    }

    private static final String resolveNames$traverse$lambda$1(JsName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getIdent();
    }

    private static final String resolveNames$traverse$lambda$2(HashMap $replacements, JsName it) {
        String string;
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isTemporary()) {
            string = it.getIdent();
        } else {
            JsName jsName = (JsName)$replacements.get(it);
            string = jsName != null ? jsName.getIdent() : null;
        }
        return string;
    }

    private static final boolean resolveNames$traverse$lambda$3(JsName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isTemporary();
    }

    private static final void liftUsedNames$traverse(Scope scope2) {
        Iterable $this$forEach$iv = scope2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope child = (Scope)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)scope2.getUsedNames(), (Iterable)child.getDeclaredNames());
            ResolveTemporaryNamesKt.liftUsedNames$traverse(child);
            CollectionsKt.addAll((Collection)scope2.getUsedNames(), (Iterable)child.getUsedNames());
        }
    }
}

