/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_A64FX;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_A64FX.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_A64FX, shgemm_beta_A64FX,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_A64FX, shgemm_itcopy_A64FX,
#else
  shgemm_oncopy_A64FX, shgemm_otcopy_A64FX,
#endif
  shgemm_oncopy_A64FX, shgemm_otcopy_A64FX,
  shgemv_n_A64FX, shgemv_t_A64FX,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_A64FX, sbdtobf16_k_A64FX, sbf16tos_k_A64FX, dbf16tod_k_A64FX,

  samax_k_A64FX,  samin_k_A64FX,  smax_k_A64FX,  smin_k_A64FX,
  isamax_k_A64FX, isamin_k_A64FX, ismax_k_A64FX, ismin_k_A64FX,
  snrm2_k_A64FX,  sasum_k_A64FX,  ssum_k_A64FX, scopy_k_A64FX, sbdot_k_A64FX,
  dsdot_k_A64FX,
  srot_k_A64FX,   srotm_k_A64FX, bscal_k_A64FX, saxpy_k_A64FX,  sscal_k_A64FX, sswap_k_A64FX,
  bgemv_n_A64FX, bgemv_t_A64FX, sbgemv_n_A64FX, sbgemv_t_A64FX, sger_k_A64FX,
  ssymv_L_A64FX, ssymv_U_A64FX,

  bgemm_kernel_A64FX, bgemm_beta_A64FX,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_A64FX, bgemm_itcopy_A64FX,
#else
  bgemm_oncopy_A64FX, bgemm_otcopy_A64FX,
#endif
  bgemm_oncopy_A64FX, bgemm_otcopy_A64FX,

  sbgemm_kernel_A64FX, sbgemm_beta_A64FX,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_A64FX, sbgemm_itcopy_A64FX,
#else
  sbgemm_oncopy_A64FX, sbgemm_otcopy_A64FX,
#endif
  sbgemm_oncopy_A64FX, sbgemm_otcopy_A64FX,

  strsm_kernel_LN_A64FX, strsm_kernel_LT_A64FX, strsm_kernel_RN_A64FX, strsm_kernel_RT_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_A64FX, strsm_iunncopy_A64FX, strsm_iutucopy_A64FX, strsm_iutncopy_A64FX,
  strsm_ilnucopy_A64FX, strsm_ilnncopy_A64FX, strsm_iltucopy_A64FX, strsm_iltncopy_A64FX,
#else
  strsm_ounucopy_A64FX, strsm_ounncopy_A64FX, strsm_outucopy_A64FX, strsm_outncopy_A64FX,
  strsm_olnucopy_A64FX, strsm_olnncopy_A64FX, strsm_oltucopy_A64FX, strsm_oltncopy_A64FX,
#endif
  strsm_ounucopy_A64FX, strsm_ounncopy_A64FX, strsm_outucopy_A64FX, strsm_outncopy_A64FX,
  strsm_olnucopy_A64FX, strsm_olnncopy_A64FX, strsm_oltucopy_A64FX, strsm_oltncopy_A64FX,
  strmm_kernel_RN_A64FX, strmm_kernel_RT_A64FX, strmm_kernel_LN_A64FX, strmm_kernel_LT_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_A64FX, strmm_iunncopy_A64FX, strmm_iutucopy_A64FX, strmm_iutncopy_A64FX,
  strmm_ilnucopy_A64FX, strmm_ilnncopy_A64FX, strmm_iltucopy_A64FX, strmm_iltncopy_A64FX,
#else
  strmm_ounucopy_A64FX, strmm_ounncopy_A64FX, strmm_outucopy_A64FX, strmm_outncopy_A64FX,
  strmm_olnucopy_A64FX, strmm_olnncopy_A64FX, strmm_oltucopy_A64FX, strmm_oltncopy_A64FX,
#endif
  strmm_ounucopy_A64FX, strmm_ounncopy_A64FX, strmm_outucopy_A64FX, strmm_outncopy_A64FX,
  strmm_olnucopy_A64FX, strmm_olnncopy_A64FX, strmm_oltucopy_A64FX, strmm_oltncopy_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_A64FX, ssymm_iltcopy_A64FX,
#else
  ssymm_outcopy_A64FX, ssymm_oltcopy_A64FX,
#endif
  ssymm_outcopy_A64FX, ssymm_oltcopy_A64FX,

#ifndef NO_LAPACK
  sneg_tcopy_A64FX, slaswp_ncopy_A64FX,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_A64FX,
  sbgemm_small_kernel_nn_A64FX, sbgemm_small_kernel_nt_A64FX, sbgemm_small_kernel_tn_A64FX, sbgemm_small_kernel_tt_A64FX,
  sbgemm_small_kernel_b0_nn_A64FX, sbgemm_small_kernel_b0_nt_A64FX, sbgemm_small_kernel_b0_tn_A64FX, sbgemm_small_kernel_b0_tt_A64FX,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_A64FX,  samin_k_A64FX,  smax_k_A64FX,  smin_k_A64FX,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_A64FX,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_A64FX, ismax_k_A64FX, ismin_k_A64FX,
  snrm2_k_A64FX,  sasum_k_A64FX,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_A64FX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_A64FX, sdot_k_A64FX,
//  dsdot_k_A64FX,
  srot_k_A64FX,  srotm_k_A64FX,  saxpy_k_A64FX,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_A64FX,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_A64FX,
  sgemv_n_A64FX,  sgemv_t_A64FX,
#endif
#if BUILD_SINGLE == 1
  sger_k_A64FX,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_A64FX, ssymv_U_A64FX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_A64FX,
  sgemm_direct_performant_A64FX,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_A64FX,
  sgemm_direct_alpha_beta_A64FX,
  ssymm_direct_alpha_betaLU_A64FX,
  ssymm_direct_alpha_betaLL_A64FX,
  strmm_direct_LNUN_A64FX,
  strmm_direct_LNLN_A64FX,
  strmm_direct_LTUN_A64FX,
  strmm_direct_LTLN_A64FX,
  ssyrk_direct_alpha_betaUN_A64FX,
  ssyrk_direct_alpha_betaUT_A64FX,
  ssyrk_direct_alpha_betaLN_A64FX,
  ssyrk_direct_alpha_betaLT_A64FX,
#endif

  sgemm_kernel_A64FX, sgemm_beta_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_A64FX, sgemm_itcopy_A64FX,
#else
  sgemm_oncopy_A64FX, sgemm_otcopy_A64FX,
#endif
  sgemm_oncopy_A64FX, sgemm_otcopy_A64FX,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_A64FX,
  sgemm_small_kernel_nn_A64FX, sgemm_small_kernel_nt_A64FX, sgemm_small_kernel_tn_A64FX, sgemm_small_kernel_tt_A64FX,
  sgemm_small_kernel_b0_nn_A64FX, sgemm_small_kernel_b0_nt_A64FX, sgemm_small_kernel_b0_tn_A64FX, sgemm_small_kernel_b0_tt_A64FX,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_A64FX, strsm_kernel_LT_A64FX, strsm_kernel_RN_A64FX, strsm_kernel_RT_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_A64FX, strsm_iunncopy_A64FX, strsm_iutucopy_A64FX, strsm_iutncopy_A64FX,
  strsm_ilnucopy_A64FX, strsm_ilnncopy_A64FX, strsm_iltucopy_A64FX, strsm_iltncopy_A64FX,
#else
  strsm_ounucopy_A64FX, strsm_ounncopy_A64FX, strsm_outucopy_A64FX, strsm_outncopy_A64FX,
  strsm_olnucopy_A64FX, strsm_olnncopy_A64FX, strsm_oltucopy_A64FX, strsm_oltncopy_A64FX,
#endif
  strsm_ounucopy_A64FX, strsm_ounncopy_A64FX, strsm_outucopy_A64FX, strsm_outncopy_A64FX,
  strsm_olnucopy_A64FX, strsm_olnncopy_A64FX, strsm_oltucopy_A64FX, strsm_oltncopy_A64FX,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_A64FX, strmm_kernel_RT_A64FX, strmm_kernel_LN_A64FX, strmm_kernel_LT_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_A64FX, strmm_iunncopy_A64FX, strmm_iutucopy_A64FX, strmm_iutncopy_A64FX,
  strmm_ilnucopy_A64FX, strmm_ilnncopy_A64FX, strmm_iltucopy_A64FX, strmm_iltncopy_A64FX,
#else
  strmm_ounucopy_A64FX, strmm_ounncopy_A64FX, strmm_outucopy_A64FX, strmm_outncopy_A64FX,
  strmm_olnucopy_A64FX, strmm_olnncopy_A64FX, strmm_oltucopy_A64FX, strmm_oltncopy_A64FX,
#endif
  strmm_ounucopy_A64FX, strmm_ounncopy_A64FX, strmm_outucopy_A64FX, strmm_outncopy_A64FX,
  strmm_olnucopy_A64FX, strmm_olnncopy_A64FX, strmm_oltucopy_A64FX, strmm_oltncopy_A64FX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_A64FX, ssymm_iltcopy_A64FX,
#else
  ssymm_outcopy_A64FX, ssymm_oltcopy_A64FX,
#endif
  ssymm_outcopy_A64FX, ssymm_oltcopy_A64FX,
#ifndef NO_LAPACK
  sneg_tcopy_A64FX, slaswp_ncopy_A64FX,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_A64FX,  damin_k_A64FX,  dmax_k_A64FX,  dmin_k_A64FX,
  idamax_k_A64FX, idamin_k_A64FX, idmax_k_A64FX, idmin_k_A64FX,
  dnrm2_k_A64FX, dasum_k_A64FX,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_A64FX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_A64FX, ddot_k_A64FX,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_A64FX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_A64FX,
  drotm_k_A64FX,
  daxpy_k_A64FX,
  dscal_k_A64FX, 
  dswap_k_A64FX,
  dgemv_n_A64FX,  dgemv_t_A64FX,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_A64FX,
  dsymv_L_A64FX,  dsymv_U_A64FX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_A64FX, dgemm_beta_A64FX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_A64FX, dgemm_itcopy_A64FX,
#else
  dgemm_oncopy_A64FX, dgemm_otcopy_A64FX,
#endif
  dgemm_oncopy_A64FX, dgemm_otcopy_A64FX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_A64FX,
  dgemm_small_kernel_nn_A64FX, dgemm_small_kernel_nt_A64FX, dgemm_small_kernel_tn_A64FX, dgemm_small_kernel_tt_A64FX,
  dgemm_small_kernel_b0_nn_A64FX, dgemm_small_kernel_b0_nt_A64FX, dgemm_small_kernel_b0_tn_A64FX, dgemm_small_kernel_b0_tt_A64FX,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_A64FX, dtrsm_kernel_LT_A64FX, dtrsm_kernel_RN_A64FX, dtrsm_kernel_RT_A64FX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_A64FX, dtrsm_iunncopy_A64FX, dtrsm_iutucopy_A64FX, dtrsm_iutncopy_A64FX,
  dtrsm_ilnucopy_A64FX, dtrsm_ilnncopy_A64FX, dtrsm_iltucopy_A64FX, dtrsm_iltncopy_A64FX,
#else
  dtrsm_ounucopy_A64FX, dtrsm_ounncopy_A64FX, dtrsm_outucopy_A64FX, dtrsm_outncopy_A64FX,
  dtrsm_olnucopy_A64FX, dtrsm_olnncopy_A64FX, dtrsm_oltucopy_A64FX, dtrsm_oltncopy_A64FX,
#endif
  dtrsm_ounucopy_A64FX, dtrsm_ounncopy_A64FX, dtrsm_outucopy_A64FX, dtrsm_outncopy_A64FX,
  dtrsm_olnucopy_A64FX, dtrsm_olnncopy_A64FX, dtrsm_oltucopy_A64FX, dtrsm_oltncopy_A64FX,
  dtrmm_kernel_RN_A64FX, dtrmm_kernel_RT_A64FX, dtrmm_kernel_LN_A64FX, dtrmm_kernel_LT_A64FX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_A64FX, dtrmm_iunncopy_A64FX, dtrmm_iutucopy_A64FX, dtrmm_iutncopy_A64FX,
  dtrmm_ilnucopy_A64FX, dtrmm_ilnncopy_A64FX, dtrmm_iltucopy_A64FX, dtrmm_iltncopy_A64FX,
#else
  dtrmm_ounucopy_A64FX, dtrmm_ounncopy_A64FX, dtrmm_outucopy_A64FX, dtrmm_outncopy_A64FX,
  dtrmm_olnucopy_A64FX, dtrmm_olnncopy_A64FX, dtrmm_oltucopy_A64FX, dtrmm_oltncopy_A64FX,
#endif
  dtrmm_ounucopy_A64FX, dtrmm_ounncopy_A64FX, dtrmm_outucopy_A64FX, dtrmm_outncopy_A64FX,
  dtrmm_olnucopy_A64FX, dtrmm_olnncopy_A64FX, dtrmm_oltucopy_A64FX, dtrmm_oltncopy_A64FX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_A64FX, dsymm_iltcopy_A64FX,
#else
  dsymm_outcopy_A64FX, dsymm_oltcopy_A64FX,
#endif
  dsymm_outcopy_A64FX, dsymm_oltcopy_A64FX,

#ifndef NO_LAPACK
  dneg_tcopy_A64FX, dlaswp_ncopy_A64FX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_A64FX,  qamin_k_A64FX,  qmax_k_A64FX,  qmin_k_A64FX,
  iqamax_k_A64FX, iqamin_k_A64FX, iqmax_k_A64FX, iqmin_k_A64FX,
  qnrm2_k_A64FX,  qasum_k_A64FX,  qsum_k_A64FX, qcopy_k_A64FX, qdot_k_A64FX,
  qrot_k_A64FX,   qrotm_k_A64FX,  qaxpy_k_A64FX,  qscal_k_A64FX, qswap_k_A64FX,
  qgemv_n_A64FX,  qgemv_t_A64FX,  qger_k_A64FX,
  qsymv_L_A64FX,  qsymv_U_A64FX,
  qgemm_kernel_A64FX, qgemm_beta_A64FX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_A64FX, qgemm_itcopy_A64FX,
#else
  qgemm_oncopy_A64FX, qgemm_otcopy_A64FX,
#endif
  qgemm_oncopy_A64FX, qgemm_otcopy_A64FX,
  qtrsm_kernel_LN_A64FX, qtrsm_kernel_LT_A64FX, qtrsm_kernel_RN_A64FX, qtrsm_kernel_RT_A64FX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_A64FX, qtrsm_iunncopy_A64FX, qtrsm_iutucopy_A64FX, qtrsm_iutncopy_A64FX,
  qtrsm_ilnucopy_A64FX, qtrsm_ilnncopy_A64FX, qtrsm_iltucopy_A64FX, qtrsm_iltncopy_A64FX,
#else
  qtrsm_ounucopy_A64FX, qtrsm_ounncopy_A64FX, qtrsm_outucopy_A64FX, qtrsm_outncopy_A64FX,
  qtrsm_olnucopy_A64FX, qtrsm_olnncopy_A64FX, qtrsm_oltucopy_A64FX, qtrsm_oltncopy_A64FX,
#endif
  qtrsm_ounucopy_A64FX, qtrsm_ounncopy_A64FX, qtrsm_outucopy_A64FX, qtrsm_outncopy_A64FX,
  qtrsm_olnucopy_A64FX, qtrsm_olnncopy_A64FX, qtrsm_oltucopy_A64FX, qtrsm_oltncopy_A64FX,
  qtrmm_kernel_RN_A64FX, qtrmm_kernel_RT_A64FX, qtrmm_kernel_LN_A64FX, qtrmm_kernel_LT_A64FX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_A64FX, qtrmm_iunncopy_A64FX, qtrmm_iutucopy_A64FX, qtrmm_iutncopy_A64FX,
  qtrmm_ilnucopy_A64FX, qtrmm_ilnncopy_A64FX, qtrmm_iltucopy_A64FX, qtrmm_iltncopy_A64FX,
#else
  qtrmm_ounucopy_A64FX, qtrmm_ounncopy_A64FX, qtrmm_outucopy_A64FX, qtrmm_outncopy_A64FX,
  qtrmm_olnucopy_A64FX, qtrmm_olnncopy_A64FX, qtrmm_oltucopy_A64FX, qtrmm_oltncopy_A64FX,
#endif
  qtrmm_ounucopy_A64FX, qtrmm_ounncopy_A64FX, qtrmm_outucopy_A64FX, qtrmm_outncopy_A64FX,
  qtrmm_olnucopy_A64FX, qtrmm_olnncopy_A64FX, qtrmm_oltucopy_A64FX, qtrmm_oltncopy_A64FX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_A64FX, qsymm_iltcopy_A64FX,
#else
  qsymm_outcopy_A64FX, qsymm_oltcopy_A64FX,
#endif
  qsymm_outcopy_A64FX, qsymm_oltcopy_A64FX,

#ifndef NO_LAPACK
  qneg_tcopy_A64FX, qlaswp_ncopy_A64FX,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_A64FX, camin_k_A64FX,
#endif
#if (BUILD_COMPLEX)
  icamax_k_A64FX, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_A64FX,
  cnrm2_k_A64FX, casum_k_A64FX, csum_k_A64FX,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_A64FX, cdotu_k_A64FX, cdotc_k_A64FX,
#endif
#if (BUILD_COMPLEX)
 csrot_k_A64FX,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_A64FX,
  caxpyc_k_A64FX, 
  cscal_k_A64FX, 
  cswap_k_A64FX,

  cgemv_n_A64FX, cgemv_t_A64FX, cgemv_r_A64FX, cgemv_c_A64FX,
  cgemv_o_A64FX, cgemv_u_A64FX, cgemv_s_A64FX, cgemv_d_A64FX,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_A64FX, cgerc_k_A64FX, cgerv_k_A64FX, cgerd_k_A64FX,
  csymv_L_A64FX, csymv_U_A64FX,
  chemv_L_A64FX, chemv_U_A64FX, chemv_M_A64FX, chemv_V_A64FX,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_A64FX, cgemm_kernel_l_A64FX, cgemm_kernel_r_A64FX, cgemm_kernel_b_A64FX,
  cgemm_beta_A64FX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_A64FX, cgemm_itcopy_A64FX,
#else
  cgemm_oncopy_A64FX, cgemm_otcopy_A64FX,
#endif
  cgemm_oncopy_A64FX, cgemm_otcopy_A64FX,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_A64FX,
  cgemm_small_kernel_nn_A64FX, cgemm_small_kernel_nt_A64FX, cgemm_small_kernel_nr_A64FX, cgemm_small_kernel_nc_A64FX,
  cgemm_small_kernel_tn_A64FX, cgemm_small_kernel_tt_A64FX, cgemm_small_kernel_tr_A64FX, cgemm_small_kernel_tc_A64FX,
  cgemm_small_kernel_rn_A64FX, cgemm_small_kernel_rt_A64FX, cgemm_small_kernel_rr_A64FX, cgemm_small_kernel_rc_A64FX,
  cgemm_small_kernel_cn_A64FX, cgemm_small_kernel_ct_A64FX, cgemm_small_kernel_cr_A64FX, cgemm_small_kernel_cc_A64FX,
  cgemm_small_kernel_b0_nn_A64FX, cgemm_small_kernel_b0_nt_A64FX, cgemm_small_kernel_b0_nr_A64FX, cgemm_small_kernel_b0_nc_A64FX,
  cgemm_small_kernel_b0_tn_A64FX, cgemm_small_kernel_b0_tt_A64FX, cgemm_small_kernel_b0_tr_A64FX, cgemm_small_kernel_b0_tc_A64FX,
  cgemm_small_kernel_b0_rn_A64FX, cgemm_small_kernel_b0_rt_A64FX, cgemm_small_kernel_b0_rr_A64FX, cgemm_small_kernel_b0_rc_A64FX,
  cgemm_small_kernel_b0_cn_A64FX, cgemm_small_kernel_b0_ct_A64FX, cgemm_small_kernel_b0_cr_A64FX, cgemm_small_kernel_b0_cc_A64FX,
#endif

  ctrsm_kernel_LN_A64FX, ctrsm_kernel_LT_A64FX, ctrsm_kernel_LR_A64FX, ctrsm_kernel_LC_A64FX,
  ctrsm_kernel_RN_A64FX, ctrsm_kernel_RT_A64FX, ctrsm_kernel_RR_A64FX, ctrsm_kernel_RC_A64FX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_A64FX,  ctrsm_iunncopy_A64FX,  ctrsm_iutucopy_A64FX,  ctrsm_iutncopy_A64FX,
  ctrsm_ilnucopy_A64FX,  ctrsm_ilnncopy_A64FX,  ctrsm_iltucopy_A64FX,  ctrsm_iltncopy_A64FX,
#else
  ctrsm_ounucopy_A64FX,  ctrsm_ounncopy_A64FX,  ctrsm_outucopy_A64FX,  ctrsm_outncopy_A64FX,
  ctrsm_olnucopy_A64FX,  ctrsm_olnncopy_A64FX,  ctrsm_oltucopy_A64FX,  ctrsm_oltncopy_A64FX,
#endif
  ctrsm_ounucopy_A64FX,  ctrsm_ounncopy_A64FX,  ctrsm_outucopy_A64FX,  ctrsm_outncopy_A64FX,
  ctrsm_olnucopy_A64FX,  ctrsm_olnncopy_A64FX,  ctrsm_oltucopy_A64FX,  ctrsm_oltncopy_A64FX,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_A64FX,  ctrmm_kernel_RT_A64FX,  ctrmm_kernel_RR_A64FX,  ctrmm_kernel_RC_A64FX,
  ctrmm_kernel_LN_A64FX,  ctrmm_kernel_LT_A64FX,  ctrmm_kernel_LR_A64FX,  ctrmm_kernel_LC_A64FX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_A64FX,  ctrmm_iunncopy_A64FX,  ctrmm_iutucopy_A64FX,  ctrmm_iutncopy_A64FX,
  ctrmm_ilnucopy_A64FX,  ctrmm_ilnncopy_A64FX,  ctrmm_iltucopy_A64FX,  ctrmm_iltncopy_A64FX,
#else
  ctrmm_ounucopy_A64FX,  ctrmm_ounncopy_A64FX,  ctrmm_outucopy_A64FX,  ctrmm_outncopy_A64FX,
  ctrmm_olnucopy_A64FX,  ctrmm_olnncopy_A64FX,  ctrmm_oltucopy_A64FX,  ctrmm_oltncopy_A64FX,
#endif
  ctrmm_ounucopy_A64FX,  ctrmm_ounncopy_A64FX,  ctrmm_outucopy_A64FX,  ctrmm_outncopy_A64FX,
  ctrmm_olnucopy_A64FX,  ctrmm_olnncopy_A64FX,  ctrmm_oltucopy_A64FX,  ctrmm_oltncopy_A64FX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_A64FX,  csymm_iltcopy_A64FX,
#else
  csymm_outcopy_A64FX,  csymm_oltcopy_A64FX,
#endif
  csymm_outcopy_A64FX,  csymm_oltcopy_A64FX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_A64FX,  chemm_iltcopy_A64FX,
#else
  chemm_outcopy_A64FX,  chemm_oltcopy_A64FX,
#endif
  chemm_outcopy_A64FX,  chemm_oltcopy_A64FX,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_A64FX,

  cgemm3m_incopyb_A64FX,  cgemm3m_incopyr_A64FX,
  cgemm3m_incopyi_A64FX,  cgemm3m_itcopyb_A64FX,
  cgemm3m_itcopyr_A64FX,  cgemm3m_itcopyi_A64FX,
  cgemm3m_oncopyb_A64FX,  cgemm3m_oncopyr_A64FX,
  cgemm3m_oncopyi_A64FX,  cgemm3m_otcopyb_A64FX,
  cgemm3m_otcopyr_A64FX,  cgemm3m_otcopyi_A64FX,

  csymm3m_iucopyb_A64FX,  csymm3m_ilcopyb_A64FX,
  csymm3m_iucopyr_A64FX,  csymm3m_ilcopyr_A64FX,
  csymm3m_iucopyi_A64FX,  csymm3m_ilcopyi_A64FX,
  csymm3m_oucopyb_A64FX,  csymm3m_olcopyb_A64FX,
  csymm3m_oucopyr_A64FX,  csymm3m_olcopyr_A64FX,
  csymm3m_oucopyi_A64FX,  csymm3m_olcopyi_A64FX,

  chemm3m_iucopyb_A64FX,  chemm3m_ilcopyb_A64FX,
  chemm3m_iucopyr_A64FX,  chemm3m_ilcopyr_A64FX,
  chemm3m_iucopyi_A64FX,  chemm3m_ilcopyi_A64FX,

  chemm3m_oucopyb_A64FX,  chemm3m_olcopyb_A64FX,
  chemm3m_oucopyr_A64FX,  chemm3m_olcopyr_A64FX,
  chemm3m_oucopyi_A64FX,  chemm3m_olcopyi_A64FX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_A64FX,
  
   claswp_ncopy_A64FX,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_A64FX, zamin_k_A64FX, izamax_k_A64FX, izamin_k_A64FX,
  znrm2_k_A64FX, zasum_k_A64FX, zsum_k_A64FX, zcopy_k_A64FX,
  zdotu_k_A64FX, zdotc_k_A64FX, zdrot_k_A64FX,
  zaxpy_k_A64FX, zaxpyc_k_A64FX, zscal_k_A64FX, zswap_k_A64FX,

  zgemv_n_A64FX, zgemv_t_A64FX, zgemv_r_A64FX, zgemv_c_A64FX,
  zgemv_o_A64FX, zgemv_u_A64FX, zgemv_s_A64FX, zgemv_d_A64FX,
  zgeru_k_A64FX, zgerc_k_A64FX, zgerv_k_A64FX, zgerd_k_A64FX,
  zsymv_L_A64FX, zsymv_U_A64FX,
  zhemv_L_A64FX, zhemv_U_A64FX, zhemv_M_A64FX, zhemv_V_A64FX,

  zgemm_kernel_n_A64FX, zgemm_kernel_l_A64FX, zgemm_kernel_r_A64FX, zgemm_kernel_b_A64FX,
  zgemm_beta_A64FX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_A64FX, zgemm_itcopy_A64FX,
#else
  zgemm_oncopy_A64FX, zgemm_otcopy_A64FX,
#endif
  zgemm_oncopy_A64FX, zgemm_otcopy_A64FX,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_A64FX,
  zgemm_small_kernel_nn_A64FX, zgemm_small_kernel_nt_A64FX, zgemm_small_kernel_nr_A64FX, zgemm_small_kernel_nc_A64FX,
  zgemm_small_kernel_tn_A64FX, zgemm_small_kernel_tt_A64FX, zgemm_small_kernel_tr_A64FX, zgemm_small_kernel_tc_A64FX,
  zgemm_small_kernel_rn_A64FX, zgemm_small_kernel_rt_A64FX, zgemm_small_kernel_rr_A64FX, zgemm_small_kernel_rc_A64FX,
  zgemm_small_kernel_cn_A64FX, zgemm_small_kernel_ct_A64FX, zgemm_small_kernel_cr_A64FX, zgemm_small_kernel_cc_A64FX,
  zgemm_small_kernel_b0_nn_A64FX, zgemm_small_kernel_b0_nt_A64FX, zgemm_small_kernel_b0_nr_A64FX, zgemm_small_kernel_b0_nc_A64FX,
  zgemm_small_kernel_b0_tn_A64FX, zgemm_small_kernel_b0_tt_A64FX, zgemm_small_kernel_b0_tr_A64FX, zgemm_small_kernel_b0_tc_A64FX,
  zgemm_small_kernel_b0_rn_A64FX, zgemm_small_kernel_b0_rt_A64FX, zgemm_small_kernel_b0_rr_A64FX, zgemm_small_kernel_b0_rc_A64FX,
  zgemm_small_kernel_b0_cn_A64FX, zgemm_small_kernel_b0_ct_A64FX, zgemm_small_kernel_b0_cr_A64FX, zgemm_small_kernel_b0_cc_A64FX,
#endif

  ztrsm_kernel_LN_A64FX, ztrsm_kernel_LT_A64FX, ztrsm_kernel_LR_A64FX, ztrsm_kernel_LC_A64FX,
  ztrsm_kernel_RN_A64FX, ztrsm_kernel_RT_A64FX, ztrsm_kernel_RR_A64FX, ztrsm_kernel_RC_A64FX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_A64FX,  ztrsm_iunncopy_A64FX,  ztrsm_iutucopy_A64FX,  ztrsm_iutncopy_A64FX,
  ztrsm_ilnucopy_A64FX,  ztrsm_ilnncopy_A64FX,  ztrsm_iltucopy_A64FX,  ztrsm_iltncopy_A64FX,
#else
  ztrsm_ounucopy_A64FX,  ztrsm_ounncopy_A64FX,  ztrsm_outucopy_A64FX,  ztrsm_outncopy_A64FX,
  ztrsm_olnucopy_A64FX,  ztrsm_olnncopy_A64FX,  ztrsm_oltucopy_A64FX,  ztrsm_oltncopy_A64FX,
#endif
  ztrsm_ounucopy_A64FX,  ztrsm_ounncopy_A64FX,  ztrsm_outucopy_A64FX,  ztrsm_outncopy_A64FX,
  ztrsm_olnucopy_A64FX,  ztrsm_olnncopy_A64FX,  ztrsm_oltucopy_A64FX,  ztrsm_oltncopy_A64FX,

  ztrmm_kernel_RN_A64FX,  ztrmm_kernel_RT_A64FX,  ztrmm_kernel_RR_A64FX,  ztrmm_kernel_RC_A64FX,
  ztrmm_kernel_LN_A64FX,  ztrmm_kernel_LT_A64FX,  ztrmm_kernel_LR_A64FX,  ztrmm_kernel_LC_A64FX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_A64FX,  ztrmm_iunncopy_A64FX,  ztrmm_iutucopy_A64FX,  ztrmm_iutncopy_A64FX,
  ztrmm_ilnucopy_A64FX,  ztrmm_ilnncopy_A64FX,  ztrmm_iltucopy_A64FX,  ztrmm_iltncopy_A64FX,
#else
  ztrmm_ounucopy_A64FX,  ztrmm_ounncopy_A64FX,  ztrmm_outucopy_A64FX,  ztrmm_outncopy_A64FX,
  ztrmm_olnucopy_A64FX,  ztrmm_olnncopy_A64FX,  ztrmm_oltucopy_A64FX,  ztrmm_oltncopy_A64FX,
#endif
  ztrmm_ounucopy_A64FX,  ztrmm_ounncopy_A64FX,  ztrmm_outucopy_A64FX,  ztrmm_outncopy_A64FX,
  ztrmm_olnucopy_A64FX,  ztrmm_olnncopy_A64FX,  ztrmm_oltucopy_A64FX,  ztrmm_oltncopy_A64FX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_A64FX,  zsymm_iltcopy_A64FX,
#else
  zsymm_outcopy_A64FX,  zsymm_oltcopy_A64FX,
#endif
  zsymm_outcopy_A64FX,  zsymm_oltcopy_A64FX,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_A64FX,  zhemm_iltcopy_A64FX,
#else
  zhemm_outcopy_A64FX,  zhemm_oltcopy_A64FX,
#endif
  zhemm_outcopy_A64FX,  zhemm_oltcopy_A64FX,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_A64FX,

  zgemm3m_incopyb_A64FX,  zgemm3m_incopyr_A64FX,
  zgemm3m_incopyi_A64FX,  zgemm3m_itcopyb_A64FX,
  zgemm3m_itcopyr_A64FX,  zgemm3m_itcopyi_A64FX,
  zgemm3m_oncopyb_A64FX,  zgemm3m_oncopyr_A64FX,
  zgemm3m_oncopyi_A64FX,  zgemm3m_otcopyb_A64FX,
  zgemm3m_otcopyr_A64FX,  zgemm3m_otcopyi_A64FX,

  zsymm3m_iucopyb_A64FX,  zsymm3m_ilcopyb_A64FX,
  zsymm3m_iucopyr_A64FX,  zsymm3m_ilcopyr_A64FX,
  zsymm3m_iucopyi_A64FX,  zsymm3m_ilcopyi_A64FX,
  zsymm3m_oucopyb_A64FX,  zsymm3m_olcopyb_A64FX,
  zsymm3m_oucopyr_A64FX,  zsymm3m_olcopyr_A64FX,
  zsymm3m_oucopyi_A64FX,  zsymm3m_olcopyi_A64FX,

  zhemm3m_iucopyb_A64FX,  zhemm3m_ilcopyb_A64FX,
  zhemm3m_iucopyr_A64FX,  zhemm3m_ilcopyr_A64FX,
  zhemm3m_iucopyi_A64FX,  zhemm3m_ilcopyi_A64FX,

  zhemm3m_oucopyb_A64FX,  zhemm3m_olcopyb_A64FX,
  zhemm3m_oucopyr_A64FX,  zhemm3m_olcopyr_A64FX,
  zhemm3m_oucopyi_A64FX,  zhemm3m_olcopyi_A64FX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_A64FX, zlaswp_ncopy_A64FX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_A64FX, xamin_k_A64FX, ixamax_k_A64FX, ixamin_k_A64FX,
  xnrm2_k_A64FX, xasum_k_A64FX, xsum_k_A64FX, xcopy_k_A64FX,
  xdotu_k_A64FX, xdotc_k_A64FX, xqrot_k_A64FX,
  xaxpy_k_A64FX, xaxpyc_k_A64FX, xscal_k_A64FX, xswap_k_A64FX,

  xgemv_n_A64FX, xgemv_t_A64FX, xgemv_r_A64FX, xgemv_c_A64FX,
  xgemv_o_A64FX, xgemv_u_A64FX, xgemv_s_A64FX, xgemv_d_A64FX,
  xgeru_k_A64FX, xgerc_k_A64FX, xgerv_k_A64FX, xgerd_k_A64FX,
  xsymv_L_A64FX, xsymv_U_A64FX,
  xhemv_L_A64FX, xhemv_U_A64FX, xhemv_M_A64FX, xhemv_V_A64FX,

  xgemm_kernel_n_A64FX, xgemm_kernel_l_A64FX, xgemm_kernel_r_A64FX, xgemm_kernel_b_A64FX,
  xgemm_beta_A64FX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_A64FX, xgemm_itcopy_A64FX,
#else
  xgemm_oncopy_A64FX, xgemm_otcopy_A64FX,
#endif
  xgemm_oncopy_A64FX, xgemm_otcopy_A64FX,

  xtrsm_kernel_LN_A64FX, xtrsm_kernel_LT_A64FX, xtrsm_kernel_LR_A64FX, xtrsm_kernel_LC_A64FX,
  xtrsm_kernel_RN_A64FX, xtrsm_kernel_RT_A64FX, xtrsm_kernel_RR_A64FX, xtrsm_kernel_RC_A64FX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_A64FX,  xtrsm_iunncopy_A64FX,  xtrsm_iutucopy_A64FX,  xtrsm_iutncopy_A64FX,
  xtrsm_ilnucopy_A64FX,  xtrsm_ilnncopy_A64FX,  xtrsm_iltucopy_A64FX,  xtrsm_iltncopy_A64FX,
#else
  xtrsm_ounucopy_A64FX,  xtrsm_ounncopy_A64FX,  xtrsm_outucopy_A64FX,  xtrsm_outncopy_A64FX,
  xtrsm_olnucopy_A64FX,  xtrsm_olnncopy_A64FX,  xtrsm_oltucopy_A64FX,  xtrsm_oltncopy_A64FX,
#endif
  xtrsm_ounucopy_A64FX,  xtrsm_ounncopy_A64FX,  xtrsm_outucopy_A64FX,  xtrsm_outncopy_A64FX,
  xtrsm_olnucopy_A64FX,  xtrsm_olnncopy_A64FX,  xtrsm_oltucopy_A64FX,  xtrsm_oltncopy_A64FX,

  xtrmm_kernel_RN_A64FX,  xtrmm_kernel_RT_A64FX,  xtrmm_kernel_RR_A64FX,  xtrmm_kernel_RC_A64FX,
  xtrmm_kernel_LN_A64FX,  xtrmm_kernel_LT_A64FX,  xtrmm_kernel_LR_A64FX,  xtrmm_kernel_LC_A64FX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_A64FX,  xtrmm_iunncopy_A64FX,  xtrmm_iutucopy_A64FX,  xtrmm_iutncopy_A64FX,
  xtrmm_ilnucopy_A64FX,  xtrmm_ilnncopy_A64FX,  xtrmm_iltucopy_A64FX,  xtrmm_iltncopy_A64FX,
#else
  xtrmm_ounucopy_A64FX,  xtrmm_ounncopy_A64FX,  xtrmm_outucopy_A64FX,  xtrmm_outncopy_A64FX,
  xtrmm_olnucopy_A64FX,  xtrmm_olnncopy_A64FX,  xtrmm_oltucopy_A64FX,  xtrmm_oltncopy_A64FX,
#endif
  xtrmm_ounucopy_A64FX,  xtrmm_ounncopy_A64FX,  xtrmm_outucopy_A64FX,  xtrmm_outncopy_A64FX,
  xtrmm_olnucopy_A64FX,  xtrmm_olnncopy_A64FX,  xtrmm_oltucopy_A64FX,  xtrmm_oltncopy_A64FX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_A64FX,  xsymm_iltcopy_A64FX,
#else
  xsymm_outcopy_A64FX,  xsymm_oltcopy_A64FX,
#endif
  xsymm_outcopy_A64FX,  xsymm_oltcopy_A64FX,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_A64FX,  xhemm_iltcopy_A64FX,
#else
  xhemm_outcopy_A64FX,  xhemm_oltcopy_A64FX,
#endif
  xhemm_outcopy_A64FX,  xhemm_oltcopy_A64FX,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_A64FX,

  xgemm3m_incopyb_A64FX,  xgemm3m_incopyr_A64FX,
  xgemm3m_incopyi_A64FX,  xgemm3m_itcopyb_A64FX,
  xgemm3m_itcopyr_A64FX,  xgemm3m_itcopyi_A64FX,
  xgemm3m_oncopyb_A64FX,  xgemm3m_oncopyr_A64FX,
  xgemm3m_oncopyi_A64FX,  xgemm3m_otcopyb_A64FX,
  xgemm3m_otcopyr_A64FX,  xgemm3m_otcopyi_A64FX,

  xsymm3m_iucopyb_A64FX,  xsymm3m_ilcopyb_A64FX,
  xsymm3m_iucopyr_A64FX,  xsymm3m_ilcopyr_A64FX,
  xsymm3m_iucopyi_A64FX,  xsymm3m_ilcopyi_A64FX,
  xsymm3m_oucopyb_A64FX,  xsymm3m_olcopyb_A64FX,
  xsymm3m_oucopyr_A64FX,  xsymm3m_olcopyr_A64FX,
  xsymm3m_oucopyi_A64FX,  xsymm3m_olcopyi_A64FX,

  xhemm3m_iucopyb_A64FX,  xhemm3m_ilcopyb_A64FX,
  xhemm3m_iucopyr_A64FX,  xhemm3m_ilcopyr_A64FX,
  xhemm3m_iucopyi_A64FX,  xhemm3m_ilcopyi_A64FX,

  xhemm3m_oucopyb_A64FX,  xhemm3m_olcopyb_A64FX,
  xhemm3m_oucopyr_A64FX,  xhemm3m_olcopyr_A64FX,
  xhemm3m_oucopyi_A64FX,  xhemm3m_olcopyi_A64FX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_A64FX, xlaswp_ncopy_A64FX,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_A64FX,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_A64FX,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_A64FX,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_A64FX,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_A64FX, somatcopy_k_ct_A64FX, somatcopy_k_rn_A64FX, somatcopy_k_rt_A64FX,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_A64FX, domatcopy_k_ct_A64FX, domatcopy_k_rn_A64FX, domatcopy_k_rt_A64FX,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_A64FX, comatcopy_k_ct_A64FX, comatcopy_k_rn_A64FX, comatcopy_k_rt_A64FX,
  comatcopy_k_cnc_A64FX, comatcopy_k_ctc_A64FX, comatcopy_k_rnc_A64FX, comatcopy_k_rtc_A64FX,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_A64FX, zomatcopy_k_ct_A64FX, zomatcopy_k_rn_A64FX, zomatcopy_k_rt_A64FX,
  zomatcopy_k_cnc_A64FX, zomatcopy_k_ctc_A64FX, zomatcopy_k_rnc_A64FX, zomatcopy_k_rtc_A64FX,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_A64FX, simatcopy_k_ct_A64FX, simatcopy_k_rn_A64FX, simatcopy_k_rt_A64FX,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_A64FX, dimatcopy_k_ct_A64FX, dimatcopy_k_rn_A64FX, dimatcopy_k_rt_A64FX,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_A64FX, cimatcopy_k_ct_A64FX, cimatcopy_k_rn_A64FX, cimatcopy_k_rt_A64FX,
  cimatcopy_k_cnc_A64FX, cimatcopy_k_ctc_A64FX, cimatcopy_k_rnc_A64FX, cimatcopy_k_rtc_A64FX,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_A64FX, zimatcopy_k_ct_A64FX, zimatcopy_k_rn_A64FX, zimatcopy_k_rt_A64FX,
  zimatcopy_k_cnc_A64FX, zimatcopy_k_ctc_A64FX, zimatcopy_k_rnc_A64FX, zimatcopy_k_rtc_A64FX,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_A64FX,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_A64FX,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_A64FX,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_A64FX,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
