/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.StyleHandler;
import io.sf.carte.echosvg.util.SVGConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class DefaultStyleHandler
implements StyleHandler,
SVGConstants {
    static Map<String, Set<String>> ignoreAttributes = new HashMap<String, Set<String>>();

    @Override
    public void setStyle(Element element, Map<String, String> styleMap, SVGGeneratorContext generatorContext) {
        String tagName = element.getTagName();
        for (String styleName : styleMap.keySet()) {
            if (element.getAttributeNS(null, styleName).length() != 0 || !this.appliesTo(styleName, tagName)) continue;
            element.setAttributeNS(null, styleName, styleMap.get(styleName));
        }
    }

    protected boolean appliesTo(String styleName, String tagName) {
        Set<String> s = ignoreAttributes.get(tagName);
        if (s == null) {
            return true;
        }
        return !s.contains(styleName);
    }

    static {
        HashSet<String> textAttributes = new HashSet<String>();
        textAttributes.add("font-size");
        textAttributes.add("font-family");
        textAttributes.add("font-style");
        textAttributes.add("font-weight");
        ignoreAttributes.put("rect", textAttributes);
        ignoreAttributes.put("circle", textAttributes);
        ignoreAttributes.put("ellipse", textAttributes);
        ignoreAttributes.put("polygon", textAttributes);
        ignoreAttributes.put("polygon", textAttributes);
        ignoreAttributes.put("line", textAttributes);
        ignoreAttributes.put("path", textAttributes);
    }
}

