/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.text.StringUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;

public class NcGroup
extends NcDataGrouping {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcGroup(NcDataGrouping parent, Group njgroup) throws IOException {
        super(parent, njgroup);
        this.setGrouping(njgroup);
        this.initChildren();
    }

    @Override
    public Object getObject() {
        return this.njgroup_;
    }

    @Override
    public String getName() {
        return this.getShortName();
    }

    @Override
    public String getNjPath() {
        return this.njgroup_.getFullName();
    }

    @Override
    public String getLongName() {
        return NcUtils.getLongName(this.njgroup_);
    }

    @Override
    public String getShortName() {
        return this.njgroup_.getShortName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        String sname = this.njgroup_.getShortName();
        String fname = this.njgroup_.getFullName();
        Group unenhanced = this.ncdataset_.getNjGroupUnenhanced(fname);
        StringBuilder sb = new StringBuilder(400);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Group \"").append(sname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>");
        if (!sname.equals(fname)) {
            sb.append("<p>Group full name: ").append(fname).append("</p>");
        }
        if (enhanced || unenhanced == null) {
            sb.append("<p><b>Showing enhanced mode description.</b></p>");
        }
        sb.append("<pre>");
        Object detailString = null;
        detailString = enhanced || unenhanced == null ? this.njgroup_.toString() : unenhanced.toString();
        LOGGER.trace("detailString length {}", (Object)((String)detailString).length());
        if (((String)detailString).length() > 300000) {
            LOGGER.info("Detail String is long; truncating.");
            detailString = ((String)detailString).substring(0, 250000) + "\u2026\n\n(truncated to 250,000 chars)";
        }
        sb.append(StringUtils.escapeHtmlSimplistic((String)detailString));
        sb.append("</pre>").append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }
}

