/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcStructure;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.text.StringUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Structure;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public class NcStructureMember
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final NcStructure ncstruct_ = (NcStructure)this.getNcParent();
    private final StructureDS njstructDS_ = (StructureDS)this.ncstruct_.getObject();
    private final VariableDS njvarDS_;
    private final String mname_;
    private final String lname_;

    public NcStructureMember(NcStructure parent, VariableDS njvarDS) {
        super(parent);
        this.njvarDS_ = njvarDS;
        this.mname_ = this.njvarDS_.getShortName();
        this.lname_ = this.ncstruct_.getName() + "." + this.mname_;
        LOGGER.trace("njvar sname {}, class {}", (Object)this.mname_, (Object)this.njvarDS_.getClass().getSimpleName());
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.njvarDS_;
    }

    @Override
    public String getName() {
        return this.mname_;
    }

    @Override
    public String getNjPath() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return this.lname_;
    }

    @Override
    public String getShortName() {
        return this.mname_;
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        LOGGER.trace("");
        String fname = this.getNjPath();
        String lname = this.getLongName();
        StringBuilder sb = new StringBuilder(4096);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Structure member \"").append(lname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>\n");
        if (!lname.equals(fname)) {
            sb.append("<p>Member full name: ").append(fname).append("</p>");
        }
        Structure substruct = this.njstructDS_.select(this.mname_);
        sb.append("<hr>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(substruct.toString())).append("</pre>");
        this.appendScalarInfo(sb, enhanced);
        sb.append("</body></html>");
        return sb.toString();
    }

    private void appendScalarInfo(StringBuilder sb, boolean enhanced) {
        block7: {
            if (!this.isEffectivelyScalar()) {
                LOGGER.trace("No, the structure and member are not both scalar");
                return;
            }
            LOGGER.trace("struct and member both look like scalars");
            try {
                Array aa = this.njvarDS_.read();
                Object oo = aa.getObject(0);
                if (oo == null) {
                    LOGGER.trace("getScalarValue returned null");
                    return;
                }
                sb.append("<hr>").append("<p>");
                if (this.njvarDS_.isScalar()) {
                    sb.append("Scalar variable has value: ");
                } else {
                    sb.append("Array is single-valued, with value: ");
                }
                NcUtils.appendScalarObjectValue(sb, oo);
                sb.append("</p>");
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    sb.append("<hr>").append("<p>").append("Exception occurred extracting structure member's scalar value: ").append(exc.toString()).append("</p>");
                }
                LOGGER.debug("Could not extract scalar value: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block7;
                exc.printStackTrace();
            }
        }
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public String toString() {
        return this.njvarDS_.getFullName();
    }

    private boolean isEffectivelyScalar() {
        if (this.njvarDS_.getSize() > 1L) {
            return false;
        }
        int[] shape = this.ncstruct_.getShape();
        return this.ncstruct_.getRank() == 0 || shape.length == 1 && shape[0] == 1;
    }
}

