/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.shapefile.ShapeException;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import gov.nasa.giss.map.shapefile.ShapeUtils;
import java.awt.geom.Point2D;

public class ShapeRecordMultiPoint
extends ShapeRecord {
    private Point2D.Double[] pts_;
    private double[] mVals_;
    private double[] mRange_;
    private double[] zVals_;
    private double[] zRange_;

    @Override
    void readFromBuffer(byte[] buffer) {
        this.recordType_ = ShapeUtils.shapeTypeFromBytes(buffer, 0);
        if (!this.isMultiPoint()) {
            throw new ShapeException("Shape type is not MultiPoint.");
        }
        this.numParts_ = 1;
        double[] bounds = ShapeUtils.doublesFromLittleBytes(buffer, 4, 4);
        this.left_ = bounds[0];
        this.top_ = bounds[3];
        this.right_ = bounds[2];
        this.bottom_ = bounds[1];
        this.numPoints_ = ShapeUtils.intFromLittleBytes(ShapeUtils.arraySection(buffer, 36, 4));
        if (this.recordType_ == ShapeRecordType.MULTIPOINT) {
            return;
        }
        int ptOffset = 48;
        this.pts_ = ShapeUtils.pointsFromLittleBytes(buffer, 48, this.numPoints_);
        int mOffset = 0;
        int zOffset = 0;
        if (this.recordType_ == ShapeRecordType.MULTIPOINT_M) {
            mOffset = 48 + this.numPoints_ * 2 * 8;
        } else if (this.recordType_ == ShapeRecordType.MULTIPOINT_Z) {
            zOffset = 48 + this.numPoints_ * 2 * 8;
            mOffset = zOffset + 16 + this.numPoints_ * 8;
        }
        if (mOffset < buffer.length) {
            this.mRange_ = ShapeUtils.doublesFromLittleBytes(buffer, mOffset, 2);
            this.mVals_ = ShapeUtils.doublesFromLittleBytes(buffer, mOffset + 16, this.numPoints_);
        }
        if (this.recordType_ == ShapeRecordType.MULTIPOINT_Z) {
            this.zRange_ = ShapeUtils.doublesFromLittleBytes(buffer, zOffset, 2);
            this.zVals_ = ShapeUtils.doublesFromLittleBytes(buffer, zOffset + 16, this.numPoints_);
        }
    }

    @Override
    public Point2D.Double[] getPoints(int partNum) {
        if (partNum != 0) {
            throw new IllegalArgumentException("Part number out of range.");
        }
        return this.pts_;
    }

    public double[] getMRange() {
        return this.mRange_;
    }

    public double[] getZRange() {
        return this.zRange_;
    }

    public double[] getMValues() {
        return this.mVals_;
    }

    public double[] getZValues() {
        return this.zVals_;
    }
}

