/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.dialog.PanCombinePlotDialog;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.task.PanCombinePlotTask;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCombinePlotAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;
    private PanCombinePlotTask combiner_;

    public PanCombinePlotAction(PanSourcesFrame f) {
        super(PanProperties.SOURCES_PROPS.getString("combine-plot"));
        this.parent_ = f;
    }

    public boolean isBusy() {
        return this.combiner_ != null && this.combiner_.isBusy();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanCombinePlotDialog dlog = new PanCombinePlotDialog(this.parent_);
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            return;
        }
        this.addToExistingPlot(dlog.getTarget());
    }

    public void addToExistingPlot(String target) {
        Objects.requireNonNull(target, "Target frame title cannot be null.");
        TreeTableNode node = this.parent_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        PanPlotFrame pframe = null;
        for (PanPlotFrame frame : PanPlotFrame.getAllPlotFrames()) {
            if (!frame.getTitle().equals(target)) continue;
            pframe = frame;
            break;
        }
        if (pframe == null) {
            LOGGER.debug("Could not find plot frame with title '{}'", (Object)target);
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        this.combiner_ = new PanCombinePlotTask(pframe, ncvar);
        pframe.addTask(this.combiner_);
        this.parent_.refresh();
    }
}

