/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkFolder;
import gov.nasa.giss.panoply.prefs.PanBookmarkNode;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanHistoryFolder;
import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarkList
extends PanBookmarkNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PanBookmarkList getSharedInstance() {
        return Singleton.INSTANCE;
    }

    protected PanBookmarkList() {
        this.setName("root");
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getAddress() {
        return "root";
    }

    @Override
    public void add(TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmarkNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarkNode.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmarkNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarkNode.");
        }
        super.add(index, child);
    }

    public void read(Element elem) {
        try {
            elem.getAttribute("key").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read top group because it has null or non-bookmark key: '" + elem.getAttribute("key") + "'");
            return;
        }
        this.readGroup(null, elem);
    }

    private void readGroup(PanBookmarkNode parentNode, Element groupElem) {
        Attribute keyA;
        String folderType = groupElem.getName();
        PanBookmarkNode folder = null;
        if (parentNode == null && "group".equals(folderType) && (keyA = groupElem.getAttribute("key")) != null) {
            folderType = keyA.getValue();
        }
        if ("bookmarks".equals(folderType)) {
            folder = PanBookmarkList.getSharedInstance();
        } else if ("history".equals(folderType)) {
            folder = PanHistoryList.getSharedInstance();
        } else if ("folder".equals(folderType)) {
            if (parentNode instanceof PanHistoryList) {
                try {
                    String date = groupElem.getAttribute("name").getValue();
                    folder = new PanHistoryFolder(parentNode, date);
                    parentNode.add(folder);
                }
                catch (Exception exc) {
                    LOGGER.warn("Could not parse history folder date.");
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                }
            } else {
                Attribute nameAttr = groupElem.getAttribute("name");
                String name = nameAttr != null ? nameAttr.getValue() : "Unnamed Folder";
                folder = new PanBookmarkFolder(parentNode, name);
                parentNode.add(folder);
            }
        } else {
            LOGGER.warn("Unknown bookmarks folder type: '" + folderType + "'");
            return;
        }
        for (Element lchild : groupElem.getChildren()) {
            String lchildName = lchild.getName();
            if ("folder".equals(lchildName)) {
                this.readGroup(folder, lchild);
                continue;
            }
            if (!"link".equals(lchildName)) continue;
            Attribute typeAttr = lchild.getAttribute("atype");
            Attribute addressAttr = lchild.getAttribute("address");
            Attribute nameAttr = lchild.getAttribute("name");
            if (typeAttr == null || addressAttr == null) continue;
            String address = addressAttr.getValue();
            String name = nameAttr != null ? nameAttr.getValue() : null;
            PanBookmark b = null;
            try {
                b = new PanBookmark(typeAttr.getValue(), (Object)address, name);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad bookmark: " + address);
            }
            if (b == null) continue;
            folder.add(b);
        }
        if ("folder".equals(folderType) && parentNode instanceof PanHistoryList && folder.getChildCount() < 1) {
            parentNode.remove(folder);
        }
    }

    void write(Element parentElement) throws IOException {
        this.writeGroup(parentElement, this);
    }

    protected final void writeGroup(Element parentElement, PanBookmarkNode folder) throws IOException {
        TreeTableNode[] children;
        Element ffex;
        if (folder instanceof PanHistoryList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "history");
        } else if (folder instanceof PanHistoryFolder) {
            ffex = new Element("folder");
            ffex.setAttribute("name", ((PanHistoryFolder)folder).getDateString());
        } else if (folder instanceof PanBookmarkList) {
            ffex = new Element("group");
            ffex.setAttribute("key", "bookmarks");
        } else if (folder instanceof PanBookmarkFolder) {
            ffex = new Element("folder");
            if (folder.isNameSet()) {
                ffex.setAttribute("name", folder.getName());
            }
        } else {
            LOGGER.warn("Unknown bookmarks 'folder' type.");
            return;
        }
        block5: for (TreeTableNode child : children = folder.getChildren()) {
            PanBookmarkNode node = (PanBookmarkNode)child;
            if (node instanceof PanBookmark) {
                Element bfex = new Element("link");
                PanBookmark b = (PanBookmark)node;
                Object o = node.getObject();
                PanBookmarkType btype = b.getAccessType();
                switch (btype) {
                    case LOCAL_DATASET: {
                        bfex.setAttribute("atype", "local");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case REMOTE_DATASET: {
                        bfex.setAttribute("atype", "remote");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    case CATALOG: {
                        bfex.setAttribute("atype", "catalog");
                        bfex.setAttribute("address", o.toString());
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (b.isNameSet()) {
                    bfex.setAttribute("name", b.getName());
                }
                ffex.addContent(bfex);
                continue;
            }
            if (!(node instanceof PanBookmarkFolder) && !(node instanceof PanHistoryFolder)) continue;
            this.writeGroup(ffex, node);
        }
        parentElement.addContent(ffex);
    }

    private static class Singleton {
        private static final PanBookmarkList INSTANCE = new PanBookmarkList();

        private Singleton() {
        }
    }
}

