/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.log;

import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingListener
implements DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_MAX = 400000;
    private int maxLength_;

    public LoggingListener() {
        this(400000);
    }

    public LoggingListener(int maxLength) {
        this.maxLength_ = maxLength;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e == null) {
            return;
        }
        Document dd = e.getDocument();
        int length = dd.getLength();
        if (length > this.maxLength_) {
            int excess = length - this.maxLength_;
            EventQueue.invokeLater(() -> {
                try {
                    dd.remove(0, excess);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }
}

