/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.EquidistantAzimuthalProjection;
import ucar.units.Converter;
import ucar.units.SI;
import ucar.units.ScaledUnit;
import ucar.units.Unit;

public class NcArrayLonLatAzimuthalEquidistant
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;
    private double cosPhiC_;
    private double sinPhiC_;

    public NcArrayLonLatAzimuthalEquidistant(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.AZIM_EQUIDISTANT);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.AZIM_EQUIDISTANT)) {
            throw new NcException("Variable is not projected type azimuthal equidistant.");
        }
        LOGGER.trace("Using GISS proj");
        this.initGissProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof EquidistantAzimuthalProjection)) {
            LOGGER.warn("Expected EquidistantAzimuthalProjection class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when EquidistantAzimuthalProjection was expected");
        }
        this.njProj_ = pj;
        String xUnits = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX).getUnitsString();
        try {
            ScaledUnit projUnit = new ScaledUnit(1000.0, SI.METER);
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("azimuthal_equidistant")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not azimuthal_equidistant");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        double k = 1.0;
        if (cosZ < 1.0) {
            double z = Math.acos(cosZ);
            k = z / Math.sin(z);
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double rho2 = xx * xx + yy * yy;
        double rho = Math.sqrt(rho2);
        double z = rho * this.oneOverR_;
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + yy * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - yy * this.sinPhiC_ * sinZ);
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

