/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.sat.Geostationary;

public class NcArrayLonLatGeostationary
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Projection njProj_;

    public NcArrayLonLatGeostationary(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.GEOSTATIONARY);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.GEOSTATIONARY)) {
            throw new NcException("Variable is not projected type geostationary.");
        }
        if (LOGGER.isTraceEnabled()) {
            this.initGissProj();
        }
        this.initUnidataProj();
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("geostationary")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not geostationary");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        LOGGER.trace("csList size {}", (Object)csList.size());
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        LOGGER.trace("cs[0] {}", (Object)cs);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof Geostationary)) {
            LOGGER.warn("Expected Geostationary class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when Geostationary was expected");
        }
        this.njProj_ = pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        return NcArrayLonLatGeostationary.transformNjLL2XY(this.njProj_, lon, lat);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        try {
            return NcArrayLonLatGeostationary.transformNjXY2LL(this.njProj_, x, y);
        }
        catch (Exception exc) {
            LOGGER.trace("Exception {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return null;
        }
    }
}

