/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimpPalette
extends AbstractColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public GimpPalette() {
        this(100);
    }

    public GimpPalette(int count) {
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("GPL");
    }

    public GimpPalette(File f) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        try (FileReader fr = new FileReader(f);
             BufferedReader br = new BufferedReader(fr);){
            this.parseColorTable(br);
        }
    }

    public GimpPalette(URL url) throws IOException, ParseException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             InputStreamReader isr = new InputStreamReader(bis);
             BufferedReader br = new BufferedReader(isr);){
            this.parseColorTable(br);
        }
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GimpPalette c = new GimpPalette(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        String oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        if (!(oneLine = oneLine.replaceFirst("\\s+$", "")).toLowerCase().startsWith("gimp palette")) {
            throw new ParseException("Apparently not a GPL GIMP Palette", 1);
        }
        int linesRead = 1;
        ArrayList<Color> v = new ArrayList<Color>(256);
        while ((oneLine = bReader.readLine()) != null) {
            String[] tokens;
            int numTokens;
            ++linesRead;
            if (oneLine.charAt(0) == '#' || oneLine.toLowerCase().startsWith("name") || (numTokens = (tokens = (oneLine = oneLine.replaceFirst("^\\s+", "")).split("\\s+")).length) < 3) continue;
            try {
                int r = Integer.parseInt(tokens[0]);
                int g = Integer.parseInt(tokens[1]);
                int b = Integer.parseInt(tokens[2]);
                v.add(new Color(r, g, b));
            }
            catch (Exception exc) {
                LOGGER.warn("Exception parsing GPL file at {}", (Object)linesRead);
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new ParseException("Exception parsing GPL file", linesRead);
            }
        }
        this.initiateFixedSizeArray(v.size());
        for (int i = 0; i < v.size(); ++i) {
            this.setColorAt(i, (Color)v.get(i));
        }
    }
}

