/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class AzimuthalEquidistant
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Equidistant";
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 180.0;

    public AzimuthalEquidistant(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalEquidistant(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeAngleParameter(90.0, 180.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = this.edgeAngleRad_;
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.fillCorners_ ? Math.PI * this.rS_ : this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == 1.0) {
            return 0.0;
        }
        if (cosZ == -1.0) {
            return -1.0;
        }
        double z = Math.acos(cosZ);
        return z / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return rho * this.invRS_;
    }
}

