/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Eckert4
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Eckert IV";
    private static final double CONST_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double INV_A = 1.0 / CONST_A;
    private static final double PI_A = Math.PI * CONST_A;
    private static final double INV_PI_A = 1.0 / (Math.PI * CONST_A);
    private static final double PI_A2_OVER_2 = 1.5707963267948966 * CONST_A * CONST_A;
    private static final double TWO_PLUS_PI_OVER_2 = 3.5707963267948966;
    private static final double MAX_X_OVER_RS = Math.PI * 2 * CONST_A;
    private static final double MAX_Y_OVER_RS = PI_A;

    public Eckert4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double phiFactor = 3.5707963267948966 * Math.sin(phiRad);
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta * (2.0 + cosTheta) - phiFactor;
            double dfunc = 2.0 * cosTheta * (1.0 + cosTheta);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = CONST_A * lambdaRad * (1.0 + Math.cos(thetaRad));
        double y = PI_A * Math.sin(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double cosTheta;
        double sinTheta;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.invRS_ * INV_PI_A);
        double phiRad = Math.asin((thetaRad + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * PI_A2_OVER_2);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ * INV_A / (1.0 + cosTheta);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert4 eckert4 = this;
        synchronized (eckert4) {
            double cosTheta;
            double sinTheta;
            double y;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(((thetaRad = Math.asin((y = (double)iy + 0.5) * this.invRS_ * INV_PI_A)) + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * PI_A2_OVER_2)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * INV_A / (1.0 + cosTheta);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        if (dotEq == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (dotEq.x > dotN.x) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }
}

