/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public abstract class GeneralEquidistantConic
extends ConicProjection {
    protected double termN_;
    protected double invN_;
    protected double termF_;
    protected double rhoC_;

    public GeneralEquidistantConic(String name, int properties, int width, int height, int xmargin, int ymargin) {
        super(name, properties, width, height, xmargin, ymargin);
    }

    @Override
    protected final void prepareScaling() {
        this.calculateParams();
        double dPhi = this.phiHeight_;
        double phiTRad = Math.toRadians(Math.min(90.0, this.phiC_ + 0.5 * dPhi));
        double phiBRad = Math.toRadians(Math.max(-90.0, this.phiC_ - 0.5 * dPhi));
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * Math.toRadians(dPhi);
        double rhoT = this.termF_ - phiTRad;
        double rhoB = this.termF_ - phiBRad;
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT2 = rhoT * Math.sin(theta2);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rhoC_ - rhoT * Math.cos(theta1);
        double yT2 = this.rhoC_ - rhoT * Math.cos(theta2);
        double yB1 = this.rhoC_ - rhoB * Math.cos(theta1);
        double yB2 = this.rhoC_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double widthFactor = Math.max(xT2, xB2);
        double heightFactor = Math.max(Math.abs(yT), Math.abs(yB));
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    protected abstract void calculateParams();

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double rho = this.termF_ - phiRad;
        double thetaRad = this.termN_ * lambdaRad;
        double x = rho * Math.sin(thetaRad);
        double y = this.rhoC_ - rho * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double rhoCMinusYOverRS = this.rhoC_ - yOverRS;
        double rho = Math.sqrt(xOverRS * xOverRS + rhoCMinusYOverRS * rhoCMinusYOverRS);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rhoCMinusYOverRS) : Math.atan2(xOverRS, rhoCMinusYOverRS);
        double lambdaRad = thetaRad * this.invN_;
        if (Double.isNaN(lambdaRad) || Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GeneralEquidistantConic generalEquidistantConic = this;
        synchronized (generalEquidistantConic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double rhoCMinusYOverRS = this.rhoC_ - yOverRS;
                double rhoCMinusYOverRSSq = rhoCMinusYOverRS * rhoCMinusYOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double thetaRad;
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + rhoCMinusYOverRSSq);
                    if (this.termN_ < 0.0) {
                        rho = -rho;
                    }
                    if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966 || (lambdaRad = (thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rhoCMinusYOverRS) : Math.atan2(xOverRS, rhoCMinusYOverRS)) * this.invN_) > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

