/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnomonicCubedSphere
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Gnomonic Cubed Sphere";
    public static final int PROPERTIES = 0x8000000;
    private static final double MAX_X_OVER_RS = 4.0;
    private static final double MAX_Y_OVER_RS = 3.0;
    private static final int FACE1 = 1;
    private static final int FACE2 = 2;
    private static final int FACE3 = 3;
    private static final int FACE4 = 4;
    private static final int TOP = 5;
    private static final int BOTTOM = 6;
    private static final double LON_SHIFT = 45.0;
    private final ProjIntegerParameter npParam_ = new ProjIntegerParameter("Index of middle row face below North Pole face", "NP Above Face", "", 2, 1, 4);
    private int npFace_;
    private final ProjIntegerParameter spParam_ = new ProjIntegerParameter("Index of middle row face above South Pole face", "SP Below Face", "", 2, 1, 4);
    private int spFace_;
    private double twoRS_;
    private double threeRS_;
    private double fourRS_;

    public GnomonicCubedSphere(int width, int height) {
        this(width, height, 0, 0);
    }

    public GnomonicCubedSphere(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x8000000, width, height, xmargin, ymargin, 4.0, 3.0);
        this.addParameter(this.npParam_);
        this.addParameter(this.spParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.npParam_) || p.equals(this.spParam_)) {
            this.npFace_ = this.npParam_.getValue();
            this.spFace_ = this.spParam_.getValue();
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        LOGGER.trace("np {}, sp {}", (Object)this.npFace_, (Object)this.spFace_);
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.twoRS_ = 2.0 * this.rS_;
        this.threeRS_ = 3.0 * this.rS_;
        this.fourRS_ = 4.0 * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lonb = lon + 45.0;
        double lambdaRad = this.lonToLambdaRad(lonb);
        double phiRad = Math.toRadians(lat);
        double cosPhiRad = Math.cos(phiRad);
        double xx = Math.cos(lambdaRad) * cosPhiRad;
        double yy = Math.sin(lambdaRad) * cosPhiRad;
        double zz = Math.sin(phiRad);
        double absXX = Math.abs(xx);
        double absYY = Math.abs(yy);
        double absZZ = Math.abs(zz);
        double ratio = 0.0;
        int face = 0;
        if (absXX >= absYY && absXX >= absZZ) {
            ratio = 1.0 / absXX;
            face = xx > 0.0 ? 2 : 4;
        } else if (absYY >= absXX && absYY >= absZZ) {
            ratio = 1.0 / absYY;
            face = yy > 0.0 ? 3 : 1;
        } else {
            ratio = 1.0 / absZZ;
            face = zz > 0.0 ? 5 : 6;
        }
        xx *= ratio;
        yy *= ratio;
        zz *= ratio;
        switch (face) {
            case 1: {
                yy = -2.0 + xx;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                yy = 2.0 - xx;
                break;
            }
            case 4: {
                yy = 4.0 - yy;
                break;
            }
            case 5: {
                switch (this.npFace_) {
                    case 1: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 4: {
                        xx = -xx;
                        yy = -yy + 4.0;
                        break;
                    }
                }
                zz = 2.0 - xx;
                break;
            }
            case 6: {
                switch (this.spFace_) {
                    case 1: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 4: {
                        xx = -xx;
                        yy = -yy + 4.0;
                        break;
                    }
                }
                zz = -2.0 + xx;
                break;
            }
        }
        double x = (double)this.outCenterX_ + (yy -= 1.0) * this.rS_;
        double y = (double)this.outCenterY_ - zz * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xxx, double yyy) {
        double x = xxx + this.rS_ - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yyy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        if (Math.abs(yOverRS) <= 1.0) {
            if (xOverRS < -3.0 || xOverRS > 5.0) {
                return null;
            }
            int face = 2;
            double yy = xOverRS;
            double zz = yOverRS;
            if (xOverRS < -1.0) {
                face = 1;
                yy += 2.0;
            } else if (xOverRS > 3.0) {
                face = 4;
                yy -= 4.0;
            } else if (xOverRS > 1.0) {
                face = 3;
                yy -= 2.0;
            }
            double rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
            double xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
            double dlambdaRad = Math.atan2(yy, xx);
            double dlambda = Math.toDegrees(dlambdaRad);
            double phiRad = Math.asin(zz);
            double phi = Math.toDegrees(phiRad);
            if (face == 3) {
                dlambda += 90.0;
            } else if (face == 4) {
                dlambda += 180.0;
            } else if (face == 1) {
                dlambda -= 90.0;
            }
            return new PointLL(this.lambdaC_ + dlambda - 45.0, phi);
        }
        if (Math.abs(yOverRS) <= 3.0) {
            double yy = xOverRS;
            int switchface = yOverRS > 0.0 ? this.npFace_ : this.spFace_;
            switch (switchface) {
                case 1: {
                    if (xOverRS < -3.0 || xOverRS > -1.0) {
                        return null;
                    }
                    yy = xOverRS + 2.0;
                    break;
                }
                case 2: {
                    if (xOverRS < -1.0 || xOverRS > 1.0) {
                        return null;
                    }
                    yy = xOverRS;
                    break;
                }
                case 3: {
                    if (xOverRS < 1.0 || xOverRS > 3.0) {
                        return null;
                    }
                    yy = xOverRS - 2.0;
                    break;
                }
                case 4: {
                    if (xOverRS < 3.0 || xOverRS > 5.0) {
                        return null;
                    }
                    yy = xOverRS - 4.0;
                    break;
                }
            }
            double xx = 2.0 - Math.abs(yOverRS);
            double rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
            double zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
            double dlambdaRad = Math.atan2(yy, xx);
            double dlambda = Math.toDegrees(dlambdaRad);
            double phiRad = Math.asin(zz);
            double phi = Math.toDegrees(phiRad);
            switch (switchface) {
                case 1: {
                    dlambda -= 90.0;
                    break;
                }
                case 3: {
                    dlambda += 90.0;
                    break;
                }
                case 4: {
                    dlambda += 180.0;
                    break;
                }
            }
            if (yOverRS < 0.0) {
                phi *= -1.0;
            }
            return new PointLL(this.lambdaC_ + dlambda - 45.0, phi);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GnomonicCubedSphere gnomonicCubedSphere = this;
        synchronized (gnomonicCubedSphere) {
            int iy = 0;
            while ((double)iy < this.threeRS_) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                int ix = 0;
                while ((double)ix < this.rS_) {
                    double phi;
                    double phiRad;
                    double dlambda;
                    double dlambdaRad;
                    double xx;
                    double rhoQ;
                    double zz;
                    double yy;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    if (yOverRS <= 1.0) {
                        yy = xOverRS;
                        zz = yOverRS;
                        rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
                        xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
                        dlambdaRad = Math.atan2(yy, xx);
                        dlambda = Math.toDegrees(dlambdaRad);
                        phiRad = Math.asin(zz);
                        phi = Math.toDegrees(phiRad);
                        this.setFacePoint(ix, iy, dlambda, phi);
                    } else {
                        yy = xOverRS;
                        xx = 2.0 - yOverRS;
                        rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
                        zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
                        dlambdaRad = Math.atan2(yy, xx);
                        dlambda = Math.toDegrees(dlambdaRad);
                        phiRad = Math.asin(zz);
                        phi = Math.toDegrees(phiRad);
                        this.setPolePoint(ix, iy, dlambda, phi);
                    }
                    ++ix;
                }
                ++iy;
            }
        }
    }

    private void setFacePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        int iyM = -iy - 1;
        this.setInvPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
        this.setInvPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
        this.setInvPoint((int)((double)ix - this.threeRS_), iyM, dlambda - 90.0, -phi);
        this.setInvPoint((int)((double)ixM - this.threeRS_), iyM, -dlambda - 90.0, -phi);
        this.setInvPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
        this.setInvPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
        this.setInvPoint((int)((double)ix - this.rS_), iyM, dlambda, -phi);
        this.setInvPoint((int)((double)ixM - this.rS_), iyM, -dlambda, -phi);
        this.setInvPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
        this.setInvPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
        this.setInvPoint((int)((double)ix + this.rS_), iyM, dlambda + 90.0, -phi);
        this.setInvPoint((int)((double)ixM + this.rS_), iyM, -dlambda + 90.0, -phi);
        this.setInvPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
        this.setInvPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
        this.setInvPoint((int)((double)ix + this.threeRS_), iyM, dlambda + 180.0, -phi);
        this.setInvPoint((int)((double)ixM + this.threeRS_), iyM, -dlambda + 180.0, -phi);
    }

    private void setPolePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        int iyM = -iy - 1;
        switch (this.npFace_) {
            case 1: {
                this.setInvPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
                this.setInvPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
                break;
            }
            case 2: {
                this.setInvPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
                this.setInvPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
                break;
            }
            case 3: {
                this.setInvPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
                this.setInvPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
                break;
            }
            case 4: {
                this.setInvPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
                this.setInvPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
                break;
            }
        }
        switch (this.spFace_) {
            case 1: {
                this.setInvPoint((int)((double)ix - this.threeRS_), iyM, dlambda - 90.0, -phi);
                this.setInvPoint((int)((double)ixM - this.threeRS_), iyM, -dlambda - 90.0, -phi);
                break;
            }
            case 2: {
                this.setInvPoint((int)((double)ix - this.rS_), iyM, dlambda, -phi);
                this.setInvPoint((int)((double)ixM - this.rS_), iyM, -dlambda, -phi);
                break;
            }
            case 3: {
                this.setInvPoint((int)((double)ix + this.rS_), iyM, dlambda + 90.0, -phi);
                this.setInvPoint((int)((double)ixM + this.rS_), iyM, -dlambda + 90.0, -phi);
                break;
            }
            case 4: {
                this.setInvPoint((int)((double)ix + this.threeRS_), iyM, dlambda + 180.0, -phi);
                this.setInvPoint((int)((double)ixM + this.threeRS_), iyM, -dlambda + 180.0, -phi);
                break;
            }
        }
    }

    @Override
    protected void setInvPoint(int ix, int iy, double dlambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        double lon = this.lambdaC_ + dlambda - 45.0;
        this.setInverseArrayLocation(col, row, lon, phi);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        Path2D.Double path = new Path2D.Double();
        path.moveTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ - this.rS_);
        switch (this.npFace_) {
            case 1: {
                path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 2: {
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.rS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 3: {
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.rS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 4: {
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.rS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ - this.threeRS_);
                break;
            }
        }
        path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ - this.rS_);
        path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ + this.rS_);
        switch (this.spFace_) {
            case 1: {
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.rS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ + this.threeRS_);
                break;
            }
            case 2: {
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.rS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.rS_);
                break;
            }
            case 3: {
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.rS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.rS_);
                break;
            }
            case 4: {
                path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.rS_);
                break;
            }
        }
        path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ + this.rS_);
        path.closePath();
        g2x.draw(path);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotNP = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotP45 = this.transformLL2XY(lon, 45.01);
        double dx = dotP45.x - dotNP.x;
        double dy = dotP45.y - dotNP.y;
        double ratio = Math.abs(dx) > Math.abs(dy) ? this.rS_ / Math.abs(dx) : this.rS_ / Math.abs(dy);
        GraphicUtils.drawLine(g2d, dotN.x, dotN.y, dotNP.x + (dx *= ratio), dotNP.y + (dy *= ratio));
        GraphicUtils.drawLine(g2d, dot0.x, dot0.y - this.rS_, dot0.x, dot0.y + this.rS_);
        Point2D.Double dotSP = this.transformLL2XY(lon, -90.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        Point2D.Double dotM45 = this.transformLL2XY(lon, -45.01);
        dx = dotM45.x - dotSP.x;
        dy = dotM45.y - dotSP.y;
        ratio = Math.abs(dx) > Math.abs(dy) ? this.rS_ / Math.abs(dx) : this.rS_ / Math.abs(dy);
        GraphicUtils.drawLine(g2d, dotSP.x + (dx *= ratio), dotSP.y + (dy *= ratio), dotS.x, dotS.y);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double absLat = Math.abs(lat);
        if (absLat < 1.0E-5) {
            Point2D.Double dotW = this.transformLL2XY(this.lambdaC_ - 179.99999, 0.0);
            Point2D.Double dotE = this.transformLL2XY(this.lambdaC_ + 179.99999, 0.0);
            GraphicUtils.drawLine(g2d, dotW, dotE);
        } else if (absLat >= 45.0) {
            Point2D.Double dotP = lat > 0.0 ? this.transformLL2XY(this.lambdaC_, 90.0) : this.transformLL2XY(this.lambdaC_, -90.0);
            double radius = this.rS_;
            if (absLat > 45.0) {
                Point2D.Double dotL = this.transformLL2XY(this.lambdaC_, lat);
                radius = 1.4142135623730951 * Math.abs(dotP.y - dotL.y);
            }
            Ellipse2D.Double ellipse = new Ellipse2D.Double(dotP.x - radius, dotP.y - radius, radius * 2.0, radius * 2.0);
            g2d.draw(ellipse);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }
}

