/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.BonneCommon;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabiusWerner1
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Stabius-Werner I";
    public static final int PROPERTIES = 0x2000200;
    private static final double SW_SCALING = 1.5707963267948966;
    private static final double MAX_X_OVER_RS;
    private static final double MAX_Y_OVER_RS;
    private static final double PHI1 = 90.0;
    private static final double COT_PHI1 = 0.0;
    private static final double COT_PHI1_PLUS_PHI1 = 1.5707963267948966;
    private static final double Y_SHIFT;
    private int leftCenterX_;
    private int rightCenterX_;

    public StabiusWerner1(int width, int height) {
        this(width, height, 0, 0);
    }

    public StabiusWerner1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2000200, width, height, xmargin, ymargin, 2.1 * MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.getWidth() - ins.right));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double alphaRad = 1.5707963267948966 - phiRad;
        if (lambdaRad == 0.0 || Math.abs(phiRad) == 1.5707963267948966) {
            x = 0.0;
            y = 0.0 - alphaRad + Y_SHIFT;
        } else {
            double betaRad = 1.5707963267948966 * lambdaRad * Math.cos(phiRad) / alphaRad;
            x = alphaRad * Math.sin(betaRad);
            y = 0.0 - alphaRad * Math.cos(betaRad) + Y_SHIFT;
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_ - Y_SHIFT;
        double y1 = 0.0 - yOverRS;
        double pmFac = 1.0;
        double alphaRad = 1.0 * Math.hypot(xOverRS, y1);
        double phiRad = 1.5707963267948966 - alphaRad;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double betaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad) / 1.5707963267948966;
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad) + (leftside ? 0.0 : 180.0);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        StabiusWerner1 stabiusWerner1 = this;
        synchronized (stabiusWerner1) {
            double pmFac = 1.0;
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y1 = 0.0 - yOverRS;
                for (int ix = 0; ix < 2 * this.dxMax_; ++ix) {
                    double betaRad;
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double alphaRad = 1.0 * Math.hypot(xOverRS, y1);
                    double phiRad = 1.5707963267948966 - alphaRad;
                    if (Math.abs(phiRad) > 1.5707963267948966 || (lambdaRad = (betaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1)) * alphaRad / Math.cos(phiRad) / 1.5707963267948966) > 1.5707963267948966) continue;
                    this.setFourPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private void setFourPoints(int ix, int iy, double lambdaP, double phiP) {
        this.setInvPoint(true, ix, iy, this.lambdaC_ + lambdaP, phiP);
        this.setInvPoint(true, -ix - 1, iy, this.lambdaC_ - lambdaP, phiP);
        this.setInvPoint(false, ix, iy, this.lambdaC_ + lambdaP + 180.0, phiP);
        this.setInvPoint(false, -ix - 1, iy, this.lambdaC_ - lambdaP + 180.0, phiP);
    }

    private void setInvPoint(boolean leftside, int ix, int iy, double lon, double lat) {
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeMeridianBezier(this.lambdaC_ + 89.99999, 90.0);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(this.lambdaC_ - 89.99999, 90.0)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(this.lambdaC_ + 180.0 + 89.99999, 90.0)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(this.lambdaC_ + 180.0 - 89.99999, 90.0)) != null) {
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lonc = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            double lon1 = lonc + -89.99999;
            double lon2 = lonc;
            double lon3 = lonc + 89.99999;
            Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
            Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
            Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = Math.abs(this.lonToLambda(lon));
        if (Math.abs(dlon - 90.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeMeridianBezier(lon, maxLat);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon, double maxLat) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        double lat = -maxLat;
        while (lat < maxLat) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                if (ptlist.size() < 2) {
                    return null;
                }
                return new Bezier(false, ptlist);
            }
            ptlist.add(new Point2D.Double(dot.x, dot.y));
            double nextlat = 0.0;
            double absLat = Math.abs(lat);
            nextlat = absLat >= maxLat - 1.0 ? lat + 0.1 : (absLat >= 85.0 ? lat + 0.25 : lat + 0.5);
            lat = nextlat;
        }
        dot = this.transformLL2XY(lon, maxLat);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        if (ptlist.size() < 2) {
            return null;
        }
        return new Bezier(false, ptlist);
    }

    static {
        double latXMax = BonneCommon.latitudeOfMaxX(1.5707963267948966, 90.0, 1.5707963267948966);
        LOGGER.trace("latXMax {}", (Object)latXMax);
        double phiRad = Math.toRadians(latXMax);
        double alphaRad = 1.5707963267948966 - phiRad;
        double betaRad = 2.4674011002723395 * Math.cos(phiRad) / alphaRad;
        MAX_X_OVER_RS = alphaRad * Math.sin(betaRad);
        double latYMax = BonneCommon.latitudeOfLobeMaxY(1.5707963267948966, 90.0, 1.5707963267948966);
        LOGGER.trace("latYMax {}", (Object)latYMax);
        phiRad = Math.toRadians(latYMax);
        alphaRad = 1.5707963267948966 - phiRad;
        betaRad = 2.4674011002723395 * Math.cos(phiRad) / alphaRad;
        double yLobe = 0.0 - alphaRad * Math.cos(betaRad);
        double yS = -Math.PI;
        MAX_Y_OVER_RS = 0.5 * Math.abs(yLobe - -Math.PI);
        Y_SHIFT = -0.5 * (yLobe + -Math.PI);
    }
}

