/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAddBookmarkAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;

    public PanAddBookmarkAction(PanSourcesFrame f) {
        super(PanProperties.MENU_PROPS.getString("add-bookmark"));
        this.parent_ = f;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanBookmark b;
        block17: {
            TreeTableNode node = this.parent_.getSelectedNode();
            if (node == null) {
                return;
            }
            b = null;
            if (node instanceof NcDataNode) {
                if (!(node instanceof NcDataset)) {
                    return;
                }
                NcDataset ncd = (NcDataset)node;
                String addrStr = ncd.getAddress();
                LOGGER.trace("addr, {}", (Object)addrStr);
                try {
                    if (PanFileUtils.isLocalFile(addrStr)) {
                        b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)addrStr, null);
                        break block17;
                    }
                    b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)addrStr, null);
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark: {}", (Object)exc.getMessage());
                    SlowMessage.show((Component)this.parent_, "Protocol Error", new StringBuilder("Could not save bookmark: " + exc.getMessage()));
                }
            } else if (node instanceof NcCatalog) {
                NcCatalog cc = (NcCatalog)node;
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cc.getURI(), cc.getName());
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark: {}", (Object)exc.toString());
                }
            } else if (node instanceof NcCatalogDataset) {
                NcCatalogDataset cd = (NcCatalogDataset)node;
                if (!cd.getAllowsChildren()) {
                    return;
                }
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cd.getCatalogURL(), cd.getName());
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else {
                return;
            }
        }
        if (b == null) {
            return;
        }
        PanSourcesFrame.getSharedInstance().addBookmarkNode(b);
        GuiUtils.refreshFrontFrameMenuBar();
    }
}

