/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.ui.NcDimensionListModel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class PanArraySlicer
extends JPanel {
    private final Object lock_ = new Object();
    private static final int MENU_LIMIT = 3200;
    private NcDimension ncdim_;
    private int length_;
    private boolean averaging_;
    private PanArraySlicer companion_;
    private StringComboBox comboBox_;
    private PanIntSpinner spinner_;
    private JLabel vLabel_;
    private PanCheckBox averageCB_;
    private JLabel linkedBullet_;
    private final EventListenerList listenerList_ = new EventListenerList();

    public PanArraySlicer(NcDimension ncdim) {
        this(ncdim, false);
    }

    public PanArraySlicer(NcDimension ncdim, boolean averaging) {
        Objects.requireNonNull(ncdim, "NcDimension cannot be null.");
        this.setOpaque(false);
        this.ncdim_ = ncdim;
        this.averaging_ = averaging;
        this.length_ = ncdim.getLength();
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        this.setLayout(new BoxLayout(this, 0));
        String lname = this.ncdim_.getLongName();
        if (lname.contains(" (")) {
            lname = lname.substring(0, lname.indexOf(" ("));
        }
        JLabel label1 = new JLabel(lname + ":\u2009");
        this.spinner_ = PanIntSpinner.small(1, 1, this.length_, 1);
        JLabel label2 = new JLabel(" of " + this.length_ + " = ");
        JLabel label3 = null;
        this.linkedBullet_ = new JLabel(" \u2022");
        if (this.length_ < 2) {
            this.averaging_ = false;
        }
        if (this.length_ < 3200 && this.ncdim_.hasFormatting()) {
            String unitsStr = this.getUnitsStr();
            this.comboBox_ = StringComboBox.create(new NcDimensionListModel(this.ncdim_));
            label3 = "".equals(unitsStr) || "1".equals(unitsStr) ? null : new JLabel(" " + unitsStr);
            this.averageCB_ = this.averaging_ ? PanCheckBox.small("Avg") : null;
        } else {
            this.vLabel_ = new JLabel(this.stringValueAt(0));
        }
        this.add(label1);
        this.add(this.spinner_);
        this.add(label2);
        if (this.comboBox_ != null) {
            this.add(this.comboBox_);
        }
        if (label3 != null) {
            this.add(label3);
        }
        if (this.vLabel_ != null) {
            this.add(this.vLabel_);
        }
        if (this.averageCB_ != null) {
            this.add(new JLabel(" \u2014 "));
            this.add(this.averageCB_);
        }
        this.add(this.linkedBullet_);
        this.add(Box.createHorizontalGlue());
        GuiUtils.setSizeSmall(this);
        if (label1.getPreferredSize().width > 50) {
            label1.setMinimumSize(new Dimension(50, label1.getPreferredSize().height));
        }
        this.spinner_.setMinimumSize(this.spinner_.getPreferredSize());
        label2.setMinimumSize(label2.getPreferredSize());
        if (this.comboBox_ != null && this.comboBox_.getPreferredSize().width > 50) {
            this.comboBox_.setMinimumSize(new Dimension(50, this.comboBox_.getPreferredSize().height));
        }
        if (label3 != null && this.comboBox_ != null && this.comboBox_.getPreferredSize().width > 20) {
            label3.setMinimumSize(new Dimension(20, label1.getPreferredSize().height));
        }
        this.linkedBullet_.setVisible(false);
    }

    private void attachListeners() {
        this.spinner_.addChangeListener(e -> {
            int ival = this.spinner_.getIntValue();
            if (this.comboBox_ != null) {
                this.comboBox_.setSelectedIndex(ival - 1);
            }
            if (this.vLabel_ != null) {
                this.vLabel_.setText(this.stringValueAt(ival - 1));
            }
            if (this.companion_ != null) {
                this.companion_.setSelectedIndex(ival - 1);
            }
            this.fireAction();
            this.validate();
            this.repaint();
        });
        if (this.comboBox_ != null) {
            this.comboBox_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.comboBox_.getSelectedIndex();
                this.spinner_.setValue(index + 1);
                if (this.companion_ != null) {
                    this.companion_.setSelectedIndex(index);
                }
            });
        }
        if (this.averaging_ && this.averageCB_ != null) {
            this.averageCB_.setSelected(true);
            this.spinner_.setEnabled(false);
            if (this.comboBox_ != null) {
                this.comboBox_.setEnabled(false);
            }
            this.averageCB_.addItemListener(e -> {
                boolean b = e.getStateChange() == 1;
                this.spinner_.setEnabled(!b);
                if (this.comboBox_ != null) {
                    this.comboBox_.setEnabled(!b);
                }
                this.fireAction();
            });
        }
    }

    public String getLongName() {
        return this.ncdim_.getLongName();
    }

    public final String getUnitsStr() {
        String unitsStr = this.ncdim_.getUnitsStr();
        if (unitsStr == null) {
            return "";
        }
        return unitsStr;
    }

    public int getLength() {
        return this.length_;
    }

    public boolean isAveraging() {
        return this.averaging_;
    }

    private String stringValueAt(int index) {
        if (this.ncdim_.hasFormatting()) {
            return this.ncdim_.hasBounds() ? this.ncdim_.formattedBoundsAt(index) : this.ncdim_.formattedValueAt(index);
        }
        return Integer.toString(index + 1);
    }

    public int getSelectedIndex() {
        if (this.averageCB_ != null && this.averageCB_.isSelected()) {
            return -1;
        }
        if (this.comboBox_ != null) {
            this.comboBox_.getSelectedIndex();
        }
        return this.spinner_.getIntValue() - 1;
    }

    public void setSelectedIndex(int index) {
        if (this.averaging_ && index == -1) {
            this.averageCB_.setSelected(true);
        } else {
            if (index < 0 || index >= this.length_) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.averaging_) {
                this.averageCB_.setSelected(false);
            }
            this.spinner_.setValue(index + 1);
        }
    }

    public Object getSelectedItem() {
        if (this.averageCB_ != null && this.averageCB_.isSelected()) {
            return "Average of all indices in dimension";
        }
        if (this.comboBox_ != null) {
            this.comboBox_.getSelectedItem();
        }
        int index = this.spinner_.getIntValue() - 1;
        return this.stringValueAt(index);
    }

    public PanArraySlicer getCompanion() {
        return this.companion_;
    }

    public void setCompanion(PanArraySlicer companion) {
        if (companion == null) {
            this.companion_ = null;
            this.linkedBullet_.setVisible(false);
            this.repaint();
            return;
        }
        if (!this.isSameLength(companion)) {
            throw new RuntimeException("Cannot link to companion slicer with different size.");
        }
        this.companion_ = companion;
        this.linkedBullet_.setVisible(true);
        this.repaint();
    }

    public boolean isSameLength(PanArraySlicer other) {
        return this.getLength() == other.getLength() && this.isAveraging() == other.isAveraging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionListener[] getActionListeners() {
        Object object = this.lock_;
        synchronized (object) {
            return (ActionListener[])this.listenerList_.getListeners(ActionListener.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.add(ActionListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.remove(ActionListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAction() {
        ActionEvent e = new ActionEvent(this, 0, null);
        Object object = this.lock_;
        synchronized (object) {
            ActionListener[] listeners = (ActionListener[])this.listenerList_.getListeners(ActionListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].actionPerformed(e);
            }
        }
    }
}

