/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanBackgroundAction;
import gov.nasa.giss.panoply.action.PanTogglePlotSectionAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLayoutControls
extends PanControlsPanel
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox titlesCB_;
    private PanCheckBox colorbarCB_;
    private PanCheckBox strokeInfoCB_;
    private PanCheckBox axesCB_;
    private PanCheckBox fnotesCB_;
    private PanCheckBox marginsCB_;
    private PanIntSpinner bWeightSpinner_;
    private ColorComboBox backgroundCombo_;
    private boolean refreshing_;

    public PanLayoutControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("layout-controls", pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.attachListeners();
        this.refreshPrivate();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        AbstractAction a = new PanTogglePlotSectionAction(this.pmeta_, "include-titles");
        this.pmeta_.putAction("include-titles", a);
        plotMenu.getItemForName("include-titles").setAction(a);
        if (!this.ptype_.isLonLatMap()) {
            a = new PanTogglePlotSectionAction(this.pmeta_, "include-axes");
            this.pmeta_.putAction("include-axes", a);
            plotMenu.getItemForName("include-axes").setAction(a);
        }
        if (this.ptype_.isLinePlot()) {
            a = new PanTogglePlotSectionAction(this.pmeta_, "include-strokeinfo");
            this.pmeta_.putAction("include-strokeinfo", a);
            plotMenu.getItemForName("include-strokeinfo").setAction(a);
        } else {
            a = new PanTogglePlotSectionAction(this.pmeta_, "include-colorbar");
            this.pmeta_.putAction("include-colorbar", a);
            plotMenu.getItemForName("include-colorbar").setAction(a);
        }
        a = new PanTogglePlotSectionAction(this.pmeta_, "include-footnotes");
        this.pmeta_.putAction("include-footnotes", a);
        plotMenu.getItemForName("include-footnotes").setAction(a);
        a = new PanTogglePlotSectionAction(this.pmeta_, "include-margins");
        this.pmeta_.putAction("include-margins", a);
        plotMenu.getItemForName("include-margins").setAction(a);
        a = new PanBackgroundAction(this.pmeta_);
        this.pmeta_.putAction("background", a);
        plotMenu.getItemForName("background").setAction(a);
    }

    private void createLayout() {
        Action a = this.pmeta_.getAction("include-titles");
        this.titlesCB_ = PanCheckBox.small("include.title", "Include title(s)", a);
        this.titlesCB_.setEnabled(a != null);
        QuickBox titlesBox = QuickBox.createLeftBox(this.titlesCB_);
        Action a2 = this.pmeta_.getAction("include-axes");
        this.axesCB_ = PanCheckBox.small("include.axes", "Include axes labeling", a2);
        this.axesCB_.setEnabled(a2 != null);
        QuickBox axesBox = QuickBox.createLeftBox(this.axesCB_);
        Action a3 = this.pmeta_.getAction("include-colorbar");
        this.colorbarCB_ = PanCheckBox.small("include.colorbar", "Include scale colorbar", a3);
        this.colorbarCB_.setEnabled(a3 != null);
        QuickBox colorbarBox = QuickBox.createLeftBox(this.colorbarCB_);
        Action a4 = this.pmeta_.getAction("include-strokeinfo");
        this.strokeInfoCB_ = PanCheckBox.small("include.strokeinfo", "Include stroke info", a4);
        this.strokeInfoCB_.setEnabled(a4 != null);
        QuickBox strokeBox = QuickBox.createLeftBox(this.strokeInfoCB_);
        Action a5 = this.pmeta_.getAction("include-footnotes");
        this.fnotesCB_ = PanCheckBox.small("include.footnotes", "Include footnotes", a5);
        this.fnotesCB_.setEnabled(a5 != null);
        QuickBox fnotesBox = QuickBox.createLeftBox(this.fnotesCB_);
        Action a6 = this.pmeta_.getAction("include-margins");
        this.marginsCB_ = PanCheckBox.small("include.margins", "Include standard margins", a6);
        this.marginsCB_.setEnabled(a6 != null);
        QuickBox marginsBox = QuickBox.createLeftBox(this.marginsCB_);
        JLabel label51 = new JLabel("Border: ");
        JLabel label52 = new JLabel("Weight:\u2009");
        JLabel label53 = new JLabel("%");
        this.bWeightSpinner_ = PanIntSpinner.smallWeight("border.weight", this.pmeta_.getInt("border.weight"), 25, 300);
        QuickBox line5 = QuickBox.createLeftBox(label51, label52, this.bWeightSpinner_, label53);
        JLabel backgroundLabel = new JLabel("Background:\u2009");
        this.backgroundCombo_ = new ColorComboBox(PaletteType.BLACK_WHITE);
        this.backgroundCombo_.setName("color.background");
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("color.background"));
        Action a7 = this.pmeta_.getAction("background");
        this.backgroundCombo_.setAction(a7);
        QuickBox backgroundBox = QuickBox.createLeftBox(backgroundLabel, this.backgroundCombo_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(titlesBox);
        this.add(Box.createVerticalStrut(1));
        this.add(axesBox);
        this.add(Box.createVerticalStrut(1));
        this.add(colorbarBox);
        this.add(Box.createVerticalStrut(1));
        this.add(strokeBox);
        this.add(Box.createVerticalStrut(1));
        this.add(fnotesBox);
        this.add(Box.createVerticalStrut(1));
        this.add(marginsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(line5);
        this.add(Box.createVerticalStrut(1));
        this.add(backgroundBox);
        GuiUtils.setSizeSmall(this);
    }

    private void attachListeners() {
        this.bWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("border.weight", this.bWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.refreshing_ = true;
        PanPlotFrame pframe = this.pmeta_.getFrame();
        PanMenuBar mbar = pframe.getPanMenuBar();
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        this.titlesCB_.setSelected(this.pmeta_.getBoolean("include.title"));
        JMenuItem jmi = plotMenu.getItemForName("include-titles");
        jmi.setSelected(this.pmeta_.getBoolean("include.title"));
        jmi.setEnabled(true);
        if (this.axesCB_.isEnabled()) {
            this.axesCB_.setSelected(this.axesCB_.isEnabled() && this.pmeta_.getBoolean("include.axes"));
            jmi = plotMenu.getItemForName("include-axes");
            jmi.setSelected(this.pmeta_.getBoolean("include.axes"));
            jmi.setEnabled(true);
        }
        if (this.colorbarCB_.isEnabled()) {
            this.colorbarCB_.setSelected(this.pmeta_.getBoolean("include.colorbar"));
            jmi = plotMenu.getItemForName("include-colorbar");
            jmi.setSelected(this.pmeta_.getBoolean("include.colorbar"));
            jmi.setEnabled(true);
        }
        if (this.strokeInfoCB_.isEnabled()) {
            this.strokeInfoCB_.setSelected(this.pmeta_.getBoolean("include.strokeinfo"));
            jmi = plotMenu.getItemForName("include-strokeinfo");
            jmi.setSelected(this.pmeta_.getBoolean("include.strokeinfo"));
            jmi.setEnabled(true);
        }
        this.fnotesCB_.setSelected(this.pmeta_.getBoolean("include.footnotes"));
        jmi = plotMenu.getItemForName("include-footnotes");
        jmi.setSelected(this.pmeta_.getBoolean("include.footnotes"));
        jmi.setEnabled(true);
        this.marginsCB_.setSelected(this.pmeta_.getBoolean("include.margins"));
        jmi = plotMenu.getItemForName("include-margins");
        jmi.setSelected(this.pmeta_.getBoolean("include.margins"));
        jmi.setEnabled(true);
        jmi = plotMenu.getItemForName("background");
        jmi.setEnabled(true);
        this.pmeta_.getAction("background").actionPerformed(null);
        Color cnew = this.pmeta_.getColor("color.background");
        this.backgroundCombo_.setSelectedColor(cnew);
        this.refreshing_ = false;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean newval;
        boolean oldval;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean changeAll = false;
        if (pname.contains("include.axes")) {
            oldval = this.axesCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.axes");
            if (newval ^ oldval) {
                this.axesCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.footnotes")) {
            oldval = this.fnotesCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.footnotes");
            if (newval ^ oldval) {
                this.fnotesCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.margins")) {
            oldval = this.marginsCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.margins");
            if (newval ^ oldval) {
                this.marginsCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.colorbar")) {
            oldval = this.colorbarCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.colorbar");
            if (newval ^ oldval) {
                this.colorbarCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.strokeinfo")) {
            oldval = this.strokeInfoCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.strokeinfo");
            if (newval ^ oldval) {
                this.strokeInfoCB_.setSelected(newval);
            }
        }
        if (pname.contains("include.title")) {
            oldval = this.titlesCB_.isSelected();
            newval = this.pmeta_.getBoolean("include.title");
            if (newval ^ oldval) {
                this.titlesCB_.setSelected(newval);
            }
        }
        if (pname.contains("color.background")) {
            Color oldval2 = this.backgroundCombo_.getSelectedColor();
            Color newval2 = this.pmeta_.getColor("color.background");
            if (!newval2.equals(oldval2)) {
                this.backgroundCombo_.setSelectedColor(newval2);
            }
        }
    }
}

